#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesseterrorifnotconverged_ SNESSETERRORIFNOTCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesseterrorifnotconverged_ snesseterrorifnotconverged
#endif
PETSC_EXTERN void snesseterrorifnotconverged_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetErrorIfNotConverged(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgeterrorifnotconverged_ SNESGETERRORIFNOTCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgeterrorifnotconverged_ snesgeterrorifnotconverged
#endif
PETSC_EXTERN void snesgeterrorifnotconverged_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESGetErrorIfNotConverged(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetalwayscomputesfinalresidual_ SNESSETALWAYSCOMPUTESFINALRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetalwayscomputesfinalresidual_ snessetalwayscomputesfinalresidual
#endif
PETSC_EXTERN void snessetalwayscomputesfinalresidual_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetAlwaysComputesFinalResidual(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetalwayscomputesfinalresidual_ SNESGETALWAYSCOMPUTESFINALRESIDUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetalwayscomputesfinalresidual_ snesgetalwayscomputesfinalresidual
#endif
PETSC_EXTERN void snesgetalwayscomputesfinalresidual_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESGetAlwaysComputesFinalResidual(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetfunctiondomainerror_ SNESSETFUNCTIONDOMAINERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetfunctiondomainerror_ snessetfunctiondomainerror
#endif
PETSC_EXTERN void snessetfunctiondomainerror_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESSetFunctionDomainError(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetjacobiandomainerror_ SNESSETJACOBIANDOMAINERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetjacobiandomainerror_ snessetjacobiandomainerror
#endif
PETSC_EXTERN void snessetjacobiandomainerror_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESSetJacobianDomainError(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetcheckjacobiandomainerror_ SNESSETCHECKJACOBIANDOMAINERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetcheckjacobiandomainerror_ snessetcheckjacobiandomainerror
#endif
PETSC_EXTERN void snessetcheckjacobiandomainerror_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetCheckJacobianDomainError(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetcheckjacobiandomainerror_ SNESGETCHECKJACOBIANDOMAINERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetcheckjacobiandomainerror_ snesgetcheckjacobiandomainerror
#endif
PETSC_EXTERN void snesgetcheckjacobiandomainerror_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESGetCheckJacobianDomainError(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetfunctiondomainerror_ SNESGETFUNCTIONDOMAINERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetfunctiondomainerror_ snesgetfunctiondomainerror
#endif
PETSC_EXTERN void snesgetfunctiondomainerror_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESGetFunctionDomainError(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetjacobiandomainerror_ SNESGETJACOBIANDOMAINERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetjacobiandomainerror_ snesgetjacobiandomainerror
#endif
PETSC_EXTERN void snesgetjacobiandomainerror_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESGetJacobianDomainError(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesload_ SNESLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesload_ snesload
#endif
PETSC_EXTERN void snesload_(SNES *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = SNESLoad(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesviewfromoptions_ SNESVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesviewfromoptions_ snesviewfromoptions
#endif
PETSC_EXTERN void snesviewfromoptions_(SNES *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = SNESViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesview_ SNESVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesview_ snesview
#endif
PETSC_EXTERN void snesview_(SNES *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = SNESView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetupmatrices_ SNESSETUPMATRICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetupmatrices_ snessetupmatrices
#endif
PETSC_EXTERN void snessetupmatrices_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESSetUpMatrices(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetfromoptions_ SNESSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetfromoptions_ snessetfromoptions
#endif
PETSC_EXTERN void snessetfromoptions_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesresetfromoptions_ SNESRESETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesresetfromoptions_ snesresetfromoptions
#endif
PETSC_EXTERN void snesresetfromoptions_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESResetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetapplicationcontext_ SNESSETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetapplicationcontext_ snessetapplicationcontext
#endif
PETSC_EXTERN void snessetapplicationcontext_(SNES *a, void *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetapplicationcontext_ SNESGETAPPLICATIONCONTEXT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetapplicationcontext_ snesgetapplicationcontext
#endif
PETSC_EXTERN void snesgetapplicationcontext_(SNES *a, PeCtx b, PetscErrorCode *ierr)
{
  *ierr = SNESGetApplicationContext(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetusematrixfree_ SNESSETUSEMATRIXFREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetusematrixfree_ snessetusematrixfree
#endif
PETSC_EXTERN void snessetusematrixfree_(SNES *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = SNESSetUseMatrixFree(*a, *b ? PETSC_TRUE : PETSC_FALSE, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetusematrixfree_ SNESGETUSEMATRIXFREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetusematrixfree_ snesgetusematrixfree
#endif
PETSC_EXTERN void snesgetusematrixfree_(SNES *a, PetscBool *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  CHKFORTRANNULLBOOL(c);
  *ierr = SNESGetUseMatrixFree(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetiterationnumber_ SNESGETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetiterationnumber_ snesgetiterationnumber
#endif
PETSC_EXTERN void snesgetiterationnumber_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetIterationNumber(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetiterationnumber_ SNESSETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetiterationnumber_ snessetiterationnumber
#endif
PETSC_EXTERN void snessetiterationnumber_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetIterationNumber(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetnonlinearstepfailures_ SNESGETNONLINEARSTEPFAILURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetnonlinearstepfailures_ snesgetnonlinearstepfailures
#endif
PETSC_EXTERN void snesgetnonlinearstepfailures_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetNonlinearStepFailures(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetmaxnonlinearstepfailures_ SNESSETMAXNONLINEARSTEPFAILURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetmaxnonlinearstepfailures_ snessetmaxnonlinearstepfailures
#endif
PETSC_EXTERN void snessetmaxnonlinearstepfailures_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetMaxNonlinearStepFailures(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetmaxnonlinearstepfailures_ SNESGETMAXNONLINEARSTEPFAILURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetmaxnonlinearstepfailures_ snesgetmaxnonlinearstepfailures
#endif
PETSC_EXTERN void snesgetmaxnonlinearstepfailures_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetMaxNonlinearStepFailures(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetnumberfunctionevals_ SNESGETNUMBERFUNCTIONEVALS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetnumberfunctionevals_ snesgetnumberfunctionevals
#endif
PETSC_EXTERN void snesgetnumberfunctionevals_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetNumberFunctionEvals(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetlinearsolvefailures_ SNESGETLINEARSOLVEFAILURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetlinearsolvefailures_ snesgetlinearsolvefailures
#endif
PETSC_EXTERN void snesgetlinearsolvefailures_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetLinearSolveFailures(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetmaxlinearsolvefailures_ SNESSETMAXLINEARSOLVEFAILURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetmaxlinearsolvefailures_ snessetmaxlinearsolvefailures
#endif
PETSC_EXTERN void snessetmaxlinearsolvefailures_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetMaxLinearSolveFailures(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetmaxlinearsolvefailures_ SNESGETMAXLINEARSOLVEFAILURES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetmaxlinearsolvefailures_ snesgetmaxlinearsolvefailures
#endif
PETSC_EXTERN void snesgetmaxlinearsolvefailures_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetMaxLinearSolveFailures(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetlinearsolveiterations_ SNESGETLINEARSOLVEITERATIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetlinearsolveiterations_ snesgetlinearsolveiterations
#endif
PETSC_EXTERN void snesgetlinearsolveiterations_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetLinearSolveIterations(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetcountersreset_ SNESSETCOUNTERSRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetcountersreset_ snessetcountersreset
#endif
PETSC_EXTERN void snessetcountersreset_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetCountersReset(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesresetcounters_ SNESRESETCOUNTERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesresetcounters_ snesresetcounters
#endif
PETSC_EXTERN void snesresetcounters_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESResetCounters(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetksp_ SNESSETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetksp_ snessetksp
#endif
PETSC_EXTERN void snessetksp_(SNES *a, KSP *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetKSP(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesparametersinitialize_ SNESPARAMETERSINITIALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesparametersinitialize_ snesparametersinitialize
#endif
PETSC_EXTERN void snesparametersinitialize_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESParametersInitialize(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescreate_ SNESCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescreate_ snescreate
#endif
PETSC_EXTERN void snescreate_(MPI_Fint *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetinitialfunction_ SNESSETINITIALFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetinitialfunction_ snessetinitialfunction
#endif
PETSC_EXTERN void snessetinitialfunction_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetInitialFunction(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetnormschedule_ SNESSETNORMSCHEDULE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetnormschedule_ snessetnormschedule
#endif
PETSC_EXTERN void snessetnormschedule_(SNES *a, SNESNormSchedule *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetNormSchedule(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetnormschedule_ SNESGETNORMSCHEDULE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetnormschedule_ snesgetnormschedule
#endif
PETSC_EXTERN void snesgetnormschedule_(SNES *a, SNESNormSchedule *b, PetscErrorCode *ierr)
{
  *ierr = SNESGetNormSchedule(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetfunctionnorm_ SNESSETFUNCTIONNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetfunctionnorm_ snessetfunctionnorm
#endif
PETSC_EXTERN void snessetfunctionnorm_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetFunctionNorm(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetfunctionnorm_ SNESGETFUNCTIONNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetfunctionnorm_ snesgetfunctionnorm
#endif
PETSC_EXTERN void snesgetfunctionnorm_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = SNESGetFunctionNorm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetupdatenorm_ SNESGETUPDATENORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetupdatenorm_ snesgetupdatenorm
#endif
PETSC_EXTERN void snesgetupdatenorm_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = SNESGetUpdateNorm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetsolutionnorm_ SNESGETSOLUTIONNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetsolutionnorm_ snesgetsolutionnorm
#endif
PETSC_EXTERN void snesgetsolutionnorm_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = SNESGetSolutionNorm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetfunctiontype_ SNESSETFUNCTIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetfunctiontype_ snessetfunctiontype
#endif
PETSC_EXTERN void snessetfunctiontype_(SNES *a, SNESFunctionType *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetFunctionType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetfunctiontype_ SNESGETFUNCTIONTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetfunctiontype_ snesgetfunctiontype
#endif
PETSC_EXTERN void snesgetfunctiontype_(SNES *a, SNESFunctionType *b, PetscErrorCode *ierr)
{
  *ierr = SNESGetFunctionType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetrhs_ SNESGETRHS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetrhs_ snesgetrhs
#endif
PETSC_EXTERN void snesgetrhs_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESGetRhs(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescomputefunction_ SNESCOMPUTEFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescomputefunction_ snescomputefunction
#endif
PETSC_EXTERN void snescomputefunction_(SNES *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = SNESComputeFunction(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescomputemffunction_ SNESCOMPUTEMFFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescomputemffunction_ snescomputemffunction
#endif
PETSC_EXTERN void snescomputemffunction_(SNES *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = SNESComputeMFFunction(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescomputengs_ SNESCOMPUTENGS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescomputengs_ snescomputengs
#endif
PETSC_EXTERN void snescomputengs_(SNES *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = SNESComputeNGS(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snestestfunction_ SNESTESTFUNCTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snestestfunction_ snestestfunction
#endif
PETSC_EXTERN void snestestfunction_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESTestFunction(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snestestjacobian_ SNESTESTJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snestestjacobian_ snestestjacobian
#endif
PETSC_EXTERN void snestestjacobian_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESTestJacobian(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snescomputejacobian_ SNESCOMPUTEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snescomputejacobian_ snescomputejacobian
#endif
PETSC_EXTERN void snescomputejacobian_(SNES *a, Vec *b, Mat *c, Mat *d, PetscErrorCode *ierr)
{
  *ierr = SNESComputeJacobian(*a, *b, *c, *d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetup_ SNESSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetup_ snessetup
#endif
PETSC_EXTERN void snessetup_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesreset_ SNESRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesreset_ snesreset
#endif
PETSC_EXTERN void snesreset_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesconvergedreasonviewcancel_ SNESCONVERGEDREASONVIEWCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesconvergedreasonviewcancel_ snesconvergedreasonviewcancel
#endif
PETSC_EXTERN void snesconvergedreasonviewcancel_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESConvergedReasonViewCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesdestroy_ SNESDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesdestroy_ snesdestroy
#endif
PETSC_EXTERN void snesdestroy_(SNES *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = SNESDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetlagpreconditioner_ SNESSETLAGPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetlagpreconditioner_ snessetlagpreconditioner
#endif
PETSC_EXTERN void snessetlagpreconditioner_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetLagPreconditioner(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetgridsequence_ SNESSETGRIDSEQUENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetgridsequence_ snessetgridsequence
#endif
PETSC_EXTERN void snessetgridsequence_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetGridSequence(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetgridsequence_ SNESGETGRIDSEQUENCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetgridsequence_ snesgetgridsequence
#endif
PETSC_EXTERN void snesgetgridsequence_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetGridSequence(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetlagpreconditioner_ SNESGETLAGPRECONDITIONER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetlagpreconditioner_ snesgetlagpreconditioner
#endif
PETSC_EXTERN void snesgetlagpreconditioner_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetLagPreconditioner(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetlagjacobian_ SNESSETLAGJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetlagjacobian_ snessetlagjacobian
#endif
PETSC_EXTERN void snessetlagjacobian_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetLagJacobian(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetlagjacobian_ SNESGETLAGJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetlagjacobian_ snesgetlagjacobian
#endif
PETSC_EXTERN void snesgetlagjacobian_(SNES *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = SNESGetLagJacobian(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetlagjacobianpersists_ SNESSETLAGJACOBIANPERSISTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetlagjacobianpersists_ snessetlagjacobianpersists
#endif
PETSC_EXTERN void snessetlagjacobianpersists_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetLagJacobianPersists(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetlagpreconditionerpersists_ SNESSETLAGPRECONDITIONERPERSISTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetlagpreconditionerpersists_ snessetlagpreconditionerpersists
#endif
PETSC_EXTERN void snessetlagpreconditionerpersists_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetLagPreconditionerPersists(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetforceiteration_ SNESSETFORCEITERATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetforceiteration_ snessetforceiteration
#endif
PETSC_EXTERN void snessetforceiteration_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetForceIteration(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetforceiteration_ SNESGETFORCEITERATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetforceiteration_ snesgetforceiteration
#endif
PETSC_EXTERN void snesgetforceiteration_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESGetForceIteration(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessettolerances_ SNESSETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessettolerances_ snessettolerances
#endif
PETSC_EXTERN void snessettolerances_(SNES *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscInt *e, PetscInt *f, PetscErrorCode *ierr)
{
  *ierr = SNESSetTolerances(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetdivergencetolerance_ SNESSETDIVERGENCETOLERANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetdivergencetolerance_ snessetdivergencetolerance
#endif
PETSC_EXTERN void snessetdivergencetolerance_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetDivergenceTolerance(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgettolerances_ SNESGETTOLERANCES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgettolerances_ snesgettolerances
#endif
PETSC_EXTERN void snesgettolerances_(SNES *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscInt *e, PetscInt *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLINTEGER(e);
  CHKFORTRANNULLINTEGER(f);
  *ierr = SNESGetTolerances(*a, b, c, d, e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetdivergencetolerance_ SNESGETDIVERGENCETOLERANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetdivergencetolerance_ snesgetdivergencetolerance
#endif
PETSC_EXTERN void snesgetdivergencetolerance_(SNES *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = SNESGetDivergenceTolerance(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmonitorlgrange_ SNESMONITORLGRANGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmonitorlgrange_ snesmonitorlgrange
#endif
PETSC_EXTERN void snesmonitorlgrange_(SNES *a, PetscInt *b, PetscReal *c, void *d, PetscErrorCode *ierr)
{
  *ierr = SNESMonitorLGRange(*a, *b, *c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesconverged_ SNESCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesconverged_ snesconverged
#endif
PETSC_EXTERN void snesconverged_(SNES *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscErrorCode *ierr)
{
  *ierr = SNESConverged(*a, *b, *c, *d, *e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmonitor_ SNESMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmonitor_ snesmonitor
#endif
PETSC_EXTERN void snesmonitor_(SNES *a, PetscInt *b, PetscReal *c, PetscErrorCode *ierr)
{
  *ierr = SNESMonitor(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesmonitorcancel_ SNESMONITORCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesmonitorcancel_ snesmonitorcancel
#endif
PETSC_EXTERN void snesmonitorcancel_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESMonitorCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetconvergedreason_ SNESGETCONVERGEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetconvergedreason_ snesgetconvergedreason
#endif
PETSC_EXTERN void snesgetconvergedreason_(SNES *a, SNESConvergedReason *b, PetscErrorCode *ierr)
{
  *ierr = SNESGetConvergedReason(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetconvergedreason_ SNESSETCONVERGEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetconvergedreason_ snessetconvergedreason
#endif
PETSC_EXTERN void snessetconvergedreason_(SNES *a, SNESConvergedReason *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetConvergedReason(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetconvergencehistory_ SNESSETCONVERGENCEHISTORY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetconvergencehistory_ snessetconvergencehistory
#endif
PETSC_EXTERN void snessetconvergencehistory_(SNES *a, PetscReal b[], PetscInt c[], PetscInt *d, PetscBool *e, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = SNESSetConvergenceHistory(*a, b, c, *d, *e ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesconvergedreasonview_ SNESCONVERGEDREASONVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesconvergedreasonview_ snesconvergedreasonview
#endif
PETSC_EXTERN void snesconvergedreasonview_(SNES *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = SNESConvergedReasonView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesconvergedreasonviewfromoptions_ SNESCONVERGEDREASONVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesconvergedreasonviewfromoptions_ snesconvergedreasonviewfromoptions
#endif
PETSC_EXTERN void snesconvergedreasonviewfromoptions_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESConvergedReasonViewFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessolve_ SNESSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessolve_ snessolve
#endif
PETSC_EXTERN void snessolve_(SNES *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = SNESSolve(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessettype_ SNESSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessettype_ snessettype
#endif
PETSC_EXTERN void snessettype_(SNES *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = SNESSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgettype_ SNESGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgettype_ snesgettype
#endif
PETSC_EXTERN void snesgettype_(SNES *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = SNESGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetsolution_ SNESSETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetsolution_ snessetsolution
#endif
PETSC_EXTERN void snessetsolution_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetSolution(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetsolution_ SNESGETSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetsolution_ snesgetsolution
#endif
PETSC_EXTERN void snesgetsolution_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESGetSolution(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetsolutionupdate_ SNESGETSOLUTIONUPDATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetsolutionupdate_ snesgetsolutionupdate
#endif
PETSC_EXTERN void snesgetsolutionupdate_(SNES *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESGetSolutionUpdate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetoptionsprefix_ SNESSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetoptionsprefix_ snessetoptionsprefix
#endif
PETSC_EXTERN void snessetoptionsprefix_(SNES *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = SNESSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesappendoptionsprefix_ SNESAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesappendoptionsprefix_ snesappendoptionsprefix
#endif
PETSC_EXTERN void snesappendoptionsprefix_(SNES *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = SNESAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetoptionsprefix_ SNESGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetoptionsprefix_ snesgetoptionsprefix
#endif
PETSC_EXTERN void snesgetoptionsprefix_(SNES *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = SNESGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snestestlocalmin_ SNESTESTLOCALMIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snestestlocalmin_ snestestlocalmin
#endif
PETSC_EXTERN void snestestlocalmin_(SNES *a, PetscErrorCode *ierr)
{
  *ierr = SNESTestLocalMin(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define sneskspsetuseew_ SNESKSPSETUSEEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define sneskspsetuseew_ sneskspsetuseew
#endif
PETSC_EXTERN void sneskspsetuseew_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = SNESKSPSetUseEW(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define sneskspgetuseew_ SNESKSPGETUSEEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define sneskspgetuseew_ sneskspgetuseew
#endif
PETSC_EXTERN void sneskspgetuseew_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESKSPGetUseEW(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define sneskspsetparametersew_ SNESKSPSETPARAMETERSEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define sneskspsetparametersew_ sneskspsetparametersew
#endif
PETSC_EXTERN void sneskspsetparametersew_(SNES *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscReal *h, PetscErrorCode *ierr)
{
  *ierr = SNESKSPSetParametersEW(*a, *b, *c, *d, *e, *f, *g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define sneskspgetparametersew_ SNESKSPGETPARAMETERSEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define sneskspgetparametersew_ sneskspgetparametersew
#endif
PETSC_EXTERN void sneskspgetparametersew_(SNES *a, PetscInt *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscReal *g, PetscReal *h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(h);
  *ierr = SNESKSPGetParametersEW(*a, b, c, d, e, f, g, h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetksp_ SNESGETKSP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetksp_ snesgetksp
#endif
PETSC_EXTERN void snesgetksp_(SNES *a, KSP *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESGetKSP(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetdm_ SNESSETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetdm_ snessetdm
#endif
PETSC_EXTERN void snessetdm_(SNES *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetdm_ SNESGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetdm_ snesgetdm
#endif
PETSC_EXTERN void snesgetdm_(SNES *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetnpc_ SNESSETNPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetnpc_ snessetnpc
#endif
PETSC_EXTERN void snessetnpc_(SNES *a, SNES *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetNPC(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetnpc_ SNESGETNPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetnpc_ snesgetnpc
#endif
PETSC_EXTERN void snesgetnpc_(SNES *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESGetNPC(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define sneshasnpc_ SNESHASNPC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define sneshasnpc_ sneshasnpc
#endif
PETSC_EXTERN void sneshasnpc_(SNES *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = SNESHasNPC(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetnpcside_ SNESSETNPCSIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetnpcside_ snessetnpcside
#endif
PETSC_EXTERN void snessetnpcside_(SNES *a, PCSide *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetNPCSide(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetnpcside_ SNESGETNPCSIDE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetnpcside_ snesgetnpcside
#endif
PETSC_EXTERN void snesgetnpcside_(SNES *a, PCSide *b, PetscErrorCode *ierr)
{
  *ierr = SNESGetNPCSide(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snessetlinesearch_ SNESSETLINESEARCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snessetlinesearch_ snessetlinesearch
#endif
PETSC_EXTERN void snessetlinesearch_(SNES *a, SNESLineSearch *b, PetscErrorCode *ierr)
{
  *ierr = SNESSetLineSearch(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesgetlinesearch_ SNESGETLINESEARCH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesgetlinesearch_ snesgetlinesearch
#endif
PETSC_EXTERN void snesgetlinesearch_(SNES *a, SNESLineSearch *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESGetLineSearch(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
