#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsirktableaucreate_ TSIRKTABLEAUCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsirktableaucreate_ tsirktableaucreate
#endif
PETSC_EXTERN void tsirktableaucreate_(TS *a, PetscInt *b, const PetscReal *c, const PetscReal *d, const PetscReal *e, const PetscReal *f, const PetscScalar *g, const PetscScalar *h, const PetscScalar *i, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLSCALAR(g);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLSCALAR(i);
  *ierr = TSIRKTableauCreate(*a, *b, c, d, e, f, g, h, i);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsirkregisterdestroy_ TSIRKREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsirkregisterdestroy_ tsirkregisterdestroy
#endif
PETSC_EXTERN void tsirkregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = TSIRKRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsirkinitializepackage_ TSIRKINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsirkinitializepackage_ tsirkinitializepackage
#endif
PETSC_EXTERN void tsirkinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSIRKInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsirkfinalizepackage_ TSIRKFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsirkfinalizepackage_ tsirkfinalizepackage
#endif
PETSC_EXTERN void tsirkfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSIRKFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsirksettype_ TSIRKSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsirksettype_ tsirksettype
#endif
PETSC_EXTERN void tsirksettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSIRKSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsirkgettype_ TSIRKGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsirkgettype_ tsirkgettype
#endif
PETSC_EXTERN void tsirkgettype_(TS *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSIRKGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsirksetnumstages_ TSIRKSETNUMSTAGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsirksetnumstages_ tsirksetnumstages
#endif
PETSC_EXTERN void tsirksetnumstages_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = TSIRKSetNumStages(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsirkgetnumstages_ TSIRKGETNUMSTAGES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsirkgetnumstages_ tsirkgetnumstages
#endif
PETSC_EXTERN void tsirkgetnumstages_(TS *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = TSIRKGetNumStages(*a, b);
  if (*ierr) return;
}
