#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecghostgetlocalform_ VECGHOSTGETLOCALFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecghostgetlocalform_ vecghostgetlocalform
#endif
PETSC_EXTERN void vecghostgetlocalform_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecGhostGetLocalForm(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecghostislocalform_ VECGHOSTISLOCALFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecghostislocalform_ vecghostislocalform
#endif
PETSC_EXTERN void vecghostislocalform_(Vec *a, Vec *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = VecGhostIsLocalForm(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecghostrestorelocalform_ VECGHOSTRESTORELOCALFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecghostrestorelocalform_ vecghostrestorelocalform
#endif
PETSC_EXTERN void vecghostrestorelocalform_(Vec *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = VecGhostRestoreLocalForm(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecghostupdatebegin_ VECGHOSTUPDATEBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecghostupdatebegin_ vecghostupdatebegin
#endif
PETSC_EXTERN void vecghostupdatebegin_(Vec *a, InsertMode *b, ScatterMode *c, PetscErrorCode *ierr)
{
  *ierr = VecGhostUpdateBegin(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define vecghostupdateend_ VECGHOSTUPDATEEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define vecghostupdateend_ vecghostupdateend
#endif
PETSC_EXTERN void vecghostupdateend_(Vec *a, InsertMode *b, ScatterMode *c, PetscErrorCode *ierr)
{
  *ierr = VecGhostUpdateEnd(*a, *b, *c);
  if (*ierr) return;
}
