#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatedensefromvectype_ MATCREATEDENSEFROMVECTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatedensefromvectype_ matcreatedensefromvectype
#endif
PETSC_EXTERN void matcreatedensefromvectype_(MPI_Fint *a, char * b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, PetscScalar *h, Mat *i, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLSCALAR(h);
  CHKFORTRANNULLOBJECT(i);
  *ierr = MatCreateDenseFromVecType(MPI_Comm_f2c(*(a)), c_b, *c, *d, *e, *f, *g, h, i);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
