#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewervtkgetdm_ PETSCVIEWERVTKGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewervtkgetdm_ petscviewervtkgetdm
#endif
PETSC_EXTERN void petscviewervtkgetdm_(PetscViewer *a, PetscObject *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscViewerVTKGetDM(v_a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscviewer.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewervtkopen_ PETSCVIEWERVTKOPEN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewervtkopen_ petscviewervtkopen
#endif
PETSC_EXTERN void petscviewervtkopen_(MPI_Fint *a, char b[], PetscFileMode *c, PetscViewer *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = PetscViewerVTKOpen(MPI_Comm_f2c(*(a)), c_b, *c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
