#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabcreateboxmesh_ DMMOABCREATEBOXMESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabcreateboxmesh_ dmmoabcreateboxmesh
#endif
PETSC_EXTERN void dmmoabcreateboxmesh_(MPI_Fint *a, PetscInt *b, PetscBool *c, const PetscReal *d, PetscInt *e, PetscInt *f, DM *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMMoabCreateBoxMesh(MPI_Comm_f2c(*(a)), *b, *c ? PETSC_TRUE : PETSC_FALSE, d, *e, *f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabloadfromfile_ DMMOABLOADFROMFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabloadfromfile_ dmmoabloadfromfile
#endif
PETSC_EXTERN void dmmoabloadfromfile_(MPI_Fint *a, PetscInt *b, PetscInt *c, char d[], char e[], DM *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMMoabLoadFromFile(MPI_Comm_f2c(*(a)), *b, *c, c_d, c_e, f);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmmoab.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmmoabrenumbermeshentities_ DMMOABRENUMBERMESHENTITIES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmmoabrenumbermeshentities_ dmmoabrenumbermeshentities
#endif
PETSC_EXTERN void dmmoabrenumbermeshentities_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMMoabRenumberMeshEntities(*a);
  if (*ierr) return;
}
