﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/directory-service-data/DirectoryServiceData_EXPORTS.h>
#include <aws/directory-service-data/DirectoryServiceDataRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>
#include <aws/core/utils/UUID.h>

namespace Aws
{
namespace Http
{
    class URI;
} //namespace Http
namespace DirectoryServiceData
{
namespace Model
{

  /**
   */
  class AddGroupMemberRequest : public DirectoryServiceDataRequest
  {
  public:
    AWS_DIRECTORYSERVICEDATA_API AddGroupMemberRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "AddGroupMember"; }

    AWS_DIRECTORYSERVICEDATA_API Aws::String SerializePayload() const override;

    AWS_DIRECTORYSERVICEDATA_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;


    ///@{
    /**
     * <p> A unique and case-sensitive identifier that you provide to make sure the
     * idempotency of the request, so multiple identical calls have the same effect as
     * one single call. </p> <p> A client token is valid for 8 hours after the first
     * request that uses it completes. After 8 hours, any request with the same client
     * token is treated as a new request. If the request succeeds, any future uses of
     * that token will be idempotent for another 8 hours. </p> <p> If you submit a
     * request with the same client token but change one of the other parameters within
     * the 8-hour idempotency window, Directory Service Data returns an
     * <code>ConflictException</code>. </p>  <p> This parameter is optional when
     * using the CLI or SDK. </p> 
     */
    inline const Aws::String& GetClientToken() const{ return m_clientToken; }
    inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
    inline void SetClientToken(const Aws::String& value) { m_clientTokenHasBeenSet = true; m_clientToken = value; }
    inline void SetClientToken(Aws::String&& value) { m_clientTokenHasBeenSet = true; m_clientToken = std::move(value); }
    inline void SetClientToken(const char* value) { m_clientTokenHasBeenSet = true; m_clientToken.assign(value); }
    inline AddGroupMemberRequest& WithClientToken(const Aws::String& value) { SetClientToken(value); return *this;}
    inline AddGroupMemberRequest& WithClientToken(Aws::String&& value) { SetClientToken(std::move(value)); return *this;}
    inline AddGroupMemberRequest& WithClientToken(const char* value) { SetClientToken(value); return *this;}
    ///@}

    ///@{
    /**
     * <p> The identifier (ID) of the directory that's associated with the group. </p>
     */
    inline const Aws::String& GetDirectoryId() const{ return m_directoryId; }
    inline bool DirectoryIdHasBeenSet() const { return m_directoryIdHasBeenSet; }
    inline void SetDirectoryId(const Aws::String& value) { m_directoryIdHasBeenSet = true; m_directoryId = value; }
    inline void SetDirectoryId(Aws::String&& value) { m_directoryIdHasBeenSet = true; m_directoryId = std::move(value); }
    inline void SetDirectoryId(const char* value) { m_directoryIdHasBeenSet = true; m_directoryId.assign(value); }
    inline AddGroupMemberRequest& WithDirectoryId(const Aws::String& value) { SetDirectoryId(value); return *this;}
    inline AddGroupMemberRequest& WithDirectoryId(Aws::String&& value) { SetDirectoryId(std::move(value)); return *this;}
    inline AddGroupMemberRequest& WithDirectoryId(const char* value) { SetDirectoryId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p> The name of the group. </p>
     */
    inline const Aws::String& GetGroupName() const{ return m_groupName; }
    inline bool GroupNameHasBeenSet() const { return m_groupNameHasBeenSet; }
    inline void SetGroupName(const Aws::String& value) { m_groupNameHasBeenSet = true; m_groupName = value; }
    inline void SetGroupName(Aws::String&& value) { m_groupNameHasBeenSet = true; m_groupName = std::move(value); }
    inline void SetGroupName(const char* value) { m_groupNameHasBeenSet = true; m_groupName.assign(value); }
    inline AddGroupMemberRequest& WithGroupName(const Aws::String& value) { SetGroupName(value); return *this;}
    inline AddGroupMemberRequest& WithGroupName(Aws::String&& value) { SetGroupName(std::move(value)); return *this;}
    inline AddGroupMemberRequest& WithGroupName(const char* value) { SetGroupName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p> The <code>SAMAccountName</code> of the user, group, or computer to add as a
     * group member. </p>
     */
    inline const Aws::String& GetMemberName() const{ return m_memberName; }
    inline bool MemberNameHasBeenSet() const { return m_memberNameHasBeenSet; }
    inline void SetMemberName(const Aws::String& value) { m_memberNameHasBeenSet = true; m_memberName = value; }
    inline void SetMemberName(Aws::String&& value) { m_memberNameHasBeenSet = true; m_memberName = std::move(value); }
    inline void SetMemberName(const char* value) { m_memberNameHasBeenSet = true; m_memberName.assign(value); }
    inline AddGroupMemberRequest& WithMemberName(const Aws::String& value) { SetMemberName(value); return *this;}
    inline AddGroupMemberRequest& WithMemberName(Aws::String&& value) { SetMemberName(std::move(value)); return *this;}
    inline AddGroupMemberRequest& WithMemberName(const char* value) { SetMemberName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p> The domain name that's associated with the group member. This parameter is
     * required only when adding a member outside of your Managed Microsoft AD domain
     * to a group inside of your Managed Microsoft AD domain. This parameter defaults
     * to the Managed Microsoft AD domain. </p>  <p> This parameter is case
     * insensitive. </p> 
     */
    inline const Aws::String& GetMemberRealm() const{ return m_memberRealm; }
    inline bool MemberRealmHasBeenSet() const { return m_memberRealmHasBeenSet; }
    inline void SetMemberRealm(const Aws::String& value) { m_memberRealmHasBeenSet = true; m_memberRealm = value; }
    inline void SetMemberRealm(Aws::String&& value) { m_memberRealmHasBeenSet = true; m_memberRealm = std::move(value); }
    inline void SetMemberRealm(const char* value) { m_memberRealmHasBeenSet = true; m_memberRealm.assign(value); }
    inline AddGroupMemberRequest& WithMemberRealm(const Aws::String& value) { SetMemberRealm(value); return *this;}
    inline AddGroupMemberRequest& WithMemberRealm(Aws::String&& value) { SetMemberRealm(std::move(value)); return *this;}
    inline AddGroupMemberRequest& WithMemberRealm(const char* value) { SetMemberRealm(value); return *this;}
    ///@}
  private:

    Aws::String m_clientToken;
    bool m_clientTokenHasBeenSet = false;

    Aws::String m_directoryId;
    bool m_directoryIdHasBeenSet = false;

    Aws::String m_groupName;
    bool m_groupNameHasBeenSet = false;

    Aws::String m_memberName;
    bool m_memberNameHasBeenSet = false;

    Aws::String m_memberRealm;
    bool m_memberRealmHasBeenSet = false;
  };

} // namespace Model
} // namespace DirectoryServiceData
} // namespace Aws
