﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ec2/model/VpnConnectionOptionsSpecification.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws
{
namespace EC2
{
namespace Model
{

VpnConnectionOptionsSpecification::VpnConnectionOptionsSpecification() : 
    m_enableAcceleration(false),
    m_enableAccelerationHasBeenSet(false),
    m_tunnelInsideIpVersion(TunnelInsideIpVersion::NOT_SET),
    m_tunnelInsideIpVersionHasBeenSet(false),
    m_tunnelOptionsHasBeenSet(false),
    m_localIpv4NetworkCidrHasBeenSet(false),
    m_remoteIpv4NetworkCidrHasBeenSet(false),
    m_localIpv6NetworkCidrHasBeenSet(false),
    m_remoteIpv6NetworkCidrHasBeenSet(false),
    m_outsideIpAddressTypeHasBeenSet(false),
    m_transportTransitGatewayAttachmentIdHasBeenSet(false),
    m_staticRoutesOnly(false),
    m_staticRoutesOnlyHasBeenSet(false)
{
}

VpnConnectionOptionsSpecification::VpnConnectionOptionsSpecification(const XmlNode& xmlNode)
  : VpnConnectionOptionsSpecification()
{
  *this = xmlNode;
}

VpnConnectionOptionsSpecification& VpnConnectionOptionsSpecification::operator =(const XmlNode& xmlNode)
{
  XmlNode resultNode = xmlNode;

  if(!resultNode.IsNull())
  {
    XmlNode enableAccelerationNode = resultNode.FirstChild("EnableAcceleration");
    if(!enableAccelerationNode.IsNull())
    {
      m_enableAcceleration = StringUtils::ConvertToBool(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(enableAccelerationNode.GetText()).c_str()).c_str());
      m_enableAccelerationHasBeenSet = true;
    }
    XmlNode tunnelInsideIpVersionNode = resultNode.FirstChild("TunnelInsideIpVersion");
    if(!tunnelInsideIpVersionNode.IsNull())
    {
      m_tunnelInsideIpVersion = TunnelInsideIpVersionMapper::GetTunnelInsideIpVersionForName(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(tunnelInsideIpVersionNode.GetText()).c_str()).c_str());
      m_tunnelInsideIpVersionHasBeenSet = true;
    }
    XmlNode tunnelOptionsNode = resultNode.FirstChild("TunnelOptions");
    if(!tunnelOptionsNode.IsNull())
    {
      XmlNode tunnelOptionsMember = tunnelOptionsNode.FirstChild("member");
      while(!tunnelOptionsMember.IsNull())
      {
        m_tunnelOptions.push_back(tunnelOptionsMember);
        tunnelOptionsMember = tunnelOptionsMember.NextNode("member");
      }

      m_tunnelOptionsHasBeenSet = true;
    }
    XmlNode localIpv4NetworkCidrNode = resultNode.FirstChild("LocalIpv4NetworkCidr");
    if(!localIpv4NetworkCidrNode.IsNull())
    {
      m_localIpv4NetworkCidr = Aws::Utils::Xml::DecodeEscapedXmlText(localIpv4NetworkCidrNode.GetText());
      m_localIpv4NetworkCidrHasBeenSet = true;
    }
    XmlNode remoteIpv4NetworkCidrNode = resultNode.FirstChild("RemoteIpv4NetworkCidr");
    if(!remoteIpv4NetworkCidrNode.IsNull())
    {
      m_remoteIpv4NetworkCidr = Aws::Utils::Xml::DecodeEscapedXmlText(remoteIpv4NetworkCidrNode.GetText());
      m_remoteIpv4NetworkCidrHasBeenSet = true;
    }
    XmlNode localIpv6NetworkCidrNode = resultNode.FirstChild("LocalIpv6NetworkCidr");
    if(!localIpv6NetworkCidrNode.IsNull())
    {
      m_localIpv6NetworkCidr = Aws::Utils::Xml::DecodeEscapedXmlText(localIpv6NetworkCidrNode.GetText());
      m_localIpv6NetworkCidrHasBeenSet = true;
    }
    XmlNode remoteIpv6NetworkCidrNode = resultNode.FirstChild("RemoteIpv6NetworkCidr");
    if(!remoteIpv6NetworkCidrNode.IsNull())
    {
      m_remoteIpv6NetworkCidr = Aws::Utils::Xml::DecodeEscapedXmlText(remoteIpv6NetworkCidrNode.GetText());
      m_remoteIpv6NetworkCidrHasBeenSet = true;
    }
    XmlNode outsideIpAddressTypeNode = resultNode.FirstChild("OutsideIpAddressType");
    if(!outsideIpAddressTypeNode.IsNull())
    {
      m_outsideIpAddressType = Aws::Utils::Xml::DecodeEscapedXmlText(outsideIpAddressTypeNode.GetText());
      m_outsideIpAddressTypeHasBeenSet = true;
    }
    XmlNode transportTransitGatewayAttachmentIdNode = resultNode.FirstChild("TransportTransitGatewayAttachmentId");
    if(!transportTransitGatewayAttachmentIdNode.IsNull())
    {
      m_transportTransitGatewayAttachmentId = Aws::Utils::Xml::DecodeEscapedXmlText(transportTransitGatewayAttachmentIdNode.GetText());
      m_transportTransitGatewayAttachmentIdHasBeenSet = true;
    }
    XmlNode staticRoutesOnlyNode = resultNode.FirstChild("staticRoutesOnly");
    if(!staticRoutesOnlyNode.IsNull())
    {
      m_staticRoutesOnly = StringUtils::ConvertToBool(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(staticRoutesOnlyNode.GetText()).c_str()).c_str());
      m_staticRoutesOnlyHasBeenSet = true;
    }
  }

  return *this;
}

void VpnConnectionOptionsSpecification::OutputToStream(Aws::OStream& oStream, const char* location, unsigned index, const char* locationValue) const
{
  if(m_enableAccelerationHasBeenSet)
  {
      oStream << location << index << locationValue << ".EnableAcceleration=" << std::boolalpha << m_enableAcceleration << "&";
  }

  if(m_tunnelInsideIpVersionHasBeenSet)
  {
      oStream << location << index << locationValue << ".TunnelInsideIpVersion=" << TunnelInsideIpVersionMapper::GetNameForTunnelInsideIpVersion(m_tunnelInsideIpVersion) << "&";
  }

  if(m_tunnelOptionsHasBeenSet)
  {
      unsigned tunnelOptionsIdx = 1;
      for(auto& item : m_tunnelOptions)
      {
        Aws::StringStream tunnelOptionsSs;
        tunnelOptionsSs << location << index << locationValue << ".TunnelOptions." << tunnelOptionsIdx++;
        item.OutputToStream(oStream, tunnelOptionsSs.str().c_str());
      }
  }

  if(m_localIpv4NetworkCidrHasBeenSet)
  {
      oStream << location << index << locationValue << ".LocalIpv4NetworkCidr=" << StringUtils::URLEncode(m_localIpv4NetworkCidr.c_str()) << "&";
  }

  if(m_remoteIpv4NetworkCidrHasBeenSet)
  {
      oStream << location << index << locationValue << ".RemoteIpv4NetworkCidr=" << StringUtils::URLEncode(m_remoteIpv4NetworkCidr.c_str()) << "&";
  }

  if(m_localIpv6NetworkCidrHasBeenSet)
  {
      oStream << location << index << locationValue << ".LocalIpv6NetworkCidr=" << StringUtils::URLEncode(m_localIpv6NetworkCidr.c_str()) << "&";
  }

  if(m_remoteIpv6NetworkCidrHasBeenSet)
  {
      oStream << location << index << locationValue << ".RemoteIpv6NetworkCidr=" << StringUtils::URLEncode(m_remoteIpv6NetworkCidr.c_str()) << "&";
  }

  if(m_outsideIpAddressTypeHasBeenSet)
  {
      oStream << location << index << locationValue << ".OutsideIpAddressType=" << StringUtils::URLEncode(m_outsideIpAddressType.c_str()) << "&";
  }

  if(m_transportTransitGatewayAttachmentIdHasBeenSet)
  {
      oStream << location << index << locationValue << ".TransportTransitGatewayAttachmentId=" << StringUtils::URLEncode(m_transportTransitGatewayAttachmentId.c_str()) << "&";
  }

  if(m_staticRoutesOnlyHasBeenSet)
  {
      oStream << location << index << locationValue << ".StaticRoutesOnly=" << std::boolalpha << m_staticRoutesOnly << "&";
  }

}

void VpnConnectionOptionsSpecification::OutputToStream(Aws::OStream& oStream, const char* location) const
{
  if(m_enableAccelerationHasBeenSet)
  {
      oStream << location << ".EnableAcceleration=" << std::boolalpha << m_enableAcceleration << "&";
  }
  if(m_tunnelInsideIpVersionHasBeenSet)
  {
      oStream << location << ".TunnelInsideIpVersion=" << TunnelInsideIpVersionMapper::GetNameForTunnelInsideIpVersion(m_tunnelInsideIpVersion) << "&";
  }
  if(m_tunnelOptionsHasBeenSet)
  {
      unsigned tunnelOptionsIdx = 1;
      for(auto& item : m_tunnelOptions)
      {
        Aws::StringStream tunnelOptionsSs;
        tunnelOptionsSs << location <<  ".TunnelOptions." << tunnelOptionsIdx++;
        item.OutputToStream(oStream, tunnelOptionsSs.str().c_str());
      }
  }
  if(m_localIpv4NetworkCidrHasBeenSet)
  {
      oStream << location << ".LocalIpv4NetworkCidr=" << StringUtils::URLEncode(m_localIpv4NetworkCidr.c_str()) << "&";
  }
  if(m_remoteIpv4NetworkCidrHasBeenSet)
  {
      oStream << location << ".RemoteIpv4NetworkCidr=" << StringUtils::URLEncode(m_remoteIpv4NetworkCidr.c_str()) << "&";
  }
  if(m_localIpv6NetworkCidrHasBeenSet)
  {
      oStream << location << ".LocalIpv6NetworkCidr=" << StringUtils::URLEncode(m_localIpv6NetworkCidr.c_str()) << "&";
  }
  if(m_remoteIpv6NetworkCidrHasBeenSet)
  {
      oStream << location << ".RemoteIpv6NetworkCidr=" << StringUtils::URLEncode(m_remoteIpv6NetworkCidr.c_str()) << "&";
  }
  if(m_outsideIpAddressTypeHasBeenSet)
  {
      oStream << location << ".OutsideIpAddressType=" << StringUtils::URLEncode(m_outsideIpAddressType.c_str()) << "&";
  }
  if(m_transportTransitGatewayAttachmentIdHasBeenSet)
  {
      oStream << location << ".TransportTransitGatewayAttachmentId=" << StringUtils::URLEncode(m_transportTransitGatewayAttachmentId.c_str()) << "&";
  }
  if(m_staticRoutesOnlyHasBeenSet)
  {
      oStream << location << ".StaticRoutesOnly=" << std::boolalpha << m_staticRoutesOnly << "&";
  }
}

} // namespace Model
} // namespace EC2
} // namespace Aws
