﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ecs/model/DeploymentEphemeralStorage.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ECS
{
namespace Model
{

DeploymentEphemeralStorage::DeploymentEphemeralStorage() : 
    m_kmsKeyIdHasBeenSet(false)
{
}

DeploymentEphemeralStorage::DeploymentEphemeralStorage(JsonView jsonValue)
  : DeploymentEphemeralStorage()
{
  *this = jsonValue;
}

DeploymentEphemeralStorage& DeploymentEphemeralStorage::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("kmsKeyId"))
  {
    m_kmsKeyId = jsonValue.GetString("kmsKeyId");

    m_kmsKeyIdHasBeenSet = true;
  }

  return *this;
}

JsonValue DeploymentEphemeralStorage::Jsonize() const
{
  JsonValue payload;

  if(m_kmsKeyIdHasBeenSet)
  {
   payload.WithString("kmsKeyId", m_kmsKeyId);

  }

  return payload;
}

} // namespace Model
} // namespace ECS
} // namespace Aws
