﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/elasticache/ElastiCache_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticache/model/ResponseMetadata.h>
#include <aws/elasticache/model/UserGroup.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Xml
{
  class XmlDocument;
} // namespace Xml
} // namespace Utils
namespace ElastiCache
{
namespace Model
{
  class DescribeUserGroupsResult
  {
  public:
    AWS_ELASTICACHE_API DescribeUserGroupsResult();
    AWS_ELASTICACHE_API DescribeUserGroupsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
    AWS_ELASTICACHE_API DescribeUserGroupsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);


    ///@{
    /**
     * <p>Returns a list of user groups.</p>
     */
    inline const Aws::Vector<UserGroup>& GetUserGroups() const{ return m_userGroups; }
    inline void SetUserGroups(const Aws::Vector<UserGroup>& value) { m_userGroups = value; }
    inline void SetUserGroups(Aws::Vector<UserGroup>&& value) { m_userGroups = std::move(value); }
    inline DescribeUserGroupsResult& WithUserGroups(const Aws::Vector<UserGroup>& value) { SetUserGroups(value); return *this;}
    inline DescribeUserGroupsResult& WithUserGroups(Aws::Vector<UserGroup>&& value) { SetUserGroups(std::move(value)); return *this;}
    inline DescribeUserGroupsResult& AddUserGroups(const UserGroup& value) { m_userGroups.push_back(value); return *this; }
    inline DescribeUserGroupsResult& AddUserGroups(UserGroup&& value) { m_userGroups.push_back(std::move(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>An optional marker returned from a prior request. Use this marker for
     * pagination of results from this operation. If this parameter is specified, the
     * response includes only records beyond the marker, up to the value specified by
     * MaxRecords.&gt;</p>
     */
    inline const Aws::String& GetMarker() const{ return m_marker; }
    inline void SetMarker(const Aws::String& value) { m_marker = value; }
    inline void SetMarker(Aws::String&& value) { m_marker = std::move(value); }
    inline void SetMarker(const char* value) { m_marker.assign(value); }
    inline DescribeUserGroupsResult& WithMarker(const Aws::String& value) { SetMarker(value); return *this;}
    inline DescribeUserGroupsResult& WithMarker(Aws::String&& value) { SetMarker(std::move(value)); return *this;}
    inline DescribeUserGroupsResult& WithMarker(const char* value) { SetMarker(value); return *this;}
    ///@}

    ///@{
    
    inline const ResponseMetadata& GetResponseMetadata() const{ return m_responseMetadata; }
    inline void SetResponseMetadata(const ResponseMetadata& value) { m_responseMetadata = value; }
    inline void SetResponseMetadata(ResponseMetadata&& value) { m_responseMetadata = std::move(value); }
    inline DescribeUserGroupsResult& WithResponseMetadata(const ResponseMetadata& value) { SetResponseMetadata(value); return *this;}
    inline DescribeUserGroupsResult& WithResponseMetadata(ResponseMetadata&& value) { SetResponseMetadata(std::move(value)); return *this;}
    ///@}
  private:

    Aws::Vector<UserGroup> m_userGroups;

    Aws::String m_marker;

    ResponseMetadata m_responseMetadata;
  };

} // namespace Model
} // namespace ElastiCache
} // namespace Aws
