unit fmuMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, aztecgen;

type
  TfmMain = class(TForm)
    GenerateButton: TButton;
    Label3: TLabel;
    BarcodeMemo: TMemo;
    InputDataMemo: TMemo;
    procedure GenerateButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.DFM}

function MatrixToString(Matrix: PAGMatrix): string;
var
  p: PAGByte;
  x, y: Cardinal;
  t: string;
begin
  Result := '';

  p := Matrix^.data;
  for y := 1 to Matrix^.height do
  begin
    for x := 1 to Matrix^.width do
    begin
      t := ' ';
      if p^ <> 0 then
        t := '#';
      Result := Result + ' ' + t;

      Inc(p);
    end;
    Result := Result + Chr($0D) + Chr($0A);
  end;
end;

function GenerateBarcode(Data: string): string;
var
  Matrix: PAGMatrix;
begin
  Result := '';

  if ag_generate(Matrix, PChar(Data), Length(Data), nil) = AG_SUCCESS then
  begin
    Result := MatrixToString(Matrix);
    ag_release_matrix(Matrix);
  end;
end;

procedure TfmMain.GenerateButtonClick(Sender: TObject);
begin
  BarcodeMemo.Text := GenerateBarcode(InputDataMemo.Text);
end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
  GenerateButtonClick(Sender);
end;

end.
