#include "stdafx.h"
#include <cstddef>
#include <cassert>
#include "BarcodeRendering.h"


void DrawBarcode(CDCHandle dc, const ag_matrix *pBarcode,
	double pointWidth, double pointHeight)
{
	assert(pBarcode != NULL);

	dc.FillRect(
		CRect(
			0,
			0,
			int(pointWidth * pBarcode->width),
			int(pointHeight * pBarcode->height)),
		HBRUSH(GetStockObject(WHITE_BRUSH)));

	for (size_t y = 0; y < pBarcode->height; ++y)
		for (size_t x = 0; x < pBarcode->width; ++x)
		{
			if (pBarcode->data[y * pBarcode->width + x] == 0)
				continue;

			dc.FillRect(
				CRect(
					int(pointWidth * x),
					int(pointHeight * y),
					int(pointWidth * (x + 1)),
					int(pointHeight * (y + 1))),
				HBRUSH(GetStockObject(BLACK_BRUSH)));
		}
}

BOOL CreateBarcodeImage(CImage *pImage, const ag_matrix *pBarcode,
	double pointWidth, double pointHeight)
{
	assert(pImage != NULL);
	assert(pImage->IsNull());
	assert(pBarcode != NULL);
	assert(pointWidth >= 0);
	assert(pointHeight >= 0);

	if (!pImage->Create(int(pointWidth * pBarcode->width),
			int(pointHeight * pBarcode->height), 24))
		return FALSE;

	const CImageDC imageDC(*pImage);
	DrawBarcode(HDC(imageDC), pBarcode, pointWidth, pointHeight);

	return TRUE;
}
