---
title: Chemical JSON
---

## Specification

@Note [Reference](https://github.com/OpenChemistry/avogadrolibs/blob/master/avogadro/io/cjsonformat.cpp)

Chemical JSON files are identified by the extension ``cjson`` or ``json`` and parsed following the format implemented in Avogadro 2.
The entries *name*, *atoms.elements.number*, *atoms.coords.3d*, *atoms.coords.3d fractional*, *unit cell*, *atoms.formalCharges*, *bonds.connections.index*, and *bonds.order* are recognized by the reader.


## Example

Caffeine molecule in ``qcschema_molecule`` format.


```json
{
  "chemicalJson": 1,
  "atoms": {
    "elements": {
      "number": [
        6, 7, 6, 7, 6, 6, 6, 8, 7, 6, 8, 7, 6, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
      ]
    },
    "coords": {
      "3d": [
         1.0731997649702911E+00,  4.8899989290949721E-02, -7.5699983421776973E-02,
         2.5136994495022558E+00,  1.2599997240612813E-02, -7.5799983399877077E-02,
         3.3519992659154081E+00,  1.0958997599990143E+00, -7.5299983509376570E-02,
         4.6189989884436962E+00,  7.3029984006504256E-01, -7.5499983465576764E-02,
         4.5790989971817559E+00, -6.3139986172404194E-01, -7.5299983509376570E-02,
         3.3012992770186567E+00, -1.1025997585317211E+00, -7.5199983531276451E-02,
         2.9806993472297307E+00, -2.4868994553714288E+00, -7.3799983837875047E-02,
         1.8252996002611557E+00, -2.9003993648153492E+00, -7.5799983399877077E-02,
         4.1143990989505834E+00, -3.3042992763616597E+00, -6.9399984801470568E-02,
         5.4516988060832432E+00, -2.8561993744951040E+00, -7.2399984144473614E-02,
         6.3892986007497967E+00, -3.6596991985294207E+00, -7.2299984166373524E-02,
         5.6623987599401575E+00, -1.4767996765823013E+00, -7.4899983596976152E-02,
         7.0094984649266268E+00, -9.3649979490745228E-01, -7.5199983531276451E-02,
         3.9205991413925863E+00, -4.7408989617477202E+00, -6.1599986509662634E-02,
         7.3399983925474632E-01,  1.0878997617510062E+00, -7.4999983575076257E-02,
         7.1239984398512435E-01, -4.5699989991746470E-01,  8.2339981967623732E-01,
         7.1239984398512435E-01, -4.5579990018026340E-01, -9.7549978636649193E-01,
         2.9929993445360430E+00,  2.1175995362477531E+00, -7.4799983618876062E-02,
         7.7652982994071955E+00, -1.7262996219420552E+00, -7.5899983377977168E-02,
         7.1485984344638682E+00, -3.2179992952612718E-01,  8.1969982048653345E-01,
         7.1479984345952676E+00, -3.2079992974512617E-01, -9.6949978768048573E-01,
         2.8649993725679135E+00, -5.0231988999243073E+00, -5.8299987232359275E-02,
         4.4022990359007768E+00, -5.1591988701404459E+00,  8.2839981858124223E-01,
         4.4001990363606742E+00, -5.1692988679285561E+00, -9.4779979243276369E-01
      ]
    }
  },
  "bonds": {
    "connections": {
      "index": [
        0, 1,
        1, 2,
        2, 3,
        3, 4,
        1, 5,
        4, 5,
        5, 6,
        6, 7,
        6, 8,
        8, 9,
        9, 10,
        4, 11,
        9, 11,
        11, 12,
        8, 13,
        0, 14,
        0, 15,
        0, 16,
        2, 17,
        12, 18,
        12, 19,
        12, 20,
        13, 21,
        13, 22,
        13, 23
      ]
    },
    "order": [
      1, 4, 4, 4, 1, 4, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
    ]
  }
}
```


## Missing features

The schema is not verified on completeness and not all data is stored in the final structure type.

@Note Feel free to contribute support for missing features
      or bring missing features to our attention by opening an issue.
