///////////////////////////////////////////////////////////////////////////////
//                                                         
// LALRHash.cc
// ------------
// Dragon LALR hash implementation
// 
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: LALRHash
// 
// Description:  
//
///////////////////////////////////////////////////////////////////////////////

#include "LALRHash.h"

///////////////////////
// LALRHash sub class //
///////////////////////

LALRHash::LALRHash()
{
}

LALRHash::LALRHash(const SetT<LR1Element>& LR1Set)
{
    _LR1Set = (SetT<LR1Element>)LR1Set;
}
	
LALRHash::LALRHash(const SetT<LR1Element>& LR1Set, int id)
{
    _LR1Set = (SetT<LR1Element>)LR1Set;
    _id = id;

}

LALRHash::~LALRHash()
{
}

int LALRHash::getId() const
{
    return _id;
}
	
SetT<LR1Element>& LALRHash::getSet() const
{
    return ((LALRHash*)this)->_LR1Set;
}
	
LALRHash& LALRHash::operator = (const LALRHash& h)
{
    _id = h._id;
    _LR1Set = h._LR1Set;
    return (*this);
}
	
bool LALRHash::operator == (const LALRHash& h) const
{
    if (_id == h._id)
	return true;
    return false;
}







