///////////////////////////////////////////////////////////////////////////////
//                                                         
// ParseTableEntry.cc
// ------------------
// Dragon parse table entry class implementation
// 
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: ParseTableEntry
// 
// Description: access to dragon termianal information 
//
///////////////////////////////////////////////////////////////////////////////

// DRAGOn INCLUDES
#include "ParseTableEntry.h"


ParseTableEntry::ParseTableEntry()
{
}

ParseTableEntry::ParseTableEntry(unsigned long state, const Chain& token, Action action, unsigned long arg)
{
    _state = state;
    _token = token;
    _action = action;
    _arg = arg;
}

unsigned long ParseTableEntry::getState()
{
    return _state;
}

const Chain& ParseTableEntry::getToken()
{
    return _token;
}

ParseTableEntry::Action ParseTableEntry::getAction()
{
    return _action;
}

unsigned long ParseTableEntry::getArg()
{
    return _arg;
}

ParseTableEntry& ParseTableEntry::operator = (const ParseTableEntry& e)
{
    _state = e._state;
    _token = e._token;
    _action = e._action;
    _arg = e._arg;
    return (*this);
}

bool ParseTableEntry::operator == (const ParseTableEntry& e)
{
    if (_state == e._state && _token == e._token )
	return true;
    return false;
}









