#ifndef _TERMINAL_H_INCLUDED_
#define _TERMINAL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Terminal.h
// ----------
// dragon terminal interface defintion
//               
// Design and Implementation by Bjoern Lemke
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: Terminal
// 
// Description: access to dragon termianal information 
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

class Terminal {
public:
    
    Terminal();
    Terminal (Chain id, Chain regexp = "", int num = 0);
    ~Terminal();

    Terminal& operator = (const Terminal& t);
    bool operator == (const Terminal& t);

    bool operator < (const Terminal& t);
    bool operator > (const Terminal& t);

    int getNum() const;
    const Chain& getName() const;
    const Chain& getRegExp() const;
    
private:
    int _num;
    Chain _name;
    Chain _regexp;
};

#endif





