///////////////////////////////////////////////////////////////////////////////
//                                                         
// ClosureCache.cc
// ---------------
// Dragon closure cache implementation
// 
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: ClosureCache
// 
// Description:
//
///////////////////////////////////////////////////////////////////////////////

#include "ClosureCache.h"


////////////////////////////
// ClosureCache sub class //
////////////////////////////

ClosureCache::ClosureCache()
{
}

ClosureCache::ClosureCache(const LR1Element& e)
{
    _e = e;
}

ClosureCache::ClosureCache(const SetT<LR1Element>& closureSet, 
				   const LR1Element& e)
{
    _closureSet = closureSet;
    _e = e;
}

ClosureCache::~ClosureCache()
{
}

SetT<LR1Element>& ClosureCache::getClosure() const
{
    return ((ClosureCache*)this)->_closureSet;
}

ClosureCache& ClosureCache::operator = (const ClosureCache& cc)
{
    _closureSet = cc._closureSet;
    _e = cc._e;
    return (*this);
}
    
bool ClosureCache::operator == (const ClosureCache& cc) const
{    
    if ( _e == cc._e)
	return true;
    return false;
}








