;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; Check that string.as_wtf16 is accepted by the parser but is not translated
;; into any IR.

;; RUN: wasm-opt %s -all -S -o - | filecheck %s
;; RUN: wasm-opt %s -all --shrink-level=3 --roundtrip -S -o - | filecheck %s --check-prefix=RTRIP
;; RUN: wasm-opt %s -all --shrink-level=3 --roundtrip --roundtrip -S -o - | filecheck %s --check-prefix=RRTRP

(module
  ;; CHECK:      (func $empty (type $2)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $empty (type $2)
  ;; RTRIP-NEXT: )
  ;; RRTRP:      (func $empty (type $2)
  ;; RRTRP-NEXT: )
  (func $empty
    (string.as_wtf16)
  )

  ;; CHECK:      (func $codeunit (type $1) (result i32)
  ;; CHECK-NEXT:  (stringview_wtf16.get_codeunit
  ;; CHECK-NEXT:   (string.const "abc")
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $codeunit (type $1) (result i32)
  ;; RTRIP-NEXT:  (local $0 i32)
  ;; RTRIP-NEXT:  (local $1 (ref string))
  ;; RTRIP-NEXT:  (stringview_wtf16.get_codeunit
  ;; RTRIP-NEXT:   (block (result (ref string))
  ;; RTRIP-NEXT:    (local.set $1
  ;; RTRIP-NEXT:     (string.const "abc")
  ;; RTRIP-NEXT:    )
  ;; RTRIP-NEXT:    (local.set $0
  ;; RTRIP-NEXT:     (i32.const 0)
  ;; RTRIP-NEXT:    )
  ;; RTRIP-NEXT:    (local.get $1)
  ;; RTRIP-NEXT:   )
  ;; RTRIP-NEXT:   (local.get $0)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  ;; RRTRP:      (func $codeunit (type $1) (result i32)
  ;; RRTRP-NEXT:  (local $0 i32)
  ;; RRTRP-NEXT:  (local $1 (ref string))
  ;; RRTRP-NEXT:  (local $2 (ref string))
  ;; RRTRP-NEXT:  (stringview_wtf16.get_codeunit
  ;; RRTRP-NEXT:   (block (result (ref string))
  ;; RRTRP-NEXT:    (local.set $2
  ;; RRTRP-NEXT:     (string.const "abc")
  ;; RRTRP-NEXT:    )
  ;; RRTRP-NEXT:    (local.set $0
  ;; RRTRP-NEXT:     (i32.const 0)
  ;; RRTRP-NEXT:    )
  ;; RRTRP-NEXT:    (local.get $2)
  ;; RRTRP-NEXT:   )
  ;; RRTRP-NEXT:   (local.get $0)
  ;; RRTRP-NEXT:  )
  ;; RRTRP-NEXT: )
  (func $codeunit (result i32)
    ;; This should parse ok with the conversion skipped. The roundtrip will
    ;; include scratch locals.
    (stringview_wtf16.get_codeunit
      (string.as_wtf16
        (string.const "abc")
      )
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $codeunit-get (type $1) (result i32)
  ;; CHECK-NEXT:  (local $pos i32)
  ;; CHECK-NEXT:  (stringview_wtf16.get_codeunit
  ;; CHECK-NEXT:   (string.const "abc")
  ;; CHECK-NEXT:   (local.get $pos)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $codeunit-get (type $1) (result i32)
  ;; RTRIP-NEXT:  (local $pos i32)
  ;; RTRIP-NEXT:  (stringview_wtf16.get_codeunit
  ;; RTRIP-NEXT:   (string.const "abc")
  ;; RTRIP-NEXT:   (local.get $pos)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  ;; RRTRP:      (func $codeunit-get (type $1) (result i32)
  ;; RRTRP-NEXT:  (local $pos i32)
  ;; RRTRP-NEXT:  (stringview_wtf16.get_codeunit
  ;; RRTRP-NEXT:   (string.const "abc")
  ;; RRTRP-NEXT:   (local.get $pos)
  ;; RRTRP-NEXT:  )
  ;; RRTRP-NEXT: )
  (func $codeunit-get (result i32)
    (local $pos i32)
    ;; This will not use a scratch local for pos.
    (stringview_wtf16.get_codeunit
      (string.const "abc")
      (local.get $pos)
    )
  )

  ;; CHECK:      (func $slice (type $0) (result stringref)
  ;; CHECK-NEXT:  (stringview_wtf16.slice
  ;; CHECK-NEXT:   (string.const "abc")
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:   (i32.const 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $slice (type $0) (result stringref)
  ;; RTRIP-NEXT:  (local $0 i32)
  ;; RTRIP-NEXT:  (local $1 i32)
  ;; RTRIP-NEXT:  (local $2 i32)
  ;; RTRIP-NEXT:  (local $3 (ref string))
  ;; RTRIP-NEXT:  (stringview_wtf16.slice
  ;; RTRIP-NEXT:   (block (result (ref string))
  ;; RTRIP-NEXT:    (local.set $3
  ;; RTRIP-NEXT:     (string.const "abc")
  ;; RTRIP-NEXT:    )
  ;; RTRIP-NEXT:    (local.set $0
  ;; RTRIP-NEXT:     (block (result i32)
  ;; RTRIP-NEXT:      (local.set $2
  ;; RTRIP-NEXT:       (i32.const 1)
  ;; RTRIP-NEXT:      )
  ;; RTRIP-NEXT:      (local.set $1
  ;; RTRIP-NEXT:       (i32.const 2)
  ;; RTRIP-NEXT:      )
  ;; RTRIP-NEXT:      (local.get $2)
  ;; RTRIP-NEXT:     )
  ;; RTRIP-NEXT:    )
  ;; RTRIP-NEXT:    (local.get $3)
  ;; RTRIP-NEXT:   )
  ;; RTRIP-NEXT:   (local.get $0)
  ;; RTRIP-NEXT:   (local.get $1)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  ;; RRTRP:      (func $slice (type $0) (result stringref)
  ;; RRTRP-NEXT:  (local $0 i32)
  ;; RRTRP-NEXT:  (local $1 i32)
  ;; RRTRP-NEXT:  (local $2 i32)
  ;; RRTRP-NEXT:  (local $3 (ref string))
  ;; RRTRP-NEXT:  (local $4 i32)
  ;; RRTRP-NEXT:  (local $5 (ref string))
  ;; RRTRP-NEXT:  (stringview_wtf16.slice
  ;; RRTRP-NEXT:   (block (result (ref string))
  ;; RRTRP-NEXT:    (local.set $5
  ;; RRTRP-NEXT:     (string.const "abc")
  ;; RRTRP-NEXT:    )
  ;; RRTRP-NEXT:    (local.set $0
  ;; RRTRP-NEXT:     (block (result i32)
  ;; RRTRP-NEXT:      (local.set $4
  ;; RRTRP-NEXT:       (i32.const 1)
  ;; RRTRP-NEXT:      )
  ;; RRTRP-NEXT:      (local.set $1
  ;; RRTRP-NEXT:       (i32.const 2)
  ;; RRTRP-NEXT:      )
  ;; RRTRP-NEXT:      (local.get $4)
  ;; RRTRP-NEXT:     )
  ;; RRTRP-NEXT:    )
  ;; RRTRP-NEXT:    (local.get $5)
  ;; RRTRP-NEXT:   )
  ;; RRTRP-NEXT:   (local.get $0)
  ;; RRTRP-NEXT:   (local.get $1)
  ;; RRTRP-NEXT:  )
  ;; RRTRP-NEXT: )
  (func $slice (result stringref)
    ;; This should parse ok with the conversion skipped. The roundtrip will
    ;; include scratch locals.
    (stringview_wtf16.slice
      (string.as_wtf16
        (string.const "abc")
      )
      (i32.const 1)
      (i32.const 2)
    )
  )

  ;; CHECK:      (func $slice-start-get (type $0) (result stringref)
  ;; CHECK-NEXT:  (local $start i32)
  ;; CHECK-NEXT:  (stringview_wtf16.slice
  ;; CHECK-NEXT:   (string.const "abc")
  ;; CHECK-NEXT:   (local.get $start)
  ;; CHECK-NEXT:   (i32.const 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $slice-start-get (type $0) (result stringref)
  ;; RTRIP-NEXT:  (local $start i32)
  ;; RTRIP-NEXT:  (local $1 i32)
  ;; RTRIP-NEXT:  (local $2 (ref string))
  ;; RTRIP-NEXT:  (stringview_wtf16.slice
  ;; RTRIP-NEXT:   (block (result (ref string))
  ;; RTRIP-NEXT:    (local.set $2
  ;; RTRIP-NEXT:     (string.const "abc")
  ;; RTRIP-NEXT:    )
  ;; RTRIP-NEXT:    (local.set $1
  ;; RTRIP-NEXT:     (i32.const 2)
  ;; RTRIP-NEXT:    )
  ;; RTRIP-NEXT:    (local.get $2)
  ;; RTRIP-NEXT:   )
  ;; RTRIP-NEXT:   (local.get $start)
  ;; RTRIP-NEXT:   (local.get $1)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  ;; RRTRP:      (func $slice-start-get (type $0) (result stringref)
  ;; RRTRP-NEXT:  (local $start i32)
  ;; RRTRP-NEXT:  (local $1 i32)
  ;; RRTRP-NEXT:  (local $2 (ref string))
  ;; RRTRP-NEXT:  (local $3 (ref string))
  ;; RRTRP-NEXT:  (stringview_wtf16.slice
  ;; RRTRP-NEXT:   (block (result (ref string))
  ;; RRTRP-NEXT:    (local.set $3
  ;; RRTRP-NEXT:     (string.const "abc")
  ;; RRTRP-NEXT:    )
  ;; RRTRP-NEXT:    (local.set $1
  ;; RRTRP-NEXT:     (i32.const 2)
  ;; RRTRP-NEXT:    )
  ;; RRTRP-NEXT:    (local.get $3)
  ;; RRTRP-NEXT:   )
  ;; RRTRP-NEXT:   (local.get $start)
  ;; RRTRP-NEXT:   (local.get $1)
  ;; RRTRP-NEXT:  )
  ;; RRTRP-NEXT: )
  (func $slice-start-get (result stringref)
    (local $start i32)
    (stringview_wtf16.slice
      (string.const "abc")
      (local.get $start)
      (i32.const 2)
    )
  )


  ;; CHECK:      (func $slice-end-get (type $0) (result stringref)
  ;; CHECK-NEXT:  (local $end i32)
  ;; CHECK-NEXT:  (stringview_wtf16.slice
  ;; CHECK-NEXT:   (string.const "abc")
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:   (local.get $end)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $slice-end-get (type $0) (result stringref)
  ;; RTRIP-NEXT:  (local $end i32)
  ;; RTRIP-NEXT:  (local $1 i32)
  ;; RTRIP-NEXT:  (local $2 (ref string))
  ;; RTRIP-NEXT:  (stringview_wtf16.slice
  ;; RTRIP-NEXT:   (block (result (ref string))
  ;; RTRIP-NEXT:    (local.set $2
  ;; RTRIP-NEXT:     (string.const "abc")
  ;; RTRIP-NEXT:    )
  ;; RTRIP-NEXT:    (local.set $1
  ;; RTRIP-NEXT:     (i32.const 1)
  ;; RTRIP-NEXT:    )
  ;; RTRIP-NEXT:    (local.get $2)
  ;; RTRIP-NEXT:   )
  ;; RTRIP-NEXT:   (local.get $1)
  ;; RTRIP-NEXT:   (local.get $end)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  ;; RRTRP:      (func $slice-end-get (type $0) (result stringref)
  ;; RRTRP-NEXT:  (local $end i32)
  ;; RRTRP-NEXT:  (local $1 i32)
  ;; RRTRP-NEXT:  (local $2 (ref string))
  ;; RRTRP-NEXT:  (local $3 (ref string))
  ;; RRTRP-NEXT:  (stringview_wtf16.slice
  ;; RRTRP-NEXT:   (block (result (ref string))
  ;; RRTRP-NEXT:    (local.set $3
  ;; RRTRP-NEXT:     (string.const "abc")
  ;; RRTRP-NEXT:    )
  ;; RRTRP-NEXT:    (local.set $1
  ;; RRTRP-NEXT:     (i32.const 1)
  ;; RRTRP-NEXT:    )
  ;; RRTRP-NEXT:    (local.get $3)
  ;; RRTRP-NEXT:   )
  ;; RRTRP-NEXT:   (local.get $1)
  ;; RRTRP-NEXT:   (local.get $end)
  ;; RRTRP-NEXT:  )
  ;; RRTRP-NEXT: )
  (func $slice-end-get (result stringref)
    (local $end i32)
    (stringview_wtf16.slice
      (string.const "abc")
      (i32.const 1)
      (local.get $end)
    )
  )

  ;; CHECK:      (func $slice-both-get (type $0) (result stringref)
  ;; CHECK-NEXT:  (local $start i32)
  ;; CHECK-NEXT:  (local $end i32)
  ;; CHECK-NEXT:  (stringview_wtf16.slice
  ;; CHECK-NEXT:   (string.const "abc")
  ;; CHECK-NEXT:   (local.get $start)
  ;; CHECK-NEXT:   (local.get $end)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $slice-both-get (type $0) (result stringref)
  ;; RTRIP-NEXT:  (local $start i32)
  ;; RTRIP-NEXT:  (local $end i32)
  ;; RTRIP-NEXT:  (stringview_wtf16.slice
  ;; RTRIP-NEXT:   (string.const "abc")
  ;; RTRIP-NEXT:   (local.get $start)
  ;; RTRIP-NEXT:   (local.get $end)
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  ;; RRTRP:      (func $slice-both-get (type $0) (result stringref)
  ;; RRTRP-NEXT:  (local $start i32)
  ;; RRTRP-NEXT:  (local $end i32)
  ;; RRTRP-NEXT:  (stringview_wtf16.slice
  ;; RRTRP-NEXT:   (string.const "abc")
  ;; RRTRP-NEXT:   (local.get $start)
  ;; RRTRP-NEXT:   (local.get $end)
  ;; RRTRP-NEXT:  )
  ;; RRTRP-NEXT: )
  (func $slice-both-get (result stringref)
    (local $start i32)
    (local $end i32)
    (stringview_wtf16.slice
      (string.const "abc")
      (local.get $start)
      (local.get $end)
    )
  )

  ;; CHECK:      (func $length (type $1) (result i32)
  ;; CHECK-NEXT:  (string.measure_wtf16
  ;; CHECK-NEXT:   (string.const "abc")
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $length (type $1) (result i32)
  ;; RTRIP-NEXT:  (string.measure_wtf16
  ;; RTRIP-NEXT:   (string.const "abc")
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  ;; RRTRP:      (func $length (type $1) (result i32)
  ;; RRTRP-NEXT:  (string.measure_wtf16
  ;; RRTRP-NEXT:   (string.const "abc")
  ;; RRTRP-NEXT:  )
  ;; RRTRP-NEXT: )
  (func $length (result i32)
    ;; This should be parsed as string.measure_wtf16 instead.
    (stringview_wtf16.length
      (string.as_wtf16
        (string.const "abc")
      )
    )
  )
)
