// NOTE: Assertions have mostly been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// The most important assertion is the attributes at the end of the file, which
// shows whether -ubsan-unique-traps attaches 'nomerge' to each ubsan call.
//
// RUN: %clang_cc1 -triple x86_64-linux-gnu -emit-llvm -fsanitize=signed-integer-overflow -O3 -mllvm -ubsan-unique-traps %s -o - -fsanitize-trap=signed-integer-overflow | FileCheck %s --check-prefix=TRAP
// RUN: %clang_cc1 -triple x86_64-linux-gnu -emit-llvm -fsanitize=signed-integer-overflow -O3 -mllvm -ubsan-unique-traps %s -o -                                         | FileCheck %s --check-prefix=HANDLER
// RUN: %clang_cc1 -triple x86_64-linux-gnu -emit-llvm -fsanitize=signed-integer-overflow -O3 -mllvm -ubsan-unique-traps %s -o - -fsanitize-minimal-runtime              | FileCheck %s --check-prefix=MINRT
//
// REQUIRES: x86-registered-target

// TRAP-LABEL: define dso_local range(i32 -2147483523, -2147483648) i32 @f(
// TRAP-SAME: i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// TRAP-NEXT:  [[ENTRY:.*:]]
// TRAP-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 125), !nosanitize [[META2:![0-9]+]]
// TRAP-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// TRAP-NEXT:    br i1 [[TMP1]], label %[[TRAP:.*]], label %[[CONT:.*]], !nosanitize [[META2]]
// TRAP:       [[TRAP]]:
// TRAP-NEXT:    tail call void @llvm.ubsantrap(i8 0) #[[ATTR4:[0-9]+]], !nosanitize [[META2]]
// TRAP-NEXT:    unreachable, !nosanitize [[META2]]
// TRAP:       [[CONT]]:
// TRAP-NEXT:    [[TMP2:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// TRAP-NEXT:    ret i32 [[TMP2]]
//
// HANDLER-LABEL: define dso_local range(i32 -2147483523, -2147483648) i32 @f(
// HANDLER-SAME: i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// HANDLER-NEXT:  [[ENTRY:.*:]]
// HANDLER-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 125), !nosanitize [[META2:![0-9]+]]
// HANDLER-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// HANDLER-NEXT:    br i1 [[TMP1]], label %[[HANDLER_ADD_OVERFLOW:.*]], label %[[CONT:.*]], !prof [[PROF3:![0-9]+]], !nosanitize [[META2]]
// HANDLER:       [[HANDLER_ADD_OVERFLOW]]:
// HANDLER-NEXT:    [[TMP2:%.*]] = zext nneg i32 [[X]] to i64, !nosanitize [[META2]]
// HANDLER-NEXT:    tail call void @__ubsan_handle_add_overflow_abort(ptr nonnull @[[GLOB1:[0-9]+]], i64 [[TMP2]], i64 125) #[[ATTR4:[0-9]+]], !nosanitize [[META2]]
// HANDLER-NEXT:    unreachable, !nosanitize [[META2]]
// HANDLER:       [[CONT]]:
// HANDLER-NEXT:    [[TMP3:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// HANDLER-NEXT:    ret i32 [[TMP3]]
//
// MINRT-LABEL: define dso_local range(i32 -2147483523, -2147483648) i32 @f(
// MINRT-SAME: i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// MINRT-NEXT:  [[ENTRY:.*:]]
// MINRT-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 125), !nosanitize [[META2:![0-9]+]]
// MINRT-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// MINRT-NEXT:    br i1 [[TMP1]], label %[[HANDLER_ADD_OVERFLOW:.*]], label %[[CONT:.*]], !prof [[PROF3:![0-9]+]], !nosanitize [[META2]]
// MINRT:       [[HANDLER_ADD_OVERFLOW]]:
// MINRT-NEXT:    tail call void @__ubsan_handle_add_overflow_minimal_abort() #[[ATTR4:[0-9]+]], !nosanitize [[META2]]
// MINRT-NEXT:    unreachable, !nosanitize [[META2]]
// MINRT:       [[CONT]]:
// MINRT-NEXT:    [[TMP2:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// MINRT-NEXT:    ret i32 [[TMP2]]
//
int f(int x) {
  return x + 125;
}

// TRAP-LABEL: define dso_local range(i32 -2147483521, -2147483648) i32 @g(
// TRAP-SAME: i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// TRAP-NEXT:  [[ENTRY:.*:]]
// TRAP-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 127), !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// TRAP-NEXT:    br i1 [[TMP1]], label %[[TRAP:.*]], label %[[CONT:.*]], !nosanitize [[META2]]
// TRAP:       [[TRAP]]:
// TRAP-NEXT:    tail call void @llvm.ubsantrap(i8 0) #[[ATTR4]], !nosanitize [[META2]]
// TRAP-NEXT:    unreachable, !nosanitize [[META2]]
// TRAP:       [[CONT]]:
// TRAP-NEXT:    [[TMP2:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// TRAP-NEXT:    ret i32 [[TMP2]]
//
// HANDLER-LABEL: define dso_local range(i32 -2147483521, -2147483648) i32 @g(
// HANDLER-SAME: i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// HANDLER-NEXT:  [[ENTRY:.*:]]
// HANDLER-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 127), !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// HANDLER-NEXT:    br i1 [[TMP1]], label %[[HANDLER_ADD_OVERFLOW:.*]], label %[[CONT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// HANDLER:       [[HANDLER_ADD_OVERFLOW]]:
// HANDLER-NEXT:    [[TMP2:%.*]] = zext nneg i32 [[X]] to i64, !nosanitize [[META2]]
// HANDLER-NEXT:    tail call void @__ubsan_handle_add_overflow_abort(ptr nonnull @[[GLOB2:[0-9]+]], i64 [[TMP2]], i64 127) #[[ATTR4]], !nosanitize [[META2]]
// HANDLER-NEXT:    unreachable, !nosanitize [[META2]]
// HANDLER:       [[CONT]]:
// HANDLER-NEXT:    [[TMP3:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// HANDLER-NEXT:    ret i32 [[TMP3]]
//
// MINRT-LABEL: define dso_local range(i32 -2147483521, -2147483648) i32 @g(
// MINRT-SAME: i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// MINRT-NEXT:  [[ENTRY:.*:]]
// MINRT-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 127), !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// MINRT-NEXT:    br i1 [[TMP1]], label %[[HANDLER_ADD_OVERFLOW:.*]], label %[[CONT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// MINRT:       [[HANDLER_ADD_OVERFLOW]]:
// MINRT-NEXT:    tail call void @__ubsan_handle_add_overflow_minimal_abort() #[[ATTR4]], !nosanitize [[META2]]
// MINRT-NEXT:    unreachable, !nosanitize [[META2]]
// MINRT:       [[CONT]]:
// MINRT-NEXT:    [[TMP2:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// MINRT-NEXT:    ret i32 [[TMP2]]
//
int g(int x) {
  return x + 127;
}

// TRAP-LABEL: define dso_local range(i32 -2147483521, -2147483648) i32 @h(
// TRAP-SAME: i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// TRAP-NEXT:  [[ENTRY:.*:]]
// TRAP-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 127), !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// TRAP-NEXT:    br i1 [[TMP1]], label %[[TRAP:.*]], label %[[CONT:.*]], !nosanitize [[META2]]
// TRAP:       [[TRAP]]:
// TRAP-NEXT:    tail call void @llvm.ubsantrap(i8 0) #[[ATTR4]], !nosanitize [[META2]]
// TRAP-NEXT:    unreachable, !nosanitize [[META2]]
// TRAP:       [[CONT]]:
// TRAP-NEXT:    [[TMP2:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[Y]], i32 129), !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP3:%.*]] = extractvalue { i32, i1 } [[TMP2]], 1, !nosanitize [[META2]]
// TRAP-NEXT:    br i1 [[TMP3]], label %[[TRAP1:.*]], label %[[CONT2:.*]], !nosanitize [[META2]]
// TRAP:       [[TRAP1]]:
// TRAP-NEXT:    tail call void @llvm.ubsantrap(i8 0) #[[ATTR4]], !nosanitize [[META2]]
// TRAP-NEXT:    unreachable, !nosanitize [[META2]]
// TRAP:       [[CONT2]]:
// TRAP-NEXT:    [[TMP4:%.*]] = extractvalue { i32, i1 } [[TMP2]], 0, !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP5:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// TRAP-NEXT:    [[COND:%.*]] = tail call i32 @llvm.smin.i32(i32 [[TMP5]], i32 [[TMP4]])
// TRAP-NEXT:    ret i32 [[COND]]
//
// HANDLER-LABEL: define dso_local range(i32 -2147483521, -2147483648) i32 @h(
// HANDLER-SAME: i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// HANDLER-NEXT:  [[ENTRY:.*:]]
// HANDLER-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 127), !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// HANDLER-NEXT:    br i1 [[TMP1]], label %[[HANDLER_ADD_OVERFLOW:.*]], label %[[CONT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// HANDLER:       [[HANDLER_ADD_OVERFLOW]]:
// HANDLER-NEXT:    [[TMP2:%.*]] = zext nneg i32 [[X]] to i64, !nosanitize [[META2]]
// HANDLER-NEXT:    tail call void @__ubsan_handle_add_overflow_abort(ptr nonnull @[[GLOB3:[0-9]+]], i64 [[TMP2]], i64 127) #[[ATTR4]], !nosanitize [[META2]]
// HANDLER-NEXT:    unreachable, !nosanitize [[META2]]
// HANDLER:       [[CONT]]:
// HANDLER-NEXT:    [[TMP3:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[Y]], i32 129), !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP4:%.*]] = extractvalue { i32, i1 } [[TMP3]], 1, !nosanitize [[META2]]
// HANDLER-NEXT:    br i1 [[TMP4]], label %[[HANDLER_ADD_OVERFLOW1:.*]], label %[[CONT2:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// HANDLER:       [[HANDLER_ADD_OVERFLOW1]]:
// HANDLER-NEXT:    [[TMP5:%.*]] = zext nneg i32 [[Y]] to i64, !nosanitize [[META2]]
// HANDLER-NEXT:    tail call void @__ubsan_handle_add_overflow_abort(ptr nonnull @[[GLOB4:[0-9]+]], i64 [[TMP5]], i64 129) #[[ATTR4]], !nosanitize [[META2]]
// HANDLER-NEXT:    unreachable, !nosanitize [[META2]]
// HANDLER:       [[CONT2]]:
// HANDLER-NEXT:    [[TMP6:%.*]] = extractvalue { i32, i1 } [[TMP3]], 0, !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP7:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// HANDLER-NEXT:    [[COND:%.*]] = tail call i32 @llvm.smin.i32(i32 [[TMP7]], i32 [[TMP6]])
// HANDLER-NEXT:    ret i32 [[COND]]
//
// MINRT-LABEL: define dso_local range(i32 -2147483521, -2147483648) i32 @h(
// MINRT-SAME: i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// MINRT-NEXT:  [[ENTRY:.*:]]
// MINRT-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 127), !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// MINRT-NEXT:    br i1 [[TMP1]], label %[[HANDLER_ADD_OVERFLOW:.*]], label %[[CONT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// MINRT:       [[HANDLER_ADD_OVERFLOW]]:
// MINRT-NEXT:    tail call void @__ubsan_handle_add_overflow_minimal_abort() #[[ATTR4]], !nosanitize [[META2]]
// MINRT-NEXT:    unreachable, !nosanitize [[META2]]
// MINRT:       [[CONT]]:
// MINRT-NEXT:    [[TMP2:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[Y]], i32 129), !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP3:%.*]] = extractvalue { i32, i1 } [[TMP2]], 1, !nosanitize [[META2]]
// MINRT-NEXT:    br i1 [[TMP3]], label %[[HANDLER_ADD_OVERFLOW1:.*]], label %[[CONT2:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// MINRT:       [[HANDLER_ADD_OVERFLOW1]]:
// MINRT-NEXT:    tail call void @__ubsan_handle_add_overflow_minimal_abort() #[[ATTR4]], !nosanitize [[META2]]
// MINRT-NEXT:    unreachable, !nosanitize [[META2]]
// MINRT:       [[CONT2]]:
// MINRT-NEXT:    [[TMP4:%.*]] = extractvalue { i32, i1 } [[TMP2]], 0, !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP5:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// MINRT-NEXT:    [[COND:%.*]] = tail call i32 @llvm.smin.i32(i32 [[TMP5]], i32 [[TMP4]])
// MINRT-NEXT:    ret i32 [[COND]]
//
int h(int x, int y) {
  x += 127;
  y += 129;
  return x < y ? x : y;
}

// TRAP-LABEL: define dso_local noundef i32 @m(
// TRAP-SAME: i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// TRAP-NEXT:  [[ENTRY:.*:]]
// TRAP-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 125), !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// TRAP-NEXT:    br i1 [[TMP1]], label %[[TRAP_I:.*]], label %[[F_EXIT:.*]], !nosanitize [[META2]]
// TRAP:       [[TRAP_I]]:
// TRAP-NEXT:    tail call void @llvm.ubsantrap(i8 0) #[[ATTR4]], !nosanitize [[META2]]
// TRAP-NEXT:    unreachable, !nosanitize [[META2]]
// TRAP:       [[F_EXIT]]:
// TRAP-NEXT:    [[TMP2:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[Y]], i32 127), !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP3:%.*]] = extractvalue { i32, i1 } [[TMP2]], 1, !nosanitize [[META2]]
// TRAP-NEXT:    br i1 [[TMP3]], label %[[TRAP_I2:.*]], label %[[G_EXIT:.*]], !nosanitize [[META2]]
// TRAP:       [[TRAP_I2]]:
// TRAP-NEXT:    tail call void @llvm.ubsantrap(i8 0) #[[ATTR4]], !nosanitize [[META2]]
// TRAP-NEXT:    unreachable, !nosanitize [[META2]]
// TRAP:       [[G_EXIT]]:
// TRAP-NEXT:    [[TMP4:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP5:%.*]] = extractvalue { i32, i1 } [[TMP2]], 0, !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP6:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[TMP4]], i32 [[TMP5]]), !nosanitize [[META2]]
// TRAP-NEXT:    [[TMP7:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1, !nosanitize [[META2]]
// TRAP-NEXT:    br i1 [[TMP7]], label %[[TRAP:.*]], label %[[CONT:.*]], !nosanitize [[META2]]
// TRAP:       [[TRAP]]:
// TRAP-NEXT:    tail call void @llvm.ubsantrap(i8 0) #[[ATTR4]], !nosanitize [[META2]]
// TRAP-NEXT:    unreachable, !nosanitize [[META2]]
// TRAP:       [[CONT]]:
// TRAP-NEXT:    [[TMP8:%.*]] = extractvalue { i32, i1 } [[TMP6]], 0, !nosanitize [[META2]]
// TRAP-NEXT:    ret i32 [[TMP8]]
//
// HANDLER-LABEL: define dso_local noundef i32 @m(
// HANDLER-SAME: i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// HANDLER-NEXT:  [[ENTRY:.*:]]
// HANDLER-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 125), !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// HANDLER-NEXT:    br i1 [[TMP1]], label %[[HANDLER_ADD_OVERFLOW_I:.*]], label %[[F_EXIT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// HANDLER:       [[HANDLER_ADD_OVERFLOW_I]]:
// HANDLER-NEXT:    [[TMP2:%.*]] = zext nneg i32 [[X]] to i64, !nosanitize [[META2]]
// HANDLER-NEXT:    tail call void @__ubsan_handle_add_overflow_abort(ptr nonnull @[[GLOB1]], i64 [[TMP2]], i64 125) #[[ATTR4]], !nosanitize [[META2]]
// HANDLER-NEXT:    unreachable, !nosanitize [[META2]]
// HANDLER:       [[F_EXIT]]:
// HANDLER-NEXT:    [[TMP3:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP4:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[Y]], i32 127), !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP5:%.*]] = extractvalue { i32, i1 } [[TMP4]], 1, !nosanitize [[META2]]
// HANDLER-NEXT:    br i1 [[TMP5]], label %[[HANDLER_ADD_OVERFLOW_I2:.*]], label %[[G_EXIT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// HANDLER:       [[HANDLER_ADD_OVERFLOW_I2]]:
// HANDLER-NEXT:    [[TMP6:%.*]] = zext nneg i32 [[Y]] to i64, !nosanitize [[META2]]
// HANDLER-NEXT:    tail call void @__ubsan_handle_add_overflow_abort(ptr nonnull @[[GLOB2]], i64 [[TMP6]], i64 127) #[[ATTR4]], !nosanitize [[META2]]
// HANDLER-NEXT:    unreachable, !nosanitize [[META2]]
// HANDLER:       [[G_EXIT]]:
// HANDLER-NEXT:    [[TMP7:%.*]] = extractvalue { i32, i1 } [[TMP4]], 0, !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP8:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[TMP3]], i32 [[TMP7]]), !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP9:%.*]] = extractvalue { i32, i1 } [[TMP8]], 1, !nosanitize [[META2]]
// HANDLER-NEXT:    br i1 [[TMP9]], label %[[HANDLER_ADD_OVERFLOW:.*]], label %[[CONT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// HANDLER:       [[HANDLER_ADD_OVERFLOW]]:
// HANDLER-NEXT:    [[TMP10:%.*]] = zext i32 [[TMP3]] to i64, !nosanitize [[META2]]
// HANDLER-NEXT:    [[TMP11:%.*]] = zext i32 [[TMP7]] to i64, !nosanitize [[META2]]
// HANDLER-NEXT:    tail call void @__ubsan_handle_add_overflow_abort(ptr nonnull @[[GLOB5:[0-9]+]], i64 [[TMP10]], i64 [[TMP11]]) #[[ATTR4]], !nosanitize [[META2]]
// HANDLER-NEXT:    unreachable, !nosanitize [[META2]]
// HANDLER:       [[CONT]]:
// HANDLER-NEXT:    [[TMP12:%.*]] = extractvalue { i32, i1 } [[TMP8]], 0, !nosanitize [[META2]]
// HANDLER-NEXT:    ret i32 [[TMP12]]
//
// MINRT-LABEL: define dso_local noundef i32 @m(
// MINRT-SAME: i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// MINRT-NEXT:  [[ENTRY:.*:]]
// MINRT-NEXT:    [[TMP0:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[X]], i32 125), !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1, !nosanitize [[META2]]
// MINRT-NEXT:    br i1 [[TMP1]], label %[[HANDLER_ADD_OVERFLOW_I:.*]], label %[[F_EXIT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// MINRT:       [[HANDLER_ADD_OVERFLOW_I]]:
// MINRT-NEXT:    tail call void @__ubsan_handle_add_overflow_minimal_abort() #[[ATTR4]], !nosanitize [[META2]]
// MINRT-NEXT:    unreachable, !nosanitize [[META2]]
// MINRT:       [[F_EXIT]]:
// MINRT-NEXT:    [[TMP2:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[Y]], i32 127), !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP3:%.*]] = extractvalue { i32, i1 } [[TMP2]], 1, !nosanitize [[META2]]
// MINRT-NEXT:    br i1 [[TMP3]], label %[[HANDLER_ADD_OVERFLOW_I2:.*]], label %[[G_EXIT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// MINRT:       [[HANDLER_ADD_OVERFLOW_I2]]:
// MINRT-NEXT:    tail call void @__ubsan_handle_add_overflow_minimal_abort() #[[ATTR4]], !nosanitize [[META2]]
// MINRT-NEXT:    unreachable, !nosanitize [[META2]]
// MINRT:       [[G_EXIT]]:
// MINRT-NEXT:    [[TMP4:%.*]] = extractvalue { i32, i1 } [[TMP0]], 0, !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP5:%.*]] = extractvalue { i32, i1 } [[TMP2]], 0, !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP6:%.*]] = tail call { i32, i1 } @llvm.sadd.with.overflow.i32(i32 [[TMP4]], i32 [[TMP5]]), !nosanitize [[META2]]
// MINRT-NEXT:    [[TMP7:%.*]] = extractvalue { i32, i1 } [[TMP6]], 1, !nosanitize [[META2]]
// MINRT-NEXT:    br i1 [[TMP7]], label %[[HANDLER_ADD_OVERFLOW:.*]], label %[[CONT:.*]], !prof [[PROF3]], !nosanitize [[META2]]
// MINRT:       [[HANDLER_ADD_OVERFLOW]]:
// MINRT-NEXT:    tail call void @__ubsan_handle_add_overflow_minimal_abort() #[[ATTR4]], !nosanitize [[META2]]
// MINRT-NEXT:    unreachable, !nosanitize [[META2]]
// MINRT:       [[CONT]]:
// MINRT-NEXT:    [[TMP8:%.*]] = extractvalue { i32, i1 } [[TMP6]], 0, !nosanitize [[META2]]
// MINRT-NEXT:    ret i32 [[TMP8]]
//
int m(int x, int y) {
  return f(x) + g(y);
}
// TRAP: attributes #[[ATTR4]] = { nomerge noreturn nounwind }
// HANDLER: attributes #[[ATTR4]] = { noreturn nounwind }
// MINRT: attributes #[[ATTR4]] = { noreturn nounwind }
