//go:build linux
// +build linux

package remove

import (
	"os"
	"testing"

	"github.com/dundee/gdu/v5/internal/testdir"
	"github.com/dundee/gdu/v5/pkg/analyze"
	"github.com/dundee/gdu/v5/pkg/fs"
	"github.com/stretchr/testify/assert"
)

func TestRemoveItemFromDirParallelWithErr(t *testing.T) {
	fin := testdir.CreateTestDir()
	defer fin()

	err := os.Chmod("test_dir/nested", 0)
	assert.Nil(t, err)
	defer func() {
		err = os.Chmod("test_dir/nested", 0755)
		assert.Nil(t, err)
	}()

	dir := &analyze.Dir{
		File: &analyze.File{
			Name: "test_dir",
		},
		BasePath: ".",
	}

	subdir := &analyze.Dir{
		File: &analyze.File{
			Name:   "nested",
			Parent: dir,
		},
	}

	err = RemoveItemFromDirParallel(dir, subdir)
	assert.Contains(t, err.Error(), "permission denied")
}

func TestRemoveItemFromDirParallelWithErr2(t *testing.T) {
	fin := testdir.CreateTestDir()
	defer fin()

	err := os.Chmod("test_dir/nested/subnested", 0)
	assert.Nil(t, err)
	defer func() {
		err = os.Chmod("test_dir/nested/subnested", 0755)
		assert.Nil(t, err)
	}()

	analyzer := analyze.CreateAnalyzer()
	dir := analyzer.AnalyzeDir(
		"test_dir", func(_, _ string) bool { return false }, false,
	).(*analyze.Dir)
	analyzer.GetDone().Wait()
	dir.UpdateStats(make(fs.HardLinkedItems))

	subdir := dir.Files[0].(*analyze.Dir)

	err = RemoveItemFromDirParallel(dir, subdir)
	assert.Contains(t, err.Error(), "permission denied")
}
