# Historical GIMP logos

## Logos

* [GIMP 3.0](logo/README.md) by Aryeom in 2024, under [Creative Commons
  Attribution-ShareAlike 4.0](https://creativecommons.org/licenses/by-sa/3.0/) license:

  ![Current GIMP logo](logo/gimp-logo.svg)

* [GIMP 2.6, 2.8 and 2.10](https://gitlab.gnome.org/GNOME/gimp/-/blob/f73c4ed397d797ec1b5175f27b5c0f3538a87714/data/images/gimp-logo.png)
  by Jakub Steiner in 2008 under [Creative Commons by-sa 3.0](https://creativecommons.org/licenses/by-sa/3.0/):

  ![GIMP 2.6 to 2.10 logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/f73c4ed397d797ec1b5175f27b5c0f3538a87714/data/images/gimp-logo.png)

  In the same time, the [developer
  logo](https://gitlab.gnome.org/GNOME/gimp/-/commit/f9ea72123880de1976e8bace2fbca015ac312845)
  was introduced, though it was not used until GIMP 2.7 (then 2.9, 2.99…)
  releases:

  ![GIMP 2.7 to 2.99 development logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/f73c4ed397d797ec1b5175f27b5c0f3538a87714/data/images/wilber-devel.png)

  The source file for the logo was [committed to repository](https://gitlab.gnome.org/GNOME/gimp/-/blob/0579cb949be212e540a345e79f4c4b503206d5fa/desktop/src/gimp.svg)
  as SVG with variants for various sizes:

  ![Vectorial source file of GIMP 2.6 to 2.10 logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/0579cb949be212e540a345e79f4c4b503206d5fa/desktop/src/gimp.svg)

* [GIMP 2.4](https://gitlab.gnome.org/GNOME/gimp/-/blob/b520a3eece0e06d24a98d6d2c7ee359b2b8e13cd/data/images/gimp-logo.png) by Jakub Steiner.

  ![GIMP 2.4 logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/b520a3eece0e06d24a98d6d2c7ee359b2b8e13cd/data/images/gimp-logo.png)

* [Pre-GIMP 2.4](https://gitlab.gnome.org/GNOME/gimp/-/blob/0268c69940ef0ec39b80011b8d8ab3ed415031b0/data/images/gimp-logo.png)
  by Jakub Steiner in 2006. This version was never used and soon changed.

  ![pre-GIMP 2.4 logo](https://gitlab.gnome.org/GNOME/gimp/-/raw/0268c69940ef0ec39b80011b8d8ab3ed415031b0/data/images/gimp-logo.png)

* [Wizard Wilber](https://gitlab.gnome.org/GNOME/gimp/-/blob/a93fbc682e5574ea68eef58a09de609fb1cc5cc8/data/images/wilber-wizard.png)
  was added in 2002 for the user installation dialog but is not used anymore in
  modern GIMP (we just use the "gimp-wilber-eek" icon instead).

  ![Wizard Wilber](https://gitlab.gnome.org/GNOME/gimp/-/raw/0d83d2008d4f80f87be898bbff9b6c652c74157e/data/images/wilber-wizard.png)

* [Wilber Construction Kit](https://gitlab.gnome.org/GNOME/gimp/-/commit/f9ea72123880de1976e8bace2fbca015ac312845)
  adding accessories to the original Wilber by various team members, between
  2000 to 2005: Jens Lautenbacher, Sven Neumann, Seth Burgess, Ville Pätsi,
  Guillermo S. Romero, Carol Spears…

* [SVG variant](https://gitlab.gnome.org/GNOME/gimp/-/blob/e33ff2b0895f8622051f310ca000f48ad45b5981/docs/Wilber.svg)
  by Simon Budig in 2000.

  ![SVG variant](https://gitlab.gnome.org/GNOME/gimp/-/raw/e6c52afb6e14915f64336ca4885f70f04e07bb8c/docs/Wilber.svg)

* [French painter Wilber](https://gitlab.gnome.org/GNOME/gimp/-/blob/a93fbc682e5574ea68eef58a09de609fb1cc5cc8/data/images/wilber-tips.png)
  exists since the start (1997), first as `app/wilber.h` [header
  file](https://gitlab.gnome.org/GNOME/gimp/-/blob/32cefec8f76ccb20f1bf3f9311843ca47c1101c8/app/wilber.h),
  then as [XMP](https://gitlab.gnome.org/GNOME/gimp/-/blob/f765a8216f29e0f4f56af767f582e5df59ae606b/pixmaps/wilber3.xpm),
  before getting its final PNG format. It was used for the "Tip of the day"
  popup (nowadays, we just use "dialog-information" icon).

  ![French painter Wilber](https://gitlab.gnome.org/GNOME/gimp/-/raw/a93fbc682e5574ea68eef58a09de609fb1cc5cc8/data/images/wilber-tips.png)

* [Original Wilber](https://gitlab.gnome.org/GNOME/gimp/-/commit/a4e97e61f982d3039d9d594de9477a5104491c52)
  by Tuomas Kuosmanen.

  ![Original Wilber](https://gitlab.gnome.org/GNOME/gimp/-/raw/925a16359732509beb04c9896ffff67ea4022735/desktop/gimp.png)

  - [XCF file](https://gitlab.gnome.org/GNOME/gimp/-/blob/a4e97e61f982d3039d9d594de9477a5104491c52/docs/Wilber.xcf.gz)
  - [README/Licensing](https://gitlab.gnome.org/GNOME/gimp/-/blob/a4e97e61f982d3039d9d594de9477a5104491c52/docs/Wilber.xcf.gz.README)

## About dialog images

We make a separate section for the "About" dialog which used to have its own
dedicated image from early GIMP until GIMP 2.2. In GIMP 2.4 until today, the
About dialog shows the application logo.

* [GIMP 2.7 (unstable release)](https://gitlab.gnome.org/GNOME/gimp/-/blob/f959832666f8ab0a2af719ee5106c7d59701502f/data/images/gimp-devel-logo.png):
  from this version and onward, stable releases (even minor version) were still
  using the logo whereas even releases (odd minor version) were using a
  dedicated development logo (Wilber with a hard hat).

  ![GIMP 2.7 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/f959832666f8ab0a2af719ee5106c7d59701502f/data/images/gimp-devel-logo.png)

* GIMP 2.4: from this version, the About dialog simply used the application logo. See GIMP 2.4 application logo.

  ![GIMP 2.4 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/0268c69940ef0ec39b80011b8d8ab3ed415031b0/data/images/gimp-logo.png)

* [GIMP 2.2](https://gitlab.gnome.org/GNOME/gimp/-/blob/c075dab29e494dd596ce84e9548a9b6e7f8c8a6b/data/images/gimp-logo.png) by Philip Lafleur.

  ![GIMP 2.2 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/c075dab29e494dd596ce84e9548a9b6e7f8c8a6b/data/images/gimp-logo.png)

* [GIMP 1.4 to 2.0](https://gitlab.gnome.org/GNOME/gimp/-/blob/8cdcee9626db576be7eacf57a2207348da26b3c3/data/images/gimp_logo.png):
  by Jakub Stenier.

  ![GIMP 1.4 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/8cdcee9626db576be7eacf57a2207348da26b3c3/data/images/gimp_logo.png)

* [Between GIMP 1.3.24 to 1.3.25](https://gitlab.gnome.org/GNOME/gimp/-/blob/c48c9370425be886c25fd9cf2252e87d2306ec12/data/images/gimp_logo.png):
  by Jakub Steiner. This image was never used in a release but a cropped version
  of it.

  ![GIMP 1.3 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/c48c9370425be886c25fd9cf2252e87d2306ec12/data/images/gimp_logo.png)

* [GIMP 1.2](https://gitlab.gnome.org/GNOME/gimp/-/blob/52776aa6d4e4c0534ced4ad33cd3f09fa3ebd7cc/data/images/gimp_logo.ppm): "Wilber & Sons"

  ![GIMP 1.2 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/be1215a221aa534118086425f361954b27427455/data/images/gimp_logo.png)

* [GIMP 1.0](https://gitlab.gnome.org/GNOME/gimp/-/blob/a3c0b515f9c39cbf0dc6ba9525ae2ea0a369ec5e/data/images/gimp-logo-1.0.png):
  This logo was used since the [early
  start](https://gitlab.gnome.org/GNOME/gimp/-/commit/32cefec8f76ccb20f1bf3f9311843ca47c1101c8) under the name `gimp_logo.ppm`.
  Author is uncertain, though the commit author is Elliot Lee.
  From reading `git log`, it looks like it was just used for the About dialog
  while the software logo may have already been Wilber.

  ![GIMP 1.0 About image](https://gitlab.gnome.org/GNOME/gimp/-/raw/a3c0b515f9c39cbf0dc6ba9525ae2ea0a369ec5e/data/images/gimp-logo-1.0.png)
