---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab release upload`

Upload release asset files or links to GitLab Release

## Synopsis

Upload release assets to GitLab Release

You can define the display name by appending '#' after the file name. 
The link type comes after the display name (eg. 'myfile.tar.gz#My display name#package')

```plaintext
glab release upload <tag> [<files>...] [flags]
```

## Examples

```plaintext
Upload a release asset with a display name (type will default to 'other')
$ glab release upload v1.0.1 '/path/to/asset.zip#My display label'

Upload a release asset with a display name and type
$ glab release upload v1.0.1 '/path/to/asset.png#My display label#image'

Upload all assets in a specified folder (types will default to 'other')
$ glab release upload v1.0.1 ./dist/*

Upload all tarballs in a specified folder (types will default to 'other')
$ glab release upload v1.0.1 ./dist/*.tar.gz

Upload release assets links specified as JSON string
$ glab release upload v1.0.1 --assets-links='
  [
    {
      "name": "Asset1", 
      "url":"https://<domain>/some/location/1", 
      "link_type": "other", 
      "direct_asset_path": "path/to/file"
    }
  ]'

```

## Options

```plaintext
  -a, --assets-links JSON   JSON string representation of assets links (e.g. `--assets-links='[{"name": "Asset1", "url":"https://<domain>/some/location/1", "link_type": "other", "direct_asset_path": "path/to/file"}]')`
```

## Options inherited from parent commands

```plaintext
      --help              Show help for command
  -R, --repo OWNER/REPO   Select another repository using the OWNER/REPO or `GROUP/NAMESPACE/REPO` format or full URL or git URL
```
