// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_7_15_8.h"

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_7_15_8 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table1_0_emit_[68] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75,
    0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c,
    0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x59,
    0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint16_t HuffDecoderCommon::table1_0_inner_[72] = {
    0x0005, 0x0045, 0x0085, 0x00c5, 0x0105, 0x0145, 0x0185, 0x01c5, 0x0205,
    0x0245, 0x0286, 0x02c6, 0x0306, 0x0346, 0x0386, 0x03c6, 0x0406, 0x0446,
    0x0486, 0x04c6, 0x0506, 0x0546, 0x0586, 0x05c6, 0x0606, 0x0646, 0x0686,
    0x06c6, 0x0706, 0x0746, 0x0786, 0x07c6, 0x0806, 0x0846, 0x0886, 0x08c6,
    0x0907, 0x0947, 0x0987, 0x09c7, 0x0a07, 0x0a47, 0x0a87, 0x0ac7, 0x0b07,
    0x0b47, 0x0b87, 0x0bc7, 0x0c07, 0x0c47, 0x0c87, 0x0cc7, 0x0d07, 0x0d47,
    0x0d87, 0x0dc7, 0x0e07, 0x0e47, 0x0e87, 0x0ec7, 0x0f07, 0x0f47, 0x0f87,
    0x0fc7, 0x1007, 0x1047, 0x1087, 0x10c7, 0x000f, 0x0017, 0x001f, 0x0027};
const uint8_t HuffDecoderCommon::table1_0_outer_[128] = {
    0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,
    4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  8,  9,  9,
    9,  9,  10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18,
    18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27,
    28, 28, 29, 29, 30, 30, 31, 31, 32, 32, 33, 33, 34, 34, 35, 35, 36, 37, 38,
    39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
    58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
const uint8_t HuffDecoderCommon::table8_0_emit_[5] = {0x21, 0x22, 0x28, 0x29,
                                                      0x3f};
const uint8_t HuffDecoderCommon::table8_0_inner_[7] = {0x00, 0x04, 0x08, 0x0c,
                                                       0x10, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table9_0_emit_[8] = {0x21, 0x22, 0x28, 0x29,
                                                      0x3f, 0x27, 0x2b, 0x7c};
const uint8_t HuffDecoderCommon::table9_0_inner_[10] = {
    0x00, 0x01, 0x05, 0x09, 0x0d, 0x11, 0x15, 0x19, 0x1d, 0x02};
const uint8_t HuffDecoderCommon::table9_0_outer_[16] = {0, 1, 0, 2, 0, 3, 0, 4,
                                                        0, 5, 6, 7, 8, 0, 0, 9};
const uint8_t HuffDecoderCommon::table10_0_emit_[10] = {
    0x21, 0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e};
const uint8_t HuffDecoderCommon::table10_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x15,
    0x00, 0x19, 0x00, 0x1d, 0x21, 0x25, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table11_0_emit_[16] = {
    0x21, 0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c,
    0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e};
const uint8_t HuffDecoderCommon::table11_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x21, 0x00,
    0x25, 0x29, 0x2d, 0x31, 0x35, 0x39, 0x3d, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table12_0_emit_[18] = {
    0x21, 0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c, 0x23,
    0x3e, 0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d};
const uint8_t HuffDecoderCommon::table12_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x35,
    0x00, 0x39, 0x00, 0x3d, 0x41, 0x45, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table13_0_emit_[40] = {
    0x21, 0x30, 0x21, 0x31, 0x21, 0x32, 0x21, 0x61, 0x21, 0x63,
    0x21, 0x65, 0x21, 0x69, 0x21, 0x6f, 0x21, 0x73, 0x21, 0x74,
    0x22, 0x30, 0x22, 0x31, 0x22, 0x32, 0x22, 0x61, 0x22, 0x63,
    0x22, 0x65, 0x22, 0x69, 0x22, 0x6f, 0x22, 0x73, 0x22, 0x74};
const uint8_t HuffDecoderCommon::table13_0_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x50,
    0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52};
const uint8_t HuffDecoderCommon::table13_1_emit_[40] = {
    0x28, 0x30, 0x28, 0x31, 0x28, 0x32, 0x28, 0x61, 0x28, 0x63,
    0x28, 0x65, 0x28, 0x69, 0x28, 0x6f, 0x28, 0x73, 0x28, 0x74,
    0x29, 0x30, 0x29, 0x31, 0x29, 0x32, 0x29, 0x61, 0x29, 0x63,
    0x29, 0x65, 0x29, 0x69, 0x29, 0x6f, 0x29, 0x73, 0x29, 0x74};
const uint8_t HuffDecoderCommon::table13_2_emit_[22] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61, 0x3f, 0x63, 0x3f,
    0x65, 0x3f, 0x69, 0x3f, 0x6f, 0x3f, 0x73, 0x3f, 0x74, 0x27, 0x2b};
const uint8_t HuffDecoderCommon::table13_2_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x52, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x56};
const uint8_t HuffDecoderCommon::table13_3_emit_[14] = {
    0x7c, 0x23, 0x3e, 0x00, 0x24, 0x40, 0x5b,
    0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint8_t HuffDecoderCommon::table13_3_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x01,
    0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x16,
    0x01, 0x01, 0x01, 0x1a, 0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01,
    0x22, 0x01, 0x26, 0x01, 0x2a, 0x2e, 0x32, 0x36, 0x03};
const uint8_t* const HuffDecoderCommon::table13_emit_[4] = {
    table13_0_emit_,
    table13_1_emit_,
    table13_2_emit_,
    table13_3_emit_,
};
const uint8_t* const HuffDecoderCommon::table13_ops_[4] = {
    table13_0_ops_,
    table13_0_ops_,
    table13_2_ops_,
    table13_3_ops_,
};
const uint8_t HuffDecoderCommon::table14_0_emit_[72] = {
    0x21, 0x30, 0x21, 0x31, 0x21, 0x32, 0x21, 0x61, 0x21, 0x63, 0x21, 0x65,
    0x21, 0x69, 0x21, 0x6f, 0x21, 0x73, 0x21, 0x74, 0x21, 0x20, 0x21, 0x25,
    0x21, 0x2d, 0x21, 0x2e, 0x21, 0x2f, 0x21, 0x33, 0x21, 0x34, 0x21, 0x35,
    0x21, 0x36, 0x21, 0x37, 0x21, 0x38, 0x21, 0x39, 0x21, 0x3d, 0x21, 0x41,
    0x21, 0x5f, 0x21, 0x62, 0x21, 0x64, 0x21, 0x66, 0x21, 0x67, 0x21, 0x68,
    0x21, 0x6c, 0x21, 0x6d, 0x21, 0x6e, 0x21, 0x70, 0x21, 0x72, 0x21, 0x75};
const uint16_t HuffDecoderCommon::table14_0_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table14_1_emit_[72] = {
    0x22, 0x30, 0x22, 0x31, 0x22, 0x32, 0x22, 0x61, 0x22, 0x63, 0x22, 0x65,
    0x22, 0x69, 0x22, 0x6f, 0x22, 0x73, 0x22, 0x74, 0x22, 0x20, 0x22, 0x25,
    0x22, 0x2d, 0x22, 0x2e, 0x22, 0x2f, 0x22, 0x33, 0x22, 0x34, 0x22, 0x35,
    0x22, 0x36, 0x22, 0x37, 0x22, 0x38, 0x22, 0x39, 0x22, 0x3d, 0x22, 0x41,
    0x22, 0x5f, 0x22, 0x62, 0x22, 0x64, 0x22, 0x66, 0x22, 0x67, 0x22, 0x68,
    0x22, 0x6c, 0x22, 0x6d, 0x22, 0x6e, 0x22, 0x70, 0x22, 0x72, 0x22, 0x75};
const uint8_t HuffDecoderCommon::table14_2_emit_[72] = {
    0x28, 0x30, 0x28, 0x31, 0x28, 0x32, 0x28, 0x61, 0x28, 0x63, 0x28, 0x65,
    0x28, 0x69, 0x28, 0x6f, 0x28, 0x73, 0x28, 0x74, 0x28, 0x20, 0x28, 0x25,
    0x28, 0x2d, 0x28, 0x2e, 0x28, 0x2f, 0x28, 0x33, 0x28, 0x34, 0x28, 0x35,
    0x28, 0x36, 0x28, 0x37, 0x28, 0x38, 0x28, 0x39, 0x28, 0x3d, 0x28, 0x41,
    0x28, 0x5f, 0x28, 0x62, 0x28, 0x64, 0x28, 0x66, 0x28, 0x67, 0x28, 0x68,
    0x28, 0x6c, 0x28, 0x6d, 0x28, 0x6e, 0x28, 0x70, 0x28, 0x72, 0x28, 0x75};
const uint8_t HuffDecoderCommon::table14_3_emit_[72] = {
    0x29, 0x30, 0x29, 0x31, 0x29, 0x32, 0x29, 0x61, 0x29, 0x63, 0x29, 0x65,
    0x29, 0x69, 0x29, 0x6f, 0x29, 0x73, 0x29, 0x74, 0x29, 0x20, 0x29, 0x25,
    0x29, 0x2d, 0x29, 0x2e, 0x29, 0x2f, 0x29, 0x33, 0x29, 0x34, 0x29, 0x35,
    0x29, 0x36, 0x29, 0x37, 0x29, 0x38, 0x29, 0x39, 0x29, 0x3d, 0x29, 0x41,
    0x29, 0x5f, 0x29, 0x62, 0x29, 0x64, 0x29, 0x66, 0x29, 0x67, 0x29, 0x68,
    0x29, 0x6c, 0x29, 0x6d, 0x29, 0x6e, 0x29, 0x70, 0x29, 0x72, 0x29, 0x75};
const uint8_t HuffDecoderCommon::table14_4_emit_[72] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61, 0x3f, 0x63, 0x3f, 0x65,
    0x3f, 0x69, 0x3f, 0x6f, 0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20, 0x3f, 0x25,
    0x3f, 0x2d, 0x3f, 0x2e, 0x3f, 0x2f, 0x3f, 0x33, 0x3f, 0x34, 0x3f, 0x35,
    0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39, 0x3f, 0x3d, 0x3f, 0x41,
    0x3f, 0x5f, 0x3f, 0x62, 0x3f, 0x64, 0x3f, 0x66, 0x3f, 0x67, 0x3f, 0x68,
    0x3f, 0x6c, 0x3f, 0x6d, 0x3f, 0x6e, 0x3f, 0x70, 0x3f, 0x72, 0x3f, 0x75};
const uint8_t HuffDecoderCommon::table14_5_emit_[40] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61, 0x27, 0x63,
    0x27, 0x65, 0x27, 0x69, 0x27, 0x6f, 0x27, 0x73, 0x27, 0x74,
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61, 0x2b, 0x63,
    0x2b, 0x65, 0x2b, 0x69, 0x2b, 0x6f, 0x2b, 0x73, 0x2b, 0x74};
const uint16_t HuffDecoderCommon::table14_5_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table14_6_emit_[22] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c,
    0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x23, 0x3e};
const uint16_t HuffDecoderCommon::table14_6_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0056};
const uint8_t HuffDecoderCommon::table14_7_emit_[11] = {
    0x00, 0x24, 0x40, 0x5b, 0x5d, 0x7e, 0x5e, 0x7d, 0x3c, 0x60, 0x7b};
const uint16_t HuffDecoderCommon::table14_7_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x001e,
    0x0000, 0x0022, 0x0000, 0x0026, 0x0000, 0x002a, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table14_emit_[8] = {
    table14_0_emit_, table14_1_emit_, table14_2_emit_, table14_3_emit_,
    table14_4_emit_, table14_5_emit_, table14_6_emit_, table14_7_emit_,
};
const uint16_t* const HuffDecoderCommon::table14_ops_[8] = {
    table14_0_ops_, table14_0_ops_, table14_0_ops_, table14_0_ops_,
    table14_0_ops_, table14_5_ops_, table14_6_ops_, table14_7_ops_,
};
const uint8_t HuffDecoderCommon::table15_0_emit_[44] = {
    0x21, 0x30, 0x21, 0x31, 0x21, 0x32, 0x21, 0x61, 0x21, 0x63, 0x21,
    0x65, 0x21, 0x69, 0x21, 0x6f, 0x21, 0x73, 0x21, 0x74, 0x21, 0x20,
    0x21, 0x25, 0x21, 0x2d, 0x21, 0x2e, 0x21, 0x2f, 0x21, 0x33, 0x21,
    0x34, 0x21, 0x35, 0x21, 0x36, 0x21, 0x37, 0x21, 0x38, 0x21, 0x39};
const uint16_t HuffDecoderCommon::table15_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0051, 0x0000, 0x0059, 0x0000, 0x0061, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089,
    0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table15_1_emit_[92] = {
    0x21, 0x3d, 0x21, 0x41, 0x21, 0x5f, 0x21, 0x62, 0x21, 0x64, 0x21, 0x66,
    0x21, 0x67, 0x21, 0x68, 0x21, 0x6c, 0x21, 0x6d, 0x21, 0x6e, 0x21, 0x70,
    0x21, 0x72, 0x21, 0x75, 0x21, 0x3a, 0x21, 0x42, 0x21, 0x43, 0x21, 0x44,
    0x21, 0x45, 0x21, 0x46, 0x21, 0x47, 0x21, 0x48, 0x21, 0x49, 0x21, 0x4a,
    0x21, 0x4b, 0x21, 0x4c, 0x21, 0x4d, 0x21, 0x4e, 0x21, 0x4f, 0x21, 0x50,
    0x21, 0x51, 0x21, 0x52, 0x21, 0x53, 0x21, 0x54, 0x21, 0x55, 0x21, 0x56,
    0x21, 0x57, 0x21, 0x59, 0x21, 0x6a, 0x21, 0x6b, 0x21, 0x71, 0x21, 0x76,
    0x21, 0x77, 0x21, 0x78, 0x21, 0x79, 0x21, 0x7a};
const uint16_t HuffDecoderCommon::table15_1_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109,
    0x0111, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149,
    0x0151, 0x0159, 0x0161, 0x0169, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table15_2_emit_[44] = {
    0x22, 0x30, 0x22, 0x31, 0x22, 0x32, 0x22, 0x61, 0x22, 0x63, 0x22,
    0x65, 0x22, 0x69, 0x22, 0x6f, 0x22, 0x73, 0x22, 0x74, 0x22, 0x20,
    0x22, 0x25, 0x22, 0x2d, 0x22, 0x2e, 0x22, 0x2f, 0x22, 0x33, 0x22,
    0x34, 0x22, 0x35, 0x22, 0x36, 0x22, 0x37, 0x22, 0x38, 0x22, 0x39};
const uint8_t HuffDecoderCommon::table15_3_emit_[92] = {
    0x22, 0x3d, 0x22, 0x41, 0x22, 0x5f, 0x22, 0x62, 0x22, 0x64, 0x22, 0x66,
    0x22, 0x67, 0x22, 0x68, 0x22, 0x6c, 0x22, 0x6d, 0x22, 0x6e, 0x22, 0x70,
    0x22, 0x72, 0x22, 0x75, 0x22, 0x3a, 0x22, 0x42, 0x22, 0x43, 0x22, 0x44,
    0x22, 0x45, 0x22, 0x46, 0x22, 0x47, 0x22, 0x48, 0x22, 0x49, 0x22, 0x4a,
    0x22, 0x4b, 0x22, 0x4c, 0x22, 0x4d, 0x22, 0x4e, 0x22, 0x4f, 0x22, 0x50,
    0x22, 0x51, 0x22, 0x52, 0x22, 0x53, 0x22, 0x54, 0x22, 0x55, 0x22, 0x56,
    0x22, 0x57, 0x22, 0x59, 0x22, 0x6a, 0x22, 0x6b, 0x22, 0x71, 0x22, 0x76,
    0x22, 0x77, 0x22, 0x78, 0x22, 0x79, 0x22, 0x7a};
const uint8_t HuffDecoderCommon::table15_4_emit_[44] = {
    0x28, 0x30, 0x28, 0x31, 0x28, 0x32, 0x28, 0x61, 0x28, 0x63, 0x28,
    0x65, 0x28, 0x69, 0x28, 0x6f, 0x28, 0x73, 0x28, 0x74, 0x28, 0x20,
    0x28, 0x25, 0x28, 0x2d, 0x28, 0x2e, 0x28, 0x2f, 0x28, 0x33, 0x28,
    0x34, 0x28, 0x35, 0x28, 0x36, 0x28, 0x37, 0x28, 0x38, 0x28, 0x39};
const uint8_t HuffDecoderCommon::table15_5_emit_[92] = {
    0x28, 0x3d, 0x28, 0x41, 0x28, 0x5f, 0x28, 0x62, 0x28, 0x64, 0x28, 0x66,
    0x28, 0x67, 0x28, 0x68, 0x28, 0x6c, 0x28, 0x6d, 0x28, 0x6e, 0x28, 0x70,
    0x28, 0x72, 0x28, 0x75, 0x28, 0x3a, 0x28, 0x42, 0x28, 0x43, 0x28, 0x44,
    0x28, 0x45, 0x28, 0x46, 0x28, 0x47, 0x28, 0x48, 0x28, 0x49, 0x28, 0x4a,
    0x28, 0x4b, 0x28, 0x4c, 0x28, 0x4d, 0x28, 0x4e, 0x28, 0x4f, 0x28, 0x50,
    0x28, 0x51, 0x28, 0x52, 0x28, 0x53, 0x28, 0x54, 0x28, 0x55, 0x28, 0x56,
    0x28, 0x57, 0x28, 0x59, 0x28, 0x6a, 0x28, 0x6b, 0x28, 0x71, 0x28, 0x76,
    0x28, 0x77, 0x28, 0x78, 0x28, 0x79, 0x28, 0x7a};
const uint8_t HuffDecoderCommon::table15_6_emit_[44] = {
    0x29, 0x30, 0x29, 0x31, 0x29, 0x32, 0x29, 0x61, 0x29, 0x63, 0x29,
    0x65, 0x29, 0x69, 0x29, 0x6f, 0x29, 0x73, 0x29, 0x74, 0x29, 0x20,
    0x29, 0x25, 0x29, 0x2d, 0x29, 0x2e, 0x29, 0x2f, 0x29, 0x33, 0x29,
    0x34, 0x29, 0x35, 0x29, 0x36, 0x29, 0x37, 0x29, 0x38, 0x29, 0x39};
const uint8_t HuffDecoderCommon::table15_7_emit_[92] = {
    0x29, 0x3d, 0x29, 0x41, 0x29, 0x5f, 0x29, 0x62, 0x29, 0x64, 0x29, 0x66,
    0x29, 0x67, 0x29, 0x68, 0x29, 0x6c, 0x29, 0x6d, 0x29, 0x6e, 0x29, 0x70,
    0x29, 0x72, 0x29, 0x75, 0x29, 0x3a, 0x29, 0x42, 0x29, 0x43, 0x29, 0x44,
    0x29, 0x45, 0x29, 0x46, 0x29, 0x47, 0x29, 0x48, 0x29, 0x49, 0x29, 0x4a,
    0x29, 0x4b, 0x29, 0x4c, 0x29, 0x4d, 0x29, 0x4e, 0x29, 0x4f, 0x29, 0x50,
    0x29, 0x51, 0x29, 0x52, 0x29, 0x53, 0x29, 0x54, 0x29, 0x55, 0x29, 0x56,
    0x29, 0x57, 0x29, 0x59, 0x29, 0x6a, 0x29, 0x6b, 0x29, 0x71, 0x29, 0x76,
    0x29, 0x77, 0x29, 0x78, 0x29, 0x79, 0x29, 0x7a};
const uint8_t HuffDecoderCommon::table15_8_emit_[44] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61, 0x3f, 0x63, 0x3f,
    0x65, 0x3f, 0x69, 0x3f, 0x6f, 0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20,
    0x3f, 0x25, 0x3f, 0x2d, 0x3f, 0x2e, 0x3f, 0x2f, 0x3f, 0x33, 0x3f,
    0x34, 0x3f, 0x35, 0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table15_9_emit_[92] = {
    0x3f, 0x3d, 0x3f, 0x41, 0x3f, 0x5f, 0x3f, 0x62, 0x3f, 0x64, 0x3f, 0x66,
    0x3f, 0x67, 0x3f, 0x68, 0x3f, 0x6c, 0x3f, 0x6d, 0x3f, 0x6e, 0x3f, 0x70,
    0x3f, 0x72, 0x3f, 0x75, 0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44,
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48, 0x3f, 0x49, 0x3f, 0x4a,
    0x3f, 0x4b, 0x3f, 0x4c, 0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f, 0x3f, 0x50,
    0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54, 0x3f, 0x55, 0x3f, 0x56,
    0x3f, 0x57, 0x3f, 0x59, 0x3f, 0x6a, 0x3f, 0x6b, 0x3f, 0x71, 0x3f, 0x76,
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a};
const uint8_t HuffDecoderCommon::table15_10_emit_[72] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61, 0x27, 0x63, 0x27, 0x65,
    0x27, 0x69, 0x27, 0x6f, 0x27, 0x73, 0x27, 0x74, 0x27, 0x20, 0x27, 0x25,
    0x27, 0x2d, 0x27, 0x2e, 0x27, 0x2f, 0x27, 0x33, 0x27, 0x34, 0x27, 0x35,
    0x27, 0x36, 0x27, 0x37, 0x27, 0x38, 0x27, 0x39, 0x27, 0x3d, 0x27, 0x41,
    0x27, 0x5f, 0x27, 0x62, 0x27, 0x64, 0x27, 0x66, 0x27, 0x67, 0x27, 0x68,
    0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70, 0x27, 0x72, 0x27, 0x75};
const uint8_t HuffDecoderCommon::table15_11_emit_[72] = {
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61, 0x2b, 0x63, 0x2b, 0x65,
    0x2b, 0x69, 0x2b, 0x6f, 0x2b, 0x73, 0x2b, 0x74, 0x2b, 0x20, 0x2b, 0x25,
    0x2b, 0x2d, 0x2b, 0x2e, 0x2b, 0x2f, 0x2b, 0x33, 0x2b, 0x34, 0x2b, 0x35,
    0x2b, 0x36, 0x2b, 0x37, 0x2b, 0x38, 0x2b, 0x39, 0x2b, 0x3d, 0x2b, 0x41,
    0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64, 0x2b, 0x66, 0x2b, 0x67, 0x2b, 0x68,
    0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70, 0x2b, 0x72, 0x2b, 0x75};
const uint8_t HuffDecoderCommon::table15_12_emit_[72] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c, 0x65,
    0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20, 0x7c, 0x25,
    0x7c, 0x2d, 0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c, 0x34, 0x7c, 0x35,
    0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39, 0x7c, 0x3d, 0x7c, 0x41,
    0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66, 0x7c, 0x67, 0x7c, 0x68,
    0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70, 0x7c, 0x72, 0x7c, 0x75};
const uint8_t HuffDecoderCommon::table15_13_emit_[40] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63,
    0x23, 0x65, 0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74,
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63,
    0x3e, 0x65, 0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74};
const uint8_t HuffDecoderCommon::table15_14_emit_[4] = {0x00, 0x24, 0x40, 0x5b};
const uint16_t HuffDecoderCommon::table15_14_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e};
const uint8_t HuffDecoderCommon::table15_15_emit_[7] = {0x5d, 0x7e, 0x5e, 0x7d,
                                                        0x3c, 0x60, 0x7b};
const uint16_t HuffDecoderCommon::table15_15_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table15_emit_[16] = {
    table15_0_emit_,  table15_1_emit_,  table15_2_emit_,  table15_3_emit_,
    table15_4_emit_,  table15_5_emit_,  table15_6_emit_,  table15_7_emit_,
    table15_8_emit_,  table15_9_emit_,  table15_10_emit_, table15_11_emit_,
    table15_12_emit_, table15_13_emit_, table15_14_emit_, table15_15_emit_,
};
const uint16_t* const HuffDecoderCommon::table15_ops_[16] = {
    table15_0_ops_, table15_1_ops_, table15_0_ops_,  table15_1_ops_,
    table15_0_ops_, table15_1_ops_, table15_0_ops_,  table15_1_ops_,
    table15_0_ops_, table15_1_ops_, table14_0_ops_,  table14_0_ops_,
    table14_0_ops_, table14_5_ops_, table15_14_ops_, table15_15_ops_,
};
const uint8_t HuffDecoderCommon::table16_0_emit_[16] = {
    0x21, 0x30, 0x21, 0x31, 0x21, 0x32, 0x21, 0x61,
    0x21, 0x63, 0x21, 0x65, 0x21, 0x69, 0x21, 0x6f};
const uint16_t HuffDecoderCommon::table16_0_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0039};
const uint8_t HuffDecoderCommon::table16_1_emit_[28] = {
    0x21, 0x73, 0x21, 0x74, 0x21, 0x20, 0x21, 0x25, 0x21, 0x2d,
    0x21, 0x2e, 0x21, 0x2f, 0x21, 0x33, 0x21, 0x34, 0x21, 0x35,
    0x21, 0x36, 0x21, 0x37, 0x21, 0x38, 0x21, 0x39};
const uint16_t HuffDecoderCommon::table16_1_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069};
const uint8_t HuffDecoderCommon::table16_2_emit_[36] = {
    0x21, 0x3d, 0x21, 0x41, 0x21, 0x5f, 0x21, 0x62, 0x21, 0x64, 0x21, 0x66,
    0x21, 0x67, 0x21, 0x68, 0x21, 0x6c, 0x21, 0x6d, 0x21, 0x6e, 0x21, 0x70,
    0x21, 0x72, 0x21, 0x75, 0x21, 0x3a, 0x21, 0x42, 0x21, 0x43, 0x21, 0x44};
const uint16_t HuffDecoderCommon::table16_2_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0039,
    0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000, 0x0000, 0x0049,
    0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059,
    0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069,
    0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000, 0x0089};
const uint8_t HuffDecoderCommon::table16_3_emit_[68] = {
    0x21, 0x45, 0x21, 0x46, 0x21, 0x47, 0x21, 0x48, 0x21, 0x49, 0x21, 0x4a,
    0x21, 0x4b, 0x21, 0x4c, 0x21, 0x4d, 0x21, 0x4e, 0x21, 0x4f, 0x21, 0x50,
    0x21, 0x51, 0x21, 0x52, 0x21, 0x53, 0x21, 0x54, 0x21, 0x55, 0x21, 0x56,
    0x21, 0x57, 0x21, 0x59, 0x21, 0x6a, 0x21, 0x6b, 0x21, 0x71, 0x21, 0x76,
    0x21, 0x77, 0x21, 0x78, 0x21, 0x79, 0x21, 0x7a, 0x21, 0x26, 0x21, 0x2a,
    0x21, 0x2c, 0x21, 0x3b, 0x21, 0x58, 0x21, 0x5a};
const uint16_t HuffDecoderCommon::table16_3_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059,
    0x0000, 0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079,
    0x0000, 0x0081, 0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099,
    0x0000, 0x00a1, 0x0000, 0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9,
    0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000, 0x00d1, 0x0000, 0x00d9,
    0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table16_4_emit_[16] = {
    0x22, 0x30, 0x22, 0x31, 0x22, 0x32, 0x22, 0x61,
    0x22, 0x63, 0x22, 0x65, 0x22, 0x69, 0x22, 0x6f};
const uint8_t HuffDecoderCommon::table16_5_emit_[28] = {
    0x22, 0x73, 0x22, 0x74, 0x22, 0x20, 0x22, 0x25, 0x22, 0x2d,
    0x22, 0x2e, 0x22, 0x2f, 0x22, 0x33, 0x22, 0x34, 0x22, 0x35,
    0x22, 0x36, 0x22, 0x37, 0x22, 0x38, 0x22, 0x39};
const uint8_t HuffDecoderCommon::table16_6_emit_[36] = {
    0x22, 0x3d, 0x22, 0x41, 0x22, 0x5f, 0x22, 0x62, 0x22, 0x64, 0x22, 0x66,
    0x22, 0x67, 0x22, 0x68, 0x22, 0x6c, 0x22, 0x6d, 0x22, 0x6e, 0x22, 0x70,
    0x22, 0x72, 0x22, 0x75, 0x22, 0x3a, 0x22, 0x42, 0x22, 0x43, 0x22, 0x44};
const uint8_t HuffDecoderCommon::table16_7_emit_[68] = {
    0x22, 0x45, 0x22, 0x46, 0x22, 0x47, 0x22, 0x48, 0x22, 0x49, 0x22, 0x4a,
    0x22, 0x4b, 0x22, 0x4c, 0x22, 0x4d, 0x22, 0x4e, 0x22, 0x4f, 0x22, 0x50,
    0x22, 0x51, 0x22, 0x52, 0x22, 0x53, 0x22, 0x54, 0x22, 0x55, 0x22, 0x56,
    0x22, 0x57, 0x22, 0x59, 0x22, 0x6a, 0x22, 0x6b, 0x22, 0x71, 0x22, 0x76,
    0x22, 0x77, 0x22, 0x78, 0x22, 0x79, 0x22, 0x7a, 0x22, 0x26, 0x22, 0x2a,
    0x22, 0x2c, 0x22, 0x3b, 0x22, 0x58, 0x22, 0x5a};
const uint8_t HuffDecoderCommon::table16_8_emit_[16] = {
    0x28, 0x30, 0x28, 0x31, 0x28, 0x32, 0x28, 0x61,
    0x28, 0x63, 0x28, 0x65, 0x28, 0x69, 0x28, 0x6f};
const uint8_t HuffDecoderCommon::table16_9_emit_[28] = {
    0x28, 0x73, 0x28, 0x74, 0x28, 0x20, 0x28, 0x25, 0x28, 0x2d,
    0x28, 0x2e, 0x28, 0x2f, 0x28, 0x33, 0x28, 0x34, 0x28, 0x35,
    0x28, 0x36, 0x28, 0x37, 0x28, 0x38, 0x28, 0x39};
const uint8_t HuffDecoderCommon::table16_10_emit_[36] = {
    0x28, 0x3d, 0x28, 0x41, 0x28, 0x5f, 0x28, 0x62, 0x28, 0x64, 0x28, 0x66,
    0x28, 0x67, 0x28, 0x68, 0x28, 0x6c, 0x28, 0x6d, 0x28, 0x6e, 0x28, 0x70,
    0x28, 0x72, 0x28, 0x75, 0x28, 0x3a, 0x28, 0x42, 0x28, 0x43, 0x28, 0x44};
const uint8_t HuffDecoderCommon::table16_11_emit_[68] = {
    0x28, 0x45, 0x28, 0x46, 0x28, 0x47, 0x28, 0x48, 0x28, 0x49, 0x28, 0x4a,
    0x28, 0x4b, 0x28, 0x4c, 0x28, 0x4d, 0x28, 0x4e, 0x28, 0x4f, 0x28, 0x50,
    0x28, 0x51, 0x28, 0x52, 0x28, 0x53, 0x28, 0x54, 0x28, 0x55, 0x28, 0x56,
    0x28, 0x57, 0x28, 0x59, 0x28, 0x6a, 0x28, 0x6b, 0x28, 0x71, 0x28, 0x76,
    0x28, 0x77, 0x28, 0x78, 0x28, 0x79, 0x28, 0x7a, 0x28, 0x26, 0x28, 0x2a,
    0x28, 0x2c, 0x28, 0x3b, 0x28, 0x58, 0x28, 0x5a};
const uint8_t HuffDecoderCommon::table16_12_emit_[16] = {
    0x29, 0x30, 0x29, 0x31, 0x29, 0x32, 0x29, 0x61,
    0x29, 0x63, 0x29, 0x65, 0x29, 0x69, 0x29, 0x6f};
const uint8_t HuffDecoderCommon::table16_13_emit_[28] = {
    0x29, 0x73, 0x29, 0x74, 0x29, 0x20, 0x29, 0x25, 0x29, 0x2d,
    0x29, 0x2e, 0x29, 0x2f, 0x29, 0x33, 0x29, 0x34, 0x29, 0x35,
    0x29, 0x36, 0x29, 0x37, 0x29, 0x38, 0x29, 0x39};
const uint8_t HuffDecoderCommon::table16_14_emit_[36] = {
    0x29, 0x3d, 0x29, 0x41, 0x29, 0x5f, 0x29, 0x62, 0x29, 0x64, 0x29, 0x66,
    0x29, 0x67, 0x29, 0x68, 0x29, 0x6c, 0x29, 0x6d, 0x29, 0x6e, 0x29, 0x70,
    0x29, 0x72, 0x29, 0x75, 0x29, 0x3a, 0x29, 0x42, 0x29, 0x43, 0x29, 0x44};
const uint8_t HuffDecoderCommon::table16_15_emit_[68] = {
    0x29, 0x45, 0x29, 0x46, 0x29, 0x47, 0x29, 0x48, 0x29, 0x49, 0x29, 0x4a,
    0x29, 0x4b, 0x29, 0x4c, 0x29, 0x4d, 0x29, 0x4e, 0x29, 0x4f, 0x29, 0x50,
    0x29, 0x51, 0x29, 0x52, 0x29, 0x53, 0x29, 0x54, 0x29, 0x55, 0x29, 0x56,
    0x29, 0x57, 0x29, 0x59, 0x29, 0x6a, 0x29, 0x6b, 0x29, 0x71, 0x29, 0x76,
    0x29, 0x77, 0x29, 0x78, 0x29, 0x79, 0x29, 0x7a, 0x29, 0x26, 0x29, 0x2a,
    0x29, 0x2c, 0x29, 0x3b, 0x29, 0x58, 0x29, 0x5a};
const uint8_t HuffDecoderCommon::table16_16_emit_[16] = {
    0x3f, 0x30, 0x3f, 0x31, 0x3f, 0x32, 0x3f, 0x61,
    0x3f, 0x63, 0x3f, 0x65, 0x3f, 0x69, 0x3f, 0x6f};
const uint8_t HuffDecoderCommon::table16_17_emit_[28] = {
    0x3f, 0x73, 0x3f, 0x74, 0x3f, 0x20, 0x3f, 0x25, 0x3f, 0x2d,
    0x3f, 0x2e, 0x3f, 0x2f, 0x3f, 0x33, 0x3f, 0x34, 0x3f, 0x35,
    0x3f, 0x36, 0x3f, 0x37, 0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table16_18_emit_[36] = {
    0x3f, 0x3d, 0x3f, 0x41, 0x3f, 0x5f, 0x3f, 0x62, 0x3f, 0x64, 0x3f, 0x66,
    0x3f, 0x67, 0x3f, 0x68, 0x3f, 0x6c, 0x3f, 0x6d, 0x3f, 0x6e, 0x3f, 0x70,
    0x3f, 0x72, 0x3f, 0x75, 0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44};
const uint8_t HuffDecoderCommon::table16_19_emit_[68] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48, 0x3f, 0x49, 0x3f, 0x4a,
    0x3f, 0x4b, 0x3f, 0x4c, 0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f, 0x3f, 0x50,
    0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54, 0x3f, 0x55, 0x3f, 0x56,
    0x3f, 0x57, 0x3f, 0x59, 0x3f, 0x6a, 0x3f, 0x6b, 0x3f, 0x71, 0x3f, 0x76,
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a, 0x3f, 0x26, 0x3f, 0x2a,
    0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f, 0x5a};
const uint8_t HuffDecoderCommon::table16_20_emit_[44] = {
    0x27, 0x30, 0x27, 0x31, 0x27, 0x32, 0x27, 0x61, 0x27, 0x63, 0x27,
    0x65, 0x27, 0x69, 0x27, 0x6f, 0x27, 0x73, 0x27, 0x74, 0x27, 0x20,
    0x27, 0x25, 0x27, 0x2d, 0x27, 0x2e, 0x27, 0x2f, 0x27, 0x33, 0x27,
    0x34, 0x27, 0x35, 0x27, 0x36, 0x27, 0x37, 0x27, 0x38, 0x27, 0x39};
const uint8_t HuffDecoderCommon::table16_21_emit_[92] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62, 0x27, 0x64, 0x27, 0x66,
    0x27, 0x67, 0x27, 0x68, 0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70,
    0x27, 0x72, 0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44,
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48, 0x27, 0x49, 0x27, 0x4a,
    0x27, 0x4b, 0x27, 0x4c, 0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f, 0x27, 0x50,
    0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54, 0x27, 0x55, 0x27, 0x56,
    0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b, 0x27, 0x71, 0x27, 0x76,
    0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a};
const uint8_t HuffDecoderCommon::table16_22_emit_[44] = {
    0x2b, 0x30, 0x2b, 0x31, 0x2b, 0x32, 0x2b, 0x61, 0x2b, 0x63, 0x2b,
    0x65, 0x2b, 0x69, 0x2b, 0x6f, 0x2b, 0x73, 0x2b, 0x74, 0x2b, 0x20,
    0x2b, 0x25, 0x2b, 0x2d, 0x2b, 0x2e, 0x2b, 0x2f, 0x2b, 0x33, 0x2b,
    0x34, 0x2b, 0x35, 0x2b, 0x36, 0x2b, 0x37, 0x2b, 0x38, 0x2b, 0x39};
const uint8_t HuffDecoderCommon::table16_23_emit_[92] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64, 0x2b, 0x66,
    0x2b, 0x67, 0x2b, 0x68, 0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70,
    0x2b, 0x72, 0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44,
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48, 0x2b, 0x49, 0x2b, 0x4a,
    0x2b, 0x4b, 0x2b, 0x4c, 0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f, 0x2b, 0x50,
    0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54, 0x2b, 0x55, 0x2b, 0x56,
    0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b, 0x2b, 0x71, 0x2b, 0x76,
    0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a};
const uint8_t HuffDecoderCommon::table16_24_emit_[44] = {
    0x7c, 0x30, 0x7c, 0x31, 0x7c, 0x32, 0x7c, 0x61, 0x7c, 0x63, 0x7c,
    0x65, 0x7c, 0x69, 0x7c, 0x6f, 0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20,
    0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e, 0x7c, 0x2f, 0x7c, 0x33, 0x7c,
    0x34, 0x7c, 0x35, 0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table16_25_emit_[92] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44,
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a};
const uint8_t HuffDecoderCommon::table16_26_emit_[72] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23, 0x65,
    0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25,
    0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39, 0x23, 0x3d, 0x23, 0x41,
    0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66, 0x23, 0x67, 0x23, 0x68,
    0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70, 0x23, 0x72, 0x23, 0x75};
const uint8_t HuffDecoderCommon::table16_27_emit_[72] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e, 0x65,
    0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25,
    0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39, 0x3e, 0x3d, 0x3e, 0x41,
    0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66, 0x3e, 0x67, 0x3e, 0x68,
    0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70, 0x3e, 0x72, 0x3e, 0x75};
const uint8_t HuffDecoderCommon::table16_28_emit_[40] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63,
    0x00, 0x65, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74,
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63,
    0x24, 0x65, 0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74};
const uint8_t HuffDecoderCommon::table16_29_emit_[40] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63,
    0x40, 0x65, 0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74,
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63,
    0x5b, 0x65, 0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74};
const uint8_t HuffDecoderCommon::table16_30_emit_[40] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63,
    0x5d, 0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74,
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63,
    0x7e, 0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74};
const uint8_t HuffDecoderCommon::table16_31_emit_[5] = {0x5e, 0x7d, 0x3c, 0x60,
                                                        0x7b};
const uint16_t HuffDecoderCommon::table16_31_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table16_emit_[32] = {
    table16_0_emit_,  table16_1_emit_,  table16_2_emit_,  table16_3_emit_,
    table16_4_emit_,  table16_5_emit_,  table16_6_emit_,  table16_7_emit_,
    table16_8_emit_,  table16_9_emit_,  table16_10_emit_, table16_11_emit_,
    table16_12_emit_, table16_13_emit_, table16_14_emit_, table16_15_emit_,
    table16_16_emit_, table16_17_emit_, table16_18_emit_, table16_19_emit_,
    table16_20_emit_, table16_21_emit_, table16_22_emit_, table16_23_emit_,
    table16_24_emit_, table16_25_emit_, table16_26_emit_, table16_27_emit_,
    table16_28_emit_, table16_29_emit_, table16_30_emit_, table16_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table16_ops_[32] = {
    table16_0_ops_, table16_1_ops_, table16_2_ops_, table16_3_ops_,
    table16_0_ops_, table16_1_ops_, table16_2_ops_, table16_3_ops_,
    table16_0_ops_, table16_1_ops_, table16_2_ops_, table16_3_ops_,
    table16_0_ops_, table16_1_ops_, table16_2_ops_, table16_3_ops_,
    table16_0_ops_, table16_1_ops_, table16_2_ops_, table16_3_ops_,
    table15_0_ops_, table15_1_ops_, table15_0_ops_, table15_1_ops_,
    table15_0_ops_, table15_1_ops_, table14_0_ops_, table14_0_ops_,
    table14_5_ops_, table14_5_ops_, table14_5_ops_, table16_31_ops_,
};
const uint16_t HuffDecoderCommon::table17_0_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0019, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0021, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0039};
const uint16_t HuffDecoderCommon::table17_1_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0031,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0041, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0069};
const uint16_t HuffDecoderCommon::table17_2_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0069, 0x0000, 0x0000, 0x0000, 0x0071, 0x0000,
    0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000, 0x0081, 0x0000, 0x0000,
    0x0000, 0x0089};
const uint16_t HuffDecoderCommon::table17_3_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0031, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000,
    0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000,
    0x0000, 0x0069, 0x0000, 0x0000, 0x0000, 0x0071, 0x0000, 0x0000, 0x0000,
    0x0079, 0x0000, 0x0000, 0x0000, 0x0081, 0x0000, 0x0000, 0x0000, 0x0089,
    0x0000, 0x0000, 0x0000, 0x0091, 0x0000, 0x0000, 0x0000, 0x0099, 0x0000,
    0x0000, 0x0000, 0x00a1, 0x0000, 0x0000, 0x0000, 0x00a9, 0x0000, 0x0000,
    0x0000, 0x00b1, 0x0000, 0x0000, 0x0000, 0x00b9, 0x0000, 0x0000, 0x0000,
    0x00c1, 0x0000, 0x0000, 0x0000, 0x00c9, 0x0000, 0x0000, 0x0000, 0x00d1,
    0x0000, 0x0000, 0x0000, 0x00d9, 0x0000, 0x00e1, 0x0000, 0x00e9, 0x0000,
    0x00f1, 0x0000, 0x00f9, 0x0000, 0x0101, 0x0000, 0x0109, 0x0000, 0x0000,
    0x0000, 0x0002};
const uint16_t HuffDecoderCommon::table17_20_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0031, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0039, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0049, 0x0000,
    0x0000, 0x0000, 0x0051, 0x0000, 0x0000, 0x0000, 0x0059, 0x0000, 0x0000,
    0x0000, 0x0061, 0x0000, 0x0000, 0x0000, 0x0069, 0x0000, 0x0000, 0x0000,
    0x0071, 0x0000, 0x0000, 0x0000, 0x0079, 0x0000, 0x0000, 0x0000, 0x0081,
    0x0000, 0x0000, 0x0000, 0x0089, 0x0000, 0x0000, 0x0000, 0x0091, 0x0000,
    0x0000, 0x0000, 0x0099, 0x0000, 0x0000, 0x0000, 0x00a1, 0x0000, 0x0000,
    0x0000, 0x00a9};
const uint8_t HuffDecoderCommon::table17_21_emit_[104] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62, 0x27, 0x64, 0x27, 0x66,
    0x27, 0x67, 0x27, 0x68, 0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70,
    0x27, 0x72, 0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44,
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48, 0x27, 0x49, 0x27, 0x4a,
    0x27, 0x4b, 0x27, 0x4c, 0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f, 0x27, 0x50,
    0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54, 0x27, 0x55, 0x27, 0x56,
    0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b, 0x27, 0x71, 0x27, 0x76,
    0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a, 0x27, 0x26, 0x27, 0x2a,
    0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27, 0x5a};
const uint16_t HuffDecoderCommon::table17_21_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0031, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0000, 0x0000, 0x0051, 0x0000,
    0x0000, 0x0000, 0x0059, 0x0000, 0x0000, 0x0000, 0x0061, 0x0000, 0x0000,
    0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081, 0x0000,
    0x0089, 0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000, 0x00a9,
    0x0000, 0x00b1, 0x0000, 0x00b9, 0x0000, 0x00c1, 0x0000, 0x00c9, 0x0000,
    0x00d1, 0x0000, 0x00d9, 0x0000, 0x00e1, 0x0000, 0x00e9, 0x0000, 0x00f1,
    0x0000, 0x00f9, 0x0000, 0x0101, 0x0000, 0x0109, 0x0000, 0x0111, 0x0000,
    0x0119, 0x0000, 0x0121, 0x0000, 0x0129, 0x0000, 0x0131, 0x0000, 0x0139,
    0x0000, 0x0141, 0x0000, 0x0149, 0x0000, 0x0151, 0x0000, 0x0159, 0x0000,
    0x0161, 0x0000, 0x0169, 0x0171, 0x0179, 0x0181, 0x0189, 0x0191, 0x0199,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table17_23_emit_[104] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62, 0x2b, 0x64, 0x2b, 0x66,
    0x2b, 0x67, 0x2b, 0x68, 0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70,
    0x2b, 0x72, 0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44,
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48, 0x2b, 0x49, 0x2b, 0x4a,
    0x2b, 0x4b, 0x2b, 0x4c, 0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f, 0x2b, 0x50,
    0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54, 0x2b, 0x55, 0x2b, 0x56,
    0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b, 0x2b, 0x71, 0x2b, 0x76,
    0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a, 0x2b, 0x26, 0x2b, 0x2a,
    0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b, 0x5a};
const uint8_t HuffDecoderCommon::table17_25_emit_[104] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62, 0x7c, 0x64, 0x7c, 0x66,
    0x7c, 0x67, 0x7c, 0x68, 0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70,
    0x7c, 0x72, 0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44,
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c, 0x4a,
    0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f, 0x7c, 0x50,
    0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54, 0x7c, 0x55, 0x7c, 0x56,
    0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b, 0x7c, 0x71, 0x7c, 0x76,
    0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a, 0x7c, 0x26, 0x7c, 0x2a,
    0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a};
const uint8_t HuffDecoderCommon::table17_26_emit_[136] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61, 0x23, 0x63, 0x23, 0x65,
    0x23, 0x69, 0x23, 0x6f, 0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25,
    0x23, 0x2d, 0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39, 0x23, 0x3d, 0x23, 0x41,
    0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66, 0x23, 0x67, 0x23, 0x68,
    0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70, 0x23, 0x72, 0x23, 0x75,
    0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44, 0x23, 0x45, 0x23, 0x46,
    0x23, 0x47, 0x23, 0x48, 0x23, 0x49, 0x23, 0x4a, 0x23, 0x4b, 0x23, 0x4c,
    0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f, 0x23, 0x50, 0x23, 0x51, 0x23, 0x52,
    0x23, 0x53, 0x23, 0x54, 0x23, 0x55, 0x23, 0x56, 0x23, 0x57, 0x23, 0x59,
    0x23, 0x6a, 0x23, 0x6b, 0x23, 0x71, 0x23, 0x76, 0x23, 0x77, 0x23, 0x78,
    0x23, 0x79, 0x23, 0x7a};
const uint16_t HuffDecoderCommon::table17_26_ops_[128] = {
    0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0000, 0x0009, 0x0000,
    0x0000, 0x0000, 0x0011, 0x0000, 0x0000, 0x0000, 0x0019, 0x0000, 0x0000,
    0x0000, 0x0021, 0x0000, 0x0000, 0x0000, 0x0029, 0x0000, 0x0000, 0x0000,
    0x0031, 0x0000, 0x0000, 0x0000, 0x0039, 0x0000, 0x0000, 0x0000, 0x0041,
    0x0000, 0x0000, 0x0000, 0x0049, 0x0000, 0x0051, 0x0000, 0x0059, 0x0000,
    0x0061, 0x0000, 0x0069, 0x0000, 0x0071, 0x0000, 0x0079, 0x0000, 0x0081,
    0x0000, 0x0089, 0x0000, 0x0091, 0x0000, 0x0099, 0x0000, 0x00a1, 0x0000,
    0x00a9, 0x0000, 0x00b1, 0x0000, 0x00b9, 0x0000, 0x00c1, 0x0000, 0x00c9,
    0x0000, 0x00d1, 0x0000, 0x00d9, 0x0000, 0x00e1, 0x0000, 0x00e9, 0x0000,
    0x00f1, 0x0000, 0x00f9, 0x0000, 0x0101, 0x0000, 0x0109, 0x0000, 0x0111,
    0x0000, 0x0119, 0x0121, 0x0129, 0x0131, 0x0139, 0x0141, 0x0149, 0x0151,
    0x0159, 0x0161, 0x0169, 0x0171, 0x0179, 0x0181, 0x0189, 0x0191, 0x0199,
    0x01a1, 0x01a9, 0x01b1, 0x01b9, 0x01c1, 0x01c9, 0x01d1, 0x01d9, 0x01e1,
    0x01e9, 0x01f1, 0x01f9, 0x0201, 0x0209, 0x0211, 0x0219, 0x0000, 0x0000,
    0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table17_27_emit_[136] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61, 0x3e, 0x63, 0x3e, 0x65,
    0x3e, 0x69, 0x3e, 0x6f, 0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25,
    0x3e, 0x2d, 0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39, 0x3e, 0x3d, 0x3e, 0x41,
    0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66, 0x3e, 0x67, 0x3e, 0x68,
    0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70, 0x3e, 0x72, 0x3e, 0x75,
    0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44, 0x3e, 0x45, 0x3e, 0x46,
    0x3e, 0x47, 0x3e, 0x48, 0x3e, 0x49, 0x3e, 0x4a, 0x3e, 0x4b, 0x3e, 0x4c,
    0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f, 0x3e, 0x50, 0x3e, 0x51, 0x3e, 0x52,
    0x3e, 0x53, 0x3e, 0x54, 0x3e, 0x55, 0x3e, 0x56, 0x3e, 0x57, 0x3e, 0x59,
    0x3e, 0x6a, 0x3e, 0x6b, 0x3e, 0x71, 0x3e, 0x76, 0x3e, 0x77, 0x3e, 0x78,
    0x3e, 0x79, 0x3e, 0x7a};
const uint8_t HuffDecoderCommon::table17_28_emit_[144] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63, 0x00, 0x65,
    0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74, 0x00, 0x20, 0x00, 0x25,
    0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35,
    0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41,
    0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66, 0x00, 0x67, 0x00, 0x68,
    0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70, 0x00, 0x72, 0x00, 0x75,
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63, 0x24, 0x65,
    0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74, 0x24, 0x20, 0x24, 0x25,
    0x24, 0x2d, 0x24, 0x2e, 0x24, 0x2f, 0x24, 0x33, 0x24, 0x34, 0x24, 0x35,
    0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39, 0x24, 0x3d, 0x24, 0x41,
    0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66, 0x24, 0x67, 0x24, 0x68,
    0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70, 0x24, 0x72, 0x24, 0x75};
const uint16_t HuffDecoderCommon::table17_28_ops_[128] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019, 0x0000,
    0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039, 0x0000, 0x0041,
    0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081,
    0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9, 0x00b1, 0x00b9, 0x00c1, 0x00c9,
    0x00d1, 0x00d9, 0x00e1, 0x00e9, 0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111,
    0x0119, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0002, 0x0000, 0x0121, 0x0000, 0x0129, 0x0000, 0x0131, 0x0000, 0x0139,
    0x0000, 0x0141, 0x0000, 0x0149, 0x0000, 0x0151, 0x0000, 0x0159, 0x0000,
    0x0161, 0x0000, 0x0169, 0x0171, 0x0179, 0x0181, 0x0189, 0x0191, 0x0199,
    0x01a1, 0x01a9, 0x01b1, 0x01b9, 0x01c1, 0x01c9, 0x01d1, 0x01d9, 0x01e1,
    0x01e9, 0x01f1, 0x01f9, 0x0201, 0x0209, 0x0211, 0x0219, 0x0221, 0x0229,
    0x0231, 0x0239, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0122};
const uint8_t HuffDecoderCommon::table17_29_emit_[144] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63, 0x40, 0x65,
    0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74, 0x40, 0x20, 0x40, 0x25,
    0x40, 0x2d, 0x40, 0x2e, 0x40, 0x2f, 0x40, 0x33, 0x40, 0x34, 0x40, 0x35,
    0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39, 0x40, 0x3d, 0x40, 0x41,
    0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66, 0x40, 0x67, 0x40, 0x68,
    0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70, 0x40, 0x72, 0x40, 0x75,
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63, 0x5b, 0x65,
    0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74, 0x5b, 0x20, 0x5b, 0x25,
    0x5b, 0x2d, 0x5b, 0x2e, 0x5b, 0x2f, 0x5b, 0x33, 0x5b, 0x34, 0x5b, 0x35,
    0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39, 0x5b, 0x3d, 0x5b, 0x41,
    0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66, 0x5b, 0x67, 0x5b, 0x68,
    0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70, 0x5b, 0x72, 0x5b, 0x75};
const uint8_t HuffDecoderCommon::table17_30_emit_[144] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d, 0x65,
    0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20, 0x5d, 0x25,
    0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d, 0x34, 0x5d, 0x35,
    0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39, 0x5d, 0x3d, 0x5d, 0x41,
    0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66, 0x5d, 0x67, 0x5d, 0x68,
    0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70, 0x5d, 0x72, 0x5d, 0x75,
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e, 0x65,
    0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20, 0x7e, 0x25,
    0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e, 0x34, 0x7e, 0x35,
    0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39, 0x7e, 0x3d, 0x7e, 0x41,
    0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66, 0x7e, 0x67, 0x7e, 0x68,
    0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70, 0x7e, 0x72, 0x7e, 0x75};
const uint8_t HuffDecoderCommon::table17_31_emit_[46] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63, 0x5e, 0x65,
    0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74, 0x7d, 0x30, 0x7d, 0x31,
    0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63, 0x7d, 0x65, 0x7d, 0x69, 0x7d, 0x6f,
    0x7d, 0x73, 0x7d, 0x74, 0x3c, 0x60, 0x7b, 0x5c, 0xc3, 0xd0};
const uint16_t HuffDecoderCommon::table17_31_ops_[128] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039, 0x0041,
    0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0052, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00a6, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x00aa, 0x00ae, 0x00b2, 0x00b6, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table17_emit_[32] = {
    table16_0_emit_,  table16_1_emit_,  table16_2_emit_,  table16_3_emit_,
    table16_4_emit_,  table16_5_emit_,  table16_6_emit_,  table16_7_emit_,
    table16_8_emit_,  table16_9_emit_,  table16_10_emit_, table16_11_emit_,
    table16_12_emit_, table16_13_emit_, table16_14_emit_, table16_15_emit_,
    table16_16_emit_, table16_17_emit_, table16_18_emit_, table16_19_emit_,
    table16_20_emit_, table17_21_emit_, table16_22_emit_, table17_23_emit_,
    table16_24_emit_, table17_25_emit_, table17_26_emit_, table17_27_emit_,
    table17_28_emit_, table17_29_emit_, table17_30_emit_, table17_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table17_ops_[32] = {
    table17_0_ops_,  table17_1_ops_,  table17_2_ops_,  table17_3_ops_,
    table17_0_ops_,  table17_1_ops_,  table17_2_ops_,  table17_3_ops_,
    table17_0_ops_,  table17_1_ops_,  table17_2_ops_,  table17_3_ops_,
    table17_0_ops_,  table17_1_ops_,  table17_2_ops_,  table17_3_ops_,
    table17_0_ops_,  table17_1_ops_,  table17_2_ops_,  table17_3_ops_,
    table17_20_ops_, table17_21_ops_, table17_20_ops_, table17_21_ops_,
    table17_20_ops_, table17_21_ops_, table17_26_ops_, table17_26_ops_,
    table17_28_ops_, table17_28_ops_, table17_28_ops_, table17_31_ops_,
};
const uint8_t HuffDecoderCommon::table18_0_emit_[60] = {
    0x21, 0x30, 0x30, 0x21, 0x30, 0x31, 0x21, 0x30, 0x32, 0x21, 0x30, 0x61,
    0x21, 0x30, 0x63, 0x21, 0x30, 0x65, 0x21, 0x30, 0x69, 0x21, 0x30, 0x6f,
    0x21, 0x30, 0x73, 0x21, 0x30, 0x74, 0x21, 0x31, 0x30, 0x21, 0x31, 0x31,
    0x21, 0x31, 0x32, 0x21, 0x31, 0x61, 0x21, 0x31, 0x63, 0x21, 0x31, 0x65,
    0x21, 0x31, 0x69, 0x21, 0x31, 0x6f, 0x21, 0x31, 0x73, 0x21, 0x31, 0x74};
const uint16_t HuffDecoderCommon::table18_0_ops_[64] = {
    0x0000, 0x0018, 0x0030, 0x0048, 0x0060, 0x0078, 0x0090, 0x00a8,
    0x00c0, 0x00d8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x00f0, 0x0108, 0x0120, 0x0138, 0x0150, 0x0168, 0x0180, 0x0198,
    0x01b0, 0x01c8, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00f2};
const uint8_t HuffDecoderCommon::table18_1_emit_[60] = {
    0x21, 0x32, 0x30, 0x21, 0x32, 0x31, 0x21, 0x32, 0x32, 0x21, 0x32, 0x61,
    0x21, 0x32, 0x63, 0x21, 0x32, 0x65, 0x21, 0x32, 0x69, 0x21, 0x32, 0x6f,
    0x21, 0x32, 0x73, 0x21, 0x32, 0x74, 0x21, 0x61, 0x30, 0x21, 0x61, 0x31,
    0x21, 0x61, 0x32, 0x21, 0x61, 0x61, 0x21, 0x61, 0x63, 0x21, 0x61, 0x65,
    0x21, 0x61, 0x69, 0x21, 0x61, 0x6f, 0x21, 0x61, 0x73, 0x21, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table18_2_emit_[60] = {
    0x21, 0x63, 0x30, 0x21, 0x63, 0x31, 0x21, 0x63, 0x32, 0x21, 0x63, 0x61,
    0x21, 0x63, 0x63, 0x21, 0x63, 0x65, 0x21, 0x63, 0x69, 0x21, 0x63, 0x6f,
    0x21, 0x63, 0x73, 0x21, 0x63, 0x74, 0x21, 0x65, 0x30, 0x21, 0x65, 0x31,
    0x21, 0x65, 0x32, 0x21, 0x65, 0x61, 0x21, 0x65, 0x63, 0x21, 0x65, 0x65,
    0x21, 0x65, 0x69, 0x21, 0x65, 0x6f, 0x21, 0x65, 0x73, 0x21, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table18_3_emit_[60] = {
    0x21, 0x69, 0x30, 0x21, 0x69, 0x31, 0x21, 0x69, 0x32, 0x21, 0x69, 0x61,
    0x21, 0x69, 0x63, 0x21, 0x69, 0x65, 0x21, 0x69, 0x69, 0x21, 0x69, 0x6f,
    0x21, 0x69, 0x73, 0x21, 0x69, 0x74, 0x21, 0x6f, 0x30, 0x21, 0x6f, 0x31,
    0x21, 0x6f, 0x32, 0x21, 0x6f, 0x61, 0x21, 0x6f, 0x63, 0x21, 0x6f, 0x65,
    0x21, 0x6f, 0x69, 0x21, 0x6f, 0x6f, 0x21, 0x6f, 0x73, 0x21, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table18_4_emit_[60] = {
    0x21, 0x73, 0x30, 0x21, 0x73, 0x31, 0x21, 0x73, 0x32, 0x21, 0x73, 0x61,
    0x21, 0x73, 0x63, 0x21, 0x73, 0x65, 0x21, 0x73, 0x69, 0x21, 0x73, 0x6f,
    0x21, 0x73, 0x73, 0x21, 0x73, 0x74, 0x21, 0x74, 0x30, 0x21, 0x74, 0x31,
    0x21, 0x74, 0x32, 0x21, 0x74, 0x61, 0x21, 0x74, 0x63, 0x21, 0x74, 0x65,
    0x21, 0x74, 0x69, 0x21, 0x74, 0x6f, 0x21, 0x74, 0x73, 0x21, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table18_5_emit_[8] = {0x21, 0x20, 0x21, 0x25,
                                                       0x21, 0x2d, 0x21, 0x2e};
const uint16_t HuffDecoderCommon::table18_5_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032};
const uint8_t HuffDecoderCommon::table18_6_emit_[8] = {0x21, 0x2f, 0x21, 0x33,
                                                       0x21, 0x34, 0x21, 0x35};
const uint8_t HuffDecoderCommon::table18_7_emit_[8] = {0x21, 0x36, 0x21, 0x37,
                                                       0x21, 0x38, 0x21, 0x39};
const uint8_t HuffDecoderCommon::table18_8_emit_[8] = {0x21, 0x3d, 0x21, 0x41,
                                                       0x21, 0x5f, 0x21, 0x62};
const uint8_t HuffDecoderCommon::table18_9_emit_[8] = {0x21, 0x64, 0x21, 0x66,
                                                       0x21, 0x67, 0x21, 0x68};
const uint8_t HuffDecoderCommon::table18_10_emit_[8] = {0x21, 0x6c, 0x21, 0x6d,
                                                        0x21, 0x6e, 0x21, 0x70};
const uint8_t HuffDecoderCommon::table18_11_emit_[12] = {
    0x21, 0x72, 0x21, 0x75, 0x21, 0x3a, 0x21, 0x42, 0x21, 0x43, 0x21, 0x44};
const uint16_t HuffDecoderCommon::table18_11_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052};
const uint8_t HuffDecoderCommon::table18_12_emit_[16] = {
    0x21, 0x45, 0x21, 0x46, 0x21, 0x47, 0x21, 0x48,
    0x21, 0x49, 0x21, 0x4a, 0x21, 0x4b, 0x21, 0x4c};
const uint16_t HuffDecoderCommon::table18_12_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0062,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0072};
const uint8_t HuffDecoderCommon::table18_13_emit_[16] = {
    0x21, 0x4d, 0x21, 0x4e, 0x21, 0x4f, 0x21, 0x50,
    0x21, 0x51, 0x21, 0x52, 0x21, 0x53, 0x21, 0x54};
const uint8_t HuffDecoderCommon::table18_14_emit_[16] = {
    0x21, 0x55, 0x21, 0x56, 0x21, 0x57, 0x21, 0x59,
    0x21, 0x6a, 0x21, 0x6b, 0x21, 0x71, 0x21, 0x76};
const uint8_t HuffDecoderCommon::table18_15_emit_[29] = {
    0x21, 0x77, 0x21, 0x78, 0x21, 0x79, 0x21, 0x7a, 0x21, 0x26,
    0x21, 0x2a, 0x21, 0x2c, 0x21, 0x3b, 0x21, 0x58, 0x21, 0x5a,
    0x21, 0x21, 0x22, 0x21, 0x28, 0x21, 0x29, 0x21, 0x3f};
const uint16_t HuffDecoderCommon::table18_15_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00aa, 0x00ba, 0x00ca, 0x00da, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_16_emit_[60] = {
    0x22, 0x30, 0x30, 0x22, 0x30, 0x31, 0x22, 0x30, 0x32, 0x22, 0x30, 0x61,
    0x22, 0x30, 0x63, 0x22, 0x30, 0x65, 0x22, 0x30, 0x69, 0x22, 0x30, 0x6f,
    0x22, 0x30, 0x73, 0x22, 0x30, 0x74, 0x22, 0x31, 0x30, 0x22, 0x31, 0x31,
    0x22, 0x31, 0x32, 0x22, 0x31, 0x61, 0x22, 0x31, 0x63, 0x22, 0x31, 0x65,
    0x22, 0x31, 0x69, 0x22, 0x31, 0x6f, 0x22, 0x31, 0x73, 0x22, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table18_17_emit_[60] = {
    0x22, 0x32, 0x30, 0x22, 0x32, 0x31, 0x22, 0x32, 0x32, 0x22, 0x32, 0x61,
    0x22, 0x32, 0x63, 0x22, 0x32, 0x65, 0x22, 0x32, 0x69, 0x22, 0x32, 0x6f,
    0x22, 0x32, 0x73, 0x22, 0x32, 0x74, 0x22, 0x61, 0x30, 0x22, 0x61, 0x31,
    0x22, 0x61, 0x32, 0x22, 0x61, 0x61, 0x22, 0x61, 0x63, 0x22, 0x61, 0x65,
    0x22, 0x61, 0x69, 0x22, 0x61, 0x6f, 0x22, 0x61, 0x73, 0x22, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table18_18_emit_[60] = {
    0x22, 0x63, 0x30, 0x22, 0x63, 0x31, 0x22, 0x63, 0x32, 0x22, 0x63, 0x61,
    0x22, 0x63, 0x63, 0x22, 0x63, 0x65, 0x22, 0x63, 0x69, 0x22, 0x63, 0x6f,
    0x22, 0x63, 0x73, 0x22, 0x63, 0x74, 0x22, 0x65, 0x30, 0x22, 0x65, 0x31,
    0x22, 0x65, 0x32, 0x22, 0x65, 0x61, 0x22, 0x65, 0x63, 0x22, 0x65, 0x65,
    0x22, 0x65, 0x69, 0x22, 0x65, 0x6f, 0x22, 0x65, 0x73, 0x22, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table18_19_emit_[60] = {
    0x22, 0x69, 0x30, 0x22, 0x69, 0x31, 0x22, 0x69, 0x32, 0x22, 0x69, 0x61,
    0x22, 0x69, 0x63, 0x22, 0x69, 0x65, 0x22, 0x69, 0x69, 0x22, 0x69, 0x6f,
    0x22, 0x69, 0x73, 0x22, 0x69, 0x74, 0x22, 0x6f, 0x30, 0x22, 0x6f, 0x31,
    0x22, 0x6f, 0x32, 0x22, 0x6f, 0x61, 0x22, 0x6f, 0x63, 0x22, 0x6f, 0x65,
    0x22, 0x6f, 0x69, 0x22, 0x6f, 0x6f, 0x22, 0x6f, 0x73, 0x22, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table18_20_emit_[60] = {
    0x22, 0x73, 0x30, 0x22, 0x73, 0x31, 0x22, 0x73, 0x32, 0x22, 0x73, 0x61,
    0x22, 0x73, 0x63, 0x22, 0x73, 0x65, 0x22, 0x73, 0x69, 0x22, 0x73, 0x6f,
    0x22, 0x73, 0x73, 0x22, 0x73, 0x74, 0x22, 0x74, 0x30, 0x22, 0x74, 0x31,
    0x22, 0x74, 0x32, 0x22, 0x74, 0x61, 0x22, 0x74, 0x63, 0x22, 0x74, 0x65,
    0x22, 0x74, 0x69, 0x22, 0x74, 0x6f, 0x22, 0x74, 0x73, 0x22, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table18_21_emit_[8] = {0x22, 0x20, 0x22, 0x25,
                                                        0x22, 0x2d, 0x22, 0x2e};
const uint8_t HuffDecoderCommon::table18_22_emit_[8] = {0x22, 0x2f, 0x22, 0x33,
                                                        0x22, 0x34, 0x22, 0x35};
const uint8_t HuffDecoderCommon::table18_23_emit_[8] = {0x22, 0x36, 0x22, 0x37,
                                                        0x22, 0x38, 0x22, 0x39};
const uint8_t HuffDecoderCommon::table18_24_emit_[8] = {0x22, 0x3d, 0x22, 0x41,
                                                        0x22, 0x5f, 0x22, 0x62};
const uint8_t HuffDecoderCommon::table18_25_emit_[8] = {0x22, 0x64, 0x22, 0x66,
                                                        0x22, 0x67, 0x22, 0x68};
const uint8_t HuffDecoderCommon::table18_26_emit_[8] = {0x22, 0x6c, 0x22, 0x6d,
                                                        0x22, 0x6e, 0x22, 0x70};
const uint8_t HuffDecoderCommon::table18_27_emit_[12] = {
    0x22, 0x72, 0x22, 0x75, 0x22, 0x3a, 0x22, 0x42, 0x22, 0x43, 0x22, 0x44};
const uint8_t HuffDecoderCommon::table18_28_emit_[16] = {
    0x22, 0x45, 0x22, 0x46, 0x22, 0x47, 0x22, 0x48,
    0x22, 0x49, 0x22, 0x4a, 0x22, 0x4b, 0x22, 0x4c};
const uint8_t HuffDecoderCommon::table18_29_emit_[16] = {
    0x22, 0x4d, 0x22, 0x4e, 0x22, 0x4f, 0x22, 0x50,
    0x22, 0x51, 0x22, 0x52, 0x22, 0x53, 0x22, 0x54};
const uint8_t HuffDecoderCommon::table18_30_emit_[16] = {
    0x22, 0x55, 0x22, 0x56, 0x22, 0x57, 0x22, 0x59,
    0x22, 0x6a, 0x22, 0x6b, 0x22, 0x71, 0x22, 0x76};
const uint8_t HuffDecoderCommon::table18_31_emit_[29] = {
    0x22, 0x77, 0x22, 0x78, 0x22, 0x79, 0x22, 0x7a, 0x22, 0x26,
    0x22, 0x2a, 0x22, 0x2c, 0x22, 0x3b, 0x22, 0x58, 0x22, 0x5a,
    0x22, 0x21, 0x22, 0x22, 0x28, 0x22, 0x29, 0x22, 0x3f};
const uint16_t HuffDecoderCommon::table18_31_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00b2, 0x00ba, 0x00ca, 0x00da, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_32_emit_[60] = {
    0x28, 0x30, 0x30, 0x28, 0x30, 0x31, 0x28, 0x30, 0x32, 0x28, 0x30, 0x61,
    0x28, 0x30, 0x63, 0x28, 0x30, 0x65, 0x28, 0x30, 0x69, 0x28, 0x30, 0x6f,
    0x28, 0x30, 0x73, 0x28, 0x30, 0x74, 0x28, 0x31, 0x30, 0x28, 0x31, 0x31,
    0x28, 0x31, 0x32, 0x28, 0x31, 0x61, 0x28, 0x31, 0x63, 0x28, 0x31, 0x65,
    0x28, 0x31, 0x69, 0x28, 0x31, 0x6f, 0x28, 0x31, 0x73, 0x28, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table18_33_emit_[60] = {
    0x28, 0x32, 0x30, 0x28, 0x32, 0x31, 0x28, 0x32, 0x32, 0x28, 0x32, 0x61,
    0x28, 0x32, 0x63, 0x28, 0x32, 0x65, 0x28, 0x32, 0x69, 0x28, 0x32, 0x6f,
    0x28, 0x32, 0x73, 0x28, 0x32, 0x74, 0x28, 0x61, 0x30, 0x28, 0x61, 0x31,
    0x28, 0x61, 0x32, 0x28, 0x61, 0x61, 0x28, 0x61, 0x63, 0x28, 0x61, 0x65,
    0x28, 0x61, 0x69, 0x28, 0x61, 0x6f, 0x28, 0x61, 0x73, 0x28, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table18_34_emit_[60] = {
    0x28, 0x63, 0x30, 0x28, 0x63, 0x31, 0x28, 0x63, 0x32, 0x28, 0x63, 0x61,
    0x28, 0x63, 0x63, 0x28, 0x63, 0x65, 0x28, 0x63, 0x69, 0x28, 0x63, 0x6f,
    0x28, 0x63, 0x73, 0x28, 0x63, 0x74, 0x28, 0x65, 0x30, 0x28, 0x65, 0x31,
    0x28, 0x65, 0x32, 0x28, 0x65, 0x61, 0x28, 0x65, 0x63, 0x28, 0x65, 0x65,
    0x28, 0x65, 0x69, 0x28, 0x65, 0x6f, 0x28, 0x65, 0x73, 0x28, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table18_35_emit_[60] = {
    0x28, 0x69, 0x30, 0x28, 0x69, 0x31, 0x28, 0x69, 0x32, 0x28, 0x69, 0x61,
    0x28, 0x69, 0x63, 0x28, 0x69, 0x65, 0x28, 0x69, 0x69, 0x28, 0x69, 0x6f,
    0x28, 0x69, 0x73, 0x28, 0x69, 0x74, 0x28, 0x6f, 0x30, 0x28, 0x6f, 0x31,
    0x28, 0x6f, 0x32, 0x28, 0x6f, 0x61, 0x28, 0x6f, 0x63, 0x28, 0x6f, 0x65,
    0x28, 0x6f, 0x69, 0x28, 0x6f, 0x6f, 0x28, 0x6f, 0x73, 0x28, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table18_36_emit_[60] = {
    0x28, 0x73, 0x30, 0x28, 0x73, 0x31, 0x28, 0x73, 0x32, 0x28, 0x73, 0x61,
    0x28, 0x73, 0x63, 0x28, 0x73, 0x65, 0x28, 0x73, 0x69, 0x28, 0x73, 0x6f,
    0x28, 0x73, 0x73, 0x28, 0x73, 0x74, 0x28, 0x74, 0x30, 0x28, 0x74, 0x31,
    0x28, 0x74, 0x32, 0x28, 0x74, 0x61, 0x28, 0x74, 0x63, 0x28, 0x74, 0x65,
    0x28, 0x74, 0x69, 0x28, 0x74, 0x6f, 0x28, 0x74, 0x73, 0x28, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table18_37_emit_[8] = {0x28, 0x20, 0x28, 0x25,
                                                        0x28, 0x2d, 0x28, 0x2e};
const uint8_t HuffDecoderCommon::table18_38_emit_[8] = {0x28, 0x2f, 0x28, 0x33,
                                                        0x28, 0x34, 0x28, 0x35};
const uint8_t HuffDecoderCommon::table18_39_emit_[8] = {0x28, 0x36, 0x28, 0x37,
                                                        0x28, 0x38, 0x28, 0x39};
const uint8_t HuffDecoderCommon::table18_40_emit_[8] = {0x28, 0x3d, 0x28, 0x41,
                                                        0x28, 0x5f, 0x28, 0x62};
const uint8_t HuffDecoderCommon::table18_41_emit_[8] = {0x28, 0x64, 0x28, 0x66,
                                                        0x28, 0x67, 0x28, 0x68};
const uint8_t HuffDecoderCommon::table18_42_emit_[8] = {0x28, 0x6c, 0x28, 0x6d,
                                                        0x28, 0x6e, 0x28, 0x70};
const uint8_t HuffDecoderCommon::table18_43_emit_[12] = {
    0x28, 0x72, 0x28, 0x75, 0x28, 0x3a, 0x28, 0x42, 0x28, 0x43, 0x28, 0x44};
const uint8_t HuffDecoderCommon::table18_44_emit_[16] = {
    0x28, 0x45, 0x28, 0x46, 0x28, 0x47, 0x28, 0x48,
    0x28, 0x49, 0x28, 0x4a, 0x28, 0x4b, 0x28, 0x4c};
const uint8_t HuffDecoderCommon::table18_45_emit_[16] = {
    0x28, 0x4d, 0x28, 0x4e, 0x28, 0x4f, 0x28, 0x50,
    0x28, 0x51, 0x28, 0x52, 0x28, 0x53, 0x28, 0x54};
const uint8_t HuffDecoderCommon::table18_46_emit_[16] = {
    0x28, 0x55, 0x28, 0x56, 0x28, 0x57, 0x28, 0x59,
    0x28, 0x6a, 0x28, 0x6b, 0x28, 0x71, 0x28, 0x76};
const uint8_t HuffDecoderCommon::table18_47_emit_[29] = {
    0x28, 0x77, 0x28, 0x78, 0x28, 0x79, 0x28, 0x7a, 0x28, 0x26,
    0x28, 0x2a, 0x28, 0x2c, 0x28, 0x3b, 0x28, 0x58, 0x28, 0x5a,
    0x28, 0x21, 0x28, 0x22, 0x28, 0x28, 0x29, 0x28, 0x3f};
const uint16_t HuffDecoderCommon::table18_47_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00b2, 0x00c2, 0x00ca, 0x00da, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_48_emit_[60] = {
    0x29, 0x30, 0x30, 0x29, 0x30, 0x31, 0x29, 0x30, 0x32, 0x29, 0x30, 0x61,
    0x29, 0x30, 0x63, 0x29, 0x30, 0x65, 0x29, 0x30, 0x69, 0x29, 0x30, 0x6f,
    0x29, 0x30, 0x73, 0x29, 0x30, 0x74, 0x29, 0x31, 0x30, 0x29, 0x31, 0x31,
    0x29, 0x31, 0x32, 0x29, 0x31, 0x61, 0x29, 0x31, 0x63, 0x29, 0x31, 0x65,
    0x29, 0x31, 0x69, 0x29, 0x31, 0x6f, 0x29, 0x31, 0x73, 0x29, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table18_49_emit_[60] = {
    0x29, 0x32, 0x30, 0x29, 0x32, 0x31, 0x29, 0x32, 0x32, 0x29, 0x32, 0x61,
    0x29, 0x32, 0x63, 0x29, 0x32, 0x65, 0x29, 0x32, 0x69, 0x29, 0x32, 0x6f,
    0x29, 0x32, 0x73, 0x29, 0x32, 0x74, 0x29, 0x61, 0x30, 0x29, 0x61, 0x31,
    0x29, 0x61, 0x32, 0x29, 0x61, 0x61, 0x29, 0x61, 0x63, 0x29, 0x61, 0x65,
    0x29, 0x61, 0x69, 0x29, 0x61, 0x6f, 0x29, 0x61, 0x73, 0x29, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table18_50_emit_[60] = {
    0x29, 0x63, 0x30, 0x29, 0x63, 0x31, 0x29, 0x63, 0x32, 0x29, 0x63, 0x61,
    0x29, 0x63, 0x63, 0x29, 0x63, 0x65, 0x29, 0x63, 0x69, 0x29, 0x63, 0x6f,
    0x29, 0x63, 0x73, 0x29, 0x63, 0x74, 0x29, 0x65, 0x30, 0x29, 0x65, 0x31,
    0x29, 0x65, 0x32, 0x29, 0x65, 0x61, 0x29, 0x65, 0x63, 0x29, 0x65, 0x65,
    0x29, 0x65, 0x69, 0x29, 0x65, 0x6f, 0x29, 0x65, 0x73, 0x29, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table18_51_emit_[60] = {
    0x29, 0x69, 0x30, 0x29, 0x69, 0x31, 0x29, 0x69, 0x32, 0x29, 0x69, 0x61,
    0x29, 0x69, 0x63, 0x29, 0x69, 0x65, 0x29, 0x69, 0x69, 0x29, 0x69, 0x6f,
    0x29, 0x69, 0x73, 0x29, 0x69, 0x74, 0x29, 0x6f, 0x30, 0x29, 0x6f, 0x31,
    0x29, 0x6f, 0x32, 0x29, 0x6f, 0x61, 0x29, 0x6f, 0x63, 0x29, 0x6f, 0x65,
    0x29, 0x6f, 0x69, 0x29, 0x6f, 0x6f, 0x29, 0x6f, 0x73, 0x29, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table18_52_emit_[60] = {
    0x29, 0x73, 0x30, 0x29, 0x73, 0x31, 0x29, 0x73, 0x32, 0x29, 0x73, 0x61,
    0x29, 0x73, 0x63, 0x29, 0x73, 0x65, 0x29, 0x73, 0x69, 0x29, 0x73, 0x6f,
    0x29, 0x73, 0x73, 0x29, 0x73, 0x74, 0x29, 0x74, 0x30, 0x29, 0x74, 0x31,
    0x29, 0x74, 0x32, 0x29, 0x74, 0x61, 0x29, 0x74, 0x63, 0x29, 0x74, 0x65,
    0x29, 0x74, 0x69, 0x29, 0x74, 0x6f, 0x29, 0x74, 0x73, 0x29, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table18_53_emit_[8] = {0x29, 0x20, 0x29, 0x25,
                                                        0x29, 0x2d, 0x29, 0x2e};
const uint8_t HuffDecoderCommon::table18_54_emit_[8] = {0x29, 0x2f, 0x29, 0x33,
                                                        0x29, 0x34, 0x29, 0x35};
const uint8_t HuffDecoderCommon::table18_55_emit_[8] = {0x29, 0x36, 0x29, 0x37,
                                                        0x29, 0x38, 0x29, 0x39};
const uint8_t HuffDecoderCommon::table18_56_emit_[8] = {0x29, 0x3d, 0x29, 0x41,
                                                        0x29, 0x5f, 0x29, 0x62};
const uint8_t HuffDecoderCommon::table18_57_emit_[8] = {0x29, 0x64, 0x29, 0x66,
                                                        0x29, 0x67, 0x29, 0x68};
const uint8_t HuffDecoderCommon::table18_58_emit_[8] = {0x29, 0x6c, 0x29, 0x6d,
                                                        0x29, 0x6e, 0x29, 0x70};
const uint8_t HuffDecoderCommon::table18_59_emit_[12] = {
    0x29, 0x72, 0x29, 0x75, 0x29, 0x3a, 0x29, 0x42, 0x29, 0x43, 0x29, 0x44};
const uint8_t HuffDecoderCommon::table18_60_emit_[16] = {
    0x29, 0x45, 0x29, 0x46, 0x29, 0x47, 0x29, 0x48,
    0x29, 0x49, 0x29, 0x4a, 0x29, 0x4b, 0x29, 0x4c};
const uint8_t HuffDecoderCommon::table18_61_emit_[16] = {
    0x29, 0x4d, 0x29, 0x4e, 0x29, 0x4f, 0x29, 0x50,
    0x29, 0x51, 0x29, 0x52, 0x29, 0x53, 0x29, 0x54};
const uint8_t HuffDecoderCommon::table18_62_emit_[16] = {
    0x29, 0x55, 0x29, 0x56, 0x29, 0x57, 0x29, 0x59,
    0x29, 0x6a, 0x29, 0x6b, 0x29, 0x71, 0x29, 0x76};
const uint8_t HuffDecoderCommon::table18_63_emit_[29] = {
    0x29, 0x77, 0x29, 0x78, 0x29, 0x79, 0x29, 0x7a, 0x29, 0x26,
    0x29, 0x2a, 0x29, 0x2c, 0x29, 0x3b, 0x29, 0x58, 0x29, 0x5a,
    0x29, 0x21, 0x29, 0x22, 0x29, 0x28, 0x29, 0x29, 0x3f};
const uint16_t HuffDecoderCommon::table18_63_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00da, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_64_emit_[60] = {
    0x3f, 0x30, 0x30, 0x3f, 0x30, 0x31, 0x3f, 0x30, 0x32, 0x3f, 0x30, 0x61,
    0x3f, 0x30, 0x63, 0x3f, 0x30, 0x65, 0x3f, 0x30, 0x69, 0x3f, 0x30, 0x6f,
    0x3f, 0x30, 0x73, 0x3f, 0x30, 0x74, 0x3f, 0x31, 0x30, 0x3f, 0x31, 0x31,
    0x3f, 0x31, 0x32, 0x3f, 0x31, 0x61, 0x3f, 0x31, 0x63, 0x3f, 0x31, 0x65,
    0x3f, 0x31, 0x69, 0x3f, 0x31, 0x6f, 0x3f, 0x31, 0x73, 0x3f, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table18_65_emit_[60] = {
    0x3f, 0x32, 0x30, 0x3f, 0x32, 0x31, 0x3f, 0x32, 0x32, 0x3f, 0x32, 0x61,
    0x3f, 0x32, 0x63, 0x3f, 0x32, 0x65, 0x3f, 0x32, 0x69, 0x3f, 0x32, 0x6f,
    0x3f, 0x32, 0x73, 0x3f, 0x32, 0x74, 0x3f, 0x61, 0x30, 0x3f, 0x61, 0x31,
    0x3f, 0x61, 0x32, 0x3f, 0x61, 0x61, 0x3f, 0x61, 0x63, 0x3f, 0x61, 0x65,
    0x3f, 0x61, 0x69, 0x3f, 0x61, 0x6f, 0x3f, 0x61, 0x73, 0x3f, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table18_66_emit_[60] = {
    0x3f, 0x63, 0x30, 0x3f, 0x63, 0x31, 0x3f, 0x63, 0x32, 0x3f, 0x63, 0x61,
    0x3f, 0x63, 0x63, 0x3f, 0x63, 0x65, 0x3f, 0x63, 0x69, 0x3f, 0x63, 0x6f,
    0x3f, 0x63, 0x73, 0x3f, 0x63, 0x74, 0x3f, 0x65, 0x30, 0x3f, 0x65, 0x31,
    0x3f, 0x65, 0x32, 0x3f, 0x65, 0x61, 0x3f, 0x65, 0x63, 0x3f, 0x65, 0x65,
    0x3f, 0x65, 0x69, 0x3f, 0x65, 0x6f, 0x3f, 0x65, 0x73, 0x3f, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table18_67_emit_[60] = {
    0x3f, 0x69, 0x30, 0x3f, 0x69, 0x31, 0x3f, 0x69, 0x32, 0x3f, 0x69, 0x61,
    0x3f, 0x69, 0x63, 0x3f, 0x69, 0x65, 0x3f, 0x69, 0x69, 0x3f, 0x69, 0x6f,
    0x3f, 0x69, 0x73, 0x3f, 0x69, 0x74, 0x3f, 0x6f, 0x30, 0x3f, 0x6f, 0x31,
    0x3f, 0x6f, 0x32, 0x3f, 0x6f, 0x61, 0x3f, 0x6f, 0x63, 0x3f, 0x6f, 0x65,
    0x3f, 0x6f, 0x69, 0x3f, 0x6f, 0x6f, 0x3f, 0x6f, 0x73, 0x3f, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table18_68_emit_[60] = {
    0x3f, 0x73, 0x30, 0x3f, 0x73, 0x31, 0x3f, 0x73, 0x32, 0x3f, 0x73, 0x61,
    0x3f, 0x73, 0x63, 0x3f, 0x73, 0x65, 0x3f, 0x73, 0x69, 0x3f, 0x73, 0x6f,
    0x3f, 0x73, 0x73, 0x3f, 0x73, 0x74, 0x3f, 0x74, 0x30, 0x3f, 0x74, 0x31,
    0x3f, 0x74, 0x32, 0x3f, 0x74, 0x61, 0x3f, 0x74, 0x63, 0x3f, 0x74, 0x65,
    0x3f, 0x74, 0x69, 0x3f, 0x74, 0x6f, 0x3f, 0x74, 0x73, 0x3f, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table18_69_emit_[8] = {0x3f, 0x20, 0x3f, 0x25,
                                                        0x3f, 0x2d, 0x3f, 0x2e};
const uint8_t HuffDecoderCommon::table18_70_emit_[8] = {0x3f, 0x2f, 0x3f, 0x33,
                                                        0x3f, 0x34, 0x3f, 0x35};
const uint8_t HuffDecoderCommon::table18_71_emit_[8] = {0x3f, 0x36, 0x3f, 0x37,
                                                        0x3f, 0x38, 0x3f, 0x39};
const uint8_t HuffDecoderCommon::table18_72_emit_[8] = {0x3f, 0x3d, 0x3f, 0x41,
                                                        0x3f, 0x5f, 0x3f, 0x62};
const uint8_t HuffDecoderCommon::table18_73_emit_[8] = {0x3f, 0x64, 0x3f, 0x66,
                                                        0x3f, 0x67, 0x3f, 0x68};
const uint8_t HuffDecoderCommon::table18_74_emit_[8] = {0x3f, 0x6c, 0x3f, 0x6d,
                                                        0x3f, 0x6e, 0x3f, 0x70};
const uint8_t HuffDecoderCommon::table18_75_emit_[12] = {
    0x3f, 0x72, 0x3f, 0x75, 0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44};
const uint8_t HuffDecoderCommon::table18_76_emit_[16] = {
    0x3f, 0x45, 0x3f, 0x46, 0x3f, 0x47, 0x3f, 0x48,
    0x3f, 0x49, 0x3f, 0x4a, 0x3f, 0x4b, 0x3f, 0x4c};
const uint8_t HuffDecoderCommon::table18_77_emit_[16] = {
    0x3f, 0x4d, 0x3f, 0x4e, 0x3f, 0x4f, 0x3f, 0x50,
    0x3f, 0x51, 0x3f, 0x52, 0x3f, 0x53, 0x3f, 0x54};
const uint8_t HuffDecoderCommon::table18_78_emit_[16] = {
    0x3f, 0x55, 0x3f, 0x56, 0x3f, 0x57, 0x3f, 0x59,
    0x3f, 0x6a, 0x3f, 0x6b, 0x3f, 0x71, 0x3f, 0x76};
const uint8_t HuffDecoderCommon::table18_79_emit_[30] = {
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a, 0x3f, 0x26,
    0x3f, 0x2a, 0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f, 0x5a,
    0x3f, 0x21, 0x3f, 0x22, 0x3f, 0x28, 0x3f, 0x29, 0x3f, 0x3f};
const uint16_t HuffDecoderCommon::table18_79_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_80_emit_[8] = {0x27, 0x30, 0x27, 0x31,
                                                        0x27, 0x32, 0x27, 0x61};
const uint8_t HuffDecoderCommon::table18_81_emit_[8] = {0x27, 0x63, 0x27, 0x65,
                                                        0x27, 0x69, 0x27, 0x6f};
const uint8_t HuffDecoderCommon::table18_82_emit_[12] = {
    0x27, 0x73, 0x27, 0x74, 0x27, 0x20, 0x27, 0x25, 0x27, 0x2d, 0x27, 0x2e};
const uint8_t HuffDecoderCommon::table18_83_emit_[16] = {
    0x27, 0x2f, 0x27, 0x33, 0x27, 0x34, 0x27, 0x35,
    0x27, 0x36, 0x27, 0x37, 0x27, 0x38, 0x27, 0x39};
const uint8_t HuffDecoderCommon::table18_84_emit_[16] = {
    0x27, 0x3d, 0x27, 0x41, 0x27, 0x5f, 0x27, 0x62,
    0x27, 0x64, 0x27, 0x66, 0x27, 0x67, 0x27, 0x68};
const uint8_t HuffDecoderCommon::table18_85_emit_[20] = {
    0x27, 0x6c, 0x27, 0x6d, 0x27, 0x6e, 0x27, 0x70, 0x27, 0x72,
    0x27, 0x75, 0x27, 0x3a, 0x27, 0x42, 0x27, 0x43, 0x27, 0x44};
const uint16_t HuffDecoderCommon::table18_85_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0022,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0042,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092};
const uint8_t HuffDecoderCommon::table18_86_emit_[32] = {
    0x27, 0x45, 0x27, 0x46, 0x27, 0x47, 0x27, 0x48, 0x27, 0x49, 0x27,
    0x4a, 0x27, 0x4b, 0x27, 0x4c, 0x27, 0x4d, 0x27, 0x4e, 0x27, 0x4f,
    0x27, 0x50, 0x27, 0x51, 0x27, 0x52, 0x27, 0x53, 0x27, 0x54};
const uint16_t HuffDecoderCommon::table18_86_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2,
    0x0001, 0x0001, 0x0001, 0x00e2, 0x0001, 0x0001, 0x0001, 0x00f2};
const uint8_t HuffDecoderCommon::table18_87_emit_[36] = {
    0x27, 0x55, 0x27, 0x56, 0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b,
    0x27, 0x71, 0x27, 0x76, 0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a,
    0x27, 0x26, 0x27, 0x2a, 0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27, 0x5a};
const uint16_t HuffDecoderCommon::table18_87_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x00c2, 0x0001, 0x00d2, 0x0001, 0x00e2, 0x0001, 0x00f2,
    0x0001, 0x0102, 0x0001, 0x0112, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_88_emit_[8] = {0x2b, 0x30, 0x2b, 0x31,
                                                        0x2b, 0x32, 0x2b, 0x61};
const uint8_t HuffDecoderCommon::table18_89_emit_[8] = {0x2b, 0x63, 0x2b, 0x65,
                                                        0x2b, 0x69, 0x2b, 0x6f};
const uint8_t HuffDecoderCommon::table18_90_emit_[12] = {
    0x2b, 0x73, 0x2b, 0x74, 0x2b, 0x20, 0x2b, 0x25, 0x2b, 0x2d, 0x2b, 0x2e};
const uint8_t HuffDecoderCommon::table18_91_emit_[16] = {
    0x2b, 0x2f, 0x2b, 0x33, 0x2b, 0x34, 0x2b, 0x35,
    0x2b, 0x36, 0x2b, 0x37, 0x2b, 0x38, 0x2b, 0x39};
const uint8_t HuffDecoderCommon::table18_92_emit_[16] = {
    0x2b, 0x3d, 0x2b, 0x41, 0x2b, 0x5f, 0x2b, 0x62,
    0x2b, 0x64, 0x2b, 0x66, 0x2b, 0x67, 0x2b, 0x68};
const uint8_t HuffDecoderCommon::table18_93_emit_[20] = {
    0x2b, 0x6c, 0x2b, 0x6d, 0x2b, 0x6e, 0x2b, 0x70, 0x2b, 0x72,
    0x2b, 0x75, 0x2b, 0x3a, 0x2b, 0x42, 0x2b, 0x43, 0x2b, 0x44};
const uint8_t HuffDecoderCommon::table18_94_emit_[32] = {
    0x2b, 0x45, 0x2b, 0x46, 0x2b, 0x47, 0x2b, 0x48, 0x2b, 0x49, 0x2b,
    0x4a, 0x2b, 0x4b, 0x2b, 0x4c, 0x2b, 0x4d, 0x2b, 0x4e, 0x2b, 0x4f,
    0x2b, 0x50, 0x2b, 0x51, 0x2b, 0x52, 0x2b, 0x53, 0x2b, 0x54};
const uint8_t HuffDecoderCommon::table18_95_emit_[36] = {
    0x2b, 0x55, 0x2b, 0x56, 0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b,
    0x2b, 0x71, 0x2b, 0x76, 0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a,
    0x2b, 0x26, 0x2b, 0x2a, 0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b, 0x5a};
const uint8_t HuffDecoderCommon::table18_96_emit_[8] = {0x7c, 0x30, 0x7c, 0x31,
                                                        0x7c, 0x32, 0x7c, 0x61};
const uint8_t HuffDecoderCommon::table18_97_emit_[8] = {0x7c, 0x63, 0x7c, 0x65,
                                                        0x7c, 0x69, 0x7c, 0x6f};
const uint8_t HuffDecoderCommon::table18_98_emit_[12] = {
    0x7c, 0x73, 0x7c, 0x74, 0x7c, 0x20, 0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e};
const uint8_t HuffDecoderCommon::table18_99_emit_[16] = {
    0x7c, 0x2f, 0x7c, 0x33, 0x7c, 0x34, 0x7c, 0x35,
    0x7c, 0x36, 0x7c, 0x37, 0x7c, 0x38, 0x7c, 0x39};
const uint8_t HuffDecoderCommon::table18_100_emit_[16] = {
    0x7c, 0x3d, 0x7c, 0x41, 0x7c, 0x5f, 0x7c, 0x62,
    0x7c, 0x64, 0x7c, 0x66, 0x7c, 0x67, 0x7c, 0x68};
const uint8_t HuffDecoderCommon::table18_101_emit_[20] = {
    0x7c, 0x6c, 0x7c, 0x6d, 0x7c, 0x6e, 0x7c, 0x70, 0x7c, 0x72,
    0x7c, 0x75, 0x7c, 0x3a, 0x7c, 0x42, 0x7c, 0x43, 0x7c, 0x44};
const uint8_t HuffDecoderCommon::table18_102_emit_[32] = {
    0x7c, 0x45, 0x7c, 0x46, 0x7c, 0x47, 0x7c, 0x48, 0x7c, 0x49, 0x7c,
    0x4a, 0x7c, 0x4b, 0x7c, 0x4c, 0x7c, 0x4d, 0x7c, 0x4e, 0x7c, 0x4f,
    0x7c, 0x50, 0x7c, 0x51, 0x7c, 0x52, 0x7c, 0x53, 0x7c, 0x54};
const uint8_t HuffDecoderCommon::table18_103_emit_[36] = {
    0x7c, 0x55, 0x7c, 0x56, 0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b,
    0x7c, 0x71, 0x7c, 0x76, 0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a,
    0x7c, 0x26, 0x7c, 0x2a, 0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a};
const uint8_t HuffDecoderCommon::table18_104_emit_[16] = {
    0x23, 0x30, 0x23, 0x31, 0x23, 0x32, 0x23, 0x61,
    0x23, 0x63, 0x23, 0x65, 0x23, 0x69, 0x23, 0x6f};
const uint8_t HuffDecoderCommon::table18_105_emit_[28] = {
    0x23, 0x73, 0x23, 0x74, 0x23, 0x20, 0x23, 0x25, 0x23, 0x2d,
    0x23, 0x2e, 0x23, 0x2f, 0x23, 0x33, 0x23, 0x34, 0x23, 0x35,
    0x23, 0x36, 0x23, 0x37, 0x23, 0x38, 0x23, 0x39};
const uint16_t HuffDecoderCommon::table18_105_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0002,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2};
const uint8_t HuffDecoderCommon::table18_106_emit_[36] = {
    0x23, 0x3d, 0x23, 0x41, 0x23, 0x5f, 0x23, 0x62, 0x23, 0x64, 0x23, 0x66,
    0x23, 0x67, 0x23, 0x68, 0x23, 0x6c, 0x23, 0x6d, 0x23, 0x6e, 0x23, 0x70,
    0x23, 0x72, 0x23, 0x75, 0x23, 0x3a, 0x23, 0x42, 0x23, 0x43, 0x23, 0x44};
const uint16_t HuffDecoderCommon::table18_106_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x0001, 0x0001, 0x00a2, 0x0001, 0x0001, 0x0001, 0x00b2,
    0x0001, 0x0001, 0x0001, 0x00c2, 0x0001, 0x0001, 0x0001, 0x00d2,
    0x0001, 0x00e2, 0x0001, 0x00f2, 0x0001, 0x0102, 0x0001, 0x0112};
const uint8_t HuffDecoderCommon::table18_107_emit_[68] = {
    0x23, 0x45, 0x23, 0x46, 0x23, 0x47, 0x23, 0x48, 0x23, 0x49, 0x23, 0x4a,
    0x23, 0x4b, 0x23, 0x4c, 0x23, 0x4d, 0x23, 0x4e, 0x23, 0x4f, 0x23, 0x50,
    0x23, 0x51, 0x23, 0x52, 0x23, 0x53, 0x23, 0x54, 0x23, 0x55, 0x23, 0x56,
    0x23, 0x57, 0x23, 0x59, 0x23, 0x6a, 0x23, 0x6b, 0x23, 0x71, 0x23, 0x76,
    0x23, 0x77, 0x23, 0x78, 0x23, 0x79, 0x23, 0x7a, 0x23, 0x26, 0x23, 0x2a,
    0x23, 0x2c, 0x23, 0x3b, 0x23, 0x58, 0x23, 0x5a};
const uint16_t HuffDecoderCommon::table18_107_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x0001, 0x00a2, 0x0001, 0x00b2,
    0x0001, 0x00c2, 0x0001, 0x00d2, 0x0001, 0x00e2, 0x0001, 0x00f2,
    0x0001, 0x0102, 0x0001, 0x0112, 0x0001, 0x0122, 0x0001, 0x0132,
    0x0001, 0x0142, 0x0001, 0x0152, 0x0001, 0x0162, 0x0001, 0x0172,
    0x0001, 0x0182, 0x0001, 0x0192, 0x0001, 0x01a2, 0x0001, 0x01b2,
    0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_108_emit_[16] = {
    0x3e, 0x30, 0x3e, 0x31, 0x3e, 0x32, 0x3e, 0x61,
    0x3e, 0x63, 0x3e, 0x65, 0x3e, 0x69, 0x3e, 0x6f};
const uint8_t HuffDecoderCommon::table18_109_emit_[28] = {
    0x3e, 0x73, 0x3e, 0x74, 0x3e, 0x20, 0x3e, 0x25, 0x3e, 0x2d,
    0x3e, 0x2e, 0x3e, 0x2f, 0x3e, 0x33, 0x3e, 0x34, 0x3e, 0x35,
    0x3e, 0x36, 0x3e, 0x37, 0x3e, 0x38, 0x3e, 0x39};
const uint8_t HuffDecoderCommon::table18_110_emit_[36] = {
    0x3e, 0x3d, 0x3e, 0x41, 0x3e, 0x5f, 0x3e, 0x62, 0x3e, 0x64, 0x3e, 0x66,
    0x3e, 0x67, 0x3e, 0x68, 0x3e, 0x6c, 0x3e, 0x6d, 0x3e, 0x6e, 0x3e, 0x70,
    0x3e, 0x72, 0x3e, 0x75, 0x3e, 0x3a, 0x3e, 0x42, 0x3e, 0x43, 0x3e, 0x44};
const uint8_t HuffDecoderCommon::table18_111_emit_[68] = {
    0x3e, 0x45, 0x3e, 0x46, 0x3e, 0x47, 0x3e, 0x48, 0x3e, 0x49, 0x3e, 0x4a,
    0x3e, 0x4b, 0x3e, 0x4c, 0x3e, 0x4d, 0x3e, 0x4e, 0x3e, 0x4f, 0x3e, 0x50,
    0x3e, 0x51, 0x3e, 0x52, 0x3e, 0x53, 0x3e, 0x54, 0x3e, 0x55, 0x3e, 0x56,
    0x3e, 0x57, 0x3e, 0x59, 0x3e, 0x6a, 0x3e, 0x6b, 0x3e, 0x71, 0x3e, 0x76,
    0x3e, 0x77, 0x3e, 0x78, 0x3e, 0x79, 0x3e, 0x7a, 0x3e, 0x26, 0x3e, 0x2a,
    0x3e, 0x2c, 0x3e, 0x3b, 0x3e, 0x58, 0x3e, 0x5a};
const uint8_t HuffDecoderCommon::table18_112_emit_[44] = {
    0x00, 0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x61, 0x00, 0x63, 0x00,
    0x65, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x73, 0x00, 0x74, 0x00, 0x20,
    0x00, 0x25, 0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f, 0x00, 0x33, 0x00,
    0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39};
const uint16_t HuffDecoderCommon::table18_112_ops_[64] = {
    0x0001, 0x0001, 0x0001, 0x0002, 0x0001, 0x0001, 0x0001, 0x0012,
    0x0001, 0x0001, 0x0001, 0x0022, 0x0001, 0x0001, 0x0001, 0x0032,
    0x0001, 0x0001, 0x0001, 0x0042, 0x0001, 0x0001, 0x0001, 0x0052,
    0x0001, 0x0001, 0x0001, 0x0062, 0x0001, 0x0001, 0x0001, 0x0072,
    0x0001, 0x0001, 0x0001, 0x0082, 0x0001, 0x0001, 0x0001, 0x0092,
    0x0001, 0x00a2, 0x0001, 0x00b2, 0x0001, 0x00c2, 0x0001, 0x00d2,
    0x0001, 0x00e2, 0x0001, 0x00f2, 0x0001, 0x0102, 0x0001, 0x0112,
    0x0001, 0x0122, 0x0001, 0x0132, 0x0001, 0x0142, 0x0001, 0x0152};
const uint8_t HuffDecoderCommon::table18_113_emit_[92] = {
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66,
    0x00, 0x67, 0x00, 0x68, 0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70,
    0x00, 0x72, 0x00, 0x75, 0x00, 0x3a, 0x00, 0x42, 0x00, 0x43, 0x00, 0x44,
    0x00, 0x45, 0x00, 0x46, 0x00, 0x47, 0x00, 0x48, 0x00, 0x49, 0x00, 0x4a,
    0x00, 0x4b, 0x00, 0x4c, 0x00, 0x4d, 0x00, 0x4e, 0x00, 0x4f, 0x00, 0x50,
    0x00, 0x51, 0x00, 0x52, 0x00, 0x53, 0x00, 0x54, 0x00, 0x55, 0x00, 0x56,
    0x00, 0x57, 0x00, 0x59, 0x00, 0x6a, 0x00, 0x6b, 0x00, 0x71, 0x00, 0x76,
    0x00, 0x77, 0x00, 0x78, 0x00, 0x79, 0x00, 0x7a};
const uint16_t HuffDecoderCommon::table18_113_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x0001, 0x00a2, 0x0001, 0x00b2,
    0x0001, 0x00c2, 0x0001, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212,
    0x0222, 0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292,
    0x02a2, 0x02b2, 0x02c2, 0x02d2, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_114_emit_[44] = {
    0x24, 0x30, 0x24, 0x31, 0x24, 0x32, 0x24, 0x61, 0x24, 0x63, 0x24,
    0x65, 0x24, 0x69, 0x24, 0x6f, 0x24, 0x73, 0x24, 0x74, 0x24, 0x20,
    0x24, 0x25, 0x24, 0x2d, 0x24, 0x2e, 0x24, 0x2f, 0x24, 0x33, 0x24,
    0x34, 0x24, 0x35, 0x24, 0x36, 0x24, 0x37, 0x24, 0x38, 0x24, 0x39};
const uint8_t HuffDecoderCommon::table18_115_emit_[92] = {
    0x24, 0x3d, 0x24, 0x41, 0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66,
    0x24, 0x67, 0x24, 0x68, 0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70,
    0x24, 0x72, 0x24, 0x75, 0x24, 0x3a, 0x24, 0x42, 0x24, 0x43, 0x24, 0x44,
    0x24, 0x45, 0x24, 0x46, 0x24, 0x47, 0x24, 0x48, 0x24, 0x49, 0x24, 0x4a,
    0x24, 0x4b, 0x24, 0x4c, 0x24, 0x4d, 0x24, 0x4e, 0x24, 0x4f, 0x24, 0x50,
    0x24, 0x51, 0x24, 0x52, 0x24, 0x53, 0x24, 0x54, 0x24, 0x55, 0x24, 0x56,
    0x24, 0x57, 0x24, 0x59, 0x24, 0x6a, 0x24, 0x6b, 0x24, 0x71, 0x24, 0x76,
    0x24, 0x77, 0x24, 0x78, 0x24, 0x79, 0x24, 0x7a};
const uint8_t HuffDecoderCommon::table18_116_emit_[44] = {
    0x40, 0x30, 0x40, 0x31, 0x40, 0x32, 0x40, 0x61, 0x40, 0x63, 0x40,
    0x65, 0x40, 0x69, 0x40, 0x6f, 0x40, 0x73, 0x40, 0x74, 0x40, 0x20,
    0x40, 0x25, 0x40, 0x2d, 0x40, 0x2e, 0x40, 0x2f, 0x40, 0x33, 0x40,
    0x34, 0x40, 0x35, 0x40, 0x36, 0x40, 0x37, 0x40, 0x38, 0x40, 0x39};
const uint8_t HuffDecoderCommon::table18_117_emit_[92] = {
    0x40, 0x3d, 0x40, 0x41, 0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66,
    0x40, 0x67, 0x40, 0x68, 0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70,
    0x40, 0x72, 0x40, 0x75, 0x40, 0x3a, 0x40, 0x42, 0x40, 0x43, 0x40, 0x44,
    0x40, 0x45, 0x40, 0x46, 0x40, 0x47, 0x40, 0x48, 0x40, 0x49, 0x40, 0x4a,
    0x40, 0x4b, 0x40, 0x4c, 0x40, 0x4d, 0x40, 0x4e, 0x40, 0x4f, 0x40, 0x50,
    0x40, 0x51, 0x40, 0x52, 0x40, 0x53, 0x40, 0x54, 0x40, 0x55, 0x40, 0x56,
    0x40, 0x57, 0x40, 0x59, 0x40, 0x6a, 0x40, 0x6b, 0x40, 0x71, 0x40, 0x76,
    0x40, 0x77, 0x40, 0x78, 0x40, 0x79, 0x40, 0x7a};
const uint8_t HuffDecoderCommon::table18_118_emit_[44] = {
    0x5b, 0x30, 0x5b, 0x31, 0x5b, 0x32, 0x5b, 0x61, 0x5b, 0x63, 0x5b,
    0x65, 0x5b, 0x69, 0x5b, 0x6f, 0x5b, 0x73, 0x5b, 0x74, 0x5b, 0x20,
    0x5b, 0x25, 0x5b, 0x2d, 0x5b, 0x2e, 0x5b, 0x2f, 0x5b, 0x33, 0x5b,
    0x34, 0x5b, 0x35, 0x5b, 0x36, 0x5b, 0x37, 0x5b, 0x38, 0x5b, 0x39};
const uint8_t HuffDecoderCommon::table18_119_emit_[92] = {
    0x5b, 0x3d, 0x5b, 0x41, 0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66,
    0x5b, 0x67, 0x5b, 0x68, 0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70,
    0x5b, 0x72, 0x5b, 0x75, 0x5b, 0x3a, 0x5b, 0x42, 0x5b, 0x43, 0x5b, 0x44,
    0x5b, 0x45, 0x5b, 0x46, 0x5b, 0x47, 0x5b, 0x48, 0x5b, 0x49, 0x5b, 0x4a,
    0x5b, 0x4b, 0x5b, 0x4c, 0x5b, 0x4d, 0x5b, 0x4e, 0x5b, 0x4f, 0x5b, 0x50,
    0x5b, 0x51, 0x5b, 0x52, 0x5b, 0x53, 0x5b, 0x54, 0x5b, 0x55, 0x5b, 0x56,
    0x5b, 0x57, 0x5b, 0x59, 0x5b, 0x6a, 0x5b, 0x6b, 0x5b, 0x71, 0x5b, 0x76,
    0x5b, 0x77, 0x5b, 0x78, 0x5b, 0x79, 0x5b, 0x7a};
const uint8_t HuffDecoderCommon::table18_120_emit_[44] = {
    0x5d, 0x30, 0x5d, 0x31, 0x5d, 0x32, 0x5d, 0x61, 0x5d, 0x63, 0x5d,
    0x65, 0x5d, 0x69, 0x5d, 0x6f, 0x5d, 0x73, 0x5d, 0x74, 0x5d, 0x20,
    0x5d, 0x25, 0x5d, 0x2d, 0x5d, 0x2e, 0x5d, 0x2f, 0x5d, 0x33, 0x5d,
    0x34, 0x5d, 0x35, 0x5d, 0x36, 0x5d, 0x37, 0x5d, 0x38, 0x5d, 0x39};
const uint8_t HuffDecoderCommon::table18_121_emit_[92] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66,
    0x5d, 0x67, 0x5d, 0x68, 0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70,
    0x5d, 0x72, 0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44,
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d, 0x4a,
    0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f, 0x5d, 0x50,
    0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54, 0x5d, 0x55, 0x5d, 0x56,
    0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b, 0x5d, 0x71, 0x5d, 0x76,
    0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a};
const uint8_t HuffDecoderCommon::table18_122_emit_[44] = {
    0x7e, 0x30, 0x7e, 0x31, 0x7e, 0x32, 0x7e, 0x61, 0x7e, 0x63, 0x7e,
    0x65, 0x7e, 0x69, 0x7e, 0x6f, 0x7e, 0x73, 0x7e, 0x74, 0x7e, 0x20,
    0x7e, 0x25, 0x7e, 0x2d, 0x7e, 0x2e, 0x7e, 0x2f, 0x7e, 0x33, 0x7e,
    0x34, 0x7e, 0x35, 0x7e, 0x36, 0x7e, 0x37, 0x7e, 0x38, 0x7e, 0x39};
const uint8_t HuffDecoderCommon::table18_123_emit_[92] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66,
    0x7e, 0x67, 0x7e, 0x68, 0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70,
    0x7e, 0x72, 0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44,
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e, 0x4a,
    0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f, 0x7e, 0x50,
    0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54, 0x7e, 0x55, 0x7e, 0x56,
    0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b, 0x7e, 0x71, 0x7e, 0x76,
    0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a};
const uint8_t HuffDecoderCommon::table18_124_emit_[72] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63, 0x5e, 0x65,
    0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20, 0x5e, 0x25,
    0x5e, 0x2d, 0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e, 0x34, 0x5e, 0x35,
    0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39, 0x5e, 0x3d, 0x5e, 0x41,
    0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66, 0x5e, 0x67, 0x5e, 0x68,
    0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70, 0x5e, 0x72, 0x5e, 0x75};
const uint16_t HuffDecoderCommon::table18_124_ops_[64] = {
    0x0001, 0x0002, 0x0001, 0x0012, 0x0001, 0x0022, 0x0001, 0x0032,
    0x0001, 0x0042, 0x0001, 0x0052, 0x0001, 0x0062, 0x0001, 0x0072,
    0x0001, 0x0082, 0x0001, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2,
    0x00e2, 0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152,
    0x0162, 0x0172, 0x0182, 0x0192, 0x01a2, 0x01b2, 0x01c2, 0x01d2,
    0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222, 0x0232, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003};
const uint8_t HuffDecoderCommon::table18_125_emit_[72] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63, 0x7d, 0x65,
    0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20, 0x7d, 0x25,
    0x7d, 0x2d, 0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d, 0x34, 0x7d, 0x35,
    0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39, 0x7d, 0x3d, 0x7d, 0x41,
    0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66, 0x7d, 0x67, 0x7d, 0x68,
    0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70, 0x7d, 0x72, 0x7d, 0x75};
const uint8_t HuffDecoderCommon::table18_126_emit_[40] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63,
    0x3c, 0x65, 0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74,
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63,
    0x60, 0x65, 0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74};
const uint16_t HuffDecoderCommon::table18_126_ops_[64] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112,
    0x0122, 0x0132, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x00a3};
const uint8_t HuffDecoderCommon::table18_127_emit_[31] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b,
    0x65, 0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x5c, 0xc3,
    0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2};
const uint16_t HuffDecoderCommon::table18_127_ops_[64] = {
    0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0003,
    0x0001, 0x00a3, 0x0001, 0x00ab, 0x0001, 0x00b3, 0x00bb, 0x00c3,
    0x00cb, 0x00d3, 0x00db, 0x00e3, 0x00eb, 0x00f3, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001,
    0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0001, 0x0004};
const uint8_t* const HuffDecoderCommon::table18_emit_[128] = {
    table18_0_emit_,   table18_1_emit_,   table18_2_emit_,   table18_3_emit_,
    table18_4_emit_,   table18_5_emit_,   table18_6_emit_,   table18_7_emit_,
    table18_8_emit_,   table18_9_emit_,   table18_10_emit_,  table18_11_emit_,
    table18_12_emit_,  table18_13_emit_,  table18_14_emit_,  table18_15_emit_,
    table18_16_emit_,  table18_17_emit_,  table18_18_emit_,  table18_19_emit_,
    table18_20_emit_,  table18_21_emit_,  table18_22_emit_,  table18_23_emit_,
    table18_24_emit_,  table18_25_emit_,  table18_26_emit_,  table18_27_emit_,
    table18_28_emit_,  table18_29_emit_,  table18_30_emit_,  table18_31_emit_,
    table18_32_emit_,  table18_33_emit_,  table18_34_emit_,  table18_35_emit_,
    table18_36_emit_,  table18_37_emit_,  table18_38_emit_,  table18_39_emit_,
    table18_40_emit_,  table18_41_emit_,  table18_42_emit_,  table18_43_emit_,
    table18_44_emit_,  table18_45_emit_,  table18_46_emit_,  table18_47_emit_,
    table18_48_emit_,  table18_49_emit_,  table18_50_emit_,  table18_51_emit_,
    table18_52_emit_,  table18_53_emit_,  table18_54_emit_,  table18_55_emit_,
    table18_56_emit_,  table18_57_emit_,  table18_58_emit_,  table18_59_emit_,
    table18_60_emit_,  table18_61_emit_,  table18_62_emit_,  table18_63_emit_,
    table18_64_emit_,  table18_65_emit_,  table18_66_emit_,  table18_67_emit_,
    table18_68_emit_,  table18_69_emit_,  table18_70_emit_,  table18_71_emit_,
    table18_72_emit_,  table18_73_emit_,  table18_74_emit_,  table18_75_emit_,
    table18_76_emit_,  table18_77_emit_,  table18_78_emit_,  table18_79_emit_,
    table18_80_emit_,  table18_81_emit_,  table18_82_emit_,  table18_83_emit_,
    table18_84_emit_,  table18_85_emit_,  table18_86_emit_,  table18_87_emit_,
    table18_88_emit_,  table18_89_emit_,  table18_90_emit_,  table18_91_emit_,
    table18_92_emit_,  table18_93_emit_,  table18_94_emit_,  table18_95_emit_,
    table18_96_emit_,  table18_97_emit_,  table18_98_emit_,  table18_99_emit_,
    table18_100_emit_, table18_101_emit_, table18_102_emit_, table18_103_emit_,
    table18_104_emit_, table18_105_emit_, table18_106_emit_, table18_107_emit_,
    table18_108_emit_, table18_109_emit_, table18_110_emit_, table18_111_emit_,
    table18_112_emit_, table18_113_emit_, table18_114_emit_, table18_115_emit_,
    table18_116_emit_, table18_117_emit_, table18_118_emit_, table18_119_emit_,
    table18_120_emit_, table18_121_emit_, table18_122_emit_, table18_123_emit_,
    table18_124_emit_, table18_125_emit_, table18_126_emit_, table18_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table18_ops_[128] = {
    table18_0_ops_,   table18_0_ops_,   table18_0_ops_,   table18_0_ops_,
    table18_0_ops_,   table18_5_ops_,   table18_5_ops_,   table18_5_ops_,
    table18_5_ops_,   table18_5_ops_,   table18_5_ops_,   table18_11_ops_,
    table18_12_ops_,  table18_12_ops_,  table18_12_ops_,  table18_15_ops_,
    table18_0_ops_,   table18_0_ops_,   table18_0_ops_,   table18_0_ops_,
    table18_0_ops_,   table18_5_ops_,   table18_5_ops_,   table18_5_ops_,
    table18_5_ops_,   table18_5_ops_,   table18_5_ops_,   table18_11_ops_,
    table18_12_ops_,  table18_12_ops_,  table18_12_ops_,  table18_31_ops_,
    table18_0_ops_,   table18_0_ops_,   table18_0_ops_,   table18_0_ops_,
    table18_0_ops_,   table18_5_ops_,   table18_5_ops_,   table18_5_ops_,
    table18_5_ops_,   table18_5_ops_,   table18_5_ops_,   table18_11_ops_,
    table18_12_ops_,  table18_12_ops_,  table18_12_ops_,  table18_47_ops_,
    table18_0_ops_,   table18_0_ops_,   table18_0_ops_,   table18_0_ops_,
    table18_0_ops_,   table18_5_ops_,   table18_5_ops_,   table18_5_ops_,
    table18_5_ops_,   table18_5_ops_,   table18_5_ops_,   table18_11_ops_,
    table18_12_ops_,  table18_12_ops_,  table18_12_ops_,  table18_63_ops_,
    table18_0_ops_,   table18_0_ops_,   table18_0_ops_,   table18_0_ops_,
    table18_0_ops_,   table18_5_ops_,   table18_5_ops_,   table18_5_ops_,
    table18_5_ops_,   table18_5_ops_,   table18_5_ops_,   table18_11_ops_,
    table18_12_ops_,  table18_12_ops_,  table18_12_ops_,  table18_79_ops_,
    table18_5_ops_,   table18_5_ops_,   table18_11_ops_,  table18_12_ops_,
    table18_12_ops_,  table18_85_ops_,  table18_86_ops_,  table18_87_ops_,
    table18_5_ops_,   table18_5_ops_,   table18_11_ops_,  table18_12_ops_,
    table18_12_ops_,  table18_85_ops_,  table18_86_ops_,  table18_87_ops_,
    table18_5_ops_,   table18_5_ops_,   table18_11_ops_,  table18_12_ops_,
    table18_12_ops_,  table18_85_ops_,  table18_86_ops_,  table18_87_ops_,
    table18_12_ops_,  table18_105_ops_, table18_106_ops_, table18_107_ops_,
    table18_12_ops_,  table18_105_ops_, table18_106_ops_, table18_107_ops_,
    table18_112_ops_, table18_113_ops_, table18_112_ops_, table18_113_ops_,
    table18_112_ops_, table18_113_ops_, table18_112_ops_, table18_113_ops_,
    table18_112_ops_, table18_113_ops_, table18_112_ops_, table18_113_ops_,
    table18_124_ops_, table18_124_ops_, table18_126_ops_, table18_127_ops_,
};
const uint8_t HuffDecoderCommon::table19_0_emit_[216] = {
    0x21, 0x30, 0x30, 0x21, 0x30, 0x31, 0x21, 0x30, 0x32, 0x21, 0x30, 0x61,
    0x21, 0x30, 0x63, 0x21, 0x30, 0x65, 0x21, 0x30, 0x69, 0x21, 0x30, 0x6f,
    0x21, 0x30, 0x73, 0x21, 0x30, 0x74, 0x21, 0x30, 0x20, 0x21, 0x30, 0x25,
    0x21, 0x30, 0x2d, 0x21, 0x30, 0x2e, 0x21, 0x30, 0x2f, 0x21, 0x30, 0x33,
    0x21, 0x30, 0x34, 0x21, 0x30, 0x35, 0x21, 0x30, 0x36, 0x21, 0x30, 0x37,
    0x21, 0x30, 0x38, 0x21, 0x30, 0x39, 0x21, 0x30, 0x3d, 0x21, 0x30, 0x41,
    0x21, 0x30, 0x5f, 0x21, 0x30, 0x62, 0x21, 0x30, 0x64, 0x21, 0x30, 0x66,
    0x21, 0x30, 0x67, 0x21, 0x30, 0x68, 0x21, 0x30, 0x6c, 0x21, 0x30, 0x6d,
    0x21, 0x30, 0x6e, 0x21, 0x30, 0x70, 0x21, 0x30, 0x72, 0x21, 0x30, 0x75,
    0x21, 0x31, 0x30, 0x21, 0x31, 0x31, 0x21, 0x31, 0x32, 0x21, 0x31, 0x61,
    0x21, 0x31, 0x63, 0x21, 0x31, 0x65, 0x21, 0x31, 0x69, 0x21, 0x31, 0x6f,
    0x21, 0x31, 0x73, 0x21, 0x31, 0x74, 0x21, 0x31, 0x20, 0x21, 0x31, 0x25,
    0x21, 0x31, 0x2d, 0x21, 0x31, 0x2e, 0x21, 0x31, 0x2f, 0x21, 0x31, 0x33,
    0x21, 0x31, 0x34, 0x21, 0x31, 0x35, 0x21, 0x31, 0x36, 0x21, 0x31, 0x37,
    0x21, 0x31, 0x38, 0x21, 0x31, 0x39, 0x21, 0x31, 0x3d, 0x21, 0x31, 0x41,
    0x21, 0x31, 0x5f, 0x21, 0x31, 0x62, 0x21, 0x31, 0x64, 0x21, 0x31, 0x66,
    0x21, 0x31, 0x67, 0x21, 0x31, 0x68, 0x21, 0x31, 0x6c, 0x21, 0x31, 0x6d,
    0x21, 0x31, 0x6e, 0x21, 0x31, 0x70, 0x21, 0x31, 0x72, 0x21, 0x31, 0x75};
const uint16_t HuffDecoderCommon::table19_0_inner_[75] = {
    0x0000, 0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9,
    0x00c1, 0x00d9, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169, 0x0181,
    0x0199, 0x01b1, 0x01c9, 0x01e1, 0x01f9, 0x0211, 0x0229, 0x0241, 0x0259,
    0x0271, 0x0289, 0x02a1, 0x02b9, 0x02d1, 0x02e9, 0x0301, 0x0319, 0x0331,
    0x0349, 0x0002, 0x0361, 0x0379, 0x0391, 0x03a9, 0x03c1, 0x03d9, 0x03f1,
    0x0409, 0x0421, 0x0439, 0x0451, 0x0469, 0x0481, 0x0499, 0x04b1, 0x04c9,
    0x04e1, 0x04f9, 0x0511, 0x0529, 0x0541, 0x0559, 0x0571, 0x0589, 0x05a1,
    0x05b9, 0x05d1, 0x05e9, 0x0601, 0x0619, 0x0631, 0x0649, 0x0661, 0x0679,
    0x0691, 0x06a9, 0x0362};
const uint8_t HuffDecoderCommon::table19_0_outer_[128] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,  0,  9,  0,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
    29, 30, 31, 32, 33, 34, 35, 36, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  37, 0,  38, 0,  39, 0,  40, 0,  41, 0,  42, 0,  43,
    0,  44, 0,  45, 0,  46, 0,  47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
    59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  74};
const uint8_t HuffDecoderCommon::table19_1_emit_[216] = {
    0x21, 0x32, 0x30, 0x21, 0x32, 0x31, 0x21, 0x32, 0x32, 0x21, 0x32, 0x61,
    0x21, 0x32, 0x63, 0x21, 0x32, 0x65, 0x21, 0x32, 0x69, 0x21, 0x32, 0x6f,
    0x21, 0x32, 0x73, 0x21, 0x32, 0x74, 0x21, 0x32, 0x20, 0x21, 0x32, 0x25,
    0x21, 0x32, 0x2d, 0x21, 0x32, 0x2e, 0x21, 0x32, 0x2f, 0x21, 0x32, 0x33,
    0x21, 0x32, 0x34, 0x21, 0x32, 0x35, 0x21, 0x32, 0x36, 0x21, 0x32, 0x37,
    0x21, 0x32, 0x38, 0x21, 0x32, 0x39, 0x21, 0x32, 0x3d, 0x21, 0x32, 0x41,
    0x21, 0x32, 0x5f, 0x21, 0x32, 0x62, 0x21, 0x32, 0x64, 0x21, 0x32, 0x66,
    0x21, 0x32, 0x67, 0x21, 0x32, 0x68, 0x21, 0x32, 0x6c, 0x21, 0x32, 0x6d,
    0x21, 0x32, 0x6e, 0x21, 0x32, 0x70, 0x21, 0x32, 0x72, 0x21, 0x32, 0x75,
    0x21, 0x61, 0x30, 0x21, 0x61, 0x31, 0x21, 0x61, 0x32, 0x21, 0x61, 0x61,
    0x21, 0x61, 0x63, 0x21, 0x61, 0x65, 0x21, 0x61, 0x69, 0x21, 0x61, 0x6f,
    0x21, 0x61, 0x73, 0x21, 0x61, 0x74, 0x21, 0x61, 0x20, 0x21, 0x61, 0x25,
    0x21, 0x61, 0x2d, 0x21, 0x61, 0x2e, 0x21, 0x61, 0x2f, 0x21, 0x61, 0x33,
    0x21, 0x61, 0x34, 0x21, 0x61, 0x35, 0x21, 0x61, 0x36, 0x21, 0x61, 0x37,
    0x21, 0x61, 0x38, 0x21, 0x61, 0x39, 0x21, 0x61, 0x3d, 0x21, 0x61, 0x41,
    0x21, 0x61, 0x5f, 0x21, 0x61, 0x62, 0x21, 0x61, 0x64, 0x21, 0x61, 0x66,
    0x21, 0x61, 0x67, 0x21, 0x61, 0x68, 0x21, 0x61, 0x6c, 0x21, 0x61, 0x6d,
    0x21, 0x61, 0x6e, 0x21, 0x61, 0x70, 0x21, 0x61, 0x72, 0x21, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table19_2_emit_[216] = {
    0x21, 0x63, 0x30, 0x21, 0x63, 0x31, 0x21, 0x63, 0x32, 0x21, 0x63, 0x61,
    0x21, 0x63, 0x63, 0x21, 0x63, 0x65, 0x21, 0x63, 0x69, 0x21, 0x63, 0x6f,
    0x21, 0x63, 0x73, 0x21, 0x63, 0x74, 0x21, 0x63, 0x20, 0x21, 0x63, 0x25,
    0x21, 0x63, 0x2d, 0x21, 0x63, 0x2e, 0x21, 0x63, 0x2f, 0x21, 0x63, 0x33,
    0x21, 0x63, 0x34, 0x21, 0x63, 0x35, 0x21, 0x63, 0x36, 0x21, 0x63, 0x37,
    0x21, 0x63, 0x38, 0x21, 0x63, 0x39, 0x21, 0x63, 0x3d, 0x21, 0x63, 0x41,
    0x21, 0x63, 0x5f, 0x21, 0x63, 0x62, 0x21, 0x63, 0x64, 0x21, 0x63, 0x66,
    0x21, 0x63, 0x67, 0x21, 0x63, 0x68, 0x21, 0x63, 0x6c, 0x21, 0x63, 0x6d,
    0x21, 0x63, 0x6e, 0x21, 0x63, 0x70, 0x21, 0x63, 0x72, 0x21, 0x63, 0x75,
    0x21, 0x65, 0x30, 0x21, 0x65, 0x31, 0x21, 0x65, 0x32, 0x21, 0x65, 0x61,
    0x21, 0x65, 0x63, 0x21, 0x65, 0x65, 0x21, 0x65, 0x69, 0x21, 0x65, 0x6f,
    0x21, 0x65, 0x73, 0x21, 0x65, 0x74, 0x21, 0x65, 0x20, 0x21, 0x65, 0x25,
    0x21, 0x65, 0x2d, 0x21, 0x65, 0x2e, 0x21, 0x65, 0x2f, 0x21, 0x65, 0x33,
    0x21, 0x65, 0x34, 0x21, 0x65, 0x35, 0x21, 0x65, 0x36, 0x21, 0x65, 0x37,
    0x21, 0x65, 0x38, 0x21, 0x65, 0x39, 0x21, 0x65, 0x3d, 0x21, 0x65, 0x41,
    0x21, 0x65, 0x5f, 0x21, 0x65, 0x62, 0x21, 0x65, 0x64, 0x21, 0x65, 0x66,
    0x21, 0x65, 0x67, 0x21, 0x65, 0x68, 0x21, 0x65, 0x6c, 0x21, 0x65, 0x6d,
    0x21, 0x65, 0x6e, 0x21, 0x65, 0x70, 0x21, 0x65, 0x72, 0x21, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table19_3_emit_[216] = {
    0x21, 0x69, 0x30, 0x21, 0x69, 0x31, 0x21, 0x69, 0x32, 0x21, 0x69, 0x61,
    0x21, 0x69, 0x63, 0x21, 0x69, 0x65, 0x21, 0x69, 0x69, 0x21, 0x69, 0x6f,
    0x21, 0x69, 0x73, 0x21, 0x69, 0x74, 0x21, 0x69, 0x20, 0x21, 0x69, 0x25,
    0x21, 0x69, 0x2d, 0x21, 0x69, 0x2e, 0x21, 0x69, 0x2f, 0x21, 0x69, 0x33,
    0x21, 0x69, 0x34, 0x21, 0x69, 0x35, 0x21, 0x69, 0x36, 0x21, 0x69, 0x37,
    0x21, 0x69, 0x38, 0x21, 0x69, 0x39, 0x21, 0x69, 0x3d, 0x21, 0x69, 0x41,
    0x21, 0x69, 0x5f, 0x21, 0x69, 0x62, 0x21, 0x69, 0x64, 0x21, 0x69, 0x66,
    0x21, 0x69, 0x67, 0x21, 0x69, 0x68, 0x21, 0x69, 0x6c, 0x21, 0x69, 0x6d,
    0x21, 0x69, 0x6e, 0x21, 0x69, 0x70, 0x21, 0x69, 0x72, 0x21, 0x69, 0x75,
    0x21, 0x6f, 0x30, 0x21, 0x6f, 0x31, 0x21, 0x6f, 0x32, 0x21, 0x6f, 0x61,
    0x21, 0x6f, 0x63, 0x21, 0x6f, 0x65, 0x21, 0x6f, 0x69, 0x21, 0x6f, 0x6f,
    0x21, 0x6f, 0x73, 0x21, 0x6f, 0x74, 0x21, 0x6f, 0x20, 0x21, 0x6f, 0x25,
    0x21, 0x6f, 0x2d, 0x21, 0x6f, 0x2e, 0x21, 0x6f, 0x2f, 0x21, 0x6f, 0x33,
    0x21, 0x6f, 0x34, 0x21, 0x6f, 0x35, 0x21, 0x6f, 0x36, 0x21, 0x6f, 0x37,
    0x21, 0x6f, 0x38, 0x21, 0x6f, 0x39, 0x21, 0x6f, 0x3d, 0x21, 0x6f, 0x41,
    0x21, 0x6f, 0x5f, 0x21, 0x6f, 0x62, 0x21, 0x6f, 0x64, 0x21, 0x6f, 0x66,
    0x21, 0x6f, 0x67, 0x21, 0x6f, 0x68, 0x21, 0x6f, 0x6c, 0x21, 0x6f, 0x6d,
    0x21, 0x6f, 0x6e, 0x21, 0x6f, 0x70, 0x21, 0x6f, 0x72, 0x21, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table19_4_emit_[216] = {
    0x21, 0x73, 0x30, 0x21, 0x73, 0x31, 0x21, 0x73, 0x32, 0x21, 0x73, 0x61,
    0x21, 0x73, 0x63, 0x21, 0x73, 0x65, 0x21, 0x73, 0x69, 0x21, 0x73, 0x6f,
    0x21, 0x73, 0x73, 0x21, 0x73, 0x74, 0x21, 0x73, 0x20, 0x21, 0x73, 0x25,
    0x21, 0x73, 0x2d, 0x21, 0x73, 0x2e, 0x21, 0x73, 0x2f, 0x21, 0x73, 0x33,
    0x21, 0x73, 0x34, 0x21, 0x73, 0x35, 0x21, 0x73, 0x36, 0x21, 0x73, 0x37,
    0x21, 0x73, 0x38, 0x21, 0x73, 0x39, 0x21, 0x73, 0x3d, 0x21, 0x73, 0x41,
    0x21, 0x73, 0x5f, 0x21, 0x73, 0x62, 0x21, 0x73, 0x64, 0x21, 0x73, 0x66,
    0x21, 0x73, 0x67, 0x21, 0x73, 0x68, 0x21, 0x73, 0x6c, 0x21, 0x73, 0x6d,
    0x21, 0x73, 0x6e, 0x21, 0x73, 0x70, 0x21, 0x73, 0x72, 0x21, 0x73, 0x75,
    0x21, 0x74, 0x30, 0x21, 0x74, 0x31, 0x21, 0x74, 0x32, 0x21, 0x74, 0x61,
    0x21, 0x74, 0x63, 0x21, 0x74, 0x65, 0x21, 0x74, 0x69, 0x21, 0x74, 0x6f,
    0x21, 0x74, 0x73, 0x21, 0x74, 0x74, 0x21, 0x74, 0x20, 0x21, 0x74, 0x25,
    0x21, 0x74, 0x2d, 0x21, 0x74, 0x2e, 0x21, 0x74, 0x2f, 0x21, 0x74, 0x33,
    0x21, 0x74, 0x34, 0x21, 0x74, 0x35, 0x21, 0x74, 0x36, 0x21, 0x74, 0x37,
    0x21, 0x74, 0x38, 0x21, 0x74, 0x39, 0x21, 0x74, 0x3d, 0x21, 0x74, 0x41,
    0x21, 0x74, 0x5f, 0x21, 0x74, 0x62, 0x21, 0x74, 0x64, 0x21, 0x74, 0x66,
    0x21, 0x74, 0x67, 0x21, 0x74, 0x68, 0x21, 0x74, 0x6c, 0x21, 0x74, 0x6d,
    0x21, 0x74, 0x6e, 0x21, 0x74, 0x70, 0x21, 0x74, 0x72, 0x21, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table19_5_emit_[120] = {
    0x21, 0x20, 0x30, 0x21, 0x20, 0x31, 0x21, 0x20, 0x32, 0x21, 0x20, 0x61,
    0x21, 0x20, 0x63, 0x21, 0x20, 0x65, 0x21, 0x20, 0x69, 0x21, 0x20, 0x6f,
    0x21, 0x20, 0x73, 0x21, 0x20, 0x74, 0x21, 0x25, 0x30, 0x21, 0x25, 0x31,
    0x21, 0x25, 0x32, 0x21, 0x25, 0x61, 0x21, 0x25, 0x63, 0x21, 0x25, 0x65,
    0x21, 0x25, 0x69, 0x21, 0x25, 0x6f, 0x21, 0x25, 0x73, 0x21, 0x25, 0x74,
    0x21, 0x2d, 0x30, 0x21, 0x2d, 0x31, 0x21, 0x2d, 0x32, 0x21, 0x2d, 0x61,
    0x21, 0x2d, 0x63, 0x21, 0x2d, 0x65, 0x21, 0x2d, 0x69, 0x21, 0x2d, 0x6f,
    0x21, 0x2d, 0x73, 0x21, 0x2d, 0x74, 0x21, 0x2e, 0x30, 0x21, 0x2e, 0x31,
    0x21, 0x2e, 0x32, 0x21, 0x2e, 0x61, 0x21, 0x2e, 0x63, 0x21, 0x2e, 0x65,
    0x21, 0x2e, 0x69, 0x21, 0x2e, 0x6f, 0x21, 0x2e, 0x73, 0x21, 0x2e, 0x74};
const uint16_t HuffDecoderCommon::table19_5_inner_[45] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169,
    0x0181, 0x0199, 0x01b1, 0x01c9, 0x00f2, 0x01e1, 0x01f9, 0x0211, 0x0229,
    0x0241, 0x0259, 0x0271, 0x0289, 0x02a1, 0x02b9, 0x01e2, 0x02d1, 0x02e9,
    0x0301, 0x0319, 0x0331, 0x0349, 0x0361, 0x0379, 0x0391, 0x03a9, 0x02d2};
const uint8_t HuffDecoderCommon::table19_5_outer_[128] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 44};
const uint8_t HuffDecoderCommon::table19_6_emit_[120] = {
    0x21, 0x2f, 0x30, 0x21, 0x2f, 0x31, 0x21, 0x2f, 0x32, 0x21, 0x2f, 0x61,
    0x21, 0x2f, 0x63, 0x21, 0x2f, 0x65, 0x21, 0x2f, 0x69, 0x21, 0x2f, 0x6f,
    0x21, 0x2f, 0x73, 0x21, 0x2f, 0x74, 0x21, 0x33, 0x30, 0x21, 0x33, 0x31,
    0x21, 0x33, 0x32, 0x21, 0x33, 0x61, 0x21, 0x33, 0x63, 0x21, 0x33, 0x65,
    0x21, 0x33, 0x69, 0x21, 0x33, 0x6f, 0x21, 0x33, 0x73, 0x21, 0x33, 0x74,
    0x21, 0x34, 0x30, 0x21, 0x34, 0x31, 0x21, 0x34, 0x32, 0x21, 0x34, 0x61,
    0x21, 0x34, 0x63, 0x21, 0x34, 0x65, 0x21, 0x34, 0x69, 0x21, 0x34, 0x6f,
    0x21, 0x34, 0x73, 0x21, 0x34, 0x74, 0x21, 0x35, 0x30, 0x21, 0x35, 0x31,
    0x21, 0x35, 0x32, 0x21, 0x35, 0x61, 0x21, 0x35, 0x63, 0x21, 0x35, 0x65,
    0x21, 0x35, 0x69, 0x21, 0x35, 0x6f, 0x21, 0x35, 0x73, 0x21, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table19_7_emit_[120] = {
    0x21, 0x36, 0x30, 0x21, 0x36, 0x31, 0x21, 0x36, 0x32, 0x21, 0x36, 0x61,
    0x21, 0x36, 0x63, 0x21, 0x36, 0x65, 0x21, 0x36, 0x69, 0x21, 0x36, 0x6f,
    0x21, 0x36, 0x73, 0x21, 0x36, 0x74, 0x21, 0x37, 0x30, 0x21, 0x37, 0x31,
    0x21, 0x37, 0x32, 0x21, 0x37, 0x61, 0x21, 0x37, 0x63, 0x21, 0x37, 0x65,
    0x21, 0x37, 0x69, 0x21, 0x37, 0x6f, 0x21, 0x37, 0x73, 0x21, 0x37, 0x74,
    0x21, 0x38, 0x30, 0x21, 0x38, 0x31, 0x21, 0x38, 0x32, 0x21, 0x38, 0x61,
    0x21, 0x38, 0x63, 0x21, 0x38, 0x65, 0x21, 0x38, 0x69, 0x21, 0x38, 0x6f,
    0x21, 0x38, 0x73, 0x21, 0x38, 0x74, 0x21, 0x39, 0x30, 0x21, 0x39, 0x31,
    0x21, 0x39, 0x32, 0x21, 0x39, 0x61, 0x21, 0x39, 0x63, 0x21, 0x39, 0x65,
    0x21, 0x39, 0x69, 0x21, 0x39, 0x6f, 0x21, 0x39, 0x73, 0x21, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table19_8_emit_[120] = {
    0x21, 0x3d, 0x30, 0x21, 0x3d, 0x31, 0x21, 0x3d, 0x32, 0x21, 0x3d, 0x61,
    0x21, 0x3d, 0x63, 0x21, 0x3d, 0x65, 0x21, 0x3d, 0x69, 0x21, 0x3d, 0x6f,
    0x21, 0x3d, 0x73, 0x21, 0x3d, 0x74, 0x21, 0x41, 0x30, 0x21, 0x41, 0x31,
    0x21, 0x41, 0x32, 0x21, 0x41, 0x61, 0x21, 0x41, 0x63, 0x21, 0x41, 0x65,
    0x21, 0x41, 0x69, 0x21, 0x41, 0x6f, 0x21, 0x41, 0x73, 0x21, 0x41, 0x74,
    0x21, 0x5f, 0x30, 0x21, 0x5f, 0x31, 0x21, 0x5f, 0x32, 0x21, 0x5f, 0x61,
    0x21, 0x5f, 0x63, 0x21, 0x5f, 0x65, 0x21, 0x5f, 0x69, 0x21, 0x5f, 0x6f,
    0x21, 0x5f, 0x73, 0x21, 0x5f, 0x74, 0x21, 0x62, 0x30, 0x21, 0x62, 0x31,
    0x21, 0x62, 0x32, 0x21, 0x62, 0x61, 0x21, 0x62, 0x63, 0x21, 0x62, 0x65,
    0x21, 0x62, 0x69, 0x21, 0x62, 0x6f, 0x21, 0x62, 0x73, 0x21, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table19_9_emit_[120] = {
    0x21, 0x64, 0x30, 0x21, 0x64, 0x31, 0x21, 0x64, 0x32, 0x21, 0x64, 0x61,
    0x21, 0x64, 0x63, 0x21, 0x64, 0x65, 0x21, 0x64, 0x69, 0x21, 0x64, 0x6f,
    0x21, 0x64, 0x73, 0x21, 0x64, 0x74, 0x21, 0x66, 0x30, 0x21, 0x66, 0x31,
    0x21, 0x66, 0x32, 0x21, 0x66, 0x61, 0x21, 0x66, 0x63, 0x21, 0x66, 0x65,
    0x21, 0x66, 0x69, 0x21, 0x66, 0x6f, 0x21, 0x66, 0x73, 0x21, 0x66, 0x74,
    0x21, 0x67, 0x30, 0x21, 0x67, 0x31, 0x21, 0x67, 0x32, 0x21, 0x67, 0x61,
    0x21, 0x67, 0x63, 0x21, 0x67, 0x65, 0x21, 0x67, 0x69, 0x21, 0x67, 0x6f,
    0x21, 0x67, 0x73, 0x21, 0x67, 0x74, 0x21, 0x68, 0x30, 0x21, 0x68, 0x31,
    0x21, 0x68, 0x32, 0x21, 0x68, 0x61, 0x21, 0x68, 0x63, 0x21, 0x68, 0x65,
    0x21, 0x68, 0x69, 0x21, 0x68, 0x6f, 0x21, 0x68, 0x73, 0x21, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table19_10_emit_[120] = {
    0x21, 0x6c, 0x30, 0x21, 0x6c, 0x31, 0x21, 0x6c, 0x32, 0x21, 0x6c, 0x61,
    0x21, 0x6c, 0x63, 0x21, 0x6c, 0x65, 0x21, 0x6c, 0x69, 0x21, 0x6c, 0x6f,
    0x21, 0x6c, 0x73, 0x21, 0x6c, 0x74, 0x21, 0x6d, 0x30, 0x21, 0x6d, 0x31,
    0x21, 0x6d, 0x32, 0x21, 0x6d, 0x61, 0x21, 0x6d, 0x63, 0x21, 0x6d, 0x65,
    0x21, 0x6d, 0x69, 0x21, 0x6d, 0x6f, 0x21, 0x6d, 0x73, 0x21, 0x6d, 0x74,
    0x21, 0x6e, 0x30, 0x21, 0x6e, 0x31, 0x21, 0x6e, 0x32, 0x21, 0x6e, 0x61,
    0x21, 0x6e, 0x63, 0x21, 0x6e, 0x65, 0x21, 0x6e, 0x69, 0x21, 0x6e, 0x6f,
    0x21, 0x6e, 0x73, 0x21, 0x6e, 0x74, 0x21, 0x70, 0x30, 0x21, 0x70, 0x31,
    0x21, 0x70, 0x32, 0x21, 0x70, 0x61, 0x21, 0x70, 0x63, 0x21, 0x70, 0x65,
    0x21, 0x70, 0x69, 0x21, 0x70, 0x6f, 0x21, 0x70, 0x73, 0x21, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table19_11_emit_[68] = {
    0x21, 0x72, 0x30, 0x21, 0x72, 0x31, 0x21, 0x72, 0x32, 0x21, 0x72, 0x61,
    0x21, 0x72, 0x63, 0x21, 0x72, 0x65, 0x21, 0x72, 0x69, 0x21, 0x72, 0x6f,
    0x21, 0x72, 0x73, 0x21, 0x72, 0x74, 0x21, 0x75, 0x30, 0x21, 0x75, 0x31,
    0x21, 0x75, 0x32, 0x21, 0x75, 0x61, 0x21, 0x75, 0x63, 0x21, 0x75, 0x65,
    0x21, 0x75, 0x69, 0x21, 0x75, 0x6f, 0x21, 0x75, 0x73, 0x21, 0x75, 0x74,
    0x21, 0x3a, 0x21, 0x42, 0x21, 0x43, 0x21, 0x44};
const uint16_t HuffDecoderCommon::table19_11_inner_[27] = {
    0x0001, 0x0019, 0x0031, 0x0049, 0x0061, 0x0079, 0x0091, 0x00a9, 0x00c1,
    0x00d9, 0x0000, 0x0002, 0x00f1, 0x0109, 0x0121, 0x0139, 0x0151, 0x0169,
    0x0181, 0x0199, 0x01b1, 0x01c9, 0x00f2, 0x01e2, 0x01f2, 0x0202, 0x0212};
const uint8_t HuffDecoderCommon::table19_11_outer_[128] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 14, 15, 16, 17,
    18, 19, 20, 21, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 22, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 23, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    24, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 25, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 26};
const uint16_t HuffDecoderCommon::table19_12_inner_[9] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072};
const uint8_t HuffDecoderCommon::table19_12_outer_[128] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8};
const uint8_t HuffDecoderCommon::table19_15_emit_[35] = {
    0x21, 0x77, 0x21, 0x78, 0x21, 0x79, 0x21, 0x7a, 0x21, 0x26, 0x21, 0x2a,
    0x21, 0x2c, 0x21, 0x3b, 0x21, 0x58, 0x21, 0x5a, 0x21, 0x21, 0x22, 0x21,
    0x28, 0x21, 0x29, 0x21, 0x3f, 0x21, 0x27, 0x21, 0x2b, 0x21, 0x7c};
const uint16_t HuffDecoderCommon::table19_15_inner_[20] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052,
    0x0062, 0x0072, 0x0082, 0x0092, 0x00a2, 0x00aa, 0x00ba,
    0x00ca, 0x00da, 0x00ea, 0x00fa, 0x010a, 0x0003};
const uint8_t HuffDecoderCommon::table19_15_outer_[128] = {
    0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0, 0,  0,  0,  0,  1, 0, 0, 0, 0, 0, 0,
    0, 0,  0, 0,  0, 0,  0, 0,  0, 2,  0, 0,  0,  0,  0,  0, 0, 0, 0, 0, 0, 0,
    0, 0,  0, 3,  0, 0,  0, 0,  0, 0,  0, 0,  0,  0,  0,  0, 0, 0, 0, 4, 0, 0,
    0, 0,  0, 0,  0, 5,  0, 0,  0, 0,  0, 0,  0,  6,  0,  0, 0, 0, 0, 0, 0, 7,
    0, 0,  0, 0,  0, 0,  0, 8,  0, 0,  0, 0,  0,  0,  0,  9, 0, 0, 0, 0, 0, 0,
    0, 10, 0, 11, 0, 12, 0, 13, 0, 14, 0, 15, 16, 17, 18, 0, 0, 19};
const uint8_t HuffDecoderCommon::table19_16_emit_[216] = {
    0x22, 0x30, 0x30, 0x22, 0x30, 0x31, 0x22, 0x30, 0x32, 0x22, 0x30, 0x61,
    0x22, 0x30, 0x63, 0x22, 0x30, 0x65, 0x22, 0x30, 0x69, 0x22, 0x30, 0x6f,
    0x22, 0x30, 0x73, 0x22, 0x30, 0x74, 0x22, 0x30, 0x20, 0x22, 0x30, 0x25,
    0x22, 0x30, 0x2d, 0x22, 0x30, 0x2e, 0x22, 0x30, 0x2f, 0x22, 0x30, 0x33,
    0x22, 0x30, 0x34, 0x22, 0x30, 0x35, 0x22, 0x30, 0x36, 0x22, 0x30, 0x37,
    0x22, 0x30, 0x38, 0x22, 0x30, 0x39, 0x22, 0x30, 0x3d, 0x22, 0x30, 0x41,
    0x22, 0x30, 0x5f, 0x22, 0x30, 0x62, 0x22, 0x30, 0x64, 0x22, 0x30, 0x66,
    0x22, 0x30, 0x67, 0x22, 0x30, 0x68, 0x22, 0x30, 0x6c, 0x22, 0x30, 0x6d,
    0x22, 0x30, 0x6e, 0x22, 0x30, 0x70, 0x22, 0x30, 0x72, 0x22, 0x30, 0x75,
    0x22, 0x31, 0x30, 0x22, 0x31, 0x31, 0x22, 0x31, 0x32, 0x22, 0x31, 0x61,
    0x22, 0x31, 0x63, 0x22, 0x31, 0x65, 0x22, 0x31, 0x69, 0x22, 0x31, 0x6f,
    0x22, 0x31, 0x73, 0x22, 0x31, 0x74, 0x22, 0x31, 0x20, 0x22, 0x31, 0x25,
    0x22, 0x31, 0x2d, 0x22, 0x31, 0x2e, 0x22, 0x31, 0x2f, 0x22, 0x31, 0x33,
    0x22, 0x31, 0x34, 0x22, 0x31, 0x35, 0x22, 0x31, 0x36, 0x22, 0x31, 0x37,
    0x22, 0x31, 0x38, 0x22, 0x31, 0x39, 0x22, 0x31, 0x3d, 0x22, 0x31, 0x41,
    0x22, 0x31, 0x5f, 0x22, 0x31, 0x62, 0x22, 0x31, 0x64, 0x22, 0x31, 0x66,
    0x22, 0x31, 0x67, 0x22, 0x31, 0x68, 0x22, 0x31, 0x6c, 0x22, 0x31, 0x6d,
    0x22, 0x31, 0x6e, 0x22, 0x31, 0x70, 0x22, 0x31, 0x72, 0x22, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table19_17_emit_[216] = {
    0x22, 0x32, 0x30, 0x22, 0x32, 0x31, 0x22, 0x32, 0x32, 0x22, 0x32, 0x61,
    0x22, 0x32, 0x63, 0x22, 0x32, 0x65, 0x22, 0x32, 0x69, 0x22, 0x32, 0x6f,
    0x22, 0x32, 0x73, 0x22, 0x32, 0x74, 0x22, 0x32, 0x20, 0x22, 0x32, 0x25,
    0x22, 0x32, 0x2d, 0x22, 0x32, 0x2e, 0x22, 0x32, 0x2f, 0x22, 0x32, 0x33,
    0x22, 0x32, 0x34, 0x22, 0x32, 0x35, 0x22, 0x32, 0x36, 0x22, 0x32, 0x37,
    0x22, 0x32, 0x38, 0x22, 0x32, 0x39, 0x22, 0x32, 0x3d, 0x22, 0x32, 0x41,
    0x22, 0x32, 0x5f, 0x22, 0x32, 0x62, 0x22, 0x32, 0x64, 0x22, 0x32, 0x66,
    0x22, 0x32, 0x67, 0x22, 0x32, 0x68, 0x22, 0x32, 0x6c, 0x22, 0x32, 0x6d,
    0x22, 0x32, 0x6e, 0x22, 0x32, 0x70, 0x22, 0x32, 0x72, 0x22, 0x32, 0x75,
    0x22, 0x61, 0x30, 0x22, 0x61, 0x31, 0x22, 0x61, 0x32, 0x22, 0x61, 0x61,
    0x22, 0x61, 0x63, 0x22, 0x61, 0x65, 0x22, 0x61, 0x69, 0x22, 0x61, 0x6f,
    0x22, 0x61, 0x73, 0x22, 0x61, 0x74, 0x22, 0x61, 0x20, 0x22, 0x61, 0x25,
    0x22, 0x61, 0x2d, 0x22, 0x61, 0x2e, 0x22, 0x61, 0x2f, 0x22, 0x61, 0x33,
    0x22, 0x61, 0x34, 0x22, 0x61, 0x35, 0x22, 0x61, 0x36, 0x22, 0x61, 0x37,
    0x22, 0x61, 0x38, 0x22, 0x61, 0x39, 0x22, 0x61, 0x3d, 0x22, 0x61, 0x41,
    0x22, 0x61, 0x5f, 0x22, 0x61, 0x62, 0x22, 0x61, 0x64, 0x22, 0x61, 0x66,
    0x22, 0x61, 0x67, 0x22, 0x61, 0x68, 0x22, 0x61, 0x6c, 0x22, 0x61, 0x6d,
    0x22, 0x61, 0x6e, 0x22, 0x61, 0x70, 0x22, 0x61, 0x72, 0x22, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table19_18_emit_[216] = {
    0x22, 0x63, 0x30, 0x22, 0x63, 0x31, 0x22, 0x63, 0x32, 0x22, 0x63, 0x61,
    0x22, 0x63, 0x63, 0x22, 0x63, 0x65, 0x22, 0x63, 0x69, 0x22, 0x63, 0x6f,
    0x22, 0x63, 0x73, 0x22, 0x63, 0x74, 0x22, 0x63, 0x20, 0x22, 0x63, 0x25,
    0x22, 0x63, 0x2d, 0x22, 0x63, 0x2e, 0x22, 0x63, 0x2f, 0x22, 0x63, 0x33,
    0x22, 0x63, 0x34, 0x22, 0x63, 0x35, 0x22, 0x63, 0x36, 0x22, 0x63, 0x37,
    0x22, 0x63, 0x38, 0x22, 0x63, 0x39, 0x22, 0x63, 0x3d, 0x22, 0x63, 0x41,
    0x22, 0x63, 0x5f, 0x22, 0x63, 0x62, 0x22, 0x63, 0x64, 0x22, 0x63, 0x66,
    0x22, 0x63, 0x67, 0x22, 0x63, 0x68, 0x22, 0x63, 0x6c, 0x22, 0x63, 0x6d,
    0x22, 0x63, 0x6e, 0x22, 0x63, 0x70, 0x22, 0x63, 0x72, 0x22, 0x63, 0x75,
    0x22, 0x65, 0x30, 0x22, 0x65, 0x31, 0x22, 0x65, 0x32, 0x22, 0x65, 0x61,
    0x22, 0x65, 0x63, 0x22, 0x65, 0x65, 0x22, 0x65, 0x69, 0x22, 0x65, 0x6f,
    0x22, 0x65, 0x73, 0x22, 0x65, 0x74, 0x22, 0x65, 0x20, 0x22, 0x65, 0x25,
    0x22, 0x65, 0x2d, 0x22, 0x65, 0x2e, 0x22, 0x65, 0x2f, 0x22, 0x65, 0x33,
    0x22, 0x65, 0x34, 0x22, 0x65, 0x35, 0x22, 0x65, 0x36, 0x22, 0x65, 0x37,
    0x22, 0x65, 0x38, 0x22, 0x65, 0x39, 0x22, 0x65, 0x3d, 0x22, 0x65, 0x41,
    0x22, 0x65, 0x5f, 0x22, 0x65, 0x62, 0x22, 0x65, 0x64, 0x22, 0x65, 0x66,
    0x22, 0x65, 0x67, 0x22, 0x65, 0x68, 0x22, 0x65, 0x6c, 0x22, 0x65, 0x6d,
    0x22, 0x65, 0x6e, 0x22, 0x65, 0x70, 0x22, 0x65, 0x72, 0x22, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table19_19_emit_[216] = {
    0x22, 0x69, 0x30, 0x22, 0x69, 0x31, 0x22, 0x69, 0x32, 0x22, 0x69, 0x61,
    0x22, 0x69, 0x63, 0x22, 0x69, 0x65, 0x22, 0x69, 0x69, 0x22, 0x69, 0x6f,
    0x22, 0x69, 0x73, 0x22, 0x69, 0x74, 0x22, 0x69, 0x20, 0x22, 0x69, 0x25,
    0x22, 0x69, 0x2d, 0x22, 0x69, 0x2e, 0x22, 0x69, 0x2f, 0x22, 0x69, 0x33,
    0x22, 0x69, 0x34, 0x22, 0x69, 0x35, 0x22, 0x69, 0x36, 0x22, 0x69, 0x37,
    0x22, 0x69, 0x38, 0x22, 0x69, 0x39, 0x22, 0x69, 0x3d, 0x22, 0x69, 0x41,
    0x22, 0x69, 0x5f, 0x22, 0x69, 0x62, 0x22, 0x69, 0x64, 0x22, 0x69, 0x66,
    0x22, 0x69, 0x67, 0x22, 0x69, 0x68, 0x22, 0x69, 0x6c, 0x22, 0x69, 0x6d,
    0x22, 0x69, 0x6e, 0x22, 0x69, 0x70, 0x22, 0x69, 0x72, 0x22, 0x69, 0x75,
    0x22, 0x6f, 0x30, 0x22, 0x6f, 0x31, 0x22, 0x6f, 0x32, 0x22, 0x6f, 0x61,
    0x22, 0x6f, 0x63, 0x22, 0x6f, 0x65, 0x22, 0x6f, 0x69, 0x22, 0x6f, 0x6f,
    0x22, 0x6f, 0x73, 0x22, 0x6f, 0x74, 0x22, 0x6f, 0x20, 0x22, 0x6f, 0x25,
    0x22, 0x6f, 0x2d, 0x22, 0x6f, 0x2e, 0x22, 0x6f, 0x2f, 0x22, 0x6f, 0x33,
    0x22, 0x6f, 0x34, 0x22, 0x6f, 0x35, 0x22, 0x6f, 0x36, 0x22, 0x6f, 0x37,
    0x22, 0x6f, 0x38, 0x22, 0x6f, 0x39, 0x22, 0x6f, 0x3d, 0x22, 0x6f, 0x41,
    0x22, 0x6f, 0x5f, 0x22, 0x6f, 0x62, 0x22, 0x6f, 0x64, 0x22, 0x6f, 0x66,
    0x22, 0x6f, 0x67, 0x22, 0x6f, 0x68, 0x22, 0x6f, 0x6c, 0x22, 0x6f, 0x6d,
    0x22, 0x6f, 0x6e, 0x22, 0x6f, 0x70, 0x22, 0x6f, 0x72, 0x22, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table19_20_emit_[216] = {
    0x22, 0x73, 0x30, 0x22, 0x73, 0x31, 0x22, 0x73, 0x32, 0x22, 0x73, 0x61,
    0x22, 0x73, 0x63, 0x22, 0x73, 0x65, 0x22, 0x73, 0x69, 0x22, 0x73, 0x6f,
    0x22, 0x73, 0x73, 0x22, 0x73, 0x74, 0x22, 0x73, 0x20, 0x22, 0x73, 0x25,
    0x22, 0x73, 0x2d, 0x22, 0x73, 0x2e, 0x22, 0x73, 0x2f, 0x22, 0x73, 0x33,
    0x22, 0x73, 0x34, 0x22, 0x73, 0x35, 0x22, 0x73, 0x36, 0x22, 0x73, 0x37,
    0x22, 0x73, 0x38, 0x22, 0x73, 0x39, 0x22, 0x73, 0x3d, 0x22, 0x73, 0x41,
    0x22, 0x73, 0x5f, 0x22, 0x73, 0x62, 0x22, 0x73, 0x64, 0x22, 0x73, 0x66,
    0x22, 0x73, 0x67, 0x22, 0x73, 0x68, 0x22, 0x73, 0x6c, 0x22, 0x73, 0x6d,
    0x22, 0x73, 0x6e, 0x22, 0x73, 0x70, 0x22, 0x73, 0x72, 0x22, 0x73, 0x75,
    0x22, 0x74, 0x30, 0x22, 0x74, 0x31, 0x22, 0x74, 0x32, 0x22, 0x74, 0x61,
    0x22, 0x74, 0x63, 0x22, 0x74, 0x65, 0x22, 0x74, 0x69, 0x22, 0x74, 0x6f,
    0x22, 0x74, 0x73, 0x22, 0x74, 0x74, 0x22, 0x74, 0x20, 0x22, 0x74, 0x25,
    0x22, 0x74, 0x2d, 0x22, 0x74, 0x2e, 0x22, 0x74, 0x2f, 0x22, 0x74, 0x33,
    0x22, 0x74, 0x34, 0x22, 0x74, 0x35, 0x22, 0x74, 0x36, 0x22, 0x74, 0x37,
    0x22, 0x74, 0x38, 0x22, 0x74, 0x39, 0x22, 0x74, 0x3d, 0x22, 0x74, 0x41,
    0x22, 0x74, 0x5f, 0x22, 0x74, 0x62, 0x22, 0x74, 0x64, 0x22, 0x74, 0x66,
    0x22, 0x74, 0x67, 0x22, 0x74, 0x68, 0x22, 0x74, 0x6c, 0x22, 0x74, 0x6d,
    0x22, 0x74, 0x6e, 0x22, 0x74, 0x70, 0x22, 0x74, 0x72, 0x22, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table19_21_emit_[120] = {
    0x22, 0x20, 0x30, 0x22, 0x20, 0x31, 0x22, 0x20, 0x32, 0x22, 0x20, 0x61,
    0x22, 0x20, 0x63, 0x22, 0x20, 0x65, 0x22, 0x20, 0x69, 0x22, 0x20, 0x6f,
    0x22, 0x20, 0x73, 0x22, 0x20, 0x74, 0x22, 0x25, 0x30, 0x22, 0x25, 0x31,
    0x22, 0x25, 0x32, 0x22, 0x25, 0x61, 0x22, 0x25, 0x63, 0x22, 0x25, 0x65,
    0x22, 0x25, 0x69, 0x22, 0x25, 0x6f, 0x22, 0x25, 0x73, 0x22, 0x25, 0x74,
    0x22, 0x2d, 0x30, 0x22, 0x2d, 0x31, 0x22, 0x2d, 0x32, 0x22, 0x2d, 0x61,
    0x22, 0x2d, 0x63, 0x22, 0x2d, 0x65, 0x22, 0x2d, 0x69, 0x22, 0x2d, 0x6f,
    0x22, 0x2d, 0x73, 0x22, 0x2d, 0x74, 0x22, 0x2e, 0x30, 0x22, 0x2e, 0x31,
    0x22, 0x2e, 0x32, 0x22, 0x2e, 0x61, 0x22, 0x2e, 0x63, 0x22, 0x2e, 0x65,
    0x22, 0x2e, 0x69, 0x22, 0x2e, 0x6f, 0x22, 0x2e, 0x73, 0x22, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table19_22_emit_[120] = {
    0x22, 0x2f, 0x30, 0x22, 0x2f, 0x31, 0x22, 0x2f, 0x32, 0x22, 0x2f, 0x61,
    0x22, 0x2f, 0x63, 0x22, 0x2f, 0x65, 0x22, 0x2f, 0x69, 0x22, 0x2f, 0x6f,
    0x22, 0x2f, 0x73, 0x22, 0x2f, 0x74, 0x22, 0x33, 0x30, 0x22, 0x33, 0x31,
    0x22, 0x33, 0x32, 0x22, 0x33, 0x61, 0x22, 0x33, 0x63, 0x22, 0x33, 0x65,
    0x22, 0x33, 0x69, 0x22, 0x33, 0x6f, 0x22, 0x33, 0x73, 0x22, 0x33, 0x74,
    0x22, 0x34, 0x30, 0x22, 0x34, 0x31, 0x22, 0x34, 0x32, 0x22, 0x34, 0x61,
    0x22, 0x34, 0x63, 0x22, 0x34, 0x65, 0x22, 0x34, 0x69, 0x22, 0x34, 0x6f,
    0x22, 0x34, 0x73, 0x22, 0x34, 0x74, 0x22, 0x35, 0x30, 0x22, 0x35, 0x31,
    0x22, 0x35, 0x32, 0x22, 0x35, 0x61, 0x22, 0x35, 0x63, 0x22, 0x35, 0x65,
    0x22, 0x35, 0x69, 0x22, 0x35, 0x6f, 0x22, 0x35, 0x73, 0x22, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table19_23_emit_[120] = {
    0x22, 0x36, 0x30, 0x22, 0x36, 0x31, 0x22, 0x36, 0x32, 0x22, 0x36, 0x61,
    0x22, 0x36, 0x63, 0x22, 0x36, 0x65, 0x22, 0x36, 0x69, 0x22, 0x36, 0x6f,
    0x22, 0x36, 0x73, 0x22, 0x36, 0x74, 0x22, 0x37, 0x30, 0x22, 0x37, 0x31,
    0x22, 0x37, 0x32, 0x22, 0x37, 0x61, 0x22, 0x37, 0x63, 0x22, 0x37, 0x65,
    0x22, 0x37, 0x69, 0x22, 0x37, 0x6f, 0x22, 0x37, 0x73, 0x22, 0x37, 0x74,
    0x22, 0x38, 0x30, 0x22, 0x38, 0x31, 0x22, 0x38, 0x32, 0x22, 0x38, 0x61,
    0x22, 0x38, 0x63, 0x22, 0x38, 0x65, 0x22, 0x38, 0x69, 0x22, 0x38, 0x6f,
    0x22, 0x38, 0x73, 0x22, 0x38, 0x74, 0x22, 0x39, 0x30, 0x22, 0x39, 0x31,
    0x22, 0x39, 0x32, 0x22, 0x39, 0x61, 0x22, 0x39, 0x63, 0x22, 0x39, 0x65,
    0x22, 0x39, 0x69, 0x22, 0x39, 0x6f, 0x22, 0x39, 0x73, 0x22, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table19_24_emit_[120] = {
    0x22, 0x3d, 0x30, 0x22, 0x3d, 0x31, 0x22, 0x3d, 0x32, 0x22, 0x3d, 0x61,
    0x22, 0x3d, 0x63, 0x22, 0x3d, 0x65, 0x22, 0x3d, 0x69, 0x22, 0x3d, 0x6f,
    0x22, 0x3d, 0x73, 0x22, 0x3d, 0x74, 0x22, 0x41, 0x30, 0x22, 0x41, 0x31,
    0x22, 0x41, 0x32, 0x22, 0x41, 0x61, 0x22, 0x41, 0x63, 0x22, 0x41, 0x65,
    0x22, 0x41, 0x69, 0x22, 0x41, 0x6f, 0x22, 0x41, 0x73, 0x22, 0x41, 0x74,
    0x22, 0x5f, 0x30, 0x22, 0x5f, 0x31, 0x22, 0x5f, 0x32, 0x22, 0x5f, 0x61,
    0x22, 0x5f, 0x63, 0x22, 0x5f, 0x65, 0x22, 0x5f, 0x69, 0x22, 0x5f, 0x6f,
    0x22, 0x5f, 0x73, 0x22, 0x5f, 0x74, 0x22, 0x62, 0x30, 0x22, 0x62, 0x31,
    0x22, 0x62, 0x32, 0x22, 0x62, 0x61, 0x22, 0x62, 0x63, 0x22, 0x62, 0x65,
    0x22, 0x62, 0x69, 0x22, 0x62, 0x6f, 0x22, 0x62, 0x73, 0x22, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table19_25_emit_[120] = {
    0x22, 0x64, 0x30, 0x22, 0x64, 0x31, 0x22, 0x64, 0x32, 0x22, 0x64, 0x61,
    0x22, 0x64, 0x63, 0x22, 0x64, 0x65, 0x22, 0x64, 0x69, 0x22, 0x64, 0x6f,
    0x22, 0x64, 0x73, 0x22, 0x64, 0x74, 0x22, 0x66, 0x30, 0x22, 0x66, 0x31,
    0x22, 0x66, 0x32, 0x22, 0x66, 0x61, 0x22, 0x66, 0x63, 0x22, 0x66, 0x65,
    0x22, 0x66, 0x69, 0x22, 0x66, 0x6f, 0x22, 0x66, 0x73, 0x22, 0x66, 0x74,
    0x22, 0x67, 0x30, 0x22, 0x67, 0x31, 0x22, 0x67, 0x32, 0x22, 0x67, 0x61,
    0x22, 0x67, 0x63, 0x22, 0x67, 0x65, 0x22, 0x67, 0x69, 0x22, 0x67, 0x6f,
    0x22, 0x67, 0x73, 0x22, 0x67, 0x74, 0x22, 0x68, 0x30, 0x22, 0x68, 0x31,
    0x22, 0x68, 0x32, 0x22, 0x68, 0x61, 0x22, 0x68, 0x63, 0x22, 0x68, 0x65,
    0x22, 0x68, 0x69, 0x22, 0x68, 0x6f, 0x22, 0x68, 0x73, 0x22, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table19_26_emit_[120] = {
    0x22, 0x6c, 0x30, 0x22, 0x6c, 0x31, 0x22, 0x6c, 0x32, 0x22, 0x6c, 0x61,
    0x22, 0x6c, 0x63, 0x22, 0x6c, 0x65, 0x22, 0x6c, 0x69, 0x22, 0x6c, 0x6f,
    0x22, 0x6c, 0x73, 0x22, 0x6c, 0x74, 0x22, 0x6d, 0x30, 0x22, 0x6d, 0x31,
    0x22, 0x6d, 0x32, 0x22, 0x6d, 0x61, 0x22, 0x6d, 0x63, 0x22, 0x6d, 0x65,
    0x22, 0x6d, 0x69, 0x22, 0x6d, 0x6f, 0x22, 0x6d, 0x73, 0x22, 0x6d, 0x74,
    0x22, 0x6e, 0x30, 0x22, 0x6e, 0x31, 0x22, 0x6e, 0x32, 0x22, 0x6e, 0x61,
    0x22, 0x6e, 0x63, 0x22, 0x6e, 0x65, 0x22, 0x6e, 0x69, 0x22, 0x6e, 0x6f,
    0x22, 0x6e, 0x73, 0x22, 0x6e, 0x74, 0x22, 0x70, 0x30, 0x22, 0x70, 0x31,
    0x22, 0x70, 0x32, 0x22, 0x70, 0x61, 0x22, 0x70, 0x63, 0x22, 0x70, 0x65,
    0x22, 0x70, 0x69, 0x22, 0x70, 0x6f, 0x22, 0x70, 0x73, 0x22, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table19_27_emit_[68] = {
    0x22, 0x72, 0x30, 0x22, 0x72, 0x31, 0x22, 0x72, 0x32, 0x22, 0x72, 0x61,
    0x22, 0x72, 0x63, 0x22, 0x72, 0x65, 0x22, 0x72, 0x69, 0x22, 0x72, 0x6f,
    0x22, 0x72, 0x73, 0x22, 0x72, 0x74, 0x22, 0x75, 0x30, 0x22, 0x75, 0x31,
    0x22, 0x75, 0x32, 0x22, 0x75, 0x61, 0x22, 0x75, 0x63, 0x22, 0x75, 0x65,
    0x22, 0x75, 0x69, 0x22, 0x75, 0x6f, 0x22, 0x75, 0x73, 0x22, 0x75, 0x74,
    0x22, 0x3a, 0x22, 0x42, 0x22, 0x43, 0x22, 0x44};
const uint8_t HuffDecoderCommon::table19_31_emit_[35] = {
    0x22, 0x77, 0x22, 0x78, 0x22, 0x79, 0x22, 0x7a, 0x22, 0x26, 0x22, 0x2a,
    0x22, 0x2c, 0x22, 0x3b, 0x22, 0x58, 0x22, 0x5a, 0x22, 0x21, 0x22, 0x22,
    0x28, 0x22, 0x29, 0x22, 0x3f, 0x22, 0x27, 0x22, 0x2b, 0x22, 0x7c};
const uint16_t HuffDecoderCommon::table19_31_inner_[20] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052,
    0x0062, 0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00ba,
    0x00ca, 0x00da, 0x00ea, 0x00fa, 0x010a, 0x0003};
const uint8_t HuffDecoderCommon::table19_32_emit_[216] = {
    0x28, 0x30, 0x30, 0x28, 0x30, 0x31, 0x28, 0x30, 0x32, 0x28, 0x30, 0x61,
    0x28, 0x30, 0x63, 0x28, 0x30, 0x65, 0x28, 0x30, 0x69, 0x28, 0x30, 0x6f,
    0x28, 0x30, 0x73, 0x28, 0x30, 0x74, 0x28, 0x30, 0x20, 0x28, 0x30, 0x25,
    0x28, 0x30, 0x2d, 0x28, 0x30, 0x2e, 0x28, 0x30, 0x2f, 0x28, 0x30, 0x33,
    0x28, 0x30, 0x34, 0x28, 0x30, 0x35, 0x28, 0x30, 0x36, 0x28, 0x30, 0x37,
    0x28, 0x30, 0x38, 0x28, 0x30, 0x39, 0x28, 0x30, 0x3d, 0x28, 0x30, 0x41,
    0x28, 0x30, 0x5f, 0x28, 0x30, 0x62, 0x28, 0x30, 0x64, 0x28, 0x30, 0x66,
    0x28, 0x30, 0x67, 0x28, 0x30, 0x68, 0x28, 0x30, 0x6c, 0x28, 0x30, 0x6d,
    0x28, 0x30, 0x6e, 0x28, 0x30, 0x70, 0x28, 0x30, 0x72, 0x28, 0x30, 0x75,
    0x28, 0x31, 0x30, 0x28, 0x31, 0x31, 0x28, 0x31, 0x32, 0x28, 0x31, 0x61,
    0x28, 0x31, 0x63, 0x28, 0x31, 0x65, 0x28, 0x31, 0x69, 0x28, 0x31, 0x6f,
    0x28, 0x31, 0x73, 0x28, 0x31, 0x74, 0x28, 0x31, 0x20, 0x28, 0x31, 0x25,
    0x28, 0x31, 0x2d, 0x28, 0x31, 0x2e, 0x28, 0x31, 0x2f, 0x28, 0x31, 0x33,
    0x28, 0x31, 0x34, 0x28, 0x31, 0x35, 0x28, 0x31, 0x36, 0x28, 0x31, 0x37,
    0x28, 0x31, 0x38, 0x28, 0x31, 0x39, 0x28, 0x31, 0x3d, 0x28, 0x31, 0x41,
    0x28, 0x31, 0x5f, 0x28, 0x31, 0x62, 0x28, 0x31, 0x64, 0x28, 0x31, 0x66,
    0x28, 0x31, 0x67, 0x28, 0x31, 0x68, 0x28, 0x31, 0x6c, 0x28, 0x31, 0x6d,
    0x28, 0x31, 0x6e, 0x28, 0x31, 0x70, 0x28, 0x31, 0x72, 0x28, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table19_33_emit_[216] = {
    0x28, 0x32, 0x30, 0x28, 0x32, 0x31, 0x28, 0x32, 0x32, 0x28, 0x32, 0x61,
    0x28, 0x32, 0x63, 0x28, 0x32, 0x65, 0x28, 0x32, 0x69, 0x28, 0x32, 0x6f,
    0x28, 0x32, 0x73, 0x28, 0x32, 0x74, 0x28, 0x32, 0x20, 0x28, 0x32, 0x25,
    0x28, 0x32, 0x2d, 0x28, 0x32, 0x2e, 0x28, 0x32, 0x2f, 0x28, 0x32, 0x33,
    0x28, 0x32, 0x34, 0x28, 0x32, 0x35, 0x28, 0x32, 0x36, 0x28, 0x32, 0x37,
    0x28, 0x32, 0x38, 0x28, 0x32, 0x39, 0x28, 0x32, 0x3d, 0x28, 0x32, 0x41,
    0x28, 0x32, 0x5f, 0x28, 0x32, 0x62, 0x28, 0x32, 0x64, 0x28, 0x32, 0x66,
    0x28, 0x32, 0x67, 0x28, 0x32, 0x68, 0x28, 0x32, 0x6c, 0x28, 0x32, 0x6d,
    0x28, 0x32, 0x6e, 0x28, 0x32, 0x70, 0x28, 0x32, 0x72, 0x28, 0x32, 0x75,
    0x28, 0x61, 0x30, 0x28, 0x61, 0x31, 0x28, 0x61, 0x32, 0x28, 0x61, 0x61,
    0x28, 0x61, 0x63, 0x28, 0x61, 0x65, 0x28, 0x61, 0x69, 0x28, 0x61, 0x6f,
    0x28, 0x61, 0x73, 0x28, 0x61, 0x74, 0x28, 0x61, 0x20, 0x28, 0x61, 0x25,
    0x28, 0x61, 0x2d, 0x28, 0x61, 0x2e, 0x28, 0x61, 0x2f, 0x28, 0x61, 0x33,
    0x28, 0x61, 0x34, 0x28, 0x61, 0x35, 0x28, 0x61, 0x36, 0x28, 0x61, 0x37,
    0x28, 0x61, 0x38, 0x28, 0x61, 0x39, 0x28, 0x61, 0x3d, 0x28, 0x61, 0x41,
    0x28, 0x61, 0x5f, 0x28, 0x61, 0x62, 0x28, 0x61, 0x64, 0x28, 0x61, 0x66,
    0x28, 0x61, 0x67, 0x28, 0x61, 0x68, 0x28, 0x61, 0x6c, 0x28, 0x61, 0x6d,
    0x28, 0x61, 0x6e, 0x28, 0x61, 0x70, 0x28, 0x61, 0x72, 0x28, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table19_34_emit_[216] = {
    0x28, 0x63, 0x30, 0x28, 0x63, 0x31, 0x28, 0x63, 0x32, 0x28, 0x63, 0x61,
    0x28, 0x63, 0x63, 0x28, 0x63, 0x65, 0x28, 0x63, 0x69, 0x28, 0x63, 0x6f,
    0x28, 0x63, 0x73, 0x28, 0x63, 0x74, 0x28, 0x63, 0x20, 0x28, 0x63, 0x25,
    0x28, 0x63, 0x2d, 0x28, 0x63, 0x2e, 0x28, 0x63, 0x2f, 0x28, 0x63, 0x33,
    0x28, 0x63, 0x34, 0x28, 0x63, 0x35, 0x28, 0x63, 0x36, 0x28, 0x63, 0x37,
    0x28, 0x63, 0x38, 0x28, 0x63, 0x39, 0x28, 0x63, 0x3d, 0x28, 0x63, 0x41,
    0x28, 0x63, 0x5f, 0x28, 0x63, 0x62, 0x28, 0x63, 0x64, 0x28, 0x63, 0x66,
    0x28, 0x63, 0x67, 0x28, 0x63, 0x68, 0x28, 0x63, 0x6c, 0x28, 0x63, 0x6d,
    0x28, 0x63, 0x6e, 0x28, 0x63, 0x70, 0x28, 0x63, 0x72, 0x28, 0x63, 0x75,
    0x28, 0x65, 0x30, 0x28, 0x65, 0x31, 0x28, 0x65, 0x32, 0x28, 0x65, 0x61,
    0x28, 0x65, 0x63, 0x28, 0x65, 0x65, 0x28, 0x65, 0x69, 0x28, 0x65, 0x6f,
    0x28, 0x65, 0x73, 0x28, 0x65, 0x74, 0x28, 0x65, 0x20, 0x28, 0x65, 0x25,
    0x28, 0x65, 0x2d, 0x28, 0x65, 0x2e, 0x28, 0x65, 0x2f, 0x28, 0x65, 0x33,
    0x28, 0x65, 0x34, 0x28, 0x65, 0x35, 0x28, 0x65, 0x36, 0x28, 0x65, 0x37,
    0x28, 0x65, 0x38, 0x28, 0x65, 0x39, 0x28, 0x65, 0x3d, 0x28, 0x65, 0x41,
    0x28, 0x65, 0x5f, 0x28, 0x65, 0x62, 0x28, 0x65, 0x64, 0x28, 0x65, 0x66,
    0x28, 0x65, 0x67, 0x28, 0x65, 0x68, 0x28, 0x65, 0x6c, 0x28, 0x65, 0x6d,
    0x28, 0x65, 0x6e, 0x28, 0x65, 0x70, 0x28, 0x65, 0x72, 0x28, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table19_35_emit_[216] = {
    0x28, 0x69, 0x30, 0x28, 0x69, 0x31, 0x28, 0x69, 0x32, 0x28, 0x69, 0x61,
    0x28, 0x69, 0x63, 0x28, 0x69, 0x65, 0x28, 0x69, 0x69, 0x28, 0x69, 0x6f,
    0x28, 0x69, 0x73, 0x28, 0x69, 0x74, 0x28, 0x69, 0x20, 0x28, 0x69, 0x25,
    0x28, 0x69, 0x2d, 0x28, 0x69, 0x2e, 0x28, 0x69, 0x2f, 0x28, 0x69, 0x33,
    0x28, 0x69, 0x34, 0x28, 0x69, 0x35, 0x28, 0x69, 0x36, 0x28, 0x69, 0x37,
    0x28, 0x69, 0x38, 0x28, 0x69, 0x39, 0x28, 0x69, 0x3d, 0x28, 0x69, 0x41,
    0x28, 0x69, 0x5f, 0x28, 0x69, 0x62, 0x28, 0x69, 0x64, 0x28, 0x69, 0x66,
    0x28, 0x69, 0x67, 0x28, 0x69, 0x68, 0x28, 0x69, 0x6c, 0x28, 0x69, 0x6d,
    0x28, 0x69, 0x6e, 0x28, 0x69, 0x70, 0x28, 0x69, 0x72, 0x28, 0x69, 0x75,
    0x28, 0x6f, 0x30, 0x28, 0x6f, 0x31, 0x28, 0x6f, 0x32, 0x28, 0x6f, 0x61,
    0x28, 0x6f, 0x63, 0x28, 0x6f, 0x65, 0x28, 0x6f, 0x69, 0x28, 0x6f, 0x6f,
    0x28, 0x6f, 0x73, 0x28, 0x6f, 0x74, 0x28, 0x6f, 0x20, 0x28, 0x6f, 0x25,
    0x28, 0x6f, 0x2d, 0x28, 0x6f, 0x2e, 0x28, 0x6f, 0x2f, 0x28, 0x6f, 0x33,
    0x28, 0x6f, 0x34, 0x28, 0x6f, 0x35, 0x28, 0x6f, 0x36, 0x28, 0x6f, 0x37,
    0x28, 0x6f, 0x38, 0x28, 0x6f, 0x39, 0x28, 0x6f, 0x3d, 0x28, 0x6f, 0x41,
    0x28, 0x6f, 0x5f, 0x28, 0x6f, 0x62, 0x28, 0x6f, 0x64, 0x28, 0x6f, 0x66,
    0x28, 0x6f, 0x67, 0x28, 0x6f, 0x68, 0x28, 0x6f, 0x6c, 0x28, 0x6f, 0x6d,
    0x28, 0x6f, 0x6e, 0x28, 0x6f, 0x70, 0x28, 0x6f, 0x72, 0x28, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table19_36_emit_[216] = {
    0x28, 0x73, 0x30, 0x28, 0x73, 0x31, 0x28, 0x73, 0x32, 0x28, 0x73, 0x61,
    0x28, 0x73, 0x63, 0x28, 0x73, 0x65, 0x28, 0x73, 0x69, 0x28, 0x73, 0x6f,
    0x28, 0x73, 0x73, 0x28, 0x73, 0x74, 0x28, 0x73, 0x20, 0x28, 0x73, 0x25,
    0x28, 0x73, 0x2d, 0x28, 0x73, 0x2e, 0x28, 0x73, 0x2f, 0x28, 0x73, 0x33,
    0x28, 0x73, 0x34, 0x28, 0x73, 0x35, 0x28, 0x73, 0x36, 0x28, 0x73, 0x37,
    0x28, 0x73, 0x38, 0x28, 0x73, 0x39, 0x28, 0x73, 0x3d, 0x28, 0x73, 0x41,
    0x28, 0x73, 0x5f, 0x28, 0x73, 0x62, 0x28, 0x73, 0x64, 0x28, 0x73, 0x66,
    0x28, 0x73, 0x67, 0x28, 0x73, 0x68, 0x28, 0x73, 0x6c, 0x28, 0x73, 0x6d,
    0x28, 0x73, 0x6e, 0x28, 0x73, 0x70, 0x28, 0x73, 0x72, 0x28, 0x73, 0x75,
    0x28, 0x74, 0x30, 0x28, 0x74, 0x31, 0x28, 0x74, 0x32, 0x28, 0x74, 0x61,
    0x28, 0x74, 0x63, 0x28, 0x74, 0x65, 0x28, 0x74, 0x69, 0x28, 0x74, 0x6f,
    0x28, 0x74, 0x73, 0x28, 0x74, 0x74, 0x28, 0x74, 0x20, 0x28, 0x74, 0x25,
    0x28, 0x74, 0x2d, 0x28, 0x74, 0x2e, 0x28, 0x74, 0x2f, 0x28, 0x74, 0x33,
    0x28, 0x74, 0x34, 0x28, 0x74, 0x35, 0x28, 0x74, 0x36, 0x28, 0x74, 0x37,
    0x28, 0x74, 0x38, 0x28, 0x74, 0x39, 0x28, 0x74, 0x3d, 0x28, 0x74, 0x41,
    0x28, 0x74, 0x5f, 0x28, 0x74, 0x62, 0x28, 0x74, 0x64, 0x28, 0x74, 0x66,
    0x28, 0x74, 0x67, 0x28, 0x74, 0x68, 0x28, 0x74, 0x6c, 0x28, 0x74, 0x6d,
    0x28, 0x74, 0x6e, 0x28, 0x74, 0x70, 0x28, 0x74, 0x72, 0x28, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table19_37_emit_[120] = {
    0x28, 0x20, 0x30, 0x28, 0x20, 0x31, 0x28, 0x20, 0x32, 0x28, 0x20, 0x61,
    0x28, 0x20, 0x63, 0x28, 0x20, 0x65, 0x28, 0x20, 0x69, 0x28, 0x20, 0x6f,
    0x28, 0x20, 0x73, 0x28, 0x20, 0x74, 0x28, 0x25, 0x30, 0x28, 0x25, 0x31,
    0x28, 0x25, 0x32, 0x28, 0x25, 0x61, 0x28, 0x25, 0x63, 0x28, 0x25, 0x65,
    0x28, 0x25, 0x69, 0x28, 0x25, 0x6f, 0x28, 0x25, 0x73, 0x28, 0x25, 0x74,
    0x28, 0x2d, 0x30, 0x28, 0x2d, 0x31, 0x28, 0x2d, 0x32, 0x28, 0x2d, 0x61,
    0x28, 0x2d, 0x63, 0x28, 0x2d, 0x65, 0x28, 0x2d, 0x69, 0x28, 0x2d, 0x6f,
    0x28, 0x2d, 0x73, 0x28, 0x2d, 0x74, 0x28, 0x2e, 0x30, 0x28, 0x2e, 0x31,
    0x28, 0x2e, 0x32, 0x28, 0x2e, 0x61, 0x28, 0x2e, 0x63, 0x28, 0x2e, 0x65,
    0x28, 0x2e, 0x69, 0x28, 0x2e, 0x6f, 0x28, 0x2e, 0x73, 0x28, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table19_38_emit_[120] = {
    0x28, 0x2f, 0x30, 0x28, 0x2f, 0x31, 0x28, 0x2f, 0x32, 0x28, 0x2f, 0x61,
    0x28, 0x2f, 0x63, 0x28, 0x2f, 0x65, 0x28, 0x2f, 0x69, 0x28, 0x2f, 0x6f,
    0x28, 0x2f, 0x73, 0x28, 0x2f, 0x74, 0x28, 0x33, 0x30, 0x28, 0x33, 0x31,
    0x28, 0x33, 0x32, 0x28, 0x33, 0x61, 0x28, 0x33, 0x63, 0x28, 0x33, 0x65,
    0x28, 0x33, 0x69, 0x28, 0x33, 0x6f, 0x28, 0x33, 0x73, 0x28, 0x33, 0x74,
    0x28, 0x34, 0x30, 0x28, 0x34, 0x31, 0x28, 0x34, 0x32, 0x28, 0x34, 0x61,
    0x28, 0x34, 0x63, 0x28, 0x34, 0x65, 0x28, 0x34, 0x69, 0x28, 0x34, 0x6f,
    0x28, 0x34, 0x73, 0x28, 0x34, 0x74, 0x28, 0x35, 0x30, 0x28, 0x35, 0x31,
    0x28, 0x35, 0x32, 0x28, 0x35, 0x61, 0x28, 0x35, 0x63, 0x28, 0x35, 0x65,
    0x28, 0x35, 0x69, 0x28, 0x35, 0x6f, 0x28, 0x35, 0x73, 0x28, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table19_39_emit_[120] = {
    0x28, 0x36, 0x30, 0x28, 0x36, 0x31, 0x28, 0x36, 0x32, 0x28, 0x36, 0x61,
    0x28, 0x36, 0x63, 0x28, 0x36, 0x65, 0x28, 0x36, 0x69, 0x28, 0x36, 0x6f,
    0x28, 0x36, 0x73, 0x28, 0x36, 0x74, 0x28, 0x37, 0x30, 0x28, 0x37, 0x31,
    0x28, 0x37, 0x32, 0x28, 0x37, 0x61, 0x28, 0x37, 0x63, 0x28, 0x37, 0x65,
    0x28, 0x37, 0x69, 0x28, 0x37, 0x6f, 0x28, 0x37, 0x73, 0x28, 0x37, 0x74,
    0x28, 0x38, 0x30, 0x28, 0x38, 0x31, 0x28, 0x38, 0x32, 0x28, 0x38, 0x61,
    0x28, 0x38, 0x63, 0x28, 0x38, 0x65, 0x28, 0x38, 0x69, 0x28, 0x38, 0x6f,
    0x28, 0x38, 0x73, 0x28, 0x38, 0x74, 0x28, 0x39, 0x30, 0x28, 0x39, 0x31,
    0x28, 0x39, 0x32, 0x28, 0x39, 0x61, 0x28, 0x39, 0x63, 0x28, 0x39, 0x65,
    0x28, 0x39, 0x69, 0x28, 0x39, 0x6f, 0x28, 0x39, 0x73, 0x28, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table19_40_emit_[120] = {
    0x28, 0x3d, 0x30, 0x28, 0x3d, 0x31, 0x28, 0x3d, 0x32, 0x28, 0x3d, 0x61,
    0x28, 0x3d, 0x63, 0x28, 0x3d, 0x65, 0x28, 0x3d, 0x69, 0x28, 0x3d, 0x6f,
    0x28, 0x3d, 0x73, 0x28, 0x3d, 0x74, 0x28, 0x41, 0x30, 0x28, 0x41, 0x31,
    0x28, 0x41, 0x32, 0x28, 0x41, 0x61, 0x28, 0x41, 0x63, 0x28, 0x41, 0x65,
    0x28, 0x41, 0x69, 0x28, 0x41, 0x6f, 0x28, 0x41, 0x73, 0x28, 0x41, 0x74,
    0x28, 0x5f, 0x30, 0x28, 0x5f, 0x31, 0x28, 0x5f, 0x32, 0x28, 0x5f, 0x61,
    0x28, 0x5f, 0x63, 0x28, 0x5f, 0x65, 0x28, 0x5f, 0x69, 0x28, 0x5f, 0x6f,
    0x28, 0x5f, 0x73, 0x28, 0x5f, 0x74, 0x28, 0x62, 0x30, 0x28, 0x62, 0x31,
    0x28, 0x62, 0x32, 0x28, 0x62, 0x61, 0x28, 0x62, 0x63, 0x28, 0x62, 0x65,
    0x28, 0x62, 0x69, 0x28, 0x62, 0x6f, 0x28, 0x62, 0x73, 0x28, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table19_41_emit_[120] = {
    0x28, 0x64, 0x30, 0x28, 0x64, 0x31, 0x28, 0x64, 0x32, 0x28, 0x64, 0x61,
    0x28, 0x64, 0x63, 0x28, 0x64, 0x65, 0x28, 0x64, 0x69, 0x28, 0x64, 0x6f,
    0x28, 0x64, 0x73, 0x28, 0x64, 0x74, 0x28, 0x66, 0x30, 0x28, 0x66, 0x31,
    0x28, 0x66, 0x32, 0x28, 0x66, 0x61, 0x28, 0x66, 0x63, 0x28, 0x66, 0x65,
    0x28, 0x66, 0x69, 0x28, 0x66, 0x6f, 0x28, 0x66, 0x73, 0x28, 0x66, 0x74,
    0x28, 0x67, 0x30, 0x28, 0x67, 0x31, 0x28, 0x67, 0x32, 0x28, 0x67, 0x61,
    0x28, 0x67, 0x63, 0x28, 0x67, 0x65, 0x28, 0x67, 0x69, 0x28, 0x67, 0x6f,
    0x28, 0x67, 0x73, 0x28, 0x67, 0x74, 0x28, 0x68, 0x30, 0x28, 0x68, 0x31,
    0x28, 0x68, 0x32, 0x28, 0x68, 0x61, 0x28, 0x68, 0x63, 0x28, 0x68, 0x65,
    0x28, 0x68, 0x69, 0x28, 0x68, 0x6f, 0x28, 0x68, 0x73, 0x28, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table19_42_emit_[120] = {
    0x28, 0x6c, 0x30, 0x28, 0x6c, 0x31, 0x28, 0x6c, 0x32, 0x28, 0x6c, 0x61,
    0x28, 0x6c, 0x63, 0x28, 0x6c, 0x65, 0x28, 0x6c, 0x69, 0x28, 0x6c, 0x6f,
    0x28, 0x6c, 0x73, 0x28, 0x6c, 0x74, 0x28, 0x6d, 0x30, 0x28, 0x6d, 0x31,
    0x28, 0x6d, 0x32, 0x28, 0x6d, 0x61, 0x28, 0x6d, 0x63, 0x28, 0x6d, 0x65,
    0x28, 0x6d, 0x69, 0x28, 0x6d, 0x6f, 0x28, 0x6d, 0x73, 0x28, 0x6d, 0x74,
    0x28, 0x6e, 0x30, 0x28, 0x6e, 0x31, 0x28, 0x6e, 0x32, 0x28, 0x6e, 0x61,
    0x28, 0x6e, 0x63, 0x28, 0x6e, 0x65, 0x28, 0x6e, 0x69, 0x28, 0x6e, 0x6f,
    0x28, 0x6e, 0x73, 0x28, 0x6e, 0x74, 0x28, 0x70, 0x30, 0x28, 0x70, 0x31,
    0x28, 0x70, 0x32, 0x28, 0x70, 0x61, 0x28, 0x70, 0x63, 0x28, 0x70, 0x65,
    0x28, 0x70, 0x69, 0x28, 0x70, 0x6f, 0x28, 0x70, 0x73, 0x28, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table19_43_emit_[68] = {
    0x28, 0x72, 0x30, 0x28, 0x72, 0x31, 0x28, 0x72, 0x32, 0x28, 0x72, 0x61,
    0x28, 0x72, 0x63, 0x28, 0x72, 0x65, 0x28, 0x72, 0x69, 0x28, 0x72, 0x6f,
    0x28, 0x72, 0x73, 0x28, 0x72, 0x74, 0x28, 0x75, 0x30, 0x28, 0x75, 0x31,
    0x28, 0x75, 0x32, 0x28, 0x75, 0x61, 0x28, 0x75, 0x63, 0x28, 0x75, 0x65,
    0x28, 0x75, 0x69, 0x28, 0x75, 0x6f, 0x28, 0x75, 0x73, 0x28, 0x75, 0x74,
    0x28, 0x3a, 0x28, 0x42, 0x28, 0x43, 0x28, 0x44};
const uint8_t HuffDecoderCommon::table19_47_emit_[35] = {
    0x28, 0x77, 0x28, 0x78, 0x28, 0x79, 0x28, 0x7a, 0x28, 0x26, 0x28, 0x2a,
    0x28, 0x2c, 0x28, 0x3b, 0x28, 0x58, 0x28, 0x5a, 0x28, 0x21, 0x28, 0x22,
    0x28, 0x28, 0x29, 0x28, 0x3f, 0x28, 0x27, 0x28, 0x2b, 0x28, 0x7c};
const uint16_t HuffDecoderCommon::table19_47_inner_[20] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052,
    0x0062, 0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2,
    0x00ca, 0x00da, 0x00ea, 0x00fa, 0x010a, 0x0003};
const uint8_t HuffDecoderCommon::table19_48_emit_[216] = {
    0x29, 0x30, 0x30, 0x29, 0x30, 0x31, 0x29, 0x30, 0x32, 0x29, 0x30, 0x61,
    0x29, 0x30, 0x63, 0x29, 0x30, 0x65, 0x29, 0x30, 0x69, 0x29, 0x30, 0x6f,
    0x29, 0x30, 0x73, 0x29, 0x30, 0x74, 0x29, 0x30, 0x20, 0x29, 0x30, 0x25,
    0x29, 0x30, 0x2d, 0x29, 0x30, 0x2e, 0x29, 0x30, 0x2f, 0x29, 0x30, 0x33,
    0x29, 0x30, 0x34, 0x29, 0x30, 0x35, 0x29, 0x30, 0x36, 0x29, 0x30, 0x37,
    0x29, 0x30, 0x38, 0x29, 0x30, 0x39, 0x29, 0x30, 0x3d, 0x29, 0x30, 0x41,
    0x29, 0x30, 0x5f, 0x29, 0x30, 0x62, 0x29, 0x30, 0x64, 0x29, 0x30, 0x66,
    0x29, 0x30, 0x67, 0x29, 0x30, 0x68, 0x29, 0x30, 0x6c, 0x29, 0x30, 0x6d,
    0x29, 0x30, 0x6e, 0x29, 0x30, 0x70, 0x29, 0x30, 0x72, 0x29, 0x30, 0x75,
    0x29, 0x31, 0x30, 0x29, 0x31, 0x31, 0x29, 0x31, 0x32, 0x29, 0x31, 0x61,
    0x29, 0x31, 0x63, 0x29, 0x31, 0x65, 0x29, 0x31, 0x69, 0x29, 0x31, 0x6f,
    0x29, 0x31, 0x73, 0x29, 0x31, 0x74, 0x29, 0x31, 0x20, 0x29, 0x31, 0x25,
    0x29, 0x31, 0x2d, 0x29, 0x31, 0x2e, 0x29, 0x31, 0x2f, 0x29, 0x31, 0x33,
    0x29, 0x31, 0x34, 0x29, 0x31, 0x35, 0x29, 0x31, 0x36, 0x29, 0x31, 0x37,
    0x29, 0x31, 0x38, 0x29, 0x31, 0x39, 0x29, 0x31, 0x3d, 0x29, 0x31, 0x41,
    0x29, 0x31, 0x5f, 0x29, 0x31, 0x62, 0x29, 0x31, 0x64, 0x29, 0x31, 0x66,
    0x29, 0x31, 0x67, 0x29, 0x31, 0x68, 0x29, 0x31, 0x6c, 0x29, 0x31, 0x6d,
    0x29, 0x31, 0x6e, 0x29, 0x31, 0x70, 0x29, 0x31, 0x72, 0x29, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table19_49_emit_[216] = {
    0x29, 0x32, 0x30, 0x29, 0x32, 0x31, 0x29, 0x32, 0x32, 0x29, 0x32, 0x61,
    0x29, 0x32, 0x63, 0x29, 0x32, 0x65, 0x29, 0x32, 0x69, 0x29, 0x32, 0x6f,
    0x29, 0x32, 0x73, 0x29, 0x32, 0x74, 0x29, 0x32, 0x20, 0x29, 0x32, 0x25,
    0x29, 0x32, 0x2d, 0x29, 0x32, 0x2e, 0x29, 0x32, 0x2f, 0x29, 0x32, 0x33,
    0x29, 0x32, 0x34, 0x29, 0x32, 0x35, 0x29, 0x32, 0x36, 0x29, 0x32, 0x37,
    0x29, 0x32, 0x38, 0x29, 0x32, 0x39, 0x29, 0x32, 0x3d, 0x29, 0x32, 0x41,
    0x29, 0x32, 0x5f, 0x29, 0x32, 0x62, 0x29, 0x32, 0x64, 0x29, 0x32, 0x66,
    0x29, 0x32, 0x67, 0x29, 0x32, 0x68, 0x29, 0x32, 0x6c, 0x29, 0x32, 0x6d,
    0x29, 0x32, 0x6e, 0x29, 0x32, 0x70, 0x29, 0x32, 0x72, 0x29, 0x32, 0x75,
    0x29, 0x61, 0x30, 0x29, 0x61, 0x31, 0x29, 0x61, 0x32, 0x29, 0x61, 0x61,
    0x29, 0x61, 0x63, 0x29, 0x61, 0x65, 0x29, 0x61, 0x69, 0x29, 0x61, 0x6f,
    0x29, 0x61, 0x73, 0x29, 0x61, 0x74, 0x29, 0x61, 0x20, 0x29, 0x61, 0x25,
    0x29, 0x61, 0x2d, 0x29, 0x61, 0x2e, 0x29, 0x61, 0x2f, 0x29, 0x61, 0x33,
    0x29, 0x61, 0x34, 0x29, 0x61, 0x35, 0x29, 0x61, 0x36, 0x29, 0x61, 0x37,
    0x29, 0x61, 0x38, 0x29, 0x61, 0x39, 0x29, 0x61, 0x3d, 0x29, 0x61, 0x41,
    0x29, 0x61, 0x5f, 0x29, 0x61, 0x62, 0x29, 0x61, 0x64, 0x29, 0x61, 0x66,
    0x29, 0x61, 0x67, 0x29, 0x61, 0x68, 0x29, 0x61, 0x6c, 0x29, 0x61, 0x6d,
    0x29, 0x61, 0x6e, 0x29, 0x61, 0x70, 0x29, 0x61, 0x72, 0x29, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table19_50_emit_[216] = {
    0x29, 0x63, 0x30, 0x29, 0x63, 0x31, 0x29, 0x63, 0x32, 0x29, 0x63, 0x61,
    0x29, 0x63, 0x63, 0x29, 0x63, 0x65, 0x29, 0x63, 0x69, 0x29, 0x63, 0x6f,
    0x29, 0x63, 0x73, 0x29, 0x63, 0x74, 0x29, 0x63, 0x20, 0x29, 0x63, 0x25,
    0x29, 0x63, 0x2d, 0x29, 0x63, 0x2e, 0x29, 0x63, 0x2f, 0x29, 0x63, 0x33,
    0x29, 0x63, 0x34, 0x29, 0x63, 0x35, 0x29, 0x63, 0x36, 0x29, 0x63, 0x37,
    0x29, 0x63, 0x38, 0x29, 0x63, 0x39, 0x29, 0x63, 0x3d, 0x29, 0x63, 0x41,
    0x29, 0x63, 0x5f, 0x29, 0x63, 0x62, 0x29, 0x63, 0x64, 0x29, 0x63, 0x66,
    0x29, 0x63, 0x67, 0x29, 0x63, 0x68, 0x29, 0x63, 0x6c, 0x29, 0x63, 0x6d,
    0x29, 0x63, 0x6e, 0x29, 0x63, 0x70, 0x29, 0x63, 0x72, 0x29, 0x63, 0x75,
    0x29, 0x65, 0x30, 0x29, 0x65, 0x31, 0x29, 0x65, 0x32, 0x29, 0x65, 0x61,
    0x29, 0x65, 0x63, 0x29, 0x65, 0x65, 0x29, 0x65, 0x69, 0x29, 0x65, 0x6f,
    0x29, 0x65, 0x73, 0x29, 0x65, 0x74, 0x29, 0x65, 0x20, 0x29, 0x65, 0x25,
    0x29, 0x65, 0x2d, 0x29, 0x65, 0x2e, 0x29, 0x65, 0x2f, 0x29, 0x65, 0x33,
    0x29, 0x65, 0x34, 0x29, 0x65, 0x35, 0x29, 0x65, 0x36, 0x29, 0x65, 0x37,
    0x29, 0x65, 0x38, 0x29, 0x65, 0x39, 0x29, 0x65, 0x3d, 0x29, 0x65, 0x41,
    0x29, 0x65, 0x5f, 0x29, 0x65, 0x62, 0x29, 0x65, 0x64, 0x29, 0x65, 0x66,
    0x29, 0x65, 0x67, 0x29, 0x65, 0x68, 0x29, 0x65, 0x6c, 0x29, 0x65, 0x6d,
    0x29, 0x65, 0x6e, 0x29, 0x65, 0x70, 0x29, 0x65, 0x72, 0x29, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table19_51_emit_[216] = {
    0x29, 0x69, 0x30, 0x29, 0x69, 0x31, 0x29, 0x69, 0x32, 0x29, 0x69, 0x61,
    0x29, 0x69, 0x63, 0x29, 0x69, 0x65, 0x29, 0x69, 0x69, 0x29, 0x69, 0x6f,
    0x29, 0x69, 0x73, 0x29, 0x69, 0x74, 0x29, 0x69, 0x20, 0x29, 0x69, 0x25,
    0x29, 0x69, 0x2d, 0x29, 0x69, 0x2e, 0x29, 0x69, 0x2f, 0x29, 0x69, 0x33,
    0x29, 0x69, 0x34, 0x29, 0x69, 0x35, 0x29, 0x69, 0x36, 0x29, 0x69, 0x37,
    0x29, 0x69, 0x38, 0x29, 0x69, 0x39, 0x29, 0x69, 0x3d, 0x29, 0x69, 0x41,
    0x29, 0x69, 0x5f, 0x29, 0x69, 0x62, 0x29, 0x69, 0x64, 0x29, 0x69, 0x66,
    0x29, 0x69, 0x67, 0x29, 0x69, 0x68, 0x29, 0x69, 0x6c, 0x29, 0x69, 0x6d,
    0x29, 0x69, 0x6e, 0x29, 0x69, 0x70, 0x29, 0x69, 0x72, 0x29, 0x69, 0x75,
    0x29, 0x6f, 0x30, 0x29, 0x6f, 0x31, 0x29, 0x6f, 0x32, 0x29, 0x6f, 0x61,
    0x29, 0x6f, 0x63, 0x29, 0x6f, 0x65, 0x29, 0x6f, 0x69, 0x29, 0x6f, 0x6f,
    0x29, 0x6f, 0x73, 0x29, 0x6f, 0x74, 0x29, 0x6f, 0x20, 0x29, 0x6f, 0x25,
    0x29, 0x6f, 0x2d, 0x29, 0x6f, 0x2e, 0x29, 0x6f, 0x2f, 0x29, 0x6f, 0x33,
    0x29, 0x6f, 0x34, 0x29, 0x6f, 0x35, 0x29, 0x6f, 0x36, 0x29, 0x6f, 0x37,
    0x29, 0x6f, 0x38, 0x29, 0x6f, 0x39, 0x29, 0x6f, 0x3d, 0x29, 0x6f, 0x41,
    0x29, 0x6f, 0x5f, 0x29, 0x6f, 0x62, 0x29, 0x6f, 0x64, 0x29, 0x6f, 0x66,
    0x29, 0x6f, 0x67, 0x29, 0x6f, 0x68, 0x29, 0x6f, 0x6c, 0x29, 0x6f, 0x6d,
    0x29, 0x6f, 0x6e, 0x29, 0x6f, 0x70, 0x29, 0x6f, 0x72, 0x29, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table19_52_emit_[216] = {
    0x29, 0x73, 0x30, 0x29, 0x73, 0x31, 0x29, 0x73, 0x32, 0x29, 0x73, 0x61,
    0x29, 0x73, 0x63, 0x29, 0x73, 0x65, 0x29, 0x73, 0x69, 0x29, 0x73, 0x6f,
    0x29, 0x73, 0x73, 0x29, 0x73, 0x74, 0x29, 0x73, 0x20, 0x29, 0x73, 0x25,
    0x29, 0x73, 0x2d, 0x29, 0x73, 0x2e, 0x29, 0x73, 0x2f, 0x29, 0x73, 0x33,
    0x29, 0x73, 0x34, 0x29, 0x73, 0x35, 0x29, 0x73, 0x36, 0x29, 0x73, 0x37,
    0x29, 0x73, 0x38, 0x29, 0x73, 0x39, 0x29, 0x73, 0x3d, 0x29, 0x73, 0x41,
    0x29, 0x73, 0x5f, 0x29, 0x73, 0x62, 0x29, 0x73, 0x64, 0x29, 0x73, 0x66,
    0x29, 0x73, 0x67, 0x29, 0x73, 0x68, 0x29, 0x73, 0x6c, 0x29, 0x73, 0x6d,
    0x29, 0x73, 0x6e, 0x29, 0x73, 0x70, 0x29, 0x73, 0x72, 0x29, 0x73, 0x75,
    0x29, 0x74, 0x30, 0x29, 0x74, 0x31, 0x29, 0x74, 0x32, 0x29, 0x74, 0x61,
    0x29, 0x74, 0x63, 0x29, 0x74, 0x65, 0x29, 0x74, 0x69, 0x29, 0x74, 0x6f,
    0x29, 0x74, 0x73, 0x29, 0x74, 0x74, 0x29, 0x74, 0x20, 0x29, 0x74, 0x25,
    0x29, 0x74, 0x2d, 0x29, 0x74, 0x2e, 0x29, 0x74, 0x2f, 0x29, 0x74, 0x33,
    0x29, 0x74, 0x34, 0x29, 0x74, 0x35, 0x29, 0x74, 0x36, 0x29, 0x74, 0x37,
    0x29, 0x74, 0x38, 0x29, 0x74, 0x39, 0x29, 0x74, 0x3d, 0x29, 0x74, 0x41,
    0x29, 0x74, 0x5f, 0x29, 0x74, 0x62, 0x29, 0x74, 0x64, 0x29, 0x74, 0x66,
    0x29, 0x74, 0x67, 0x29, 0x74, 0x68, 0x29, 0x74, 0x6c, 0x29, 0x74, 0x6d,
    0x29, 0x74, 0x6e, 0x29, 0x74, 0x70, 0x29, 0x74, 0x72, 0x29, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table19_53_emit_[120] = {
    0x29, 0x20, 0x30, 0x29, 0x20, 0x31, 0x29, 0x20, 0x32, 0x29, 0x20, 0x61,
    0x29, 0x20, 0x63, 0x29, 0x20, 0x65, 0x29, 0x20, 0x69, 0x29, 0x20, 0x6f,
    0x29, 0x20, 0x73, 0x29, 0x20, 0x74, 0x29, 0x25, 0x30, 0x29, 0x25, 0x31,
    0x29, 0x25, 0x32, 0x29, 0x25, 0x61, 0x29, 0x25, 0x63, 0x29, 0x25, 0x65,
    0x29, 0x25, 0x69, 0x29, 0x25, 0x6f, 0x29, 0x25, 0x73, 0x29, 0x25, 0x74,
    0x29, 0x2d, 0x30, 0x29, 0x2d, 0x31, 0x29, 0x2d, 0x32, 0x29, 0x2d, 0x61,
    0x29, 0x2d, 0x63, 0x29, 0x2d, 0x65, 0x29, 0x2d, 0x69, 0x29, 0x2d, 0x6f,
    0x29, 0x2d, 0x73, 0x29, 0x2d, 0x74, 0x29, 0x2e, 0x30, 0x29, 0x2e, 0x31,
    0x29, 0x2e, 0x32, 0x29, 0x2e, 0x61, 0x29, 0x2e, 0x63, 0x29, 0x2e, 0x65,
    0x29, 0x2e, 0x69, 0x29, 0x2e, 0x6f, 0x29, 0x2e, 0x73, 0x29, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table19_54_emit_[120] = {
    0x29, 0x2f, 0x30, 0x29, 0x2f, 0x31, 0x29, 0x2f, 0x32, 0x29, 0x2f, 0x61,
    0x29, 0x2f, 0x63, 0x29, 0x2f, 0x65, 0x29, 0x2f, 0x69, 0x29, 0x2f, 0x6f,
    0x29, 0x2f, 0x73, 0x29, 0x2f, 0x74, 0x29, 0x33, 0x30, 0x29, 0x33, 0x31,
    0x29, 0x33, 0x32, 0x29, 0x33, 0x61, 0x29, 0x33, 0x63, 0x29, 0x33, 0x65,
    0x29, 0x33, 0x69, 0x29, 0x33, 0x6f, 0x29, 0x33, 0x73, 0x29, 0x33, 0x74,
    0x29, 0x34, 0x30, 0x29, 0x34, 0x31, 0x29, 0x34, 0x32, 0x29, 0x34, 0x61,
    0x29, 0x34, 0x63, 0x29, 0x34, 0x65, 0x29, 0x34, 0x69, 0x29, 0x34, 0x6f,
    0x29, 0x34, 0x73, 0x29, 0x34, 0x74, 0x29, 0x35, 0x30, 0x29, 0x35, 0x31,
    0x29, 0x35, 0x32, 0x29, 0x35, 0x61, 0x29, 0x35, 0x63, 0x29, 0x35, 0x65,
    0x29, 0x35, 0x69, 0x29, 0x35, 0x6f, 0x29, 0x35, 0x73, 0x29, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table19_55_emit_[120] = {
    0x29, 0x36, 0x30, 0x29, 0x36, 0x31, 0x29, 0x36, 0x32, 0x29, 0x36, 0x61,
    0x29, 0x36, 0x63, 0x29, 0x36, 0x65, 0x29, 0x36, 0x69, 0x29, 0x36, 0x6f,
    0x29, 0x36, 0x73, 0x29, 0x36, 0x74, 0x29, 0x37, 0x30, 0x29, 0x37, 0x31,
    0x29, 0x37, 0x32, 0x29, 0x37, 0x61, 0x29, 0x37, 0x63, 0x29, 0x37, 0x65,
    0x29, 0x37, 0x69, 0x29, 0x37, 0x6f, 0x29, 0x37, 0x73, 0x29, 0x37, 0x74,
    0x29, 0x38, 0x30, 0x29, 0x38, 0x31, 0x29, 0x38, 0x32, 0x29, 0x38, 0x61,
    0x29, 0x38, 0x63, 0x29, 0x38, 0x65, 0x29, 0x38, 0x69, 0x29, 0x38, 0x6f,
    0x29, 0x38, 0x73, 0x29, 0x38, 0x74, 0x29, 0x39, 0x30, 0x29, 0x39, 0x31,
    0x29, 0x39, 0x32, 0x29, 0x39, 0x61, 0x29, 0x39, 0x63, 0x29, 0x39, 0x65,
    0x29, 0x39, 0x69, 0x29, 0x39, 0x6f, 0x29, 0x39, 0x73, 0x29, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table19_56_emit_[120] = {
    0x29, 0x3d, 0x30, 0x29, 0x3d, 0x31, 0x29, 0x3d, 0x32, 0x29, 0x3d, 0x61,
    0x29, 0x3d, 0x63, 0x29, 0x3d, 0x65, 0x29, 0x3d, 0x69, 0x29, 0x3d, 0x6f,
    0x29, 0x3d, 0x73, 0x29, 0x3d, 0x74, 0x29, 0x41, 0x30, 0x29, 0x41, 0x31,
    0x29, 0x41, 0x32, 0x29, 0x41, 0x61, 0x29, 0x41, 0x63, 0x29, 0x41, 0x65,
    0x29, 0x41, 0x69, 0x29, 0x41, 0x6f, 0x29, 0x41, 0x73, 0x29, 0x41, 0x74,
    0x29, 0x5f, 0x30, 0x29, 0x5f, 0x31, 0x29, 0x5f, 0x32, 0x29, 0x5f, 0x61,
    0x29, 0x5f, 0x63, 0x29, 0x5f, 0x65, 0x29, 0x5f, 0x69, 0x29, 0x5f, 0x6f,
    0x29, 0x5f, 0x73, 0x29, 0x5f, 0x74, 0x29, 0x62, 0x30, 0x29, 0x62, 0x31,
    0x29, 0x62, 0x32, 0x29, 0x62, 0x61, 0x29, 0x62, 0x63, 0x29, 0x62, 0x65,
    0x29, 0x62, 0x69, 0x29, 0x62, 0x6f, 0x29, 0x62, 0x73, 0x29, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table19_57_emit_[120] = {
    0x29, 0x64, 0x30, 0x29, 0x64, 0x31, 0x29, 0x64, 0x32, 0x29, 0x64, 0x61,
    0x29, 0x64, 0x63, 0x29, 0x64, 0x65, 0x29, 0x64, 0x69, 0x29, 0x64, 0x6f,
    0x29, 0x64, 0x73, 0x29, 0x64, 0x74, 0x29, 0x66, 0x30, 0x29, 0x66, 0x31,
    0x29, 0x66, 0x32, 0x29, 0x66, 0x61, 0x29, 0x66, 0x63, 0x29, 0x66, 0x65,
    0x29, 0x66, 0x69, 0x29, 0x66, 0x6f, 0x29, 0x66, 0x73, 0x29, 0x66, 0x74,
    0x29, 0x67, 0x30, 0x29, 0x67, 0x31, 0x29, 0x67, 0x32, 0x29, 0x67, 0x61,
    0x29, 0x67, 0x63, 0x29, 0x67, 0x65, 0x29, 0x67, 0x69, 0x29, 0x67, 0x6f,
    0x29, 0x67, 0x73, 0x29, 0x67, 0x74, 0x29, 0x68, 0x30, 0x29, 0x68, 0x31,
    0x29, 0x68, 0x32, 0x29, 0x68, 0x61, 0x29, 0x68, 0x63, 0x29, 0x68, 0x65,
    0x29, 0x68, 0x69, 0x29, 0x68, 0x6f, 0x29, 0x68, 0x73, 0x29, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table19_58_emit_[120] = {
    0x29, 0x6c, 0x30, 0x29, 0x6c, 0x31, 0x29, 0x6c, 0x32, 0x29, 0x6c, 0x61,
    0x29, 0x6c, 0x63, 0x29, 0x6c, 0x65, 0x29, 0x6c, 0x69, 0x29, 0x6c, 0x6f,
    0x29, 0x6c, 0x73, 0x29, 0x6c, 0x74, 0x29, 0x6d, 0x30, 0x29, 0x6d, 0x31,
    0x29, 0x6d, 0x32, 0x29, 0x6d, 0x61, 0x29, 0x6d, 0x63, 0x29, 0x6d, 0x65,
    0x29, 0x6d, 0x69, 0x29, 0x6d, 0x6f, 0x29, 0x6d, 0x73, 0x29, 0x6d, 0x74,
    0x29, 0x6e, 0x30, 0x29, 0x6e, 0x31, 0x29, 0x6e, 0x32, 0x29, 0x6e, 0x61,
    0x29, 0x6e, 0x63, 0x29, 0x6e, 0x65, 0x29, 0x6e, 0x69, 0x29, 0x6e, 0x6f,
    0x29, 0x6e, 0x73, 0x29, 0x6e, 0x74, 0x29, 0x70, 0x30, 0x29, 0x70, 0x31,
    0x29, 0x70, 0x32, 0x29, 0x70, 0x61, 0x29, 0x70, 0x63, 0x29, 0x70, 0x65,
    0x29, 0x70, 0x69, 0x29, 0x70, 0x6f, 0x29, 0x70, 0x73, 0x29, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table19_59_emit_[68] = {
    0x29, 0x72, 0x30, 0x29, 0x72, 0x31, 0x29, 0x72, 0x32, 0x29, 0x72, 0x61,
    0x29, 0x72, 0x63, 0x29, 0x72, 0x65, 0x29, 0x72, 0x69, 0x29, 0x72, 0x6f,
    0x29, 0x72, 0x73, 0x29, 0x72, 0x74, 0x29, 0x75, 0x30, 0x29, 0x75, 0x31,
    0x29, 0x75, 0x32, 0x29, 0x75, 0x61, 0x29, 0x75, 0x63, 0x29, 0x75, 0x65,
    0x29, 0x75, 0x69, 0x29, 0x75, 0x6f, 0x29, 0x75, 0x73, 0x29, 0x75, 0x74,
    0x29, 0x3a, 0x29, 0x42, 0x29, 0x43, 0x29, 0x44};
const uint8_t HuffDecoderCommon::table19_63_emit_[35] = {
    0x29, 0x77, 0x29, 0x78, 0x29, 0x79, 0x29, 0x7a, 0x29, 0x26, 0x29, 0x2a,
    0x29, 0x2c, 0x29, 0x3b, 0x29, 0x58, 0x29, 0x5a, 0x29, 0x21, 0x29, 0x22,
    0x29, 0x28, 0x29, 0x29, 0x3f, 0x29, 0x27, 0x29, 0x2b, 0x29, 0x7c};
const uint16_t HuffDecoderCommon::table19_63_inner_[20] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052,
    0x0062, 0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2,
    0x00d2, 0x00da, 0x00ea, 0x00fa, 0x010a, 0x0003};
const uint8_t HuffDecoderCommon::table19_64_emit_[216] = {
    0x3f, 0x30, 0x30, 0x3f, 0x30, 0x31, 0x3f, 0x30, 0x32, 0x3f, 0x30, 0x61,
    0x3f, 0x30, 0x63, 0x3f, 0x30, 0x65, 0x3f, 0x30, 0x69, 0x3f, 0x30, 0x6f,
    0x3f, 0x30, 0x73, 0x3f, 0x30, 0x74, 0x3f, 0x30, 0x20, 0x3f, 0x30, 0x25,
    0x3f, 0x30, 0x2d, 0x3f, 0x30, 0x2e, 0x3f, 0x30, 0x2f, 0x3f, 0x30, 0x33,
    0x3f, 0x30, 0x34, 0x3f, 0x30, 0x35, 0x3f, 0x30, 0x36, 0x3f, 0x30, 0x37,
    0x3f, 0x30, 0x38, 0x3f, 0x30, 0x39, 0x3f, 0x30, 0x3d, 0x3f, 0x30, 0x41,
    0x3f, 0x30, 0x5f, 0x3f, 0x30, 0x62, 0x3f, 0x30, 0x64, 0x3f, 0x30, 0x66,
    0x3f, 0x30, 0x67, 0x3f, 0x30, 0x68, 0x3f, 0x30, 0x6c, 0x3f, 0x30, 0x6d,
    0x3f, 0x30, 0x6e, 0x3f, 0x30, 0x70, 0x3f, 0x30, 0x72, 0x3f, 0x30, 0x75,
    0x3f, 0x31, 0x30, 0x3f, 0x31, 0x31, 0x3f, 0x31, 0x32, 0x3f, 0x31, 0x61,
    0x3f, 0x31, 0x63, 0x3f, 0x31, 0x65, 0x3f, 0x31, 0x69, 0x3f, 0x31, 0x6f,
    0x3f, 0x31, 0x73, 0x3f, 0x31, 0x74, 0x3f, 0x31, 0x20, 0x3f, 0x31, 0x25,
    0x3f, 0x31, 0x2d, 0x3f, 0x31, 0x2e, 0x3f, 0x31, 0x2f, 0x3f, 0x31, 0x33,
    0x3f, 0x31, 0x34, 0x3f, 0x31, 0x35, 0x3f, 0x31, 0x36, 0x3f, 0x31, 0x37,
    0x3f, 0x31, 0x38, 0x3f, 0x31, 0x39, 0x3f, 0x31, 0x3d, 0x3f, 0x31, 0x41,
    0x3f, 0x31, 0x5f, 0x3f, 0x31, 0x62, 0x3f, 0x31, 0x64, 0x3f, 0x31, 0x66,
    0x3f, 0x31, 0x67, 0x3f, 0x31, 0x68, 0x3f, 0x31, 0x6c, 0x3f, 0x31, 0x6d,
    0x3f, 0x31, 0x6e, 0x3f, 0x31, 0x70, 0x3f, 0x31, 0x72, 0x3f, 0x31, 0x75};
const uint8_t HuffDecoderCommon::table19_65_emit_[216] = {
    0x3f, 0x32, 0x30, 0x3f, 0x32, 0x31, 0x3f, 0x32, 0x32, 0x3f, 0x32, 0x61,
    0x3f, 0x32, 0x63, 0x3f, 0x32, 0x65, 0x3f, 0x32, 0x69, 0x3f, 0x32, 0x6f,
    0x3f, 0x32, 0x73, 0x3f, 0x32, 0x74, 0x3f, 0x32, 0x20, 0x3f, 0x32, 0x25,
    0x3f, 0x32, 0x2d, 0x3f, 0x32, 0x2e, 0x3f, 0x32, 0x2f, 0x3f, 0x32, 0x33,
    0x3f, 0x32, 0x34, 0x3f, 0x32, 0x35, 0x3f, 0x32, 0x36, 0x3f, 0x32, 0x37,
    0x3f, 0x32, 0x38, 0x3f, 0x32, 0x39, 0x3f, 0x32, 0x3d, 0x3f, 0x32, 0x41,
    0x3f, 0x32, 0x5f, 0x3f, 0x32, 0x62, 0x3f, 0x32, 0x64, 0x3f, 0x32, 0x66,
    0x3f, 0x32, 0x67, 0x3f, 0x32, 0x68, 0x3f, 0x32, 0x6c, 0x3f, 0x32, 0x6d,
    0x3f, 0x32, 0x6e, 0x3f, 0x32, 0x70, 0x3f, 0x32, 0x72, 0x3f, 0x32, 0x75,
    0x3f, 0x61, 0x30, 0x3f, 0x61, 0x31, 0x3f, 0x61, 0x32, 0x3f, 0x61, 0x61,
    0x3f, 0x61, 0x63, 0x3f, 0x61, 0x65, 0x3f, 0x61, 0x69, 0x3f, 0x61, 0x6f,
    0x3f, 0x61, 0x73, 0x3f, 0x61, 0x74, 0x3f, 0x61, 0x20, 0x3f, 0x61, 0x25,
    0x3f, 0x61, 0x2d, 0x3f, 0x61, 0x2e, 0x3f, 0x61, 0x2f, 0x3f, 0x61, 0x33,
    0x3f, 0x61, 0x34, 0x3f, 0x61, 0x35, 0x3f, 0x61, 0x36, 0x3f, 0x61, 0x37,
    0x3f, 0x61, 0x38, 0x3f, 0x61, 0x39, 0x3f, 0x61, 0x3d, 0x3f, 0x61, 0x41,
    0x3f, 0x61, 0x5f, 0x3f, 0x61, 0x62, 0x3f, 0x61, 0x64, 0x3f, 0x61, 0x66,
    0x3f, 0x61, 0x67, 0x3f, 0x61, 0x68, 0x3f, 0x61, 0x6c, 0x3f, 0x61, 0x6d,
    0x3f, 0x61, 0x6e, 0x3f, 0x61, 0x70, 0x3f, 0x61, 0x72, 0x3f, 0x61, 0x75};
const uint8_t HuffDecoderCommon::table19_66_emit_[216] = {
    0x3f, 0x63, 0x30, 0x3f, 0x63, 0x31, 0x3f, 0x63, 0x32, 0x3f, 0x63, 0x61,
    0x3f, 0x63, 0x63, 0x3f, 0x63, 0x65, 0x3f, 0x63, 0x69, 0x3f, 0x63, 0x6f,
    0x3f, 0x63, 0x73, 0x3f, 0x63, 0x74, 0x3f, 0x63, 0x20, 0x3f, 0x63, 0x25,
    0x3f, 0x63, 0x2d, 0x3f, 0x63, 0x2e, 0x3f, 0x63, 0x2f, 0x3f, 0x63, 0x33,
    0x3f, 0x63, 0x34, 0x3f, 0x63, 0x35, 0x3f, 0x63, 0x36, 0x3f, 0x63, 0x37,
    0x3f, 0x63, 0x38, 0x3f, 0x63, 0x39, 0x3f, 0x63, 0x3d, 0x3f, 0x63, 0x41,
    0x3f, 0x63, 0x5f, 0x3f, 0x63, 0x62, 0x3f, 0x63, 0x64, 0x3f, 0x63, 0x66,
    0x3f, 0x63, 0x67, 0x3f, 0x63, 0x68, 0x3f, 0x63, 0x6c, 0x3f, 0x63, 0x6d,
    0x3f, 0x63, 0x6e, 0x3f, 0x63, 0x70, 0x3f, 0x63, 0x72, 0x3f, 0x63, 0x75,
    0x3f, 0x65, 0x30, 0x3f, 0x65, 0x31, 0x3f, 0x65, 0x32, 0x3f, 0x65, 0x61,
    0x3f, 0x65, 0x63, 0x3f, 0x65, 0x65, 0x3f, 0x65, 0x69, 0x3f, 0x65, 0x6f,
    0x3f, 0x65, 0x73, 0x3f, 0x65, 0x74, 0x3f, 0x65, 0x20, 0x3f, 0x65, 0x25,
    0x3f, 0x65, 0x2d, 0x3f, 0x65, 0x2e, 0x3f, 0x65, 0x2f, 0x3f, 0x65, 0x33,
    0x3f, 0x65, 0x34, 0x3f, 0x65, 0x35, 0x3f, 0x65, 0x36, 0x3f, 0x65, 0x37,
    0x3f, 0x65, 0x38, 0x3f, 0x65, 0x39, 0x3f, 0x65, 0x3d, 0x3f, 0x65, 0x41,
    0x3f, 0x65, 0x5f, 0x3f, 0x65, 0x62, 0x3f, 0x65, 0x64, 0x3f, 0x65, 0x66,
    0x3f, 0x65, 0x67, 0x3f, 0x65, 0x68, 0x3f, 0x65, 0x6c, 0x3f, 0x65, 0x6d,
    0x3f, 0x65, 0x6e, 0x3f, 0x65, 0x70, 0x3f, 0x65, 0x72, 0x3f, 0x65, 0x75};
const uint8_t HuffDecoderCommon::table19_67_emit_[216] = {
    0x3f, 0x69, 0x30, 0x3f, 0x69, 0x31, 0x3f, 0x69, 0x32, 0x3f, 0x69, 0x61,
    0x3f, 0x69, 0x63, 0x3f, 0x69, 0x65, 0x3f, 0x69, 0x69, 0x3f, 0x69, 0x6f,
    0x3f, 0x69, 0x73, 0x3f, 0x69, 0x74, 0x3f, 0x69, 0x20, 0x3f, 0x69, 0x25,
    0x3f, 0x69, 0x2d, 0x3f, 0x69, 0x2e, 0x3f, 0x69, 0x2f, 0x3f, 0x69, 0x33,
    0x3f, 0x69, 0x34, 0x3f, 0x69, 0x35, 0x3f, 0x69, 0x36, 0x3f, 0x69, 0x37,
    0x3f, 0x69, 0x38, 0x3f, 0x69, 0x39, 0x3f, 0x69, 0x3d, 0x3f, 0x69, 0x41,
    0x3f, 0x69, 0x5f, 0x3f, 0x69, 0x62, 0x3f, 0x69, 0x64, 0x3f, 0x69, 0x66,
    0x3f, 0x69, 0x67, 0x3f, 0x69, 0x68, 0x3f, 0x69, 0x6c, 0x3f, 0x69, 0x6d,
    0x3f, 0x69, 0x6e, 0x3f, 0x69, 0x70, 0x3f, 0x69, 0x72, 0x3f, 0x69, 0x75,
    0x3f, 0x6f, 0x30, 0x3f, 0x6f, 0x31, 0x3f, 0x6f, 0x32, 0x3f, 0x6f, 0x61,
    0x3f, 0x6f, 0x63, 0x3f, 0x6f, 0x65, 0x3f, 0x6f, 0x69, 0x3f, 0x6f, 0x6f,
    0x3f, 0x6f, 0x73, 0x3f, 0x6f, 0x74, 0x3f, 0x6f, 0x20, 0x3f, 0x6f, 0x25,
    0x3f, 0x6f, 0x2d, 0x3f, 0x6f, 0x2e, 0x3f, 0x6f, 0x2f, 0x3f, 0x6f, 0x33,
    0x3f, 0x6f, 0x34, 0x3f, 0x6f, 0x35, 0x3f, 0x6f, 0x36, 0x3f, 0x6f, 0x37,
    0x3f, 0x6f, 0x38, 0x3f, 0x6f, 0x39, 0x3f, 0x6f, 0x3d, 0x3f, 0x6f, 0x41,
    0x3f, 0x6f, 0x5f, 0x3f, 0x6f, 0x62, 0x3f, 0x6f, 0x64, 0x3f, 0x6f, 0x66,
    0x3f, 0x6f, 0x67, 0x3f, 0x6f, 0x68, 0x3f, 0x6f, 0x6c, 0x3f, 0x6f, 0x6d,
    0x3f, 0x6f, 0x6e, 0x3f, 0x6f, 0x70, 0x3f, 0x6f, 0x72, 0x3f, 0x6f, 0x75};
const uint8_t HuffDecoderCommon::table19_68_emit_[216] = {
    0x3f, 0x73, 0x30, 0x3f, 0x73, 0x31, 0x3f, 0x73, 0x32, 0x3f, 0x73, 0x61,
    0x3f, 0x73, 0x63, 0x3f, 0x73, 0x65, 0x3f, 0x73, 0x69, 0x3f, 0x73, 0x6f,
    0x3f, 0x73, 0x73, 0x3f, 0x73, 0x74, 0x3f, 0x73, 0x20, 0x3f, 0x73, 0x25,
    0x3f, 0x73, 0x2d, 0x3f, 0x73, 0x2e, 0x3f, 0x73, 0x2f, 0x3f, 0x73, 0x33,
    0x3f, 0x73, 0x34, 0x3f, 0x73, 0x35, 0x3f, 0x73, 0x36, 0x3f, 0x73, 0x37,
    0x3f, 0x73, 0x38, 0x3f, 0x73, 0x39, 0x3f, 0x73, 0x3d, 0x3f, 0x73, 0x41,
    0x3f, 0x73, 0x5f, 0x3f, 0x73, 0x62, 0x3f, 0x73, 0x64, 0x3f, 0x73, 0x66,
    0x3f, 0x73, 0x67, 0x3f, 0x73, 0x68, 0x3f, 0x73, 0x6c, 0x3f, 0x73, 0x6d,
    0x3f, 0x73, 0x6e, 0x3f, 0x73, 0x70, 0x3f, 0x73, 0x72, 0x3f, 0x73, 0x75,
    0x3f, 0x74, 0x30, 0x3f, 0x74, 0x31, 0x3f, 0x74, 0x32, 0x3f, 0x74, 0x61,
    0x3f, 0x74, 0x63, 0x3f, 0x74, 0x65, 0x3f, 0x74, 0x69, 0x3f, 0x74, 0x6f,
    0x3f, 0x74, 0x73, 0x3f, 0x74, 0x74, 0x3f, 0x74, 0x20, 0x3f, 0x74, 0x25,
    0x3f, 0x74, 0x2d, 0x3f, 0x74, 0x2e, 0x3f, 0x74, 0x2f, 0x3f, 0x74, 0x33,
    0x3f, 0x74, 0x34, 0x3f, 0x74, 0x35, 0x3f, 0x74, 0x36, 0x3f, 0x74, 0x37,
    0x3f, 0x74, 0x38, 0x3f, 0x74, 0x39, 0x3f, 0x74, 0x3d, 0x3f, 0x74, 0x41,
    0x3f, 0x74, 0x5f, 0x3f, 0x74, 0x62, 0x3f, 0x74, 0x64, 0x3f, 0x74, 0x66,
    0x3f, 0x74, 0x67, 0x3f, 0x74, 0x68, 0x3f, 0x74, 0x6c, 0x3f, 0x74, 0x6d,
    0x3f, 0x74, 0x6e, 0x3f, 0x74, 0x70, 0x3f, 0x74, 0x72, 0x3f, 0x74, 0x75};
const uint8_t HuffDecoderCommon::table19_69_emit_[120] = {
    0x3f, 0x20, 0x30, 0x3f, 0x20, 0x31, 0x3f, 0x20, 0x32, 0x3f, 0x20, 0x61,
    0x3f, 0x20, 0x63, 0x3f, 0x20, 0x65, 0x3f, 0x20, 0x69, 0x3f, 0x20, 0x6f,
    0x3f, 0x20, 0x73, 0x3f, 0x20, 0x74, 0x3f, 0x25, 0x30, 0x3f, 0x25, 0x31,
    0x3f, 0x25, 0x32, 0x3f, 0x25, 0x61, 0x3f, 0x25, 0x63, 0x3f, 0x25, 0x65,
    0x3f, 0x25, 0x69, 0x3f, 0x25, 0x6f, 0x3f, 0x25, 0x73, 0x3f, 0x25, 0x74,
    0x3f, 0x2d, 0x30, 0x3f, 0x2d, 0x31, 0x3f, 0x2d, 0x32, 0x3f, 0x2d, 0x61,
    0x3f, 0x2d, 0x63, 0x3f, 0x2d, 0x65, 0x3f, 0x2d, 0x69, 0x3f, 0x2d, 0x6f,
    0x3f, 0x2d, 0x73, 0x3f, 0x2d, 0x74, 0x3f, 0x2e, 0x30, 0x3f, 0x2e, 0x31,
    0x3f, 0x2e, 0x32, 0x3f, 0x2e, 0x61, 0x3f, 0x2e, 0x63, 0x3f, 0x2e, 0x65,
    0x3f, 0x2e, 0x69, 0x3f, 0x2e, 0x6f, 0x3f, 0x2e, 0x73, 0x3f, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table19_70_emit_[120] = {
    0x3f, 0x2f, 0x30, 0x3f, 0x2f, 0x31, 0x3f, 0x2f, 0x32, 0x3f, 0x2f, 0x61,
    0x3f, 0x2f, 0x63, 0x3f, 0x2f, 0x65, 0x3f, 0x2f, 0x69, 0x3f, 0x2f, 0x6f,
    0x3f, 0x2f, 0x73, 0x3f, 0x2f, 0x74, 0x3f, 0x33, 0x30, 0x3f, 0x33, 0x31,
    0x3f, 0x33, 0x32, 0x3f, 0x33, 0x61, 0x3f, 0x33, 0x63, 0x3f, 0x33, 0x65,
    0x3f, 0x33, 0x69, 0x3f, 0x33, 0x6f, 0x3f, 0x33, 0x73, 0x3f, 0x33, 0x74,
    0x3f, 0x34, 0x30, 0x3f, 0x34, 0x31, 0x3f, 0x34, 0x32, 0x3f, 0x34, 0x61,
    0x3f, 0x34, 0x63, 0x3f, 0x34, 0x65, 0x3f, 0x34, 0x69, 0x3f, 0x34, 0x6f,
    0x3f, 0x34, 0x73, 0x3f, 0x34, 0x74, 0x3f, 0x35, 0x30, 0x3f, 0x35, 0x31,
    0x3f, 0x35, 0x32, 0x3f, 0x35, 0x61, 0x3f, 0x35, 0x63, 0x3f, 0x35, 0x65,
    0x3f, 0x35, 0x69, 0x3f, 0x35, 0x6f, 0x3f, 0x35, 0x73, 0x3f, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table19_71_emit_[120] = {
    0x3f, 0x36, 0x30, 0x3f, 0x36, 0x31, 0x3f, 0x36, 0x32, 0x3f, 0x36, 0x61,
    0x3f, 0x36, 0x63, 0x3f, 0x36, 0x65, 0x3f, 0x36, 0x69, 0x3f, 0x36, 0x6f,
    0x3f, 0x36, 0x73, 0x3f, 0x36, 0x74, 0x3f, 0x37, 0x30, 0x3f, 0x37, 0x31,
    0x3f, 0x37, 0x32, 0x3f, 0x37, 0x61, 0x3f, 0x37, 0x63, 0x3f, 0x37, 0x65,
    0x3f, 0x37, 0x69, 0x3f, 0x37, 0x6f, 0x3f, 0x37, 0x73, 0x3f, 0x37, 0x74,
    0x3f, 0x38, 0x30, 0x3f, 0x38, 0x31, 0x3f, 0x38, 0x32, 0x3f, 0x38, 0x61,
    0x3f, 0x38, 0x63, 0x3f, 0x38, 0x65, 0x3f, 0x38, 0x69, 0x3f, 0x38, 0x6f,
    0x3f, 0x38, 0x73, 0x3f, 0x38, 0x74, 0x3f, 0x39, 0x30, 0x3f, 0x39, 0x31,
    0x3f, 0x39, 0x32, 0x3f, 0x39, 0x61, 0x3f, 0x39, 0x63, 0x3f, 0x39, 0x65,
    0x3f, 0x39, 0x69, 0x3f, 0x39, 0x6f, 0x3f, 0x39, 0x73, 0x3f, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table19_72_emit_[120] = {
    0x3f, 0x3d, 0x30, 0x3f, 0x3d, 0x31, 0x3f, 0x3d, 0x32, 0x3f, 0x3d, 0x61,
    0x3f, 0x3d, 0x63, 0x3f, 0x3d, 0x65, 0x3f, 0x3d, 0x69, 0x3f, 0x3d, 0x6f,
    0x3f, 0x3d, 0x73, 0x3f, 0x3d, 0x74, 0x3f, 0x41, 0x30, 0x3f, 0x41, 0x31,
    0x3f, 0x41, 0x32, 0x3f, 0x41, 0x61, 0x3f, 0x41, 0x63, 0x3f, 0x41, 0x65,
    0x3f, 0x41, 0x69, 0x3f, 0x41, 0x6f, 0x3f, 0x41, 0x73, 0x3f, 0x41, 0x74,
    0x3f, 0x5f, 0x30, 0x3f, 0x5f, 0x31, 0x3f, 0x5f, 0x32, 0x3f, 0x5f, 0x61,
    0x3f, 0x5f, 0x63, 0x3f, 0x5f, 0x65, 0x3f, 0x5f, 0x69, 0x3f, 0x5f, 0x6f,
    0x3f, 0x5f, 0x73, 0x3f, 0x5f, 0x74, 0x3f, 0x62, 0x30, 0x3f, 0x62, 0x31,
    0x3f, 0x62, 0x32, 0x3f, 0x62, 0x61, 0x3f, 0x62, 0x63, 0x3f, 0x62, 0x65,
    0x3f, 0x62, 0x69, 0x3f, 0x62, 0x6f, 0x3f, 0x62, 0x73, 0x3f, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table19_73_emit_[120] = {
    0x3f, 0x64, 0x30, 0x3f, 0x64, 0x31, 0x3f, 0x64, 0x32, 0x3f, 0x64, 0x61,
    0x3f, 0x64, 0x63, 0x3f, 0x64, 0x65, 0x3f, 0x64, 0x69, 0x3f, 0x64, 0x6f,
    0x3f, 0x64, 0x73, 0x3f, 0x64, 0x74, 0x3f, 0x66, 0x30, 0x3f, 0x66, 0x31,
    0x3f, 0x66, 0x32, 0x3f, 0x66, 0x61, 0x3f, 0x66, 0x63, 0x3f, 0x66, 0x65,
    0x3f, 0x66, 0x69, 0x3f, 0x66, 0x6f, 0x3f, 0x66, 0x73, 0x3f, 0x66, 0x74,
    0x3f, 0x67, 0x30, 0x3f, 0x67, 0x31, 0x3f, 0x67, 0x32, 0x3f, 0x67, 0x61,
    0x3f, 0x67, 0x63, 0x3f, 0x67, 0x65, 0x3f, 0x67, 0x69, 0x3f, 0x67, 0x6f,
    0x3f, 0x67, 0x73, 0x3f, 0x67, 0x74, 0x3f, 0x68, 0x30, 0x3f, 0x68, 0x31,
    0x3f, 0x68, 0x32, 0x3f, 0x68, 0x61, 0x3f, 0x68, 0x63, 0x3f, 0x68, 0x65,
    0x3f, 0x68, 0x69, 0x3f, 0x68, 0x6f, 0x3f, 0x68, 0x73, 0x3f, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table19_74_emit_[120] = {
    0x3f, 0x6c, 0x30, 0x3f, 0x6c, 0x31, 0x3f, 0x6c, 0x32, 0x3f, 0x6c, 0x61,
    0x3f, 0x6c, 0x63, 0x3f, 0x6c, 0x65, 0x3f, 0x6c, 0x69, 0x3f, 0x6c, 0x6f,
    0x3f, 0x6c, 0x73, 0x3f, 0x6c, 0x74, 0x3f, 0x6d, 0x30, 0x3f, 0x6d, 0x31,
    0x3f, 0x6d, 0x32, 0x3f, 0x6d, 0x61, 0x3f, 0x6d, 0x63, 0x3f, 0x6d, 0x65,
    0x3f, 0x6d, 0x69, 0x3f, 0x6d, 0x6f, 0x3f, 0x6d, 0x73, 0x3f, 0x6d, 0x74,
    0x3f, 0x6e, 0x30, 0x3f, 0x6e, 0x31, 0x3f, 0x6e, 0x32, 0x3f, 0x6e, 0x61,
    0x3f, 0x6e, 0x63, 0x3f, 0x6e, 0x65, 0x3f, 0x6e, 0x69, 0x3f, 0x6e, 0x6f,
    0x3f, 0x6e, 0x73, 0x3f, 0x6e, 0x74, 0x3f, 0x70, 0x30, 0x3f, 0x70, 0x31,
    0x3f, 0x70, 0x32, 0x3f, 0x70, 0x61, 0x3f, 0x70, 0x63, 0x3f, 0x70, 0x65,
    0x3f, 0x70, 0x69, 0x3f, 0x70, 0x6f, 0x3f, 0x70, 0x73, 0x3f, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table19_75_emit_[68] = {
    0x3f, 0x72, 0x30, 0x3f, 0x72, 0x31, 0x3f, 0x72, 0x32, 0x3f, 0x72, 0x61,
    0x3f, 0x72, 0x63, 0x3f, 0x72, 0x65, 0x3f, 0x72, 0x69, 0x3f, 0x72, 0x6f,
    0x3f, 0x72, 0x73, 0x3f, 0x72, 0x74, 0x3f, 0x75, 0x30, 0x3f, 0x75, 0x31,
    0x3f, 0x75, 0x32, 0x3f, 0x75, 0x61, 0x3f, 0x75, 0x63, 0x3f, 0x75, 0x65,
    0x3f, 0x75, 0x69, 0x3f, 0x75, 0x6f, 0x3f, 0x75, 0x73, 0x3f, 0x75, 0x74,
    0x3f, 0x3a, 0x3f, 0x42, 0x3f, 0x43, 0x3f, 0x44};
const uint8_t HuffDecoderCommon::table19_79_emit_[35] = {
    0x3f, 0x77, 0x3f, 0x78, 0x3f, 0x79, 0x3f, 0x7a, 0x3f, 0x26, 0x3f, 0x2a,
    0x3f, 0x2c, 0x3f, 0x3b, 0x3f, 0x58, 0x3f, 0x5a, 0x3f, 0x21, 0x3f, 0x22,
    0x3f, 0x28, 0x3f, 0x29, 0x3f, 0x3f, 0x27, 0x3f, 0x2b, 0x3f, 0x7c};
const uint16_t HuffDecoderCommon::table19_79_inner_[20] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052,
    0x0062, 0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2,
    0x00d2, 0x00e2, 0x00ea, 0x00fa, 0x010a, 0x0003};
const uint8_t HuffDecoderCommon::table19_80_emit_[120] = {
    0x27, 0x30, 0x30, 0x27, 0x30, 0x31, 0x27, 0x30, 0x32, 0x27, 0x30, 0x61,
    0x27, 0x30, 0x63, 0x27, 0x30, 0x65, 0x27, 0x30, 0x69, 0x27, 0x30, 0x6f,
    0x27, 0x30, 0x73, 0x27, 0x30, 0x74, 0x27, 0x31, 0x30, 0x27, 0x31, 0x31,
    0x27, 0x31, 0x32, 0x27, 0x31, 0x61, 0x27, 0x31, 0x63, 0x27, 0x31, 0x65,
    0x27, 0x31, 0x69, 0x27, 0x31, 0x6f, 0x27, 0x31, 0x73, 0x27, 0x31, 0x74,
    0x27, 0x32, 0x30, 0x27, 0x32, 0x31, 0x27, 0x32, 0x32, 0x27, 0x32, 0x61,
    0x27, 0x32, 0x63, 0x27, 0x32, 0x65, 0x27, 0x32, 0x69, 0x27, 0x32, 0x6f,
    0x27, 0x32, 0x73, 0x27, 0x32, 0x74, 0x27, 0x61, 0x30, 0x27, 0x61, 0x31,
    0x27, 0x61, 0x32, 0x27, 0x61, 0x61, 0x27, 0x61, 0x63, 0x27, 0x61, 0x65,
    0x27, 0x61, 0x69, 0x27, 0x61, 0x6f, 0x27, 0x61, 0x73, 0x27, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table19_81_emit_[120] = {
    0x27, 0x63, 0x30, 0x27, 0x63, 0x31, 0x27, 0x63, 0x32, 0x27, 0x63, 0x61,
    0x27, 0x63, 0x63, 0x27, 0x63, 0x65, 0x27, 0x63, 0x69, 0x27, 0x63, 0x6f,
    0x27, 0x63, 0x73, 0x27, 0x63, 0x74, 0x27, 0x65, 0x30, 0x27, 0x65, 0x31,
    0x27, 0x65, 0x32, 0x27, 0x65, 0x61, 0x27, 0x65, 0x63, 0x27, 0x65, 0x65,
    0x27, 0x65, 0x69, 0x27, 0x65, 0x6f, 0x27, 0x65, 0x73, 0x27, 0x65, 0x74,
    0x27, 0x69, 0x30, 0x27, 0x69, 0x31, 0x27, 0x69, 0x32, 0x27, 0x69, 0x61,
    0x27, 0x69, 0x63, 0x27, 0x69, 0x65, 0x27, 0x69, 0x69, 0x27, 0x69, 0x6f,
    0x27, 0x69, 0x73, 0x27, 0x69, 0x74, 0x27, 0x6f, 0x30, 0x27, 0x6f, 0x31,
    0x27, 0x6f, 0x32, 0x27, 0x6f, 0x61, 0x27, 0x6f, 0x63, 0x27, 0x6f, 0x65,
    0x27, 0x6f, 0x69, 0x27, 0x6f, 0x6f, 0x27, 0x6f, 0x73, 0x27, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table19_82_emit_[68] = {
    0x27, 0x73, 0x30, 0x27, 0x73, 0x31, 0x27, 0x73, 0x32, 0x27, 0x73, 0x61,
    0x27, 0x73, 0x63, 0x27, 0x73, 0x65, 0x27, 0x73, 0x69, 0x27, 0x73, 0x6f,
    0x27, 0x73, 0x73, 0x27, 0x73, 0x74, 0x27, 0x74, 0x30, 0x27, 0x74, 0x31,
    0x27, 0x74, 0x32, 0x27, 0x74, 0x61, 0x27, 0x74, 0x63, 0x27, 0x74, 0x65,
    0x27, 0x74, 0x69, 0x27, 0x74, 0x6f, 0x27, 0x74, 0x73, 0x27, 0x74, 0x74,
    0x27, 0x20, 0x27, 0x25, 0x27, 0x2d, 0x27, 0x2e};
const uint16_t HuffDecoderCommon::table19_85_inner_[11] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042,
    0x0052, 0x0062, 0x0072, 0x0082, 0x0092};
const uint8_t HuffDecoderCommon::table19_85_outer_[128] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0,
    0, 8, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 10};
const uint16_t HuffDecoderCommon::table19_86_inner_[17] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2};
const uint8_t HuffDecoderCommon::table19_86_outer_[128] = {
    0, 0,  0, 0, 0, 0, 0, 1,  0, 0,  0, 0, 0, 0,  0, 2,  0, 0, 0, 0, 0, 0,
    0, 3,  0, 0, 0, 0, 0, 0,  0, 4,  0, 0, 0, 0,  0, 0,  0, 5, 0, 0, 0, 0,
    0, 0,  0, 6, 0, 0, 0, 0,  0, 0,  0, 7, 0, 0,  0, 0,  0, 0, 0, 8, 0, 0,
    0, 0,  0, 0, 0, 9, 0, 0,  0, 0,  0, 0, 0, 10, 0, 0,  0, 0, 0, 0, 0, 11,
    0, 0,  0, 0, 0, 0, 0, 12, 0, 0,  0, 0, 0, 0,  0, 13, 0, 0, 0, 0, 0, 0,
    0, 14, 0, 0, 0, 0, 0, 0,  0, 15, 0, 0, 0, 0,  0, 0,  0, 16};
const uint8_t HuffDecoderCommon::table19_87_emit_[46] = {
    0x27, 0x55, 0x27, 0x56, 0x27, 0x57, 0x27, 0x59, 0x27, 0x6a, 0x27, 0x6b,
    0x27, 0x71, 0x27, 0x76, 0x27, 0x77, 0x27, 0x78, 0x27, 0x79, 0x27, 0x7a,
    0x27, 0x26, 0x27, 0x2a, 0x27, 0x2c, 0x27, 0x3b, 0x27, 0x58, 0x27, 0x5a,
    0x27, 0x21, 0x27, 0x22, 0x27, 0x28, 0x27, 0x29, 0x27, 0x3f};
const uint16_t HuffDecoderCommon::table19_87_inner_[25] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0003};
const uint8_t HuffDecoderCommon::table19_87_outer_[128] = {
    0,  0,  0, 0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0, 0, 2, 0,  0, 0,
    0,  0,  0, 0,  3,  0,  0,  0,  0,  0,  0,  0,  4,  0, 0, 0, 0,  0, 0,
    0,  5,  0, 0,  0,  0,  0,  0,  0,  6,  0,  0,  0,  0, 0, 0, 0,  7, 0,
    0,  0,  0, 0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 9, 0, 0,  0, 0,
    0,  0,  0, 10, 0,  0,  0,  0,  0,  0,  0,  11, 0,  0, 0, 0, 0,  0, 0,
    12, 0,  0, 0,  13, 0,  0,  0,  14, 0,  0,  0,  15, 0, 0, 0, 16, 0, 0,
    0,  17, 0, 0,  0,  18, 19, 20, 21, 22, 23, 0,  0,  24};
const uint8_t HuffDecoderCommon::table19_88_emit_[120] = {
    0x2b, 0x30, 0x30, 0x2b, 0x30, 0x31, 0x2b, 0x30, 0x32, 0x2b, 0x30, 0x61,
    0x2b, 0x30, 0x63, 0x2b, 0x30, 0x65, 0x2b, 0x30, 0x69, 0x2b, 0x30, 0x6f,
    0x2b, 0x30, 0x73, 0x2b, 0x30, 0x74, 0x2b, 0x31, 0x30, 0x2b, 0x31, 0x31,
    0x2b, 0x31, 0x32, 0x2b, 0x31, 0x61, 0x2b, 0x31, 0x63, 0x2b, 0x31, 0x65,
    0x2b, 0x31, 0x69, 0x2b, 0x31, 0x6f, 0x2b, 0x31, 0x73, 0x2b, 0x31, 0x74,
    0x2b, 0x32, 0x30, 0x2b, 0x32, 0x31, 0x2b, 0x32, 0x32, 0x2b, 0x32, 0x61,
    0x2b, 0x32, 0x63, 0x2b, 0x32, 0x65, 0x2b, 0x32, 0x69, 0x2b, 0x32, 0x6f,
    0x2b, 0x32, 0x73, 0x2b, 0x32, 0x74, 0x2b, 0x61, 0x30, 0x2b, 0x61, 0x31,
    0x2b, 0x61, 0x32, 0x2b, 0x61, 0x61, 0x2b, 0x61, 0x63, 0x2b, 0x61, 0x65,
    0x2b, 0x61, 0x69, 0x2b, 0x61, 0x6f, 0x2b, 0x61, 0x73, 0x2b, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table19_89_emit_[120] = {
    0x2b, 0x63, 0x30, 0x2b, 0x63, 0x31, 0x2b, 0x63, 0x32, 0x2b, 0x63, 0x61,
    0x2b, 0x63, 0x63, 0x2b, 0x63, 0x65, 0x2b, 0x63, 0x69, 0x2b, 0x63, 0x6f,
    0x2b, 0x63, 0x73, 0x2b, 0x63, 0x74, 0x2b, 0x65, 0x30, 0x2b, 0x65, 0x31,
    0x2b, 0x65, 0x32, 0x2b, 0x65, 0x61, 0x2b, 0x65, 0x63, 0x2b, 0x65, 0x65,
    0x2b, 0x65, 0x69, 0x2b, 0x65, 0x6f, 0x2b, 0x65, 0x73, 0x2b, 0x65, 0x74,
    0x2b, 0x69, 0x30, 0x2b, 0x69, 0x31, 0x2b, 0x69, 0x32, 0x2b, 0x69, 0x61,
    0x2b, 0x69, 0x63, 0x2b, 0x69, 0x65, 0x2b, 0x69, 0x69, 0x2b, 0x69, 0x6f,
    0x2b, 0x69, 0x73, 0x2b, 0x69, 0x74, 0x2b, 0x6f, 0x30, 0x2b, 0x6f, 0x31,
    0x2b, 0x6f, 0x32, 0x2b, 0x6f, 0x61, 0x2b, 0x6f, 0x63, 0x2b, 0x6f, 0x65,
    0x2b, 0x6f, 0x69, 0x2b, 0x6f, 0x6f, 0x2b, 0x6f, 0x73, 0x2b, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table19_90_emit_[68] = {
    0x2b, 0x73, 0x30, 0x2b, 0x73, 0x31, 0x2b, 0x73, 0x32, 0x2b, 0x73, 0x61,
    0x2b, 0x73, 0x63, 0x2b, 0x73, 0x65, 0x2b, 0x73, 0x69, 0x2b, 0x73, 0x6f,
    0x2b, 0x73, 0x73, 0x2b, 0x73, 0x74, 0x2b, 0x74, 0x30, 0x2b, 0x74, 0x31,
    0x2b, 0x74, 0x32, 0x2b, 0x74, 0x61, 0x2b, 0x74, 0x63, 0x2b, 0x74, 0x65,
    0x2b, 0x74, 0x69, 0x2b, 0x74, 0x6f, 0x2b, 0x74, 0x73, 0x2b, 0x74, 0x74,
    0x2b, 0x20, 0x2b, 0x25, 0x2b, 0x2d, 0x2b, 0x2e};
const uint8_t HuffDecoderCommon::table19_95_emit_[46] = {
    0x2b, 0x55, 0x2b, 0x56, 0x2b, 0x57, 0x2b, 0x59, 0x2b, 0x6a, 0x2b, 0x6b,
    0x2b, 0x71, 0x2b, 0x76, 0x2b, 0x77, 0x2b, 0x78, 0x2b, 0x79, 0x2b, 0x7a,
    0x2b, 0x26, 0x2b, 0x2a, 0x2b, 0x2c, 0x2b, 0x3b, 0x2b, 0x58, 0x2b, 0x5a,
    0x2b, 0x21, 0x2b, 0x22, 0x2b, 0x28, 0x2b, 0x29, 0x2b, 0x3f};
const uint8_t HuffDecoderCommon::table19_96_emit_[120] = {
    0x7c, 0x30, 0x30, 0x7c, 0x30, 0x31, 0x7c, 0x30, 0x32, 0x7c, 0x30, 0x61,
    0x7c, 0x30, 0x63, 0x7c, 0x30, 0x65, 0x7c, 0x30, 0x69, 0x7c, 0x30, 0x6f,
    0x7c, 0x30, 0x73, 0x7c, 0x30, 0x74, 0x7c, 0x31, 0x30, 0x7c, 0x31, 0x31,
    0x7c, 0x31, 0x32, 0x7c, 0x31, 0x61, 0x7c, 0x31, 0x63, 0x7c, 0x31, 0x65,
    0x7c, 0x31, 0x69, 0x7c, 0x31, 0x6f, 0x7c, 0x31, 0x73, 0x7c, 0x31, 0x74,
    0x7c, 0x32, 0x30, 0x7c, 0x32, 0x31, 0x7c, 0x32, 0x32, 0x7c, 0x32, 0x61,
    0x7c, 0x32, 0x63, 0x7c, 0x32, 0x65, 0x7c, 0x32, 0x69, 0x7c, 0x32, 0x6f,
    0x7c, 0x32, 0x73, 0x7c, 0x32, 0x74, 0x7c, 0x61, 0x30, 0x7c, 0x61, 0x31,
    0x7c, 0x61, 0x32, 0x7c, 0x61, 0x61, 0x7c, 0x61, 0x63, 0x7c, 0x61, 0x65,
    0x7c, 0x61, 0x69, 0x7c, 0x61, 0x6f, 0x7c, 0x61, 0x73, 0x7c, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table19_97_emit_[120] = {
    0x7c, 0x63, 0x30, 0x7c, 0x63, 0x31, 0x7c, 0x63, 0x32, 0x7c, 0x63, 0x61,
    0x7c, 0x63, 0x63, 0x7c, 0x63, 0x65, 0x7c, 0x63, 0x69, 0x7c, 0x63, 0x6f,
    0x7c, 0x63, 0x73, 0x7c, 0x63, 0x74, 0x7c, 0x65, 0x30, 0x7c, 0x65, 0x31,
    0x7c, 0x65, 0x32, 0x7c, 0x65, 0x61, 0x7c, 0x65, 0x63, 0x7c, 0x65, 0x65,
    0x7c, 0x65, 0x69, 0x7c, 0x65, 0x6f, 0x7c, 0x65, 0x73, 0x7c, 0x65, 0x74,
    0x7c, 0x69, 0x30, 0x7c, 0x69, 0x31, 0x7c, 0x69, 0x32, 0x7c, 0x69, 0x61,
    0x7c, 0x69, 0x63, 0x7c, 0x69, 0x65, 0x7c, 0x69, 0x69, 0x7c, 0x69, 0x6f,
    0x7c, 0x69, 0x73, 0x7c, 0x69, 0x74, 0x7c, 0x6f, 0x30, 0x7c, 0x6f, 0x31,
    0x7c, 0x6f, 0x32, 0x7c, 0x6f, 0x61, 0x7c, 0x6f, 0x63, 0x7c, 0x6f, 0x65,
    0x7c, 0x6f, 0x69, 0x7c, 0x6f, 0x6f, 0x7c, 0x6f, 0x73, 0x7c, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table19_98_emit_[68] = {
    0x7c, 0x73, 0x30, 0x7c, 0x73, 0x31, 0x7c, 0x73, 0x32, 0x7c, 0x73, 0x61,
    0x7c, 0x73, 0x63, 0x7c, 0x73, 0x65, 0x7c, 0x73, 0x69, 0x7c, 0x73, 0x6f,
    0x7c, 0x73, 0x73, 0x7c, 0x73, 0x74, 0x7c, 0x74, 0x30, 0x7c, 0x74, 0x31,
    0x7c, 0x74, 0x32, 0x7c, 0x74, 0x61, 0x7c, 0x74, 0x63, 0x7c, 0x74, 0x65,
    0x7c, 0x74, 0x69, 0x7c, 0x74, 0x6f, 0x7c, 0x74, 0x73, 0x7c, 0x74, 0x74,
    0x7c, 0x20, 0x7c, 0x25, 0x7c, 0x2d, 0x7c, 0x2e};
const uint8_t HuffDecoderCommon::table19_103_emit_[46] = {
    0x7c, 0x55, 0x7c, 0x56, 0x7c, 0x57, 0x7c, 0x59, 0x7c, 0x6a, 0x7c, 0x6b,
    0x7c, 0x71, 0x7c, 0x76, 0x7c, 0x77, 0x7c, 0x78, 0x7c, 0x79, 0x7c, 0x7a,
    0x7c, 0x26, 0x7c, 0x2a, 0x7c, 0x2c, 0x7c, 0x3b, 0x7c, 0x58, 0x7c, 0x5a,
    0x7c, 0x21, 0x7c, 0x22, 0x7c, 0x28, 0x7c, 0x29, 0x7c, 0x3f};
const uint16_t HuffDecoderCommon::table19_105_inner_[15] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062,
    0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2};
const uint8_t HuffDecoderCommon::table19_105_outer_[128] = {
    0, 0,  0, 0, 0, 0, 0, 0,  0, 0,  0, 0, 0, 0, 0, 1,  0, 0, 0, 0, 0, 0,
    0, 0,  0, 0, 0, 0, 0, 0,  0, 2,  0, 0, 0, 0, 0, 0,  0, 3, 0, 0, 0, 0,
    0, 0,  0, 4, 0, 0, 0, 0,  0, 0,  0, 5, 0, 0, 0, 0,  0, 0, 0, 6, 0, 0,
    0, 0,  0, 0, 0, 7, 0, 0,  0, 0,  0, 0, 0, 8, 0, 0,  0, 0, 0, 0, 0, 9,
    0, 0,  0, 0, 0, 0, 0, 10, 0, 0,  0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0,
    0, 12, 0, 0, 0, 0, 0, 0,  0, 13, 0, 0, 0, 0, 0, 0,  0, 14};
const uint16_t HuffDecoderCommon::table19_106_inner_[19] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052,
    0x0062, 0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2,
    0x00d2, 0x00e2, 0x00f2, 0x0102, 0x0112};
const uint8_t HuffDecoderCommon::table19_106_outer_[128] = {
    0, 0,  0, 0, 0, 0,  0, 1,  0, 0,  0, 0, 0, 0,  0, 2,  0, 0, 0, 0, 0, 0,
    0, 3,  0, 0, 0, 0,  0, 0,  0, 4,  0, 0, 0, 0,  0, 0,  0, 5, 0, 0, 0, 0,
    0, 0,  0, 6, 0, 0,  0, 0,  0, 0,  0, 7, 0, 0,  0, 0,  0, 0, 0, 8, 0, 0,
    0, 0,  0, 0, 0, 9,  0, 0,  0, 0,  0, 0, 0, 10, 0, 0,  0, 0, 0, 0, 0, 11,
    0, 0,  0, 0, 0, 0,  0, 12, 0, 0,  0, 0, 0, 0,  0, 13, 0, 0, 0, 0, 0, 0,
    0, 14, 0, 0, 0, 15, 0, 0,  0, 16, 0, 0, 0, 17, 0, 0,  0, 18};
const uint16_t HuffDecoderCommon::table19_107_inner_[36] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0003};
const uint8_t HuffDecoderCommon::table19_107_outer_[128] = {
    0, 0,  0, 1,  0, 0,  0, 2,  0, 0,  0, 3,  0, 0,  0, 4,  0, 0,  0, 5,  0, 0,
    0, 6,  0, 0,  0, 7,  0, 0,  0, 8,  0, 0,  0, 9,  0, 0,  0, 10, 0, 0,  0, 11,
    0, 0,  0, 12, 0, 0,  0, 13, 0, 0,  0, 14, 0, 0,  0, 15, 0, 0,  0, 16, 0, 0,
    0, 17, 0, 0,  0, 18, 0, 0,  0, 19, 0, 0,  0, 20, 0, 0,  0, 21, 0, 0,  0, 22,
    0, 0,  0, 23, 0, 0,  0, 24, 0, 0,  0, 25, 0, 0,  0, 26, 0, 0,  0, 27, 0, 0,
    0, 28, 0, 29, 0, 30, 0, 31, 0, 32, 0, 33, 0, 34, 0, 0,  0, 35};
const uint16_t HuffDecoderCommon::table19_112_inner_[23] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062,
    0x0072, 0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2,
    0x00f2, 0x0102, 0x0112, 0x0122, 0x0132, 0x0142, 0x0152};
const uint8_t HuffDecoderCommon::table19_112_outer_[128] = {
    0, 0,  0, 0,  0, 0,  0, 1,  0, 0,  0, 0,  0, 0,  0, 2,  0, 0,  0, 0,  0, 0,
    0, 3,  0, 0,  0, 0,  0, 0,  0, 4,  0, 0,  0, 0,  0, 0,  0, 5,  0, 0,  0, 0,
    0, 0,  0, 6,  0, 0,  0, 0,  0, 0,  0, 7,  0, 0,  0, 0,  0, 0,  0, 8,  0, 0,
    0, 0,  0, 0,  0, 9,  0, 0,  0, 0,  0, 0,  0, 10, 0, 0,  0, 11, 0, 0,  0, 12,
    0, 0,  0, 13, 0, 0,  0, 14, 0, 0,  0, 15, 0, 0,  0, 16, 0, 0,  0, 17, 0, 0,
    0, 18, 0, 0,  0, 19, 0, 0,  0, 20, 0, 0,  0, 21, 0, 0,  0, 22};
const uint8_t HuffDecoderCommon::table19_113_emit_[104] = {
    0x00, 0x3d, 0x00, 0x41, 0x00, 0x5f, 0x00, 0x62, 0x00, 0x64, 0x00, 0x66,
    0x00, 0x67, 0x00, 0x68, 0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x70,
    0x00, 0x72, 0x00, 0x75, 0x00, 0x3a, 0x00, 0x42, 0x00, 0x43, 0x00, 0x44,
    0x00, 0x45, 0x00, 0x46, 0x00, 0x47, 0x00, 0x48, 0x00, 0x49, 0x00, 0x4a,
    0x00, 0x4b, 0x00, 0x4c, 0x00, 0x4d, 0x00, 0x4e, 0x00, 0x4f, 0x00, 0x50,
    0x00, 0x51, 0x00, 0x52, 0x00, 0x53, 0x00, 0x54, 0x00, 0x55, 0x00, 0x56,
    0x00, 0x57, 0x00, 0x59, 0x00, 0x6a, 0x00, 0x6b, 0x00, 0x71, 0x00, 0x76,
    0x00, 0x77, 0x00, 0x78, 0x00, 0x79, 0x00, 0x7a, 0x00, 0x26, 0x00, 0x2a,
    0x00, 0x2c, 0x00, 0x3b, 0x00, 0x58, 0x00, 0x5a};
const uint16_t HuffDecoderCommon::table19_113_inner_[54] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2,
    0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332, 0x0003};
const uint8_t HuffDecoderCommon::table19_113_outer_[128] = {
    0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
    5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,  9,  0,  0,
    0,  10, 0,  0,  0,  11, 0,  0,  0,  12, 0,  0,  0,  13, 0,  0,  0,  14, 0,
    15, 0,  16, 0,  17, 0,  18, 0,  19, 0,  20, 0,  21, 0,  22, 0,  23, 0,  24,
    0,  25, 0,  26, 0,  27, 0,  28, 0,  29, 0,  30, 0,  31, 0,  32, 0,  33, 0,
    34, 0,  35, 0,  36, 0,  37, 0,  38, 0,  39, 0,  40, 0,  41, 0,  42, 0,  43,
    0,  44, 0,  45, 0,  46, 47, 48, 49, 50, 51, 52, 0,  53};
const uint8_t HuffDecoderCommon::table19_115_emit_[104] = {
    0x24, 0x3d, 0x24, 0x41, 0x24, 0x5f, 0x24, 0x62, 0x24, 0x64, 0x24, 0x66,
    0x24, 0x67, 0x24, 0x68, 0x24, 0x6c, 0x24, 0x6d, 0x24, 0x6e, 0x24, 0x70,
    0x24, 0x72, 0x24, 0x75, 0x24, 0x3a, 0x24, 0x42, 0x24, 0x43, 0x24, 0x44,
    0x24, 0x45, 0x24, 0x46, 0x24, 0x47, 0x24, 0x48, 0x24, 0x49, 0x24, 0x4a,
    0x24, 0x4b, 0x24, 0x4c, 0x24, 0x4d, 0x24, 0x4e, 0x24, 0x4f, 0x24, 0x50,
    0x24, 0x51, 0x24, 0x52, 0x24, 0x53, 0x24, 0x54, 0x24, 0x55, 0x24, 0x56,
    0x24, 0x57, 0x24, 0x59, 0x24, 0x6a, 0x24, 0x6b, 0x24, 0x71, 0x24, 0x76,
    0x24, 0x77, 0x24, 0x78, 0x24, 0x79, 0x24, 0x7a, 0x24, 0x26, 0x24, 0x2a,
    0x24, 0x2c, 0x24, 0x3b, 0x24, 0x58, 0x24, 0x5a};
const uint8_t HuffDecoderCommon::table19_117_emit_[104] = {
    0x40, 0x3d, 0x40, 0x41, 0x40, 0x5f, 0x40, 0x62, 0x40, 0x64, 0x40, 0x66,
    0x40, 0x67, 0x40, 0x68, 0x40, 0x6c, 0x40, 0x6d, 0x40, 0x6e, 0x40, 0x70,
    0x40, 0x72, 0x40, 0x75, 0x40, 0x3a, 0x40, 0x42, 0x40, 0x43, 0x40, 0x44,
    0x40, 0x45, 0x40, 0x46, 0x40, 0x47, 0x40, 0x48, 0x40, 0x49, 0x40, 0x4a,
    0x40, 0x4b, 0x40, 0x4c, 0x40, 0x4d, 0x40, 0x4e, 0x40, 0x4f, 0x40, 0x50,
    0x40, 0x51, 0x40, 0x52, 0x40, 0x53, 0x40, 0x54, 0x40, 0x55, 0x40, 0x56,
    0x40, 0x57, 0x40, 0x59, 0x40, 0x6a, 0x40, 0x6b, 0x40, 0x71, 0x40, 0x76,
    0x40, 0x77, 0x40, 0x78, 0x40, 0x79, 0x40, 0x7a, 0x40, 0x26, 0x40, 0x2a,
    0x40, 0x2c, 0x40, 0x3b, 0x40, 0x58, 0x40, 0x5a};
const uint8_t HuffDecoderCommon::table19_119_emit_[104] = {
    0x5b, 0x3d, 0x5b, 0x41, 0x5b, 0x5f, 0x5b, 0x62, 0x5b, 0x64, 0x5b, 0x66,
    0x5b, 0x67, 0x5b, 0x68, 0x5b, 0x6c, 0x5b, 0x6d, 0x5b, 0x6e, 0x5b, 0x70,
    0x5b, 0x72, 0x5b, 0x75, 0x5b, 0x3a, 0x5b, 0x42, 0x5b, 0x43, 0x5b, 0x44,
    0x5b, 0x45, 0x5b, 0x46, 0x5b, 0x47, 0x5b, 0x48, 0x5b, 0x49, 0x5b, 0x4a,
    0x5b, 0x4b, 0x5b, 0x4c, 0x5b, 0x4d, 0x5b, 0x4e, 0x5b, 0x4f, 0x5b, 0x50,
    0x5b, 0x51, 0x5b, 0x52, 0x5b, 0x53, 0x5b, 0x54, 0x5b, 0x55, 0x5b, 0x56,
    0x5b, 0x57, 0x5b, 0x59, 0x5b, 0x6a, 0x5b, 0x6b, 0x5b, 0x71, 0x5b, 0x76,
    0x5b, 0x77, 0x5b, 0x78, 0x5b, 0x79, 0x5b, 0x7a, 0x5b, 0x26, 0x5b, 0x2a,
    0x5b, 0x2c, 0x5b, 0x3b, 0x5b, 0x58, 0x5b, 0x5a};
const uint8_t HuffDecoderCommon::table19_121_emit_[104] = {
    0x5d, 0x3d, 0x5d, 0x41, 0x5d, 0x5f, 0x5d, 0x62, 0x5d, 0x64, 0x5d, 0x66,
    0x5d, 0x67, 0x5d, 0x68, 0x5d, 0x6c, 0x5d, 0x6d, 0x5d, 0x6e, 0x5d, 0x70,
    0x5d, 0x72, 0x5d, 0x75, 0x5d, 0x3a, 0x5d, 0x42, 0x5d, 0x43, 0x5d, 0x44,
    0x5d, 0x45, 0x5d, 0x46, 0x5d, 0x47, 0x5d, 0x48, 0x5d, 0x49, 0x5d, 0x4a,
    0x5d, 0x4b, 0x5d, 0x4c, 0x5d, 0x4d, 0x5d, 0x4e, 0x5d, 0x4f, 0x5d, 0x50,
    0x5d, 0x51, 0x5d, 0x52, 0x5d, 0x53, 0x5d, 0x54, 0x5d, 0x55, 0x5d, 0x56,
    0x5d, 0x57, 0x5d, 0x59, 0x5d, 0x6a, 0x5d, 0x6b, 0x5d, 0x71, 0x5d, 0x76,
    0x5d, 0x77, 0x5d, 0x78, 0x5d, 0x79, 0x5d, 0x7a, 0x5d, 0x26, 0x5d, 0x2a,
    0x5d, 0x2c, 0x5d, 0x3b, 0x5d, 0x58, 0x5d, 0x5a};
const uint8_t HuffDecoderCommon::table19_123_emit_[104] = {
    0x7e, 0x3d, 0x7e, 0x41, 0x7e, 0x5f, 0x7e, 0x62, 0x7e, 0x64, 0x7e, 0x66,
    0x7e, 0x67, 0x7e, 0x68, 0x7e, 0x6c, 0x7e, 0x6d, 0x7e, 0x6e, 0x7e, 0x70,
    0x7e, 0x72, 0x7e, 0x75, 0x7e, 0x3a, 0x7e, 0x42, 0x7e, 0x43, 0x7e, 0x44,
    0x7e, 0x45, 0x7e, 0x46, 0x7e, 0x47, 0x7e, 0x48, 0x7e, 0x49, 0x7e, 0x4a,
    0x7e, 0x4b, 0x7e, 0x4c, 0x7e, 0x4d, 0x7e, 0x4e, 0x7e, 0x4f, 0x7e, 0x50,
    0x7e, 0x51, 0x7e, 0x52, 0x7e, 0x53, 0x7e, 0x54, 0x7e, 0x55, 0x7e, 0x56,
    0x7e, 0x57, 0x7e, 0x59, 0x7e, 0x6a, 0x7e, 0x6b, 0x7e, 0x71, 0x7e, 0x76,
    0x7e, 0x77, 0x7e, 0x78, 0x7e, 0x79, 0x7e, 0x7a, 0x7e, 0x26, 0x7e, 0x2a,
    0x7e, 0x2c, 0x7e, 0x3b, 0x7e, 0x58, 0x7e, 0x5a};
const uint8_t HuffDecoderCommon::table19_124_emit_[136] = {
    0x5e, 0x30, 0x5e, 0x31, 0x5e, 0x32, 0x5e, 0x61, 0x5e, 0x63, 0x5e, 0x65,
    0x5e, 0x69, 0x5e, 0x6f, 0x5e, 0x73, 0x5e, 0x74, 0x5e, 0x20, 0x5e, 0x25,
    0x5e, 0x2d, 0x5e, 0x2e, 0x5e, 0x2f, 0x5e, 0x33, 0x5e, 0x34, 0x5e, 0x35,
    0x5e, 0x36, 0x5e, 0x37, 0x5e, 0x38, 0x5e, 0x39, 0x5e, 0x3d, 0x5e, 0x41,
    0x5e, 0x5f, 0x5e, 0x62, 0x5e, 0x64, 0x5e, 0x66, 0x5e, 0x67, 0x5e, 0x68,
    0x5e, 0x6c, 0x5e, 0x6d, 0x5e, 0x6e, 0x5e, 0x70, 0x5e, 0x72, 0x5e, 0x75,
    0x5e, 0x3a, 0x5e, 0x42, 0x5e, 0x43, 0x5e, 0x44, 0x5e, 0x45, 0x5e, 0x46,
    0x5e, 0x47, 0x5e, 0x48, 0x5e, 0x49, 0x5e, 0x4a, 0x5e, 0x4b, 0x5e, 0x4c,
    0x5e, 0x4d, 0x5e, 0x4e, 0x5e, 0x4f, 0x5e, 0x50, 0x5e, 0x51, 0x5e, 0x52,
    0x5e, 0x53, 0x5e, 0x54, 0x5e, 0x55, 0x5e, 0x56, 0x5e, 0x57, 0x5e, 0x59,
    0x5e, 0x6a, 0x5e, 0x6b, 0x5e, 0x71, 0x5e, 0x76, 0x5e, 0x77, 0x5e, 0x78,
    0x5e, 0x79, 0x5e, 0x7a};
const uint16_t HuffDecoderCommon::table19_124_inner_[70] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2, 0x02b2,
    0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332, 0x0342,
    0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2, 0x03d2,
    0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0003};
const uint8_t HuffDecoderCommon::table19_124_outer_[128] = {
    0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,
    5,  0,  0,  0,  6,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,  9,  0,  0,
    0,  10, 0,  11, 0,  12, 0,  13, 0,  14, 0,  15, 0,  16, 0,  17, 0,  18, 0,
    19, 0,  20, 0,  21, 0,  22, 0,  23, 0,  24, 0,  25, 0,  26, 0,  27, 0,  28,
    0,  29, 0,  30, 0,  31, 0,  32, 0,  33, 0,  34, 0,  35, 0,  36, 37, 38, 39,
    40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
    59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 0,  0,  0,  69};
const uint8_t HuffDecoderCommon::table19_125_emit_[136] = {
    0x7d, 0x30, 0x7d, 0x31, 0x7d, 0x32, 0x7d, 0x61, 0x7d, 0x63, 0x7d, 0x65,
    0x7d, 0x69, 0x7d, 0x6f, 0x7d, 0x73, 0x7d, 0x74, 0x7d, 0x20, 0x7d, 0x25,
    0x7d, 0x2d, 0x7d, 0x2e, 0x7d, 0x2f, 0x7d, 0x33, 0x7d, 0x34, 0x7d, 0x35,
    0x7d, 0x36, 0x7d, 0x37, 0x7d, 0x38, 0x7d, 0x39, 0x7d, 0x3d, 0x7d, 0x41,
    0x7d, 0x5f, 0x7d, 0x62, 0x7d, 0x64, 0x7d, 0x66, 0x7d, 0x67, 0x7d, 0x68,
    0x7d, 0x6c, 0x7d, 0x6d, 0x7d, 0x6e, 0x7d, 0x70, 0x7d, 0x72, 0x7d, 0x75,
    0x7d, 0x3a, 0x7d, 0x42, 0x7d, 0x43, 0x7d, 0x44, 0x7d, 0x45, 0x7d, 0x46,
    0x7d, 0x47, 0x7d, 0x48, 0x7d, 0x49, 0x7d, 0x4a, 0x7d, 0x4b, 0x7d, 0x4c,
    0x7d, 0x4d, 0x7d, 0x4e, 0x7d, 0x4f, 0x7d, 0x50, 0x7d, 0x51, 0x7d, 0x52,
    0x7d, 0x53, 0x7d, 0x54, 0x7d, 0x55, 0x7d, 0x56, 0x7d, 0x57, 0x7d, 0x59,
    0x7d, 0x6a, 0x7d, 0x6b, 0x7d, 0x71, 0x7d, 0x76, 0x7d, 0x77, 0x7d, 0x78,
    0x7d, 0x79, 0x7d, 0x7a};
const uint8_t HuffDecoderCommon::table19_126_emit_[144] = {
    0x3c, 0x30, 0x3c, 0x31, 0x3c, 0x32, 0x3c, 0x61, 0x3c, 0x63, 0x3c, 0x65,
    0x3c, 0x69, 0x3c, 0x6f, 0x3c, 0x73, 0x3c, 0x74, 0x3c, 0x20, 0x3c, 0x25,
    0x3c, 0x2d, 0x3c, 0x2e, 0x3c, 0x2f, 0x3c, 0x33, 0x3c, 0x34, 0x3c, 0x35,
    0x3c, 0x36, 0x3c, 0x37, 0x3c, 0x38, 0x3c, 0x39, 0x3c, 0x3d, 0x3c, 0x41,
    0x3c, 0x5f, 0x3c, 0x62, 0x3c, 0x64, 0x3c, 0x66, 0x3c, 0x67, 0x3c, 0x68,
    0x3c, 0x6c, 0x3c, 0x6d, 0x3c, 0x6e, 0x3c, 0x70, 0x3c, 0x72, 0x3c, 0x75,
    0x60, 0x30, 0x60, 0x31, 0x60, 0x32, 0x60, 0x61, 0x60, 0x63, 0x60, 0x65,
    0x60, 0x69, 0x60, 0x6f, 0x60, 0x73, 0x60, 0x74, 0x60, 0x20, 0x60, 0x25,
    0x60, 0x2d, 0x60, 0x2e, 0x60, 0x2f, 0x60, 0x33, 0x60, 0x34, 0x60, 0x35,
    0x60, 0x36, 0x60, 0x37, 0x60, 0x38, 0x60, 0x39, 0x60, 0x3d, 0x60, 0x41,
    0x60, 0x5f, 0x60, 0x62, 0x60, 0x64, 0x60, 0x66, 0x60, 0x67, 0x60, 0x68,
    0x60, 0x6c, 0x60, 0x6d, 0x60, 0x6e, 0x60, 0x70, 0x60, 0x72, 0x60, 0x75};
const uint16_t HuffDecoderCommon::table19_126_inner_[75] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0003, 0x0242, 0x0252, 0x0262, 0x0272, 0x0282, 0x0292, 0x02a2,
    0x02b2, 0x02c2, 0x02d2, 0x02e2, 0x02f2, 0x0302, 0x0312, 0x0322, 0x0332,
    0x0342, 0x0352, 0x0362, 0x0372, 0x0382, 0x0392, 0x03a2, 0x03b2, 0x03c2,
    0x03d2, 0x03e2, 0x03f2, 0x0402, 0x0412, 0x0422, 0x0432, 0x0442, 0x0452,
    0x0462, 0x0472, 0x0243};
const uint8_t HuffDecoderCommon::table19_127_emit_[96] = {
    0x7b, 0x30, 0x7b, 0x31, 0x7b, 0x32, 0x7b, 0x61, 0x7b, 0x63, 0x7b, 0x65,
    0x7b, 0x69, 0x7b, 0x6f, 0x7b, 0x73, 0x7b, 0x74, 0x7b, 0x20, 0x7b, 0x25,
    0x7b, 0x2d, 0x7b, 0x2e, 0x7b, 0x2f, 0x7b, 0x33, 0x7b, 0x34, 0x7b, 0x35,
    0x7b, 0x36, 0x7b, 0x37, 0x7b, 0x38, 0x7b, 0x39, 0x7b, 0x3d, 0x7b, 0x41,
    0x7b, 0x5f, 0x7b, 0x62, 0x7b, 0x64, 0x7b, 0x66, 0x7b, 0x67, 0x7b, 0x68,
    0x7b, 0x6c, 0x7b, 0x6d, 0x7b, 0x6e, 0x7b, 0x70, 0x7b, 0x72, 0x7b, 0x75,
    0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0, 0xe2, 0x99,
    0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9, 0xe3, 0xe5, 0xe6};
const uint16_t HuffDecoderCommon::table19_127_inner_[63] = {
    0x0000, 0x0002, 0x0012, 0x0022, 0x0032, 0x0042, 0x0052, 0x0062, 0x0072,
    0x0082, 0x0092, 0x00a2, 0x00b2, 0x00c2, 0x00d2, 0x00e2, 0x00f2, 0x0102,
    0x0112, 0x0122, 0x0132, 0x0142, 0x0152, 0x0162, 0x0172, 0x0182, 0x0192,
    0x01a2, 0x01b2, 0x01c2, 0x01d2, 0x01e2, 0x01f2, 0x0202, 0x0212, 0x0222,
    0x0232, 0x0003, 0x0243, 0x024b, 0x0253, 0x025b, 0x0263, 0x026b, 0x0273,
    0x027b, 0x0283, 0x028b, 0x0293, 0x029b, 0x02a3, 0x02ab, 0x02b3, 0x02bb,
    0x02c3, 0x02cb, 0x02d3, 0x02db, 0x02e3, 0x02eb, 0x02f3, 0x02fb, 0x0004};
const uint8_t HuffDecoderCommon::table19_127_outer_[128] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,  0,  9,  0,
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
    29, 30, 31, 32, 33, 34, 35, 36, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  37, 0,  0,  0,  38, 0,  0,  0,  39, 0,  0,  0,  40,
    0,  41, 0,  42, 0,  43, 0,  44, 0,  45, 0,  46, 0,  47, 0,  48, 49, 50, 51,
    52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0,  0,  0,  0,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  62};
const uint8_t* const HuffDecoderCommon::table19_emit_[128] = {
    table19_0_emit_,   table19_1_emit_,   table19_2_emit_,   table19_3_emit_,
    table19_4_emit_,   table19_5_emit_,   table19_6_emit_,   table19_7_emit_,
    table19_8_emit_,   table19_9_emit_,   table19_10_emit_,  table19_11_emit_,
    table18_12_emit_,  table18_13_emit_,  table18_14_emit_,  table19_15_emit_,
    table19_16_emit_,  table19_17_emit_,  table19_18_emit_,  table19_19_emit_,
    table19_20_emit_,  table19_21_emit_,  table19_22_emit_,  table19_23_emit_,
    table19_24_emit_,  table19_25_emit_,  table19_26_emit_,  table19_27_emit_,
    table18_28_emit_,  table18_29_emit_,  table18_30_emit_,  table19_31_emit_,
    table19_32_emit_,  table19_33_emit_,  table19_34_emit_,  table19_35_emit_,
    table19_36_emit_,  table19_37_emit_,  table19_38_emit_,  table19_39_emit_,
    table19_40_emit_,  table19_41_emit_,  table19_42_emit_,  table19_43_emit_,
    table18_44_emit_,  table18_45_emit_,  table18_46_emit_,  table19_47_emit_,
    table19_48_emit_,  table19_49_emit_,  table19_50_emit_,  table19_51_emit_,
    table19_52_emit_,  table19_53_emit_,  table19_54_emit_,  table19_55_emit_,
    table19_56_emit_,  table19_57_emit_,  table19_58_emit_,  table19_59_emit_,
    table18_60_emit_,  table18_61_emit_,  table18_62_emit_,  table19_63_emit_,
    table19_64_emit_,  table19_65_emit_,  table19_66_emit_,  table19_67_emit_,
    table19_68_emit_,  table19_69_emit_,  table19_70_emit_,  table19_71_emit_,
    table19_72_emit_,  table19_73_emit_,  table19_74_emit_,  table19_75_emit_,
    table18_76_emit_,  table18_77_emit_,  table18_78_emit_,  table19_79_emit_,
    table19_80_emit_,  table19_81_emit_,  table19_82_emit_,  table18_83_emit_,
    table18_84_emit_,  table18_85_emit_,  table18_86_emit_,  table19_87_emit_,
    table19_88_emit_,  table19_89_emit_,  table19_90_emit_,  table18_91_emit_,
    table18_92_emit_,  table18_93_emit_,  table18_94_emit_,  table19_95_emit_,
    table19_96_emit_,  table19_97_emit_,  table19_98_emit_,  table18_99_emit_,
    table18_100_emit_, table18_101_emit_, table18_102_emit_, table19_103_emit_,
    table18_104_emit_, table18_105_emit_, table18_106_emit_, table18_107_emit_,
    table18_108_emit_, table18_109_emit_, table18_110_emit_, table18_111_emit_,
    table18_112_emit_, table19_113_emit_, table18_114_emit_, table19_115_emit_,
    table18_116_emit_, table19_117_emit_, table18_118_emit_, table19_119_emit_,
    table18_120_emit_, table19_121_emit_, table18_122_emit_, table19_123_emit_,
    table19_124_emit_, table19_125_emit_, table19_126_emit_, table19_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table19_inner_[128] = {
    table19_0_inner_,   table19_0_inner_,   table19_0_inner_,
    table19_0_inner_,   table19_0_inner_,   table19_5_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_5_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_11_inner_,
    table19_12_inner_,  table19_12_inner_,  table19_12_inner_,
    table19_15_inner_,  table19_0_inner_,   table19_0_inner_,
    table19_0_inner_,   table19_0_inner_,   table19_0_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_5_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_5_inner_,
    table19_11_inner_,  table19_12_inner_,  table19_12_inner_,
    table19_12_inner_,  table19_31_inner_,  table19_0_inner_,
    table19_0_inner_,   table19_0_inner_,   table19_0_inner_,
    table19_0_inner_,   table19_5_inner_,   table19_5_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_5_inner_,
    table19_5_inner_,   table19_11_inner_,  table19_12_inner_,
    table19_12_inner_,  table19_12_inner_,  table19_47_inner_,
    table19_0_inner_,   table19_0_inner_,   table19_0_inner_,
    table19_0_inner_,   table19_0_inner_,   table19_5_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_5_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_11_inner_,
    table19_12_inner_,  table19_12_inner_,  table19_12_inner_,
    table19_63_inner_,  table19_0_inner_,   table19_0_inner_,
    table19_0_inner_,   table19_0_inner_,   table19_0_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_5_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_5_inner_,
    table19_11_inner_,  table19_12_inner_,  table19_12_inner_,
    table19_12_inner_,  table19_79_inner_,  table19_5_inner_,
    table19_5_inner_,   table19_11_inner_,  table19_12_inner_,
    table19_12_inner_,  table19_85_inner_,  table19_86_inner_,
    table19_87_inner_,  table19_5_inner_,   table19_5_inner_,
    table19_11_inner_,  table19_12_inner_,  table19_12_inner_,
    table19_85_inner_,  table19_86_inner_,  table19_87_inner_,
    table19_5_inner_,   table19_5_inner_,   table19_11_inner_,
    table19_12_inner_,  table19_12_inner_,  table19_85_inner_,
    table19_86_inner_,  table19_87_inner_,  table19_12_inner_,
    table19_105_inner_, table19_106_inner_, table19_107_inner_,
    table19_12_inner_,  table19_105_inner_, table19_106_inner_,
    table19_107_inner_, table19_112_inner_, table19_113_inner_,
    table19_112_inner_, table19_113_inner_, table19_112_inner_,
    table19_113_inner_, table19_112_inner_, table19_113_inner_,
    table19_112_inner_, table19_113_inner_, table19_112_inner_,
    table19_113_inner_, table19_124_inner_, table19_124_inner_,
    table19_126_inner_, table19_127_inner_,
};
const uint8_t* const HuffDecoderCommon::table19_outer_[128] = {
    table19_0_outer_,   table19_0_outer_,   table19_0_outer_,
    table19_0_outer_,   table19_0_outer_,   table19_5_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_5_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_11_outer_,
    table19_12_outer_,  table19_12_outer_,  table19_12_outer_,
    table19_15_outer_,  table19_0_outer_,   table19_0_outer_,
    table19_0_outer_,   table19_0_outer_,   table19_0_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_5_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_5_outer_,
    table19_11_outer_,  table19_12_outer_,  table19_12_outer_,
    table19_12_outer_,  table19_15_outer_,  table19_0_outer_,
    table19_0_outer_,   table19_0_outer_,   table19_0_outer_,
    table19_0_outer_,   table19_5_outer_,   table19_5_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_5_outer_,
    table19_5_outer_,   table19_11_outer_,  table19_12_outer_,
    table19_12_outer_,  table19_12_outer_,  table19_15_outer_,
    table19_0_outer_,   table19_0_outer_,   table19_0_outer_,
    table19_0_outer_,   table19_0_outer_,   table19_5_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_5_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_11_outer_,
    table19_12_outer_,  table19_12_outer_,  table19_12_outer_,
    table19_15_outer_,  table19_0_outer_,   table19_0_outer_,
    table19_0_outer_,   table19_0_outer_,   table19_0_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_5_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_5_outer_,
    table19_11_outer_,  table19_12_outer_,  table19_12_outer_,
    table19_12_outer_,  table19_15_outer_,  table19_5_outer_,
    table19_5_outer_,   table19_11_outer_,  table19_12_outer_,
    table19_12_outer_,  table19_85_outer_,  table19_86_outer_,
    table19_87_outer_,  table19_5_outer_,   table19_5_outer_,
    table19_11_outer_,  table19_12_outer_,  table19_12_outer_,
    table19_85_outer_,  table19_86_outer_,  table19_87_outer_,
    table19_5_outer_,   table19_5_outer_,   table19_11_outer_,
    table19_12_outer_,  table19_12_outer_,  table19_85_outer_,
    table19_86_outer_,  table19_87_outer_,  table19_12_outer_,
    table19_105_outer_, table19_106_outer_, table19_107_outer_,
    table19_12_outer_,  table19_105_outer_, table19_106_outer_,
    table19_107_outer_, table19_112_outer_, table19_113_outer_,
    table19_112_outer_, table19_113_outer_, table19_112_outer_,
    table19_113_outer_, table19_112_outer_, table19_113_outer_,
    table19_112_outer_, table19_113_outer_, table19_112_outer_,
    table19_113_outer_, table19_124_outer_, table19_124_outer_,
    table19_0_outer_,   table19_127_outer_,
};
const uint8_t HuffDecoderCommon::table7_0_emit_[1] = {0x21};
const uint16_t HuffDecoderCommon::table7_0_ops_[256] = {
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003, 0x0003,
    0x0003, 0x0003, 0x0003, 0x0003};
const uint8_t HuffDecoderCommon::table7_16_emit_[1] = {0x22};
const uint8_t HuffDecoderCommon::table7_32_emit_[1] = {0x28};
const uint8_t HuffDecoderCommon::table7_48_emit_[1] = {0x29};
const uint8_t HuffDecoderCommon::table7_64_emit_[1] = {0x3f};
const uint8_t HuffDecoderCommon::table7_80_emit_[1] = {0x27};
const uint16_t HuffDecoderCommon::table7_80_ops_[256] = {
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004, 0x0004,
    0x0004, 0x0004, 0x0004, 0x0004};
const uint8_t HuffDecoderCommon::table7_88_emit_[1] = {0x2b};
const uint8_t HuffDecoderCommon::table7_96_emit_[1] = {0x7c};
const uint8_t HuffDecoderCommon::table7_104_emit_[1] = {0x23};
const uint16_t HuffDecoderCommon::table7_104_ops_[256] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table7_108_emit_[1] = {0x3e};
const uint8_t HuffDecoderCommon::table7_112_emit_[1] = {0x00};
const uint16_t HuffDecoderCommon::table7_112_ops_[256] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006};
const uint8_t HuffDecoderCommon::table7_114_emit_[1] = {0x24};
const uint8_t HuffDecoderCommon::table7_116_emit_[1] = {0x40};
const uint8_t HuffDecoderCommon::table7_118_emit_[1] = {0x5b};
const uint8_t HuffDecoderCommon::table7_120_emit_[1] = {0x5d};
const uint8_t HuffDecoderCommon::table7_122_emit_[1] = {0x7e};
const uint8_t HuffDecoderCommon::table7_124_emit_[1] = {0x5e};
const uint16_t HuffDecoderCommon::table7_124_ops_[256] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007};
const uint8_t HuffDecoderCommon::table7_125_emit_[1] = {0x7d};
const uint8_t HuffDecoderCommon::table7_126_emit_[2] = {0x3c, 0x60};
const uint16_t HuffDecoderCommon::table7_126_ops_[256] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208, 0x0208,
    0x0208, 0x0208, 0x0208, 0x0208};
const uint8_t HuffDecoderCommon::table7_127_emit_[51] = {
    0x7b, 0x5c, 0xc3, 0xd0, 0x80, 0x82, 0x83, 0xa2, 0xb8, 0xc2, 0xe0,
    0xe2, 0x99, 0xa1, 0xa7, 0xac, 0xb0, 0xb1, 0xb3, 0xd1, 0xd8, 0xd9,
    0xe3, 0xe5, 0xe6, 0x81, 0x84, 0x85, 0x86, 0x88, 0x92, 0x9a, 0x9c,
    0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad, 0xb2, 0xb5, 0xb9, 0xba, 0xbb,
    0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9};
const uint16_t HuffDecoderCommon::table7_127_ops_[256] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c, 0x020c,
    0x020c, 0x040c, 0x040c, 0x040c, 0x040c, 0x040c, 0x040c, 0x040c, 0x040c,
    0x060c, 0x060c, 0x060c, 0x060c, 0x060c, 0x060c, 0x060c, 0x060c, 0x080d,
    0x080d, 0x080d, 0x080d, 0x0a0d, 0x0a0d, 0x0a0d, 0x0a0d, 0x0c0d, 0x0c0d,
    0x0c0d, 0x0c0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x100d, 0x100d, 0x100d,
    0x100d, 0x120d, 0x120d, 0x120d, 0x120d, 0x140d, 0x140d, 0x140d, 0x140d,
    0x160d, 0x160d, 0x160d, 0x160d, 0x180e, 0x180e, 0x1a0e, 0x1a0e, 0x1c0e,
    0x1c0e, 0x1e0e, 0x1e0e, 0x200e, 0x200e, 0x220e, 0x220e, 0x240e, 0x240e,
    0x260e, 0x260e, 0x280e, 0x280e, 0x2a0e, 0x2a0e, 0x2c0e, 0x2c0e, 0x2e0e,
    0x2e0e, 0x300e, 0x300e, 0x320f, 0x340f, 0x360f, 0x380f, 0x3a0f, 0x3c0f,
    0x3e0f, 0x400f, 0x420f, 0x440f, 0x460f, 0x480f, 0x4a0f, 0x4c0f, 0x4e0f,
    0x500f, 0x520f, 0x540f, 0x560f, 0x580f, 0x5a0f, 0x5c0f, 0x5e0f, 0x600f,
    0x620f, 0x640f, 0x001f, 0x002f, 0x003f, 0x004f, 0x005f, 0x006f, 0x007f,
    0x008f, 0x009f, 0x00af, 0x00bf, 0x00cf, 0x00df, 0x00ef, 0x00ff, 0x010f,
    0x011f, 0x012f, 0x013f, 0x014f};
const uint8_t* const HuffDecoderCommon::table7_emit_[128] = {
    table7_0_emit_,   table7_0_emit_,   table7_0_emit_,   table7_0_emit_,
    table7_0_emit_,   table7_0_emit_,   table7_0_emit_,   table7_0_emit_,
    table7_0_emit_,   table7_0_emit_,   table7_0_emit_,   table7_0_emit_,
    table7_0_emit_,   table7_0_emit_,   table7_0_emit_,   table7_0_emit_,
    table7_16_emit_,  table7_16_emit_,  table7_16_emit_,  table7_16_emit_,
    table7_16_emit_,  table7_16_emit_,  table7_16_emit_,  table7_16_emit_,
    table7_16_emit_,  table7_16_emit_,  table7_16_emit_,  table7_16_emit_,
    table7_16_emit_,  table7_16_emit_,  table7_16_emit_,  table7_16_emit_,
    table7_32_emit_,  table7_32_emit_,  table7_32_emit_,  table7_32_emit_,
    table7_32_emit_,  table7_32_emit_,  table7_32_emit_,  table7_32_emit_,
    table7_32_emit_,  table7_32_emit_,  table7_32_emit_,  table7_32_emit_,
    table7_32_emit_,  table7_32_emit_,  table7_32_emit_,  table7_32_emit_,
    table7_48_emit_,  table7_48_emit_,  table7_48_emit_,  table7_48_emit_,
    table7_48_emit_,  table7_48_emit_,  table7_48_emit_,  table7_48_emit_,
    table7_48_emit_,  table7_48_emit_,  table7_48_emit_,  table7_48_emit_,
    table7_48_emit_,  table7_48_emit_,  table7_48_emit_,  table7_48_emit_,
    table7_64_emit_,  table7_64_emit_,  table7_64_emit_,  table7_64_emit_,
    table7_64_emit_,  table7_64_emit_,  table7_64_emit_,  table7_64_emit_,
    table7_64_emit_,  table7_64_emit_,  table7_64_emit_,  table7_64_emit_,
    table7_64_emit_,  table7_64_emit_,  table7_64_emit_,  table7_64_emit_,
    table7_80_emit_,  table7_80_emit_,  table7_80_emit_,  table7_80_emit_,
    table7_80_emit_,  table7_80_emit_,  table7_80_emit_,  table7_80_emit_,
    table7_88_emit_,  table7_88_emit_,  table7_88_emit_,  table7_88_emit_,
    table7_88_emit_,  table7_88_emit_,  table7_88_emit_,  table7_88_emit_,
    table7_96_emit_,  table7_96_emit_,  table7_96_emit_,  table7_96_emit_,
    table7_96_emit_,  table7_96_emit_,  table7_96_emit_,  table7_96_emit_,
    table7_104_emit_, table7_104_emit_, table7_104_emit_, table7_104_emit_,
    table7_108_emit_, table7_108_emit_, table7_108_emit_, table7_108_emit_,
    table7_112_emit_, table7_112_emit_, table7_114_emit_, table7_114_emit_,
    table7_116_emit_, table7_116_emit_, table7_118_emit_, table7_118_emit_,
    table7_120_emit_, table7_120_emit_, table7_122_emit_, table7_122_emit_,
    table7_124_emit_, table7_125_emit_, table7_126_emit_, table7_127_emit_,
};
const uint16_t* const HuffDecoderCommon::table7_ops_[128] = {
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_0_ops_,   table7_0_ops_,   table7_0_ops_,   table7_0_ops_,
    table7_80_ops_,  table7_80_ops_,  table7_80_ops_,  table7_80_ops_,
    table7_80_ops_,  table7_80_ops_,  table7_80_ops_,  table7_80_ops_,
    table7_80_ops_,  table7_80_ops_,  table7_80_ops_,  table7_80_ops_,
    table7_80_ops_,  table7_80_ops_,  table7_80_ops_,  table7_80_ops_,
    table7_80_ops_,  table7_80_ops_,  table7_80_ops_,  table7_80_ops_,
    table7_80_ops_,  table7_80_ops_,  table7_80_ops_,  table7_80_ops_,
    table7_104_ops_, table7_104_ops_, table7_104_ops_, table7_104_ops_,
    table7_104_ops_, table7_104_ops_, table7_104_ops_, table7_104_ops_,
    table7_112_ops_, table7_112_ops_, table7_112_ops_, table7_112_ops_,
    table7_112_ops_, table7_112_ops_, table7_112_ops_, table7_112_ops_,
    table7_112_ops_, table7_112_ops_, table7_112_ops_, table7_112_ops_,
    table7_124_ops_, table7_124_ops_, table7_126_ops_, table7_127_ops_,
};
const uint8_t HuffDecoderCommon::table37_0_emit_[15] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5,
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint8_t HuffDecoderCommon::table37_0_inner_[16] = {
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e,
    0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x01};
const uint8_t HuffDecoderCommon::table36_0_emit_[17] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda,
    0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc};
const uint8_t HuffDecoderCommon::table36_0_ops_[32] = {
    0x04, 0x04, 0x0c, 0x0c, 0x14, 0x14, 0x1c, 0x1c, 0x24, 0x24, 0x2c,
    0x2c, 0x34, 0x34, 0x3c, 0x3c, 0x44, 0x44, 0x4c, 0x4c, 0x54, 0x54,
    0x5c, 0x5c, 0x64, 0x64, 0x6c, 0x6c, 0x74, 0x74, 0x7d, 0x85};
const uint8_t HuffDecoderCommon::table40_0_emit_[6] = {0xec, 0xed, 0xc7,
                                                       0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table40_0_inner_[6] = {0x02, 0x06, 0x0b,
                                                        0x0f, 0x13, 0x17};
const uint8_t HuffDecoderCommon::table43_0_emit_[17] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4, 0xf5,
    0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint8_t HuffDecoderCommon::table43_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x28,
    0x2c, 0x30, 0x34, 0x38, 0x3c, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table44_0_emit_[46] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0b, 0x0c, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18,
    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint8_t HuffDecoderCommon::table44_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00,
    0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69,
    0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95,
    0x99, 0x9d, 0xa1, 0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x02};
const uint8_t HuffDecoderCommon::table45_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x39,
    0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41, 0x00, 0x45, 0x00, 0x49,
    0x00, 0x4d, 0x00, 0x51, 0x00, 0x55, 0x00, 0x59, 0x00, 0x5d, 0x00, 0x61,
    0x00, 0x65, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x71, 0x00, 0x75, 0x00, 0x79,
    0x00, 0x7d, 0x00, 0x81, 0x00, 0x85, 0x00, 0x89, 0x00, 0x8d, 0x00, 0x91,
    0x00, 0x95, 0x00, 0x99, 0x00, 0x9d, 0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9,
    0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table42_0_emit_[4] = {0xd3, 0xd4, 0xd6, 0xdd};
const uint16_t HuffDecoderCommon::table42_0_ops_[32] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
    0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
    0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065};
const uint8_t HuffDecoderCommon::table42_1_emit_[4] = {0xde, 0xdf, 0xf1, 0xf4};
const uint8_t HuffDecoderCommon::table42_2_emit_[4] = {0xf5, 0xf6, 0xf7, 0xf8};
const uint8_t HuffDecoderCommon::table42_3_emit_[4] = {0xfa, 0xfb, 0xfc, 0xfd};
const uint8_t HuffDecoderCommon::table42_4_emit_[7] = {0xfe, 0x02, 0x03, 0x04,
                                                       0x05, 0x06, 0x07};
const uint16_t HuffDecoderCommon::table42_4_ops_[32] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0046, 0x0046, 0x0046, 0x0046,
    0x0066, 0x0066, 0x0066, 0x0066, 0x0086, 0x0086, 0x0086, 0x0086,
    0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00c6, 0x00c6, 0x00c6, 0x00c6};
const uint8_t HuffDecoderCommon::table42_5_emit_[8] = {0x08, 0x0b, 0x0c, 0x0e,
                                                       0x0f, 0x10, 0x11, 0x12};
const uint16_t HuffDecoderCommon::table42_5_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0046, 0x0046, 0x0046, 0x0046, 0x0066, 0x0066, 0x0066, 0x0066,
    0x0086, 0x0086, 0x0086, 0x0086, 0x00a6, 0x00a6, 0x00a6, 0x00a6,
    0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00e6, 0x00e6, 0x00e6, 0x00e6};
const uint8_t HuffDecoderCommon::table42_6_emit_[8] = {0x13, 0x14, 0x15, 0x17,
                                                       0x18, 0x19, 0x1a, 0x1b};
const uint8_t HuffDecoderCommon::table42_7_emit_[10] = {
    0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint16_t HuffDecoderCommon::table42_7_ops_[32] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0046, 0x0046, 0x0046, 0x0046, 0x0066, 0x0066, 0x0066, 0x0066,
    0x0086, 0x0086, 0x0086, 0x0086, 0x00a6, 0x00a6, 0x00a6, 0x00a6,
    0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00e8, 0x0108, 0x0128, 0x0018};
const uint8_t* const HuffDecoderCommon::table42_emit_[8] = {
    table42_0_emit_, table42_1_emit_, table42_2_emit_, table42_3_emit_,
    table42_4_emit_, table42_5_emit_, table42_6_emit_, table42_7_emit_,
};
const uint16_t* const HuffDecoderCommon::table42_ops_[8] = {
    table42_0_ops_, table42_0_ops_, table42_0_ops_, table42_0_ops_,
    table42_4_ops_, table42_5_ops_, table42_5_ops_, table42_7_ops_,
};
}  // namespace geometry_7_15_8
}  // namespace grpc_core
