// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_9_5_16_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_9_5_16_H
#include <cstddef>
#include <cstdint>

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_9_5_16 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) {
    return table4_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit4(size_t i, size_t emit) {
    return table4_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp5(size_t i) {
    return table5_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit5(size_t i, size_t emit) {
    return table5_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit1(size_t i, size_t emit) {
    return table1_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp6(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit6(size_t, size_t emit) { return emit + 33; }
  static inline uint64_t GetOp7(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit7(size_t, size_t emit) { return emit + 40; }
  static inline uint64_t GetOp9(size_t i) { return i; }
  static inline uint64_t GetEmit9(size_t, size_t emit) {
    return ((void)emit, 63);
  }
  static inline uint64_t GetOp8(size_t i) {
    return ((i < 1 ? (((void)i, 0)) : ((i - 1))) < 1
                ? (((void)(i < 1 ? (((void)i, 0)) : ((i - 1))), 1))
                : (((i < 1 ? (((void)i, 0)) : ((i - 1))) - 1) ? 10 : 6));
  }
  static inline uint64_t GetEmit8(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 63)) : ((emit - 1) ? 43 : 39));
  }
  static inline uint64_t GetOp11(size_t i) {
    return (i < 2 ? (i) : ((i - 2) + 1));
  }
  static inline uint64_t GetEmit11(size_t, size_t emit) {
    return ((void)emit, 124);
  }
  static inline uint64_t GetOp12(size_t i) {
    return table12_0_inner_[table12_0_outer_[i]];
  }
  static inline uint64_t GetEmit12(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 124)) : ((emit - 1) ? 62 : 35));
  }
  static inline uint64_t GetOp13(size_t i) {
    return table13_0_inner_[table13_0_outer_[i]];
  }
  static inline uint64_t GetEmit13(size_t, size_t emit) {
    return table13_0_emit_[emit];
  }
  static inline uint64_t GetOp10(size_t i) {
    return table10_0_inner_[table10_0_outer_[i]];
  }
  static inline uint64_t GetEmit10(size_t, size_t emit) {
    return table10_0_emit_[emit];
  }
  static inline uint64_t GetOp14(size_t i) { return i ? 3 : 1; }
  static inline uint64_t GetEmit14(size_t, size_t emit) {
    return emit ? 96 : 60;
  }
  static inline uint64_t GetOp16(size_t i) { return i; }
  static inline uint64_t GetEmit16(size_t, size_t emit) {
    return ((void)emit, 123);
  }
  static inline uint64_t GetOp17(size_t i) {
    return (i < 2 ? (i) : ((i - 2) ? 2 : 0));
  }
  static inline uint64_t GetEmit17(size_t, size_t emit) {
    return ((void)emit, 123);
  }
  static inline uint64_t GetOp18(size_t i) { return table18_0_outer_[i]; }
  static inline uint64_t GetEmit18(size_t, size_t emit) {
    return ((void)emit, 123);
  }
  static inline uint64_t GetOp19(size_t i) { return table19_0_outer_[i]; }
  static inline uint64_t GetEmit19(size_t, size_t emit) {
    return ((void)emit, 123);
  }
  static inline uint64_t GetOp20(size_t i) { return table20_0_ops_[i]; }
  static inline uint64_t GetEmit20(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 92 : 123) : ((emit - 2) ? 208 : 195));
  }
  static inline uint64_t GetOp21(size_t i) { return table21_0_ops_[i]; }
  static inline uint64_t GetEmit21(size_t, size_t emit) {
    return table21_0_emit_[emit];
  }
  static inline uint64_t GetOp22(size_t i) {
    return table22_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit22(size_t i, size_t emit) {
    return table22_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp23(size_t i) {
    return table23_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit23(size_t i, size_t emit) {
    return table23_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp24(size_t i) {
    return table24_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit24(size_t i, size_t emit) {
    return table24_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp25(size_t i) {
    return table25_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit25(size_t i, size_t emit) {
    return table25_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp26(size_t i) {
    return table26_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit26(size_t i, size_t emit) {
    return table26_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp27(size_t i) {
    return table27_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit27(size_t i, size_t emit) {
    return table27_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp28(size_t i) {
    return table28_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit28(size_t i, size_t emit) {
    return table28_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp29(size_t i) {
    return table29_inner_[i >> 7][table29_outer_[i >> 7][i & 0x7f]];
  }
  static inline uint64_t GetEmit29(size_t i, size_t emit) {
    return table29_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp30(size_t i) {
    return table30_inner_[i >> 8][table30_outer_[i >> 8][i & 0xff]];
  }
  static inline uint64_t GetEmit30(size_t i, size_t emit) {
    return table30_emit_[i >> 8][emit];
  }
  static inline uint64_t GetOp15(size_t i) {
    return table15_ops_[i >> 9][i & 0x1ff];
  }
  static inline uint64_t GetEmit15(size_t i, size_t emit) {
    return table15_emit_[i >> 9][emit];
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table4_0_emit_[22];
  static const uint8_t table4_0_ops_[64];
  static const uint8_t table4_1_emit_[46];
  static const uint8_t table4_1_ops_[64];
  static const uint8_t* const table4_emit_[2];
  static const uint8_t* const table4_ops_[2];
  static const uint8_t table5_0_ops_[128];
  static const uint8_t table5_1_emit_[52];
  static const uint8_t table5_1_ops_[128];
  static const uint8_t* const table5_emit_[2];
  static const uint8_t* const table5_ops_[2];
  static const uint8_t table1_0_emit_[2];
  static const uint16_t table1_0_ops_[32];
  static const uint8_t table1_1_emit_[2];
  static const uint8_t table1_2_emit_[2];
  static const uint8_t table1_3_emit_[2];
  static const uint8_t table1_4_emit_[2];
  static const uint8_t table1_5_emit_[4];
  static const uint16_t table1_5_ops_[32];
  static const uint8_t table1_6_emit_[4];
  static const uint8_t table1_7_emit_[4];
  static const uint8_t table1_8_emit_[4];
  static const uint8_t table1_9_emit_[4];
  static const uint8_t table1_10_emit_[4];
  static const uint8_t table1_11_emit_[6];
  static const uint16_t table1_11_ops_[32];
  static const uint8_t table1_12_emit_[8];
  static const uint16_t table1_12_ops_[32];
  static const uint8_t table1_13_emit_[8];
  static const uint8_t table1_14_emit_[8];
  static const uint8_t table1_15_emit_[10];
  static const uint16_t table1_15_ops_[32];
  static const uint8_t* const table1_emit_[16];
  static const uint16_t* const table1_ops_[16];
  static const uint8_t table12_0_inner_[5];
  static const uint8_t table12_0_outer_[8];
  static const uint8_t table13_0_emit_[9];
  static const uint8_t table13_0_inner_[11];
  static const uint8_t table13_0_outer_[16];
  static const uint8_t table10_0_emit_[11];
  static const uint16_t table10_0_inner_[13];
  static const uint8_t table10_0_outer_[32];
  static const uint8_t table18_0_outer_[8];
  static const uint8_t table19_0_outer_[16];
  static const uint8_t table20_0_ops_[32];
  static const uint8_t table21_0_emit_[31];
  static const uint8_t table21_0_ops_[64];
  static const uint8_t table22_0_emit_[44];
  static const uint8_t table22_0_ops_[32];
  static const uint8_t table22_1_emit_[28];
  static const uint8_t table22_1_ops_[32];
  static const uint8_t table22_2_emit_[15];
  static const uint8_t table22_2_ops_[32];
  static const uint8_t table22_3_emit_[9];
  static const uint8_t table22_3_ops_[32];
  static const uint8_t* const table22_emit_[4];
  static const uint8_t* const table22_ops_[4];
  static const uint16_t table23_0_ops_[64];
  static const uint8_t table23_1_emit_[92];
  static const uint16_t table23_1_ops_[64];
  static const uint16_t table23_2_ops_[64];
  static const uint8_t table23_3_emit_[35];
  static const uint16_t table23_3_ops_[64];
  static const uint8_t* const table23_emit_[4];
  static const uint16_t* const table23_ops_[4];
  static const uint16_t table24_0_ops_[128];
  static const uint8_t table24_1_emit_[104];
  static const uint16_t table24_1_ops_[128];
  static const uint16_t table24_2_ops_[128];
  static const uint8_t table24_3_emit_[64];
  static const uint16_t table24_3_ops_[128];
  static const uint8_t* const table24_emit_[4];
  static const uint16_t* const table24_ops_[4];
  static const uint8_t table25_0_emit_[4];
  static const uint8_t table25_0_ops_[32];
  static const uint8_t table25_1_emit_[4];
  static const uint8_t table25_2_emit_[4];
  static const uint8_t table25_3_emit_[4];
  static const uint8_t table25_4_emit_[4];
  static const uint8_t table25_5_emit_[8];
  static const uint8_t table25_5_ops_[32];
  static const uint8_t table25_6_emit_[8];
  static const uint8_t table25_7_emit_[8];
  static const uint8_t table25_8_emit_[8];
  static const uint8_t table25_9_emit_[8];
  static const uint8_t table25_10_emit_[8];
  static const uint8_t table25_11_emit_[12];
  static const uint8_t table25_11_ops_[32];
  static const uint8_t table25_12_emit_[16];
  static const uint8_t table25_12_ops_[32];
  static const uint8_t table25_13_emit_[16];
  static const uint8_t table25_14_emit_[16];
  static const uint8_t table25_15_emit_[20];
  static const uint8_t table25_15_ops_[32];
  static const uint8_t table25_16_emit_[20];
  static const uint8_t table25_16_ops_[32];
  static const uint8_t table25_17_emit_[20];
  static const uint8_t table25_18_emit_[20];
  static const uint8_t table25_19_emit_[2];
  static const uint8_t table25_19_ops_[32];
  static const uint8_t table25_20_emit_[2];
  static const uint8_t table25_21_emit_[2];
  static const uint8_t table25_22_emit_[2];
  static const uint8_t table25_23_emit_[4];
  static const uint8_t table25_23_ops_[32];
  static const uint8_t table25_24_emit_[4];
  static const uint8_t table25_25_emit_[4];
  static const uint8_t table25_26_emit_[7];
  static const uint8_t table25_26_ops_[32];
  static const uint8_t table25_27_emit_[8];
  static const uint8_t table25_27_ops_[32];
  static const uint8_t table25_28_emit_[8];
  static const uint8_t table25_29_emit_[12];
  static const uint8_t table25_29_ops_[32];
  static const uint8_t table25_30_emit_[16];
  static const uint8_t table25_30_ops_[32];
  static const uint8_t table25_31_emit_[17];
  static const uint8_t table25_31_ops_[32];
  static const uint8_t* const table25_emit_[32];
  static const uint8_t* const table25_ops_[32];
  static const uint8_t table26_0_emit_[60];
  static const uint16_t table26_0_ops_[64];
  static const uint8_t table26_1_emit_[60];
  static const uint8_t table26_2_emit_[60];
  static const uint8_t table26_3_emit_[60];
  static const uint8_t table26_4_emit_[60];
  static const uint16_t table26_5_ops_[64];
  static const uint16_t table26_11_ops_[64];
  static const uint16_t table26_12_ops_[64];
  static const uint8_t table26_15_emit_[30];
  static const uint16_t table26_15_ops_[64];
  static const uint8_t table26_16_emit_[72];
  static const uint16_t table26_16_ops_[64];
  static const uint8_t table26_17_emit_[72];
  static const uint8_t table26_18_emit_[72];
  static const uint8_t table26_19_emit_[40];
  static const uint16_t table26_19_ops_[64];
  static const uint8_t table26_20_emit_[40];
  static const uint8_t table26_21_emit_[40];
  static const uint8_t table26_22_emit_[40];
  static const uint16_t table26_23_ops_[64];
  static const uint16_t table26_26_ops_[64];
  static const uint16_t table26_27_ops_[64];
  static const uint16_t table26_29_ops_[64];
  static const uint16_t table26_30_ops_[64];
  static const uint8_t table26_31_emit_[21];
  static const uint16_t table26_31_ops_[64];
  static const uint8_t* const table26_emit_[32];
  static const uint16_t* const table26_ops_[32];
  static const uint8_t table27_0_emit_[108];
  static const uint16_t table27_0_ops_[64];
  static const uint8_t table27_1_emit_[108];
  static const uint8_t table27_2_emit_[108];
  static const uint8_t table27_3_emit_[108];
  static const uint8_t table27_4_emit_[108];
  static const uint8_t table27_5_emit_[108];
  static const uint8_t table27_6_emit_[108];
  static const uint8_t table27_7_emit_[108];
  static const uint8_t table27_8_emit_[108];
  static const uint8_t table27_9_emit_[108];
  static const uint8_t table27_10_emit_[60];
  static const uint16_t table27_10_ops_[64];
  static const uint8_t table27_11_emit_[60];
  static const uint8_t table27_12_emit_[60];
  static const uint8_t table27_13_emit_[60];
  static const uint8_t table27_14_emit_[60];
  static const uint8_t table27_15_emit_[60];
  static const uint8_t table27_16_emit_[60];
  static const uint8_t table27_17_emit_[60];
  static const uint8_t table27_18_emit_[60];
  static const uint8_t table27_19_emit_[60];
  static const uint8_t table27_20_emit_[60];
  static const uint8_t table27_21_emit_[60];
  static const uint8_t table27_22_emit_[60];
  static const uint8_t table27_23_emit_[8];
  static const uint16_t table27_23_ops_[64];
  static const uint8_t table27_24_emit_[8];
  static const uint8_t table27_25_emit_[8];
  static const uint8_t table27_26_emit_[8];
  static const uint8_t table27_27_emit_[8];
  static const uint8_t table27_28_emit_[8];
  static const uint8_t table27_29_emit_[8];
  static const uint8_t table27_30_emit_[8];
  static const uint8_t table27_31_emit_[28];
  static const uint16_t table27_31_ops_[64];
  static const uint8_t table27_32_emit_[44];
  static const uint16_t table27_32_ops_[64];
  static const uint8_t table27_33_emit_[92];
  static const uint16_t table27_33_ops_[64];
  static const uint8_t table27_34_emit_[44];
  static const uint8_t table27_35_emit_[92];
  static const uint8_t table27_36_emit_[44];
  static const uint8_t table27_37_emit_[92];
  static const uint8_t table27_38_emit_[72];
  static const uint16_t table27_38_ops_[64];
  static const uint8_t table27_39_emit_[72];
  static const uint8_t table27_40_emit_[72];
  static const uint8_t table27_41_emit_[72];
  static const uint8_t table27_42_emit_[72];
  static const uint8_t table27_43_emit_[72];
  static const uint8_t table27_44_emit_[72];
  static const uint8_t table27_45_emit_[72];
  static const uint8_t table27_46_emit_[40];
  static const uint16_t table27_46_ops_[64];
  static const uint8_t table27_47_emit_[40];
  static const uint8_t table27_48_emit_[40];
  static const uint8_t table27_49_emit_[40];
  static const uint8_t table27_50_emit_[40];
  static const uint8_t table27_51_emit_[40];
  static const uint8_t table27_52_emit_[22];
  static const uint16_t table27_52_ops_[64];
  static const uint8_t table27_53_emit_[4];
  static const uint16_t table27_53_ops_[64];
  static const uint8_t table27_54_emit_[4];
  static const uint8_t table27_55_emit_[4];
  static const uint8_t table27_56_emit_[4];
  static const uint8_t table27_57_emit_[4];
  static const uint8_t table27_58_emit_[4];
  static const uint8_t table27_59_emit_[8];
  static const uint16_t table27_59_ops_[64];
  static const uint8_t table27_60_emit_[8];
  static const uint8_t table27_61_emit_[8];
  static const uint8_t table27_62_emit_[11];
  static const uint16_t table27_62_ops_[64];
  static const uint8_t table27_63_emit_[25];
  static const uint16_t table27_63_ops_[64];
  static const uint8_t* const table27_emit_[64];
  static const uint16_t* const table27_ops_[64];
  static const uint8_t table28_0_emit_[204];
  static const uint16_t table28_0_ops_[128];
  static const uint8_t table28_1_emit_[204];
  static const uint8_t table28_2_emit_[204];
  static const uint8_t table28_3_emit_[204];
  static const uint8_t table28_4_emit_[204];
  static const uint8_t table28_5_emit_[204];
  static const uint8_t table28_6_emit_[204];
  static const uint8_t table28_7_emit_[204];
  static const uint8_t table28_8_emit_[204];
  static const uint8_t table28_9_emit_[204];
  static const uint8_t table28_10_emit_[216];
  static const uint16_t table28_10_ops_[128];
  static const uint8_t table28_11_emit_[216];
  static const uint8_t table28_12_emit_[216];
  static const uint8_t table28_13_emit_[216];
  static const uint8_t table28_14_emit_[216];
  static const uint8_t table28_15_emit_[216];
  static const uint8_t table28_16_emit_[216];
  static const uint8_t table28_17_emit_[216];
  static const uint8_t table28_18_emit_[216];
  static const uint8_t table28_19_emit_[216];
  static const uint8_t table28_20_emit_[216];
  static const uint8_t table28_21_emit_[216];
  static const uint8_t table28_22_emit_[216];
  static const uint8_t table28_23_emit_[120];
  static const uint16_t table28_23_ops_[128];
  static const uint8_t table28_24_emit_[120];
  static const uint8_t table28_25_emit_[120];
  static const uint8_t table28_26_emit_[120];
  static const uint8_t table28_27_emit_[120];
  static const uint8_t table28_28_emit_[120];
  static const uint8_t table28_29_emit_[120];
  static const uint8_t table28_30_emit_[120];
  static const uint8_t table28_31_emit_[32];
  static const uint16_t table28_31_ops_[128];
  static const uint16_t table28_32_ops_[128];
  static const uint8_t table28_33_emit_[104];
  static const uint16_t table28_33_ops_[128];
  static const uint8_t table28_35_emit_[104];
  static const uint8_t table28_37_emit_[104];
  static const uint8_t table28_38_emit_[136];
  static const uint16_t table28_38_ops_[128];
  static const uint8_t table28_39_emit_[136];
  static const uint8_t table28_40_emit_[136];
  static const uint8_t table28_41_emit_[136];
  static const uint8_t table28_42_emit_[136];
  static const uint8_t table28_43_emit_[136];
  static const uint8_t table28_44_emit_[136];
  static const uint8_t table28_45_emit_[136];
  static const uint8_t table28_46_emit_[144];
  static const uint16_t table28_46_ops_[128];
  static const uint8_t table28_47_emit_[144];
  static const uint8_t table28_48_emit_[144];
  static const uint8_t table28_49_emit_[144];
  static const uint8_t table28_50_emit_[144];
  static const uint8_t table28_51_emit_[144];
  static const uint8_t table28_52_emit_[112];
  static const uint16_t table28_52_ops_[128];
  static const uint8_t table28_53_emit_[80];
  static const uint16_t table28_53_ops_[128];
  static const uint8_t table28_54_emit_[80];
  static const uint8_t table28_55_emit_[80];
  static const uint8_t table28_56_emit_[80];
  static const uint8_t table28_57_emit_[80];
  static const uint8_t table28_58_emit_[80];
  static const uint16_t table28_59_ops_[128];
  static const uint16_t table28_62_ops_[128];
  static const uint8_t table28_63_emit_[44];
  static const uint16_t table28_63_ops_[128];
  static const uint8_t* const table28_emit_[64];
  static const uint16_t* const table28_ops_[64];
  static const uint8_t table29_0_emit_[66];
  static const uint16_t table29_0_inner_[23];
  static const uint8_t table29_0_outer_[128];
  static const uint8_t table29_1_emit_[156];
  static const uint16_t table29_1_inner_[54];
  static const uint8_t table29_1_outer_[128];
  static const uint8_t table29_2_emit_[66];
  static const uint8_t table29_3_emit_[156];
  static const uint8_t table29_4_emit_[66];
  static const uint8_t table29_5_emit_[156];
  static const uint8_t table29_6_emit_[66];
  static const uint8_t table29_7_emit_[156];
  static const uint8_t table29_8_emit_[66];
  static const uint8_t table29_9_emit_[156];
  static const uint8_t table29_10_emit_[66];
  static const uint8_t table29_11_emit_[156];
  static const uint8_t table29_12_emit_[66];
  static const uint8_t table29_13_emit_[156];
  static const uint8_t table29_14_emit_[66];
  static const uint8_t table29_15_emit_[156];
  static const uint8_t table29_16_emit_[66];
  static const uint8_t table29_17_emit_[156];
  static const uint8_t table29_18_emit_[66];
  static const uint8_t table29_19_emit_[156];
  static const uint8_t table29_20_emit_[204];
  static const uint16_t table29_20_inner_[70];
  static const uint8_t table29_20_outer_[128];
  static const uint8_t table29_21_emit_[204];
  static const uint8_t table29_22_emit_[204];
  static const uint8_t table29_23_emit_[204];
  static const uint8_t table29_24_emit_[204];
  static const uint8_t table29_25_emit_[204];
  static const uint8_t table29_26_emit_[204];
  static const uint8_t table29_27_emit_[204];
  static const uint8_t table29_28_emit_[204];
  static const uint8_t table29_29_emit_[204];
  static const uint8_t table29_30_emit_[204];
  static const uint8_t table29_31_emit_[204];
  static const uint8_t table29_32_emit_[204];
  static const uint8_t table29_33_emit_[204];
  static const uint8_t table29_34_emit_[204];
  static const uint8_t table29_35_emit_[204];
  static const uint8_t table29_36_emit_[204];
  static const uint8_t table29_37_emit_[204];
  static const uint8_t table29_38_emit_[204];
  static const uint8_t table29_39_emit_[204];
  static const uint8_t table29_40_emit_[204];
  static const uint8_t table29_41_emit_[204];
  static const uint8_t table29_42_emit_[204];
  static const uint8_t table29_43_emit_[204];
  static const uint8_t table29_44_emit_[204];
  static const uint8_t table29_45_emit_[204];
  static const uint8_t table29_46_emit_[216];
  static const uint16_t table29_46_inner_[75];
  static const uint8_t table29_46_outer_[128];
  static const uint8_t table29_47_emit_[216];
  static const uint8_t table29_48_emit_[216];
  static const uint8_t table29_49_emit_[216];
  static const uint8_t table29_50_emit_[216];
  static const uint8_t table29_51_emit_[216];
  static const uint8_t table29_52_emit_[216];
  static const uint8_t table29_53_emit_[216];
  static const uint8_t table29_54_emit_[216];
  static const uint8_t table29_55_emit_[216];
  static const uint8_t table29_56_emit_[216];
  static const uint8_t table29_57_emit_[216];
  static const uint8_t table29_58_emit_[216];
  static const uint8_t table29_59_emit_[216];
  static const uint8_t table29_60_emit_[216];
  static const uint8_t table29_61_emit_[216];
  static const uint8_t table29_62_emit_[120];
  static const uint16_t table29_62_inner_[45];
  static const uint8_t table29_62_outer_[128];
  static const uint8_t table29_63_emit_[92];
  static const uint16_t table29_63_inner_[40];
  static const uint8_t table29_63_outer_[128];
  static const uint8_t table29_64_emit_[16];
  static const uint16_t table29_64_inner_[9];
  static const uint8_t table29_64_outer_[128];
  static const uint8_t table29_65_emit_[28];
  static const uint16_t table29_65_inner_[15];
  static const uint8_t table29_65_outer_[128];
  static const uint8_t table29_66_emit_[36];
  static const uint16_t table29_66_inner_[19];
  static const uint8_t table29_66_outer_[128];
  static const uint8_t table29_67_emit_[68];
  static const uint16_t table29_67_inner_[36];
  static const uint8_t table29_67_outer_[128];
  static const uint8_t table29_68_emit_[16];
  static const uint8_t table29_69_emit_[28];
  static const uint8_t table29_70_emit_[36];
  static const uint8_t table29_71_emit_[68];
  static const uint8_t table29_72_emit_[16];
  static const uint8_t table29_73_emit_[28];
  static const uint8_t table29_74_emit_[36];
  static const uint8_t table29_75_emit_[68];
  static const uint8_t table29_76_emit_[44];
  static const uint16_t table29_76_inner_[23];
  static const uint8_t table29_77_emit_[104];
  static const uint16_t table29_77_inner_[54];
  static const uint8_t table29_78_emit_[44];
  static const uint8_t table29_79_emit_[104];
  static const uint8_t table29_80_emit_[44];
  static const uint8_t table29_81_emit_[104];
  static const uint8_t table29_82_emit_[44];
  static const uint8_t table29_83_emit_[104];
  static const uint8_t table29_84_emit_[44];
  static const uint8_t table29_85_emit_[104];
  static const uint8_t table29_86_emit_[44];
  static const uint8_t table29_87_emit_[104];
  static const uint8_t table29_88_emit_[44];
  static const uint8_t table29_89_emit_[104];
  static const uint8_t table29_90_emit_[44];
  static const uint8_t table29_91_emit_[104];
  static const uint8_t table29_92_emit_[136];
  static const uint16_t table29_92_inner_[70];
  static const uint8_t table29_93_emit_[136];
  static const uint8_t table29_94_emit_[136];
  static const uint8_t table29_95_emit_[136];
  static const uint8_t table29_96_emit_[136];
  static const uint8_t table29_97_emit_[136];
  static const uint8_t table29_98_emit_[136];
  static const uint8_t table29_99_emit_[136];
  static const uint8_t table29_100_emit_[136];
  static const uint8_t table29_101_emit_[136];
  static const uint8_t table29_102_emit_[136];
  static const uint8_t table29_103_emit_[136];
  static const uint8_t table29_104_emit_[136];
  static const uint8_t table29_105_emit_[144];
  static const uint16_t table29_105_inner_[75];
  static const uint8_t table29_106_emit_[144];
  static const uint8_t table29_107_emit_[144];
  static const uint8_t table29_108_emit_[144];
  static const uint8_t table29_109_emit_[144];
  static const uint8_t table29_110_emit_[144];
  static const uint8_t table29_111_emit_[144];
  static const uint8_t table29_112_emit_[144];
  static const uint8_t table29_113_emit_[144];
  static const uint8_t table29_114_emit_[144];
  static const uint8_t table29_115_emit_[144];
  static const uint8_t table29_116_emit_[144];
  static const uint8_t table29_117_emit_[144];
  static const uint8_t table29_118_emit_[80];
  static const uint16_t table29_118_inner_[45];
  static const uint8_t table29_119_emit_[80];
  static const uint8_t table29_120_emit_[80];
  static const uint8_t table29_121_emit_[80];
  static const uint8_t table29_122_emit_[80];
  static const uint8_t table29_123_emit_[80];
  static const uint8_t table29_124_emit_[80];
  static const uint8_t table29_125_emit_[26];
  static const uint16_t table29_125_inner_[18];
  static const uint8_t table29_125_outer_[128];
  static const uint8_t table29_126_emit_[10];
  static const uint16_t table29_126_inner_[11];
  static const uint8_t table29_126_outer_[128];
  static const uint8_t table29_127_emit_[63];
  static const uint16_t table29_127_inner_[65];
  static const uint8_t table29_127_outer_[128];
  static const uint8_t* const table29_emit_[128];
  static const uint16_t* const table29_inner_[128];
  static const uint8_t* const table29_outer_[128];
  static const uint8_t table30_0_outer_[256];
  static const uint8_t table30_1_outer_[256];
  static const uint8_t table30_20_emit_[222];
  static const uint16_t table30_20_inner_[76];
  static const uint8_t table30_20_outer_[256];
  static const uint8_t table30_21_emit_[222];
  static const uint8_t table30_22_emit_[222];
  static const uint8_t table30_23_emit_[222];
  static const uint8_t table30_24_emit_[222];
  static const uint8_t table30_25_emit_[222];
  static const uint8_t table30_26_emit_[222];
  static const uint8_t table30_27_emit_[222];
  static const uint8_t table30_28_emit_[222];
  static const uint8_t table30_29_emit_[222];
  static const uint8_t table30_30_emit_[222];
  static const uint8_t table30_31_emit_[222];
  static const uint8_t table30_32_emit_[222];
  static const uint8_t table30_33_emit_[222];
  static const uint8_t table30_34_emit_[222];
  static const uint8_t table30_35_emit_[222];
  static const uint8_t table30_36_emit_[222];
  static const uint8_t table30_37_emit_[222];
  static const uint8_t table30_38_emit_[222];
  static const uint8_t table30_39_emit_[222];
  static const uint8_t table30_40_emit_[222];
  static const uint8_t table30_41_emit_[222];
  static const uint8_t table30_42_emit_[222];
  static const uint8_t table30_43_emit_[222];
  static const uint8_t table30_44_emit_[222];
  static const uint8_t table30_45_emit_[222];
  static const uint8_t table30_46_emit_[408];
  static const uint16_t table30_46_inner_[139];
  static const uint8_t table30_46_outer_[256];
  static const uint8_t table30_47_emit_[408];
  static const uint8_t table30_48_emit_[408];
  static const uint8_t table30_49_emit_[408];
  static const uint8_t table30_50_emit_[408];
  static const uint8_t table30_51_emit_[408];
  static const uint8_t table30_52_emit_[408];
  static const uint8_t table30_53_emit_[408];
  static const uint8_t table30_54_emit_[408];
  static const uint8_t table30_55_emit_[408];
  static const uint8_t table30_56_emit_[408];
  static const uint8_t table30_57_emit_[408];
  static const uint8_t table30_58_emit_[408];
  static const uint8_t table30_59_emit_[408];
  static const uint8_t table30_60_emit_[408];
  static const uint8_t table30_61_emit_[408];
  static const uint8_t table30_62_emit_[432];
  static const uint16_t table30_62_inner_[149];
  static const uint8_t table30_62_outer_[256];
  static const uint8_t table30_63_emit_[252];
  static const uint16_t table30_63_inner_[94];
  static const uint8_t table30_63_outer_[256];
  static const uint8_t table30_64_emit_[240];
  static const uint16_t table30_64_inner_[89];
  static const uint8_t table30_64_outer_[256];
  static const uint8_t table30_65_emit_[84];
  static const uint16_t table30_65_inner_[35];
  static const uint8_t table30_65_outer_[256];
  static const uint8_t table30_66_outer_[256];
  static const uint8_t table30_67_emit_[78];
  static const uint16_t table30_67_inner_[41];
  static const uint8_t table30_67_outer_[256];
  static const uint8_t table30_68_emit_[240];
  static const uint8_t table30_69_emit_[84];
  static const uint8_t table30_71_emit_[78];
  static const uint8_t table30_72_emit_[240];
  static const uint8_t table30_73_emit_[84];
  static const uint8_t table30_75_emit_[78];
  static const uint8_t table30_92_emit_[148];
  static const uint16_t table30_92_inner_[76];
  static const uint8_t table30_93_emit_[148];
  static const uint8_t table30_94_emit_[148];
  static const uint8_t table30_95_emit_[148];
  static const uint8_t table30_96_emit_[148];
  static const uint8_t table30_97_emit_[148];
  static const uint8_t table30_98_emit_[148];
  static const uint8_t table30_99_emit_[148];
  static const uint8_t table30_100_emit_[148];
  static const uint8_t table30_101_emit_[148];
  static const uint8_t table30_102_emit_[148];
  static const uint8_t table30_103_emit_[148];
  static const uint8_t table30_104_emit_[148];
  static const uint8_t table30_105_emit_[272];
  static const uint16_t table30_105_inner_[139];
  static const uint8_t table30_106_emit_[272];
  static const uint8_t table30_107_emit_[272];
  static const uint8_t table30_108_emit_[272];
  static const uint8_t table30_109_emit_[272];
  static const uint8_t table30_110_emit_[272];
  static const uint8_t table30_111_emit_[272];
  static const uint8_t table30_112_emit_[272];
  static const uint8_t table30_113_emit_[272];
  static const uint8_t table30_114_emit_[272];
  static const uint8_t table30_115_emit_[272];
  static const uint8_t table30_116_emit_[272];
  static const uint8_t table30_117_emit_[272];
  static const uint8_t table30_118_emit_[288];
  static const uint16_t table30_118_inner_[149];
  static const uint8_t table30_119_emit_[288];
  static const uint8_t table30_120_emit_[288];
  static const uint8_t table30_121_emit_[288];
  static const uint8_t table30_122_emit_[288];
  static const uint8_t table30_123_emit_[288];
  static const uint8_t table30_124_emit_[288];
  static const uint8_t table30_125_emit_[192];
  static const uint16_t table30_125_inner_[104];
  static const uint8_t table30_125_outer_[256];
  static const uint8_t table30_126_emit_[124];
  static const uint16_t table30_126_inner_[71];
  static const uint8_t table30_126_outer_[256];
  static const uint8_t table30_127_outer_[256];
  static const uint8_t* const table30_emit_[128];
  static const uint16_t* const table30_inner_[128];
  static const uint8_t* const table30_outer_[128];
  static const uint8_t table15_0_emit_[1];
  static const uint16_t table15_0_ops_[512];
  static const uint8_t table15_64_emit_[1];
  static const uint16_t table15_64_ops_[512];
  static const uint8_t table15_68_emit_[1];
  static const uint8_t table15_72_emit_[1];
  static const uint8_t table15_76_emit_[1];
  static const uint16_t table15_76_ops_[512];
  static const uint8_t table15_78_emit_[1];
  static const uint8_t table15_80_emit_[1];
  static const uint8_t table15_82_emit_[1];
  static const uint8_t table15_84_emit_[1];
  static const uint8_t table15_86_emit_[1];
  static const uint8_t table15_88_emit_[1];
  static const uint8_t table15_90_emit_[1];
  static const uint8_t table15_92_emit_[1];
  static const uint16_t table15_92_ops_[512];
  static const uint8_t table15_93_emit_[1];
  static const uint8_t table15_94_emit_[1];
  static const uint8_t table15_95_emit_[1];
  static const uint8_t table15_96_emit_[1];
  static const uint8_t table15_97_emit_[1];
  static const uint8_t table15_98_emit_[1];
  static const uint8_t table15_99_emit_[1];
  static const uint8_t table15_100_emit_[1];
  static const uint8_t table15_101_emit_[1];
  static const uint8_t table15_102_emit_[1];
  static const uint8_t table15_103_emit_[1];
  static const uint8_t table15_104_emit_[1];
  static const uint8_t table15_105_emit_[2];
  static const uint16_t table15_105_ops_[512];
  static const uint8_t table15_106_emit_[2];
  static const uint8_t table15_107_emit_[2];
  static const uint8_t table15_108_emit_[2];
  static const uint8_t table15_109_emit_[2];
  static const uint8_t table15_110_emit_[2];
  static const uint8_t table15_111_emit_[2];
  static const uint8_t table15_112_emit_[2];
  static const uint8_t table15_113_emit_[2];
  static const uint8_t table15_114_emit_[2];
  static const uint8_t table15_115_emit_[2];
  static const uint8_t table15_116_emit_[2];
  static const uint8_t table15_117_emit_[2];
  static const uint8_t table15_118_emit_[4];
  static const uint16_t table15_118_ops_[512];
  static const uint8_t table15_119_emit_[4];
  static const uint8_t table15_120_emit_[4];
  static const uint8_t table15_121_emit_[4];
  static const uint8_t table15_122_emit_[4];
  static const uint8_t table15_123_emit_[4];
  static const uint8_t table15_124_emit_[4];
  static const uint8_t table15_125_emit_[7];
  static const uint16_t table15_125_ops_[512];
  static const uint16_t table15_126_ops_[512];
  static const uint8_t table15_127_emit_[66];
  static const uint16_t table15_127_ops_[512];
  static const uint8_t* const table15_emit_[128];
  static const uint16_t* const table15_ops_[128];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo9()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 9)) & 0x1ff;
      const auto op = GetOp1(index);
      const int consumed = op & 15;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 7;
      switch ((op >> 4) & 7) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 1: {
          DecodeStep0();
          break;
        }
        case 2: {
          DecodeStep1();
          break;
        }
        case 3: {
          DecodeStep2();
          break;
        }
        case 4: {
          DecodeStep3();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo9() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  void Done0() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp4(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit4(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp5(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit5(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo1()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp6(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit6(index, emit_ofs + 0));
  }
  bool RefillTo1() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
    }
    return true;
  }
  bool Read1to8Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Done1() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep1() {
    if (!RefillTo1()) {
      Done2();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp7(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit7(index, emit_ofs + 0));
  }
  void Done2() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep2() {
    if (!RefillTo2()) {
      Done3();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp8(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit8(index, emit_ofs + 0));
  }
  bool RefillTo2() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done3() {
    done_ = true;
    switch (buffer_len_) {
      case 1: {
        const auto index = buffer_ & 1;
        const auto op = GetOp9(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit9(index, (op >> 1) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep3() {
    if (!RefillTo5()) {
      Done4();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 5)) & 0x1f;
    const auto op = GetOp10(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 5;
    switch ((op >> 3) & 3) {
      case 0: {
        sink_(GetEmit10(index, emit_ofs + 0));
        break;
      }
      case 1: {
        DecodeStep4();
        break;
      }
      case 2: {
        DecodeStep5();
        break;
      }
    }
  }
  bool RefillTo5() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done4() {
    done_ = true;
    switch (buffer_len_) {
      case 1: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp11(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit11(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp12(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit12(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp13(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep4() {
    if (!RefillTo1()) {
      Done5();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 1)) & 0x1;
    const auto op = GetOp14(index);
    const int consumed = op & 1;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 1;
    sink_(GetEmit14(index, emit_ofs + 0));
  }
  void Done5() {
    done_ = true;
    ok_ = false;
  }
  void DecodeStep5() {
    if (!RefillTo16()) {
      Done6();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 16)) & 0xffff;
    const auto op = GetOp15(index);
    const int consumed = op & 31;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 6;
    switch ((op >> 5) & 1) {
      case 0: {
        sink_(GetEmit15(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  bool RefillTo16() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7: {
        return Read2to7Bytes();
      }
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done6() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1: {
        const auto index = buffer_ & 1;
        const auto op = GetOp16(index);
        switch (op & 1) {
          case 0: {
            sink_(GetEmit16(index, (op >> 1) + 0));
            break;
          }
        }
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp17(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp18(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp19(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp20(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp21(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            sink_(GetEmit21(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp22(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit22(index, (op >> 2) + 0));
            sink_(GetEmit22(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit22(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp23(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit23(index, (op >> 2) + 0));
            sink_(GetEmit23(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit23(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp24(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit24(index, (op >> 2) + 0));
            sink_(GetEmit24(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit24(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp25(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit25(index, (op >> 2) + 0));
            sink_(GetEmit25(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit25(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp26(index);
        switch (op & 7) {
          case 0: {
            sink_(GetEmit26(index, (op >> 3) + 0));
            sink_(GetEmit26(index, (op >> 3) + 1));
            sink_(GetEmit26(index, (op >> 3) + 2));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit26(index, (op >> 3) + 0));
            sink_(GetEmit26(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit26(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp27(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit27(index, (op >> 3) + 0));
            sink_(GetEmit27(index, (op >> 3) + 1));
            sink_(GetEmit27(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit27(index, (op >> 3) + 0));
            sink_(GetEmit27(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit27(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp28(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit28(index, (op >> 3) + 0));
            sink_(GetEmit28(index, (op >> 3) + 1));
            sink_(GetEmit28(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit28(index, (op >> 3) + 0));
            sink_(GetEmit28(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit28(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 14: {
        const auto index = buffer_ & 16383;
        const auto op = GetOp29(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit29(index, (op >> 3) + 0));
            sink_(GetEmit29(index, (op >> 3) + 1));
            sink_(GetEmit29(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit29(index, (op >> 3) + 0));
            sink_(GetEmit29(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit29(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 15: {
        const auto index = buffer_ & 32767;
        const auto op = GetOp30(index);
        switch (op & 7) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit30(index, (op >> 3) + 0));
            sink_(GetEmit30(index, (op >> 3) + 1));
            sink_(GetEmit30(index, (op >> 3) + 2));
            break;
          }
          case 2: {
            sink_(GetEmit30(index, (op >> 3) + 0));
            sink_(GetEmit30(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit30(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_9_5_16
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_9_5_16_H
