/*
 * GStreamer
 *
 * unit test for jpeg2000parse
 *
 * Copyright (C) 2019 Collabora Inc. All rights reserved.
 *
 * Contact: Aaron Boxer <aaron.boxer@collabora.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "parser.h"
#include <gst/codecparsers/gstjpeg2000sampling.h>

static GstStaticPadTemplate srctemplate_jpc =
GST_STATIC_PAD_TEMPLATE ("src", GST_PAD_SRC,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("image/x-jpc, parsed=(boolean)false"));

static GstStaticPadTemplate srctemplate_j2c =
GST_STATIC_PAD_TEMPLATE ("src", GST_PAD_SRC,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("image/x-j2c, parsed=(boolean)false"));

static GstStaticPadTemplate srctemplate_jp2 =
GST_STATIC_PAD_TEMPLATE ("src", GST_PAD_SRC,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("image/jp2, parsed=(boolean)false"));

#define SINK_CAPS_MONO_TMPL " width = (int) 32, height = (int) 32, \
						sampling = (string) GRAYSCALE, profile = (int) 0, \
						colorspace = (string) GRAY, parsed = (boolean) true;"

static GstStaticPadTemplate sinktemplate_mono_jpc =
GST_STATIC_PAD_TEMPLATE ("sink", GST_PAD_SINK,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("image/x-jpc," SINK_CAPS_MONO_TMPL)
    );

static GstStaticPadTemplate sinktemplate_mono_j2c =
GST_STATIC_PAD_TEMPLATE ("sink", GST_PAD_SINK,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("image/x-j2c," SINK_CAPS_MONO_TMPL)
    );

#define SINK_CAPS_RGB_TMPL " width = (int) 32, height = (int) 32, \
						sampling = (string) RGB, profile = (int) 0, \
						colorspace = (string) sRGB, parsed = (boolean) true;"

static GstStaticPadTemplate sinktemplate_rgb_jpc =
GST_STATIC_PAD_TEMPLATE ("sink", GST_PAD_SINK,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("image/x-jpc," SINK_CAPS_RGB_TMPL)
    );

static GstStaticPadTemplate sinktemplate_rgb_j2c =
GST_STATIC_PAD_TEMPLATE ("sink", GST_PAD_SINK,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("image/x-j2c," SINK_CAPS_RGB_TMPL)
    );

static guint8 *jpeg2000_codec_data = NULL;
static gsize jpge2000_codec_data_size = 0;

unsigned char rgb_32_32_j2k[] = {
  0xff, 0x4f, 0xff, 0x51, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x01, 0x01, 0x07, 0x01, 0x01,
  0x07, 0x01, 0x01, 0xff, 0x52, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x01,
  0x05, 0x04, 0x04, 0x00, 0x01, 0xff, 0x5c, 0x00, 0x13, 0x40, 0x40, 0x48,
  0x48, 0x50, 0x48, 0x48, 0x50, 0x48, 0x48, 0x50, 0x48, 0x48, 0x50, 0x48,
  0x48, 0x50, 0xff, 0x64, 0x00, 0x25, 0x00, 0x01, 0x43, 0x72, 0x65, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x4f, 0x70, 0x65, 0x6e, 0x4a,
  0x50, 0x45, 0x47, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20,
  0x32, 0x2e, 0x33, 0x2e, 0x31, 0xff, 0x90, 0x00, 0x0a, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x4f, 0x00, 0x01, 0xff, 0x93, 0xcf, 0xb4, 0x08, 0x03, 0x1f,
  0xc3, 0xe7, 0x02, 0x08, 0xc1, 0xf2, 0x01, 0x00, 0xc0, 0x7c, 0x20, 0xc3,
  0xea, 0x02, 0x80, 0x10, 0x80, 0x09, 0x07, 0x3f, 0x07, 0xc0, 0x7c, 0x20,
  0xcf, 0xc0, 0x0a, 0x07, 0xce, 0x08, 0x05, 0x02, 0xef, 0x00, 0x7f, 0xc0,
  0x3a, 0x0c, 0x0f, 0x90, 0x0c, 0x03, 0xe1, 0x04, 0x01, 0x00, 0x09, 0xc0,
  0x7c, 0x21, 0xc0, 0xf9, 0x02, 0x40, 0x3e, 0x10, 0xc0, 0x10, 0x9a, 0x7f,
  0x0d, 0xfa, 0x01, 0x7f, 0x10, 0x93, 0x7f, 0xc0, 0xf9, 0x01, 0xc7, 0xda,
  0x0b, 0x01, 0xf2, 0x04, 0x0e, 0x41, 0x06, 0x08, 0xd9, 0xee, 0x60, 0x07,
  0x0d, 0x72, 0x91, 0xbf, 0xc0, 0x7c, 0x21, 0xcf, 0xc0, 0x1a, 0x03, 0xe4,
  0x06, 0x0d, 0x93, 0x4f, 0x0c, 0x17, 0xac, 0x9f, 0xc7, 0x3f, 0x0d, 0x8e,
  0x7f, 0xc0, 0x3a, 0x2c, 0xfc, 0x03, 0xe0, 0x0e, 0x8c, 0x16, 0xa3, 0xbe,
  0xff, 0x6f, 0x00, 0xcf, 0xca, 0xc7, 0x45, 0x46, 0x09, 0x8f, 0xcd, 0x8e,
  0x86, 0x17, 0x84, 0x9d, 0x4c, 0x24, 0xa5, 0xd4, 0x77, 0xac, 0x3f, 0xc0,
  0x7c, 0x23, 0x4f, 0xc0, 0x36, 0x01, 0xf0, 0x8a, 0x21, 0x8c, 0xb6, 0x66,
  0xca, 0x47, 0x10, 0x30, 0x3b, 0x48, 0x58, 0x64, 0x1e, 0x61, 0x0b, 0xa6,
  0xba, 0x61, 0x3d, 0x21, 0x27, 0x03, 0xf5, 0xf7, 0xc0, 0x7c, 0x23, 0x4f,
  0xc0, 0x42, 0x01, 0xf0, 0x8e, 0x20, 0xe8, 0xfd, 0xd5, 0xc1, 0x66, 0x0d,
  0x8d, 0x0c, 0x4c, 0x68, 0x3b, 0xca, 0x89, 0x62, 0xcc, 0xe6, 0x34, 0x39,
  0x31, 0x37, 0xb7, 0x20, 0x79, 0xfa, 0x1a, 0x41, 0xd9, 0xdb, 0xc0, 0x3a,
  0x44, 0x7d, 0xa4, 0x30, 0x02, 0x60, 0x60, 0x45, 0x83, 0x8e, 0x6a, 0x51,
  0x90, 0xed, 0x00, 0xd4, 0x14, 0xc6, 0x8e, 0xe4, 0xf6, 0xe7, 0x47, 0x44,
  0xeb, 0xc3, 0x64, 0x58, 0x97, 0xba, 0x1a, 0x4d, 0xbc, 0xc1, 0xc1, 0x24,
  0xf4, 0x85, 0x1b, 0x04, 0xb9, 0x98, 0xb9, 0x08, 0xa5, 0x7d, 0x9f, 0x19,
  0xc2, 0x70, 0x20, 0x15, 0xa5, 0xc0, 0x3a, 0x5c, 0xfc, 0x06, 0xe0, 0x0e,
  0x8e, 0x35, 0xdd, 0xa7, 0x0f, 0x78, 0xc3, 0x11, 0x30, 0x66, 0xde, 0x7f,
  0x0c, 0x1a, 0x28, 0x04, 0x01, 0xe1, 0x78, 0x92, 0x67, 0xbb, 0xe3, 0x51,
  0x63, 0x89, 0xe0, 0x1d, 0x2c, 0x87, 0xfa, 0xda, 0x25, 0x01, 0x8d, 0x56,
  0xda, 0xff, 0x7f, 0x34, 0xf0, 0xf7, 0x05, 0x8b, 0xc9, 0x8f, 0xc0, 0x3a,
  0x6c, 0xfc, 0x08, 0x60, 0x0e, 0x96, 0x38, 0xd7, 0xa3, 0x30, 0x1a, 0x8d,
  0xbd, 0x2d, 0x30, 0xc1, 0x76, 0x0a, 0xe7, 0x03, 0x84, 0x12, 0x1f, 0x7e,
  0xd3, 0xfa, 0x25, 0x99, 0x97, 0x5c, 0xc8, 0xd2, 0xc3, 0x4a, 0xa5, 0xcc,
  0xb4, 0xd9, 0x72, 0x75, 0x02, 0x3c, 0xef, 0xa6, 0x44, 0x4f, 0x93, 0x3f,
  0xf5, 0x36, 0xc8, 0x06, 0x34, 0x9e, 0xa9, 0x86, 0xdd, 0x30, 0x9f, 0x60,
  0xf7, 0x92, 0x2f, 0xc0, 0x15, 0x31, 0xf6, 0x94, 0x40, 0x0a, 0xa0, 0x2e,
  0x67, 0x19, 0xa4, 0xc9, 0x7a, 0xe6, 0x62, 0xcb, 0x67, 0x6a, 0xaa, 0xed,
  0xdf, 0x37, 0x23, 0xda, 0x88, 0xd5, 0xd4, 0xe0, 0x00, 0xc1, 0xbc, 0xfa,
  0xee, 0x8c, 0x02, 0xfc, 0x4e, 0xed, 0x1f, 0x16, 0x6d, 0x88, 0xf7, 0x5b,
  0x55, 0xd6, 0x85, 0x9f, 0x74, 0x77, 0xa3, 0xa4, 0xbf, 0xa0, 0xbb, 0x9f,
  0x19, 0xca, 0xfa, 0xc7, 0x73, 0xc8, 0x80, 0xd8, 0x66, 0xef, 0xc0, 0x3a,
  0x64, 0xfc, 0x07, 0x20, 0x04, 0xa0, 0x62, 0x58, 0xac, 0x18, 0x55, 0x48,
  0x17, 0x3c, 0xf1, 0xb0, 0x66, 0x6f, 0x00, 0xd4, 0xb9, 0xf7, 0xff, 0x6c,
  0xb9, 0x5b, 0xa0, 0x0d, 0xe6, 0xe0, 0xce, 0x1e, 0xbb, 0x5a, 0x47, 0x30,
  0xe0, 0x58, 0x79, 0xb1, 0xc0, 0x04, 0xd8, 0xba, 0x17, 0xbf, 0x62, 0x09,
  0xb3, 0xa6, 0x72, 0xc0, 0x15, 0xb3, 0xf0, 0x25, 0x80, 0x13, 0x80, 0x1e,
  0xeb, 0xfa, 0xc6, 0xf2, 0x99, 0xf7, 0x54, 0x75, 0xaf, 0x5c, 0xc7, 0x62,
  0x66, 0xae, 0x3d, 0xfb, 0xae, 0x34, 0xeb, 0xb5, 0xac, 0x00, 0x01, 0x9f,
  0x4c, 0x72, 0x25, 0x30, 0xd0, 0x8b, 0x45, 0x1b, 0x19, 0xce, 0x05, 0x96,
  0xb1, 0x9c, 0xd8, 0x34, 0x22, 0x66, 0xc7, 0x19, 0x76, 0x65, 0x41, 0x25,
  0xbd, 0x03, 0x84, 0xb9, 0x68, 0xd4, 0x8a, 0x2f, 0xff, 0xd9
};

unsigned char rgb_32_32_j2c[] = { 0x00, 0x00, 0x02, 0xd6, 0x6a, 0x70, 0x32,
  0x63, 0xff, 0x4f, 0xff, 0x51, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x01, 0x01, 0x07, 0x01,
  0x01, 0x07, 0x01, 0x01, 0xff, 0x52, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x05, 0x04, 0x04, 0x00, 0x01, 0xff, 0x5c, 0x00, 0x13, 0x40, 0x40,
  0x48, 0x48, 0x50, 0x48, 0x48, 0x50, 0x48, 0x48, 0x50, 0x48, 0x48, 0x50,
  0x48, 0x48, 0x50, 0xff, 0x64, 0x00, 0x25, 0x00, 0x01, 0x43, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x4f, 0x70, 0x65, 0x6e,
  0x4a, 0x50, 0x45, 0x47, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x32, 0x2e, 0x33, 0x2e, 0x31, 0xff, 0x90, 0x00, 0x0a, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x4f, 0x00, 0x01, 0xff, 0x93, 0xcf, 0xb4, 0x08, 0x03,
  0x1f, 0xc3, 0xe7, 0x02, 0x08, 0xc1, 0xf2, 0x01, 0x00, 0xc0, 0x7c, 0x20,
  0xc3, 0xea, 0x02, 0x80, 0x10, 0x80, 0x09, 0x07, 0x3f, 0x07, 0xc0, 0x7c,
  0x20, 0xcf, 0xc0, 0x0a, 0x07, 0xce, 0x08, 0x05, 0x02, 0xef, 0x00, 0x7f,
  0xc0, 0x3a, 0x0c, 0x0f, 0x90, 0x0c, 0x03, 0xe1, 0x04, 0x01, 0x00, 0x09,
  0xc0, 0x7c, 0x21, 0xc0, 0xf9, 0x02, 0x40, 0x3e, 0x10, 0xc0, 0x10, 0x9a,
  0x7f, 0x0d, 0xfa, 0x01, 0x7f, 0x10, 0x93, 0x7f, 0xc0, 0xf9, 0x01, 0xc7,
  0xda, 0x0b, 0x01, 0xf2, 0x04, 0x0e, 0x41, 0x06, 0x08, 0xd9, 0xee, 0x60,
  0x07, 0x0d, 0x72, 0x91, 0xbf, 0xc0, 0x7c, 0x21, 0xcf, 0xc0, 0x1a, 0x03,
  0xe4, 0x06, 0x0d, 0x93, 0x4f, 0x0c, 0x17, 0xac, 0x9f, 0xc7, 0x3f, 0x0d,
  0x8e, 0x7f, 0xc0, 0x3a, 0x2c, 0xfc, 0x03, 0xe0, 0x0e, 0x8c, 0x16, 0xa3,
  0xbe, 0xff, 0x6f, 0x00, 0xcf, 0xca, 0xc7, 0x45, 0x46, 0x09, 0x8f, 0xcd,
  0x8e, 0x86, 0x17, 0x84, 0x9d, 0x4c, 0x24, 0xa5, 0xd4, 0x77, 0xac, 0x3f,
  0xc0, 0x7c, 0x23, 0x4f, 0xc0, 0x36, 0x01, 0xf0, 0x8a, 0x21, 0x8c, 0xb6,
  0x66, 0xca, 0x47, 0x10, 0x30, 0x3b, 0x48, 0x58, 0x64, 0x1e, 0x61, 0x0b,
  0xa6, 0xba, 0x61, 0x3d, 0x21, 0x27, 0x03, 0xf5, 0xf7, 0xc0, 0x7c, 0x23,
  0x4f, 0xc0, 0x42, 0x01, 0xf0, 0x8e, 0x20, 0xe8, 0xfd, 0xd5, 0xc1, 0x66,
  0x0d, 0x8d, 0x0c, 0x4c, 0x68, 0x3b, 0xca, 0x89, 0x62, 0xcc, 0xe6, 0x34,
  0x39, 0x31, 0x37, 0xb7, 0x20, 0x79, 0xfa, 0x1a, 0x41, 0xd9, 0xdb, 0xc0,
  0x3a, 0x44, 0x7d, 0xa4, 0x30, 0x02, 0x60, 0x60, 0x45, 0x83, 0x8e, 0x6a,
  0x51, 0x90, 0xed, 0x00, 0xd4, 0x14, 0xc6, 0x8e, 0xe4, 0xf6, 0xe7, 0x47,
  0x44, 0xeb, 0xc3, 0x64, 0x58, 0x97, 0xba, 0x1a, 0x4d, 0xbc, 0xc1, 0xc1,
  0x24, 0xf4, 0x85, 0x1b, 0x04, 0xb9, 0x98, 0xb9, 0x08, 0xa5, 0x7d, 0x9f,
  0x19, 0xc2, 0x70, 0x20, 0x15, 0xa5, 0xc0, 0x3a, 0x5c, 0xfc, 0x06, 0xe0,
  0x0e, 0x8e, 0x35, 0xdd, 0xa7, 0x0f, 0x78, 0xc3, 0x11, 0x30, 0x66, 0xde,
  0x7f, 0x0c, 0x1a, 0x28, 0x04, 0x01, 0xe1, 0x78, 0x92, 0x67, 0xbb, 0xe3,
  0x51, 0x63, 0x89, 0xe0, 0x1d, 0x2c, 0x87, 0xfa, 0xda, 0x25, 0x01, 0x8d,
  0x56, 0xda, 0xff, 0x7f, 0x34, 0xf0, 0xf7, 0x05, 0x8b, 0xc9, 0x8f, 0xc0,
  0x3a, 0x6c, 0xfc, 0x08, 0x60, 0x0e, 0x96, 0x38, 0xd7, 0xa3, 0x30, 0x1a,
  0x8d, 0xbd, 0x2d, 0x30, 0xc1, 0x76, 0x0a, 0xe7, 0x03, 0x84, 0x12, 0x1f,
  0x7e, 0xd3, 0xfa, 0x25, 0x99, 0x97, 0x5c, 0xc8, 0xd2, 0xc3, 0x4a, 0xa5,
  0xcc, 0xb4, 0xd9, 0x72, 0x75, 0x02, 0x3c, 0xef, 0xa6, 0x44, 0x4f, 0x93,
  0x3f, 0xf5, 0x36, 0xc8, 0x06, 0x34, 0x9e, 0xa9, 0x86, 0xdd, 0x30, 0x9f,
  0x60, 0xf7, 0x92, 0x2f, 0xc0, 0x15, 0x31, 0xf6, 0x94, 0x40, 0x0a, 0xa0,
  0x2e, 0x67, 0x19, 0xa4, 0xc9, 0x7a, 0xe6, 0x62, 0xcb, 0x67, 0x6a, 0xaa,
  0xed, 0xdf, 0x37, 0x23, 0xda, 0x88, 0xd5, 0xd4, 0xe0, 0x00, 0xc1, 0xbc,
  0xfa, 0xee, 0x8c, 0x02, 0xfc, 0x4e, 0xed, 0x1f, 0x16, 0x6d, 0x88, 0xf7,
  0x5b, 0x55, 0xd6, 0x85, 0x9f, 0x74, 0x77, 0xa3, 0xa4, 0xbf, 0xa0, 0xbb,
  0x9f, 0x19, 0xca, 0xfa, 0xc7, 0x73, 0xc8, 0x80, 0xd8, 0x66, 0xef, 0xc0,
  0x3a, 0x64, 0xfc, 0x07, 0x20, 0x04, 0xa0, 0x62, 0x58, 0xac, 0x18, 0x55,
  0x48, 0x17, 0x3c, 0xf1, 0xb0, 0x66, 0x6f, 0x00, 0xd4, 0xb9, 0xf7, 0xff,
  0x6c, 0xb9, 0x5b, 0xa0, 0x0d, 0xe6, 0xe0, 0xce, 0x1e, 0xbb, 0x5a, 0x47,
  0x30, 0xe0, 0x58, 0x79, 0xb1, 0xc0, 0x04, 0xd8, 0xba, 0x17, 0xbf, 0x62,
  0x09, 0xb3, 0xa6, 0x72, 0xc0, 0x15, 0xb3, 0xf0, 0x25, 0x80, 0x13, 0x80,
  0x1e, 0xeb, 0xfa, 0xc6, 0xf2, 0x99, 0xf7, 0x54, 0x75, 0xaf, 0x5c, 0xc7,
  0x62, 0x66, 0xae, 0x3d, 0xfb, 0xae, 0x34, 0xeb, 0xb5, 0xac, 0x00, 0x01,
  0x9f, 0x4c, 0x72, 0x25, 0x30, 0xd0, 0x8b, 0x45, 0x1b, 0x19, 0xce, 0x05,
  0x96, 0xb1, 0x9c, 0xd8, 0x34, 0x22, 0x66, 0xc7, 0x19, 0x76, 0x65, 0x41,
  0x25, 0xbd, 0x03, 0x84, 0xb9, 0x68, 0xd4, 0x8a, 0x2f, 0xff, 0xd9
};



unsigned char rgb_32_32_jp2[] = {
  0x00, 0x00, 0x00, 0x0c, 0x6a, 0x50, 0x20, 0x20, 0x0d, 0x0a, 0x87, 0x0a,
  0x00, 0x00, 0x00, 0x14, 0x66, 0x74, 0x79, 0x70, 0x6a, 0x70, 0x32, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x6a, 0x70, 0x32, 0x20, 0x00, 0x00, 0x00, 0x2d,
  0x6a, 0x70, 0x32, 0x68, 0x00, 0x00, 0x00, 0x16, 0x69, 0x68, 0x64, 0x72,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x03, 0x07, 0x07,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x63, 0x6f, 0x6c, 0x72, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x02, 0xd6, 0x6a, 0x70, 0x32,
  0x63, 0xff, 0x4f, 0xff, 0x51, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x01, 0x01, 0x07, 0x01,
  0x01, 0x07, 0x01, 0x01, 0xff, 0x52, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x05, 0x04, 0x04, 0x00, 0x01, 0xff, 0x5c, 0x00, 0x13, 0x40, 0x40,
  0x48, 0x48, 0x50, 0x48, 0x48, 0x50, 0x48, 0x48, 0x50, 0x48, 0x48, 0x50,
  0x48, 0x48, 0x50, 0xff, 0x64, 0x00, 0x25, 0x00, 0x01, 0x43, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x4f, 0x70, 0x65, 0x6e,
  0x4a, 0x50, 0x45, 0x47, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x32, 0x2e, 0x33, 0x2e, 0x31, 0xff, 0x90, 0x00, 0x0a, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x4f, 0x00, 0x01, 0xff, 0x93, 0xcf, 0xb4, 0x08, 0x03,
  0x1f, 0xc3, 0xe7, 0x02, 0x08, 0xc1, 0xf2, 0x01, 0x00, 0xc0, 0x7c, 0x20,
  0xc3, 0xea, 0x02, 0x80, 0x10, 0x80, 0x09, 0x07, 0x3f, 0x07, 0xc0, 0x7c,
  0x20, 0xcf, 0xc0, 0x0a, 0x07, 0xce, 0x08, 0x05, 0x02, 0xef, 0x00, 0x7f,
  0xc0, 0x3a, 0x0c, 0x0f, 0x90, 0x0c, 0x03, 0xe1, 0x04, 0x01, 0x00, 0x09,
  0xc0, 0x7c, 0x21, 0xc0, 0xf9, 0x02, 0x40, 0x3e, 0x10, 0xc0, 0x10, 0x9a,
  0x7f, 0x0d, 0xfa, 0x01, 0x7f, 0x10, 0x93, 0x7f, 0xc0, 0xf9, 0x01, 0xc7,
  0xda, 0x0b, 0x01, 0xf2, 0x04, 0x0e, 0x41, 0x06, 0x08, 0xd9, 0xee, 0x60,
  0x07, 0x0d, 0x72, 0x91, 0xbf, 0xc0, 0x7c, 0x21, 0xcf, 0xc0, 0x1a, 0x03,
  0xe4, 0x06, 0x0d, 0x93, 0x4f, 0x0c, 0x17, 0xac, 0x9f, 0xc7, 0x3f, 0x0d,
  0x8e, 0x7f, 0xc0, 0x3a, 0x2c, 0xfc, 0x03, 0xe0, 0x0e, 0x8c, 0x16, 0xa3,
  0xbe, 0xff, 0x6f, 0x00, 0xcf, 0xca, 0xc7, 0x45, 0x46, 0x09, 0x8f, 0xcd,
  0x8e, 0x86, 0x17, 0x84, 0x9d, 0x4c, 0x24, 0xa5, 0xd4, 0x77, 0xac, 0x3f,
  0xc0, 0x7c, 0x23, 0x4f, 0xc0, 0x36, 0x01, 0xf0, 0x8a, 0x21, 0x8c, 0xb6,
  0x66, 0xca, 0x47, 0x10, 0x30, 0x3b, 0x48, 0x58, 0x64, 0x1e, 0x61, 0x0b,
  0xa6, 0xba, 0x61, 0x3d, 0x21, 0x27, 0x03, 0xf5, 0xf7, 0xc0, 0x7c, 0x23,
  0x4f, 0xc0, 0x42, 0x01, 0xf0, 0x8e, 0x20, 0xe8, 0xfd, 0xd5, 0xc1, 0x66,
  0x0d, 0x8d, 0x0c, 0x4c, 0x68, 0x3b, 0xca, 0x89, 0x62, 0xcc, 0xe6, 0x34,
  0x39, 0x31, 0x37, 0xb7, 0x20, 0x79, 0xfa, 0x1a, 0x41, 0xd9, 0xdb, 0xc0,
  0x3a, 0x44, 0x7d, 0xa4, 0x30, 0x02, 0x60, 0x60, 0x45, 0x83, 0x8e, 0x6a,
  0x51, 0x90, 0xed, 0x00, 0xd4, 0x14, 0xc6, 0x8e, 0xe4, 0xf6, 0xe7, 0x47,
  0x44, 0xeb, 0xc3, 0x64, 0x58, 0x97, 0xba, 0x1a, 0x4d, 0xbc, 0xc1, 0xc1,
  0x24, 0xf4, 0x85, 0x1b, 0x04, 0xb9, 0x98, 0xb9, 0x08, 0xa5, 0x7d, 0x9f,
  0x19, 0xc2, 0x70, 0x20, 0x15, 0xa5, 0xc0, 0x3a, 0x5c, 0xfc, 0x06, 0xe0,
  0x0e, 0x8e, 0x35, 0xdd, 0xa7, 0x0f, 0x78, 0xc3, 0x11, 0x30, 0x66, 0xde,
  0x7f, 0x0c, 0x1a, 0x28, 0x04, 0x01, 0xe1, 0x78, 0x92, 0x67, 0xbb, 0xe3,
  0x51, 0x63, 0x89, 0xe0, 0x1d, 0x2c, 0x87, 0xfa, 0xda, 0x25, 0x01, 0x8d,
  0x56, 0xda, 0xff, 0x7f, 0x34, 0xf0, 0xf7, 0x05, 0x8b, 0xc9, 0x8f, 0xc0,
  0x3a, 0x6c, 0xfc, 0x08, 0x60, 0x0e, 0x96, 0x38, 0xd7, 0xa3, 0x30, 0x1a,
  0x8d, 0xbd, 0x2d, 0x30, 0xc1, 0x76, 0x0a, 0xe7, 0x03, 0x84, 0x12, 0x1f,
  0x7e, 0xd3, 0xfa, 0x25, 0x99, 0x97, 0x5c, 0xc8, 0xd2, 0xc3, 0x4a, 0xa5,
  0xcc, 0xb4, 0xd9, 0x72, 0x75, 0x02, 0x3c, 0xef, 0xa6, 0x44, 0x4f, 0x93,
  0x3f, 0xf5, 0x36, 0xc8, 0x06, 0x34, 0x9e, 0xa9, 0x86, 0xdd, 0x30, 0x9f,
  0x60, 0xf7, 0x92, 0x2f, 0xc0, 0x15, 0x31, 0xf6, 0x94, 0x40, 0x0a, 0xa0,
  0x2e, 0x67, 0x19, 0xa4, 0xc9, 0x7a, 0xe6, 0x62, 0xcb, 0x67, 0x6a, 0xaa,
  0xed, 0xdf, 0x37, 0x23, 0xda, 0x88, 0xd5, 0xd4, 0xe0, 0x00, 0xc1, 0xbc,
  0xfa, 0xee, 0x8c, 0x02, 0xfc, 0x4e, 0xed, 0x1f, 0x16, 0x6d, 0x88, 0xf7,
  0x5b, 0x55, 0xd6, 0x85, 0x9f, 0x74, 0x77, 0xa3, 0xa4, 0xbf, 0xa0, 0xbb,
  0x9f, 0x19, 0xca, 0xfa, 0xc7, 0x73, 0xc8, 0x80, 0xd8, 0x66, 0xef, 0xc0,
  0x3a, 0x64, 0xfc, 0x07, 0x20, 0x04, 0xa0, 0x62, 0x58, 0xac, 0x18, 0x55,
  0x48, 0x17, 0x3c, 0xf1, 0xb0, 0x66, 0x6f, 0x00, 0xd4, 0xb9, 0xf7, 0xff,
  0x6c, 0xb9, 0x5b, 0xa0, 0x0d, 0xe6, 0xe0, 0xce, 0x1e, 0xbb, 0x5a, 0x47,
  0x30, 0xe0, 0x58, 0x79, 0xb1, 0xc0, 0x04, 0xd8, 0xba, 0x17, 0xbf, 0x62,
  0x09, 0xb3, 0xa6, 0x72, 0xc0, 0x15, 0xb3, 0xf0, 0x25, 0x80, 0x13, 0x80,
  0x1e, 0xeb, 0xfa, 0xc6, 0xf2, 0x99, 0xf7, 0x54, 0x75, 0xaf, 0x5c, 0xc7,
  0x62, 0x66, 0xae, 0x3d, 0xfb, 0xae, 0x34, 0xeb, 0xb5, 0xac, 0x00, 0x01,
  0x9f, 0x4c, 0x72, 0x25, 0x30, 0xd0, 0x8b, 0x45, 0x1b, 0x19, 0xce, 0x05,
  0x96, 0xb1, 0x9c, 0xd8, 0x34, 0x22, 0x66, 0xc7, 0x19, 0x76, 0x65, 0x41,
  0x25, 0xbd, 0x03, 0x84, 0xb9, 0x68, 0xd4, 0x8a, 0x2f, 0xff, 0xd9
};


unsigned char mono_32_32_j2k[] = {
  0xff, 0x4f, 0xff, 0x51, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0xff, 0x52, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x05, 0x04, 0x04, 0x00, 0x01, 0xff,
  0x5c, 0x00, 0x13, 0x40, 0x08, 0x10, 0x10, 0x18, 0x10, 0x10, 0x18, 0x10,
  0x10, 0x18, 0x10, 0x10, 0x18, 0x10, 0x10, 0x18, 0xff, 0x64, 0x00, 0x25,
  0x00, 0x01, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x20, 0x4f, 0x70, 0x65, 0x6e, 0x4a, 0x50, 0x45, 0x47, 0x20, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x32, 0x2e, 0x33, 0x2e, 0x31, 0xff,
  0x90, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x01, 0xff,
  0x93, 0xd0, 0x80, 0x03, 0xdd, 0x06, 0x43, 0x10, 0x80, 0x07, 0x07, 0x07,
  0xa4, 0x53, 0xa1, 0x00, 0x02, 0x7f, 0x0e, 0x1e, 0xc8, 0xe4, 0x93, 0xa2,
  0x80, 0x02, 0xc3, 0xe6, 0x14, 0x37, 0x8d, 0x15, 0x21, 0xb8, 0x50, 0x11,
  0xf7, 0xca, 0xc9, 0x53, 0x13, 0x80, 0x0e, 0x38, 0x92, 0x1b, 0x0b, 0x8e,
  0xb9, 0x57, 0x24, 0x4a, 0xff, 0x7f, 0x17, 0xde, 0x06, 0x1c, 0xc9, 0x2f,
  0xe3, 0x94, 0xc7, 0x19, 0xb2, 0x78, 0xe2, 0x5c, 0x6f, 0xbf, 0xca, 0xd9,
  0x55, 0x15, 0xc0, 0x19, 0x19, 0xe7, 0xf6, 0x16, 0x44, 0xa0, 0xe4, 0xd4,
  0xfd, 0x27, 0x7f, 0x3f, 0x1b, 0xc6, 0x55, 0x2d, 0xd2, 0x09, 0xed, 0xae,
  0xb8, 0xa5, 0x1b, 0xc0, 0x89, 0xc8, 0x0a, 0x0d, 0x70, 0xa7, 0x86, 0x78,
  0x2d, 0xd1, 0x66, 0xd1, 0xff, 0xd9
};

unsigned char mono_32_32_j2c[] = {
  0x00, 0x00, 0x00, 0xfe, 0x6a, 0x70, 0x32,
  0x63, 0xff, 0x4f, 0xff, 0x51, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0xff, 0x52,
  0x00, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x05, 0x04, 0x04, 0x00, 0x01,
  0xff, 0x5c, 0x00, 0x13, 0x40, 0x08, 0x10, 0x10, 0x18, 0x10, 0x10, 0x18,
  0x10, 0x10, 0x18, 0x10, 0x10, 0x18, 0x10, 0x10, 0x18, 0xff, 0x64, 0x00,
  0x25, 0x00, 0x01, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x20, 0x4f, 0x70, 0x65, 0x6e, 0x4a, 0x50, 0x45, 0x47, 0x20, 0x76,
  0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x32, 0x2e, 0x33, 0x2e, 0x31,
  0xff, 0x90, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x01,
  0xff, 0x93, 0xd0, 0x80, 0x03, 0xdd, 0x06, 0x43, 0x10, 0x80, 0x07, 0x07,
  0x07, 0xa4, 0x53, 0xa1, 0x00, 0x02, 0x7f, 0x0e, 0x1e, 0xc8, 0xe4, 0x93,
  0xa2, 0x80, 0x02, 0xc3, 0xe6, 0x14, 0x37, 0x8d, 0x15, 0x21, 0xb8, 0x50,
  0x11, 0xf7, 0xca, 0xc9, 0x53, 0x13, 0x80, 0x0e, 0x38, 0x92, 0x1b, 0x0b,
  0x8e, 0xb9, 0x57, 0x24, 0x4a, 0xff, 0x7f, 0x17, 0xde, 0x06, 0x1c, 0xc9,
  0x2f, 0xe3, 0x94, 0xc7, 0x19, 0xb2, 0x78, 0xe2, 0x5c, 0x6f, 0xbf, 0xca,
  0xd9, 0x55, 0x15, 0xc0, 0x19, 0x19, 0xe7, 0xf6, 0x16, 0x44, 0xa0, 0xe4,
  0xd4, 0xfd, 0x27, 0x7f, 0x3f, 0x1b, 0xc6, 0x55, 0x2d, 0xd2, 0x09, 0xed,
  0xae, 0xb8, 0xa5, 0x1b, 0xc0, 0x89, 0xc8, 0x0a, 0x0d, 0x70, 0xa7, 0x86,
  0x78, 0x2d, 0xd1, 0x66, 0xd1, 0xff, 0xd9
};

unsigned char mono_32_32_jp2[] = {
  0x00, 0x00, 0x00, 0x0c, 0x6a, 0x50, 0x20, 0x20, 0x0d, 0x0a, 0x87, 0x0a,
  0x00, 0x00, 0x00, 0x14, 0x66, 0x74, 0x79, 0x70, 0x6a, 0x70, 0x32, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x6a, 0x70, 0x32, 0x20, 0x00, 0x00, 0x00, 0x2d,
  0x6a, 0x70, 0x32, 0x68, 0x00, 0x00, 0x00, 0x16, 0x69, 0x68, 0x64, 0x72,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x01, 0x00, 0x07,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x63, 0x6f, 0x6c, 0x72, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0xfe, 0x6a, 0x70, 0x32,
  0x63, 0xff, 0x4f, 0xff, 0x51, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0xff, 0x52,
  0x00, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x05, 0x04, 0x04, 0x00, 0x01,
  0xff, 0x5c, 0x00, 0x13, 0x40, 0x08, 0x10, 0x10, 0x18, 0x10, 0x10, 0x18,
  0x10, 0x10, 0x18, 0x10, 0x10, 0x18, 0x10, 0x10, 0x18, 0xff, 0x64, 0x00,
  0x25, 0x00, 0x01, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x20, 0x4f, 0x70, 0x65, 0x6e, 0x4a, 0x50, 0x45, 0x47, 0x20, 0x76,
  0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x32, 0x2e, 0x33, 0x2e, 0x31,
  0xff, 0x90, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x01,
  0xff, 0x93, 0xd0, 0x80, 0x03, 0xdd, 0x06, 0x43, 0x10, 0x80, 0x07, 0x07,
  0x07, 0xa4, 0x53, 0xa1, 0x00, 0x02, 0x7f, 0x0e, 0x1e, 0xc8, 0xe4, 0x93,
  0xa2, 0x80, 0x02, 0xc3, 0xe6, 0x14, 0x37, 0x8d, 0x15, 0x21, 0xb8, 0x50,
  0x11, 0xf7, 0xca, 0xc9, 0x53, 0x13, 0x80, 0x0e, 0x38, 0x92, 0x1b, 0x0b,
  0x8e, 0xb9, 0x57, 0x24, 0x4a, 0xff, 0x7f, 0x17, 0xde, 0x06, 0x1c, 0xc9,
  0x2f, 0xe3, 0x94, 0xc7, 0x19, 0xb2, 0x78, 0xe2, 0x5c, 0x6f, 0xbf, 0xca,
  0xd9, 0x55, 0x15, 0xc0, 0x19, 0x19, 0xe7, 0xf6, 0x16, 0x44, 0xa0, 0xe4,
  0xd4, 0xfd, 0x27, 0x7f, 0x3f, 0x1b, 0xc6, 0x55, 0x2d, 0xd2, 0x09, 0xed,
  0xae, 0xb8, 0xa5, 0x1b, 0xc0, 0x89, 0xc8, 0x0a, 0x0d, 0x70, 0xa7, 0x86,
  0x78, 0x2d, 0xd1, 0x66, 0xd1, 0xff, 0xd9
};

static gboolean
verify_buffer (buffer_verify_data_s * vdata, GstBuffer * buffer)
{
  if (!vdata->discard) {
    GstMapInfo map;
    if (gst_buffer_map (buffer, &map, GST_MAP_READ)) {
      if (ctx_sink_template == &sinktemplate_mono_jpc &&
          ctx_src_template == &srctemplate_j2c) {
        fail_unless (map.size == jpge2000_codec_data_size - 8);
      }
      gst_buffer_unmap (buffer, &map);
    }
    return TRUE;
  }

  return FALSE;
}

GST_START_TEST (test_parse_normal)
{
  gst_parser_test_normal (jpeg2000_codec_data, jpge2000_codec_data_size);
}

GST_END_TEST;

static Suite *
jpeg2000parse_suite (const char *suite_name)
{
  Suite *s = suite_create (suite_name);
  TCase *tc_chain = tcase_create ("general");

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_parse_normal);
  return s;
}

static int
run_test_suite (guint8 * data, gsize size,
    GstStaticPadTemplate * src_templ, GstStaticPadTemplate * sink_templ,
    const gchar * name)
{
  Suite *s;

  ctx_sink_template = sink_templ;
  ctx_src_template = src_templ;
  jpeg2000_codec_data = data;
  jpge2000_codec_data_size = size;
  s = jpeg2000parse_suite (name);
  return gst_check_run_suite (s, name, __FILE__ "_normal.c");
}

int
main (int argc, char **argv)
{
  int nf = 0;

  gst_check_init (&argc, &argv);

  ctx_factory = "jpeg2000parse";
  ctx_no_metadata = TRUE;
  ctx_frame_generated = FALSE;

  nf +=
      run_test_suite (mono_32_32_j2k, sizeof (mono_32_32_j2k), &srctemplate_jpc,
      &sinktemplate_mono_jpc, "mono jpc to jpc");
  nf +=
      run_test_suite (rgb_32_32_j2k, sizeof (rgb_32_32_j2k), &srctemplate_jpc,
      &sinktemplate_rgb_jpc, "rgb jpc to jpc");
  nf +=
      run_test_suite (mono_32_32_j2c, sizeof (mono_32_32_j2c), &srctemplate_j2c,
      &sinktemplate_mono_j2c, "mono j2c to j2c");
  nf +=
      run_test_suite (rgb_32_32_j2c, sizeof (rgb_32_32_j2c), &srctemplate_j2c,
      &sinktemplate_rgb_j2c, "rgb j2c to j2c");


  /* downstream buffer size may differ from upstream size in the following tests */
  ctx_verify_buffer = verify_buffer;
  nf +=
      run_test_suite (mono_32_32_j2c, sizeof (mono_32_32_j2c), &srctemplate_j2c,
      &sinktemplate_mono_jpc, "mono j2c to jpc");
  nf +=
      run_test_suite (rgb_32_32_j2c, sizeof (rgb_32_32_j2c), &srctemplate_j2c,
      &sinktemplate_rgb_jpc, "rgb j2c to jpc");
  nf +=
      run_test_suite (mono_32_32_jp2, sizeof (mono_32_32_jp2), &srctemplate_jp2,
      &sinktemplate_mono_jpc, "mono jp2 to jpc");
  nf +=
      run_test_suite (rgb_32_32_jp2, sizeof (rgb_32_32_jp2), &srctemplate_jp2,
      &sinktemplate_rgb_jpc, "rgb jp2 to jpc");
  nf +=
      run_test_suite (mono_32_32_jp2, sizeof (mono_32_32_jp2), &srctemplate_jp2,
      &sinktemplate_mono_j2c, "mono jp2 to j2c");
  nf +=
      run_test_suite (rgb_32_32_jp2, sizeof (rgb_32_32_jp2), &srctemplate_jp2,
      &sinktemplate_rgb_j2c, "rgb jp2 to j2c");


  return nf;
}
