// Generated by gmmproc 2.66.7 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/window.h>
#include <gdkmm/private/window_p.h>


/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gdk/gdk.h>
#include <gdkmm/cursor.h>
#include <gdkmm/device.h>
#include <gdkmm/types.h>
#include <gdkmm/glcontext.h>
#include <gdkmm/drawingcontext.h>
#include <gdkmm/frameclock.h>

namespace Gdk
{

Window::Window(const Glib::RefPtr<Window>& parent, GdkWindowAttr* attributes, int attributes_mask)
:
  Glib::Object((GObject*) gdk_window_new(Glib::unwrap(parent), attributes, attributes_mask))
{
  //GdkWindow is X11/win32-specific, so we probably can't derived our own GType.
}

void Window::set_cursor()
{
  gdk_window_set_cursor(gobj(), nullptr);
}

void Window::set_device_cursor(const Glib::RefPtr<Gdk::Device>& device)
{
  gdk_window_set_device_cursor(gobj(), Glib::unwrap(device), nullptr);
}

void Window::unset_icon()
{
  gdk_window_set_icon_name(gobj(), nullptr); /* See GDK docs */
}

void Window::invalidate(bool invalidate_children)
{
  gdk_window_invalidate_rect(gobj(), nullptr, invalidate_children);
}

void Window::restack(bool above)
{
  gdk_window_restack(gobj(), nullptr, above);
}

Glib::RefPtr<DragContext> Window::drag_begin (const std::vector<Glib::ustring>& targets)
{
  return Glib::wrap (gdk_drag_begin (gobj (), Glib::ListHandler<Glib::ustring, AtomUstringTraits>::vector_to_list(targets).data ()), true);
}

DragProtocol Window::get_drag_protocol(Glib::RefPtr<Window>& target) const
{
  GdkWindow* window = nullptr;
  auto result = gdk_window_get_drag_protocol(
    const_cast<GdkWindow*>(gobj()),
    &window);

  target = Glib::wrap(window, true /* take ref */);
  return (DragProtocol)result;
}

DragProtocol Window::get_drag_protocol() const
{
  return (DragProtocol)gdk_window_get_drag_protocol(
    const_cast<GdkWindow*>(gobj()),
    nullptr);
}

} // namespace Gdk

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::WindowState>::value_type()
{
  return gdk_window_state_get_type();
}

// static
GType Glib::Value<Gdk::WindowType>::value_type()
{
  return gdk_window_type_get_type();
}

// static
GType Glib::Value<Gdk::WindowAttributesType>::value_type()
{
  return gdk_window_attributes_type_get_type();
}

// static
GType Glib::Value<Gdk::WindowHints>::value_type()
{
  return gdk_window_hints_get_type();
}

// static
GType Glib::Value<Gdk::WindowTypeHint>::value_type()
{
  return gdk_window_type_hint_get_type();
}

// static
GType Glib::Value<Gdk::WMDecoration>::value_type()
{
  return gdk_wm_decoration_get_type();
}

// static
GType Glib::Value<Gdk::WMFunction>::value_type()
{
  return gdk_wm_function_get_type();
}

// static
GType Glib::Value<Gdk::WindowEdge>::value_type()
{
  return gdk_window_edge_get_type();
}

// static
GType Glib::Value<Gdk::Gravity>::value_type()
{
  return gdk_gravity_get_type();
}

// static
GType Glib::Value<Gdk::AnchorHints>::value_type()
{
  return gdk_anchor_hints_get_type();
}

// static
GType Glib::Value<Gdk::FullscreenMode>::value_type()
{
  return gdk_fullscreen_mode_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::Window> wrap(GdkWindow* object, bool take_copy)
{
  return Glib::RefPtr<Gdk::Window>( dynamic_cast<Gdk::Window*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Window_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Window_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_window_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Window_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Window_Class::wrap_new(GObject* object)
{
  return new Window((GdkWindow*)object);
}


/* The implementation: */

GdkWindow* Window::gobj_copy()
{
  reference();
  return gobj();
}

Window::Window(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Window::Window(GdkWindow* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Window::Window(Window&& src) noexcept
: Glib::Object(std::move(src))
{}

Window& Window::operator=(Window&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


Window::~Window() noexcept
{}


Window::CppClassType Window::window_class_; // initialize static member

GType Window::get_type()
{
  return window_class_.init().get_type();
}


GType Window::get_base_type()
{
  return gdk_window_get_type();
}


Glib::RefPtr<Window> Window::create(const Glib::RefPtr<Window>& parent, GdkWindowAttr* attributes, int attributes_mask)
{
  return Glib::RefPtr<Window>( new Window(parent, attributes, attributes_mask) );
}

WindowType Window::get_window_type() const
{
  return ((WindowType)(gdk_window_get_window_type(const_cast<GdkWindow*>(gobj()))));
}

Glib::RefPtr<Visual> Window::get_visual()
{
  Glib::RefPtr<Visual> retvalue = Glib::wrap(gdk_window_get_visual(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Visual> Window::get_visual() const
{
  return const_cast<Window*>(this)->get_visual();
}

Glib::RefPtr<Screen> Window::get_screen()
{
  Glib::RefPtr<Screen> retvalue = Glib::wrap(gdk_window_get_screen(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Screen> Window::get_screen() const
{
  return const_cast<Window*>(this)->get_screen();
}

Glib::RefPtr<Display> Window::get_display()
{
  Glib::RefPtr<Display> retvalue = Glib::wrap(gdk_window_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Display> Window::get_display() const
{
  return const_cast<Window*>(this)->get_display();
}

void Window::show()
{
  gdk_window_show(gobj());
}

void Window::hide()
{
  gdk_window_hide(gobj());
}

void Window::withdraw()
{
  gdk_window_withdraw(gobj());
}

void Window::show_unraised()
{
  gdk_window_show_unraised(gobj());
}

void Window::move(int x, int y)
{
  gdk_window_move(gobj(), x, y);
}

void Window::resize(int width, int height)
{
  gdk_window_resize(gobj(), width, height);
}

void Window::move_resize(int x, int y, int width, int height)
{
  gdk_window_move_resize(gobj(), x, y, width, height);
}

void Window::reparent(const Glib::RefPtr<Window>& new_parent, int x, int y)
{
  gdk_window_reparent(gobj(), Glib::unwrap(new_parent), x, y);
}

void Window::raise()
{
  gdk_window_raise(gobj());
}

void Window::lower()
{
  gdk_window_lower(gobj());
}

void Window::restack(const Glib::RefPtr<Window>& sibling, bool above)
{
  gdk_window_restack(gobj(), Glib::unwrap(sibling), static_cast<int>(above));
}

void Window::focus(guint32 timestamp)
{
  gdk_window_focus(gobj(), timestamp);
}

void Window::set_user_data(gpointer user_data)
{
  gdk_window_set_user_data(gobj(), user_data);
}

void Window::set_override_redirect(bool override_redirect)
{
  gdk_window_set_override_redirect(gobj(), static_cast<int>(override_redirect));
}

void Window::add_filter(GdkFilterFunc function, gpointer data)
{
  gdk_window_add_filter(gobj(), function, data);
}

void Window::remove_filter(GdkFilterFunc function, gpointer data)
{
  gdk_window_remove_filter(gobj(), function, data);
}

void Window::scroll(int dx, int dy)
{
  gdk_window_scroll(gobj(), dx, dy);
}

void Window::move_region(const ::Cairo::RefPtr< ::Cairo::Region>& region, int dx, int dy)
{
  gdk_window_move_region(gobj(), ((region) ? (region)->cobj() : nullptr), dx, dy);
}

bool Window::ensure_native()
{
  return gdk_window_ensure_native(gobj());
}

void Window::shape_combine_region(const ::Cairo::RefPtr< ::Cairo::Region>& shape_region, int offset_x, int offset_y)
{
  gdk_window_shape_combine_region(gobj(), ((shape_region) ? (shape_region)->cobj() : nullptr), offset_x, offset_y);
}

void Window::set_child_shapes()
{
  gdk_window_set_child_shapes(gobj());
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
bool Window::get_composited() const
{
  return gdk_window_get_composited(const_cast<GdkWindow*>(gobj()));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::set_composited(bool composited)
{
  gdk_window_set_composited(gobj(), static_cast<int>(composited));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

void Window::merge_child_shapes()
{
  gdk_window_merge_child_shapes(gobj());
}

void Window::input_shape_combine_region(const ::Cairo::RefPtr< ::Cairo::Region>& shape_region, int offset_x, int offset_y)
{
  gdk_window_input_shape_combine_region(gobj(), ((shape_region) ? (shape_region)->cobj() : nullptr), offset_x, offset_y);
}

void Window::set_child_input_shapes()
{
  gdk_window_set_child_input_shapes(gobj());
}

void Window::merge_child_input_shapes()
{
  gdk_window_merge_child_input_shapes(gobj());
}

void Window::set_pass_through(bool pass_through)
{
  gdk_window_set_pass_through(gobj(), static_cast<int>(pass_through));
}

bool Window::get_pass_through() const
{
  return gdk_window_get_pass_through(const_cast<GdkWindow*>(gobj()));
}

bool Window::is_visible() const
{
  return gdk_window_is_visible(const_cast<GdkWindow*>(gobj()));
}

bool Window::is_viewable() const
{
  return gdk_window_is_viewable(const_cast<GdkWindow*>(gobj()));
}

bool Window::is_input_only() const
{
  return gdk_window_is_input_only(const_cast<GdkWindow*>(gobj()));
}

bool Window::is_shaped() const
{
  return gdk_window_is_shaped(const_cast<GdkWindow*>(gobj()));
}

WindowState Window::get_state() const
{
  return ((WindowState)(gdk_window_get_state(const_cast<GdkWindow*>(gobj()))));
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
bool Window::set_static_gravities(bool use_static)
{
  return gdk_window_set_static_gravities(gobj(), static_cast<int>(use_static));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

bool Window::has_native() const
{
  return gdk_window_has_native(const_cast<GdkWindow*>(gobj()));
}

void Window::set_type_hint(WindowTypeHint hint)
{
  gdk_window_set_type_hint(gobj(), ((GdkWindowTypeHint)(hint)));
}

WindowTypeHint Window::get_type_hint()
{
  return ((WindowTypeHint)(gdk_window_get_type_hint(gobj())));
}

bool Window::get_modal_hint() const
{
  return gdk_window_get_modal_hint(const_cast<GdkWindow*>(gobj()));
}

void Window::set_modal_hint(bool modal)
{
  gdk_window_set_modal_hint(gobj(), static_cast<int>(modal));
}

void Window::set_geometry_hints(const Geometry& geometry, WindowHints geom_mask)
{
  gdk_window_set_geometry_hints(gobj(), &(geometry), ((GdkWindowHints)(geom_mask)));
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::begin_paint_rect(const Rectangle& rectangle)
{
  gdk_window_begin_paint_rect(gobj(), (rectangle).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::begin_paint_region(const ::Cairo::RefPtr< ::Cairo::Region>& region)
{
  gdk_window_begin_paint_region(gobj(), ((region) ? (region)->cobj() : nullptr));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::end_paint()
{
  gdk_window_end_paint(gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::flush()
{
  gdk_window_flush(gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

void Window::set_title(const Glib::ustring& title)
{
  gdk_window_set_title(gobj(), title.c_str());
}

void Window::set_role(const Glib::ustring& role)
{
  gdk_window_set_role(gobj(), role.c_str());
}

void Window::set_startup_id(const Glib::ustring& startup_id)
{
  gdk_window_set_startup_id(gobj(), startup_id.c_str());
}

void Window::set_transient_for(const Glib::RefPtr<Window>& parent)
{
  gdk_window_set_transient_for(gobj(), Glib::unwrap(parent));
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::set_background(const Color& color)
{
  gdk_window_set_background(gobj(), (color).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::set_background(const RGBA& rgba)
{
  gdk_window_set_background_rgba(gobj(), (rgba).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::set_background(const ::Cairo::RefPtr< ::Cairo::Pattern>& pattern)
{
  gdk_window_set_background_pattern(gobj(), (pattern)->cobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
::Cairo::RefPtr< ::Cairo::Pattern> Window::get_background_pattern()
{
  return ::Cairo::RefPtr< ::Cairo::Pattern>(new ::Cairo::Pattern(gdk_window_get_background_pattern(gobj()), false /* take reference */));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
::Cairo::RefPtr<const ::Cairo::Pattern> Window::get_background_pattern() const
{
  return ::Cairo::RefPtr<const ::Cairo::Pattern>(new ::Cairo::Pattern(gdk_window_get_background_pattern(const_cast<GdkWindow*>(gobj())), false /* take reference */));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

void Window::set_cursor(const Glib::RefPtr<Cursor>& cursor)
{
  gdk_window_set_cursor(gobj(), Glib::unwrap(cursor));
}

void Window::set_device_cursor(const Glib::RefPtr<Device>& device, const Glib::RefPtr<Cursor>& cursor)
{
  gdk_window_set_device_cursor(gobj(), Glib::unwrap(device), Glib::unwrap(cursor));
}

Glib::RefPtr<Cursor> Window::get_device_cursor(const Glib::RefPtr<Device>& device)
{
  Glib::RefPtr<Cursor> retvalue = Glib::wrap(gdk_window_get_device_cursor(gobj(), Glib::unwrap(device)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Cursor> Window::get_device_cursor(const Glib::RefPtr<const Device>& device) const
{
  Glib::RefPtr<const Cursor> retvalue = Glib::wrap(gdk_window_get_device_cursor(const_cast<GdkWindow*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device))));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Cursor> Window::get_cursor()
{
  Glib::RefPtr<Cursor> retvalue = Glib::wrap(gdk_window_get_cursor(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Cursor> Window::get_cursor() const
{
  return const_cast<Window*>(this)->get_cursor();
}

void Window::get_user_data(gpointer* data)
{
  gdk_window_get_user_data(gobj(), data);
}

void Window::get_geometry(int& x, int& y, int& width, int& height) const
{
  gdk_window_get_geometry(const_cast<GdkWindow*>(gobj()), &(x), &(y), &(width), &(height));
}

int Window::get_width() const
{
  return gdk_window_get_width(const_cast<GdkWindow*>(gobj()));
}

int Window::get_height() const
{
  return gdk_window_get_height(const_cast<GdkWindow*>(gobj()));
}

void Window::get_position(int& x, int& y) const
{
  gdk_window_get_position(const_cast<GdkWindow*>(gobj()), &(x), &(y));
}

int Window::get_origin(int& x, int& y) const
{
  return gdk_window_get_origin(const_cast<GdkWindow*>(gobj()), &(x), &(y));
}

void Window::get_root_coords(int x, int y, int& root_x, int& root_y)
{
  gdk_window_get_root_coords(gobj(), x, y, &(root_x), &(root_y));
}

void Window::coords_to_parent(double x, double y, double& parent_x, double& parent_y)
{
  gdk_window_coords_to_parent(gobj(), x, y, &(parent_x), &(parent_y));
}

void Window::coords_from_parent(double parent_x, double parent_y, double& x, double& y)
{
  gdk_window_coords_from_parent(gobj(), parent_x, parent_y, &(x), &(y));
}

void Window::get_root_origin(int& x, int& y) const
{
  gdk_window_get_root_origin(const_cast<GdkWindow*>(gobj()), &(x), &(y));
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::get_frame_extents(Rectangle& rect)
{
  gdk_window_get_frame_extents(gobj(), (rect).gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

void Window::get_frame_extents(Rectangle& rect) const
{
  return const_cast<Window*>(this)->get_frame_extents(rect);
}

int Window::get_scale_factor() const
{
  return gdk_window_get_scale_factor(const_cast<GdkWindow*>(gobj()));
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
Glib::RefPtr<Window> Window::get_pointer(int& x, int& y, ModifierType& mask)
{
  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_window_get_pointer(gobj(), &(x), &(y), ((GdkModifierType*) &(mask))));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

Glib::RefPtr<Window> Window::get_parent()
{
  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_window_get_parent(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Window> Window::get_parent() const
{
  return const_cast<Window*>(this)->get_parent();
}

Glib::RefPtr<Window> Window::get_toplevel()
{
  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_window_get_toplevel(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Window> Window::get_toplevel() const
{
  return const_cast<Window*>(this)->get_toplevel();
}

Glib::RefPtr<Window> Window::get_device_position(const Glib::RefPtr<const Device>& device, int& x, int& y, ModifierType& mask) const
{
  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_window_get_device_position(const_cast<GdkWindow*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)), &(x), &(y), ((GdkModifierType*) &(mask))));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Window> Window::get_device_position(const Glib::RefPtr<const Device>& device, double& x, double& y, ModifierType& mask) const
{
  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_window_get_device_position_double(const_cast<GdkWindow*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)), &(x), &(y), ((GdkModifierType*) &(mask))));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Window> Window::get_effective_parent()
{
  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_window_get_effective_parent(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Window> Window::get_effective_parent() const
{
  return const_cast<Window*>(this)->get_effective_parent();
}

Glib::RefPtr<Window> Window::get_effective_toplevel()
{
  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_window_get_effective_toplevel(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Window> Window::get_effective_toplevel() const
{
  return const_cast<Window*>(this)->get_effective_toplevel();
}

std::vector< Glib::RefPtr<Window> > Window::get_children()
{
  return Glib::ListHandler<Glib::RefPtr<Window> >::list_to_vector(gdk_window_get_children(gobj()), Glib::OWNERSHIP_SHALLOW);
}

std::vector< Glib::RefPtr<const Window> > Window::get_children() const
{
  return Glib::ListHandler<Glib::RefPtr<const Window> >::list_to_vector(gdk_window_get_children(const_cast<GdkWindow*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

EventMask Window::get_events() const
{
  return ((EventMask)(gdk_window_get_events(const_cast<GdkWindow*>(gobj()))));
}

void Window::set_events(EventMask event_mask)
{
  gdk_window_set_events(gobj(), ((GdkEventMask)(event_mask)));
}

EventMask Window::get_device_events(const Glib::RefPtr<const Device>& device) const
{
  return ((EventMask)(gdk_window_get_device_events(const_cast<GdkWindow*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)))));
}

void Window::set_device_events(const Glib::RefPtr<Device>& device, EventMask event_mask)
{
  gdk_window_set_device_events(gobj(), Glib::unwrap(device), ((GdkEventMask)(event_mask)));
}

EventMask Window::get_source_events(InputSource source) const
{
  return ((EventMask)(gdk_window_get_source_events(const_cast<GdkWindow*>(gobj()), ((GdkInputSource)(source)))));
}

void Window::set_source_events(InputSource source, EventMask event_mask)
{
  gdk_window_set_source_events(gobj(), ((GdkInputSource)(source)), ((GdkEventMask)(event_mask)));
}

void Window::set_icon_list(const std::vector< Glib::RefPtr<Gdk::Pixbuf> >& pixbufs)
{
  gdk_window_set_icon_list(gobj(), Glib::ListHandler<Glib::RefPtr<Gdk::Pixbuf> >::vector_to_list(pixbufs).data ());
}

void Window::set_icon_name(const Glib::ustring& name)
{
  gdk_window_set_icon_name(gobj(), name.c_str());
}

void Window::set_group(const Glib::RefPtr<Window>& leader)
{
  gdk_window_set_group(gobj(), Glib::unwrap(leader));
}

Glib::RefPtr<Window> Window::get_group()
{
  return Glib::wrap(gdk_window_get_group(gobj()));
}

Glib::RefPtr<const Window> Window::get_group() const
{
  return const_cast<Window*>(this)->get_group();
}

void Window::set_decorations(WMDecoration decorations)
{
  gdk_window_set_decorations(gobj(), ((GdkWMDecoration)(decorations)));
}

bool Window::get_decorations(WMDecoration& decorations) const
{
  return gdk_window_get_decorations(const_cast<GdkWindow*>(gobj()), ((GdkWMDecoration*) &(decorations)));
}

void Window::set_functions(WMFunction functions)
{
  gdk_window_set_functions(gobj(), ((GdkWMFunction)(functions)));
}

::Cairo::RefPtr< ::Cairo::Surface> Window::create_similar_surface(::Cairo::Content content, int width, int height)
{
  return ::Cairo::RefPtr< ::Cairo::Surface>(new ::Cairo::Surface(gdk_window_create_similar_surface(gobj(), (cairo_content_t)(content), width, height), true /* do not take ref */));
}

::Cairo::RefPtr< ::Cairo::Surface> Window::create_similar_image_surface(::Cairo::Format format, int width, int height, int scale)
{
  return ::Cairo::RefPtr< ::Cairo::Surface>(new ::Cairo::Surface(gdk_window_create_similar_image_surface(gobj(), (cairo_format_t)(format), width, height, scale), true /* do not take ref */));
}

void Window::beep()
{
  gdk_window_beep(gobj());
}

void Window::iconify()
{
  gdk_window_iconify(gobj());
}

void Window::deiconify()
{
  gdk_window_deiconify(gobj());
}

void Window::stick()
{
  gdk_window_stick(gobj());
}

void Window::unstick()
{
  gdk_window_unstick(gobj());
}

void Window::maximize()
{
  gdk_window_maximize(gobj());
}

void Window::unmaximize()
{
  gdk_window_unmaximize(gobj());
}

void Window::register_dnd()
{
  gdk_window_register_dnd(gobj());
}

void Window::begin_resize_drag(WindowEdge edge, int button, int root_x, int root_y, guint32 timestamp)
{
  gdk_window_begin_resize_drag(gobj(), ((GdkWindowEdge)(edge)), button, root_x, root_y, timestamp);
}

void Window::resize_drag(WindowEdge edge, const Glib::RefPtr<Device>& device, int button, int root_x, int root_y, guint32 timestamp)
{
  gdk_window_begin_resize_drag_for_device(gobj(), ((GdkWindowEdge)(edge)), Glib::unwrap(device), button, root_x, root_y, timestamp);
}

void Window::begin_move_drag(int button, int root_x, int root_y, guint32 timestamp)
{
  gdk_window_begin_move_drag(gobj(), button, root_x, root_y, timestamp);
}

void Window::begin_move_drag(const Glib::RefPtr<Device>& device, int button, int root_x, int root_y, guint32 timestamp)
{
  gdk_window_begin_move_drag_for_device(gobj(), Glib::unwrap(device), button, root_x, root_y, timestamp);
}

void Window::invalidate_rect(const Rectangle& rect, bool invalidate_children)
{
  gdk_window_invalidate_rect(gobj(), (rect).gobj(), static_cast<int>(invalidate_children));
}

void Window::invalidate_region(const ::Cairo::RefPtr< ::Cairo::Region>& region, bool invalidate_children)
{
  gdk_window_invalidate_region(gobj(), ((region) ? (region)->cobj() : nullptr), static_cast<int>(invalidate_children));
}

::Cairo::RefPtr< ::Cairo::Region> Window::get_update_area()
{
  return ::Cairo::RefPtr< ::Cairo::Region>(new ::Cairo::Region((gdk_window_get_update_area(gobj())), true /* do not take ref */));
}

void Window::freeze_updates()
{
  gdk_window_freeze_updates(gobj());
}

void Window::thaw_updates()
{
  gdk_window_thaw_updates(gobj());
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::process_all_updates()
{
  gdk_window_process_all_updates();
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::process_updates(bool update_children)
{
  gdk_window_process_updates(gobj(), static_cast<int>(update_children));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::set_debug_updates(bool setting)
{
  gdk_window_set_debug_updates(static_cast<int>(setting));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

void Window::constrain_size(const Geometry& geometry, guint flags, int width, int height, int& new_width, int& new_height)
{
  gdk_window_constrain_size(const_cast<GdkGeometry*>(&(geometry)), (GdkWindowHints)(flags), width, height, &(new_width), &(new_height));
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::enable_synchronized_configure()
{
  gdk_window_enable_synchronized_configure(gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::configure_finished()
{
  gdk_window_configure_finished(gobj());
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

void Window::set_skip_taskbar_hint(bool skips_taskbar)
{
  gdk_window_set_skip_taskbar_hint(gobj(), static_cast<int>(skips_taskbar));
}

void Window::set_skip_pager_hint(bool skips_pager)
{
  gdk_window_set_skip_pager_hint(gobj(), static_cast<int>(skips_pager));
}

void Window::set_urgency_hint(bool urgent)
{
  gdk_window_set_urgency_hint(gobj(), static_cast<int>(urgent));
}

void Window::fullscreen()
{
  gdk_window_fullscreen(gobj());
}

void Window::set_fullscreen_mode(FullscreenMode mode)
{
  gdk_window_set_fullscreen_mode(gobj(), ((GdkFullscreenMode)(mode)));
}

FullscreenMode Window::get_fullscreen_mode() const
{
  return ((FullscreenMode)(gdk_window_get_fullscreen_mode(const_cast<GdkWindow*>(gobj()))));
}

void Window::unfullscreen()
{
  gdk_window_unfullscreen(gobj());
}

void Window::set_keep_above(bool setting)
{
  gdk_window_set_keep_above(gobj(), static_cast<int>(setting));
}

void Window::set_keep_below(bool setting)
{
  gdk_window_set_keep_below(gobj(), static_cast<int>(setting));
}

void Window::set_opacity(double opacity)
{
  gdk_window_set_opacity(gobj(), opacity);
}

bool Window::get_accept_focus() const
{
  return gdk_window_get_accept_focus(const_cast<GdkWindow*>(gobj()));
}

void Window::set_accept_focus(bool accept_focus)
{
  gdk_window_set_accept_focus(gobj(), static_cast<int>(accept_focus));
}

bool Window::get_focus_on_map() const
{
  return gdk_window_get_focus_on_map(const_cast<GdkWindow*>(gobj()));
}

void Window::set_focus_on_map(bool focus_on_map)
{
  gdk_window_set_focus_on_map(gobj(), static_cast<int>(focus_on_map));
}

Glib::RefPtr<Window> Window::get_default_root_window()
{

  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_get_default_root_window());
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us
  return retvalue;
}

::Cairo::RefPtr< ::Cairo::Surface> Window::get_offscreen_surface()
{
  ::Cairo::RefPtr< ::Cairo::Surface> retvalue = ::Cairo::RefPtr< ::Cairo::Surface>(new ::Cairo::Surface(gdk_offscreen_window_get_surface(gobj()), true /* do not take ref */));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

::Cairo::RefPtr<const ::Cairo::Surface> Window::get_offscreen_surface() const
{
  return const_cast<Window*>(this)->get_offscreen_surface();
}

Glib::RefPtr<Window> Window::get_offscreen_embedder()
{
  Glib::RefPtr<Window> retvalue = Glib::wrap(gdk_offscreen_window_get_embedder(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Window> Window::get_offscreen_embedder() const
{
  return const_cast<Window*>(this)->get_offscreen_embedder();
}

void Window::set_offscreen_embedder(const Glib::RefPtr<Window>& embedder)
{
  gdk_offscreen_window_set_embedder(gobj(), Glib::unwrap(embedder));
}

void Window::geometry_changed()
{
  gdk_window_geometry_changed(gobj());
}

void Window::set_support_multidevice(bool support_multidevice)
{
  gdk_window_set_support_multidevice(gobj(), static_cast<int>(support_multidevice));
}

bool Window::get_support_multidevice()
{
  return gdk_window_get_support_multidevice(gobj());
}

Glib::RefPtr<FrameClock> Window::get_frame_clock()
{
  Glib::RefPtr<FrameClock> retvalue = Glib::wrap(gdk_window_get_frame_clock(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const FrameClock> Window::get_frame_clock() const
{
  return const_cast<Window*>(this)->get_frame_clock();
}

::Cairo::RefPtr< ::Cairo::Region> Window::get_clip_region() const
{
  return ::Cairo::RefPtr< ::Cairo::Region>(new ::Cairo::Region(gdk_window_get_clip_region(const_cast<GdkWindow*>(gobj())), true /* do not take ref */));
}

::Cairo::RefPtr< ::Cairo::Region> Window::get_visible_region() const
{
  return ::Cairo::RefPtr< ::Cairo::Region>(new ::Cairo::Region(gdk_window_get_visible_region(const_cast<GdkWindow*>(gobj())), true /* do not take ref */));
}

#ifndef GDKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
::Cairo::RefPtr< ::Cairo::Context> Window::create_cairo_context()
{
  return ::Cairo::RefPtr< ::Cairo::Context>(new ::Cairo::Context(gdk_cairo_create(gobj()), true /* has_reference */));
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GDKMM_DISABLE_DEPRECATED

void Window::set_opaque_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  gdk_window_set_opaque_region(gobj(), const_cast<cairo_region_t*>((region) ? (region)->cobj() : nullptr));
}

void Window::set_event_compression(bool event_compression)
{
  gdk_window_set_event_compression(gobj(), static_cast<int>(event_compression));
}

bool Window::get_event_compression() const
{
  return gdk_window_get_event_compression(const_cast<GdkWindow*>(gobj()));
}

void Window::set_shadow_width(int left, int right, int top, int bottom)
{
  gdk_window_set_shadow_width(gobj(), left, right, top, bottom);
}

bool Window::show_window_menu(GdkEvent* event)
{
  return gdk_window_show_window_menu(gobj(), event);
}

Glib::RefPtr<Gdk::GLContext> Window::create_gl_context()
{
  GError* gerror = nullptr;
  Glib::RefPtr<Gdk::GLContext> retvalue = Glib::wrap(gdk_window_create_gl_context(gobj(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<DrawingContext> Window::begin_draw_frame(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  Glib::RefPtr<DrawingContext> retvalue = Glib::wrap(gdk_window_begin_draw_frame(gobj(), ((region) ? (region)->cobj() : nullptr)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Window::end_draw_frame(const Glib::RefPtr<DrawingContext>& context)
{
  gdk_window_end_draw_frame(gobj(), Glib::unwrap(context));
}


Glib::PropertyProxy< Glib::RefPtr<Cursor> > Window::property_cursor() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Cursor> >(this, "cursor");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Cursor> > Window::property_cursor() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Cursor> >(this, "cursor");
}


} // namespace Gdk


