[![main](https://github.com/ispc/ispc/actions/workflows/pre-release-artifacts.yml/badge.svg)](https://github.com/ispc/ispc/actions/workflows/pre-release-artifacts.yml)
[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause)

[![OpenSSF Best Practices](https://www.bestpractices.dev/projects/9395/badge)](https://www.bestpractices.dev/projects/9395)
[![OpenSSF Scorecard](https://api.securityscorecards.dev/projects/github.com/ispc/ispc/badge)](https://securityscorecards.dev/viewer/?uri=github.com/ispc/ispc)
[![Bandit](https://github.com/ispc/ispc/actions/workflows/bandit.yml/badge.svg)](https://github.com/ispc/ispc/actions/workflows/bandit.yml)
[![Coverity](https://scan.coverity.com/projects/30508/badge.svg)](https://scan.coverity.com/projects/intel-ispc)
[![Trivy](https://github.com/ispc/ispc/actions/workflows/trivy.yml/badge.svg)](https://github.com/ispc/ispc/actions/workflows/trivy.yml)
[![Cve-bin](https://github.com/ispc/ispc/actions/workflows/cve-bin.yml/badge.svg)](https://github.com/ispc/ispc/actions/workflows/cve-bin.yml)
[![ClamAV](https://github.com/ispc/ispc/actions/workflows/clamav.yml/badge.svg)](https://github.com/ispc/ispc/actions/workflows/clamav.yml)
[![Hardening Checks](https://github.com/ispc/ispc/actions/workflows/hardening-check.yml/badge.svg)](https://github.com/ispc/ispc/actions/workflows/hardening-check.yml)

[![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://github.com/codespaces/new?hide_repo_select=true&ref=main&repo=1931356)

# Intel® Implicit SPMD Program Compiler (Intel® ISPC)

`ispc` is a compiler for a variant of the C programming language, with
extensions for [single program, multiple
data](http://en.wikipedia.org/wiki/SPMD) programming.  Under the SPMD model,
the programmer writes a program that generally appears to be a regular serial
program, though the execution model is actually that a number of *program
instances* execute in parallel on the hardware.

## Overview

`ispc` compiles a C-based SPMD programming language to run on the SIMD units of
CPUs and GPUs; it frequently provides a 3x or more speedup on architectures
with 4-wide vector SSE units and 5x-6x on architectures with 8-wide AVX vector
units, without any of the difficulty of writing intrinsics code.
Parallelization across multiple cores is also supported by `ispc`, making it
possible to write programs that achieve performance improvement that scales by
both number of cores and vector unit size.

There are a few key principles in the design of `ispc`:

  * To build a small set of extensions to the C language that would deliver
    excellent performance to performance-oriented programmers who want to run
    SPMD programs on the CPU and GPU.

  * To provide a thin abstraction layer between the programmer and the
    hardware--in particular, to have an execution and data model where the
    programmer can cleanly reason about the mapping of their source program to
    compiled assembly language and the underlying hardware.

  * To make it possible to harness the computational power of SIMD vector units
    without the extremely low-programmer-productivity activity of directly
    writing intrinsics.

  * To explore opportunities from close coupling between C/C++ application code
    and SPMD `ispc` code running on the same processor--to have lightweight
    function calls between the two languages and to share data directly via
    pointers without copying or reformatting.

`ispc` is an open source compiler with the BSD license.  It uses the remarkable
[LLVM Compiler Infrastructure](http://llvm.org) for back-end code generation
and optimization and is [hosted on github](http://github.com/ispc/ispc). It
supports Windows, macOS, and Linux as a host operating system and also capable
to target Android, iOS, and PS4/PS5.  It currently supports multiple flavours
of x86 (SSE2, SSE4, AVX, AVX2, and AVX512), ARM (NEON), and Intel® GPU
architectures (Gen9 and Xe family).

## Features

`ispc` provides a number of key features to developers:

  * Familiarity as an extension of the C programming language: `ispc` supports
    familiar C syntax and programming idioms, while adding the ability to write
    SPMD programs.

  * High-quality SIMD code generation: the performance of code generated by
    `ispc` is often close to that of hand-written intrinsics code.

  * Ease of adoption with existing software systems: functions written in
    `ispc` directly interoperate with application functions written in C/C++
    and with application data structures.
            
  * Portability across over a decade of CPU generations: `ispc` has targets for
    x86 SSE2, SSE4, AVX, AVX2, and AVX512, as well as ARM NEON and recent
    Intel® GPUs.

  * Portability across operating systems: Microsoft Windows, macOS, Linux, and
    FreeBSD are all supported by `ispc`.

  * Debugging with standard tools: `ispc` programs can be debugged with
    standard debuggers.

## Installation
### Official Release Binaries

You can download the official release binaries from [the latest release
page](https://github.com/ispc/ispc/releases/latest). Choose the appropriate version
for your operating system and architecture.

### Linux (Snap Store)

Linux users can install `ispc` using the Snap Store:

```bash
snap install ispc
```

### Other Package Managers

Thanks to community support, `ispc` is also available through a variety of
package managers on multiple operating systems.

### Windows

To install `ispc` on Windows, you can download the latest release as `zip`
archive from
[the latest release page](https://github.com/ispc/ispc/releases/latest).
Then you need to unpack that to some directory. It is user's responsibility to
set-up permissions for this directory according to the principle of least
privilege.

Moreover, `ispc` depends on run-time components of Visual C++ (DLLs). These
libraries can be installed with Microsoft Visual C++ Redistributable package.
Instruction to install them can be found
[here](https://learn.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist).

## Development Guide

If you're interested in contributing to `ispc` or building it from source,
this section will help you get started.

### GitHub Codespaces

The fastest way to get a development environment set up is through GitHub
Codespaces. This provides a fully configured environment in the cloud, with all
dependencies pre-installed. Codespaces gives you a browser-based development
environment with everything you need to build, test, and debug ISPC. Click the
following button to open Codespaces with configured `ispc`:

[![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://github.com/codespaces/new?hide_repo_select=true&ref=main&repo=1931356)

### Building From Source

For detailed instructions on how to build ISPC from source on different
platforms, please refer to our
[ISPC Development Guide](https://github.com/ispc/ispc/wiki/ISPC-Development-Guide)
for build and test instructions.

## Additional Resources

Latest `ispc` binaries corresponding to `main` branch can be downloaded from
the Github release page for
[Linux](https://github.com/ispc/ispc/releases/download/trunk-artifacts/ispc-trunk-linux.tar.gz)
and
[Windows](https://github.com/ispc/ispc/releases/download/trunk-artifacts/ispc-trunk-windows.zip)
See also additional [documentation](https://ispc.github.io/documentation.html)
and additional [performance information](https://ispc.github.io/perf.html).  If
you have a bug report and have a question, you are welcome to open an
[issue](https://github.com/ispc/ispc/issues) or start a
[discussion](https://github.com/ispc/ispc/discussions) on GitHub.
