/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2022 Mikolaj Wielgus
 * Copyright (C) 2023 KiCad Developers, see AUTHORS.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <sim/sim_model_ngspice.h>


void NGSPICE_MODEL_INFO_MAP::addBSIM3()
{
    modelInfos[MODEL_TYPE::BSIM3] = { "BSIM3", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley Short Channel IGFET Model Version-3", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "capmod",  100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "3", "3", "Capacitance model selector" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "mobmod",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Mobility model selector" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noimod",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Noise model selector" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nqsmod_",  210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-quasi-static const model selector" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "acnqsmod_",  211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "AC NQS model selector" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "acm",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Area calculation method selector" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "calcacm",  102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Area calculation method ACM=12" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model parameter checking selector" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "binunit",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_STRING, "", SIM_MODEL::PARAM::CATEGORY::DC, "3.3.0", "3.3.0", "parameter for model version" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tox",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-08", "1.5e-08", "Gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "toxm",  201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-08", "1.5e-08", "Gate oxide thickness used in extraction" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cdsc",  106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cdscb",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cit",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nfactor",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xj",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.5e-07", "1.5e-07", "Junction depth in meters" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vsat",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "at",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "a0",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "a1",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "a2",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "keta",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.047", "-0.047", "Body-bias coefficient of non-uniform depletion width effect." );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nsub",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nch",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ngate",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "gamma1",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "gamma2",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbx",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbm",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xt",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "80", "80", "Narrow width effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nlx",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Lateral non-uniform doping effect" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.25e-09", "2.25e-09", "Linear gate dependence of mobility" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "4.31e-09", "4.31e-09", "Temperature coefficient of ua" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5.87e-19", "5.87e-19", "Quadratic gate dependence of mobility" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-7.61e-18", "-7.61e-18", "Temperature coefficient of ub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tnom",  651, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgso",  652, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-source overlap capacitance per width" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgdo",  653, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-drain overlap capacitance per width" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgbo",  654, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate-bulk overlap capacitance per length" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xpart",  655, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "elm",  185, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "Non-quasi-static const Elmore Constant Parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rsh",  656, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain resistance per width" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bias effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pscbe1",  166, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "4.24e+08", "4.24e+08", "Substrate current body-effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pscbe2",  167, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Substrate current body-effect coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "js",  657, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0.0001", "0.0001", "Source/drain junction reverse saturation current density" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "jsw",  696, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A/m²", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Sidewall junction reverse saturation current density" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pb",  658, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain junction built-in potential" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nj",  691, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Source/drain junction emission coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xti",  692, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "3", "3", "Junction current temperature exponent" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "mj",  659, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source/drain bottom junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pbsw",  660, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Source/drain sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "mjsw",  661, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source/drain sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pbswg",  693, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1", "1", "Source/drain (gate side) sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "mjswg",  694, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.33", "0.33", "Source/drain (gate side) sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cj",  662, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.0005", "0.0005", "Source/drain bottom junction capacitance per unit area" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vfbcv",  194, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat Band Voltage parameter for capmod=0 only" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vfb",  200, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Flat Band Voltage" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cjsw",  663, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source/drain sidewall junction capacitance per unit periphery" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cjswg",  695, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "5e-10", "5e-10", "Source/drain (gate side) sidewall junction capacitance per unit width" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tpb",  205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tcj",  202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cj" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tpbsw",  206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pbsw" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tcjsw",  203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cjsw" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tpbswg",  207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of pbswg" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "tcjswg",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of cjswg" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "acde",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponential coefficient for finite charge thickness" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "moin",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "15", "15", "Coefficient for gate-bias dependent surface potential" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noff",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "C-V turn-on/off parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "voffcv",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "C-V lateral-shift parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lintnoi",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "lint offset for noise calculation" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lint",  669, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ll",  670, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "llc",  697, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lln",  671, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lw",  672, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwc",  698, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwn",  673, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwl",  674, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwlc",  699, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lmin",  675, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum length for the model" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lmax",  676, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum length for the model" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xl",  703, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length correction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "xw",  704, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width correction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wint",  677, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wl",  678, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wlc",  700, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wln",  679, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ww",  680, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwc",  701, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwn",  681, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwl",  682, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwlc",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter for CV" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wmin",  683, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Minimum width for the model" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wmax",  684, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Maximum width for the model" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ckappa",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "7.29897e-11", "7.29897e-11", "Fringe capacitance parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dwc",  685, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "dlc",  686, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "hdif",  711, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Distance Gate - contact" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldif",  712, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Length of LDD Gate-Source/Drain" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ld",  713, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Length of LDD under Gate" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rd",  714, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Resistance of LDD drain side" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rs",  715, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Resistance of LDD source side" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rdc",  716, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Resistance contact drain side" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "rsc",  717, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "ACM Parameter: Resistance contact source side" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wmlt",  718, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "ACM Parameter: Width shrink factor" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "alpha1",  199, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "beta0",  175, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "30", "30", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ijth",  198, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Diode limiting current" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcdsc",  251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcdscb",  252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcdscd",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcit",  253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnfactor",  254, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lxj",  255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xj" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvsat",  256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lat",  257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of at" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "la0",  258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lags",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "la1",  259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "la2",  260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lketa",  261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnsub",  262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnch",  263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lngate",  265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lgamma1",  266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gamma1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lgamma2",  267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of gamma2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvbx",  268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbx" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvbm",  270, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lxt",  272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xt" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lk1",  275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lkt1",  276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lkt1l",  277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1l" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lkt2",  279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lk2",  278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lk3",  280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lk3b",  281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lw0",  282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnlx",  283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nlx" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt0",  284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt1",  285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt2",  286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt0w",  287, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt1w",  288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldvt2w",  289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldrout",  290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldsub",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvth0",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvtho",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lua",  293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lua1",  294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lub",  295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lub1",  296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "luc",  297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "luc1",  298, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lu0",  299, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lute",  300, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ute" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvoff",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lelm",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of elm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldelta",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lrdsw",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lprwg",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lprwb",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lprt",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prt" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "leta0",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "letab",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0", "-0", "Length dependence of etab" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpclm",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpdiblc1",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpdiblc2",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpdiblcb",  324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpscbe1",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pscbe1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpscbe2",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pscbe2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lpvag",  314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lwr",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldwg",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ldwb",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lb0",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lb1",  319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcgsl",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgsl" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcgdl",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdl" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lckappa",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ckappa" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcf",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cf" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lclc",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of clc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lcle",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cle" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lalpha0",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lalpha1",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lbeta0",  321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvfbcv",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfbcv" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvfb",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lacde",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of acde" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lmoin",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of moin" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lnoff",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of noff" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "lvoffcv",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voffcv" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcdsc",  381, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcdscb",  382, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcdscd",  457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcit",  383, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnfactor",  384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wxj",  385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xj" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvsat",  386, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wat",  387, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of at" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wa0",  388, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wags",  458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wa1",  389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wa2",  390, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wketa",  391, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnsub",  392, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnch",  393, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wngate",  395, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wgamma1",  396, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gamma1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wgamma2",  397, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of gamma2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvbx",  398, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbx" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvbm",  400, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wxt",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xt" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wk1",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wkt1",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wkt1l",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1l" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wkt2",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wk2",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wk3",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wk3b",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ww0",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnlx",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nlx" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt0",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt1",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt2",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt0w",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt1w",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdvt2w",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdrout",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdsub",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvth0",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvtho",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wua",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wua1",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wub",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wub1",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wuc",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wuc1",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wu0",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wute",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ute" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvoff",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "welm",  462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of elm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdelta",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wrdsw",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wprwg",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wprwb",  456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wprt",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prt" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "weta0",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wetab",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpclm",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pclm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpdiblc1",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpdiblc2",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpdiblcb",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpscbe1",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pscbe1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpscbe2",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pscbe2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wpvag",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pvag" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wwr",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wr" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdwg",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwg" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wdwb",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wb0",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wb1",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcgsl",  463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgsl" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcgdl",  464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgdl" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wckappa",  465, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ckappa" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcf",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cf" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wclc",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of clc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wcle",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cle" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "walpha0",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "walpha1",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wbeta0",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvfbcv",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfbcv" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvfb",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wacde",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of acde" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wmoin",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of moin" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wnoff",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of noff" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "wvoffcv",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voffcv" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcdsc",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdsc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcdscb",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcdscd",  587, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscd" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcit",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cit" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnfactor",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfactor" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pxj",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xj" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvsat",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsat" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pat",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of at" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pa0",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pags",  588, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ags" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pa1",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pa2",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pketa",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of keta" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnsub",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnch",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pngate",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngate" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pgamma1",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gamma1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pgamma2",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of gamma2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvbx",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbx" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvbm",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pxt",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xt" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pk1",  535, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pkt1",  536, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pkt1l",  537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1l" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pkt2",  539, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pk2",  538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pk3",  540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pk3b",  541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3b" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pw0",  542, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of w0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnlx",  543, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nlx" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt0",  544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt1",  545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt2",  546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt0w",  547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt1w",  548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdvt2w",  549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2w" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdrout",  550, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of drout" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdsub",  551, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dsub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvth0",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vth0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvtho",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pua",  553, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pua1",  554, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pub",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pub1",  556, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "puc",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "puc1",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pu0",  559, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of u0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pute",  560, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ute" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvoff",  561, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voff" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pelm",  592, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of elm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdelta",  562, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delta" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "prdsw",  563, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdsw" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pprwg",  585, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwg" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pprwb",  586, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pprt",  564, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prt" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "peta0",  567, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eta0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "petab",  568, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of etab" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppclm",  569, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pclm" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppdiblc1",  570, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppdiblc2",  571, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppdiblcb",  584, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppscbe1",  572, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pscbe1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppscbe2",  573, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pscbe2" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ppvag",  574, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pvag" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pwr",  575, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wr" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdwg",  576, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwg" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pdwb",  577, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pb0",  578, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pb1",  579, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcgsl",  593, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgsl" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcgdl",  594, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgdl" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pckappa",  595, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ckappa" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcf",  596, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cf" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pclc",  597, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of clc" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pcle",  598, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cle" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "palpha0",  580, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "palpha1",  604, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha1" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pbeta0",  581, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta0" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvfbcv",  599, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfbcv" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvfb",  605, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfb" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pacde",  600, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of acde" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pmoin",  601, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of moin" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pnoff",  602, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of noff" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pvoffcv",  606, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voffcv" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noia",  666, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1e+20", "9.9e+18", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noib",  667, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "50000", "2400", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "noic",  668, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "-1.4e-12", "1.4e-12", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "em",  687, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "4.1e+07", "4.1e+07", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "ef",  688, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise frequency exponent" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "af",  689, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "kf",  690, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgs_max",  801, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgd_max",  802, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgb_max",  803, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vds_max",  804, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbs_max",  805, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbd_max",  806, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgsr_max",  807, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgdr_max",  808, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vgbr_max",  809, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbsr_max",  810, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "vbdr_max",  811, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "nmos",  664, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
    modelInfos[MODEL_TYPE::BSIM3].modelParams.emplace_back( "pmos",  665, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
    // Instance parameters
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "m",  16, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel multiplier", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "nqsmod",  14, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Non-quasi-static const model selector", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "acnqsmod",  15, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "AC NQS model selector", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "geo",  19, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "ACM model drain/source connection", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "delvto",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero bias threshold voltage variation", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "mulu0",  18, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Low field mobility multiplier", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ic",  13, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gmbs",  766, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gm",  764, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gds",  765, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vdsat",  787, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vth",  786, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vth", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "id",  761, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vbs",  758, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vgs",  759, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vgs", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "vds",  760, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vds", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ibd",  763, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibd", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "ibs",  762, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibs", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gbd",  767, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "gbd", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "gbs",  768, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "gbs", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "qb",  769, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qbulk", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cqb",  770, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "CQbulk", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "qg",  771, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qgate", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cqg",  772, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "CQgate", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "qd",  773, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qdrain", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cqd",  774, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "CQdrain", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cgg",  775, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cggb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cgd",  776, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgdb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cgs",  777, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgsb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cdg",  783, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdgb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cdd",  784, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cddb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cds",  785, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdsb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cbg",  778, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbgb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cbd",  792, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbdb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "cbs",  793, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbsb", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "capbd",  779, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbd", true );
    modelInfos[MODEL_TYPE::BSIM3].instanceParams.emplace_back( "capbs",  781, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbs", true );
}