#![feature(prelude_import)]
#![no_std]
#![doc(html_root_url = "https://docs.rs/serde/1.0.137")]
#![allow(unknown_lints, bare_trait_objects, deprecated)]
#![deny(missing_docs, unused_imports)]
#[prelude_import]
use ::std::prelude::rust_2015::*;
#[macro_use]
extern crate std;
mod lib {
    mod core {
        #[cfg(feature = "std")]
        pub use std::*;
    }
    pub use self::core::{cmp, iter, mem, num, ptr, slice, str};
    pub use self::core::{f32, f64};
    pub use self::core::{i16, i32, i64, i8, isize};
    pub use self::core::{u16, u32, u64, u8, usize};
    pub use self::core::cell::{Cell, RefCell};
    pub use self::core::clone::{self, Clone};
    pub use self::core::convert::{self, From, Into};
    pub use self::core::default::{self, Default};
    pub use self::core::fmt::{self, Debug, Display};
    pub use self::core::marker::{self, PhantomData};
    pub use self::core::num::Wrapping;
    pub use self::core::ops::Range;
    pub use self::core::option::{self, Option};
    pub use self::core::result::{self, Result};
    #[cfg(feature = "std")]
    pub use std::borrow::{Cow, ToOwned};
    #[cfg(feature = "std")]
    pub use std::string::{String, ToString};
    #[cfg(feature = "std")]
    pub use std::vec::Vec;
    #[cfg(feature = "std")]
    pub use std::boxed::Box;
    #[cfg(all(feature = "rc", feature = "std"))]
    pub use std::rc::{Rc, Weak as RcWeak};
    #[cfg(all(feature = "rc", feature = "std"))]
    pub use std::sync::{Arc, Weak as ArcWeak};
    #[cfg(feature = "std")]
    pub use std::collections::{BTreeMap, BTreeSet, BinaryHeap, LinkedList, VecDeque};
    #[cfg(feature = "std")]
    pub use std::{error, net};
    #[cfg(feature = "std")]
    pub use std::collections::{HashMap, HashSet};
    #[cfg(feature = "std")]
    pub use std::ffi::{CStr, CString, OsStr, OsString};
    #[cfg(feature = "std")]
    pub use std::hash::{BuildHasher, Hash};
    #[cfg(feature = "std")]
    pub use std::io::Write;
    #[cfg(feature = "std")]
    pub use std::path::{Path, PathBuf};
    #[cfg(feature = "std")]
    pub use std::sync::{Mutex, RwLock};
    #[cfg(feature = "std")]
    pub use std::time::{SystemTime, UNIX_EPOCH};
    #[cfg(not(no_core_reverse))]
    pub use self::core::cmp::Reverse;
    #[cfg(not(no_ops_bound))]
    pub use self::core::ops::Bound;
    #[cfg(not(no_range_inclusive))]
    pub use self::core::ops::RangeInclusive;
    #[cfg(all(feature = "std", not(no_std_atomic)))]
    pub use std::sync::atomic::{
        AtomicBool, AtomicI16, AtomicI32, AtomicI8, AtomicIsize, AtomicU16, AtomicU32,
        AtomicU8, AtomicUsize, Ordering,
    };
    #[cfg(all(feature = "std", not(no_std_atomic64)))]
    pub use std::sync::atomic::{AtomicI64, AtomicU64};
    #[cfg(any(feature = "std", not(no_core_duration)))]
    pub use self::core::time::Duration;
}
#[macro_use]
mod macros {}
#[macro_use]
mod integer128 {}
pub mod de {
    use lib::*;
    pub mod value {
        use lib::*;
        use self::private::{First, Second};
        use __private::size_hint;
        use de::{self, Deserializer, Expected, IntoDeserializer, SeqAccess, Visitor};
        use ser;
        pub struct Error {
            err: ErrorImpl,
        }
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl ::core::clone::Clone for Error {
            #[inline]
            fn clone(&self) -> Error {
                match *self {
                    Self { err: ref __self_0_0 } => {
                        Error {
                            err: ::core::clone::Clone::clone(&(*__self_0_0)),
                        }
                    }
                }
            }
        }
        impl ::core::marker::StructuralPartialEq for Error {}
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl ::core::cmp::PartialEq for Error {
            #[inline]
            fn eq(&self, other: &Error) -> bool {
                match *other {
                    Self { err: ref __self_1_0 } => {
                        match *self {
                            Self { err: ref __self_0_0 } => {
                                (*__self_0_0) == (*__self_1_0)
                            }
                        }
                    }
                }
            }
            #[inline]
            fn ne(&self, other: &Error) -> bool {
                match *other {
                    Self { err: ref __self_1_0 } => {
                        match *self {
                            Self { err: ref __self_0_0 } => {
                                (*__self_0_0) != (*__self_1_0)
                            }
                        }
                    }
                }
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        type ErrorImpl = Box<str>;
        impl de::Error for Error {
            #[cfg(any(feature = "std", feature = "alloc"))]
            #[cold]
            fn custom<T>(msg: T) -> Self
            where
                T: Display,
            {
                Error {
                    err: msg.to_string().into_boxed_str(),
                }
            }
        }
        impl ser::Error for Error {
            #[cold]
            fn custom<T>(msg: T) -> Self
            where
                T: Display,
            {
                de::Error::custom(msg)
            }
        }
        impl Display for Error {
            #[cfg(any(feature = "std", feature = "alloc"))]
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str(&self.err)
            }
        }
        impl Debug for Error {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                let mut debug = formatter.debug_tuple("Error");
                #[cfg(any(feature = "std", feature = "alloc"))] debug.field(&self.err);
                debug.finish()
            }
        }
        #[cfg(feature = "std")]
        impl error::Error for Error {
            fn description(&self) -> &str {
                &self.err
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for ()
        where
            E: de::Error,
        {
            type Deserializer = UnitDeserializer<E>;
            fn into_deserializer(self) -> UnitDeserializer<E> {
                UnitDeserializer {
                    marker: PhantomData,
                }
            }
        }
        pub struct UnitDeserializer<E> {
            marker: PhantomData<E>,
        }
        impl<E> Copy for UnitDeserializer<E> {}
        impl<E> Clone for UnitDeserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> de::Deserializer<'de> for UnitDeserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_unit()
            }
            fn deserialize_option<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_none()
            }
        }
        impl<E> Debug for UnitDeserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.debug_struct("UnitDeserializer").finish()
            }
        }
        pub struct BoolDeserializer<E> {
            value: bool,
            marker: PhantomData<E>,
        }
        impl<E> Copy for BoolDeserializer<E> {}
        impl<E> Clone for BoolDeserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for bool
        where
            E: de::Error,
        {
            type Deserializer = BoolDeserializer<E>;
            fn into_deserializer(self) -> BoolDeserializer<E> {
                BoolDeserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for BoolDeserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_bool(self.value)
            }
        }
        impl<E> Debug for BoolDeserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("BoolDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct I8Deserializer<E> {
            value: i8,
            marker: PhantomData<E>,
        }
        impl<E> Copy for I8Deserializer<E> {}
        impl<E> Clone for I8Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for i8
        where
            E: de::Error,
        {
            type Deserializer = I8Deserializer<E>;
            fn into_deserializer(self) -> I8Deserializer<E> {
                I8Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for I8Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_i8(self.value)
            }
        }
        impl<E> Debug for I8Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("I8Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct I16Deserializer<E> {
            value: i16,
            marker: PhantomData<E>,
        }
        impl<E> Copy for I16Deserializer<E> {}
        impl<E> Clone for I16Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for i16
        where
            E: de::Error,
        {
            type Deserializer = I16Deserializer<E>;
            fn into_deserializer(self) -> I16Deserializer<E> {
                I16Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for I16Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_i16(self.value)
            }
        }
        impl<E> Debug for I16Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("I16Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct I32Deserializer<E> {
            value: i32,
            marker: PhantomData<E>,
        }
        impl<E> Copy for I32Deserializer<E> {}
        impl<E> Clone for I32Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for i32
        where
            E: de::Error,
        {
            type Deserializer = I32Deserializer<E>;
            fn into_deserializer(self) -> I32Deserializer<E> {
                I32Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for I32Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_i32(self.value)
            }
        }
        impl<E> Debug for I32Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("I32Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct I64Deserializer<E> {
            value: i64,
            marker: PhantomData<E>,
        }
        impl<E> Copy for I64Deserializer<E> {}
        impl<E> Clone for I64Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for i64
        where
            E: de::Error,
        {
            type Deserializer = I64Deserializer<E>;
            fn into_deserializer(self) -> I64Deserializer<E> {
                I64Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for I64Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_i64(self.value)
            }
        }
        impl<E> Debug for I64Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("I64Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct IsizeDeserializer<E> {
            value: isize,
            marker: PhantomData<E>,
        }
        impl<E> Copy for IsizeDeserializer<E> {}
        impl<E> Clone for IsizeDeserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for isize
        where
            E: de::Error,
        {
            type Deserializer = IsizeDeserializer<E>;
            fn into_deserializer(self) -> IsizeDeserializer<E> {
                IsizeDeserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for IsizeDeserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_i64(self.value as i64)
            }
        }
        impl<E> Debug for IsizeDeserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("IsizeDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct U8Deserializer<E> {
            value: u8,
            marker: PhantomData<E>,
        }
        impl<E> Copy for U8Deserializer<E> {}
        impl<E> Clone for U8Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for u8
        where
            E: de::Error,
        {
            type Deserializer = U8Deserializer<E>;
            fn into_deserializer(self) -> U8Deserializer<E> {
                U8Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for U8Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_u8(self.value)
            }
        }
        impl<E> Debug for U8Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("U8Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct U16Deserializer<E> {
            value: u16,
            marker: PhantomData<E>,
        }
        impl<E> Copy for U16Deserializer<E> {}
        impl<E> Clone for U16Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for u16
        where
            E: de::Error,
        {
            type Deserializer = U16Deserializer<E>;
            fn into_deserializer(self) -> U16Deserializer<E> {
                U16Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for U16Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_u16(self.value)
            }
        }
        impl<E> Debug for U16Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("U16Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct U64Deserializer<E> {
            value: u64,
            marker: PhantomData<E>,
        }
        impl<E> Copy for U64Deserializer<E> {}
        impl<E> Clone for U64Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for u64
        where
            E: de::Error,
        {
            type Deserializer = U64Deserializer<E>;
            fn into_deserializer(self) -> U64Deserializer<E> {
                U64Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for U64Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_u64(self.value)
            }
        }
        impl<E> Debug for U64Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("U64Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct UsizeDeserializer<E> {
            value: usize,
            marker: PhantomData<E>,
        }
        impl<E> Copy for UsizeDeserializer<E> {}
        impl<E> Clone for UsizeDeserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for usize
        where
            E: de::Error,
        {
            type Deserializer = UsizeDeserializer<E>;
            fn into_deserializer(self) -> UsizeDeserializer<E> {
                UsizeDeserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for UsizeDeserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_u64(self.value as u64)
            }
        }
        impl<E> Debug for UsizeDeserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("UsizeDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct F32Deserializer<E> {
            value: f32,
            marker: PhantomData<E>,
        }
        impl<E> Copy for F32Deserializer<E> {}
        impl<E> Clone for F32Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for f32
        where
            E: de::Error,
        {
            type Deserializer = F32Deserializer<E>;
            fn into_deserializer(self) -> F32Deserializer<E> {
                F32Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for F32Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_f32(self.value)
            }
        }
        impl<E> Debug for F32Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("F32Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct F64Deserializer<E> {
            value: f64,
            marker: PhantomData<E>,
        }
        impl<E> Copy for F64Deserializer<E> {}
        impl<E> Clone for F64Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for f64
        where
            E: de::Error,
        {
            type Deserializer = F64Deserializer<E>;
            fn into_deserializer(self) -> F64Deserializer<E> {
                F64Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for F64Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_f64(self.value)
            }
        }
        impl<E> Debug for F64Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("F64Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct CharDeserializer<E> {
            value: char,
            marker: PhantomData<E>,
        }
        impl<E> Copy for CharDeserializer<E> {}
        impl<E> Clone for CharDeserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for char
        where
            E: de::Error,
        {
            type Deserializer = CharDeserializer<E>;
            fn into_deserializer(self) -> CharDeserializer<E> {
                CharDeserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for CharDeserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_char(self.value)
            }
        }
        impl<E> Debug for CharDeserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("CharDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct I128Deserializer<E> {
            value: i128,
            marker: PhantomData<E>,
        }
        impl<E> Copy for I128Deserializer<E> {}
        impl<E> Clone for I128Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for i128
        where
            E: de::Error,
        {
            type Deserializer = I128Deserializer<E>;
            fn into_deserializer(self) -> I128Deserializer<E> {
                I128Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for I128Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_i128(self.value)
            }
        }
        impl<E> Debug for I128Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("I128Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct U128Deserializer<E> {
            value: u128,
            marker: PhantomData<E>,
        }
        impl<E> Copy for U128Deserializer<E> {}
        impl<E> Clone for U128Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for u128
        where
            E: de::Error,
        {
            type Deserializer = U128Deserializer<E>;
            fn into_deserializer(self) -> U128Deserializer<E> {
                U128Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for U128Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_u128(self.value)
            }
        }
        impl<E> Debug for U128Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("U128Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct U32Deserializer<E> {
            value: u32,
            marker: PhantomData<E>,
        }
        impl<E> Copy for U32Deserializer<E> {}
        impl<E> Clone for U32Deserializer<E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> IntoDeserializer<'de, E> for u32
        where
            E: de::Error,
        {
            type Deserializer = U32Deserializer<E>;
            fn into_deserializer(self) -> U32Deserializer<E> {
                U32Deserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for U32Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_u32(self.value)
            }
            fn deserialize_enum<V>(
                self,
                name: &str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                visitor.visit_enum(self)
            }
        }
        impl<'de, E> de::EnumAccess<'de> for U32Deserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            type Variant = private::UnitOnly<E>;
            fn variant_seed<T>(
                self,
                seed: T,
            ) -> Result<(T::Value, Self::Variant), Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                seed.deserialize(self).map(private::unit_only)
            }
        }
        impl<E> Debug for U32Deserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("U32Deserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct StrDeserializer<'a, E> {
            value: &'a str,
            marker: PhantomData<E>,
        }
        impl<'de, E> Copy for StrDeserializer<'de, E> {}
        impl<'de, E> Clone for StrDeserializer<'de, E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, 'a, E> IntoDeserializer<'de, E> for &'a str
        where
            E: de::Error,
        {
            type Deserializer = StrDeserializer<'a, E>;
            fn into_deserializer(self) -> StrDeserializer<'a, E> {
                StrDeserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, 'a, E> de::Deserializer<'de> for StrDeserializer<'a, E>
        where
            E: de::Error,
        {
            type Error = E;
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_str(self.value)
            }
            fn deserialize_enum<V>(
                self,
                name: &str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                visitor.visit_enum(self)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        impl<'de, 'a, E> de::EnumAccess<'de> for StrDeserializer<'a, E>
        where
            E: de::Error,
        {
            type Error = E;
            type Variant = private::UnitOnly<E>;
            fn variant_seed<T>(
                self,
                seed: T,
            ) -> Result<(T::Value, Self::Variant), Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                seed.deserialize(self).map(private::unit_only)
            }
        }
        impl<'a, E> Debug for StrDeserializer<'a, E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("StrDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct BorrowedStrDeserializer<'de, E> {
            value: &'de str,
            marker: PhantomData<E>,
        }
        impl<'de, E> Copy for BorrowedStrDeserializer<'de, E> {}
        impl<'de, E> Clone for BorrowedStrDeserializer<'de, E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> BorrowedStrDeserializer<'de, E> {
            pub fn new(value: &'de str) -> BorrowedStrDeserializer<'de, E> {
                BorrowedStrDeserializer {
                    value: value,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> de::Deserializer<'de> for BorrowedStrDeserializer<'de, E>
        where
            E: de::Error,
        {
            type Error = E;
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_borrowed_str(self.value)
            }
            fn deserialize_enum<V>(
                self,
                name: &str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                visitor.visit_enum(self)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        impl<'de, E> de::EnumAccess<'de> for BorrowedStrDeserializer<'de, E>
        where
            E: de::Error,
        {
            type Error = E;
            type Variant = private::UnitOnly<E>;
            fn variant_seed<T>(
                self,
                seed: T,
            ) -> Result<(T::Value, Self::Variant), Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                seed.deserialize(self).map(private::unit_only)
            }
        }
        impl<'de, E> Debug for BorrowedStrDeserializer<'de, E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("BorrowedStrDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        pub struct StringDeserializer<E> {
            value: String,
            marker: PhantomData<E>,
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<E> Clone for StringDeserializer<E> {
            fn clone(&self) -> Self {
                StringDeserializer {
                    value: self.value.clone(),
                    marker: PhantomData,
                }
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, E> IntoDeserializer<'de, E> for String
        where
            E: de::Error,
        {
            type Deserializer = StringDeserializer<E>;
            fn into_deserializer(self) -> StringDeserializer<E> {
                StringDeserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, E> de::Deserializer<'de> for StringDeserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_string(self.value)
            }
            fn deserialize_enum<V>(
                self,
                name: &str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                visitor.visit_enum(self)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, 'a, E> de::EnumAccess<'de> for StringDeserializer<E>
        where
            E: de::Error,
        {
            type Error = E;
            type Variant = private::UnitOnly<E>;
            fn variant_seed<T>(
                self,
                seed: T,
            ) -> Result<(T::Value, Self::Variant), Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                seed.deserialize(self).map(private::unit_only)
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<E> Debug for StringDeserializer<E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("StringDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        pub struct CowStrDeserializer<'a, E> {
            value: Cow<'a, str>,
            marker: PhantomData<E>,
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'a, E> Clone for CowStrDeserializer<'a, E> {
            fn clone(&self) -> Self {
                CowStrDeserializer {
                    value: self.value.clone(),
                    marker: PhantomData,
                }
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, 'a, E> IntoDeserializer<'de, E> for Cow<'a, str>
        where
            E: de::Error,
        {
            type Deserializer = CowStrDeserializer<'a, E>;
            fn into_deserializer(self) -> CowStrDeserializer<'a, E> {
                CowStrDeserializer {
                    value: self,
                    marker: PhantomData,
                }
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, 'a, E> de::Deserializer<'de> for CowStrDeserializer<'a, E>
        where
            E: de::Error,
        {
            type Error = E;
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                match self.value {
                    Cow::Borrowed(string) => visitor.visit_str(string),
                    Cow::Owned(string) => visitor.visit_string(string),
                }
            }
            fn deserialize_enum<V>(
                self,
                name: &str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                visitor.visit_enum(self)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, 'a, E> de::EnumAccess<'de> for CowStrDeserializer<'a, E>
        where
            E: de::Error,
        {
            type Error = E;
            type Variant = private::UnitOnly<E>;
            fn variant_seed<T>(
                self,
                seed: T,
            ) -> Result<(T::Value, Self::Variant), Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                seed.deserialize(self).map(private::unit_only)
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'a, E> Debug for CowStrDeserializer<'a, E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("CowStrDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct BytesDeserializer<'a, E> {
            value: &'a [u8],
            marker: PhantomData<E>,
        }
        impl<'a, E> BytesDeserializer<'a, E> {
            pub fn new(value: &'a [u8]) -> Self {
                BytesDeserializer {
                    value: value,
                    marker: PhantomData,
                }
            }
        }
        impl<'a, E> Copy for BytesDeserializer<'a, E> {}
        impl<'a, E> Clone for BytesDeserializer<'a, E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, 'a, E> IntoDeserializer<'de, E> for &'a [u8]
        where
            E: de::Error,
        {
            type Deserializer = BytesDeserializer<'a, E>;
            fn into_deserializer(self) -> BytesDeserializer<'a, E> {
                BytesDeserializer::new(self)
            }
        }
        impl<'de, 'a, E> Deserializer<'de> for BytesDeserializer<'a, E>
        where
            E: de::Error,
        {
            type Error = E;
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: Visitor<'de>,
            {
                visitor.visit_bytes(self.value)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        impl<'a, E> Debug for BytesDeserializer<'a, E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("BytesDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct BorrowedBytesDeserializer<'de, E> {
            value: &'de [u8],
            marker: PhantomData<E>,
        }
        impl<'de, E> BorrowedBytesDeserializer<'de, E> {
            pub fn new(value: &'de [u8]) -> Self {
                BorrowedBytesDeserializer {
                    value: value,
                    marker: PhantomData,
                }
            }
        }
        impl<'de, E> Copy for BorrowedBytesDeserializer<'de, E> {}
        impl<'de, E> Clone for BorrowedBytesDeserializer<'de, E> {
            fn clone(&self) -> Self {
                *self
            }
        }
        impl<'de, E> Deserializer<'de> for BorrowedBytesDeserializer<'de, E>
        where
            E: de::Error,
        {
            type Error = E;
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: Visitor<'de>,
            {
                visitor.visit_borrowed_bytes(self.value)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        impl<'de, E> Debug for BorrowedBytesDeserializer<'de, E> {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("BorrowedBytesDeserializer")
                    .field("value", &self.value)
                    .finish()
            }
        }
        pub struct SeqDeserializer<I, E> {
            iter: iter::Fuse<I>,
            count: usize,
            marker: PhantomData<E>,
        }
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl<I: ::core::clone::Clone, E: ::core::clone::Clone> ::core::clone::Clone
        for SeqDeserializer<I, E> {
            #[inline]
            fn clone(&self) -> SeqDeserializer<I, E> {
                match *self {
                    Self {
                        iter: ref __self_0_0,
                        count: ref __self_0_1,
                        marker: ref __self_0_2,
                    } => {
                        SeqDeserializer {
                            iter: ::core::clone::Clone::clone(&(*__self_0_0)),
                            count: ::core::clone::Clone::clone(&(*__self_0_1)),
                            marker: ::core::clone::Clone::clone(&(*__self_0_2)),
                        }
                    }
                }
            }
        }
        impl<I, E> SeqDeserializer<I, E>
        where
            I: Iterator,
        {
            pub fn new(iter: I) -> Self {
                SeqDeserializer {
                    iter: iter.fuse(),
                    count: 0,
                    marker: PhantomData,
                }
            }
        }
        impl<I, E> SeqDeserializer<I, E>
        where
            I: Iterator,
            E: de::Error,
        {
            pub fn end(self) -> Result<(), E> {
                let remaining = self.iter.count();
                if remaining == 0 {
                    Ok(())
                } else {
                    Err(
                        de::Error::invalid_length(
                            self.count + remaining,
                            &ExpectedInSeq(self.count),
                        ),
                    )
                }
            }
        }
        impl<'de, I, T, E> de::Deserializer<'de> for SeqDeserializer<I, E>
        where
            I: Iterator<Item = T>,
            T: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Error = E;
            fn deserialize_any<V>(mut self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let v = match visitor.visit_seq(&mut self) {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                };
                match self.end() {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                };
                Ok(v)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        impl<'de, I, T, E> de::SeqAccess<'de> for SeqDeserializer<I, E>
        where
            I: Iterator<Item = T>,
            T: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Error = E;
            fn next_element_seed<V>(
                &mut self,
                seed: V,
            ) -> Result<Option<V::Value>, Self::Error>
            where
                V: de::DeserializeSeed<'de>,
            {
                match self.iter.next() {
                    Some(value) => {
                        self.count += 1;
                        seed.deserialize(value.into_deserializer()).map(Some)
                    }
                    None => Ok(None),
                }
            }
            fn size_hint(&self) -> Option<usize> {
                size_hint::from_bounds(&self.iter)
            }
        }
        struct ExpectedInSeq(usize);
        impl Expected for ExpectedInSeq {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                if self.0 == 1 {
                    {
                        let result = formatter
                            .write_fmt(
                                ::core::fmt::Arguments::new_v1(
                                    &["1 element in sequence"],
                                    &[],
                                ),
                            );
                        result
                    }
                } else {
                    {
                        let result = formatter
                            .write_fmt(
                                ::core::fmt::Arguments::new_v1(
                                    &["", " elements in sequence"],
                                    &[::core::fmt::ArgumentV1::new_display(&self.0)],
                                ),
                            );
                        result
                    }
                }
            }
        }
        impl<I, E> Debug for SeqDeserializer<I, E>
        where
            I: Debug,
        {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("SeqDeserializer")
                    .field("iter", &self.iter)
                    .field("count", &self.count)
                    .finish()
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, T, E> IntoDeserializer<'de, E> for Vec<T>
        where
            T: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Deserializer = SeqDeserializer<<Self as IntoIterator>::IntoIter, E>;
            fn into_deserializer(self) -> Self::Deserializer {
                SeqDeserializer::new(self.into_iter())
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, T, E> IntoDeserializer<'de, E> for BTreeSet<T>
        where
            T: IntoDeserializer<'de, E> + Eq + Ord,
            E: de::Error,
        {
            type Deserializer = SeqDeserializer<<Self as IntoIterator>::IntoIter, E>;
            fn into_deserializer(self) -> Self::Deserializer {
                SeqDeserializer::new(self.into_iter())
            }
        }
        #[cfg(feature = "std")]
        impl<'de, T, S, E> IntoDeserializer<'de, E> for HashSet<T, S>
        where
            T: IntoDeserializer<'de, E> + Eq + Hash,
            S: BuildHasher,
            E: de::Error,
        {
            type Deserializer = SeqDeserializer<<Self as IntoIterator>::IntoIter, E>;
            fn into_deserializer(self) -> Self::Deserializer {
                SeqDeserializer::new(self.into_iter())
            }
        }
        pub struct SeqAccessDeserializer<A> {
            seq: A,
        }
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl<A: ::core::clone::Clone> ::core::clone::Clone for SeqAccessDeserializer<A> {
            #[inline]
            fn clone(&self) -> SeqAccessDeserializer<A> {
                match *self {
                    Self { seq: ref __self_0_0 } => {
                        SeqAccessDeserializer {
                            seq: ::core::clone::Clone::clone(&(*__self_0_0)),
                        }
                    }
                }
            }
        }
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl<A: ::core::fmt::Debug> ::core::fmt::Debug for SeqAccessDeserializer<A> {
            fn fmt(&self, f: &mut ::core::fmt::Formatter) -> ::core::fmt::Result {
                match *self {
                    Self { seq: ref __self_0_0 } => {
                        let debug_trait_builder = &mut ::core::fmt::Formatter::debug_struct(
                            f,
                            "SeqAccessDeserializer",
                        );
                        let _ = ::core::fmt::DebugStruct::field(
                            debug_trait_builder,
                            "seq",
                            &&(*__self_0_0),
                        );
                        ::core::fmt::DebugStruct::finish(debug_trait_builder)
                    }
                }
            }
        }
        impl<A> SeqAccessDeserializer<A> {
            pub fn new(seq: A) -> Self {
                SeqAccessDeserializer { seq: seq }
            }
        }
        impl<'de, A> de::Deserializer<'de> for SeqAccessDeserializer<A>
        where
            A: de::SeqAccess<'de>,
        {
            type Error = A::Error;
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_seq(self.seq)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        pub struct MapDeserializer<'de, I, E>
        where
            I: Iterator,
            I::Item: private::Pair,
        {
            iter: iter::Fuse<I>,
            value: Option<Second<I::Item>>,
            count: usize,
            lifetime: PhantomData<&'de ()>,
            error: PhantomData<E>,
        }
        impl<'de, I, E> MapDeserializer<'de, I, E>
        where
            I: Iterator,
            I::Item: private::Pair,
        {
            pub fn new(iter: I) -> Self {
                MapDeserializer {
                    iter: iter.fuse(),
                    value: None,
                    count: 0,
                    lifetime: PhantomData,
                    error: PhantomData,
                }
            }
        }
        impl<'de, I, E> MapDeserializer<'de, I, E>
        where
            I: Iterator,
            I::Item: private::Pair,
            E: de::Error,
        {
            pub fn end(self) -> Result<(), E> {
                let remaining = self.iter.count();
                if remaining == 0 {
                    Ok(())
                } else {
                    Err(
                        de::Error::invalid_length(
                            self.count + remaining,
                            &ExpectedInMap(self.count),
                        ),
                    )
                }
            }
        }
        impl<'de, I, E> MapDeserializer<'de, I, E>
        where
            I: Iterator,
            I::Item: private::Pair,
        {
            fn next_pair(&mut self) -> Option<(First<I::Item>, Second<I::Item>)> {
                match self.iter.next() {
                    Some(kv) => {
                        self.count += 1;
                        Some(private::Pair::split(kv))
                    }
                    None => None,
                }
            }
        }
        impl<'de, I, E> de::Deserializer<'de> for MapDeserializer<'de, I, E>
        where
            I: Iterator,
            I::Item: private::Pair,
            First<I::Item>: IntoDeserializer<'de, E>,
            Second<I::Item>: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Error = E;
            fn deserialize_any<V>(mut self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let value = match visitor.visit_map(&mut self) {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                };
                match self.end() {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                };
                Ok(value)
            }
            fn deserialize_seq<V>(mut self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let value = match visitor.visit_seq(&mut self) {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                };
                match self.end() {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                };
                Ok(value)
            }
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_seq(visitor)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        impl<'de, I, E> de::MapAccess<'de> for MapDeserializer<'de, I, E>
        where
            I: Iterator,
            I::Item: private::Pair,
            First<I::Item>: IntoDeserializer<'de, E>,
            Second<I::Item>: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Error = E;
            fn next_key_seed<T>(
                &mut self,
                seed: T,
            ) -> Result<Option<T::Value>, Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                match self.next_pair() {
                    Some((key, value)) => {
                        self.value = Some(value);
                        seed.deserialize(key.into_deserializer()).map(Some)
                    }
                    None => Ok(None),
                }
            }
            fn next_value_seed<T>(&mut self, seed: T) -> Result<T::Value, Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                let value = self.value.take();
                let value = value.expect("MapAccess::next_value called before next_key");
                seed.deserialize(value.into_deserializer())
            }
            fn next_entry_seed<TK, TV>(
                &mut self,
                kseed: TK,
                vseed: TV,
            ) -> Result<Option<(TK::Value, TV::Value)>, Self::Error>
            where
                TK: de::DeserializeSeed<'de>,
                TV: de::DeserializeSeed<'de>,
            {
                match self.next_pair() {
                    Some((key, value)) => {
                        let key = match kseed.deserialize(key.into_deserializer()) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        };
                        let value = match vseed.deserialize(value.into_deserializer()) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        };
                        Ok(Some((key, value)))
                    }
                    None => Ok(None),
                }
            }
            fn size_hint(&self) -> Option<usize> {
                size_hint::from_bounds(&self.iter)
            }
        }
        impl<'de, I, E> de::SeqAccess<'de> for MapDeserializer<'de, I, E>
        where
            I: Iterator,
            I::Item: private::Pair,
            First<I::Item>: IntoDeserializer<'de, E>,
            Second<I::Item>: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Error = E;
            fn next_element_seed<T>(
                &mut self,
                seed: T,
            ) -> Result<Option<T::Value>, Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                match self.next_pair() {
                    Some((k, v)) => {
                        let de = PairDeserializer(k, v, PhantomData);
                        seed.deserialize(de).map(Some)
                    }
                    None => Ok(None),
                }
            }
            fn size_hint(&self) -> Option<usize> {
                size_hint::from_bounds(&self.iter)
            }
        }
        impl<'de, I, E> Clone for MapDeserializer<'de, I, E>
        where
            I: Iterator + Clone,
            I::Item: private::Pair,
            Second<I::Item>: Clone,
        {
            fn clone(&self) -> Self {
                MapDeserializer {
                    iter: self.iter.clone(),
                    value: self.value.clone(),
                    count: self.count,
                    lifetime: self.lifetime,
                    error: self.error,
                }
            }
        }
        impl<'de, I, E> Debug for MapDeserializer<'de, I, E>
        where
            I: Iterator + Debug,
            I::Item: private::Pair,
            Second<I::Item>: Debug,
        {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter
                    .debug_struct("MapDeserializer")
                    .field("iter", &self.iter)
                    .field("value", &self.value)
                    .field("count", &self.count)
                    .finish()
            }
        }
        struct PairDeserializer<A, B, E>(A, B, PhantomData<E>);
        impl<'de, A, B, E> de::Deserializer<'de> for PairDeserializer<A, B, E>
        where
            A: IntoDeserializer<'de, E>,
            B: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Error = E;
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_enum<V>(
                self,
                name: &'static str,
                variants: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = variants;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                self.deserialize_seq(visitor)
            }
            fn deserialize_seq<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                let mut pair_visitor = PairVisitor(
                    Some(self.0),
                    Some(self.1),
                    PhantomData,
                );
                let pair = match visitor.visit_seq(&mut pair_visitor) {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                };
                if pair_visitor.1.is_none() {
                    Ok(pair)
                } else {
                    let remaining = pair_visitor.size_hint().unwrap();
                    Err(de::Error::invalid_length(2, &ExpectedInSeq(2 - remaining)))
                }
            }
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                if len == 2 {
                    self.deserialize_seq(visitor)
                } else {
                    Err(de::Error::invalid_length(2, &ExpectedInSeq(len)))
                }
            }
        }
        struct PairVisitor<A, B, E>(Option<A>, Option<B>, PhantomData<E>);
        impl<'de, A, B, E> de::SeqAccess<'de> for PairVisitor<A, B, E>
        where
            A: IntoDeserializer<'de, E>,
            B: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Error = E;
            fn next_element_seed<T>(
                &mut self,
                seed: T,
            ) -> Result<Option<T::Value>, Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                if let Some(k) = self.0.take() {
                    seed.deserialize(k.into_deserializer()).map(Some)
                } else if let Some(v) = self.1.take() {
                    seed.deserialize(v.into_deserializer()).map(Some)
                } else {
                    Ok(None)
                }
            }
            fn size_hint(&self) -> Option<usize> {
                if self.0.is_some() {
                    Some(2)
                } else if self.1.is_some() {
                    Some(1)
                } else {
                    Some(0)
                }
            }
        }
        struct ExpectedInMap(usize);
        impl Expected for ExpectedInMap {
            fn fmt(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                if self.0 == 1 {
                    {
                        let result = formatter
                            .write_fmt(
                                ::core::fmt::Arguments::new_v1(&["1 element in map"], &[]),
                            );
                        result
                    }
                } else {
                    {
                        let result = formatter
                            .write_fmt(
                                ::core::fmt::Arguments::new_v1(
                                    &["", " elements in map"],
                                    &[::core::fmt::ArgumentV1::new_display(&self.0)],
                                ),
                            );
                        result
                    }
                }
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, K, V, E> IntoDeserializer<'de, E> for BTreeMap<K, V>
        where
            K: IntoDeserializer<'de, E> + Eq + Ord,
            V: IntoDeserializer<'de, E>,
            E: de::Error,
        {
            type Deserializer = MapDeserializer<
                'de,
                <Self as IntoIterator>::IntoIter,
                E,
            >;
            fn into_deserializer(self) -> Self::Deserializer {
                MapDeserializer::new(self.into_iter())
            }
        }
        #[cfg(feature = "std")]
        impl<'de, K, V, S, E> IntoDeserializer<'de, E> for HashMap<K, V, S>
        where
            K: IntoDeserializer<'de, E> + Eq + Hash,
            V: IntoDeserializer<'de, E>,
            S: BuildHasher,
            E: de::Error,
        {
            type Deserializer = MapDeserializer<
                'de,
                <Self as IntoIterator>::IntoIter,
                E,
            >;
            fn into_deserializer(self) -> Self::Deserializer {
                MapDeserializer::new(self.into_iter())
            }
        }
        pub struct MapAccessDeserializer<A> {
            map: A,
        }
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl<A: ::core::clone::Clone> ::core::clone::Clone for MapAccessDeserializer<A> {
            #[inline]
            fn clone(&self) -> MapAccessDeserializer<A> {
                match *self {
                    Self { map: ref __self_0_0 } => {
                        MapAccessDeserializer {
                            map: ::core::clone::Clone::clone(&(*__self_0_0)),
                        }
                    }
                }
            }
        }
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl<A: ::core::fmt::Debug> ::core::fmt::Debug for MapAccessDeserializer<A> {
            fn fmt(&self, f: &mut ::core::fmt::Formatter) -> ::core::fmt::Result {
                match *self {
                    Self { map: ref __self_0_0 } => {
                        let debug_trait_builder = &mut ::core::fmt::Formatter::debug_struct(
                            f,
                            "MapAccessDeserializer",
                        );
                        let _ = ::core::fmt::DebugStruct::field(
                            debug_trait_builder,
                            "map",
                            &&(*__self_0_0),
                        );
                        ::core::fmt::DebugStruct::finish(debug_trait_builder)
                    }
                }
            }
        }
        impl<A> MapAccessDeserializer<A> {
            pub fn new(map: A) -> Self {
                MapAccessDeserializer { map: map }
            }
        }
        impl<'de, A> de::Deserializer<'de> for MapAccessDeserializer<A>
        where
            A: de::MapAccess<'de>,
        {
            type Error = A::Error;
            fn deserialize_any<V>(self, visitor: V) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_map(self.map)
            }
            fn deserialize_enum<V>(
                self,
                _name: &str,
                _variants: &'static [&'static str],
                visitor: V,
            ) -> Result<V::Value, Self::Error>
            where
                V: de::Visitor<'de>,
            {
                visitor.visit_enum(self)
            }
            #[inline]
            fn deserialize_bool<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_i128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u8<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u16<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_u128<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f32<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_f64<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_char<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_str<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_string<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_bytes<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_byte_buf<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_option<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_unit_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_newtype_struct<V>(
                self,
                name: &'static str,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_seq<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple<V>(
                self,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_tuple_struct<V>(
                self,
                name: &'static str,
                len: usize,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = len;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_map<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_struct<V>(
                self,
                name: &'static str,
                fields: &'static [&'static str],
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                let _ = name;
                let _ = fields;
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_identifier<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
            #[inline]
            fn deserialize_ignored_any<V>(
                self,
                visitor: V,
            ) -> crate::__private::Result<V::Value, Self::Error>
            where
                V: crate::de::Visitor<'de>,
            {
                self.deserialize_any(visitor)
            }
        }
        impl<'de, A> de::EnumAccess<'de> for MapAccessDeserializer<A>
        where
            A: de::MapAccess<'de>,
        {
            type Error = A::Error;
            type Variant = private::MapAsEnum<A>;
            fn variant_seed<T>(
                mut self,
                seed: T,
            ) -> Result<(T::Value, Self::Variant), Self::Error>
            where
                T: de::DeserializeSeed<'de>,
            {
                match self.map.next_key_seed(seed)? {
                    Some(key) => Ok((key, private::map_as_enum(self.map))),
                    None => Err(de::Error::invalid_type(de::Unexpected::Map, &"enum")),
                }
            }
        }
        mod private {
            use lib::*;
            use de::{
                self, DeserializeSeed, Deserializer, MapAccess, Unexpected,
                VariantAccess, Visitor,
            };
            pub struct UnitOnly<E> {
                marker: PhantomData<E>,
            }
            pub fn unit_only<T, E>(t: T) -> (T, UnitOnly<E>) {
                (t, UnitOnly { marker: PhantomData })
            }
            impl<'de, E> de::VariantAccess<'de> for UnitOnly<E>
            where
                E: de::Error,
            {
                type Error = E;
                fn unit_variant(self) -> Result<(), Self::Error> {
                    Ok(())
                }
                fn newtype_variant_seed<T>(
                    self,
                    _seed: T,
                ) -> Result<T::Value, Self::Error>
                where
                    T: de::DeserializeSeed<'de>,
                {
                    Err(
                        de::Error::invalid_type(
                            Unexpected::UnitVariant,
                            &"newtype variant",
                        ),
                    )
                }
                fn tuple_variant<V>(
                    self,
                    _len: usize,
                    _visitor: V,
                ) -> Result<V::Value, Self::Error>
                where
                    V: de::Visitor<'de>,
                {
                    Err(
                        de::Error::invalid_type(
                            Unexpected::UnitVariant,
                            &"tuple variant",
                        ),
                    )
                }
                fn struct_variant<V>(
                    self,
                    _fields: &'static [&'static str],
                    _visitor: V,
                ) -> Result<V::Value, Self::Error>
                where
                    V: de::Visitor<'de>,
                {
                    Err(
                        de::Error::invalid_type(
                            Unexpected::UnitVariant,
                            &"struct variant",
                        ),
                    )
                }
            }
            pub struct MapAsEnum<A> {
                map: A,
            }
            pub fn map_as_enum<A>(map: A) -> MapAsEnum<A> {
                MapAsEnum { map: map }
            }
            impl<'de, A> VariantAccess<'de> for MapAsEnum<A>
            where
                A: MapAccess<'de>,
            {
                type Error = A::Error;
                fn unit_variant(mut self) -> Result<(), Self::Error> {
                    self.map.next_value()
                }
                fn newtype_variant_seed<T>(
                    mut self,
                    seed: T,
                ) -> Result<T::Value, Self::Error>
                where
                    T: DeserializeSeed<'de>,
                {
                    self.map.next_value_seed(seed)
                }
                fn tuple_variant<V>(
                    mut self,
                    len: usize,
                    visitor: V,
                ) -> Result<V::Value, Self::Error>
                where
                    V: Visitor<'de>,
                {
                    self.map
                        .next_value_seed(SeedTupleVariant {
                            len: len,
                            visitor: visitor,
                        })
                }
                fn struct_variant<V>(
                    mut self,
                    _fields: &'static [&'static str],
                    visitor: V,
                ) -> Result<V::Value, Self::Error>
                where
                    V: Visitor<'de>,
                {
                    self.map
                        .next_value_seed(SeedStructVariant {
                            visitor: visitor,
                        })
                }
            }
            struct SeedTupleVariant<V> {
                len: usize,
                visitor: V,
            }
            impl<'de, V> DeserializeSeed<'de> for SeedTupleVariant<V>
            where
                V: Visitor<'de>,
            {
                type Value = V::Value;
                fn deserialize<D>(self, deserializer: D) -> Result<Self::Value, D::Error>
                where
                    D: Deserializer<'de>,
                {
                    deserializer.deserialize_tuple(self.len, self.visitor)
                }
            }
            struct SeedStructVariant<V> {
                visitor: V,
            }
            impl<'de, V> DeserializeSeed<'de> for SeedStructVariant<V>
            where
                V: Visitor<'de>,
            {
                type Value = V::Value;
                fn deserialize<D>(self, deserializer: D) -> Result<Self::Value, D::Error>
                where
                    D: Deserializer<'de>,
                {
                    deserializer.deserialize_map(self.visitor)
                }
            }
            pub trait Pair {
                type First;
                type Second;
                fn split(self) -> (Self::First, Self::Second);
            }
            impl<A, B> Pair for (A, B) {
                type First = A;
                type Second = B;
                fn split(self) -> (A, B) {
                    self
                }
            }
            pub type First<T> = <T as Pair>::First;
            pub type Second<T> = <T as Pair>::Second;
        }
    }
    #[cfg(not(no_integer128))]
    mod format {
        use lib::fmt::{self, Write};
        use lib::str;
        pub struct Buf<'a> {
            bytes: &'a mut [u8],
            offset: usize,
        }
        impl<'a> Buf<'a> {
            pub fn new(bytes: &'a mut [u8]) -> Self {
                Buf { bytes, offset: 0 }
            }
            pub fn as_str(&self) -> &str {
                let slice = &self.bytes[..self.offset];
                unsafe { str::from_utf8_unchecked(slice) }
            }
        }
        impl<'a> Write for Buf<'a> {
            fn write_str(&mut self, s: &str) -> fmt::Result {
                if self.offset + s.len() > self.bytes.len() {
                    Err(fmt::Error)
                } else {
                    self.bytes[self.offset..self.offset + s.len()]
                        .copy_from_slice(s.as_bytes());
                    self.offset += s.len();
                    Ok(())
                }
            }
        }
    }
    mod ignored_any {
        use lib::*;
        use de::{
            Deserialize, Deserializer, EnumAccess, Error, MapAccess, SeqAccess,
            VariantAccess, Visitor,
        };
        pub struct IgnoredAny;
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl ::core::marker::Copy for IgnoredAny {}
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl ::core::clone::Clone for IgnoredAny {
            #[inline]
            fn clone(&self) -> IgnoredAny {
                { *self }
            }
        }
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl ::core::fmt::Debug for IgnoredAny {
            fn fmt(&self, f: &mut ::core::fmt::Formatter) -> ::core::fmt::Result {
                match *self {
                    Self => ::core::fmt::Formatter::write_str(f, "IgnoredAny"),
                }
            }
        }
        #[automatically_derived]
        #[allow(unused_qualifications)]
        impl ::core::default::Default for IgnoredAny {
            #[inline]
            fn default() -> IgnoredAny {
                IgnoredAny {}
            }
        }
        impl<'de> Visitor<'de> for IgnoredAny {
            type Value = IgnoredAny;
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("anything at all")
            }
            #[inline]
            fn visit_bool<E>(self, x: bool) -> Result<Self::Value, E> {
                let _ = x;
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_i64<E>(self, x: i64) -> Result<Self::Value, E> {
                let _ = x;
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_i128<E>(self, x: i128) -> Result<Self::Value, E> {
                let _ = x;
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_u64<E>(self, x: u64) -> Result<Self::Value, E> {
                let _ = x;
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_u128<E>(self, x: u128) -> Result<Self::Value, E> {
                let _ = x;
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_f64<E>(self, x: f64) -> Result<Self::Value, E> {
                let _ = x;
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_str<E>(self, s: &str) -> Result<Self::Value, E>
            where
                E: Error,
            {
                let _ = s;
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_none<E>(self) -> Result<Self::Value, E> {
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_some<D>(self, deserializer: D) -> Result<Self::Value, D::Error>
            where
                D: Deserializer<'de>,
            {
                IgnoredAny::deserialize(deserializer)
            }
            #[inline]
            fn visit_newtype_struct<D>(
                self,
                deserializer: D,
            ) -> Result<Self::Value, D::Error>
            where
                D: Deserializer<'de>,
            {
                IgnoredAny::deserialize(deserializer)
            }
            #[inline]
            fn visit_unit<E>(self) -> Result<Self::Value, E> {
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                while let Some(IgnoredAny) = match seq.next_element() {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                } {}
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_map<A>(self, mut map: A) -> Result<Self::Value, A::Error>
            where
                A: MapAccess<'de>,
            {
                while let Some((IgnoredAny, IgnoredAny)) = match map.next_entry() {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                } {}
                Ok(IgnoredAny)
            }
            #[inline]
            fn visit_bytes<E>(self, bytes: &[u8]) -> Result<Self::Value, E>
            where
                E: Error,
            {
                let _ = bytes;
                Ok(IgnoredAny)
            }
            fn visit_enum<A>(self, data: A) -> Result<Self::Value, A::Error>
            where
                A: EnumAccess<'de>,
            {
                data.variant::<IgnoredAny>()?.1.newtype_variant()
            }
        }
        impl<'de> Deserialize<'de> for IgnoredAny {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<IgnoredAny, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_ignored_any(IgnoredAny)
            }
        }
    }
    mod impls {
        use lib::*;
        use de::{
            Deserialize, Deserializer, EnumAccess, Error, SeqAccess, Unexpected,
            VariantAccess, Visitor,
        };
        #[cfg(any(feature = "std", feature = "alloc", not(no_core_duration)))]
        use de::MapAccess;
        use seed::InPlaceSeed;
        #[cfg(any(feature = "std", feature = "alloc"))]
        use __private::size_hint;
        struct UnitVisitor;
        impl<'de> Visitor<'de> for UnitVisitor {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("unit")
            }
            fn visit_unit<E>(self) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(())
            }
        }
        impl<'de> Deserialize<'de> for () {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_unit(UnitVisitor)
            }
        }
        struct BoolVisitor;
        impl<'de> Visitor<'de> for BoolVisitor {
            type Value = bool;
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("a boolean")
            }
            fn visit_bool<E>(self, v: bool) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(v)
            }
        }
        impl<'de> Deserialize<'de> for bool {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_bool(BoolVisitor)
            }
        }
        impl<'de> Deserialize<'de> for i8 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = i8;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("i8")
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if Self::Value::min_value() as i64 <= v as i64
                            && v as i64 <= Self::Value::max_value() as i64
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if Self::Value::min_value() as i64 <= v as i64
                            && v as i64 <= Self::Value::max_value() as i64
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if Self::Value::min_value() as i64 <= v as i64
                            && v as i64 <= Self::Value::max_value() as i64
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_i8(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero), not(no_num_nonzero_signed)))]
        impl<'de> Deserialize<'de> for num::NonZeroI8 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroI8;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero i8")
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if i8::min_value() as i64 <= v as i64
                            && v as i64 <= i8::max_value() as i64
                        {
                            if let Some(nonzero) = Self::Value::new(v as i8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if i8::min_value() as i64 <= v as i64
                            && v as i64 <= i8::max_value() as i64
                        {
                            if let Some(nonzero) = Self::Value::new(v as i8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if i8::min_value() as i64 <= v as i64
                            && v as i64 <= i8::max_value() as i64
                        {
                            if let Some(nonzero) = Self::Value::new(v as i8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_i8(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for i16 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = i16;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("i16")
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if Self::Value::min_value() as i64 <= v as i64
                            && v as i64 <= Self::Value::max_value() as i64
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if Self::Value::min_value() as i64 <= v as i64
                            && v as i64 <= Self::Value::max_value() as i64
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_i16(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero), not(no_num_nonzero_signed)))]
        impl<'de> Deserialize<'de> for num::NonZeroI16 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroI16;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero i16")
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i16) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if i16::min_value() as i64 <= v as i64
                            && v as i64 <= i16::max_value() as i64
                        {
                            if let Some(nonzero) = Self::Value::new(v as i16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if i16::min_value() as i64 <= v as i64
                            && v as i64 <= i16::max_value() as i64
                        {
                            if let Some(nonzero) = Self::Value::new(v as i16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_i16(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for i32 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = i32;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("i32")
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if Self::Value::min_value() as i64 <= v as i64
                            && v as i64 <= Self::Value::max_value() as i64
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_i32(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero), not(no_num_nonzero_signed)))]
        impl<'de> Deserialize<'de> for num::NonZeroI32 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroI32;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero i32")
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i32) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i32) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if i32::min_value() as i64 <= v as i64
                            && v as i64 <= i32::max_value() as i64
                        {
                            if let Some(nonzero) = Self::Value::new(v as i32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_i32(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for i64 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = i64;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("i64")
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_i64(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero), not(no_num_nonzero_signed)))]
        impl<'de> Deserialize<'de> for num::NonZeroI64 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroI64;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero i64")
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i64) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i64) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i64) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i64::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i64) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i64::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i64) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i64::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i64) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= i64::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as i64) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_i64(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for isize {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = isize;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("isize")
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if Self::Value::min_value() as i64 <= v as i64
                            && v as i64 <= Self::Value::max_value() as i64
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if Self::Value::min_value() as i64 <= v as i64
                            && v as i64 <= Self::Value::max_value() as i64
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_i64(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero), not(no_num_nonzero_signed)))]
        impl<'de> Deserialize<'de> for num::NonZeroIsize {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroIsize;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero isize")
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as isize) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as isize) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if isize::min_value() as i64 <= v as i64
                            && v as i64 <= isize::max_value() as i64
                        {
                            if let Some(nonzero) = Self::Value::new(v as isize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if isize::min_value() as i64 <= v as i64
                            && v as i64 <= isize::max_value() as i64
                        {
                            if let Some(nonzero) = Self::Value::new(v as isize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= isize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as isize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= isize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as isize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= isize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as isize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= isize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as isize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_i64(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for u8 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = u8;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("u8")
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_u8(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero)))]
        impl<'de> Deserialize<'de> for num::NonZeroU8 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroU8;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero u8")
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= u8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= u8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= u8::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u8) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_u8(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for u16 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = u16;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("u16")
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_u16(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero)))]
        impl<'de> Deserialize<'de> for num::NonZeroU16 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroU16;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero u16")
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u16) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= u16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= u16::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u16) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_u16(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for u32 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = u32;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("u32")
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_u32(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero)))]
        impl<'de> Deserialize<'de> for num::NonZeroU32 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroU32;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero u32")
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u32) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u32) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= u32::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u32) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_u32(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for u64 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = u64;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("u64")
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_u64(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero)))]
        impl<'de> Deserialize<'de> for num::NonZeroU64 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroU64;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero u64")
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u64) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u64) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u64) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u64::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u64) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u64::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u64) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u64::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u64) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u64::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u64) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                }
                deserializer.deserialize_u64(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for usize {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = usize;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("usize")
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Unsigned(v as u64), &self),
                            )
                        }
                    }
                }
                deserializer.deserialize_u64(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero)))]
        impl<'de> Deserialize<'de> for num::NonZeroUsize {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroUsize;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero usize")
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as usize) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as usize) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= usize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as usize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= usize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as usize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= usize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as usize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= usize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as usize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= usize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as usize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as u64 <= usize::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as usize) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Unsigned(v as u64), &self))
                    }
                }
                deserializer.deserialize_u64(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for f32 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = f32;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("f32")
                    }
                    #[inline]
                    fn visit_f32<E>(self, v: f32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_f64<E>(self, v: f64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                }
                deserializer.deserialize_f32(PrimitiveVisitor)
            }
        }
        impl<'de> Deserialize<'de> for f64 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = f64;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("f64")
                    }
                    #[inline]
                    fn visit_f64<E>(self, v: f64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_f32<E>(self, v: f32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                }
                deserializer.deserialize_f64(PrimitiveVisitor)
            }
        }
        impl<'de> Deserialize<'de> for i128 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = i128;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("i128")
                    }
                    #[inline]
                    fn visit_i128<E>(self, v: i128) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    fn visit_u128<E>(self, v: u128) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as i128 >= Self::Value::min_value() as i128
                            && v as u128 <= Self::Value::max_value() as u128
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(Error::invalid_value(Unexpected::Other("u128"), &self))
                        }
                    }
                }
                deserializer.deserialize_i128(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero), not(no_num_nonzero_signed)))]
        impl<'de> Deserialize<'de> for num::NonZeroI128 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroI128;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero i128")
                    }
                    fn visit_i128<E>(self, v: i128) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as i128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u128<E>(self, v: u128) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as i128 >= i128::min_value() as i128
                            && v as u128 <= i128::max_value() as u128
                        {
                            if let Some(nonzero) = Self::Value::new(v as i128) {
                                Ok(nonzero)
                            } else {
                                Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                            }
                        } else {
                            Err(Error::invalid_value(Unexpected::Other("u128"), &self))
                        }
                    }
                }
                deserializer.deserialize_i128(NonZeroVisitor)
            }
        }
        impl<'de> Deserialize<'de> for u128 {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct PrimitiveVisitor;
                impl<'de> Visitor<'de> for PrimitiveVisitor {
                    type Value = u128;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("u128")
                    }
                    #[inline]
                    fn visit_u128<E>(self, v: u128) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v)
                    }
                    #[inline]
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        Ok(v as Self::Value)
                    }
                    #[inline]
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    #[inline]
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 <= v && v as u64 <= Self::Value::max_value() as u64 {
                            Ok(v as Self::Value)
                        } else {
                            Err(
                                Error::invalid_value(Unexpected::Signed(v as i64), &self),
                            )
                        }
                    }
                    fn visit_i128<E>(self, v: i128) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as i128 >= Self::Value::min_value() as i128
                            && v as u128 <= Self::Value::max_value() as u128
                        {
                            Ok(v as Self::Value)
                        } else {
                            Err(Error::invalid_value(Unexpected::Other("i128"), &self))
                        }
                    }
                }
                deserializer.deserialize_u128(PrimitiveVisitor)
            }
        }
        #[cfg(all(not(no_num_nonzero)))]
        impl<'de> Deserialize<'de> for num::NonZeroU128 {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct NonZeroVisitor;
                impl<'de> Visitor<'de> for NonZeroVisitor {
                    type Value = num::NonZeroU128;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a nonzero u128")
                    }
                    fn visit_u128<E>(self, v: u128) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u8<E>(self, v: u8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u16<E>(self, v: u16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u32<E>(self, v: u32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_u64<E>(self, v: u64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if let Some(nonzero) = Self::Value::new(v as u128) {
                            Ok(nonzero)
                        } else {
                            Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                        }
                    }
                    fn visit_i8<E>(self, v: i8) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u128::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u128) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i16<E>(self, v: i16) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u128::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u128) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i32<E>(self, v: i32) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u128::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u128) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i64<E>(self, v: i64) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if 0 < v && v as u64 <= u128::max_value() as u64 {
                            if let Some(nonzero) = Self::Value::new(v as u128) {
                                return Ok(nonzero);
                            }
                        }
                        Err(Error::invalid_value(Unexpected::Signed(v as i64), &self))
                    }
                    fn visit_i128<E>(self, v: i128) -> Result<Self::Value, E>
                    where
                        E: Error,
                    {
                        if v as i128 >= u128::min_value() as i128
                            && v as u128 <= u128::max_value() as u128
                        {
                            if let Some(nonzero) = Self::Value::new(v as u128) {
                                Ok(nonzero)
                            } else {
                                Err(Error::invalid_value(Unexpected::Unsigned(0), &self))
                            }
                        } else {
                            Err(Error::invalid_value(Unexpected::Other("i128"), &self))
                        }
                    }
                }
                deserializer.deserialize_u128(NonZeroVisitor)
            }
        }
        struct CharVisitor;
        impl<'de> Visitor<'de> for CharVisitor {
            type Value = char;
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("a character")
            }
            #[inline]
            fn visit_char<E>(self, v: char) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(v)
            }
            #[inline]
            fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
            where
                E: Error,
            {
                let mut iter = v.chars();
                match (iter.next(), iter.next()) {
                    (Some(c), None) => Ok(c),
                    _ => Err(Error::invalid_value(Unexpected::Str(v), &self)),
                }
            }
        }
        impl<'de> Deserialize<'de> for char {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_char(CharVisitor)
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        struct StringVisitor;
        #[cfg(any(feature = "std", feature = "alloc"))]
        struct StringInPlaceVisitor<'a>(&'a mut String);
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de> Visitor<'de> for StringVisitor {
            type Value = String;
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("a string")
            }
            fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(v.to_owned())
            }
            fn visit_string<E>(self, v: String) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(v)
            }
            fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
            where
                E: Error,
            {
                match str::from_utf8(v) {
                    Ok(s) => Ok(s.to_owned()),
                    Err(_) => Err(Error::invalid_value(Unexpected::Bytes(v), &self)),
                }
            }
            fn visit_byte_buf<E>(self, v: Vec<u8>) -> Result<Self::Value, E>
            where
                E: Error,
            {
                match String::from_utf8(v) {
                    Ok(s) => Ok(s),
                    Err(e) => {
                        Err(
                            Error::invalid_value(
                                Unexpected::Bytes(&e.into_bytes()),
                                &self,
                            ),
                        )
                    }
                }
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'a, 'de> Visitor<'de> for StringInPlaceVisitor<'a> {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("a string")
            }
            fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
            where
                E: Error,
            {
                self.0.clear();
                self.0.push_str(v);
                Ok(())
            }
            fn visit_string<E>(self, v: String) -> Result<Self::Value, E>
            where
                E: Error,
            {
                *self.0 = v;
                Ok(())
            }
            fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
            where
                E: Error,
            {
                match str::from_utf8(v) {
                    Ok(s) => {
                        self.0.clear();
                        self.0.push_str(s);
                        Ok(())
                    }
                    Err(_) => Err(Error::invalid_value(Unexpected::Bytes(v), &self)),
                }
            }
            fn visit_byte_buf<E>(self, v: Vec<u8>) -> Result<Self::Value, E>
            where
                E: Error,
            {
                match String::from_utf8(v) {
                    Ok(s) => {
                        *self.0 = s;
                        Ok(())
                    }
                    Err(e) => {
                        Err(
                            Error::invalid_value(
                                Unexpected::Bytes(&e.into_bytes()),
                                &self,
                            ),
                        )
                    }
                }
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de> Deserialize<'de> for String {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_string(StringVisitor)
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_string(StringInPlaceVisitor(place))
            }
        }
        struct StrVisitor;
        impl<'a> Visitor<'a> for StrVisitor {
            type Value = &'a str;
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("a borrowed string")
            }
            fn visit_borrowed_str<E>(self, v: &'a str) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(v)
            }
            fn visit_borrowed_bytes<E>(self, v: &'a [u8]) -> Result<Self::Value, E>
            where
                E: Error,
            {
                str::from_utf8(v)
                    .map_err(|_| Error::invalid_value(Unexpected::Bytes(v), &self))
            }
        }
        impl<'de: 'a, 'a> Deserialize<'de> for &'a str {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_str(StrVisitor)
            }
        }
        struct BytesVisitor;
        impl<'a> Visitor<'a> for BytesVisitor {
            type Value = &'a [u8];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("a borrowed byte array")
            }
            fn visit_borrowed_bytes<E>(self, v: &'a [u8]) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(v)
            }
            fn visit_borrowed_str<E>(self, v: &'a str) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(v.as_bytes())
            }
        }
        impl<'de: 'a, 'a> Deserialize<'de> for &'a [u8] {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_bytes(BytesVisitor)
            }
        }
        #[cfg(feature = "std")]
        struct CStringVisitor;
        #[cfg(feature = "std")]
        impl<'de> Visitor<'de> for CStringVisitor {
            type Value = CString;
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("byte array")
            }
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let len = size_hint::cautious(seq.size_hint());
                let mut values = Vec::with_capacity(len);
                while let Some(value) = match seq.next_element() {
                    ::core::result::Result::Ok(val) => val,
                    ::core::result::Result::Err(err) => {
                        return ::core::result::Result::Err(
                            ::core::convert::From::from(err),
                        );
                    }
                } {
                    values.push(value);
                }
                CString::new(values).map_err(Error::custom)
            }
            fn visit_bytes<E>(self, v: &[u8]) -> Result<Self::Value, E>
            where
                E: Error,
            {
                CString::new(v).map_err(Error::custom)
            }
            fn visit_byte_buf<E>(self, v: Vec<u8>) -> Result<Self::Value, E>
            where
                E: Error,
            {
                CString::new(v).map_err(Error::custom)
            }
            fn visit_str<E>(self, v: &str) -> Result<Self::Value, E>
            where
                E: Error,
            {
                CString::new(v).map_err(Error::custom)
            }
            fn visit_string<E>(self, v: String) -> Result<Self::Value, E>
            where
                E: Error,
            {
                CString::new(v).map_err(Error::custom)
            }
        }
        #[cfg(feature = "std")]
        impl<'de> Deserialize<'de> for CString {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_byte_buf(CStringVisitor)
            }
        }
        impl<'de> Deserialize<'de> for Box<CStr> {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                Deserialize::deserialize(deserializer).map(CString::into_boxed_c_str)
            }
        }
        impl<'de, T: Deserialize<'de>> Deserialize<'de> for Reverse<T> {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                Deserialize::deserialize(deserializer).map(Reverse)
            }
        }
        struct OptionVisitor<T> {
            marker: PhantomData<T>,
        }
        impl<'de, T> Visitor<'de> for OptionVisitor<T>
        where
            T: Deserialize<'de>,
        {
            type Value = Option<T>;
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("option")
            }
            #[inline]
            fn visit_unit<E>(self) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(None)
            }
            #[inline]
            fn visit_none<E>(self) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(None)
            }
            #[inline]
            fn visit_some<D>(self, deserializer: D) -> Result<Self::Value, D::Error>
            where
                D: Deserializer<'de>,
            {
                T::deserialize(deserializer).map(Some)
            }
            #[doc(hidden)]
            fn __private_visit_untagged_option<D>(
                self,
                deserializer: D,
            ) -> Result<Self::Value, ()>
            where
                D: Deserializer<'de>,
            {
                Ok(T::deserialize(deserializer).ok())
            }
        }
        impl<'de, T> Deserialize<'de> for Option<T>
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer
                    .deserialize_option(OptionVisitor {
                        marker: PhantomData,
                    })
            }
        }
        struct PhantomDataVisitor<T: ?Sized> {
            marker: PhantomData<T>,
        }
        impl<'de, T: ?Sized> Visitor<'de> for PhantomDataVisitor<T> {
            type Value = PhantomData<T>;
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("unit")
            }
            #[inline]
            fn visit_unit<E>(self) -> Result<Self::Value, E>
            where
                E: Error,
            {
                Ok(PhantomData)
            }
        }
        impl<'de, T: ?Sized> Deserialize<'de> for PhantomData<T> {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                let visitor = PhantomDataVisitor {
                    marker: PhantomData,
                };
                deserializer.deserialize_unit_struct("PhantomData", visitor)
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        fn nop_reserve<T>(_seq: T, _n: usize) {}
        impl<'de, T> Deserialize<'de> for BinaryHeap<T>
        where
            T: Deserialize<'de> + Ord,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqVisitor<T> {
                    marker: PhantomData<BinaryHeap<T>>,
                }
                impl<'de, T> Visitor<'de> for SeqVisitor<T>
                where
                    T: Deserialize<'de> + Ord,
                {
                    type Value = BinaryHeap<T>;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let mut values = BinaryHeap::with_capacity(
                            size_hint::cautious(seq.size_hint()),
                        );
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            BinaryHeap::push(&mut values, value);
                        }
                        Ok(values)
                    }
                }
                let visitor = SeqVisitor { marker: PhantomData };
                deserializer.deserialize_seq(visitor)
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqInPlaceVisitor<'a, T: 'a>(&'a mut BinaryHeap<T>);
                impl<'a, 'de, T> Visitor<'de> for SeqInPlaceVisitor<'a, T>
                where
                    T: Deserialize<'de> + Ord,
                {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(
                        mut self,
                        mut seq: A,
                    ) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        BinaryHeap::clear(&mut self.0);
                        BinaryHeap::reserve(
                            &mut self.0,
                            size_hint::cautious(seq.size_hint()),
                        );
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            BinaryHeap::push(&mut self.0, value);
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_seq(SeqInPlaceVisitor(place))
            }
        }
        impl<'de, T> Deserialize<'de> for BTreeSet<T>
        where
            T: Deserialize<'de> + Eq + Ord,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqVisitor<T> {
                    marker: PhantomData<BTreeSet<T>>,
                }
                impl<'de, T> Visitor<'de> for SeqVisitor<T>
                where
                    T: Deserialize<'de> + Eq + Ord,
                {
                    type Value = BTreeSet<T>;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let mut values = BTreeSet::new();
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            BTreeSet::insert(&mut values, value);
                        }
                        Ok(values)
                    }
                }
                let visitor = SeqVisitor { marker: PhantomData };
                deserializer.deserialize_seq(visitor)
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqInPlaceVisitor<'a, T: 'a>(&'a mut BTreeSet<T>);
                impl<'a, 'de, T> Visitor<'de> for SeqInPlaceVisitor<'a, T>
                where
                    T: Deserialize<'de> + Eq + Ord,
                {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(
                        mut self,
                        mut seq: A,
                    ) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        BTreeSet::clear(&mut self.0);
                        nop_reserve(&mut self.0, size_hint::cautious(seq.size_hint()));
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            BTreeSet::insert(&mut self.0, value);
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_seq(SeqInPlaceVisitor(place))
            }
        }
        impl<'de, T> Deserialize<'de> for LinkedList<T>
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqVisitor<T> {
                    marker: PhantomData<LinkedList<T>>,
                }
                impl<'de, T> Visitor<'de> for SeqVisitor<T>
                where
                    T: Deserialize<'de>,
                {
                    type Value = LinkedList<T>;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let mut values = LinkedList::new();
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            LinkedList::push_back(&mut values, value);
                        }
                        Ok(values)
                    }
                }
                let visitor = SeqVisitor { marker: PhantomData };
                deserializer.deserialize_seq(visitor)
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqInPlaceVisitor<'a, T: 'a>(&'a mut LinkedList<T>);
                impl<'a, 'de, T> Visitor<'de> for SeqInPlaceVisitor<'a, T>
                where
                    T: Deserialize<'de>,
                {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(
                        mut self,
                        mut seq: A,
                    ) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        LinkedList::clear(&mut self.0);
                        nop_reserve(&mut self.0, size_hint::cautious(seq.size_hint()));
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            LinkedList::push_back(&mut self.0, value);
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_seq(SeqInPlaceVisitor(place))
            }
        }
        impl<'de, T, S> Deserialize<'de> for HashSet<T, S>
        where
            T: Deserialize<'de> + Eq + Hash,
            S: BuildHasher + Default,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqVisitor<T, S> {
                    marker: PhantomData<HashSet<T, S>>,
                }
                impl<'de, T, S> Visitor<'de> for SeqVisitor<T, S>
                where
                    T: Deserialize<'de> + Eq + Hash,
                    S: BuildHasher + Default,
                {
                    type Value = HashSet<T, S>;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let mut values = HashSet::with_capacity_and_hasher(
                            size_hint::cautious(seq.size_hint()),
                            S::default(),
                        );
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            HashSet::insert(&mut values, value);
                        }
                        Ok(values)
                    }
                }
                let visitor = SeqVisitor { marker: PhantomData };
                deserializer.deserialize_seq(visitor)
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqInPlaceVisitor<'a, T: 'a, S: 'a>(&'a mut HashSet<T, S>);
                impl<'a, 'de, T, S> Visitor<'de> for SeqInPlaceVisitor<'a, T, S>
                where
                    T: Deserialize<'de> + Eq + Hash,
                    S: BuildHasher + Default,
                {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(
                        mut self,
                        mut seq: A,
                    ) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        HashSet::clear(&mut self.0);
                        HashSet::reserve(
                            &mut self.0,
                            size_hint::cautious(seq.size_hint()),
                        );
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            HashSet::insert(&mut self.0, value);
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_seq(SeqInPlaceVisitor(place))
            }
        }
        impl<'de, T> Deserialize<'de> for VecDeque<T>
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqVisitor<T> {
                    marker: PhantomData<VecDeque<T>>,
                }
                impl<'de, T> Visitor<'de> for SeqVisitor<T>
                where
                    T: Deserialize<'de>,
                {
                    type Value = VecDeque<T>;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let mut values = VecDeque::with_capacity(
                            size_hint::cautious(seq.size_hint()),
                        );
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            VecDeque::push_back(&mut values, value);
                        }
                        Ok(values)
                    }
                }
                let visitor = SeqVisitor { marker: PhantomData };
                deserializer.deserialize_seq(visitor)
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct SeqInPlaceVisitor<'a, T: 'a>(&'a mut VecDeque<T>);
                impl<'a, 'de, T> Visitor<'de> for SeqInPlaceVisitor<'a, T>
                where
                    T: Deserialize<'de>,
                {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    #[inline]
                    fn visit_seq<A>(
                        mut self,
                        mut seq: A,
                    ) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        VecDeque::clear(&mut self.0);
                        VecDeque::reserve(
                            &mut self.0,
                            size_hint::cautious(seq.size_hint()),
                        );
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            VecDeque::push_back(&mut self.0, value);
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_seq(SeqInPlaceVisitor(place))
            }
        }
        #[cfg(any(feature = "std", feature = "alloc"))]
        impl<'de, T> Deserialize<'de> for Vec<T>
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct VecVisitor<T> {
                    marker: PhantomData<T>,
                }
                impl<'de, T> Visitor<'de> for VecVisitor<T>
                where
                    T: Deserialize<'de>,
                {
                    type Value = Vec<T>;
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let mut values = Vec::with_capacity(
                            size_hint::cautious(seq.size_hint()),
                        );
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            values.push(value);
                        }
                        Ok(values)
                    }
                }
                let visitor = VecVisitor { marker: PhantomData };
                deserializer.deserialize_seq(visitor)
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct VecInPlaceVisitor<'a, T: 'a>(&'a mut Vec<T>);
                impl<'a, 'de, T> Visitor<'de> for VecInPlaceVisitor<'a, T>
                where
                    T: Deserialize<'de>,
                {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a sequence")
                    }
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let hint = size_hint::cautious(seq.size_hint());
                        if let Some(additional) = hint.checked_sub(self.0.len()) {
                            self.0.reserve(additional);
                        }
                        for i in 0..self.0.len() {
                            let next = {
                                let next_place = InPlaceSeed(&mut self.0[i]);
                                match seq.next_element_seed(next_place) {
                                    ::core::result::Result::Ok(val) => val,
                                    ::core::result::Result::Err(err) => {
                                        return ::core::result::Result::Err(
                                            ::core::convert::From::from(err),
                                        );
                                    }
                                }
                            };
                            if next.is_none() {
                                self.0.truncate(i);
                                return Ok(());
                            }
                        }
                        while let Some(value) = match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            self.0.push(value);
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_seq(VecInPlaceVisitor(place))
            }
        }
        struct ArrayVisitor<A> {
            marker: PhantomData<A>,
        }
        struct ArrayInPlaceVisitor<'a, A: 'a>(&'a mut A);
        impl<A> ArrayVisitor<A> {
            fn new() -> Self {
                ArrayVisitor {
                    marker: PhantomData,
                }
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 0]> {
            type Value = [T; 0];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an empty array")
            }
            #[inline]
            fn visit_seq<A>(self, _: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([])
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 0] {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(0, ArrayVisitor::<[T; 0]>::new())
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 1]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 1];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 1")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 1]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 1")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 1]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(1, ArrayVisitor::<[T; 1]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(1, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 2]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 2];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 2")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 2]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 2")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 2]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(2, ArrayVisitor::<[T; 2]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(2, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 3]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 3];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 3")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 3]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 3")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 3]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(3, ArrayVisitor::<[T; 3]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(3, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 4]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 4];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 4")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 4]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 4")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 4]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(4, ArrayVisitor::<[T; 4]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(4, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 5]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 5];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 5")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 5]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 5")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 5]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(5, ArrayVisitor::<[T; 5]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(5, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 6]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 6];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 6")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 6]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 6")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 6]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(6, ArrayVisitor::<[T; 6]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(6, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 7]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 7];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 7")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 7]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 7")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 7]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(7, ArrayVisitor::<[T; 7]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(7, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 8]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 8];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 8")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 8]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 8")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 8]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(8, ArrayVisitor::<[T; 8]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(8, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 9]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 9];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 9")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 9]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 9")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 9]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(9, ArrayVisitor::<[T; 9]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(9, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 10]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 10];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 10")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 10]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 10")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 10]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(10, ArrayVisitor::<[T; 10]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(10, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 11]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 11];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 11")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 11]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 11")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 11]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(11, ArrayVisitor::<[T; 11]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(11, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 12]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 12];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 12")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 12]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 12")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 12]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(12, ArrayVisitor::<[T; 12]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(12, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 13]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 13];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 13")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 13]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 13")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 13]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(13, ArrayVisitor::<[T; 13]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(13, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 14]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 14];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 14")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 14]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 14")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 14]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(14, ArrayVisitor::<[T; 14]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(14, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 15]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 15];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 15")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 15]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 15")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 15]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(15, ArrayVisitor::<[T; 15]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(15, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 16]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 16];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 16")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 16]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 16")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 16]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(16, ArrayVisitor::<[T; 16]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(16, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 17]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 17];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 17")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 17]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 17")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 17]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(17, ArrayVisitor::<[T; 17]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(17, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 18]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 18];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 18")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 18]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 18")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 18]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(18, ArrayVisitor::<[T; 18]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(18, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 19]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 19];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 19")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 19]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 19")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 19]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(19, ArrayVisitor::<[T; 19]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(19, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 20]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 20];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 20")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 20]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 20")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 20]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(20, ArrayVisitor::<[T; 20]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(20, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 21]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 21];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 21")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 21]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 21")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 21]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(21, ArrayVisitor::<[T; 21]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(21, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 22]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 22];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 22")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 22]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 22")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 22]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(22, ArrayVisitor::<[T; 22]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(22, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 23]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 23];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 23")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 23]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 23")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 23]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(23, ArrayVisitor::<[T; 23]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(23, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 24]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 24];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 24")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 24]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 24")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 24]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(24, ArrayVisitor::<[T; 24]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(24, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 25]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 25];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 25")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(24, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 25]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 25")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 25]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(25, ArrayVisitor::<[T; 25]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(25, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 26]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 26];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 26")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(24, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(25, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 26]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 26")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 26]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(26, ArrayVisitor::<[T; 26]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(26, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 27]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 27];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 27")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(24, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(25, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(26, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 27]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 27")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 27]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(27, ArrayVisitor::<[T; 27]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(27, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 28]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 28];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 28")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(24, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(25, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(26, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(27, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 28]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 28")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 28]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(28, ArrayVisitor::<[T; 28]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(28, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 29]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 29];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 29")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(24, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(25, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(26, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(27, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(28, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 29]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 29")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 29]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(29, ArrayVisitor::<[T; 29]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(29, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 30]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 30];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 30")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(24, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(25, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(26, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(27, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(28, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(29, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 30]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 30")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 30]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(30, ArrayVisitor::<[T; 30]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(30, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 31]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 31];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 31")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(24, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(25, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(26, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(27, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(28, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(29, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(30, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 31]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 31")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 31]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(31, ArrayVisitor::<[T; 31]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(31, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T> Visitor<'de> for ArrayVisitor<[T; 32]>
        where
            T: Deserialize<'de>,
        {
            type Value = [T; 32];
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 32")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                Ok([
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(0, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(1, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(2, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(3, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(4, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(5, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(6, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(7, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(8, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(9, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(10, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(11, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(12, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(13, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(14, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(15, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(16, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(17, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(18, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(19, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(20, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(21, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(22, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(23, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(24, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(25, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(26, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(27, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(28, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(29, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(30, &self)),
                    },
                    match match seq.next_element() {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    } {
                        Some(val) => val,
                        None => return Err(Error::invalid_length(31, &self)),
                    },
                ])
            }
        }
        impl<'a, 'de, T> Visitor<'de> for ArrayInPlaceVisitor<'a, [T; 32]>
        where
            T: Deserialize<'de>,
        {
            type Value = ();
            fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                formatter.write_str("an array of length 32")
            }
            #[inline]
            fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
            where
                A: SeqAccess<'de>,
            {
                let mut fail_idx = None;
                for (idx, dest) in self.0[..].iter_mut().enumerate() {
                    if match seq.next_element_seed(InPlaceSeed(dest)) {
                        ::core::result::Result::Ok(val) => val,
                        ::core::result::Result::Err(err) => {
                            return ::core::result::Result::Err(
                                ::core::convert::From::from(err),
                            );
                        }
                    }
                        .is_none()
                    {
                        fail_idx = Some(idx);
                        break;
                    }
                }
                if let Some(idx) = fail_idx {
                    return Err(Error::invalid_length(idx, &self));
                }
                Ok(())
            }
        }
        impl<'de, T> Deserialize<'de> for [T; 32]
        where
            T: Deserialize<'de>,
        {
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(32, ArrayVisitor::<[T; 32]>::new())
            }
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                deserializer.deserialize_tuple(32, ArrayInPlaceVisitor(place))
            }
        }
        impl<'de, T0: Deserialize<'de>> Deserialize<'de> for (T0,) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0> {
                    marker: PhantomData<(T0,)>,
                }
                impl<'de, T0: Deserialize<'de>> Visitor<'de> for TupleVisitor<T0> {
                    type Value = (T0,);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 1")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        Ok((T0,))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        1,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<'a, T0: 'a>(&'a mut (T0,));
                impl<'a, 'de, T0: Deserialize<'de>> Visitor<'de>
                for TupleInPlaceVisitor<'a, T0> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 1")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(1, TupleInPlaceVisitor(place))
            }
        }
        impl<'de, T0: Deserialize<'de>, T1: Deserialize<'de>> Deserialize<'de>
        for (T0, T1) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1> {
                    marker: PhantomData<(T0, T1)>,
                }
                impl<'de, T0: Deserialize<'de>, T1: Deserialize<'de>> Visitor<'de>
                for TupleVisitor<T0, T1> {
                    type Value = (T0, T1);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 2")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        Ok((T0, T1))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        2,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<'a, T0: 'a, T1: 'a>(&'a mut (T0, T1));
                impl<'a, 'de, T0: Deserialize<'de>, T1: Deserialize<'de>> Visitor<'de>
                for TupleInPlaceVisitor<'a, T0, T1> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 2")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(2, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2> {
                    marker: PhantomData<(T0, T1, T2)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                > Visitor<'de> for TupleVisitor<T0, T1, T2> {
                    type Value = (T0, T1, T2);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 3")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        Ok((T0, T1, T2))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        3,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<'a, T0: 'a, T1: 'a, T2: 'a>(
                    &'a mut (T0, T1, T2),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                > Visitor<'de> for TupleInPlaceVisitor<'a, T0, T1, T2> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 3")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(3, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3> {
                    marker: PhantomData<(T0, T1, T2, T3)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                > Visitor<'de> for TupleVisitor<T0, T1, T2, T3> {
                    type Value = (T0, T1, T2, T3);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 4")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        Ok((T0, T1, T2, T3))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        4,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<'a, T0: 'a, T1: 'a, T2: 'a, T3: 'a>(
                    &'a mut (T0, T1, T2, T3),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                > Visitor<'de> for TupleInPlaceVisitor<'a, T0, T1, T2, T3> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 4")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).3)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(3, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(4, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
            T4: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3, T4) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3, T4> {
                    marker: PhantomData<(T0, T1, T2, T3, T4)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                > Visitor<'de> for TupleVisitor<T0, T1, T2, T3, T4> {
                    type Value = (T0, T1, T2, T3, T4);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 5")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        let T4 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(4, &self)),
                        };
                        Ok((T0, T1, T2, T3, T4))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        5,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<'a, T0: 'a, T1: 'a, T2: 'a, T3: 'a, T4: 'a>(
                    &'a mut (T0, T1, T2, T3, T4),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                > Visitor<'de> for TupleInPlaceVisitor<'a, T0, T1, T2, T3, T4> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 5")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).3)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(3, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).4)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(4, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(5, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
            T4: Deserialize<'de>,
            T5: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3, T4, T5) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3, T4, T5> {
                    marker: PhantomData<(T0, T1, T2, T3, T4, T5)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                > Visitor<'de> for TupleVisitor<T0, T1, T2, T3, T4, T5> {
                    type Value = (T0, T1, T2, T3, T4, T5);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 6")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        let T4 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(4, &self)),
                        };
                        let T5 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(5, &self)),
                        };
                        Ok((T0, T1, T2, T3, T4, T5))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        6,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<
                    'a,
                    T0: 'a,
                    T1: 'a,
                    T2: 'a,
                    T3: 'a,
                    T4: 'a,
                    T5: 'a,
                >(
                    &'a mut (T0, T1, T2, T3, T4, T5),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                > Visitor<'de> for TupleInPlaceVisitor<'a, T0, T1, T2, T3, T4, T5> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 6")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).3)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(3, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).4)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(4, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).5)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(5, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(6, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
            T4: Deserialize<'de>,
            T5: Deserialize<'de>,
            T6: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3, T4, T5, T6) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3, T4, T5, T6> {
                    marker: PhantomData<(T0, T1, T2, T3, T4, T5, T6)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                > Visitor<'de> for TupleVisitor<T0, T1, T2, T3, T4, T5, T6> {
                    type Value = (T0, T1, T2, T3, T4, T5, T6);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 7")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        let T4 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(4, &self)),
                        };
                        let T5 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(5, &self)),
                        };
                        let T6 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(6, &self)),
                        };
                        Ok((T0, T1, T2, T3, T4, T5, T6))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        7,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<
                    'a,
                    T0: 'a,
                    T1: 'a,
                    T2: 'a,
                    T3: 'a,
                    T4: 'a,
                    T5: 'a,
                    T6: 'a,
                >(
                    &'a mut (T0, T1, T2, T3, T4, T5, T6),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                > Visitor<'de> for TupleInPlaceVisitor<'a, T0, T1, T2, T3, T4, T5, T6> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 7")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).3)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(3, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).4)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(4, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).5)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(5, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).6)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(6, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(7, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
            T4: Deserialize<'de>,
            T5: Deserialize<'de>,
            T6: Deserialize<'de>,
            T7: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3, T4, T5, T6, T7) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7> {
                    marker: PhantomData<(T0, T1, T2, T3, T4, T5, T6, T7)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                > Visitor<'de> for TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7> {
                    type Value = (T0, T1, T2, T3, T4, T5, T6, T7);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 8")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        let T4 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(4, &self)),
                        };
                        let T5 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(5, &self)),
                        };
                        let T6 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(6, &self)),
                        };
                        let T7 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(7, &self)),
                        };
                        Ok((T0, T1, T2, T3, T4, T5, T6, T7))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        8,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<
                    'a,
                    T0: 'a,
                    T1: 'a,
                    T2: 'a,
                    T3: 'a,
                    T4: 'a,
                    T5: 'a,
                    T6: 'a,
                    T7: 'a,
                >(
                    &'a mut (T0, T1, T2, T3, T4, T5, T6, T7),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                > Visitor<'de>
                for TupleInPlaceVisitor<'a, T0, T1, T2, T3, T4, T5, T6, T7> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 8")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).3)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(3, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).4)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(4, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).5)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(5, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).6)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(6, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).7)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(7, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(8, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
            T4: Deserialize<'de>,
            T5: Deserialize<'de>,
            T6: Deserialize<'de>,
            T7: Deserialize<'de>,
            T8: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3, T4, T5, T6, T7, T8) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7, T8> {
                    marker: PhantomData<(T0, T1, T2, T3, T4, T5, T6, T7, T8)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                    T8: Deserialize<'de>,
                > Visitor<'de> for TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7, T8> {
                    type Value = (T0, T1, T2, T3, T4, T5, T6, T7, T8);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 9")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        let T4 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(4, &self)),
                        };
                        let T5 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(5, &self)),
                        };
                        let T6 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(6, &self)),
                        };
                        let T7 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(7, &self)),
                        };
                        let T8 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(8, &self)),
                        };
                        Ok((T0, T1, T2, T3, T4, T5, T6, T7, T8))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        9,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<
                    'a,
                    T0: 'a,
                    T1: 'a,
                    T2: 'a,
                    T3: 'a,
                    T4: 'a,
                    T5: 'a,
                    T6: 'a,
                    T7: 'a,
                    T8: 'a,
                >(
                    &'a mut (T0, T1, T2, T3, T4, T5, T6, T7, T8),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                    T8: Deserialize<'de>,
                > Visitor<'de>
                for TupleInPlaceVisitor<'a, T0, T1, T2, T3, T4, T5, T6, T7, T8> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 9")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).3)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(3, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).4)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(4, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).5)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(5, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).6)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(6, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).7)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(7, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).8)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(8, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(9, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
            T4: Deserialize<'de>,
            T5: Deserialize<'de>,
            T6: Deserialize<'de>,
            T7: Deserialize<'de>,
            T8: Deserialize<'de>,
            T9: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> {
                    marker: PhantomData<(T0, T1, T2, T3, T4, T5, T6, T7, T8, T9)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                    T8: Deserialize<'de>,
                    T9: Deserialize<'de>,
                > Visitor<'de> for TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> {
                    type Value = (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 10")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        let T4 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(4, &self)),
                        };
                        let T5 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(5, &self)),
                        };
                        let T6 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(6, &self)),
                        };
                        let T7 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(7, &self)),
                        };
                        let T8 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(8, &self)),
                        };
                        let T9 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(9, &self)),
                        };
                        Ok((T0, T1, T2, T3, T4, T5, T6, T7, T8, T9))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        10,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<
                    'a,
                    T0: 'a,
                    T1: 'a,
                    T2: 'a,
                    T3: 'a,
                    T4: 'a,
                    T5: 'a,
                    T6: 'a,
                    T7: 'a,
                    T8: 'a,
                    T9: 'a,
                >(
                    &'a mut (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                    T8: Deserialize<'de>,
                    T9: Deserialize<'de>,
                > Visitor<'de>
                for TupleInPlaceVisitor<'a, T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 10")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).3)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(3, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).4)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(4, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).5)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(5, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).6)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(6, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).7)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(7, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).8)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(8, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).9)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(9, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(10, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
            T4: Deserialize<'de>,
            T5: Deserialize<'de>,
            T6: Deserialize<'de>,
            T7: Deserialize<'de>,
            T8: Deserialize<'de>,
            T9: Deserialize<'de>,
            T10: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> {
                    marker: PhantomData<(T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10)>,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                    T8: Deserialize<'de>,
                    T9: Deserialize<'de>,
                    T10: Deserialize<'de>,
                > Visitor<'de>
                for TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> {
                    type Value = (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 11")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        let T4 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(4, &self)),
                        };
                        let T5 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(5, &self)),
                        };
                        let T6 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(6, &self)),
                        };
                        let T7 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(7, &self)),
                        };
                        let T8 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(8, &self)),
                        };
                        let T9 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(9, &self)),
                        };
                        let T10 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(10, &self)),
                        };
                        Ok((T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        11,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<
                    'a,
                    T0: 'a,
                    T1: 'a,
                    T2: 'a,
                    T3: 'a,
                    T4: 'a,
                    T5: 'a,
                    T6: 'a,
                    T7: 'a,
                    T8: 'a,
                    T9: 'a,
                    T10: 'a,
                >(
                    &'a mut (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                    T8: Deserialize<'de>,
                    T9: Deserialize<'de>,
                    T10: Deserialize<'de>,
                > Visitor<'de>
                for TupleInPlaceVisitor<
                    'a,
                    T0,
                    T1,
                    T2,
                    T3,
                    T4,
                    T5,
                    T6,
                    T7,
                    T8,
                    T9,
                    T10,
                > {
                    type Value = ();
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 11")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).0)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(0, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).1)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(1, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).2)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(2, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).3)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(3, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).4)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(4, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).5)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(5, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).6)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(6, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).7)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(7, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).8)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(8, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).9)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(9, &self));
                        }
                        if match seq.next_element_seed(InPlaceSeed(&mut (self.0).10)) {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        }
                            .is_none()
                        {
                            return Err(Error::invalid_length(10, &self));
                        }
                        Ok(())
                    }
                }
                deserializer.deserialize_tuple(11, TupleInPlaceVisitor(place))
            }
        }
        impl<
            'de,
            T0: Deserialize<'de>,
            T1: Deserialize<'de>,
            T2: Deserialize<'de>,
            T3: Deserialize<'de>,
            T4: Deserialize<'de>,
            T5: Deserialize<'de>,
            T6: Deserialize<'de>,
            T7: Deserialize<'de>,
            T8: Deserialize<'de>,
            T9: Deserialize<'de>,
            T10: Deserialize<'de>,
            T11: Deserialize<'de>,
        > Deserialize<'de> for (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11) {
            #[inline]
            fn deserialize<D>(deserializer: D) -> Result<Self, D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> {
                    marker: PhantomData<
                        (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11),
                    >,
                }
                impl<
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                    T8: Deserialize<'de>,
                    T9: Deserialize<'de>,
                    T10: Deserialize<'de>,
                    T11: Deserialize<'de>,
                > Visitor<'de>
                for TupleVisitor<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> {
                    type Value = (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11);
                    fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                        formatter.write_str("a tuple of size 12")
                    }
                    #[inline]
                    #[allow(non_snake_case)]
                    fn visit_seq<A>(self, mut seq: A) -> Result<Self::Value, A::Error>
                    where
                        A: SeqAccess<'de>,
                    {
                        let T0 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(0, &self)),
                        };
                        let T1 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(1, &self)),
                        };
                        let T2 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(2, &self)),
                        };
                        let T3 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(3, &self)),
                        };
                        let T4 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(4, &self)),
                        };
                        let T5 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(5, &self)),
                        };
                        let T6 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(6, &self)),
                        };
                        let T7 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(7, &self)),
                        };
                        let T8 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(8, &self)),
                        };
                        let T9 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(9, &self)),
                        };
                        let T10 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(10, &self)),
                        };
                        let T11 = match match seq.next_element() {
                            ::core::result::Result::Ok(val) => val,
                            ::core::result::Result::Err(err) => {
                                return ::core::result::Result::Err(
                                    ::core::convert::From::from(err),
                                );
                            }
                        } {
                            Some(value) => value,
                            None => return Err(Error::invalid_length(11, &self)),
                        };
                        Ok((T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11))
                    }
                }
                deserializer
                    .deserialize_tuple(
                        12,
                        TupleVisitor {
                            marker: PhantomData,
                        },
                    )
            }
            #[inline]
            fn deserialize_in_place<D>(
                deserializer: D,
                place: &mut Self,
            ) -> Result<(), D::Error>
            where
                D: Deserializer<'de>,
            {
                struct TupleInPlaceVisitor<
                    'a,
                    T0: 'a,
                    T1: 'a,
                    T2: 'a,
                    T3: 'a,
                    T4: 'a,
                    T5: 'a,
                    T6: 'a,
                    T7: 'a,
                    T8: 'a,
                    T9: 'a,
                    T10: 'a,
                    T11: 'a,
                >(
                    &'a mut (T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11),
                );
                impl<
                    'a,
                    'de,
                    T0: Deserialize<'de>,
                    T1: Deserialize<'de>,
                    T2: Deserialize<'de>,
                    T3: Deserialize<'de>,
                    T4: Deserialize<'de>,
                    T5: Deserialize<'de>,
                    T6: Deserialize<'de>,
                    T7: Deserialize<'de>,
                    T8: Deserialize<'de>,
                    T9: Deserialize<'de>,
                    T10: Deserialize<'de>,
                    T11: Deserialize<'de>,
                > Visitor<'de>
                for TupleInPlaceVisitor<
                    'a,
                    T0,
                    T1,
                  