/*
 * Copyright (C) 2018 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

/*
 * Caution!
 * This file is generated by the script "utils/lexbor/tag_ns/tags.py"!
 * Do not change this file!
 */


#include <unit/test.h>

#include <lexbor/tag/tag.h>

#define LXB_HTML_TAG_RES_DATA
#define LXB_HTML_TAG_RES_SHS_DATA
#include <lexbor/html/tag_res.h>


TEST_BEGIN(names)
{
    const lxb_tag_data_t *entry;
    lexbor_hash_t *tags;

    tags = lexbor_hash_create();
    test_eq(lexbor_hash_init(tags, 32, sizeof(lxb_tag_data_t)), LXB_STATUS_OK);

    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "!--", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "!--");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "!doctype", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "!doctype");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "#document", 9);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "#document");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "#end-of-file", 12);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "#end-of-file");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "#text", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "#text");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "#undef", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "#undef");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "a", 1);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "a");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "abbr", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "abbr");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "acronym", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "acronym");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "address", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "address");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "altglyph", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "altglyph");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "altglyphdef", 11);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "altglyphdef");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "altglyphitem", 12);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "altglyphitem");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "animatecolor", 12);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "animatecolor");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "animatemotion", 13);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "animatemotion");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "animatetransform", 16);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "animatetransform");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "annotation-xml", 14);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "annotation-xml");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "applet", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "applet");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "area", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "area");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "article", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "article");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "aside", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "aside");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "audio", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "audio");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "b", 1);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "b");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "base", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "base");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "basefont", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "basefont");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "bdi", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "bdi");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "bdo", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "bdo");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "bgsound", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "bgsound");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "big", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "big");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "blink", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "blink");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "blockquote", 10);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "blockquote");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "body", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "body");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "br", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "br");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "button", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "button");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "canvas", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "canvas");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "caption", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "caption");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "center", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "center");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "cite", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "cite");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "clippath", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "clippath");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "code", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "code");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "col", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "col");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "colgroup", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "colgroup");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "data", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "data");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "datalist", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "datalist");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "dd", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "dd");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "del", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "del");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "desc", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "desc");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "details", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "details");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "dfn", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "dfn");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "dialog", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "dialog");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "dir", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "dir");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "div", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "div");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "dl", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "dl");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "dt", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "dt");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "em", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "em");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "embed", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "embed");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "feblend", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "feblend");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fecolormatrix", 13);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fecolormatrix");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fecomponenttransfer", 19);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fecomponenttransfer");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fecomposite", 11);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fecomposite");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "feconvolvematrix", 16);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "feconvolvematrix");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fediffuselighting", 17);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fediffuselighting");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fedisplacementmap", 17);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fedisplacementmap");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fedistantlight", 14);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fedistantlight");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fedropshadow", 12);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fedropshadow");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "feflood", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "feflood");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fefunca", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fefunca");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fefuncb", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fefuncb");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fefuncg", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fefuncg");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fefuncr", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fefuncr");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fegaussianblur", 14);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fegaussianblur");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "feimage", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "feimage");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "femerge", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "femerge");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "femergenode", 11);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "femergenode");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "femorphology", 12);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "femorphology");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "feoffset", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "feoffset");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fepointlight", 12);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fepointlight");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fespecularlighting", 18);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fespecularlighting");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fespotlight", 11);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fespotlight");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fetile", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fetile");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "feturbulence", 12);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "feturbulence");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "fieldset", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "fieldset");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "figcaption", 10);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "figcaption");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "figure", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "figure");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "font", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "font");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "footer", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "footer");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "foreignobject", 13);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "foreignobject");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "form", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "form");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "frame", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "frame");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "frameset", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "frameset");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "glyphref", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "glyphref");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "h1", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "h1");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "h2", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "h2");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "h3", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "h3");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "h4", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "h4");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "h5", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "h5");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "h6", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "h6");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "head", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "head");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "header", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "header");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "hgroup", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "hgroup");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "hr", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "hr");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "html", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "html");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "i", 1);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "i");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "iframe", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "iframe");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "image", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "image");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "img", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "img");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "input", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "input");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "ins", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "ins");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "isindex", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "isindex");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "kbd", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "kbd");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "keygen", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "keygen");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "label", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "label");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "legend", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "legend");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "li", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "li");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "lineargradient", 14);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "lineargradient");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "link", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "link");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "listing", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "listing");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "main", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "main");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "malignmark", 10);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "malignmark");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "map", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "map");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "mark", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "mark");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "marquee", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "marquee");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "math", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "math");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "menu", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "menu");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "meta", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "meta");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "meter", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "meter");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "mfenced", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "mfenced");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "mglyph", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "mglyph");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "mi", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "mi");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "mn", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "mn");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "mo", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "mo");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "ms", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "ms");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "mtext", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "mtext");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "multicol", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "multicol");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "nav", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "nav");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "nextid", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "nextid");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "nobr", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "nobr");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "noembed", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "noembed");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "noframes", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "noframes");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "noscript", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "noscript");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "object", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "object");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "ol", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "ol");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "optgroup", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "optgroup");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "option", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "option");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "output", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "output");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "p", 1);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "p");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "param", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "param");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "path", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "path");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "picture", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "picture");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "plaintext", 9);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "plaintext");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "pre", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "pre");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "progress", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "progress");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "q", 1);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "q");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "radialgradient", 14);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "radialgradient");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "rb", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "rb");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "rp", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "rp");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "rt", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "rt");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "rtc", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "rtc");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "ruby", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "ruby");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "s", 1);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "s");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "samp", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "samp");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "script", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "script");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "search", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "search");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "section", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "section");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "select", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "select");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "selectedcontent", 15);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "selectedcontent");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "slot", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "slot");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "small", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "small");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "source", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "source");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "spacer", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "spacer");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "span", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "span");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "strike", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "strike");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "strong", 6);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "strong");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "style", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "style");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "sub", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "sub");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "summary", 7);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "summary");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "sup", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "sup");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "svg", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "svg");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "table", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "table");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "tbody", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "tbody");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "td", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "td");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "template", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "template");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "textarea", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "textarea");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "textpath", 8);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "textpath");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "tfoot", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "tfoot");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "th", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "th");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "thead", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "thead");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "time", 4);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "time");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "title", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "title");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "tr", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "tr");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "track", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "track");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "tt", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "tt");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "u", 1);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "u");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "ul", 2);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "ul");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "var", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "var");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "video", 5);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "video");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "wbr", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "wbr");
    entry = lxb_tag_data_by_name(tags, (const lxb_char_t *) "xmp", 3);
    test_ne(entry, NULL); test_eq_u_str(lexbor_hash_entry_str(&entry->entry), (const lxb_char_t *) "xmp");

    lexbor_hash_destroy(tags, true);
}
TEST_END

int
main(int argc, const char * argv[])
{
    TEST_INIT();

    TEST_ADD(names);

    TEST_RUN("lexbor/tag/res");
    TEST_RELEASE();
}


