/////////////////////////////////////////////////////////////////////////////// 
// 
// PagTest.cc 
// ------------- 
// Pager class test module 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017 by Bjoern Lemke 
// 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include "../src/Exception.h" 
#include "../src/Pager.h" 

#include <locale.h> 

int main(int argc, char **argv) 
{ 

    try 
    { 

        ListT<Chain> schema;

	schema.Insert("First:30");
	schema.Insert("SecondCol:50");
	schema.Insert("Third:10");
	
	
        ListT< ListT<Chain> > outData; 
        for ( int i=0; i< 100; i++) 
        { 
             ListT<Chain> outRow; 
             outRow.Insert(Chain(i) + Chain(" Apha") ); 
             outRow.Insert("Beta"); 
             outRow.Insert("Gamma"); 
             outData.Insert(outRow); 
        } 
        Pager pag; 
        pag.managePage(Chain("The Page"), outData, schema); 

    } 
    catch (Exception e) 
    { 
        Chain msg; 
        e.pop(msg); 
        cout << msg << endl; 
        return 1; 
    } 

    return 0; 

} 
