; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx90a < %s | FileCheck %s

declare double @llvm.amdgcn.flat.atomic.fadd.f64.p0.f64(ptr nocapture, double) #8

define protected amdgpu_kernel void @IllegalGEPConst(i32 %a, ptr addrspace(1) %b, double %c) {
; CHECK-LABEL: IllegalGEPConst:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    s_load_dword s2, s[0:1], 0x24
; CHECK-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x2c
; CHECK-NEXT:    v_mov_b32_e32 v2, 0
; CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; CHECK-NEXT:    s_ashr_i32 s3, s2, 31
; CHECK-NEXT:    s_lshl_b64 s[0:1], s[2:3], 3
; CHECK-NEXT:    s_add_u32 s0, s4, s0
; CHECK-NEXT:    v_mov_b32_e32 v0, s6
; CHECK-NEXT:    v_mov_b32_e32 v1, s7
; CHECK-NEXT:    s_addc_u32 s1, s5, s1
; CHECK-NEXT:    global_atomic_add_f64 v2, v[0:1], s[0:1] offset:-8
; CHECK-NEXT:    s_endpgm
entry:
  %i = add nsw i32 %a, -1
  %i.2 = sext i32 %i to i64
  %i.3 = getelementptr inbounds double, ptr addrspace(1) %b, i64 %i.2
  %i.4 = addrspacecast ptr addrspace(1) %i.3 to ptr
  %i.5 = tail call contract double @llvm.amdgcn.flat.atomic.fadd.f64.p0.f64(ptr %i.4, double %c) #8
  ret void
}

attributes #8 = { argmemonly mustprogress nounwind willreturn "target-cpu"="gfx90a" }
