; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -o - %s | FileCheck -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -O0 -global-isel=0 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -o - %s | FileCheck -check-prefixes=GFX9-O0,GFX9-SDAG-O0 %s

; FIXME: GlobalISel missing the power-of-2 cases in legalization. https://github.com/llvm/llvm-project/issues/80671
; xUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -o - %s | FileCheck -check-prefixes=GFX9,GFX9 %s
; xUN: llc -O0 -global-isel=1 -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -o - %s | FileCheck -check-prefixes=GFX9-O0,GFX9-O0 %s

define i128 @v_sdiv_i128_vv(i128 %lhs, i128 %rhs) {
; GFX9-LABEL: v_sdiv_i128_vv:
; GFX9:       ; %bb.0: ; %_udiv-special-cases
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i32_e32 v16, 31, v3
; GFX9-NEXT:    v_xor_b32_e32 v0, v16, v0
; GFX9-NEXT:    v_xor_b32_e32 v1, v16, v1
; GFX9-NEXT:    v_sub_co_u32_e32 v8, vcc, v0, v16
; GFX9-NEXT:    v_xor_b32_e32 v2, v16, v2
; GFX9-NEXT:    v_subb_co_u32_e32 v9, vcc, v1, v16, vcc
; GFX9-NEXT:    v_ashrrev_i32_e32 v17, 31, v7
; GFX9-NEXT:    v_xor_b32_e32 v3, v16, v3
; GFX9-NEXT:    v_subb_co_u32_e32 v10, vcc, v2, v16, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v11, vcc, v3, v16, vcc
; GFX9-NEXT:    v_xor_b32_e32 v3, v17, v4
; GFX9-NEXT:    v_xor_b32_e32 v2, v17, v5
; GFX9-NEXT:    v_sub_co_u32_e32 v20, vcc, v3, v17
; GFX9-NEXT:    v_xor_b32_e32 v0, v17, v6
; GFX9-NEXT:    v_subb_co_u32_e32 v21, vcc, v2, v17, vcc
; GFX9-NEXT:    v_xor_b32_e32 v1, v17, v7
; GFX9-NEXT:    v_subb_co_u32_e32 v0, vcc, v0, v17, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v17, vcc
; GFX9-NEXT:    v_or_b32_e32 v3, v21, v1
; GFX9-NEXT:    v_or_b32_e32 v2, v20, v0
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GFX9-NEXT:    v_or_b32_e32 v3, v9, v11
; GFX9-NEXT:    v_or_b32_e32 v2, v8, v10
; GFX9-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[2:3]
; GFX9-NEXT:    v_ffbh_u32_e32 v2, v0
; GFX9-NEXT:    v_add_u32_e32 v2, 32, v2
; GFX9-NEXT:    v_ffbh_u32_e32 v3, v1
; GFX9-NEXT:    v_min_u32_e32 v2, v2, v3
; GFX9-NEXT:    v_ffbh_u32_e32 v3, v20
; GFX9-NEXT:    v_add_u32_e32 v3, 32, v3
; GFX9-NEXT:    v_ffbh_u32_e32 v4, v21
; GFX9-NEXT:    v_min_u32_e32 v3, v3, v4
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_add_co_u32_e32 v3, vcc, 64, v3
; GFX9-NEXT:    v_addc_co_u32_e64 v4, s[6:7], 0, 0, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX9-NEXT:    v_ffbh_u32_e32 v5, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX9-NEXT:    v_ffbh_u32_e32 v3, v10
; GFX9-NEXT:    v_add_u32_e32 v3, 32, v3
; GFX9-NEXT:    v_min_u32_e32 v3, v3, v5
; GFX9-NEXT:    v_ffbh_u32_e32 v5, v8
; GFX9-NEXT:    v_add_u32_e32 v5, 32, v5
; GFX9-NEXT:    v_ffbh_u32_e32 v6, v9
; GFX9-NEXT:    v_min_u32_e32 v5, v5, v6
; GFX9-NEXT:    v_cndmask_b32_e64 v4, v4, 0, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v5, vcc, 64, v5
; GFX9-NEXT:    v_addc_co_u32_e64 v6, s[6:7], 0, 0, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; GFX9-NEXT:    s_mov_b64 s[6:7], 0x7f
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, 0, vcc
; GFX9-NEXT:    v_sub_co_u32_e32 v2, vcc, v2, v3
; GFX9-NEXT:    v_subb_co_u32_e32 v3, vcc, v4, v6, vcc
; GFX9-NEXT:    v_mov_b32_e32 v5, 0
; GFX9-NEXT:    v_subbrev_co_u32_e32 v4, vcc, 0, v5, vcc
; GFX9-NEXT:    v_subbrev_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v18, v16
; GFX9-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v19, v17
; GFX9-NEXT:    v_cndmask_b32_e64 v7, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v7, v6, vcc
; GFX9-NEXT:    v_and_b32_e32 v6, 1, v6
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v6
; GFX9-NEXT:    v_xor_b32_e32 v6, 0x7f, v2
; GFX9-NEXT:    v_or_b32_e32 v7, v3, v5
; GFX9-NEXT:    v_or_b32_e32 v6, v6, v4
; GFX9-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; GFX9-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GFX9-NEXT:    v_cndmask_b32_e64 v13, v11, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v12, v10, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v9, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v8, 0, s[4:5]
; GFX9-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB0_6
; GFX9-NEXT:  ; %bb.1: ; %udiv-bb1
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, 1, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, 0, v3, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v24, vcc, 0, v4, vcc
; GFX9-NEXT:    v_sub_u32_e32 v7, 0x7f, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v5, vcc
; GFX9-NEXT:    v_sub_u32_e32 v12, 64, v7
; GFX9-NEXT:    v_or_b32_e32 v4, v23, v25
; GFX9-NEXT:    v_or_b32_e32 v3, v22, v24
; GFX9-NEXT:    v_lshlrev_b64 v[5:6], v7, v[10:11]
; GFX9-NEXT:    v_lshrrev_b64 v[12:13], v12, v[8:9]
; GFX9-NEXT:    v_sub_u32_e32 v2, 63, v2
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[3:4]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], v2, v[8:9]
; GFX9-NEXT:    v_or_b32_e32 v4, v6, v13
; GFX9-NEXT:    v_or_b32_e32 v5, v5, v12
; GFX9-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v7
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v5, s[4:5]
; GFX9-NEXT:    v_lshlrev_b64 v[4:5], v7, v[8:9]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v7
; GFX9-NEXT:    v_mov_b32_e32 v6, 0
; GFX9-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v3, v3, v11, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v2, v2, v10, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v5, 0, v5, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v4, 0, v4, s[4:5]
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB0_5
; GFX9-NEXT:  ; %bb.2: ; %udiv-preheader
; GFX9-NEXT:    v_sub_u32_e32 v12, 64, v22
; GFX9-NEXT:    v_lshrrev_b64 v[6:7], v22, v[8:9]
; GFX9-NEXT:    v_lshlrev_b64 v[12:13], v12, v[10:11]
; GFX9-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v22
; GFX9-NEXT:    v_or_b32_e32 v12, v6, v12
; GFX9-NEXT:    v_subrev_u32_e32 v6, 64, v22
; GFX9-NEXT:    v_or_b32_e32 v13, v7, v13
; GFX9-NEXT:    v_lshrrev_b64 v[6:7], v6, v[10:11]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v22
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v7, v13, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v7, v9, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v12, v6, v12, vcc
; GFX9-NEXT:    v_lshrrev_b64 v[6:7], v22, v[10:11]
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v12, v8, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v11, 0, v7, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v10, 0, v6, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v26, vcc, -1, v20
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, -1, v21, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v28, vcc, -1, v0, vcc
; GFX9-NEXT:    v_mov_b32_e32 v14, 0
; GFX9-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-NEXT:    v_addc_co_u32_e32 v29, vcc, -1, v1, vcc
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v15, 0
; GFX9-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-NEXT:    v_mov_b32_e32 v7, 0
; GFX9-NEXT:  .LBB0_3: ; %udiv-do-while
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 31, v5
; GFX9-NEXT:    v_lshlrev_b64 v[4:5], 1, v[4:5]
; GFX9-NEXT:    v_lshlrev_b64 v[10:11], 1, v[10:11]
; GFX9-NEXT:    v_or_b32_e32 v4, v14, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 31, v9
; GFX9-NEXT:    v_lshlrev_b64 v[8:9], 1, v[8:9]
; GFX9-NEXT:    v_or_b32_e32 v10, v10, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 31, v3
; GFX9-NEXT:    v_or_b32_e32 v8, v8, v14
; GFX9-NEXT:    v_sub_co_u32_e32 v14, vcc, v26, v8
; GFX9-NEXT:    v_subb_co_u32_e32 v14, vcc, v27, v9, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v14, vcc, v28, v10, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v14, vcc, v29, v11, vcc
; GFX9-NEXT:    v_ashrrev_i32_e32 v30, 31, v14
; GFX9-NEXT:    v_and_b32_e32 v14, v30, v20
; GFX9-NEXT:    v_sub_co_u32_e32 v8, vcc, v8, v14
; GFX9-NEXT:    v_and_b32_e32 v14, v30, v21
; GFX9-NEXT:    v_subb_co_u32_e32 v9, vcc, v9, v14, vcc
; GFX9-NEXT:    v_and_b32_e32 v14, v30, v0
; GFX9-NEXT:    v_subb_co_u32_e32 v10, vcc, v10, v14, vcc
; GFX9-NEXT:    v_and_b32_e32 v14, v30, v1
; GFX9-NEXT:    v_subb_co_u32_e32 v11, vcc, v11, v14, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, -1, v22
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, -1, v23, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v24, vcc, -1, v24, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, -1, v25, vcc
; GFX9-NEXT:    v_or_b32_e32 v5, v15, v5
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], 1, v[2:3]
; GFX9-NEXT:    v_or_b32_e32 v14, v22, v24
; GFX9-NEXT:    v_or_b32_e32 v15, v23, v25
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GFX9-NEXT:    v_or3_b32 v2, v2, v6, v12
; GFX9-NEXT:    v_and_b32_e32 v6, 1, v30
; GFX9-NEXT:    v_mov_b32_e32 v15, v7
; GFX9-NEXT:    v_or3_b32 v3, v3, 0, v13
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v14, v6
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB0_3
; GFX9-NEXT:  ; %bb.4: ; %Flow
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:  .LBB0_5: ; %Flow2
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 1, v[4:5]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], 1, v[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 31, v5
; GFX9-NEXT:    v_or3_b32 v13, v3, 0, v13
; GFX9-NEXT:    v_or3_b32 v12, v2, v4, v12
; GFX9-NEXT:    v_or_b32_e32 v7, v7, v1
; GFX9-NEXT:    v_or_b32_e32 v6, v6, v0
; GFX9-NEXT:  .LBB0_6: ; %Flow3
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    v_xor_b32_e32 v2, v17, v16
; GFX9-NEXT:    v_xor_b32_e32 v3, v19, v18
; GFX9-NEXT:    v_xor_b32_e32 v0, v6, v2
; GFX9-NEXT:    v_xor_b32_e32 v1, v7, v3
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v2
; GFX9-NEXT:    v_xor_b32_e32 v5, v12, v2
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v3, vcc
; GFX9-NEXT:    v_xor_b32_e32 v4, v13, v3
; GFX9-NEXT:    v_subb_co_u32_e32 v2, vcc, v5, v2, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v3, vcc, v4, v3, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O0-LABEL: v_sdiv_i128_vv:
; GFX9-O0:       ; %bb.0: ; %_udiv-special-cases
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $vgpr8 : SGPR spill to VGPR lane
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v5
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v4
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v3
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    s_waitcnt vmcnt(4)
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    s_waitcnt vmcnt(1)
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v4
; GFX9-O0-NEXT:    v_ashrrev_i64 v[13:14], s4, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v2
; GFX9-O0-NEXT:    v_ashrrev_i64 v[11:12], s4, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-O0-NEXT:    v_xor_b32_e64 v1, v6, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v13
; GFX9-O0-NEXT:    v_xor_b32_e64 v13, v4, v5
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v10
; GFX9-O0-NEXT:    v_xor_b32_e64 v1, v6, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_xor_b32_e64 v15, v4, v5
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v16
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v14
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v9, vcc, v9, v4
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v6, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v13, vcc, v10, v4, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v5, vcc, v5, v6, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_xor_b32_e64 v1, v5, v1
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_xor_b32_e64 v11, v3, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v8
; GFX9-O0-NEXT:    v_xor_b32_e64 v1, v5, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v7
; GFX9-O0-NEXT:    v_xor_b32_e64 v7, v3, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v12
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v1, vcc, v1, v3
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v7, v5, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v11, vcc, v8, v3, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v2, vcc, v2, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v7
; GFX9-O0-NEXT:    v_xor_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    v_xor_b32_e64 v3, v3, v4
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-O0-NEXT:    v_or_b32_e64 v3, v8, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    v_or_b32_e64 v1, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    v_writelane_b32 v0, s6, 0
; GFX9-O0-NEXT:    v_writelane_b32 v0, s7, 1
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[4:5], v[1:2], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    v_or_b32_e64 v15, v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v9, v3, v1
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v15
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[8:9], v[9:10], s[6:7]
; GFX9-O0-NEXT:    s_or_b64 s[4:5], s[4:5], s[8:9]
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v6, v6
; GFX9-O0-NEXT:    s_mov_b32 s9, 32
; GFX9-O0-NEXT:    v_add_u32_e64 v6, v6, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v7, v7
; GFX9-O0-NEXT:    v_min_u32_e64 v6, v6, v7
; GFX9-O0-NEXT:    s_mov_b32 s8, 0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v5
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v8, v8
; GFX9-O0-NEXT:    v_min_u32_e64 v15, v5, v8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v5
; GFX9-O0-NEXT:    s_mov_b64 s[10:11], 64
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v15
; GFX9-O0-NEXT:    s_mov_b32 s12, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v16
; GFX9-O0-NEXT:    s_mov_b32 s14, s11
; GFX9-O0-NEXT:    v_add_co_u32_e64 v8, s[12:13], v8, s12
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s14
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[12:13], v5, v9, s[12:13]
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[12:13], v[11:12], s[6:7]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v10, s[12:13]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v9, v6, v7, s[12:13]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v1
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v6, v2
; GFX9-O0-NEXT:    v_min_u32_e64 v6, v5, v6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v7
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v3
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v11, v4
; GFX9-O0-NEXT:    v_min_u32_e64 v15, v5, v11
; GFX9-O0-NEXT:    ; implicit-def: $sgpr9
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v15
; GFX9-O0-NEXT:    s_mov_b32 s8, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v16
; GFX9-O0-NEXT:    s_mov_b32 s10, s11
; GFX9-O0-NEXT:    v_add_co_u32_e64 v11, s[8:9], v11, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s10
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[8:9], v5, v12, s[8:9]
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[8:9], v[13:14], s[6:7]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    s_mov_b32 s10, s6
; GFX9-O0-NEXT:    s_mov_b32 s11, s7
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v5, vcc, v5, v8
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v9, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s10
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v8, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s11
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s11
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v8
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[8:9], v[8:9], s[8:9]
; GFX9-O0-NEXT:    s_mov_b64 s[12:13], 0x7f
; GFX9-O0-NEXT:    s_mov_b64 s[14:15], s[12:13]
; GFX9-O0-NEXT:    v_cmp_gt_u64_e64 s[14:15], v[5:6], s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v10, 0, 1, s[14:15]
; GFX9-O0-NEXT:    s_mov_b64 s[14:15], s[6:7]
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[14:15], v[8:9], s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, 0, 1, s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, v7, v10, s[8:9]
; GFX9-O0-NEXT:    v_and_b32_e64 v7, 1, v7
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[8:9], v7, 1
; GFX9-O0-NEXT:    s_or_b64 s[8:9], s[4:5], s[8:9]
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], -1
; GFX9-O0-NEXT:    s_xor_b64 s[4:5], s[8:9], s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    s_mov_b32 s14, s13
; GFX9-O0-NEXT:    v_xor_b32_e64 v7, v7, s14
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    ; kill: def $sgpr12 killed $sgpr12 killed $sgpr12_sgpr13
; GFX9-O0-NEXT:    v_xor_b32_e64 v5, v5, s12
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v7, v7, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[6:7], v[5:6], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v2, v5, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v4, v5, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v5
; GFX9-O0-NEXT:    s_and_b64 s[6:7], s[4:5], s[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-O0-NEXT:    v_writelane_b32 v0, s4, 2
; GFX9-O0-NEXT:    v_writelane_b32 v0, s5, 3
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB0_3
; GFX9-O0-NEXT:    s_branch .LBB0_8
; GFX9-O0-NEXT:  .LBB0_1: ; %Flow
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v0, 4
; GFX9-O0-NEXT:    v_readlane_b32 s5, v0, 5
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:  ; %bb.2: ; %Flow
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(6)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB0_5
; GFX9-O0-NEXT:  .LBB0_3: ; %Flow2
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v4, 2
; GFX9-O0-NEXT:    v_readlane_b32 s5, v4, 3
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB0_9
; GFX9-O0-NEXT:  .LBB0_4: ; %udiv-loop-exit
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 1
; GFX9-O0-NEXT:    s_waitcnt vmcnt(2)
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s4, v[0:1]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshlrev_b64 v[9:10], s4, v[9:10]
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v8
; GFX9-O0-NEXT:    v_or3_b32 v4, v4, v11, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v9
; GFX9-O0-NEXT:    v_or3_b32 v0, v0, v1, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v6
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v4, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v4
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB0_3
; GFX9-O0-NEXT:  .LBB0_5: ; %Flow1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v8, 6
; GFX9-O0-NEXT:    v_readlane_b32 s5, v8, 7
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB0_4
; GFX9-O0-NEXT:  .LBB0_6: ; %udiv-do-while
; GFX9-O0-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s6, v16, 8
; GFX9-O0-NEXT:    v_readlane_b32 s7, v16, 9
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    s_waitcnt vmcnt(16)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[29:30], s4, v[2:3]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v30
; GFX9-O0-NEXT:    s_mov_b32 s5, 1
; GFX9-O0-NEXT:    v_lshlrev_b64 v[23:24], s5, v[23:24]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v24
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v29
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v23
; GFX9-O0-NEXT:    v_or_b32_e64 v23, v5, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[29:30], s5, v[2:3]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], s4, v[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v30
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v29
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 killed $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v3, v4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s5, v[0:1]
; GFX9-O0-NEXT:    v_lshlrev_b64 v[29:30], s5, v[6:7]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v30
; GFX9-O0-NEXT:    s_waitcnt vmcnt(10)
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v28
; GFX9-O0-NEXT:    v_or3_b32 v6, v6, v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v29
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v27
; GFX9-O0-NEXT:    v_or3_b32 v0, v0, v1, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    s_waitcnt vmcnt(8)
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v26
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v25
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v24
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v15
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v13, vcc, v13, v6
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v12, vcc, v12, v10, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v11, vcc, v11, v4, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v7, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    v_ashrrev_i64 v[13:14], s4, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v14
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], 1
; GFX9-O0-NEXT:    s_mov_b32 s8, s5
; GFX9-O0-NEXT:    v_and_b32_e64 v12, v7, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v13
; GFX9-O0-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_and_b32_e64 v14, v11, s4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v22
; GFX9-O0-NEXT:    v_and_b32_e64 v23, v7, v23
; GFX9-O0-NEXT:    v_and_b32_e64 v21, v11, v21
; GFX9-O0-NEXT:    ; kill: def $vgpr21 killed $vgpr21 def $vgpr21_vgpr22 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v20
; GFX9-O0-NEXT:    v_and_b32_e64 v7, v7, v23
; GFX9-O0-NEXT:    v_and_b32_e64 v23, v11, v19
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v24
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v22
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v6, vcc, v6, v20
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v10, vcc, v10, v19, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v4, vcc, v4, v11, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v5, v7, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v8
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 killed $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], -1
; GFX9-O0-NEXT:    s_mov_b32 s5, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v20, vcc, v11, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v9, vcc, v9, v11, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v17, vcc, v10, v11, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v8, vcc, v8, v10, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr20 killed $vgpr20 def $vgpr20_vgpr21 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v20
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v21
; GFX9-O0-NEXT:    v_or_b32_e64 v19, v19, v22
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v20
; GFX9-O0-NEXT:    v_or_b32_e64 v17, v17, v18
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v19
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[4:5], v[17:18], v[12:13]
; GFX9-O0-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v0
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v14
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v12
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GFX9-O0-NEXT:    v_writelane_b32 v16, s6, 4
; GFX9-O0-NEXT:    v_writelane_b32 v16, s7, 5
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GFX9-O0-NEXT:    v_writelane_b32 v16, s6, 8
; GFX9-O0-NEXT:    v_writelane_b32 v16, s7, 9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execnz .LBB0_6
; GFX9-O0-NEXT:    s_branch .LBB0_1
; GFX9-O0-NEXT:  .LBB0_7: ; %udiv-preheader
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(9)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[6:7], v4, v[21:22]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    s_mov_b32 s6, 64
; GFX9-O0-NEXT:    v_sub_u32_e64 v12, s6, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[23:24], v12, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v24
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v23
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    v_cmp_lt_u32_e64 s[4:5], v4, s6
; GFX9-O0-NEXT:    v_sub_u32_e64 v5, v4, s6
; GFX9-O0-NEXT:    v_lshrrev_b64 v[23:24], v5, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v24
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s6, 0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[6:7], v4, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v22
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v23
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v21
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[6:7]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], v4, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v5
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s8, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v12, v12, v15, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v4
; GFX9-O0-NEXT:    s_mov_b32 s8, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v5, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v14
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], -1
; GFX9-O0-NEXT:    s_mov_b32 s5, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v12, vcc, v12, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v17, vcc, v15, v17, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v14, vcc, v14, v15, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v13, vcc, v13, v15, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v13
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr12 killed $vgpr12 def $vgpr12_vgpr13 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v17
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s6
; GFX9-O0-NEXT:    v_writelane_b32 v16, s4, 8
; GFX9-O0-NEXT:    v_writelane_b32 v16, s5, 9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB0_6
; GFX9-O0-NEXT:  .LBB0_8: ; %udiv-bb1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 1
; GFX9-O0-NEXT:    s_mov_b32 s5, s6
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-O0-NEXT:    s_mov_b32 s4, s7
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s8, s6
; GFX9-O0-NEXT:    s_mov_b32 s9, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v9, vcc, v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v5, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b32 s4, 0x7f
; GFX9-O0-NEXT:    v_sub_u32_e64 v3, s4, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[5:6], v3, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-O0-NEXT:    s_mov_b32 s4, 64
; GFX9-O0-NEXT:    v_sub_u32_e64 v14, s4, v3
; GFX9-O0-NEXT:    v_lshrrev_b64 v[14:15], v14, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v15
; GFX9-O0-NEXT:    v_or_b32_e64 v13, v13, v16
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v6
; GFX9-O0-NEXT:    v_cmp_lt_u32_e64 s[4:5], v3, s4
; GFX9-O0-NEXT:    s_mov_b32 s10, 63
; GFX9-O0-NEXT:    v_sub_u32_e64 v4, s10, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[13:14], v4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s10, 0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[10:11], v3, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v12
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[10:11]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v13
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v6, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v6, s[10:11]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[7:8], v3, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[4:5]
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, v4, v7, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v3
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v10
; GFX9-O0-NEXT:    v_or_b32_e64 v3, v3, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v1, v1, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[4:5], v[1:2], s[6:7]
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-O0-NEXT:    s_and_b64 s[4:5], s[6:7], s[4:5]
; GFX9-O0-NEXT:    s_xor_b64 s[6:7], s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_writelane_b32 v0, s6, 6
; GFX9-O0-NEXT:    v_writelane_b32 v0, s7, 7
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB0_5
; GFX9-O0-NEXT:    s_branch .LBB0_7
; GFX9-O0-NEXT:  .LBB0_9: ; %udiv-end
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v10
; GFX9-O0-NEXT:    v_xor_b32_e64 v3, v3, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v9
; GFX9-O0-NEXT:    v_xor_b32_e64 v9, v6, v5
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    v_xor_b32_e64 v3, v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 killed $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_xor_b32_e64 v0, v0, v8
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v10
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v7, vcc, v7, v8
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v0, vcc, v0, v6, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v5, vcc, v3, v5, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    s_mov_b32 s4, 32
; GFX9-O0-NEXT:    v_lshrrev_b64 v[7:8], s4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-O0-NEXT:    v_lshrrev_b64 v[5:6], s4, v[5:6]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    ; kill: killed $vgpr4
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
  %div = sdiv i128 %lhs, %rhs
  ret i128 %div
}

define i128 @v_udiv_i128_vv(i128 %lhs, i128 %rhs) {
; GFX9-LABEL: v_udiv_i128_vv:
; GFX9:       ; %bb.0: ; %_udiv-special-cases
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_or_b32_e32 v9, v5, v7
; GFX9-NEXT:    v_or_b32_e32 v8, v4, v6
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; GFX9-NEXT:    v_or_b32_e32 v9, v1, v3
; GFX9-NEXT:    v_or_b32_e32 v8, v0, v2
; GFX9-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[8:9]
; GFX9-NEXT:    v_ffbh_u32_e32 v8, v6
; GFX9-NEXT:    v_add_u32_e32 v8, 32, v8
; GFX9-NEXT:    v_ffbh_u32_e32 v9, v7
; GFX9-NEXT:    v_min_u32_e32 v8, v8, v9
; GFX9-NEXT:    v_ffbh_u32_e32 v9, v4
; GFX9-NEXT:    v_add_u32_e32 v9, 32, v9
; GFX9-NEXT:    v_ffbh_u32_e32 v10, v5
; GFX9-NEXT:    v_min_u32_e32 v9, v9, v10
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_add_co_u32_e32 v9, vcc, 64, v9
; GFX9-NEXT:    v_addc_co_u32_e64 v10, s[6:7], 0, 0, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; GFX9-NEXT:    v_ffbh_u32_e32 v11, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX9-NEXT:    v_ffbh_u32_e32 v9, v2
; GFX9-NEXT:    v_add_u32_e32 v9, 32, v9
; GFX9-NEXT:    v_min_u32_e32 v9, v9, v11
; GFX9-NEXT:    v_ffbh_u32_e32 v11, v0
; GFX9-NEXT:    v_add_u32_e32 v11, 32, v11
; GFX9-NEXT:    v_ffbh_u32_e32 v12, v1
; GFX9-NEXT:    v_min_u32_e32 v11, v11, v12
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v10, 0, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v11, vcc, 64, v11
; GFX9-NEXT:    v_addc_co_u32_e64 v12, s[6:7], 0, 0, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; GFX9-NEXT:    s_mov_b64 s[6:7], 0x7f
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v13, v12, 0, vcc
; GFX9-NEXT:    v_sub_co_u32_e32 v12, vcc, v8, v9
; GFX9-NEXT:    v_subb_co_u32_e32 v13, vcc, v10, v13, vcc
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_subbrev_co_u32_e32 v14, vcc, 0, v8, vcc
; GFX9-NEXT:    v_subbrev_co_u32_e32 v15, vcc, 0, v8, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[12:13]
; GFX9-NEXT:    v_or_b32_e32 v10, v13, v15
; GFX9-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[14:15]
; GFX9-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX9-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX9-NEXT:    v_xor_b32_e32 v9, 0x7f, v12
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v8
; GFX9-NEXT:    v_or_b32_e32 v9, v9, v14
; GFX9-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[9:10]
; GFX9-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v3, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v2, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v1, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v0, 0, s[4:5]
; GFX9-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB1_6
; GFX9-NEXT:  ; %bb.1: ; %udiv-bb1
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 1, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v13, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v20, vcc, 0, v14, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v21, vcc, 0, v15, vcc
; GFX9-NEXT:    v_sub_u32_e32 v15, 0x7f, v12
; GFX9-NEXT:    v_or_b32_e32 v9, v19, v21
; GFX9-NEXT:    v_or_b32_e32 v8, v18, v20
; GFX9-NEXT:    v_sub_u32_e32 v13, 64, v15
; GFX9-NEXT:    v_lshlrev_b64 v[10:11], v15, v[2:3]
; GFX9-NEXT:    v_lshrrev_b64 v[13:14], v13, v[0:1]
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; GFX9-NEXT:    v_sub_u32_e32 v8, 63, v12
; GFX9-NEXT:    v_lshlrev_b64 v[8:9], v8, v[0:1]
; GFX9-NEXT:    v_or_b32_e32 v11, v11, v14
; GFX9-NEXT:    v_or_b32_e32 v10, v10, v13
; GFX9-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v15
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v11, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v8, v10, s[4:5]
; GFX9-NEXT:    v_lshlrev_b64 v[10:11], v15, v[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v15
; GFX9-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-NEXT:    v_mov_b32_e32 v14, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v3, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v8, v2, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v11, 0, v11, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-NEXT:    v_mov_b32_e32 v15, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v10, 0, v10, s[4:5]
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB1_5
; GFX9-NEXT:  ; %bb.2: ; %udiv-preheader
; GFX9-NEXT:    v_sub_u32_e32 v14, 64, v18
; GFX9-NEXT:    v_lshrrev_b64 v[12:13], v18, v[0:1]
; GFX9-NEXT:    v_lshlrev_b64 v[14:15], v14, v[2:3]
; GFX9-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v18
; GFX9-NEXT:    v_or_b32_e32 v14, v12, v14
; GFX9-NEXT:    v_subrev_u32_e32 v12, 64, v18
; GFX9-NEXT:    v_or_b32_e32 v15, v13, v15
; GFX9-NEXT:    v_lshrrev_b64 v[12:13], v12, v[2:3]
; GFX9-NEXT:    v_lshrrev_b64 v[2:3], v18, v[2:3]
; GFX9-NEXT:    v_cndmask_b32_e32 v13, v13, v15, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v12, v12, v14, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, 0, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, -1, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, -1, v5, vcc
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v24, vcc, -1, v6, vcc
; GFX9-NEXT:    v_mov_b32_e32 v16, 0
; GFX9-NEXT:    v_mov_b32_e32 v14, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v13, v1, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v12, v0, s[4:5]
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, -1, v7, vcc
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v17, 0
; GFX9-NEXT:    v_mov_b32_e32 v15, 0
; GFX9-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-NEXT:  .LBB1_3: ; %udiv-do-while
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_lshlrev_b64 v[26:27], 1, v[10:11]
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 31, v11
; GFX9-NEXT:    v_or_b32_e32 v10, v16, v26
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 31, v1
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 1, v[0:1]
; GFX9-NEXT:    v_or_b32_e32 v11, v17, v27
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], 1, v[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 31, v9
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v17
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v16
; GFX9-NEXT:    v_sub_co_u32_e32 v16, vcc, v22, v0
; GFX9-NEXT:    v_subb_co_u32_e32 v16, vcc, v23, v1, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v16, vcc, v24, v2, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v16, vcc, v25, v3, vcc
; GFX9-NEXT:    v_ashrrev_i32_e32 v26, 31, v16
; GFX9-NEXT:    v_and_b32_e32 v16, v26, v4
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v16
; GFX9-NEXT:    v_and_b32_e32 v16, v26, v5
; GFX9-NEXT:    v_lshlrev_b64 v[8:9], 1, v[8:9]
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v16, vcc
; GFX9-NEXT:    v_and_b32_e32 v16, v26, v6
; GFX9-NEXT:    v_or3_b32 v8, v8, v12, v14
; GFX9-NEXT:    v_and_b32_e32 v12, v26, v7
; GFX9-NEXT:    v_subb_co_u32_e32 v2, vcc, v2, v16, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v12, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, -1, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, -1, v19, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v20, vcc, -1, v20, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v21, vcc, -1, v21, vcc
; GFX9-NEXT:    v_or_b32_e32 v16, v18, v20
; GFX9-NEXT:    v_or_b32_e32 v17, v19, v21
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[16:17]
; GFX9-NEXT:    v_and_b32_e32 v12, 1, v26
; GFX9-NEXT:    v_mov_b32_e32 v17, v13
; GFX9-NEXT:    v_or3_b32 v9, v9, 0, v15
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v16, v12
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  ; %bb.4: ; %Flow
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:  .LBB1_5: ; %Flow2
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 1, v[10:11]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], 1, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 31, v11
; GFX9-NEXT:    v_or3_b32 v8, v3, 0, v15
; GFX9-NEXT:    v_or3_b32 v9, v2, v4, v14
; GFX9-NEXT:    v_or_b32_e32 v10, v13, v1
; GFX9-NEXT:    v_or_b32_e32 v11, v12, v0
; GFX9-NEXT:  .LBB1_6: ; %Flow3
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    v_mov_b32_e32 v0, v11
; GFX9-NEXT:    v_mov_b32_e32 v1, v10
; GFX9-NEXT:    v_mov_b32_e32 v2, v9
; GFX9-NEXT:    v_mov_b32_e32 v3, v8
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O0-LABEL: v_udiv_i128_vv:
; GFX9-O0:       ; %bb.0: ; %_udiv-special-cases
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $vgpr8 : SGPR spill to VGPR lane
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v6
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v3
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v12
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-O0-NEXT:    v_or_b32_e64 v3, v8, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    v_or_b32_e64 v1, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    v_writelane_b32 v0, s6, 0
; GFX9-O0-NEXT:    v_writelane_b32 v0, s7, 1
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[4:5], v[1:2], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    v_or_b32_e64 v15, v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v9, v3, v1
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v15
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[8:9], v[9:10], s[6:7]
; GFX9-O0-NEXT:    s_or_b64 s[4:5], s[4:5], s[8:9]
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v6, v6
; GFX9-O0-NEXT:    s_mov_b32 s9, 32
; GFX9-O0-NEXT:    v_add_u32_e64 v6, v6, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v7, v7
; GFX9-O0-NEXT:    v_min_u32_e64 v6, v6, v7
; GFX9-O0-NEXT:    s_mov_b32 s8, 0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v5
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v8, v8
; GFX9-O0-NEXT:    v_min_u32_e64 v15, v5, v8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v5
; GFX9-O0-NEXT:    s_mov_b64 s[10:11], 64
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v15
; GFX9-O0-NEXT:    s_mov_b32 s12, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v16
; GFX9-O0-NEXT:    s_mov_b32 s14, s11
; GFX9-O0-NEXT:    v_add_co_u32_e64 v8, s[12:13], v8, s12
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s14
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[12:13], v5, v9, s[12:13]
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    s_mov_b64 s[12:13], s[6:7]
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[12:13], v[11:12], s[12:13]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v10, s[12:13]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v9, v6, v7, s[12:13]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v1
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v6, v2
; GFX9-O0-NEXT:    v_min_u32_e64 v6, v5, v6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v7
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v3
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v11, v4
; GFX9-O0-NEXT:    v_min_u32_e64 v15, v5, v11
; GFX9-O0-NEXT:    ; implicit-def: $sgpr9
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v15
; GFX9-O0-NEXT:    s_mov_b32 s8, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v16
; GFX9-O0-NEXT:    s_mov_b32 s10, s11
; GFX9-O0-NEXT:    v_add_co_u32_e64 v11, s[8:9], v11, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s10
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[8:9], v5, v12, s[8:9]
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[8:9], v[13:14], s[8:9]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    s_mov_b32 s10, s6
; GFX9-O0-NEXT:    s_mov_b32 s11, s7
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v5, vcc, v5, v8
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v9, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s10
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v8, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s11
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s11
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v8
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[8:9], v[8:9], s[8:9]
; GFX9-O0-NEXT:    s_mov_b64 s[12:13], 0x7f
; GFX9-O0-NEXT:    s_mov_b64 s[14:15], s[12:13]
; GFX9-O0-NEXT:    v_cmp_gt_u64_e64 s[14:15], v[5:6], s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v10, 0, 1, s[14:15]
; GFX9-O0-NEXT:    s_mov_b64 s[14:15], s[6:7]
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[14:15], v[8:9], s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, 0, 1, s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, v7, v10, s[8:9]
; GFX9-O0-NEXT:    v_and_b32_e64 v7, 1, v7
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[8:9], v7, 1
; GFX9-O0-NEXT:    s_or_b64 s[8:9], s[4:5], s[8:9]
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], -1
; GFX9-O0-NEXT:    s_xor_b64 s[4:5], s[8:9], s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    s_mov_b32 s14, s13
; GFX9-O0-NEXT:    v_xor_b32_e64 v7, v7, s14
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    ; kill: def $sgpr12 killed $sgpr12 killed $sgpr12_sgpr13
; GFX9-O0-NEXT:    v_xor_b32_e64 v5, v5, s12
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v7, v7, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[6:7], v[5:6], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v2, v5, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v4, v5, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v5
; GFX9-O0-NEXT:    s_and_b64 s[6:7], s[4:5], s[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-O0-NEXT:    v_writelane_b32 v0, s4, 2
; GFX9-O0-NEXT:    v_writelane_b32 v0, s5, 3
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB1_3
; GFX9-O0-NEXT:    s_branch .LBB1_8
; GFX9-O0-NEXT:  .LBB1_1: ; %Flow
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v0, 4
; GFX9-O0-NEXT:    v_readlane_b32 s5, v0, 5
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:  ; %bb.2: ; %Flow
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(6)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB1_5
; GFX9-O0-NEXT:  .LBB1_3: ; %Flow2
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v4, 2
; GFX9-O0-NEXT:    v_readlane_b32 s5, v4, 3
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB1_9
; GFX9-O0-NEXT:  .LBB1_4: ; %udiv-loop-exit
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 1
; GFX9-O0-NEXT:    s_waitcnt vmcnt(2)
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s4, v[0:1]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshlrev_b64 v[9:10], s4, v[9:10]
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v8
; GFX9-O0-NEXT:    v_or3_b32 v4, v4, v11, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v9
; GFX9-O0-NEXT:    v_or3_b32 v0, v0, v1, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v6
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v4, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v4
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB1_3
; GFX9-O0-NEXT:  .LBB1_5: ; %Flow1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v8, 6
; GFX9-O0-NEXT:    v_readlane_b32 s5, v8, 7
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB1_4
; GFX9-O0-NEXT:  .LBB1_6: ; %udiv-do-while
; GFX9-O0-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s6, v16, 8
; GFX9-O0-NEXT:    v_readlane_b32 s7, v16, 9
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    s_waitcnt vmcnt(16)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[29:30], s4, v[2:3]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v30
; GFX9-O0-NEXT:    s_mov_b32 s5, 1
; GFX9-O0-NEXT:    v_lshlrev_b64 v[23:24], s5, v[23:24]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v24
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v29
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v23
; GFX9-O0-NEXT:    v_or_b32_e64 v23, v5, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[29:30], s5, v[2:3]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], s4, v[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v30
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v29
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 killed $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v3, v4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s5, v[0:1]
; GFX9-O0-NEXT:    v_lshlrev_b64 v[29:30], s5, v[6:7]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v30
; GFX9-O0-NEXT:    s_waitcnt vmcnt(10)
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v28
; GFX9-O0-NEXT:    v_or3_b32 v6, v6, v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v29
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v27
; GFX9-O0-NEXT:    v_or3_b32 v0, v0, v1, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    s_waitcnt vmcnt(8)
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v26
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v25
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v24
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v15
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v13, vcc, v13, v6
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v12, vcc, v12, v10, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v11, vcc, v11, v4, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v7, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    v_ashrrev_i64 v[13:14], s4, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v14
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], 1
; GFX9-O0-NEXT:    s_mov_b32 s8, s5
; GFX9-O0-NEXT:    v_and_b32_e64 v12, v7, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v13
; GFX9-O0-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_and_b32_e64 v14, v11, s4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v22
; GFX9-O0-NEXT:    v_and_b32_e64 v23, v7, v23
; GFX9-O0-NEXT:    v_and_b32_e64 v21, v11, v21
; GFX9-O0-NEXT:    ; kill: def $vgpr21 killed $vgpr21 def $vgpr21_vgpr22 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v20
; GFX9-O0-NEXT:    v_and_b32_e64 v7, v7, v23
; GFX9-O0-NEXT:    v_and_b32_e64 v23, v11, v19
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v24
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v22
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v6, vcc, v6, v20
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v10, vcc, v10, v19, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v4, vcc, v4, v11, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v5, v7, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v8
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 killed $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], -1
; GFX9-O0-NEXT:    s_mov_b32 s5, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v20, vcc, v11, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v9, vcc, v9, v11, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v17, vcc, v10, v11, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v8, vcc, v8, v10, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr20 killed $vgpr20 def $vgpr20_vgpr21 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v20
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v21
; GFX9-O0-NEXT:    v_or_b32_e64 v19, v19, v22
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v20
; GFX9-O0-NEXT:    v_or_b32_e64 v17, v17, v18
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v19
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[4:5], v[17:18], v[12:13]
; GFX9-O0-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v0
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v14
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v12
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GFX9-O0-NEXT:    v_writelane_b32 v16, s6, 4
; GFX9-O0-NEXT:    v_writelane_b32 v16, s7, 5
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GFX9-O0-NEXT:    v_writelane_b32 v16, s6, 8
; GFX9-O0-NEXT:    v_writelane_b32 v16, s7, 9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execnz .LBB1_6
; GFX9-O0-NEXT:    s_branch .LBB1_1
; GFX9-O0-NEXT:  .LBB1_7: ; %udiv-preheader
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(9)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[6:7], v4, v[21:22]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    s_mov_b32 s6, 64
; GFX9-O0-NEXT:    v_sub_u32_e64 v12, s6, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[23:24], v12, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v24
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v23
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    v_cmp_lt_u32_e64 s[4:5], v4, s6
; GFX9-O0-NEXT:    v_sub_u32_e64 v5, v4, s6
; GFX9-O0-NEXT:    v_lshrrev_b64 v[23:24], v5, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v24
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s6, 0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[6:7], v4, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v22
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v23
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v21
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[6:7]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], v4, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v5
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s8, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v12, v12, v15, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v4
; GFX9-O0-NEXT:    s_mov_b32 s8, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v5, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v14
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], -1
; GFX9-O0-NEXT:    s_mov_b32 s5, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v12, vcc, v12, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v17, vcc, v15, v17, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v14, vcc, v14, v15, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v13, vcc, v13, v15, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v13
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr12 killed $vgpr12 def $vgpr12_vgpr13 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v17
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s6
; GFX9-O0-NEXT:    v_writelane_b32 v16, s4, 8
; GFX9-O0-NEXT:    v_writelane_b32 v16, s5, 9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB1_6
; GFX9-O0-NEXT:  .LBB1_8: ; %udiv-bb1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 1
; GFX9-O0-NEXT:    s_mov_b32 s5, s6
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-O0-NEXT:    s_mov_b32 s4, s7
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s8, s6
; GFX9-O0-NEXT:    s_mov_b32 s9, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v9, vcc, v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v5, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b32 s4, 0x7f
; GFX9-O0-NEXT:    v_sub_u32_e64 v3, s4, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[5:6], v3, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-O0-NEXT:    s_mov_b32 s4, 64
; GFX9-O0-NEXT:    v_sub_u32_e64 v14, s4, v3
; GFX9-O0-NEXT:    v_lshrrev_b64 v[14:15], v14, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v15
; GFX9-O0-NEXT:    v_or_b32_e64 v13, v13, v16
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v6
; GFX9-O0-NEXT:    v_cmp_lt_u32_e64 s[4:5], v3, s4
; GFX9-O0-NEXT:    s_mov_b32 s10, 63
; GFX9-O0-NEXT:    v_sub_u32_e64 v4, s10, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[13:14], v4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s10, 0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[10:11], v3, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v12
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[10:11]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v13
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v6, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v6, s[10:11]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[7:8], v3, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[4:5]
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, v4, v7, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v3
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v10
; GFX9-O0-NEXT:    v_or_b32_e64 v3, v3, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v1, v1, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[4:5], v[1:2], s[6:7]
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-O0-NEXT:    s_and_b64 s[4:5], s[6:7], s[4:5]
; GFX9-O0-NEXT:    s_xor_b64 s[6:7], s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_writelane_b32 v0, s6, 6
; GFX9-O0-NEXT:    v_writelane_b32 v0, s7, 7
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB1_5
; GFX9-O0-NEXT:    s_branch .LBB1_7
; GFX9-O0-NEXT:  .LBB1_9: ; %udiv-end
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 32
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_lshrrev_b64 v[2:3], s4, v[5:6]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    ; kill: killed $vgpr4
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
  %div = udiv i128 %lhs, %rhs
  ret i128 %div
}

define i128 @v_srem_i128_vv(i128 %lhs, i128 %rhs) {
; GFX9-LABEL: v_srem_i128_vv:
; GFX9:       ; %bb.0: ; %_udiv-special-cases
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i32_e32 v20, 31, v3
; GFX9-NEXT:    v_xor_b32_e32 v0, v0, v20
; GFX9-NEXT:    v_xor_b32_e32 v10, v2, v20
; GFX9-NEXT:    v_xor_b32_e32 v1, v1, v20
; GFX9-NEXT:    v_sub_co_u32_e32 v2, vcc, v0, v20
; GFX9-NEXT:    v_xor_b32_e32 v9, v3, v20
; GFX9-NEXT:    v_subb_co_u32_e32 v3, vcc, v1, v20, vcc
; GFX9-NEXT:    v_ashrrev_i32_e32 v8, 31, v7
; GFX9-NEXT:    v_subb_co_u32_e32 v0, vcc, v10, v20, vcc
; GFX9-NEXT:    v_xor_b32_e32 v4, v4, v8
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v9, v20, vcc
; GFX9-NEXT:    v_xor_b32_e32 v5, v5, v8
; GFX9-NEXT:    v_sub_co_u32_e32 v23, vcc, v4, v8
; GFX9-NEXT:    v_xor_b32_e32 v6, v6, v8
; GFX9-NEXT:    v_subb_co_u32_e32 v21, vcc, v5, v8, vcc
; GFX9-NEXT:    v_xor_b32_e32 v7, v7, v8
; GFX9-NEXT:    v_subb_co_u32_e32 v4, vcc, v6, v8, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v5, vcc, v7, v8, vcc
; GFX9-NEXT:    v_or_b32_e32 v7, v21, v5
; GFX9-NEXT:    v_or_b32_e32 v6, v23, v4
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[6:7]
; GFX9-NEXT:    v_or_b32_e32 v7, v3, v1
; GFX9-NEXT:    v_or_b32_e32 v6, v2, v0
; GFX9-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[6:7]
; GFX9-NEXT:    v_ffbh_u32_e32 v6, v4
; GFX9-NEXT:    v_add_u32_e32 v6, 32, v6
; GFX9-NEXT:    v_ffbh_u32_e32 v7, v5
; GFX9-NEXT:    v_min_u32_e32 v6, v6, v7
; GFX9-NEXT:    v_ffbh_u32_e32 v7, v23
; GFX9-NEXT:    v_add_u32_e32 v7, 32, v7
; GFX9-NEXT:    v_ffbh_u32_e32 v8, v21
; GFX9-NEXT:    v_min_u32_e32 v7, v7, v8
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_add_co_u32_e32 v7, vcc, 64, v7
; GFX9-NEXT:    v_addc_co_u32_e64 v8, s[6:7], 0, 0, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[4:5]
; GFX9-NEXT:    v_ffbh_u32_e32 v9, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v7, v6, vcc
; GFX9-NEXT:    v_ffbh_u32_e32 v7, v0
; GFX9-NEXT:    v_add_u32_e32 v7, 32, v7
; GFX9-NEXT:    v_min_u32_e32 v7, v7, v9
; GFX9-NEXT:    v_ffbh_u32_e32 v9, v2
; GFX9-NEXT:    v_add_u32_e32 v9, 32, v9
; GFX9-NEXT:    v_ffbh_u32_e32 v10, v3
; GFX9-NEXT:    v_min_u32_e32 v9, v9, v10
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v8, 0, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v9, vcc, 64, v9
; GFX9-NEXT:    v_addc_co_u32_e64 v10, s[6:7], 0, 0, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[0:1]
; GFX9-NEXT:    s_mov_b64 s[6:7], 0x7f
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v10, 0, vcc
; GFX9-NEXT:    v_sub_co_u32_e32 v6, vcc, v6, v7
; GFX9-NEXT:    v_subb_co_u32_e32 v7, vcc, v8, v10, vcc
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    v_subbrev_co_u32_e32 v8, vcc, 0, v9, vcc
; GFX9-NEXT:    v_subbrev_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[6:7]
; GFX9-NEXT:    v_or_b32_e32 v13, v7, v9
; GFX9-NEXT:    v_cndmask_b32_e64 v10, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[8:9]
; GFX9-NEXT:    v_mov_b32_e32 v22, v20
; GFX9-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v11, v10, vcc
; GFX9-NEXT:    v_and_b32_e32 v10, 1, v10
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v10
; GFX9-NEXT:    v_xor_b32_e32 v10, 0x7f, v6
; GFX9-NEXT:    v_or_b32_e32 v12, v10, v8
; GFX9-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[12:13]
; GFX9-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GFX9-NEXT:    v_cndmask_b32_e64 v11, v1, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v12, v0, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v3, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v13, v2, 0, s[4:5]
; GFX9-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB2_6
; GFX9-NEXT:  ; %bb.1: ; %udiv-bb1
; GFX9-NEXT:    v_add_co_u32_e32 v24, vcc, 1, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v7, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v26, vcc, 0, v8, vcc
; GFX9-NEXT:    v_sub_u32_e32 v13, 0x7f, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, 0, v9, vcc
; GFX9-NEXT:    v_sub_u32_e32 v11, 64, v13
; GFX9-NEXT:    v_or_b32_e32 v8, v25, v27
; GFX9-NEXT:    v_or_b32_e32 v7, v24, v26
; GFX9-NEXT:    v_lshlrev_b64 v[9:10], v13, v[0:1]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], v11, v[2:3]
; GFX9-NEXT:    v_sub_u32_e32 v6, 63, v6
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[7:8]
; GFX9-NEXT:    v_lshlrev_b64 v[6:7], v6, v[2:3]
; GFX9-NEXT:    v_or_b32_e32 v8, v10, v12
; GFX9-NEXT:    v_or_b32_e32 v9, v9, v11
; GFX9-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v13
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v13
; GFX9-NEXT:    v_lshlrev_b64 v[12:13], v13, v[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, v8, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v8, 0
; GFX9-NEXT:    v_mov_b32_e32 v10, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v7, v7, v1, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, v6, v0, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v13, 0, v13, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:    v_mov_b32_e32 v11, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v12, 0, v12, s[4:5]
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB2_5
; GFX9-NEXT:  ; %bb.2: ; %udiv-preheader
; GFX9-NEXT:    v_sub_u32_e32 v10, 64, v24
; GFX9-NEXT:    v_lshrrev_b64 v[8:9], v24, v[2:3]
; GFX9-NEXT:    v_lshlrev_b64 v[10:11], v10, v[0:1]
; GFX9-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v24
; GFX9-NEXT:    v_or_b32_e32 v10, v8, v10
; GFX9-NEXT:    v_subrev_u32_e32 v8, 64, v24
; GFX9-NEXT:    v_or_b32_e32 v11, v9, v11
; GFX9-NEXT:    v_lshrrev_b64 v[8:9], v8, v[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v24
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v9, v11, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v15, v9, v3, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v8, v10, vcc
; GFX9-NEXT:    v_lshrrev_b64 v[8:9], v24, v[0:1]
; GFX9-NEXT:    v_cndmask_b32_e64 v14, v10, v2, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v17, 0, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v16, 0, v8, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v28, vcc, -1, v23
; GFX9-NEXT:    v_addc_co_u32_e32 v29, vcc, -1, v21, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v30, vcc, -1, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v18, 0
; GFX9-NEXT:    v_mov_b32_e32 v10, 0
; GFX9-NEXT:    v_addc_co_u32_e32 v31, vcc, -1, v5, vcc
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v19, 0
; GFX9-NEXT:    v_mov_b32_e32 v11, 0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0
; GFX9-NEXT:  .LBB2_3: ; %udiv-do-while
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 31, v15
; GFX9-NEXT:    v_lshlrev_b64 v[14:15], 1, v[14:15]
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 31, v7
; GFX9-NEXT:    v_lshlrev_b64 v[6:7], 1, v[6:7]
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 31, v13
; GFX9-NEXT:    v_lshlrev_b64 v[16:17], 1, v[16:17]
; GFX9-NEXT:    v_or_b32_e32 v14, v14, v33
; GFX9-NEXT:    v_or3_b32 v6, v6, v8, v10
; GFX9-NEXT:    v_sub_co_u32_e32 v8, vcc, v28, v14
; GFX9-NEXT:    v_or_b32_e32 v16, v16, v32
; GFX9-NEXT:    v_subb_co_u32_e32 v8, vcc, v29, v15, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v8, vcc, v30, v16, vcc
; GFX9-NEXT:    v_lshlrev_b64 v[12:13], 1, v[12:13]
; GFX9-NEXT:    v_subb_co_u32_e32 v8, vcc, v31, v17, vcc
; GFX9-NEXT:    v_ashrrev_i32_e32 v8, 31, v8
; GFX9-NEXT:    v_or_b32_e32 v12, v18, v12
; GFX9-NEXT:    v_and_b32_e32 v18, v8, v23
; GFX9-NEXT:    v_or_b32_e32 v13, v19, v13
; GFX9-NEXT:    v_and_b32_e32 v19, v8, v21
; GFX9-NEXT:    v_sub_co_u32_e32 v14, vcc, v14, v18
; GFX9-NEXT:    v_and_b32_e32 v32, v8, v4
; GFX9-NEXT:    v_subb_co_u32_e32 v15, vcc, v15, v19, vcc
; GFX9-NEXT:    v_and_b32_e32 v33, v8, v5
; GFX9-NEXT:    v_subb_co_u32_e32 v16, vcc, v16, v32, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v17, vcc, v17, v33, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v24, vcc, -1, v24
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, -1, v25, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v26, vcc, -1, v26, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, -1, v27, vcc
; GFX9-NEXT:    v_or_b32_e32 v18, v24, v26
; GFX9-NEXT:    v_or_b32_e32 v19, v25, v27
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[18:19]
; GFX9-NEXT:    v_and_b32_e32 v8, 1, v8
; GFX9-NEXT:    v_mov_b32_e32 v19, v9
; GFX9-NEXT:    v_or3_b32 v7, v7, 0, v11
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v18, v8
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB2_3
; GFX9-NEXT:  ; %bb.4: ; %Flow
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:  .LBB2_5: ; %Flow2
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_lshlrev_b64 v[14:15], 1, v[12:13]
; GFX9-NEXT:    v_lshlrev_b64 v[6:7], 1, v[6:7]
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 31, v13
; GFX9-NEXT:    v_or3_b32 v11, v7, 0, v11
; GFX9-NEXT:    v_or3_b32 v12, v6, v12, v10
; GFX9-NEXT:    v_or_b32_e32 v10, v9, v15
; GFX9-NEXT:    v_or_b32_e32 v13, v8, v14
; GFX9-NEXT:  .LBB2_6: ; %Flow3
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    v_mul_lo_u32 v16, v13, v5
; GFX9-NEXT:    v_mad_u64_u32 v[5:6], s[4:5], v23, v13, 0
; GFX9-NEXT:    v_mov_b32_e32 v15, 0
; GFX9-NEXT:    v_mad_u64_u32 v[7:8], s[4:5], v13, v4, 0
; GFX9-NEXT:    v_mov_b32_e32 v14, v6
; GFX9-NEXT:    v_mad_u64_u32 v[13:14], s[4:5], v21, v13, v[14:15]
; GFX9-NEXT:    v_mul_lo_u32 v9, v10, v4
; GFX9-NEXT:    v_mul_lo_u32 v11, v11, v23
; GFX9-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-NEXT:    v_mov_b32_e32 v14, v15
; GFX9-NEXT:    v_mad_u64_u32 v[13:14], s[4:5], v23, v10, v[13:14]
; GFX9-NEXT:    v_add3_u32 v8, v8, v16, v9
; GFX9-NEXT:    v_mad_u64_u32 v[6:7], s[4:5], v12, v23, v[7:8]
; GFX9-NEXT:    v_mov_b32_e32 v8, v14
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, v4, v8
; GFX9-NEXT:    v_addc_co_u32_e64 v9, s[4:5], 0, 0, vcc
; GFX9-NEXT:    v_mul_lo_u32 v12, v12, v21
; GFX9-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v21, v10, v[8:9]
; GFX9-NEXT:    v_add3_u32 v4, v11, v7, v12
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, v8, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v4, vcc, v9, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v7, v13
; GFX9-NEXT:    v_sub_co_u32_e32 v2, vcc, v2, v5
; GFX9-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v7, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v0, vcc, v0, v6, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v4, vcc
; GFX9-NEXT:    v_xor_b32_e32 v5, v0, v20
; GFX9-NEXT:    v_xor_b32_e32 v0, v2, v20
; GFX9-NEXT:    v_xor_b32_e32 v4, v1, v22
; GFX9-NEXT:    v_xor_b32_e32 v1, v3, v22
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v20
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v22, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v2, vcc, v5, v20, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v3, vcc, v4, v22, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O0-LABEL: v_srem_i128_vv:
; GFX9-O0:       ; %bb.0: ; %_udiv-special-cases
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:348 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:352 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:356 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:360 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $vgpr8 : SGPR spill to VGPR lane
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v6
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v0
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    s_waitcnt vmcnt(1)
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v15
; GFX9-O0-NEXT:    v_ashrrev_i64 v[12:13], s4, v[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v13
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v9
; GFX9-O0-NEXT:    v_ashrrev_i64 v[6:7], s4, v[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v13
; GFX9-O0-NEXT:    v_xor_b32_e64 v1, v1, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v14
; GFX9-O0-NEXT:    v_xor_b32_e64 v13, v11, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_xor_b32_e64 v1, v1, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 killed $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_xor_b32_e64 v15, v4, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v7
; GFX9-O0-NEXT:    v_xor_b32_e64 v1, v1, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_xor_b32_e64 v7, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_xor_b32_e64 v1, v1, v4
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_xor_b32_e64 v2, v2, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v16
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v14
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v9, vcc, v9, v12
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v10, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v13, vcc, v11, v12, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v5, vcc, v5, v10, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 killed $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v8
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v1, vcc, v1, v6
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v4, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v11, vcc, v5, v6, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v12
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-O0-NEXT:    v_or_b32_e64 v3, v8, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    v_or_b32_e64 v1, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    v_writelane_b32 v0, s6, 0
; GFX9-O0-NEXT:    v_writelane_b32 v0, s7, 1
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[4:5], v[1:2], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    v_or_b32_e64 v15, v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v9, v3, v1
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v15
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[8:9], v[9:10], s[6:7]
; GFX9-O0-NEXT:    s_or_b64 s[4:5], s[4:5], s[8:9]
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v6, v6
; GFX9-O0-NEXT:    s_mov_b32 s9, 32
; GFX9-O0-NEXT:    v_add_u32_e64 v6, v6, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v7, v7
; GFX9-O0-NEXT:    v_min_u32_e64 v6, v6, v7
; GFX9-O0-NEXT:    s_mov_b32 s8, 0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v5
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v8, v8
; GFX9-O0-NEXT:    v_min_u32_e64 v15, v5, v8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v5
; GFX9-O0-NEXT:    s_mov_b64 s[10:11], 64
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v15
; GFX9-O0-NEXT:    s_mov_b32 s12, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v16
; GFX9-O0-NEXT:    s_mov_b32 s14, s11
; GFX9-O0-NEXT:    v_add_co_u32_e64 v8, s[12:13], v8, s12
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s14
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[12:13], v5, v9, s[12:13]
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[12:13], v[11:12], s[6:7]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v10, s[12:13]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v9, v6, v7, s[12:13]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v1
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v6, v2
; GFX9-O0-NEXT:    v_min_u32_e64 v6, v5, v6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v7
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v3
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v11, v4
; GFX9-O0-NEXT:    v_min_u32_e64 v15, v5, v11
; GFX9-O0-NEXT:    ; implicit-def: $sgpr9
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v15
; GFX9-O0-NEXT:    s_mov_b32 s8, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v16
; GFX9-O0-NEXT:    s_mov_b32 s10, s11
; GFX9-O0-NEXT:    v_add_co_u32_e64 v11, s[8:9], v11, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s10
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[8:9], v5, v12, s[8:9]
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[8:9], v[13:14], s[6:7]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    s_mov_b32 s10, s6
; GFX9-O0-NEXT:    s_mov_b32 s11, s7
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v5, vcc, v5, v8
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v9, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s10
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v8, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s11
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s11
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v8
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[8:9], v[8:9], s[8:9]
; GFX9-O0-NEXT:    s_mov_b64 s[12:13], 0x7f
; GFX9-O0-NEXT:    s_mov_b64 s[14:15], s[12:13]
; GFX9-O0-NEXT:    v_cmp_gt_u64_e64 s[14:15], v[5:6], s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v10, 0, 1, s[14:15]
; GFX9-O0-NEXT:    s_mov_b64 s[14:15], s[6:7]
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[14:15], v[8:9], s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, 0, 1, s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, v7, v10, s[8:9]
; GFX9-O0-NEXT:    v_and_b32_e64 v7, 1, v7
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[8:9], v7, 1
; GFX9-O0-NEXT:    s_or_b64 s[8:9], s[4:5], s[8:9]
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], -1
; GFX9-O0-NEXT:    s_xor_b64 s[4:5], s[8:9], s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    s_mov_b32 s14, s13
; GFX9-O0-NEXT:    v_xor_b32_e64 v7, v7, s14
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    ; kill: def $sgpr12 killed $sgpr12 killed $sgpr12_sgpr13
; GFX9-O0-NEXT:    v_xor_b32_e64 v5, v5, s12
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v7, v7, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[6:7], v[5:6], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v2, v5, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v4, v5, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v5
; GFX9-O0-NEXT:    s_and_b64 s[6:7], s[4:5], s[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-O0-NEXT:    v_writelane_b32 v0, s4, 2
; GFX9-O0-NEXT:    v_writelane_b32 v0, s5, 3
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB2_3
; GFX9-O0-NEXT:    s_branch .LBB2_8
; GFX9-O0-NEXT:  .LBB2_1: ; %Flow
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v0, 4
; GFX9-O0-NEXT:    v_readlane_b32 s5, v0, 5
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:  ; %bb.2: ; %Flow
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(6)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB2_5
; GFX9-O0-NEXT:  .LBB2_3: ; %Flow2
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v4, 2
; GFX9-O0-NEXT:    v_readlane_b32 s5, v4, 3
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB2_9
; GFX9-O0-NEXT:  .LBB2_4: ; %udiv-loop-exit
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 1
; GFX9-O0-NEXT:    s_waitcnt vmcnt(2)
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s4, v[0:1]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshlrev_b64 v[9:10], s4, v[9:10]
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v8
; GFX9-O0-NEXT:    v_or3_b32 v4, v4, v11, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v9
; GFX9-O0-NEXT:    v_or3_b32 v0, v0, v1, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v6
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v4, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v4
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB2_3
; GFX9-O0-NEXT:  .LBB2_5: ; %Flow1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v8, 6
; GFX9-O0-NEXT:    v_readlane_b32 s5, v8, 7
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB2_4
; GFX9-O0-NEXT:  .LBB2_6: ; %udiv-do-while
; GFX9-O0-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s6, v16, 8
; GFX9-O0-NEXT:    v_readlane_b32 s7, v16, 9
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    s_waitcnt vmcnt(16)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[29:30], s4, v[2:3]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v30
; GFX9-O0-NEXT:    s_mov_b32 s5, 1
; GFX9-O0-NEXT:    v_lshlrev_b64 v[23:24], s5, v[23:24]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v24
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v29
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v23
; GFX9-O0-NEXT:    v_or_b32_e64 v23, v5, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[29:30], s5, v[2:3]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], s4, v[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v30
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v29
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 killed $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v3, v4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s5, v[0:1]
; GFX9-O0-NEXT:    v_lshlrev_b64 v[29:30], s5, v[6:7]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v30
; GFX9-O0-NEXT:    s_waitcnt vmcnt(10)
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v28
; GFX9-O0-NEXT:    v_or3_b32 v6, v6, v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v29
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v27
; GFX9-O0-NEXT:    v_or3_b32 v0, v0, v1, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    s_waitcnt vmcnt(8)
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v26
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v25
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v24
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v15
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v13, vcc, v13, v6
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v12, vcc, v12, v10, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v11, vcc, v11, v4, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v7, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    v_ashrrev_i64 v[13:14], s4, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v14
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], 1
; GFX9-O0-NEXT:    s_mov_b32 s8, s5
; GFX9-O0-NEXT:    v_and_b32_e64 v12, v7, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v13
; GFX9-O0-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_and_b32_e64 v14, v11, s4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v22
; GFX9-O0-NEXT:    v_and_b32_e64 v23, v7, v23
; GFX9-O0-NEXT:    v_and_b32_e64 v21, v11, v21
; GFX9-O0-NEXT:    ; kill: def $vgpr21 killed $vgpr21 def $vgpr21_vgpr22 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v20
; GFX9-O0-NEXT:    v_and_b32_e64 v7, v7, v23
; GFX9-O0-NEXT:    v_and_b32_e64 v23, v11, v19
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v24
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v22
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v6, vcc, v6, v20
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v10, vcc, v10, v19, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v4, vcc, v4, v11, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v5, v7, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v8
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 killed $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], -1
; GFX9-O0-NEXT:    s_mov_b32 s5, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v20, vcc, v11, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v9, vcc, v9, v11, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v17, vcc, v10, v11, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v8, vcc, v8, v10, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr20 killed $vgpr20 def $vgpr20_vgpr21 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v20
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v21
; GFX9-O0-NEXT:    v_or_b32_e64 v19, v19, v22
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v20
; GFX9-O0-NEXT:    v_or_b32_e64 v17, v17, v18
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v19
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[4:5], v[17:18], v[12:13]
; GFX9-O0-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v0
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v14
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v12
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GFX9-O0-NEXT:    v_writelane_b32 v16, s6, 4
; GFX9-O0-NEXT:    v_writelane_b32 v16, s7, 5
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GFX9-O0-NEXT:    v_writelane_b32 v16, s6, 8
; GFX9-O0-NEXT:    v_writelane_b32 v16, s7, 9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execnz .LBB2_6
; GFX9-O0-NEXT:    s_branch .LBB2_1
; GFX9-O0-NEXT:  .LBB2_7: ; %udiv-preheader
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:344 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(9)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[6:7], v4, v[21:22]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    s_mov_b32 s6, 64
; GFX9-O0-NEXT:    v_sub_u32_e64 v12, s6, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[23:24], v12, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v24
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v23
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    v_cmp_lt_u32_e64 s[4:5], v4, s6
; GFX9-O0-NEXT:    v_sub_u32_e64 v5, v4, s6
; GFX9-O0-NEXT:    v_lshrrev_b64 v[23:24], v5, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v24
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s6, 0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[6:7], v4, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v22
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v23
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v21
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[6:7]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], v4, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v5
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s8, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v12, v12, v15, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v4
; GFX9-O0-NEXT:    s_mov_b32 s8, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v5, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v14
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], -1
; GFX9-O0-NEXT:    s_mov_b32 s5, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v12, vcc, v12, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v17, vcc, v15, v17, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v14, vcc, v14, v15, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v13, vcc, v13, v15, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v13
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr12 killed $vgpr12 def $vgpr12_vgpr13 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v17
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s6
; GFX9-O0-NEXT:    v_writelane_b32 v16, s4, 8
; GFX9-O0-NEXT:    v_writelane_b32 v16, s5, 9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB2_6
; GFX9-O0-NEXT:  .LBB2_8: ; %udiv-bb1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 1
; GFX9-O0-NEXT:    s_mov_b32 s5, s6
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-O0-NEXT:    s_mov_b32 s4, s7
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s8, s6
; GFX9-O0-NEXT:    s_mov_b32 s9, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v9, vcc, v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v5, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:344 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b32 s4, 0x7f
; GFX9-O0-NEXT:    v_sub_u32_e64 v3, s4, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[5:6], v3, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-O0-NEXT:    s_mov_b32 s4, 64
; GFX9-O0-NEXT:    v_sub_u32_e64 v14, s4, v3
; GFX9-O0-NEXT:    v_lshrrev_b64 v[14:15], v14, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v15
; GFX9-O0-NEXT:    v_or_b32_e64 v13, v13, v16
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v6
; GFX9-O0-NEXT:    v_cmp_lt_u32_e64 s[4:5], v3, s4
; GFX9-O0-NEXT:    s_mov_b32 s10, 63
; GFX9-O0-NEXT:    v_sub_u32_e64 v4, s10, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[13:14], v4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s10, 0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[10:11], v3, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v12
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[10:11]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v13
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v6, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v6, s[10:11]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[7:8], v3, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[4:5]
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, v4, v7, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v3
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v10
; GFX9-O0-NEXT:    v_or_b32_e64 v3, v3, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v1, v1, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[4:5], v[1:2], s[6:7]
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-O0-NEXT:    s_and_b64 s[4:5], s[6:7], s[4:5]
; GFX9-O0-NEXT:    s_xor_b64 s[6:7], s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_writelane_b32 v0, s6, 6
; GFX9-O0-NEXT:    v_writelane_b32 v0, s7, 7
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB2_5
; GFX9-O0-NEXT:    s_branch .LBB2_7
; GFX9-O0-NEXT:  .LBB2_9: ; %udiv-end
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 32
; GFX9-O0-NEXT:    s_waitcnt vmcnt(2)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[5:6]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v17
; GFX9-O0-NEXT:    v_mul_lo_u32 v3, v1, v0
; GFX9-O0-NEXT:    v_lshrrev_b64 v[17:18], s4, v[17:18]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v17
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mul_lo_u32 v2, v5, v2
; GFX9-O0-NEXT:    v_mad_u64_u32 v[17:18], s[6:7], v5, v0, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v18
; GFX9-O0-NEXT:    v_add3_u32 v2, v0, v2, v3
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v0
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s4, v[2:3]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 killed $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    s_mov_b32 s5, 0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v18
; GFX9-O0-NEXT:    v_or_b32_e64 v0, v0, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v17
; GFX9-O0-NEXT:    v_or_b32_e64 v17, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v0
; GFX9-O0-NEXT:    v_lshrrev_b64 v[2:3], s4, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v11
; GFX9-O0-NEXT:    v_mul_lo_u32 v3, v2, v6
; GFX9-O0-NEXT:    v_lshrrev_b64 v[11:12], s4, v[11:12]
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 killed $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v19
; GFX9-O0-NEXT:    v_mul_lo_u32 v11, v11, v0
; GFX9-O0-NEXT:    v_mad_u64_u32 v[19:20], s[6:7], v2, v0, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v20
; GFX9-O0-NEXT:    v_add3_u32 v2, v2, v3, v11
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s4, v[2:3]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 killed $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v20
; GFX9-O0-NEXT:    v_or_b32_e64 v11, v11, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v19
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v18
; GFX9-O0-NEXT:    v_add_co_u32_e64 v17, s[6:7], v11, v12
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v2, s[6:7], v2, v3, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v2
; GFX9-O0-NEXT:    v_mad_u64_u32 v[19:20], s[6:7], v6, v1, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v19
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v20
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v12
; GFX9-O0-NEXT:    v_lshlrev_b64 v[19:20], s4, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v20
; GFX9-O0-NEXT:    v_or_b32_e64 v11, v11, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v19
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mad_u64_u32 v[19:20], s[6:7], v6, v5, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v19
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v20
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v21
; GFX9-O0-NEXT:    v_lshlrev_b64 v[19:20], s4, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, v20
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v21
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 killed $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v19
; GFX9-O0-NEXT:    v_or_b32_e64 v23, v11, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v6
; GFX9-O0-NEXT:    v_mad_u64_u32 v[11:12], s[6:7], v0, v5, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, v12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr21 killed $vgpr21 def $vgpr21_vgpr22 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v24
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v22
; GFX9-O0-NEXT:    v_add_co_u32_e64 v5, s[6:7], v5, v20
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v19, s[6:7], v6, v19, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v19
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v6
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0xffffffff
; GFX9-O0-NEXT:    s_mov_b32 s8, s7
; GFX9-O0-NEXT:    v_and_b32_e64 v19, v19, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v5
; GFX9-O0-NEXT:    ; kill: def $sgpr6 killed $sgpr6 killed $sgpr6_sgpr7
; GFX9-O0-NEXT:    v_and_b32_e64 v21, v20, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr21 killed $vgpr21 def $vgpr21_vgpr22 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v19
; GFX9-O0-NEXT:    v_mad_u64_u32 v[19:20], s[6:7], v0, v1, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v19
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v24
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v20
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v1
; GFX9-O0-NEXT:    v_lshlrev_b64 v[19:20], s4, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v20
; GFX9-O0-NEXT:    v_or_b32_e64 v0, v0, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v23
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 killed $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_or_b32_e64 v23, v1, v19
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v24
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v22
; GFX9-O0-NEXT:    v_add_co_u32_e64 v0, s[6:7], v0, v20
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v19, s[6:7], v1, v19, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v19
; GFX9-O0-NEXT:    v_lshrrev_b64 v[21:22], s4, v[0:1]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[5:6], s4, v[5:6]
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v22
; GFX9-O0-NEXT:    v_add_co_u32_e64 v19, s[6:7], v19, v20
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[6:7], v5, v6, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v19
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v20
; GFX9-O0-NEXT:    v_add_co_u32_e64 v19, s[6:7], v5, v6
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v2, s[6:7], v2, v3, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v19
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v20
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v18
; GFX9-O0-NEXT:    v_add_co_u32_e64 v2, s[6:7], v2, v6
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[6:7], v3, v5, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    v_lshlrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 killed $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v11
; GFX9-O0-NEXT:    v_or_b32_e64 v0, v0, v1
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v16
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v14
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v12
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v11, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v5, vcc, v5, v6, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v2, vcc, v1, v2, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v10
; GFX9-O0-NEXT:    v_xor_b32_e64 v3, v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_xor_b32_e64 v9, v6, v5
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_xor_b32_e64 v3, v3, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 killed $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v7
; GFX9-O0-NEXT:    v_xor_b32_e64 v0, v0, v8
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v10
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v7, vcc, v7, v8
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v0, vcc, v0, v6, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v5, vcc, v3, v5, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_lshrrev_b64 v[7:8], s4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-O0-NEXT:    v_lshrrev_b64 v[5:6], s4, v[5:6]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    ; kill: killed $vgpr4
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:348 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:352 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:356 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:360 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
  %div = srem i128 %lhs, %rhs
  ret i128 %div
}

define i128 @v_urem_i128_vv(i128 %lhs, i128 %rhs) {
; GFX9-LABEL: v_urem_i128_vv:
; GFX9:       ; %bb.0: ; %_udiv-special-cases
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_or_b32_e32 v9, v5, v7
; GFX9-NEXT:    v_or_b32_e32 v8, v4, v6
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[8:9]
; GFX9-NEXT:    v_or_b32_e32 v9, v1, v3
; GFX9-NEXT:    v_or_b32_e32 v8, v0, v2
; GFX9-NEXT:    v_cmp_eq_u64_e64 s[4:5], 0, v[8:9]
; GFX9-NEXT:    v_ffbh_u32_e32 v8, v6
; GFX9-NEXT:    v_add_u32_e32 v8, 32, v8
; GFX9-NEXT:    v_ffbh_u32_e32 v9, v7
; GFX9-NEXT:    v_min_u32_e32 v8, v8, v9
; GFX9-NEXT:    v_ffbh_u32_e32 v9, v4
; GFX9-NEXT:    v_add_u32_e32 v9, 32, v9
; GFX9-NEXT:    v_ffbh_u32_e32 v10, v5
; GFX9-NEXT:    v_min_u32_e32 v9, v9, v10
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_add_co_u32_e32 v9, vcc, 64, v9
; GFX9-NEXT:    v_addc_co_u32_e64 v10, s[6:7], 0, 0, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[6:7]
; GFX9-NEXT:    v_ffbh_u32_e32 v11, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX9-NEXT:    v_ffbh_u32_e32 v9, v2
; GFX9-NEXT:    v_add_u32_e32 v9, 32, v9
; GFX9-NEXT:    v_min_u32_e32 v9, v9, v11
; GFX9-NEXT:    v_ffbh_u32_e32 v11, v0
; GFX9-NEXT:    v_add_u32_e32 v11, 32, v11
; GFX9-NEXT:    v_ffbh_u32_e32 v12, v1
; GFX9-NEXT:    v_min_u32_e32 v11, v11, v12
; GFX9-NEXT:    v_cndmask_b32_e64 v10, v10, 0, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v11, vcc, 64, v11
; GFX9-NEXT:    v_addc_co_u32_e64 v12, s[6:7], 0, 0, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[2:3]
; GFX9-NEXT:    s_mov_b64 s[6:7], 0x7f
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v12, v12, 0, vcc
; GFX9-NEXT:    v_sub_co_u32_e32 v8, vcc, v8, v9
; GFX9-NEXT:    v_subb_co_u32_e32 v9, vcc, v10, v12, vcc
; GFX9-NEXT:    v_mov_b32_e32 v11, 0
; GFX9-NEXT:    v_subbrev_co_u32_e32 v10, vcc, 0, v11, vcc
; GFX9-NEXT:    v_subbrev_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[6:7], v[8:9]
; GFX9-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[10:11]
; GFX9-NEXT:    v_cndmask_b32_e64 v13, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GFX9-NEXT:    v_cndmask_b32_e32 v12, v13, v12, vcc
; GFX9-NEXT:    v_and_b32_e32 v12, 1, v12
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v12
; GFX9-NEXT:    v_xor_b32_e32 v12, 0x7f, v8
; GFX9-NEXT:    v_or_b32_e32 v13, v9, v11
; GFX9-NEXT:    v_or_b32_e32 v12, v12, v10
; GFX9-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[12:13]
; GFX9-NEXT:    s_xor_b64 s[6:7], s[4:5], -1
; GFX9-NEXT:    v_cndmask_b32_e64 v15, v3, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v14, v2, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v13, v1, 0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v12, v0, 0, s[4:5]
; GFX9-NEXT:    s_and_b64 s[4:5], s[6:7], vcc
; GFX9-NEXT:    s_and_saveexec_b64 s[8:9], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB3_6
; GFX9-NEXT:  ; %bb.1: ; %udiv-bb1
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, 1, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, 0, v9, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v24, vcc, 0, v10, vcc
; GFX9-NEXT:    v_sub_u32_e32 v15, 0x7f, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, 0, v11, vcc
; GFX9-NEXT:    v_sub_u32_e32 v13, 64, v15
; GFX9-NEXT:    v_or_b32_e32 v10, v23, v25
; GFX9-NEXT:    v_or_b32_e32 v9, v22, v24
; GFX9-NEXT:    v_lshlrev_b64 v[11:12], v15, v[2:3]
; GFX9-NEXT:    v_lshrrev_b64 v[13:14], v13, v[0:1]
; GFX9-NEXT:    v_sub_u32_e32 v8, 63, v8
; GFX9-NEXT:    v_cmp_ne_u64_e32 vcc, 0, v[9:10]
; GFX9-NEXT:    v_lshlrev_b64 v[8:9], v8, v[0:1]
; GFX9-NEXT:    v_or_b32_e32 v10, v12, v14
; GFX9-NEXT:    v_or_b32_e32 v11, v11, v13
; GFX9-NEXT:    v_cmp_gt_u32_e64 s[4:5], 64, v15
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v10, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v8, v11, s[4:5]
; GFX9-NEXT:    v_lshlrev_b64 v[10:11], v15, v[0:1]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v15
; GFX9-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-NEXT:    v_mov_b32_e32 v14, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v9, v9, v3, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v8, v8, v2, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e64 v11, 0, v11, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-NEXT:    v_mov_b32_e32 v15, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v10, 0, v10, s[4:5]
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[6:7], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB3_5
; GFX9-NEXT:  ; %bb.2: ; %udiv-preheader
; GFX9-NEXT:    v_sub_u32_e32 v14, 64, v22
; GFX9-NEXT:    v_lshrrev_b64 v[12:13], v22, v[0:1]
; GFX9-NEXT:    v_lshlrev_b64 v[14:15], v14, v[2:3]
; GFX9-NEXT:    v_cmp_gt_u32_e32 vcc, 64, v22
; GFX9-NEXT:    v_or_b32_e32 v14, v12, v14
; GFX9-NEXT:    v_subrev_u32_e32 v12, 64, v22
; GFX9-NEXT:    v_or_b32_e32 v15, v13, v15
; GFX9-NEXT:    v_lshrrev_b64 v[12:13], v12, v[2:3]
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 0, v22
; GFX9-NEXT:    v_cndmask_b32_e32 v13, v13, v15, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v17, v13, v1, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v14, v12, v14, vcc
; GFX9-NEXT:    v_lshrrev_b64 v[12:13], v22, v[2:3]
; GFX9-NEXT:    v_cndmask_b32_e64 v16, v14, v0, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v19, 0, v13, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v18, 0, v12, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v26, vcc, -1, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v27, vcc, -1, v5, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v28, vcc, -1, v6, vcc
; GFX9-NEXT:    v_mov_b32_e32 v20, 0
; GFX9-NEXT:    v_mov_b32_e32 v14, 0
; GFX9-NEXT:    v_addc_co_u32_e32 v29, vcc, -1, v7, vcc
; GFX9-NEXT:    s_mov_b64 s[4:5], 0
; GFX9-NEXT:    v_mov_b32_e32 v21, 0
; GFX9-NEXT:    v_mov_b32_e32 v15, 0
; GFX9-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-NEXT:  .LBB3_3: ; %udiv-do-while
; GFX9-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 31, v11
; GFX9-NEXT:    v_lshlrev_b64 v[10:11], 1, v[10:11]
; GFX9-NEXT:    v_lshlrev_b64 v[18:19], 1, v[18:19]
; GFX9-NEXT:    v_or_b32_e32 v10, v20, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 31, v17
; GFX9-NEXT:    v_lshlrev_b64 v[16:17], 1, v[16:17]
; GFX9-NEXT:    v_or_b32_e32 v18, v18, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 31, v9
; GFX9-NEXT:    v_or_b32_e32 v16, v16, v20
; GFX9-NEXT:    v_sub_co_u32_e32 v20, vcc, v26, v16
; GFX9-NEXT:    v_subb_co_u32_e32 v20, vcc, v27, v17, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v20, vcc, v28, v18, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v20, vcc, v29, v19, vcc
; GFX9-NEXT:    v_ashrrev_i32_e32 v30, 31, v20
; GFX9-NEXT:    v_and_b32_e32 v20, v30, v4
; GFX9-NEXT:    v_sub_co_u32_e32 v16, vcc, v16, v20
; GFX9-NEXT:    v_and_b32_e32 v20, v30, v5
; GFX9-NEXT:    v_subb_co_u32_e32 v17, vcc, v17, v20, vcc
; GFX9-NEXT:    v_and_b32_e32 v20, v30, v6
; GFX9-NEXT:    v_subb_co_u32_e32 v18, vcc, v18, v20, vcc
; GFX9-NEXT:    v_and_b32_e32 v20, v30, v7
; GFX9-NEXT:    v_subb_co_u32_e32 v19, vcc, v19, v20, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v22, vcc, -1, v22
; GFX9-NEXT:    v_addc_co_u32_e32 v23, vcc, -1, v23, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v24, vcc, -1, v24, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v25, vcc, -1, v25, vcc
; GFX9-NEXT:    v_or_b32_e32 v11, v21, v11
; GFX9-NEXT:    v_lshlrev_b64 v[8:9], 1, v[8:9]
; GFX9-NEXT:    v_or_b32_e32 v20, v22, v24
; GFX9-NEXT:    v_or_b32_e32 v21, v23, v25
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[20:21]
; GFX9-NEXT:    v_or3_b32 v8, v8, v12, v14
; GFX9-NEXT:    v_and_b32_e32 v12, 1, v30
; GFX9-NEXT:    v_mov_b32_e32 v21, v13
; GFX9-NEXT:    v_or3_b32 v9, v9, 0, v15
; GFX9-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v20, v12
; GFX9-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB3_3
; GFX9-NEXT:  ; %bb.4: ; %Flow
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:  .LBB3_5: ; %Flow2
; GFX9-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX9-NEXT:    v_lshlrev_b64 v[16:17], 1, v[10:11]
; GFX9-NEXT:    v_lshlrev_b64 v[8:9], 1, v[8:9]
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 31, v11
; GFX9-NEXT:    v_or3_b32 v15, v9, 0, v15
; GFX9-NEXT:    v_or3_b32 v14, v8, v10, v14
; GFX9-NEXT:    v_or_b32_e32 v13, v13, v17
; GFX9-NEXT:    v_or_b32_e32 v12, v12, v16
; GFX9-NEXT:  .LBB3_6: ; %Flow3
; GFX9-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX9-NEXT:    v_mul_lo_u32 v19, v12, v7
; GFX9-NEXT:    v_mad_u64_u32 v[7:8], s[4:5], v4, v12, 0
; GFX9-NEXT:    v_mov_b32_e32 v17, 0
; GFX9-NEXT:    v_mad_u64_u32 v[9:10], s[4:5], v12, v6, 0
; GFX9-NEXT:    v_mov_b32_e32 v16, v8
; GFX9-NEXT:    v_mad_u64_u32 v[11:12], s[4:5], v5, v12, v[16:17]
; GFX9-NEXT:    v_mul_lo_u32 v18, v13, v6
; GFX9-NEXT:    v_mul_lo_u32 v16, v15, v4
; GFX9-NEXT:    v_mov_b32_e32 v6, v12
; GFX9-NEXT:    v_mov_b32_e32 v12, v17
; GFX9-NEXT:    v_mad_u64_u32 v[11:12], s[4:5], v4, v13, v[11:12]
; GFX9-NEXT:    v_add3_u32 v10, v10, v19, v18
; GFX9-NEXT:    v_mad_u64_u32 v[8:9], s[4:5], v14, v4, v[9:10]
; GFX9-NEXT:    v_mov_b32_e32 v4, v12
; GFX9-NEXT:    v_mul_lo_u32 v10, v14, v5
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, v6, v4
; GFX9-NEXT:    v_addc_co_u32_e64 v15, s[4:5], 0, 0, vcc
; GFX9-NEXT:    v_mad_u64_u32 v[4:5], s[4:5], v5, v13, v[14:15]
; GFX9-NEXT:    v_add3_u32 v6, v16, v9, v10
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, v4, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v6, vcc
; GFX9-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-NEXT:    v_sub_co_u32_e32 v0, vcc, v0, v7
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v6, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v2, vcc, v2, v4, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v5, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O0-LABEL: v_urem_i128_vv:
; GFX9-O0:       ; %bb.0: ; %_udiv-special-cases
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:328 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:332 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:336 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 offset:340 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $vgpr8 : SGPR spill to VGPR lane
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v6
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v0
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v3
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v12
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v12
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v1
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-O0-NEXT:    v_or_b32_e64 v3, v8, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    v_or_b32_e64 v1, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    v_writelane_b32 v0, s6, 0
; GFX9-O0-NEXT:    v_writelane_b32 v0, s7, 1
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[4:5], v[1:2], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    v_or_b32_e64 v15, v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v9, v3, v1
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v15
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[8:9], v[9:10], s[6:7]
; GFX9-O0-NEXT:    s_or_b64 s[4:5], s[4:5], s[8:9]
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v6, v6
; GFX9-O0-NEXT:    s_mov_b32 s9, 32
; GFX9-O0-NEXT:    v_add_u32_e64 v6, v6, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v7, v7
; GFX9-O0-NEXT:    v_min_u32_e64 v6, v6, v7
; GFX9-O0-NEXT:    s_mov_b32 s8, 0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v7
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v5
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v8, v8
; GFX9-O0-NEXT:    v_min_u32_e64 v15, v5, v8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v5
; GFX9-O0-NEXT:    s_mov_b64 s[10:11], 64
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v15
; GFX9-O0-NEXT:    s_mov_b32 s12, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v16
; GFX9-O0-NEXT:    s_mov_b32 s14, s11
; GFX9-O0-NEXT:    v_add_co_u32_e64 v8, s[12:13], v8, s12
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, s14
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[12:13], v5, v9, s[12:13]
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    s_mov_b64 s[12:13], s[6:7]
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[12:13], v[11:12], s[12:13]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v10, s[12:13]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v9, v6, v7, s[12:13]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v1
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v6, v2
; GFX9-O0-NEXT:    v_min_u32_e64 v6, v5, v6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v7
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v5, v3
; GFX9-O0-NEXT:    v_add_u32_e64 v5, v5, s9
; GFX9-O0-NEXT:    v_ffbh_u32_e64 v11, v4
; GFX9-O0-NEXT:    v_min_u32_e64 v15, v5, v11
; GFX9-O0-NEXT:    ; implicit-def: $sgpr9
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v15
; GFX9-O0-NEXT:    s_mov_b32 s8, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v16
; GFX9-O0-NEXT:    s_mov_b32 s10, s11
; GFX9-O0-NEXT:    v_add_co_u32_e64 v11, s[8:9], v11, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s10
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v5, s[8:9], v5, v12, s[8:9]
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[8:9], v[13:14], s[8:9]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    s_mov_b32 s10, s6
; GFX9-O0-NEXT:    s_mov_b32 s11, s7
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v5, vcc, v5, v8
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v9, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s10
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v8, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s11
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s11
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v6, v7, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v8
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[8:9], v[8:9], s[8:9]
; GFX9-O0-NEXT:    s_mov_b64 s[12:13], 0x7f
; GFX9-O0-NEXT:    s_mov_b64 s[14:15], s[12:13]
; GFX9-O0-NEXT:    v_cmp_gt_u64_e64 s[14:15], v[5:6], s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v10, 0, 1, s[14:15]
; GFX9-O0-NEXT:    s_mov_b64 s[14:15], s[6:7]
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[14:15], v[8:9], s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, 0, 1, s[14:15]
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, v7, v10, s[8:9]
; GFX9-O0-NEXT:    v_and_b32_e64 v7, 1, v7
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[8:9], v7, 1
; GFX9-O0-NEXT:    s_or_b64 s[8:9], s[4:5], s[8:9]
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], -1
; GFX9-O0-NEXT:    s_xor_b64 s[4:5], s[8:9], s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    s_mov_b32 s14, s13
; GFX9-O0-NEXT:    v_xor_b32_e64 v7, v7, s14
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    ; kill: def $sgpr12 killed $sgpr12 killed $sgpr12_sgpr13
; GFX9-O0-NEXT:    v_xor_b32_e64 v5, v5, s12
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v7, v7, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v8
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[6:7], v[5:6], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v2, v5, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s10
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v1, v1, v2, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr12
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v4, v5, s[8:9]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[8:9]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; implicit-def: $sgpr8
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v5
; GFX9-O0-NEXT:    s_and_b64 s[6:7], s[4:5], s[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], exec
; GFX9-O0-NEXT:    v_writelane_b32 v0, s4, 2
; GFX9-O0-NEXT:    v_writelane_b32 v0, s5, 3
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB3_3
; GFX9-O0-NEXT:    s_branch .LBB3_8
; GFX9-O0-NEXT:  .LBB3_1: ; %Flow
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v0, 4
; GFX9-O0-NEXT:    v_readlane_b32 s5, v0, 5
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:  ; %bb.2: ; %Flow
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:156 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:160 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:164 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(6)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB3_5
; GFX9-O0-NEXT:  .LBB3_3: ; %Flow2
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v4, 2
; GFX9-O0-NEXT:    v_readlane_b32 s5, v4, 3
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:176 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:180 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:168 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:172 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB3_9
; GFX9-O0-NEXT:  .LBB3_4: ; %udiv-loop-exit
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:184 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:188 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:192 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:196 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:200 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:204 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:208 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:212 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 1
; GFX9-O0-NEXT:    s_waitcnt vmcnt(2)
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s4, v[0:1]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshlrev_b64 v[9:10], s4, v[9:10]
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v8
; GFX9-O0-NEXT:    v_or3_b32 v4, v4, v11, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v9
; GFX9-O0-NEXT:    v_or3_b32 v0, v0, v1, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v6
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v4, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v4
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB3_3
; GFX9-O0-NEXT:  .LBB3_5: ; %Flow1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s4, v8, 6
; GFX9-O0-NEXT:    v_readlane_b32 s5, v8, 7
; GFX9-O0-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:192 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:196 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:184 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:188 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:208 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:212 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:200 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:204 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB3_4
; GFX9-O0-NEXT:  .LBB3_6: ; %udiv-do-while
; GFX9-O0-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_readlane_b32 s6, v16, 8
; GFX9-O0-NEXT:    v_readlane_b32 s7, v16, 9
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:216 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:220 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:224 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:228 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v23, off, s[0:3], s32 offset:232 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v24, off, s[0:3], s32 offset:236 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:240 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:244 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:248 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:252 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:256 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:260 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v27, off, s[0:3], s32 offset:264 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v28, off, s[0:3], s32 offset:268 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v25, off, s[0:3], s32 offset:272 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v26, off, s[0:3], s32 offset:276 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:280 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:284 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:288 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:292 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    s_waitcnt vmcnt(16)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[29:30], s4, v[2:3]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v30
; GFX9-O0-NEXT:    s_mov_b32 s5, 1
; GFX9-O0-NEXT:    v_lshlrev_b64 v[23:24], s5, v[23:24]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v24
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v29
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v23
; GFX9-O0-NEXT:    v_or_b32_e64 v23, v5, v10
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[29:30], s5, v[2:3]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], s4, v[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v30
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v29
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 killed $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_or_b32_e64 v4, v3, v4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s5, v[0:1]
; GFX9-O0-NEXT:    v_lshlrev_b64 v[29:30], s5, v[6:7]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v30
; GFX9-O0-NEXT:    s_waitcnt vmcnt(10)
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v28
; GFX9-O0-NEXT:    v_or3_b32 v6, v6, v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v29
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v27
; GFX9-O0-NEXT:    v_or3_b32 v0, v0, v1, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    s_waitcnt vmcnt(8)
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v26
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v25
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v24
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v14
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v15
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v13, vcc, v13, v6
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v12, vcc, v12, v10, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v11, vcc, v11, v4, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v7, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    v_ashrrev_i64 v[13:14], s4, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v14
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], 1
; GFX9-O0-NEXT:    s_mov_b32 s8, s5
; GFX9-O0-NEXT:    v_and_b32_e64 v12, v7, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v13
; GFX9-O0-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_and_b32_e64 v14, v11, s4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v22
; GFX9-O0-NEXT:    v_and_b32_e64 v23, v7, v23
; GFX9-O0-NEXT:    v_and_b32_e64 v21, v11, v21
; GFX9-O0-NEXT:    ; kill: def $vgpr21 killed $vgpr21 def $vgpr21_vgpr22 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v23, v20
; GFX9-O0-NEXT:    v_and_b32_e64 v7, v7, v23
; GFX9-O0-NEXT:    v_and_b32_e64 v23, v11, v19
; GFX9-O0-NEXT:    ; kill: def $vgpr23 killed $vgpr23 def $vgpr23_vgpr24 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v24, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v23
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v24
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v22
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v6, vcc, v6, v20
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v10, vcc, v10, v19, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v4, vcc, v4, v11, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v7, vcc, v5, v7, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v10
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v8
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 killed $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], -1
; GFX9-O0-NEXT:    s_mov_b32 s5, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v20, vcc, v11, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v9, vcc, v9, v11, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v17, vcc, v10, v11, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v8, vcc, v8, v10, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr20 killed $vgpr20 def $vgpr20_vgpr21 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v21, v9
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v20
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v21
; GFX9-O0-NEXT:    v_mov_b32_e32 v22, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v21
; GFX9-O0-NEXT:    v_or_b32_e64 v19, v19, v22
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v20
; GFX9-O0-NEXT:    v_or_b32_e64 v17, v17, v18
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v19
; GFX9-O0-NEXT:    v_cmp_eq_u64_e64 s[4:5], v[17:18], v[12:13]
; GFX9-O0-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v2
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v0
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v14
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:156 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v12
; GFX9-O0-NEXT:    buffer_store_dword v17, off, s[0:3], s32 offset:160 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v18, off, s[0:3], s32 offset:164 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GFX9-O0-NEXT:    v_writelane_b32 v16, s6, 4
; GFX9-O0-NEXT:    v_writelane_b32 v16, s7, 5
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], s[4:5]
; GFX9-O0-NEXT:    v_writelane_b32 v16, s6, 8
; GFX9-O0-NEXT:    v_writelane_b32 v16, s7, 9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execnz .LBB3_6
; GFX9-O0-NEXT:    s_branch .LBB3_1
; GFX9-O0-NEXT:  .LBB3_7: ; %udiv-preheader
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:296 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:300 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:304 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:308 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:312 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:316 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:320 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:324 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v20, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v21, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v22, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_waitcnt vmcnt(9)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v10
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[6:7], v4, v[21:22]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v7
; GFX9-O0-NEXT:    s_mov_b32 s6, 64
; GFX9-O0-NEXT:    v_sub_u32_e64 v12, s6, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[23:24], v12, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v24
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v23
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v7
; GFX9-O0-NEXT:    v_cmp_lt_u32_e64 s[4:5], v4, s6
; GFX9-O0-NEXT:    v_sub_u32_e64 v5, v4, s6
; GFX9-O0-NEXT:    v_lshrrev_b64 v[23:24], v5, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v24
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s6, 0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[6:7], v4, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v22
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v23
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v21
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v6, v6, v7, s[6:7]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_lshrrev_b64 v[4:5], v4, v[19:20]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v5
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s8, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v12, v12, v15, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v4
; GFX9-O0-NEXT:    s_mov_b32 s8, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v5, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v14
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], -1
; GFX9-O0-NEXT:    s_mov_b32 s5, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v18
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v12, vcc, v12, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v17, vcc, v15, v17, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v14, vcc, v14, v15, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v13, vcc, v13, v15, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr14 killed $vgpr14 def $vgpr14_vgpr15 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v13
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr12 killed $vgpr12 def $vgpr12_vgpr13 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v17
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:280 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:284 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:288 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:292 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s6
; GFX9-O0-NEXT:    v_writelane_b32 v16, s4, 8
; GFX9-O0-NEXT:    v_writelane_b32 v16, s5, 9
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v16, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_store_dword v14, off, s[0:3], s32 offset:272 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v15, off, s[0:3], s32 offset:276 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:264 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v13, off, s[0:3], s32 offset:268 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v10, off, s[0:3], s32 offset:256 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v11, off, s[0:3], s32 offset:260 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:248 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v9, off, s[0:3], s32 offset:252 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:240 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:244 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:232 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:236 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:224 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:228 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:216 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:220 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_branch .LBB3_6
; GFX9-O0-NEXT:  .LBB3_8: ; %udiv-bb1
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v5, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 1
; GFX9-O0-NEXT:    s_mov_b32 s5, s6
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-O0-NEXT:    s_mov_b32 s4, s7
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s8, s6
; GFX9-O0-NEXT:    s_mov_b32 s9, s7
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    v_add_co_u32_e32 v9, vcc, v4, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v2, vcc, v2, v5, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s8
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v5, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s9
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v5, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v1
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:312 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:316 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:320 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:324 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b32 s4, 0x7f
; GFX9-O0-NEXT:    v_sub_u32_e64 v3, s4, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[5:6], v3, v[11:12]
; GFX9-O0-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-O0-NEXT:    s_mov_b32 s4, 64
; GFX9-O0-NEXT:    v_sub_u32_e64 v14, s4, v3
; GFX9-O0-NEXT:    v_lshrrev_b64 v[14:15], v14, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v15
; GFX9-O0-NEXT:    v_or_b32_e64 v13, v13, v16
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 killed $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v14
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v6
; GFX9-O0-NEXT:    v_cmp_lt_u32_e64 s[4:5], v3, s4
; GFX9-O0-NEXT:    s_mov_b32 s10, 63
; GFX9-O0-NEXT:    v_sub_u32_e64 v4, s10, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[13:14], v4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v14
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s10, 0
; GFX9-O0-NEXT:    v_cmp_eq_u32_e64 s[10:11], v3, s10
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v12
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v4, v4, v15, s[10:11]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v13
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v6, s[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v5, v5, v6, s[10:11]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    ; implicit-def: $sgpr10
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v4
; GFX9-O0-NEXT:    v_lshlrev_b64 v[7:8], v3, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[4:5]
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s8
; GFX9-O0-NEXT:    v_cndmask_b32_e64 v7, v4, v7, s[4:5]
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v3
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:304 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:308 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:296 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:300 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v10
; GFX9-O0-NEXT:    v_or_b32_e64 v3, v3, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v9
; GFX9-O0-NEXT:    v_or_b32_e64 v1, v1, v2
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_cmp_ne_u64_e64 s[4:5], v[1:2], s[6:7]
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s9
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-O0-NEXT:    buffer_store_dword v7, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v8, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v5, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v4, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v2, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], exec
; GFX9-O0-NEXT:    s_and_b64 s[4:5], s[6:7], s[4:5]
; GFX9-O0-NEXT:    s_xor_b64 s[6:7], s[4:5], s[6:7]
; GFX9-O0-NEXT:    v_writelane_b32 v0, s6, 6
; GFX9-O0-NEXT:    v_writelane_b32 v0, s7, 7
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_store_dword v0, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_cbranch_execz .LBB3_5
; GFX9-O0-NEXT:    s_branch .LBB3_7
; GFX9-O0-NEXT:  .LBB3_9: ; %udiv-end
; GFX9-O0-NEXT:    s_or_saveexec_b64 s[18:19], -1
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[18:19]
; GFX9-O0-NEXT:    buffer_load_dword v9, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:176 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:180 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v7, off, s[0:3], s32 offset:168 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:172 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b32 s4, 32
; GFX9-O0-NEXT:    s_waitcnt vmcnt(2)
; GFX9-O0-NEXT:    v_lshrrev_b64 v[2:3], s4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v13
; GFX9-O0-NEXT:    v_mul_lo_u32 v5, v6, v2
; GFX9-O0-NEXT:    v_lshrrev_b64 v[13:14], s4, v[13:14]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v13
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 killed $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mul_lo_u32 v3, v7, v3
; GFX9-O0-NEXT:    v_mad_u64_u32 v[13:14], s[6:7], v7, v2, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v14
; GFX9-O0-NEXT:    v_add3_u32 v2, v2, v3, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    v_lshlrev_b64 v[17:18], s4, v[2:3]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v18
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 killed $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    s_mov_b32 s5, 0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v14
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v13
; GFX9-O0-NEXT:    v_or_b32_e64 v13, v3, v5
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-O0-NEXT:    v_lshrrev_b64 v[2:3], s4, v[15:16]
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v11
; GFX9-O0-NEXT:    v_mul_lo_u32 v3, v2, v8
; GFX9-O0-NEXT:    v_lshrrev_b64 v[11:12], s4, v[11:12]
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 killed $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v15
; GFX9-O0-NEXT:    v_mul_lo_u32 v11, v11, v5
; GFX9-O0-NEXT:    v_mad_u64_u32 v[15:16], s[6:7], v2, v5, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v16
; GFX9-O0-NEXT:    v_add3_u32 v2, v2, v3, v11
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_lshlrev_b64 v[2:3], s4, v[2:3]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 killed $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v16
; GFX9-O0-NEXT:    v_or_b32_e64 v11, v11, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v15
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v14
; GFX9-O0-NEXT:    v_add_co_u32_e64 v13, s[6:7], v11, v12
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v2, s[6:7], v2, v3, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr13 killed $vgpr13 def $vgpr13_vgpr14 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v14, v2
; GFX9-O0-NEXT:    v_mad_u64_u32 v[15:16], s[6:7], v8, v6, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v15
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v16
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v12
; GFX9-O0-NEXT:    v_lshlrev_b64 v[15:16], s4, v[15:16]
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v16
; GFX9-O0-NEXT:    v_or_b32_e64 v11, v11, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v15
; GFX9-O0-NEXT:    v_or_b32_e64 v2, v2, v3
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v11
; GFX9-O0-NEXT:    v_mad_u64_u32 v[15:16], s[6:7], v8, v7, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v11, v15
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v12
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v16
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v17
; GFX9-O0-NEXT:    v_lshlrev_b64 v[15:16], s4, v[15:16]
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v16
; GFX9-O0-NEXT:    v_or_b32_e64 v8, v8, v17
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 killed $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v15
; GFX9-O0-NEXT:    v_or_b32_e64 v19, v11, v12
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v8
; GFX9-O0-NEXT:    v_mad_u64_u32 v[11:12], s[6:7], v5, v7, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v17, v12
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v19
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v20
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v18
; GFX9-O0-NEXT:    v_add_co_u32_e64 v7, s[6:7], v7, v16
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v15, s[6:7], v8, v15, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v8
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0xffffffff
; GFX9-O0-NEXT:    s_mov_b32 s8, s7
; GFX9-O0-NEXT:    v_and_b32_e64 v15, v15, s8
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v7
; GFX9-O0-NEXT:    ; kill: def $sgpr6 killed $sgpr6 killed $sgpr6_sgpr7
; GFX9-O0-NEXT:    v_and_b32_e64 v17, v16, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr17 killed $vgpr17 def $vgpr17_vgpr18 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v18, v15
; GFX9-O0-NEXT:    v_mad_u64_u32 v[15:16], s[6:7], v5, v6, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v19, v15
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v20
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v16
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    ; implicit-def: $sgpr7
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v6
; GFX9-O0-NEXT:    v_lshlrev_b64 v[15:16], s4, v[15:16]
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v16
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v19
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 killed $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_or_b32_e64 v19, v6, v15
; GFX9-O0-NEXT:    ; kill: def $vgpr19 killed $vgpr19 def $vgpr19_vgpr20 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v20, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v19
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v20
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v18
; GFX9-O0-NEXT:    v_add_co_u32_e64 v5, s[6:7], v5, v16
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v15, s[6:7], v6, v15, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v15
; GFX9-O0-NEXT:    v_lshrrev_b64 v[17:18], s4, v[5:6]
; GFX9-O0-NEXT:    v_lshrrev_b64 v[7:8], s4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v15, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v17
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v18
; GFX9-O0-NEXT:    v_add_co_u32_e64 v15, s[6:7], v15, v16
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v7, s[6:7], v7, v8, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v16
; GFX9-O0-NEXT:    v_add_co_u32_e64 v15, s[6:7], v7, v8
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v2, s[6:7], v2, v3, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr15 killed $vgpr15 def $vgpr15_vgpr16 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v15
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v13
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v16
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v14
; GFX9-O0-NEXT:    v_add_co_u32_e64 v2, s[6:7], v2, v8
; GFX9-O0-NEXT:    v_addc_co_u32_e64 v7, s[6:7], v3, v7, s[6:7]
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 def $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v7
; GFX9-O0-NEXT:    v_lshlrev_b64 v[6:7], s4, v[5:6]
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 killed $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    ; implicit-def: $sgpr6
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, s5
; GFX9-O0-NEXT:    ; kill: def $vgpr11 killed $vgpr11 def $vgpr11_vgpr12 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v12, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v12
; GFX9-O0-NEXT:    v_or_b32_e64 v5, v5, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v11
; GFX9-O0-NEXT:    v_or_b32_e64 v6, v6, v7
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v10
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v7, vcc, v7, v8
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v0, vcc, v0, v6, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v5, vcc, v3, v5, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr7 killed $vgpr7 def $vgpr7_vgpr8 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v8, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v7
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    v_lshrrev_b64 v[7:8], s4, v[7:8]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-O0-NEXT:    v_lshrrev_b64 v[5:6], s4, v[5:6]
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    ; kill: killed $vgpr4
; GFX9-O0-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:328 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_nop 0
; GFX9-O0-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:332 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:336 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:340 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
  %div = urem i128 %lhs, %rhs
  ret i128 %div
}

define i128 @v_sdiv_i128_v_pow2k(i128 %lhs) {
; GFX9-LABEL: v_sdiv_i128_v_pow2k:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX9-NEXT:    v_mov_b32_e32 v5, v4
; GFX9-NEXT:    v_lshrrev_b64 v[4:5], 31, v[4:5]
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v4, vcc, v1, v5, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v2, vcc, 0, v2, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 31, v[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 1, v4
; GFX9-NEXT:    v_ashrrev_i64 v[2:3], 33, v[2:3]
; GFX9-NEXT:    v_or_b32_e32 v0, v4, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O0-LABEL: v_sdiv_i128_v_pow2k:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v2
; GFX9-O0-NEXT:    buffer_store_dword v1, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v0
; GFX9-O0-NEXT:    buffer_load_dword v0, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr4 def $vgpr4_vgpr5 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v3
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v0
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    v_ashrrev_i64 v[4:5], s4, v[4:5]
; GFX9-O0-NEXT:    s_mov_b32 s5, 31
; GFX9-O0-NEXT:    v_lshrrev_b64 v[6:7], s5, v[4:5]
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v7
; GFX9-O0-NEXT:    s_mov_b64 s[8:9], 0
; GFX9-O0-NEXT:    s_mov_b32 s6, s8
; GFX9-O0-NEXT:    s_mov_b32 s4, s9
; GFX9-O0-NEXT:    v_add_co_u32_e32 v0, vcc, v0, v5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v4, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, s6
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v5, vcc, v2, v4, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v3
; GFX9-O0-NEXT:    s_mov_b32 s4, 33
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 killed $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_lshl_or_b32 v0, v2, s5, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v6
; GFX9-O0-NEXT:    v_ashrrev_i64 v[3:4], s4, v[3:4]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    s_mov_b32 s4, 1
; GFX9-O0-NEXT:    v_alignbit_b32 v1, v1, v2, s4
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    s_mov_b32 s4, 32
; GFX9-O0-NEXT:    v_lshrrev_b64 v[3:4], s4, v[3:4]
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 killed $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
  %div = sdiv i128 %lhs, 8589934592
  ret i128 %div
}

define i128 @v_srem_i128_v_pow2k(i128 %lhs) {
; GFX9-LABEL: v_srem_i128_v_pow2k:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX9-NEXT:    v_mov_b32_e32 v5, v4
; GFX9-NEXT:    v_lshrrev_b64 v[4:5], 31, v[4:5]
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, v0, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v4, vcc, v1, v5, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v2, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v6, vcc, 0, v3, vcc
; GFX9-NEXT:    v_and_b32_e32 v4, -2, v4
; GFX9-NEXT:    v_subrev_co_u32_e32 v0, vcc, 0, v0
; GFX9-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v4, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v2, vcc, v2, v5, vcc
; GFX9-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v6, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O0-LABEL: v_srem_i128_v_pow2k:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v3
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v1
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v7
; GFX9-O0-NEXT:    s_mov_b32 s4, 63
; GFX9-O0-NEXT:    v_ashrrev_i64 v[6:7], s4, v[6:7]
; GFX9-O0-NEXT:    s_mov_b32 s4, 31
; GFX9-O0-NEXT:    v_lshrrev_b64 v[6:7], s4, v[6:7]
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v6
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v7
; GFX9-O0-NEXT:    s_mov_b64 s[6:7], 0
; GFX9-O0-NEXT:    s_mov_b32 s5, s6
; GFX9-O0-NEXT:    s_mov_b32 s4, s7
; GFX9-O0-NEXT:    v_add_co_u32_e32 v6, vcc, v5, v4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v4, vcc, v0, v2, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v8, vcc, v3, v2, vcc
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-O0-NEXT:    v_addc_co_u32_e32 v2, vcc, v1, v2, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 def $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v7
; GFX9-O0-NEXT:    s_mov_b32 s6, -2
; GFX9-O0-NEXT:    s_mov_b32 s4, 0
; GFX9-O0-NEXT:    ; kill: def $sgpr4 killed $sgpr4 def $sgpr4_sgpr5
; GFX9-O0-NEXT:    s_mov_b32 s5, s6
; GFX9-O0-NEXT:    s_mov_b32 s6, s5
; GFX9-O0-NEXT:    v_and_b32_e64 v4, v4, s6
; GFX9-O0-NEXT:    ; kill: def $vgpr6 killed $vgpr6 killed $vgpr6_vgpr7 killed $exec
; GFX9-O0-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_and_b32_e64 v9, v6, s4
; GFX9-O0-NEXT:    ; kill: def $vgpr9 killed $vgpr9 def $vgpr9_vgpr10 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v10, v4
; GFX9-O0-NEXT:    v_mov_b32_e32 v7, v9
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v10
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr8 killed $vgpr8 def $vgpr8_vgpr9 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v9, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v8
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v9
; GFX9-O0-NEXT:    v_sub_co_u32_e32 v5, vcc, v5, v7
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v0, vcc, v0, v6, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v3, vcc, v3, v4, vcc
; GFX9-O0-NEXT:    v_subb_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v0, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    s_mov_b32 s4, 32
; GFX9-O0-NEXT:    v_lshrrev_b64 v[5:6], s4, v[5:6]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_lshrrev_b64 v[3:4], s4, v[3:4]
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 killed $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
  %div = srem i128 %lhs, 8589934592
  ret i128 %div
}

define i128 @v_udiv_i128_v_pow2k(i128 %lhs) {
; GFX9-LABEL: v_udiv_i128_v_pow2k:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-NEXT:    v_lshlrev_b64 v[0:1], 31, v[2:3]
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 1, v4
; GFX9-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 1, v3
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O0-LABEL: v_udiv_i128_v_pow2k:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v5, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr5 killed $vgpr5 def $vgpr5_vgpr6 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v6, v3
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    v_mov_b32_e32 v4, v5
; GFX9-O0-NEXT:    s_mov_b32 s4, 33
; GFX9-O0-NEXT:    v_lshrrev_b64 v[0:1], s4, v[0:1]
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 killed $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    s_mov_b32 s5, 31
; GFX9-O0-NEXT:    v_lshl_or_b32 v0, v4, s5, v0
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v5
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v6
; GFX9-O0-NEXT:    v_lshrrev_b64 v[2:3], s4, v[1:2]
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v6
; GFX9-O0-NEXT:    s_mov_b32 s4, 1
; GFX9-O0-NEXT:    v_alignbit_b32 v1, v1, v4, s4
; GFX9-O0-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr2_vgpr3 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
  %div = udiv i128 %lhs, 8589934592
  ret i128 %div
}

define i128 @v_urem_i128_v_pow2k(i128 %lhs) {
; GFX9-LABEL: v_urem_i128_v_pow2k:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-O0-LABEL: v_urem_i128_v_pow2k:
; GFX9-O0:       ; %bb.0:
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-O0-NEXT:    buffer_store_dword v3, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, v2
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    buffer_load_dword v1, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX9-O0-NEXT:    ; kill: def $vgpr4 killed $vgpr1 killed $exec
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    s_waitcnt vmcnt(0)
; GFX9-O0-NEXT:    v_mov_b32_e32 v1, v2
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; implicit-def: $sgpr4_sgpr5
; GFX9-O0-NEXT:    s_mov_b32 s6, 1
; GFX9-O0-NEXT:    s_mov_b32 s4, -1
; GFX9-O0-NEXT:    ; kill: def $sgpr4 killed $sgpr4 def $sgpr4_sgpr5
; GFX9-O0-NEXT:    s_mov_b32 s5, s6
; GFX9-O0-NEXT:    s_mov_b32 s6, s5
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v1
; GFX9-O0-NEXT:    v_and_b32_e64 v3, v2, s6
; GFX9-O0-NEXT:    ; kill: def $sgpr4 killed $sgpr4 killed $sgpr4_sgpr5
; GFX9-O0-NEXT:    ; kill: def $vgpr0 killed $vgpr0 killed $vgpr0_vgpr1 killed $exec
; GFX9-O0-NEXT:    v_and_b32_e64 v1, v0, s4
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    s_mov_b32 s4, 32
; GFX9-O0-NEXT:    v_lshrrev_b64 v[1:2], s4, v[1:2]
; GFX9-O0-NEXT:    ; kill: def $vgpr1 killed $vgpr1 killed $vgpr1_vgpr2 killed $exec
; GFX9-O0-NEXT:    v_mov_b32_e32 v3, 0
; GFX9-O0-NEXT:    v_mov_b32_e32 v2, v3
; GFX9-O0-NEXT:    s_setpc_b64 s[30:31]
  %div = urem i128 %lhs, 8589934592
  ret i128 %div
}

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX9-SDAG: {{.*}}
; GFX9-SDAG-O0: {{.*}}
