; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O0 -mtriple=riscv32 -mattr=+xcvbi -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK_NOPT
; RUN: llc -O3 -mtriple=riscv32 -mattr=+xcvbi -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK_OPT

define i32 @beqimm(i32 %a) {
; CHECK_NOPT-LABEL: beqimm:
; CHECK_NOPT:       # %bb.0:
; CHECK_NOPT-NEXT:    cv.beqimm a0, 5, .LBB0_2
; CHECK_NOPT-NEXT:    j .LBB0_1
; CHECK_NOPT-NEXT:  .LBB0_1: # %f
; CHECK_NOPT-NEXT:    li a0, 0
; CHECK_NOPT-NEXT:    ret
; CHECK_NOPT-NEXT:  .LBB0_2: # %t
; CHECK_NOPT-NEXT:    li a0, 1
; CHECK_NOPT-NEXT:    ret
;
; CHECK_OPT-LABEL: beqimm:
; CHECK_OPT:       # %bb.0:
; CHECK_OPT-NEXT:    cv.bneimm a0, 5, .LBB0_2
; CHECK_OPT-NEXT:  # %bb.1: # %t
; CHECK_OPT-NEXT:    li a0, 1
; CHECK_OPT-NEXT:    ret
; CHECK_OPT-NEXT:  .LBB0_2: # %f
; CHECK_OPT-NEXT:    li a0, 0
; CHECK_OPT-NEXT:    ret
  %1 = icmp eq i32 %a, 5
  br i1 %1, label %t, label %f
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bneimm(i32 %a) {
; CHECK_NOPT-LABEL: bneimm:
; CHECK_NOPT:       # %bb.0:
; CHECK_NOPT-NEXT:    cv.bneimm a0, 5, .LBB1_2
; CHECK_NOPT-NEXT:    j .LBB1_1
; CHECK_NOPT-NEXT:  .LBB1_1: # %f
; CHECK_NOPT-NEXT:    li a0, 0
; CHECK_NOPT-NEXT:    ret
; CHECK_NOPT-NEXT:  .LBB1_2: # %t
; CHECK_NOPT-NEXT:    li a0, 1
; CHECK_NOPT-NEXT:    ret
;
; CHECK_OPT-LABEL: bneimm:
; CHECK_OPT:       # %bb.0:
; CHECK_OPT-NEXT:    cv.beqimm a0, 5, .LBB1_2
; CHECK_OPT-NEXT:  # %bb.1: # %t
; CHECK_OPT-NEXT:    li a0, 1
; CHECK_OPT-NEXT:    ret
; CHECK_OPT-NEXT:  .LBB1_2: # %f
; CHECK_OPT-NEXT:    li a0, 0
; CHECK_OPT-NEXT:    ret
  %1 = icmp ne i32 %a, 5
  br i1 %1, label %t, label %f
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @select_beqimm_1(i32 %a, i32 %x, i32 %y) {
; CHECK_NOPT-LABEL: select_beqimm_1:
; CHECK_NOPT:       # %bb.0: # %entry
; CHECK_NOPT-NEXT:    addi sp, sp, -16
; CHECK_NOPT-NEXT:    .cfi_def_cfa_offset 16
; CHECK_NOPT-NEXT:    sw a1, 8(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    sw a2, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    cv.beqimm a0, -16, .LBB2_2
; CHECK_NOPT-NEXT:  # %bb.1: # %entry
; CHECK_NOPT-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:  .LBB2_2: # %entry
; CHECK_NOPT-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    addi sp, sp, 16
; CHECK_NOPT-NEXT:    ret
;
; CHECK_OPT-LABEL: select_beqimm_1:
; CHECK_OPT:       # %bb.0: # %entry
; CHECK_OPT-NEXT:    cv.beqimm a0, -16, .LBB2_2
; CHECK_OPT-NEXT:  # %bb.1: # %entry
; CHECK_OPT-NEXT:    mv a2, a1
; CHECK_OPT-NEXT:  .LBB2_2: # %entry
; CHECK_OPT-NEXT:    mv a0, a2
; CHECK_OPT-NEXT:    ret
entry:
  %cmp.not = icmp eq i32 %a, -16
  %cond = select i1 %cmp.not, i32 %y, i32 %x
  ret i32 %cond
}

define i32 @select_beqimm_2(i32 %a, i32 %x, i32 %y) {
; CHECK_NOPT-LABEL: select_beqimm_2:
; CHECK_NOPT:       # %bb.0: # %entry
; CHECK_NOPT-NEXT:    addi sp, sp, -16
; CHECK_NOPT-NEXT:    .cfi_def_cfa_offset 16
; CHECK_NOPT-NEXT:    sw a1, 8(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    sw a2, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    cv.beqimm a0, 0, .LBB3_2
; CHECK_NOPT-NEXT:  # %bb.1: # %entry
; CHECK_NOPT-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:  .LBB3_2: # %entry
; CHECK_NOPT-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    addi sp, sp, 16
; CHECK_NOPT-NEXT:    ret
;
; CHECK_OPT-LABEL: select_beqimm_2:
; CHECK_OPT:       # %bb.0: # %entry
; CHECK_OPT-NEXT:    cv.beqimm a0, 0, .LBB3_2
; CHECK_OPT-NEXT:  # %bb.1: # %entry
; CHECK_OPT-NEXT:    mv a2, a1
; CHECK_OPT-NEXT:  .LBB3_2: # %entry
; CHECK_OPT-NEXT:    mv a0, a2
; CHECK_OPT-NEXT:    ret
entry:
  %cmp.not = icmp eq i32 %a, 0
  %cond = select i1 %cmp.not, i32 %y, i32 %x
  ret i32 %cond
}

define i32 @select_beqimm_3(i32 %a, i32 %x, i32 %y) {
; CHECK_NOPT-LABEL: select_beqimm_3:
; CHECK_NOPT:       # %bb.0: # %entry
; CHECK_NOPT-NEXT:    addi sp, sp, -16
; CHECK_NOPT-NEXT:    .cfi_def_cfa_offset 16
; CHECK_NOPT-NEXT:    sw a1, 8(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    sw a2, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    cv.beqimm a0, 15, .LBB4_2
; CHECK_NOPT-NEXT:  # %bb.1: # %entry
; CHECK_NOPT-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:  .LBB4_2: # %entry
; CHECK_NOPT-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    addi sp, sp, 16
; CHECK_NOPT-NEXT:    ret
;
; CHECK_OPT-LABEL: select_beqimm_3:
; CHECK_OPT:       # %bb.0: # %entry
; CHECK_OPT-NEXT:    cv.beqimm a0, 15, .LBB4_2
; CHECK_OPT-NEXT:  # %bb.1: # %entry
; CHECK_OPT-NEXT:    mv a2, a1
; CHECK_OPT-NEXT:  .LBB4_2: # %entry
; CHECK_OPT-NEXT:    mv a0, a2
; CHECK_OPT-NEXT:    ret
entry:
  %cmp.not = icmp eq i32 %a, 15
  %cond = select i1 %cmp.not, i32 %y, i32 %x
  ret i32 %cond
}

define i32 @select_no_beqimm_1(i32 %a, i32 %x, i32 %y) {
; CHECK_NOPT-LABEL: select_no_beqimm_1:
; CHECK_NOPT:       # %bb.0: # %entry
; CHECK_NOPT-NEXT:    addi sp, sp, -16
; CHECK_NOPT-NEXT:    .cfi_def_cfa_offset 16
; CHECK_NOPT-NEXT:    sw a1, 8(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    li a1, -17
; CHECK_NOPT-NEXT:    sw a2, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    beq a0, a1, .LBB5_2
; CHECK_NOPT-NEXT:  # %bb.1: # %entry
; CHECK_NOPT-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:  .LBB5_2: # %entry
; CHECK_NOPT-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    addi sp, sp, 16
; CHECK_NOPT-NEXT:    ret
;
; CHECK_OPT-LABEL: select_no_beqimm_1:
; CHECK_OPT:       # %bb.0: # %entry
; CHECK_OPT-NEXT:    li a3, -17
; CHECK_OPT-NEXT:    beq a0, a3, .LBB5_2
; CHECK_OPT-NEXT:  # %bb.1: # %entry
; CHECK_OPT-NEXT:    mv a2, a1
; CHECK_OPT-NEXT:  .LBB5_2: # %entry
; CHECK_OPT-NEXT:    mv a0, a2
; CHECK_OPT-NEXT:    ret
entry:
  %cmp.not = icmp eq i32 %a, -17
  %cond = select i1 %cmp.not, i32 %y, i32 %x
  ret i32 %cond
}

define i32 @select_no_beqimm_2(i32 %a, i32 %x, i32 %y) {
; CHECK_NOPT-LABEL: select_no_beqimm_2:
; CHECK_NOPT:       # %bb.0: # %entry
; CHECK_NOPT-NEXT:    addi sp, sp, -16
; CHECK_NOPT-NEXT:    .cfi_def_cfa_offset 16
; CHECK_NOPT-NEXT:    sw a1, 8(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    li a1, 16
; CHECK_NOPT-NEXT:    sw a2, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    beq a0, a1, .LBB6_2
; CHECK_NOPT-NEXT:  # %bb.1: # %entry
; CHECK_NOPT-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:  .LBB6_2: # %entry
; CHECK_NOPT-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    addi sp, sp, 16
; CHECK_NOPT-NEXT:    ret
;
; CHECK_OPT-LABEL: select_no_beqimm_2:
; CHECK_OPT:       # %bb.0: # %entry
; CHECK_OPT-NEXT:    li a3, 16
; CHECK_OPT-NEXT:    beq a0, a3, .LBB6_2
; CHECK_OPT-NEXT:  # %bb.1: # %entry
; CHECK_OPT-NEXT:    mv a2, a1
; CHECK_OPT-NEXT:  .LBB6_2: # %entry
; CHECK_OPT-NEXT:    mv a0, a2
; CHECK_OPT-NEXT:    ret
entry:
  %cmp.not = icmp eq i32 %a, 16
  %cond = select i1 %cmp.not, i32 %y, i32 %x
  ret i32 %cond
}

define i32 @select_bneimm_1(i32 %a, i32 %x, i32 %y) {
; CHECK_NOPT-LABEL: select_bneimm_1:
; CHECK_NOPT:       # %bb.0: # %entry
; CHECK_NOPT-NEXT:    addi sp, sp, -16
; CHECK_NOPT-NEXT:    .cfi_def_cfa_offset 16
; CHECK_NOPT-NEXT:    sw a1, 8(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    sw a2, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:    cv.bneimm a0, 0, .LBB7_2
; CHECK_NOPT-NEXT:  # %bb.1: # %entry
; CHECK_NOPT-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; CHECK_NOPT-NEXT:  .LBB7_2: # %entry
; CHECK_NOPT-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; CHECK_NOPT-NEXT:    addi sp, sp, 16
; CHECK_NOPT-NEXT:    ret
;
; CHECK_OPT-LABEL: select_bneimm_1:
; CHECK_OPT:       # %bb.0: # %entry
; CHECK_OPT-NEXT:    cv.bneimm a0, 0, .LBB7_2
; CHECK_OPT-NEXT:  # %bb.1: # %entry
; CHECK_OPT-NEXT:    mv a2, a1
; CHECK_OPT-NEXT:  .LBB7_2: # %entry
; CHECK_OPT-NEXT:    mv a0, a2
; CHECK_OPT-NEXT:    ret
entry:
  %cmp.not = icmp ne i32 %a, 0
  %cond = select i1 %cmp.not, i32 %y, i32 %x
  ret i32 %cond
}

