/*--------------------------------------------------------------------------*/
/* Copyright 2020-2024 NXP                                                  */
/*                                                                          */
/* NXP Proprietary. This software is owned or controlled by NXP and may     */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms.  If you do not agree to be bound by the applicable        */
/* license terms, then you may not retain, install, activate or otherwise   */
/* use the software.                                                        */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxCsslMemory.h
 * @brief Top-level include file for the CSSL memory functions
 */

#ifndef MCUXCSSLMEMORY_H
#define MCUXCSSLMEMORY_H

/**
 * @defgroup mcuxCsslMemory mcuxCssl Memory API
 * @brief Control Flow Protected Memory Functions
 *
 * @ingroup mcuxCsslAPI
 */
#include <mcuxCsslMemory_Constants.h>
#include <mcuxCsslMemory_Types.h>


#include <mcuxCsslMemory_Compare.h>

#include <mcuxCsslMemory_Clear.h>

#include <mcuxCsslMemory_Copy.h>

#include <mcuxCsslMemory_Set.h>

#endif
