/*
 * Copyright 2016 Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _FSL_INPUTMUX_CONNECTIONS_
#define _FSL_INPUTMUX_CONNECTIONS_

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* Component ID definition, used by tools. */
#ifndef FSL_COMPONENT_ID
#define FSL_COMPONENT_ID "platform.drivers.inputmux_connections"
#endif

/*!
 * @addtogroup inputmux_driver
 * @{
 */

/*! @brief Periphinmux IDs */
#define SCT0_PMUX_ID         0x00U
#define SHSGPIO_PMUX_ID      0x80U
#define PINTSEL_PMUX_ID      0x100U
#define DMA0_ITRIG_PMUX_ID   0x200U
#define DMA0_OTRIG_PMUX_ID   0x300U
#define DMA1_ITRIG_PMUX_ID   0x400U
#define DMA1_OTRIG_PMUX_ID   0x500U
#define CT32BIT0_CAP_PMUX_ID 0x600U
#define CT32BIT1_CAP_PMUX_ID 0x610U
#define CT32BIT2_CAP_PMUX_ID 0x620U
#define CT32BIT3_CAP_PMUX_ID 0x630U
#define FREQMEAS_PMUX_ID     0x700U
#define DMA0_REQ_ENA0_ID     0x740U
#define DMA1_REQ_ENA0_ID     0x760U
#define DMA0_ITRIG_EN0_ID    0x780U
#define DMA0_ITRIG_EN1_ID    0x784U
#define DMA1_ITRIG_EN0_ID    0x7A0U
#define DMA1_ITRIG_EN1_ID    0x7A4U
#define ENA_SHIFT            8U
#define PMUX_SHIFT           20U

/*! @brief INPUTMUX connections type */
typedef enum _inputmux_connection_t
{
    /*!< SCT INMUX. */
    kINPUTMUX_Gpio3Inp0ToSct0      = 0U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio4Inp1ToSct0      = 1U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio22Inp2ToSct0     = 2U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio23Inp3ToSct0     = 3U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio26Inp4ToSct0     = 4U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio27Inp5ToSct0     = 5U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio35Inp6ToSct0     = 6U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio36Inp7ToSct0     = 7U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0Mat0ToSct0    = 8U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1Mat0ToSct0    = 9U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2Mat0ToSct0    = 10U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3Mat0ToSct0    = 11U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToSct0  = 14U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0SclkToSct0 = 17U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1SclkToSct0 = 18U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToSct0   = 19U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToSct0   = 20U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_MclkToSct0           = 21U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToSct0        = 22U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_DebugHaltedToSct0    = 23U + (SCT0_PMUX_ID << PMUX_SHIFT),

    /*!< Pin Interrupt. */
    kINPUTMUX_GpioPort0Pin0ToPintsel  = 0U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin1ToPintsel  = 1U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin2ToPintsel  = 2U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin3ToPintsel  = 3U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin4ToPintsel  = 4U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin5ToPintsel  = 5U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin6ToPintsel  = 6U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin7ToPintsel  = 7U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin8ToPintsel  = 8U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin9ToPintsel  = 9U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin10ToPintsel = 10U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin11ToPintsel = 11U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin12ToPintsel = 12U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin13ToPintsel = 13U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin14ToPintsel = 14U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin15ToPintsel = 15U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin16ToPintsel = 16U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin17ToPintsel = 17U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin18ToPintsel = 18U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin19ToPintsel = 19U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin20ToPintsel = 20U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin21ToPintsel = 21U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin22ToPintsel = 22U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin23ToPintsel = 23U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin24ToPintsel = 24U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin25ToPintsel = 25U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin26ToPintsel = 26U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin27ToPintsel = 27U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin28ToPintsel = 28U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin29ToPintsel = 29U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin30ToPintsel = 30U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin31ToPintsel = 31U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin0ToPintsel  = 32U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin1ToPintsel  = 33U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin2ToPintsel  = 34U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin3ToPintsel  = 35U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin4ToPintsel  = 36U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin5ToPintsel  = 37U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin6ToPintsel  = 38U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin7ToPintsel  = 39U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin8ToPintsel  = 40U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin9ToPintsel  = 41U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin10ToPintsel = 42U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin11ToPintsel = 43U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin12ToPintsel = 44U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin13ToPintsel = 45U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin14ToPintsel = 46U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin15ToPintsel = 47U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin16ToPintsel = 48U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin17ToPintsel = 49U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin18ToPintsel = 50U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin19ToPintsel = 51U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin20ToPintsel = 52U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin21ToPintsel = 53U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin22ToPintsel = 54U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin23ToPintsel = 55U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin24ToPintsel = 56U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin25ToPintsel = 57U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin26ToPintsel = 58U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin27ToPintsel = 59U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin28ToPintsel = 60U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin29ToPintsel = 61U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin30ToPintsel = 62U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin31ToPintsel = 63U + (PINTSEL_PMUX_ID << PMUX_SHIFT),

    /*!< Frequency measure. */
    kINPUTMUX_SysoscToFreqmeas             = 0U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SfroToFreqmeas               = 1U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FfroToFreqmeas               = 2U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_LposcToFreqmeas              = 3U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Xtal32kToFreqmeas            = 4U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_C0FrHclkToFreqmeas           = 5U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FreqmeGpioClkInToFreqmeas    = 6U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_T3pllMcuFlexspiClkToFreqmeas = 7U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_TddrMcuFlexspiClkToFreqmeas  = 8U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_TddrMcuEnetClkToFreqmeas     = 9U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_TcpuMcuFlexspiClkToFreqmeas  = 10U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Nco32kToFreqmeas             = 18U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_PmuFclkToFreqmeas            = 19U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Osc32kClk1hzToFreqmeas       = 20U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Osc32kClk1khzToFreqmeas      = 21U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_LcdFclkToFreqmeas            = 22U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexcomm0FclkToFreqmeas      = 23U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_DmicFclkToFreqmeas           = 24U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexspi0FclkToFreqmeas       = 25U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_TcpuMcuClkToFreqmeas         = 26U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_AvpllCh2ClkoutToFreqmeas     = 27U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier0 capture input mux. */
    kINPUTMUX_Gpio0Inp0ToTimer0CaptureChannels             = 0U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio1Inp1ToTimer0CaptureChannels             = 1U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio12Inp2ToTimer0CaptureChannels            = 2U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio13Inp3ToTimer0CaptureChannels            = 3U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio14Inp4ToTimer0CaptureChannels            = 4U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio21Inp5ToTimer0CaptureChannels            = 5U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio24Inp6ToTimer0CaptureChannels            = 6U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio25Inp7ToTimer0CaptureChannels            = 7U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio37Inp8ToTimer0CaptureChannels            = 8U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio38Inp9ToTimer0CaptureChannels            = 9U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio39Inp10ToTimer0CaptureChannels           = 10U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio51Inp11ToTimer0CaptureChannels           = 11U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio52Inp12ToTimer0CaptureChannels           = 12U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio53Inp13ToTimer0CaptureChannels           = 13U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio54Inp14ToTimer0CaptureChannels           = 14U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer0CaptureChannels          = 16U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer0CaptureChannels          = 17U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger0ToTimer0CaptureChannels       = 19U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger1ToTimer0CaptureChannels       = 20U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger2ToTimer0CaptureChannels       = 21U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexcommDmaDone0ToTimer0CaptureChannels      = 22U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexcommDmaDone1ToTimer0CaptureChannels      = 23U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexcommDmaCmpltDone0ToTimer0CaptureChannels = 24U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexcommDmaCmpltDone1ToTimer0CaptureChannels = 25U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier1 capture input mux. */
    kINPUTMUX_Gpio0Inp0ToTimer1CaptureChannels       = 0U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio1Inp1ToTimer1CaptureChannels       = 1U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio12Inp2ToTimer1CaptureChannels      = 2U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio13Inp3ToTimer1CaptureChannels      = 3U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio14Inp4ToTimer1CaptureChannels      = 4U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio21Inp5ToTimer1CaptureChannels      = 5U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio24Inp6ToTimer1CaptureChannels      = 6U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio25Inp7ToTimer1CaptureChannels      = 7U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio37Inp8ToTimer1CaptureChannels      = 8U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio38Inp9ToTimer1CaptureChannels      = 9U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio39Inp10ToTimer1CaptureChannels     = 10U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio51Inp11ToTimer1CaptureChannels     = 11U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio52Inp12ToTimer1CaptureChannels     = 12U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio53Inp13ToTimer1CaptureChannels     = 13U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio54Inp14ToTimer1CaptureChannels     = 14U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer1CaptureChannels    = 16U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer1CaptureChannels    = 17U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_EnetToTimer1CaptureChannels            = 18U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger0ToTimer1CaptureChannels = 19U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger1ToTimer1CaptureChannels = 20U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger2ToTimer1CaptureChannels = 21U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier2 capture input mux. */
    kINPUTMUX_Gpio0Inp0ToTimer2CaptureChannels             = 0U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio1Inp1ToTimer2CaptureChannels             = 1U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio12Inp2ToTimer2CaptureChannels            = 2U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio13Inp3ToTimer2CaptureChannels            = 3U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio14Inp4ToTimer2CaptureChannels            = 4U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio21Inp5ToTimer2CaptureChannels            = 5U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio24Inp6ToTimer2CaptureChannels            = 6U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio25Inp7ToTimer2CaptureChannels            = 7U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio37Inp8ToTimer2CaptureChannels            = 8U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio38Inp9ToTimer2CaptureChannels            = 9U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio39Inp10ToTimer2CaptureChannels           = 10U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio51Inp11ToTimer2CaptureChannels           = 11U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio52Inp12ToTimer2CaptureChannels           = 12U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio53Inp13ToTimer2CaptureChannels           = 13U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio54Inp14ToTimer2CaptureChannels           = 14U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer2CaptureChannels          = 16U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer2CaptureChannels          = 17U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger0ToTimer2CaptureChannels       = 19U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger1ToTimer2CaptureChannels       = 20U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger2ToTimer2CaptureChannels       = 21U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexcommDmaDone0ToTimer2CaptureChannels      = 22U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexcommDmaDone1ToTimer2CaptureChannels      = 23U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexcommDmaCmpltDone0ToTimer2CaptureChannels = 24U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexcommDmaCmpltDone1ToTimer2CaptureChannels = 25U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier3 capture input mux. */
    kINPUTMUX_Gpio0Inp0ToTimer3CaptureChannels       = 0U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio1Inp1ToTimer3CaptureChannels       = 1U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio12Inp2ToTimer3CaptureChannels      = 2U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio13Inp3ToTimer3CaptureChannels      = 3U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio14Inp4ToTimer3CaptureChannels      = 4U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio21Inp5ToTimer3CaptureChannels      = 5U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio24Inp6ToTimer3CaptureChannels      = 6U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio25Inp7ToTimer3CaptureChannels      = 7U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio37Inp8ToTimer3CaptureChannels      = 8U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio38Inp9ToTimer3CaptureChannels      = 9U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio39Inp10ToTimer3CaptureChannels     = 10U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio51Inp11ToTimer3CaptureChannels     = 11U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio52Inp12ToTimer3CaptureChannels     = 12U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio53Inp13ToTimer3CaptureChannels     = 13U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Gpio54Inp14ToTimer3CaptureChannels     = 14U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer3CaptureChannels    = 16U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer3CaptureChannels    = 17U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger0ToTimer3CaptureChannels = 19U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger1ToTimer3CaptureChannels = 20U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_BtuHostTrigger2ToTimer3CaptureChannels = 21U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< DMA0 ITRIG. */
    kINPUTMUX_NsGpioPint0ToDma0         = 0U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint1ToDma0         = 1U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint2ToDma0         = 2U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint3ToDma0         = 3U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToDma0           = 4U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToDma0           = 5U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToDma0           = 6U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToDma0           = 7U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToDma0           = 8U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToDma0           = 9U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToDma0           = 10U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToDma0           = 11U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0TrigOutAToDma0        = 14U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0TrigOutBToDma0        = 15U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0TrigOutCToDma0        = 16U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0TrigOutDToDma0        = 17U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0Dmac0ToDma0           = 18U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0Dmac1ToDma0           = 19U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_EnetMac0DmaReq0ToDma0     = 20U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_EnetMac0DmaReq1ToDma0     = 21U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_UsimDmaRxSingleToDma0     = 22U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_UsimDmaTxSingleToDma0     = 23U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GauGpadc0DmaSingleToDma0  = 24U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GauGpadc1DmaSingleToDma0  = 25U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GauGpdacaDmaSingleToDma0  = 26U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GauGpdacbDmaSingleToDma0  = 27U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiRxToDma0           = 28U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiTxToDma0           = 29U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_LcdRxRegToDmaSingleToDma0 = 32U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_LcdTxRegToDmaSingleToDma0 = 33U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),

    /*!< DMA1 ITRIG. */
    kINPUTMUX_NsGpioPint0ToDma1         = 0U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint1ToDma1         = 1U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint2ToDma1         = 2U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint3ToDma1         = 3U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToDma1           = 4U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToDma1           = 5U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToDma1           = 6U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToDma1           = 7U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToDma1           = 8U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToDma1           = 9U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToDma1           = 10U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToDma1           = 11U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1TrigOutAToDma1        = 14U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1TrigOutBToDma1        = 15U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1TrigOutCToDma1        = 16U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1TrigOutDToDma1        = 17U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0Dmac0ToDma1           = 18U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0Dmac1ToDma1           = 19U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_EnetMac0DmaReq0ToDma1     = 20U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_EnetMac0DmaReq1ToDma1     = 21U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_UsimDmaRxSingleToDma1     = 22U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_UsimDmaTxSingleToDma1     = 23U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GauGpadc0DmaSingleToDma1  = 24U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GauGpadc1DmaSingleToDma1  = 25U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GauGpdacaDmaSingleToDma1  = 26U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GauGpdacbDmaSingleToDma1  = 27U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiRxToDma1           = 28U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiTxToDma1           = 29U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_LcdRxRegToDmaSingleToDma1 = 32U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_LcdTxRegToDmaSingleToDma1 = 33U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),

    /*!< DMA0 OTRIG. */
    kINPUTMUX_Dma0OtrigChannel0ToTriginChannels  = 0U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel1ToTriginChannels  = 1U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel2ToTriginChannels  = 2U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel3ToTriginChannels  = 3U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel4ToTriginChannels  = 4U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel5ToTriginChannels  = 5U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel6ToTriginChannels  = 6U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel7ToTriginChannels  = 7U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel8ToTriginChannels  = 8U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel9ToTriginChannels  = 9U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel10ToTriginChannels = 10U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel11ToTriginChannels = 11U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel12ToTriginChannels = 12U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel13ToTriginChannels = 13U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel14ToTriginChannels = 14U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel15ToTriginChannels = 15U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel16ToTriginChannels = 16U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel17ToTriginChannels = 17U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel18ToTriginChannels = 18U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel19ToTriginChannels = 19U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel20ToTriginChannels = 20U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel21ToTriginChannels = 21U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel22ToTriginChannels = 22U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel23ToTriginChannels = 23U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel24ToTriginChannels = 24U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel25ToTriginChannels = 25U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel26ToTriginChannels = 26U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel27ToTriginChannels = 27U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel28ToTriginChannels = 28U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel29ToTriginChannels = 29U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel30ToTriginChannels = 30U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel31ToTriginChannels = 31U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel32ToTriginChannels = 32U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),

    /*!< DMA1 OTRIG. */
    kINPUTMUX_Dma1OtrigChannel0ToTriginChannels  = 0U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel1ToTriginChannels  = 1U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel2ToTriginChannels  = 2U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel3ToTriginChannels  = 3U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel4ToTriginChannels  = 4U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel5ToTriginChannels  = 5U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel6ToTriginChannels  = 6U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel7ToTriginChannels  = 7U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel8ToTriginChannels  = 8U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel9ToTriginChannels  = 9U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel10ToTriginChannels = 10U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel11ToTriginChannels = 11U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel12ToTriginChannels = 12U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel13ToTriginChannels = 13U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel14ToTriginChannels = 14U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel15ToTriginChannels = 15U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel16ToTriginChannels = 16U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel17ToTriginChannels = 17U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel18ToTriginChannels = 18U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel19ToTriginChannels = 19U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel20ToTriginChannels = 20U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel21ToTriginChannels = 21U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel22ToTriginChannels = 22U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel23ToTriginChannels = 23U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel24ToTriginChannels = 24U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel25ToTriginChannels = 25U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel26ToTriginChannels = 26U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel27ToTriginChannels = 27U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel28ToTriginChannels = 28U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel29ToTriginChannels = 29U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel30ToTriginChannels = 30U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel31ToTriginChannels = 31U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel32ToTriginChannels = 32U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
} inputmux_connection_t;
/*! @brief INPUTMUX signal enable/disable type */
typedef enum _inputmux_signal_t
{
    /*!< DMA0 input trigger source enable. */
    kINPUTMUX_Dmac0InputTriggerPint0Ena               = 0U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPint1Ena               = 1U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPint2Ena               = 2U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPint3Ena               = 3U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer0M0Ena           = 4U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer0M1Ena           = 5U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer1M0Ena           = 6U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer1M1Ena           = 7U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer2M0Ena           = 8U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer2M1Ena           = 9U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer3M0Ena           = 10U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer3M1Ena           = 11U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerDma0OutAEna            = 14U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerDma0OutBEna            = 15U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerDma0OutCEna            = 16U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerDma0OutDEna            = 17U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerSct0Dmac0Ena           = 18U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerSct0Dmac1Ena           = 19U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerEnetMac0DmaReq0Ena     = 20U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerEnetMac0DmaReq1Ena     = 21U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerUsimDmaRxSingleEna     = 22U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerUsimDmaTxSingleEna     = 23U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerGauGpadc0DmaSingleEna  = 24U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerGauGpadc1DmaSingleEna  = 25U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerGauGpdacaDmaSingleEna  = 26U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerGauGpdacbDmaSingleEna  = 27U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexspiRxEna           = 28U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexspiTxEna           = 29U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerLcdRxRegToDmaSingleEna = 0U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerLcdTxRegToDmaSingleEna = 1U + (DMA0_ITRIG_EN1_ID << ENA_SHIFT),

    /*!< DMA1 input trigger source enable. */
    kINPUTMUX_Dmac1InputTriggerPint0Ena               = 0U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerPint1Ena               = 1U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerPint2Ena               = 2U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerPint3Ena               = 3U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer0M0Ena           = 4U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer0M1Ena           = 5U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer1M0Ena           = 6U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer1M1Ena           = 7U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer2M0Ena           = 8U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer2M1Ena           = 9U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer3M0Ena           = 10U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer3M1Ena           = 11U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDma1OutAEna            = 14U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDma1OutBEna            = 15U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDma1OutCEna            = 16U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDma1OutDEna            = 17U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerSct0Dmac0Ena           = 18U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerSct0Dmac1Ena           = 19U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerEnetMac0DmaReq0Ena     = 20U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerEnetMac0DmaReq1Ena     = 21U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerUsimDmaRxSingleEna     = 22U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerUsimDmaTxSingleEna     = 23U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerGauGpadc0DmaSingleEna  = 24U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerGauGpadc1DmaSingleEna  = 25U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerGauGpdacaDmaSingleEna  = 26U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerGauGpdacbDmaSingleEna  = 27U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexspiRxEna           = 28U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexspiTxEna           = 29U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerLcdRxRegToDmaSingleEna = 0U + (DMA1_ITRIG_EN1_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerLcdTxRegToDmaSingleEna = 1U + (DMA1_ITRIG_EN1_ID << ENA_SHIFT),

    /*!< DMA0 REQ signal. */
    kINPUTMUX_Flexcomm0RxToDmac0Ch0RequestEna   = 0U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm0TxToDmac0Ch1RequestEna   = 1U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm1RxToDmac0Ch2RequestEna   = 2U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm1TxToDmac0Ch3RequestEna   = 3U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm2RxToDmac0Ch4RequestEna   = 4U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm2TxToDmac0Ch5RequestEna   = 5U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm3RxToDmac0Ch6RequestEna   = 6U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm3TxToDmac0Ch7RequestEna   = 7U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch0ToDmac0Ch16RequestEna     = 16U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch1ToDmac0Ch17RequestEna     = 17U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch2ToDmac0Ch18RequestEna     = 18U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch3ToDmac0Ch19RequestEna     = 19U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm14RxToDmac0Ch26RequestEna = 26U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm14TxToDmac0Ch27RequestEna = 27U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),

    /*!< DMA1 REQ signal. */
    kINPUTMUX_Flexcomm0RxToDmac1Ch0RequestEna   = 0U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm0TxToDmac1Ch1RequestEna   = 1U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm1RxToDmac1Ch2RequestEna   = 2U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm1TxToDmac1Ch3RequestEna   = 3U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm2RxToDmac1Ch4RequestEna   = 4U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm2TxToDmac1Ch5RequestEna   = 5U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm3RxToDmac1Ch6RequestEna   = 6U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm3TxToDmac1Ch7RequestEna   = 7U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch0ToDmac1Ch16RequestEna     = 16U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch1ToDmac1Ch17RequestEna     = 17U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch2ToDmac1Ch18RequestEna     = 18U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch3ToDmac1Ch19RequestEna     = 19U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm14RxToDmac1Ch26RequestEna = 26U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm14TxToDmac1Ch27RequestEna = 27U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
} inputmux_signal_t;

/*@}*/

#endif /* _FSL_INPUTMUX_CONNECTIONS_ */
