# @file    TestPriority.rb
# @brief   SBML Priority unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestPriority.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestPriority < Test::Unit::TestCase

  def setup
    @@p = LibSBML::Priority.new(3,1)
    if (@@p == nil)
    end
  end

  def teardown
    @@p = nil
  end

  def test_Priority_create
    assert( @@p.getTypeCode() == LibSBML::SBML_PRIORITY )
    assert( @@p.getMetaId() == "" )
    assert( @@p.getNotes() == nil )
    assert( @@p.getAnnotation() == nil )
    assert( @@p.getMath() == nil )
  end

  def test_Priority_createWithNS
    xmlns = LibSBML::XMLNamespaces.new()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = LibSBML::SBMLNamespaces.new(3,1)
    sbmlns.addNamespaces(xmlns)
    object = LibSBML::Priority.new(sbmlns)
    assert( object.getTypeCode() == LibSBML::SBML_PRIORITY )
    assert( object.getMetaId() == "" )
    assert( object.getNotes() == nil )
    assert( object.getAnnotation() == nil )
    assert( object.getLevel() == 3 )
    assert( object.getVersion() == 1 )
    assert( object.getNamespaces() != nil )
    assert( object.getNamespaces().getLength() == 2 )
    object = nil
  end

  def test_Priority_free_NULL
  end

  def test_Priority_setMath
    math = LibSBML::parseFormula("lambda(x, x^3)")
    @@p.setMath(math)
    math1 = @@p.getMath()
    assert( math1 != nil )
    formula = LibSBML::formulaToString(math1)
    assert( formula != nil )
    assert ((  "lambda(x, x^3)" == formula ))
    assert( @@p.getMath() != math )
    assert_equal true, @@p.isSetMath()
    @@p.setMath(@@p.getMath())
    math1 = @@p.getMath()
    assert( math1 != nil )
    formula = LibSBML::formulaToString(math1)
    assert( formula != nil )
    assert ((  "lambda(x, x^3)" == formula ))
    @@p.setMath(nil)
    assert_equal false, @@p.isSetMath()
    if (@@p.getMath() != nil)
    end
  end

  def test_Priority_setMath1
    math = LibSBML::parseFormula("2 * k")
    i = @@p.setMath(math)
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( @@p.getMath() != math )
    assert_equal true, @@p.isSetMath()
    i = @@p.setMath(nil)
    assert( i == LibSBML::LIBSBML_OPERATION_SUCCESS )
    assert( @@p.getMath() == nil )
    assert_equal false, @@p.isSetMath()
    math = nil
  end

  def test_Priority_setMath2
    math = LibSBML::ASTNode.new(LibSBML::AST_DIVIDE)
    i = @@p.setMath(math)
    assert( i == LibSBML::LIBSBML_INVALID_OBJECT )
    assert_equal false, @@p.isSetMath()
    math = nil
  end

end
