/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_k_csk.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  double t73, t77, t79, t81, t87, t89, t90, t91;
  double t93, t94, t96, t97, t98, t100, t102, t107;
  double tvrho0, t110, t111, t114, t117, t118, t121, t123;
  double t127, tvsigma0, t129, t135, t136, t139, t141, t145;
  double tvlapl0, tvtau0;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t73 = t21 / t22;
  t77 = t34 * rho[0];
  t79 = 0.1e1 / t23 / t77;
  t81 = t30 * t33 * t79;
  t87 = -0.25e2 / 0.162e3 * t30 * t40 * t36 + 0.4e2 / 0.243e3 * t81;
  t89 = t64 * t61;
  t90 = my_piecewise3(t55, 0, t87);
  t91 = my_piecewise3(t57, t90, 0);
  t93 = fabs(t58) / t58;
  t94 = 0.1e1 / t59;
  t96 = 0.1e1 / t63;
  t97 = t62 * t96;
  t98 = t93 * t94 * t97;
  t100 = my_piecewise5(t52, 0, t55, 0, -t89 * t91 * t98);
  t102 = -0.5e1 / 0.27e2 * t81 + t87 * t65 + t47 * t100;
  t107 = my_piecewise3(t3, 0, t8 * t73 * t67 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tvrho0 = 0.2e1 * rho[0] * t107 + 0.2e1 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t110 = t32 * t36;
  t111 = t30 * t110;
  t114 = t30 * t110 * t65;
  t117 = my_piecewise3(t55, 0, -0.5e1 / 0.81e2 * t111);
  t118 = my_piecewise3(t57, t117, 0);
  t121 = my_piecewise5(t52, 0, t55, 0, -t89 * t118 * t98);
  t123 = 0.5e1 / 0.72e2 * t111 - 0.5e1 / 0.81e2 * t114 + t47 * t121;
  t127 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t123);
  tvsigma0 = 0.2e1 * rho[0] * t127;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t129 = t32 * t42;
  t135 = my_piecewise3(t55, 0, 0.5e1 / 0.54e2 * t30 * t129);
  t136 = my_piecewise3(t57, t135, 0);
  t139 = my_piecewise5(t52, 0, t55, 0, -t89 * t136 * t98);
  t141 = 0.5e1 / 0.54e2 * t30 * t129 * t65 + t47 * t139;
  t145 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t141);
  tvlapl0 = 0.2e1 * rho[0] * t145;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  double t73, t77, t79, t81, t87, t89, t90, t91;
  double t93, t94, t96, t97, t98, t100, t102, t107;
  double tvrho0, t110, t111, t114, t117, t118, t121, t123;
  double t127, tvsigma0, t129, t135, t136, t139, t141, t145;
  double tvlapl0, tvtau0;

  double t150, t157, t159, t161, t167, t171, t173, t174;
  double t176, t177, t178, t179, t180, t181, t182, t183;
  double t184, t186, t188, t189, t190, t192, t193, t196;
  double t197, t199, t200, t201, t203, t205, t206, t207;
  double t210, t212, t217, tv2rho20, t223, t224, t227, t230;
  double t233, t234, t235, t236, t238, t239, t240, t241;
  double t244, t245, t248, t250, t251, t252, t254, t256;
  double t257, t260, t262, t267, tv2rhosigma0, t278, t279, t281;
  double t282, t285, t286, t289, t291, t293, t297, t299;
  double t304, tv2rholapl0, tv2rhotau0, t308, t310, t313, t316, t317;
  double t319, t320, t321, t323, t327, t329, t333, tv2sigma20;
  double t339, t343, t345, t346, t347, t348, t349, t352;
  double t353, t356, t358, t362, tv2sigmalapl0, tv2sigmatau0, t367, t370;
  double t373, t374, t376, t380, t382, t386, tv2lapl20, tv2lapltau0;
  double tv2tau20;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t73 = t21 / t22;
  t77 = t34 * rho[0];
  t79 = 0.1e1 / t23 / t77;
  t81 = t30 * t33 * t79;
  t87 = -0.25e2 / 0.162e3 * t30 * t40 * t36 + 0.4e2 / 0.243e3 * t81;
  t89 = t64 * t61;
  t90 = my_piecewise3(t55, 0, t87);
  t91 = my_piecewise3(t57, t90, 0);
  t93 = fabs(t58) / t58;
  t94 = 0.1e1 / t59;
  t96 = 0.1e1 / t63;
  t97 = t62 * t96;
  t98 = t93 * t94 * t97;
  t100 = my_piecewise5(t52, 0, t55, 0, -t89 * t91 * t98);
  t102 = -0.5e1 / 0.27e2 * t81 + t87 * t65 + t47 * t100;
  t107 = my_piecewise3(t3, 0, t8 * t73 * t67 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tvrho0 = 0.2e1 * rho[0] * t107 + 0.2e1 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t110 = t32 * t36;
  t111 = t30 * t110;
  t114 = t30 * t110 * t65;
  t117 = my_piecewise3(t55, 0, -0.5e1 / 0.81e2 * t111);
  t118 = my_piecewise3(t57, t117, 0);
  t121 = my_piecewise5(t52, 0, t55, 0, -t89 * t118 * t98);
  t123 = 0.5e1 / 0.72e2 * t111 - 0.5e1 / 0.81e2 * t114 + t47 * t121;
  t127 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t123);
  tvsigma0 = 0.2e1 * rho[0] * t127;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t129 = t32 * t42;
  t135 = my_piecewise3(t55, 0, 0.5e1 / 0.54e2 * t30 * t129);
  t136 = my_piecewise3(t57, t135, 0);
  t139 = my_piecewise5(t52, 0, t55, 0, -t89 * t136 * t98);
  t141 = 0.5e1 / 0.54e2 * t30 * t129 * t65 + t47 * t139;
  t145 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t141);
  tvlapl0 = 0.2e1 * rho[0] * t145;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t150 = t21 / t22 / rho[0];
  t157 = t34 * t34;
  t159 = 0.1e1 / t23 / t157;
  t161 = t30 * t33 * t159;
  t167 = 0.1e3 / 0.243e3 * t30 * t40 * t79 - 0.44e3 / 0.729e3 * t161;
  t171 = t60 * t60;
  t173 = t64 / t171;
  t174 = t91 * t91;
  t176 = t93 * t93;
  t177 = t59 * t59;
  t178 = 0.1e1 / t177;
  t179 = t176 * t178;
  t180 = t62 * t62;
  t181 = t63 * t63;
  t182 = 0.1e1 / t181;
  t183 = t180 * t182;
  t184 = t179 * t183;
  t186 = t174 * t176;
  t188 = t178 * t62;
  t189 = t96 * params->csk_a;
  t190 = t188 * t189;
  t192 = my_piecewise3(t55, 0, t167);
  t193 = my_piecewise3(t57, t192, 0);
  t196 = t89 * t174;
  t197 = 0.0;
  t199 = t197 * t94 * t97;
  t200 = t196 * t199;
  t201 = t179 * t97;
  t203 = t173 * t186;
  t205 = t178 * t180;
  t206 = t182 * params->csk_a;
  t207 = t205 * t206;
  t210 = my_piecewise5(t52, 0, t55, 0, t173 * t174 * t184 + t89 * t186 * t190 - t89 * t193 * t98 - t203 * t190 + t196 * t201 - t203 * t207 - t200);
  t212 = 0.55e2 / 0.81e2 * t161 + t167 * t65 + 0.2e1 * t87 * t100 + t47 * t210;
  t217 = my_piecewise3(t3, 0, -t8 * t150 * t67 / 0.3e2 + t8 * t73 * t102 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t212);
  tv2rho20 = 0.2e1 * rho[0] * t217 + 0.4e1 * t107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t223 = t32 * t79;
  t224 = t30 * t223;
  t227 = t30 * t223 * t65;
  t230 = t30 * t110 * t100;
  t233 = t91 * t176;
  t234 = t173 * t233;
  t235 = t182 * t118;
  t236 = t205 * t235;
  t238 = t118 * t176;
  t239 = t89 * t238;
  t240 = t189 * t91;
  t241 = t188 * t240;
  t244 = my_piecewise3(t55, 0, 0.4e2 / 0.243e3 * t224);
  t245 = my_piecewise3(t57, t244, 0);
  t248 = t118 * t91;
  t250 = t89 * t248 * t199;
  t251 = t96 * t91;
  t252 = t188 * t251;
  t254 = t173 * t238;
  t256 = t206 * t91;
  t257 = t205 * t256;
  t260 = my_piecewise5(t52, 0, t55, 0, -t89 * t245 * t98 + t234 * t236 + t239 * t241 + t239 * t252 - t254 * t241 - t254 * t257 - t250);
  t262 = -0.5e1 / 0.27e2 * t224 + 0.4e2 / 0.243e3 * t227 - 0.5e1 / 0.81e2 * t230 + t87 * t121 + t47 * t260;
  t267 = my_piecewise3(t3, 0, t8 * t73 * t123 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t262);
  tv2rhosigma0 = 0.2e1 * rho[0] * t267 + 0.2e1 * t127;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t278 = t182 * t136;
  t279 = t205 * t278;
  t281 = t136 * t176;
  t282 = t89 * t281;
  t285 = my_piecewise3(t55, 0, -0.25e2 / 0.162e3 * t111);
  t286 = my_piecewise3(t57, t285, 0);
  t289 = t136 * t91;
  t291 = t89 * t289 * t199;
  t293 = t173 * t281;
  t297 = my_piecewise5(t52, 0, t55, 0, -t89 * t286 * t98 + t234 * t279 + t282 * t241 - t293 * t241 + t282 * t252 - t293 * t257 - t291);
  t299 = -0.25e2 / 0.162e3 * t114 + 0.5e1 / 0.54e2 * t30 * t129 * t100 + t87 * t139 + t47 * t297;
  t304 = my_piecewise3(t3, 0, t8 * t73 * t141 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t299);
  tv2rholapl0 = 0.2e1 * rho[0] * t304 + 0.2e1 * t145;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t308 = t30 * t110 * t121;
  t310 = t118 * t118;
  t313 = t310 * t176;
  t316 = my_piecewise3(t55, 0, 0);
  t317 = my_piecewise3(t57, t316, 0);
  t319 = t89 * t317 * t98;
  t320 = t89 * t310;
  t321 = t320 * t199;
  t323 = t173 * t313;
  t327 = my_piecewise5(t52, 0, t55, 0, t173 * t310 * t184 + t89 * t313 * t190 - t323 * t190 + t320 * t201 - t323 * t207 - t319 - t321);
  t329 = -0.1e2 / 0.81e2 * t308 + t47 * t327;
  t333 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t329);
  tv2sigma20 = 0.2e1 * rho[0] * t333;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t339 = t30 * t110 * t139;
  t343 = t188 * t189 * t118;
  t345 = t136 * t118;
  t346 = t89 * t345;
  t347 = t346 * t199;
  t348 = t96 * t118;
  t349 = t188 * t348;
  t352 = t206 * t118;
  t353 = t205 * t352;
  t356 = my_piecewise5(t52, 0, t55, 0, t254 * t279 + t282 * t343 + t282 * t349 - t293 * t343 - t293 * t353 - t319 - t347);
  t358 = 0.5e1 / 0.54e2 * t30 * t129 * t121 - 0.5e1 / 0.81e2 * t339 + t47 * t356;
  t362 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t358);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t362;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t367 = t136 * t136;
  t370 = t367 * t176;
  t373 = t89 * t367;
  t374 = t373 * t199;
  t376 = t173 * t370;
  t380 = my_piecewise5(t52, 0, t55, 0, t173 * t367 * t184 + t89 * t370 * t190 - t376 * t190 + t373 * t201 - t376 * t207 - t319 - t374);
  t382 = 0.5e1 / 0.27e2 * t30 * t129 * t139 + t47 * t380;
  t386 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t382);
  tv2lapl20 = 0.2e1 * rho[0] * t386;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  double t73, t77, t79, t81, t87, t89, t90, t91;
  double t93, t94, t96, t97, t98, t100, t102, t107;
  double tvrho0, t110, t111, t114, t117, t118, t121, t123;
  double t127, tvsigma0, t129, t135, t136, t139, t141, t145;
  double tvlapl0, tvtau0;

  double t150, t157, t159, t161, t167, t171, t173, t174;
  double t176, t177, t178, t179, t180, t181, t182, t183;
  double t184, t186, t188, t189, t190, t192, t193, t196;
  double t197, t199, t200, t201, t203, t205, t206, t207;
  double t210, t212, t217, tv2rho20, t223, t224, t227, t230;
  double t233, t234, t235, t236, t238, t239, t240, t241;
  double t244, t245, t248, t250, t251, t252, t254, t256;
  double t257, t260, t262, t267, tv2rhosigma0, t278, t279, t281;
  double t282, t285, t286, t289, t291, t293, t297, t299;
  double t304, tv2rholapl0, tv2rhotau0, t308, t310, t313, t316, t317;
  double t319, t320, t321, t323, t327, t329, t333, tv2sigma20;
  double t339, t343, t345, t346, t347, t348, t349, t352;
  double t353, t356, t358, t362, tv2sigmalapl0, tv2sigmatau0, t367, t370;
  double t373, t374, t376, t380, t382, t386, tv2lapl20, tv2lapltau0;
  double tv2tau20;

  double t391, t403, t405, t411, t419, t420, t422, t424;
  double t425, t426, t428, t429, t430, t432, t433, t437;
  double t441, t445, t446, t449, t450, t453, t454, t456;
  double t457, t461, t463, t464, t465, t467, t469, t470;
  double t471, t473, t474, t475, t476, t479, t482, t484;
  double t485, t486, t492, t493, t494, t496, t497, t498;
  double t501, t502, t503, t504, t509, t513, t514, t515;
  double t518, t519, t524, t528, t529, t532, t534, t536;
  double t541, tv3rho30, t551, t552, t555, t558, t561, t567;
  double t568, t572, t573, t574, t576, t577, t580, t581;
  double t583, t584, t587, t588, t592, t595, t598, t599;
  double t600, t601, t602, t606, t607, t612, t615, t618;
  double t619, t621, t622, t623, t624, t625, t627, t630;
  double t631, t632, t637, t638, t639, t640, t641, t642;
  double t643, t645, t646, t647, t649, t651, t652, t655;
  double t656, t662, t663, t670, t674, t675, t676, t678;
  double t680, t682, t687, tv3rho2sigma0, t706, t707, t710, t711;
  double t714, t715, t718, t721, t722, t723, t725, t727;
  double t729, t731, t732, t736, t737, t738, t748, t749;
  double t750, t753, t754, t763, t764, t765, t767, t771;
  double t777, t778, t781, t783, t785, t789, t791, t793;
  double t795, t800, tv3rho2lapl0, tv3rho2tau0, t807, t810, t813, t815;
  double t816, t817, t818, t820, t822, t823, t824, t825;
  double t827, t828, t829, t831, t832, t834, t835, t838;
  double t840, t841, t842, t843, t844, t845, t848, t851;
  double t852, t855, t856, t859, t860, t862, t863, t865;
  double t866, t869, t872, t873, t876, t877, t878, t879;
  double t880, t882, t883, t888, t892, t893, t896, t901;
  double t902, t903, t904, t906, t907, t908, t909, t911;
  double t912, t913, t914, t915, t917, t918, t919, t922;
  double t924, t926, t931, tv3rhosigma20, t942, t945, t948, t949;
  double t951, t952, t954, t955, t956, t957, t959, t960;
  double t961, t963, t964, t965, t966, t967, t970, t971;
  double t973, t977, t980, t981, t982, t983, t985, t986;
  double t987, t988, t989, t992, t995, t996, t998, t1000;
  double t1009, t1012, t1013, t1017, t1021, t1022, t1028, t1030;
  double t1031, t1033, t1036, t1038, t1040, t1045, tv3rhosigmalapl0, tv3rhosigmatau0;
  double t1056, t1058, t1059, t1061, t1063, t1064, t1066, t1068;
  double t1069, t1072, t1073, t1075, t1078, t1079, t1082, t1085;
  double t1086, t1092, t1099, t1113, t1114, t1116, t1117, t1118;
  double t1120, t1121, t1125, t1127, t1129, t1134, tv3rholapl20, tv3rholapltau0;
  double tv3rhotau20, t1138, t1140, t1149, t1150, t1151, t1152, t1153;
  double t1154, t1155, t1156, t1157, t1158, t1159, t1160, t1161;
  double t1162, t1163, t1165, t1166, t1167, t1168, t1173, t1174;
  double t1175, t1178, t1181, t1183, t1184, t1185, t1186, t1187;
  double t1188, t1189, t1191, t1192, t1195, t1204, t1206, t1208;
  double t1212, tv3sigma30, t1218, t1220, t1221, t1222, t1223, t1224;
  double t1225, t1226, t1227, t1228, t1229, t1230, t1231, t1234;
  double t1235, t1236, t1239, t1242, t1247, t1248, t1249, t1250;
  double t1251, t1254, t1255, t1260, t1261, t1262, t1263, t1266;
  double t1267, t1268, t1269, t1270, t1273, t1274, t1275, t1276;
  double t1278, t1280, t1281, t1282, t1283, t1284, t1285, t1290;
  double t1292, t1294, t1298, tv3sigma2lapl0, tv3sigma2tau0, t1304, t1306, t1308;
  double t1309, t1311, t1312, t1313, t1314, t1315, t1316, t1317;
  double t1318, t1321, t1325, t1326, t1332, t1333, t1334, t1338;
  double t1344, t1345, t1348, t1351, t1352, t1353, t1354, t1355;
  double t1356, t1363, t1365, t1367, t1371, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20;
  double t1376, t1385, t1386, t1387, t1388, t1389, t1390, t1391;
  double t1393, t1394, t1395, t1396, t1397, t1398, t1399, t1400;
  double t1401, t1402, t1403, t1406, t1413, t1416, t1417, t1418;
  double t1420, t1421, t1430, t1432, t1434, t1438, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, tv3tau30;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t73 = t21 / t22;
  t77 = t34 * rho[0];
  t79 = 0.1e1 / t23 / t77;
  t81 = t30 * t33 * t79;
  t87 = -0.25e2 / 0.162e3 * t30 * t40 * t36 + 0.4e2 / 0.243e3 * t81;
  t89 = t64 * t61;
  t90 = my_piecewise3(t55, 0, t87);
  t91 = my_piecewise3(t57, t90, 0);
  t93 = fabs(t58) / t58;
  t94 = 0.1e1 / t59;
  t96 = 0.1e1 / t63;
  t97 = t62 * t96;
  t98 = t93 * t94 * t97;
  t100 = my_piecewise5(t52, 0, t55, 0, -t89 * t91 * t98);
  t102 = -0.5e1 / 0.27e2 * t81 + t87 * t65 + t47 * t100;
  t107 = my_piecewise3(t3, 0, t8 * t73 * t67 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tvrho0 = 0.2e1 * rho[0] * t107 + 0.2e1 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t110 = t32 * t36;
  t111 = t30 * t110;
  t114 = t30 * t110 * t65;
  t117 = my_piecewise3(t55, 0, -0.5e1 / 0.81e2 * t111);
  t118 = my_piecewise3(t57, t117, 0);
  t121 = my_piecewise5(t52, 0, t55, 0, -t89 * t118 * t98);
  t123 = 0.5e1 / 0.72e2 * t111 - 0.5e1 / 0.81e2 * t114 + t47 * t121;
  t127 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t123);
  tvsigma0 = 0.2e1 * rho[0] * t127;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t129 = t32 * t42;
  t135 = my_piecewise3(t55, 0, 0.5e1 / 0.54e2 * t30 * t129);
  t136 = my_piecewise3(t57, t135, 0);
  t139 = my_piecewise5(t52, 0, t55, 0, -t89 * t136 * t98);
  t141 = 0.5e1 / 0.54e2 * t30 * t129 * t65 + t47 * t139;
  t145 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t141);
  tvlapl0 = 0.2e1 * rho[0] * t145;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t150 = t21 / t22 / rho[0];
  t157 = t34 * t34;
  t159 = 0.1e1 / t23 / t157;
  t161 = t30 * t33 * t159;
  t167 = 0.1e3 / 0.243e3 * t30 * t40 * t79 - 0.44e3 / 0.729e3 * t161;
  t171 = t60 * t60;
  t173 = t64 / t171;
  t174 = t91 * t91;
  t176 = t93 * t93;
  t177 = t59 * t59;
  t178 = 0.1e1 / t177;
  t179 = t176 * t178;
  t180 = t62 * t62;
  t181 = t63 * t63;
  t182 = 0.1e1 / t181;
  t183 = t180 * t182;
  t184 = t179 * t183;
  t186 = t174 * t176;
  t188 = t178 * t62;
  t189 = t96 * params->csk_a;
  t190 = t188 * t189;
  t192 = my_piecewise3(t55, 0, t167);
  t193 = my_piecewise3(t57, t192, 0);
  t196 = t89 * t174;
  t197 = 0.0;
  t199 = t197 * t94 * t97;
  t200 = t196 * t199;
  t201 = t179 * t97;
  t203 = t173 * t186;
  t205 = t178 * t180;
  t206 = t182 * params->csk_a;
  t207 = t205 * t206;
  t210 = my_piecewise5(t52, 0, t55, 0, t173 * t174 * t184 + t89 * t186 * t190 - t89 * t193 * t98 - t203 * t190 + t196 * t201 - t203 * t207 - t200);
  t212 = 0.55e2 / 0.81e2 * t161 + t167 * t65 + 0.2e1 * t87 * t100 + t47 * t210;
  t217 = my_piecewise3(t3, 0, -t8 * t150 * t67 / 0.3e2 + t8 * t73 * t102 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t212);
  tv2rho20 = 0.2e1 * rho[0] * t217 + 0.4e1 * t107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t223 = t32 * t79;
  t224 = t30 * t223;
  t227 = t30 * t223 * t65;
  t230 = t30 * t110 * t100;
  t233 = t91 * t176;
  t234 = t173 * t233;
  t235 = t182 * t118;
  t236 = t205 * t235;
  t238 = t118 * t176;
  t239 = t89 * t238;
  t240 = t189 * t91;
  t241 = t188 * t240;
  t244 = my_piecewise3(t55, 0, 0.4e2 / 0.243e3 * t224);
  t245 = my_piecewise3(t57, t244, 0);
  t248 = t118 * t91;
  t250 = t89 * t248 * t199;
  t251 = t96 * t91;
  t252 = t188 * t251;
  t254 = t173 * t238;
  t256 = t206 * t91;
  t257 = t205 * t256;
  t260 = my_piecewise5(t52, 0, t55, 0, -t89 * t245 * t98 + t234 * t236 + t239 * t241 + t239 * t252 - t254 * t241 - t254 * t257 - t250);
  t262 = -0.5e1 / 0.27e2 * t224 + 0.4e2 / 0.243e3 * t227 - 0.5e1 / 0.81e2 * t230 + t87 * t121 + t47 * t260;
  t267 = my_piecewise3(t3, 0, t8 * t73 * t123 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t262);
  tv2rhosigma0 = 0.2e1 * rho[0] * t267 + 0.2e1 * t127;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t278 = t182 * t136;
  t279 = t205 * t278;
  t281 = t136 * t176;
  t282 = t89 * t281;
  t285 = my_piecewise3(t55, 0, -0.25e2 / 0.162e3 * t111);
  t286 = my_piecewise3(t57, t285, 0);
  t289 = t136 * t91;
  t291 = t89 * t289 * t199;
  t293 = t173 * t281;
  t297 = my_piecewise5(t52, 0, t55, 0, -t89 * t286 * t98 + t234 * t279 + t282 * t241 - t293 * t241 + t282 * t252 - t293 * t257 - t291);
  t299 = -0.25e2 / 0.162e3 * t114 + 0.5e1 / 0.54e2 * t30 * t129 * t100 + t87 * t139 + t47 * t297;
  t304 = my_piecewise3(t3, 0, t8 * t73 * t141 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t299);
  tv2rholapl0 = 0.2e1 * rho[0] * t304 + 0.2e1 * t145;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t308 = t30 * t110 * t121;
  t310 = t118 * t118;
  t313 = t310 * t176;
  t316 = my_piecewise3(t55, 0, 0);
  t317 = my_piecewise3(t57, t316, 0);
  t319 = t89 * t317 * t98;
  t320 = t89 * t310;
  t321 = t320 * t199;
  t323 = t173 * t313;
  t327 = my_piecewise5(t52, 0, t55, 0, t173 * t310 * t184 + t89 * t313 * t190 - t323 * t190 + t320 * t201 - t323 * t207 - t319 - t321);
  t329 = -0.1e2 / 0.81e2 * t308 + t47 * t327;
  t333 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t329);
  tv2sigma20 = 0.2e1 * rho[0] * t333;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t339 = t30 * t110 * t139;
  t343 = t188 * t189 * t118;
  t345 = t136 * t118;
  t346 = t89 * t345;
  t347 = t346 * t199;
  t348 = t96 * t118;
  t349 = t188 * t348;
  t352 = t206 * t118;
  t353 = t205 * t352;
  t356 = my_piecewise5(t52, 0, t55, 0, t254 * t279 + t282 * t343 + t282 * t349 - t293 * t343 - t293 * t353 - t319 - t347);
  t358 = 0.5e1 / 0.54e2 * t30 * t129 * t121 - 0.5e1 / 0.81e2 * t339 + t47 * t356;
  t362 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t358);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t362;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t367 = t136 * t136;
  t370 = t367 * t176;
  t373 = t89 * t367;
  t374 = t373 * t199;
  t376 = t173 * t370;
  t380 = my_piecewise5(t52, 0, t55, 0, t173 * t367 * t184 + t89 * t370 * t190 - t376 * t190 + t373 * t201 - t376 * t207 - t319 - t374);
  t382 = 0.5e1 / 0.27e2 * t30 * t129 * t139 + t47 * t380;
  t386 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t382);
  tv2lapl20 = 0.2e1 * rho[0] * t386;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t391 = t21 / t22 / t34;
  t403 = 0.1e1 / t23 / t157 / rho[0];
  t405 = t30 * t33 * t403;
  t411 = -0.11e4 / 0.729e3 * t30 * t40 * t159 + 0.616e4 / 0.2187e4 * t405;
  t419 = t64 / t171 / t60;
  t420 = t174 * t91;
  t422 = t176 * t93;
  t424 = 0.1e1 / t177 / t59;
  t425 = t422 * t424;
  t426 = t180 * t62;
  t428 = 0.1e1 / t181 / t63;
  t429 = t426 * t428;
  t430 = t425 * t429;
  t432 = my_piecewise3(t55, 0, t411);
  t433 = my_piecewise3(t57, t432, 0);
  t437 = t425 * t183;
  t441 = t425 * t97;
  t445 = t189 * t193;
  t446 = t188 * t445;
  t449 = t193 * t176;
  t450 = t173 * t449;
  t453 = t420 * t197;
  t454 = t173 * t453;
  t456 = t205 * t206 * t93;
  t457 = t454 * t456;
  t461 = t178 * params->csk_a;
  t463 = t93 * t62 * t96;
  t464 = t461 * t463;
  t465 = t454 * t464;
  t467 = t420 * t93;
  t469 = t189 * t197;
  t470 = t188 * t469;
  t471 = t89 * t467 * t470;
  t473 = t420 * t422;
  t474 = t173 * t473;
  t475 = t424 * params->csk_a;
  t476 = t475 * t97;
  t479 = t89 * t473;
  t482 = -0.3e1 * t173 * t420 * t437 + 0.3e1 * t89 * t233 * t446 - t419 * t420 * t430 - 0.2e1 * t89 * t420 * t441 - t89 * t433 * t98 - 0.3e1 * t450 * t241 - 0.3e1 * t450 * t257 + 0.3e1 * t474 * t476 - 0.3e1 * t479 * t476 - t200 - 0.3e1 * t457 - 0.3e1 * t465 + 0.3e1 * t471;
  t484 = t182 * t197;
  t485 = t205 * t484;
  t486 = t173 * t467 * t485;
  t492 = t96 * t93;
  t493 = t188 * t492;
  t494 = t89 * t453 * t493;
  t496 = t419 * t473;
  t497 = t424 * t180;
  t498 = t497 * t206;
  t501 = t424 * t62;
  t502 = params->csk_a * params->csk_a;
  t503 = t96 * t502;
  t504 = t501 * t503;
  t509 = t182 * t193;
  t513 = t424 * t426;
  t514 = t428 * params->csk_a;
  t515 = t513 * t514;
  t518 = t182 * t502;
  t519 = t497 * t518;
  t524 = t89 * t193 * t91 * t199;
  t528 = t428 * t502;
  t529 = t513 * t528;
  t532 = 0.3e1 * t234 * t205 * t509 + 0.3e1 * t89 * t449 * t252 + 0.3e1 * t474 * t504 + 0.3e1 * t474 * t519 - t479 * t504 + 0.3e1 * t496 * t498 - t496 * t504 + 0.3e1 * t496 * t515 - 0.3e1 * t496 * t519 - 0.2e1 * t496 * t529 + 0.3e1 * t486 + 0.3e1 * t494 - 0.3e1 * t524;
  t534 = my_piecewise5(t52, 0, t55, 0, t482 + t532);
  t536 = -0.77e3 / 0.243e3 * t405 + t411 * t65 + 0.3e1 * t167 * t100 + 0.3e1 * t87 * t210 + t47 * t534;
  t541 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t391 * t67 - t8 * t150 * t102 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t73 * t212 + 0.3e1 / 0.2e2 * t8 * t24 * t536);
  tv3rho30 = 0.2e1 * rho[0] * t541 + 0.6e1 * t217;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t551 = t32 * t159;
  t552 = t30 * t551;
  t555 = t30 * t551 * t65;
  t558 = t30 * t223 * t100;
  t561 = t30 * t110 * t210;
  t567 = my_piecewise3(t55, 0, -0.44e3 / 0.729e3 * t552);
  t568 = my_piecewise3(t57, t567, 0);
  t572 = t118 * t422;
  t573 = t419 * t572;
  t574 = t424 * t502;
  t576 = t174 * t180 * t182;
  t577 = t574 * t576;
  t580 = t206 * t193;
  t581 = t205 * t580;
  t583 = t528 * t174;
  t584 = t513 * t583;
  t587 = t245 * t176;
  t588 = t89 * t587;
  t592 = t173 * t572;
  t595 = t173 * t587;
  t598 = t174 * t422;
  t599 = t419 * t598;
  t600 = t428 * t118;
  t601 = t600 * params->csk_a;
  t602 = t513 * t601;
  t606 = t174 * t62 * t96;
  t607 = t475 * t606;
  t612 = t89 * t572;
  t615 = t118 * t174;
  t618 = t197 * t178 * t463;
  t619 = t89 * t615 * t618;
  t621 = t174 * t93;
  t622 = t173 * t621;
  t623 = t235 * t197;
  t624 = t205 * t623;
  t625 = t622 * t624;
  t627 = t497 * t352;
  t630 = -t89 * t568 * t98 + t239 * t446 + 0.2e1 * t588 * t241 - 0.2e1 * t595 * t241 - t254 * t446 - t254 * t581 - 0.2e1 * t595 * t257 - 0.3e1 * t573 * t577 - 0.2e1 * t573 * t584 + 0.3e1 * t592 * t577 + 0.3e1 * t592 * t607 + 0.3e1 * t599 * t602 + 0.3e1 * t599 * t627 - 0.3e1 * t612 * t607 + 0.3e1 * t619 + 0.3e1 * t625;
  t631 = t503 * t174;
  t632 = t501 * t631;
  t637 = t118 * t93;
  t638 = t637 * t178;
  t639 = t89 * t638;
  t640 = params->csk_a * t174;
  t641 = t640 * t197;
  t642 = t97 * t641;
  t643 = t639 * t642;
  t645 = t615 * t197;
  t646 = t173 * t645;
  t647 = t646 * t456;
  t649 = t646 * t464;
  t651 = t96 * t174;
  t652 = t501 * t651;
  t655 = t173 * t598;
  t656 = t497 * t235;
  t662 = t182 * t245;
  t663 = t205 * t662;
  t670 = t89 * t245 * t91 * t199;
  t674 = t89 * t118 * t193 * t199;
  t675 = t96 * t193;
  t676 = t188 * t675;
  t678 = -t599 * t513 * t600 + 0.2e1 * t234 * t663 + t450 * t236 + t239 * t676 + 0.2e1 * t588 * t252 - t573 * t632 + 0.3e1 * t592 * t632 - t612 * t632 - 0.2e1 * t612 * t652 - 0.3e1 * t655 * t656 - t250 + 0.3e1 * t643 - 0.3e1 * t647 - 0.3e1 * t649 - 0.2e1 * t670 - t674;
  t680 = my_piecewise5(t52, 0, t55, 0, t630 + t678);
  t682 = 0.55e2 / 0.81e2 * t552 - 0.44e3 / 0.729e3 * t555 + 0.8e2 / 0.243e3 * t558 - 0.5e1 / 0.81e2 * t561 + t167 * t121 + 0.2e1 * t87 * t260 + t47 * t680;
  t687 = my_piecewise3(t3, 0, -t8 * t150 * t123 / 0.3e2 + t8 * t73 * t262 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t682);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t687 + 0.4e1 * t267;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t706 = my_piecewise3(t55, 0, 0.1e3 / 0.243e3 * t224);
  t707 = my_piecewise3(t57, t706, 0);
  t710 = t136 * t422;
  t711 = t173 * t710;
  t714 = t286 * t176;
  t715 = t173 * t714;
  t718 = t89 * t710;
  t721 = t278 * t197;
  t722 = t205 * t721;
  t723 = t622 * t722;
  t725 = t136 * t174;
  t727 = t89 * t725 * t618;
  t729 = t419 * t710;
  t731 = t278 * params->csk_a;
  t732 = t497 * t731;
  t736 = t725 * t197;
  t737 = t173 * t736;
  t738 = t737 * t464;
  t748 = t428 * t136;
  t749 = t748 * params->csk_a;
  t750 = t513 * t749;
  t753 = -t89 * t707 * t98 - 0.2e1 * t715 * t241 - t293 * t446 - t293 * t581 - 0.3e1 * t729 * t577 - 0.2e1 * t729 * t584 + 0.3e1 * t599 * t732 + 0.3e1 * t599 * t750 + 0.3e1 * t711 * t607 - 0.3e1 * t718 * t607 + 0.3e1 * t711 * t632 - t718 * t632 - t729 * t632 + 0.3e1 * t723 + 0.3e1 * t727 - 0.3e1 * t738;
  t754 = t89 * t714;
  t763 = t136 * t93 * t178;
  t764 = t89 * t763;
  t765 = t764 * t642;
  t767 = t737 * t456;
  t771 = t497 * t278;
  t777 = t182 * t286;
  t778 = t205 * t777;
  t781 = t513 * t748;
  t783 = t286 * t91;
  t785 = t89 * t783 * t199;
  t789 = t89 * t136 * t193 * t199;
  t791 = 0.2e1 * t234 * t778 + 0.2e1 * t754 * t241 + 0.2e1 * t754 * t252 - 0.2e1 * t715 * t257 + t450 * t279 + t282 * t446 + t282 * t676 + 0.3e1 * t711 * t577 - t599 * t781 - 0.2e1 * t718 * t652 - 0.3e1 * t655 * t771 - t291 + 0.3e1 * t765 - 0.3e1 * t767 - 0.2e1 * t785 - t789;
  t793 = my_piecewise5(t52, 0, t55, 0, t753 + t791);
  t795 = 0.1e3 / 0.243e3 * t227 - 0.25e2 / 0.81e2 * t230 + 0.5e1 / 0.54e2 * t30 * t129 * t210 + t167 * t139 + 0.2e1 * t87 * t297 + t47 * t793;
  t800 = my_piecewise3(t3, 0, -t8 * t150 * t141 / 0.3e2 + t8 * t73 * t299 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t795);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t800 + 0.4e1 * t304;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t807 = t30 * t223 * t121;
  t810 = t30 * t110 * t260;
  t813 = t310 * t197;
  t815 = t173 * t813 * t178;
  t816 = params->csk_a * t91;
  t817 = t816 * t463;
  t818 = t815 * t817;
  t820 = t310 * t93;
  t822 = t89 * t820 * t178;
  t823 = t816 * t197;
  t824 = t97 * t823;
  t825 = t822 * t824;
  t827 = t816 * t93;
  t828 = t183 * t827;
  t829 = t815 * t828;
  t831 = t310 * t422;
  t832 = t173 * t831;
  t834 = t91 * t62 * t96;
  t835 = t574 * t834;
  t838 = t419 * t831;
  t840 = t317 * t176;
  t841 = t89 * t840;
  t842 = t841 * t241;
  t843 = t173 * t840;
  t844 = t843 * t241;
  t845 = t475 * t834;
  t848 = t89 * t831;
  t851 = t528 * t91;
  t852 = t513 * t851;
  t855 = t518 * t91;
  t856 = t497 * t855;
  t859 = t843 * t257;
  t860 = t89 * t813;
  t862 = t188 * t251 * t93;
  t863 = t860 * t862;
  t865 = t97 * t245;
  t866 = t461 * t865;
  t869 = -0.2e1 * t254 * t866 + 0.3e1 * t832 * t835 + 0.3e1 * t832 * t845 + 0.3e1 * t832 * t856 - t838 * t835 - 0.2e1 * t838 * t852 - 0.3e1 * t848 * t845 - t319 - t321 - 0.3e1 * t818 + 0.3e1 * t825 - 0.3e1 * t829 + t842 - t844 - t859 + 0.3e1 * t863;
  t872 = t206 * t245;
  t873 = t205 * t872;
  t876 = t173 * t820;
  t877 = t182 * t91;
  t878 = t877 * t197;
  t879 = t205 * t878;
  t880 = t876 * t879;
  t882 = t514 * t91;
  t883 = t513 * t882;
  t888 = t497 * t256;
  t892 = t841 * t252;
  t893 = t501 * t251;
  t896 = t497 * t877;
  t901 = t91 * t422;
  t902 = t419 * t901;
  t903 = t428 * t310;
  t904 = t513 * t903;
  t906 = t182 * t317;
  t907 = t205 * t906;
  t908 = t234 * t907;
  t909 = t317 * t91;
  t911 = t89 * t909 * t199;
  t912 = t118 * t197;
  t913 = t89 * t912;
  t914 = t94 * t62;
  t915 = t96 * t245;
  t917 = t913 * t914 * t915;
  t918 = 0.2e1 * t917;
  t919 = t188 * t915;
  t922 = 0.2e1 * t239 * t866 + 0.2e1 * t239 * t919 + 0.2e1 * t254 * t663 - 0.2e1 * t254 * t873 - 0.3e1 * t832 * t896 - t848 * t835 - 0.3e1 * t838 * t856 + 0.3e1 * t838 * t883 + 0.3e1 * t838 * t888 - 0.2e1 * t848 * t893 - t902 * t904 + 0.3e1 * t880 + t892 + t908 - t911 - t918;
  t924 = my_piecewise5(t52, 0, t55, 0, t869 + t922);
  t926 = 0.8e2 / 0.243e3 * t807 - 0.1e2 / 0.81e2 * t810 + t87 * t327 + t47 * t924;
  t931 = my_piecewise3(t3, 0, t8 * t73 * t329 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t926);
  tv3rhosigma20 = 0.2e1 * rho[0] * t931 + 0.2e1 * t333;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t942 = t30 * t223 * t139;
  t945 = t30 * t110 * t297;
  t948 = t345 * t197;
  t949 = t173 * t948;
  t951 = t461 * t91 * t463;
  t952 = t949 * t951;
  t954 = t97 * params->csk_a;
  t955 = t248 * t197;
  t956 = t954 * t955;
  t957 = t764 * t956;
  t959 = t205 * t182;
  t960 = t959 * t827;
  t961 = t949 * t960;
  t963 = t710 * t424;
  t964 = t89 * t963;
  t965 = params->csk_a * t118;
  t966 = t965 * t91;
  t967 = t97 * t966;
  t970 = t419 * t963;
  t971 = t502 * t118;
  t973 = t971 * t183 * t91;
  t977 = t429 * t971 * t91;
  t980 = t173 * t638;
  t981 = t289 * t197;
  t982 = t183 * t981;
  t983 = t980 * t982;
  t985 = t572 * t424;
  t986 = t419 * t985;
  t987 = t136 * params->csk_a;
  t988 = t987 * t91;
  t989 = t429 * t988;
  t992 = t173 * t963;
  t995 = t89 * t948;
  t996 = t995 * t862;
  t998 = t971 * t834;
  t1000 = t183 * t988;
  t1009 = t497 * t278 * t91;
  t1012 = t348 * t91;
  t1013 = t501 * t1012;
  t1017 = 0.3e1 * t986 * t1000 - 0.3e1 * t592 * t1009 - 0.2e1 * t718 * t1013 - t715 * t343 - 0.3e1 * t964 * t967 - t964 * t998 + 0.3e1 * t992 * t967 - 0.3e1 * t970 * t973 - 0.2e1 * t970 * t977 - t970 * t998 + 0.3e1 * t992 * t973 + 0.3e1 * t986 * t989 + 0.3e1 * t992 * t998 - t319 - 0.3e1 * t952 + 0.3e1 * t957 - 0.3e1 * t961 + 0.3e1 * t983 + 0.3e1 * t996;
  t1021 = t600 * t136;
  t1022 = t513 * t1021;
  t1028 = t286 * t118;
  t1030 = t89 * t1028 * t199;
  t1031 = t136 * t245;
  t1033 = t89 * t1031 * t199;
  t1036 = -t902 * t1022 + t254 * t778 + t595 * t279 + t282 * t866 + t282 * t919 - t293 * t866 - t293 * t873 + t754 * t343 + t754 * t349 - t715 * t353 - t1030 - t1033 - t347 + t842 - t844 - t859 + t892 + t908 - t911;
  t1038 = my_piecewise5(t52, 0, t55, 0, t1017 + t1036);
  t1040 = -0.25e2 / 0.162e3 * t308 + 0.5e1 / 0.54e2 * t30 * t129 * t260 + 0.4e2 / 0.243e3 * t942 - 0.5e1 / 0.81e2 * t945 + t87 * t356 + t47 * t1038;
  t1045 = my_piecewise3(t3, 0, t8 * t73 * t358 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1040);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1045 + 0.2e1 * t362;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1056 = t367 * t197;
  t1058 = t173 * t1056 * t178;
  t1059 = t1058 * t817;
  t1061 = t367 * t93;
  t1063 = t89 * t1061 * t178;
  t1064 = t1063 * t824;
  t1066 = t1058 * t828;
  t1068 = t367 * t422;
  t1069 = t89 * t1068;
  t1072 = t173 * t1061;
  t1073 = t1072 * t879;
  t1075 = t419 * t1068;
  t1078 = t189 * t286;
  t1079 = t188 * t1078;
  t1082 = t173 * t1068;
  t1085 = t89 * t1056;
  t1086 = t1085 * t862;
  t1092 = t206 * t286;
  t1099 = -0.2e1 * t293 * t205 * t1092 - 0.3e1 * t1069 * t845 - t1075 * t835 - 0.2e1 * t1075 * t852 - 0.3e1 * t1075 * t856 + 0.3e1 * t1075 * t883 + 0.2e1 * t282 * t1079 - 0.2e1 * t293 * t1079 + 0.3e1 * t1082 * t856 - 0.3e1 * t1059 + 0.3e1 * t1064 - 0.3e1 * t1066 + 0.3e1 * t1073 + 0.3e1 * t1086 - t319 - t374;
  t1113 = t428 * t367;
  t1114 = t513 * t1113;
  t1116 = t136 * t197;
  t1117 = t89 * t1116;
  t1118 = t96 * t286;
  t1120 = t1117 * t914 * t1118;
  t1121 = 0.2e1 * t1120;
  t1125 = 0.2e1 * t282 * t188 * t1118 - t1069 * t835 - 0.2e1 * t1069 * t893 + 0.3e1 * t1075 * t888 + 0.3e1 * t1082 * t835 + 0.3e1 * t1082 * t845 - 0.3e1 * t1082 * t896 - t902 * t1114 + 0.2e1 * t293 * t778 - t1121 + t842 - t844 - t859 + t892 + t908 - t911;
  t1127 = my_piecewise5(t52, 0, t55, 0, t1099 + t1125);
  t1129 = -0.25e2 / 0.81e2 * t339 + 0.5e1 / 0.27e2 * t30 * t129 * t297 + t87 * t380 + t47 * t1127;
  t1134 = my_piecewise3(t3, 0, t8 * t73 * t382 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1129);
  tv3rholapl20 = 0.2e1 * rho[0] * t1134 + 0.2e1 * t386;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1138 = t30 * t110 * t327;
  t1140 = t310 * t118;
  t1149 = t189 * t317;
  t1150 = t188 * t1149;
  t1151 = t239 * t1150;
  t1152 = 0.3e1 * t1151;
  t1153 = t843 * t353;
  t1154 = 0.3e1 * t1153;
  t1155 = t1140 * t197;
  t1156 = t173 * t1155;
  t1157 = t1156 * t456;
  t1158 = 0.3e1 * t1157;
  t1159 = t843 * t343;
  t1160 = 0.3e1 * t1159;
  t1161 = t1156 * t464;
  t1162 = 0.3e1 * t1161;
  t1163 = t1140 * t93;
  t1165 = t89 * t1163 * t470;
  t1166 = 0.3e1 * t1165;
  t1167 = t1140 * t422;
  t1168 = t419 * t1167;
  t1173 = -0.3e1 * t173 * t1140 * t437 - t419 * t1140 * t430 - 0.2e1 * t89 * t1140 * t441 - 0.3e1 * t1168 * t519 - 0.2e1 * t1168 * t529 + t1152 - t1154 - t1158 - t1160 - t1162 + t1166 - t319 - t321;
  t1174 = t254 * t907;
  t1175 = 0.3e1 * t1174;
  t1178 = t173 * t1167;
  t1181 = t317 * t118;
  t1183 = t89 * t1181 * t199;
  t1184 = 0.3e1 * t1183;
  t1185 = t841 * t349;
  t1186 = 0.3e1 * t1185;
  t1187 = t89 * t1155;
  t1188 = t1187 * t493;
  t1189 = 0.3e1 * t1188;
  t1191 = t173 * t1163 * t485;
  t1192 = 0.3e1 * t1191;
  t1195 = t89 * t1167;
  t1204 = 0.3e1 * t1168 * t498 - t1168 * t504 + 0.3e1 * t1168 * t515 + 0.3e1 * t1178 * t476 + 0.3e1 * t1178 * t504 + 0.3e1 * t1178 * t519 - 0.3e1 * t1195 * t476 - t1195 * t504 + t1175 - t1184 + t1186 + t1189 + t1192;
  t1206 = my_piecewise5(t52, 0, t55, 0, t1173 + t1204);
  t1208 = -0.5e1 / 0.27e2 * t1138 + t47 * t1206;
  t1212 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1208);
  tv3sigma30 = 0.2e1 * rho[0] * t1212;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1218 = t30 * t110 * t356;
  t1220 = t136 * t310;
  t1221 = t1220 * t197;
  t1222 = t173 * t1221;
  t1223 = t1222 * t464;
  t1224 = 0.3e1 * t1223;
  t1225 = params->csk_a * t310;
  t1226 = t1225 * t197;
  t1227 = t97 * t1226;
  t1228 = t764 * t1227;
  t1229 = 0.3e1 * t1228;
  t1230 = t1222 * t456;
  t1231 = 0.3e1 * t1230;
  t1234 = t282 * t1150;
  t1235 = t518 * t310;
  t1236 = t497 * t1235;
  t1239 = t293 * t1150;
  t1242 = t475 * t310 * t62 * t96;
  t1247 = t89 * t1220;
  t1248 = t1247 * t618;
  t1249 = 0.3e1 * t1248;
  t1250 = t876 * t722;
  t1251 = 0.3e1 * t1250;
  t1254 = t503 * t310;
  t1255 = t501 * t1254;
  t1260 = 0.3e1 * t711 * t1236 + 0.3e1 * t711 * t1242 - 0.3e1 * t718 * t1242 + 0.3e1 * t711 * t1255 - t718 * t1255 - t729 * t1255 + 0.3e1 * t838 * t732 + 0.3e1 * t838 * t750 - t1224 + t1229 - t1231 + t1234 - t1239 + t1249 + t1251 - t319;
  t1261 = 0.2e1 * t1151;
  t1262 = 0.2e1 * t1153;
  t1263 = 0.2e1 * t1159;
  t1266 = t206 * t317;
  t1267 = t205 * t1266;
  t1268 = t293 * t1267;
  t1269 = t528 * t310;
  t1270 = t513 * t1269;
  t1273 = 0.2e1 * t1174;
  t1274 = 0.2e1 * t1183;
  t1275 = 0.2e1 * t1185;
  t1276 = t843 * t279;
  t1278 = t136 * t317;
  t1280 = t89 * t1278 * t199;
  t1281 = t96 * t317;
  t1282 = t188 * t1281;
  t1283 = t282 * t1282;
  t1284 = t96 * t310;
  t1285 = t501 * t1284;
  t1290 = -0.3e1 * t729 * t1236 - 0.2e1 * t729 * t1270 - 0.2e1 * t718 * t1285 - 0.3e1 * t832 * t771 - t838 * t781 + t1261 - t1262 - t1263 - t1268 + t1273 - t1274 + t1275 + t1276 - t1280 + t1283 - t347;
  t1292 = my_piecewise5(t52, 0, t55, 0, t1260 + t1290);
  t1294 = 0.5e1 / 0.54e2 * t30 * t129 * t327 - 0.1e2 / 0.81e2 * t1218 + t47 * t1292;
  t1298 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1294);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1298;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1304 = t30 * t110 * t380;
  t1306 = t965 * t93;
  t1308 = t1058 * t183 * t1306;
  t1309 = 0.3e1 * t1308;
  t1311 = t1058 * t965 * t463;
  t1312 = 0.3e1 * t1311;
  t1313 = t965 * t197;
  t1314 = t97 * t1313;
  t1315 = t1063 * t1314;
  t1316 = 0.3e1 * t1315;
  t1317 = t183 * t118;
  t1318 = t574 * t1317;
  t1321 = t528 * t118;
  t1325 = t1072 * t624;
  t1326 = 0.3e1 * t1325;
  t1332 = t188 * t348 * t93;
  t1333 = t1085 * t1332;
  t1334 = 0.3e1 * t1333;
  t1338 = t501 * t503 * t118;
  t1344 = t118 * t62 * t96;
  t1345 = t475 * t1344;
  t1348 = -0.2e1 * t1075 * t513 * t1321 - t1069 * t1338 - 0.3e1 * t1075 * t1318 - t1075 * t1338 + 0.3e1 * t1075 * t602 + 0.3e1 * t1075 * t627 + 0.3e1 * t1082 * t1318 + 0.3e1 * t1082 * t1338 + 0.3e1 * t1082 * t1345 - t1309 - t1312 + t1316 + t1326 + t1334 - t319 - t374;
  t1351 = 0.2e1 * t1234;
  t1352 = 0.2e1 * t1239;
  t1353 = 0.2e1 * t1268;
  t1354 = 0.2e1 * t1276;
  t1355 = 0.2e1 * t1280;
  t1356 = 0.2e1 * t1283;
  t1363 = -0.2e1 * t1069 * t501 * t348 - 0.3e1 * t1069 * t1345 - 0.3e1 * t1082 * t656 - t573 * t1114 + t1151 - t1153 - t1159 + t1174 - t1183 + t1185 + t1351 - t1352 - t1353 + t1354 - t1355 + t1356;
  t1365 = my_piecewise5(t52, 0, t55, 0, t1348 + t1363);
  t1367 = 0.5e1 / 0.27e2 * t30 * t129 * t356 - 0.5e1 / 0.81e2 * t1304 + t47 * t1365;
  t1371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1367);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1371;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1376 = t367 * t136;
  t1385 = t1376 * t197;
  t1386 = t173 * t1385;
  t1387 = t1386 * t456;
  t1388 = 0.3e1 * t1387;
  t1389 = t1386 * t464;
  t1390 = 0.3e1 * t1389;
  t1391 = t1376 * t93;
  t1393 = t89 * t1391 * t470;
  t1394 = 0.3e1 * t1393;
  t1395 = 0.3e1 * t1234;
  t1396 = 0.3e1 * t1239;
  t1397 = 0.3e1 * t1268;
  t1398 = 0.3e1 * t1276;
  t1399 = 0.3e1 * t1280;
  t1400 = -0.3e1 * t173 * t1376 * t437 - t419 * t1376 * t430 - 0.2e1 * t89 * t1376 * t441 - t1388 - t1390 + t1394 + t1395 - t1396 - t1397 + t1398 - t1399 - t319 - t374;
  t1401 = 0.3e1 * t1283;
  t1402 = t1376 * t422;
  t1403 = t89 * t1402;
  t1406 = t419 * t1402;
  t1413 = t173 * t1402;
  t1416 = t89 * t1385;
  t1417 = t1416 * t493;
  t1418 = 0.3e1 * t1417;
  t1420 = t173 * t1391 * t485;
  t1421 = 0.3e1 * t1420;
  t1430 = -0.3e1 * t1403 * t476 - t1403 * t504 + 0.3e1 * t1406 * t498 - t1406 * t504 + 0.3e1 * t1406 * t515 - 0.3e1 * t1406 * t519 - 0.2e1 * t1406 * t529 + 0.3e1 * t1413 * t476 + 0.3e1 * t1413 * t504 + 0.3e1 * t1413 * t519 + t1401 + t1418 + t1421;
  t1432 = my_piecewise5(t52, 0, t55, 0, t1400 + t1430);
  t1434 = 0.5e1 / 0.18e2 * t30 * t129 * t380 + t47 * t1432;
  t1438 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1434);
  tv3lapl30 = 0.2e1 * rho[0] * t1438;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t6, t8, t9, t10, t12;
  double t13, t15, t16, t18, t19, t21, t22, t23;
  double t24, t25, t26, t27, t28, t30, t31, t32;
  double t33, t34, t36, t38, t40, t42, t47, t49;
  double t50, t51, t52, t53, t54, t55, t56, t57;
  double t58, t59, t60, t61, t62, t63, t64, t65;
  double t67, t71, tzk0;

  double t73, t77, t79, t81, t87, t89, t90, t91;
  double t93, t94, t96, t97, t98, t100, t102, t107;
  double tvrho0, t110, t111, t114, t117, t118, t121, t123;
  double t127, tvsigma0, t129, t135, t136, t139, t141, t145;
  double tvlapl0, tvtau0;

  double t150, t157, t159, t161, t167, t171, t173, t174;
  double t176, t177, t178, t179, t180, t181, t182, t183;
  double t184, t186, t188, t189, t190, t192, t193, t196;
  double t197, t199, t200, t201, t203, t205, t206, t207;
  double t210, t212, t217, tv2rho20, t223, t224, t227, t230;
  double t233, t234, t235, t236, t238, t239, t240, t241;
  double t244, t245, t248, t250, t251, t252, t254, t256;
  double t257, t260, t262, t267, tv2rhosigma0, t278, t279, t281;
  double t282, t285, t286, t289, t291, t293, t297, t299;
  double t304, tv2rholapl0, tv2rhotau0, t308, t310, t313, t316, t317;
  double t319, t320, t321, t323, t327, t329, t333, tv2sigma20;
  double t339, t343, t345, t346, t347, t348, t349, t352;
  double t353, t356, t358, t362, tv2sigmalapl0, tv2sigmatau0, t367, t370;
  double t373, t374, t376, t380, t382, t386, tv2lapl20, tv2lapltau0;
  double tv2tau20;

  double t391, t403, t405, t411, t419, t420, t422, t424;
  double t425, t426, t428, t429, t430, t432, t433, t437;
  double t441, t445, t446, t449, t450, t453, t454, t456;
  double t457, t461, t463, t464, t465, t467, t469, t470;
  double t471, t473, t474, t475, t476, t479, t482, t484;
  double t485, t486, t492, t493, t494, t496, t497, t498;
  double t501, t502, t503, t504, t509, t513, t514, t515;
  double t518, t519, t524, t528, t529, t532, t534, t536;
  double t541, tv3rho30, t551, t552, t555, t558, t561, t567;
  double t568, t572, t573, t574, t576, t577, t580, t581;
  double t583, t584, t587, t588, t592, t595, t598, t599;
  double t600, t601, t602, t606, t607, t612, t615, t618;
  double t619, t621, t622, t623, t624, t625, t627, t630;
  double t631, t632, t637, t638, t639, t640, t641, t642;
  double t643, t645, t646, t647, t649, t651, t652, t655;
  double t656, t662, t663, t670, t674, t675, t676, t678;
  double t680, t682, t687, tv3rho2sigma0, t706, t707, t710, t711;
  double t714, t715, t718, t721, t722, t723, t725, t727;
  double t729, t731, t732, t736, t737, t738, t748, t749;
  double t750, t753, t754, t763, t764, t765, t767, t771;
  double t777, t778, t781, t783, t785, t789, t791, t793;
  double t795, t800, tv3rho2lapl0, tv3rho2tau0, t807, t810, t813, t815;
  double t816, t817, t818, t820, t822, t823, t824, t825;
  double t827, t828, t829, t831, t832, t834, t835, t838;
  double t840, t841, t842, t843, t844, t845, t848, t851;
  double t852, t855, t856, t859, t860, t862, t863, t865;
  double t866, t869, t872, t873, t876, t877, t878, t879;
  double t880, t882, t883, t888, t892, t893, t896, t901;
  double t902, t903, t904, t906, t907, t908, t909, t911;
  double t912, t913, t914, t915, t917, t918, t919, t922;
  double t924, t926, t931, tv3rhosigma20, t942, t945, t948, t949;
  double t951, t952, t954, t955, t956, t957, t959, t960;
  double t961, t963, t964, t965, t966, t967, t970, t971;
  double t973, t977, t980, t981, t982, t983, t985, t986;
  double t987, t988, t989, t992, t995, t996, t998, t1000;
  double t1009, t1012, t1013, t1017, t1021, t1022, t1028, t1030;
  double t1031, t1033, t1036, t1038, t1040, t1045, tv3rhosigmalapl0, tv3rhosigmatau0;
  double t1056, t1058, t1059, t1061, t1063, t1064, t1066, t1068;
  double t1069, t1072, t1073, t1075, t1078, t1079, t1082, t1085;
  double t1086, t1092, t1099, t1113, t1114, t1116, t1117, t1118;
  double t1120, t1121, t1125, t1127, t1129, t1134, tv3rholapl20, tv3rholapltau0;
  double tv3rhotau20, t1138, t1140, t1149, t1150, t1151, t1152, t1153;
  double t1154, t1155, t1156, t1157, t1158, t1159, t1160, t1161;
  double t1162, t1163, t1165, t1166, t1167, t1168, t1173, t1174;
  double t1175, t1178, t1181, t1183, t1184, t1185, t1186, t1187;
  double t1188, t1189, t1191, t1192, t1195, t1204, t1206, t1208;
  double t1212, tv3sigma30, t1218, t1220, t1221, t1222, t1223, t1224;
  double t1225, t1226, t1227, t1228, t1229, t1230, t1231, t1234;
  double t1235, t1236, t1239, t1242, t1247, t1248, t1249, t1250;
  double t1251, t1254, t1255, t1260, t1261, t1262, t1263, t1266;
  double t1267, t1268, t1269, t1270, t1273, t1274, t1275, t1276;
  double t1278, t1280, t1281, t1282, t1283, t1284, t1285, t1290;
  double t1292, t1294, t1298, tv3sigma2lapl0, tv3sigma2tau0, t1304, t1306, t1308;
  double t1309, t1311, t1312, t1313, t1314, t1315, t1316, t1317;
  double t1318, t1321, t1325, t1326, t1332, t1333, t1334, t1338;
  double t1344, t1345, t1348, t1351, t1352, t1353, t1354, t1355;
  double t1356, t1363, t1365, t1367, t1371, tv3sigmalapl20, tv3sigmalapltau0, tv3sigmatau20;
  double t1376, t1385, t1386, t1387, t1388, t1389, t1390, t1391;
  double t1393, t1394, t1395, t1396, t1397, t1398, t1399, t1400;
  double t1401, t1402, t1403, t1406, t1413, t1416, t1417, t1418;
  double t1420, t1421, t1430, t1432, t1434, t1438, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, tv3tau30;

  double t1460, t1466, t1474, t1475, t1483, t1485, t1486, t1488;
  double t1489, t1490, t1491, t1492, t1493, t1494, t1495, t1496;
  double t1498, t1499, t1502, t1503, t1506, t1507, t1508, t1511;
  double t1512, t1515, t1519, t1526, t1528, t1531, t1536, t1538;
  double t1541, t1542, t1545, t1546, t1549, t1550, t1552, t1553;
  double t1556, t1557, t1558, t1561, t1563, t1565, t1570, t1573;
  double t1576, t1580, t1583, t1585, t1590, t1592, t1595, t1600;
  double t1603, t1604, t1606, t1610, t1614, t1618, t1619, t1622;
  double t1627, t1634, t1638, t1641, t1647, t1648, t1649, t1650;
  double t1651, t1654, t1655, t1656, t1659, t1660, t1661, t1662;
  double t1665, t1670, t1671, t1677, t1678, t1681, t1682, t1693;
  double t1696, t1699, t1706, t1707, t1710, t1711, t1716, t1718;
  double t1719, t1725, t1728, t1736, t1737, t1743, t1750, t1751;
  double t1752, t1753, t1762, t1763, t1768, t1777, t1781, t1788;
  double tv4rho40, t1801, t1802, t1822, t1823, t1831, t1833, t1834;
  double t1840, t1841, t1842, t1845, t1847, t1848, t1851, t1852;
  double t1856, t1859, t1864, t1865, t1867, t1868, t1874, t1878;
  double t1879, t1881, t1882, t1885, t1888, t1893, t1896, t1899;
  double t1902, t1906, t1907, t1911, t1914, t1915, t1920, t1926;
  double t1928, t1929, t1936, t1943, t1946, t1947, t1948, t1950;
  double t1953, t1955, t1958, t1961, t1962, t1963, t1967, t1973;
  double t1974, t1976, t1977, t1980, t1985, t1988, t1990, t1993;
  double t1994, t1997, t1998, t2004, t2007, t2013, t2016, t2017;
  double t2022, t2027, t2035, t2040, t2044, t2047, t2049, t2052;
  double t2057, t2062, t2067, t2070, t2071, t2075, t2080, t2082;
  double t2094, t2096, t2098, t2107, t2111, t2118, t2121, t2126;
  double t2138, t2143, t2146, t2159, t2171, t2174, t2178, t2183;
  double t2184, t2187, t2191, t2198, tv4rho3sigma0, t2223, t2224, t2232;
  double t2235, t2237, t2242, t2244, t2247, t2248, t2251, t2252;
  double t2253, t2257, t2262, t2263, t2272, t2277, t2278, t2285;
  double t2286, t2298, t2302, t2307, t2310, t2315, t2316, t2319;
  double t2322, t2325, t2330, t2333, t2339, t2344, t2345, t2348;
  double t2355, t2359, t2364, t2367, t2372, t2373, t2376, t2393;
  double t2395, t2400, t2402, t2406, t2410, t2415, t2416, t2420;
  double t2432, t2436, t2440, t2454, t2456, t2474, t2477, t2483;
  double t2489, t2498, t2501, t2504, t2518, t2522, t2529, tv4rho3lapl0;
  double tv4rho3tau0, t2551, t2552, t2560, t2561, t2562, t2570, t2571;
  double t2574, t2575, t2576, t2578, t2581, t2582, t2583, t2585;
  double t2588, t2590, t2593, t2596, t2599, t2600, t2601, t2602;
  double t2605, t2606, t2607, t2608, t2611, t2614, t2617, t2620;
  double t2632, t2644, t2645, t2646, t2658, t2661, t2665, t2669;
  double t2670, t2673, t2674, t2676, t2679, t2680, t2681, t2682;
  double t2685, t2686, t2690, t2693, t2694, t2696, t2697, t2699;
  double t2700, t2703, t2706, t2710, t2713, t2720, t2722, t2726;
  double t2732, t2734, t2736, t2737, t2738, t2739, t2741, t2744;
  double t2745, t2760, t2762, t2765, t2770, t2771, t2773, t2775;
  double t2777, t2780, t2781, t2782, t2785, t2786, t2788, t2790;
  double t2795, t2796, t2797, t2801, t2804, t2810, t2813, t2815;
  double t2834, t2844, t2854, t2858, t2861, t2868, t2872, t2874;
  double t2875, t2876, t2877, t2880, t2881, t2882, t2884, t2888;
  double t2896, t2898, t2901, t2905, t2906, t2907, t2910, t2911;
  double t2915, t2918, t2919, t2921, t2922, t2925, t2930, t2939;
  double t2940, t2944, t2951, tv4rho2sigma20, t2978, t2979, t2982, t2983;
  double t2988, t2992, t2999, t3003, t3014, t3031, t3033, t3034;
  double t3035, t3036, t3039, t3040, t3041, t3044, t3047, t3048;
  double t3051, t3054, t3067, t3069, t3070, t3076, t3080, t3091;
  double t3101, t3110, t3111, t3117, t3120, t3121, t3122, t3132;
  double t3142, t3147, t3151, t3170, t3171, t3179, t3180, t3186;
  double t3190, t3191, t3199, t3208, t3217, t3222, t3237, t3248;
  double t3249, t3254, t3261, t3288, t3292, t3297, t3301, t3322;
  double t3326, t3333, tv4rho2sigmalapl0, tv4rho2sigmatau0, t3351, t3355, t3360, t3361;
  double t3364, t3367, t3372, t3373, t3378, t3379, t3382, t3389;
  double t3392, t3400, t3401, t3402, t3406, t3423, t3432, t3434;
  double t3435, t3438, t3445, t3447, t3453, t3459, t3460, t3463;
  double t3476, t3479, t3487, t3496, t3498, t3506, t3513, t3522;
  double t3531, t3535, t3566, t3567, t3577, t3585, t3586, t3597;
  double t3603, t3611, t3616, t3617, t3625, t3629, t3636, tv4rho2lapl20;
  double tv4rho2lapltau0, tv4rho2tau20, t3649, t3650, t3651, t3653, t3654, t3655;
  double t3656, t3658, t3661, t3663, t3664, t3665, t3666, t3668;
  double t3670, t3671, t3672, t3673, t3677, t3679, t3682, t3683;
  double t3684, t3687, t3688, t3689, t3692, t3694, t3695, t3698;
  double t3699, t3705, t3709, t3713, t3720, t3721, t3723, t3725;
  double t3726, t3731, t3736, t3738, t3739, t3741, t3744, t3746;
  double t3747, t3753, t3756, t3757, t3758, t3760, t3764, t3768;
  double t3771, t3777, t3780, t3781, t3786, t3787, t3791, t3797;
  double t3811, t3812, t3815, t3822, t3829, t3832, t3835, t3838;
  double t3843, t3845, t3850, t3852, t3860, t3878, t3880, t3881;
  double t3884, t3887, t3894, t3898, t3899, t3901, t3903, t3905;
  double t3907, t3908, t3909, t3922, t3924, t3927, t3937, t3941;
  double t3943, t3947, t3954, tv4rhosigma30, t3971, t3972, t3975, t3976;
  double t3979, t3980, t3981, t3988, t3992, t3994, t3995, t4000;
  double t4002, t4008, t4010, t4011, t4015, t4021, t4028, t4033;
  double t4036, t4039, t4044, t4045, t4049, t4054, t4055, t4062;
  double t4069, t4070, t4071, t4073, t4082, t4084, t4086, t4089;
  double t4106, t4118, t4119, t4123, t4130, t4136, t4154, t4169;
  double t4170, t4178, t4182, t4183, t4191, t4224, t4225, t4232;
  double t4233, t4235, t4237, t4240, t4244, t4259, t4261, t4264;
  double t4282, t4292, t4298, t4303, t4307, t4308, t4313, t4320;
  double tv4rhosigma2lapl0, tv4rhosigma2tau0, t4337, t4338, t4339, t4340, t4343, t4346;
  double t4347, t4350, t4351, t4359, t4369, t4371, t4372, t4385;
  double t4390, t4392, t4403, t4421, t4426, t4427, t4434, t4438;
  double t4445, t4448, t4456, t4484, t4515, t4561, t4562, t4571;
  double t4576, t4602, t4612, t4618, t4623, t4630, tv4rhosigmalapl20, tv4rhosigmalapltau0;
  double tv4rhosigmatau20, t4641, t4642, t4643, t4646, t4650, t4653, t4675;
  double t4692, t4693, t4696, t4698, t4701, t4707, t4724, t4729;
  double t4732, t4739, t4741, t4748, t4749, t4758, t4761, t4763;
  double t4766, t4767, t4780, t4783, t4794, t4812, t4818, t4827;
  double t4834, t4836, t4845, t4852, t4853, t4857, t4861, t4868;
  double tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, tv4rhotau30, t4874, t4875, t4877, t4879;
  double t4882, t4883, t4884, t4889, t4900, t4901, t4903, t4905;
  double t4906, t4908, t4910, t4913, t4914, t4916, t4918, t4919;
  double t4922, t4925, t4926, t4928, t4930, t4933, t4934, t4936;
  double t4937, t4939, t4941, t4942, t4948, t4952, t4957, t4966;
  double t4971, t4974, t4975, t4978, t4981, t4989, t5006, t5011;
  double t5012, t5014, t5018, t5020, t5026, t5027, t5041, t5045;
  double t5051, t5061, t5075, t5079, t5085, tv4sigma40, t5093, t5094;
  double t5099, t5103, t5104, t5105, t5106, t5107, t5108, t5109;
  double t5110, t5111, t5112, t5113, t5114, t5115, t5119, t5120;
  double t5121, t5122, t5123, t5124, t5125, t5135, t5146, t5147;
  double t5149, t5150, t5151, t5152, t5153, t5154, t5155, t5156;
  double t5158, t5166, t5170, t5176, t5177, t5185, t5192, t5193;
  double t5209, t5210, t5211, t5218, t5228, t5248, t5249, t5256;
  double t5257, t5259, t5269, t5270, t5271, t5272, t5273, t5275;
  double t5276, t5280, t5298, t5301, t5305, t5311, tv4sigma3lapl0, tv4sigma3tau0;
  double t5320, t5328, t5329, t5336, t5345, t5347, t5352, t5356;
  double t5371, t5378, t5382, t5388, t5406, t5408, t5411, t5418;
  double t5441, t5443, t5445, t5446, t5448, t5451, t5452, t5454;
  double t5458, t5462, t5470, t5480, t5482, t5486, t5501, t5519;
  double t5521, t5524, t5527, t5531, t5535, t5541, tv4sigma2lapl20, tv4sigma2lapltau0;
  double tv4sigma2tau20, t5550, t5551, t5565, t5573, t5579, t5581, t5584;
  double t5588, t5596, t5609, t5610, t5629, t5643, t5667, t5676;
  double t5689, t5691, t5695, t5701, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, tv4sigmatau30;
  double t5706, t5709, t5712, t5726, t5730, t5731, t5734, t5741;
  double t5746, t5767, t5768, t5771, t5774, t5778, t5783, t5818;
  double t5819, t5832, t5857, t5861, t5867, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20;
  double tv4lapltau30, tv4tau40;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = t4 * t4;
  t6 = M_CBRTPI;
  t8 = t5 * t6 * M_PI;
  t9 = 0.1e1 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t12 = my_piecewise5(t9, t10, t9, -t10, 0);
  t13 = 0.1e1 + t12;
  t15 = POW_1_3(p->zeta_threshold);
  t16 = t15 * t15;
  t18 = POW_1_3(t13);
  t19 = t18 * t18;
  t21 = my_piecewise3(t13 <= p->zeta_threshold, t16 * p->zeta_threshold, t19 * t13);
  t22 = POW_1_3(rho[0]);
  t23 = t22 * t22;
  t24 = t21 * t23;
  t25 = M_CBRT6;
  t26 = M_PI * M_PI;
  t27 = POW_1_3(t26);
  t28 = t27 * t27;
  t30 = t25 / t28;
  t31 = M_CBRT2;
  t32 = t31 * t31;
  t33 = sigma[0] * t32;
  t34 = rho[0] * rho[0];
  t36 = 0.1e1 / t23 / t34;
  t38 = t30 * t33 * t36;
  t40 = lapl[0] * t32;
  t42 = 0.1e1 / t23 / rho[0];
  t47 = 0.5e1 / 0.54e2 * t30 * t40 * t42 - 0.5e1 / 0.81e2 * t38;
  t49 = log(0.1e1 - DBL_EPSILON);
  t50 = 0.1e1 / params->csk_a;
  t51 = pow(-t49, -t50);
  t52 = t47 < -t51;
  t53 = log(DBL_EPSILON);
  t54 = pow(-t53, -t50);
  t55 = -t54 < t47;
  t56 = my_piecewise3(t55, -t54, t47);
  t57 = -t51 < t56;
  t58 = my_piecewise3(t57, t56, -t51);
  t59 = fabs(t58);
  t60 = pow(t59, params->csk_a);
  t61 = 0.1e1 / t60;
  t62 = exp(-t61);
  t63 = 0.1e1 - t62;
  t64 = pow(t63, t50);
  t65 = my_piecewise5(t52, 0, t55, 1, t64);
  t67 = 0.1e1 + 0.5e1 / 0.72e2 * t38 + t47 * t65;
  t71 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t67);
  tzk0 = 0.2e1 * t71;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t73 = t21 / t22;
  t77 = t34 * rho[0];
  t79 = 0.1e1 / t23 / t77;
  t81 = t30 * t33 * t79;
  t87 = -0.25e2 / 0.162e3 * t30 * t40 * t36 + 0.4e2 / 0.243e3 * t81;
  t89 = t64 * t61;
  t90 = my_piecewise3(t55, 0, t87);
  t91 = my_piecewise3(t57, t90, 0);
  t93 = fabs(t58) / t58;
  t94 = 0.1e1 / t59;
  t96 = 0.1e1 / t63;
  t97 = t62 * t96;
  t98 = t93 * t94 * t97;
  t100 = my_piecewise5(t52, 0, t55, 0, -t89 * t91 * t98);
  t102 = -0.5e1 / 0.27e2 * t81 + t87 * t65 + t47 * t100;
  t107 = my_piecewise3(t3, 0, t8 * t73 * t67 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t102);
  tvrho0 = 0.2e1 * rho[0] * t107 + 0.2e1 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t110 = t32 * t36;
  t111 = t30 * t110;
  t114 = t30 * t110 * t65;
  t117 = my_piecewise3(t55, 0, -0.5e1 / 0.81e2 * t111);
  t118 = my_piecewise3(t57, t117, 0);
  t121 = my_piecewise5(t52, 0, t55, 0, -t89 * t118 * t98);
  t123 = 0.5e1 / 0.72e2 * t111 - 0.5e1 / 0.81e2 * t114 + t47 * t121;
  t127 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t123);
  tvsigma0 = 0.2e1 * rho[0] * t127;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t129 = t32 * t42;
  t135 = my_piecewise3(t55, 0, 0.5e1 / 0.54e2 * t30 * t129);
  t136 = my_piecewise3(t57, t135, 0);
  t139 = my_piecewise5(t52, 0, t55, 0, -t89 * t136 * t98);
  t141 = 0.5e1 / 0.54e2 * t30 * t129 * t65 + t47 * t139;
  t145 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t141);
  tvlapl0 = 0.2e1 * rho[0] * t145;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t150 = t21 / t22 / rho[0];
  t157 = t34 * t34;
  t159 = 0.1e1 / t23 / t157;
  t161 = t30 * t33 * t159;
  t167 = 0.1e3 / 0.243e3 * t30 * t40 * t79 - 0.44e3 / 0.729e3 * t161;
  t171 = t60 * t60;
  t173 = t64 / t171;
  t174 = t91 * t91;
  t176 = t93 * t93;
  t177 = t59 * t59;
  t178 = 0.1e1 / t177;
  t179 = t176 * t178;
  t180 = t62 * t62;
  t181 = t63 * t63;
  t182 = 0.1e1 / t181;
  t183 = t180 * t182;
  t184 = t179 * t183;
  t186 = t174 * t176;
  t188 = t178 * t62;
  t189 = t96 * params->csk_a;
  t190 = t188 * t189;
  t192 = my_piecewise3(t55, 0, t167);
  t193 = my_piecewise3(t57, t192, 0);
  t196 = t89 * t174;
  t197 = 0.0;
  t199 = t197 * t94 * t97;
  t200 = t196 * t199;
  t201 = t179 * t97;
  t203 = t173 * t186;
  t205 = t178 * t180;
  t206 = t182 * params->csk_a;
  t207 = t205 * t206;
  t210 = my_piecewise5(t52, 0, t55, 0, t173 * t174 * t184 + t89 * t186 * t190 - t89 * t193 * t98 - t203 * t190 + t196 * t201 - t203 * t207 - t200);
  t212 = 0.55e2 / 0.81e2 * t161 + t167 * t65 + 0.2e1 * t87 * t100 + t47 * t210;
  t217 = my_piecewise3(t3, 0, -t8 * t150 * t67 / 0.3e2 + t8 * t73 * t102 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t212);
  tv2rho20 = 0.2e1 * rho[0] * t217 + 0.4e1 * t107;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t223 = t32 * t79;
  t224 = t30 * t223;
  t227 = t30 * t223 * t65;
  t230 = t30 * t110 * t100;
  t233 = t91 * t176;
  t234 = t173 * t233;
  t235 = t182 * t118;
  t236 = t205 * t235;
  t238 = t118 * t176;
  t239 = t89 * t238;
  t240 = t189 * t91;
  t241 = t188 * t240;
  t244 = my_piecewise3(t55, 0, 0.4e2 / 0.243e3 * t224);
  t245 = my_piecewise3(t57, t244, 0);
  t248 = t118 * t91;
  t250 = t89 * t248 * t199;
  t251 = t96 * t91;
  t252 = t188 * t251;
  t254 = t173 * t238;
  t256 = t206 * t91;
  t257 = t205 * t256;
  t260 = my_piecewise5(t52, 0, t55, 0, -t89 * t245 * t98 + t234 * t236 + t239 * t241 + t239 * t252 - t254 * t241 - t254 * t257 - t250);
  t262 = -0.5e1 / 0.27e2 * t224 + 0.4e2 / 0.243e3 * t227 - 0.5e1 / 0.81e2 * t230 + t87 * t121 + t47 * t260;
  t267 = my_piecewise3(t3, 0, t8 * t73 * t123 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t262);
  tv2rhosigma0 = 0.2e1 * rho[0] * t267 + 0.2e1 * t127;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t278 = t182 * t136;
  t279 = t205 * t278;
  t281 = t136 * t176;
  t282 = t89 * t281;
  t285 = my_piecewise3(t55, 0, -0.25e2 / 0.162e3 * t111);
  t286 = my_piecewise3(t57, t285, 0);
  t289 = t136 * t91;
  t291 = t89 * t289 * t199;
  t293 = t173 * t281;
  t297 = my_piecewise5(t52, 0, t55, 0, -t89 * t286 * t98 + t234 * t279 + t282 * t241 - t293 * t241 + t282 * t252 - t293 * t257 - t291);
  t299 = -0.25e2 / 0.162e3 * t114 + 0.5e1 / 0.54e2 * t30 * t129 * t100 + t87 * t139 + t47 * t297;
  t304 = my_piecewise3(t3, 0, t8 * t73 * t141 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t299);
  tv2rholapl0 = 0.2e1 * rho[0] * t304 + 0.2e1 * t145;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t308 = t30 * t110 * t121;
  t310 = t118 * t118;
  t313 = t310 * t176;
  t316 = my_piecewise3(t55, 0, 0);
  t317 = my_piecewise3(t57, t316, 0);
  t319 = t89 * t317 * t98;
  t320 = t89 * t310;
  t321 = t320 * t199;
  t323 = t173 * t313;
  t327 = my_piecewise5(t52, 0, t55, 0, t173 * t310 * t184 + t89 * t313 * t190 - t323 * t190 + t320 * t201 - t323 * t207 - t319 - t321);
  t329 = -0.1e2 / 0.81e2 * t308 + t47 * t327;
  t333 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t329);
  tv2sigma20 = 0.2e1 * rho[0] * t333;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t339 = t30 * t110 * t139;
  t343 = t188 * t189 * t118;
  t345 = t136 * t118;
  t346 = t89 * t345;
  t347 = t346 * t199;
  t348 = t96 * t118;
  t349 = t188 * t348;
  t352 = t206 * t118;
  t353 = t205 * t352;
  t356 = my_piecewise5(t52, 0, t55, 0, t254 * t279 + t282 * t343 + t282 * t349 - t293 * t343 - t293 * t353 - t319 - t347);
  t358 = 0.5e1 / 0.54e2 * t30 * t129 * t121 - 0.5e1 / 0.81e2 * t339 + t47 * t356;
  t362 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t358);
  tv2sigmalapl0 = 0.2e1 * rho[0] * t362;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  t367 = t136 * t136;
  t370 = t367 * t176;
  t373 = t89 * t367;
  t374 = t373 * t199;
  t376 = t173 * t370;
  t380 = my_piecewise5(t52, 0, t55, 0, t173 * t367 * t184 + t89 * t370 * t190 - t376 * t190 + t373 * t201 - t376 * t207 - t319 - t374);
  t382 = 0.5e1 / 0.27e2 * t30 * t129 * t139 + t47 * t380;
  t386 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t382);
  tv2lapl20 = 0.2e1 * rho[0] * t386;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t391 = t21 / t22 / t34;
  t403 = 0.1e1 / t23 / t157 / rho[0];
  t405 = t30 * t33 * t403;
  t411 = -0.11e4 / 0.729e3 * t30 * t40 * t159 + 0.616e4 / 0.2187e4 * t405;
  t419 = t64 / t171 / t60;
  t420 = t174 * t91;
  t422 = t176 * t93;
  t424 = 0.1e1 / t177 / t59;
  t425 = t422 * t424;
  t426 = t180 * t62;
  t428 = 0.1e1 / t181 / t63;
  t429 = t426 * t428;
  t430 = t425 * t429;
  t432 = my_piecewise3(t55, 0, t411);
  t433 = my_piecewise3(t57, t432, 0);
  t437 = t425 * t183;
  t441 = t425 * t97;
  t445 = t189 * t193;
  t446 = t188 * t445;
  t449 = t193 * t176;
  t450 = t173 * t449;
  t453 = t420 * t197;
  t454 = t173 * t453;
  t456 = t205 * t206 * t93;
  t457 = t454 * t456;
  t461 = t178 * params->csk_a;
  t463 = t93 * t62 * t96;
  t464 = t461 * t463;
  t465 = t454 * t464;
  t467 = t420 * t93;
  t469 = t189 * t197;
  t470 = t188 * t469;
  t471 = t89 * t467 * t470;
  t473 = t420 * t422;
  t474 = t173 * t473;
  t475 = t424 * params->csk_a;
  t476 = t475 * t97;
  t479 = t89 * t473;
  t482 = -0.3e1 * t173 * t420 * t437 + 0.3e1 * t89 * t233 * t446 - t419 * t420 * t430 - 0.2e1 * t89 * t420 * t441 - t89 * t433 * t98 - 0.3e1 * t450 * t241 - 0.3e1 * t450 * t257 + 0.3e1 * t474 * t476 - 0.3e1 * t479 * t476 - t200 - 0.3e1 * t457 - 0.3e1 * t465 + 0.3e1 * t471;
  t484 = t182 * t197;
  t485 = t205 * t484;
  t486 = t173 * t467 * t485;
  t492 = t96 * t93;
  t493 = t188 * t492;
  t494 = t89 * t453 * t493;
  t496 = t419 * t473;
  t497 = t424 * t180;
  t498 = t497 * t206;
  t501 = t424 * t62;
  t502 = params->csk_a * params->csk_a;
  t503 = t96 * t502;
  t504 = t501 * t503;
  t509 = t182 * t193;
  t513 = t424 * t426;
  t514 = t428 * params->csk_a;
  t515 = t513 * t514;
  t518 = t182 * t502;
  t519 = t497 * t518;
  t524 = t89 * t193 * t91 * t199;
  t528 = t428 * t502;
  t529 = t513 * t528;
  t532 = 0.3e1 * t234 * t205 * t509 + 0.3e1 * t89 * t449 * t252 + 0.3e1 * t474 * t504 + 0.3e1 * t474 * t519 - t479 * t504 + 0.3e1 * t496 * t498 - t496 * t504 + 0.3e1 * t496 * t515 - 0.3e1 * t496 * t519 - 0.2e1 * t496 * t529 + 0.3e1 * t486 + 0.3e1 * t494 - 0.3e1 * t524;
  t534 = my_piecewise5(t52, 0, t55, 0, t482 + t532);
  t536 = -0.77e3 / 0.243e3 * t405 + t411 * t65 + 0.3e1 * t167 * t100 + 0.3e1 * t87 * t210 + t47 * t534;
  t541 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t391 * t67 - t8 * t150 * t102 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t73 * t212 + 0.3e1 / 0.2e2 * t8 * t24 * t536);
  tv3rho30 = 0.2e1 * rho[0] * t541 + 0.6e1 * t217;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t551 = t32 * t159;
  t552 = t30 * t551;
  t555 = t30 * t551 * t65;
  t558 = t30 * t223 * t100;
  t561 = t30 * t110 * t210;
  t567 = my_piecewise3(t55, 0, -0.44e3 / 0.729e3 * t552);
  t568 = my_piecewise3(t57, t567, 0);
  t572 = t118 * t422;
  t573 = t419 * t572;
  t574 = t424 * t502;
  t576 = t174 * t180 * t182;
  t577 = t574 * t576;
  t580 = t206 * t193;
  t581 = t205 * t580;
  t583 = t528 * t174;
  t584 = t513 * t583;
  t587 = t245 * t176;
  t588 = t89 * t587;
  t592 = t173 * t572;
  t595 = t173 * t587;
  t598 = t174 * t422;
  t599 = t419 * t598;
  t600 = t428 * t118;
  t601 = t600 * params->csk_a;
  t602 = t513 * t601;
  t606 = t174 * t62 * t96;
  t607 = t475 * t606;
  t612 = t89 * t572;
  t615 = t118 * t174;
  t618 = t197 * t178 * t463;
  t619 = t89 * t615 * t618;
  t621 = t174 * t93;
  t622 = t173 * t621;
  t623 = t235 * t197;
  t624 = t205 * t623;
  t625 = t622 * t624;
  t627 = t497 * t352;
  t630 = -t89 * t568 * t98 + t239 * t446 + 0.2e1 * t588 * t241 - 0.2e1 * t595 * t241 - t254 * t446 - t254 * t581 - 0.2e1 * t595 * t257 - 0.3e1 * t573 * t577 - 0.2e1 * t573 * t584 + 0.3e1 * t592 * t577 + 0.3e1 * t592 * t607 + 0.3e1 * t599 * t602 + 0.3e1 * t599 * t627 - 0.3e1 * t612 * t607 + 0.3e1 * t619 + 0.3e1 * t625;
  t631 = t503 * t174;
  t632 = t501 * t631;
  t637 = t118 * t93;
  t638 = t637 * t178;
  t639 = t89 * t638;
  t640 = params->csk_a * t174;
  t641 = t640 * t197;
  t642 = t97 * t641;
  t643 = t639 * t642;
  t645 = t615 * t197;
  t646 = t173 * t645;
  t647 = t646 * t456;
  t649 = t646 * t464;
  t651 = t96 * t174;
  t652 = t501 * t651;
  t655 = t173 * t598;
  t656 = t497 * t235;
  t662 = t182 * t245;
  t663 = t205 * t662;
  t670 = t89 * t245 * t91 * t199;
  t674 = t89 * t118 * t193 * t199;
  t675 = t96 * t193;
  t676 = t188 * t675;
  t678 = -t599 * t513 * t600 + 0.2e1 * t234 * t663 + t450 * t236 + t239 * t676 + 0.2e1 * t588 * t252 - t573 * t632 + 0.3e1 * t592 * t632 - t612 * t632 - 0.2e1 * t612 * t652 - 0.3e1 * t655 * t656 - t250 + 0.3e1 * t643 - 0.3e1 * t647 - 0.3e1 * t649 - 0.2e1 * t670 - t674;
  t680 = my_piecewise5(t52, 0, t55, 0, t630 + t678);
  t682 = 0.55e2 / 0.81e2 * t552 - 0.44e3 / 0.729e3 * t555 + 0.8e2 / 0.243e3 * t558 - 0.5e1 / 0.81e2 * t561 + t167 * t121 + 0.2e1 * t87 * t260 + t47 * t680;
  t687 = my_piecewise3(t3, 0, -t8 * t150 * t123 / 0.3e2 + t8 * t73 * t262 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t682);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t687 + 0.4e1 * t267;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t706 = my_piecewise3(t55, 0, 0.1e3 / 0.243e3 * t224);
  t707 = my_piecewise3(t57, t706, 0);
  t710 = t136 * t422;
  t711 = t173 * t710;
  t714 = t286 * t176;
  t715 = t173 * t714;
  t718 = t89 * t710;
  t721 = t278 * t197;
  t722 = t205 * t721;
  t723 = t622 * t722;
  t725 = t136 * t174;
  t727 = t89 * t725 * t618;
  t729 = t419 * t710;
  t731 = t278 * params->csk_a;
  t732 = t497 * t731;
  t736 = t725 * t197;
  t737 = t173 * t736;
  t738 = t737 * t464;
  t748 = t428 * t136;
  t749 = t748 * params->csk_a;
  t750 = t513 * t749;
  t753 = -t89 * t707 * t98 - 0.2e1 * t715 * t241 - t293 * t446 - t293 * t581 - 0.3e1 * t729 * t577 - 0.2e1 * t729 * t584 + 0.3e1 * t599 * t732 + 0.3e1 * t599 * t750 + 0.3e1 * t711 * t607 - 0.3e1 * t718 * t607 + 0.3e1 * t711 * t632 - t718 * t632 - t729 * t632 + 0.3e1 * t723 + 0.3e1 * t727 - 0.3e1 * t738;
  t754 = t89 * t714;
  t763 = t136 * t93 * t178;
  t764 = t89 * t763;
  t765 = t764 * t642;
  t767 = t737 * t456;
  t771 = t497 * t278;
  t777 = t182 * t286;
  t778 = t205 * t777;
  t781 = t513 * t748;
  t783 = t286 * t91;
  t785 = t89 * t783 * t199;
  t789 = t89 * t136 * t193 * t199;
  t791 = 0.2e1 * t234 * t778 + 0.2e1 * t754 * t241 + 0.2e1 * t754 * t252 - 0.2e1 * t715 * t257 + t450 * t279 + t282 * t446 + t282 * t676 + 0.3e1 * t711 * t577 - t599 * t781 - 0.2e1 * t718 * t652 - 0.3e1 * t655 * t771 - t291 + 0.3e1 * t765 - 0.3e1 * t767 - 0.2e1 * t785 - t789;
  t793 = my_piecewise5(t52, 0, t55, 0, t753 + t791);
  t795 = 0.1e3 / 0.243e3 * t227 - 0.25e2 / 0.81e2 * t230 + 0.5e1 / 0.54e2 * t30 * t129 * t210 + t167 * t139 + 0.2e1 * t87 * t297 + t47 * t793;
  t800 = my_piecewise3(t3, 0, -t8 * t150 * t141 / 0.3e2 + t8 * t73 * t299 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * t795);
  tv3rho2lapl0 = 0.2e1 * rho[0] * t800 + 0.4e1 * t304;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t807 = t30 * t223 * t121;
  t810 = t30 * t110 * t260;
  t813 = t310 * t197;
  t815 = t173 * t813 * t178;
  t816 = params->csk_a * t91;
  t817 = t816 * t463;
  t818 = t815 * t817;
  t820 = t310 * t93;
  t822 = t89 * t820 * t178;
  t823 = t816 * t197;
  t824 = t97 * t823;
  t825 = t822 * t824;
  t827 = t816 * t93;
  t828 = t183 * t827;
  t829 = t815 * t828;
  t831 = t310 * t422;
  t832 = t173 * t831;
  t834 = t91 * t62 * t96;
  t835 = t574 * t834;
  t838 = t419 * t831;
  t840 = t317 * t176;
  t841 = t89 * t840;
  t842 = t841 * t241;
  t843 = t173 * t840;
  t844 = t843 * t241;
  t845 = t475 * t834;
  t848 = t89 * t831;
  t851 = t528 * t91;
  t852 = t513 * t851;
  t855 = t518 * t91;
  t856 = t497 * t855;
  t859 = t843 * t257;
  t860 = t89 * t813;
  t862 = t188 * t251 * t93;
  t863 = t860 * t862;
  t865 = t97 * t245;
  t866 = t461 * t865;
  t869 = -0.2e1 * t254 * t866 + 0.3e1 * t832 * t835 + 0.3e1 * t832 * t845 + 0.3e1 * t832 * t856 - t838 * t835 - 0.2e1 * t838 * t852 - 0.3e1 * t848 * t845 - t319 - t321 - 0.3e1 * t818 + 0.3e1 * t825 - 0.3e1 * t829 + t842 - t844 - t859 + 0.3e1 * t863;
  t872 = t206 * t245;
  t873 = t205 * t872;
  t876 = t173 * t820;
  t877 = t182 * t91;
  t878 = t877 * t197;
  t879 = t205 * t878;
  t880 = t876 * t879;
  t882 = t514 * t91;
  t883 = t513 * t882;
  t888 = t497 * t256;
  t892 = t841 * t252;
  t893 = t501 * t251;
  t896 = t497 * t877;
  t901 = t91 * t422;
  t902 = t419 * t901;
  t903 = t428 * t310;
  t904 = t513 * t903;
  t906 = t182 * t317;
  t907 = t205 * t906;
  t908 = t234 * t907;
  t909 = t317 * t91;
  t911 = t89 * t909 * t199;
  t912 = t118 * t197;
  t913 = t89 * t912;
  t914 = t94 * t62;
  t915 = t96 * t245;
  t917 = t913 * t914 * t915;
  t918 = 0.2e1 * t917;
  t919 = t188 * t915;
  t922 = 0.2e1 * t239 * t866 + 0.2e1 * t239 * t919 + 0.2e1 * t254 * t663 - 0.2e1 * t254 * t873 - 0.3e1 * t832 * t896 - t848 * t835 - 0.3e1 * t838 * t856 + 0.3e1 * t838 * t883 + 0.3e1 * t838 * t888 - 0.2e1 * t848 * t893 - t902 * t904 + 0.3e1 * t880 + t892 + t908 - t911 - t918;
  t924 = my_piecewise5(t52, 0, t55, 0, t869 + t922);
  t926 = 0.8e2 / 0.243e3 * t807 - 0.1e2 / 0.81e2 * t810 + t87 * t327 + t47 * t924;
  t931 = my_piecewise3(t3, 0, t8 * t73 * t329 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t926);
  tv3rhosigma20 = 0.2e1 * rho[0] * t931 + 0.2e1 * t333;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t942 = t30 * t223 * t139;
  t945 = t30 * t110 * t297;
  t948 = t345 * t197;
  t949 = t173 * t948;
  t951 = t461 * t91 * t463;
  t952 = t949 * t951;
  t954 = t97 * params->csk_a;
  t955 = t248 * t197;
  t956 = t954 * t955;
  t957 = t764 * t956;
  t959 = t205 * t182;
  t960 = t959 * t827;
  t961 = t949 * t960;
  t963 = t710 * t424;
  t964 = t89 * t963;
  t965 = params->csk_a * t118;
  t966 = t965 * t91;
  t967 = t97 * t966;
  t970 = t419 * t963;
  t971 = t502 * t118;
  t973 = t971 * t183 * t91;
  t977 = t429 * t971 * t91;
  t980 = t173 * t638;
  t981 = t289 * t197;
  t982 = t183 * t981;
  t983 = t980 * t982;
  t985 = t572 * t424;
  t986 = t419 * t985;
  t987 = t136 * params->csk_a;
  t988 = t987 * t91;
  t989 = t429 * t988;
  t992 = t173 * t963;
  t995 = t89 * t948;
  t996 = t995 * t862;
  t998 = t971 * t834;
  t1000 = t183 * t988;
  t1009 = t497 * t278 * t91;
  t1012 = t348 * t91;
  t1013 = t501 * t1012;
  t1017 = 0.3e1 * t986 * t1000 - 0.3e1 * t592 * t1009 - 0.2e1 * t718 * t1013 - t715 * t343 - 0.3e1 * t964 * t967 - t964 * t998 + 0.3e1 * t992 * t967 - 0.3e1 * t970 * t973 - 0.2e1 * t970 * t977 - t970 * t998 + 0.3e1 * t992 * t973 + 0.3e1 * t986 * t989 + 0.3e1 * t992 * t998 - t319 - 0.3e1 * t952 + 0.3e1 * t957 - 0.3e1 * t961 + 0.3e1 * t983 + 0.3e1 * t996;
  t1021 = t600 * t136;
  t1022 = t513 * t1021;
  t1028 = t286 * t118;
  t1030 = t89 * t1028 * t199;
  t1031 = t136 * t245;
  t1033 = t89 * t1031 * t199;
  t1036 = -t902 * t1022 + t254 * t778 + t595 * t279 + t282 * t866 + t282 * t919 - t293 * t866 - t293 * t873 + t754 * t343 + t754 * t349 - t715 * t353 - t1030 - t1033 - t347 + t842 - t844 - t859 + t892 + t908 - t911;
  t1038 = my_piecewise5(t52, 0, t55, 0, t1017 + t1036);
  t1040 = -0.25e2 / 0.162e3 * t308 + 0.5e1 / 0.54e2 * t30 * t129 * t260 + 0.4e2 / 0.243e3 * t942 - 0.5e1 / 0.81e2 * t945 + t87 * t356 + t47 * t1038;
  t1045 = my_piecewise3(t3, 0, t8 * t73 * t358 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1040);
  tv3rhosigmalapl0 = 0.2e1 * rho[0] * t1045 + 0.2e1 * t362;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  t1056 = t367 * t197;
  t1058 = t173 * t1056 * t178;
  t1059 = t1058 * t817;
  t1061 = t367 * t93;
  t1063 = t89 * t1061 * t178;
  t1064 = t1063 * t824;
  t1066 = t1058 * t828;
  t1068 = t367 * t422;
  t1069 = t89 * t1068;
  t1072 = t173 * t1061;
  t1073 = t1072 * t879;
  t1075 = t419 * t1068;
  t1078 = t189 * t286;
  t1079 = t188 * t1078;
  t1082 = t173 * t1068;
  t1085 = t89 * t1056;
  t1086 = t1085 * t862;
  t1092 = t206 * t286;
  t1099 = -0.2e1 * t293 * t205 * t1092 - 0.3e1 * t1069 * t845 - t1075 * t835 - 0.2e1 * t1075 * t852 - 0.3e1 * t1075 * t856 + 0.3e1 * t1075 * t883 + 0.2e1 * t282 * t1079 - 0.2e1 * t293 * t1079 + 0.3e1 * t1082 * t856 - 0.3e1 * t1059 + 0.3e1 * t1064 - 0.3e1 * t1066 + 0.3e1 * t1073 + 0.3e1 * t1086 - t319 - t374;
  t1113 = t428 * t367;
  t1114 = t513 * t1113;
  t1116 = t136 * t197;
  t1117 = t89 * t1116;
  t1118 = t96 * t286;
  t1120 = t1117 * t914 * t1118;
  t1121 = 0.2e1 * t1120;
  t1125 = 0.2e1 * t282 * t188 * t1118 - t1069 * t835 - 0.2e1 * t1069 * t893 + 0.3e1 * t1075 * t888 + 0.3e1 * t1082 * t835 + 0.3e1 * t1082 * t845 - 0.3e1 * t1082 * t896 - t902 * t1114 + 0.2e1 * t293 * t778 - t1121 + t842 - t844 - t859 + t892 + t908 - t911;
  t1127 = my_piecewise5(t52, 0, t55, 0, t1099 + t1125);
  t1129 = -0.25e2 / 0.81e2 * t339 + 0.5e1 / 0.27e2 * t30 * t129 * t297 + t87 * t380 + t47 * t1127;
  t1134 = my_piecewise3(t3, 0, t8 * t73 * t382 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * t1129);
  tv3rholapl20 = 0.2e1 * rho[0] * t1134 + 0.2e1 * t386;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1138 = t30 * t110 * t327;
  t1140 = t310 * t118;
  t1149 = t189 * t317;
  t1150 = t188 * t1149;
  t1151 = t239 * t1150;
  t1152 = 0.3e1 * t1151;
  t1153 = t843 * t353;
  t1154 = 0.3e1 * t1153;
  t1155 = t1140 * t197;
  t1156 = t173 * t1155;
  t1157 = t1156 * t456;
  t1158 = 0.3e1 * t1157;
  t1159 = t843 * t343;
  t1160 = 0.3e1 * t1159;
  t1161 = t1156 * t464;
  t1162 = 0.3e1 * t1161;
  t1163 = t1140 * t93;
  t1165 = t89 * t1163 * t470;
  t1166 = 0.3e1 * t1165;
  t1167 = t1140 * t422;
  t1168 = t419 * t1167;
  t1173 = -0.3e1 * t173 * t1140 * t437 - t419 * t1140 * t430 - 0.2e1 * t89 * t1140 * t441 - 0.3e1 * t1168 * t519 - 0.2e1 * t1168 * t529 + t1152 - t1154 - t1158 - t1160 - t1162 + t1166 - t319 - t321;
  t1174 = t254 * t907;
  t1175 = 0.3e1 * t1174;
  t1178 = t173 * t1167;
  t1181 = t317 * t118;
  t1183 = t89 * t1181 * t199;
  t1184 = 0.3e1 * t1183;
  t1185 = t841 * t349;
  t1186 = 0.3e1 * t1185;
  t1187 = t89 * t1155;
  t1188 = t1187 * t493;
  t1189 = 0.3e1 * t1188;
  t1191 = t173 * t1163 * t485;
  t1192 = 0.3e1 * t1191;
  t1195 = t89 * t1167;
  t1204 = 0.3e1 * t1168 * t498 - t1168 * t504 + 0.3e1 * t1168 * t515 + 0.3e1 * t1178 * t476 + 0.3e1 * t1178 * t504 + 0.3e1 * t1178 * t519 - 0.3e1 * t1195 * t476 - t1195 * t504 + t1175 - t1184 + t1186 + t1189 + t1192;
  t1206 = my_piecewise5(t52, 0, t55, 0, t1173 + t1204);
  t1208 = -0.5e1 / 0.27e2 * t1138 + t47 * t1206;
  t1212 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1208);
  tv3sigma30 = 0.2e1 * rho[0] * t1212;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1218 = t30 * t110 * t356;
  t1220 = t136 * t310;
  t1221 = t1220 * t197;
  t1222 = t173 * t1221;
  t1223 = t1222 * t464;
  t1224 = 0.3e1 * t1223;
  t1225 = params->csk_a * t310;
  t1226 = t1225 * t197;
  t1227 = t97 * t1226;
  t1228 = t764 * t1227;
  t1229 = 0.3e1 * t1228;
  t1230 = t1222 * t456;
  t1231 = 0.3e1 * t1230;
  t1234 = t282 * t1150;
  t1235 = t518 * t310;
  t1236 = t497 * t1235;
  t1239 = t293 * t1150;
  t1242 = t475 * t310 * t62 * t96;
  t1247 = t89 * t1220;
  t1248 = t1247 * t618;
  t1249 = 0.3e1 * t1248;
  t1250 = t876 * t722;
  t1251 = 0.3e1 * t1250;
  t1254 = t503 * t310;
  t1255 = t501 * t1254;
  t1260 = 0.3e1 * t711 * t1236 + 0.3e1 * t711 * t1242 - 0.3e1 * t718 * t1242 + 0.3e1 * t711 * t1255 - t718 * t1255 - t729 * t1255 + 0.3e1 * t838 * t732 + 0.3e1 * t838 * t750 - t1224 + t1229 - t1231 + t1234 - t1239 + t1249 + t1251 - t319;
  t1261 = 0.2e1 * t1151;
  t1262 = 0.2e1 * t1153;
  t1263 = 0.2e1 * t1159;
  t1266 = t206 * t317;
  t1267 = t205 * t1266;
  t1268 = t293 * t1267;
  t1269 = t528 * t310;
  t1270 = t513 * t1269;
  t1273 = 0.2e1 * t1174;
  t1274 = 0.2e1 * t1183;
  t1275 = 0.2e1 * t1185;
  t1276 = t843 * t279;
  t1278 = t136 * t317;
  t1280 = t89 * t1278 * t199;
  t1281 = t96 * t317;
  t1282 = t188 * t1281;
  t1283 = t282 * t1282;
  t1284 = t96 * t310;
  t1285 = t501 * t1284;
  t1290 = -0.3e1 * t729 * t1236 - 0.2e1 * t729 * t1270 - 0.2e1 * t718 * t1285 - 0.3e1 * t832 * t771 - t838 * t781 + t1261 - t1262 - t1263 - t1268 + t1273 - t1274 + t1275 + t1276 - t1280 + t1283 - t347;
  t1292 = my_piecewise5(t52, 0, t55, 0, t1260 + t1290);
  t1294 = 0.5e1 / 0.54e2 * t30 * t129 * t327 - 0.1e2 / 0.81e2 * t1218 + t47 * t1292;
  t1298 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1294);
  tv3sigma2lapl0 = 0.2e1 * rho[0] * t1298;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  t1304 = t30 * t110 * t380;
  t1306 = t965 * t93;
  t1308 = t1058 * t183 * t1306;
  t1309 = 0.3e1 * t1308;
  t1311 = t1058 * t965 * t463;
  t1312 = 0.3e1 * t1311;
  t1313 = t965 * t197;
  t1314 = t97 * t1313;
  t1315 = t1063 * t1314;
  t1316 = 0.3e1 * t1315;
  t1317 = t183 * t118;
  t1318 = t574 * t1317;
  t1321 = t528 * t118;
  t1325 = t1072 * t624;
  t1326 = 0.3e1 * t1325;
  t1332 = t188 * t348 * t93;
  t1333 = t1085 * t1332;
  t1334 = 0.3e1 * t1333;
  t1338 = t501 * t503 * t118;
  t1344 = t118 * t62 * t96;
  t1345 = t475 * t1344;
  t1348 = -0.2e1 * t1075 * t513 * t1321 - t1069 * t1338 - 0.3e1 * t1075 * t1318 - t1075 * t1338 + 0.3e1 * t1075 * t602 + 0.3e1 * t1075 * t627 + 0.3e1 * t1082 * t1318 + 0.3e1 * t1082 * t1338 + 0.3e1 * t1082 * t1345 - t1309 - t1312 + t1316 + t1326 + t1334 - t319 - t374;
  t1351 = 0.2e1 * t1234;
  t1352 = 0.2e1 * t1239;
  t1353 = 0.2e1 * t1268;
  t1354 = 0.2e1 * t1276;
  t1355 = 0.2e1 * t1280;
  t1356 = 0.2e1 * t1283;
  t1363 = -0.2e1 * t1069 * t501 * t348 - 0.3e1 * t1069 * t1345 - 0.3e1 * t1082 * t656 - t573 * t1114 + t1151 - t1153 - t1159 + t1174 - t1183 + t1185 + t1351 - t1352 - t1353 + t1354 - t1355 + t1356;
  t1365 = my_piecewise5(t52, 0, t55, 0, t1348 + t1363);
  t1367 = 0.5e1 / 0.27e2 * t30 * t129 * t356 - 0.5e1 / 0.81e2 * t1304 + t47 * t1365;
  t1371 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1367);
  tv3sigmalapl20 = 0.2e1 * rho[0] * t1371;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  t1376 = t367 * t136;
  t1385 = t1376 * t197;
  t1386 = t173 * t1385;
  t1387 = t1386 * t456;
  t1388 = 0.3e1 * t1387;
  t1389 = t1386 * t464;
  t1390 = 0.3e1 * t1389;
  t1391 = t1376 * t93;
  t1393 = t89 * t1391 * t470;
  t1394 = 0.3e1 * t1393;
  t1395 = 0.3e1 * t1234;
  t1396 = 0.3e1 * t1239;
  t1397 = 0.3e1 * t1268;
  t1398 = 0.3e1 * t1276;
  t1399 = 0.3e1 * t1280;
  t1400 = -0.3e1 * t173 * t1376 * t437 - t419 * t1376 * t430 - 0.2e1 * t89 * t1376 * t441 - t1388 - t1390 + t1394 + t1395 - t1396 - t1397 + t1398 - t1399 - t319 - t374;
  t1401 = 0.3e1 * t1283;
  t1402 = t1376 * t422;
  t1403 = t89 * t1402;
  t1406 = t419 * t1402;
  t1413 = t173 * t1402;
  t1416 = t89 * t1385;
  t1417 = t1416 * t493;
  t1418 = 0.3e1 * t1417;
  t1420 = t173 * t1391 * t485;
  t1421 = 0.3e1 * t1420;
  t1430 = -0.3e1 * t1403 * t476 - t1403 * t504 + 0.3e1 * t1406 * t498 - t1406 * t504 + 0.3e1 * t1406 * t515 - 0.3e1 * t1406 * t519 - 0.2e1 * t1406 * t529 + 0.3e1 * t1413 * t476 + 0.3e1 * t1413 * t504 + 0.3e1 * t1413 * t519 + t1401 + t1418 + t1421;
  t1432 = my_piecewise5(t52, 0, t55, 0, t1400 + t1430);
  t1434 = 0.5e1 / 0.18e2 * t30 * t129 * t380 + t47 * t1432;
  t1438 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * t1434);
  tv3lapl30 = 0.2e1 * rho[0] * t1438;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t1460 = t30 * t33 / t23 / t157 / t34;
  t1466 = 0.154e5 / 0.2187e4 * t30 * t40 * t403 - 0.10472e6 / 0.6561e4 * t1460;
  t1474 = t193 * t193;
  t1475 = t89 * t1474;
  t1483 = t171 * t171;
  t1485 = t64 / t1483;
  t1486 = t174 * t174;
  t1488 = t176 * t176;
  t1489 = t177 * t177;
  t1490 = 0.1e1 / t1489;
  t1491 = t1488 * t1490;
  t1492 = t180 * t180;
  t1493 = t181 * t181;
  t1494 = 0.1e1 / t1493;
  t1495 = t1492 * t1494;
  t1496 = t1491 * t1495;
  t1498 = my_piecewise3(t55, 0, t1466);
  t1499 = my_piecewise3(t57, t1498, 0);
  t1502 = t89 * t1486;
  t1503 = t1491 * t97;
  t1506 = t197 * t197;
  t1507 = t1506 * t178;
  t1508 = t1507 * t97;
  t1511 = t173 * t1486;
  t1512 = t1507 * t183;
  t1515 = t1491 * t183;
  t1519 = t1491 * t429;
  t1526 = t193 * t93;
  t1528 = t173 * t1526 * t178;
  t1531 = t183 * t641;
  t1536 = params->csk_a * t197;
  t1538 = t97 * t1536 * t193;
  t1541 = t433 * t176;
  t1542 = t89 * t1541;
  t1545 = t193 * t422;
  t1546 = t173 * t1545;
  t1549 = t1486 * t197;
  t1550 = t173 * t1549;
  t1552 = t176 * t62 * t96;
  t1553 = t475 * t1552;
  t1556 = t1486 * t176;
  t1557 = t89 * t1556;
  t1558 = t501 * t469;
  t1561 = 0.18e2 * t89 * t621 * t178 * t1538 - 0.18e2 * t1528 * t1531 - 0.18e2 * t1528 * t642 + 0.4e1 * t1542 * t241 + 0.18e2 * t1546 * t607 + 0.18e2 * t1550 * t1553 - 0.18e2 * t1557 * t1558 - t200 - 0.4e1 * t457 - 0.4e1 * t465 + 0.4e1 * t471;
  t1563 = t89 * t598;
  t1565 = t501 * t503 * t193;
  t1570 = t419 * t1545;
  t1573 = t574 * t1552;
  t1576 = t419 * t1549;
  t1580 = t501 * t503 * t197;
  t1583 = t428 * t193;
  t1585 = t513 * t1583 * params->csk_a;
  t1590 = t173 * t1556;
  t1592 = t497 * t518 * t197;
  t1595 = t501 * t445;
  t1600 = t205 * t484 * t193;
  t1603 = t419 * t1556;
  t1604 = t428 * t197;
  t1606 = t513 * t1604 * params->csk_a;
  t1610 = t497 * t518 * t193;
  t1614 = t497 * t484 * params->csk_a;
  t1618 = t176 * t180 * t182;
  t1619 = t574 * t1618;
  t1622 = t173 * t1541;
  t1627 = t497 * t580;
  t1634 = t188 * t651 * t197;
  t1638 = t513 * t528 * t176;
  t1641 = 0.18e2 * t89 * t1526 * t1634 - 0.18e2 * t1570 * t577 - 0.18e2 * t1576 * t1619 - 0.12e2 * t1576 * t1638 + 0.18e2 * t622 * t1600 + 0.18e2 * t1603 * t1606 + 0.18e2 * t1603 * t1614 + 0.18e2 * t655 * t1610 - 0.4e1 * t1622 * t241 - 0.4e1 * t1622 * t257 + 0.18e2 * t599 * t1627;
  t1647 = t1486 * t1488;
  t1648 = t1485 * t1647;
  t1649 = t502 * params->csk_a;
  t1650 = t1490 * t1649;
  t1651 = t1650 * t429;
  t1654 = t1490 * t1492;
  t1655 = t1494 * t1649;
  t1656 = t1654 * t1655;
  t1659 = t173 * t1647;
  t1660 = t1490 * t180;
  t1661 = t182 * t1649;
  t1662 = t1660 * t1661;
  t1665 = t419 * t1647;
  t1670 = t1494 * t502;
  t1671 = t1654 * t1670;
  t1677 = t1490 * t426;
  t1678 = t1677 * t528;
  t1681 = t1494 * params->csk_a;
  t1682 = t1654 * t1681;
  t1693 = t1660 * t206;
  t1696 = t1660 * t518;
  t1699 = t497 * t509;
  t1706 = t96 * t176;
  t1707 = t501 * t1706;
  t1710 = t1486 * t1506;
  t1711 = t173 * t1710;
  t1716 = 0.4e1 * t234 * t205 * t182 * t433 - 0.4e1 * t89 * t433 * t91 * t199 - 0.12e2 * t89 * t1545 * t652 - 0.12e2 * t89 * t1549 * t1707 + 0.18e2 * t1648 * t1678 - 0.6e1 * t1648 * t1682 + 0.7e1 * t1659 * t1693 - 0.11e2 * t1659 * t1696 - 0.18e2 * t655 * t1699 - 0.3e1 * t1711 * t190 - 0.3e1 * t1711 * t207;
  t1718 = t1490 * params->csk_a;
  t1719 = t1718 * t97;
  t1725 = t89 * t1647;
  t1728 = t497 * t484;
  t1736 = t1474 * t176;
  t1737 = t173 * t1736;
  t1743 = t513 * t1604;
  t1750 = -0.6e1 * t599 * t513 * t1583 + 0.3e1 * t89 * t1710 * t190 + 0.3e1 * t89 * t1736 * t190 + 0.4e1 * t1542 * t252 - 0.18e2 * t1590 * t1728 - 0.6e1 * t1603 * t1743 - 0.11e2 * t1659 * t1719 - 0.18e2 * t1665 * t1693 + 0.11e2 * t1725 * t1719 - 0.3e1 * t1737 * t190 - 0.3e1 * t1737 * t207;
  t1751 = t1490 * t62;
  t1752 = t96 * t1649;
  t1753 = t1751 * t1752;
  t1762 = t1490 * t502;
  t1763 = t1762 * t97;
  t1768 = t1677 * t514;
  t1777 = 0.7e1 * t1648 * t1696 - t1648 * t1753 - 0.6e1 * t1648 * t1768 - 0.7e1 * t1659 * t1753 - 0.18e2 * t1659 * t1763 - 0.6e1 * t1665 * t1678 + 0.6e1 * t1665 * t1753 + 0.6e1 * t1665 * t1763 - 0.12e2 * t1665 * t1768 + t1725 * t1753 + 0.6e1 * t1725 * t1763;
  t1781 = my_piecewise5(t52, 0, t55, 0, 0.3e1 * t1475 * t201 - 0.7e1 * t1659 * t1662 + 0.18e2 * t1665 * t1662 - 0.7e1 * t1648 * t1662 + 0.11e2 * t1648 * t1671 + 0.12e2 * t1665 * t1651 - 0.12e2 * t1648 * t1651 - 0.6e1 * t1648 * t1656 - 0.6e1 * t1576 * t1573 - 0.6e1 * t1557 * t1580 + 0.18e2 * t599 * t1585 - 0.12e2 * t1570 * t584 + 0.18e2 * t1590 * t1592 - 0.18e2 * t1563 * t1595 - 0.6e1 * t1563 * t1565 + 0.18e2 * t1546 * t632 - 0.6e1 * t1570 * t632 + 0.18e2 * t1550 * t1573 + 0.6e1 * t1502 * t1503 + 0.3e1 * t1502 * t1508 + 0.3e1 * t1511 * t1512 + 0.11e2 * t1511 * t1515 - 0.3e1 * t1475 * t199 - 0.5e1 * t524 + 0.4e1 * t494 + 0.4e1 * t486 + t1777 + t1750 + t1716 + t1641 + t1561 + 0.3e1 * t173 * t1474 * t184 + t1485 * t1486 * t1496 - t89 * t1499 * t98 + 0.6e1 * t419 * t1486 * t1519);
  t1788 = my_piecewise3(t3, 0, -0.14e2 / 0.135e3 * t8 * t21 / t22 / t77 * t67 + 0.8e1 / 0.45e2 * t8 * t391 * t102 - t8 * t150 * t212 / 0.5e1 + 0.2e1 / 0.5e1 * t8 * t73 * t536 + 0.3e1 / 0.2e2 * t8 * t24 * (0.1309e5 / 0.729e3 * t1460 + t1466 * t65 + 0.4e1 * t411 * t100 + 0.6e1 * t167 * t210 + 0.4e1 * t87 * t534 + t47 * t1781));
  tv4rho40 = 0.2e1 * rho[0] * t1788 + 0.8e1 * t541;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1801 = t32 * t403;
  t1802 = t30 * t1801;
  t1822 = my_piecewise3(t55, 0, 0.616e4 / 0.2187e4 * t1802);
  t1823 = my_piecewise3(t57, t1822, 0);
  t1831 = params->csk_a * t193;
  t1833 = t251 * t197;
  t1834 = t1831 * t62 * t1833;
  t1840 = params->csk_a * t93;
  t1841 = t1840 * t193;
  t1842 = t959 * t1841;
  t1845 = t173 * t985;
  t1847 = t502 * t193 * t91;
  t1848 = t183 * t1847;
  t1851 = t118 * t420;
  t1852 = t1851 * t197;
  t1856 = t419 * t1852;
  t1859 = t245 * t174;
  t1864 = -0.9e1 * t173 * t1859 * t197 * t456 + 0.18e2 * t173 * t1852 * t1553 - 0.9e1 * t173 * t955 * t1842 - t89 * t1823 * t98 - 0.18e2 * t1856 * t1619 + 0.9e1 * t639 * t1834 - 0.9e1 * t980 * t1834 + 0.9e1 * t1845 * t1848 + 0.4e1 * t619 + 0.4e1 * t625 + 0.4e1 * t643 - 0.4e1 * t647 - 0.4e1 * t649;
  t1865 = t420 * t176;
  t1867 = t419 * t1865 * t424;
  t1868 = t429 * t1313;
  t1874 = t245 * t93 * t178;
  t1878 = t238 * t424;
  t1879 = t89 * t1878;
  t1881 = t502 * t420 * t197;
  t1882 = t97 * t1881;
  t1885 = t173 * t1878;
  t1888 = t183 * t1313;
  t1893 = t97 * params->csk_a * t420 * t197;
  t1896 = t419 * t1878;
  t1899 = t1831 * t834;
  t1902 = t173 * t1874;
  t1906 = t419 * t901 * t424;
  t1907 = t965 * t193;
  t1911 = t429 * t1847;
  t1914 = t89 * t985;
  t1915 = t97 * t1847;
  t1920 = 0.9e1 * t89 * t1874 * t642 + 0.9e1 * t1906 * t429 * t1907 - 0.12e2 * t1856 * t1638 + 0.9e1 * t1845 * t1899 + 0.9e1 * t1845 * t1915 + 0.18e2 * t1867 * t1868 + 0.18e2 * t1867 * t1888 - 0.6e1 * t1879 * t1882 - 0.18e2 * t1879 * t1893 + 0.18e2 * t1885 * t1882 - 0.6e1 * t1896 * t1882 - 0.9e1 * t1902 * t642 - 0.6e1 * t986 * t1911 - 0.3e1 * t1914 * t1915;
  t1926 = t91 * t93;
  t1928 = t173 * t1926 * t178;
  t1929 = t912 * t193;
  t1936 = t183 * t1881;
  t1943 = t188 * t492 * t193;
  t1946 = t118 * t1488;
  t1947 = t419 * t1946;
  t1948 = t428 * t1649;
  t1950 = t1677 * t1948 * t420;
  t1953 = t89 * t1946;
  t1955 = t1751 * t503 * t420;
  t1958 = t173 * t1946;
  t1961 = t420 * t1488;
  t1962 = t419 * t1961;
  t1963 = t1660 * t352;
  t1967 = t1751 * t1752 * t420;
  t1973 = 0.9e1 * t1906 * t183 * t1907 + 0.9e1 * t1928 * t183 * t1929 + 0.9e1 * t89 * t955 * t1943 - 0.9e1 * t986 * t1848 + 0.18e2 * t1885 * t1936 - 0.9e1 * t1914 * t1899 - 0.3e1 * t986 * t1915 + 0.12e2 * t1947 * t1950 + 0.6e1 * t1947 * t1967 + 0.6e1 * t1953 * t1955 + t1953 * t1967 - 0.18e2 * t1958 * t1955 - 0.7e1 * t1958 * t1967 - 0.18e2 * t1962 * t1963;
  t1974 = t1485 * t1946;
  t1976 = t245 * t422;
  t1977 = t173 * t1976;
  t1980 = t419 * t1976;
  t1985 = t1718 * t420 * t62 * t96;
  t1988 = t1485 * t1961;
  t1990 = t1660 * t235 * t502;
  t1993 = t568 * t176;
  t1994 = t89 * t1993;
  t1997 = t173 * t1851;
  t1998 = t1507 * t954;
  t2004 = t1677 * t528 * t420;
  t2007 = t89 * t1851;
  t2013 = t197 * t424 * t1552;
  t2016 = t183 * params->csk_a;
  t2017 = t1507 * t2016;
  t2022 = 0.6e1 * t1947 * t1955 - 0.6e1 * t1947 * t2004 + 0.11e2 * t1953 * t1985 - 0.11e2 * t1958 * t1985 - t1974 * t1967 + 0.9e1 * t1977 * t607 + 0.9e1 * t1977 * t632 - 0.3e1 * t1980 * t632 + 0.7e1 * t1988 * t1990 + 0.3e1 * t1994 * t241 - 0.3e1 * t1997 * t1998 - 0.3e1 * t1997 * t2017 + 0.3e1 * t2007 * t1998 - 0.12e2 * t2007 * t2013;
  t2027 = t1650 * t420 * t180 * t182;
  t2035 = t173 * t1865;
  t2040 = t501 * t251 * t193;
  t2044 = t205 * t662 * t197;
  t2047 = t419 * t1865;
  t2049 = t513 * t600 * t197;
  t2052 = t173 * t901;
  t2057 = t173 * t1993;
  t2062 = t497 * t872;
  t2067 = t89 * t1976;
  t2070 = -0.9e1 * t2052 * t497 * t235 * t193 + 0.9e1 * t89 * t1859 * t618 - 0.18e2 * t2035 * t497 * t623 + 0.18e2 * t1947 * t2027 - 0.7e1 * t1974 * t2027 - 0.9e1 * t1980 * t577 - 0.6e1 * t612 * t2040 + 0.9e1 * t622 * t2044 - 0.6e1 * t2047 * t2049 - 0.3e1 * t2057 * t241 + 0.9e1 * t599 * t2062 - 0.9e1 * t2067 * t607 - 0.3e1 * t595 * t446;
  t2071 = t173 * t1961;
  t2075 = t1660 * t518 * t420;
  t2080 = t1494 * t118;
  t2082 = t1654 * t2080 * params->csk_a;
  t2094 = t188 * t189 * t433;
  t2096 = t428 * t245;
  t2098 = t513 * t2096 * params->csk_a;
  t2107 = t205 * t206 * t433;
  t2111 = -0.3e1 * t902 * t513 * t1583 * t118 - 0.12e2 * t1974 * t1950 - 0.11e2 * t1958 * t2075 + 0.7e1 * t2071 * t1963 + 0.9e1 * t1977 * t577 - 0.6e1 * t1980 * t584 - 0.6e1 * t1988 * t2082 - 0.3e1 * t2057 * t257 + t239 * t2094 - t254 * t2094 + 0.9e1 * t599 * t2098 - t254 * t2107 + 0.3e1 * t588 * t446 - 0.3e1 * t595 * t581;
  t2118 = t1654 * t1655 * t420;
  t2121 = t1677 * t601;
  t2126 = t1677 * t1321;
  t2138 = t188 * t96 * t433;
  t2143 = 0.11e2 * t1988 * t1654 * t2080 * t502 + t1622 * t236 - 0.7e1 * t1958 * t2027 - 0.12e2 * t1962 * t2121 - 0.6e1 * t1974 * t2118 - 0.6e1 * t1988 * t2121 + 0.18e2 * t1988 * t2126 + 0.3e1 * t1994 * t252 - 0.3e1 * t2067 * t632 + t239 * t2138 + 0.3e1 * t588 * t676 - t250 - 0.3e1 * t670 - 0.2e1 * t674;
  t2146 = t513 * t2096;
  t2159 = t205 * t182 * t568;
  t2171 = t497 * t662;
  t2174 = t1677 * t600;
  t2178 = t173 * t420 * t1506;
  t2183 = t96 * t420;
  t2184 = t1751 * t2183;
  t2187 = 0.3e1 * t450 * t663 - 0.3e1 * t599 * t2146 + t1988 * t1654 * t2080 - 0.3e1 * t89 * t245 * t193 * t199 - t89 * t118 * t433 * t199 + 0.3e1 * t234 * t2159 - 0.3e1 * t89 * t568 * t91 * t199 - 0.6e1 * t2067 * t652 + 0.11e2 * t2071 * t1660 * t235 - 0.9e1 * t655 * t2171 + 0.6e1 * t1962 * t2174 + 0.3e1 * t2178 * t236 + 0.3e1 * t2007 * t1508 + 0.6e1 * t1953 * t2184;
  t2191 = my_piecewise5(t52, 0, t55, 0, t1864 + t1920 + t1973 + t2022 + t2070 + t2111 + t2143 + t2187);
  t2198 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t391 * t123 - t8 * t150 * t262 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t73 * t682 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.77e3 / 0.243e3 * t1802 + 0.616e4 / 0.2187e4 * t30 * t1801 * t65 - 0.44e3 / 0.243e3 * t30 * t551 * t100 + 0.4e2 / 0.81e2 * t30 * t223 * t210 - 0.5e1 / 0.81e2 * t30 * t110 * t534 + t411 * t121 + 0.3e1 * t167 * t260 + 0.3e1 * t87 * t680 + t47 * t2191));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2198 + 0.6e1 * t687;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2223 = my_piecewise3(t55, 0, -0.11e4 / 0.729e3 * t552);
  t2224 = my_piecewise3(t57, t2223, 0);
  t2232 = t173 * t981;
  t2235 = t461 * t93;
  t2237 = t2235 * t97 * t193;
  t2242 = t286 * t174;
  t2244 = t173 * t2242 * t197;
  t2247 = t1116 * params->csk_a;
  t2248 = t429 * t2247;
  t2251 = t136 * t420;
  t2252 = t2251 * t197;
  t2253 = t419 * t2252;
  t2257 = t183 * t1116 * t193;
  t2262 = -t89 * t2224 * t98 - 0.12e2 * t2253 * t1638 + 0.9e1 * t764 * t1834 - 0.9e1 * t2232 * t1842 + 0.9e1 * t992 * t1848 + 0.18e2 * t1867 * t2248 + 0.9e1 * t1928 * t2257 - 0.9e1 * t2232 * t2237 - 0.9e1 * t2244 * t456 - 0.9e1 * t2244 * t464 + 0.4e1 * t723 + 0.4e1 * t727 - 0.4e1 * t738;
  t2263 = t183 * t2247;
  t2272 = t173 * t2252;
  t2277 = t281 * t424;
  t2278 = t89 * t2277;
  t2285 = t987 * t193;
  t2286 = t429 * t2285;
  t2298 = 0.9e1 * t89 * t981 * t1943 - 0.6e1 * t2253 * t1573 + 0.18e2 * t2272 * t1573 - 0.18e2 * t2253 * t1619 - 0.9e1 * t970 * t1848 + 0.18e2 * t1867 * t2263 - 0.6e1 * t2278 * t1882 - 0.18e2 * t2278 * t1893 - 0.9e1 * t964 * t1899 + 0.9e1 * t992 * t1899 + 0.9e1 * t1906 * t2286 - 0.6e1 * t970 * t1911 - 0.3e1 * t964 * t1915 + 0.9e1 * t992 * t1915;
  t2302 = t183 * t2285;
  t2307 = t89 * t286 * t93 * t178;
  t2310 = t173 * t2277;
  t2315 = t136 * t1488;
  t2316 = t419 * t2315;
  t2319 = t89 * t2251;
  t2322 = t173 * t2251;
  t2325 = t497 * t721;
  t2330 = t173 * t2315;
  t2333 = t89 * t2315;
  t2339 = 0.18e2 * t2272 * t1553 + 0.9e1 * t1906 * t2302 - 0.3e1 * t970 * t1915 + 0.18e2 * t2310 * t1936 - 0.7e1 * t2330 * t1967 + t2333 * t1967 - 0.11e2 * t2330 * t1985 + 0.11e2 * t2333 * t1985 + 0.3e1 * t2319 * t1998 - 0.3e1 * t2322 * t1998 - 0.6e1 * t2316 * t2004 - 0.3e1 * t2322 * t2017 - 0.18e2 * t2035 * t2325 + 0.9e1 * t2307 * t642;
  t2344 = t286 * t422;
  t2345 = t173 * t2344;
  t2348 = t419 * t2344;
  t2355 = t1485 * t2315;
  t2359 = t497 * t1092;
  t2364 = t89 * t2344;
  t2367 = t1660 * t731;
  t2372 = t707 * t176;
  t2373 = t173 * t2372;
  t2376 = 0.12e2 * t2316 * t1950 + 0.6e1 * t2316 * t1955 - 0.18e2 * t2330 * t1955 + 0.6e1 * t2333 * t1955 + 0.6e1 * t2316 * t1967 - t2355 * t1967 + 0.7e1 * t2071 * t2367 - 0.11e2 * t2330 * t2075 + 0.9e1 * t2345 * t632 - 0.9e1 * t2348 * t577 - 0.3e1 * t2348 * t632 + 0.9e1 * t599 * t2359 - 0.9e1 * t2364 * t607 - 0.3e1 * t2373 * t257;
  t2393 = t1494 * t136;
  t2395 = t1654 * t2393 * t502;
  t2400 = t428 * t286;
  t2402 = t513 * t2400 * params->csk_a;
  t2406 = t1654 * t2393 * params->csk_a;
  t2410 = t1660 * t278 * t502;
  t2415 = -0.12e2 * t282 * t501 * t2183 * t197 - 0.12e2 * t2355 * t1950 + 0.11e2 * t1988 * t2395 - 0.6e1 * t1988 * t2406 + 0.7e1 * t1988 * t2410 - 0.7e1 * t2355 * t2027 - t293 * t2094 - t293 * t2107 - 0.6e1 * t2355 * t2118 + 0.9e1 * t2345 * t607 - 0.6e1 * t2348 * t584 + 0.9e1 * t599 * t2402 - 0.3e1 * t715 * t581;
  t2416 = t1677 * t749;
  t2420 = t1677 * t748 * t502;
  t2432 = t205 * t777 * t197;
  t2436 = t513 * t748 * t197;
  t2440 = t497 * t278 * t193;
  t2454 = 0.9e1 * t89 * t2242 * t618 - 0.18e2 * t1962 * t2367 - 0.12e2 * t1962 * t2416 - 0.6e1 * t1988 * t2416 + 0.18e2 * t1988 * t2420 + 0.18e2 * t2316 * t2027 - 0.7e1 * t2330 * t2027 - 0.6e1 * t718 * t2040 - 0.6e1 * t2047 * t2436 - 0.9e1 * t2052 * t2440 - 0.3e1 * t2364 * t632 - 0.3e1 * t2373 * t241 + 0.9e1 * t622 * t2432 - 0.3e1 * t715 * t446;
  t2456 = t89 * t2372;
  t2474 = t513 * t2400;
  t2477 = t1654 * t2393;
  t2483 = -0.3e1 * t902 * t513 * t1583 * t136 - 0.3e1 * t89 * t286 * t193 * t199 + t1988 * t2477 + t282 * t2094 + 0.9e1 * t2345 * t577 + 0.3e1 * t2456 * t241 + 0.3e1 * t2456 * t252 - 0.3e1 * t599 * t2474 + 0.3e1 * t754 * t446 - t291 + 0.4e1 * t765 - 0.4e1 * t767 - 0.3e1 * t785 - 0.2e1 * t789;
  t2489 = t205 * t182 * t707;
  t2498 = t1660 * t278;
  t2501 = t497 * t777;
  t2504 = t1677 * t748;
  t2518 = -t89 * t136 * t433 * t199 - 0.3e1 * t89 * t707 * t91 * t199 + 0.3e1 * t2319 * t1508 + t1622 * t279 + 0.6e1 * t1962 * t2504 + 0.11e2 * t2071 * t2498 + t282 * t2138 + 0.3e1 * t2178 * t279 + 0.6e1 * t2333 * t2184 + 0.3e1 * t234 * t2489 - 0.6e1 * t2364 * t652 - 0.9e1 * t655 * t2501 + 0.3e1 * t450 * t778 + 0.3e1 * t754 * t676;
  t2522 = my_piecewise5(t52, 0, t55, 0, t2262 + t2298 + t2339 + t2376 + t2415 + t2454 + t2483 + t2518);
  t2529 = my_piecewise3(t3, 0, 0.2e1 / 0.45e2 * t8 * t391 * t141 - t8 * t150 * t299 / 0.1e2 + 0.3e1 / 0.1e2 * t8 * t73 * t795 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.11e4 / 0.729e3 * t555 + 0.1e3 / 0.81e2 * t558 - 0.25e2 / 0.54e2 * t561 + 0.5e1 / 0.54e2 * t30 * t129 * t534 + t411 * t139 + 0.3e1 * t167 * t297 + 0.3e1 * t87 * t793 + t47 * t2522));
  tv4rho3lapl0 = 0.2e1 * rho[0] * t2529 + 0.6e1 * t800;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t2551 = t245 * t245;
  t2552 = t89 * t2551;
  t2560 = t912 * t178;
  t2561 = t173 * t2560;
  t2562 = t1926 * t245;
  t2570 = t91 * t197 * t245;
  t2571 = t954 * t2570;
  t2574 = t313 * t424;
  t2575 = t419 * t2574;
  t2576 = t502 * t174;
  t2578 = t2576 * t97 * t197;
  t2581 = t317 * t93;
  t2582 = t2581 * t178;
  t2583 = t173 * t2582;
  t2585 = 0.3e1 * t2583 * t1531;
  t2588 = 0.3e1 * t89 * t2582 * t642;
  t2590 = 0.3e1 * t2583 * t642;
  t2593 = t89 * t2574;
  t2596 = t173 * t2574;
  t2599 = t813 * t424;
  t2600 = t419 * t2599;
  t2601 = t2576 * t176;
  t2602 = t429 * t2601;
  t2605 = 0.2e1 * t173 * t2551 * t184 - 0.12e2 * t2561 * t2016 * t2562 - 0.12e2 * t2561 * t827 * t865 + 0.18e2 * t2575 * t1531 - 0.2e1 * t2552 * t199 + 0.2e1 * t2552 * t201 + 0.12e2 * t639 * t2571 - 0.6e1 * t2575 * t2578 - 0.6e1 * t2593 * t2578 + 0.18e2 * t2596 * t2578 - 0.12e2 * t2600 * t2602 - t2585 + t2588 - t2590 - t319 - t321;
  t2606 = t502 * t91;
  t2607 = t2606 * t245;
  t2608 = t429 * t2607;
  t2611 = t1831 * t463;
  t2614 = t2576 * t1618;
  t2617 = t816 * t865;
  t2620 = t97 * t2607;
  t2632 = t640 * t1552;
  t2644 = t502 * t180;
  t2645 = t662 * t91;
  t2646 = t2644 * t2645;
  t2658 = t183 * t2576 * t197;
  t2661 = -0.8e1 * t986 * t2608 - 0.3e1 * t815 * t2611 - 0.18e2 * t2600 * t2614 + 0.12e2 * t1845 * t2617 - 0.4e1 * t1914 * t2620 + 0.12e2 * t1845 * t2620 - 0.4e1 * t986 * t2620 + 0.12e2 * t986 * t183 * t816 * t245 + 0.18e2 * t173 * t2599 * t2632 - 0.18e2 * t2593 * t642 + 0.12e2 * t1906 * t429 * t965 * t245 + 0.12e2 * t980 * t183 * t2570 - 0.12e2 * t986 * t2646 + 0.12e2 * t1845 * t2646 + 0.12e2 * t89 * t2560 * t97 * t2562 + 0.3e1 * t822 * t1538 + 0.18e2 * t2596 * t2658;
  t2665 = t183 * t1841;
  t2669 = t419 * t186 * t424;
  t2670 = t429 * t1226;
  t2673 = t310 * t1488;
  t2674 = t89 * t2673;
  t2676 = t1751 * t189 * t174;
  t2679 = t310 * t1506;
  t2680 = t173 * t2679;
  t2681 = t206 * t174;
  t2682 = t205 * t2681;
  t2685 = t419 * t2673;
  t2686 = t1677 * t583;
  t2690 = t501 * t651 * t176;
  t2693 = t317 * t422;
  t2694 = t89 * t2693;
  t2696 = 0.3e1 * t2694 * t607;
  t2697 = t173 * t2693;
  t2699 = 0.3e1 * t2697 * t607;
  t2700 = t461 * t606;
  t2703 = t173 * t2673;
  t2706 = t310 * t174;
  t2710 = t1660 * t2681;
  t2713 = t1751 * t631;
  t2720 = 0.3e1 * t89 * t2706 * t1998 - 0.12e2 * t1914 * t2617 - 0.3e1 * t815 * t2665 + 0.18e2 * t2669 * t2670 + 0.11e2 * t2674 * t2676 + 0.6e1 * t2674 * t2713 - 0.11e2 * t2703 * t2676 - 0.3e1 * t2680 * t2682 - 0.3e1 * t2680 * t2700 - 0.6e1 * t2685 * t2686 - 0.18e2 * t2685 * t2710 + 0.6e1 * t2685 * t2713 - 0.12e2 * t860 * t2690 - 0.18e2 * t2703 * t2713 - t2696 + t2699;
  t2722 = t1677 * t1948 * t174;
  t2726 = t1751 * t1752 * t174;
  t2732 = t1485 * t2673;
  t2734 = t2694 * t632;
  t2736 = 0.3e1 * t2697 * t632;
  t2737 = t419 * t2693;
  t2738 = t2737 * t632;
  t2739 = t841 * t446;
  t2741 = 0.3e1 * t2697 * t577;
  t2744 = t174 * t1488;
  t2745 = t1485 * t2744;
  t2760 = 0.3e1 * t89 * t2581 * t1634;
  t2762 = t1654 * t1655 * t174;
  t2765 = 0.7e1 * t2732 * t1660 * t518 * t174 - 0.6e1 * t2745 * t1677 * t903 * params->csk_a + 0.3e1 * t838 * t1627 + t2674 * t2726 + 0.12e2 * t2685 * t2722 + 0.6e1 * t2685 * t2726 + 0.18e2 * t2732 * t2686 - 0.7e1 * t2703 * t2726 - 0.12e2 * t2732 * t2722 - t2732 * t2726 - 0.6e1 * t2732 * t2762 - t2734 + t2736 - t2738 + t2739 + t2741 + t2760;
  t2770 = t843 * t581;
  t2771 = t428 * t317;
  t2773 = t513 * t2771 * params->csk_a;
  t2775 = 0.3e1 * t599 * t2773;
  t2777 = 0.2e1 * t2737 * t584;
  t2780 = t182 * t310;
  t2781 = t2780 * t197;
  t2782 = t497 * t2781;
  t2785 = t843 * t446;
  t2786 = t497 * t1266;
  t2788 = 0.3e1 * t599 * t2786;
  t2790 = 0.3e1 * t2737 * t577;
  t2795 = t173 * t2744;
  t2796 = t2780 * params->csk_a;
  t2797 = t1660 * t2796;
  t2801 = t513 * t528 * t193;
  t2804 = t1494 * t310;
  t2810 = t1660 * t1235;
  t2813 = 0.11e2 * t2745 * t1654 * t2804 * t502 - t848 * t1565 + 0.3e1 * t832 * t1595 - 0.3e1 * t848 * t1595 + 0.3e1 * t832 * t1610 + 0.3e1 * t860 * t1943 - 0.18e2 * t203 * t2782 + 0.7e1 * t2795 * t2797 - 0.11e2 * t2795 * t2810 - 0.2e1 * t838 * t2801 - t2770 + t2775 - t2777 - t2785 + t2788 - t2790;
  t2815 = t1660 * t1661 * t174;
  t2834 = t419 * t186;
  t2844 = t1677 * t428 * t174 * params->csk_a;
  t2854 = t188 * t189 * t568;
  t2858 = t501 * t251 * t245;
  t2861 = -0.7e1 * t2703 * t2815 + 0.3e1 * t832 * t1565 + 0.18e2 * t2685 * t2815 - t838 * t1565 - 0.7e1 * t2732 * t2815 - 0.4e1 * t818 + 0.4e1 * t825 - 0.4e1 * t829 - 0.4e1 * t902 * t513 * t600 * t245 + 0.3e1 * t876 * t1600 - 0.6e1 * t2834 * t513 * t903 * t197 - 0.12e2 * t592 * t497 * t2645 - 0.12e2 * t2685 * t2844 + 0.3e1 * t838 * t1585 - 0.6e1 * t2745 * t1654 * t2804 * params->csk_a + 0.2e1 * t239 * t2854 - 0.8e1 * t612 * t2858;
  t2868 = t205 * t206 * t568;
  t2872 = t205 * t906 * t197;
  t2874 = 0.3e1 * t622 * t2872;
  t2875 = 0.2e1 * t842;
  t2876 = 0.2e1 * t844;
  t2877 = 0.2e1 * t859;
  t2880 = 0.2e1 * t892;
  t2881 = 0.2e1 * t908;
  t2882 = 0.3e1 * t911;
  t2884 = t2551 * t176;
  t2888 = t173 * t2884;
  t2896 = 0.3e1 * t173 * t2706 * t1512 + 0.2e1 * t89 * t2884 * t190 - 0.3e1 * t838 * t1610 - 0.2e1 * t2888 * t190 - 0.2e1 * t2888 * t207 - 0.2e1 * t254 * t2854 - 0.2e1 * t254 * t2868 + t2874 + t2875 - t2876 - t2877 + t2880 + t2881 - t2882 + 0.4e1 * t863 + 0.4e1 * t880 - 0.4e1 * t917;
  t2898 = t188 * t651;
  t2901 = t1751 * t651;
  t2905 = 0.2e1 * t2694 * t652;
  t2906 = t513 * t2771;
  t2907 = t599 * t2906;
  t2910 = t89 * t317 * t193 * t199;
  t2911 = t96 * t568;
  t2915 = t188 * t2911;
  t2918 = t841 * t676;
  t2919 = t497 * t906;
  t2921 = 0.3e1 * t655 * t2919;
  t2922 = t501 * t675;
  t2925 = t1660 * t2780;
  t2930 = t419 * t2744;
  t2939 = t450 * t907;
  t2940 = 0.3e1 * t89 * t2679 * t2898 + 0.6e1 * t2674 * t2901 - t2905 - t2907 - t2910 - 0.2e1 * t913 * t914 * t2911 + 0.2e1 * t239 * t2915 + t2918 - t2921 - 0.2e1 * t848 * t2922 + 0.11e2 * t2795 * t2925 - 0.3e1 * t832 * t1699 + 0.6e1 * t2930 * t1677 * t903 + 0.2e1 * t254 * t2159 - t1570 * t904 + t2745 * t1654 * t2804 + t2939;
  t2944 = my_piecewise5(t52, 0, t55, 0, t2605 + t2661 + t2720 + t2765 + t2813 + t2861 + t2896 + t2940);
  t2951 = my_piecewise3(t3, 0, -t8 * t150 * t329 / 0.3e2 + t8 * t73 * t926 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.88e3 / 0.729e3 * t30 * t551 * t121 + 0.16e3 / 0.243e3 * t30 * t223 * t260 - 0.1e2 / 0.81e2 * t30 * t110 * t680 + t167 * t327 + 0.2e1 * t87 * t924 + t47 * t2944));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t2951 + 0.4e1 * t931;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t2978 = t1028 * t197;
  t2979 = t173 * t2978;
  t2982 = t1031 * t197;
  t2983 = t173 * t2982;
  t2988 = t429 * t136;
  t2992 = t419 * t948;
  t2999 = t183 * t136;
  t3003 = t574 * t174;
  t3014 = t183 * t502;
  t3031 = -t319 - 0.6e1 * t2979 * t960 - 0.6e1 * t2983 * t960 - 0.3e1 * t949 * t1842 + 0.18e2 * t2669 * t2988 * t1313 - 0.12e2 * t2992 * t513 * t428 * t2601 - 0.3e1 * t949 * t2237 + 0.18e2 * t2669 * t2999 * t1313 - 0.18e2 * t2992 * t3003 * t1618 + 0.6e1 * t2307 * t956 + 0.6e1 * t764 * t2571 + 0.3e1 * t764 * t954 * t1929 + 0.18e2 * t2310 * t3014 * t645 - 0.6e1 * t2979 * t951 - 0.6e1 * t2983 * t951 + 0.18e2 * t949 * t475 * t174 * t1552 - 0.18e2 * t2278 * t954 * t645 - 0.4e1 * t952 + 0.4e1 * t957;
  t3033 = t2315 * t1490;
  t3034 = t1485 * t3033;
  t3035 = t1649 * t118;
  t3036 = t3035 * t576;
  t3039 = t89 * t3033;
  t3040 = t971 * t174;
  t3041 = t97 * t3040;
  t3044 = t419 * t3033;
  t3047 = t3035 * t174;
  t3048 = t429 * t3047;
  t3051 = t173 * t3033;
  t3054 = t3035 * t606;
  t3067 = t2744 * t1490;
  t3069 = t987 * t118;
  t3070 = t183 * t3069;
  t3076 = t97 * t965 * t174;
  t3080 = t173 * t345 * t1506;
  t3091 = -0.18e2 * t1885 * t183 * t736 - 0.6e1 * t3044 * t429 * t3040 - 0.18e2 * t419 * t3067 * t3070 + 0.6e1 * t992 * t2617 - 0.3e1 * t3080 * t2682 - 0.12e2 * t995 * t2690 - 0.3e1 * t3080 * t2700 - 0.7e1 * t3034 * t3036 - t3034 * t3054 + 0.18e2 * t3044 * t3036 - 0.7e1 * t3051 * t3036 + 0.6e1 * t3039 * t3041 + t3039 * t3054 + 0.11e2 * t3039 * t3076 + 0.6e1 * t3044 * t3041 - 0.18e2 * t3051 * t3041 + 0.12e2 * t3044 * t3048 + 0.6e1 * t3044 * t3054 - 0.7e1 * t3051 * t3054 - 0.4e1 * t961;
  t3101 = t97 * t1907;
  t3110 = t2344 * t424;
  t3111 = t419 * t3110;
  t3117 = t971 * t183 * t193;
  t3120 = t1485 * t3067;
  t3121 = t136 * t502;
  t3122 = t3121 * t118;
  t3132 = t971 * t193;
  t3142 = t173 * t3110;
  t3147 = t97 * t3132;
  t3151 = -0.11e2 * t3051 * t3076 + 0.3e1 * t89 * t725 * t1506 * t343 - 0.6e1 * t964 * t2617 - 0.3e1 * t964 * t3101 + 0.7e1 * t173 * t3067 * t3070 - 0.11e2 * t3051 * t183 * t3040 - 0.6e1 * t3111 * t973 - 0.6e1 * t970 * t2646 - 0.3e1 * t970 * t3117 + 0.18e2 * t3120 * t429 * t3122 - 0.12e2 * t3034 * t3048 - 0.4e1 * t3111 * t977 - 0.4e1 * t970 * t2608 - 0.2e1 * t970 * t429 * t3132 + 0.11e2 * t3120 * t1495 * t3122 - 0.6e1 * t3034 * t1495 * t3047 + 0.6e1 * t3142 * t967 + 0.3e1 * t992 * t3101 - t964 * t3147 + 0.6e1 * t3142 * t998;
  t3170 = t783 * t197;
  t3171 = t183 * t3170;
  t3179 = t1946 * t1490;
  t3180 = t419 * t3179;
  t3186 = t419 * t1976 * t424;
  t3190 = t286 * params->csk_a * t91;
  t3191 = t429 * t3190;
  t3199 = t89 * t3110;
  t3208 = 0.6e1 * t3142 * t973 + 0.6e1 * t992 * t2646 + 0.3e1 * t992 * t3117 + 0.6e1 * t89 * t2978 * t862 + 0.6e1 * t89 * t2982 * t862 + 0.3e1 * t995 * t1943 - 0.2e1 * t3111 * t998 + 0.6e1 * t1902 * t982 + 0.6e1 * t980 * t3171 + 0.3e1 * t980 * t2257 - 0.6e1 * t2669 * t429 * t948 - 0.12e2 * t3180 * t429 * t725 * params->csk_a + 0.6e1 * t3186 * t989 + 0.6e1 * t986 * t3191 + 0.3e1 * t986 * t2286 - 0.6e1 * t3120 * t1495 * t3069 - 0.6e1 * t3199 * t967 + 0.3e1 * t992 * t3147 + 0.6e1 * t992 * t2620 - 0.2e1 * t970 * t2620;
  t3217 = t183 * t3190;
  t3222 = t429 * t3069;
  t3237 = t1507 * t2999;
  t3248 = t777 * t91;
  t3249 = t497 * t3248;
  t3254 = -t970 * t3147 + 0.7e1 * t3120 * t183 * t3122 + 0.6e1 * t3186 * t1000 + 0.6e1 * t986 * t3217 + 0.3e1 * t986 * t2302 - 0.6e1 * t3120 * t3222 - 0.2e1 * t3199 * t998 - 0.2e1 * t964 * t2620 - t2585 + t2588 - t2590 + 0.3e1 * t346 * t1507 * t606 + 0.6e1 * t2333 * t1751 * t348 * t174 + 0.3e1 * t173 * t615 * t3237 + 0.11e2 * t1958 * t1660 * t278 * t174 - 0.2e1 * t715 * t873 - 0.6e1 * t1977 * t1009 - 0.6e1 * t592 * t3249 - 0.3e1 * t592 * t2440;
  t3261 = t513 * t2096 * t136;
  t3288 = 0.6e1 * t2930 * t1677 * t1021 - t293 * t2868 - t1570 * t1022 - 0.2e1 * t902 * t3261 - 0.2e1 * t902 * t513 * t600 * t286 + t2745 * t1654 * t2080 * t136 + t2456 * t343 + 0.2e1 * t754 * t866 + t282 * t2854 - 0.4e1 * t2364 * t1013 - 0.4e1 * t718 * t2858 - 0.2e1 * t718 * t501 * t348 * t193 - t2373 * t343 - 0.2e1 * t715 * t866 - t293 * t2854 - t2373 * t353 - t2696 + t2699 - t2734 + t2736;
  t3292 = t3003 * t1552;
  t3297 = t97 * t502;
  t3301 = -0.6e1 * t2278 * t3297 * t645 - 0.6e1 * t2992 * t3292 + 0.18e2 * t949 * t3292 - t2738 + t2739 + t2741 + t2760 - t2770 + t2775 - t2777 - t2785 + t2788 - t2790 + t2874 + t2875 - t2876 - t2877 - t347 + 0.4e1 * t983 + 0.4e1 * t996;
  t3322 = t2880 + t2881 - t2882 - 0.2e1 * t1030 - 0.2e1 * t1033 - t2905 - t2907 - t2910 + t2918 - t2921 + t2939 + t2456 * t349 + 0.2e1 * t754 * t919 + t282 * t2915 + t2057 * t279 + 0.2e1 * t595 * t778 + t254 * t2489 - t89 * t707 * t118 * t199 - 0.2e1 * t89 * t286 * t245 * t199 - t89 * t136 * t568 * t199;
  t3326 = my_piecewise5(t52, 0, t55, 0, t3031 + t3091 + t3151 + t3208 + t3254 + t3288 + t3301 + t3322);
  t3333 = my_piecewise3(t3, 0, -t8 * t150 * t358 / 0.3e2 + t8 * t73 * t1040 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.1e3 / 0.243e3 * t807 - 0.25e2 / 0.81e2 * t810 + 0.5e1 / 0.54e2 * t30 * t129 * t680 - 0.44e3 / 0.729e3 * t30 * t551 * t139 + 0.8e2 / 0.243e3 * t30 * t223 * t297 - 0.5e1 / 0.81e2 * t30 * t110 * t793 + t167 * t356 + 0.2e1 * t87 * t1038 + t47 * t3326));
  tv4rho2sigmalapl0 = 0.2e1 * rho[0] * t3333 + 0.4e1 * t1045;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  t3351 = t286 * t286;
  t3355 = t89 * t3351;
  t3360 = t370 * t424;
  t3361 = t419 * t3360;
  t3364 = t89 * t3360;
  t3367 = t173 * t3360;
  t3372 = t1056 * t424;
  t3373 = t173 * t3372;
  t3378 = t97 * t286;
  t3379 = t816 * t3378;
  t3382 = t2606 * t3378;
  t3389 = t2644 * t3248;
  t3392 = 0.2e1 * t173 * t3351 * t184 + 0.18e2 * t3361 * t1531 - 0.2e1 * t3355 * t199 + 0.2e1 * t3355 * t201 - 0.6e1 * t3361 * t2578 - 0.6e1 * t3364 * t2578 + 0.18e2 * t3367 * t2578 + 0.18e2 * t3373 * t2632 + 0.12e2 * t970 * t3217 - 0.18e2 * t3364 * t642 + 0.12e2 * t992 * t3379 - 0.4e1 * t964 * t3382 - 0.4e1 * t970 * t3382 - 0.12e2 * t970 * t3389 - t319 - t374;
  t3400 = t1116 * t178;
  t3401 = t89 * t3400;
  t3402 = t1926 * t286;
  t3406 = t173 * t763;
  t3423 = t419 * t3372;
  t3432 = -0.8e1 * t970 * t429 * t502 * t286 * t91 + 0.12e2 * t992 * t3389 + 0.12e2 * t3401 * t97 * t3402 + 0.12e2 * t3406 * t3171 + 0.12e2 * t970 * t3191 + 0.3e1 * t1063 * t1538 + 0.18e2 * t3367 * t2658 - 0.12e2 * t964 * t3379 - 0.3e1 * t1058 * t2665 + 0.18e2 * t2669 * t429 * t1056 * params->csk_a - 0.12e2 * t3423 * t2602 + 0.12e2 * t992 * t3382 - 0.3e1 * t1058 * t2611 - 0.18e2 * t3423 * t2614 - t2585 + t2588 - t2590;
  t3434 = t367 * t1488;
  t3435 = t173 * t3434;
  t3438 = t419 * t3434;
  t3445 = t1485 * t3434;
  t3447 = t89 * t3434;
  t3453 = t367 * t174;
  t3459 = t367 * t1506;
  t3460 = t173 * t3459;
  t3463 = t182 * t174;
  t3476 = -0.18e2 * t376 * t497 * t3463 * t197 + 0.3e1 * t89 * t3453 * t1998 - 0.12e2 * t1085 * t2690 - 0.11e2 * t3435 * t2676 + 0.11e2 * t3447 * t2676 - 0.3e1 * t3460 * t2682 - 0.6e1 * t3438 * t2686 - 0.3e1 * t3460 * t2700 - 0.18e2 * t3438 * t2710 - 0.18e2 * t3435 * t2713 + 0.6e1 * t3438 * t2713 + 0.6e1 * t3447 * t2713 - 0.7e1 * t3435 * t2726 + 0.6e1 * t3438 * t2726 - t3445 * t2726 + t3447 * t2726;
  t3479 = t182 * t367;
  t3487 = t513 * t1113 * t197;
  t3496 = t1494 * t367;
  t3498 = t1654 * t3496 * params->csk_a;
  t3506 = t1677 * t1113 * params->csk_a;
  t3513 = t1660 * t3479 * t502;
  t3522 = 0.7e1 * t2795 * t1660 * t3479 * params->csk_a - t1069 * t1565 - 0.3e1 * t1069 * t1595 + 0.3e1 * t1072 * t1600 + 0.3e1 * t1075 * t1585 + 0.3e1 * t1075 * t1627 + 0.3e1 * t1082 * t1565 + 0.18e2 * t3445 * t2686 - 0.6e1 * t2745 * t3498 - 0.6e1 * t2745 * t3506 - 0.11e2 * t2795 * t3513 - 0.7e1 * t3435 * t2815 + 0.18e2 * t3438 * t2815 - 0.7e1 * t3445 * t2815 - 0.6e1 * t2834 * t3487 - 0.12e2 * t3438 * t2844 - 0.12e2 * t711 * t3249;
  t3531 = t513 * t748 * t286;
  t3535 = t461 * t97 * t707;
  t3566 = 0.11e2 * t3445 * t1654 * t1670 * t174 - 0.2e1 * t293 * t205 * t206 * t707 - 0.8e1 * t718 * t501 * t251 * t286 - t1075 * t1565 - 0.3e1 * t1075 * t1610 - 0.2e1 * t1075 * t2801 + 0.3e1 * t1082 * t1595 + 0.3e1 * t1082 * t1610 + 0.3e1 * t1085 * t1943 + 0.12e2 * t3438 * t2722 - 0.12e2 * t3445 * t2722 + 0.7e1 * t2745 * t3513 - 0.6e1 * t3445 * t2762 + 0.2e1 * t282 * t3535 - 0.2e1 * t293 * t3535 - 0.4e1 * t902 * t3531;
  t3567 = t173 * t3400;
  t3577 = -0.12e2 * t3567 * t2016 * t3402 + 0.12e2 * t764 * t954 * t3170 - 0.12e2 * t3567 * t827 * t3378 - t2696 + t2699 - t2734 + t2736 - t2738 + t2739 + t2741 + t2760 - t2770 + t2775 - t2777 - t2785 + t2788 - t2790;
  t3585 = -0.4e1 * t1059 + 0.4e1 * t1064 - 0.4e1 * t1066 + t2874 + 0.4e1 * t1073 + 0.4e1 * t1086 + t2875 - t2876 - t2877 + t2880 + t2881 - t2882 - 0.4e1 * t1120 - t2905 - t2907 - t2910 + t2918;
  t3586 = t89 * t3459;
  t3597 = t96 * t707;
  t3603 = t1677 * t1113;
  t3611 = t1654 * t3496;
  t3616 = t3351 * t176;
  t3617 = t173 * t3616;
  t3625 = -t2921 + t2939 + 0.3e1 * t3586 * t2898 + 0.6e1 * t3447 * t2901 + 0.3e1 * t173 * t3453 * t1512 + 0.11e2 * t3435 * t1660 * t3463 + 0.2e1 * t282 * t188 * t3597 - 0.3e1 * t1082 * t1699 + 0.6e1 * t2930 * t3603 - 0.2e1 * t1069 * t2922 + 0.2e1 * t293 * t2489 - t1570 * t1114 + t2745 * t3611 - 0.2e1 * t1117 * t914 * t3597 - 0.2e1 * t3617 * t190 - 0.2e1 * t3617 * t207 + 0.2e1 * t89 * t3616 * t190;
  t3629 = my_piecewise5(t52, 0, t55, 0, t3392 + t3432 + t3476 + t3522 + t3566 + t3577 + t3585 + t3625);
  t3636 = my_piecewise3(t3, 0, -t8 * t150 * t382 / 0.3e2 + t8 * t73 * t1129 / 0.5e1 + 0.3e1 / 0.2e2 * t8 * t24 * (0.2e3 / 0.243e3 * t942 - 0.5e2 / 0.81e2 * t945 + 0.5e1 / 0.27e2 * t30 * t129 * t793 + t167 * t380 + 0.2e1 * t87 * t1127 + t47 * t3629));
  tv4rho2lapl20 = 0.2e1 * rho[0] * t3636 + 0.4e1 * t1134;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t3649 = t2693 * t424;
  t3650 = t419 * t3649;
  t3651 = t3650 * t973;
  t3653 = params->csk_a * t317;
  t3654 = t3653 * t91;
  t3655 = t97 * t3654;
  t3656 = t1914 * t3655;
  t3658 = t3650 * t998;
  t3661 = t986 * t183 * t3654;
  t3663 = t502 * t317;
  t3664 = t3663 * t91;
  t3665 = t97 * t3664;
  t3666 = t1914 * t3665;
  t3668 = t1845 * t3665;
  t3670 = t1140 * t176;
  t3671 = t3670 * t424;
  t3672 = t419 * t3671;
  t3673 = t183 * t823;
  t3677 = t986 * t429 * t3654;
  t3679 = t429 * t823;
  t3682 = t173 * t3671;
  t3683 = t2606 * t197;
  t3684 = t183 * t3683;
  t3687 = t1181 * t197;
  t3688 = t89 * t3687;
  t3689 = t3688 * t862;
  t3692 = t173 * t3649 * t967;
  t3694 = 0.18e2 * t3672 * t3673 + 0.18e2 * t3672 * t3679 + 0.18e2 * t3682 * t3684 - t319 - t321 - 0.9e1 * t3651 - 0.9e1 * t3656 - 0.3e1 * t3658 + 0.9e1 * t3661 - 0.3e1 * t3666 + 0.9e1 * t3668 + 0.9e1 * t3677 + 0.9e1 * t3689 + 0.9e1 * t3692;
  t3695 = t1155 * t424;
  t3698 = t176 * params->csk_a * t91;
  t3699 = t97 * t3698;
  t3705 = t1840 * t865;
  t3709 = t97 * t1536 * t245;
  t3713 = t97 * t3683;
  t3720 = t183 * t3664;
  t3721 = t1845 * t3720;
  t3723 = t3650 * t977;
  t3725 = t1840 * t245;
  t3726 = t183 * t3725;
  t3731 = t429 * t3683;
  t3736 = t980 * t183 * t909 * t197;
  t3738 = t1140 * t1488;
  t3739 = t173 * t3738;
  t3741 = t1660 * t1661 * t91;
  t3744 = 0.18e2 * t173 * t3695 * t3699 - 0.6e1 * t89 * t3671 * t3713 - 0.18e2 * t89 * t3695 * t3699 - 0.18e2 * t3672 * t3684 - 0.6e1 * t3672 * t3713 - 0.12e2 * t3672 * t3731 + 0.18e2 * t3682 * t3713 - 0.9e1 * t815 * t3705 + 0.9e1 * t822 * t3709 - 0.9e1 * t815 * t3726 - 0.7e1 * t3739 * t3741 + 0.9e1 * t3721 - 0.6e1 * t3723 + 0.9e1 * t3736;
  t3746 = t1485 * t3738;
  t3747 = t1660 * t855;
  t3753 = t574 * t183 * t245;
  t3756 = t91 * t1488;
  t3757 = t1485 * t3756;
  t3758 = t428 * t1140;
  t3760 = t1677 * t3758 * t502;
  t3764 = t1650 * t429 * t91;
  t3768 = t513 * t528 * t245;
  t3771 = t1494 * t1140;
  t3777 = t1654 * t1655 * t91;
  t3780 = t89 * t3738;
  t3781 = t1751 * t240;
  t3786 = t419 * t3738;
  t3787 = t1660 * t256;
  t3791 = t1751 * t1752 * t91;
  t3797 = 0.11e2 * t3757 * t1654 * t3771 * t502 - 0.11e2 * t3739 * t3781 - 0.7e1 * t3739 * t3791 - 0.7e1 * t3746 * t3741 + 0.7e1 * t3746 * t3747 - 0.12e2 * t3746 * t3764 - 0.6e1 * t3746 * t3777 - 0.9e1 * t838 * t3753 + 0.18e2 * t3757 * t3760 - 0.6e1 * t838 * t3768 + 0.11e2 * t3780 * t3781 + t3780 * t3791 - 0.18e2 * t3786 * t3787 + 0.6e1 * t3786 * t3791;
  t3811 = t1140 * t1506;
  t3812 = t173 * t3811;
  t3815 = t1140 * t91;
  t3822 = t1751 * t503 * t91;
  t3829 = t2694 * t1013;
  t3832 = t501 * t1706 * t91;
  t3835 = t1677 * t851;
  t3838 = -0.6e1 * t3757 * t1654 * t3771 * params->csk_a + 0.3e1 * t89 * t3815 * t1998 - 0.12e2 * t1187 * t3832 + 0.9e1 * t838 * t2098 - 0.3e1 * t3812 * t241 - 0.3e1 * t3812 * t257 - 0.18e2 * t3739 * t3822 + 0.18e2 * t3786 * t3741 - t3746 * t3791 + 0.9e1 * t832 * t3753 + 0.12e2 * t3786 * t3764 + 0.6e1 * t3780 * t3822 + 0.6e1 * t3786 * t3822 - 0.6e1 * t3786 * t3835 - 0.6e1 * t3829;
  t3843 = t592 * t497 * t906 * t91;
  t3845 = t1677 * t882;
  t3850 = t843 * t866;
  t3852 = t475 * t865;
  t3860 = t501 * t503 * t245;
  t3878 = t588 * t1150;
  t3880 = -0.6e1 * t419 * t233 * t513 * t3758 * t197 - 0.6e1 * t3757 * t1677 * t3758 * params->csk_a + 0.9e1 * t876 * t2044 + 0.9e1 * t838 * t2062 - 0.11e2 * t3739 * t3747 + 0.7e1 * t3739 * t3787 - 0.12e2 * t3786 * t3845 + 0.9e1 * t832 * t3852 + 0.9e1 * t832 * t3860 - 0.3e1 * t838 * t3860 - 0.3e1 * t848 * t3860 - 0.9e1 * t3843 - 0.3e1 * t3850 + 0.3e1 * t3878;
  t3881 = t843 * t873;
  t3884 = t188 * t492 * t245;
  t3887 = t182 * t1140;
  t3894 = t902 * t513 * t600 * t317;
  t3898 = t173 * t3687;
  t3899 = t3898 * t960;
  t3901 = t3688 * t951;
  t3903 = t3898 * t951;
  t3905 = -0.18e2 * t234 * t497 * t3887 * t197 - 0.9e1 * t848 * t3852 + 0.9e1 * t860 * t3884 + t1152 - t1154 - t1158 - 0.3e1 * t3881 - 0.3e1 * t3894 - 0.9e1 * t3899 + 0.9e1 * t3901 - 0.9e1 * t3903 - t818 + t825 - t829;
  t3907 = 0.6e1 * t1183;
  t3908 = -t1160 - t1162 + t1166 + t842 - t844 - t859 + t863 + t880 + t892 + t908 - t911 - t918 + t1175 - t3907;
  t3909 = t1751 * t251;
  t3922 = t841 * t919;
  t3924 = t501 * t915;
  t3927 = t173 * t3756;
  t3937 = t595 * t907;
  t3941 = t89 * t317 * t245 * t199;
  t3943 = 0.6e1 * t419 * t3756 * t1677 * t3758 + 0.3e1 * t173 * t3815 * t1512 + t3757 * t1654 * t3771 + 0.11e2 * t3927 * t1660 * t3887 + 0.3e1 * t89 * t3811 * t252 - 0.3e1 * t838 * t2146 - 0.9e1 * t832 * t2171 + 0.6e1 * t3780 * t3909 - 0.6e1 * t848 * t3924 + t1186 + t1189 + t1192 + 0.3e1 * t3922 + 0.3e1 * t3937 - 0.3e1 * t3941;
  t3947 = my_piecewise5(t52, 0, t55, 0, t3694 + t3744 + t3797 + t3838 + t3880 + t3905 + t3908 + t3943);
  t3954 = my_piecewise3(t3, 0, t8 * t73 * t1208 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (0.4e2 / 0.81e2 * t30 * t223 * t327 - 0.5e1 / 0.27e2 * t30 * t110 * t924 + t87 * t1206 + t47 * t3947));
  tv4rhosigma30 = 0.2e1 * rho[0] * t3954 + 0.2e1 * t1212;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t3971 = t964 * t3665;
  t3972 = t992 * t3665;
  t3975 = t1649 * t310 * t91;
  t3976 = t183 * t3975;
  t3979 = t970 * t3665;
  t3980 = t502 * t310;
  t3981 = t3980 * t834;
  t3988 = t97 * t3975;
  t3992 = t3650 * t1000;
  t3994 = t2673 * t1490;
  t3995 = t1485 * t3994;
  t4000 = t992 * t3720;
  t4002 = t429 * t3975;
  t4008 = t964 * t3655;
  t4010 = -0.12e2 * t419 * t3994 * t989 + 0.6e1 * t3039 * t3981 + t3039 * t3988 + 0.18e2 * t3044 * t3976 + 0.6e1 * t3044 * t3981 + 0.12e2 * t3044 * t4002 - 0.7e1 * t3051 * t3976 - 0.18e2 * t3051 * t3981 - 0.7e1 * t3051 * t3988 - 0.6e1 * t3995 * t989 - t319 - t3971 + 0.3e1 * t3972 - t3979 + 0.3e1 * t3992 + 0.3e1 * t4000 - 0.3e1 * t4008 - t952 + t957 - t961;
  t4011 = t992 * t3655;
  t4015 = t970 * t3720;
  t4021 = t3980 * t91;
  t4028 = t3650 * t989;
  t4033 = t965 * t865;
  t4036 = t3756 * t1490;
  t4039 = t183 * t987 * t310;
  t4044 = t971 * t245;
  t4045 = t183 * t4044;
  t4049 = t970 * t429 * t3664;
  t4054 = t1485 * t4036;
  t4055 = t3121 * t310;
  t4062 = t987 * t245;
  t4069 = t1278 * t197;
  t4070 = t89 * t4069;
  t4071 = t4070 * t862;
  t4073 = 0.3e1 * t4011 - 0.7e1 * t3034 * t3976 - 0.3e1 * t4015 + 0.7e1 * t3995 * t183 * t3121 * t91 - 0.6e1 * t3044 * t429 * t4021 + 0.6e1 * t3044 * t3988 - t3034 * t3988 + 0.3e1 * t4028 - 0.6e1 * t2575 * t429 * t981 + 0.6e1 * t992 * t4033 - 0.18e2 * t419 * t4036 * t4039 + 0.3e1 * t2307 * t1227 + 0.6e1 * t992 * t4045 - 0.2e1 * t4049 - 0.4e1 * t970 * t429 * t4044 + 0.11e2 * t4054 * t1495 * t4055 - 0.6e1 * t3034 * t1495 * t3975 + 0.6e1 * t986 * t429 * t4062 - 0.6e1 * t3995 * t1495 * t988 + 0.3e1 * t4071;
  t4082 = t2583 * t982;
  t4084 = t286 * t310;
  t4086 = t173 * t4084 * t197;
  t4089 = t971 * t865;
  t4106 = t233 * t424;
  t4118 = t189 * t310;
  t4119 = t188 * t4118;
  t4123 = t97 * t1225 * t91;
  t4130 = t173 * t1220 * t1506;
  t4136 = -0.6e1 * t970 * t4045 + 0.18e2 * t4054 * t429 * t4055 - 0.12e2 * t3034 * t4002 + 0.3e1 * t4082 - 0.3e1 * t4086 * t464 + 0.6e1 * t992 * t4089 - 0.2e1 * t970 * t4089 + 0.6e1 * t986 * t183 * t4062 - 0.2e1 * t964 * t4089 - 0.6e1 * t964 * t4033 + 0.7e1 * t173 * t4036 * t4039 + 0.6e1 * t995 * t3884 - 0.18e2 * t173 * t4106 * t183 * t1221 - 0.3e1 * t4086 * t456 + 0.6e1 * t980 * t183 * t2982 + 0.3e1 * t89 * t289 * t1506 * t4119 + 0.11e2 * t3039 * t4123 - 0.12e2 * t89 * t1221 * t3832 - 0.3e1 * t4130 * t257 - 0.11e2 * t3051 * t183 * t4021;
  t4154 = t2697 * t1009;
  t4169 = t715 * t1267;
  t4170 = 0.6e1 * t2685 * t1677 * t748 * t91 + 0.3e1 * t89 * t4084 * t618 - 0.3e1 * t2348 * t1236 + 0.3e1 * t2345 * t1242 - 0.3e1 * t2364 * t1242 + 0.6e1 * t3692 + 0.6e1 * t3721 - 0.4e1 * t3723 + 0.6e1 * t3736 - 0.3e1 * t4154 - t4169;
  t4178 = t754 * t1150;
  t4182 = t513 * t2771 * t136;
  t4183 = t902 * t4182;
  t4191 = t718 * t501 * t1281 * t91;
  t4224 = t715 * t1150;
  t4225 = -0.2e1 * t2348 * t1270 + 0.3e1 * t838 * t2402 + t4178 + 0.3e1 * t2345 * t1236 - t4183 - 0.2e1 * t573 * t3261 + t3757 * t1654 * t2804 * t136 - 0.2e1 * t4191 + 0.3e1 * t173 * t310 * t91 * t3237 + 0.3e1 * t1247 * t1507 * t834 + 0.6e1 * t2333 * t1751 * t1284 * t91 + 0.3e1 * t2345 * t1255 - t2348 * t1255 - 0.4e1 * t718 * t501 * t348 * t245 + 0.11e2 * t3927 * t1660 * t278 * t310 + 0.3e1 * t876 * t2432 - 0.6e1 * t592 * t497 * t278 * t245 + 0.3e1 * t838 * t2359 - t2364 * t1255 - t4224;
  t4232 = t173 * t4069;
  t4233 = t4232 * t960;
  t4235 = t419 * t2277;
  t4237 = t3980 * t180 * t878;
  t4240 = t813 * t91;
  t4244 = t429 * t502;
  t4259 = t4070 * t951;
  t4261 = t4232 * t951;
  t4264 = t574 * t176 * t834;
  t4282 = 0.18e2 * t1222 * t475 * t176 * t834 + 0.6e1 * t764 * t954 * t912 * t245 - 0.6e1 * t419 * t1221 * t4264 - 0.6e1 * t949 * t2235 * t865 - 0.18e2 * t2278 * t954 * t4240 + 0.18e2 * t2575 * t2988 * t823 - 0.6e1 * t949 * t959 * t3725 + 0.18e2 * t1222 * t4264 + 0.18e2 * t2310 * t4237 + 0.3e1 * t4259 - 0.3e1 * t4261;
  t4292 = 0.18e2 * t419 * t4106 * t2999 * t1226 - t1224 + t1229 - t1231 + t1234 - t1239 + t1249 + t1251 + t1261 - t1262 - t1263 - t1268 - 0.6e1 * t3899 + 0.6e1 * t3901 - 0.6e1 * t3903 + t842 - t844 - t859 + t983 + t996;
  t4298 = t754 * t1282;
  t4303 = t843 * t778;
  t4307 = t89 * t286 * t317 * t199;
  t4308 = -0.2e1 * t2364 * t1285 - t838 * t2474 - 0.3e1 * t832 * t2501 + t1283 - t1355 + 0.2e1 * t3922 + 0.2e1 * t3937 - 0.2e1 * t3941 + t4298 + t4303 - t4307;
  t4313 = my_piecewise5(t52, 0, t55, 0, -0.18e2 * t4235 * t4237 - 0.3e1 * t4130 * t241 - 0.11e2 * t3051 * t4123 - 0.6e1 * t2278 * t3297 * t4240 - 0.12e2 * t4235 * t4244 * t4240 + t4308 + t4292 + t4282 - 0.3e1 * t4233 + t4225 + t4170 + t4136 + t4073 + t4010 - 0.2e1 * t3894 + 0.2e1 * t3878 - 0.2e1 * t3881 - 0.2e1 * t3850 - 0.6e1 * t3843 - 0.4e1 * t3829 - t347 + 0.6e1 * t3689 + 0.6e1 * t3677 - 0.2e1 * t3666 + 0.6e1 * t3668 + 0.6e1 * t3661 - 0.6e1 * t3656 - 0.2e1 * t3658 - 0.6e1 * t3651 + t1276 + t1275 + t1273 - t1033 - t1030 - t911 - 0.4e1 * t1183 + t908 + t892);
  t4320 = my_piecewise3(t3, 0, t8 * t73 * t1294 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.25e2 / 0.162e3 * t1138 + 0.5e1 / 0.54e2 * t30 * t129 * t924 + 0.8e2 / 0.243e3 * t30 * t223 * t356 - 0.1e2 / 0.81e2 * t30 * t110 * t1038 + t87 * t1292 + t47 * t4313));
  tv4rhosigma2lapl0 = 0.2e1 * rho[0] * t4320 + 0.2e1 * t1298;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  t4337 = t3434 * t1490;
  t4338 = t419 * t4337;
  t4339 = t3035 * t91;
  t4340 = t429 * t4339;
  t4343 = t183 * t966;
  t4346 = t173 * t4337;
  t4347 = t183 * t4339;
  t4350 = t89 * t4337;
  t4351 = t97 * t4339;
  t4359 = t1485 * t4337;
  t4369 = t1485 * t3179;
  t4371 = t367 * params->csk_a * t91;
  t4372 = t429 * t4371;
  t4385 = t367 * t91;
  t4390 = -0.6e1 * t1896 * t429 * t4385 * t197 - 0.6e1 * t4359 * t1495 * t4339 + 0.6e1 * t3406 * t183 * t2978 - 0.12e2 * t3180 * t4372 + 0.12e2 * t4338 * t4340 - 0.18e2 * t4338 * t4343 + 0.18e2 * t4338 * t4347 + 0.6e1 * t4338 * t4351 + 0.7e1 * t4346 * t4343 - 0.7e1 * t4346 * t4347 - 0.7e1 * t4346 * t4351 - 0.11e2 * t4346 * t967 - 0.7e1 * t4359 * t4347 + t4350 * t4351 + 0.11e2 * t4350 * t967 - t4359 * t4351 + 0.7e1 * t4359 * t973 - 0.6e1 * t4369 * t4372 - t319 - t374;
  t4392 = t173 * t3459 * t178;
  t4403 = t89 * t3372;
  t4421 = t965 * t3378;
  t4426 = t971 * t286;
  t4427 = t97 * t4426;
  t4434 = t637 * t286;
  t4438 = t965 * t286;
  t4445 = t183 * t4426;
  t4448 = -0.3e1 * t4392 * t4343 - 0.3e1 * t4392 * t967 + 0.3e1 * t89 * t4385 * t1506 * t343 - 0.11e2 * t4346 * t973 - 0.12e2 * t4403 * t97 * t238 * t91 + 0.6e1 * t4350 * t998 - 0.18e2 * t4346 * t998 + 0.6e1 * t4338 * t998 - 0.6e1 * t4338 * t977 - 0.18e2 * t3367 * t183 * t955 - 0.3e1 * t1058 * t3705 + 0.6e1 * t992 * t4421 + 0.3e1 * t1063 * t3709 - 0.2e1 * t964 * t4427 + 0.6e1 * t992 * t4427 - 0.2e1 * t970 * t4427 + 0.6e1 * t3401 * t97 * t4434 + 0.6e1 * t970 * t183 * t4438 + 0.6e1 * t970 * t429 * t4438 + 0.6e1 * t992 * t4445;
  t4456 = t367 * t502 * t118;
  t4484 = 0.11e2 * t4054 * t1495 * t4456 - 0.6e1 * t4369 * t1495 * t4371 + 0.18e2 * t4054 * t429 * t4456 - 0.4e1 * t970 * t429 * t4426 - 0.3e1 * t1058 * t3726 - 0.12e2 * t4359 * t4340 - 0.6e1 * t964 * t4421 - 0.6e1 * t970 * t4445 - 0.2e1 * t3971 + 0.6e1 * t3972 - 0.2e1 * t3979 + 0.6e1 * t3992 + 0.6e1 * t4000 - 0.6e1 * t4008 + 0.6e1 * t4011 - 0.6e1 * t4015 + 0.6e1 * t4028 - 0.4e1 * t4049 + 0.6e1 * t4071 + 0.6e1 * t4082;
  t4515 = -0.4e1 * t718 * t501 * t348 * t286 - 0.3e1 * t1069 * t3852 + 0.3e1 * t1075 * t2062 + 0.3e1 * t1075 * t2098 - t1075 * t3860 + 0.3e1 * t1082 * t3753 + 0.3e1 * t1082 * t3852 + 0.3e1 * t1082 * t3860 + 0.3e1 * t1085 * t3884 - 0.2e1 * t3723 + 0.3e1 * t3736;
  t4561 = -0.2e1 * t573 * t3531 + t3757 * t1654 * t2080 * t367 - 0.3e1 * t1075 * t3753 - 0.2e1 * t1075 * t3768 + 0.3e1 * t1072 * t2044 - 0.6e1 * t711 * t497 * t235 * t286 + 0.3e1 * t3586 * t188 * t1012 + 0.6e1 * t3447 * t1751 * t1012 + 0.3e1 * t173 * t4385 * t1507 * t1317 + 0.11e2 * t3435 * t1660 * t235 * t91 + 0.6e1 * t1947 * t1677 * t1113 * t91 - t1069 * t3860 - 0.6e1 * t4154 - 0.2e1 * t4169 + 0.2e1 * t4178 - 0.2e1 * t4183 - 0.4e1 * t4191 - 0.2e1 * t4224 - 0.2e1 * t3829 - 0.3e1 * t3843;
  t4562 = t1344 * t3698;
  t4571 = t971 * t62 * t1833;
  t4576 = t3014 * t955;
  t4602 = 0.18e2 * t3361 * t429 * t118 * t823 - 0.6e1 * t3567 * t1306 * t3378 + 0.18e2 * t3361 * t1317 * t823 - 0.6e1 * t3567 * t2016 * t4434 + 0.6e1 * t764 * t954 * t2978 - 0.12e2 * t3361 * t4244 * t955 - 0.6e1 * t3361 * t4571 - 0.18e2 * t3361 * t4576 - 0.6e1 * t3364 * t4571 + 0.18e2 * t3367 * t4571 + 0.18e2 * t3367 * t4576 + 0.18e2 * t3373 * t4562 - 0.18e2 * t4403 * t4562 - t3850 + t3878 - t3881 - t3894 - 0.6e1 * t4233 + 0.6e1 * t4259 - 0.6e1 * t4261;
  t4612 = -0.2e1 * t1069 * t3924 - 0.3e1 * t1082 * t2171 - t1980 * t1114 - t1059 + t1064 - t1066 + t1151 - t1153 - t1159 - t1309 - t1312 + t1316 + t1326 + t1334 + t1351 - t1352 - t1353 - 0.3e1 * t3899 + 0.3e1 * t3901 - 0.3e1 * t3903;
  t4618 = -t1274 + t1185 + t1354 - 0.4e1 * t1280 + t1356 + t3922 + t3937 - t3941 + 0.2e1 * t4298 + 0.2e1 * t4303 - 0.2e1 * t4307;
  t4623 = my_piecewise5(t52, 0, t55, 0, t4515 + t4484 + t4448 + t4390 + 0.3e1 * t3721 + 0.3e1 * t3689 + 0.3e1 * t3692 + 0.3e1 * t3677 - t3666 + 0.3e1 * t3668 + 0.3e1 * t3661 - 0.3e1 * t3656 - t3658 - 0.3e1 * t3651 + t842 - t844 + t4618 + t4612 + t4602 + t4561 + t1073 + t1086 - t859 - t911 + t1174 + t908 - t1121 + t892);
  t4630 = my_piecewise3(t3, 0, t8 * t73 * t1367 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.25e2 / 0.81e2 * t1218 + 0.5e1 / 0.27e2 * t30 * t129 * t1038 + 0.4e2 / 0.243e3 * t30 * t223 * t380 - 0.5e1 / 0.81e2 * t30 * t110 * t1127 + t87 * t1365 + t47 * t4623));
  tv4rhosigmalapl20 = 0.2e1 * rho[0] * t4630 + 0.2e1 * t1371;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  t4641 = t1376 * t176;
  t4642 = t4641 * t424;
  t4643 = t89 * t4642;
  t4646 = t173 * t4642;
  t4650 = t173 * t1385 * t424;
  t4653 = t419 * t4642;
  t4675 = 0.9e1 * t1063 * t97 * t1536 * t286 - 0.9e1 * t1058 * t1840 * t3378 + 0.18e2 * t4653 * t3673 + 0.18e2 * t4653 * t3679 + 0.18e2 * t4646 * t3684 - 0.18e2 * t4653 * t3684 + 0.18e2 * t4650 * t3699 - 0.6e1 * t4643 * t3713 + 0.18e2 * t4646 * t3713 - 0.6e1 * t4653 * t3713 - 0.12e2 * t4653 * t3731 - 0.18e2 * t4643 * t824 - t319 - t374;
  t4692 = t1376 * t1488;
  t4693 = t173 * t4692;
  t4696 = -0.9e1 * t1058 * t183 * t1840 * t286 - 0.7e1 * t4693 * t3741 - 0.3e1 * t3971 + 0.9e1 * t3972 - 0.3e1 * t3979 + 0.9e1 * t3992 + 0.9e1 * t4000 - 0.9e1 * t4008 + 0.9e1 * t4011 - 0.9e1 * t4015 + 0.9e1 * t4028 - 0.6e1 * t4049 + 0.9e1 * t4071 + 0.9e1 * t4082;
  t4698 = t419 * t4692;
  t4701 = t89 * t4692;
  t4707 = t1485 * t4692;
  t4724 = t574 * t183 * t286;
  t4729 = t1677 * t428 * t1376 * t502;
  t4732 = -0.9e1 * t1075 * t4724 + 0.18e2 * t4698 * t3741 - 0.7e1 * t4707 * t3741 + 0.7e1 * t4707 * t3747 + 0.18e2 * t3757 * t4729 + 0.12e2 * t4698 * t3764 - 0.18e2 * t4698 * t3787 - 0.7e1 * t4693 * t3791 + 0.6e1 * t4698 * t3791 + t4701 * t3791 - t4707 * t3791 - 0.18e2 * t4693 * t3822 + 0.6e1 * t4701 * t3822 - 0.6e1 * t4707 * t3845;
  t4739 = t1494 * t1376;
  t4741 = t1654 * t4739 * t502;
  t4748 = t419 * t4641;
  t4749 = t428 * t91;
  t4758 = t501 * t1078;
  t4761 = t182 * t1376;
  t4763 = t1660 * t4761 * params->csk_a;
  t4766 = t1376 * t1506;
  t4767 = t173 * t4766;
  t4780 = -0.6e1 * t1075 * t513 * t528 * t286 - 0.6e1 * t4707 * t1654 * t1681 * t91 - 0.6e1 * t4748 * t513 * t4749 * t197 - 0.9e1 * t1069 * t4758 + 0.9e1 * t1075 * t2402 - 0.12e2 * t1416 * t3832 - 0.3e1 * t4767 * t241 - 0.3e1 * t4767 * t257 + 0.11e2 * t3757 * t4741 - 0.12e2 * t4707 * t3764 - 0.6e1 * t4707 * t3777 + 0.11e2 * t4701 * t3781 + 0.6e1 * t4698 * t3822 - 0.6e1 * t4698 * t3835 + 0.7e1 * t3927 * t4763;
  t4783 = t1376 * t91;
  t4794 = t501 * t503 * t286;
  t4812 = t497 * t4761 * t197;
  t4818 = 0.9e1 * t1085 * t188 * t492 * t286 + 0.3e1 * t89 * t4783 * t1998 - 0.3e1 * t1069 * t4794 + 0.9e1 * t1072 * t2432 + 0.9e1 * t1075 * t2359 - 0.3e1 * t1075 * t4794 + 0.9e1 * t1082 * t4724 + 0.9e1 * t1082 * t4758 + 0.9e1 * t1082 * t4794 - 0.18e2 * t234 * t4812 - 0.11e2 * t4693 * t3747 - 0.11e2 * t4693 * t3781 - 0.12e2 * t4698 * t3845 - 0.9e1 * t4154;
  t4827 = t1654 * t4739;
  t4834 = 0.3e1 * t173 * t4783 * t1512 + t3757 * t4827 + 0.6e1 * t4701 * t3909 - t1059 + t1064 - t1066 - 0.3e1 * t4169 + 0.3e1 * t4178 - 0.3e1 * t4183 - 0.6e1 * t4191 - 0.3e1 * t4224 - 0.9e1 * t4233 + 0.9e1 * t4259 - 0.9e1 * t4261;
  t4836 = t89 * t4766;
  t4845 = t1660 * t4761;
  t4852 = -0.6e1 * t1069 * t501 * t1118 + 0.6e1 * t4698 * t1677 * t4749 - 0.3e1 * t1075 * t2474 - 0.9e1 * t1082 * t2501 + 0.3e1 * t4836 * t252 + 0.11e2 * t3927 * t4845 + t1073 + t1086 - t1388 - t1390 + t1394 + t1395 - t1396 - t1397;
  t4853 = 0.6e1 * t1280;
  t4857 = t842 - t844 - t859 + t892 + t908 - t911 - t1121 + t1398 - t4853 + t1401 + t1418 + t1421 + 0.3e1 * t4298 + 0.3e1 * t4303 - 0.3e1 * t4307;
  t4861 = my_piecewise5(t52, 0, t55, 0, t4675 + t4696 + t4732 + t4780 + t4818 + t4834 + t4852 + t4857);
  t4868 = my_piecewise3(t3, 0, t8 * t73 * t1434 / 0.1e2 + 0.3e1 / 0.2e2 * t8 * t24 * (-0.25e2 / 0.54e2 * t1304 + 0.5e1 / 0.18e2 * t30 * t129 * t1127 + t87 * t1432 + t47 * t4861));
  tv4rholapl30 = 0.2e1 * rho[0] * t4868 + 0.2e1 * t1438;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t4874 = t317 * t317;
  t4875 = t89 * t4874;
  t4877 = 0.3e1 * t4875 * t199;
  t4879 = 0.3e1 * t4875 * t201;
  t4882 = 0.3e1 * t173 * t4874 * t184;
  t4883 = t310 * t310;
  t4884 = t89 * t4883;
  t4889 = t173 * t4883;
  t4900 = t317 * t310;
  t4901 = t4900 * t197;
  t4903 = t89 * t4901 * t464;
  t4905 = t173 * t4901;
  t4906 = t4905 * t464;
  t4908 = t4905 * t456;
  t4910 = t838 * t2786;
  t4913 = t501 * t503 * t317;
  t4914 = t848 * t4913;
  t4916 = t832 * t4913;
  t4918 = t4883 * t176;
  t4919 = t419 * t4918;
  t4922 = t838 * t2773;
  t4925 = t497 * t518 * t317;
  t4926 = t832 * t4925;
  t4928 = t838 * t4925;
  t4930 = 0.18e2 * t4919 * t1614 - t321 + 0.18e2 * t4903 - 0.18e2 * t4906 - 0.18e2 * t4908 + 0.18e2 * t4910 - 0.6e1 * t4914 + 0.18e2 * t4916 + 0.18e2 * t4922 + 0.18e2 * t4926 - 0.18e2 * t4928;
  t4933 = t513 * t528 * t317;
  t4934 = t838 * t4933;
  t4936 = t501 * t1149;
  t4937 = t848 * t4936;
  t4939 = t2697 * t1242;
  t4941 = t4883 * t197;
  t4942 = t89 * t4941;
  t4948 = t876 * t2872;
  t4952 = t838 * t4913;
  t4957 = t173 * t4918;
  t4966 = t89 * t4900 * t618;
  t4971 = t513 * t528 * t197;
  t4974 = t4883 * t1488;
  t4975 = t173 * t4974;
  t4978 = t419 * t4974;
  t4981 = t1485 * t4974;
  t4989 = -0.6e1 * t4919 * t1580 - 0.18e2 * t4919 * t1592 + 0.18e2 * t4957 * t1592 + 0.12e2 * t4978 * t1651 + 0.18e2 * t4978 * t1662 - 0.7e1 * t4981 * t1662 - 0.7e1 * t4975 * t1753 + 0.6e1 * t4978 * t1753 - t4981 * t1753 - 0.12e2 * t4919 * t4971 + 0.18e2 * t4966;
  t5006 = t89 * t4974;
  t5011 = t4874 * t176;
  t5012 = t173 * t5011;
  t5014 = 0.3e1 * t5012 * t190;
  t5018 = 0.3e1 * t89 * t5011 * t190;
  t5020 = 0.3e1 * t5012 * t207;
  t5026 = t4883 * t1506;
  t5027 = t173 * t5026;
  t5041 = 0.3e1 * t89 * t5026 * t190 - 0.7e1 * t4975 * t1662 - 0.18e2 * t4978 * t1693 + t5006 * t1753 - 0.18e2 * t4975 * t1763 + 0.6e1 * t4978 * t1763 + 0.6e1 * t5006 * t1763 - 0.3e1 * t5027 * t190 - 0.3e1 * t5027 * t207 + t5018 - t5020;
  t5045 = t2694 * t1285;
  t5051 = t832 * t2919;
  t5061 = t838 * t2906;
  t5075 = 0.4e1 * t1151 - 0.4e1 * t1153 - 0.4e1 * t1157 - 0.4e1 * t1159 - 0.4e1 * t1161 + 0.4e1 * t1165 + 0.4e1 * t1174 - 0.9e1 * t1183 + 0.4e1 * t1185 + 0.4e1 * t1188 + 0.4e1 * t1191;
  t5079 = my_piecewise5(t52, 0, t55, 0, -0.12e2 * t4942 * t1707 - 0.6e1 * t4978 * t1678 - 0.12e2 * t4978 * t1768 + 0.7e1 * t4975 * t1693 - 0.6e1 * t4919 * t1743 + 0.11e2 * t5006 * t1719 - 0.11e2 * t4975 * t1719 + 0.7e1 * t4981 * t1696 - 0.6e1 * t4981 * t1682 - 0.18e2 * t4957 * t1728 + 0.18e2 * t4981 * t1678 - 0.12e2 * t4981 * t1651 + 0.11e2 * t4981 * t1671 - 0.6e1 * t4981 * t1656 + 0.18e2 * t4957 * t1580 - 0.18e2 * t4942 * t1553 + 0.18e2 * t4919 * t1606 + 0.6e1 * t4884 * t1503 + 0.3e1 * t4889 * t1512 + 0.11e2 * t4889 * t1515 + 0.3e1 * t4884 * t1508 - 0.6e1 * t4981 * t1768 - 0.11e2 * t4975 * t1696 + 0.6e1 * t419 * t4883 * t1519 + t1485 * t4883 * t1496 + 0.18e2 * t173 * t4941 * t1553 - 0.6e1 * t89 * t4918 * t1580 - t319 + t5075 - 0.6e1 * t5061 - 0.18e2 * t5051 - 0.12e2 * t5045 + t5041 - t5014 + t4989 - 0.6e1 * t4952 + 0.18e2 * t4948 + 0.18e2 * t4939 - 0.12e2 * t4934 - 0.18e2 * t4937 + t4930 + t4882 - t4877 + t4879);
  t5085 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (-0.2e2 / 0.81e2 * t30 * t110 * t1206 + t47 * t5079));
  tv4sigma40 = 0.2e1 * rho[0] * t5085;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t5093 = t136 * t1140;
  t5094 = t5093 * t197;
  t5099 = t502 * t1140 * t197;
  t5103 = t3650 * t3070;
  t5104 = 0.9e1 * t5103;
  t5105 = t3663 * t118;
  t5106 = t183 * t5105;
  t5107 = t992 * t5106;
  t5108 = 0.9e1 * t5107;
  t5109 = t97 * t5105;
  t5110 = t964 * t5109;
  t5111 = 0.3e1 * t5110;
  t5112 = t992 * t5109;
  t5113 = 0.9e1 * t5112;
  t5114 = t970 * t5109;
  t5115 = 0.3e1 * t5114;
  t5119 = t97 * t3653 * t118;
  t5120 = t964 * t5119;
  t5121 = 0.9e1 * t5120;
  t5122 = -0.6e1 * t419 * t5094 * t1573 - 0.6e1 * t2278 * t97 * t5099 + 0.18e2 * t3672 * t2248 - t319 - t4877 + t4879 + t4882 + t5104 + t5108 - t5111 + t5113 - t5115 - t5121;
  t5123 = t992 * t5119;
  t5124 = 0.9e1 * t5123;
  t5125 = t173 * t5094;
  t5135 = t183 * t5099;
  t5146 = t970 * t429 * t5105;
  t5147 = 0.6e1 * t5146;
  t5149 = t2583 * t183 * t948;
  t5150 = 0.9e1 * t5149;
  t5151 = t3650 * t3222;
  t5152 = 0.9e1 * t5151;
  t5153 = t4070 * t1332;
  t5154 = 0.9e1 * t5153;
  t5155 = t970 * t5106;
  t5156 = 0.9e1 * t5155;
  t5158 = -0.18e2 * t2278 * t97 * params->csk_a * t1140 * t197 - 0.12e2 * t4235 * t429 * t5099 + 0.18e2 * t5125 * t1553 + 0.18e2 * t5125 * t1573 + 0.18e2 * t3672 * t2263 + 0.18e2 * t2310 * t5135 - 0.18e2 * t4235 * t5135 + 0.9e1 * t4903 + t5124 - t5147 + t5150 + t5152 + t5154 - t5156;
  t5166 = t1650 * t1140 * t180 * t182;
  t5170 = t1677 * t1948 * t1140;
  t5176 = t1140 * t62 * t96;
  t5177 = t1762 * t5176;
  t5185 = t1751 * t1752 * t1140;
  t5192 = 0.18e2 * t2316 * t5166 + 0.12e2 * t2316 * t5170 + 0.6e1 * t2316 * t5177 + 0.6e1 * t2316 * t5185 - 0.7e1 * t2330 * t5166 - 0.18e2 * t2330 * t5177 - 0.7e1 * t2330 * t5185 + 0.6e1 * t2333 * t5177 + t2333 * t5185 - t2355 * t5185 - 0.6e1 * t3746 * t2416 - 0.9e1 * t4906 - 0.9e1 * t4908;
  t5193 = t1718 * t5176;
  t5209 = t718 * t501 * t1281 * t118;
  t5210 = 0.6e1 * t5209;
  t5211 = t89 * t5093;
  t5218 = t173 * t5093;
  t5228 = -0.11e2 * t2330 * t1660 * t518 * t1140 - 0.6e1 * t419 * t3670 * t2436 + 0.3e1 * t5211 * t1998 - 0.3e1 * t5218 * t1998 - 0.12e2 * t5211 * t2013 - 0.3e1 * t5218 * t2017 - 0.6e1 * t2316 * t3760 - 0.11e2 * t2330 * t5193 + 0.11e2 * t2333 * t5193 - 0.7e1 * t2355 * t5166 + 0.7e1 * t3746 * t2410 - 0.12e2 * t3786 * t2416 + 0.9e1 * t4910 - t5210;
  t5248 = t573 * t4182;
  t5249 = 0.3e1 * t5248;
  t5256 = t2697 * t497 * t278 * t118;
  t5257 = 0.9e1 * t5256;
  t5259 = -0.6e1 * t2355 * t1654 * t1655 * t1140 - 0.18e2 * t173 * t3670 * t2325 - 0.12e2 * t2355 * t5170 + 0.7e1 * t3739 * t2367 - 0.18e2 * t3786 * t2367 + 0.11e2 * t3746 * t2395 - 0.6e1 * t3746 * t2406 + 0.18e2 * t3746 * t2420 - 0.3e1 * t4914 + 0.9e1 * t4916 + 0.9e1 * t4922 - t5249 - t5257;
  t5269 = t188 * t96 * t1306;
  t5270 = t4070 * t5269;
  t5271 = 0.9e1 * t5270;
  t5272 = t4232 * t5269;
  t5273 = 0.9e1 * t5272;
  t5275 = t4232 * t959 * t1306;
  t5276 = 0.9e1 * t5275;
  t5280 = 0.9e1 * t4926 - 0.9e1 * t4928 - 0.6e1 * t4934 - 0.9e1 * t4937 + 0.9e1 * t4939 + 0.9e1 * t4948 - 0.3e1 * t4952 + 0.9e1 * t4966 + t5271 - t5273 - t5276 - 0.4e1 * t1223 + 0.4e1 * t1228 - 0.4e1 * t1230;
  t5298 = 0.6e1 * t2333 * t1751 * t96 * t1140 + 0.3e1 * t5211 * t1508 + t3746 * t2477 + 0.11e2 * t3739 * t2498 + 0.6e1 * t3786 * t2504 + 0.3e1 * t3812 * t279 + t1234 - t5014 + t5018 - t5020 - 0.6e1 * t5045 - 0.9e1 * t5051 - 0.3e1 * t5061;
  t5301 = -t1239 + 0.4e1 * t1248 + 0.4e1 * t1250 + t1152 - t1154 - t1160 - t1268 - t347 + t1175 - t3907 + t1186 + t1276 - t1399 + t1283;
  t5305 = my_piecewise5(t52, 0, t55, 0, t5122 + t5158 + t5192 + t5228 + t5259 + t5280 + t5298 + t5301);
  t5311 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.54e2 * t30 * t129 * t1206 - 0.5e1 / 0.27e2 * t30 * t110 * t1292 + t47 * t5305));
  tv4sigma3lapl0 = 0.2e1 * rho[0] * t5311;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  t5320 = t97 * t313 * params->csk_a;
  t5328 = t3980 * t197;
  t5329 = t97 * t5328;
  t5336 = t2644 * t2781;
  t5345 = t1058 * t3653 * t463;
  t5347 = 0.18e2 * t3361 * t183 * t1226 - 0.12e2 * t3361 * t429 * t5328 - 0.6e1 * t3361 * t5329 - 0.18e2 * t3361 * t5336 - 0.6e1 * t3364 * t5329 + 0.18e2 * t3367 * t5329 + 0.18e2 * t3367 * t5336 + 0.18e2 * t3373 * t5320 - 0.18e2 * t4403 * t5320 - t319 - t374 - t4877 + t4879 + t4882 - 0.3e1 * t5345;
  t5352 = t1063 * t97 * t3653 * t197;
  t5356 = t1058 * t183 * t3653 * t93;
  t5371 = 0.18e2 * t3361 * t2670 + 0.3e1 * t4903 + 0.12e2 * t5103 + 0.12e2 * t5107 - 0.4e1 * t5110 + 0.12e2 * t5112 - 0.4e1 * t5114 - 0.12e2 * t5120 + 0.12e2 * t5123 - 0.8e1 * t5146 + 0.12e2 * t5149 + 0.12e2 * t5151 + 0.12e2 * t5153 - 0.12e2 * t5155 + 0.3e1 * t5352 - 0.3e1 * t5356;
  t5378 = t1660 * t1661 * t310;
  t5382 = t1751 * t1752 * t310;
  t5388 = t1751 * t4118;
  t5406 = -0.12e2 * t2685 * t3506 - 0.6e1 * t2732 * t3506 + 0.7e1 * t3435 * t2797 - 0.18e2 * t3438 * t2797 + 0.7e1 * t3445 * t2810 - 0.7e1 * t3435 * t5378 - 0.7e1 * t3435 * t5382 - 0.11e2 * t3435 * t5388 + 0.18e2 * t3438 * t5378 + 0.6e1 * t3438 * t5382 - 0.7e1 * t3445 * t5378 - t3445 * t5382 + t3447 * t5382 + 0.11e2 * t3447 * t5388 - 0.3e1 * t4906 - 0.3e1 * t4908;
  t5408 = t1677 * t1948 * t310;
  t5411 = t367 * t310;
  t5418 = t1751 * t1254;
  t5441 = t1069 * t4936;
  t5443 = t1075 * t2786;
  t5445 = t1069 * t4913;
  t5446 = t1082 * t4913;
  t5448 = -0.12e2 * t1085 * t501 * t1284 * t176 - 0.6e1 * t3438 * t1677 * t1269 + 0.3e1 * t89 * t5411 * t1998 - 0.3e1 * t3460 * t205 * t2796 - 0.6e1 * t419 * t313 * t3487 - 0.18e2 * t376 * t2782 - 0.11e2 * t3435 * t2810 - 0.18e2 * t3435 * t5418 + 0.12e2 * t3438 * t5408 + 0.6e1 * t3438 * t5418 + 0.6e1 * t3447 * t5418 - 0.3e1 * t3460 * t4119 - 0.3e1 * t5441 + 0.3e1 * t5443 - t5445 + 0.3e1 * t5446;
  t5451 = t1075 * t4913;
  t5452 = t1075 * t2773;
  t5454 = t1082 * t4925;
  t5458 = t1085 * t188 * t1281 * t93;
  t5462 = t1075 * t4925;
  t5470 = t1075 * t4933;
  t5480 = t1072 * t2872;
  t5482 = t1082 * t4936;
  t5486 = 0.18e2 * t2732 * t1677 * t1113 * t502 - 0.6e1 * t3445 * t1654 * t1655 * t310 + 0.11e2 * t2732 * t1654 * t3496 * t502 - 0.6e1 * t2732 * t3498 - 0.12e2 * t3445 * t5408 + 0.3e1 * t4910 - 0.8e1 * t5209 - t5451 + 0.3e1 * t5452 + 0.3e1 * t5454 + 0.3e1 * t5458 - 0.3e1 * t5462 - 0.2e1 * t5470 + 0.3e1 * t5480 + 0.3e1 * t5482;
  t5501 = -t4914 + 0.3e1 * t4916 - 0.4e1 * t5248 - 0.12e2 * t5256 + 0.3e1 * t4922 + 0.3e1 * t4926 - 0.3e1 * t4928 - 0.2e1 * t4934 - 0.3e1 * t4937 + 0.3e1 * t4939 + 0.3e1 * t4948 - t4952 + 0.3e1 * t4966 + 0.12e2 * t5270 - 0.12e2 * t5272 - 0.12e2 * t5275;
  t5519 = t2737 * t1114;
  t5521 = t1082 * t2919;
  t5524 = t1069 * t501 * t1281;
  t5527 = 0.6e1 * t3447 * t1751 * t1284 + 0.3e1 * t3586 * t188 * t1284 + 0.3e1 * t173 * t5411 * t1512 + 0.6e1 * t2685 * t3603 + t2732 * t3611 + 0.11e2 * t3435 * t2925 - 0.4e1 * t1308 - 0.4e1 * t1311 + 0.4e1 * t1315 - t5014 + t5018 - t5020 - 0.2e1 * t5045 - t5519 - 0.3e1 * t5521 - 0.2e1 * t5524;
  t5531 = -0.3e1 * t5051 - t5061 + 0.4e1 * t1325 + 0.4e1 * t1333 + t1351 - t1352 + t1261 - t1262 - t1263 - t1353 + t1273 - t1184 + t1275 + t1354 - t4853 + t1356;
  t5535 = my_piecewise5(t52, 0, t55, 0, t5347 + t5371 + t5406 + t5448 + t5486 + t5501 + t5527 + t5531);
  t5541 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.27e2 * t30 * t129 * t1292 - 0.1e2 / 0.81e2 * t30 * t110 * t1365 + t47 * t5535));
  tv4sigma2lapl20 = 0.2e1 * rho[0] * t5541;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  t5550 = t502 * t197 * t118;
  t5551 = t97 * t5550;
  t5565 = t183 * t5550;
  t5573 = 0.18e2 * t4650 * t965 * t1552 - 0.12e2 * t4653 * t429 * t5550 - 0.18e2 * t4643 * t1314 + 0.18e2 * t4653 * t1888 - 0.6e1 * t4643 * t5551 + 0.18e2 * t4646 * t5551 + 0.18e2 * t4646 * t5565 - 0.6e1 * t4653 * t5551 - 0.18e2 * t4653 * t5565 - t319 - t374 - t4877 + t4879 + t4882;
  t5579 = 0.18e2 * t4653 * t1868 + t5104 + t5108 - t5111 + t5113 - t5115 - t5121 + t5124 - t5147 + t5150 + t5152 - 0.9e1 * t5345 + 0.9e1 * t5352 - 0.9e1 * t5356;
  t5581 = t1762 * t1344;
  t5584 = t1650 * t1317;
  t5588 = t1677 * t1948 * t118;
  t5596 = t1751 * t1752 * t118;
  t5609 = -0.18e2 * t4698 * t1963 - 0.12e2 * t4698 * t2121 - 0.6e1 * t4707 * t2121 - 0.18e2 * t4693 * t5581 - 0.7e1 * t4693 * t5584 - 0.7e1 * t4693 * t5596 + 0.18e2 * t4698 * t5584 + 0.12e2 * t4698 * t5588 + 0.6e1 * t4698 * t5596 + 0.6e1 * t4701 * t5581 + t4701 * t5596 - t4707 * t5596 + t5154 - t5156;
  t5610 = t1718 * t1344;
  t5629 = t1376 * t118;
  t5643 = -0.12e2 * t1416 * t501 * t1706 * t118 + 0.3e1 * t89 * t5629 * t1998 + 0.7e1 * t1958 * t4763 - 0.11e2 * t4693 * t1990 + 0.7e1 * t4707 * t1990 - 0.6e1 * t4707 * t2082 - 0.6e1 * t4698 * t2126 - 0.18e2 * t254 * t4812 - 0.3e1 * t4767 * t343 - 0.3e1 * t4767 * t353 - 0.11e2 * t4693 * t5610 + 0.6e1 * t4698 * t5581 + 0.11e2 * t4701 * t5610 - 0.7e1 * t4707 * t5584;
  t5667 = -0.6e1 * t4707 * t1654 * t1655 * t118 + 0.18e2 * t1974 * t4729 + 0.11e2 * t1974 * t4741 - 0.6e1 * t4748 * t2049 - 0.12e2 * t4707 * t5588 - 0.9e1 * t5441 + 0.9e1 * t5443 - 0.3e1 * t5445 + 0.9e1 * t5446 - 0.3e1 * t5451 + 0.9e1 * t5452 + 0.9e1 * t5454 + 0.9e1 * t5458 - 0.9e1 * t5462;
  t5676 = 0.6e1 * t4701 * t1751 * t348 + 0.6e1 * t4698 * t2174 - t1308 - t1311 + t1315 - t5210 - t5249 - t5257 + t5271 - t5273 - t5276 - 0.6e1 * t5470 + 0.9e1 * t5480 + 0.9e1 * t5482;
  t5689 = 0.3e1 * t173 * t5629 * t1512 + 0.11e2 * t1958 * t4845 + t1974 * t4827 + 0.3e1 * t4836 * t349 + t1325 + t1333 - t1388 - t1390 - t5014 + t5018 - t5020 - 0.3e1 * t5519 - 0.9e1 * t5521 - 0.6e1 * t5524;
  t5691 = t1394 + t1395 - t1396 + t1151 - t1153 - t1159 - t1397 + t1174 - t1183 + t1185 + t1398 - 0.8e1 * t1280 + t1401 + t1418 + t1421;
  t5695 = my_piecewise5(t52, 0, t55, 0, t5573 + t5579 + t5609 + t5643 + t5667 + t5676 + t5689 + t5691);
  t5701 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.5e1 / 0.18e2 * t30 * t129 * t1365 - 0.5e1 / 0.81e2 * t30 * t110 * t1432 + t47 * t5695));
  tv4sigmalapl30 = 0.2e1 * rho[0] * t5701;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  t5706 = t367 * t367;
  t5709 = t173 * t5706;
  t5712 = t89 * t5706;
  t5726 = t5706 * t197;
  t5730 = t5706 * t176;
  t5731 = t89 * t5730;
  t5734 = t419 * t5730;
  t5741 = t173 * t5730;
  t5746 = 0.18e2 * t173 * t5726 * t1553 - 0.18e2 * t5731 * t1558 - 0.6e1 * t5731 * t1580 - 0.18e2 * t5734 * t1592 + 0.18e2 * t5741 * t1592 + 0.18e2 * t5734 * t1606 - 0.12e2 * t5734 * t4971 - t374 - 0.18e2 * t5345 + 0.18e2 * t5352 - 0.18e2 * t5356;
  t5767 = t5706 * t1488;
  t5768 = t173 * t5767;
  t5771 = t419 * t5767;
  t5774 = t1485 * t5767;
  t5778 = t89 * t5767;
  t5783 = -0.7e1 * t5768 * t1753 + 0.6e1 * t5771 * t1753 - t5774 * t1753 - 0.18e2 * t5768 * t1763 + 0.6e1 * t5778 * t1763 - 0.6e1 * t5774 * t1768 + 0.18e2 * t5458 - 0.18e2 * t5462 - 0.12e2 * t5470 + 0.18e2 * t5480 + 0.18e2 * t5482;
  t5818 = t5706 * t1506;
  t5819 = t173 * t5818;
  t5832 = -0.12e2 * t89 * t5726 * t1707 + 0.3e1 * t89 * t5818 * t190 - 0.7e1 * t5774 * t1662 + 0.7e1 * t5774 * t1696 - 0.11e2 * t5768 * t1719 + 0.11e2 * t5778 * t1719 - 0.6e1 * t5734 * t1743 + 0.6e1 * t5771 * t1763 - 0.12e2 * t5771 * t1768 - 0.3e1 * t5819 * t190 - 0.3e1 * t5819 * t207;
  t5857 = -0.4e1 * t1387 - 0.4e1 * t1389 + 0.4e1 * t1393 + 0.4e1 * t1234 - 0.4e1 * t1239 - 0.4e1 * t1268 + 0.4e1 * t1276 - 0.9e1 * t1280 + 0.4e1 * t1283 + 0.4e1 * t1417 + 0.4e1 * t1420;
  t5861 = my_piecewise5(t52, 0, t55, 0, -0.6e1 * t5774 * t1656 - 0.6e1 * t5771 * t1678 - 0.18e2 * t5741 * t1728 - 0.6e1 * t5774 * t1682 + 0.7e1 * t5768 * t1693 + 0.11e2 * t5709 * t1515 + 0.6e1 * t5712 * t1503 + 0.3e1 * t5709 * t1512 + 0.3e1 * t5712 * t1508 + 0.18e2 * t5741 * t1580 + 0.18e2 * t5734 * t1614 - 0.6e1 * t5734 * t1580 + 0.18e2 * t5771 * t1662 + 0.12e2 * t5771 * t1651 - 0.7e1 * t5768 * t1662 - 0.18e2 * t5771 * t1693 + t5778 * t1753 - 0.11e2 * t5768 * t1696 + 0.18e2 * t5774 * t1678 - 0.12e2 * t5774 * t1651 + 0.11e2 * t5774 * t1671 + t1485 * t5706 * t1496 + 0.6e1 * t419 * t5706 * t1519 + t5857 + t5832 + t5783 + t5746 - 0.18e2 * t5521 - 0.12e2 * t5524 - 0.6e1 * t5519 + 0.18e2 * t5454 - 0.6e1 * t5451 + 0.18e2 * t5452 - 0.6e1 * t5445 + 0.18e2 * t5446 - 0.18e2 * t5441 + 0.18e2 * t5443 - t319 - t5020 + t5018 - t5014 + t4882 - t4877 + t4879);
  t5867 = my_piecewise3(t3, 0, 0.3e1 / 0.2e2 * t8 * t24 * (0.1e2 / 0.27e2 * t30 * t129 * t1432 + t47 * t5861));
  tv4lapl40 = 0.2e1 * rho[0] * t5867;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  double t122, t123, t124, t126, t129, t130, t134, t135;
  double t138, t141, t143, t149, t151, t152, t153, t155;
  double t156, t158, t159, t160, t162, t164, t169, t170;
  double t172, t175, t176, t180, t183, t185, tvrho0, t189;
  double t192, t193, t198, t200, t203, t204, t210, t212;
  double t218, t220, t221, t222, t224, t225, t227, t228;
  double t229, t231, t233, t238, tvrho1, t241, t244, t247;
  double t248, t251, t253, t257, tvsigma0, tvsigma1, t258, t261;
  double t264, t265, t268, t270, t274, tvsigma2, t280, t281;
  double t284, t286, t290, tvlapl0, t296, t297, t300, t302;
  double t306, tvlapl1, tvtau0, tvtau1;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t122 = t8 * t8;
  t123 = 0.1e1 / t122;
  t124 = t18 * t123;
  t126 = my_piecewise5(t12, 0, t16, 0, t9 - t124);
  t129 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t126);
  t130 = t129 * t31;
  t134 = 0.1e1 / t30;
  t135 = t29 * t134;
  t138 = t7 * t135 * t73 / 0.1e2;
  t141 = 0.1e1 / t41 / t39 / rho[0];
  t143 = t38 * sigma[0] * t141;
  t149 = -0.25e2 / 0.162e3 * t38 * lapl[0] * t43 + 0.4e2 / 0.243e3 * t143;
  t151 = t70 * t67;
  t152 = my_piecewise3(t61, 0, t149);
  t153 = my_piecewise3(t63, t152, 0);
  t155 = fabs(t64) / t64;
  t156 = 0.1e1 / t65;
  t158 = 0.1e1 / t69;
  t159 = t68 * t158;
  t160 = t155 * t156 * t159;
  t162 = my_piecewise5(t58, 0, t61, 0, -t151 * t153 * t160);
  t164 = -0.5e1 / 0.27e2 * t143 + t149 * t71 + t53 * t162;
  t169 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t73 + t138 + 0.3e1 / 0.2e2 * t7 * t32 * t164);
  t170 = t79 * t123;
  t172 = my_piecewise5(t16, 0, t12, 0, -t9 - t170);
  t175 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t172);
  t176 = t175 * t31;
  t180 = t87 * t134;
  t183 = t7 * t180 * t117 / 0.1e2;
  t185 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t117 + t183);
  tvrho0 = t77 + t121 + t8 * (t169 + t185);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t189 = my_piecewise5(t12, 0, t16, 0, -t9 - t124);
  t192 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t189);
  t193 = t192 * t31;
  t198 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t73 + t138);
  t200 = my_piecewise5(t16, 0, t12, 0, t9 - t170);
  t203 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t200);
  t204 = t203 * t31;
  t210 = 0.1e1 / t91 / t89 / rho[1];
  t212 = t38 * sigma[2] * t210;
  t218 = -0.25e2 / 0.162e3 * t38 * lapl[1] * t93 + 0.4e2 / 0.243e3 * t212;
  t220 = t114 * t111;
  t221 = my_piecewise3(t105, 0, t218);
  t222 = my_piecewise3(t107, t221, 0);
  t224 = fabs(t108) / t108;
  t225 = 0.1e1 / t109;
  t227 = 0.1e1 / t113;
  t228 = t112 * t227;
  t229 = t224 * t225 * t228;
  t231 = my_piecewise5(t104, 0, t105, 0, -t220 * t222 * t229);
  t233 = -0.5e1 / 0.27e2 * t212 + t218 * t115 + t103 * t231;
  t238 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t117 + t183 + 0.3e1 / 0.2e2 * t7 * t88 * t233);
  tvrho1 = t77 + t121 + t8 * (t198 + t238);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t241 = t38 * t43;
  t244 = t38 * t43 * t71;
  t247 = my_piecewise3(t61, 0, -0.5e1 / 0.81e2 * t241);
  t248 = my_piecewise3(t63, t247, 0);
  t251 = my_piecewise5(t58, 0, t61, 0, -t151 * t248 * t160);
  t253 = 0.5e1 / 0.72e2 * t241 - 0.5e1 / 0.81e2 * t244 + t53 * t251;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t253);
  tvsigma0 = t8 * t257;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t258 = t38 * t93;
  t261 = t38 * t93 * t115;
  t264 = my_piecewise3(t105, 0, -0.5e1 / 0.81e2 * t258);
  t265 = my_piecewise3(t107, t264, 0);
  t268 = my_piecewise5(t104, 0, t105, 0, -t220 * t265 * t229);
  t270 = 0.5e1 / 0.72e2 * t258 - 0.5e1 / 0.81e2 * t261 + t103 * t268;
  t274 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t270);
  tvsigma2 = t8 * t274;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t280 = my_piecewise3(t61, 0, 0.5e1 / 0.54e2 * t38 * t48);
  t281 = my_piecewise3(t63, t280, 0);
  t284 = my_piecewise5(t58, 0, t61, 0, -t151 * t281 * t160);
  t286 = 0.5e1 / 0.54e2 * t38 * t48 * t71 + t53 * t284;
  t290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t286);
  tvlapl0 = t8 * t290;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t296 = my_piecewise3(t105, 0, 0.5e1 / 0.54e2 * t38 * t98);
  t297 = my_piecewise3(t107, t296, 0);
  t300 = my_piecewise5(t104, 0, t105, 0, -t220 * t297 * t229);
  t302 = 0.5e1 / 0.54e2 * t38 * t98 * t115 + t103 * t300;
  t306 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t302);
  tvlapl1 = t8 * t306;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  double t122, t123, t124, t126, t129, t130, t134, t135;
  double t138, t141, t143, t149, t151, t152, t153, t155;
  double t156, t158, t159, t160, t162, t164, t169, t170;
  double t172, t175, t176, t180, t183, t185, tvrho0, t189;
  double t192, t193, t198, t200, t203, t204, t210, t212;
  double t218, t220, t221, t222, t224, t225, t227, t228;
  double t229, t231, t233, t238, tvrho1, t241, t244, t247;
  double t248, t251, t253, t257, tvsigma0, tvsigma1, t258, t261;
  double t264, t265, t268, t270, t274, tvsigma2, t280, t281;
  double t284, t286, t290, tvlapl0, t296, t297, t300, t302;
  double t306, tvlapl1, tvtau0, tvtau1;

  double t309, t310, t313, t314, t315, t318, t322, t323;
  double t327, t329, t335, t336, t339, t341, t343, t345;
  double t347, t353, t357, t359, t360, t362, t363, t364;
  double t365, t366, t367, t368, t369, t370, t372, t374;
  double t375, t376, t378, t379, t382, t383, t385, t386;
  double t387, t389, t391, t392, t393, t396, t398, t403;
  double t404, t405, t408, t411, t415, t416, t420, t422;
  double t424, t427, t429, tv2rho20, t432, t436, t440, t441;
  double t445, t447, t455, t456, t460, t464, t465, t469;
  double t471, t478, t481, tv2rho21, t486, t491, t495, t496;
  double t502, t503, t508, t512, t513, t522, t524, t526;
  double t532, t536, t538, t539, t541, t542, t543, t544;
  double t545, t546, t547, t548, t549, t551, t553, t554;
  double t555, t557, t558, t561, t562, t564, t565, t566;
  double t568, t570, t571, t572, t575, t577, t582, tv2rho22;
  double t590, t591, t594, t597, t600, t601, t602, t603;
  double t605, t606, t607, t608, t611, t612, t615, t617;
  double t618, t619, t621, t623, t624, t627, t629, t634;
  double tv2rhosigma0, tv2rhosigma1, t641, t643, tv2rhosigma2, t649, tv2rhosigma3, tv2rhosigma4;
  double t654, t657, t660, t663, t664, t665, t666, t668;
  double t669, t671, t674, t675, t678, t680, t681, t682;
  double t684, t686, t687, t690, t692, t697, tv2rhosigma5, t704;
  double t710, t711, t713, t714, t717, t718, t721, t723;
  double t725, t729, t731, t736, tv2rholapl0, t743, t745, tv2rholapl1;
  double t751, tv2rholapl2, t761, t762, t764, t765, t768, t769;
  double t772, t774, t776, t780, t782, t787, tv2rholapl3, tv2rhotau0;
  double tv2rhotau1, tv2rhotau2, tv2rhotau3, t790, t792, t795, t798, t799;
  double t801, t802, t803, t805, t809, t811, t815, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t817, t819, t822, t825;
  double t826, t828, t829, t830, t832, t836, t838, t842;
  double tv2sigma25, t847, t850, t851, t853, t854, t855, t856;
  double t857, t860, t861, t864, t866, t870, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t875, t878, t879, t881, t882;
  double t883, t884, t885, t888, t889, t892, t894, t898;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t902;
  double t905, t906, t908, t909, t911, t915, t917, t921;
  double tv2lapl20, tv2lapl21, t925, t928, t929, t931, t932, t934;
  double t938, t940, t944, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3;
  double tv2tau20, tv2tau21, tv2tau22;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t122 = t8 * t8;
  t123 = 0.1e1 / t122;
  t124 = t18 * t123;
  t126 = my_piecewise5(t12, 0, t16, 0, t9 - t124);
  t129 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t126);
  t130 = t129 * t31;
  t134 = 0.1e1 / t30;
  t135 = t29 * t134;
  t138 = t7 * t135 * t73 / 0.1e2;
  t141 = 0.1e1 / t41 / t39 / rho[0];
  t143 = t38 * sigma[0] * t141;
  t149 = -0.25e2 / 0.162e3 * t38 * lapl[0] * t43 + 0.4e2 / 0.243e3 * t143;
  t151 = t70 * t67;
  t152 = my_piecewise3(t61, 0, t149);
  t153 = my_piecewise3(t63, t152, 0);
  t155 = fabs(t64) / t64;
  t156 = 0.1e1 / t65;
  t158 = 0.1e1 / t69;
  t159 = t68 * t158;
  t160 = t155 * t156 * t159;
  t162 = my_piecewise5(t58, 0, t61, 0, -t151 * t153 * t160);
  t164 = -0.5e1 / 0.27e2 * t143 + t149 * t71 + t53 * t162;
  t169 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t73 + t138 + 0.3e1 / 0.2e2 * t7 * t32 * t164);
  t170 = t79 * t123;
  t172 = my_piecewise5(t16, 0, t12, 0, -t9 - t170);
  t175 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t172);
  t176 = t175 * t31;
  t180 = t87 * t134;
  t183 = t7 * t180 * t117 / 0.1e2;
  t185 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t117 + t183);
  tvrho0 = t77 + t121 + t8 * (t169 + t185);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t189 = my_piecewise5(t12, 0, t16, 0, -t9 - t124);
  t192 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t189);
  t193 = t192 * t31;
  t198 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t73 + t138);
  t200 = my_piecewise5(t16, 0, t12, 0, t9 - t170);
  t203 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t200);
  t204 = t203 * t31;
  t210 = 0.1e1 / t91 / t89 / rho[1];
  t212 = t38 * sigma[2] * t210;
  t218 = -0.25e2 / 0.162e3 * t38 * lapl[1] * t93 + 0.4e2 / 0.243e3 * t212;
  t220 = t114 * t111;
  t221 = my_piecewise3(t105, 0, t218);
  t222 = my_piecewise3(t107, t221, 0);
  t224 = fabs(t108) / t108;
  t225 = 0.1e1 / t109;
  t227 = 0.1e1 / t113;
  t228 = t112 * t227;
  t229 = t224 * t225 * t228;
  t231 = my_piecewise5(t104, 0, t105, 0, -t220 * t222 * t229);
  t233 = -0.5e1 / 0.27e2 * t212 + t218 * t115 + t103 * t231;
  t238 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t117 + t183 + 0.3e1 / 0.2e2 * t7 * t88 * t233);
  tvrho1 = t77 + t121 + t8 * (t198 + t238);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t241 = t38 * t43;
  t244 = t38 * t43 * t71;
  t247 = my_piecewise3(t61, 0, -0.5e1 / 0.81e2 * t241);
  t248 = my_piecewise3(t63, t247, 0);
  t251 = my_piecewise5(t58, 0, t61, 0, -t151 * t248 * t160);
  t253 = 0.5e1 / 0.72e2 * t241 - 0.5e1 / 0.81e2 * t244 + t53 * t251;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t253);
  tvsigma0 = t8 * t257;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t258 = t38 * t93;
  t261 = t38 * t93 * t115;
  t264 = my_piecewise3(t105, 0, -0.5e1 / 0.81e2 * t258);
  t265 = my_piecewise3(t107, t264, 0);
  t268 = my_piecewise5(t104, 0, t105, 0, -t220 * t265 * t229);
  t270 = 0.5e1 / 0.72e2 * t258 - 0.5e1 / 0.81e2 * t261 + t103 * t268;
  t274 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t270);
  tvsigma2 = t8 * t274;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t280 = my_piecewise3(t61, 0, 0.5e1 / 0.54e2 * t38 * t48);
  t281 = my_piecewise3(t63, t280, 0);
  t284 = my_piecewise5(t58, 0, t61, 0, -t151 * t281 * t160);
  t286 = 0.5e1 / 0.54e2 * t38 * t48 * t71 + t53 * t284;
  t290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t286);
  tvlapl0 = t8 * t290;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t296 = my_piecewise3(t105, 0, 0.5e1 / 0.54e2 * t38 * t98);
  t297 = my_piecewise3(t107, t296, 0);
  t300 = my_piecewise5(t104, 0, t105, 0, -t220 * t297 * t229);
  t302 = 0.5e1 / 0.54e2 * t38 * t98 * t115 + t103 * t300;
  t306 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t302);
  tvlapl1 = t8 * t306;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t309 = 0.1e1 / t26;
  t310 = t126 * t126;
  t313 = t122 * t8;
  t314 = 0.1e1 / t313;
  t315 = t18 * t314;
  t318 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t123 + 0.2e1 * t315);
  t322 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t310 + 0.5e1 / 0.3e1 * t27 * t318);
  t323 = t322 * t31;
  t327 = t129 * t134;
  t329 = t7 * t327 * t73;
  t335 = 0.1e1 / t30 / t8;
  t336 = t29 * t335;
  t339 = t7 * t336 * t73 / 0.3e2;
  t341 = t7 * t135 * t164;
  t343 = t39 * t39;
  t345 = 0.1e1 / t41 / t343;
  t347 = t38 * sigma[0] * t345;
  t353 = 0.1e3 / 0.243e3 * t38 * lapl[0] * t141 - 0.44e3 / 0.729e3 * t347;
  t357 = t66 * t66;
  t359 = t70 / t357;
  t360 = t153 * t153;
  t362 = t155 * t155;
  t363 = t65 * t65;
  t364 = 0.1e1 / t363;
  t365 = t362 * t364;
  t366 = t68 * t68;
  t367 = t69 * t69;
  t368 = 0.1e1 / t367;
  t369 = t366 * t368;
  t370 = t365 * t369;
  t372 = t360 * t362;
  t374 = t364 * t68;
  t375 = t158 * params->csk_a;
  t376 = t374 * t375;
  t378 = my_piecewise3(t61, 0, t353);
  t379 = my_piecewise3(t63, t378, 0);
  t382 = t151 * t360;
  t383 = 0.0;
  t385 = t383 * t156 * t159;
  t386 = t382 * t385;
  t387 = t365 * t159;
  t389 = t359 * t372;
  t391 = t364 * t366;
  t392 = t368 * params->csk_a;
  t393 = t391 * t392;
  t396 = my_piecewise5(t58, 0, t61, 0, -t151 * t379 * t160 + t151 * t372 * t376 + t359 * t360 * t370 - t389 * t376 + t382 * t387 - t389 * t393 - t386);
  t398 = 0.55e2 / 0.81e2 * t347 + t353 * t71 + 0.2e1 * t149 * t162 + t53 * t396;
  t403 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t73 + t329 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t164 - t339 + t341 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t398);
  t404 = 0.1e1 / t84;
  t405 = t172 * t172;
  t408 = t79 * t314;
  t411 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t123 + 0.2e1 * t408);
  t415 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t405 + 0.5e1 / 0.3e1 * t85 * t411);
  t416 = t415 * t31;
  t420 = t175 * t134;
  t422 = t7 * t420 * t117;
  t424 = t87 * t335;
  t427 = t7 * t424 * t117 / 0.3e2;
  t429 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t117 + t422 / 0.5e1 - t427);
  tv2rho20 = 0.2e1 * t169 + 0.2e1 * t185 + t8 * (t403 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t432 = t309 * t189;
  t436 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t315);
  t440 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t432 * t126 + 0.5e1 / 0.3e1 * t27 * t436);
  t441 = t440 * t31;
  t445 = t192 * t134;
  t447 = t7 * t445 * t73;
  t455 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t73 + t447 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t164 + t329 / 0.1e2 - t339 + t341 / 0.1e2);
  t456 = t404 * t200;
  t460 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t408);
  t464 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t456 * t172 + 0.5e1 / 0.3e1 * t85 * t460);
  t465 = t464 * t31;
  t469 = t203 * t134;
  t471 = t7 * t469 * t117;
  t478 = t7 * t180 * t233;
  t481 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t117 + t471 / 0.1e2 + t422 / 0.1e2 - t427 + 0.3e1 / 0.2e2 * t7 * t176 * t233 + t478 / 0.1e2);
  tv2rho21 = t169 + t185 + t198 + t238 + t8 * (t455 + t481);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t486 = t189 * t189;
  t491 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t123 + 0.2e1 * t315);
  t495 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t486 + 0.5e1 / 0.3e1 * t27 * t491);
  t496 = t495 * t31;
  t502 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t73 + t447 / 0.5e1 - t339);
  t503 = t200 * t200;
  t508 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t123 + 0.2e1 * t408);
  t512 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t503 + 0.5e1 / 0.3e1 * t85 * t508);
  t513 = t512 * t31;
  t522 = t89 * t89;
  t524 = 0.1e1 / t91 / t522;
  t526 = t38 * sigma[2] * t524;
  t532 = 0.1e3 / 0.243e3 * t38 * lapl[1] * t210 - 0.44e3 / 0.729e3 * t526;
  t536 = t110 * t110;
  t538 = t114 / t536;
  t539 = t222 * t222;
  t541 = t224 * t224;
  t542 = t109 * t109;
  t543 = 0.1e1 / t542;
  t544 = t541 * t543;
  t545 = t112 * t112;
  t546 = t113 * t113;
  t547 = 0.1e1 / t546;
  t548 = t545 * t547;
  t549 = t544 * t548;
  t551 = t539 * t541;
  t553 = t543 * t112;
  t554 = t227 * params->csk_a;
  t555 = t553 * t554;
  t557 = my_piecewise3(t105, 0, t532);
  t558 = my_piecewise3(t107, t557, 0);
  t561 = t220 * t539;
  t562 = 0.0;
  t564 = t562 * t225 * t228;
  t565 = t561 * t564;
  t566 = t544 * t228;
  t568 = t538 * t551;
  t570 = t543 * t545;
  t571 = t547 * params->csk_a;
  t572 = t570 * t571;
  t575 = my_piecewise5(t104, 0, t105, 0, -t220 * t558 * t229 + t220 * t551 * t555 + t538 * t539 * t549 - t568 * t555 + t561 * t566 - t568 * t572 - t565);
  t577 = 0.55e2 / 0.81e2 * t526 + t532 * t115 + 0.2e1 * t218 * t231 + t103 * t575;
  t582 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t117 + t471 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t233 - t427 + t478 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t577);
  tv2rho22 = 0.2e1 * t198 + 0.2e1 * t238 + t8 * (t502 + t582);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t590 = t7 * t135 * t253 / 0.1e2;
  t591 = t38 * t141;
  t594 = t38 * t141 * t71;
  t597 = t38 * t43 * t162;
  t600 = t153 * t362;
  t601 = t359 * t600;
  t602 = t368 * t248;
  t603 = t391 * t602;
  t605 = t248 * t362;
  t606 = t151 * t605;
  t607 = t375 * t153;
  t608 = t374 * t607;
  t611 = my_piecewise3(t61, 0, 0.4e2 / 0.243e3 * t591);
  t612 = my_piecewise3(t63, t611, 0);
  t615 = t248 * t153;
  t617 = t151 * t615 * t385;
  t618 = t158 * t153;
  t619 = t374 * t618;
  t621 = t359 * t605;
  t623 = t392 * t153;
  t624 = t391 * t623;
  t627 = my_piecewise5(t58, 0, t61, 0, -t151 * t612 * t160 + t601 * t603 + t606 * t608 + t606 * t619 - t621 * t608 - t621 * t624 - t617);
  t629 = -0.5e1 / 0.27e2 * t591 + 0.4e2 / 0.243e3 * t594 - 0.5e1 / 0.81e2 * t597 + t149 * t251 + t53 * t627;
  t634 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t253 + t590 + 0.3e1 / 0.2e2 * t7 * t32 * t629);
  tv2rhosigma0 = t8 * t634 + t257;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t641 = t7 * t180 * t270 / 0.1e2;
  t643 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t270 + t641);
  tv2rhosigma2 = t8 * t643 + t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t649 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t253 + t590);
  tv2rhosigma3 = t8 * t649 + t257;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t654 = t38 * t210;
  t657 = t38 * t210 * t115;
  t660 = t38 * t93 * t231;
  t663 = t222 * t541;
  t664 = t538 * t663;
  t665 = t547 * t265;
  t666 = t570 * t665;
  t668 = t265 * t541;
  t669 = t220 * t668;
  t671 = t553 * t554 * t222;
  t674 = my_piecewise3(t105, 0, 0.4e2 / 0.243e3 * t654);
  t675 = my_piecewise3(t107, t674, 0);
  t678 = t265 * t222;
  t680 = t220 * t678 * t564;
  t681 = t227 * t222;
  t682 = t553 * t681;
  t684 = t538 * t668;
  t686 = t571 * t222;
  t687 = t570 * t686;
  t690 = my_piecewise5(t104, 0, t105, 0, -t220 * t675 * t229 + t664 * t666 + t669 * t671 + t669 * t682 - t684 * t671 - t684 * t687 - t680);
  t692 = -0.5e1 / 0.27e2 * t654 + 0.4e2 / 0.243e3 * t657 - 0.5e1 / 0.81e2 * t660 + t218 * t268 + t103 * t690;
  t697 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t270 + t641 + 0.3e1 / 0.2e2 * t7 * t88 * t692);
  tv2rhosigma5 = t8 * t697 + t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t704 = t7 * t135 * t286 / 0.1e2;
  t710 = t368 * t281;
  t711 = t391 * t710;
  t713 = t281 * t362;
  t714 = t151 * t713;
  t717 = my_piecewise3(t61, 0, -0.25e2 / 0.162e3 * t241);
  t718 = my_piecewise3(t63, t717, 0);
  t721 = t281 * t153;
  t723 = t151 * t721 * t385;
  t725 = t359 * t713;
  t729 = my_piecewise5(t58, 0, t61, 0, -t151 * t718 * t160 + t601 * t711 + t714 * t608 - t725 * t608 + t714 * t619 - t725 * t624 - t723);
  t731 = -0.25e2 / 0.162e3 * t244 + 0.5e1 / 0.54e2 * t38 * t48 * t162 + t149 * t284 + t53 * t729;
  t736 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t286 + t704 + 0.3e1 / 0.2e2 * t7 * t32 * t731);
  tv2rholapl0 = t8 * t736 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t743 = t7 * t180 * t302 / 0.1e2;
  t745 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t302 + t743);
  tv2rholapl1 = t8 * t745 + t306;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t751 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t286 + t704);
  tv2rholapl2 = t8 * t751 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t761 = t547 * t297;
  t762 = t570 * t761;
  t764 = t297 * t541;
  t765 = t220 * t764;
  t768 = my_piecewise3(t105, 0, -0.25e2 / 0.162e3 * t258);
  t769 = my_piecewise3(t107, t768, 0);
  t772 = t297 * t222;
  t774 = t220 * t772 * t564;
  t776 = t538 * t764;
  t780 = my_piecewise5(t104, 0, t105, 0, -t220 * t769 * t229 + t664 * t762 + t765 * t671 - t776 * t671 + t765 * t682 - t776 * t687 - t774);
  t782 = -0.25e2 / 0.162e3 * t261 + 0.5e1 / 0.54e2 * t38 * t98 * t231 + t218 * t300 + t103 * t780;
  t787 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t302 + t743 + 0.3e1 / 0.2e2 * t7 * t88 * t782);
  tv2rholapl3 = t8 * t787 + t306;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t790 = t38 * t43 * t251;
  t792 = t248 * t248;
  t795 = t792 * t362;
  t798 = my_piecewise3(t61, 0, 0);
  t799 = my_piecewise3(t63, t798, 0);
  t801 = t151 * t799 * t160;
  t802 = t151 * t792;
  t803 = t802 * t385;
  t805 = t359 * t795;
  t809 = my_piecewise5(t58, 0, t61, 0, t151 * t795 * t376 + t359 * t792 * t370 - t805 * t376 + t802 * t387 - t805 * t393 - t801 - t803);
  t811 = -0.1e2 / 0.81e2 * t790 + t53 * t809;
  t815 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t811);
  tv2sigma20 = t8 * t815;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t817 = t38 * t93 * t268;
  t819 = t265 * t265;
  t822 = t819 * t541;
  t825 = my_piecewise3(t105, 0, 0);
  t826 = my_piecewise3(t107, t825, 0);
  t828 = t220 * t826 * t229;
  t829 = t220 * t819;
  t830 = t829 * t564;
  t832 = t538 * t822;
  t836 = my_piecewise5(t104, 0, t105, 0, t220 * t822 * t555 + t538 * t819 * t549 - t832 * t555 + t829 * t566 - t832 * t572 - t828 - t830);
  t838 = -0.1e2 / 0.81e2 * t817 + t103 * t836;
  t842 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t838);
  tv2sigma25 = t8 * t842;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t847 = t38 * t43 * t284;
  t850 = t375 * t248;
  t851 = t374 * t850;
  t853 = t281 * t248;
  t854 = t151 * t853;
  t855 = t854 * t385;
  t856 = t158 * t248;
  t857 = t374 * t856;
  t860 = t392 * t248;
  t861 = t391 * t860;
  t864 = my_piecewise5(t58, 0, t61, 0, t621 * t711 + t714 * t851 + t714 * t857 - t725 * t851 - t725 * t861 - t801 - t855);
  t866 = 0.5e1 / 0.54e2 * t38 * t48 * t251 - 0.5e1 / 0.81e2 * t847 + t53 * t864;
  t870 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t866);
  tv2sigmalapl0 = t8 * t870;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t875 = t38 * t93 * t300;
  t878 = t554 * t265;
  t879 = t553 * t878;
  t881 = t297 * t265;
  t882 = t220 * t881;
  t883 = t882 * t564;
  t884 = t227 * t265;
  t885 = t553 * t884;
  t888 = t571 * t265;
  t889 = t570 * t888;
  t892 = my_piecewise5(t104, 0, t105, 0, t684 * t762 + t765 * t879 + t765 * t885 - t776 * t879 - t776 * t889 - t828 - t883);
  t894 = 0.5e1 / 0.54e2 * t38 * t98 * t268 - 0.5e1 / 0.81e2 * t875 + t103 * t892;
  t898 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t894);
  tv2sigmalapl5 = t8 * t898;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t902 = t281 * t281;
  t905 = t902 * t362;
  t906 = t151 * t905;
  t908 = t151 * t902;
  t909 = t908 * t385;
  t911 = t359 * t905;
  t915 = my_piecewise5(t58, 0, t61, 0, t359 * t902 * t370 + t906 * t376 - t911 * t376 + t908 * t387 - t911 * t393 - t801 - t909);
  t917 = 0.5e1 / 0.27e2 * t38 * t48 * t284 + t53 * t915;
  t921 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t917);
  tv2lapl20 = t8 * t921;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t925 = t297 * t297;
  t928 = t925 * t541;
  t929 = t220 * t928;
  t931 = t220 * t925;
  t932 = t931 * t564;
  t934 = t538 * t928;
  t938 = my_piecewise5(t104, 0, t105, 0, t538 * t925 * t549 + t929 * t555 - t934 * t555 + t931 * t566 - t934 * t572 - t828 - t932);
  t940 = 0.5e1 / 0.27e2 * t38 * t98 * t300 + t103 * t938;
  t944 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t940);
  tv2lapl22 = t8 * t944;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  double t122, t123, t124, t126, t129, t130, t134, t135;
  double t138, t141, t143, t149, t151, t152, t153, t155;
  double t156, t158, t159, t160, t162, t164, t169, t170;
  double t172, t175, t176, t180, t183, t185, tvrho0, t189;
  double t192, t193, t198, t200, t203, t204, t210, t212;
  double t218, t220, t221, t222, t224, t225, t227, t228;
  double t229, t231, t233, t238, tvrho1, t241, t244, t247;
  double t248, t251, t253, t257, tvsigma0, tvsigma1, t258, t261;
  double t264, t265, t268, t270, t274, tvsigma2, t280, t281;
  double t284, t286, t290, tvlapl0, t296, t297, t300, t302;
  double t306, tvlapl1, tvtau0, tvtau1;

  double t309, t310, t313, t314, t315, t318, t322, t323;
  double t327, t329, t335, t336, t339, t341, t343, t345;
  double t347, t353, t357, t359, t360, t362, t363, t364;
  double t365, t366, t367, t368, t369, t370, t372, t374;
  double t375, t376, t378, t379, t382, t383, t385, t386;
  double t387, t389, t391, t392, t393, t396, t398, t403;
  double t404, t405, t408, t411, t415, t416, t420, t422;
  double t424, t427, t429, tv2rho20, t432, t436, t440, t441;
  double t445, t447, t455, t456, t460, t464, t465, t469;
  double t471, t478, t481, tv2rho21, t486, t491, t495, t496;
  double t502, t503, t508, t512, t513, t522, t524, t526;
  double t532, t536, t538, t539, t541, t542, t543, t544;
  double t545, t546, t547, t548, t549, t551, t553, t554;
  double t555, t557, t558, t561, t562, t564, t565, t566;
  double t568, t570, t571, t572, t575, t577, t582, tv2rho22;
  double t590, t591, t594, t597, t600, t601, t602, t603;
  double t605, t606, t607, t608, t611, t612, t615, t617;
  double t618, t619, t621, t623, t624, t627, t629, t634;
  double tv2rhosigma0, tv2rhosigma1, t641, t643, tv2rhosigma2, t649, tv2rhosigma3, tv2rhosigma4;
  double t654, t657, t660, t663, t664, t665, t666, t668;
  double t669, t671, t674, t675, t678, t680, t681, t682;
  double t684, t686, t687, t690, t692, t697, tv2rhosigma5, t704;
  double t710, t711, t713, t714, t717, t718, t721, t723;
  double t725, t729, t731, t736, tv2rholapl0, t743, t745, tv2rholapl1;
  double t751, tv2rholapl2, t761, t762, t764, t765, t768, t769;
  double t772, t774, t776, t780, t782, t787, tv2rholapl3, tv2rhotau0;
  double tv2rhotau1, tv2rhotau2, tv2rhotau3, t790, t792, t795, t798, t799;
  double t801, t802, t803, t805, t809, t811, t815, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t817, t819, t822, t825;
  double t826, t828, t829, t830, t832, t836, t838, t842;
  double tv2sigma25, t847, t850, t851, t853, t854, t855, t856;
  double t857, t860, t861, t864, t866, t870, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t875, t878, t879, t881, t882;
  double t883, t884, t885, t888, t889, t892, t894, t898;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t902;
  double t905, t906, t908, t909, t911, t915, t917, t921;
  double tv2lapl20, tv2lapl21, t925, t928, t929, t931, t932, t934;
  double t938, t940, t944, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3;
  double tv2tau20, tv2tau21, tv2tau22;

  double t948, t949, t952, t955, t956, t957, t960, t964;
  double t965, t969, t971, t976, t978, t981, t987, t988;
  double t991, t993, t996, t1000, t1002, t1008, t1014, t1015;
  double t1018, t1019, t1020, t1021, t1023, t1024, t1025, t1027;
  double t1029, t1030, t1031, t1034, t1035, t1041, t1042, t1044;
  double t1045, t1050, t1052, t1054, t1055, t1056, t1058, t1059;
  double t1060, t1063, t1067, t1070, t1071, t1072, t1073, t1076;
  double t1079, t1084, t1085, t1086, t1089, t1090, t1091, t1093;
  double t1094, t1095, t1098, t1100, t1101, t1105, t1109, t1110;
  double t1111, t1114, t1115, t1120, t1124, t1125, t1128, t1130;
  double t1132, t1137, t1139, t1140, t1143, t1146, t1149, t1153;
  double t1154, t1158, t1160, t1162, t1164, t1166, t1169, t1171;
  double tv3rho30, t1174, t1175, t1176, t1179, t1184, t1185, t1187;
  double t1191, t1192, t1196, t1199, t1203, t1205, t1209, t1218;
  double t1219, t1220, t1223, t1228, t1230, t1234, t1235, t1239;
  double t1242, t1243, t1245, t1254, t1256, t1259, tv3rho31, t1262;
  double t1267, t1271, t1275, t1276, t1280, t1282, t1291, t1292;
  double t1297, t1301, t1305, t1306, t1310, t1312, t1319, t1327;
  double t1329, t1330, tv3rho32, t1335, t1342, t1346, t1347, t1354;
  double t1355, t1362, t1366, t1367, t1384, t1386, t1392, t1398;
  double t1399, t1402, t1403, t1404, t1405, t1407, t1408, t1409;
  double t1411, t1414, t1415, t1418, t1419, t1425, t1426, t1430;
  double t1432, t1434, t1435, t1436, t1438, t1439, t1440, t1442;
  double t1443, t1447, t1451, t1454, t1455, t1456, t1457, t1459;
  double t1460, t1461, t1464, t1465, t1469, t1470, t1471, t1477;
  double t1478, t1479, t1481, t1482, t1488, t1492, t1493, t1494;
  double t1497, t1498, t1503, t1507, t1508, t1511, t1513, t1515;
  double t1520, tv3rho33, t1528, t1535, t1537, t1539, t1542, t1545;
  double t1548, t1553, t1554, t1556, t1557, t1560, t1561, t1564;
  double t1567, t1570, t1571, t1573, t1574, t1575, t1576, t1577;
  double t1579, t1580, t1582, t1586, t1588, t1589, t1590, t1594;
  double t1595, t1598, t1599, t1601, t1602, t1605, t1613, t1615;
  double t1616, t1617, t1620, t1621, t1622, t1624, t1625, t1626;
  double t1627, t1628, t1629, t1630, t1632, t1635, t1636, t1639;
  double t1640, t1643, t1644, t1650, t1651, t1656, t1658, t1662;
  double t1663, t1664, t1666, t1668, t1670, t1675, tv3rho2sigma0, tv3rho2sigma1;
  double t1682, t1686, t1688, tv3rho2sigma2, t1694, t1702, tv3rho2sigma3, tv3rho2sigma4;
  double t1708, t1715, t1718, tv3rho2sigma5, t1726, tv3rho2sigma6, tv3rho2sigma7, t1737;
  double t1740, t1743, t1746, t1751, t1752, t1755, t1756, t1758;
  double t1759, t1764, t1767, t1768, t1769, t1770, t1771, t1773;
  double t1776, t1777, t1779, t1780, t1782, t1783, t1784, t1792;
  double t1793, t1796, t1797, t1799, t1800, t1803, t1804, t1805;
  double t1808, t1811, t1815, t1816, t1817, t1819, t1820, t1821;
  double t1823, t1824, t1825, t1827, t1830, t1831, t1834, t1835;
  double t1838, t1839, t1840, t1845, t1849, t1850, t1851, t1856;
  double t1857, t1862, t1864, t1866, t1871, tv3rho2sigma8, t1878, t1885;
  double t1887, t1898, t1899, t1902, t1903, t1910, t1913, t1914;
  double t1915, t1917, t1919, t1921, t1922, t1928, t1936, t1937;
  double t1938, t1939, t1942, t1945, t1946, t1947, t1950, t1951;
  double t1952, t1954, t1957, t1958, t1963, t1968, t1971, t1972;
  double t1975, t1977, t1979, t1983, t1985, t1987, t1992, tv3rho2lapl0;
  double t1999, t2003, t2005, tv3rho2lapl1, t2011, t2019, tv3rho2lapl2, t2025;
  double t2032, t2035, tv3rho2lapl3, t2043, tv3rho2lapl4, t2063, t2064, t2070;
  double t2073, t2074, t2077, t2080, t2082, t2084, t2085, t2086;
  double t2091, t2092, t2096, t2097, t2098, t2101, t2105, t2111;
  double t2112, t2115, t2116, t2117, t2119, t2122, t2123, t2126;
  double t2128, t2131, t2132, t2135, t2137, t2139, t2141, t2148;
  double t2150, t2152, t2157, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2, tv3rho2tau3;
  double tv3rho2tau4, tv3rho2tau5, t2164, t2166, t2169, t2172, t2173, t2174;
  double t2175, t2178, t2179, t2182, t2183, t2184, t2187, t2188;
  double t2191, t2194, t2196, t2202, t2203, t2206, t2207, t2208;
  double t2209, t2210, t2213, t2214, t2215, t2217, t2218, t2224;
  double t2225, t2226, t2229, t2230, t2231, t2232, t2233, t2234;
  double t2237, t2238, t2239, t2240, t2243, t2244, t2245, t2246;
  double t2248, t2249, t2250, t2252, t2253, t2254, t2255, t2257;
  double t2258, t2259, t2264, t2265, t2266, t2267, t2269, t2270;
  double t2271, t2272, t2274, t2275, t2278, t2281, t2282, t2284;
  double t2286, t2291, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2298;
  double t2300, tv3rhosigma25, t2306, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t2312, t2315, t2318, t2319, t2320, t2321, t2324, t2325;
  double t2328, t2329, t2332, t2333, t2336, t2337, t2340, t2343;
  double t2344, t2345, t2346, t2347, t2349, t2350, t2354, t2355;
  double t2356, t2357, t2358, t2359, t2361, t2364, t2365, t2367;
  double t2372, t2373, t2375, t2376, t2377, t2378, t2380, t2381;
  double t2382, t2383, t2386, t2387, t2388, t2389, t2391, t2393;
  double t2394, t2399, t2400, t2403, t2408, t2409, t2410, t2411;
  double t2413, t2414, t2415, t2418, t2419, t2420, t2421, t2422;
  double t2424, t2425, t2426, t2429, t2431, t2433, t2438, tv3rhosigma211;
  double t2445, t2451, t2454, t2457, t2458, t2459, t2460, t2461;
  double t2464, t2465, t2466, t2467, t2468, t2471, t2472, t2473;
  double t2475, t2478, t2479, t2483, t2485, t2486, t2493, t2496;
  double t2497, t2498, t2499, t2501, t2503, t2504, t2506, t2507;
  double t2508, t2509, t2511, t2512, t2513, t2515, t2520, t2521;
  double t2525, t2526, t2529, t2530, t2536, t2538, t2541, t2543;
  double t2545, t2547, t2552, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4;
  double t2559, t2561, tv3rhosigmalapl5, t2567, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9;
  double tv3rhosigmalapl10, t2577, t2580, t2583, t2584, t2585, t2586, t2587;
  double t2590, t2593, t2594, t2595, t2596, t2597, t2599, t2602;
  double t2604, t2605, t2610, t2613, t2616, t2617, t2618, t2622;
  double t2624, t2625, t2627, t2628, t2629, t2630, t2633, t2634;
  double t2636, t2637, t2638, t2639, t2641, t2642, t2645, t2652;
  double t2653, t2655, t2656, t2665, t2668, t2669, t2671, t2673;
  double t2678, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5;
  double tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t2685, t2691;
  double t2693, t2694, t2696, t2698, t2700, t2701, t2703, t2704;
  double t2706, t2709, t2715, t2723, t2724, t2725, t2730, t2731;
  double t2737, t2738, t2746, t2747, t2749, t2750, t2751, t2753;
  double t2754, t2760, t2762, t2764, t2769, tv3rholapl20, tv3rholapl21, t2776;
  double t2778, tv3rholapl22, t2784, tv3rholapl23, tv3rholapl24, t2794, t2796, t2797;
  double t2799, t2801, t2802, t2804, t2806, t2807, t2811, t2813;
  double t2824, t2825, t2827, t2828, t2829, t2834, t2838, t2839;
  double t2849, t2850, t2851, t2853, t2854, t2860, t2861, t2863;
  double t2865, t2867, t2872, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3;
  double tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23;
  double tv3rhotau24, tv3rhotau25, t2875, t2877, t2886, t2887, t2888, t2889;
  double t2890, t2891, t2892, t2893, t2894, t2896, t2897, t2898;
  double t2899, t2900, t2901, t2902, t2903, t2904, t2905, t2910;
  double t2912, t2913, t2914, t2915, t2916, t2917, t2918, t2919;
  double t2922, t2924, t2925, t2926, t2927, t2932, t2941, t2943;
  double t2945, t2949, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t2951, t2953, t2962, t2963, t2964;
  double t2965, t2966, t2967, t2968, t2970, t2971, t2972, t2973;
  double t2974, t2975, t2976, t2977, t2978, t2979, t2980, t2981;
  double t2984, t2986, t2987, t2988, t2989, t2994, t2995, t2998;
  double t3002, t3003, t3004, t3005, t3006, t3007, t3008, t3017;
  double t3019, t3021, t3025, tv3sigma39, t3030, t3032, t3033, t3034;
  double t3035, t3036, t3037, t3038, t3040, t3041, t3048, t3049;
  double t3054, t3055, t3056, t3057, t3058, t3059, t3061, t3062;
  double t3065, t3066, t3067, t3068, t3069, t3074, t3075, t3078;
  double t3079, t3080, t3082, t3083, t3084, t3085, t3086, t3087;
  double t3088, t3091, t3092, t3095, t3097, t3099, t3100, t3101;
  double t3102, t3103, t3105, t3107, t3111, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double t3116, t3118, t3119, t3120, t3121, t3122, t3124, t3125;
  double t3126, t3127, t3129, t3130, t3132, t3134, t3135, t3138;
  double t3139, t3140, t3141, t3142, t3147, t3150, t3160, t3161;
  double t3162, t3163, t3164, t3165, t3166, t3167, t3168, t3169;
  double t3170, t3171, t3172, t3173, t3176, t3177, t3180, t3182;
  double t3184, t3185, t3186, t3187, t3188, t3190, t3192, t3196;
  double tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t3201, t3203, t3205;
  double t3206, t3207, t3209, t3210, t3211, t3213, t3214, t3217;
  double t3218, t3223, t3226, t3227, t3230, t3234, t3235, t3242;
  double t3243, t3244, t3247, t3248, t3249, t3250, t3251, t3252;
  double t3259, t3261, t3263, t3267, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, t3272, t3274, t3275, t3276;
  double t3277, t3278, t3279, t3281, t3282, t3284, t3285, t3288;
  double t3289, t3294, t3297, t3298, t3301, t3305, t3306, t3313;
  double t3314, t3315, t3318, t3319, t3320, t3321, t3322, t3323;
  double t3330, t3332, t3334, t3338, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2;
  double tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10;
  double tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26;
  double tv3sigmatau27, tv3sigmatau28, t3342, t3351, t3353, t3354, t3355, t3356;
  double t3357, t3358, t3359, t3360, t3361, t3362, t3363, t3364;
  double t3365, t3366, t3367, t3369, t3370, t3372, t3373, t3374;
  double t3375, t3378, t3385, t3396, t3398, t3400, t3404, tv3lapl30;
  double tv3lapl31, tv3lapl32, t3408, t3417, t3418, t3419, t3420, t3421;
  double t3422, t3423, t3425, t3426, t3427, t3428, t3429, t3430;
  double t3431, t3432, t3433, t3434, t3435, t3438, t3439, t3440;
  double t3442, t3443, t3444, t3447, t3462, t3464, t3466, t3470;
  double tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20;
  double tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30, tv3tau31, tv3tau32;
  double tv3tau33;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t122 = t8 * t8;
  t123 = 0.1e1 / t122;
  t124 = t18 * t123;
  t126 = my_piecewise5(t12, 0, t16, 0, t9 - t124);
  t129 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t126);
  t130 = t129 * t31;
  t134 = 0.1e1 / t30;
  t135 = t29 * t134;
  t138 = t7 * t135 * t73 / 0.1e2;
  t141 = 0.1e1 / t41 / t39 / rho[0];
  t143 = t38 * sigma[0] * t141;
  t149 = -0.25e2 / 0.162e3 * t38 * lapl[0] * t43 + 0.4e2 / 0.243e3 * t143;
  t151 = t70 * t67;
  t152 = my_piecewise3(t61, 0, t149);
  t153 = my_piecewise3(t63, t152, 0);
  t155 = fabs(t64) / t64;
  t156 = 0.1e1 / t65;
  t158 = 0.1e1 / t69;
  t159 = t68 * t158;
  t160 = t155 * t156 * t159;
  t162 = my_piecewise5(t58, 0, t61, 0, -t151 * t153 * t160);
  t164 = -0.5e1 / 0.27e2 * t143 + t149 * t71 + t53 * t162;
  t169 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t73 + t138 + 0.3e1 / 0.2e2 * t7 * t32 * t164);
  t170 = t79 * t123;
  t172 = my_piecewise5(t16, 0, t12, 0, -t9 - t170);
  t175 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t172);
  t176 = t175 * t31;
  t180 = t87 * t134;
  t183 = t7 * t180 * t117 / 0.1e2;
  t185 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t117 + t183);
  tvrho0 = t77 + t121 + t8 * (t169 + t185);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t189 = my_piecewise5(t12, 0, t16, 0, -t9 - t124);
  t192 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t189);
  t193 = t192 * t31;
  t198 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t73 + t138);
  t200 = my_piecewise5(t16, 0, t12, 0, t9 - t170);
  t203 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t200);
  t204 = t203 * t31;
  t210 = 0.1e1 / t91 / t89 / rho[1];
  t212 = t38 * sigma[2] * t210;
  t218 = -0.25e2 / 0.162e3 * t38 * lapl[1] * t93 + 0.4e2 / 0.243e3 * t212;
  t220 = t114 * t111;
  t221 = my_piecewise3(t105, 0, t218);
  t222 = my_piecewise3(t107, t221, 0);
  t224 = fabs(t108) / t108;
  t225 = 0.1e1 / t109;
  t227 = 0.1e1 / t113;
  t228 = t112 * t227;
  t229 = t224 * t225 * t228;
  t231 = my_piecewise5(t104, 0, t105, 0, -t220 * t222 * t229);
  t233 = -0.5e1 / 0.27e2 * t212 + t218 * t115 + t103 * t231;
  t238 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t117 + t183 + 0.3e1 / 0.2e2 * t7 * t88 * t233);
  tvrho1 = t77 + t121 + t8 * (t198 + t238);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t241 = t38 * t43;
  t244 = t38 * t43 * t71;
  t247 = my_piecewise3(t61, 0, -0.5e1 / 0.81e2 * t241);
  t248 = my_piecewise3(t63, t247, 0);
  t251 = my_piecewise5(t58, 0, t61, 0, -t151 * t248 * t160);
  t253 = 0.5e1 / 0.72e2 * t241 - 0.5e1 / 0.81e2 * t244 + t53 * t251;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t253);
  tvsigma0 = t8 * t257;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t258 = t38 * t93;
  t261 = t38 * t93 * t115;
  t264 = my_piecewise3(t105, 0, -0.5e1 / 0.81e2 * t258);
  t265 = my_piecewise3(t107, t264, 0);
  t268 = my_piecewise5(t104, 0, t105, 0, -t220 * t265 * t229);
  t270 = 0.5e1 / 0.72e2 * t258 - 0.5e1 / 0.81e2 * t261 + t103 * t268;
  t274 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t270);
  tvsigma2 = t8 * t274;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t280 = my_piecewise3(t61, 0, 0.5e1 / 0.54e2 * t38 * t48);
  t281 = my_piecewise3(t63, t280, 0);
  t284 = my_piecewise5(t58, 0, t61, 0, -t151 * t281 * t160);
  t286 = 0.5e1 / 0.54e2 * t38 * t48 * t71 + t53 * t284;
  t290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t286);
  tvlapl0 = t8 * t290;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t296 = my_piecewise3(t105, 0, 0.5e1 / 0.54e2 * t38 * t98);
  t297 = my_piecewise3(t107, t296, 0);
  t300 = my_piecewise5(t104, 0, t105, 0, -t220 * t297 * t229);
  t302 = 0.5e1 / 0.54e2 * t38 * t98 * t115 + t103 * t300;
  t306 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t302);
  tvlapl1 = t8 * t306;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t309 = 0.1e1 / t26;
  t310 = t126 * t126;
  t313 = t122 * t8;
  t314 = 0.1e1 / t313;
  t315 = t18 * t314;
  t318 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t123 + 0.2e1 * t315);
  t322 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t310 + 0.5e1 / 0.3e1 * t27 * t318);
  t323 = t322 * t31;
  t327 = t129 * t134;
  t329 = t7 * t327 * t73;
  t335 = 0.1e1 / t30 / t8;
  t336 = t29 * t335;
  t339 = t7 * t336 * t73 / 0.3e2;
  t341 = t7 * t135 * t164;
  t343 = t39 * t39;
  t345 = 0.1e1 / t41 / t343;
  t347 = t38 * sigma[0] * t345;
  t353 = 0.1e3 / 0.243e3 * t38 * lapl[0] * t141 - 0.44e3 / 0.729e3 * t347;
  t357 = t66 * t66;
  t359 = t70 / t357;
  t360 = t153 * t153;
  t362 = t155 * t155;
  t363 = t65 * t65;
  t364 = 0.1e1 / t363;
  t365 = t362 * t364;
  t366 = t68 * t68;
  t367 = t69 * t69;
  t368 = 0.1e1 / t367;
  t369 = t366 * t368;
  t370 = t365 * t369;
  t372 = t360 * t362;
  t374 = t364 * t68;
  t375 = t158 * params->csk_a;
  t376 = t374 * t375;
  t378 = my_piecewise3(t61, 0, t353);
  t379 = my_piecewise3(t63, t378, 0);
  t382 = t151 * t360;
  t383 = 0.0;
  t385 = t383 * t156 * t159;
  t386 = t382 * t385;
  t387 = t365 * t159;
  t389 = t359 * t372;
  t391 = t364 * t366;
  t392 = t368 * params->csk_a;
  t393 = t391 * t392;
  t396 = my_piecewise5(t58, 0, t61, 0, -t151 * t379 * t160 + t151 * t372 * t376 + t359 * t360 * t370 - t389 * t376 + t382 * t387 - t389 * t393 - t386);
  t398 = 0.55e2 / 0.81e2 * t347 + t353 * t71 + 0.2e1 * t149 * t162 + t53 * t396;
  t403 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t73 + t329 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t164 - t339 + t341 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t398);
  t404 = 0.1e1 / t84;
  t405 = t172 * t172;
  t408 = t79 * t314;
  t411 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t123 + 0.2e1 * t408);
  t415 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t405 + 0.5e1 / 0.3e1 * t85 * t411);
  t416 = t415 * t31;
  t420 = t175 * t134;
  t422 = t7 * t420 * t117;
  t424 = t87 * t335;
  t427 = t7 * t424 * t117 / 0.3e2;
  t429 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t117 + t422 / 0.5e1 - t427);
  tv2rho20 = 0.2e1 * t169 + 0.2e1 * t185 + t8 * (t403 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t432 = t309 * t189;
  t436 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t315);
  t440 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t432 * t126 + 0.5e1 / 0.3e1 * t27 * t436);
  t441 = t440 * t31;
  t445 = t192 * t134;
  t447 = t7 * t445 * t73;
  t455 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t73 + t447 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t164 + t329 / 0.1e2 - t339 + t341 / 0.1e2);
  t456 = t404 * t200;
  t460 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t408);
  t464 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t456 * t172 + 0.5e1 / 0.3e1 * t85 * t460);
  t465 = t464 * t31;
  t469 = t203 * t134;
  t471 = t7 * t469 * t117;
  t478 = t7 * t180 * t233;
  t481 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t117 + t471 / 0.1e2 + t422 / 0.1e2 - t427 + 0.3e1 / 0.2e2 * t7 * t176 * t233 + t478 / 0.1e2);
  tv2rho21 = t169 + t185 + t198 + t238 + t8 * (t455 + t481);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t486 = t189 * t189;
  t491 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t123 + 0.2e1 * t315);
  t495 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t486 + 0.5e1 / 0.3e1 * t27 * t491);
  t496 = t495 * t31;
  t502 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t73 + t447 / 0.5e1 - t339);
  t503 = t200 * t200;
  t508 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t123 + 0.2e1 * t408);
  t512 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t503 + 0.5e1 / 0.3e1 * t85 * t508);
  t513 = t512 * t31;
  t522 = t89 * t89;
  t524 = 0.1e1 / t91 / t522;
  t526 = t38 * sigma[2] * t524;
  t532 = 0.1e3 / 0.243e3 * t38 * lapl[1] * t210 - 0.44e3 / 0.729e3 * t526;
  t536 = t110 * t110;
  t538 = t114 / t536;
  t539 = t222 * t222;
  t541 = t224 * t224;
  t542 = t109 * t109;
  t543 = 0.1e1 / t542;
  t544 = t541 * t543;
  t545 = t112 * t112;
  t546 = t113 * t113;
  t547 = 0.1e1 / t546;
  t548 = t545 * t547;
  t549 = t544 * t548;
  t551 = t539 * t541;
  t553 = t543 * t112;
  t554 = t227 * params->csk_a;
  t555 = t553 * t554;
  t557 = my_piecewise3(t105, 0, t532);
  t558 = my_piecewise3(t107, t557, 0);
  t561 = t220 * t539;
  t562 = 0.0;
  t564 = t562 * t225 * t228;
  t565 = t561 * t564;
  t566 = t544 * t228;
  t568 = t538 * t551;
  t570 = t543 * t545;
  t571 = t547 * params->csk_a;
  t572 = t570 * t571;
  t575 = my_piecewise5(t104, 0, t105, 0, -t220 * t558 * t229 + t220 * t551 * t555 + t538 * t539 * t549 - t568 * t555 + t561 * t566 - t568 * t572 - t565);
  t577 = 0.55e2 / 0.81e2 * t526 + t532 * t115 + 0.2e1 * t218 * t231 + t103 * t575;
  t582 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t117 + t471 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t233 - t427 + t478 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t577);
  tv2rho22 = 0.2e1 * t198 + 0.2e1 * t238 + t8 * (t502 + t582);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t590 = t7 * t135 * t253 / 0.1e2;
  t591 = t38 * t141;
  t594 = t38 * t141 * t71;
  t597 = t38 * t43 * t162;
  t600 = t153 * t362;
  t601 = t359 * t600;
  t602 = t368 * t248;
  t603 = t391 * t602;
  t605 = t248 * t362;
  t606 = t151 * t605;
  t607 = t375 * t153;
  t608 = t374 * t607;
  t611 = my_piecewise3(t61, 0, 0.4e2 / 0.243e3 * t591);
  t612 = my_piecewise3(t63, t611, 0);
  t615 = t248 * t153;
  t617 = t151 * t615 * t385;
  t618 = t158 * t153;
  t619 = t374 * t618;
  t621 = t359 * t605;
  t623 = t392 * t153;
  t624 = t391 * t623;
  t627 = my_piecewise5(t58, 0, t61, 0, -t151 * t612 * t160 + t601 * t603 + t606 * t608 + t606 * t619 - t621 * t608 - t621 * t624 - t617);
  t629 = -0.5e1 / 0.27e2 * t591 + 0.4e2 / 0.243e3 * t594 - 0.5e1 / 0.81e2 * t597 + t149 * t251 + t53 * t627;
  t634 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t253 + t590 + 0.3e1 / 0.2e2 * t7 * t32 * t629);
  tv2rhosigma0 = t8 * t634 + t257;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t641 = t7 * t180 * t270 / 0.1e2;
  t643 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t270 + t641);
  tv2rhosigma2 = t8 * t643 + t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t649 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t253 + t590);
  tv2rhosigma3 = t8 * t649 + t257;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t654 = t38 * t210;
  t657 = t38 * t210 * t115;
  t660 = t38 * t93 * t231;
  t663 = t222 * t541;
  t664 = t538 * t663;
  t665 = t547 * t265;
  t666 = t570 * t665;
  t668 = t265 * t541;
  t669 = t220 * t668;
  t671 = t553 * t554 * t222;
  t674 = my_piecewise3(t105, 0, 0.4e2 / 0.243e3 * t654);
  t675 = my_piecewise3(t107, t674, 0);
  t678 = t265 * t222;
  t680 = t220 * t678 * t564;
  t681 = t227 * t222;
  t682 = t553 * t681;
  t684 = t538 * t668;
  t686 = t571 * t222;
  t687 = t570 * t686;
  t690 = my_piecewise5(t104, 0, t105, 0, -t220 * t675 * t229 + t664 * t666 + t669 * t671 + t669 * t682 - t684 * t671 - t684 * t687 - t680);
  t692 = -0.5e1 / 0.27e2 * t654 + 0.4e2 / 0.243e3 * t657 - 0.5e1 / 0.81e2 * t660 + t218 * t268 + t103 * t690;
  t697 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t270 + t641 + 0.3e1 / 0.2e2 * t7 * t88 * t692);
  tv2rhosigma5 = t8 * t697 + t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t704 = t7 * t135 * t286 / 0.1e2;
  t710 = t368 * t281;
  t711 = t391 * t710;
  t713 = t281 * t362;
  t714 = t151 * t713;
  t717 = my_piecewise3(t61, 0, -0.25e2 / 0.162e3 * t241);
  t718 = my_piecewise3(t63, t717, 0);
  t721 = t281 * t153;
  t723 = t151 * t721 * t385;
  t725 = t359 * t713;
  t729 = my_piecewise5(t58, 0, t61, 0, -t151 * t718 * t160 + t601 * t711 + t714 * t608 - t725 * t608 + t714 * t619 - t725 * t624 - t723);
  t731 = -0.25e2 / 0.162e3 * t244 + 0.5e1 / 0.54e2 * t38 * t48 * t162 + t149 * t284 + t53 * t729;
  t736 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t286 + t704 + 0.3e1 / 0.2e2 * t7 * t32 * t731);
  tv2rholapl0 = t8 * t736 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t743 = t7 * t180 * t302 / 0.1e2;
  t745 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t302 + t743);
  tv2rholapl1 = t8 * t745 + t306;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t751 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t286 + t704);
  tv2rholapl2 = t8 * t751 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t761 = t547 * t297;
  t762 = t570 * t761;
  t764 = t297 * t541;
  t765 = t220 * t764;
  t768 = my_piecewise3(t105, 0, -0.25e2 / 0.162e3 * t258);
  t769 = my_piecewise3(t107, t768, 0);
  t772 = t297 * t222;
  t774 = t220 * t772 * t564;
  t776 = t538 * t764;
  t780 = my_piecewise5(t104, 0, t105, 0, -t220 * t769 * t229 + t664 * t762 + t765 * t671 - t776 * t671 + t765 * t682 - t776 * t687 - t774);
  t782 = -0.25e2 / 0.162e3 * t261 + 0.5e1 / 0.54e2 * t38 * t98 * t231 + t218 * t300 + t103 * t780;
  t787 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t302 + t743 + 0.3e1 / 0.2e2 * t7 * t88 * t782);
  tv2rholapl3 = t8 * t787 + t306;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t790 = t38 * t43 * t251;
  t792 = t248 * t248;
  t795 = t792 * t362;
  t798 = my_piecewise3(t61, 0, 0);
  t799 = my_piecewise3(t63, t798, 0);
  t801 = t151 * t799 * t160;
  t802 = t151 * t792;
  t803 = t802 * t385;
  t805 = t359 * t795;
  t809 = my_piecewise5(t58, 0, t61, 0, t151 * t795 * t376 + t359 * t792 * t370 - t805 * t376 + t802 * t387 - t805 * t393 - t801 - t803);
  t811 = -0.1e2 / 0.81e2 * t790 + t53 * t809;
  t815 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t811);
  tv2sigma20 = t8 * t815;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t817 = t38 * t93 * t268;
  t819 = t265 * t265;
  t822 = t819 * t541;
  t825 = my_piecewise3(t105, 0, 0);
  t826 = my_piecewise3(t107, t825, 0);
  t828 = t220 * t826 * t229;
  t829 = t220 * t819;
  t830 = t829 * t564;
  t832 = t538 * t822;
  t836 = my_piecewise5(t104, 0, t105, 0, t220 * t822 * t555 + t538 * t819 * t549 - t832 * t555 + t829 * t566 - t832 * t572 - t828 - t830);
  t838 = -0.1e2 / 0.81e2 * t817 + t103 * t836;
  t842 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t838);
  tv2sigma25 = t8 * t842;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t847 = t38 * t43 * t284;
  t850 = t375 * t248;
  t851 = t374 * t850;
  t853 = t281 * t248;
  t854 = t151 * t853;
  t855 = t854 * t385;
  t856 = t158 * t248;
  t857 = t374 * t856;
  t860 = t392 * t248;
  t861 = t391 * t860;
  t864 = my_piecewise5(t58, 0, t61, 0, t621 * t711 + t714 * t851 + t714 * t857 - t725 * t851 - t725 * t861 - t801 - t855);
  t866 = 0.5e1 / 0.54e2 * t38 * t48 * t251 - 0.5e1 / 0.81e2 * t847 + t53 * t864;
  t870 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t866);
  tv2sigmalapl0 = t8 * t870;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t875 = t38 * t93 * t300;
  t878 = t554 * t265;
  t879 = t553 * t878;
  t881 = t297 * t265;
  t882 = t220 * t881;
  t883 = t882 * t564;
  t884 = t227 * t265;
  t885 = t553 * t884;
  t888 = t571 * t265;
  t889 = t570 * t888;
  t892 = my_piecewise5(t104, 0, t105, 0, t684 * t762 + t765 * t879 + t765 * t885 - t776 * t879 - t776 * t889 - t828 - t883);
  t894 = 0.5e1 / 0.54e2 * t38 * t98 * t268 - 0.5e1 / 0.81e2 * t875 + t103 * t892;
  t898 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t894);
  tv2sigmalapl5 = t8 * t898;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t902 = t281 * t281;
  t905 = t902 * t362;
  t906 = t151 * t905;
  t908 = t151 * t902;
  t909 = t908 * t385;
  t911 = t359 * t905;
  t915 = my_piecewise5(t58, 0, t61, 0, t359 * t902 * t370 + t906 * t376 - t911 * t376 + t908 * t387 - t911 * t393 - t801 - t909);
  t917 = 0.5e1 / 0.27e2 * t38 * t48 * t284 + t53 * t915;
  t921 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t917);
  tv2lapl20 = t8 * t921;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t925 = t297 * t297;
  t928 = t925 * t541;
  t929 = t220 * t928;
  t931 = t220 * t925;
  t932 = t931 * t564;
  t934 = t538 * t928;
  t938 = my_piecewise5(t104, 0, t105, 0, t538 * t925 * t549 + t929 * t555 - t934 * t555 + t931 * t566 - t934 * t572 - t828 - t932);
  t940 = 0.5e1 / 0.27e2 * t38 * t98 * t300 + t103 * t938;
  t944 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t940);
  tv2lapl22 = t8 * t944;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t948 = 0.1e1 / t26 / t21;
  t949 = t310 * t126;
  t952 = t309 * t126;
  t955 = t122 * t122;
  t956 = 0.1e1 / t955;
  t957 = t18 * t956;
  t960 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t314 - 0.6e1 * t957);
  t964 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t948 * t949 + 0.1e2 / 0.3e1 * t952 * t318 + 0.5e1 / 0.3e1 * t27 * t960);
  t965 = t964 * t31;
  t969 = t322 * t134;
  t971 = t7 * t969 * t73;
  t976 = t129 * t335;
  t978 = t7 * t976 * t73;
  t981 = t7 * t327 * t164;
  t987 = 0.1e1 / t30 / t122;
  t988 = t29 * t987;
  t991 = 0.2e1 / 0.45e2 * t7 * t988 * t73;
  t993 = t7 * t336 * t164;
  t996 = t7 * t135 * t398;
  t1000 = 0.1e1 / t41 / t343 / rho[0];
  t1002 = t38 * sigma[0] * t1000;
  t1008 = -0.11e4 / 0.729e3 * t38 * lapl[0] * t345 + 0.616e4 / 0.2187e4 * t1002;
  t1014 = t379 * t362;
  t1015 = t359 * t1014;
  t1018 = t360 * t153;
  t1019 = t1018 * t383;
  t1020 = t359 * t1019;
  t1021 = t364 * params->csk_a;
  t1023 = t155 * t68 * t158;
  t1024 = t1021 * t1023;
  t1025 = t1020 * t1024;
  t1027 = t1018 * t155;
  t1029 = t375 * t383;
  t1030 = t374 * t1029;
  t1031 = t151 * t1027 * t1030;
  t1034 = t375 * t379;
  t1035 = t374 * t1034;
  t1041 = t391 * t392 * t155;
  t1042 = t1020 * t1041;
  t1044 = my_piecewise3(t61, 0, t1008);
  t1045 = my_piecewise3(t63, t1044, 0);
  t1050 = t70 / t357 / t66;
  t1052 = t362 * t155;
  t1054 = 0.1e1 / t363 / t65;
  t1055 = t1052 * t1054;
  t1056 = t366 * t68;
  t1058 = 0.1e1 / t367 / t69;
  t1059 = t1056 * t1058;
  t1060 = t1055 * t1059;
  t1063 = t1055 * t159;
  t1067 = t1055 * t369;
  t1070 = t1018 * t1052;
  t1071 = t359 * t1070;
  t1072 = t1054 * params->csk_a;
  t1073 = t1072 * t159;
  t1076 = t151 * t1070;
  t1079 = -t1050 * t1018 * t1060 - 0.2e1 * t151 * t1018 * t1063 - 0.3e1 * t359 * t1018 * t1067 + 0.3e1 * t151 * t600 * t1035 - t151 * t1045 * t160 - 0.3e1 * t1015 * t608 - 0.3e1 * t1015 * t624 + 0.3e1 * t1071 * t1073 - 0.3e1 * t1076 * t1073 - 0.3e1 * t1025 + 0.3e1 * t1031 - 0.3e1 * t1042 - t386;
  t1084 = t158 * t155;
  t1085 = t374 * t1084;
  t1086 = t151 * t1019 * t1085;
  t1089 = t368 * t383;
  t1090 = t391 * t1089;
  t1091 = t359 * t1027 * t1090;
  t1093 = params->csk_a * params->csk_a;
  t1094 = t1054 * t1093;
  t1095 = t1094 * t159;
  t1098 = t1050 * t1070;
  t1100 = t1054 * t366;
  t1101 = t1100 * t392;
  t1105 = t368 * t379;
  t1109 = t1054 * t1056;
  t1110 = t1058 * params->csk_a;
  t1111 = t1109 * t1110;
  t1114 = t368 * t1093;
  t1115 = t1100 * t1114;
  t1120 = t151 * t379 * t153 * t385;
  t1124 = t1058 * t1093;
  t1125 = t1109 * t1124;
  t1128 = 0.3e1 * t151 * t1014 * t619 + 0.3e1 * t601 * t391 * t1105 + 0.3e1 * t1071 * t1095 + 0.3e1 * t1071 * t1115 - t1076 * t1095 - t1098 * t1095 + 0.3e1 * t1098 * t1101 + 0.3e1 * t1098 * t1111 - 0.3e1 * t1098 * t1115 - 0.2e1 * t1098 * t1125 + 0.3e1 * t1086 + 0.3e1 * t1091 - 0.3e1 * t1120;
  t1130 = my_piecewise5(t58, 0, t61, 0, t1079 + t1128);
  t1132 = -0.77e3 / 0.243e3 * t1002 + t1008 * t71 + 0.3e1 * t353 * t162 + 0.3e1 * t149 * t396 + t53 * t1130;
  t1137 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t965 * t73 + 0.3e1 / 0.1e2 * t971 + 0.9e1 / 0.2e2 * t7 * t323 * t164 - t978 / 0.1e2 + 0.3e1 / 0.5e1 * t981 + 0.9e1 / 0.2e2 * t7 * t130 * t398 + t991 - t993 / 0.1e2 + 0.3e1 / 0.1e2 * t996 + 0.3e1 / 0.2e2 * t7 * t32 * t1132);
  t1139 = 0.1e1 / t84 / t82;
  t1140 = t405 * t172;
  t1143 = t404 * t172;
  t1146 = t79 * t956;
  t1149 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t314 - 0.6e1 * t1146);
  t1153 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1139 * t1140 + 0.1e2 / 0.3e1 * t1143 * t411 + 0.5e1 / 0.3e1 * t85 * t1149);
  t1154 = t1153 * t31;
  t1158 = t415 * t134;
  t1160 = t7 * t1158 * t117;
  t1162 = t175 * t335;
  t1164 = t7 * t1162 * t117;
  t1166 = t87 * t987;
  t1169 = 0.2e1 / 0.45e2 * t7 * t1166 * t117;
  t1171 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1154 * t117 + 0.3e1 / 0.1e2 * t1160 - t1164 / 0.1e2 + t1169);
  tv3rho30 = 0.3e1 * t403 + 0.3e1 * t429 + t8 * (t1137 + t1171);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1174 = 0.2e1 * t455;
  t1175 = 0.2e1 * t481;
  t1176 = t948 * t189;
  t1179 = t309 * t436;
  t1184 = 0.2e1 * t314;
  t1185 = 0.6e1 * t957;
  t1187 = my_piecewise5(t12, 0, t16, 0, t1184 - t1185);
  t1191 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1176 * t310 + 0.2e2 / 0.9e1 * t1179 * t126 + 0.1e2 / 0.9e1 * t432 * t318 + 0.5e1 / 0.3e1 * t27 * t1187);
  t1192 = t1191 * t31;
  t1196 = t440 * t134;
  t1199 = t7 * t1196 * t73 / 0.5e1;
  t1203 = t192 * t335;
  t1205 = t7 * t1203 * t73;
  t1209 = t7 * t445 * t164 / 0.5e1;
  t1218 = 0.3e1 / 0.2e2 * t7 * t1192 * t73 + t1199 + 0.3e1 / 0.1e2 * t7 * t441 * t164 - t1205 / 0.3e2 + t1209 + 0.3e1 / 0.2e2 * t7 * t193 * t398 + t971 / 0.1e2 - t978 / 0.15e2 + t981 / 0.5e1 + t991 - t993 / 0.15e2 + t996 / 0.1e2;
  t1219 = my_piecewise3(t2, 0, t1218);
  t1220 = t1139 * t200;
  t1223 = t404 * t460;
  t1228 = 0.6e1 * t1146;
  t1230 = my_piecewise5(t16, 0, t12, 0, -t1184 - t1228);
  t1234 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1220 * t405 + 0.2e2 / 0.9e1 * t1223 * t172 + 0.1e2 / 0.9e1 * t456 * t411 + 0.5e1 / 0.3e1 * t85 * t1230);
  t1235 = t1234 * t31;
  t1239 = t464 * t134;
  t1242 = t7 * t1239 * t117 / 0.5e1;
  t1243 = t203 * t335;
  t1245 = t7 * t1243 * t117;
  t1254 = t7 * t420 * t233 / 0.5e1;
  t1256 = t7 * t424 * t233;
  t1259 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1235 * t117 + t1242 - t1245 / 0.3e2 + t1160 / 0.1e2 - t1164 / 0.15e2 + t1169 + 0.3e1 / 0.2e2 * t7 * t416 * t233 + t1254 - t1256 / 0.3e2);
  tv3rho31 = t403 + t429 + t1174 + t1175 + t8 * (t1219 + t1259);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1262 = t948 * t486;
  t1267 = t309 * t491;
  t1271 = my_piecewise5(t12, 0, t16, 0, -t1184 - t1185);
  t1275 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1262 * t126 + 0.2e2 / 0.9e1 * t432 * t436 + 0.1e2 / 0.9e1 * t1267 * t126 + 0.5e1 / 0.3e1 * t27 * t1271);
  t1276 = t1275 * t31;
  t1280 = t495 * t134;
  t1282 = t7 * t1280 * t73;
  t1291 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1276 * t73 + t1282 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t496 * t164 + t1199 - t1205 / 0.15e2 + t1209 - t978 / 0.3e2 + t991 - t993 / 0.3e2);
  t1292 = t1139 * t503;
  t1297 = t404 * t508;
  t1301 = my_piecewise5(t16, 0, t12, 0, t1184 - t1228);
  t1305 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1292 * t172 + 0.2e2 / 0.9e1 * t456 * t460 + 0.1e2 / 0.9e1 * t1297 * t172 + 0.5e1 / 0.3e1 * t85 * t1301);
  t1306 = t1305 * t31;
  t1310 = t512 * t134;
  t1312 = t7 * t1310 * t117;
  t1319 = t7 * t469 * t233;
  t1327 = t7 * t180 * t577;
  t1329 = 0.3e1 / 0.2e2 * t7 * t1306 * t117 + t1312 / 0.1e2 + t1242 - t1245 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t465 * t233 + t1319 / 0.5e1 - t1164 / 0.3e2 + t1169 + t1254 - t1256 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t176 * t577 + t1327 / 0.1e2;
  t1330 = my_piecewise3(t78, 0, t1329);
  tv3rho32 = t1174 + t1175 + t502 + t582 + t8 * (t1291 + t1330);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1335 = t486 * t189;
  t1342 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t314 - 0.6e1 * t957);
  t1346 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t948 * t1335 + 0.1e2 / 0.3e1 * t432 * t491 + 0.5e1 / 0.3e1 * t27 * t1342);
  t1347 = t1346 * t31;
  t1354 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1347 * t73 + 0.3e1 / 0.1e2 * t1282 - t1205 / 0.1e2 + t991);
  t1355 = t503 * t200;
  t1362 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t314 - 0.6e1 * t1146);
  t1366 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1139 * t1355 + 0.1e2 / 0.3e1 * t456 * t508 + 0.5e1 / 0.3e1 * t85 * t1362);
  t1367 = t1366 * t31;
  t1384 = 0.1e1 / t91 / t522 / rho[1];
  t1386 = t38 * sigma[2] * t1384;
  t1392 = -0.11e4 / 0.729e3 * t38 * lapl[1] * t524 + 0.616e4 / 0.2187e4 * t1386;
  t1398 = t558 * t541;
  t1399 = t538 * t1398;
  t1402 = t539 * t222;
  t1403 = t1402 * t562;
  t1404 = t538 * t1403;
  t1405 = t543 * params->csk_a;
  t1407 = t224 * t112 * t227;
  t1408 = t1405 * t1407;
  t1409 = t1404 * t1408;
  t1411 = t1402 * t224;
  t1414 = t553 * t554 * t562;
  t1415 = t220 * t1411 * t1414;
  t1418 = t554 * t558;
  t1419 = t553 * t1418;
  t1425 = t570 * t571 * t224;
  t1426 = t1404 * t1425;
  t1430 = t114 / t536 / t110;
  t1432 = t541 * t224;
  t1434 = 0.1e1 / t542 / t109;
  t1435 = t1432 * t1434;
  t1436 = t545 * t112;
  t1438 = 0.1e1 / t546 / t113;
  t1439 = t1436 * t1438;
  t1440 = t1435 * t1439;
  t1442 = my_piecewise3(t105, 0, t1392);
  t1443 = my_piecewise3(t107, t1442, 0);
  t1447 = t1435 * t228;
  t1451 = t1435 * t548;
  t1454 = t1402 * t1432;
  t1455 = t1430 * t1454;
  t1456 = t1434 * t1093;
  t1457 = t1456 * t228;
  t1459 = t538 * t1454;
  t1460 = t1434 * params->csk_a;
  t1461 = t1460 * t228;
  t1464 = -t1430 * t1402 * t1440 - 0.2e1 * t220 * t1402 * t1447 - 0.3e1 * t538 * t1402 * t1451 + 0.3e1 * t220 * t663 * t1419 - t220 * t1443 * t229 - 0.3e1 * t1399 * t671 - 0.3e1 * t1399 * t687 - t1455 * t1457 + 0.3e1 * t1459 * t1461 - 0.3e1 * t1409 + 0.3e1 * t1415 - 0.3e1 * t1426 - t565;
  t1465 = t220 * t1454;
  t1469 = t547 * t562;
  t1470 = t570 * t1469;
  t1471 = t538 * t1411 * t1470;
  t1477 = t227 * t224;
  t1478 = t553 * t1477;
  t1479 = t220 * t1403 * t1478;
  t1481 = t1434 * t545;
  t1482 = t1481 * t571;
  t1488 = t547 * t558;
  t1492 = t1434 * t1436;
  t1493 = t1438 * params->csk_a;
  t1494 = t1492 * t1493;
  t1497 = t547 * t1093;
  t1498 = t1481 * t1497;
  t1503 = t220 * t558 * t222 * t564;
  t1507 = t1438 * t1093;
  t1508 = t1492 * t1507;
  t1511 = 0.3e1 * t220 * t1398 * t682 + 0.3e1 * t664 * t570 * t1488 + 0.3e1 * t1455 * t1482 + 0.3e1 * t1455 * t1494 - 0.3e1 * t1455 * t1498 - 0.2e1 * t1455 * t1508 + 0.3e1 * t1459 * t1457 - t1465 * t1457 + 0.3e1 * t1459 * t1498 - 0.3e1 * t1465 * t1461 + 0.3e1 * t1471 + 0.3e1 * t1479 - 0.3e1 * t1503;
  t1513 = my_piecewise5(t104, 0, t105, 0, t1464 + t1511);
  t1515 = -0.77e3 / 0.243e3 * t1386 + t1392 * t115 + 0.3e1 * t532 * t231 + 0.3e1 * t218 * t575 + t103 * t1513;
  t1520 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1367 * t117 + 0.3e1 / 0.1e2 * t1312 + 0.9e1 / 0.2e2 * t7 * t513 * t233 - t1245 / 0.1e2 + 0.3e1 / 0.5e1 * t1319 + 0.9e1 / 0.2e2 * t7 * t204 * t577 + t1169 - t1256 / 0.1e2 + 0.3e1 / 0.1e2 * t1327 + 0.3e1 / 0.2e2 * t7 * t88 * t1515);
  tv3rho33 = 0.3e1 * t502 + 0.3e1 * t582 + t8 * (t1354 + t1520);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1528 = t7 * t327 * t253;
  t1535 = t7 * t336 * t253 / 0.3e2;
  t1537 = t7 * t135 * t629;
  t1539 = t38 * t345;
  t1542 = t38 * t345 * t71;
  t1545 = t38 * t141 * t162;
  t1548 = t38 * t43 * t396;
  t1553 = t248 * t1052;
  t1554 = t359 * t1553;
  t1556 = t360 * t68 * t158;
  t1557 = t1072 * t1556;
  t1560 = t612 * t362;
  t1561 = t359 * t1560;
  t1564 = t151 * t1553;
  t1567 = t248 * t360;
  t1570 = t383 * t364 * t1023;
  t1571 = t151 * t1567 * t1570;
  t1573 = t360 * t155;
  t1574 = t359 * t1573;
  t1575 = t602 * t383;
  t1576 = t391 * t1575;
  t1577 = t1574 * t1576;
  t1579 = t1054 * t68;
  t1580 = t158 * t1093;
  t1582 = t1579 * t1580 * t360;
  t1586 = t1050 * t1553;
  t1588 = t360 * t1052;
  t1589 = t1050 * t1588;
  t1590 = t1100 * t860;
  t1594 = t360 * t366 * t368;
  t1595 = t1094 * t1594;
  t1598 = t392 * t379;
  t1599 = t391 * t1598;
  t1601 = t1124 * t360;
  t1602 = t1109 * t1601;
  t1605 = t151 * t1560;
  t1613 = t606 * t1035 + 0.3e1 * t1554 * t1557 + 0.3e1 * t1554 * t1582 + 0.3e1 * t1554 * t1595 - 0.3e1 * t1564 * t1557 - 0.2e1 * t1561 * t608 - 0.2e1 * t1561 * t624 - t1564 * t1582 - t1586 * t1582 - 0.3e1 * t1586 * t1595 - 0.2e1 * t1586 * t1602 + 0.3e1 * t1589 * t1590 - t621 * t1599 + 0.2e1 * t1605 * t608 + 0.3e1 * t1571 + 0.3e1 * t1577;
  t1615 = t1058 * t248;
  t1616 = t1615 * params->csk_a;
  t1617 = t1109 * t1616;
  t1620 = t1567 * t383;
  t1621 = t359 * t1620;
  t1622 = t1621 * t1024;
  t1624 = t248 * t155;
  t1625 = t1624 * t364;
  t1626 = t151 * t1625;
  t1627 = params->csk_a * t360;
  t1628 = t1627 * t383;
  t1629 = t159 * t1628;
  t1630 = t1626 * t1629;
  t1632 = t1621 * t1041;
  t1635 = my_piecewise3(t61, 0, -0.44e3 / 0.729e3 * t1539);
  t1636 = my_piecewise3(t63, t1635, 0);
  t1639 = t158 * t360;
  t1640 = t1579 * t1639;
  t1643 = t359 * t1588;
  t1644 = t1100 * t602;
  t1650 = t368 * t612;
  t1651 = t391 * t1650;
  t1656 = t612 * t153;
  t1658 = t151 * t1656 * t385;
  t1662 = t151 * t248 * t379 * t385;
  t1663 = t158 * t379;
  t1664 = t374 * t1663;
  t1666 = -t1589 * t1109 * t1615 - t151 * t1636 * t160 + t1015 * t603 - t621 * t1035 - 0.2e1 * t1564 * t1640 + 0.3e1 * t1589 * t1617 + 0.2e1 * t1605 * t619 - 0.3e1 * t1643 * t1644 + 0.2e1 * t601 * t1651 + t606 * t1664 - 0.3e1 * t1622 + 0.3e1 * t1630 - 0.3e1 * t1632 - 0.2e1 * t1658 - t1662 - t617;
  t1668 = my_piecewise5(t58, 0, t61, 0, t1613 + t1666);
  t1670 = 0.55e2 / 0.81e2 * t1539 - 0.44e3 / 0.729e3 * t1542 + 0.8e2 / 0.243e3 * t1545 - 0.5e1 / 0.81e2 * t1548 + t353 * t251 + 0.2e1 * t149 * t627 + t53 * t1668;
  t1675 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t253 + t1528 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t629 - t1535 + t1537 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1670);
  tv3rho2sigma0 = t8 * t1675 + 0.2e1 * t634;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1682 = t7 * t420 * t270;
  t1686 = t7 * t424 * t270 / 0.3e2;
  t1688 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t270 + t1682 / 0.5e1 - t1686);
  tv3rho2sigma2 = t8 * t1688 + 0.2e1 * t643;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1694 = t7 * t445 * t253;
  t1702 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t253 + t1694 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t629 + t1528 / 0.1e2 - t1535 + t1537 / 0.1e2);
  tv3rho2sigma3 = t8 * t1702 + t634 + t649;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1708 = t7 * t469 * t270;
  t1715 = t7 * t180 * t692;
  t1718 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t270 + t1708 / 0.1e2 + t1682 / 0.1e2 - t1686 + 0.3e1 / 0.2e2 * t7 * t176 * t692 + t1715 / 0.1e2);
  tv3rho2sigma5 = t8 * t1718 + t643 + t697;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1726 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t253 + t1694 / 0.5e1 - t1535);
  tv3rho2sigma6 = t8 * t1726 + 0.2e1 * t649;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1737 = t38 * t524;
  t1740 = t38 * t524 * t115;
  t1743 = t38 * t210 * t231;
  t1746 = t38 * t93 * t575;
  t1751 = t675 * t541;
  t1752 = t538 * t1751;
  t1755 = t265 * t1432;
  t1756 = t538 * t1755;
  t1758 = t539 * t112 * t227;
  t1759 = t1460 * t1758;
  t1764 = t220 * t1755;
  t1767 = t539 * t224;
  t1768 = t538 * t1767;
  t1769 = t665 * t562;
  t1770 = t570 * t1769;
  t1771 = t1768 * t1770;
  t1773 = t265 * t539;
  t1776 = t562 * t543 * t1407;
  t1777 = t220 * t1773 * t1776;
  t1779 = t1430 * t1755;
  t1780 = t1456 * t1758;
  t1782 = t539 * t1432;
  t1783 = t1430 * t1782;
  t1784 = t1481 * t888;
  t1792 = t539 * t545 * t547;
  t1793 = t1456 * t1792;
  t1796 = t571 * t558;
  t1797 = t570 * t1796;
  t1799 = t1507 * t539;
  t1800 = t1492 * t1799;
  t1803 = t1438 * t265;
  t1804 = t1803 * params->csk_a;
  t1805 = t1492 * t1804;
  t1808 = t220 * t1751;
  t1811 = -t684 * t1419 - 0.2e1 * t1752 * t671 - 0.2e1 * t1752 * t687 + 0.3e1 * t1756 * t1759 + 0.3e1 * t1756 * t1780 - 0.3e1 * t1764 * t1759 - t1764 * t1780 - t1779 * t1780 - 0.3e1 * t1779 * t1793 - 0.2e1 * t1779 * t1800 + 0.3e1 * t1783 * t1784 + 0.3e1 * t1783 * t1805 - t684 * t1797 + 0.2e1 * t1808 * t671 + 0.3e1 * t1771 + 0.3e1 * t1777;
  t1815 = t1773 * t562;
  t1816 = t538 * t1815;
  t1817 = t1816 * t1408;
  t1819 = t265 * t224;
  t1820 = t1819 * t543;
  t1821 = t220 * t1820;
  t1823 = params->csk_a * t539 * t562;
  t1824 = t228 * t1823;
  t1825 = t1821 * t1824;
  t1827 = t1816 * t1425;
  t1830 = my_piecewise3(t105, 0, -0.44e3 / 0.729e3 * t1737);
  t1831 = my_piecewise3(t107, t1830, 0);
  t1834 = t538 * t1782;
  t1835 = t1481 * t665;
  t1838 = t1434 * t112;
  t1839 = t227 * t539;
  t1840 = t1838 * t1839;
  t1845 = t220 * t675 * t222 * t564;
  t1849 = t220 * t265 * t558 * t564;
  t1850 = t227 * t558;
  t1851 = t553 * t1850;
  t1856 = t547 * t675;
  t1857 = t570 * t1856;
  t1862 = -t1783 * t1492 * t1803 - t220 * t1831 * t229 + t1399 * t666 + t669 * t1419 + 0.3e1 * t1756 * t1793 - 0.2e1 * t1764 * t1840 + 0.2e1 * t1808 * t682 - 0.3e1 * t1834 * t1835 + t669 * t1851 + 0.2e1 * t664 * t1857 - 0.3e1 * t1817 + 0.3e1 * t1825 - 0.3e1 * t1827 - 0.2e1 * t1845 - t1849 - t680;
  t1864 = my_piecewise5(t104, 0, t105, 0, t1811 + t1862);
  t1866 = 0.55e2 / 0.81e2 * t1737 - 0.44e3 / 0.729e3 * t1740 + 0.8e2 / 0.243e3 * t1743 - 0.5e1 / 0.81e2 * t1746 + t532 * t268 + 0.2e1 * t218 * t690 + t103 * t1864;
  t1871 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t270 + t1708 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t692 - t1686 + t1715 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t1866);
  tv3rho2sigma8 = t8 * t1871 + 0.2e1 * t697;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1878 = t7 * t327 * t286;
  t1885 = t7 * t336 * t286 / 0.3e2;
  t1887 = t7 * t135 * t731;
  t1898 = t281 * t1052;
  t1899 = t359 * t1898;
  t1902 = t718 * t362;
  t1903 = t359 * t1902;
  t1910 = t151 * t1898;
  t1913 = t710 * t383;
  t1914 = t391 * t1913;
  t1915 = t1574 * t1914;
  t1917 = t281 * t360;
  t1919 = t151 * t1917 * t1570;
  t1921 = t710 * params->csk_a;
  t1922 = t1100 * t1921;
  t1928 = t1050 * t1898;
  t1936 = t714 * t1035 - t725 * t1035 + 0.3e1 * t1899 * t1557 - 0.3e1 * t1910 * t1557 + 0.3e1 * t1899 * t1582 - t1910 * t1582 - t1928 * t1582 + 0.3e1 * t1589 * t1922 + 0.3e1 * t1899 * t1595 - 0.3e1 * t1928 * t1595 - t725 * t1599 - 0.2e1 * t1928 * t1602 - 0.2e1 * t1903 * t608 - 0.2e1 * t1903 * t624 + 0.3e1 * t1915 + 0.3e1 * t1919;
  t1937 = t1058 * t281;
  t1938 = t1937 * params->csk_a;
  t1939 = t1109 * t1938;
  t1942 = t151 * t1902;
  t1945 = t1917 * t383;
  t1946 = t359 * t1945;
  t1947 = t1946 * t1024;
  t1950 = t281 * t155 * t364;
  t1951 = t151 * t1950;
  t1952 = t1951 * t1629;
  t1954 = t1946 * t1041;
  t1957 = my_piecewise3(t61, 0, 0.1e3 / 0.243e3 * t591);
  t1958 = my_piecewise3(t63, t1957, 0);
  t1963 = t1100 * t710;
  t1968 = t151 * t281 * t379 * t385;
  t1971 = t368 * t718;
  t1972 = t391 * t1971;
  t1975 = t1109 * t1937;
  t1977 = t718 * t153;
  t1979 = t151 * t1977 * t385;
  t1983 = -t151 * t1958 * t160 + t1015 * t711 + 0.3e1 * t1589 * t1939 - t1589 * t1975 - 0.2e1 * t1910 * t1640 - 0.3e1 * t1643 * t1963 + t714 * t1664 + 0.2e1 * t1942 * t608 + 0.2e1 * t1942 * t619 + 0.2e1 * t601 * t1972 - 0.3e1 * t1947 + 0.3e1 * t1952 - 0.3e1 * t1954 - t1968 - 0.2e1 * t1979 - t723;
  t1985 = my_piecewise5(t58, 0, t61, 0, t1936 + t1983);
  t1987 = 0.1e3 / 0.243e3 * t594 - 0.25e2 / 0.81e2 * t597 + 0.5e1 / 0.54e2 * t38 * t48 * t396 + t353 * t284 + 0.2e1 * t149 * t729 + t53 * t1985;
  t1992 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t286 + t1878 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t731 - t1885 + t1887 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1987);
  tv3rho2lapl0 = t8 * t1992 + 0.2e1 * t736;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1999 = t7 * t420 * t302;
  t2003 = t7 * t424 * t302 / 0.3e2;
  t2005 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t302 + t1999 / 0.5e1 - t2003);
  tv3rho2lapl1 = t8 * t2005 + 0.2e1 * t745;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2011 = t7 * t445 * t286;
  t2019 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t286 + t2011 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t731 + t1878 / 0.1e2 - t1885 + t1887 / 0.1e2);
  tv3rho2lapl2 = t8 * t2019 + t736 + t751;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2025 = t7 * t469 * t302;
  t2032 = t7 * t180 * t782;
  t2035 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t302 + t2025 / 0.1e2 + t1999 / 0.1e2 - t2003 + 0.3e1 / 0.2e2 * t7 * t176 * t782 + t2032 / 0.1e2);
  tv3rho2lapl3 = t8 * t2035 + t745 + t787;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2043 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t286 + t2011 / 0.5e1 - t1885);
  tv3rho2lapl4 = t8 * t2043 + 0.2e1 * t751;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2063 = t297 * t1432;
  t2064 = t1430 * t2063;
  t2070 = t538 * t2063;
  t2073 = t769 * t541;
  t2074 = t538 * t2073;
  t2077 = t220 * t2063;
  t2080 = t297 * t539;
  t2082 = t220 * t2080 * t1776;
  t2084 = t761 * t562;
  t2085 = t570 * t2084;
  t2086 = t1768 * t2085;
  t2091 = t761 * params->csk_a;
  t2092 = t1481 * t2091;
  t2096 = t1438 * t297;
  t2097 = t2096 * params->csk_a;
  t2098 = t1492 * t2097;
  t2101 = t220 * t2073;
  t2105 = t765 * t1419 - t776 * t1419 + 0.3e1 * t2070 * t1759 - 0.3e1 * t2077 * t1759 - t2064 * t1780 + 0.3e1 * t2070 * t1780 - t2077 * t1780 + 0.3e1 * t1783 * t2092 + 0.3e1 * t1783 * t2098 - 0.3e1 * t2064 * t1793 - t776 * t1797 - 0.2e1 * t2064 * t1800 - 0.2e1 * t2074 * t671 + 0.2e1 * t2101 * t671 + 0.3e1 * t2082 + 0.3e1 * t2086;
  t2111 = t538 * t2080 * t562;
  t2112 = t2111 * t1408;
  t2115 = t297 * t224 * t543;
  t2116 = t220 * t2115;
  t2117 = t2116 * t1824;
  t2119 = t2111 * t1425;
  t2122 = my_piecewise3(t105, 0, 0.1e3 / 0.243e3 * t654);
  t2123 = my_piecewise3(t107, t2122, 0);
  t2126 = t297 * t558;
  t2128 = t220 * t2126 * t564;
  t2131 = t547 * t769;
  t2132 = t570 * t2131;
  t2135 = t1492 * t2096;
  t2137 = t769 * t222;
  t2139 = t220 * t2137 * t564;
  t2141 = t1481 * t761;
  t2148 = -t220 * t2123 * t229 + t1399 * t762 - t1783 * t2135 + 0.3e1 * t2070 * t1793 - 0.3e1 * t1834 * t2141 - 0.2e1 * t2077 * t1840 + t765 * t1851 - 0.2e1 * t2074 * t687 + 0.2e1 * t2101 * t682 + 0.2e1 * t664 * t2132 - 0.3e1 * t2112 + 0.3e1 * t2117 - 0.3e1 * t2119 - t2128 - 0.2e1 * t2139 - t774;
  t2150 = my_piecewise5(t104, 0, t105, 0, t2105 + t2148);
  t2152 = 0.1e3 / 0.243e3 * t657 - 0.25e2 / 0.81e2 * t660 + 0.5e1 / 0.54e2 * t38 * t98 * t575 + t532 * t300 + 0.2e1 * t218 * t780 + t103 * t2150;
  t2157 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t302 + t2025 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t782 - t2003 + t2032 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t2152);
  tv3rho2lapl5 = t8 * t2157 + 0.2e1 * t787;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2164 = t7 * t135 * t811 / 0.1e2;
  t2166 = t38 * t141 * t251;
  t2169 = t38 * t43 * t627;
  t2172 = t792 * t1052;
  t2173 = t1050 * t2172;
  t2174 = t1110 * t153;
  t2175 = t1109 * t2174;
  t2178 = t375 * t612;
  t2179 = t374 * t2178;
  t2182 = t359 * t2172;
  t2183 = t1114 * t153;
  t2184 = t1100 * t2183;
  t2187 = t1124 * t153;
  t2188 = t1109 * t2187;
  t2191 = t1100 * t623;
  t2194 = t151 * t2172;
  t2196 = t1579 * t1580 * t153;
  t2202 = t153 * t68 * t158;
  t2203 = t1072 * t2202;
  t2206 = t799 * t362;
  t2207 = t151 * t2206;
  t2208 = t2207 * t608;
  t2209 = t359 * t2206;
  t2210 = t2209 * t608;
  t2213 = t2209 * t624;
  t2214 = t792 * t383;
  t2215 = t151 * t2214;
  t2217 = t374 * t618 * t155;
  t2218 = t2215 * t2217;
  t2224 = 0.3e1 * t2173 * t2175 - 0.3e1 * t2173 * t2184 - 0.2e1 * t2173 * t2188 + 0.3e1 * t2173 * t2191 - t2173 * t2196 + 0.2e1 * t606 * t2179 - 0.2e1 * t621 * t2179 + 0.3e1 * t2182 * t2184 + 0.3e1 * t2182 * t2196 + 0.3e1 * t2182 * t2203 - t2194 * t2196 - 0.3e1 * t2194 * t2203 + t2208 - t2210 - t2213 + 0.3e1 * t2218;
  t2225 = t392 * t612;
  t2226 = t391 * t2225;
  t2229 = t792 * t155;
  t2230 = t359 * t2229;
  t2231 = t368 * t153;
  t2232 = t2231 * t383;
  t2233 = t391 * t2232;
  t2234 = t2230 * t2233;
  t2237 = t359 * t2214 * t364;
  t2238 = params->csk_a * t153;
  t2239 = t2238 * t1023;
  t2240 = t2237 * t2239;
  t2243 = t151 * t2229 * t364;
  t2244 = t2238 * t383;
  t2245 = t159 * t2244;
  t2246 = t2243 * t2245;
  t2248 = t2238 * t155;
  t2249 = t369 * t2248;
  t2250 = t2237 * t2249;
  t2252 = t248 * t383;
  t2253 = t151 * t2252;
  t2254 = t156 * t68;
  t2255 = t158 * t612;
  t2257 = t2253 * t2254 * t2255;
  t2258 = 0.2e1 * t2257;
  t2259 = t374 * t2255;
  t2264 = t153 * t1052;
  t2265 = t1050 * t2264;
  t2266 = t1058 * t792;
  t2267 = t1109 * t2266;
  t2269 = t368 * t799;
  t2270 = t391 * t2269;
  t2271 = t601 * t2270;
  t2272 = t799 * t153;
  t2274 = t151 * t2272 * t385;
  t2275 = t1579 * t618;
  t2278 = t1100 * t2231;
  t2281 = t2207 * t619;
  t2282 = 0.2e1 * t621 * t1651 - 0.3e1 * t2182 * t2278 - 0.2e1 * t2194 * t2275 - 0.2e1 * t621 * t2226 + 0.2e1 * t606 * t2259 - t2265 * t2267 + 0.3e1 * t2234 - 0.3e1 * t2240 + 0.3e1 * t2246 - 0.3e1 * t2250 - t2258 + t2271 - t2274 + t2281 - t801 - t803;
  t2284 = my_piecewise5(t58, 0, t61, 0, t2224 + t2282);
  t2286 = 0.8e2 / 0.243e3 * t2166 - 0.1e2 / 0.81e2 * t2169 + t149 * t809 + t53 * t2284;
  t2291 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t811 + t2164 + 0.3e1 / 0.2e2 * t7 * t32 * t2286);
  tv3rhosigma20 = t8 * t2291 + t815;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2298 = t7 * t180 * t838 / 0.1e2;
  t2300 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t838 + t2298);
  tv3rhosigma25 = t8 * t2300 + t842;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2306 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t811 + t2164);
  tv3rhosigma26 = t8 * t2306 + t815;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2312 = t38 * t210 * t268;
  t2315 = t38 * t93 * t690;
  t2318 = t819 * t1432;
  t2319 = t1430 * t2318;
  t2320 = t548 * t222;
  t2321 = t1456 * t2320;
  t2324 = t571 * t675;
  t2325 = t570 * t2324;
  t2328 = t1507 * t222;
  t2329 = t1492 * t2328;
  t2332 = t1493 * t222;
  t2333 = t1492 * t2332;
  t2336 = t554 * t675;
  t2337 = t553 * t2336;
  t2340 = t538 * t2318;
  t2343 = t826 * t541;
  t2344 = t538 * t2343;
  t2345 = t2344 * t687;
  t2346 = t819 * t562;
  t2347 = t220 * t2346;
  t2349 = t553 * t681 * t224;
  t2350 = t2347 * t2349;
  t2354 = t819 * t224;
  t2355 = t538 * t2354;
  t2356 = t547 * t222;
  t2357 = t2356 * t562;
  t2358 = t570 * t2357;
  t2359 = t2355 * t2358;
  t2361 = t1481 * t686;
  t2364 = t220 * t2318;
  t2365 = t227 * t1093;
  t2367 = t1838 * t2365 * t222;
  t2372 = t220 * t2343;
  t2373 = t2372 * t671;
  t2375 = t538 * t2346 * t543;
  t2376 = params->csk_a * t222;
  t2377 = t2376 * t1407;
  t2378 = t2375 * t2377;
  t2380 = -0.3e1 * t2319 * t2321 - 0.2e1 * t2319 * t2329 + 0.3e1 * t2319 * t2333 + 0.3e1 * t2319 * t2361 - t2319 * t2367 + 0.3e1 * t2340 * t2321 - 0.2e1 * t684 * t2325 + 0.2e1 * t669 * t2337 - 0.2e1 * t684 * t2337 + 0.3e1 * t2340 * t2367 - t2364 * t2367 - t2345 + 0.3e1 * t2350 + 0.3e1 * t2359 + t2373 - 0.3e1 * t2378;
  t2381 = t2376 * t224;
  t2382 = t548 * t2381;
  t2383 = t2375 * t2382;
  t2386 = t220 * t2354 * t543;
  t2387 = t2376 * t562;
  t2388 = t228 * t2387;
  t2389 = t2386 * t2388;
  t2391 = t2344 * t671;
  t2393 = t222 * t112 * t227;
  t2394 = t1460 * t2393;
  t2399 = t2372 * t682;
  t2400 = t1838 * t681;
  t2403 = t1481 * t2356;
  t2408 = t222 * t1432;
  t2409 = t1430 * t2408;
  t2410 = t1438 * t819;
  t2411 = t1492 * t2410;
  t2413 = t547 * t826;
  t2414 = t570 * t2413;
  t2415 = t664 * t2414;
  t2418 = t220 * t826 * t222 * t564;
  t2419 = t265 * t562;
  t2420 = t220 * t2419;
  t2421 = t225 * t112;
  t2422 = t227 * t675;
  t2424 = t2420 * t2421 * t2422;
  t2425 = 0.2e1 * t2424;
  t2426 = t553 * t2422;
  t2429 = 0.2e1 * t684 * t1857 + 0.3e1 * t2340 * t2394 - 0.3e1 * t2340 * t2403 - 0.3e1 * t2364 * t2394 - 0.2e1 * t2364 * t2400 - t2409 * t2411 + 0.2e1 * t669 * t2426 - 0.3e1 * t2383 + 0.3e1 * t2389 - t2391 + t2399 + t2415 - t2418 - t2425 - t828 - t830;
  t2431 = my_piecewise5(t104, 0, t105, 0, t2380 + t2429);
  t2433 = 0.8e2 / 0.243e3 * t2312 - 0.1e2 / 0.81e2 * t2315 + t218 * t836 + t103 * t2431;
  t2438 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t838 + t2298 + 0.3e1 / 0.2e2 * t7 * t88 * t2433);
  tv3rhosigma211 = t8 * t2438 + t842;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2445 = t7 * t135 * t866 / 0.1e2;
  t2451 = t38 * t141 * t284;
  t2454 = t38 * t43 * t729;
  t2457 = t1553 * t1054;
  t2458 = t1050 * t2457;
  t2459 = t281 * params->csk_a;
  t2460 = t2459 * t153;
  t2461 = t1059 * t2460;
  t2464 = t1898 * t1054;
  t2465 = t359 * t2464;
  t2466 = t1093 * t248;
  t2467 = t2466 * t153;
  t2468 = t369 * t2467;
  t2471 = t853 * t383;
  t2472 = t151 * t2471;
  t2473 = t2472 * t2217;
  t2475 = t369 * t2460;
  t2478 = t151 * t2464;
  t2479 = t159 * t2467;
  t2483 = t1050 * t2464;
  t2485 = t159 * t248;
  t2486 = t2238 * t2485;
  t2493 = t1059 * t2467;
  t2496 = t359 * t1625;
  t2497 = t721 * t383;
  t2498 = t369 * t2497;
  t2499 = t2496 * t2498;
  t2501 = t359 * t2471;
  t2503 = t1021 * t153 * t1023;
  t2504 = t2501 * t2503;
  t2506 = t159 * params->csk_a;
  t2507 = t615 * t383;
  t2508 = t2506 * t2507;
  t2509 = t1951 * t2508;
  t2511 = t391 * t368;
  t2512 = t2511 * t2248;
  t2513 = t2501 * t2512;
  t2515 = 0.3e1 * t2458 * t2461 + 0.3e1 * t2458 * t2475 + 0.3e1 * t2465 * t2468 + 0.3e1 * t2465 * t2479 + 0.3e1 * t2465 * t2486 - 0.3e1 * t2483 * t2468 - t2478 * t2479 - 0.3e1 * t2478 * t2486 - t2483 * t2479 - 0.2e1 * t2483 * t2493 + t2208 - t2210 - t2213 + 0.3e1 * t2473 + 0.3e1 * t2499 - 0.3e1 * t2504 + 0.3e1 * t2509 - 0.3e1 * t2513 - t801;
  t2520 = t1615 * t281;
  t2521 = t1109 * t2520;
  t2525 = t856 * t153;
  t2526 = t1579 * t2525;
  t2529 = t710 * t153;
  t2530 = t1100 * t2529;
  t2536 = t718 * t248;
  t2538 = t151 * t2536 * t385;
  t2541 = t151 * t281 * t612 * t385;
  t2543 = -0.3e1 * t1554 * t2530 + t1561 * t711 - t1903 * t851 - t1903 * t861 - 0.2e1 * t1910 * t2526 + t1942 * t851 + t1942 * t857 + t621 * t1972 + t714 * t2179 - t725 * t2179 - t725 * t2226 + t714 * t2259 - t2265 * t2521 + t2271 - t2274 + t2281 - t2538 - t2541 - t855;
  t2545 = my_piecewise5(t58, 0, t61, 0, t2515 + t2543);
  t2547 = -0.25e2 / 0.162e3 * t790 + 0.5e1 / 0.54e2 * t38 * t48 * t627 + 0.4e2 / 0.243e3 * t2451 - 0.5e1 / 0.81e2 * t2454 + t149 * t864 + t53 * t2545;
  t2552 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t866 + t2445 + 0.3e1 / 0.2e2 * t7 * t32 * t2547);
  tv3rhosigmalapl0 = t8 * t2552 + t870;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2559 = t7 * t180 * t894 / 0.1e2;
  t2561 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t894 + t2559);
  tv3rhosigmalapl5 = t8 * t2561 + t898;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2567 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t866 + t2445);
  tv3rhosigmalapl6 = t8 * t2567 + t870;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2577 = t38 * t210 * t300;
  t2580 = t38 * t93 * t780;
  t2583 = t1755 * t1434;
  t2584 = t1430 * t2583;
  t2585 = t297 * params->csk_a;
  t2586 = t2585 * t222;
  t2587 = t1439 * t2586;
  t2590 = t548 * t2586;
  t2593 = t2063 * t1434;
  t2594 = t220 * t2593;
  t2595 = t1093 * t265;
  t2596 = t2595 * t222;
  t2597 = t228 * t2596;
  t2599 = t538 * t2593;
  t2602 = t1430 * t2593;
  t2604 = t228 * t265;
  t2605 = t2376 * t2604;
  t2610 = t1439 * t2596;
  t2613 = t548 * t2596;
  t2616 = t881 * t562;
  t2617 = t220 * t2616;
  t2618 = t2617 * t2349;
  t2622 = t538 * t1820;
  t2624 = t548 * t772 * t562;
  t2625 = t2622 * t2624;
  t2627 = t538 * t2616;
  t2628 = t570 * t547;
  t2629 = t2628 * t2381;
  t2630 = t2627 * t2629;
  t2633 = t1405 * t222 * t1407;
  t2634 = t2627 * t2633;
  t2636 = t228 * params->csk_a;
  t2637 = t678 * t562;
  t2638 = t2636 * t2637;
  t2639 = t2116 * t2638;
  t2641 = t761 * t222;
  t2642 = t1481 * t2641;
  t2645 = -0.3e1 * t1756 * t2642 + 0.3e1 * t2584 * t2587 + 0.3e1 * t2584 * t2590 - t2594 * t2597 - 0.3e1 * t2594 * t2605 + 0.3e1 * t2599 * t2597 - t2602 * t2597 + 0.3e1 * t2599 * t2605 + 0.3e1 * t2599 * t2613 - 0.2e1 * t2602 * t2610 - 0.3e1 * t2602 * t2613 - t2345 + t2373 + 0.3e1 * t2618 + 0.3e1 * t2625 - 0.3e1 * t2630 - 0.3e1 * t2634 + 0.3e1 * t2639 - t828;
  t2652 = t1803 * t297;
  t2653 = t1492 * t2652;
  t2655 = t884 * t222;
  t2656 = t1838 * t2655;
  t2665 = t220 * t769 * t265 * t564;
  t2668 = t220 * t297 * t675 * t564;
  t2669 = t1752 * t762 - t2074 * t879 - t2074 * t889 - 0.2e1 * t2077 * t2656 + t2101 * t879 + t2101 * t885 + t684 * t2132 - t776 * t2325 + t765 * t2337 - t776 * t2337 - t2409 * t2653 + t765 * t2426 - t2391 + t2399 + t2415 - t2418 - t2665 - t2668 - t883;
  t2671 = my_piecewise5(t104, 0, t105, 0, t2645 + t2669);
  t2673 = -0.25e2 / 0.162e3 * t817 + 0.5e1 / 0.54e2 * t38 * t98 * t690 + 0.4e2 / 0.243e3 * t2577 - 0.5e1 / 0.81e2 * t2580 + t218 * t892 + t103 * t2671;
  t2678 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t894 + t2559 + 0.3e1 / 0.2e2 * t7 * t88 * t2673);
  tv3rhosigmalapl11 = t8 * t2678 + t898;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2685 = t7 * t135 * t917 / 0.1e2;
  t2691 = t902 * t383;
  t2693 = t359 * t2691 * t364;
  t2694 = t2693 * t2249;
  t2696 = t2693 * t2239;
  t2698 = t902 * t155;
  t2700 = t151 * t2698 * t364;
  t2701 = t2700 * t2245;
  t2703 = t902 * t1052;
  t2704 = t151 * t2703;
  t2706 = t359 * t2703;
  t2709 = t1050 * t2703;
  t2715 = t392 * t718;
  t2723 = -0.2e1 * t725 * t391 * t2715 + 0.3e1 * t2709 * t2175 - 0.2e1 * t2709 * t2188 - t2704 * t2196 + 0.3e1 * t2706 * t2196 - t2709 * t2196 - 0.3e1 * t2704 * t2203 + 0.3e1 * t2706 * t2203 + t2208 - t2210 - t2213 - 0.3e1 * t2694 - 0.3e1 * t2696 + 0.3e1 * t2701 - t801 - t909;
  t2724 = t375 * t718;
  t2725 = t374 * t2724;
  t2730 = t151 * t2691;
  t2731 = t2730 * t2217;
  t2737 = t359 * t2698;
  t2738 = t2737 * t2233;
  t2746 = t1058 * t902;
  t2747 = t1109 * t2746;
  t2749 = t281 * t383;
  t2750 = t151 * t2749;
  t2751 = t158 * t718;
  t2753 = t2750 * t2254 * t2751;
  t2754 = 0.2e1 * t2753;
  t2760 = 0.2e1 * t714 * t374 * t2751 + 0.2e1 * t725 * t1972 + 0.3e1 * t2706 * t2184 - 0.3e1 * t2709 * t2184 + 0.3e1 * t2709 * t2191 - t2265 * t2747 - 0.2e1 * t2704 * t2275 - 0.3e1 * t2706 * t2278 + 0.2e1 * t714 * t2725 - 0.2e1 * t725 * t2725 + t2271 - t2274 + t2281 + 0.3e1 * t2731 + 0.3e1 * t2738 - t2754;
  t2762 = my_piecewise5(t58, 0, t61, 0, t2723 + t2760);
  t2764 = -0.25e2 / 0.81e2 * t847 + 0.5e1 / 0.27e2 * t38 * t48 * t729 + t149 * t915 + t53 * t2762;
  t2769 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t917 + t2685 + 0.3e1 / 0.2e2 * t7 * t32 * t2764);
  tv3rholapl20 = t8 * t2769 + t921;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2776 = t7 * t180 * t940 / 0.1e2;
  t2778 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t940 + t2776);
  tv3rholapl22 = t8 * t2778 + t944;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2784 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t917 + t2685);
  tv3rholapl23 = t8 * t2784 + t921;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2794 = t925 * t562;
  t2796 = t538 * t2794 * t543;
  t2797 = t2796 * t2377;
  t2799 = t925 * t224;
  t2801 = t220 * t2799 * t543;
  t2802 = t2801 * t2388;
  t2804 = t2796 * t2382;
  t2806 = t925 * t1432;
  t2807 = t1430 * t2806;
  t2811 = t220 * t2806;
  t2813 = t538 * t2806;
  t2824 = t220 * t2794;
  t2825 = t2824 * t2349;
  t2827 = 0.3e1 * t2813 * t2321 - 0.2e1 * t2807 * t2329 + 0.3e1 * t2807 * t2361 - t2807 * t2367 - t2811 * t2367 + 0.3e1 * t2813 * t2367 - 0.3e1 * t2811 * t2394 + 0.3e1 * t2813 * t2394 - t2345 + t2373 - 0.3e1 * t2797 + 0.3e1 * t2802 - 0.3e1 * t2804 + 0.3e1 * t2825 - t828 - t932;
  t2828 = t228 * t769;
  t2829 = t1405 * t2828;
  t2834 = t571 * t769;
  t2838 = t538 * t2799;
  t2839 = t2838 * t2358;
  t2849 = t297 * t562;
  t2850 = t220 * t2849;
  t2851 = t227 * t769;
  t2853 = t2850 * t2421 * t2851;
  t2854 = 0.2e1 * t2853;
  t2860 = t1438 * t925;
  t2861 = t1492 * t2860;
  t2863 = -0.2e1 * t776 * t570 * t2834 + 0.2e1 * t765 * t553 * t2851 + 0.2e1 * t776 * t2132 - 0.3e1 * t2807 * t2321 + 0.3e1 * t2807 * t2333 - 0.2e1 * t2811 * t2400 - 0.3e1 * t2813 * t2403 - t2409 * t2861 + 0.2e1 * t765 * t2829 - 0.2e1 * t776 * t2829 - t2391 + t2399 + t2415 - t2418 + 0.3e1 * t2839 - t2854;
  t2865 = my_piecewise5(t104, 0, t105, 0, t2827 + t2863);
  t2867 = -0.25e2 / 0.81e2 * t875 + 0.5e1 / 0.27e2 * t38 * t98 * t780 + t218 * t938 + t103 * t2865;
  t2872 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t940 + t2776 + 0.3e1 / 0.2e2 * t7 * t88 * t2867);
  tv3rholapl25 = t8 * t2872 + t944;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2875 = t38 * t43 * t809;
  t2877 = t792 * t248;
  t2886 = t2877 * t383;
  t2887 = t359 * t2886;
  t2888 = t2887 * t1041;
  t2889 = 0.3e1 * t2888;
  t2890 = t2209 * t851;
  t2891 = 0.3e1 * t2890;
  t2892 = t2887 * t1024;
  t2893 = 0.3e1 * t2892;
  t2894 = t2877 * t155;
  t2896 = t151 * t2894 * t1030;
  t2897 = 0.3e1 * t2896;
  t2898 = t375 * t799;
  t2899 = t374 * t2898;
  t2900 = t606 * t2899;
  t2901 = 0.3e1 * t2900;
  t2902 = t2209 * t861;
  t2903 = 0.3e1 * t2902;
  t2904 = t2877 * t1052;
  t2905 = t1050 * t2904;
  t2910 = -t1050 * t2877 * t1060 - 0.2e1 * t151 * t2877 * t1063 - 0.3e1 * t359 * t2877 * t1067 - 0.3e1 * t2905 * t1115 - 0.2e1 * t2905 * t1125 - t2889 - t2891 - t2893 + t2897 + t2901 - t2903 - t801 - t803;
  t2912 = t359 * t2894 * t1090;
  t2913 = 0.3e1 * t2912;
  t2914 = t2207 * t857;
  t2915 = 0.3e1 * t2914;
  t2916 = t151 * t2886;
  t2917 = t2916 * t1085;
  t2918 = 0.3e1 * t2917;
  t2919 = t359 * t2904;
  t2922 = t799 * t248;
  t2924 = t151 * t2922 * t385;
  t2925 = 0.3e1 * t2924;
  t2926 = t621 * t2270;
  t2927 = 0.3e1 * t2926;
  t2932 = t151 * t2904;
  t2941 = 0.3e1 * t2919 * t1073 - 0.3e1 * t2932 * t1073 - t2905 * t1095 + 0.3e1 * t2919 * t1095 - t2932 * t1095 + 0.3e1 * t2905 * t1101 + 0.3e1 * t2905 * t1111 + 0.3e1 * t2919 * t1115 + t2913 + t2915 + t2918 - t2925 + t2927;
  t2943 = my_piecewise5(t58, 0, t61, 0, t2910 + t2941);
  t2945 = -0.5e1 / 0.27e2 * t2875 + t53 * t2943;
  t2949 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t2945);
  tv3sigma30 = t8 * t2949;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2951 = t38 * t93 * t836;
  t2953 = t819 * t265;
  t2962 = t2344 * t879;
  t2963 = 0.3e1 * t2962;
  t2964 = t2953 * t562;
  t2965 = t538 * t2964;
  t2966 = t2965 * t1408;
  t2967 = 0.3e1 * t2966;
  t2968 = t2953 * t224;
  t2970 = t220 * t2968 * t1414;
  t2971 = 0.3e1 * t2970;
  t2972 = t554 * t826;
  t2973 = t553 * t2972;
  t2974 = t669 * t2973;
  t2975 = 0.3e1 * t2974;
  t2976 = t2344 * t889;
  t2977 = 0.3e1 * t2976;
  t2978 = t2965 * t1425;
  t2979 = 0.3e1 * t2978;
  t2980 = t2953 * t1432;
  t2981 = t220 * t2980;
  t2984 = t826 * t265;
  t2986 = t220 * t2984 * t564;
  t2987 = 0.3e1 * t2986;
  t2988 = -t1430 * t2953 * t1440 - 0.2e1 * t220 * t2953 * t1447 - 0.3e1 * t538 * t2953 * t1451 - 0.3e1 * t2981 * t1461 - t2963 - t2967 + t2971 + t2975 - t2977 - t2979 - t2987 - t828 - t830;
  t2989 = t1430 * t2980;
  t2994 = t684 * t2414;
  t2995 = 0.3e1 * t2994;
  t2998 = t538 * t2980;
  t3002 = t538 * t2968 * t1470;
  t3003 = 0.3e1 * t3002;
  t3004 = t2372 * t885;
  t3005 = 0.3e1 * t3004;
  t3006 = t220 * t2964;
  t3007 = t3006 * t1478;
  t3008 = 0.3e1 * t3007;
  t3017 = -t2981 * t1457 - t2989 * t1457 + 0.3e1 * t2998 * t1457 + 0.3e1 * t2998 * t1461 + 0.3e1 * t2989 * t1482 + 0.3e1 * t2989 * t1494 - 0.3e1 * t2989 * t1498 + 0.3e1 * t2998 * t1498 - 0.2e1 * t2989 * t1508 + t2995 + t3003 + t3005 + t3008;
  t3019 = my_piecewise5(t104, 0, t105, 0, t2988 + t3017);
  t3021 = -0.5e1 / 0.27e2 * t2951 + t103 * t3019;
  t3025 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3021);
  tv3sigma39 = t8 * t3025;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3030 = t38 * t43 * t864;
  t3032 = t281 * t792;
  t3033 = t3032 * t383;
  t3034 = t359 * t3033;
  t3035 = t3034 * t1041;
  t3036 = 0.3e1 * t3035;
  t3037 = t3034 * t1024;
  t3038 = 0.3e1 * t3037;
  t3040 = t792 * t68 * t158;
  t3041 = t1072 * t3040;
  t3048 = t1580 * t792;
  t3049 = t1579 * t3048;
  t3054 = t2230 * t1914;
  t3055 = 0.3e1 * t3054;
  t3056 = t151 * t3032;
  t3057 = t3056 * t1570;
  t3058 = 0.3e1 * t3057;
  t3059 = t725 * t2899;
  t3061 = t792 * t366 * t368;
  t3062 = t1094 * t3061;
  t3065 = t392 * t799;
  t3066 = t391 * t3065;
  t3067 = t725 * t3066;
  t3068 = t1124 * t792;
  t3069 = t1109 * t3068;
  t3074 = 0.3e1 * t1899 * t3041 + 0.3e1 * t1899 * t3049 - 0.3e1 * t1910 * t3041 - t1910 * t3049 + 0.3e1 * t2173 * t1922 - t1928 * t3049 - 0.3e1 * t1928 * t3062 - 0.2e1 * t1928 * t3069 + 0.3e1 * t2173 * t1939 - t3036 - t3038 + t3055 + t3058 - t3059 - t3067 - t801;
  t3075 = t714 * t2899;
  t3078 = 0.2e1 * t2890;
  t3079 = 0.2e1 * t2900;
  t3080 = 0.2e1 * t2902;
  t3082 = params->csk_a * t792 * t383;
  t3083 = t159 * t3082;
  t3084 = t1951 * t3083;
  t3085 = 0.3e1 * t3084;
  t3086 = 0.2e1 * t2914;
  t3087 = 0.2e1 * t2924;
  t3088 = 0.2e1 * t2926;
  t3091 = t158 * t792;
  t3092 = t1579 * t3091;
  t3095 = t2209 * t711;
  t3097 = t281 * t799;
  t3099 = t151 * t3097 * t385;
  t3100 = t158 * t799;
  t3101 = t374 * t3100;
  t3102 = t714 * t3101;
  t3103 = 0.3e1 * t1899 * t3062 - 0.2e1 * t1910 * t3092 - 0.3e1 * t2182 * t1963 - t2173 * t1975 + t3075 - t3078 + t3079 - t3080 + t3085 + t3086 - t3087 + t3088 + t3095 - t3099 + t3102 - t855;
  t3105 = my_piecewise5(t58, 0, t61, 0, t3074 + t3103);
  t3107 = 0.5e1 / 0.54e2 * t38 * t48 * t809 - 0.1e2 / 0.81e2 * t3030 + t53 * t3105;
  t3111 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3107);
  tv3sigma2lapl0 = t8 * t3111;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3116 = t38 * t93 * t892;
  t3118 = t297 * t819;
  t3119 = t3118 * t562;
  t3120 = t538 * t3119;
  t3121 = t3120 * t1408;
  t3122 = 0.3e1 * t3121;
  t3124 = params->csk_a * t819 * t562;
  t3125 = t228 * t3124;
  t3126 = t2116 * t3125;
  t3127 = 0.3e1 * t3126;
  t3129 = t819 * t112 * t227;
  t3130 = t1456 * t3129;
  t3132 = t776 * t2973;
  t3134 = t819 * t545 * t547;
  t3135 = t1456 * t3134;
  t3138 = t571 * t826;
  t3139 = t570 * t3138;
  t3140 = t776 * t3139;
  t3141 = t1507 * t819;
  t3142 = t1492 * t3141;
  t3147 = t765 * t2973;
  t3150 = t1460 * t3129;
  t3160 = -t2064 * t3130 - 0.3e1 * t2064 * t3135 - 0.2e1 * t2064 * t3142 + 0.3e1 * t2070 * t3130 + 0.3e1 * t2070 * t3135 + 0.3e1 * t2070 * t3150 - t2077 * t3130 - 0.3e1 * t2077 * t3150 + 0.3e1 * t2319 * t2092 + 0.3e1 * t2319 * t2098 - t3122 + t3127 - t3132 - t3140 + t3147 - t828;
  t3161 = t2355 * t2085;
  t3162 = 0.3e1 * t3161;
  t3163 = t220 * t3118;
  t3164 = t3163 * t1776;
  t3165 = 0.3e1 * t3164;
  t3166 = 0.2e1 * t2962;
  t3167 = 0.2e1 * t2974;
  t3168 = 0.2e1 * t2976;
  t3169 = t3120 * t1425;
  t3170 = 0.3e1 * t3169;
  t3171 = 0.2e1 * t2986;
  t3172 = 0.2e1 * t2994;
  t3173 = 0.2e1 * t3004;
  t3176 = t227 * t819;
  t3177 = t1838 * t3176;
  t3180 = t2344 * t762;
  t3182 = t297 * t826;
  t3184 = t220 * t3182 * t564;
  t3185 = t227 * t826;
  t3186 = t553 * t3185;
  t3187 = t765 * t3186;
  t3188 = -0.2e1 * t2077 * t3177 - t2319 * t2135 - 0.3e1 * t2340 * t2141 + t3162 + t3165 - t3166 + t3167 - t3168 - t3170 - t3171 + t3172 + t3173 + t3180 - t3184 + t3187 - t883;
  t3190 = my_piecewise5(t104, 0, t105, 0, t3160 + t3188);
  t3192 = 0.5e1 / 0.54e2 * t38 * t98 * t836 - 0.1e2 / 0.81e2 * t3116 + t103 * t3190;
  t3196 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3192);
  tv3sigma2lapl11 = t8 * t3196;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3201 = t38 * t43 * t915;
  t3203 = params->csk_a * t248;
  t3205 = t2693 * t3203 * t1023;
  t3206 = 0.3e1 * t3205;
  t3207 = t3203 * t383;
  t3209 = t2700 * t159 * t3207;
  t3210 = 0.3e1 * t3209;
  t3211 = t3203 * t155;
  t3213 = t2693 * t369 * t3211;
  t3214 = 0.3e1 * t3213;
  t3217 = t1580 * t248;
  t3218 = t1579 * t3217;
  t3223 = t1072 * t2485;
  t3226 = t369 * t248;
  t3227 = t1094 * t3226;
  t3230 = t1124 * t248;
  t3234 = t2737 * t1576;
  t3235 = 0.3e1 * t3234;
  t3242 = t2730 * t374 * t856 * t155;
  t3243 = 0.3e1 * t3242;
  t3244 = -0.2e1 * t2709 * t1109 * t3230 + 0.3e1 * t2709 * t1590 + 0.3e1 * t2709 * t1617 - t2704 * t3218 + 0.3e1 * t2706 * t3218 + 0.3e1 * t2706 * t3223 + 0.3e1 * t2706 * t3227 - t2709 * t3218 - 0.3e1 * t2709 * t3227 - t3206 + t3210 - t3214 + t3235 + t3243 - t801 - t909;
  t3247 = 0.2e1 * t3059;
  t3248 = 0.2e1 * t3067;
  t3249 = 0.2e1 * t3075;
  t3250 = 0.2e1 * t3095;
  t3251 = 0.2e1 * t3099;
  t3252 = 0.2e1 * t3102;
  t3259 = -0.2e1 * t2704 * t1579 * t856 - t1586 * t2747 - 0.3e1 * t2706 * t1644 - 0.3e1 * t2704 * t3223 - t2890 + t2900 - t2902 + t2914 - t2924 + t2926 - t3247 - t3248 + t3249 + t3250 - t3251 + t3252;
  t3261 = my_piecewise5(t58, 0, t61, 0, t3244 + t3259);
  t3263 = 0.5e1 / 0.27e2 * t38 * t48 * t864 - 0.5e1 / 0.81e2 * t3201 + t53 * t3261;
  t3267 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3263);
  tv3sigmalapl20 = t8 * t3267;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3272 = t38 * t93 * t938;
  t3274 = params->csk_a * t265;
  t3275 = t3274 * t562;
  t3276 = t228 * t3275;
  t3277 = t2801 * t3276;
  t3278 = 0.3e1 * t3277;
  t3279 = t3274 * t224;
  t3281 = t2796 * t548 * t3279;
  t3282 = 0.3e1 * t3281;
  t3284 = t2796 * t3274 * t1407;
  t3285 = 0.3e1 * t3284;
  t3288 = t2365 * t265;
  t3289 = t1838 * t3288;
  t3294 = t1460 * t2604;
  t3297 = t548 * t265;
  t3298 = t1456 * t3297;
  t3301 = t1507 * t265;
  t3305 = t2838 * t1770;
  t3306 = 0.3e1 * t3305;
  t3313 = t2824 * t553 * t884 * t224;
  t3314 = 0.3e1 * t3313;
  t3315 = -0.2e1 * t2807 * t1492 * t3301 + 0.3e1 * t2807 * t1784 + 0.3e1 * t2807 * t1805 - t2807 * t3289 - 0.3e1 * t2807 * t3298 - t2811 * t3289 + 0.3e1 * t2813 * t3289 + 0.3e1 * t2813 * t3294 + 0.3e1 * t2813 * t3298 + t3278 - t3282 - t3285 + t3306 + t3314 - t828 - t932;
  t3318 = 0.2e1 * t3132;
  t3319 = 0.2e1 * t3140;
  t3320 = 0.2e1 * t3147;
  t3321 = 0.2e1 * t3180;
  t3322 = 0.2e1 * t3184;
  t3323 = 0.2e1 * t3187;
  t3330 = -0.2e1 * t2811 * t1838 * t884 - t1779 * t2861 - 0.3e1 * t2813 * t1835 - 0.3e1 * t2811 * t3294 - t2962 + t2974 - t2976 - t2986 + t2994 + t3004 - t3318 - t3319 + t3320 + t3321 - t3322 + t3323;
  t3332 = my_piecewise5(t104, 0, t105, 0, t3315 + t3330);
  t3334 = 0.5e1 / 0.27e2 * t38 * t98 * t892 - 0.5e1 / 0.81e2 * t3272 + t103 * t3332;
  t3338 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3334);
  tv3sigmalapl28 = t8 * t3338;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3342 = t902 * t281;
  t3351 = t3342 * t155;
  t3353 = t151 * t3351 * t1030;
  t3354 = 0.3e1 * t3353;
  t3355 = t3342 * t383;
  t3356 = t359 * t3355;
  t3357 = t3356 * t1024;
  t3358 = 0.3e1 * t3357;
  t3359 = t3356 * t1041;
  t3360 = 0.3e1 * t3359;
  t3361 = 0.3e1 * t3059;
  t3362 = 0.3e1 * t3067;
  t3363 = 0.3e1 * t3075;
  t3364 = 0.3e1 * t3095;
  t3365 = 0.3e1 * t3099;
  t3366 = -t1050 * t3342 * t1060 - 0.2e1 * t151 * t3342 * t1063 - 0.3e1 * t359 * t3342 * t1067 + t3354 - t3358 - t3360 - t3361 - t3362 + t3363 + t3364 - t3365 - t801 - t909;
  t3367 = 0.3e1 * t3102;
  t3369 = t359 * t3351 * t1090;
  t3370 = 0.3e1 * t3369;
  t3372 = t151 * t3355 * t1085;
  t3373 = 0.3e1 * t3372;
  t3374 = t3342 * t1052;
  t3375 = t151 * t3374;
  t3378 = t1050 * t3374;
  t3385 = t359 * t3374;
  t3396 = -0.3e1 * t3375 * t1073 + 0.3e1 * t3385 * t1073 - t3375 * t1095 - t3378 * t1095 + 0.3e1 * t3385 * t1095 + 0.3e1 * t3378 * t1101 + 0.3e1 * t3378 * t1111 - 0.3e1 * t3378 * t1115 + 0.3e1 * t3385 * t1115 - 0.2e1 * t3378 * t1125 + t3367 + t3370 + t3373;
  t3398 = my_piecewise5(t58, 0, t61, 0, t3366 + t3396);
  t3400 = 0.5e1 / 0.18e2 * t38 * t48 * t915 + t53 * t3398;
  t3404 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3400);
  tv3lapl30 = t8 * t3404;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3408 = t925 * t297;
  t3417 = t3408 * t562;
  t3418 = t538 * t3417;
  t3419 = t3418 * t1408;
  t3420 = 0.3e1 * t3419;
  t3421 = t3418 * t1425;
  t3422 = 0.3e1 * t3421;
  t3423 = t3408 * t224;
  t3425 = t220 * t3423 * t1414;
  t3426 = 0.3e1 * t3425;
  t3427 = 0.3e1 * t3132;
  t3428 = 0.3e1 * t3140;
  t3429 = 0.3e1 * t3147;
  t3430 = 0.3e1 * t3180;
  t3431 = 0.3e1 * t3184;
  t3432 = -t1430 * t3408 * t1440 - 0.2e1 * t220 * t3408 * t1447 - 0.3e1 * t538 * t3408 * t1451 - t3420 - t3422 + t3426 - t3427 - t3428 + t3429 + t3430 - t3431 - t828 - t932;
  t3433 = 0.3e1 * t3187;
  t3434 = t3408 * t1432;
  t3435 = t538 * t3434;
  t3438 = t220 * t3417;
  t3439 = t3438 * t1478;
  t3440 = 0.3e1 * t3439;
  t3442 = t538 * t3423 * t1470;
  t3443 = 0.3e1 * t3442;
  t3444 = t220 * t3434;
  t3447 = t1430 * t3434;
  t3462 = 0.3e1 * t3435 * t1457 - t3444 * t1457 - t3447 * t1457 + 0.3e1 * t3435 * t1461 - 0.3e1 * t3444 * t1461 + 0.3e1 * t3447 * t1482 + 0.3e1 * t3447 * t1494 + 0.3e1 * t3435 * t1498 - 0.3e1 * t3447 * t1498 - 0.2e1 * t3447 * t1508 + t3433 + t3440 + t3443;
  t3464 = my_piecewise5(t104, 0, t105, 0, t3432 + t3462);
  t3466 = 0.5e1 / 0.18e2 * t38 * t98 * t938 + t103 * t3464;
  t3470 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3466);
  tv3lapl33 = t8 * t3470;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t5, t7, t8, t9, t12;
  double t13, t16, t17, t18, t20, t21, t22, t23;
  double t24, t25, t26, t27, t29, t30, t31, t32;
  double t33, t34, t35, t36, t38, t39, t40, t41;
  double t43, t45, t48, t53, t55, t56, t57, t58;
  double t59, t60, t61, t62, t63, t64, t65, t66;
  double t67, t68, t69, t70, t71, t73, t77, t78;
  double t79, t81, t82, t83, t84, t85, t87, t88;
  double t89, t90, t91, t93, t95, t98, t103, t104;
  double t105, t106, t107, t108, t109, t110, t111, t112;
  double t113, t114, t115, t117, t121, tzk0;

  double t122, t123, t124, t126, t129, t130, t134, t135;
  double t138, t141, t143, t149, t151, t152, t153, t155;
  double t156, t158, t159, t160, t162, t164, t169, t170;
  double t172, t175, t176, t180, t183, t185, tvrho0, t189;
  double t192, t193, t198, t200, t203, t204, t210, t212;
  double t218, t220, t221, t222, t224, t225, t227, t228;
  double t229, t231, t233, t238, tvrho1, t241, t244, t247;
  double t248, t251, t253, t257, tvsigma0, tvsigma1, t258, t261;
  double t264, t265, t268, t270, t274, tvsigma2, t280, t281;
  double t284, t286, t290, tvlapl0, t296, t297, t300, t302;
  double t306, tvlapl1, tvtau0, tvtau1;

  double t309, t310, t313, t314, t315, t318, t322, t323;
  double t327, t329, t335, t336, t339, t341, t343, t345;
  double t347, t353, t357, t359, t360, t362, t363, t364;
  double t365, t366, t367, t368, t369, t370, t372, t374;
  double t375, t376, t378, t379, t382, t383, t385, t386;
  double t387, t389, t391, t392, t393, t396, t398, t403;
  double t404, t405, t408, t411, t415, t416, t420, t422;
  double t424, t427, t429, tv2rho20, t432, t436, t440, t441;
  double t445, t447, t455, t456, t460, t464, t465, t469;
  double t471, t478, t481, tv2rho21, t486, t491, t495, t496;
  double t502, t503, t508, t512, t513, t522, t524, t526;
  double t532, t536, t538, t539, t541, t542, t543, t544;
  double t545, t546, t547, t548, t549, t551, t553, t554;
  double t555, t557, t558, t561, t562, t564, t565, t566;
  double t568, t570, t571, t572, t575, t577, t582, tv2rho22;
  double t590, t591, t594, t597, t600, t601, t602, t603;
  double t605, t606, t607, t608, t611, t612, t615, t617;
  double t618, t619, t621, t623, t624, t627, t629, t634;
  double tv2rhosigma0, tv2rhosigma1, t641, t643, tv2rhosigma2, t649, tv2rhosigma3, tv2rhosigma4;
  double t654, t657, t660, t663, t664, t665, t666, t668;
  double t669, t671, t674, t675, t678, t680, t681, t682;
  double t684, t686, t687, t690, t692, t697, tv2rhosigma5, t704;
  double t710, t711, t713, t714, t717, t718, t721, t723;
  double t725, t729, t731, t736, tv2rholapl0, t743, t745, tv2rholapl1;
  double t751, tv2rholapl2, t761, t762, t764, t765, t768, t769;
  double t772, t774, t776, t780, t782, t787, tv2rholapl3, tv2rhotau0;
  double tv2rhotau1, tv2rhotau2, tv2rhotau3, t790, t792, t795, t798, t799;
  double t801, t802, t803, t805, t809, t811, t815, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t817, t819, t822, t825;
  double t826, t828, t829, t830, t832, t836, t838, t842;
  double tv2sigma25, t847, t850, t851, t853, t854, t855, t856;
  double t857, t860, t861, t864, t866, t870, tv2sigmalapl0, tv2sigmalapl1;
  double tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, t875, t878, t879, t881, t882;
  double t883, t884, t885, t888, t889, t892, t894, t898;
  double tv2sigmalapl5, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, tv2sigmatau5, t902;
  double t905, t906, t908, t909, t911, t915, t917, t921;
  double tv2lapl20, tv2lapl21, t925, t928, t929, t931, t932, t934;
  double t938, t940, t944, tv2lapl22, tv2lapltau0, tv2lapltau1, tv2lapltau2, tv2lapltau3;
  double tv2tau20, tv2tau21, tv2tau22;

  double t948, t949, t952, t955, t956, t957, t960, t964;
  double t965, t969, t971, t976, t978, t981, t987, t988;
  double t991, t993, t996, t1000, t1002, t1008, t1014, t1015;
  double t1018, t1019, t1020, t1021, t1023, t1024, t1025, t1027;
  double t1029, t1030, t1031, t1034, t1035, t1041, t1042, t1044;
  double t1045, t1050, t1052, t1054, t1055, t1056, t1058, t1059;
  double t1060, t1063, t1067, t1070, t1071, t1072, t1073, t1076;
  double t1079, t1084, t1085, t1086, t1089, t1090, t1091, t1093;
  double t1094, t1095, t1098, t1100, t1101, t1105, t1109, t1110;
  double t1111, t1114, t1115, t1120, t1124, t1125, t1128, t1130;
  double t1132, t1137, t1139, t1140, t1143, t1146, t1149, t1153;
  double t1154, t1158, t1160, t1162, t1164, t1166, t1169, t1171;
  double tv3rho30, t1174, t1175, t1176, t1179, t1184, t1185, t1187;
  double t1191, t1192, t1196, t1199, t1203, t1205, t1209, t1218;
  double t1219, t1220, t1223, t1228, t1230, t1234, t1235, t1239;
  double t1242, t1243, t1245, t1254, t1256, t1259, tv3rho31, t1262;
  double t1267, t1271, t1275, t1276, t1280, t1282, t1291, t1292;
  double t1297, t1301, t1305, t1306, t1310, t1312, t1319, t1327;
  double t1329, t1330, tv3rho32, t1335, t1342, t1346, t1347, t1354;
  double t1355, t1362, t1366, t1367, t1384, t1386, t1392, t1398;
  double t1399, t1402, t1403, t1404, t1405, t1407, t1408, t1409;
  double t1411, t1414, t1415, t1418, t1419, t1425, t1426, t1430;
  double t1432, t1434, t1435, t1436, t1438, t1439, t1440, t1442;
  double t1443, t1447, t1451, t1454, t1455, t1456, t1457, t1459;
  double t1460, t1461, t1464, t1465, t1469, t1470, t1471, t1477;
  double t1478, t1479, t1481, t1482, t1488, t1492, t1493, t1494;
  double t1497, t1498, t1503, t1507, t1508, t1511, t1513, t1515;
  double t1520, tv3rho33, t1528, t1535, t1537, t1539, t1542, t1545;
  double t1548, t1553, t1554, t1556, t1557, t1560, t1561, t1564;
  double t1567, t1570, t1571, t1573, t1574, t1575, t1576, t1577;
  double t1579, t1580, t1582, t1586, t1588, t1589, t1590, t1594;
  double t1595, t1598, t1599, t1601, t1602, t1605, t1613, t1615;
  double t1616, t1617, t1620, t1621, t1622, t1624, t1625, t1626;
  double t1627, t1628, t1629, t1630, t1632, t1635, t1636, t1639;
  double t1640, t1643, t1644, t1650, t1651, t1656, t1658, t1662;
  double t1663, t1664, t1666, t1668, t1670, t1675, tv3rho2sigma0, tv3rho2sigma1;
  double t1682, t1686, t1688, tv3rho2sigma2, t1694, t1702, tv3rho2sigma3, tv3rho2sigma4;
  double t1708, t1715, t1718, tv3rho2sigma5, t1726, tv3rho2sigma6, tv3rho2sigma7, t1737;
  double t1740, t1743, t1746, t1751, t1752, t1755, t1756, t1758;
  double t1759, t1764, t1767, t1768, t1769, t1770, t1771, t1773;
  double t1776, t1777, t1779, t1780, t1782, t1783, t1784, t1792;
  double t1793, t1796, t1797, t1799, t1800, t1803, t1804, t1805;
  double t1808, t1811, t1815, t1816, t1817, t1819, t1820, t1821;
  double t1823, t1824, t1825, t1827, t1830, t1831, t1834, t1835;
  double t1838, t1839, t1840, t1845, t1849, t1850, t1851, t1856;
  double t1857, t1862, t1864, t1866, t1871, tv3rho2sigma8, t1878, t1885;
  double t1887, t1898, t1899, t1902, t1903, t1910, t1913, t1914;
  double t1915, t1917, t1919, t1921, t1922, t1928, t1936, t1937;
  double t1938, t1939, t1942, t1945, t1946, t1947, t1950, t1951;
  double t1952, t1954, t1957, t1958, t1963, t1968, t1971, t1972;
  double t1975, t1977, t1979, t1983, t1985, t1987, t1992, tv3rho2lapl0;
  double t1999, t2003, t2005, tv3rho2lapl1, t2011, t2019, tv3rho2lapl2, t2025;
  double t2032, t2035, tv3rho2lapl3, t2043, tv3rho2lapl4, t2063, t2064, t2070;
  double t2073, t2074, t2077, t2080, t2082, t2084, t2085, t2086;
  double t2091, t2092, t2096, t2097, t2098, t2101, t2105, t2111;
  double t2112, t2115, t2116, t2117, t2119, t2122, t2123, t2126;
  double t2128, t2131, t2132, t2135, t2137, t2139, t2141, t2148;
  double t2150, t2152, t2157, tv3rho2lapl5, tv3rho2tau0, tv3rho2tau1, tv3rho2tau2, tv3rho2tau3;
  double tv3rho2tau4, tv3rho2tau5, t2164, t2166, t2169, t2172, t2173, t2174;
  double t2175, t2178, t2179, t2182, t2183, t2184, t2187, t2188;
  double t2191, t2194, t2196, t2202, t2203, t2206, t2207, t2208;
  double t2209, t2210, t2213, t2214, t2215, t2217, t2218, t2224;
  double t2225, t2226, t2229, t2230, t2231, t2232, t2233, t2234;
  double t2237, t2238, t2239, t2240, t2243, t2244, t2245, t2246;
  double t2248, t2249, t2250, t2252, t2253, t2254, t2255, t2257;
  double t2258, t2259, t2264, t2265, t2266, t2267, t2269, t2270;
  double t2271, t2272, t2274, t2275, t2278, t2281, t2282, t2284;
  double t2286, t2291, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t2298;
  double t2300, tv3rhosigma25, t2306, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210;
  double t2312, t2315, t2318, t2319, t2320, t2321, t2324, t2325;
  double t2328, t2329, t2332, t2333, t2336, t2337, t2340, t2343;
  double t2344, t2345, t2346, t2347, t2349, t2350, t2354, t2355;
  double t2356, t2357, t2358, t2359, t2361, t2364, t2365, t2367;
  double t2372, t2373, t2375, t2376, t2377, t2378, t2380, t2381;
  double t2382, t2383, t2386, t2387, t2388, t2389, t2391, t2393;
  double t2394, t2399, t2400, t2403, t2408, t2409, t2410, t2411;
  double t2413, t2414, t2415, t2418, t2419, t2420, t2421, t2422;
  double t2424, t2425, t2426, t2429, t2431, t2433, t2438, tv3rhosigma211;
  double t2445, t2451, t2454, t2457, t2458, t2459, t2460, t2461;
  double t2464, t2465, t2466, t2467, t2468, t2471, t2472, t2473;
  double t2475, t2478, t2479, t2483, t2485, t2486, t2493, t2496;
  double t2497, t2498, t2499, t2501, t2503, t2504, t2506, t2507;
  double t2508, t2509, t2511, t2512, t2513, t2515, t2520, t2521;
  double t2525, t2526, t2529, t2530, t2536, t2538, t2541, t2543;
  double t2545, t2547, t2552, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4;
  double t2559, t2561, tv3rhosigmalapl5, t2567, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9;
  double tv3rhosigmalapl10, t2577, t2580, t2583, t2584, t2585, t2586, t2587;
  double t2590, t2593, t2594, t2595, t2596, t2597, t2599, t2602;
  double t2604, t2605, t2610, t2613, t2616, t2617, t2618, t2622;
  double t2624, t2625, t2627, t2628, t2629, t2630, t2633, t2634;
  double t2636, t2637, t2638, t2639, t2641, t2642, t2645, t2652;
  double t2653, t2655, t2656, t2665, t2668, t2669, t2671, t2673;
  double t2678, tv3rhosigmalapl11, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3, tv3rhosigmatau4, tv3rhosigmatau5;
  double tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8, tv3rhosigmatau9, tv3rhosigmatau10, tv3rhosigmatau11, t2685, t2691;
  double t2693, t2694, t2696, t2698, t2700, t2701, t2703, t2704;
  double t2706, t2709, t2715, t2723, t2724, t2725, t2730, t2731;
  double t2737, t2738, t2746, t2747, t2749, t2750, t2751, t2753;
  double t2754, t2760, t2762, t2764, t2769, tv3rholapl20, tv3rholapl21, t2776;
  double t2778, tv3rholapl22, t2784, tv3rholapl23, tv3rholapl24, t2794, t2796, t2797;
  double t2799, t2801, t2802, t2804, t2806, t2807, t2811, t2813;
  double t2824, t2825, t2827, t2828, t2829, t2834, t2838, t2839;
  double t2849, t2850, t2851, t2853, t2854, t2860, t2861, t2863;
  double t2865, t2867, t2872, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3;
  double tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, tv3rhotau20, tv3rhotau21, tv3rhotau22, tv3rhotau23;
  double tv3rhotau24, tv3rhotau25, t2875, t2877, t2886, t2887, t2888, t2889;
  double t2890, t2891, t2892, t2893, t2894, t2896, t2897, t2898;
  double t2899, t2900, t2901, t2902, t2903, t2904, t2905, t2910;
  double t2912, t2913, t2914, t2915, t2916, t2917, t2918, t2919;
  double t2922, t2924, t2925, t2926, t2927, t2932, t2941, t2943;
  double t2945, t2949, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35;
  double tv3sigma36, tv3sigma37, tv3sigma38, t2951, t2953, t2962, t2963, t2964;
  double t2965, t2966, t2967, t2968, t2970, t2971, t2972, t2973;
  double t2974, t2975, t2976, t2977, t2978, t2979, t2980, t2981;
  double t2984, t2986, t2987, t2988, t2989, t2994, t2995, t2998;
  double t3002, t3003, t3004, t3005, t3006, t3007, t3008, t3017;
  double t3019, t3021, t3025, tv3sigma39, t3030, t3032, t3033, t3034;
  double t3035, t3036, t3037, t3038, t3040, t3041, t3048, t3049;
  double t3054, t3055, t3056, t3057, t3058, t3059, t3061, t3062;
  double t3065, t3066, t3067, t3068, t3069, t3074, t3075, t3078;
  double t3079, t3080, t3082, t3083, t3084, t3085, t3086, t3087;
  double t3088, t3091, t3092, t3095, t3097, t3099, t3100, t3101;
  double t3102, t3103, t3105, t3107, t3111, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double t3116, t3118, t3119, t3120, t3121, t3122, t3124, t3125;
  double t3126, t3127, t3129, t3130, t3132, t3134, t3135, t3138;
  double t3139, t3140, t3141, t3142, t3147, t3150, t3160, t3161;
  double t3162, t3163, t3164, t3165, t3166, t3167, t3168, t3169;
  double t3170, t3171, t3172, t3173, t3176, t3177, t3180, t3182;
  double t3184, t3185, t3186, t3187, t3188, t3190, t3192, t3196;
  double tv3sigma2lapl11, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6;
  double tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, tv3sigma2tau11, t3201, t3203, t3205;
  double t3206, t3207, t3209, t3210, t3211, t3213, t3214, t3217;
  double t3218, t3223, t3226, t3227, t3230, t3234, t3235, t3242;
  double t3243, t3244, t3247, t3248, t3249, t3250, t3251, t3252;
  double t3259, t3261, t3263, t3267, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, t3272, t3274, t3275, t3276;
  double t3277, t3278, t3279, t3281, t3282, t3284, t3285, t3288;
  double t3289, t3294, t3297, t3298, t3301, t3305, t3306, t3313;
  double t3314, t3315, t3318, t3319, t3320, t3321, t3322, t3323;
  double t3330, t3332, t3334, t3338, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2;
  double tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10;
  double tv3sigmalapltau11, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24, tv3sigmatau25, tv3sigmatau26;
  double tv3sigmatau27, tv3sigmatau28, t3342, t3351, t3353, t3354, t3355, t3356;
  double t3357, t3358, t3359, t3360, t3361, t3362, t3363, t3364;
  double t3365, t3366, t3367, t3369, t3370, t3372, t3373, t3374;
  double t3375, t3378, t3385, t3396, t3398, t3400, t3404, tv3lapl30;
  double tv3lapl31, tv3lapl32, t3408, t3417, t3418, t3419, t3420, t3421;
  double t3422, t3423, t3425, t3426, t3427, t3428, t3429, t3430;
  double t3431, t3432, t3433, t3434, t3435, t3438, t3439, t3440;
  double t3442, t3443, t3444, t3447, t3462, t3464, t3466, t3470;
  double tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20;
  double tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, tv3tau30, tv3tau31, tv3tau32;
  double tv3tau33;

  double t3475, t3479, t3483, t3486, t3490, t3495, t3498, t3501;
  double t3507, t3513, t3524, t3528, t3531, t3533, t3534, t3541;
  double t3543, t3546, t3547, t3548, t3550, t3551, t3555, t3556;
  double t3560, t3561, t3566, t3569, t3572, t3576, t3579, t3581;
  double t3584, t3586, t3592, t3593, t3596, t3598, t3600, t3603;
  double t3606, t3607, t3612, t3617, t3619, t3627, t3630, t3632;
  double t3637, t3641, t3645, t3650, t3651, t3652, t3653, t3656;
  double t3657, t3658, t3659, t3660, t3663, t3664, t3668, t3671;
  double t3672, t3675, t3677, t3679, t3680, t3681, t3682, t3683;
  double t3685, t3688, t3694, t3695, t3696, t3697, t3698, t3699;
  double t3702, t3705, t3706, t3707, t3710, t3711, t3714, t3715;
  double t3720, t3724, t3728, t3731, t3734, t3737, t3755, t3756;
  double t3759, t3761, t3764, t3768, t3773, t3778, t3779, t3782;
  double t3783, t3784, t3791, t3792, t3797, t3803, t3812, t3813;
  double t3822, t3826, t3832, t3834, t3835, t3841, t3847, t3848;
  double t3851, t3855, t3864, t3870, t3873, t3875, t3876, t3877;
  double t3879, t3880, t3886, t3891, t3894, t3898, t3905, t3909;
  double t3913, t3918, t3920, tv4rho40, t3927, t3931, t3932, t3935;
  double t3956, t3957, t3959, t3963, t3972, t3978, t3979, t3981;
  double t3992, t3993, t4010, t4012, t4016, t4023, t4027, t4028;
  double t4031, t4040, t4043, t4044, t4046, t4048, t4049, tv4rho41;
  double t4058, t4062, t4077, t4090, t4094, t4103, t4114, t4115;
  double t4124, t4137, t4141, t4148, t4152, t4161, t4164, t4175;
  double t4178, t4180, t4181, tv4rho42, t4202, t4206, t4213, t4224;
  double t4225, t4242, t4246, t4253, t4261, t4270, t4280, t4282;
  double t4283, tv4rho43, t4288, t4293, t4300, t4304, t4313, t4323;
  double t4328, t4335, t4339, t4357, t4363, t4374, t4375, t4376;
  double t4378, t4381, t4384, t4385, t4386, t4391, t4393, t4396;
  double t4401, t4404, t4405, t4409, t4412, t4415, t4416, t4425;
  double t4428, t4431, t4434, t4437, t4440, t4443, t4446, t4448;
  double t4452, t4456, t4459, t4461, t4462, t4465, t4467, t4473;
  double t4477, t4478, t4486, t4488, t4491, t4492, t4493, t4496;
  double t4497, t4498, t4501, t4502, t4503, t4504, t4505, t4506;
  double t4507, t4515, t4518, t4521, t4522, t4523, t4526, t4527;
  double t4530, t4531, t4534, t4537, t4539, t4540, t4546, t4552;
  double t4553, t4558, t4570, t4581, t4592, t4595, t4598, t4600;
  double t4601, t4602, t4608, t4613, t4614, t4617, t4618, t4622;
  double t4626, t4627, t4628, t4629, t4630, t4632, t4633, t4636;
  double t4640, t4645, t4647, t4650, t4651, t4656, t4657, t4667;
  double t4670, t4674, t4680, t4681, tv4rho44, t4689, t4695, t4698;
  double t4705, t4707, t4710, t4712, t4736, t4737, t4739, t4742;
  double t4743, t4745, t4748, t4749, t4750, t4753, t4756, t4759;
  double t4761, t4766, t4769, t4770, t4773, t4774, t4779, t4781;
  double t4787, t4792, t4796, t4801, t4802, t4803, t4806, t4807;
  double t4812, t4815, t4819, t4823, t4831, t4835, t4836, t4842;
  double t4845, t4846, t4851, t4856, t4859, t4862, t4864, t4867;
  double t4871, t4876, t4880, t4883, t4887, t4888, t4891, t4893;
  double t4898, t4913, t4920, t4929, t4932, t4933, t4934, t4935;
  double t4938, t4939, t4940, t4943, t4945, t4946, t4949, t4951;
  double t4956, t4960, t4964, t4965, t4968, t4969, t4970, t4975;
  double t4980, t4981, t4983, t4984, t4991, t5001, t5003, t5004;
  double t5009, t5013, t5014, t5017, t5020, t5022, t5030, t5031;
  double t5052, t5059, t5062, t5067, t5079, t5082, t5083, t5087;
  double t5093, t5094, t5099, t5103, t5110, tv4rho3sigma0, tv4rho3sigma1, t5117;
  double t5120, t5124, t5126, tv4rho3sigma2, t5128, t5134, t5139, t5143;
  double t5152, t5153, tv4rho3sigma3, tv4rho3sigma4, t5155, t5161, t5163, t5172;
  double t5174, t5177, tv4rho3sigma5, t5183, t5192, tv4rho3sigma6, tv4rho3sigma7, t5198;
  double t5205, t5213, t5215, t5216, tv4rho3sigma8, t5225, tv4rho3sigma9, tv4rho3sigma10;
  double t5242, t5266, t5267, t5269, t5270, t5273, t5276, t5277;
  double t5280, t5283, t5286, t5289, t5292, t5296, t5299, t5300;
  double t5307, t5308, t5309, t5310, t5313, t5318, t5319, t5322;
  double t5323, t5328, t5333, t5338, t5343, t5344, t5345, t5348;
  double t5350, t5355, t5360, t5363, t5368, t5373, t5376, t5380;
  double t5384, t5387, t5389, t5392, t5393, t5398, t5407, t5412;
  double t5417, t5422, t5436, t5442, t5451, t5454, t5455, t5456;
  double t5457, t5460, t5461, t5462, t5465, t5470, t5472, t5473;
  double t5476, t5477, t5478, t5483, t5486, t5487, t5489, t5490;
  double t5493, t5496, t5499, t5500, t5508, t5509, t5513, t5515;
  double t5516, t5521, t5527, t5531, t5534, t5537, t5541, t5546;
  double t5551, t5553, t5563, t5583, t5585, t5589, t5595, t5601;
  double t5604, t5610, t5615, t5622, t5623, t5628, t5632, t5639;
  double tv4rho3sigma11, t5646, t5652, t5655, t5662, t5664, t5667, t5687;
  double t5688, t5689, t5694, t5695, t5698, t5708, t5709, t5711;
  double t5716, t5717, t5721, t5722, t5725, t5731, t5734, t5735;
  double t5740, t5751, t5761, t5762, t5765, t5768, t5771, t5774;
  double t5775, t5778, t5788, t5790, t5793, t5794, t5798, t5803;
  double t5810, t5814, t5817, t5824, t5829, t5832, t5839, t5847;
  double t5862, t5865, t5867, t5876, t5878, t5882, t5892, t5896;
  double t5899, t5907, t5914, t5926, t5929, t5938, t5941, t5949;
  double t5952, t5955, t5968, t5969, t5974, t5978, t5985, tv4rho3lapl0;
  double t5992, t5995, t5999, t6001, tv4rho3lapl1, t6003, t6009, t6014;
  double t6018, t6027, t6028, tv4rho3lapl2, t6030, t6036, t6038, t6047;
  double t6049, t6052, tv4rho3lapl3, t6058, t6067, tv4rho3lapl4, t6073, t6080;
  double t6088, t6090, t6091, tv4rho3lapl5, t6100, tv4rho3lapl6, t6133, t6136;
  double t6137, t6140, t6141, t6146, t6151, t6154, t6155, t6158;
  double t6159, t6161, t6166, t6167, t6170, t6174, t6177, t6181;
  double t6184, t6187, t6193, t6202, t6206, t6210, t6217, t6219;
  double t6222, t6233, t6240, t6266, t6269, t6275, t6279, t6282;
  double t6286, t6287, t6290, t6291, t6294, t6295, t6300, t6309;
  double t6314, t6331, t6332, t6339, t6342, t6345, t6349, t6350;
  double t6353, t6358, t6367, t6372, t6375, t6380, t6384, t6387;
  double t6390, t6410, t6411, t6416, t6420, t6427, tv4rho3lapl7, tv4rho3tau0;
  double tv4rho3tau1, tv4rho3tau2, tv4rho3tau3, tv4rho3tau4, tv4rho3tau5, tv4rho3tau6, tv4rho3tau7, t6434;
  double t6441, t6443, t6457, t6458, t6459, t6465, t6466, t6467;
  double t6470, t6472, t6475, t6476, t6478, t6479, t6481, t6482;
  double t6483, t6484, t6487, t6490, t6491, t6494, t6497, t6502;
  double t6503, t6504, t6509, t6511, t6513, t6515, t6522, t6524;
  double t6532, t6536, t6539, t6541, t6544, t6550, t6554, t6559;
  double t6561, t6562, t6564, t6565, t6567, t6570, t6571, t6572;
  double t6573, t6582, t6586, t6599, t6600, t6601, t6606, t6608;
  double t6610, t6619, t6624, t6626, t6630, t6634, t6638, t6640;
  double t6641, t6644, t6646, t6649, t6653, t6660, t6665, t6666;
  double t6669, t6670, t6671, t6672, t6675, t6682, t6687, t6690;
  double t6691, t6693, t6694, t6695, t6696, t6699, t6705, t6706;
  double t6707, t6714, t6717, t6718, t6721, t6725, t6726, t6731;
  double t6736, t6739, t6743, t6744, t6748, t6758, t6762, t6763;
  double t6767, t6772, t6776, t6779, t6780, t6781, t6790, t6795;
  double t6798, t6804, t6806, t6807, t6808, t6814, t6815, t6816;
  double t6819, t6820, t6831, t6837, t6838, t6839, t6840, t6844;
  double t6851, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t6858, t6862;
  double t6864, tv4rho2sigma25, t6870, t6878, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29;
  double tv4rho2sigma210, t6884, t6891, t6894, tv4rho2sigma211, t6902, tv4rho2sigma212, tv4rho2sigma213;
  double tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t6925, t6928, t6932, t6933, t6934;
  double t6935, t6936, t6939, t6944, t6947, t6948, t6952, t6955;
  double t6958, t6961, t6963, t6965, t6968, t6969, t6972, t6986;
  double t6987, t6988, t6991, t6997, t7000, t7001, t7013, t7017;
  double t7022, t7023, t7025, t7028, t7030, t7033, t7035, t7038;
  double t7039, t7041, t7042, t7045, t7047, t7048, t7050, t7051;
  double t7053, t7059, t7062, t7065, t7067, t7074, t7076, t7077;
  double t7078, t7082, t7088, t7090, t7091, t7094, t7095, t7097;
  double t7100, t7102, t7104, t7109, t7110, t7112, t7114, t7116;
  double t7119, t7125, t7129, t7132, t7135, t7141, t7151, t7153;
  double t7156, t7157, t7162, t7170, t7174, t7181, t7183, t7187;
  double t7196, t7204, t7205, t7206, t7209, t7212, t7221, t7224;
  double t7230, t7232, t7237, t7240, t7241, t7244, t7245, t7249;
  double t7252, t7253, t7255, t7258, t7264, t7270, t7271, t7272;
  double t7275, t7285, t7287, t7290, t7296, t7297, t7305, t7306;
  double t7307, t7308, t7310, t7314, t7321, tv4rho2sigma217, t7328, t7335;
  double t7337, t7361, t7362, t7363, t7366, t7369, t7370, t7373;
  double t7374, t7377, t7378, t7379, t7380, t7384, t7387, t7396;
  double t7397, t7404, t7409, t7415, t7419, t7420, t7423, t7434;
  double t7437, t7445, t7446, t7453, t7454, t7457, t7461, t7462;
  double t7463, t7468, t7473, t7494, t7503, t7506, t7515, t7517;
  double t7523, t7524, t7527, t7536, t7540, t7560, t7567, t7573;
  double t7588, t7599, t7600, t7622, t7624, t7644, t7645, t7648;
  double t7651, t7663, t7666, t7668, t7669, t7672, t7685, t7689;
  double t7692, t7696, t7710, t7714, t7721, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2;
  double tv4rho2sigmalapl3, tv4rho2sigmalapl4, t7728, t7732, t7734, tv4rho2sigmalapl5, t7740, t7748;
  double tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, t7754, t7761, t7764;
  double tv4rho2sigmalapl11, t7772, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, t7812;
  double t7816, t7817, t7818, t7823, t7824, t7827, t7830, t7834;
  double t7835, t7836, t7840, t7848, t7852, t7857, t7864, t7871;
  double t7872, t7873, t7874, t7877, t7878, t7879, t7880, t7888;
  double t7892, t7895, t7903, t7906, t7907, t7908, t7911, t7914;
  double t7918, t7922, t7933, t7934, t7941, t7942, t7945, t7952;
  double t7957, t7965, t7966, t7971, t7972, t7975, t7996, t7999;
  double t8003, t8006, t8031, t8032, t8035, t8040, t8045, t8053;
  double t8056, t8058, t8076, t8079, t8081, t8094, t8117, t8127;
  double t8142, t8156, t8160, t8167, tv4rho2sigmalapl17, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2;
  double tv4rho2sigmatau3, tv4rho2sigmatau4, tv4rho2sigmatau5, tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10;
  double tv4rho2sigmatau11, tv4rho2sigmatau12, tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, tv4rho2sigmatau17, t8174;
  double t8181, t8183, t8196, t8206, t8211, t8215, t8216, t8228;
  double t8231, t8232, t8235, t8240, t8245, t8246, t8248, t8251;
  double t8258, t8261, t8272, t8277, t8282, t8289, t8294, t8295;
  double t8307, t8320, t8324, t8327, t8335, t8337, t8340, t8353;
  double t8357, t8366, t8384, t8391, t8392, t8397, t8409, t8412;
  double t8414, t8415, t8416, t8425, t8438, t8440, t8449, t8452;
  double t8455, t8466, t8470, t8477, tv4rho2lapl20, tv4rho2lapl21, t8484, t8488;
  double t8490, tv4rho2lapl22, t8496, t8504, tv4rho2lapl23, tv4rho2lapl24, t8510, t8517;
  double t8520, tv4rho2lapl25, t8528, tv4rho2lapl26, tv4rho2lapl27, t8553, t8560, t8566;
  double t8567, t8573, t8574, t8583, t8584, t8585, t8596, t8597;
  double t8600, t8601, t8602, t8609, t8612, t8615, t8623, t8632;
  double t8637, t8645, t8647, t8650, t8651, t8658, t8666, t8669;
  double t8674, t8690, t8693, t8699, t8703, t8711, t8720, t8739;
  double t8747, t8748, t8753, t8759, t8766, t8768, t8769, t8770;
  double t8780, t8785, t8790, t8793, t8803, t8805, t8809, t8820;
  double t8824, t8831, tv4rho2lapl28, tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4;
  double tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, tv4rho2tau20;
  double tv4rho2tau21, tv4rho2tau22, tv4rho2tau23, tv4rho2tau24, tv4rho2tau25, tv4rho2tau26, tv4rho2tau27, tv4rho2tau28;
  double t8838, t8846, t8848, t8852, t8854, t8855, t8856, t8857;
  double t8859, t8860, t8862, t8863, t8869, t8872, t8873, t8874;
  double t8875, t8876, t8879, t8880, t8882, t8883, t8885, t8887;
  double t8888, t8889, t8891, t8892, t8905, t8909, t8913, t8915;
  double t8918, t8920, t8922, t8923, t8924, t8927, t8929, t8932;
  double t8933, t8934, t8936, t8938, t8941, t8942, t8944, t8946;
  double t8947, t8948, t8952, t8954, t8958, t8961, t8962, t8965;
  double t8968, t8969, t8970, t8971, t8974, t8975, t8978, t8979;
  double t8982, t8985, t8986, t8989, t8994, t8997, t9000, t9003;
  double t9004, t9007, t9014, t9021, t9026, t9029, t9033, t9035;
  double t9038, t9042, t9045, t9051, t9054, t9055, t9067, t9074;
  double t9075, t9076, t9081, t9084, t9093, t9101, t9108, t9110;
  double t9131, t9133, t9138, t9140, t9142, t9143, t9144, t9148;
  double t9155, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36;
  double tv4rhosigma37, tv4rhosigma38, t9162, t9164, tv4rhosigma39, t9170, tv4rhosigma310, tv4rhosigma311;
  double tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t9182;
  double t9183, t9184, t9185, t9189, t9190, t9192, t9198, t9201;
  double t9202, t9205, t9207, t9209, t9210, t9212, t9214, t9217;
  double t9220, t9221, t9224, t9225, t9226, t9227, t9229, t9230;
  double t9231, t9235, t9238, t9242, t9245, t9248, t9249, t9251;
  double t9254, t9255, t9257, t9259, t9261, t9268, t9270, t9272;
  double t9273, t9275, t9277, t9281, t9282, t9283, t9289, t9292;
  double t9293, t9300, t9303, t9304, t9305, t9306, t9309, t9311;
  double t9319, t9324, t9326, t9329, t9335, t9337, t9342, t9345;
  double t9346, t9349, t9350, t9355, t9357, t9359, t9362, t9365;
  double t9370, t9372, t9375, t9379, t9383, t9386, t9388, t9399;
  double t9402, t9407, t9408, t9410, t9415, t9419, t9438, t9443;
  double t9457, t9459, t9467, t9469, t9472, t9473, t9474, t9478;
  double t9485, tv4rhosigma319, t9492, t9504, t9505, t9509, t9511, t9512;
  double t9521, t9525, t9532, t9533, t9536, t9539, t9541, t9545;
  double t9546, t9550, t9551, t9554, t9556, t9564, t9570, t9571;
  double t9572, t9574, t9580, t9582, t9585, t9587, t9590, t9595;
  double t9596, t9602, t9611, t9615, t9624, t9632, t9641, t9650;
  double t9654, t9656, t9657, t9660, t9664, t9678, t9685, t9687;
  double t9688, t9691, t9694, t9706, t9711, t9716, t9735, t9738;
  double t9741, t9744, t9752, t9753, t9764, t9774, t9783, t9795;
  double t9815, t9819, t9820, t9824, t9827, t9832, t9839, tv4rhosigma2lapl0;
  double tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3, tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8;
  double tv4rhosigma2lapl9, tv4rhosigma2lapl10, t9846, t9848, tv4rhosigma2lapl11, t9854, tv4rhosigma2lapl12, tv4rhosigma2lapl13;
  double tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19, tv4rhosigma2lapl20, tv4rhosigma2lapl21;
  double tv4rhosigma2lapl22, t9870, t9875, t9876, t9879, t9880, t9885, t9895;
  double t9902, t9903, t9908, t9909, t9912, t9914, t9921, t9922;
  double t9923, t9925, t9927, t9931, t9936, t9938, t9942, t9949;
  double t9950, t9960, t9963, t9969, t9972, t9974, t9981, t9985;
  double t9987, t9989, t9990, t9995, t10010, t10014, t10018, t10021;
  double t10029, t10053, t10071, t10080, t10083, t10087, t10088, t10094;
  double t10099, t10100, t10104, t10127, t10139, t10140, t10141, t10145;
  double t10146, t10152, t10155, t10165, t10171, t10176, t10177, t10178;
  double t10183, t10187, t10188, t10196, t10199, t10204, t10211, tv4rhosigma2lapl23;
  double tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6, tv4rhosigma2tau7;
  double tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, tv4rhosigma2tau11, tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15;
  double tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19, tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, tv4rhosigma2tau23;
  double t10218, t10230, t10231, t10232, t10234, t10237, t10240, t10241;
  double t10244, t10245, t10248, t10251, t10256, t10269, t10290, t10318;
  double t10319, t10331, t10336, t10363, t10367, t10368, t10373, t10379;
  double t10383, t10402, t10415, t10416, t10418, t10421, t10455, t10456;
  double t10460, t10475, t10494, t10514, t10519, t10526, tv4rhosigmalapl20, tv4rhosigmalapl21;
  double tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27, t10533, t10535;
  double tv4rhosigmalapl28, t10541, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214;
  double tv4rhosigmalapl215, tv4rhosigmalapl216, t10572, t10599, t10626, t10643, t10646, t10649;
  double t10653, t10654, t10671, t10681, t10687, t10701, t10702, t10703;
  double t10706, t10709, t10712, t10715, t10719, t10722, t10723, t10740;
  double t10746, t10749, t10757, t10759, t10767, t10775, t10780, t10786;
  double t10808, t10815, t10838, t10843, t10850, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1;
  double tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9;
  double tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17;
  double tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, tv4rhosigmatau20, tv4rhosigmatau21;
  double tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, tv4rhosigmatau28, tv4rhosigmatau29;
  double tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, tv4rhosigmatau217;
  double t10857, t10871, t10879, t10880, t10883, t10890, t10893, t10897;
  double t10916, t10917, t10925, t10927, t10935, t10938, t10940, t10943;
  double t10950, t10952, t10961, t10964, t10965, t10970, t10973, t10983;
  double t10991, t11008, t11011, t11017, t11022, t11030, t11036, t11037;
  double t11040, t11042, t11045, t11050, t11051, t11059, t11069, t11075;
  double t11078, t11081, t11082, t11086, t11093, tv4rholapl30, tv4rholapl31, tv4rholapl32;
  double t11100, t11102, tv4rholapl33, t11108, tv4rholapl34, tv4rholapl35, tv4rholapl36, t11118;
  double t11119, t11122, t11123, t11133, t11139, t11140, t11142, t11145;
  double t11148, t11160, t11173, t11175, t11178, t11183, t11185, t11189;
  double t11195, t11204, t11211, t11213, t11221, t11224, t11225, t11228;
  double t11244, t11247, t11257, t11269, t11272, t11277, t11285, t11290;
  double t11298, t11305, t11312, t11313, t11316, t11319, t11322, t11336;
  double t11337, t11338, t11342, t11349, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2;
  double tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10;
  double tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26;
  double tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, tv4rhotau30, tv4rhotau31, tv4rhotau32;
  double tv4rhotau33, tv4rhotau34, tv4rhotau35, tv4rhotau36, tv4rhotau37, t11357, t11360, t11361;
  double t11363, t11364, t11366, t11367, t11369, t11371, t11372, t11373;
  double t11376, t11379, t11380, t11384, t11385, t11391, t11392, t11394;
  double t11397, t11398, t11400, t11402, t11407, t11419, t11421, t11423;
  double t11425, t11427, t11431, t11433, t11434, t11436, t11443, t11446;
  double t11459, t11460, t11461, t11463, t11466, t11468, t11471, t11482;
  double t11492, t11497, t11498, t11520, t11522, t11524, t11529, t11537;
  double t11539, t11542, t11544, t11559, t11563, t11569, tv4sigma40, tv4sigma41;
  double tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49;
  double tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t11573, t11575, t11576, t11578;
  double t11579, t11580, t11581, t11582, t11583, t11585, t11586, t11589;
  double t11591, t11592, t11593, t11594, t11598, t11599, t11601, t11604;
  double t11605, t11608, t11610, t11618, t11619, t11621, t11627, t11629;
  double t11633, t11639, t11640, t11642, t11645, t11648, t11667, t11673;
  double t11674, t11675, t11677, t11679, t11680, t11685, t11694, t11709;
  double t11710, t11714, t11723, t11730, t11732, t11737, t11745, t11747;
  double t11750, t11752, t11767, t11771, t11777, tv4sigma414, t11786, t11787;
  double t11788, t11789, t11790, t11791, t11792, t11796, t11799, t11800;
  double t11801, t11802, t11803, t11804, t11805, t11806, t11807, t11808;
  double t11809, t11810, t11811, t11814, t11817, t11828, t11829, t11830;
  double t11831, t11834, t11835, t11837, t11838, t11842, t11843, t11844;
  double t11850, t11854, t11860, t11872, t11879, t11885, t11897, t11905;
  double t11908, t11914, t11916, t11917, t11919, t11920, t11921, t11922;
  double t11923, t11927, t11929, t11934, t11963, t11971, t11972, t11973;
  double t11974, t11981, t11982, t11987, t11989, t11993, t11999, tv4sigma3lapl0;
  double tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8;
  double tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16;
  double tv4sigma3lapl17, tv4sigma3lapl18, t12007, t12008, t12009, t12010, t12011, t12012;
  double t12013, t12014, t12017, t12018, t12019, t12020, t12024, t12027;
  double t12028, t12029, t12030, t12031, t12032, t12033, t12034, t12035;
  double t12045, t12051, t12052, t12053, t12054, t12057, t12058, t12062;
  double t12063, t12064, t12066, t12067, t12073, t12085, t12091, t12094;
  double t12104, t12105, t12106, t12107, t12108, t12109, t12111, t12112;
  double t12115, t12123, t12128, t12137, t12150, t12151, t12152, t12153;
  double t12154, t12159, t12160, t12168, t12173, t12181, t12190, t12208;
  double t12212, t12216, t12222, tv4sigma3lapl19, tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3;
  double tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11;
  double tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, tv4sigma3tau19;
  double t12230, t12235, t12239, t12240, t12249, t12258, t12263, t12279;
  double t12291, t12298, t12302, t12305, t12307, t12316, t12320, t12325;
  double t12328, t12332, t12342, t12352, t12356, t12360, t12362, t12363;
  double t12367, t12375, t12383, t12401, t12411, t12413, t12414, t12416;
  double t12417, t12426, t12428, t12431, t12435, t12441, tv4sigma2lapl20, tv4sigma2lapl21;
  double tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24, tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29;
  double tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212, tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, t12463;
  double t12475, t12479, t12483, t12485, t12490, t12502, t12503, t12507;
  double t12512, t12516, t12519, t12520, t12526, t12536, t12540, t12542;
  double t12545, t12549, t12555, t12563, t12573, t12583, t12595, t12597;
  double t12598, t12600, t12601, t12603, t12611, t12616, t12621, t12626;
  double t12629, t12631, t12639, t12646, t12651, t12654, t12658, t12664;
  double tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2, tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6;
  double tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10, tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14;
  double tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18, tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22;
  double tv4sigma2lapltau23, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26;
  double tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214;
  double tv4sigma2tau215, tv4sigma2tau216, tv4sigma2tau217, t12673, t12678, t12691, t12704, t12710;
  double t12719, t12720, t12728, t12749, t12754, t12778, t12785, t12792;
  double t12793, t12796, t12799, t12815, t12817, t12821, t12827, tv4sigmalapl30;
  double tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38;
  double tv4sigmalapl39, tv4sigmalapl310, t12834, t12840, t12843, t12847, t12862, t12864;
  double t12869, t12883, t12901, t12918, t12940, t12951, t12956, t12957;
  double t12962, t12977, t12979, t12983, t12989, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1;
  double tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9;
  double tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17;
  double tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27;
  double tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215;
  double tv4sigmalapltau216, tv4sigmalapltau217, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34, tv4sigmatau35;
  double tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, tv4sigmatau311, t12995, t12996;
  double t13000, t13003, t13004, t13007, t13010, t13015, t13025, t13026;
  double t13029, t13033, t13038, t13046, t13058, t13059, t13096, t13117;
  double t13120, t13123, t13147, t13151, t13157, tv4lapl40, tv4lapl41, tv4lapl42;
  double tv4lapl43, t13161, t13162, t13163, t13169, t13170, t13176, t13181;
  double t13191, t13192, t13195, t13200, t13206, t13217, t13234, t13235;
  double t13263, t13283, t13291, t13296, t13313, t13317, t13323, tv4lapl44;
  double tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7;
  double tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27;
  double tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36;
  double tv4lapltau37, tv4tau40, tv4tau41, tv4tau42, tv4tau43, tv4tau44;

  mgga_k_csk_params *params;

  assert(p->params != NULL);
  params = (mgga_k_csk_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = t3 * t3;
  t5 = M_CBRTPI;
  t7 = t4 * t5 * M_PI;
  t8 = rho[0] + rho[1];
  t9 = 0.1e1 / t8;
  t12 = 0.2e1 * rho[0] * t9 <= p->zeta_threshold;
  t13 = p->zeta_threshold - 0.1e1;
  t16 = 0.2e1 * rho[1] * t9 <= p->zeta_threshold;
  t17 = -t13;
  t18 = rho[0] - rho[1];
  t20 = my_piecewise5(t12, t13, t16, t17, t18 * t9);
  t21 = 0.1e1 + t20;
  t22 = t21 <= p->zeta_threshold;
  t23 = POW_1_3(p->zeta_threshold);
  t24 = t23 * t23;
  t25 = t24 * p->zeta_threshold;
  t26 = POW_1_3(t21);
  t27 = t26 * t26;
  t29 = my_piecewise3(t22, t25, t27 * t21);
  t30 = POW_1_3(t8);
  t31 = t30 * t30;
  t32 = t29 * t31;
  t33 = M_CBRT6;
  t34 = M_PI * M_PI;
  t35 = POW_1_3(t34);
  t36 = t35 * t35;
  t38 = t33 / t36;
  t39 = rho[0] * rho[0];
  t40 = POW_1_3(rho[0]);
  t41 = t40 * t40;
  t43 = 0.1e1 / t41 / t39;
  t45 = t38 * sigma[0] * t43;
  t48 = 0.1e1 / t41 / rho[0];
  t53 = 0.5e1 / 0.54e2 * t38 * lapl[0] * t48 - 0.5e1 / 0.81e2 * t45;
  t55 = log(0.1e1 - DBL_EPSILON);
  t56 = 0.1e1 / params->csk_a;
  t57 = pow(-t55, -t56);
  t58 = t53 < -t57;
  t59 = log(DBL_EPSILON);
  t60 = pow(-t59, -t56);
  t61 = -t60 < t53;
  t62 = my_piecewise3(t61, -t60, t53);
  t63 = -t57 < t62;
  t64 = my_piecewise3(t63, t62, -t57);
  t65 = fabs(t64);
  t66 = pow(t65, params->csk_a);
  t67 = 0.1e1 / t66;
  t68 = exp(-t67);
  t69 = 0.1e1 - t68;
  t70 = pow(t69, t56);
  t71 = my_piecewise5(t58, 0, t61, 1, t70);
  t73 = 0.1e1 + 0.5e1 / 0.72e2 * t45 + t53 * t71;
  t77 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t73);
  t78 = rho[1] <= p->dens_threshold;
  t79 = -t18;
  t81 = my_piecewise5(t16, t13, t12, t17, t79 * t9);
  t82 = 0.1e1 + t81;
  t83 = t82 <= p->zeta_threshold;
  t84 = POW_1_3(t82);
  t85 = t84 * t84;
  t87 = my_piecewise3(t83, t25, t85 * t82);
  t88 = t87 * t31;
  t89 = rho[1] * rho[1];
  t90 = POW_1_3(rho[1]);
  t91 = t90 * t90;
  t93 = 0.1e1 / t91 / t89;
  t95 = t38 * sigma[2] * t93;
  t98 = 0.1e1 / t91 / rho[1];
  t103 = 0.5e1 / 0.54e2 * t38 * lapl[1] * t98 - 0.5e1 / 0.81e2 * t95;
  t104 = t103 < -t57;
  t105 = -t60 < t103;
  t106 = my_piecewise3(t105, -t60, t103);
  t107 = -t57 < t106;
  t108 = my_piecewise3(t107, t106, -t57);
  t109 = fabs(t108);
  t110 = pow(t109, params->csk_a);
  t111 = 0.1e1 / t110;
  t112 = exp(-t111);
  t113 = 0.1e1 - t112;
  t114 = pow(t113, t56);
  t115 = my_piecewise5(t104, 0, t105, 1, t114);
  t117 = 0.1e1 + 0.5e1 / 0.72e2 * t95 + t103 * t115;
  t121 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t117);
  tzk0 = t77 + t121;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t122 = t8 * t8;
  t123 = 0.1e1 / t122;
  t124 = t18 * t123;
  t126 = my_piecewise5(t12, 0, t16, 0, t9 - t124);
  t129 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t126);
  t130 = t129 * t31;
  t134 = 0.1e1 / t30;
  t135 = t29 * t134;
  t138 = t7 * t135 * t73 / 0.1e2;
  t141 = 0.1e1 / t41 / t39 / rho[0];
  t143 = t38 * sigma[0] * t141;
  t149 = -0.25e2 / 0.162e3 * t38 * lapl[0] * t43 + 0.4e2 / 0.243e3 * t143;
  t151 = t70 * t67;
  t152 = my_piecewise3(t61, 0, t149);
  t153 = my_piecewise3(t63, t152, 0);
  t155 = fabs(t64) / t64;
  t156 = 0.1e1 / t65;
  t158 = 0.1e1 / t69;
  t159 = t68 * t158;
  t160 = t155 * t156 * t159;
  t162 = my_piecewise5(t58, 0, t61, 0, -t151 * t153 * t160);
  t164 = -0.5e1 / 0.27e2 * t143 + t149 * t71 + t53 * t162;
  t169 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t73 + t138 + 0.3e1 / 0.2e2 * t7 * t32 * t164);
  t170 = t79 * t123;
  t172 = my_piecewise5(t16, 0, t12, 0, -t9 - t170);
  t175 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t172);
  t176 = t175 * t31;
  t180 = t87 * t134;
  t183 = t7 * t180 * t117 / 0.1e2;
  t185 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t117 + t183);
  tvrho0 = t77 + t121 + t8 * (t169 + t185);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t189 = my_piecewise5(t12, 0, t16, 0, -t9 - t124);
  t192 = my_piecewise3(t22, 0, 0.5e1 / 0.3e1 * t27 * t189);
  t193 = t192 * t31;
  t198 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t73 + t138);
  t200 = my_piecewise5(t16, 0, t12, 0, t9 - t170);
  t203 = my_piecewise3(t83, 0, 0.5e1 / 0.3e1 * t85 * t200);
  t204 = t203 * t31;
  t210 = 0.1e1 / t91 / t89 / rho[1];
  t212 = t38 * sigma[2] * t210;
  t218 = -0.25e2 / 0.162e3 * t38 * lapl[1] * t93 + 0.4e2 / 0.243e3 * t212;
  t220 = t114 * t111;
  t221 = my_piecewise3(t105, 0, t218);
  t222 = my_piecewise3(t107, t221, 0);
  t224 = fabs(t108) / t108;
  t225 = 0.1e1 / t109;
  t227 = 0.1e1 / t113;
  t228 = t112 * t227;
  t229 = t224 * t225 * t228;
  t231 = my_piecewise5(t104, 0, t105, 0, -t220 * t222 * t229);
  t233 = -0.5e1 / 0.27e2 * t212 + t218 * t115 + t103 * t231;
  t238 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t117 + t183 + 0.3e1 / 0.2e2 * t7 * t88 * t233);
  tvrho1 = t77 + t121 + t8 * (t198 + t238);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t241 = t38 * t43;
  t244 = t38 * t43 * t71;
  t247 = my_piecewise3(t61, 0, -0.5e1 / 0.81e2 * t241);
  t248 = my_piecewise3(t63, t247, 0);
  t251 = my_piecewise5(t58, 0, t61, 0, -t151 * t248 * t160);
  t253 = 0.5e1 / 0.72e2 * t241 - 0.5e1 / 0.81e2 * t244 + t53 * t251;
  t257 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t253);
  tvsigma0 = t8 * t257;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t258 = t38 * t93;
  t261 = t38 * t93 * t115;
  t264 = my_piecewise3(t105, 0, -0.5e1 / 0.81e2 * t258);
  t265 = my_piecewise3(t107, t264, 0);
  t268 = my_piecewise5(t104, 0, t105, 0, -t220 * t265 * t229);
  t270 = 0.5e1 / 0.72e2 * t258 - 0.5e1 / 0.81e2 * t261 + t103 * t268;
  t274 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t270);
  tvsigma2 = t8 * t274;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t280 = my_piecewise3(t61, 0, 0.5e1 / 0.54e2 * t38 * t48);
  t281 = my_piecewise3(t63, t280, 0);
  t284 = my_piecewise5(t58, 0, t61, 0, -t151 * t281 * t160);
  t286 = 0.5e1 / 0.54e2 * t38 * t48 * t71 + t53 * t284;
  t290 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t286);
  tvlapl0 = t8 * t290;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t296 = my_piecewise3(t105, 0, 0.5e1 / 0.54e2 * t38 * t98);
  t297 = my_piecewise3(t107, t296, 0);
  t300 = my_piecewise5(t104, 0, t105, 0, -t220 * t297 * t229);
  t302 = 0.5e1 / 0.54e2 * t38 * t98 * t115 + t103 * t300;
  t306 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t302);
  tvlapl1 = t8 * t306;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  tvtau0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  tvtau1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t309 = 0.1e1 / t26;
  t310 = t126 * t126;
  t313 = t122 * t8;
  t314 = 0.1e1 / t313;
  t315 = t18 * t314;
  t318 = my_piecewise5(t12, 0, t16, 0, -0.2e1 * t123 + 0.2e1 * t315);
  t322 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t310 + 0.5e1 / 0.3e1 * t27 * t318);
  t323 = t322 * t31;
  t327 = t129 * t134;
  t329 = t7 * t327 * t73;
  t335 = 0.1e1 / t30 / t8;
  t336 = t29 * t335;
  t339 = t7 * t336 * t73 / 0.3e2;
  t341 = t7 * t135 * t164;
  t343 = t39 * t39;
  t345 = 0.1e1 / t41 / t343;
  t347 = t38 * sigma[0] * t345;
  t353 = 0.1e3 / 0.243e3 * t38 * lapl[0] * t141 - 0.44e3 / 0.729e3 * t347;
  t357 = t66 * t66;
  t359 = t70 / t357;
  t360 = t153 * t153;
  t362 = t155 * t155;
  t363 = t65 * t65;
  t364 = 0.1e1 / t363;
  t365 = t362 * t364;
  t366 = t68 * t68;
  t367 = t69 * t69;
  t368 = 0.1e1 / t367;
  t369 = t366 * t368;
  t370 = t365 * t369;
  t372 = t360 * t362;
  t374 = t364 * t68;
  t375 = t158 * params->csk_a;
  t376 = t374 * t375;
  t378 = my_piecewise3(t61, 0, t353);
  t379 = my_piecewise3(t63, t378, 0);
  t382 = t151 * t360;
  t383 = 0.0;
  t385 = t383 * t156 * t159;
  t386 = t382 * t385;
  t387 = t365 * t159;
  t389 = t359 * t372;
  t391 = t364 * t366;
  t392 = t368 * params->csk_a;
  t393 = t391 * t392;
  t396 = my_piecewise5(t58, 0, t61, 0, -t151 * t379 * t160 + t151 * t372 * t376 + t359 * t360 * t370 - t389 * t376 + t382 * t387 - t389 * t393 - t386);
  t398 = 0.55e2 / 0.81e2 * t347 + t353 * t71 + 0.2e1 * t149 * t162 + t53 * t396;
  t403 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t73 + t329 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t164 - t339 + t341 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t398);
  t404 = 0.1e1 / t84;
  t405 = t172 * t172;
  t408 = t79 * t314;
  t411 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t123 + 0.2e1 * t408);
  t415 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t405 + 0.5e1 / 0.3e1 * t85 * t411);
  t416 = t415 * t31;
  t420 = t175 * t134;
  t422 = t7 * t420 * t117;
  t424 = t87 * t335;
  t427 = t7 * t424 * t117 / 0.3e2;
  t429 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t117 + t422 / 0.5e1 - t427);
  tv2rho20 = 0.2e1 * t169 + 0.2e1 * t185 + t8 * (t403 + t429);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t432 = t309 * t189;
  t436 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t315);
  t440 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t432 * t126 + 0.5e1 / 0.3e1 * t27 * t436);
  t441 = t440 * t31;
  t445 = t192 * t134;
  t447 = t7 * t445 * t73;
  t455 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t73 + t447 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t164 + t329 / 0.1e2 - t339 + t341 / 0.1e2);
  t456 = t404 * t200;
  t460 = my_piecewise5(t16, 0, t12, 0, 0.2e1 * t408);
  t464 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t456 * t172 + 0.5e1 / 0.3e1 * t85 * t460);
  t465 = t464 * t31;
  t469 = t203 * t134;
  t471 = t7 * t469 * t117;
  t478 = t7 * t180 * t233;
  t481 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t117 + t471 / 0.1e2 + t422 / 0.1e2 - t427 + 0.3e1 / 0.2e2 * t7 * t176 * t233 + t478 / 0.1e2);
  tv2rho21 = t169 + t185 + t198 + t238 + t8 * (t455 + t481);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t486 = t189 * t189;
  t491 = my_piecewise5(t12, 0, t16, 0, 0.2e1 * t123 + 0.2e1 * t315);
  t495 = my_piecewise3(t22, 0, 0.1e2 / 0.9e1 * t309 * t486 + 0.5e1 / 0.3e1 * t27 * t491);
  t496 = t495 * t31;
  t502 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t73 + t447 / 0.5e1 - t339);
  t503 = t200 * t200;
  t508 = my_piecewise5(t16, 0, t12, 0, -0.2e1 * t123 + 0.2e1 * t408);
  t512 = my_piecewise3(t83, 0, 0.1e2 / 0.9e1 * t404 * t503 + 0.5e1 / 0.3e1 * t85 * t508);
  t513 = t512 * t31;
  t522 = t89 * t89;
  t524 = 0.1e1 / t91 / t522;
  t526 = t38 * sigma[2] * t524;
  t532 = 0.1e3 / 0.243e3 * t38 * lapl[1] * t210 - 0.44e3 / 0.729e3 * t526;
  t536 = t110 * t110;
  t538 = t114 / t536;
  t539 = t222 * t222;
  t541 = t224 * t224;
  t542 = t109 * t109;
  t543 = 0.1e1 / t542;
  t544 = t541 * t543;
  t545 = t112 * t112;
  t546 = t113 * t113;
  t547 = 0.1e1 / t546;
  t548 = t545 * t547;
  t549 = t544 * t548;
  t551 = t539 * t541;
  t553 = t543 * t112;
  t554 = t227 * params->csk_a;
  t555 = t553 * t554;
  t557 = my_piecewise3(t105, 0, t532);
  t558 = my_piecewise3(t107, t557, 0);
  t561 = t220 * t539;
  t562 = 0.0;
  t564 = t562 * t225 * t228;
  t565 = t561 * t564;
  t566 = t544 * t228;
  t568 = t538 * t551;
  t570 = t543 * t545;
  t571 = t547 * params->csk_a;
  t572 = t570 * t571;
  t575 = my_piecewise5(t104, 0, t105, 0, -t220 * t558 * t229 + t220 * t551 * t555 + t538 * t539 * t549 - t568 * t555 + t561 * t566 - t568 * t572 - t565);
  t577 = 0.55e2 / 0.81e2 * t526 + t532 * t115 + 0.2e1 * t218 * t231 + t103 * t575;
  t582 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t117 + t471 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t233 - t427 + t478 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t577);
  tv2rho22 = 0.2e1 * t198 + 0.2e1 * t238 + t8 * (t502 + t582);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t590 = t7 * t135 * t253 / 0.1e2;
  t591 = t38 * t141;
  t594 = t38 * t141 * t71;
  t597 = t38 * t43 * t162;
  t600 = t153 * t362;
  t601 = t359 * t600;
  t602 = t368 * t248;
  t603 = t391 * t602;
  t605 = t248 * t362;
  t606 = t151 * t605;
  t607 = t375 * t153;
  t608 = t374 * t607;
  t611 = my_piecewise3(t61, 0, 0.4e2 / 0.243e3 * t591);
  t612 = my_piecewise3(t63, t611, 0);
  t615 = t248 * t153;
  t617 = t151 * t615 * t385;
  t618 = t158 * t153;
  t619 = t374 * t618;
  t621 = t359 * t605;
  t623 = t392 * t153;
  t624 = t391 * t623;
  t627 = my_piecewise5(t58, 0, t61, 0, -t151 * t612 * t160 + t601 * t603 + t606 * t608 + t606 * t619 - t621 * t608 - t621 * t624 - t617);
  t629 = -0.5e1 / 0.27e2 * t591 + 0.4e2 / 0.243e3 * t594 - 0.5e1 / 0.81e2 * t597 + t149 * t251 + t53 * t627;
  t634 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t253 + t590 + 0.3e1 / 0.2e2 * t7 * t32 * t629);
  tv2rhosigma0 = t8 * t634 + t257;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t641 = t7 * t180 * t270 / 0.1e2;
  t643 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t270 + t641);
  tv2rhosigma2 = t8 * t643 + t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t649 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t253 + t590);
  tv2rhosigma3 = t8 * t649 + t257;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t654 = t38 * t210;
  t657 = t38 * t210 * t115;
  t660 = t38 * t93 * t231;
  t663 = t222 * t541;
  t664 = t538 * t663;
  t665 = t547 * t265;
  t666 = t570 * t665;
  t668 = t265 * t541;
  t669 = t220 * t668;
  t671 = t553 * t554 * t222;
  t674 = my_piecewise3(t105, 0, 0.4e2 / 0.243e3 * t654);
  t675 = my_piecewise3(t107, t674, 0);
  t678 = t265 * t222;
  t680 = t220 * t678 * t564;
  t681 = t227 * t222;
  t682 = t553 * t681;
  t684 = t538 * t668;
  t686 = t571 * t222;
  t687 = t570 * t686;
  t690 = my_piecewise5(t104, 0, t105, 0, -t220 * t675 * t229 + t664 * t666 + t669 * t671 + t669 * t682 - t684 * t671 - t684 * t687 - t680);
  t692 = -0.5e1 / 0.27e2 * t654 + 0.4e2 / 0.243e3 * t657 - 0.5e1 / 0.81e2 * t660 + t218 * t268 + t103 * t690;
  t697 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t270 + t641 + 0.3e1 / 0.2e2 * t7 * t88 * t692);
  tv2rhosigma5 = t8 * t697 + t274;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t704 = t7 * t135 * t286 / 0.1e2;
  t710 = t368 * t281;
  t711 = t391 * t710;
  t713 = t281 * t362;
  t714 = t151 * t713;
  t717 = my_piecewise3(t61, 0, -0.25e2 / 0.162e3 * t241);
  t718 = my_piecewise3(t63, t717, 0);
  t721 = t281 * t153;
  t723 = t151 * t721 * t385;
  t725 = t359 * t713;
  t729 = my_piecewise5(t58, 0, t61, 0, -t151 * t718 * t160 + t601 * t711 + t714 * t608 - t725 * t608 + t714 * t619 - t725 * t624 - t723);
  t731 = -0.25e2 / 0.162e3 * t244 + 0.5e1 / 0.54e2 * t38 * t48 * t162 + t149 * t284 + t53 * t729;
  t736 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t286 + t704 + 0.3e1 / 0.2e2 * t7 * t32 * t731);
  tv2rholapl0 = t8 * t736 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t743 = t7 * t180 * t302 / 0.1e2;
  t745 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t302 + t743);
  tv2rholapl1 = t8 * t745 + t306;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  t751 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t286 + t704);
  tv2rholapl2 = t8 * t751 + t290;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  t761 = t547 * t297;
  t762 = t570 * t761;
  t764 = t297 * t541;
  t765 = t220 * t764;
  t768 = my_piecewise3(t105, 0, -0.25e2 / 0.162e3 * t258);
  t769 = my_piecewise3(t107, t768, 0);
  t772 = t297 * t222;
  t774 = t220 * t772 * t564;
  t776 = t538 * t764;
  t780 = my_piecewise5(t104, 0, t105, 0, -t220 * t769 * t229 + t664 * t762 + t765 * t671 - t776 * t671 + t765 * t682 - t776 * t687 - t774);
  t782 = -0.25e2 / 0.162e3 * t261 + 0.5e1 / 0.54e2 * t38 * t98 * t231 + t218 * t300 + t103 * t780;
  t787 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t302 + t743 + 0.3e1 / 0.2e2 * t7 * t88 * t782);
  tv2rholapl3 = t8 * t787 + t306;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  tv2rhotau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  tv2rhotau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  tv2rhotau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  tv2rhotau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t790 = t38 * t43 * t251;
  t792 = t248 * t248;
  t795 = t792 * t362;
  t798 = my_piecewise3(t61, 0, 0);
  t799 = my_piecewise3(t63, t798, 0);
  t801 = t151 * t799 * t160;
  t802 = t151 * t792;
  t803 = t802 * t385;
  t805 = t359 * t795;
  t809 = my_piecewise5(t58, 0, t61, 0, t151 * t795 * t376 + t359 * t792 * t370 - t805 * t376 + t802 * t387 - t805 * t393 - t801 - t803);
  t811 = -0.1e2 / 0.81e2 * t790 + t53 * t809;
  t815 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t811);
  tv2sigma20 = t8 * t815;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t817 = t38 * t93 * t268;
  t819 = t265 * t265;
  t822 = t819 * t541;
  t825 = my_piecewise3(t105, 0, 0);
  t826 = my_piecewise3(t107, t825, 0);
  t828 = t220 * t826 * t229;
  t829 = t220 * t819;
  t830 = t829 * t564;
  t832 = t538 * t822;
  t836 = my_piecewise5(t104, 0, t105, 0, t220 * t822 * t555 + t538 * t819 * t549 - t832 * t555 + t829 * t566 - t832 * t572 - t828 - t830);
  t838 = -0.1e2 / 0.81e2 * t817 + t103 * t836;
  t842 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t838);
  tv2sigma25 = t8 * t842;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t847 = t38 * t43 * t284;
  t850 = t375 * t248;
  t851 = t374 * t850;
  t853 = t281 * t248;
  t854 = t151 * t853;
  t855 = t854 * t385;
  t856 = t158 * t248;
  t857 = t374 * t856;
  t860 = t392 * t248;
  t861 = t391 * t860;
  t864 = my_piecewise5(t58, 0, t61, 0, t621 * t711 + t714 * t851 + t714 * t857 - t725 * t851 - t725 * t861 - t801 - t855);
  t866 = 0.5e1 / 0.54e2 * t38 * t48 * t251 - 0.5e1 / 0.81e2 * t847 + t53 * t864;
  t870 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t866);
  tv2sigmalapl0 = t8 * t870;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  t875 = t38 * t93 * t300;
  t878 = t554 * t265;
  t879 = t553 * t878;
  t881 = t297 * t265;
  t882 = t220 * t881;
  t883 = t882 * t564;
  t884 = t227 * t265;
  t885 = t553 * t884;
  t888 = t571 * t265;
  t889 = t570 * t888;
  t892 = my_piecewise5(t104, 0, t105, 0, t684 * t762 + t765 * t879 + t765 * t885 - t776 * t879 - t776 * t889 - t828 - t883);
  t894 = 0.5e1 / 0.54e2 * t38 * t98 * t268 - 0.5e1 / 0.81e2 * t875 + t103 * t892;
  t898 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t894);
  tv2sigmalapl5 = t8 * t898;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  tv2sigmatau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  tv2sigmatau5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  t902 = t281 * t281;
  t905 = t902 * t362;
  t906 = t151 * t905;
  t908 = t151 * t902;
  t909 = t908 * t385;
  t911 = t359 * t905;
  t915 = my_piecewise5(t58, 0, t61, 0, t359 * t902 * t370 + t906 * t376 - t911 * t376 + t908 * t387 - t911 * t393 - t801 - t909);
  t917 = 0.5e1 / 0.27e2 * t38 * t48 * t284 + t53 * t915;
  t921 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t917);
  tv2lapl20 = t8 * t921;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  t925 = t297 * t297;
  t928 = t925 * t541;
  t929 = t220 * t928;
  t931 = t220 * t925;
  t932 = t931 * t564;
  t934 = t538 * t928;
  t938 = my_piecewise5(t104, 0, t105, 0, t538 * t925 * t549 + t929 * t555 - t934 * t555 + t931 * t566 - t934 * t572 - t828 - t932);
  t940 = 0.5e1 / 0.27e2 * t38 * t98 * t300 + t103 * t938;
  t944 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t940);
  tv2lapl22 = t8 * t944;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  tv2tau20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  tv2tau22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t948 = 0.1e1 / t26 / t21;
  t949 = t310 * t126;
  t952 = t309 * t126;
  t955 = t122 * t122;
  t956 = 0.1e1 / t955;
  t957 = t18 * t956;
  t960 = my_piecewise5(t12, 0, t16, 0, 0.6e1 * t314 - 0.6e1 * t957);
  t964 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t948 * t949 + 0.1e2 / 0.3e1 * t952 * t318 + 0.5e1 / 0.3e1 * t27 * t960);
  t965 = t964 * t31;
  t969 = t322 * t134;
  t971 = t7 * t969 * t73;
  t976 = t129 * t335;
  t978 = t7 * t976 * t73;
  t981 = t7 * t327 * t164;
  t987 = 0.1e1 / t30 / t122;
  t988 = t29 * t987;
  t991 = 0.2e1 / 0.45e2 * t7 * t988 * t73;
  t993 = t7 * t336 * t164;
  t996 = t7 * t135 * t398;
  t1000 = 0.1e1 / t41 / t343 / rho[0];
  t1002 = t38 * sigma[0] * t1000;
  t1008 = -0.11e4 / 0.729e3 * t38 * lapl[0] * t345 + 0.616e4 / 0.2187e4 * t1002;
  t1014 = t379 * t362;
  t1015 = t359 * t1014;
  t1018 = t360 * t153;
  t1019 = t1018 * t383;
  t1020 = t359 * t1019;
  t1021 = t364 * params->csk_a;
  t1023 = t155 * t68 * t158;
  t1024 = t1021 * t1023;
  t1025 = t1020 * t1024;
  t1027 = t1018 * t155;
  t1029 = t375 * t383;
  t1030 = t374 * t1029;
  t1031 = t151 * t1027 * t1030;
  t1034 = t375 * t379;
  t1035 = t374 * t1034;
  t1041 = t391 * t392 * t155;
  t1042 = t1020 * t1041;
  t1044 = my_piecewise3(t61, 0, t1008);
  t1045 = my_piecewise3(t63, t1044, 0);
  t1050 = t70 / t357 / t66;
  t1052 = t362 * t155;
  t1054 = 0.1e1 / t363 / t65;
  t1055 = t1052 * t1054;
  t1056 = t366 * t68;
  t1058 = 0.1e1 / t367 / t69;
  t1059 = t1056 * t1058;
  t1060 = t1055 * t1059;
  t1063 = t1055 * t159;
  t1067 = t1055 * t369;
  t1070 = t1018 * t1052;
  t1071 = t359 * t1070;
  t1072 = t1054 * params->csk_a;
  t1073 = t1072 * t159;
  t1076 = t151 * t1070;
  t1079 = -t1050 * t1018 * t1060 - 0.2e1 * t151 * t1018 * t1063 - 0.3e1 * t359 * t1018 * t1067 + 0.3e1 * t151 * t600 * t1035 - t151 * t1045 * t160 - 0.3e1 * t1015 * t608 - 0.3e1 * t1015 * t624 + 0.3e1 * t1071 * t1073 - 0.3e1 * t1076 * t1073 - 0.3e1 * t1025 + 0.3e1 * t1031 - 0.3e1 * t1042 - t386;
  t1084 = t158 * t155;
  t1085 = t374 * t1084;
  t1086 = t151 * t1019 * t1085;
  t1089 = t368 * t383;
  t1090 = t391 * t1089;
  t1091 = t359 * t1027 * t1090;
  t1093 = params->csk_a * params->csk_a;
  t1094 = t1054 * t1093;
  t1095 = t1094 * t159;
  t1098 = t1050 * t1070;
  t1100 = t1054 * t366;
  t1101 = t1100 * t392;
  t1105 = t368 * t379;
  t1109 = t1054 * t1056;
  t1110 = t1058 * params->csk_a;
  t1111 = t1109 * t1110;
  t1114 = t368 * t1093;
  t1115 = t1100 * t1114;
  t1120 = t151 * t379 * t153 * t385;
  t1124 = t1058 * t1093;
  t1125 = t1109 * t1124;
  t1128 = 0.3e1 * t151 * t1014 * t619 + 0.3e1 * t601 * t391 * t1105 + 0.3e1 * t1071 * t1095 + 0.3e1 * t1071 * t1115 - t1076 * t1095 - t1098 * t1095 + 0.3e1 * t1098 * t1101 + 0.3e1 * t1098 * t1111 - 0.3e1 * t1098 * t1115 - 0.2e1 * t1098 * t1125 + 0.3e1 * t1086 + 0.3e1 * t1091 - 0.3e1 * t1120;
  t1130 = my_piecewise5(t58, 0, t61, 0, t1079 + t1128);
  t1132 = -0.77e3 / 0.243e3 * t1002 + t1008 * t71 + 0.3e1 * t353 * t162 + 0.3e1 * t149 * t396 + t53 * t1130;
  t1137 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t965 * t73 + 0.3e1 / 0.1e2 * t971 + 0.9e1 / 0.2e2 * t7 * t323 * t164 - t978 / 0.1e2 + 0.3e1 / 0.5e1 * t981 + 0.9e1 / 0.2e2 * t7 * t130 * t398 + t991 - t993 / 0.1e2 + 0.3e1 / 0.1e2 * t996 + 0.3e1 / 0.2e2 * t7 * t32 * t1132);
  t1139 = 0.1e1 / t84 / t82;
  t1140 = t405 * t172;
  t1143 = t404 * t172;
  t1146 = t79 * t956;
  t1149 = my_piecewise5(t16, 0, t12, 0, -0.6e1 * t314 - 0.6e1 * t1146);
  t1153 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1139 * t1140 + 0.1e2 / 0.3e1 * t1143 * t411 + 0.5e1 / 0.3e1 * t85 * t1149);
  t1154 = t1153 * t31;
  t1158 = t415 * t134;
  t1160 = t7 * t1158 * t117;
  t1162 = t175 * t335;
  t1164 = t7 * t1162 * t117;
  t1166 = t87 * t987;
  t1169 = 0.2e1 / 0.45e2 * t7 * t1166 * t117;
  t1171 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1154 * t117 + 0.3e1 / 0.1e2 * t1160 - t1164 / 0.1e2 + t1169);
  tv3rho30 = 0.3e1 * t403 + 0.3e1 * t429 + t8 * (t1137 + t1171);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1174 = 0.2e1 * t455;
  t1175 = 0.2e1 * t481;
  t1176 = t948 * t189;
  t1179 = t309 * t436;
  t1184 = 0.2e1 * t314;
  t1185 = 0.6e1 * t957;
  t1187 = my_piecewise5(t12, 0, t16, 0, t1184 - t1185);
  t1191 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1176 * t310 + 0.2e2 / 0.9e1 * t1179 * t126 + 0.1e2 / 0.9e1 * t432 * t318 + 0.5e1 / 0.3e1 * t27 * t1187);
  t1192 = t1191 * t31;
  t1196 = t440 * t134;
  t1199 = t7 * t1196 * t73 / 0.5e1;
  t1203 = t192 * t335;
  t1205 = t7 * t1203 * t73;
  t1209 = t7 * t445 * t164 / 0.5e1;
  t1218 = 0.3e1 / 0.2e2 * t7 * t1192 * t73 + t1199 + 0.3e1 / 0.1e2 * t7 * t441 * t164 - t1205 / 0.3e2 + t1209 + 0.3e1 / 0.2e2 * t7 * t193 * t398 + t971 / 0.1e2 - t978 / 0.15e2 + t981 / 0.5e1 + t991 - t993 / 0.15e2 + t996 / 0.1e2;
  t1219 = my_piecewise3(t2, 0, t1218);
  t1220 = t1139 * t200;
  t1223 = t404 * t460;
  t1228 = 0.6e1 * t1146;
  t1230 = my_piecewise5(t16, 0, t12, 0, -t1184 - t1228);
  t1234 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1220 * t405 + 0.2e2 / 0.9e1 * t1223 * t172 + 0.1e2 / 0.9e1 * t456 * t411 + 0.5e1 / 0.3e1 * t85 * t1230);
  t1235 = t1234 * t31;
  t1239 = t464 * t134;
  t1242 = t7 * t1239 * t117 / 0.5e1;
  t1243 = t203 * t335;
  t1245 = t7 * t1243 * t117;
  t1254 = t7 * t420 * t233 / 0.5e1;
  t1256 = t7 * t424 * t233;
  t1259 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1235 * t117 + t1242 - t1245 / 0.3e2 + t1160 / 0.1e2 - t1164 / 0.15e2 + t1169 + 0.3e1 / 0.2e2 * t7 * t416 * t233 + t1254 - t1256 / 0.3e2);
  tv3rho31 = t403 + t429 + t1174 + t1175 + t8 * (t1219 + t1259);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1262 = t948 * t486;
  t1267 = t309 * t491;
  t1271 = my_piecewise5(t12, 0, t16, 0, -t1184 - t1185);
  t1275 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t1262 * t126 + 0.2e2 / 0.9e1 * t432 * t436 + 0.1e2 / 0.9e1 * t1267 * t126 + 0.5e1 / 0.3e1 * t27 * t1271);
  t1276 = t1275 * t31;
  t1280 = t495 * t134;
  t1282 = t7 * t1280 * t73;
  t1291 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1276 * t73 + t1282 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t496 * t164 + t1199 - t1205 / 0.15e2 + t1209 - t978 / 0.3e2 + t991 - t993 / 0.3e2);
  t1292 = t1139 * t503;
  t1297 = t404 * t508;
  t1301 = my_piecewise5(t16, 0, t12, 0, t1184 - t1228);
  t1305 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1292 * t172 + 0.2e2 / 0.9e1 * t456 * t460 + 0.1e2 / 0.9e1 * t1297 * t172 + 0.5e1 / 0.3e1 * t85 * t1301);
  t1306 = t1305 * t31;
  t1310 = t512 * t134;
  t1312 = t7 * t1310 * t117;
  t1319 = t7 * t469 * t233;
  t1327 = t7 * t180 * t577;
  t1329 = 0.3e1 / 0.2e2 * t7 * t1306 * t117 + t1312 / 0.1e2 + t1242 - t1245 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t465 * t233 + t1319 / 0.5e1 - t1164 / 0.3e2 + t1169 + t1254 - t1256 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t176 * t577 + t1327 / 0.1e2;
  t1330 = my_piecewise3(t78, 0, t1329);
  tv3rho32 = t1174 + t1175 + t502 + t582 + t8 * (t1291 + t1330);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1335 = t486 * t189;
  t1342 = my_piecewise5(t12, 0, t16, 0, -0.6e1 * t314 - 0.6e1 * t957);
  t1346 = my_piecewise3(t22, 0, -0.1e2 / 0.27e2 * t948 * t1335 + 0.1e2 / 0.3e1 * t432 * t491 + 0.5e1 / 0.3e1 * t27 * t1342);
  t1347 = t1346 * t31;
  t1354 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1347 * t73 + 0.3e1 / 0.1e2 * t1282 - t1205 / 0.1e2 + t991);
  t1355 = t503 * t200;
  t1362 = my_piecewise5(t16, 0, t12, 0, 0.6e1 * t314 - 0.6e1 * t1146);
  t1366 = my_piecewise3(t83, 0, -0.1e2 / 0.27e2 * t1139 * t1355 + 0.1e2 / 0.3e1 * t456 * t508 + 0.5e1 / 0.3e1 * t85 * t1362);
  t1367 = t1366 * t31;
  t1384 = 0.1e1 / t91 / t522 / rho[1];
  t1386 = t38 * sigma[2] * t1384;
  t1392 = -0.11e4 / 0.729e3 * t38 * lapl[1] * t524 + 0.616e4 / 0.2187e4 * t1386;
  t1398 = t558 * t541;
  t1399 = t538 * t1398;
  t1402 = t539 * t222;
  t1403 = t1402 * t562;
  t1404 = t538 * t1403;
  t1405 = t543 * params->csk_a;
  t1407 = t224 * t112 * t227;
  t1408 = t1405 * t1407;
  t1409 = t1404 * t1408;
  t1411 = t1402 * t224;
  t1414 = t553 * t554 * t562;
  t1415 = t220 * t1411 * t1414;
  t1418 = t554 * t558;
  t1419 = t553 * t1418;
  t1425 = t570 * t571 * t224;
  t1426 = t1404 * t1425;
  t1430 = t114 / t536 / t110;
  t1432 = t541 * t224;
  t1434 = 0.1e1 / t542 / t109;
  t1435 = t1432 * t1434;
  t1436 = t545 * t112;
  t1438 = 0.1e1 / t546 / t113;
  t1439 = t1436 * t1438;
  t1440 = t1435 * t1439;
  t1442 = my_piecewise3(t105, 0, t1392);
  t1443 = my_piecewise3(t107, t1442, 0);
  t1447 = t1435 * t228;
  t1451 = t1435 * t548;
  t1454 = t1402 * t1432;
  t1455 = t1430 * t1454;
  t1456 = t1434 * t1093;
  t1457 = t1456 * t228;
  t1459 = t538 * t1454;
  t1460 = t1434 * params->csk_a;
  t1461 = t1460 * t228;
  t1464 = -t1430 * t1402 * t1440 - 0.2e1 * t220 * t1402 * t1447 - 0.3e1 * t538 * t1402 * t1451 + 0.3e1 * t220 * t663 * t1419 - t220 * t1443 * t229 - 0.3e1 * t1399 * t671 - 0.3e1 * t1399 * t687 - t1455 * t1457 + 0.3e1 * t1459 * t1461 - 0.3e1 * t1409 + 0.3e1 * t1415 - 0.3e1 * t1426 - t565;
  t1465 = t220 * t1454;
  t1469 = t547 * t562;
  t1470 = t570 * t1469;
  t1471 = t538 * t1411 * t1470;
  t1477 = t227 * t224;
  t1478 = t553 * t1477;
  t1479 = t220 * t1403 * t1478;
  t1481 = t1434 * t545;
  t1482 = t1481 * t571;
  t1488 = t547 * t558;
  t1492 = t1434 * t1436;
  t1493 = t1438 * params->csk_a;
  t1494 = t1492 * t1493;
  t1497 = t547 * t1093;
  t1498 = t1481 * t1497;
  t1503 = t220 * t558 * t222 * t564;
  t1507 = t1438 * t1093;
  t1508 = t1492 * t1507;
  t1511 = 0.3e1 * t220 * t1398 * t682 + 0.3e1 * t664 * t570 * t1488 + 0.3e1 * t1455 * t1482 + 0.3e1 * t1455 * t1494 - 0.3e1 * t1455 * t1498 - 0.2e1 * t1455 * t1508 + 0.3e1 * t1459 * t1457 - t1465 * t1457 + 0.3e1 * t1459 * t1498 - 0.3e1 * t1465 * t1461 + 0.3e1 * t1471 + 0.3e1 * t1479 - 0.3e1 * t1503;
  t1513 = my_piecewise5(t104, 0, t105, 0, t1464 + t1511);
  t1515 = -0.77e3 / 0.243e3 * t1386 + t1392 * t115 + 0.3e1 * t532 * t231 + 0.3e1 * t218 * t575 + t103 * t1513;
  t1520 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1367 * t117 + 0.3e1 / 0.1e2 * t1312 + 0.9e1 / 0.2e2 * t7 * t513 * t233 - t1245 / 0.1e2 + 0.3e1 / 0.5e1 * t1319 + 0.9e1 / 0.2e2 * t7 * t204 * t577 + t1169 - t1256 / 0.1e2 + 0.3e1 / 0.1e2 * t1327 + 0.3e1 / 0.2e2 * t7 * t88 * t1515);
  tv3rho33 = 0.3e1 * t502 + 0.3e1 * t582 + t8 * (t1354 + t1520);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1528 = t7 * t327 * t253;
  t1535 = t7 * t336 * t253 / 0.3e2;
  t1537 = t7 * t135 * t629;
  t1539 = t38 * t345;
  t1542 = t38 * t345 * t71;
  t1545 = t38 * t141 * t162;
  t1548 = t38 * t43 * t396;
  t1553 = t248 * t1052;
  t1554 = t359 * t1553;
  t1556 = t360 * t68 * t158;
  t1557 = t1072 * t1556;
  t1560 = t612 * t362;
  t1561 = t359 * t1560;
  t1564 = t151 * t1553;
  t1567 = t248 * t360;
  t1570 = t383 * t364 * t1023;
  t1571 = t151 * t1567 * t1570;
  t1573 = t360 * t155;
  t1574 = t359 * t1573;
  t1575 = t602 * t383;
  t1576 = t391 * t1575;
  t1577 = t1574 * t1576;
  t1579 = t1054 * t68;
  t1580 = t158 * t1093;
  t1582 = t1579 * t1580 * t360;
  t1586 = t1050 * t1553;
  t1588 = t360 * t1052;
  t1589 = t1050 * t1588;
  t1590 = t1100 * t860;
  t1594 = t360 * t366 * t368;
  t1595 = t1094 * t1594;
  t1598 = t392 * t379;
  t1599 = t391 * t1598;
  t1601 = t1124 * t360;
  t1602 = t1109 * t1601;
  t1605 = t151 * t1560;
  t1613 = t606 * t1035 + 0.3e1 * t1554 * t1557 + 0.3e1 * t1554 * t1582 + 0.3e1 * t1554 * t1595 - 0.3e1 * t1564 * t1557 - 0.2e1 * t1561 * t608 - 0.2e1 * t1561 * t624 - t1564 * t1582 - t1586 * t1582 - 0.3e1 * t1586 * t1595 - 0.2e1 * t1586 * t1602 + 0.3e1 * t1589 * t1590 - t621 * t1599 + 0.2e1 * t1605 * t608 + 0.3e1 * t1571 + 0.3e1 * t1577;
  t1615 = t1058 * t248;
  t1616 = t1615 * params->csk_a;
  t1617 = t1109 * t1616;
  t1620 = t1567 * t383;
  t1621 = t359 * t1620;
  t1622 = t1621 * t1024;
  t1624 = t248 * t155;
  t1625 = t1624 * t364;
  t1626 = t151 * t1625;
  t1627 = params->csk_a * t360;
  t1628 = t1627 * t383;
  t1629 = t159 * t1628;
  t1630 = t1626 * t1629;
  t1632 = t1621 * t1041;
  t1635 = my_piecewise3(t61, 0, -0.44e3 / 0.729e3 * t1539);
  t1636 = my_piecewise3(t63, t1635, 0);
  t1639 = t158 * t360;
  t1640 = t1579 * t1639;
  t1643 = t359 * t1588;
  t1644 = t1100 * t602;
  t1650 = t368 * t612;
  t1651 = t391 * t1650;
  t1656 = t612 * t153;
  t1658 = t151 * t1656 * t385;
  t1662 = t151 * t248 * t379 * t385;
  t1663 = t158 * t379;
  t1664 = t374 * t1663;
  t1666 = -t1589 * t1109 * t1615 - t151 * t1636 * t160 + t1015 * t603 - t621 * t1035 - 0.2e1 * t1564 * t1640 + 0.3e1 * t1589 * t1617 + 0.2e1 * t1605 * t619 - 0.3e1 * t1643 * t1644 + 0.2e1 * t601 * t1651 + t606 * t1664 - 0.3e1 * t1622 + 0.3e1 * t1630 - 0.3e1 * t1632 - 0.2e1 * t1658 - t1662 - t617;
  t1668 = my_piecewise5(t58, 0, t61, 0, t1613 + t1666);
  t1670 = 0.55e2 / 0.81e2 * t1539 - 0.44e3 / 0.729e3 * t1542 + 0.8e2 / 0.243e3 * t1545 - 0.5e1 / 0.81e2 * t1548 + t353 * t251 + 0.2e1 * t149 * t627 + t53 * t1668;
  t1675 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t253 + t1528 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t629 - t1535 + t1537 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1670);
  tv3rho2sigma0 = t8 * t1675 + 0.2e1 * t634;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1682 = t7 * t420 * t270;
  t1686 = t7 * t424 * t270 / 0.3e2;
  t1688 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t270 + t1682 / 0.5e1 - t1686);
  tv3rho2sigma2 = t8 * t1688 + 0.2e1 * t643;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1694 = t7 * t445 * t253;
  t1702 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t253 + t1694 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t629 + t1528 / 0.1e2 - t1535 + t1537 / 0.1e2);
  tv3rho2sigma3 = t8 * t1702 + t634 + t649;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1708 = t7 * t469 * t270;
  t1715 = t7 * t180 * t692;
  t1718 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t270 + t1708 / 0.1e2 + t1682 / 0.1e2 - t1686 + 0.3e1 / 0.2e2 * t7 * t176 * t692 + t1715 / 0.1e2);
  tv3rho2sigma5 = t8 * t1718 + t643 + t697;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1726 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t253 + t1694 / 0.5e1 - t1535);
  tv3rho2sigma6 = t8 * t1726 + 0.2e1 * t649;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1737 = t38 * t524;
  t1740 = t38 * t524 * t115;
  t1743 = t38 * t210 * t231;
  t1746 = t38 * t93 * t575;
  t1751 = t675 * t541;
  t1752 = t538 * t1751;
  t1755 = t265 * t1432;
  t1756 = t538 * t1755;
  t1758 = t539 * t112 * t227;
  t1759 = t1460 * t1758;
  t1764 = t220 * t1755;
  t1767 = t539 * t224;
  t1768 = t538 * t1767;
  t1769 = t665 * t562;
  t1770 = t570 * t1769;
  t1771 = t1768 * t1770;
  t1773 = t265 * t539;
  t1776 = t562 * t543 * t1407;
  t1777 = t220 * t1773 * t1776;
  t1779 = t1430 * t1755;
  t1780 = t1456 * t1758;
  t1782 = t539 * t1432;
  t1783 = t1430 * t1782;
  t1784 = t1481 * t888;
  t1792 = t539 * t545 * t547;
  t1793 = t1456 * t1792;
  t1796 = t571 * t558;
  t1797 = t570 * t1796;
  t1799 = t1507 * t539;
  t1800 = t1492 * t1799;
  t1803 = t1438 * t265;
  t1804 = t1803 * params->csk_a;
  t1805 = t1492 * t1804;
  t1808 = t220 * t1751;
  t1811 = -t684 * t1419 - 0.2e1 * t1752 * t671 - 0.2e1 * t1752 * t687 + 0.3e1 * t1756 * t1759 + 0.3e1 * t1756 * t1780 - 0.3e1 * t1764 * t1759 - t1764 * t1780 - t1779 * t1780 - 0.3e1 * t1779 * t1793 - 0.2e1 * t1779 * t1800 + 0.3e1 * t1783 * t1784 + 0.3e1 * t1783 * t1805 - t684 * t1797 + 0.2e1 * t1808 * t671 + 0.3e1 * t1771 + 0.3e1 * t1777;
  t1815 = t1773 * t562;
  t1816 = t538 * t1815;
  t1817 = t1816 * t1408;
  t1819 = t265 * t224;
  t1820 = t1819 * t543;
  t1821 = t220 * t1820;
  t1823 = params->csk_a * t539 * t562;
  t1824 = t228 * t1823;
  t1825 = t1821 * t1824;
  t1827 = t1816 * t1425;
  t1830 = my_piecewise3(t105, 0, -0.44e3 / 0.729e3 * t1737);
  t1831 = my_piecewise3(t107, t1830, 0);
  t1834 = t538 * t1782;
  t1835 = t1481 * t665;
  t1838 = t1434 * t112;
  t1839 = t227 * t539;
  t1840 = t1838 * t1839;
  t1845 = t220 * t675 * t222 * t564;
  t1849 = t220 * t265 * t558 * t564;
  t1850 = t227 * t558;
  t1851 = t553 * t1850;
  t1856 = t547 * t675;
  t1857 = t570 * t1856;
  t1862 = -t1783 * t1492 * t1803 - t220 * t1831 * t229 + t1399 * t666 + t669 * t1419 + 0.3e1 * t1756 * t1793 - 0.2e1 * t1764 * t1840 + 0.2e1 * t1808 * t682 - 0.3e1 * t1834 * t1835 + t669 * t1851 + 0.2e1 * t664 * t1857 - 0.3e1 * t1817 + 0.3e1 * t1825 - 0.3e1 * t1827 - 0.2e1 * t1845 - t1849 - t680;
  t1864 = my_piecewise5(t104, 0, t105, 0, t1811 + t1862);
  t1866 = 0.55e2 / 0.81e2 * t1737 - 0.44e3 / 0.729e3 * t1740 + 0.8e2 / 0.243e3 * t1743 - 0.5e1 / 0.81e2 * t1746 + t532 * t268 + 0.2e1 * t218 * t690 + t103 * t1864;
  t1871 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t270 + t1708 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t692 - t1686 + t1715 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t1866);
  tv3rho2sigma8 = t8 * t1871 + 0.2e1 * t697;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1878 = t7 * t327 * t286;
  t1885 = t7 * t336 * t286 / 0.3e2;
  t1887 = t7 * t135 * t731;
  t1898 = t281 * t1052;
  t1899 = t359 * t1898;
  t1902 = t718 * t362;
  t1903 = t359 * t1902;
  t1910 = t151 * t1898;
  t1913 = t710 * t383;
  t1914 = t391 * t1913;
  t1915 = t1574 * t1914;
  t1917 = t281 * t360;
  t1919 = t151 * t1917 * t1570;
  t1921 = t710 * params->csk_a;
  t1922 = t1100 * t1921;
  t1928 = t1050 * t1898;
  t1936 = t714 * t1035 - t725 * t1035 + 0.3e1 * t1899 * t1557 - 0.3e1 * t1910 * t1557 + 0.3e1 * t1899 * t1582 - t1910 * t1582 - t1928 * t1582 + 0.3e1 * t1589 * t1922 + 0.3e1 * t1899 * t1595 - 0.3e1 * t1928 * t1595 - t725 * t1599 - 0.2e1 * t1928 * t1602 - 0.2e1 * t1903 * t608 - 0.2e1 * t1903 * t624 + 0.3e1 * t1915 + 0.3e1 * t1919;
  t1937 = t1058 * t281;
  t1938 = t1937 * params->csk_a;
  t1939 = t1109 * t1938;
  t1942 = t151 * t1902;
  t1945 = t1917 * t383;
  t1946 = t359 * t1945;
  t1947 = t1946 * t1024;
  t1950 = t281 * t155 * t364;
  t1951 = t151 * t1950;
  t1952 = t1951 * t1629;
  t1954 = t1946 * t1041;
  t1957 = my_piecewise3(t61, 0, 0.1e3 / 0.243e3 * t591);
  t1958 = my_piecewise3(t63, t1957, 0);
  t1963 = t1100 * t710;
  t1968 = t151 * t281 * t379 * t385;
  t1971 = t368 * t718;
  t1972 = t391 * t1971;
  t1975 = t1109 * t1937;
  t1977 = t718 * t153;
  t1979 = t151 * t1977 * t385;
  t1983 = -t151 * t1958 * t160 + t1015 * t711 + 0.3e1 * t1589 * t1939 - t1589 * t1975 - 0.2e1 * t1910 * t1640 - 0.3e1 * t1643 * t1963 + t714 * t1664 + 0.2e1 * t1942 * t608 + 0.2e1 * t1942 * t619 + 0.2e1 * t601 * t1972 - 0.3e1 * t1947 + 0.3e1 * t1952 - 0.3e1 * t1954 - t1968 - 0.2e1 * t1979 - t723;
  t1985 = my_piecewise5(t58, 0, t61, 0, t1936 + t1983);
  t1987 = 0.1e3 / 0.243e3 * t594 - 0.25e2 / 0.81e2 * t597 + 0.5e1 / 0.54e2 * t38 * t48 * t396 + t353 * t284 + 0.2e1 * t149 * t729 + t53 * t1985;
  t1992 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t286 + t1878 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t731 - t1885 + t1887 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * t1987);
  tv3rho2lapl0 = t8 * t1992 + 0.2e1 * t736;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1999 = t7 * t420 * t302;
  t2003 = t7 * t424 * t302 / 0.3e2;
  t2005 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t302 + t1999 / 0.5e1 - t2003);
  tv3rho2lapl1 = t8 * t2005 + 0.2e1 * t745;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  t2011 = t7 * t445 * t286;
  t2019 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t286 + t2011 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t731 + t1878 / 0.1e2 - t1885 + t1887 / 0.1e2);
  tv3rho2lapl2 = t8 * t2019 + t736 + t751;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  t2025 = t7 * t469 * t302;
  t2032 = t7 * t180 * t782;
  t2035 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t302 + t2025 / 0.1e2 + t1999 / 0.1e2 - t2003 + 0.3e1 / 0.2e2 * t7 * t176 * t782 + t2032 / 0.1e2);
  tv3rho2lapl3 = t8 * t2035 + t745 + t787;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  t2043 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t286 + t2011 / 0.5e1 - t1885);
  tv3rho2lapl4 = t8 * t2043 + 0.2e1 * t751;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  t2063 = t297 * t1432;
  t2064 = t1430 * t2063;
  t2070 = t538 * t2063;
  t2073 = t769 * t541;
  t2074 = t538 * t2073;
  t2077 = t220 * t2063;
  t2080 = t297 * t539;
  t2082 = t220 * t2080 * t1776;
  t2084 = t761 * t562;
  t2085 = t570 * t2084;
  t2086 = t1768 * t2085;
  t2091 = t761 * params->csk_a;
  t2092 = t1481 * t2091;
  t2096 = t1438 * t297;
  t2097 = t2096 * params->csk_a;
  t2098 = t1492 * t2097;
  t2101 = t220 * t2073;
  t2105 = t765 * t1419 - t776 * t1419 + 0.3e1 * t2070 * t1759 - 0.3e1 * t2077 * t1759 - t2064 * t1780 + 0.3e1 * t2070 * t1780 - t2077 * t1780 + 0.3e1 * t1783 * t2092 + 0.3e1 * t1783 * t2098 - 0.3e1 * t2064 * t1793 - t776 * t1797 - 0.2e1 * t2064 * t1800 - 0.2e1 * t2074 * t671 + 0.2e1 * t2101 * t671 + 0.3e1 * t2082 + 0.3e1 * t2086;
  t2111 = t538 * t2080 * t562;
  t2112 = t2111 * t1408;
  t2115 = t297 * t224 * t543;
  t2116 = t220 * t2115;
  t2117 = t2116 * t1824;
  t2119 = t2111 * t1425;
  t2122 = my_piecewise3(t105, 0, 0.1e3 / 0.243e3 * t654);
  t2123 = my_piecewise3(t107, t2122, 0);
  t2126 = t297 * t558;
  t2128 = t220 * t2126 * t564;
  t2131 = t547 * t769;
  t2132 = t570 * t2131;
  t2135 = t1492 * t2096;
  t2137 = t769 * t222;
  t2139 = t220 * t2137 * t564;
  t2141 = t1481 * t761;
  t2148 = -t220 * t2123 * t229 + t1399 * t762 - t1783 * t2135 + 0.3e1 * t2070 * t1793 - 0.3e1 * t1834 * t2141 - 0.2e1 * t2077 * t1840 + t765 * t1851 - 0.2e1 * t2074 * t687 + 0.2e1 * t2101 * t682 + 0.2e1 * t664 * t2132 - 0.3e1 * t2112 + 0.3e1 * t2117 - 0.3e1 * t2119 - t2128 - 0.2e1 * t2139 - t774;
  t2150 = my_piecewise5(t104, 0, t105, 0, t2105 + t2148);
  t2152 = 0.1e3 / 0.243e3 * t657 - 0.25e2 / 0.81e2 * t660 + 0.5e1 / 0.54e2 * t38 * t98 * t575 + t532 * t300 + 0.2e1 * t218 * t780 + t103 * t2150;
  t2157 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t302 + t2025 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t782 - t2003 + t2032 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * t2152);
  tv3rho2lapl5 = t8 * t2157 + 0.2e1 * t787;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  tv3rho2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  tv3rho2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  tv3rho2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  tv3rho2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  tv3rho2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  tv3rho2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t2164 = t7 * t135 * t811 / 0.1e2;
  t2166 = t38 * t141 * t251;
  t2169 = t38 * t43 * t627;
  t2172 = t792 * t1052;
  t2173 = t1050 * t2172;
  t2174 = t1110 * t153;
  t2175 = t1109 * t2174;
  t2178 = t375 * t612;
  t2179 = t374 * t2178;
  t2182 = t359 * t2172;
  t2183 = t1114 * t153;
  t2184 = t1100 * t2183;
  t2187 = t1124 * t153;
  t2188 = t1109 * t2187;
  t2191 = t1100 * t623;
  t2194 = t151 * t2172;
  t2196 = t1579 * t1580 * t153;
  t2202 = t153 * t68 * t158;
  t2203 = t1072 * t2202;
  t2206 = t799 * t362;
  t2207 = t151 * t2206;
  t2208 = t2207 * t608;
  t2209 = t359 * t2206;
  t2210 = t2209 * t608;
  t2213 = t2209 * t624;
  t2214 = t792 * t383;
  t2215 = t151 * t2214;
  t2217 = t374 * t618 * t155;
  t2218 = t2215 * t2217;
  t2224 = 0.3e1 * t2173 * t2175 - 0.3e1 * t2173 * t2184 - 0.2e1 * t2173 * t2188 + 0.3e1 * t2173 * t2191 - t2173 * t2196 + 0.2e1 * t606 * t2179 - 0.2e1 * t621 * t2179 + 0.3e1 * t2182 * t2184 + 0.3e1 * t2182 * t2196 + 0.3e1 * t2182 * t2203 - t2194 * t2196 - 0.3e1 * t2194 * t2203 + t2208 - t2210 - t2213 + 0.3e1 * t2218;
  t2225 = t392 * t612;
  t2226 = t391 * t2225;
  t2229 = t792 * t155;
  t2230 = t359 * t2229;
  t2231 = t368 * t153;
  t2232 = t2231 * t383;
  t2233 = t391 * t2232;
  t2234 = t2230 * t2233;
  t2237 = t359 * t2214 * t364;
  t2238 = params->csk_a * t153;
  t2239 = t2238 * t1023;
  t2240 = t2237 * t2239;
  t2243 = t151 * t2229 * t364;
  t2244 = t2238 * t383;
  t2245 = t159 * t2244;
  t2246 = t2243 * t2245;
  t2248 = t2238 * t155;
  t2249 = t369 * t2248;
  t2250 = t2237 * t2249;
  t2252 = t248 * t383;
  t2253 = t151 * t2252;
  t2254 = t156 * t68;
  t2255 = t158 * t612;
  t2257 = t2253 * t2254 * t2255;
  t2258 = 0.2e1 * t2257;
  t2259 = t374 * t2255;
  t2264 = t153 * t1052;
  t2265 = t1050 * t2264;
  t2266 = t1058 * t792;
  t2267 = t1109 * t2266;
  t2269 = t368 * t799;
  t2270 = t391 * t2269;
  t2271 = t601 * t2270;
  t2272 = t799 * t153;
  t2274 = t151 * t2272 * t385;
  t2275 = t1579 * t618;
  t2278 = t1100 * t2231;
  t2281 = t2207 * t619;
  t2282 = 0.2e1 * t621 * t1651 - 0.3e1 * t2182 * t2278 - 0.2e1 * t2194 * t2275 - 0.2e1 * t621 * t2226 + 0.2e1 * t606 * t2259 - t2265 * t2267 + 0.3e1 * t2234 - 0.3e1 * t2240 + 0.3e1 * t2246 - 0.3e1 * t2250 - t2258 + t2271 - t2274 + t2281 - t801 - t803;
  t2284 = my_piecewise5(t58, 0, t61, 0, t2224 + t2282);
  t2286 = 0.8e2 / 0.243e3 * t2166 - 0.1e2 / 0.81e2 * t2169 + t149 * t809 + t53 * t2284;
  t2291 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t811 + t2164 + 0.3e1 / 0.2e2 * t7 * t32 * t2286);
  tv3rhosigma20 = t8 * t2291 + t815;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t2298 = t7 * t180 * t838 / 0.1e2;
  t2300 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t838 + t2298);
  tv3rhosigma25 = t8 * t2300 + t842;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t2306 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t811 + t2164);
  tv3rhosigma26 = t8 * t2306 + t815;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t2312 = t38 * t210 * t268;
  t2315 = t38 * t93 * t690;
  t2318 = t819 * t1432;
  t2319 = t1430 * t2318;
  t2320 = t548 * t222;
  t2321 = t1456 * t2320;
  t2324 = t571 * t675;
  t2325 = t570 * t2324;
  t2328 = t1507 * t222;
  t2329 = t1492 * t2328;
  t2332 = t1493 * t222;
  t2333 = t1492 * t2332;
  t2336 = t554 * t675;
  t2337 = t553 * t2336;
  t2340 = t538 * t2318;
  t2343 = t826 * t541;
  t2344 = t538 * t2343;
  t2345 = t2344 * t687;
  t2346 = t819 * t562;
  t2347 = t220 * t2346;
  t2349 = t553 * t681 * t224;
  t2350 = t2347 * t2349;
  t2354 = t819 * t224;
  t2355 = t538 * t2354;
  t2356 = t547 * t222;
  t2357 = t2356 * t562;
  t2358 = t570 * t2357;
  t2359 = t2355 * t2358;
  t2361 = t1481 * t686;
  t2364 = t220 * t2318;
  t2365 = t227 * t1093;
  t2367 = t1838 * t2365 * t222;
  t2372 = t220 * t2343;
  t2373 = t2372 * t671;
  t2375 = t538 * t2346 * t543;
  t2376 = params->csk_a * t222;
  t2377 = t2376 * t1407;
  t2378 = t2375 * t2377;
  t2380 = -0.3e1 * t2319 * t2321 - 0.2e1 * t2319 * t2329 + 0.3e1 * t2319 * t2333 + 0.3e1 * t2319 * t2361 - t2319 * t2367 + 0.3e1 * t2340 * t2321 - 0.2e1 * t684 * t2325 + 0.2e1 * t669 * t2337 - 0.2e1 * t684 * t2337 + 0.3e1 * t2340 * t2367 - t2364 * t2367 - t2345 + 0.3e1 * t2350 + 0.3e1 * t2359 + t2373 - 0.3e1 * t2378;
  t2381 = t2376 * t224;
  t2382 = t548 * t2381;
  t2383 = t2375 * t2382;
  t2386 = t220 * t2354 * t543;
  t2387 = t2376 * t562;
  t2388 = t228 * t2387;
  t2389 = t2386 * t2388;
  t2391 = t2344 * t671;
  t2393 = t222 * t112 * t227;
  t2394 = t1460 * t2393;
  t2399 = t2372 * t682;
  t2400 = t1838 * t681;
  t2403 = t1481 * t2356;
  t2408 = t222 * t1432;
  t2409 = t1430 * t2408;
  t2410 = t1438 * t819;
  t2411 = t1492 * t2410;
  t2413 = t547 * t826;
  t2414 = t570 * t2413;
  t2415 = t664 * t2414;
  t2418 = t220 * t826 * t222 * t564;
  t2419 = t265 * t562;
  t2420 = t220 * t2419;
  t2421 = t225 * t112;
  t2422 = t227 * t675;
  t2424 = t2420 * t2421 * t2422;
  t2425 = 0.2e1 * t2424;
  t2426 = t553 * t2422;
  t2429 = 0.2e1 * t684 * t1857 + 0.3e1 * t2340 * t2394 - 0.3e1 * t2340 * t2403 - 0.3e1 * t2364 * t2394 - 0.2e1 * t2364 * t2400 - t2409 * t2411 + 0.2e1 * t669 * t2426 - 0.3e1 * t2383 + 0.3e1 * t2389 - t2391 + t2399 + t2415 - t2418 - t2425 - t828 - t830;
  t2431 = my_piecewise5(t104, 0, t105, 0, t2380 + t2429);
  t2433 = 0.8e2 / 0.243e3 * t2312 - 0.1e2 / 0.81e2 * t2315 + t218 * t836 + t103 * t2431;
  t2438 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t838 + t2298 + 0.3e1 / 0.2e2 * t7 * t88 * t2433);
  tv3rhosigma211 = t8 * t2438 + t842;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t2445 = t7 * t135 * t866 / 0.1e2;
  t2451 = t38 * t141 * t284;
  t2454 = t38 * t43 * t729;
  t2457 = t1553 * t1054;
  t2458 = t1050 * t2457;
  t2459 = t281 * params->csk_a;
  t2460 = t2459 * t153;
  t2461 = t1059 * t2460;
  t2464 = t1898 * t1054;
  t2465 = t359 * t2464;
  t2466 = t1093 * t248;
  t2467 = t2466 * t153;
  t2468 = t369 * t2467;
  t2471 = t853 * t383;
  t2472 = t151 * t2471;
  t2473 = t2472 * t2217;
  t2475 = t369 * t2460;
  t2478 = t151 * t2464;
  t2479 = t159 * t2467;
  t2483 = t1050 * t2464;
  t2485 = t159 * t248;
  t2486 = t2238 * t2485;
  t2493 = t1059 * t2467;
  t2496 = t359 * t1625;
  t2497 = t721 * t383;
  t2498 = t369 * t2497;
  t2499 = t2496 * t2498;
  t2501 = t359 * t2471;
  t2503 = t1021 * t153 * t1023;
  t2504 = t2501 * t2503;
  t2506 = t159 * params->csk_a;
  t2507 = t615 * t383;
  t2508 = t2506 * t2507;
  t2509 = t1951 * t2508;
  t2511 = t391 * t368;
  t2512 = t2511 * t2248;
  t2513 = t2501 * t2512;
  t2515 = 0.3e1 * t2458 * t2461 + 0.3e1 * t2458 * t2475 + 0.3e1 * t2465 * t2468 + 0.3e1 * t2465 * t2479 + 0.3e1 * t2465 * t2486 - 0.3e1 * t2483 * t2468 - t2478 * t2479 - 0.3e1 * t2478 * t2486 - t2483 * t2479 - 0.2e1 * t2483 * t2493 + t2208 - t2210 - t2213 + 0.3e1 * t2473 + 0.3e1 * t2499 - 0.3e1 * t2504 + 0.3e1 * t2509 - 0.3e1 * t2513 - t801;
  t2520 = t1615 * t281;
  t2521 = t1109 * t2520;
  t2525 = t856 * t153;
  t2526 = t1579 * t2525;
  t2529 = t710 * t153;
  t2530 = t1100 * t2529;
  t2536 = t718 * t248;
  t2538 = t151 * t2536 * t385;
  t2541 = t151 * t281 * t612 * t385;
  t2543 = -0.3e1 * t1554 * t2530 + t1561 * t711 - t1903 * t851 - t1903 * t861 - 0.2e1 * t1910 * t2526 + t1942 * t851 + t1942 * t857 + t621 * t1972 + t714 * t2179 - t725 * t2179 - t725 * t2226 + t714 * t2259 - t2265 * t2521 + t2271 - t2274 + t2281 - t2538 - t2541 - t855;
  t2545 = my_piecewise5(t58, 0, t61, 0, t2515 + t2543);
  t2547 = -0.25e2 / 0.162e3 * t790 + 0.5e1 / 0.54e2 * t38 * t48 * t627 + 0.4e2 / 0.243e3 * t2451 - 0.5e1 / 0.81e2 * t2454 + t149 * t864 + t53 * t2545;
  t2552 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t866 + t2445 + 0.3e1 / 0.2e2 * t7 * t32 * t2547);
  tv3rhosigmalapl0 = t8 * t2552 + t870;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  t2559 = t7 * t180 * t894 / 0.1e2;
  t2561 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t894 + t2559);
  tv3rhosigmalapl5 = t8 * t2561 + t898;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  t2567 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t866 + t2445);
  tv3rhosigmalapl6 = t8 * t2567 + t870;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  t2577 = t38 * t210 * t300;
  t2580 = t38 * t93 * t780;
  t2583 = t1755 * t1434;
  t2584 = t1430 * t2583;
  t2585 = t297 * params->csk_a;
  t2586 = t2585 * t222;
  t2587 = t1439 * t2586;
  t2590 = t548 * t2586;
  t2593 = t2063 * t1434;
  t2594 = t220 * t2593;
  t2595 = t1093 * t265;
  t2596 = t2595 * t222;
  t2597 = t228 * t2596;
  t2599 = t538 * t2593;
  t2602 = t1430 * t2593;
  t2604 = t228 * t265;
  t2605 = t2376 * t2604;
  t2610 = t1439 * t2596;
  t2613 = t548 * t2596;
  t2616 = t881 * t562;
  t2617 = t220 * t2616;
  t2618 = t2617 * t2349;
  t2622 = t538 * t1820;
  t2624 = t548 * t772 * t562;
  t2625 = t2622 * t2624;
  t2627 = t538 * t2616;
  t2628 = t570 * t547;
  t2629 = t2628 * t2381;
  t2630 = t2627 * t2629;
  t2633 = t1405 * t222 * t1407;
  t2634 = t2627 * t2633;
  t2636 = t228 * params->csk_a;
  t2637 = t678 * t562;
  t2638 = t2636 * t2637;
  t2639 = t2116 * t2638;
  t2641 = t761 * t222;
  t2642 = t1481 * t2641;
  t2645 = -0.3e1 * t1756 * t2642 + 0.3e1 * t2584 * t2587 + 0.3e1 * t2584 * t2590 - t2594 * t2597 - 0.3e1 * t2594 * t2605 + 0.3e1 * t2599 * t2597 - t2602 * t2597 + 0.3e1 * t2599 * t2605 + 0.3e1 * t2599 * t2613 - 0.2e1 * t2602 * t2610 - 0.3e1 * t2602 * t2613 - t2345 + t2373 + 0.3e1 * t2618 + 0.3e1 * t2625 - 0.3e1 * t2630 - 0.3e1 * t2634 + 0.3e1 * t2639 - t828;
  t2652 = t1803 * t297;
  t2653 = t1492 * t2652;
  t2655 = t884 * t222;
  t2656 = t1838 * t2655;
  t2665 = t220 * t769 * t265 * t564;
  t2668 = t220 * t297 * t675 * t564;
  t2669 = t1752 * t762 - t2074 * t879 - t2074 * t889 - 0.2e1 * t2077 * t2656 + t2101 * t879 + t2101 * t885 + t684 * t2132 - t776 * t2325 + t765 * t2337 - t776 * t2337 - t2409 * t2653 + t765 * t2426 - t2391 + t2399 + t2415 - t2418 - t2665 - t2668 - t883;
  t2671 = my_piecewise5(t104, 0, t105, 0, t2645 + t2669);
  t2673 = -0.25e2 / 0.162e3 * t817 + 0.5e1 / 0.54e2 * t38 * t98 * t690 + 0.4e2 / 0.243e3 * t2577 - 0.5e1 / 0.81e2 * t2580 + t218 * t892 + t103 * t2671;
  t2678 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t894 + t2559 + 0.3e1 / 0.2e2 * t7 * t88 * t2673);
  tv3rhosigmalapl11 = t8 * t2678 + t898;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  tv3rhosigmatau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  tv3rhosigmatau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  tv3rhosigmatau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  tv3rhosigmatau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  t2685 = t7 * t135 * t917 / 0.1e2;
  t2691 = t902 * t383;
  t2693 = t359 * t2691 * t364;
  t2694 = t2693 * t2249;
  t2696 = t2693 * t2239;
  t2698 = t902 * t155;
  t2700 = t151 * t2698 * t364;
  t2701 = t2700 * t2245;
  t2703 = t902 * t1052;
  t2704 = t151 * t2703;
  t2706 = t359 * t2703;
  t2709 = t1050 * t2703;
  t2715 = t392 * t718;
  t2723 = -0.2e1 * t725 * t391 * t2715 + 0.3e1 * t2709 * t2175 - 0.2e1 * t2709 * t2188 - t2704 * t2196 + 0.3e1 * t2706 * t2196 - t2709 * t2196 - 0.3e1 * t2704 * t2203 + 0.3e1 * t2706 * t2203 + t2208 - t2210 - t2213 - 0.3e1 * t2694 - 0.3e1 * t2696 + 0.3e1 * t2701 - t801 - t909;
  t2724 = t375 * t718;
  t2725 = t374 * t2724;
  t2730 = t151 * t2691;
  t2731 = t2730 * t2217;
  t2737 = t359 * t2698;
  t2738 = t2737 * t2233;
  t2746 = t1058 * t902;
  t2747 = t1109 * t2746;
  t2749 = t281 * t383;
  t2750 = t151 * t2749;
  t2751 = t158 * t718;
  t2753 = t2750 * t2254 * t2751;
  t2754 = 0.2e1 * t2753;
  t2760 = 0.2e1 * t714 * t374 * t2751 + 0.2e1 * t725 * t1972 + 0.3e1 * t2706 * t2184 - 0.3e1 * t2709 * t2184 + 0.3e1 * t2709 * t2191 - t2265 * t2747 - 0.2e1 * t2704 * t2275 - 0.3e1 * t2706 * t2278 + 0.2e1 * t714 * t2725 - 0.2e1 * t725 * t2725 + t2271 - t2274 + t2281 + 0.3e1 * t2731 + 0.3e1 * t2738 - t2754;
  t2762 = my_piecewise5(t58, 0, t61, 0, t2723 + t2760);
  t2764 = -0.25e2 / 0.81e2 * t847 + 0.5e1 / 0.27e2 * t38 * t48 * t729 + t149 * t915 + t53 * t2762;
  t2769 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t917 + t2685 + 0.3e1 / 0.2e2 * t7 * t32 * t2764);
  tv3rholapl20 = t8 * t2769 + t921;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  t2776 = t7 * t180 * t940 / 0.1e2;
  t2778 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t940 + t2776);
  tv3rholapl22 = t8 * t2778 + t944;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  t2784 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t917 + t2685);
  tv3rholapl23 = t8 * t2784 + t921;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  t2794 = t925 * t562;
  t2796 = t538 * t2794 * t543;
  t2797 = t2796 * t2377;
  t2799 = t925 * t224;
  t2801 = t220 * t2799 * t543;
  t2802 = t2801 * t2388;
  t2804 = t2796 * t2382;
  t2806 = t925 * t1432;
  t2807 = t1430 * t2806;
  t2811 = t220 * t2806;
  t2813 = t538 * t2806;
  t2824 = t220 * t2794;
  t2825 = t2824 * t2349;
  t2827 = 0.3e1 * t2813 * t2321 - 0.2e1 * t2807 * t2329 + 0.3e1 * t2807 * t2361 - t2807 * t2367 - t2811 * t2367 + 0.3e1 * t2813 * t2367 - 0.3e1 * t2811 * t2394 + 0.3e1 * t2813 * t2394 - t2345 + t2373 - 0.3e1 * t2797 + 0.3e1 * t2802 - 0.3e1 * t2804 + 0.3e1 * t2825 - t828 - t932;
  t2828 = t228 * t769;
  t2829 = t1405 * t2828;
  t2834 = t571 * t769;
  t2838 = t538 * t2799;
  t2839 = t2838 * t2358;
  t2849 = t297 * t562;
  t2850 = t220 * t2849;
  t2851 = t227 * t769;
  t2853 = t2850 * t2421 * t2851;
  t2854 = 0.2e1 * t2853;
  t2860 = t1438 * t925;
  t2861 = t1492 * t2860;
  t2863 = -0.2e1 * t776 * t570 * t2834 + 0.2e1 * t765 * t553 * t2851 + 0.2e1 * t776 * t2132 - 0.3e1 * t2807 * t2321 + 0.3e1 * t2807 * t2333 - 0.2e1 * t2811 * t2400 - 0.3e1 * t2813 * t2403 - t2409 * t2861 + 0.2e1 * t765 * t2829 - 0.2e1 * t776 * t2829 - t2391 + t2399 + t2415 - t2418 + 0.3e1 * t2839 - t2854;
  t2865 = my_piecewise5(t104, 0, t105, 0, t2827 + t2863);
  t2867 = -0.25e2 / 0.81e2 * t875 + 0.5e1 / 0.27e2 * t38 * t98 * t780 + t218 * t938 + t103 * t2865;
  t2872 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t940 + t2776 + 0.3e1 / 0.2e2 * t7 * t88 * t2867);
  tv3rholapl25 = t8 * t2872 + t944;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  tv3rhotau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  tv3rhotau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  tv3rhotau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  tv3rhotau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t2875 = t38 * t43 * t809;
  t2877 = t792 * t248;
  t2886 = t2877 * t383;
  t2887 = t359 * t2886;
  t2888 = t2887 * t1041;
  t2889 = 0.3e1 * t2888;
  t2890 = t2209 * t851;
  t2891 = 0.3e1 * t2890;
  t2892 = t2887 * t1024;
  t2893 = 0.3e1 * t2892;
  t2894 = t2877 * t155;
  t2896 = t151 * t2894 * t1030;
  t2897 = 0.3e1 * t2896;
  t2898 = t375 * t799;
  t2899 = t374 * t2898;
  t2900 = t606 * t2899;
  t2901 = 0.3e1 * t2900;
  t2902 = t2209 * t861;
  t2903 = 0.3e1 * t2902;
  t2904 = t2877 * t1052;
  t2905 = t1050 * t2904;
  t2910 = -t1050 * t2877 * t1060 - 0.2e1 * t151 * t2877 * t1063 - 0.3e1 * t359 * t2877 * t1067 - 0.3e1 * t2905 * t1115 - 0.2e1 * t2905 * t1125 - t2889 - t2891 - t2893 + t2897 + t2901 - t2903 - t801 - t803;
  t2912 = t359 * t2894 * t1090;
  t2913 = 0.3e1 * t2912;
  t2914 = t2207 * t857;
  t2915 = 0.3e1 * t2914;
  t2916 = t151 * t2886;
  t2917 = t2916 * t1085;
  t2918 = 0.3e1 * t2917;
  t2919 = t359 * t2904;
  t2922 = t799 * t248;
  t2924 = t151 * t2922 * t385;
  t2925 = 0.3e1 * t2924;
  t2926 = t621 * t2270;
  t2927 = 0.3e1 * t2926;
  t2932 = t151 * t2904;
  t2941 = 0.3e1 * t2919 * t1073 - 0.3e1 * t2932 * t1073 - t2905 * t1095 + 0.3e1 * t2919 * t1095 - t2932 * t1095 + 0.3e1 * t2905 * t1101 + 0.3e1 * t2905 * t1111 + 0.3e1 * t2919 * t1115 + t2913 + t2915 + t2918 - t2925 + t2927;
  t2943 = my_piecewise5(t58, 0, t61, 0, t2910 + t2941);
  t2945 = -0.5e1 / 0.27e2 * t2875 + t53 * t2943;
  t2949 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t2945);
  tv3sigma30 = t8 * t2949;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t2951 = t38 * t93 * t836;
  t2953 = t819 * t265;
  t2962 = t2344 * t879;
  t2963 = 0.3e1 * t2962;
  t2964 = t2953 * t562;
  t2965 = t538 * t2964;
  t2966 = t2965 * t1408;
  t2967 = 0.3e1 * t2966;
  t2968 = t2953 * t224;
  t2970 = t220 * t2968 * t1414;
  t2971 = 0.3e1 * t2970;
  t2972 = t554 * t826;
  t2973 = t553 * t2972;
  t2974 = t669 * t2973;
  t2975 = 0.3e1 * t2974;
  t2976 = t2344 * t889;
  t2977 = 0.3e1 * t2976;
  t2978 = t2965 * t1425;
  t2979 = 0.3e1 * t2978;
  t2980 = t2953 * t1432;
  t2981 = t220 * t2980;
  t2984 = t826 * t265;
  t2986 = t220 * t2984 * t564;
  t2987 = 0.3e1 * t2986;
  t2988 = -t1430 * t2953 * t1440 - 0.2e1 * t220 * t2953 * t1447 - 0.3e1 * t538 * t2953 * t1451 - 0.3e1 * t2981 * t1461 - t2963 - t2967 + t2971 + t2975 - t2977 - t2979 - t2987 - t828 - t830;
  t2989 = t1430 * t2980;
  t2994 = t684 * t2414;
  t2995 = 0.3e1 * t2994;
  t2998 = t538 * t2980;
  t3002 = t538 * t2968 * t1470;
  t3003 = 0.3e1 * t3002;
  t3004 = t2372 * t885;
  t3005 = 0.3e1 * t3004;
  t3006 = t220 * t2964;
  t3007 = t3006 * t1478;
  t3008 = 0.3e1 * t3007;
  t3017 = -t2981 * t1457 - t2989 * t1457 + 0.3e1 * t2998 * t1457 + 0.3e1 * t2998 * t1461 + 0.3e1 * t2989 * t1482 + 0.3e1 * t2989 * t1494 - 0.3e1 * t2989 * t1498 + 0.3e1 * t2998 * t1498 - 0.2e1 * t2989 * t1508 + t2995 + t3003 + t3005 + t3008;
  t3019 = my_piecewise5(t104, 0, t105, 0, t2988 + t3017);
  t3021 = -0.5e1 / 0.27e2 * t2951 + t103 * t3019;
  t3025 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3021);
  tv3sigma39 = t8 * t3025;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t3030 = t38 * t43 * t864;
  t3032 = t281 * t792;
  t3033 = t3032 * t383;
  t3034 = t359 * t3033;
  t3035 = t3034 * t1041;
  t3036 = 0.3e1 * t3035;
  t3037 = t3034 * t1024;
  t3038 = 0.3e1 * t3037;
  t3040 = t792 * t68 * t158;
  t3041 = t1072 * t3040;
  t3048 = t1580 * t792;
  t3049 = t1579 * t3048;
  t3054 = t2230 * t1914;
  t3055 = 0.3e1 * t3054;
  t3056 = t151 * t3032;
  t3057 = t3056 * t1570;
  t3058 = 0.3e1 * t3057;
  t3059 = t725 * t2899;
  t3061 = t792 * t366 * t368;
  t3062 = t1094 * t3061;
  t3065 = t392 * t799;
  t3066 = t391 * t3065;
  t3067 = t725 * t3066;
  t3068 = t1124 * t792;
  t3069 = t1109 * t3068;
  t3074 = 0.3e1 * t1899 * t3041 + 0.3e1 * t1899 * t3049 - 0.3e1 * t1910 * t3041 - t1910 * t3049 + 0.3e1 * t2173 * t1922 - t1928 * t3049 - 0.3e1 * t1928 * t3062 - 0.2e1 * t1928 * t3069 + 0.3e1 * t2173 * t1939 - t3036 - t3038 + t3055 + t3058 - t3059 - t3067 - t801;
  t3075 = t714 * t2899;
  t3078 = 0.2e1 * t2890;
  t3079 = 0.2e1 * t2900;
  t3080 = 0.2e1 * t2902;
  t3082 = params->csk_a * t792 * t383;
  t3083 = t159 * t3082;
  t3084 = t1951 * t3083;
  t3085 = 0.3e1 * t3084;
  t3086 = 0.2e1 * t2914;
  t3087 = 0.2e1 * t2924;
  t3088 = 0.2e1 * t2926;
  t3091 = t158 * t792;
  t3092 = t1579 * t3091;
  t3095 = t2209 * t711;
  t3097 = t281 * t799;
  t3099 = t151 * t3097 * t385;
  t3100 = t158 * t799;
  t3101 = t374 * t3100;
  t3102 = t714 * t3101;
  t3103 = 0.3e1 * t1899 * t3062 - 0.2e1 * t1910 * t3092 - 0.3e1 * t2182 * t1963 - t2173 * t1975 + t3075 - t3078 + t3079 - t3080 + t3085 + t3086 - t3087 + t3088 + t3095 - t3099 + t3102 - t855;
  t3105 = my_piecewise5(t58, 0, t61, 0, t3074 + t3103);
  t3107 = 0.5e1 / 0.54e2 * t38 * t48 * t809 - 0.1e2 / 0.81e2 * t3030 + t53 * t3105;
  t3111 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3107);
  tv3sigma2lapl0 = t8 * t3111;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  t3116 = t38 * t93 * t892;
  t3118 = t297 * t819;
  t3119 = t3118 * t562;
  t3120 = t538 * t3119;
  t3121 = t3120 * t1408;
  t3122 = 0.3e1 * t3121;
  t3124 = params->csk_a * t819 * t562;
  t3125 = t228 * t3124;
  t3126 = t2116 * t3125;
  t3127 = 0.3e1 * t3126;
  t3129 = t819 * t112 * t227;
  t3130 = t1456 * t3129;
  t3132 = t776 * t2973;
  t3134 = t819 * t545 * t547;
  t3135 = t1456 * t3134;
  t3138 = t571 * t826;
  t3139 = t570 * t3138;
  t3140 = t776 * t3139;
  t3141 = t1507 * t819;
  t3142 = t1492 * t3141;
  t3147 = t765 * t2973;
  t3150 = t1460 * t3129;
  t3160 = -t2064 * t3130 - 0.3e1 * t2064 * t3135 - 0.2e1 * t2064 * t3142 + 0.3e1 * t2070 * t3130 + 0.3e1 * t2070 * t3135 + 0.3e1 * t2070 * t3150 - t2077 * t3130 - 0.3e1 * t2077 * t3150 + 0.3e1 * t2319 * t2092 + 0.3e1 * t2319 * t2098 - t3122 + t3127 - t3132 - t3140 + t3147 - t828;
  t3161 = t2355 * t2085;
  t3162 = 0.3e1 * t3161;
  t3163 = t220 * t3118;
  t3164 = t3163 * t1776;
  t3165 = 0.3e1 * t3164;
  t3166 = 0.2e1 * t2962;
  t3167 = 0.2e1 * t2974;
  t3168 = 0.2e1 * t2976;
  t3169 = t3120 * t1425;
  t3170 = 0.3e1 * t3169;
  t3171 = 0.2e1 * t2986;
  t3172 = 0.2e1 * t2994;
  t3173 = 0.2e1 * t3004;
  t3176 = t227 * t819;
  t3177 = t1838 * t3176;
  t3180 = t2344 * t762;
  t3182 = t297 * t826;
  t3184 = t220 * t3182 * t564;
  t3185 = t227 * t826;
  t3186 = t553 * t3185;
  t3187 = t765 * t3186;
  t3188 = -0.2e1 * t2077 * t3177 - t2319 * t2135 - 0.3e1 * t2340 * t2141 + t3162 + t3165 - t3166 + t3167 - t3168 - t3170 - t3171 + t3172 + t3173 + t3180 - t3184 + t3187 - t883;
  t3190 = my_piecewise5(t104, 0, t105, 0, t3160 + t3188);
  t3192 = 0.5e1 / 0.54e2 * t38 * t98 * t836 - 0.1e2 / 0.81e2 * t3116 + t103 * t3190;
  t3196 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3192);
  tv3sigma2lapl11 = t8 * t3196;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  tv3sigma2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  tv3sigma2tau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  t3201 = t38 * t43 * t915;
  t3203 = params->csk_a * t248;
  t3205 = t2693 * t3203 * t1023;
  t3206 = 0.3e1 * t3205;
  t3207 = t3203 * t383;
  t3209 = t2700 * t159 * t3207;
  t3210 = 0.3e1 * t3209;
  t3211 = t3203 * t155;
  t3213 = t2693 * t369 * t3211;
  t3214 = 0.3e1 * t3213;
  t3217 = t1580 * t248;
  t3218 = t1579 * t3217;
  t3223 = t1072 * t2485;
  t3226 = t369 * t248;
  t3227 = t1094 * t3226;
  t3230 = t1124 * t248;
  t3234 = t2737 * t1576;
  t3235 = 0.3e1 * t3234;
  t3242 = t2730 * t374 * t856 * t155;
  t3243 = 0.3e1 * t3242;
  t3244 = -0.2e1 * t2709 * t1109 * t3230 + 0.3e1 * t2709 * t1590 + 0.3e1 * t2709 * t1617 - t2704 * t3218 + 0.3e1 * t2706 * t3218 + 0.3e1 * t2706 * t3223 + 0.3e1 * t2706 * t3227 - t2709 * t3218 - 0.3e1 * t2709 * t3227 - t3206 + t3210 - t3214 + t3235 + t3243 - t801 - t909;
  t3247 = 0.2e1 * t3059;
  t3248 = 0.2e1 * t3067;
  t3249 = 0.2e1 * t3075;
  t3250 = 0.2e1 * t3095;
  t3251 = 0.2e1 * t3099;
  t3252 = 0.2e1 * t3102;
  t3259 = -0.2e1 * t2704 * t1579 * t856 - t1586 * t2747 - 0.3e1 * t2706 * t1644 - 0.3e1 * t2704 * t3223 - t2890 + t2900 - t2902 + t2914 - t2924 + t2926 - t3247 - t3248 + t3249 + t3250 - t3251 + t3252;
  t3261 = my_piecewise5(t58, 0, t61, 0, t3244 + t3259);
  t3263 = 0.5e1 / 0.27e2 * t38 * t48 * t864 - 0.5e1 / 0.81e2 * t3201 + t53 * t3261;
  t3267 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3263);
  tv3sigmalapl20 = t8 * t3267;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  t3272 = t38 * t93 * t938;
  t3274 = params->csk_a * t265;
  t3275 = t3274 * t562;
  t3276 = t228 * t3275;
  t3277 = t2801 * t3276;
  t3278 = 0.3e1 * t3277;
  t3279 = t3274 * t224;
  t3281 = t2796 * t548 * t3279;
  t3282 = 0.3e1 * t3281;
  t3284 = t2796 * t3274 * t1407;
  t3285 = 0.3e1 * t3284;
  t3288 = t2365 * t265;
  t3289 = t1838 * t3288;
  t3294 = t1460 * t2604;
  t3297 = t548 * t265;
  t3298 = t1456 * t3297;
  t3301 = t1507 * t265;
  t3305 = t2838 * t1770;
  t3306 = 0.3e1 * t3305;
  t3313 = t2824 * t553 * t884 * t224;
  t3314 = 0.3e1 * t3313;
  t3315 = -0.2e1 * t2807 * t1492 * t3301 + 0.3e1 * t2807 * t1784 + 0.3e1 * t2807 * t1805 - t2807 * t3289 - 0.3e1 * t2807 * t3298 - t2811 * t3289 + 0.3e1 * t2813 * t3289 + 0.3e1 * t2813 * t3294 + 0.3e1 * t2813 * t3298 + t3278 - t3282 - t3285 + t3306 + t3314 - t828 - t932;
  t3318 = 0.2e1 * t3132;
  t3319 = 0.2e1 * t3140;
  t3320 = 0.2e1 * t3147;
  t3321 = 0.2e1 * t3180;
  t3322 = 0.2e1 * t3184;
  t3323 = 0.2e1 * t3187;
  t3330 = -0.2e1 * t2811 * t1838 * t884 - t1779 * t2861 - 0.3e1 * t2813 * t1835 - 0.3e1 * t2811 * t3294 - t2962 + t2974 - t2976 - t2986 + t2994 + t3004 - t3318 - t3319 + t3320 + t3321 - t3322 + t3323;
  t3332 = my_piecewise5(t104, 0, t105, 0, t3315 + t3330);
  t3334 = 0.5e1 / 0.27e2 * t38 * t98 * t892 - 0.5e1 / 0.81e2 * t3272 + t103 * t3332;
  t3338 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3334);
  tv3sigmalapl28 = t8 * t3338;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  tv3sigmatau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  tv3sigmatau28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  t3342 = t902 * t281;
  t3351 = t3342 * t155;
  t3353 = t151 * t3351 * t1030;
  t3354 = 0.3e1 * t3353;
  t3355 = t3342 * t383;
  t3356 = t359 * t3355;
  t3357 = t3356 * t1024;
  t3358 = 0.3e1 * t3357;
  t3359 = t3356 * t1041;
  t3360 = 0.3e1 * t3359;
  t3361 = 0.3e1 * t3059;
  t3362 = 0.3e1 * t3067;
  t3363 = 0.3e1 * t3075;
  t3364 = 0.3e1 * t3095;
  t3365 = 0.3e1 * t3099;
  t3366 = -t1050 * t3342 * t1060 - 0.2e1 * t151 * t3342 * t1063 - 0.3e1 * t359 * t3342 * t1067 + t3354 - t3358 - t3360 - t3361 - t3362 + t3363 + t3364 - t3365 - t801 - t909;
  t3367 = 0.3e1 * t3102;
  t3369 = t359 * t3351 * t1090;
  t3370 = 0.3e1 * t3369;
  t3372 = t151 * t3355 * t1085;
  t3373 = 0.3e1 * t3372;
  t3374 = t3342 * t1052;
  t3375 = t151 * t3374;
  t3378 = t1050 * t3374;
  t3385 = t359 * t3374;
  t3396 = -0.3e1 * t3375 * t1073 + 0.3e1 * t3385 * t1073 - t3375 * t1095 - t3378 * t1095 + 0.3e1 * t3385 * t1095 + 0.3e1 * t3378 * t1101 + 0.3e1 * t3378 * t1111 - 0.3e1 * t3378 * t1115 + 0.3e1 * t3385 * t1115 - 0.2e1 * t3378 * t1125 + t3367 + t3370 + t3373;
  t3398 = my_piecewise5(t58, 0, t61, 0, t3366 + t3396);
  t3400 = 0.5e1 / 0.18e2 * t38 * t48 * t915 + t53 * t3398;
  t3404 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * t3400);
  tv3lapl30 = t8 * t3404;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  t3408 = t925 * t297;
  t3417 = t3408 * t562;
  t3418 = t538 * t3417;
  t3419 = t3418 * t1408;
  t3420 = 0.3e1 * t3419;
  t3421 = t3418 * t1425;
  t3422 = 0.3e1 * t3421;
  t3423 = t3408 * t224;
  t3425 = t220 * t3423 * t1414;
  t3426 = 0.3e1 * t3425;
  t3427 = 0.3e1 * t3132;
  t3428 = 0.3e1 * t3140;
  t3429 = 0.3e1 * t3147;
  t3430 = 0.3e1 * t3180;
  t3431 = 0.3e1 * t3184;
  t3432 = -t1430 * t3408 * t1440 - 0.2e1 * t220 * t3408 * t1447 - 0.3e1 * t538 * t3408 * t1451 - t3420 - t3422 + t3426 - t3427 - t3428 + t3429 + t3430 - t3431 - t828 - t932;
  t3433 = 0.3e1 * t3187;
  t3434 = t3408 * t1432;
  t3435 = t538 * t3434;
  t3438 = t220 * t3417;
  t3439 = t3438 * t1478;
  t3440 = 0.3e1 * t3439;
  t3442 = t538 * t3423 * t1470;
  t3443 = 0.3e1 * t3442;
  t3444 = t220 * t3434;
  t3447 = t1430 * t3434;
  t3462 = 0.3e1 * t3435 * t1457 - t3444 * t1457 - t3447 * t1457 + 0.3e1 * t3435 * t1461 - 0.3e1 * t3444 * t1461 + 0.3e1 * t3447 * t1482 + 0.3e1 * t3447 * t1494 + 0.3e1 * t3435 * t1498 - 0.3e1 * t3447 * t1498 - 0.2e1 * t3447 * t1508 + t3433 + t3440 + t3443;
  t3464 = my_piecewise5(t104, 0, t105, 0, t3432 + t3462);
  t3466 = 0.5e1 / 0.18e2 * t38 * t98 * t938 + t103 * t3464;
  t3470 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * t3466);
  tv3lapl33 = t8 * t3470;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  tv3tau30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  tv3tau33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t3475 = t7 * t964 * t134 * t73;
  t3479 = t7 * t322 * t335 * t73;
  t3483 = t7 * t129 * t987 * t73;
  t3486 = 0.1e1 / t30 / t313;
  t3490 = 0.14e2 / 0.135e3 * t7 * t29 * t3486 * t73;
  t3495 = t7 * t988 * t164;
  t3498 = t7 * t336 * t398;
  t3501 = t7 * t135 * t1132;
  t3507 = t38 * sigma[0] / t41 / t343 / t39;
  t3513 = 0.154e5 / 0.2187e4 * t38 * lapl[0] * t1000 - 0.10472e6 / 0.6561e4 * t3507;
  t3524 = t379 * t379;
  t3528 = t151 * t3524;
  t3531 = t379 * t155;
  t3533 = t359 * t3531 * t364;
  t3534 = t369 * t1628;
  t3541 = params->csk_a * t383;
  t3543 = t159 * t3541 * t379;
  t3546 = t360 * t360;
  t3547 = t3546 * t383;
  t3548 = t359 * t3547;
  t3550 = t362 * t68 * t158;
  t3551 = t1072 * t3550;
  t3555 = t3546 * t362;
  t3556 = t151 * t3555;
  t3560 = t379 * t1052;
  t3561 = t359 * t3560;
  t3566 = t1050 * t3560;
  t3569 = t1094 * t3550;
  t3572 = t1050 * t3547;
  t3576 = t1579 * t1580 * t383;
  t3579 = t151 * t1588;
  t3581 = t1579 * t1580 * t379;
  t3584 = t1058 * t379;
  t3586 = t1109 * t3584 * params->csk_a;
  t3592 = t362 * t366 * t368;
  t3593 = t1094 * t3592;
  t3596 = -0.18e2 * t3556 * t1579 * t1029 + 0.18e2 * t3561 * t1557 + 0.18e2 * t3561 * t1582 - 0.6e1 * t3566 * t1582 + 0.18e2 * t1589 * t3586 - 0.12e2 * t3566 * t1602 + 0.18e2 * t3548 * t3569 - 0.6e1 * t3556 * t3576 - 0.6e1 * t3572 * t3569 - 0.18e2 * t3572 * t3593 - 0.6e1 * t3579 * t3581;
  t3598 = t359 * t3555;
  t3600 = t1100 * t1114 * t383;
  t3603 = t1579 * t1034;
  t3606 = t1045 * t362;
  t3607 = t359 * t3606;
  t3612 = t1100 * t1598;
  t3617 = t1050 * t3555;
  t3619 = t1100 * t1089 * params->csk_a;
  t3627 = t151 * t3606;
  t3630 = t1058 * t383;
  t3632 = t1109 * t3630 * params->csk_a;
  t3637 = t1109 * t1124 * t362;
  t3641 = t391 * t1089 * t379;
  t3645 = t1100 * t1114 * t379;
  t3650 = t151 * t3546;
  t3651 = t383 * t383;
  t3652 = t3651 * t364;
  t3653 = t3652 * t159;
  t3656 = t362 * t362;
  t3657 = t363 * t363;
  t3658 = 0.1e1 / t3657;
  t3659 = t3656 * t3658;
  t3660 = t3659 * t159;
  t3663 = t359 * t3546;
  t3664 = t3652 * t369;
  t3668 = t3659 * t1059;
  t3671 = my_piecewise3(t61, 0, t3513);
  t3672 = my_piecewise3(t63, t3671, 0);
  t3675 = t357 * t357;
  t3677 = t70 / t3675;
  t3679 = t366 * t366;
  t3680 = t367 * t367;
  t3681 = 0.1e1 / t3680;
  t3682 = t3679 * t3681;
  t3683 = t3659 * t3682;
  t3685 = t3659 * t369;
  t3688 = 0.6e1 * t1050 * t3546 * t3668 - t151 * t3672 * t160 + t3677 * t3546 * t3683 + 0.18e2 * t1574 * t3641 + 0.18e2 * t1643 * t3645 + 0.3e1 * t3528 * t387 - 0.12e2 * t3572 * t3637 + 0.3e1 * t3650 * t3653 + 0.6e1 * t3650 * t3660 + 0.3e1 * t3663 * t3664 + 0.11e2 * t3663 * t3685;
  t3694 = t3546 * t3656;
  t3695 = t1050 * t3694;
  t3696 = t3658 * t1056;
  t3697 = t1093 * params->csk_a;
  t3698 = t1058 * t3697;
  t3699 = t3696 * t3698;
  t3702 = t3677 * t3694;
  t3705 = t3658 * t3679;
  t3706 = t3681 * t3697;
  t3707 = t3705 * t3706;
  t3710 = t3658 * t3697;
  t3711 = t3710 * t369;
  t3714 = t3658 * t366;
  t3715 = t3714 * t1114;
  t3720 = t3696 * t1124;
  t3724 = t359 * t3694;
  t3728 = t3705 * t3681 * t1093;
  t3731 = t1100 * t1105;
  t3734 = t1100 * t1089;
  t3737 = t3714 * t392;
  t3755 = t3681 * params->csk_a;
  t3756 = t3705 * t3755;
  t3759 = -0.4e1 * t151 * t1045 * t153 * t385 + 0.4e1 * t601 * t391 * t368 * t1045 - 0.6e1 * t1589 * t1109 * t3584 - 0.18e2 * t1643 * t3731 - 0.18e2 * t3598 * t3734 - 0.18e2 * t3695 * t3737 + 0.11e2 * t3702 * t3728 - 0.6e1 * t3702 * t3756 - 0.7e1 * t3724 * t3711 - 0.11e2 * t3724 * t3715 + 0.7e1 * t3724 * t3737;
  t3761 = t3696 * t1110;
  t3764 = t3524 * t362;
  t3768 = t359 * t3764;
  t3773 = t1109 * t3630;
  t3778 = t3546 * t3651;
  t3779 = t359 * t3778;
  t3782 = t151 * t3694;
  t3783 = t3658 * t68;
  t3784 = t3783 * t375;
  t3791 = t158 * t362;
  t3792 = t1579 * t3791;
  t3797 = -0.12e2 * t151 * t3560 * t1640 - 0.12e2 * t151 * t3547 * t3792 + 0.3e1 * t151 * t3764 * t376 - 0.6e1 * t3617 * t3773 + 0.4e1 * t3627 * t619 - 0.12e2 * t3695 * t3761 - 0.3e1 * t3768 * t376 - 0.3e1 * t3779 * t376 - 0.3e1 * t3768 * t393 - 0.3e1 * t3779 * t393 + 0.11e2 * t3782 * t3784;
  t3803 = t3710 * t159;
  t3812 = t3658 * t1093;
  t3813 = t3812 * t159;
  t3822 = 0.3e1 * t151 * t3778 * t376 - 0.6e1 * t3695 * t3720 + 0.6e1 * t3695 * t3803 + 0.6e1 * t3695 * t3813 - 0.6e1 * t3702 * t3761 - t3702 * t3803 - 0.11e2 * t3724 * t3784 - 0.7e1 * t3724 * t3803 - 0.18e2 * t3724 * t3813 + t3782 * t3803 + 0.6e1 * t3782 * t3813;
  t3826 = my_piecewise5(t58, 0, t61, 0, -0.4e1 * t1025 + 0.4e1 * t1031 - 0.4e1 * t1042 + 0.4e1 * t1086 + 0.4e1 * t1091 - 0.5e1 * t1120 + t3822 + t3797 + t3759 + t3688 - t386 + t3596 + 0.4e1 * t3627 * t608 + 0.18e2 * t3598 * t3600 - 0.18e2 * t3579 * t3603 - 0.4e1 * t3607 * t624 - 0.4e1 * t3607 * t608 + 0.18e2 * t3548 * t3551 - 0.3e1 * t3528 * t385 - 0.18e2 * t3533 * t3534 - 0.18e2 * t3533 * t1629 + 0.7e1 * t3702 * t3715 - 0.7e1 * t3702 * t3711 + 0.18e2 * t3702 * t3720 + 0.12e2 * t3695 * t3699 - 0.12e2 * t3702 * t3699 - 0.6e1 * t3702 * t3707 + 0.18e2 * t3695 * t3711 + 0.18e2 * t3617 * t3632 + 0.18e2 * t1589 * t3612 - 0.18e2 * t3566 * t1595 + 0.18e2 * t3617 * t3619 + 0.18e2 * t151 * t3531 * t374 * t1639 * t383 + 0.18e2 * t151 * t1573 * t364 * t3543 + 0.3e1 * t359 * t3524 * t370);
  t3832 = t21 * t21;
  t3834 = 0.1e1 / t26 / t3832;
  t3835 = t310 * t310;
  t3841 = t318 * t318;
  t3847 = 0.1e1 / t955 / t8;
  t3848 = t18 * t3847;
  t3851 = my_piecewise5(t12, 0, t16, 0, -0.24e2 * t956 + 0.24e2 * t3848);
  t3855 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3834 * t3835 - 0.2e2 / 0.9e1 * t948 * t310 * t318 + 0.1e2 / 0.3e1 * t309 * t3841 + 0.4e2 / 0.9e1 * t952 * t960 + 0.5e1 / 0.3e1 * t27 * t3851);
  t3864 = t7 * t969 * t164;
  t3870 = t7 * t976 * t164;
  t3873 = t7 * t327 * t398;
  t3875 = 0.2e1 / 0.5e1 * t3475 - t3479 / 0.5e1 + 0.8e1 / 0.45e2 * t3483 - t3490 + 0.3e1 / 0.5e1 * t7 * t130 * t1132 + 0.8e1 / 0.45e2 * t3495 - t3498 / 0.5e1 + 0.2e1 / 0.5e1 * t3501 + 0.3e1 / 0.2e2 * t7 * t32 * (0.1309e5 / 0.729e3 * t3507 + t3513 * t71 + 0.4e1 * t1008 * t162 + 0.6e1 * t353 * t396 + 0.4e1 * t149 * t1130 + t53 * t3826) + 0.3e1 / 0.2e2 * t7 * t3855 * t31 * t73 + 0.3e1 / 0.5e1 * t7 * t965 * t164 + 0.6e1 / 0.5e1 * t3864 + 0.9e1 / 0.1e2 * t7 * t323 * t398 - 0.2e1 / 0.5e1 * t3870 + 0.6e1 / 0.5e1 * t3873;
  t3876 = my_piecewise3(t2, 0, t3875);
  t3877 = t82 * t82;
  t3879 = 0.1e1 / t84 / t3877;
  t3880 = t405 * t405;
  t3886 = t411 * t411;
  t3891 = t79 * t3847;
  t3894 = my_piecewise5(t16, 0, t12, 0, 0.24e2 * t956 + 0.24e2 * t3891);
  t3898 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3879 * t3880 - 0.2e2 / 0.9e1 * t1139 * t405 * t411 + 0.1e2 / 0.3e1 * t404 * t3886 + 0.4e2 / 0.9e1 * t1143 * t1149 + 0.5e1 / 0.3e1 * t85 * t3894);
  t3905 = t7 * t1153 * t134 * t117;
  t3909 = t7 * t415 * t335 * t117;
  t3913 = t7 * t175 * t987 * t117;
  t3918 = 0.14e2 / 0.135e3 * t7 * t87 * t3486 * t117;
  t3920 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t3898 * t31 * t117 + 0.2e1 / 0.5e1 * t3905 - t3909 / 0.5e1 + 0.8e1 / 0.45e2 * t3913 - t3918);
  tv4rho40 = 0.4e1 * t1137 + 0.4e1 * t1171 + t8 * (t3876 + t3920);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t3927 = t7 * t1191 * t134 * t73;
  t3931 = t7 * t440 * t335 * t73;
  t3932 = t3931 / 0.1e2;
  t3935 = t7 * t192 * t987 * t73;
  t3956 = 0.12e2 * t956;
  t3957 = 0.24e2 * t3848;
  t3959 = my_piecewise5(t12, 0, t16, 0, -t3956 + t3957);
  t3963 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3834 * t189 * t949 - 0.1e2 / 0.9e1 * t948 * t436 * t310 - 0.1e2 / 0.9e1 * t1176 * t126 * t318 + 0.1e2 / 0.3e1 * t309 * t1187 * t126 + 0.1e2 / 0.3e1 * t1179 * t318 + 0.1e2 / 0.9e1 * t432 * t960 + 0.5e1 / 0.3e1 * t27 * t3959);
  t3972 = t7 * t1196 * t164;
  t3978 = t7 * t1203 * t164;
  t3979 = t3978 / 0.1e2;
  t3981 = t7 * t445 * t398;
  t3992 = 0.3e1 / 0.1e2 * t3927 - t3932 + 0.2e1 / 0.45e2 * t3935 + t3475 / 0.1e2 - t3479 / 0.1e2 + 0.2e1 / 0.15e2 * t3483 - t3490 + 0.3e1 / 0.2e2 * t7 * t3963 * t31 * t73 + 0.9e1 / 0.2e2 * t7 * t1192 * t164 + 0.3e1 / 0.5e1 * t3972 + 0.9e1 / 0.2e2 * t7 * t441 * t398 - t3979 + 0.3e1 / 0.1e2 * t3981 + 0.3e1 / 0.2e2 * t7 * t193 * t1132 + 0.2e1 / 0.15e2 * t3495 - t3498 / 0.1e2 + t3501 / 0.1e2 + 0.3e1 / 0.1e2 * t3864 - t3870 / 0.5e1 + 0.3e1 / 0.1e2 * t3873;
  t3993 = my_piecewise3(t2, 0, t3992);
  t4010 = 0.24e2 * t3891;
  t4012 = my_piecewise5(t16, 0, t12, 0, t3956 + t4010);
  t4016 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3879 * t200 * t1140 - 0.1e2 / 0.9e1 * t1139 * t460 * t405 - 0.1e2 / 0.9e1 * t1220 * t172 * t411 + 0.1e2 / 0.3e1 * t404 * t1230 * t172 + 0.1e2 / 0.3e1 * t1223 * t411 + 0.1e2 / 0.9e1 * t456 * t1149 + 0.5e1 / 0.3e1 * t85 * t4012);
  t4023 = t7 * t1234 * t134 * t117;
  t4027 = t7 * t464 * t335 * t117;
  t4028 = t4027 / 0.1e2;
  t4031 = t7 * t203 * t987 * t117;
  t4040 = t7 * t1158 * t233;
  t4043 = t7 * t1162 * t233;
  t4044 = t4043 / 0.1e2;
  t4046 = t7 * t1166 * t233;
  t4048 = 0.3e1 / 0.2e2 * t7 * t4016 * t31 * t117 + 0.3e1 / 0.1e2 * t4023 - t4028 + 0.2e1 / 0.45e2 * t4031 + t3905 / 0.1e2 - t3909 / 0.1e2 + 0.2e1 / 0.15e2 * t3913 - t3918 + 0.3e1 / 0.2e2 * t7 * t1154 * t233 + 0.3e1 / 0.1e2 * t4040 - t4044 + 0.2e1 / 0.45e2 * t4046;
  t4049 = my_piecewise3(t78, 0, t4048);
  tv4rho41 = t1137 + t1171 + 0.3e1 * t1219 + 0.3e1 * t1259 + t8 * (t3993 + t4049);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t4058 = t7 * t1275 * t134 * t73;
  t4062 = t7 * t495 * t335 * t73;
  t4077 = t436 * t436;
  t4090 = my_piecewise5(t12, 0, t16, 0, t3957);
  t4094 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3834 * t486 * t310 - 0.4e2 / 0.27e2 * t1176 * t126 * t436 - 0.1e2 / 0.27e2 * t1262 * t318 + 0.2e2 / 0.9e1 * t309 * t4077 + 0.2e2 / 0.9e1 * t432 * t1187 - 0.1e2 / 0.27e2 * t948 * t491 * t310 + 0.2e2 / 0.9e1 * t309 * t1271 * t126 + 0.1e2 / 0.9e1 * t1267 * t318 + 0.5e1 / 0.3e1 * t27 * t4090);
  t4103 = t7 * t1280 * t164;
  t4114 = t4058 / 0.5e1 - t4062 / 0.3e2 + t3927 / 0.5e1 - 0.2e1 / 0.15e2 * t3931 + 0.4e1 / 0.45e2 * t3935 - t3479 / 0.3e2 + 0.4e1 / 0.45e2 * t3483 - t3490 + 0.3e1 / 0.2e2 * t7 * t4094 * t31 * t73 + 0.3e1 / 0.1e2 * t7 * t1276 * t164 + t4103 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t496 * t398 + 0.2e1 / 0.5e1 * t3972 - 0.2e1 / 0.15e2 * t3978 + t3981 / 0.5e1 + 0.4e1 / 0.45e2 * t3495 - t3498 / 0.3e2 - t3870 / 0.15e2;
  t4115 = my_piecewise3(t2, 0, t4114);
  t4124 = t460 * t460;
  t4137 = my_piecewise5(t16, 0, t12, 0, t4010);
  t4141 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3879 * t503 * t405 - 0.4e2 / 0.27e2 * t1220 * t172 * t460 - 0.1e2 / 0.27e2 * t1292 * t411 + 0.2e2 / 0.9e1 * t404 * t4124 + 0.2e2 / 0.9e1 * t456 * t1230 - 0.1e2 / 0.27e2 * t1139 * t508 * t405 + 0.2e2 / 0.9e1 * t404 * t1301 * t172 + 0.1e2 / 0.9e1 * t1297 * t411 + 0.5e1 / 0.3e1 * t85 * t4137);
  t4148 = t7 * t1305 * t134 * t117;
  t4152 = t7 * t512 * t335 * t117;
  t4161 = t7 * t1239 * t233;
  t4164 = t7 * t1243 * t233;
  t4175 = t7 * t420 * t577;
  t4178 = t7 * t424 * t577;
  t4180 = 0.3e1 / 0.2e2 * t7 * t4141 * t31 * t117 + t4148 / 0.5e1 - t4152 / 0.3e2 + t4023 / 0.5e1 - 0.2e1 / 0.15e2 * t4027 + 0.4e1 / 0.45e2 * t4031 + 0.3e1 / 0.1e2 * t7 * t1235 * t233 + 0.2e1 / 0.5e1 * t4161 - t4164 / 0.15e2 - t3909 / 0.3e2 + 0.4e1 / 0.45e2 * t3913 - t3918 + t4040 / 0.5e1 - 0.2e1 / 0.15e2 * t4043 + 0.4e1 / 0.45e2 * t4046 + 0.3e1 / 0.2e2 * t7 * t416 * t577 + t4175 / 0.5e1 - t4178 / 0.3e2;
  t4181 = my_piecewise3(t78, 0, t4180);
  tv4rho42 = 0.2e1 * t1219 + 0.2e1 * t1259 + 0.2e1 * t1291 + 0.2e1 * t1330 + t8 * (t4115 + t4181);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t4202 = my_piecewise5(t12, 0, t16, 0, t3956 + t3957);
  t4206 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3834 * t1335 * t126 - 0.1e2 / 0.9e1 * t1262 * t436 - 0.1e2 / 0.9e1 * t1176 * t491 * t126 + 0.1e2 / 0.3e1 * t1179 * t491 + 0.1e2 / 0.3e1 * t432 * t1271 + 0.1e2 / 0.9e1 * t309 * t1342 * t126 + 0.5e1 / 0.3e1 * t27 * t4202);
  t4213 = t7 * t1346 * t134 * t73;
  t4224 = 0.3e1 / 0.2e2 * t7 * t4206 * t31 * t73 + t4213 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t1347 * t164 + 0.3e1 / 0.1e2 * t4058 - t4062 / 0.1e2 + 0.3e1 / 0.1e2 * t4103 - t3932 + 0.2e1 / 0.15e2 * t3935 - t3979 + 0.2e1 / 0.45e2 * t3483 - t3490 + 0.2e1 / 0.45e2 * t3495;
  t4225 = my_piecewise3(t2, 0, t4224);
  t4242 = my_piecewise5(t16, 0, t12, 0, -t3956 + t4010);
  t4246 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3879 * t1355 * t172 - 0.1e2 / 0.9e1 * t1292 * t460 - 0.1e2 / 0.9e1 * t1220 * t508 * t172 + 0.1e2 / 0.3e1 * t1223 * t508 + 0.1e2 / 0.3e1 * t456 * t1301 + 0.1e2 / 0.9e1 * t404 * t1362 * t172 + 0.5e1 / 0.3e1 * t85 * t4242);
  t4253 = t7 * t1366 * t134 * t117;
  t4261 = t7 * t1310 * t233;
  t4270 = t7 * t469 * t577;
  t4280 = t7 * t180 * t1515;
  t4282 = 0.3e1 / 0.2e2 * t7 * t4246 * t31 * t117 + t4253 / 0.1e2 + 0.3e1 / 0.1e2 * t4148 - t4152 / 0.1e2 + 0.9e1 / 0.2e2 * t7 * t1306 * t233 + 0.3e1 / 0.1e2 * t4261 - t4028 + 0.2e1 / 0.15e2 * t4031 + 0.3e1 / 0.5e1 * t4161 - t4164 / 0.5e1 + 0.9e1 / 0.2e2 * t7 * t465 * t577 + 0.3e1 / 0.1e2 * t4270 + 0.2e1 / 0.45e2 * t3913 - t3918 - t4044 + 0.2e1 / 0.15e2 * t4046 + 0.3e1 / 0.1e2 * t4175 - t4178 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t176 * t1515 + t4280 / 0.1e2;
  t4283 = my_piecewise3(t78, 0, t4282);
  tv4rho43 = 0.3e1 * t1291 + 0.3e1 * t1330 + t1354 + t1520 + t8 * (t4225 + t4283);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t4288 = t486 * t486;
  t4293 = t491 * t491;
  t4300 = my_piecewise5(t12, 0, t16, 0, 0.24e2 * t956 + 0.24e2 * t3848);
  t4304 = my_piecewise3(t22, 0, 0.4e2 / 0.81e2 * t3834 * t4288 - 0.2e2 / 0.9e1 * t1262 * t491 + 0.1e2 / 0.3e1 * t309 * t4293 + 0.4e2 / 0.9e1 * t432 * t1342 + 0.5e1 / 0.3e1 * t27 * t4300);
  t4313 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t4304 * t31 * t73 + 0.2e1 / 0.5e1 * t4213 - t4062 / 0.5e1 + 0.8e1 / 0.45e2 * t3935 - t3490);
  t4323 = t503 * t503;
  t4328 = t508 * t508;
  t4335 = my_piecewise5(t16, 0, t12, 0, -0.24e2 * t956 + 0.24e2 * t3891);
  t4339 = my_piecewise3(t83, 0, 0.4e2 / 0.81e2 * t3879 * t4323 - 0.2e2 / 0.9e1 * t1292 * t508 + 0.1e2 / 0.3e1 * t404 * t4328 + 0.4e2 / 0.9e1 * t456 * t1362 + 0.5e1 / 0.3e1 * t85 * t4335);
  t4357 = t38 * sigma[2] / t91 / t522 / t89;
  t4363 = 0.154e5 / 0.2187e4 * t38 * lapl[1] * t1384 - 0.10472e6 / 0.6561e4 * t4357;
  t4374 = t539 * t539;
  t4375 = t4374 * t541;
  t4376 = t220 * t4375;
  t4378 = t1838 * t2365 * t562;
  t4381 = t1430 * t4375;
  t4384 = t538 * t4375;
  t4385 = t228 * t562;
  t4386 = t1460 * t4385;
  t4391 = t220 * t1782;
  t4393 = t1838 * t2365 * t558;
  t4396 = t558 * t1432;
  t4401 = t4374 * t562;
  t4404 = t541 * t112 * t227;
  t4405 = t1456 * t4404;
  t4409 = t1481 * t1497 * t562;
  t4412 = t1838 * t1418;
  t4415 = t1443 * t541;
  t4416 = t538 * t4415;
  t4425 = t1481 * t1796;
  t4428 = t1430 * t4396;
  t4431 = t558 * t224;
  t4434 = t553 * t1839 * t562;
  t4437 = t220 * t4415;
  t4440 = 0.18e2 * t220 * t4431 * t4434 + 0.18e2 * t538 * t4401 * t4405 - 0.6e1 * t1783 * t4393 + 0.18e2 * t1783 * t4425 - 0.18e2 * t4428 * t1793 + 0.18e2 * t1834 * t4412 + 0.18e2 * t4384 * t4409 - 0.18e2 * t4391 * t4412 - 0.4e1 * t4416 * t671 - 0.4e1 * t4416 * t687 + 0.4e1 * t4437 * t671;
  t4443 = t570 * t1469 * t558;
  t4446 = t1438 * t562;
  t4448 = t1492 * t4446 * params->csk_a;
  t4452 = t1481 * t1497 * t558;
  t4456 = t1481 * t1469 * params->csk_a;
  t4459 = t1430 * t4401;
  t4461 = t541 * t545 * t547;
  t4462 = t1456 * t4461;
  t4465 = t1438 * t558;
  t4467 = t1492 * t4465 * params->csk_a;
  t4473 = t1492 * t1507 * t541;
  t4477 = t538 * t4431 * t543;
  t4478 = t548 * t1823;
  t4486 = params->csk_a * t562;
  t4488 = t228 * t4486 * t558;
  t4491 = t558 * t558;
  t4492 = t4491 * t541;
  t4493 = t538 * t4492;
  t4496 = t562 * t562;
  t4497 = t4374 * t4496;
  t4498 = t538 * t4497;
  t4501 = t541 * t541;
  t4502 = t4374 * t4501;
  t4503 = t538 * t4502;
  t4504 = t542 * t542;
  t4505 = 0.1e1 / t4504;
  t4506 = t4505 * params->csk_a;
  t4507 = t4506 * t228;
  t4515 = t220 * t4502;
  t4518 = t1481 * t1469;
  t4521 = t1430 * t4502;
  t4522 = t4505 * t1093;
  t4523 = t4522 * t228;
  t4526 = t4505 * t1436;
  t4527 = t4526 * t1507;
  t4530 = t4505 * t3697;
  t4531 = t4530 * t228;
  t4534 = 0.18e2 * t220 * t1767 * t543 * t4488 + 0.3e1 * t220 * t4497 * t555 - 0.18e2 * t4384 * t4518 - 0.3e1 * t4493 * t555 - 0.3e1 * t4498 * t555 - 0.3e1 * t4498 * t572 - 0.11e2 * t4503 * t4507 + 0.11e2 * t4515 * t4507 + 0.6e1 * t4521 * t4523 - 0.6e1 * t4521 * t4527 + 0.6e1 * t4521 * t4531;
  t4537 = t536 * t536;
  t4539 = t114 / t4537;
  t4540 = t4539 * t4502;
  t4546 = t4526 * t1493;
  t4552 = t4505 * t545;
  t4553 = t4552 * t571;
  t4558 = t4552 * t1497;
  t4570 = t1492 * t4446;
  t4581 = t4530 * t548;
  t4592 = t1838 * t1850;
  t4595 = t1481 * t1488;
  t4598 = -0.4e1 * t220 * t1443 * t222 * t564 + 0.4e1 * t664 * t570 * t547 * t1443 - 0.12e2 * t4376 * t1838 * t227 * t562 + 0.3e1 * t220 * t4492 * t555 - 0.18e2 * t1834 * t4595 - 0.6e1 * t4381 * t4570 - 0.12e2 * t4391 * t4592 + 0.4e1 * t4437 * t682 - 0.12e2 * t4521 * t4546 + 0.7e1 * t4540 * t4558 - 0.7e1 * t4540 * t4581;
  t4600 = t220 * t4374;
  t4601 = t4496 * t543;
  t4602 = t4601 * t228;
  t4608 = t220 * t4491;
  t4613 = t4501 * t4505;
  t4614 = t4613 * t228;
  t4617 = t538 * t4374;
  t4618 = t4601 * t548;
  t4622 = t4613 * t1439;
  t4626 = t545 * t545;
  t4627 = t546 * t546;
  t4628 = 0.1e1 / t4627;
  t4629 = t4626 * t4628;
  t4630 = t4613 * t4629;
  t4632 = my_piecewise3(t105, 0, t4363);
  t4633 = my_piecewise3(t107, t4632, 0);
  t4636 = t4613 * t548;
  t4640 = 0.6e1 * t1430 * t4374 * t4622 - t220 * t4633 * t229 + t4539 * t4374 * t4630 + 0.3e1 * t538 * t4491 * t549 + 0.3e1 * t4600 * t4602 + 0.6e1 * t4600 * t4614 - 0.3e1 * t4608 * t564 + 0.3e1 * t4608 * t566 + 0.3e1 * t4617 * t4618 + 0.11e2 * t4617 * t4636 + 0.4e1 * t1471;
  t4645 = t4505 * t4626;
  t4647 = t4645 * t4628 * t1093;
  t4650 = t1438 * t3697;
  t4651 = t4526 * t4650;
  t4656 = t4628 * t3697;
  t4657 = t4645 * t4656;
  t4667 = t4645 * t4628 * params->csk_a;
  t4670 = -0.3e1 * t4493 * t572 - 0.7e1 * t4503 * t4581 + 0.18e2 * t4521 * t4581 + 0.12e2 * t4521 * t4651 + 0.18e2 * t4540 * t4527 + 0.11e2 * t4540 * t4647 - 0.12e2 * t4540 * t4651 - 0.6e1 * t4540 * t4657 - 0.6e1 * t4540 * t4667 + 0.4e1 * t1479 - 0.5e1 * t1503;
  t4674 = my_piecewise5(t104, 0, t105, 0, t4440 - t565 + 0.18e2 * t1834 * t4452 + 0.18e2 * t4381 * t4456 - 0.18e2 * t4459 * t4462 + 0.18e2 * t1783 * t4467 - 0.12e2 * t4428 * t1800 + 0.18e2 * t1768 * t4443 + 0.18e2 * t4381 * t4448 - 0.6e1 * t4381 * t4378 + 0.18e2 * t4384 * t4386 - 0.18e2 * t4376 * t4386 - 0.6e1 * t4391 * t4393 - 0.6e1 * t4376 * t4378 - 0.6e1 * t4540 * t4546 + t4515 * t4531 - 0.7e1 * t4503 * t4531 - 0.18e2 * t4521 * t4553 + 0.7e1 * t4503 * t4553 - 0.11e2 * t4503 * t4558 - t4540 * t4531 - 0.18e2 * t4503 * t4523 + 0.6e1 * t4515 * t4523 - 0.12e2 * t4459 * t4473 - 0.18e2 * t4477 * t4478 - 0.18e2 * t4477 * t1824 + t4670 + t4640 + t4534 + t4598 + 0.4e1 * t1415 - 0.4e1 * t1409 - 0.6e1 * t1783 * t1492 * t4465 + 0.18e2 * t538 * t4396 * t1780 - 0.4e1 * t1426);
  t4680 = 0.2e1 / 0.5e1 * t4253 + 0.6e1 / 0.5e1 * t4261 + 0.6e1 / 0.5e1 * t4270 + 0.2e1 / 0.5e1 * t4280 - t4152 / 0.5e1 - 0.2e1 / 0.5e1 * t4164 - t4178 / 0.5e1 + 0.8e1 / 0.45e2 * t4046 + 0.8e1 / 0.45e2 * t4031 - t3918 + 0.3e1 / 0.2e2 * t7 * t4339 * t31 * t117 + 0.3e1 / 0.5e1 * t7 * t1367 * t233 + 0.9e1 / 0.1e2 * t7 * t513 * t577 + 0.3e1 / 0.5e1 * t7 * t204 * t1515 + 0.3e1 / 0.2e2 * t7 * t88 * (0.1309e5 / 0.729e3 * t4357 + t4363 * t115 + 0.4e1 * t1392 * t231 + 0.6e1 * t532 * t575 + 0.4e1 * t218 * t1513 + t103 * t4674);
  t4681 = my_piecewise3(t78, 0, t4680);
  tv4rho44 = 0.4e1 * t1354 + 0.4e1 * t1520 + t8 * (t4313 + t4681);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t4689 = t7 * t969 * t253;
  t4695 = t7 * t976 * t253;
  t4698 = t7 * t327 * t629;
  t4705 = 0.2e1 / 0.45e2 * t7 * t988 * t253;
  t4707 = t7 * t336 * t629;
  t4710 = t7 * t135 * t1670;
  t4712 = t38 * t1000;
  t4736 = t248 * t3656;
  t4737 = t151 * t4736;
  t4739 = t3783 * t375 * t1018;
  t4742 = t248 * t1018;
  t4743 = t151 * t4742;
  t4745 = t383 * t1054 * t3550;
  t4748 = t359 * t4742;
  t4749 = t369 * params->csk_a;
  t4750 = t3652 * t4749;
  t4753 = t3652 * t2506;
  t4756 = t359 * t4736;
  t4759 = t1050 * t4736;
  t4761 = t3696 * t3698 * t1018;
  t4766 = t3812 * t1018 * t68 * t158;
  t4769 = t612 * t1052;
  t4770 = t359 * t4769;
  t4773 = 0.9e1 * t4770 * t1582 + 0.11e2 * t4737 * t4739 - 0.11e2 * t4756 * t4739 - 0.12e2 * t4743 * t4745 - 0.3e1 * t4748 * t4750 - 0.3e1 * t4748 * t4753 + 0.12e2 * t4759 * t4761 + 0.6e1 * t4759 * t4766 + 0.4e1 * t1571 + 0.4e1 * t1577 - 0.4e1 * t1622 + 0.4e1 * t1630 - 0.4e1 * t1632;
  t4774 = t1050 * t4769;
  t4779 = t158 * t3697;
  t4781 = t3783 * t4779 * t1018;
  t4787 = t3677 * t4736;
  t4792 = t1579 * t618 * t379;
  t4796 = t391 * t1650 * t383;
  t4801 = t1018 * t3656;
  t4802 = t1050 * t4801;
  t4803 = t3714 * t860;
  t4806 = t1636 * t362;
  t4807 = t359 * t4806;
  t4812 = t1100 * t2225;
  t4815 = -0.3e1 * t1561 * t1035 + 0.9e1 * t4770 * t1557 - 0.6e1 * t1564 * t4792 + 0.9e1 * t1574 * t4796 - 0.3e1 * t4774 * t1582 + 0.9e1 * t1589 * t4812 + 0.6e1 * t4737 * t4766 + t4737 * t4781 - 0.18e2 * t4756 * t4766 - 0.7e1 * t4756 * t4781 + 0.6e1 * t4759 * t4781 - t4787 * t4781 - 0.18e2 * t4802 * t4803 - 0.3e1 * t4807 * t608;
  t4819 = t151 * t4806;
  t4823 = t3696 * t1124 * t1018;
  t4831 = t391 * t392 * t1045;
  t4835 = t3677 * t4801;
  t4836 = t3681 * t248;
  t4842 = t3705 * t3706 * t1018;
  t4845 = t1018 * t362;
  t4846 = t1050 * t4845;
  t4851 = t359 * t2264;
  t4856 = t3696 * t1616;
  t4859 = t151 * t4769;
  t4862 = t368 * t3697;
  t4864 = t3714 * t4862 * t1018;
  t4867 = -0.9e1 * t4774 * t1595 + 0.3e1 * t4819 * t608 - 0.6e1 * t4759 * t4823 + 0.3e1 * t4743 * t4753 - 0.3e1 * t1561 * t1599 - t621 * t4831 - 0.6e1 * t4774 * t1602 + 0.11e2 * t4835 * t3705 * t4836 * t1093 - 0.6e1 * t4787 * t4842 - 0.6e1 * t4846 * t1109 * t1615 * t383 - 0.9e1 * t4851 * t1100 * t602 * t379 - 0.12e2 * t4802 * t4856 - 0.3e1 * t4859 * t1582 - 0.7e1 * t4756 * t4864;
  t4871 = t3714 * t602 * t1093;
  t4876 = t359 * t4801;
  t4880 = t3714 * t1114 * t1018;
  t4883 = t612 * t360;
  t4887 = t359 * t4845;
  t4888 = t1100 * t1575;
  t4891 = t1058 * t612;
  t4893 = t1109 * t4891 * params->csk_a;
  t4898 = t1021 * t1045 * t68 * t158;
  t4913 = 0.18e2 * t4759 * t4864 + 0.7e1 * t4835 * t4871 - 0.9e1 * t4859 * t1557 + 0.7e1 * t4876 * t4803 - 0.11e2 * t4756 * t4880 + 0.9e1 * t151 * t4883 * t1570 - 0.18e2 * t4887 * t4888 + 0.9e1 * t1589 * t4893 - t621 * t4898 - 0.6e1 * t4835 * t3705 * t4836 * params->csk_a - 0.3e1 * t2265 * t1109 * t3584 * t248 + 0.3e1 * t1605 * t1035 + 0.9e1 * t4770 * t1595 + t606 * t4898;
  t4920 = t3696 * t3230;
  t4929 = t2506 * t153 * t383 * t379;
  t4932 = t359 * t2507;
  t4933 = params->csk_a * t155;
  t4934 = t4933 * t379;
  t4935 = t2511 * t4934;
  t4938 = t1021 * t155;
  t4939 = t159 * t379;
  t4940 = t4938 * t4939;
  t4943 = t359 * t2457;
  t4945 = t1093 * t379 * t153;
  t4946 = t369 * t4945;
  t4949 = t151 * t2457;
  t4951 = t159 * t2238 * t379;
  t4956 = t374 * t1084 * t379;
  t4960 = t359 * t4883 * t383;
  t4964 = t1050 * t4845 * t1054;
  t4965 = t369 * t3207;
  t4968 = 0.9e1 * t151 * t2507 * t4956 - 0.9e1 * t4960 * t1024 + 0.9e1 * t1626 * t4929 - 0.12e2 * t4787 * t4761 - 0.7e1 * t4787 * t4864 - 0.3e1 * t4807 * t624 - 0.6e1 * t4835 * t4856 + 0.18e2 * t4835 * t4920 - 0.9e1 * t4932 * t4935 - 0.9e1 * t4932 * t4940 + 0.9e1 * t4943 * t4946 - 0.9e1 * t4949 * t4951 + 0.18e2 * t4964 * t4965;
  t4969 = t4742 * t383;
  t4970 = t1050 * t4969;
  t4975 = t359 * t4969;
  t4980 = t605 * t1054;
  t4981 = t151 * t4980;
  t4983 = t1093 * t1018 * t383;
  t4984 = t159 * t4983;
  t4991 = t159 * params->csk_a * t1018 * t383;
  t5001 = t153 * t155;
  t5003 = t359 * t5001 * t364;
  t5004 = t2252 * t379;
  t5009 = t612 * t155 * t364;
  t5013 = t359 * t4980;
  t5014 = t369 * t4983;
  t5017 = t1059 * t4945;
  t5020 = 0.18e2 * t4964 * t1059 * t3207 + 0.9e1 * t151 * t5009 * t1629 + 0.9e1 * t5003 * t369 * t5004 - 0.9e1 * t4960 * t1041 - 0.6e1 * t2458 * t5017 + 0.18e2 * t4975 * t3551 - 0.6e1 * t4970 * t3569 + 0.18e2 * t4975 * t3569 - 0.18e2 * t4970 * t3593 - 0.12e2 * t4970 * t3637 + 0.9e1 * t4943 * t4951 - 0.6e1 * t4981 * t4984 - 0.18e2 * t4981 * t4991 + 0.18e2 * t5013 * t5014;
  t5022 = t159 * t4945;
  t5030 = t1050 * t2264 * t1054;
  t5031 = t3203 * t379;
  t5052 = t374 * t158 * t1045;
  t5059 = t1100 * t1650;
  t5062 = -t151 * t248 * t1045 * t385 - 0.3e1 * t151 * t612 * t379 * t385 + 0.9e1 * t5030 * t1059 * t5031 + 0.9e1 * t5030 * t369 * t5031 + t4835 * t3705 * t4836 + 0.11e2 * t4876 * t3714 * t602 - 0.6e1 * t4859 * t1640 - 0.9e1 * t1643 * t5059 - 0.9e1 * t2458 * t4946 - 0.3e1 * t2458 * t5022 + 0.3e1 * t4819 * t619 + 0.9e1 * t4943 * t5022 - 0.3e1 * t4949 * t5022 + t606 * t5052;
  t5067 = t391 * t368 * t1636;
  t5079 = t1109 * t4891;
  t5082 = t158 * t1018;
  t5083 = t3783 * t5082;
  t5087 = t359 * t1018 * t3651;
  t5093 = my_piecewise3(t61, 0, 0.616e4 / 0.2187e4 * t4712);
  t5094 = my_piecewise3(t63, t5093, 0);
  t5099 = -0.3e1 * t151 * t1636 * t153 * t385 - t151 * t5094 * t160 + 0.6e1 * t4802 * t3696 * t1615 + 0.3e1 * t1015 * t1651 - 0.3e1 * t1589 * t5079 + 0.3e1 * t1605 * t1664 + t3607 * t603 + 0.3e1 * t4743 * t3653 + 0.6e1 * t4737 * t5083 + 0.3e1 * t601 * t5067 + 0.3e1 * t5087 * t603 - 0.3e1 * t1658 - 0.2e1 * t1662 - t617;
  t5103 = my_piecewise5(t58, 0, t61, 0, t4773 + t4815 + t4867 + t4913 + t4968 + t5020 + t5062 + t5099);
  t5110 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t965 * t253 + 0.3e1 / 0.1e2 * t4689 + 0.9e1 / 0.2e2 * t7 * t323 * t629 - t4695 / 0.1e2 + 0.3e1 / 0.5e1 * t4698 + 0.9e1 / 0.2e2 * t7 * t130 * t1670 + t4705 - t4707 / 0.1e2 + 0.3e1 / 0.1e2 * t4710 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.77e3 / 0.243e3 * t4712 + 0.616e4 / 0.2187e4 * t38 * t1000 * t71 - 0.44e3 / 0.243e3 * t38 * t345 * t162 + 0.4e2 / 0.81e2 * t38 * t141 * t396 - 0.5e1 / 0.81e2 * t38 * t43 * t1130 + t1008 * t251 + 0.3e1 * t353 * t627 + 0.3e1 * t149 * t1668 + t53 * t5103));
  tv4rho3sigma0 = t8 * t5110 + 0.3e1 * t1675;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t5117 = t7 * t1158 * t270;
  t5120 = t7 * t1162 * t270;
  t5124 = 0.2e1 / 0.45e2 * t7 * t1166 * t270;
  t5126 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1154 * t270 + 0.3e1 / 0.1e2 * t5117 - t5120 / 0.1e2 + t5124);
  tv4rho3sigma2 = t8 * t5126 + 0.3e1 * t1688;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t5128 = 0.2e1 * t1702;
  t5134 = t7 * t1196 * t253 / 0.5e1;
  t5139 = t7 * t1203 * t253;
  t5143 = t7 * t445 * t629 / 0.5e1;
  t5152 = 0.3e1 / 0.2e2 * t7 * t1192 * t253 + t5134 + 0.3e1 / 0.1e2 * t7 * t441 * t629 - t5139 / 0.3e2 + t5143 + 0.3e1 / 0.2e2 * t7 * t193 * t1670 + t4689 / 0.1e2 - t4695 / 0.15e2 + t4698 / 0.5e1 + t4705 - t4707 / 0.15e2 + t4710 / 0.1e2;
  t5153 = my_piecewise3(t2, 0, t5152);
  tv4rho3sigma3 = t8 * t5153 + t1675 + t5128;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t5155 = 0.2e1 * t1718;
  t5161 = t7 * t1239 * t270 / 0.5e1;
  t5163 = t7 * t1243 * t270;
  t5172 = t7 * t420 * t692 / 0.5e1;
  t5174 = t7 * t424 * t692;
  t5177 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1235 * t270 + t5161 - t5163 / 0.3e2 + t5117 / 0.1e2 - t5120 / 0.15e2 + t5124 + 0.3e1 / 0.2e2 * t7 * t416 * t692 + t5172 - t5174 / 0.3e2);
  tv4rho3sigma5 = t8 * t5177 + t1688 + t5155;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t5183 = t7 * t1280 * t253;
  t5192 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1276 * t253 + t5183 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t496 * t629 + t5134 - t5139 / 0.15e2 + t5143 - t4695 / 0.3e2 + t4705 - t4707 / 0.3e2);
  tv4rho3sigma6 = t8 * t5192 + t1726 + t5128;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t5198 = t7 * t1310 * t270;
  t5205 = t7 * t469 * t692;
  t5213 = t7 * t180 * t1866;
  t5215 = 0.3e1 / 0.2e2 * t7 * t1306 * t270 + t5198 / 0.1e2 + t5161 - t5163 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t465 * t692 + t5205 / 0.5e1 - t5120 / 0.3e2 + t5124 + t5172 - t5174 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t176 * t1866 + t5213 / 0.1e2;
  t5216 = my_piecewise3(t78, 0, t5215);
  tv4rho3sigma8 = t8 * t5216 + t1871 + t5155;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t5225 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1347 * t253 + 0.3e1 / 0.1e2 * t5183 - t5139 / 0.1e2 + t4705);
  tv4rho3sigma9 = t8 * t5225 + 0.3e1 * t1726;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t5242 = t38 * t1384;
  t5266 = t265 * t4501;
  t5267 = t538 * t5266;
  t5269 = t1402 * t112 * t227;
  t5270 = t4522 * t5269;
  t5273 = t1430 * t5266;
  t5276 = t675 * t1432;
  t5277 = t538 * t5276;
  t5280 = t1430 * t5276;
  t5283 = t220 * t5266;
  t5286 = t4530 * t5269;
  t5289 = t4539 * t5266;
  t5292 = 0.9e1 * t5277 * t1780 - 0.3e1 * t5280 * t1780 - 0.18e2 * t5267 * t5270 + 0.6e1 * t5273 * t5270 + 0.6e1 * t5283 * t5270 + 0.6e1 * t5273 * t5286 + t5283 * t5286 - t5289 * t5286 + 0.4e1 * t1771 + 0.4e1 * t1777 - 0.4e1 * t1817 + 0.4e1 * t1825 - 0.4e1 * t1827;
  t5296 = t4526 * t4650 * t1402;
  t5299 = t1831 * t541;
  t5300 = t220 * t5299;
  t5307 = t265 * t1402;
  t5308 = t538 * t5307;
  t5309 = t548 * params->csk_a;
  t5310 = t4601 * t5309;
  t5313 = t4506 * t5269;
  t5318 = t220 * t5307;
  t5319 = t4601 * t2636;
  t5322 = t1402 * t541;
  t5323 = t538 * t5322;
  t5328 = t562 * t1434 * t4404;
  t5333 = t1430 * t5322;
  t5338 = t538 * t2408;
  t5343 = t1402 * t4501;
  t5344 = t1430 * t5343;
  t5345 = t4526 * t1804;
  t5348 = -0.6e1 * t5273 * t4526 * t1507 * t1402 - 0.9e1 * t5338 * t1481 * t665 * t558 - 0.6e1 * t5333 * t1492 * t1803 * t562 - 0.18e2 * t5323 * t1481 * t1769 - 0.7e1 * t5267 * t5286 - 0.11e2 * t5267 * t5313 + 0.12e2 * t5273 * t5296 + 0.11e2 * t5283 * t5313 + 0.3e1 * t5300 * t671 - 0.3e1 * t5308 * t5310 - 0.3e1 * t5308 * t5319 + 0.3e1 * t5318 * t5319 - 0.12e2 * t5318 * t5328 - 0.12e2 * t5344 * t5345;
  t5350 = t675 * t539;
  t5355 = t1838 * t681 * t558;
  t5360 = t4552 * t888;
  t5363 = t538 * t5299;
  t5368 = t1481 * t2324;
  t5373 = t220 * t5276;
  t5376 = t538 * t5343;
  t5380 = t4552 * t1497 * t1402;
  t5384 = t570 * t1856 * t562;
  t5387 = t1438 * t675;
  t5389 = t1492 * t5387 * params->csk_a;
  t5392 = t4539 * t5343;
  t5393 = t4628 * t265;
  t5398 = -0.6e1 * t5392 * t4645 * t5393 * params->csk_a + 0.9e1 * t220 * t5350 * t1776 - 0.3e1 * t1752 * t1419 + 0.9e1 * t5277 * t1759 - 0.9e1 * t5373 * t1759 - 0.6e1 * t1764 * t5355 + 0.9e1 * t1768 * t5384 + 0.9e1 * t1783 * t5368 + 0.9e1 * t1783 * t5389 - 0.9e1 * t5280 * t1793 - 0.11e2 * t5267 * t5380 - 0.18e2 * t5344 * t5360 + 0.7e1 * t5376 * t5360 - 0.3e1 * t5363 * t671;
  t5407 = t1405 * t1443 * t112 * t227;
  t5412 = t4552 * t665 * t1093;
  t5417 = t4530 * t1402 * t545 * t547;
  t5422 = t4526 * t3301;
  t5436 = -0.3e1 * t2409 * t1492 * t4465 * t265 + 0.3e1 * t1808 * t1419 - 0.3e1 * t5373 * t1780 + 0.9e1 * t5277 * t1793 - 0.7e1 * t5267 * t5417 + 0.18e2 * t5273 * t5417 - 0.12e2 * t5289 * t5296 - 0.7e1 * t5289 * t5417 - 0.6e1 * t5392 * t5345 - 0.3e1 * t5363 * t687 + 0.7e1 * t5392 * t5412 + 0.18e2 * t5392 * t5422 + t669 * t5407 - t684 * t5407;
  t5442 = t570 * t571 * t1443;
  t5451 = t4645 * t4656 * t1402;
  t5454 = t538 * t2637;
  t5455 = params->csk_a * t224;
  t5456 = t5455 * t558;
  t5457 = t2628 * t5456;
  t5460 = t1405 * t224;
  t5461 = t228 * t558;
  t5462 = t5460 * t5461;
  t5465 = t222 * t562;
  t5470 = t538 * t2583;
  t5472 = t1093 * t558 * t222;
  t5473 = t548 * t5472;
  t5476 = t5307 * t562;
  t5477 = t538 * t5476;
  t5478 = t1460 * t4404;
  t5483 = t1430 * t5476;
  t5486 = t668 * t1434;
  t5487 = t220 * t5486;
  t5489 = t1093 * t1402 * t562;
  t5490 = t228 * t5489;
  t5493 = 0.11e2 * t5392 * t4645 * t5393 * t1093 + 0.9e1 * t1821 * t2636 * t5465 * t558 - 0.3e1 * t1752 * t1797 - 0.6e1 * t5280 * t1800 + 0.18e2 * t5477 * t4405 - 0.6e1 * t5483 * t4405 - 0.6e1 * t5289 * t5451 - t684 * t5442 - 0.9e1 * t5454 * t5457 - 0.9e1 * t5454 * t5462 + 0.9e1 * t5470 * t5473 + 0.18e2 * t5477 * t5478 - 0.6e1 * t5487 * t5490;
  t5496 = t228 * params->csk_a * t1402 * t562;
  t5499 = t1093 * t222;
  t5500 = t5499 * t5461;
  t5508 = t1430 * t2408 * t1434;
  t5509 = t3274 * t558;
  t5513 = t222 * t224;
  t5515 = t538 * t5513 * t543;
  t5516 = t2419 * t558;
  t5521 = t1430 * t5322 * t1434;
  t5527 = t553 * t1477 * t558;
  t5531 = t538 * t5350 * t562;
  t5534 = t2376 * t5461;
  t5537 = t220 * t2583;
  t5541 = t675 * t224 * t543;
  t5546 = t548 * t5489;
  t5551 = 0.18e2 * t5521 * t1439 * t3275 + 0.9e1 * t220 * t5541 * t1824 + 0.9e1 * t220 * t2637 * t5527 + 0.18e2 * t538 * t5486 * t5546 + 0.9e1 * t5508 * t548 * t5509 + 0.9e1 * t5515 * t548 * t5516 - 0.9e1 * t5531 * t1408 - 0.9e1 * t5531 * t1425 - 0.3e1 * t2584 * t5500 - 0.12e2 * t5483 * t4473 + 0.9e1 * t5470 * t5500 + 0.9e1 * t5470 * t5534 - 0.18e2 * t5487 * t5496 - 0.9e1 * t5537 * t5534;
  t5553 = t548 * t3275;
  t5563 = t1439 * t5472;
  t5583 = t4505 * t112;
  t5585 = t5583 * t227 * t1402;
  t5589 = t538 * t1402 * t4496;
  t5595 = 0.18e2 * t5521 * t5553 - 0.18e2 * t5483 * t4462 - 0.9e1 * t2584 * t5473 + 0.9e1 * t5508 * t1439 * t5509 - 0.6e1 * t2584 * t5563 - 0.3e1 * t5537 * t5500 - 0.6e1 * t5373 * t1840 - 0.3e1 * t220 * t1831 * t222 * t564 - 0.3e1 * t220 * t675 * t558 * t564 - t220 * t265 * t1443 * t564 + 0.3e1 * t1808 * t1851 + 0.6e1 * t5283 * t5585 + 0.3e1 * t5589 * t666 + 0.11e2 * t5376 * t4552 * t665;
  t5601 = t553 * t227 * t1443;
  t5604 = t570 * t547 * t1831;
  t5610 = t1492 * t5387;
  t5615 = t1481 * t1856;
  t5622 = my_piecewise3(t105, 0, 0.616e4 / 0.2187e4 * t5242);
  t5623 = my_piecewise3(t107, t5622, 0);
  t5628 = 0.6e1 * t5344 * t4526 * t1803 - t220 * t5623 * t229 + t5392 * t4645 * t5393 + 0.3e1 * t1399 * t1857 - 0.3e1 * t1783 * t5610 - 0.9e1 * t1834 * t5615 + t4416 * t666 + 0.3e1 * t5318 * t4602 + 0.3e1 * t5300 * t682 + t669 * t5601 + 0.3e1 * t664 * t5604 - 0.3e1 * t1845 - 0.2e1 * t1849 - t680;
  t5632 = my_piecewise5(t104, 0, t105, 0, t5292 + t5348 + t5398 + t5436 + t5493 + t5551 + t5595 + t5628);
  t5639 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1367 * t270 + 0.3e1 / 0.1e2 * t5198 + 0.9e1 / 0.2e2 * t7 * t513 * t692 - t5163 / 0.1e2 + 0.3e1 / 0.5e1 * t5205 + 0.9e1 / 0.2e2 * t7 * t204 * t1866 + t5124 - t5174 / 0.1e2 + 0.3e1 / 0.1e2 * t5213 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.77e3 / 0.243e3 * t5242 + 0.616e4 / 0.2187e4 * t38 * t1384 * t115 - 0.44e3 / 0.243e3 * t38 * t524 * t231 + 0.4e2 / 0.81e2 * t38 * t210 * t575 - 0.5e1 / 0.81e2 * t38 * t93 * t1513 + t1392 * t268 + 0.3e1 * t532 * t690 + 0.3e1 * t218 * t1864 + t103 * t5632));
  tv4rho3sigma11 = t8 * t5639 + 0.3e1 * t1871;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t5646 = t7 * t969 * t286;
  t5652 = t7 * t976 * t286;
  t5655 = t7 * t327 * t731;
  t5662 = 0.2e1 / 0.45e2 * t7 * t988 * t286;
  t5664 = t7 * t336 * t731;
  t5667 = t7 * t135 * t1987;
  t5687 = t281 * t1018;
  t5688 = t5687 * t383;
  t5689 = t359 * t5688;
  t5694 = t713 * t1054;
  t5695 = t151 * t5694;
  t5698 = t1050 * t5688;
  t5708 = 0.9e1 * t151 * t2497 * t4956 + 0.9e1 * t2465 * t4946 - 0.3e1 * t2483 * t5022 + 0.18e2 * t5689 * t3551 + 0.18e2 * t5689 * t3569 - 0.6e1 * t5698 * t3569 - 0.6e1 * t5695 * t4984 - 0.18e2 * t5695 * t4991 + 0.4e1 * t1915 + 0.4e1 * t1919 - 0.4e1 * t1947 + 0.4e1 * t1952 - 0.4e1 * t1954;
  t5709 = t718 * t360;
  t5711 = t359 * t5709 * t383;
  t5716 = t2459 * t379;
  t5717 = t369 * t5716;
  t5721 = t718 * t155 * t364;
  t5722 = t151 * t5721;
  t5725 = t359 * t5694;
  t5731 = t369 * t2749 * t379;
  t5734 = t2749 * params->csk_a;
  t5735 = t1059 * t5734;
  t5740 = t369 * t5734;
  t5751 = -0.9e1 * t5711 * t1024 - 0.9e1 * t5711 * t1041 + 0.9e1 * t5722 * t1629 + 0.9e1 * t2465 * t4951 - 0.9e1 * t2478 * t4951 - 0.9e1 * t2483 * t4946 - 0.6e1 * t2483 * t5017 - 0.18e2 * t5698 * t3593 - 0.12e2 * t5698 * t3637 + 0.18e2 * t4964 * t5735 + 0.18e2 * t4964 * t5740 + 0.9e1 * t5003 * t5731 + 0.18e2 * t5725 * t5014 + 0.9e1 * t5030 * t5717;
  t5761 = t281 * t3656;
  t5762 = t151 * t5761;
  t5765 = t1100 * t1913;
  t5768 = t359 * t5761;
  t5771 = t1050 * t5761;
  t5774 = t718 * t1052;
  t5775 = t359 * t5774;
  t5778 = t1050 * t5774;
  t5788 = t3677 * t5761;
  t5790 = 0.9e1 * t1050 * t3560 * t1054 * t2461 + 0.9e1 * t5775 * t1582 - 0.3e1 * t5778 * t1582 + 0.9e1 * t2465 * t5022 - 0.3e1 * t2478 * t5022 + 0.11e2 * t5762 * t4739 + 0.6e1 * t5762 * t4766 - 0.18e2 * t5768 * t4766 + 0.6e1 * t5771 * t4766 + t5762 * t4781 - 0.7e1 * t5768 * t4781 + 0.6e1 * t5771 * t4781 - t5788 * t4781 - 0.18e2 * t4887 * t5765;
  t5793 = t1958 * t362;
  t5794 = t151 * t5793;
  t5798 = t3714 * t710 * t1093;
  t5803 = t359 * t5687;
  t5810 = t151 * t5687;
  t5814 = t3696 * t1937 * t1093;
  t5817 = t151 * t5774;
  t5824 = t359 * t5793;
  t5829 = t1100 * t2715;
  t5832 = -0.12e2 * t714 * t1579 * t5082 * t383 - 0.3e1 * t1903 * t1035 - 0.3e1 * t5817 * t1582 + 0.9e1 * t1589 * t5829 - 0.11e2 * t5768 * t4739 - 0.3e1 * t5803 * t4750 - 0.3e1 * t5803 * t4753 + 0.3e1 * t5810 * t4753 + 0.12e2 * t5771 * t4761 - 0.6e1 * t5771 * t4823 + 0.7e1 * t4835 * t5798 + 0.18e2 * t4835 * t5814 + 0.3e1 * t5794 * t608 - 0.3e1 * t5824 * t608;
  t5839 = t3714 * t1921;
  t5847 = t391 * t1971 * t383;
  t5862 = 0.9e1 * t5775 * t1557 - 0.9e1 * t5817 * t1557 + 0.9e1 * t1574 * t5847 - 0.9e1 * t5778 * t1595 - 0.3e1 * t1903 * t1599 - 0.6e1 * t1910 * t4792 - 0.12e2 * t5788 * t4761 - 0.18e2 * t4802 * t5839 - t725 * t4831 + 0.7e1 * t4876 * t5839 - 0.11e2 * t5768 * t4880 - t725 * t4898 - 0.3e1 * t5824 * t624;
  t5865 = t3681 * t281;
  t5867 = t3705 * t5865 * t1093;
  t5876 = t1058 * t718;
  t5878 = t1109 * t5876 * params->csk_a;
  t5882 = t3705 * t5865 * params->csk_a;
  t5892 = t1109 * t1937 * t383;
  t5896 = t1100 * t710 * t379;
  t5899 = t3696 * t1938;
  t5907 = -0.3e1 * t2265 * t1109 * t3584 * t281 + 0.9e1 * t151 * t5709 * t1570 + 0.9e1 * t1589 * t5878 - 0.6e1 * t5778 * t1602 - 0.12e2 * t4802 * t5899 + 0.11e2 * t4835 * t5867 - 0.6e1 * t4835 * t5882 - 0.6e1 * t4835 * t5899 - 0.6e1 * t5788 * t4842 - 0.6e1 * t4846 * t5892 - 0.9e1 * t4851 * t5896 - 0.7e1 * t5768 * t4864 + 0.18e2 * t5771 * t4864 - 0.7e1 * t5788 * t4864;
  t5914 = t359 * t2497;
  t5926 = t391 * t368 * t1958;
  t5929 = t1109 * t5876;
  t5938 = 0.3e1 * t1015 * t1972 + 0.3e1 * t1942 * t1035 - 0.3e1 * t1589 * t5929 + 0.9e1 * t5775 * t1595 + 0.9e1 * t1951 * t4929 + t3607 * t711 + 0.3e1 * t5810 * t3653 + t714 * t4898 - 0.9e1 * t5914 * t4935 - 0.9e1 * t5914 * t4940 + t714 * t5052 + 0.6e1 * t5762 * t5083 + 0.3e1 * t5794 * t619 + 0.3e1 * t601 * t5926;
  t5941 = t3705 * t5865;
  t5949 = t3714 * t710;
  t5952 = t1100 * t1971;
  t5955 = t3696 * t1937;
  t5968 = my_piecewise3(t61, 0, -0.11e4 / 0.729e3 * t1539);
  t5969 = my_piecewise3(t63, t5968, 0);
  t5974 = -t151 * t281 * t1045 * t385 - 0.3e1 * t151 * t1958 * t153 * t385 - 0.3e1 * t151 * t718 * t379 * t385 - t151 * t5969 * t160 - 0.6e1 * t5817 * t1640 - 0.9e1 * t1643 * t5952 + 0.3e1 * t1942 * t1664 + 0.6e1 * t4802 * t5955 + t4835 * t5941 + 0.11e2 * t4876 * t5949 + 0.3e1 * t5087 * t711 - 0.2e1 * t1968 - 0.3e1 * t1979 - t723;
  t5978 = my_piecewise5(t58, 0, t61, 0, t5708 + t5751 + t5790 + t5832 + t5862 + t5907 + t5938 + t5974);
  t5985 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t965 * t286 + 0.3e1 / 0.1e2 * t5646 + 0.9e1 / 0.2e2 * t7 * t323 * t731 - t5652 / 0.1e2 + 0.3e1 / 0.5e1 * t5655 + 0.9e1 / 0.2e2 * t7 * t130 * t1987 + t5662 - t5664 / 0.1e2 + 0.3e1 / 0.1e2 * t5667 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.11e4 / 0.729e3 * t1542 + 0.1e3 / 0.81e2 * t1545 - 0.25e2 / 0.54e2 * t1548 + 0.5e1 / 0.54e2 * t38 * t48 * t1130 + t1008 * t284 + 0.3e1 * t353 * t729 + 0.3e1 * t149 * t1985 + t53 * t5978));
  tv4rho3lapl0 = t8 * t5985 + 0.3e1 * t1992;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t5992 = t7 * t1158 * t302;
  t5995 = t7 * t1162 * t302;
  t5999 = 0.2e1 / 0.45e2 * t7 * t1166 * t302;
  t6001 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1154 * t302 + 0.3e1 / 0.1e2 * t5992 - t5995 / 0.1e2 + t5999);
  tv4rho3lapl1 = t8 * t6001 + 0.3e1 * t2005;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  t6003 = 0.2e1 * t2019;
  t6009 = t7 * t1196 * t286 / 0.5e1;
  t6014 = t7 * t1203 * t286;
  t6018 = t7 * t445 * t731 / 0.5e1;
  t6027 = 0.3e1 / 0.2e2 * t7 * t1192 * t286 + t6009 + 0.3e1 / 0.1e2 * t7 * t441 * t731 - t6014 / 0.3e2 + t6018 + 0.3e1 / 0.2e2 * t7 * t193 * t1987 + t5646 / 0.1e2 - t5652 / 0.15e2 + t5655 / 0.5e1 + t5662 - t5664 / 0.15e2 + t5667 / 0.1e2;
  t6028 = my_piecewise3(t2, 0, t6027);
  tv4rho3lapl2 = t8 * t6028 + t1992 + t6003;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  t6030 = 0.2e1 * t2035;
  t6036 = t7 * t1239 * t302 / 0.5e1;
  t6038 = t7 * t1243 * t302;
  t6047 = t7 * t420 * t782 / 0.5e1;
  t6049 = t7 * t424 * t782;
  t6052 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1235 * t302 + t6036 - t6038 / 0.3e2 + t5992 / 0.1e2 - t5995 / 0.15e2 + t5999 + 0.3e1 / 0.2e2 * t7 * t416 * t782 + t6047 - t6049 / 0.3e2);
  tv4rho3lapl3 = t8 * t6052 + t2005 + t6030;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  t6058 = t7 * t1280 * t286;
  t6067 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1276 * t286 + t6058 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t496 * t731 + t6009 - t6014 / 0.15e2 + t6018 - t5652 / 0.3e2 + t5662 - t5664 / 0.3e2);
  tv4rho3lapl4 = t8 * t6067 + t2043 + t6003;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  t6073 = t7 * t1310 * t302;
  t6080 = t7 * t469 * t782;
  t6088 = t7 * t180 * t2152;
  t6090 = 0.3e1 / 0.2e2 * t7 * t1306 * t302 + t6073 / 0.1e2 + t6036 - t6038 / 0.15e2 + 0.3e1 / 0.1e2 * t7 * t465 * t782 + t6080 / 0.5e1 - t5995 / 0.3e2 + t5999 + t6047 - t6049 / 0.15e2 + 0.3e1 / 0.2e2 * t7 * t176 * t2152 + t6088 / 0.1e2;
  t6091 = my_piecewise3(t78, 0, t6090);
  tv4rho3lapl5 = t8 * t6091 + t2157 + t6030;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  t6100 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t1347 * t286 + 0.3e1 / 0.1e2 * t6058 - t6014 / 0.1e2 + t5662);
  tv4rho3lapl6 = t8 * t6100 + 0.3e1 * t2043;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  t6133 = t4526 * t2097;
  t6136 = t297 * t1402;
  t6137 = t220 * t6136;
  t6140 = t297 * t4501;
  t6141 = t220 * t6140;
  t6146 = t538 * t6136;
  t6151 = t538 * t6140;
  t6154 = t2123 * t541;
  t6155 = t538 * t6154;
  t6158 = -0.3e1 * t6146 * t5310 + 0.11e2 * t6141 * t5313 - 0.11e2 * t6151 * t5313 + 0.3e1 * t6137 * t5319 - 0.3e1 * t6146 * t5319 - 0.12e2 * t6137 * t5328 - 0.12e2 * t5344 * t6133 - 0.3e1 * t6155 * t687 + 0.4e1 * t2082 + 0.4e1 * t2086 - 0.4e1 * t2112 + 0.4e1 * t2117 - 0.4e1 * t2119;
  t6159 = t4628 * t297;
  t6161 = t4645 * t6159 * t1093;
  t6166 = t769 * t1432;
  t6167 = t538 * t6166;
  t6170 = t1430 * t6140;
  t6174 = t4552 * t761 * t1093;
  t6177 = t4539 * t6140;
  t6181 = t4526 * t2096 * t1093;
  t6184 = t220 * t6166;
  t6187 = t4552 * t2091;
  t6193 = t4645 * t6159 * params->csk_a;
  t6202 = 0.3e1 * t2101 * t1419 + 0.9e1 * t6167 * t1759 - 0.9e1 * t6184 * t1759 + 0.9e1 * t6167 * t1793 - 0.18e2 * t5344 * t6187 + 0.7e1 * t5376 * t6187 - 0.11e2 * t6151 * t5380 + 0.11e2 * t5392 * t6161 + 0.7e1 * t5392 * t6174 + 0.18e2 * t5392 * t6181 - 0.6e1 * t5392 * t6193 + 0.18e2 * t6170 * t5417 - 0.7e1 * t6177 * t5417 - 0.3e1 * t6155 * t671;
  t6206 = t1430 * t6166;
  t6210 = t1481 * t761 * t558;
  t6217 = t1438 * t769;
  t6219 = t1492 * t6217 * params->csk_a;
  t6222 = t220 * t6154;
  t6233 = t1481 * t2834;
  t6240 = -0.3e1 * t2409 * t1492 * t4465 * t297 - 0.3e1 * t2074 * t1419 + 0.9e1 * t1783 * t6219 + 0.9e1 * t1783 * t6233 - 0.9e1 * t6206 * t1793 - 0.18e2 * t6151 * t5270 + t6141 * t5286 - 0.7e1 * t6151 * t5286 + 0.6e1 * t6170 * t5286 - t6177 * t5286 - 0.9e1 * t5338 * t6210 - 0.6e1 * t5344 * t6181 - 0.6e1 * t5392 * t6133 + 0.3e1 * t6222 * t671;
  t6266 = 0.9e1 * t6167 * t1780 - 0.3e1 * t6184 * t1780 - 0.3e1 * t6206 * t1780 - 0.3e1 * t2074 * t1797 - 0.6e1 * t6206 * t1800 + 0.6e1 * t6141 * t5270 + 0.6e1 * t6170 * t5270 + 0.12e2 * t6170 * t5296 - 0.12e2 * t6177 * t5296 + t765 * t5407 - t776 * t5407 - 0.7e1 * t6151 * t5417 - t776 * t5442 - 0.6e1 * t6177 * t5451;
  t6269 = t1481 * t2084;
  t6275 = t570 * t2131 * t562;
  t6279 = t1492 * t2096 * t562;
  t6282 = t769 * t539;
  t6286 = t6282 * t562;
  t6287 = t538 * t6286;
  t6290 = t6136 * t562;
  t6291 = t538 * t6290;
  t6294 = t764 * t1434;
  t6295 = t220 * t6294;
  t6300 = t1430 * t6290;
  t6309 = 0.9e1 * t220 * t6282 * t1776 - 0.9e1 * t6287 * t1408 + 0.9e1 * t1768 * t6275 - 0.6e1 * t2077 * t5355 - 0.9e1 * t2594 * t5534 + 0.9e1 * t2599 * t5534 + 0.18e2 * t6291 * t4405 - 0.6e1 * t6300 * t4405 - 0.18e2 * t5323 * t6269 - 0.6e1 * t5333 * t6279 + 0.18e2 * t6291 * t5478 - 0.6e1 * t6295 * t5490 - 0.18e2 * t6295 * t5496;
  t6314 = t1430 * t4396 * t1434;
  t6331 = t2849 * params->csk_a;
  t6332 = t1439 * t6331;
  t6339 = t538 * t6294;
  t6342 = t548 * t6331;
  t6345 = 0.9e1 * t220 * t6286 * t1408 - 0.9e1 * t6287 * t1425 + 0.9e1 * t6314 * t2587 + 0.9e1 * t6314 * t2590 - 0.3e1 * t2594 * t5500 + 0.9e1 * t2599 * t5473 + 0.9e1 * t2599 * t5500 - 0.9e1 * t2602 * t5473 - 0.3e1 * t2602 * t5500 - 0.6e1 * t2602 * t5563 - 0.12e2 * t6300 * t4473 + 0.18e2 * t5521 * t6332 + 0.18e2 * t5521 * t6342 + 0.18e2 * t6339 * t5546;
  t6349 = t2126 * t562;
  t6350 = t548 * t6349;
  t6353 = t220 * t6349;
  t6358 = t538 * t6349;
  t6367 = t4552 * t761;
  t6372 = t1481 * t2131;
  t6375 = t4526 * t2096;
  t6380 = -0.9e1 * t1834 * t6372 + 0.9e1 * t6353 * t2349 - 0.9e1 * t6358 * t2629 + 0.9e1 * t6353 * t2633 - 0.9e1 * t6358 * t2633 + t4416 * t762 - 0.18e2 * t6300 * t4462 + 0.3e1 * t6137 * t4602 + 0.6e1 * t5344 * t6375 + 0.11e2 * t5376 * t6367 + 0.9e1 * t5515 * t6350 + 0.6e1 * t6141 * t5585 + 0.3e1 * t5589 * t762 + t765 * t5601;
  t6384 = t570 * t547 * t2123;
  t6387 = t1492 * t6217;
  t6390 = t4645 * t6159;
  t6410 = my_piecewise3(t105, 0, -0.11e4 / 0.729e3 * t1737);
  t6411 = my_piecewise3(t107, t6410, 0);
  t6416 = -t220 * t297 * t1443 * t564 - 0.3e1 * t220 * t2123 * t222 * t564 - 0.3e1 * t220 * t769 * t558 * t564 - t220 * t6411 * t229 + 0.3e1 * t1399 * t2132 - 0.3e1 * t1783 * t6387 - 0.6e1 * t6184 * t1840 + 0.3e1 * t2101 * t1851 + t5392 * t6390 + 0.3e1 * t6222 * t682 + 0.3e1 * t664 * t6384 - 0.2e1 * t2128 - 0.3e1 * t2139 - t774;
  t6420 = my_piecewise5(t104, 0, t105, 0, t6158 + t6202 + t6240 + t6266 + t6309 + t6345 + t6380 + t6416);
  t6427 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t1367 * t302 + 0.3e1 / 0.1e2 * t6073 + 0.9e1 / 0.2e2 * t7 * t513 * t782 - t6038 / 0.1e2 + 0.3e1 / 0.5e1 * t6080 + 0.9e1 / 0.2e2 * t7 * t204 * t2152 + t5999 - t6049 / 0.1e2 + 0.3e1 / 0.1e2 * t6088 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.11e4 / 0.729e3 * t1740 + 0.1e3 / 0.81e2 * t1743 - 0.25e2 / 0.54e2 * t1746 + 0.5e1 / 0.54e2 * t38 * t98 * t1513 + t1392 * t300 + 0.3e1 * t532 * t780 + 0.3e1 * t218 * t2150 + t103 * t6420));
  tv4rho3lapl7 = t8 * t6427 + 0.3e1 * t2157;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  tv4rho3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  tv4rho3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  tv4rho3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  tv4rho3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  tv4rho3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  tv4rho3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  tv4rho3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  tv4rho3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t6434 = t7 * t327 * t811;
  t6441 = t7 * t336 * t811 / 0.3e2;
  t6443 = t7 * t135 * t2286;
  t6457 = 0.2e1 * t2208;
  t6458 = 0.2e1 * t2210;
  t6459 = 0.2e1 * t2213;
  t6465 = t792 * t3656;
  t6466 = t1050 * t6465;
  t6467 = t3812 * t1556;
  t6470 = t359 * t6465;
  t6472 = t3658 * params->csk_a * t1556;
  t6475 = t799 * t1052;
  t6476 = t151 * t6475;
  t6478 = 0.3e1 * t6476 * t1557;
  t6479 = t359 * t6475;
  t6481 = 0.3e1 * t6479 * t1557;
  t6482 = t792 * t3651;
  t6483 = t359 * t6482;
  t6484 = t1021 * t1556;
  t6487 = t3696 * t1601;
  t6490 = t392 * t360;
  t6491 = t3714 * t6490;
  t6494 = t151 * t6465;
  t6497 = 0.6e1 * t6466 * t6467 - 0.6e1 * t6466 * t6487 - 0.18e2 * t6466 * t6491 + 0.6e1 * t6494 * t6467 - 0.11e2 * t6470 * t6472 - 0.3e1 * t6483 * t6484 + 0.4e1 * t2218 + 0.4e1 * t2234 - 0.4e1 * t2240 + 0.4e1 * t2246 - 0.4e1 * t2250 + t6457 - t6458 - t6459 - t6478 + t6481;
  t6502 = t360 * t3656;
  t6503 = t3677 * t6502;
  t6504 = t3681 * t792;
  t6509 = t1058 * t799;
  t6511 = t1109 * t6509 * params->csk_a;
  t6513 = 0.3e1 * t1589 * t6511;
  t6515 = t1109 * t1124 * t379;
  t6522 = t3677 * t6465;
  t6524 = t3705 * t3706 * t360;
  t6532 = t3714 * t1114 * t360;
  t6536 = t3696 * t3698 * t360;
  t6539 = t1050 * t6502;
  t6541 = t3696 * t2266 * params->csk_a;
  t6544 = t792 * t360;
  t6550 = t391 * t6490;
  t6554 = t1579 * t1639 * t362;
  t6559 = t2207 * t1035;
  t6561 = 0.3e1 * t6479 * t1595;
  t6562 = -0.4e1 * t2265 * t1109 * t1615 * t612 - 0.6e1 * t6503 * t3705 * t6504 * params->csk_a + t6513 - 0.2e1 * t2173 * t6515 + 0.11e2 * t6503 * t3705 * t6504 * t1093 - 0.6e1 * t6522 * t6524 - 0.12e2 * t4851 * t1100 * t602 * t612 + 0.7e1 * t6522 * t6532 - 0.12e2 * t6522 * t6536 - 0.12e2 * t6539 * t6541 + 0.3e1 * t151 * t6544 * t4753 + 0.11e2 * t6494 * t6472 - 0.3e1 * t6483 * t6550 - 0.12e2 * t2215 * t6554 - 0.18e2 * t6470 * t6467 + t6559 + t6561;
  t6564 = t2209 * t1035;
  t6565 = t1050 * t6475;
  t6567 = 0.3e1 * t6565 * t1595;
  t6570 = t359 * t6502;
  t6571 = t368 * t792;
  t6572 = t6571 * params->csk_a;
  t6573 = t3714 * t6572;
  t6582 = t3714 * t6571 * t1093;
  t6586 = t3714 * t4862 * t360;
  t6599 = 0.3e1 * t6479 * t1582;
  t6600 = t6565 * t1582;
  t6601 = -t2173 * t3581 + 0.3e1 * t2173 * t3612 + 0.3e1 * t2182 * t3581 + 0.3e1 * t2182 * t3603 - t2194 * t3581 - 0.3e1 * t2194 * t3603 + 0.18e2 * t6466 * t6586 - 0.7e1 * t6470 * t6586 + 0.18e2 * t6522 * t6487 - 0.7e1 * t6522 * t6586 + 0.7e1 * t6570 * t6573 - 0.11e2 * t6570 * t6582 - t6564 - t6567 + t6599 - t6600;
  t6606 = t1100 * t3065;
  t6608 = 0.3e1 * t1589 * t6606;
  t6610 = t3783 * t4779 * t360;
  t6619 = t391 * t392 * t1636;
  t6624 = t2209 * t1599;
  t6626 = 0.2e1 * t6565 * t1602;
  t6630 = t1100 * t6571 * t383;
  t6634 = t1021 * t159 * t1636;
  t6638 = t391 * t2269 * t383;
  t6640 = 0.3e1 * t1574 * t6638;
  t6641 = t799 * t360;
  t6644 = 0.3e1 * t151 * t6641 * t1570;
  t6646 = t1579 * t2255 * t153;
  t6649 = -0.8e1 * t1564 * t6646 - 0.3e1 * t2173 * t3645 + 0.3e1 * t2215 * t4956 + 0.3e1 * t2230 * t3641 - 0.18e2 * t389 * t6630 - 0.2e1 * t621 * t6619 - 0.2e1 * t621 * t6634 + 0.12e2 * t6466 * t6536 + 0.6e1 * t6466 * t6610 - 0.7e1 * t6470 * t6610 + t6494 * t6610 - 0.6e1 * t6503 * t6541 + t6608 - t6624 - t6626 + t6640 + t6644;
  t6653 = t6476 * t1582;
  t6660 = t1050 * t372;
  t6665 = t795 * t1054;
  t6666 = t1050 * t6665;
  t6669 = t151 * t6665;
  t6670 = t1093 * t360;
  t6671 = t6670 * t383;
  t6672 = t159 * t6671;
  t6675 = t359 * t6665;
  t6682 = t1059 * t6671;
  t6687 = t6641 * t383;
  t6690 = 0.3e1 * t151 * t6687 * t1024;
  t6691 = t359 * t6687;
  t6693 = 0.3e1 * t6691 * t1024;
  t6694 = t612 * params->csk_a;
  t6695 = t6694 * t153;
  t6696 = t159 * t6695;
  t6699 = -0.6e1 * t6660 * t1109 * t2266 * t383 - 0.18e2 * t6669 * t1629 + 0.18e2 * t6675 * t1629 + 0.3e1 * t2173 * t3586 + 0.3e1 * t2182 * t3645 + 0.18e2 * t6666 * t3534 - 0.12e2 * t4949 * t6696 + 0.2e1 * t606 * t6634 - t6522 * t6610 - 0.6e1 * t6666 * t6672 - 0.12e2 * t6666 * t6682 - 0.6e1 * t6669 * t6672 + 0.18e2 * t6675 * t6672 - t6653 + t6690 - t6693;
  t6705 = t1093 * t153;
  t6706 = t159 * t612;
  t6707 = t6705 * t6706;
  t6714 = 0.3e1 * t6691 * t1041;
  t6717 = t6705 * t612;
  t6718 = t1059 * t6717;
  t6721 = t2252 * t612;
  t6725 = t2252 * t364;
  t6726 = t151 * t6725;
  t6731 = t369 * t6717;
  t6736 = t369 * t6671;
  t6739 = t369 * t4934;
  t6743 = t1050 * t372 * t1054;
  t6744 = t1059 * t3082;
  t6748 = params->csk_a * t379 * t1023;
  t6758 = 0.12e2 * t4943 * t6696 + 0.12e2 * t2458 * t369 * t6695 - 0.4e1 * t2458 * t6707 + 0.12e2 * t2458 * t1059 * t6695 - t6714 - 0.4e1 * t4949 * t6707 - 0.8e1 * t2458 * t6718 + 0.12e2 * t5003 * t369 * t6721 + 0.12e2 * t6726 * t159 * t1656 * t155 + 0.12e2 * t4943 * t6731 - 0.12e2 * t2458 * t6731 + 0.18e2 * t6675 * t6736 - 0.3e1 * t2237 * t6739 + 0.18e2 * t6743 * t6744 - 0.3e1 * t2237 * t6748 - 0.18e2 * t1050 * t2214 * t1054 * t6670 * t3592 + 0.3e1 * t2243 * t3543;
  t6762 = t359 * t6725;
  t6763 = t369 * t612;
  t6767 = t6706 * t2248;
  t6772 = t158 * t1636;
  t6776 = t374 * t6772;
  t6779 = t612 * t612;
  t6780 = t6779 * t362;
  t6781 = t359 * t6780;
  t6790 = 0.2e1 * t6476 * t1640;
  t6795 = t374 * t1639;
  t6798 = t3783 * t1639;
  t6804 = t1100 * t2269;
  t6806 = 0.3e1 * t1643 * t6804;
  t6807 = 0.2e1 * t151 * t6780 * t376 + 0.3e1 * t151 * t6482 * t6795 - 0.12e2 * t6762 * t6763 * t2248 - 0.2e1 * t2253 * t2254 * t6772 + 0.6e1 * t6539 * t3696 * t2266 + 0.3e1 * t359 * t6544 * t3664 - 0.2e1 * t6781 * t376 - 0.2e1 * t6781 * t393 + 0.12e2 * t4943 * t6707 + 0.2e1 * t606 * t6776 + 0.6e1 * t6494 * t6798 + 0.12e2 * t6726 * t6767 - 0.12e2 * t6762 * t6767 - t6790 - t6806 - t801 - t803;
  t6808 = t2207 * t1664;
  t6814 = t1015 * t2270;
  t6815 = t1109 * t6509;
  t6816 = t1589 * t6815;
  t6819 = t151 * t799 * t379 * t385;
  t6820 = t1579 * t1663;
  t6831 = t151 * t6779;
  t6837 = 0.2e1 * t2271;
  t6838 = 0.3e1 * t2274;
  t6839 = 0.2e1 * t2281;
  t6840 = 0.2e1 * t359 * t6779 * t370 + t6503 * t3705 * t6504 + 0.11e2 * t6570 * t3714 * t6571 - 0.3e1 * t2182 * t3731 - 0.2e1 * t2194 * t6820 - t3566 * t2267 - 0.2e1 * t6831 * t385 + 0.2e1 * t6831 * t387 + 0.2e1 * t621 * t5067 - 0.4e1 * t2257 + t6808 + t6814 - t6816 - t6819 + t6837 - t6838 + t6839;
  t6844 = my_piecewise5(t58, 0, t61, 0, t6497 + t6562 + t6601 + t6649 + t6699 + t6758 + t6807 + t6840);
  t6851 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t811 + t6434 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t2286 - t6441 + t6443 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.88e3 / 0.729e3 * t38 * t345 * t251 + 0.16e3 / 0.243e3 * t38 * t141 * t627 - 0.1e2 / 0.81e2 * t38 * t43 * t1668 + t353 * t809 + 0.2e1 * t149 * t2284 + t53 * t6844));
  tv4rho2sigma20 = t8 * t6851 + 0.2e1 * t2291;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t6858 = t7 * t420 * t838;
  t6862 = t7 * t424 * t838 / 0.3e2;
  t6864 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t838 + t6858 / 0.5e1 - t6862);
  tv4rho2sigma25 = t8 * t6864 + 0.2e1 * t2300;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t6870 = t7 * t445 * t811;
  t6878 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t811 + t6870 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t2286 + t6434 / 0.1e2 - t6441 + t6443 / 0.1e2);
  tv4rho2sigma26 = t8 * t6878 + t2291 + t2306;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t6884 = t7 * t469 * t838;
  t6891 = t7 * t180 * t2433;
  t6894 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t838 + t6884 / 0.1e2 + t6858 / 0.1e2 - t6862 + 0.3e1 / 0.2e2 * t7 * t176 * t2433 + t6891 / 0.1e2);
  tv4rho2sigma211 = t8 * t6894 + t2300 + t2438;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t6902 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t811 + t6870 / 0.5e1 - t6441);
  tv4rho2sigma212 = t8 * t6902 + 0.2e1 * t2306;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t6925 = 0.2e1 * t2345;
  t6928 = 0.2e1 * t2373;
  t6932 = t822 * t1434;
  t6933 = t1430 * t6932;
  t6934 = t1093 * t539;
  t6935 = t6934 * t562;
  t6936 = t1439 * t6935;
  t6939 = t1439 * t1823;
  t6944 = t228 * params->csk_a * t675 * t222;
  t6947 = t538 * t6932;
  t6948 = t548 * t6935;
  t6952 = t826 * t539 * t562;
  t6955 = 0.3e1 * t220 * t6952 * t1408;
  t6958 = 0.3e1 * t538 * t6952 * t1408;
  t6961 = t826 * t224;
  t6963 = t538 * t6961 * t543;
  t6965 = 0.3e1 * t6963 * t4478;
  t6968 = 0.12e2 * t5470 * t6944 - 0.12e2 * t5537 * t6944 - 0.12e2 * t6933 * t6936 + 0.18e2 * t6933 * t6939 - 0.18e2 * t6933 * t6948 + 0.18e2 * t6947 * t6948 + 0.4e1 * t2350 + 0.4e1 * t2359 - 0.4e1 * t2378 - 0.4e1 * t2383 + 0.4e1 * t2389 - t6925 + t6928 + t6955 - t6958 - t6965;
  t6969 = t2346 * t1434;
  t6972 = t228 * t551 * params->csk_a;
  t6986 = t1093 * t545;
  t6987 = t2356 * t675;
  t6988 = t6986 * t6987;
  t6991 = t3274 * t675;
  t6997 = t1439 * t1093 * t675 * t222;
  t7000 = t228 * t675;
  t7001 = t5499 * t7000;
  t7013 = t5465 * t675;
  t7017 = t6934 * t4385;
  t7022 = t819 * t4501;
  t7023 = t1430 * t7022;
  t7025 = t4526 * t1493 * t539;
  t7028 = t538 * t7022;
  t7030 = t4552 * t1497 * t539;
  t7033 = 0.12e2 * t220 * t2419 * t543 * t228 * t5513 * t675 + 0.12e2 * t5508 * t1439 * t6991 - 0.18e2 * t220 * t6969 * t6972 + 0.12e2 * t2622 * t548 * t7013 + 0.18e2 * t538 * t6969 * t6972 + 0.12e2 * t5508 * t548 * t6991 - 0.12e2 * t2584 * t6988 - 0.8e1 * t2584 * t6997 - 0.4e1 * t2584 * t7001 + 0.18e2 * t6933 * t4478 + 0.12e2 * t5470 * t6988 + 0.12e2 * t5470 * t7001 - 0.4e1 * t5537 * t7001 - 0.6e1 * t6933 * t7017 + 0.18e2 * t6947 * t7017 - 0.12e2 * t7023 * t7025 - 0.11e2 * t7028 * t7030;
  t7035 = t4539 * t7022;
  t7038 = t826 * t1432;
  t7039 = t1430 * t7038;
  t7041 = 0.3e1 * t7039 * t1793;
  t7042 = t4530 * t1792;
  t7045 = t220 * t7038;
  t7047 = 0.3e1 * t7045 * t1759;
  t7048 = t538 * t7038;
  t7050 = 0.3e1 * t7048 * t1759;
  t7051 = t220 * t7022;
  t7053 = t5583 * t1839 * params->csk_a;
  t7059 = t1838 * t1839 * t541;
  t7062 = t4526 * t1799;
  t7065 = t227 * t3697;
  t7067 = t5583 * t7065 * t539;
  t7074 = t7045 * t1780;
  t7076 = 0.3e1 * t7048 * t1780;
  t7077 = t7039 * t1780;
  t7078 = -0.12e2 * t2347 * t7059 - 0.6e1 * t7023 * t7062 + 0.6e1 * t7023 * t7067 - 0.11e2 * t7028 * t7053 - 0.7e1 * t7028 * t7067 + 0.7e1 * t7035 * t7030 - 0.7e1 * t7035 * t7042 - t7035 * t7067 + 0.11e2 * t7051 * t7053 + t7051 * t7067 - t7041 - t7047 + t7050 - t7074 + t7076 - t7077;
  t7082 = t4526 * t4650 * t539;
  t7088 = 0.3e1 * t7048 * t1793;
  t7090 = t547 * t539 * params->csk_a;
  t7091 = t4552 * t7090;
  t7094 = t539 * t4501;
  t7095 = t4539 * t7094;
  t7097 = t4526 * t2410 * params->csk_a;
  t7100 = t1481 * t3138;
  t7102 = 0.3e1 * t1783 * t7100;
  t7104 = t553 * t554 * t1831;
  t7109 = t2344 * t1797;
  t7110 = t1438 * t826;
  t7112 = t1492 * t7110 * params->csk_a;
  t7114 = 0.3e1 * t1783 * t7112;
  t7116 = 0.2e1 * t7039 * t1800;
  t7119 = t4526 * t3141;
  t7125 = t570 * t571 * t1831;
  t7129 = t1492 * t1507 * t558;
  t7132 = -0.3e1 * t2319 * t4452 - 0.2e1 * t2319 * t7129 + 0.3e1 * t2340 * t4452 + 0.2e1 * t669 * t7104 - 0.2e1 * t684 * t7125 + 0.18e2 * t7023 * t7042 + 0.12e2 * t7023 * t7082 - 0.18e2 * t7023 * t7091 - 0.7e1 * t7028 * t7042 - 0.12e2 * t7035 * t7082 - 0.6e1 * t7095 * t7097 + 0.18e2 * t7095 * t7119 + t7088 + t7102 - t7109 + t7114 - t7116;
  t7135 = t4628 * t819;
  t7141 = t4645 * t4656 * t539;
  t7151 = t570 * t2413 * t562;
  t7153 = 0.3e1 * t1768 * t7151;
  t7156 = 0.3e1 * t220 * t6961 * t4434;
  t7157 = t4522 * t1758;
  t7162 = t2344 * t1419;
  t7170 = t2372 * t1419;
  t7174 = 0.11e2 * t7095 * t4645 * t7135 * t1093 - 0.6e1 * t7095 * t4645 * t7135 * params->csk_a - t2319 * t4393 + 0.3e1 * t2319 * t4425 + 0.3e1 * t2319 * t4467 + 0.3e1 * t2340 * t4393 + 0.3e1 * t2340 * t4412 - t2364 * t4393 - 0.3e1 * t2364 * t4412 + 0.6e1 * t7023 * t7157 - 0.18e2 * t7028 * t7157 - 0.6e1 * t7035 * t7141 + t7153 + t7156 - t7162 + t7170;
  t7181 = t547 * t819;
  t7183 = t1481 * t7181 * t562;
  t7187 = t1838 * t681 * t675;
  t7196 = t1430 * t551;
  t7204 = t819 * t4496;
  t7205 = t538 * t7204;
  t7206 = t1405 * t1758;
  t7209 = t570 * t7090;
  t7212 = t819 * t539;
  t7221 = params->csk_a * t558 * t1407;
  t7224 = t548 * t5456;
  t7230 = -0.4e1 * t2409 * t1492 * t1803 * t675 + 0.3e1 * t2347 * t5527 - 0.18e2 * t568 * t7183 - 0.8e1 * t1764 * t7187 + 0.7e1 * t7028 * t7091 - 0.2e1 * t684 * t7104 + 0.3e1 * t2355 * t4443 - 0.6e1 * t7196 * t1492 * t2410 * t562 - 0.12e2 * t1756 * t1481 * t6987 - 0.3e1 * t7205 * t7206 - 0.3e1 * t7205 * t7209 + 0.3e1 * t220 * t7212 * t5319 + 0.6e1 * t7051 * t7157 + 0.3e1 * t2386 * t4488 - 0.3e1 * t2375 * t7221 - 0.3e1 * t2375 * t7224 - 0.6e1 * t220 * t6932 * t7017;
  t7232 = t2636 * t7013;
  t7237 = t5309 * t7013;
  t7240 = t1492 * t7110;
  t7241 = t1783 * t7240;
  t7244 = t220 * t826 * t558 * t564;
  t7245 = t227 * t1831;
  t7249 = t553 * t7245;
  t7252 = t2372 * t1851;
  t7253 = t1481 * t2413;
  t7255 = 0.3e1 * t1834 * t7253;
  t7258 = t538 * t7094;
  t7264 = t1430 * t7094;
  t7270 = t675 * t675;
  t7271 = t7270 * t541;
  t7272 = t538 * t7271;
  t7275 = 0.6e1 * t7264 * t4526 * t2410 - 0.2e1 * t2420 * t2421 * t7245 + 0.11e2 * t7258 * t4552 * t7181 + 0.12e2 * t1821 * t7232 - 0.3e1 * t2340 * t4595 - 0.2e1 * t2364 * t4592 - 0.12e2 * t2622 * t7232 - 0.12e2 * t2622 * t7237 - 0.2e1 * t7272 * t555 + 0.2e1 * t684 * t5604 + 0.2e1 * t669 * t7249 - t7241 - t7244 + t7252 - t7255 - t828 - t830;
  t7285 = 0.2e1 * t7045 * t1840;
  t7287 = t553 * t1839;
  t7290 = t5583 * t1839;
  t7296 = t1399 * t2414;
  t7297 = t220 * t7270;
  t7305 = 0.2e1 * t2391;
  t7306 = 0.2e1 * t2399;
  t7307 = 0.2e1 * t2415;
  t7308 = 0.3e1 * t2418;
  t7310 = 0.2e1 * t220 * t7271 * t555 + 0.3e1 * t220 * t7204 * t7287 + 0.3e1 * t538 * t7212 * t4618 + t7095 * t4645 * t7135 + 0.2e1 * t538 * t7270 * t549 - t4428 * t2411 - 0.2e1 * t7297 * t564 + 0.2e1 * t7297 * t566 - 0.2e1 * t7272 * t572 + 0.6e1 * t7051 * t7290 - 0.4e1 * t2424 - t7285 + t7296 - t7305 + t7306 + t7307 - t7308;
  t7314 = my_piecewise5(t104, 0, t105, 0, t6968 + t7033 + t7078 + t7132 + t7174 + t7230 + t7275 + t7310);
  t7321 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t838 + t6884 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t2433 - t6862 + t6891 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.88e3 / 0.729e3 * t38 * t524 * t268 + 0.16e3 / 0.243e3 * t38 * t210 * t690 - 0.1e2 / 0.81e2 * t38 * t93 * t1864 + t532 * t836 + 0.2e1 * t218 * t2431 + t103 * t7314));
  tv4rho2sigma217 = t8 * t7321 + 0.2e1 * t2438;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t7328 = t7 * t327 * t866;
  t7335 = t7 * t336 * t866 / 0.3e2;
  t7337 = t7 * t135 * t2547;
  t7361 = t5761 * t3658;
  t7362 = t1050 * t7361;
  t7363 = t6670 * t2485;
  t7366 = t151 * t7361;
  t7369 = t3697 * t248;
  t7370 = t7369 * t1594;
  t7373 = t7369 * t360;
  t7374 = t1059 * t7373;
  t7377 = t6502 * t3658;
  t7378 = t3677 * t7377;
  t7379 = t853 * params->csk_a;
  t7380 = t1059 * t7379;
  t7384 = t359 * t853 * t3651;
  t7387 = t2466 * t360;
  t7396 = t359 * t7361;
  t7397 = t1627 * t2485;
  t7404 = 0.3e1 * t151 * t1917 * t3651 * t851 - 0.6e1 * t7362 * t1059 * t7387 - 0.18e2 * t5013 * t369 * t1945 - 0.3e1 * t7384 * t6484 - 0.3e1 * t7384 * t6550 + 0.6e1 * t7362 * t7363 + 0.18e2 * t7362 * t7370 + 0.12e2 * t7362 * t7374 + 0.6e1 * t7366 * t7363 - 0.6e1 * t7378 * t7380 - 0.11e2 * t7396 * t7397 + 0.4e1 * t2473 + 0.4e1 * t2499 - 0.4e1 * t2504 + 0.4e1 * t2509 - 0.4e1 * t2513 + t6457 - t6458 - t6459;
  t7409 = t159 * t7373;
  t7415 = t3677 * t7361;
  t7419 = t5774 * t1054;
  t7420 = t359 * t7419;
  t7423 = t1050 * t7419;
  t7434 = t1050 * t7377;
  t7437 = t151 * t7419;
  t7445 = t3677 * t4736 * t3658;
  t7446 = t281 * t1093;
  t7453 = t2459 * t612;
  t7454 = t369 * t7453;
  t7457 = 0.7e1 * t7445 * t369 * t7446 * t360 + 0.6e1 * t2465 * t6707 + 0.6e1 * t2465 * t6731 + 0.6e1 * t7420 * t2468 - 0.6e1 * t7423 * t2468 - 0.2e1 * t2478 * t6707 + 0.6e1 * t7420 * t2479 - 0.2e1 * t7423 * t2479 - 0.2e1 * t7437 * t2479 - 0.2e1 * t2483 * t6707 + 0.6e1 * t5030 * t7454 + 0.6e1 * t7362 * t7409 - 0.18e2 * t7396 * t7363 + 0.11e2 * t7366 * t7397 + t7366 * t7409 - 0.7e1 * t7396 * t7370 - 0.7e1 * t7415 * t7370 - 0.12e2 * t7434 * t7380 - 0.7e1 * t7396 * t7409 - t7415 * t7409;
  t7461 = t718 * params->csk_a;
  t7462 = t7461 * t248;
  t7463 = t1059 * t7462;
  t7468 = t1059 * t7453;
  t7473 = t369 * t7462;
  t7494 = t7446 * t248;
  t7503 = t369 * t7379;
  t7506 = t159 * t5031;
  t7515 = -0.6e1 * t2483 * t6731 + 0.6e1 * t5030 * t7463 - 0.4e1 * t7423 * t2493 + 0.6e1 * t5030 * t7468 - 0.4e1 * t2483 * t6718 + 0.6e1 * t5030 * t7473 - 0.12e2 * t5695 * t159 * t1620 + 0.6e1 * t7420 * t2486 + 0.6e1 * t2465 * t6696 - 0.6e1 * t6743 * t1059 * t2471 - 0.6e1 * t7437 * t2486 - 0.6e1 * t2478 * t6696 - 0.2e1 * t2483 * t1059 * t2466 * t379 + 0.11e2 * t7378 * t3682 * t7494 - 0.6e1 * t7415 * t3682 * t7373 + 0.3e1 * t2496 * t5731 - 0.18e2 * t7434 * t7503 - 0.3e1 * t2478 * t7506 + 0.7e1 * t359 * t7377 * t7503 - 0.11e2 * t7396 * t369 * t7387;
  t7517 = t2466 * t369 * t379;
  t7523 = t1977 * t383;
  t7524 = t369 * t7523;
  t7527 = t2536 * t383;
  t7536 = t1656 * t383;
  t7540 = t2466 * t4939;
  t7560 = t1100 * t710 * t612;
  t7567 = -0.3e1 * t2483 * t7517 + 0.6e1 * t359 * t5009 * t2498 + 0.6e1 * t2496 * t7524 + 0.6e1 * t151 * t7527 * t2217 + 0.3e1 * t2465 * t7506 - 0.6e1 * t7378 * t3682 * t7379 + 0.6e1 * t1951 * t159 * t7536 - t2483 * t7540 + 0.3e1 * t2458 * t5717 - t2478 * t7540 + 0.3e1 * t2465 * t7540 + 0.3e1 * t2458 * t1059 * t5716 + 0.3e1 * t2465 * t7517 + 0.3e1 * t2472 * t4956 + 0.18e2 * t7378 * t1059 * t7494 - 0.12e2 * t7415 * t7374 - 0.6e1 * t4851 * t7560 - t725 * t6634 - t5824 * t861 - 0.2e1 * t1903 * t2226;
  t7573 = t1109 * t4891 * t281;
  t7588 = t1100 * t1971 * t153;
  t7599 = t369 * t281;
  t7600 = t3652 * t7599;
  t7622 = -t725 * t6619 - t3566 * t2521 - 0.2e1 * t2265 * t7573 - 0.2e1 * t2265 * t1109 * t1615 * t718 + t6503 * t3705 * t4836 * t281 + t5794 * t851 - t5824 * t851 - 0.2e1 * t1903 * t2179 - 0.6e1 * t1554 * t7588 - 0.4e1 * t5817 * t2526 - 0.4e1 * t1910 * t6646 + 0.3e1 * t854 * t3652 * t1556 + 0.3e1 * t359 * t1567 * t7600 + 0.6e1 * t5762 * t3783 * t856 * t360 + 0.6e1 * t6539 * t3696 * t2520 - 0.3e1 * t1554 * t5896 - 0.2e1 * t1910 * t1579 * t856 * t379 + 0.11e2 * t6570 * t3714 * t710 * t248 + 0.2e1 * t1942 * t2179;
  t7624 = t714 * t6634 - t6478 + t6481 + t6513 + t6559 + t6561 - t6564 - t6567 + t6599 - t6600 + t6608 - t6624 - t6626 + t6640 + t6644 - t6653 + t6690 - t6693 - t6714 - t801;
  t7644 = t1094 * t360;
  t7645 = t7644 * t3550;
  t7648 = t1050 * t2471;
  t7651 = t159 * t1093;
  t7663 = t359 * t5721;
  t7666 = t359 * t1950;
  t7668 = t618 * t383;
  t7669 = t6694 * t68 * t7668;
  t7672 = t4749 * t2507;
  t7685 = t369 * t1093;
  t7689 = -t151 * t1958 * t248 * t385 - 0.2e1 * t151 * t718 * t612 * t385 - t151 * t281 * t1636 * t385 + t5794 * t857 + 0.18e2 * t2501 * t1072 * t360 * t3550 - 0.18e2 * t5695 * t2506 * t1620 + 0.18e2 * t2501 * t7645 - 0.6e1 * t7648 * t7645 - 0.6e1 * t5695 * t7651 * t1620 - 0.3e1 * t2501 * t4940 + 0.18e2 * t6743 * t7599 * t3207 - 0.18e2 * t7648 * t7644 * t3592 - 0.6e1 * t7663 * t2508 - 0.6e1 * t7666 * t7669 - 0.6e1 * t7663 * t7672 - 0.6e1 * t7666 * t4749 * t7536 + 0.6e1 * t5722 * t2508 + 0.6e1 * t1951 * t7669 + 0.3e1 * t1951 * t2506 * t5004 + 0.18e2 * t5725 * t7685 * t1620;
  t7692 = t1059 * t281;
  t7696 = t1109 * t1058;
  t7710 = -0.3e1 * t2501 * t4935 + 0.18e2 * t6743 * t7692 * t3207 - 0.12e2 * t7648 * t7696 * t6670 * t362 + 0.2e1 * t1942 * t2259 + t714 * t6776 + t4807 * t711 + 0.2e1 * t1561 * t1972 + t621 * t5926 - t6790 - t6806 + t6808 + t6814 - t6816 - t6819 - t855 + t6837 - t6838 + t6839 - 0.2e1 * t2538 - 0.2e1 * t2541;
  t7714 = my_piecewise5(t58, 0, t61, 0, t7404 + t7457 + t7515 + t7567 + t7622 + t7624 + t7689 + t7710);
  t7721 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t866 + t7328 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t2547 - t7335 + t7337 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.1e3 / 0.243e3 * t2166 - 0.25e2 / 0.81e2 * t2169 + 0.5e1 / 0.54e2 * t38 * t48 * t1668 - 0.44e3 / 0.729e3 * t38 * t345 * t284 + 0.8e2 / 0.243e3 * t38 * t141 * t729 - 0.5e1 / 0.81e2 * t38 * t43 * t1985 + t353 * t864 + 0.2e1 * t149 * t2545 + t53 * t7714));
  tv4rho2sigmalapl0 = t8 * t7721 + 0.2e1 * t2552;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  t7728 = t7 * t420 * t894;
  t7732 = t7 * t424 * t894 / 0.3e2;
  t7734 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t894 + t7728 / 0.5e1 - t7732);
  tv4rho2sigmalapl5 = t8 * t7734 + 0.2e1 * t2561;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  t7740 = t7 * t445 * t866;
  t7748 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t866 + t7740 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t2547 + t7328 / 0.1e2 - t7335 + t7337 / 0.1e2);
  tv4rho2sigmalapl6 = t8 * t7748 + t2552 + t2567;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  t7754 = t7 * t469 * t894;
  t7761 = t7 * t180 * t2673;
  t7764 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t894 + t7754 / 0.1e2 + t7728 / 0.1e2 - t7732 + 0.3e1 / 0.2e2 * t7 * t176 * t2673 + t7761 / 0.1e2);
  tv4rho2sigmalapl11 = t8 * t7764 + t2561 + t2678;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  t7772 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t866 + t7740 / 0.5e1 - t7335);
  tv4rho2sigmalapl12 = t8 * t7772 + 0.2e1 * t2567;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  t7812 = t538 * t2115;
  t7816 = t769 * t224 * t543;
  t7817 = t538 * t7816;
  t7818 = t5309 * t2637;
  t7823 = t1456 * t539;
  t7824 = t7823 * t4404;
  t7827 = t1430 * t2616;
  t7830 = t228 * t1093;
  t7834 = t551 * t1434;
  t7835 = t1430 * t7834;
  t7836 = t1439 * t297;
  t7840 = t1492 * t1438;
  t7848 = t548 * t1093;
  t7852 = -t6925 + t6928 + 0.4e1 * t2618 + 0.4e1 * t2625 - 0.4e1 * t2630 - 0.4e1 * t2634 + 0.4e1 * t2639 + 0.18e2 * t2627 * t1460 * t539 * t4404 - 0.18e2 * t6295 * t2636 * t1815 - 0.6e1 * t7812 * t7232 - 0.6e1 * t7817 * t7818 - 0.6e1 * t7812 * t7237 + 0.18e2 * t2627 * t7824 - 0.6e1 * t7827 * t7824 - 0.6e1 * t6295 * t7830 * t1815 + 0.18e2 * t7835 * t7836 * t3275 - 0.12e2 * t7827 * t7840 * t6934 * t541 + 0.3e1 * t2116 * t2636 * t5516 + 0.18e2 * t6339 * t7848 * t1815;
  t7857 = t548 * t297;
  t7864 = t220 * t7816;
  t7871 = t6140 * t4505;
  t7872 = t220 * t7871;
  t7873 = t2595 * t539;
  t7874 = t228 * t7873;
  t7877 = t7094 * t4505;
  t7878 = t4539 * t7877;
  t7879 = t881 * params->csk_a;
  t7880 = t1439 * t7879;
  t7888 = t228 * t3274 * t539;
  t7892 = t538 * t881 * t4496;
  t7895 = t1430 * t7871;
  t7903 = t538 * t7871;
  t7906 = t3697 * t265;
  t7907 = t7906 * t539;
  t7908 = t1439 * t7907;
  t7911 = t548 * t7907;
  t7914 = t228 * t7907;
  t7918 = -0.3e1 * t2627 * t5457 - 0.3e1 * t2627 * t5462 + 0.18e2 * t7835 * t7857 * t3275 - 0.18e2 * t7827 * t7823 * t4461 + 0.6e1 * t7864 * t2638 + 0.6e1 * t2116 * t7232 - 0.6e1 * t7817 * t2638 + 0.6e1 * t7872 * t7874 - 0.6e1 * t7878 * t7880 + 0.3e1 * t220 * t2080 * t4496 * t879 + 0.11e2 * t7872 * t7888 - 0.3e1 * t7892 * t7209 - 0.6e1 * t7895 * t1439 * t7873 - 0.12e2 * t2617 * t7059 - 0.3e1 * t7892 * t7206 - 0.11e2 * t7903 * t7888 + 0.12e2 * t7895 * t7908 - 0.7e1 * t7903 * t7911 + t7872 * t7914 - 0.7e1 * t7903 * t7914;
  t7922 = t4539 * t7871;
  t7933 = t4539 * t5266 * t4505;
  t7934 = t297 * t1093;
  t7941 = t6166 * t1434;
  t7942 = t220 * t7941;
  t7945 = t538 * t7941;
  t7952 = t1430 * t7941;
  t7957 = t1430 * t7877;
  t7965 = t769 * params->csk_a * t265;
  t7966 = t548 * t7965;
  t7971 = t2585 * t675;
  t7972 = t548 * t7971;
  t7975 = 0.7e1 * t7933 * t548 * t7934 * t539 - 0.2e1 * t2594 * t7001 - 0.2e1 * t7942 * t2597 + 0.6e1 * t7945 * t2597 - 0.2e1 * t7952 * t2597 + 0.6e1 * t2599 * t6988 + 0.6e1 * t2599 * t7001 - 0.2e1 * t2602 * t7001 + 0.6e1 * t7945 * t2613 - 0.6e1 * t7952 * t2613 + 0.6e1 * t5508 * t7966 + 0.6e1 * t5508 * t7972 + 0.6e1 * t7895 * t7874 - 0.18e2 * t7903 * t7874 - 0.12e2 * t7957 * t7880 + 0.18e2 * t7895 * t7911 + 0.6e1 * t7895 * t7914 - 0.12e2 * t7922 * t7908 - 0.7e1 * t7922 * t7911 - t7922 * t7914;
  t7996 = t2595 * t548 * t558;
  t7999 = t7934 * t265;
  t8003 = t548 * t7879;
  t8006 = t228 * t5509;
  t8031 = t2137 * t562;
  t8032 = t548 * t8031;
  t8035 = -0.6e1 * t2602 * t6988 - 0.6e1 * t7835 * t1439 * t2616 - 0.6e1 * t7942 * t2605 - 0.6e1 * t2594 * t6944 + 0.6e1 * t7945 * t2605 + 0.6e1 * t2599 * t6944 + 0.3e1 * t2617 * t5527 - 0.18e2 * t538 * t7834 * t548 * t2616 - 0.3e1 * t2602 * t7996 + 0.18e2 * t7878 * t1439 * t7999 - 0.18e2 * t7957 * t8003 - 0.3e1 * t2594 * t8006 + 0.7e1 * t538 * t7877 * t8003 - 0.11e2 * t7903 * t548 * t7873 - 0.2e1 * t2602 * t1439 * t2595 * t558 + 0.11e2 * t7878 * t4629 * t7999 - 0.6e1 * t7922 * t4629 * t7907 + 0.6e1 * t2116 * t228 * t7013 + 0.6e1 * t538 * t5541 * t2624 + 0.6e1 * t2622 * t8032;
  t8040 = t1439 * t7965;
  t8045 = t1439 * t7971;
  t8053 = t228 * t2637;
  t8056 = t2595 * t5461;
  t8058 = t2585 * t558;
  t8076 = t1481 * t2131 * t265;
  t8079 = 0.3e1 * t2599 * t8006 + 0.6e1 * t5508 * t8040 - 0.4e1 * t7952 * t2610 + 0.6e1 * t5508 * t8045 - 0.4e1 * t2602 * t6997 - 0.6e1 * t7878 * t4629 * t7879 + 0.6e1 * t7864 * t8053 - t2602 * t8056 + 0.3e1 * t2584 * t548 * t8058 - t2594 * t8056 + 0.3e1 * t2599 * t8056 + 0.3e1 * t2622 * t6350 + 0.3e1 * t2584 * t1439 * t8058 + 0.3e1 * t2599 * t7996 + t6955 - t6958 - t6965 + t7095 * t4645 * t5393 * t297 - 0.6e1 * t5338 * t8076;
  t8081 = t1481 * t761 * t675;
  t8094 = t1492 * t5387 * t297;
  t8117 = t4601 * t7857;
  t8127 = -0.6e1 * t5338 * t8081 - t6155 * t879 - 0.2e1 * t2074 * t2337 - t776 * t7104 - t6155 * t889 - 0.2e1 * t2074 * t2325 - t776 * t7125 - t4428 * t2653 - 0.2e1 * t2409 * t8094 - 0.2e1 * t2409 * t1492 * t1803 * t769 + t6222 * t879 + 0.2e1 * t2101 * t2337 + t765 * t7104 - 0.4e1 * t2077 * t7187 - 0.4e1 * t6184 * t2656 + 0.3e1 * t882 * t4601 * t1758 + 0.6e1 * t6141 * t5583 * t884 * t539 + 0.3e1 * t538 * t1773 * t8117 + 0.6e1 * t7264 * t4526 * t2652 - 0.2e1 * t2077 * t1838 * t884 * t558;
  t8142 = -t220 * t297 * t1831 * t564 - 0.2e1 * t220 * t769 * t675 * t564 + 0.11e2 * t7258 * t4552 * t761 * t265 - 0.3e1 * t1756 * t6210 - t7041 - t7047 + t7050 - t7074 + t7076 - t7077 + t7088 + t7102 - t7109 + t7114 - t7116 + t7153 + t7156 - t7162 + t7170 - t828;
  t8156 = -t220 * t2123 * t265 * t564 + 0.2e1 * t1752 * t2132 + 0.2e1 * t2101 * t2426 + t5363 * t762 + t6222 * t885 + t684 * t6384 + t765 * t7249 - 0.2e1 * t2665 - 0.2e1 * t2668 - t7241 - t7244 + t7252 - t7255 - t7285 + t7296 - t7305 + t7306 + t7307 - t7308 - t883;
  t8160 = my_piecewise5(t104, 0, t105, 0, t7852 + t7918 + t7975 + t8035 + t8079 + t8127 + t8142 + t8156);
  t8167 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t894 + t7754 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t2673 - t7732 + t7761 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * (0.1e3 / 0.243e3 * t2312 - 0.25e2 / 0.81e2 * t2315 + 0.5e1 / 0.54e2 * t38 * t98 * t1864 - 0.44e3 / 0.729e3 * t38 * t524 * t300 + 0.8e2 / 0.243e3 * t38 * t210 * t780 - 0.5e1 / 0.81e2 * t38 * t93 * t2150 + t532 * t892 + 0.2e1 * t218 * t2671 + t103 * t8160));
  tv4rho2sigmalapl17 = t8 * t8167 + 0.2e1 * t2678;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  tv4rho2sigmatau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  tv4rho2sigmatau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  tv4rho2sigmatau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  tv4rho2sigmatau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  tv4rho2sigmatau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  tv4rho2sigmatau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  t8174 = t7 * t327 * t917;
  t8181 = t7 * t336 * t917 / 0.3e2;
  t8183 = t7 * t135 * t2764;
  t8196 = t2506 * t7523;
  t8206 = t2459 * t718;
  t8211 = t1093 * t718 * t153;
  t8215 = t2749 * t364;
  t8216 = t151 * t8215;
  t8228 = 0.12e2 * t8216 * t159 * t5001 * t718 - 0.8e1 * t2483 * t1059 * t8211 + 0.12e2 * t5030 * t1059 * t8206 + 0.12e2 * t5030 * t369 * t8206 - 0.12e2 * t7666 * t4749 * t7523 + 0.12e2 * t1951 * t8196 - 0.3e1 * t2693 * t6739 - 0.3e1 * t2693 * t6748 + 0.12e2 * t7666 * t7524 - 0.12e2 * t7666 * t8196 - 0.4e1 * t2694 - 0.4e1 * t2696 + 0.4e1 * t2701 + t6457 - t6458 - t6459;
  t8231 = t905 * t1054;
  t8232 = t1050 * t8231;
  t8235 = t369 * t8211;
  t8240 = t159 * t8211;
  t8245 = t2691 * t1054;
  t8246 = t151 * t8245;
  t8248 = t159 * t372 * params->csk_a;
  t8251 = t359 * t8245;
  t8258 = t151 * t8231;
  t8261 = t359 * t8231;
  t8272 = t159 * t7461 * t153;
  t8277 = 0.18e2 * t8232 * t1059 * t1628 + 0.12e2 * t2465 * t8235 + 0.12e2 * t2465 * t8240 - 0.4e1 * t2478 * t8240 - 0.12e2 * t2478 * t8272 - 0.12e2 * t2483 * t8235 - 0.4e1 * t2483 * t8240 + 0.3e1 * t2700 * t3543 + 0.18e2 * t8232 * t3534 - 0.6e1 * t8232 * t6672 - 0.6e1 * t8258 * t6672 + 0.18e2 * t8261 * t6672 - 0.12e2 * t8232 * t6682 - 0.18e2 * t8232 * t6736 + 0.18e2 * t8261 * t6736 - 0.18e2 * t8246 * t8248 + 0.18e2 * t8251 * t8248;
  t8282 = t374 * t375 * t1958;
  t8289 = t368 * t360;
  t8294 = t902 * t3656;
  t8295 = t359 * t8294;
  t8307 = t1109 * t1937 * t718;
  t8320 = -0.18e2 * t911 * t1100 * t8289 * t383 - 0.8e1 * t1910 * t1579 * t618 * t718 - 0.4e1 * t2265 * t8307 + 0.12e2 * t2465 * t8272 - t2704 * t3581 - 0.3e1 * t2704 * t3603 + 0.3e1 * t2706 * t3581 + 0.3e1 * t2706 * t3603 + 0.3e1 * t2706 * t3645 - t2709 * t3581 + 0.3e1 * t2709 * t3612 - 0.3e1 * t2709 * t3645 + 0.3e1 * t2730 * t4956 - 0.11e2 * t8295 * t6472 + 0.2e1 * t714 * t8282 - 0.2e1 * t725 * t8282;
  t8324 = t1109 * t2746 * t383;
  t8327 = t1050 * t8294;
  t8335 = t3681 * t902;
  t8337 = t3705 * t8335 * params->csk_a;
  t8340 = t3677 * t8294;
  t8353 = t151 * t8294;
  t8357 = t3696 * t2746 * params->csk_a;
  t8366 = -0.12e2 * t8327 * t3696 * t1058 * t360 * params->csk_a + 0.3e1 * t2709 * t3586 + 0.3e1 * t2737 * t3641 + 0.11e2 * t8353 * t6472 + 0.18e2 * t8340 * t6487 + 0.7e1 * t8295 * t6491 - 0.6e1 * t6503 * t8337 - 0.6e1 * t6503 * t8357 + 0.7e1 * t8340 * t6532 - 0.12e2 * t8340 * t6536 + 0.18e2 * t8327 * t6586 - 0.7e1 * t8340 * t6586 - 0.7e1 * t8295 * t6610 + 0.6e1 * t8327 * t6610 - t8340 * t6610 + t8353 * t6610 - 0.6e1 * t6660 * t8324;
  t8384 = t3705 * t8335 * t1093;
  t8391 = t902 * t3651;
  t8392 = t359 * t8391;
  t8397 = t902 * t360;
  t8409 = -0.2e1 * t725 * t391 * t392 * t1958 + 0.3e1 * t151 * t8397 * t4753 - 0.12e2 * t1899 * t7588 - 0.2e1 * t2709 * t6515 - 0.12e2 * t2730 * t6554 - 0.18e2 * t8295 * t6467 + 0.6e1 * t8327 * t6467 + 0.6e1 * t8353 * t6467 - 0.3e1 * t8392 * t6484 - 0.18e2 * t8327 * t6491 + 0.11e2 * t6503 * t8384 - 0.6e1 * t8340 * t6524 - 0.11e2 * t8295 * t6532 + 0.12e2 * t8327 * t6536 - 0.3e1 * t8392 * t6550 - 0.7e1 * t8295 * t6586;
  t8412 = -0.6e1 * t8327 * t6487 - t6478 + t6481 + t6513 + t6559 + t6561 - t6564 - t6567 + t6599 - t6600 + t6608 - t6624 - t6626 + t6640 + t6644 - t6653 + t6690;
  t8414 = t718 * t718;
  t8415 = t8414 * t362;
  t8416 = t359 * t8415;
  t8425 = t151 * t8391;
  t8438 = t3705 * t8335;
  t8440 = t158 * t1958;
  t8449 = -t6693 - t6714 - t909 - t801 - 0.2e1 * t8416 * t376 + 0.2e1 * t151 * t8415 * t376 + 0.11e2 * t8295 * t3714 * t8289 + 0.3e1 * t8425 * t6795 + 0.6e1 * t8353 * t6798 + 0.3e1 * t359 * t8397 * t3664 - 0.2e1 * t8416 * t393 - 0.2e1 * t2704 * t6820 - t3566 * t2747 + t6503 * t8438 - 0.2e1 * t2750 * t2254 * t8440 + 0.2e1 * t714 * t374 * t8440 + 0.2e1 * t725 * t5926;
  t8452 = t3696 * t2746;
  t8455 = t151 * t8414;
  t8466 = 0.2e1 * t359 * t8414 * t370 - 0.3e1 * t2706 * t3731 - 0.2e1 * t8455 * t385 + 0.2e1 * t8455 * t387 + 0.6e1 * t6539 * t8452 + 0.4e1 * t2731 + 0.4e1 * t2738 - 0.4e1 * t2753 - t6790 - t6806 + t6808 + t6814 - t6816 - t6819 + t6837 - t6838 + t6839;
  t8470 = my_piecewise5(t58, 0, t61, 0, t8228 + t8277 + t8320 + t8366 + t8409 + t8412 + t8449 + t8466);
  t8477 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t323 * t917 + t8174 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t130 * t2764 - t8181 + t8183 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t32 * (0.2e3 / 0.243e3 * t2451 - 0.5e2 / 0.81e2 * t2454 + 0.5e1 / 0.27e2 * t38 * t48 * t1985 + t353 * t915 + 0.2e1 * t149 * t2762 + t53 * t8470));
  tv4rho2lapl20 = t8 * t8477 + 0.2e1 * t2769;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  t8484 = t7 * t420 * t940;
  t8488 = t7 * t424 * t940 / 0.3e2;
  t8490 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t416 * t940 + t8484 / 0.5e1 - t8488);
  tv4rho2lapl22 = t8 * t8490 + 0.2e1 * t2778;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  t8496 = t7 * t445 * t917;
  t8504 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t441 * t917 + t8496 / 0.1e2 + 0.3e1 / 0.2e2 * t7 * t193 * t2764 + t8174 / 0.1e2 - t8181 + t8183 / 0.1e2);
  tv4rho2lapl23 = t8 * t8504 + t2769 + t2784;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  t8510 = t7 * t469 * t940;
  t8517 = t7 * t180 * t2867;
  t8520 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t465 * t940 + t8510 / 0.1e2 + t8484 / 0.1e2 - t8488 + 0.3e1 / 0.2e2 * t7 * t176 * t2867 + t8517 / 0.1e2);
  tv4rho2lapl25 = t8 * t8520 + t2778 + t2872;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  t8528 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t496 * t917 + t8496 / 0.5e1 - t8181);
  tv4rho2lapl26 = t8 * t8528 + 0.2e1 * t2784;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  t8553 = t2636 * t8031;
  t8560 = t2585 * t769;
  t8566 = t928 * t1434;
  t8567 = t1430 * t8566;
  t8573 = t2131 * t222;
  t8574 = t6986 * t8573;
  t8583 = -0.8e1 * t2602 * t1439 * t5499 * t769 + 0.12e2 * t5508 * t1439 * t8560 - 0.12e2 * t7812 * t5309 * t8031 + 0.12e2 * t5508 * t548 * t8560 + 0.12e2 * t2116 * t8553 + 0.12e2 * t2599 * t8574 - 0.12e2 * t2602 * t8574 - 0.3e1 * t2796 * t7221 + 0.18e2 * t8567 * t6939 + 0.12e2 * t7812 * t8032 - 0.12e2 * t7812 * t8553 - 0.4e1 * t2797 + 0.4e1 * t2802 - 0.4e1 * t2804 - t6925 + t6928;
  t8584 = t2849 * t543;
  t8585 = t220 * t8584;
  t8596 = t2794 * t1434;
  t8597 = t538 * t8596;
  t8600 = t1093 * t112;
  t8601 = t2851 * t222;
  t8602 = t8600 * t8601;
  t8609 = t220 * t8596;
  t8612 = t220 * t8566;
  t8615 = t538 * t8566;
  t8623 = params->csk_a * t112 * t8601;
  t8632 = 0.12e2 * t8585 * t228 * t5513 * t769 - 0.4e1 * t2594 * t8602 - 0.12e2 * t2594 * t8623 + 0.12e2 * t2599 * t8602 + 0.12e2 * t2599 * t8623 - 0.4e1 * t2602 * t8602 - 0.3e1 * t2796 * t7224 + 0.3e1 * t2801 * t4488 + 0.18e2 * t8567 * t4478 - 0.12e2 * t8567 * t6936 - 0.18e2 * t8567 * t6948 + 0.18e2 * t8615 * t6948 + 0.18e2 * t8597 * t6972 - 0.18e2 * t8609 * t6972 - 0.6e1 * t8567 * t7017 - 0.6e1 * t8612 * t7017 + 0.18e2 * t8615 * t7017;
  t8637 = t1492 * t2860 * t562;
  t8645 = t4628 * t925;
  t8647 = t4645 * t8645 * t1093;
  t8650 = t925 * t4501;
  t8651 = t4539 * t8650;
  t8658 = t547 * t925;
  t8666 = t538 * t8650;
  t8669 = t220 * t8650;
  t8674 = -0.18e2 * t568 * t1481 * t8658 * t562 - 0.12e2 * t2070 * t1481 * t8573 - 0.8e1 * t2077 * t1838 * t8601 - 0.2e1 * t2807 * t7129 + 0.3e1 * t2813 * t4452 + 0.3e1 * t2824 * t5527 + 0.3e1 * t2838 * t4443 - 0.11e2 * t8666 * t7053 + 0.11e2 * t8669 * t7053 + 0.7e1 * t8666 * t7091 + 0.11e2 * t7095 * t8647 - 0.6e1 * t8651 * t7141 - 0.6e1 * t7196 * t8637 + t6955 - t6958 - t6965;
  t8690 = t1492 * t2096 * t769;
  t8693 = t1430 * t8650;
  t8699 = t4645 * t8645 * params->csk_a;
  t8703 = t553 * t554 * t2123;
  t8711 = t4526 * t2860 * t1093;
  t8720 = 0.7e1 * t7095 * t4552 * t8658 * t1093 - 0.2e1 * t776 * t570 * t571 * t2123 - 0.4e1 * t2409 * t8690 - t2807 * t4393 + 0.3e1 * t2807 * t4425 - 0.3e1 * t2807 * t4452 + 0.3e1 * t2807 * t4467 - t2811 * t4393 - 0.3e1 * t2811 * t4412 + 0.3e1 * t2813 * t4393 + 0.3e1 * t2813 * t4412 - 0.12e2 * t8693 * t7025 - 0.7e1 * t8666 * t7042 - 0.6e1 * t7095 * t8699 + 0.18e2 * t7095 * t8711 + 0.2e1 * t765 * t8703 - 0.2e1 * t776 * t8703;
  t8739 = t4526 * t2860 * params->csk_a;
  t8747 = t925 * t4496;
  t8748 = t538 * t8747;
  t8753 = t925 * t539;
  t8759 = 0.3e1 * t220 * t8753 * t5319 - 0.12e2 * t2824 * t7059 - 0.11e2 * t8666 * t7030 - 0.7e1 * t8651 * t7042 + 0.18e2 * t8693 * t7042 - t8651 * t7067 - 0.7e1 * t8666 * t7067 + t8669 * t7067 + 0.6e1 * t8693 * t7067 - 0.12e2 * t8651 * t7082 + 0.12e2 * t8693 * t7082 - 0.18e2 * t8693 * t7091 - 0.6e1 * t7095 * t8739 + 0.6e1 * t8693 * t7157 - 0.3e1 * t8748 * t7206 - 0.3e1 * t8748 * t7209;
  t8766 = -0.6e1 * t8693 * t7062 - 0.18e2 * t8666 * t7157 + 0.6e1 * t8669 * t7157 - t7041 - t7047 + t7050 - t7074 + t7076 - t7077 + t7088 + t7102 - t7109 + t7114 - t7116 + t7153 + t7156 - t7162;
  t8768 = t769 * t769;
  t8769 = t8768 * t541;
  t8770 = t538 * t8769;
  t8780 = t220 * t8747;
  t8785 = t4552 * t8658;
  t8790 = t4526 * t2860;
  t8793 = t227 * t2123;
  t8803 = t4645 * t8645;
  t8805 = t7170 - t932 - t828 - 0.2e1 * t8770 * t555 - 0.2e1 * t8770 * t572 + 0.3e1 * t538 * t8753 * t4618 + 0.6e1 * t8669 * t7290 + 0.3e1 * t8780 * t7287 - 0.2e1 * t2811 * t4592 + 0.11e2 * t7258 * t8785 - 0.3e1 * t2813 * t4595 + 0.6e1 * t7264 * t8790 - 0.2e1 * t2850 * t2421 * t8793 + 0.2e1 * t765 * t553 * t8793 + 0.2e1 * t776 * t6384 - t4428 * t2861 + t7095 * t8803;
  t8809 = t220 * t8768;
  t8820 = 0.2e1 * t220 * t8769 * t555 + 0.2e1 * t538 * t8768 * t549 - 0.2e1 * t8809 * t564 + 0.2e1 * t8809 * t566 + 0.4e1 * t2825 + 0.4e1 * t2839 - 0.4e1 * t2853 - t7241 - t7244 + t7252 - t7255 - t7285 + t7296 - t7305 + t7306 + t7307 - t7308;
  t8824 = my_piecewise5(t104, 0, t105, 0, t8583 + t8632 + t8674 + t8720 + t8759 + t8766 + t8805 + t8820);
  t8831 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t513 * t940 + t8510 / 0.5e1 + 0.3e1 / 0.1e2 * t7 * t204 * t2867 - t8488 + t8517 / 0.5e1 + 0.3e1 / 0.2e2 * t7 * t88 * (0.2e3 / 0.243e3 * t2577 - 0.5e2 / 0.81e2 * t2580 + 0.5e1 / 0.27e2 * t38 * t98 * t2150 + t532 * t938 + 0.2e1 * t218 * t2865 + t103 * t8824));
  tv4rho2lapl28 = t8 * t8831 + 0.2e1 * t2872;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  tv4rho2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  tv4rho2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  tv4rho2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  tv4rho2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  tv4rho2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  tv4rho2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t8838 = t7 * t135 * t2945 / 0.1e2;
  t8846 = t2922 * t383;
  t8848 = t359 * t8846 * t2503;
  t8852 = t1626 * t2506 * t2272 * t383;
  t8854 = t799 * t155;
  t8855 = t8854 * t364;
  t8856 = t359 * t8855;
  t8857 = t8856 * t7672;
  t8859 = t2877 * t362;
  t8860 = t8859 * t1054;
  t8862 = t6705 * t383;
  t8863 = t159 * t8862;
  t8869 = t1050 * t8860;
  t8872 = -0.6e1 * t151 * t8860 * t8863 + 0.18e2 * t359 * t8860 * t8863 - 0.6e1 * t8869 * t8863 + t2208 - t2210 - t2213 + t2218 + t2234 - t2240 + t2246 - t2250 - 0.9e1 * t8848 + 0.9e1 * t8852 - 0.9e1 * t8857;
  t8873 = t1093 * t799;
  t8874 = t8873 * t153;
  t8875 = t369 * t8874;
  t8876 = t4943 * t8875;
  t8879 = t159 * t2507;
  t8880 = t151 * t8855 * t8879;
  t8882 = t799 * params->csk_a;
  t8883 = t8882 * t248;
  t8885 = t5030 * t1059 * t8883;
  t8887 = t6475 * t1054;
  t8888 = t1050 * t8887;
  t8889 = t8888 * t2493;
  t8891 = t4933 * t612;
  t8892 = t369 * t8891;
  t8905 = t4933 * t6706;
  t8909 = t159 * t3541 * t612;
  t8913 = t5003 * t369 * t8846;
  t8915 = t8888 * t2468;
  t8918 = t359 * t8887 * t2486;
  t8920 = t2886 * t1054;
  t8922 = t362 * params->csk_a;
  t8923 = t8922 * t153;
  t8924 = t159 * t8923;
  t8927 = -0.18e2 * t8869 * t1093 * t366 * t2232 + 0.18e2 * t8869 * t1059 * t2244 - 0.12e2 * t8869 * t1059 * t8862 - 0.18e2 * t151 * t8920 * t8924 - 0.9e1 * t2237 * t8892 - 0.9e1 * t2237 * t8905 + 0.9e1 * t2243 * t8909 + 0.9e1 * t8876 + 0.9e1 * t8880 + 0.9e1 * t8885 - 0.6e1 * t8889 + 0.9e1 * t8913 - 0.9e1 * t8915 + 0.9e1 * t8918;
  t8929 = t359 * t8920;
  t8932 = t8882 * t153;
  t8933 = t159 * t8932;
  t8934 = t4949 * t8933;
  t8936 = t8888 * t2479;
  t8938 = t369 * t2244;
  t8941 = t159 * t8874;
  t8942 = t4949 * t8941;
  t8944 = t4943 * t8941;
  t8946 = t1093 * t362;
  t8947 = t8946 * t153;
  t8948 = t369 * t8947;
  t8952 = t2458 * t369 * t8932;
  t8954 = t2877 * t153;
  t8958 = t1094 * t6763;
  t8961 = t153 * t3656;
  t8962 = t3677 * t8961;
  t8965 = t3696 * t1058 * t2877 * t1093;
  t8968 = t2877 * t3656;
  t8969 = t3677 * t8968;
  t8970 = t1059 * t153;
  t8971 = t3710 * t8970;
  t8974 = t1050 * t8968;
  t8975 = t3812 * t2202;
  t8978 = t2877 * t3651;
  t8979 = t359 * t8978;
  t8982 = 0.3e1 * t151 * t8954 * t4753 - 0.9e1 * t2173 * t8958 - 0.3e1 * t8979 * t608 + 0.18e2 * t8869 * t8938 + 0.18e2 * t8929 * t8924 + 0.18e2 * t8929 * t8948 + 0.18e2 * t8962 * t8965 - 0.12e2 * t8969 * t8971 + 0.6e1 * t8974 * t8975 - 0.9e1 * t8934 - 0.3e1 * t8936 - 0.3e1 * t8942 + 0.9e1 * t8944 + 0.9e1 * t8952;
  t8985 = t359 * t8968;
  t8986 = t3714 * t2183;
  t8989 = t151 * t8968;
  t8994 = t6476 * t2526;
  t8997 = t1579 * t3791 * t153;
  t9000 = t3696 * t2187;
  t9003 = t359 * t8859;
  t9004 = t1100 * t2232;
  t9007 = t1579 * t2178;
  t9014 = t2265 * t1109 * t1615 * t799;
  t9021 = t1579 * t1580 * t612;
  t9026 = 0.9e1 * t2173 * t4812 + 0.9e1 * t2173 * t4893 + 0.9e1 * t2182 * t8958 + 0.9e1 * t2182 * t9007 - 0.9e1 * t2194 * t9007 - 0.3e1 * t2194 * t9021 - 0.12e2 * t2916 * t8997 - 0.3e1 * t8979 * t624 - 0.6e1 * t8974 * t9000 - 0.18e2 * t8985 * t8975 + 0.6e1 * t8989 * t8975 - 0.11e2 * t8985 * t8986 - 0.18e2 * t9003 * t9004 - 0.6e1 * t8994 - 0.3e1 * t9014;
  t9029 = t1605 * t2899;
  t9033 = t4851 * t1100 * t2269 * t248;
  t9035 = t2209 * t2226;
  t9038 = t374 * t1084 * t612;
  t9042 = t1109 * t1124 * t612;
  t9045 = t3681 * t2877;
  t9051 = t3705 * t3706 * t153;
  t9054 = t1050 * t8859;
  t9055 = t1058 * t153;
  t9067 = t3783 * t4779 * t153;
  t9074 = 0.11e2 * t8962 * t3705 * t9045 * t1093 - 0.6e1 * t9054 * t1109 * t9055 * t383 - 0.6e1 * t8969 * t3705 * t3755 * t153 - 0.6e1 * t2173 * t9042 + 0.9e1 * t2215 * t9038 + 0.9e1 * t2230 * t4796 - 0.6e1 * t8969 * t9051 - t8969 * t9067 + 0.6e1 * t8974 * t9067 - 0.7e1 * t8985 * t9067 + t8989 * t9067 + 0.3e1 * t9029 - 0.9e1 * t9033 - 0.3e1 * t9035;
  t9075 = t369 * t153;
  t9076 = t3710 * t9075;
  t9081 = t3696 * t2174;
  t9084 = t3714 * t623;
  t9093 = t2209 * t2179;
  t9101 = t3783 * t607;
  t9108 = -0.3e1 * t2173 * t9021 + 0.9e1 * t2182 * t9021 + 0.7e1 * t8969 * t8986 - 0.7e1 * t8969 * t9076 - 0.6e1 * t8969 * t9081 + 0.12e2 * t8974 * t8971 + 0.18e2 * t8974 * t9076 - 0.12e2 * t8974 * t9081 - 0.18e2 * t8974 * t9084 - 0.7e1 * t8985 * t9076 + 0.7e1 * t8985 * t9084 - 0.11e2 * t8985 * t9101 + 0.11e2 * t8989 * t9101 - 0.3e1 * t9093;
  t9110 = t3783 * t618;
  t9131 = t2207 * t2259;
  t9133 = t1579 * t2255;
  t9138 = t151 * t799 * t612 * t385;
  t9140 = t1561 * t2270;
  t9142 = 0.3e1 * t151 * t8978 * t619 + 0.11e2 * t8985 * t3714 * t2231 + 0.3e1 * t359 * t8954 * t3664 + 0.6e1 * t8974 * t3696 * t9055 + t8962 * t3705 * t9045 - 0.3e1 * t2173 * t5079 - 0.9e1 * t2182 * t5059 - 0.6e1 * t2194 * t9133 + 0.6e1 * t8989 * t9110 - t801 - t803 + 0.3e1 * t9131 - 0.3e1 * t9138 + 0.3e1 * t9140;
  t9143 = 0.6e1 * t2924;
  t9144 = -t2889 - t2891 - t2893 + t2897 + t2901 - t2903 - t2258 + t2271 - t2274 + t2281 + t2913 + t2915 + t2918 - t9143 + t2927;
  t9148 = my_piecewise5(t58, 0, t61, 0, t8872 + t8927 + t8982 + t9026 + t9074 + t9108 + t9142 + t9144);
  t9155 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t2945 + t8838 + 0.3e1 / 0.2e2 * t7 * t32 * (0.4e2 / 0.81e2 * t38 * t141 * t809 - 0.5e1 / 0.27e2 * t38 * t43 * t2284 + t149 * t2943 + t53 * t9148));
  tv4rhosigma30 = t8 * t9155 + t2949;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t9162 = t7 * t180 * t3021 / 0.1e2;
  t9164 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t3021 + t9162);
  tv4rhosigma39 = t8 * t9164 + t3025;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t9170 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t2945 + t8838);
  tv4rhosigma310 = t8 * t9170 + t2949;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t9182 = t2953 * t541;
  t9183 = t9182 * t1434;
  t9184 = t1430 * t9183;
  t9185 = t5499 * t562;
  t9189 = t826 * params->csk_a;
  t9190 = t9189 * t222;
  t9192 = t2584 * t1439 * t9190;
  t9198 = t228 * t4486 * t675;
  t9201 = t538 * t9183;
  t9202 = t548 * t9185;
  t9205 = t2984 * t562;
  t9207 = t5515 * t548 * t9205;
  t9209 = t220 * t9205;
  t9210 = t9209 * t2349;
  t9212 = 0.18e2 * t9184 * t1439 * t2387 - 0.12e2 * t9184 * t1439 * t9185 + 0.9e1 * t2386 * t9198 + 0.18e2 * t9201 * t9202 - t2345 + t2350 + t2359 + t2373 - t2378 - t2383 + t2389 + 0.9e1 * t9192 + 0.9e1 * t9207 + 0.9e1 * t9210;
  t9214 = t8600 * t681 * t562;
  t9217 = t5455 * t7000;
  t9220 = t5455 * t675;
  t9221 = t548 * t9220;
  t9224 = t1093 * t826;
  t9225 = t9224 * t222;
  t9226 = t548 * t9225;
  t9227 = t5470 * t9226;
  t9229 = t7038 * t1434;
  t9230 = t1430 * t9229;
  t9231 = t9230 * t2610;
  t9235 = t9230 * t2613;
  t9238 = t538 * t9229 * t2605;
  t9242 = t2376 * t4404;
  t9245 = t220 * t9183;
  t9248 = t228 * t9190;
  t9249 = t5537 * t9248;
  t9251 = t548 * t2387;
  t9254 = t228 * t9225;
  t9255 = t5537 * t9254;
  t9257 = t5470 * t9254;
  t9259 = 0.18e2 * t538 * t2964 * t1434 * t9242 - 0.9e1 * t2375 * t9217 - 0.9e1 * t2375 * t9221 - 0.18e2 * t9245 * t2388 - 0.18e2 * t9184 * t9202 - 0.6e1 * t9184 * t9214 + 0.18e2 * t9184 * t9251 + 0.9e1 * t9227 - 0.6e1 * t9231 - 0.9e1 * t9235 + 0.9e1 * t9238 - 0.9e1 * t9249 - 0.3e1 * t9255 + 0.9e1 * t9257;
  t9261 = t9230 * t2597;
  t9268 = t2584 * t548 * t9190;
  t9270 = t9209 * t2633;
  t9272 = t538 * t9205;
  t9273 = t9272 * t2633;
  t9275 = t9272 * t2629;
  t9277 = t1808 * t2973;
  t9281 = t222 * t4501;
  t9282 = t4539 * t9281;
  t9283 = t4628 * t2953;
  t9289 = t1481 * t1497 * t675;
  t9292 = t1430 * t9182;
  t9293 = t1438 * t222;
  t9300 = t4526 * t1438 * t2953 * t1093;
  t9303 = t2953 * t4501;
  t9304 = t4539 * t9303;
  t9305 = t1439 * t222;
  t9306 = t4530 * t9305;
  t9309 = -0.6e1 * t9292 * t1492 * t9293 * t562 - 0.6e1 * t9282 * t4645 * t9283 * params->csk_a + 0.9e1 * t2319 * t5389 + 0.9e1 * t2340 * t9289 + 0.18e2 * t9201 * t9214 - 0.6e1 * t9245 * t9214 + 0.18e2 * t9282 * t9300 - 0.12e2 * t9304 * t9306 - 0.3e1 * t9261 + 0.9e1 * t9268 + 0.9e1 * t9270 - 0.9e1 * t9273 - 0.9e1 * t9275 + 0.3e1 * t9277;
  t9311 = t1492 * t1507 * t675;
  t9319 = t4645 * t4656 * t222;
  t9324 = t2409 * t1492 * t1803 * t826;
  t9326 = t1838 * t2336;
  t9329 = t538 * t9281;
  t9335 = t538 * t9303;
  t9337 = t4552 * t1497 * t222;
  t9342 = t4506 * t2393;
  t9345 = t1430 * t9303;
  t9346 = t4522 * t2393;
  t9349 = t2953 * t4496;
  t9350 = t538 * t9349;
  t9355 = t7045 * t2656;
  t9357 = t227 * t541;
  t9359 = t1838 * t9357 * t222;
  t9362 = t4526 * t2328;
  t9365 = 0.7e1 * t9329 * t4552 * t547 * t2953 * params->csk_a + 0.11e2 * t9282 * t4645 * t9283 * t1093 - 0.9e1 * t2319 * t9289 - 0.6e1 * t2319 * t9311 - 0.9e1 * t2364 * t9326 - 0.12e2 * t3006 * t9359 - 0.3e1 * t9350 * t671 - 0.3e1 * t9350 * t687 - 0.6e1 * t9304 * t9319 - 0.11e2 * t9335 * t9337 - 0.11e2 * t9335 * t9342 + 0.6e1 * t9345 * t9346 - 0.6e1 * t9345 * t9362 - 0.3e1 * t9324 - 0.6e1 * t9355;
  t9370 = t1756 * t1481 * t2413 * t222;
  t9372 = t4526 * t2332;
  t9375 = t538 * t9182;
  t9379 = t2953 * t222;
  t9383 = t220 * t9303;
  t9386 = t2344 * t2337;
  t9388 = t1456 * t7000;
  t9399 = t2344 * t2325;
  t9402 = t553 * t1477 * t675;
  t9407 = -0.18e2 * t9375 * t1481 * t2357 + 0.3e1 * t220 * t9379 * t5319 + 0.9e1 * t2319 * t5368 - 0.3e1 * t2319 * t9388 + 0.9e1 * t2340 * t9326 + 0.9e1 * t2340 * t9388 + 0.9e1 * t2347 * t9402 + 0.9e1 * t2355 * t5384 - 0.3e1 * t2364 * t9388 + 0.11e2 * t9383 * t9342 - 0.12e2 * t9345 * t9372 - 0.9e1 * t9370 - 0.3e1 * t9386 - 0.3e1 * t9399;
  t9408 = t547 * t3697;
  t9410 = t4552 * t9408 * t222;
  t9415 = t4552 * t686;
  t9419 = t5583 * t7065 * t222;
  t9438 = 0.7e1 * t9304 * t9337 - 0.6e1 * t9304 * t9372 - 0.7e1 * t9304 * t9410 - t9304 * t9419 + 0.12e2 * t9345 * t9306 - 0.18e2 * t9335 * t9346 - 0.7e1 * t9335 * t9410 - 0.7e1 * t9335 * t9419 + 0.18e2 * t9345 * t9410 - 0.18e2 * t9345 * t9415 + 0.6e1 * t9345 * t9419 + 0.6e1 * t9383 * t9346 + t9383 * t9419 - t828;
  t9443 = t5583 * t681;
  t9457 = t220 * t826 * t675 * t564;
  t9459 = t1752 * t2414;
  t9467 = t2372 * t2426;
  t9469 = t1838 * t2422;
  t9472 = 0.3e1 * t220 * t9349 * t682 + 0.11e2 * t9335 * t4552 * t2356 + 0.6e1 * t9345 * t4526 * t9293 + 0.3e1 * t538 * t9379 * t4618 + t9282 * t4645 * t9283 - 0.3e1 * t2319 * t5610 - 0.9e1 * t2340 * t5615 - 0.6e1 * t2364 * t9469 + 0.6e1 * t9383 * t9443 - t2963 - t830 - 0.3e1 * t9457 + 0.3e1 * t9459 + 0.3e1 * t9467;
  t9473 = 0.6e1 * t2986;
  t9474 = -t2967 + t2971 + t2975 - t2977 - t2979 - t2391 + t2399 + t2415 - t2418 - t2425 - t9473 + t2995 + t3003 + t3005 + t3008;
  t9478 = my_piecewise5(t104, 0, t105, 0, t9212 + t9259 + t9309 + t9365 + t9407 + t9438 + t9472 + t9474);
  t9485 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t3021 + t9162 + 0.3e1 / 0.2e2 * t7 * t88 * (0.4e2 / 0.81e2 * t38 * t210 * t836 - 0.5e1 / 0.27e2 * t38 * t93 * t2431 + t218 * t3019 + t103 * t9478));
  tv4rhosigma319 = t8 * t9485 + t3025;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t9492 = t7 * t135 * t3107 / 0.1e2;
  t9504 = t1093 * t792;
  t9505 = t9504 * t153;
  t9509 = t8888 * t2461;
  t9511 = t6465 * t3658;
  t9512 = t3677 * t9511;
  t9521 = t1050 * t600 * t1054;
  t9525 = t1050 * t9511;
  t9532 = t2466 * t612;
  t9533 = t369 * t9532;
  t9536 = t3203 * t6706;
  t9539 = t718 * t792;
  t9541 = t359 * t9539 * t383;
  t9545 = t3677 * t8961 * t3658;
  t9546 = t7446 * t792;
  t9550 = t3697 * t792;
  t9551 = t9550 * t8970;
  t9554 = t2208 - t2210 - t2213 - t3036 - t3038 + t2473 + t2499 - 0.6e1 * t7362 * t1059 * t9505 + 0.3e1 * t9509 - 0.6e1 * t9512 * t3682 * t2460 + 0.6e1 * t2496 * t369 * t2749 * t612 - 0.6e1 * t9521 * t1059 * t3033 - 0.12e2 * t9525 * t2461 + 0.6e1 * t2472 * t9038 + 0.6e1 * t2458 * t7454 + 0.6e1 * t2465 * t9533 + 0.6e1 * t2465 * t9536 - 0.3e1 * t9541 * t1024 + 0.18e2 * t9545 * t1059 * t9546 - 0.12e2 * t7415 * t9551;
  t9556 = t2483 * t1059 * t8874;
  t9564 = t9550 * t153;
  t9570 = t3097 * t383;
  t9571 = t151 * t9570;
  t9572 = t9571 * t2217;
  t9574 = t2483 * t8875;
  t9580 = t8856 * t2498;
  t9582 = t2238 * t3040;
  t9585 = t2478 * t8933;
  t9587 = t2465 * t8933;
  t9590 = t359 * t3032 * t3651;
  t9595 = t375 * t792;
  t9596 = t374 * t9595;
  t9602 = t2466 * t6706;
  t9611 = -0.2e1 * t9556 - 0.4e1 * t2483 * t1059 * t9532 + 0.11e2 * t9545 * t3682 * t9546 - 0.6e1 * t7415 * t3682 * t9564 + 0.6e1 * t2458 * t7468 + 0.3e1 * t9572 - 0.3e1 * t9574 - 0.6e1 * t2483 * t9533 - 0.3e1 * t9541 * t1041 + 0.3e1 * t9580 - 0.11e2 * t7396 * t9582 - 0.3e1 * t9585 + 0.3e1 * t9587 - 0.3e1 * t9590 * t608 + 0.3e1 * t151 * t721 * t3651 * t9596 - 0.11e2 * t7396 * t369 * t9505 - 0.2e1 * t2483 * t9602 - 0.2e1 * t2478 * t9602 + 0.6e1 * t2465 * t9602 + 0.3e1 * t5722 * t3083;
  t9615 = t9504 * t2202;
  t9624 = t9550 * t9075;
  t9632 = t151 * t3033;
  t9641 = t159 * t9564;
  t9650 = t8888 * t2475;
  t9654 = t2465 * t8941;
  t9656 = t2483 * t8941;
  t9657 = 0.7e1 * t9512 * t369 * t7446 * t153 + 0.7e1 * t359 * t9511 * t2475 - 0.6e1 * t9512 * t2461 - 0.18e2 * t9525 * t2475 - 0.6e1 * t2478 * t9536 - 0.18e2 * t6675 * t2498 - 0.3e1 * t9590 * t624 + 0.6e1 * t7362 * t9615 + 0.6e1 * t7362 * t9641 + 0.11e2 * t7366 * t9582 + 0.6e1 * t7366 * t9615 + t7366 * t9641 - 0.18e2 * t7396 * t9615 - 0.7e1 * t7396 * t9641 - 0.7e1 * t7415 * t9624 - t7415 * t9641 - 0.12e2 * t9632 * t8997 + 0.3e1 * t9650 + 0.3e1 * t9654 - t9656;
  t9660 = t2465 * t8875;
  t9664 = t2478 * t8941;
  t9678 = t1100 * t368 * t8947;
  t9685 = t9571 * t2503;
  t9687 = t359 * t9570;
  t9688 = t9687 * t2503;
  t9691 = t1094 * t362 * t2202;
  t9694 = t1050 * t3033;
  t9706 = t9687 * t2512;
  t9711 = t1579 * t158 * t8923;
  t9716 = 0.18e2 * t6666 * t7692 * t2244 - 0.6e1 * t2501 * t2511 * t8891 - 0.12e2 * t9694 * t7696 * t8947 + 0.18e2 * t3034 * t9691 + 0.18e2 * t3034 * t9711 - 0.18e2 * t9632 * t9711 - 0.18e2 * t9694 * t9678 - 0.6e1 * t9694 * t9691 + 0.3e1 * t9685 - 0.3e1 * t9688 - 0.3e1 * t9706;
  t9735 = t1903 * t3066;
  t9738 = -0.2e1 * t5778 * t3069 - t2504 + t2509 - t2513 - 0.6e1 * t8848 + 0.6e1 * t8852 - 0.6e1 * t8857 + 0.6e1 * t8876 + 0.6e1 * t8880 + 0.6e1 * t8885 - 0.4e1 * t8889 + 0.6e1 * t8913 - 0.6e1 * t8915 + 0.6e1 * t8918 - 0.6e1 * t8934 - 0.2e1 * t8936 - 0.2e1 * t8942 + 0.6e1 * t8944 + 0.6e1 * t8952 - t9735;
  t9741 = t1942 * t2899;
  t9744 = t1903 * t2899;
  t9752 = t1109 * t6509 * t281;
  t9753 = t2265 * t9752;
  t9764 = t1050 * t8961;
  t9774 = t1910 * t1579 * t3100 * t153;
  t9783 = t6479 * t2530;
  t9795 = 0.6e1 * t5762 * t3783 * t3091 * t153 + 0.3e1 * t359 * t792 * t153 * t7600 + 0.6e1 * t9764 * t3696 * t2266 * t281 + 0.3e1 * t151 * t9539 * t1570 + 0.3e1 * t3056 * t3652 * t2202 + 0.11e2 * t6470 * t3714 * t2529 - 0.6e1 * t1554 * t7560 + 0.3e1 * t5775 * t3041 - t5778 * t3049 - 0.2e1 * t9774 - 0.3e1 * t9783;
  t9815 = t2209 * t1972;
  t9819 = t151 * t718 * t799 * t385;
  t9820 = t1942 * t3101;
  t9824 = 0.3e1 * t2173 * t5829 - t2173 * t5929 - 0.3e1 * t2182 * t5952 - 0.3e1 * t5817 * t3041 + 0.3e1 * t5775 * t3049 - t5817 * t3049 - 0.2e1 * t5817 * t3092 - t801 - 0.4e1 * t8994 - 0.2e1 * t9014 + 0.2e1 * t9029 - 0.6e1 * t9033 - 0.2e1 * t9035 - 0.2e1 * t9093 + 0.2e1 * t9131 - 0.2e1 * t9138 + 0.2e1 * t9140 + t9815 - t9819 + t9820;
  t9827 = t2271 - t2274 + t2281 - t2538 - t2541 + t3086 - 0.4e1 * t2924 + t3088 + t3095 - t3251 + t3102;
  t9832 = my_piecewise5(t58, 0, t61, 0, 0.18e2 * t3034 * t9678 + 0.3e1 * t2173 * t5878 + 0.3e1 * t5775 * t3062 - 0.3e1 * t5778 * t3062 - 0.2e1 * t1586 * t7573 + 0.3e1 * t2230 * t5847 + 0.18e2 * t7362 * t9624 + 0.12e2 * t7362 * t9551 - 0.7e1 * t7396 * t9624 + t9824 + t9827 + t9795 - t9753 - t9744 + t9741 + t9738 + t9716 - t9664 + 0.3e1 * t9660 + t9657 + t9611 + t9554 - t855 + 0.6e1 * t1951 * t2506 * t6721 - 0.6e1 * t2501 * t4938 * t6706 + 0.18e2 * t6666 * t7599 * t2244 - 0.6e1 * t5695 * t7651 * t2214 * t153 - 0.4e1 * t1910 * t1579 * t856 * t612 + t8962 * t3705 * t6504 * t281 + t3085 + t3079 - t3080 + t3075 - t3078 - t3067 - t3059 + t3055 + t3058);
  t9839 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t3107 + t9492 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.25e2 / 0.162e3 * t2875 + 0.5e1 / 0.54e2 * t38 * t48 * t2284 + 0.8e2 / 0.243e3 * t38 * t141 * t864 - 0.1e2 / 0.81e2 * t38 * t43 * t2545 + t149 * t3105 + t53 * t9832));
  tv4rhosigma2lapl0 = t8 * t9839 + t3111;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  t9846 = t7 * t180 * t3192 / 0.1e2;
  t9848 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t3192 + t9846);
  tv4rhosigma2lapl11 = t8 * t9848 + t3196;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  t9854 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t3107 + t9492);
  tv4rhosigma2lapl12 = t8 * t9854 + t3111;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  t9870 = t2376 * t3129;
  t9875 = t554 * t819;
  t9876 = t553 * t9875;
  t9879 = t1093 * t819;
  t9880 = t9879 * t222;
  t9885 = t538 * t3118 * t4496;
  t9895 = t220 * t3119;
  t9902 = t7022 * t4505;
  t9903 = t4539 * t9902;
  t9908 = t3697 * t819;
  t9909 = t9908 * t2320;
  t9912 = t2594 * t9248;
  t9914 = t2599 * t9248;
  t9921 = t3182 * t562;
  t9922 = t220 * t9921;
  t9923 = t9922 * t2349;
  t9925 = -t2345 + t2373 + t2618 + t2625 - 0.11e2 * t7903 * t9870 + 0.3e1 * t220 * t772 * t4496 * t9876 - 0.11e2 * t7903 * t548 * t9880 - 0.3e1 * t9885 * t671 - 0.6e1 * t7895 * t1439 * t9880 - 0.3e1 * t9885 * t687 - 0.18e2 * t6947 * t2624 - 0.12e2 * t9895 * t9359 + 0.6e1 * t2622 * t548 * t2849 * t675 + 0.7e1 * t9903 * t548 * t7934 * t222 - 0.7e1 * t7922 * t9909 - 0.3e1 * t9912 + 0.3e1 * t9914 + 0.7e1 * t538 * t9902 * t2590 + 0.11e2 * t7872 * t9870 + 0.3e1 * t9923;
  t9927 = t1430 * t663 * t1434;
  t9931 = t1430 * t9902;
  t9936 = t769 * t819;
  t9938 = t538 * t9936 * t562;
  t9942 = t2602 * t1439 * t9225;
  t9949 = t4539 * t9281 * t4505;
  t9950 = t7934 * t819;
  t9960 = t2602 * t9226;
  t9963 = t2595 * t548 * t675;
  t9969 = t9908 * t9305;
  t9972 = t6963 * t2624;
  t9974 = t9230 * t2587;
  t9981 = t9230 * t2590;
  t9985 = t2599 * t9254;
  t9987 = -0.6e1 * t9927 * t1439 * t3119 - 0.12e2 * t9931 * t2587 + 0.6e1 * t2617 * t9402 - 0.3e1 * t9938 * t1425 - 0.2e1 * t9942 - 0.4e1 * t2602 * t1439 * t2595 * t675 + 0.11e2 * t9949 * t4629 * t9950 - 0.6e1 * t7922 * t4629 * t9908 * t222 + 0.6e1 * t2584 * t8045 - 0.3e1 * t9960 - 0.6e1 * t2602 * t9963 + 0.18e2 * t9949 * t1439 * t9950 - 0.12e2 * t7922 * t9969 + 0.3e1 * t9972 + 0.3e1 * t9974 - 0.6e1 * t9903 * t4629 * t2586 - 0.18e2 * t9931 * t2590 + 0.3e1 * t9981 - 0.6e1 * t9903 * t2587 + 0.3e1 * t9985;
  t9989 = t2602 * t9254;
  t9990 = t2595 * t7000;
  t9995 = t228 * t6991;
  t10010 = t9908 * t2393;
  t10014 = t2599 * t9226;
  t10018 = t2594 * t9254;
  t10021 = t9879 * t2393;
  t10029 = t7872 * t10010 - t7922 * t10010 + 0.6e1 * t7872 * t10021 + 0.6e1 * t7895 * t10021 - 0.18e2 * t7903 * t10021 - 0.3e1 * t9938 * t1408 + 0.6e1 * t2584 * t7972 - 0.2e1 * t2594 * t9990 - 0.6e1 * t2594 * t9995 + 0.6e1 * t2599 * t9963 + 0.6e1 * t2599 * t9990 + 0.6e1 * t2599 * t9995 - 0.2e1 * t2602 * t9990 + 0.3e1 * t7864 * t3125 + 0.18e2 * t7895 * t9909 + 0.12e2 * t7895 * t9969 - 0.7e1 * t7903 * t9909 + 0.3e1 * t10014 - t10018 - t9989;
  t10053 = 0.3e1 * t220 * t9936 * t1776 - t2630 - t2634 + t2639 - 0.2e1 * t9255 + 0.6e1 * t9257 - 0.2e1 * t9261 + 0.6e1 * t9268 + 0.6e1 * t9270 - 0.6e1 * t9273 - 0.6e1 * t9275;
  t10071 = t2101 * t2973;
  t10080 = t2074 * t2973;
  t10083 = t2074 * t3139;
  t10087 = t1492 * t7110 * t297;
  t10088 = t2409 * t10087;
  t10094 = t1430 * t9281;
  t10099 = -0.4e1 * t2077 * t1838 * t884 * t675 + 0.3e1 * t2355 * t6275 - 0.6e1 * t1756 * t8081 - t6184 * t3130 + 0.3e1 * t6167 * t3130 - t6206 * t3130 + 0.3e1 * t2319 * t6219 + t10071 + 0.3e1 * t6167 * t3135 + 0.3e1 * t6167 * t3150 - 0.3e1 * t6184 * t3150 + 0.3e1 * t2319 * t6233 - t10080 - 0.3e1 * t6206 * t3135 - t10083 - 0.2e1 * t6206 * t3142 - t10088 - 0.2e1 * t1779 * t8094 + t9282 * t4645 * t7135 * t297 + 0.6e1 * t10094 * t4526 * t2410 * t297;
  t10100 = t7048 * t2642;
  t10104 = t2077 * t1838 * t3185 * t222;
  t10127 = t9922 * t2633;
  t10139 = t1430 * t3119;
  t10140 = t1093 * t541;
  t10141 = t10140 * t222;
  t10145 = t538 * t9921;
  t10146 = t10145 * t2629;
  t10152 = t1456 * t541 * t2393;
  t10155 = 0.6e1 * t2116 * t2636 * t2419 * t675 - 0.12e2 * t10139 * t7840 * t10141 + 0.18e2 * t6933 * t7836 * t2387 - 0.6e1 * t2627 * t2628 * t9220 - 0.6e1 * t2627 * t5460 * t7000 + 0.18e2 * t3120 * t10152 + 0.3e1 * t10127 - 0.3e1 * t10146 - t828 - 0.2e1 * t9386 - 0.2e1 * t9399;
  t10165 = t1481 * t547 * t10141;
  t10171 = t10145 * t2633;
  t10176 = t541 * params->csk_a;
  t10177 = t10176 * t222;
  t10178 = t1838 * t227 * t10177;
  t10183 = t2344 * t2132;
  t10187 = t220 * t769 * t826 * t564;
  t10188 = t2101 * t3186;
  t10196 = -0.6e1 * t6295 * t7830 * t2346 * t222 + 0.18e2 * t6933 * t7857 * t2387 - 0.6e1 * t10139 * t10152 - 0.18e2 * t10139 * t10165 + 0.18e2 * t3120 * t10165 + 0.18e2 * t3120 * t10178 - 0.18e2 * t9895 * t10178 - t2319 * t6387 - 0.3e1 * t2340 * t6372 - 0.2e1 * t6184 * t3177 - 0.3e1 * t10171 + t10183 - t10187 + t10188 - t3122 + t3127 - t3132 - 0.2e1 * t9457 + 0.2e1 * t9459 + 0.2e1 * t9467;
  t10199 = t2399 + t2415 - t2418 - t2665 - t2668 - 0.4e1 * t2986 + t3172 + t3173 + t3180 - t3322 + t3187;
  t10204 = my_piecewise5(t104, 0, t105, 0, -0.7e1 * t7903 * t10010 + 0.6e1 * t7895 * t10010 + t10199 + t10196 + t10155 - 0.2e1 * t10104 - 0.3e1 * t10100 + t10099 + t10053 + t10029 + t9987 + t9925 - t883 - 0.6e1 * t9370 - 0.4e1 * t9355 - 0.2e1 * t9324 + 0.2e1 * t9277 - 0.6e1 * t9249 + 0.6e1 * t9238 - 0.6e1 * t9235 - 0.4e1 * t9231 + 0.6e1 * t9227 + 0.6e1 * t9207 + 0.6e1 * t9210 + 0.6e1 * t9192 + 0.11e2 * t7028 * t4552 * t2641 + 0.3e1 * t3163 * t4601 * t2393 + 0.3e1 * t538 * t819 * t222 * t8117 + 0.6e1 * t6141 * t5583 * t3176 * t222 - t3170 - t3166 + t3167 - t3168 + t3162 + t3165 + t3147 - t3140 - t2391);
  t10211 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t3192 + t9846 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.25e2 / 0.162e3 * t2951 + 0.5e1 / 0.54e2 * t38 * t98 * t2431 + 0.8e2 / 0.243e3 * t38 * t210 * t892 - 0.1e2 / 0.81e2 * t38 * t93 * t2671 + t218 * t3190 + t103 * t10204));
  tv4rhosigma2lapl23 = t8 * t10211 + t3196;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  tv4rhosigma2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  tv4rhosigma2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  tv4rhosigma2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  tv4rhosigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  t10218 = t7 * t135 * t3263 / 0.1e2;
  t10230 = t8294 * t3658;
  t10231 = t3677 * t10230;
  t10232 = t7369 * t2202;
  t10234 = t1050 * t10230;
  t10237 = t3697 * t366 * t602 * t153;
  t10240 = t7369 * t153;
  t10241 = t1059 * t10240;
  t10244 = t3203 * t153;
  t10245 = t369 * t10244;
  t10248 = t359 * t10230;
  t10251 = t151 * t10230;
  t10256 = t902 * params->csk_a;
  t10269 = -0.6e1 * t7445 * t1059 * t10256 * t153 - t10231 * t10232 + 0.6e1 * t10234 * t10232 - 0.7e1 * t10248 * t10232 + t10251 * t10232 + 0.18e2 * t10234 * t10237 + 0.12e2 * t10234 * t10241 - 0.18e2 * t10234 * t10245 - 0.7e1 * t10248 * t10237 - 0.18e2 * t10248 * t2479 + 0.6e1 * t10251 * t2479 + t2208 - t2210 - t2213 - t2694 - t2696 + t2701 + 0.6e1 * t9509 - 0.4e1 * t9556 + 0.6e1 * t9572;
  t10290 = -0.6e1 * t9574 + 0.6e1 * t9580 - 0.6e1 * t9585 + 0.6e1 * t9587 + 0.6e1 * t9650 + 0.6e1 * t9654 - 0.2e1 * t9656 + 0.6e1 * t9660 - 0.2e1 * t9664 + 0.6e1 * t9685 - 0.6e1 * t9688 - 0.6e1 * t9706 - 0.3e1 * t8848 + 0.3e1 * t8852 - 0.3e1 * t8857 + 0.3e1 * t8876 + 0.3e1 * t8880 + 0.3e1 * t8885 - 0.2e1 * t8889 + 0.3e1 * t8913;
  t10318 = t359 * t8961;
  t10319 = t368 * t902;
  t10331 = t902 * t153;
  t10336 = -0.3e1 * t8915 + 0.3e1 * t8918 - 0.3e1 * t8934 - t8936 - t8942 + 0.3e1 * t8944 + 0.3e1 * t8952 + 0.3e1 * t2709 * t4812 - t2704 * t9021 + 0.3e1 * t2737 * t4796 - 0.6e1 * t1899 * t1100 * t602 * t718 + 0.6e1 * t9764 * t3696 * t2746 * t248 + 0.3e1 * t2709 * t4893 + 0.3e1 * t2706 * t8958 - 0.4e1 * t1910 * t1579 * t856 * t718 + 0.11e2 * t10318 * t3714 * t10319 * t248 - 0.3e1 * t2709 * t8958 - 0.2e1 * t2709 * t9042 + 0.3e1 * t8425 * t374 * t2525 + 0.3e1 * t359 * t10331 * t3652 * t3226;
  t10363 = -0.2e1 * t9744 - 0.2e1 * t9753 - 0.4e1 * t9774 - 0.6e1 * t9783 - 0.2e1 * t8994 - t9014 + t9029 - 0.3e1 * t9033 - t9035 - t9093 - t909;
  t10367 = t359 * t8215;
  t10368 = t159 * t718;
  t10373 = t2466 * t68 * t7668;
  t10379 = t1624 * t718;
  t10383 = t7685 * t2507;
  t10402 = t2485 * t8923;
  t10415 = -t801 - 0.6e1 * t10367 * t3211 * t10368 - 0.6e1 * t8232 * t10373 + 0.6e1 * t1951 * t2506 * t7527 - 0.6e1 * t10367 * t4749 * t10379 - 0.18e2 * t8232 * t10383 - 0.12e2 * t8232 * t1059 * t1093 * t2507 + 0.18e2 * t8232 * t1059 * t248 * t2244 + 0.18e2 * t8261 * t10383 - 0.6e1 * t8258 * t10373 + 0.18e2 * t8261 * t10373 + 0.18e2 * t8232 * t7672 - 0.18e2 * t8246 * t10402 + 0.18e2 * t8251 * t10402 - 0.2e1 * t2704 * t9133 - 0.3e1 * t2706 * t5059 - t4774 * t2747 + 0.2e1 * t9815 - 0.2e1 * t9819 + 0.2e1 * t9820;
  t10416 = t9131 - t9138 + t9140 - t3206 + t3210 - t3214 + t3235 + t3243 - t3247 - t3248 + t3249 - t2890 + t2900 - t2902 + t2731 + t2738 + t2271 - t2274 + t2281 - t2754;
  t10418 = t3203 * t10368;
  t10421 = t2466 * t10368;
  t10455 = t2466 * t718;
  t10456 = t369 * t10455;
  t10460 = t902 * t1093 * t248;
  t10475 = 0.6e1 * t2465 * t10418 - 0.2e1 * t2483 * t10421 - 0.3e1 * t2693 * t8905 - 0.2e1 * t2478 * t10421 + 0.6e1 * t2465 * t10421 - 0.3e1 * t2693 * t8892 + 0.6e1 * t2483 * t7473 + 0.6e1 * t8216 * t159 * t10379 + 0.3e1 * t2700 * t8909 - 0.6e1 * t2478 * t10418 - 0.6e1 * t9521 * t1059 * t902 * t248 * t383 - 0.12e2 * t10234 * t1059 * t10244 + 0.6e1 * t2483 * t7463 - 0.6e1 * t9545 * t3682 * t10256 * t248 + 0.6e1 * t2465 * t10456 + 0.18e2 * t9545 * t1059 * t10460 - 0.12e2 * t10231 * t10241 - 0.4e1 * t2483 * t1059 * t10455 + 0.11e2 * t9545 * t3682 * t10460 - 0.6e1 * t10231 * t3682 * t10240;
  t10494 = t359 * t8391 * t364;
  t10514 = 0.3e1 * t151 * t10331 * t3651 * t851 - 0.18e2 * t8261 * t369 * t2507 + 0.6e1 * t10234 * t2479 - 0.6e1 * t10234 * t2493 - 0.11e2 * t10248 * t2468 + t2914 + t2926 - t3087 - 0.4e1 * t3099 + t3250 + t3252;
  t10519 = my_piecewise5(t58, 0, t61, 0, t10514 + t10475 + t10416 + t10415 + t10363 + t10336 + t10290 + t10269 + 0.2e1 * t9741 - 0.2e1 * t9735 + 0.6e1 * t8353 * t3783 * t2525 + 0.6e1 * t7666 * t369 * t7527 - 0.12e2 * t8258 * t8879 + 0.7e1 * t10248 * t10245 - 0.6e1 * t2483 * t10456 + 0.7e1 * t10231 * t2468 - 0.7e1 * t10231 * t10237 + 0.11e2 * t10251 * t2486 - 0.11e2 * t10248 * t2486 - 0.3e1 * t10494 * t2486 - 0.3e1 * t10494 * t10245 + 0.3e1 * t2706 * t9021 - t2709 * t9021 + 0.3e1 * t2706 * t9007 + 0.3e1 * t2730 * t9038 - 0.3e1 * t2704 * t9007 - 0.2e1 * t1586 * t8307 + t8962 * t3705 * t4836 * t902);
  t10526 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t3263 + t10218 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.25e2 / 0.81e2 * t3030 + 0.5e1 / 0.27e2 * t38 * t48 * t2545 + 0.4e2 / 0.243e3 * t38 * t141 * t915 - 0.5e1 / 0.81e2 * t38 * t43 * t2762 + t149 * t3261 + t53 * t10519));
  tv4rhosigmalapl20 = t8 * t10526 + t3267;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  t10533 = t7 * t180 * t3334 / 0.1e2;
  t10535 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t3334 + t10533);
  tv4rhosigmalapl28 = t8 * t10535 + t3338;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  t10541 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t3263 + t10218);
  tv4rhosigmalapl29 = t8 * t10541 + t3267;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  t10572 = -t2345 + t2373 - t2797 + t2802 - t2804 - 0.6e1 * t9912 + 0.6e1 * t9914 + 0.6e1 * t9923 - 0.4e1 * t9942 - 0.6e1 * t9960 + 0.6e1 * t9972 + 0.6e1 * t9974 + 0.6e1 * t9981 + 0.6e1 * t9985 - 0.2e1 * t9989 + 0.6e1 * t10014 - 0.2e1 * t10018 + 0.3e1 * t9192 + 0.3e1 * t9207 + 0.3e1 * t9210;
  t10599 = t9282 * t4645 * t5393 * t925 - 0.2e1 * t1779 * t8690 - t2807 * t9388 - 0.3e1 * t2811 * t9326 + 0.3e1 * t2813 * t9289 + 0.3e1 * t2813 * t9326 + 0.3e1 * t2813 * t9388 + 0.3e1 * t2824 * t9402 + 0.3e1 * t9227 - 0.2e1 * t9231 - 0.3e1 * t9235 + 0.3e1 * t9238 - 0.3e1 * t9249 - t9255 + 0.3e1 * t9257 - t9261 + 0.3e1 * t9268 + 0.3e1 * t9270 - 0.3e1 * t9273 - 0.3e1 * t9275;
  t10626 = t925 * t222;
  t10643 = -0.2e1 * t2807 * t9311 + 0.3e1 * t2838 * t5384 - 0.6e1 * t2070 * t8076 + 0.6e1 * t10094 * t4526 * t2860 * t265 + 0.3e1 * t2807 * t5389 - 0.4e1 * t2077 * t1838 * t884 * t769 + 0.11e2 * t9329 * t4552 * t8658 * t265 - 0.3e1 * t2807 * t9289 + 0.3e1 * t8780 * t553 * t2655 + 0.3e1 * t538 * t10626 * t4601 * t3297 + 0.6e1 * t8669 * t5583 * t2655 + 0.3e1 * t2807 * t5368 - t2811 * t9388 + 0.2e1 * t10071 - 0.2e1 * t10080 - 0.2e1 * t10083 - 0.2e1 * t10088 - 0.6e1 * t10100 - 0.4e1 * t10104 + t9277;
  t10646 = t7848 * t2637;
  t10649 = t2419 * t769;
  t10653 = t538 * t8584;
  t10654 = t1819 * t769;
  t10671 = t7830 * t2637;
  t10681 = t2604 * t10177;
  t10687 = -0.12e2 * t8567 * t1439 * t1093 * t2637 + 0.18e2 * t8567 * t1439 * t265 * t2387 - 0.6e1 * t10653 * t3279 * t2828 - 0.18e2 * t8567 * t10646 - 0.6e1 * t8567 * t10671 - 0.6e1 * t8612 * t10671 + 0.18e2 * t8615 * t10671 + 0.18e2 * t8597 * t10681 - 0.18e2 * t8609 * t10681 + 0.18e2 * t8567 * t7818 + 0.6e1 * t10127;
  t10701 = -0.2e1 * t2811 * t9469 - 0.3e1 * t2813 * t5615 - t5280 * t2861 - 0.6e1 * t10146 - 0.6e1 * t10171 + 0.2e1 * t10183 - 0.2e1 * t10187 + 0.2e1 * t10188 - t2962 + t3278 - t3282 - t3285 + t3306 + t3314 - t3318 - t3319 + t3320 - t9457 + t9459 + t9467;
  t10702 = t8650 * t4505;
  t10703 = t4539 * t10702;
  t10706 = t3697 * t545 * t665 * t222;
  t10709 = t220 * t10702;
  t10712 = t538 * t10702;
  t10715 = t1430 * t10702;
  t10719 = t538 * t8747 * t543;
  t10722 = t3274 * t222;
  t10723 = t548 * t10722;
  t10740 = t925 * t1093 * t265;
  t10746 = t3697 * t1436 * t1803 * t222;
  t10749 = t2595 * t769;
  t10757 = t2974 - t2976 + t2825 + t2839 - 0.7e1 * t10703 * t10706 + 0.11e2 * t10709 * t2605 - 0.11e2 * t10712 * t2605 + 0.6e1 * t10715 * t2597 - 0.3e1 * t10719 * t2605 - 0.3e1 * t10719 * t10723 - 0.11e2 * t10712 * t2613 + 0.3e1 * t220 * t10626 * t4496 * t879 - 0.6e1 * t10715 * t2610 - 0.18e2 * t8615 * t548 * t2637 + 0.7e1 * t10703 * t2613 + 0.18e2 * t9949 * t1439 * t10740 - 0.12e2 * t10703 * t10746 - 0.4e1 * t2602 * t1439 * t10749 - 0.3e1 * t2796 * t9221 + 0.6e1 * t2602 * t7966;
  t10759 = t228 * t10749;
  t10767 = t228 * t7965;
  t10775 = t925 * params->csk_a;
  t10780 = t548 * t10749;
  t10786 = t7906 * t222;
  t10808 = t228 * t10786;
  t10815 = -0.2e1 * t2594 * t10759 + 0.6e1 * t8585 * t228 * t10654 + 0.3e1 * t2801 * t9198 - 0.6e1 * t2594 * t10767 - 0.12e2 * t10715 * t1439 * t10722 + 0.6e1 * t2602 * t8040 - 0.6e1 * t9949 * t4629 * t10775 * t265 + 0.6e1 * t2599 * t10780 + 0.11e2 * t9949 * t4629 * t10740 - 0.6e1 * t10703 * t4629 * t10786 + 0.6e1 * t7812 * t548 * t10649 - 0.6e1 * t9927 * t1439 * t925 * t265 * t562 - 0.12e2 * t8612 * t8053 + 0.7e1 * t10712 * t10723 - 0.6e1 * t2602 * t10780 - 0.6e1 * t7933 * t1439 * t10775 * t222 + t10709 * t10808 - 0.7e1 * t10712 * t10808 + 0.6e1 * t10715 * t10808 - t10703 * t10808;
  t10838 = -0.18e2 * t10712 * t2597 + t2399 + t2415 - t2418 - t2854 + t2994 + t3004 - t3171 - 0.4e1 * t3184 + t3321 + t3323;
  t10843 = my_piecewise5(t104, 0, t105, 0, -t828 - t932 - t9399 - t9386 - 0.3e1 * t9370 - 0.2e1 * t9355 - t9324 + t10701 + t10687 + t10643 + 0.6e1 * t2116 * t2636 * t10649 - 0.6e1 * t10653 * t5309 * t10654 - 0.18e2 * t10715 * t10723 - 0.7e1 * t10712 * t10706 + 0.6e1 * t10709 * t2597 - 0.3e1 * t2796 * t9217 + 0.6e1 * t2599 * t10767 + 0.6e1 * t2599 * t10759 - 0.2e1 * t2602 * t10759 + 0.18e2 * t8615 * t10646 + 0.18e2 * t10715 * t10706 + 0.12e2 * t10715 * t10746 + t10838 + t10815 + t10757 + t10599 + t10572 - t2391);
  t10850 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t3334 + t10533 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.25e2 / 0.81e2 * t3116 + 0.5e1 / 0.27e2 * t38 * t98 * t2671 + 0.4e2 / 0.243e3 * t38 * t210 * t938 - 0.5e1 / 0.81e2 * t38 * t93 * t2865 + t218 * t3332 + t103 * t10843));
  tv4rhosigmalapl217 = t8 * t10850 + t3338;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  tv4rhosigmatau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  tv4rhosigmatau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  tv4rhosigmatau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  tv4rhosigmatau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  t10857 = t7 * t135 * t3400 / 0.1e2;
  t10871 = t2208 - t2210 - t2213 - t2694 - t2696 + t2701 + 0.9e1 * t9509 - 0.6e1 * t9556 + 0.9e1 * t9572 - 0.9e1 * t9574 + 0.9e1 * t9580 - 0.9e1 * t9585 + 0.9e1 * t9587 + 0.9e1 * t9650;
  t10879 = t3342 * t3656;
  t10880 = t359 * t10879;
  t10883 = t1050 * t10879;
  t10890 = t3677 * t10879;
  t10893 = t151 * t10879;
  t10897 = -0.18e2 * t10880 * t8975 - 0.7e1 * t10880 * t9067 - 0.7e1 * t10880 * t9076 + 0.12e2 * t10883 * t8971 + 0.18e2 * t10883 * t9076 - 0.6e1 * t10890 * t9081 + t10893 * t9067 + 0.9e1 * t9654 - 0.3e1 * t9656 + 0.9e1 * t9660 - 0.3e1 * t9664 + 0.9e1 * t9685 - 0.9e1 * t9688 - 0.9e1 * t9706;
  t10916 = t3342 * t362;
  t10917 = t151 * t10916;
  t10925 = t3681 * t3342;
  t10927 = t3705 * t10925 * t1093;
  t10935 = t3705 * t10925 * params->csk_a;
  t10938 = 0.9e1 * t2730 * t374 * t1084 * t718 - 0.6e1 * t2709 * t1109 * t1124 * t718 - 0.12e2 * t10917 * t1579 * t7668 - 0.11e2 * t10880 * t9101 + 0.6e1 * t10883 * t9067 - 0.12e2 * t10883 * t9081 - 0.18e2 * t10883 * t9084 - 0.6e1 * t10890 * t9051 - t10890 * t9067 + 0.6e1 * t10893 * t8975 + 0.11e2 * t10893 * t9101 + 0.11e2 * t8962 * t10927 - 0.6e1 * t8962 * t10935 + 0.9e1 * t2709 * t5878;
  t10940 = t1100 * t1114 * t718;
  t10943 = t1579 * t2724;
  t10950 = t1058 * t3342;
  t10952 = t3696 * t10950 * t1093;
  t10961 = t1109 * t10950 * t383;
  t10964 = t3342 * t3651;
  t10965 = t359 * t10964;
  t10970 = t359 * t10916;
  t10973 = t3342 * t153;
  t10983 = -0.6e1 * t1050 * t600 * t10961 + 0.3e1 * t151 * t10973 * t4753 - 0.11e2 * t10880 * t8986 + 0.7e1 * t10880 * t9084 + 0.6e1 * t10883 * t8975 - 0.6e1 * t10883 * t9000 - 0.7e1 * t10890 * t9076 + 0.9e1 * t2706 * t10940 - 0.9e1 * t2709 * t10940 - 0.9e1 * t2704 * t10943 + 0.18e2 * t8962 * t10952 - 0.3e1 * t10965 * t608 - 0.3e1 * t10965 * t624 - 0.18e2 * t10970 * t9004 + 0.9e1 * t2737 * t5847;
  t10991 = t1579 * t1580 * t718;
  t11008 = -0.12e2 * t10890 * t8971 + 0.7e1 * t10890 * t8986 + 0.9e1 * t2706 * t10943 - 0.3e1 * t2704 * t10991 + 0.9e1 * t2706 * t10991 - 0.3e1 * t2709 * t10991 + 0.9e1 * t2709 * t5829 - t909 - 0.3e1 * t9735 + 0.3e1 * t9741 - 0.3e1 * t9744 - 0.3e1 * t9753 - 0.6e1 * t9774 - 0.9e1 * t9783;
  t11011 = t3705 * t10925;
  t11017 = t3714 * t368 * t3342;
  t11022 = t3696 * t10950;
  t11030 = t151 * t10964;
  t11036 = t3355 * t1054;
  t11037 = t151 * t11036;
  t11040 = 0.3e1 * t359 * t10973 * t3664 - 0.6e1 * t2704 * t1579 * t2751 + 0.11e2 * t10318 * t11017 + 0.6e1 * t10893 * t9110 + t8962 * t11011 + 0.6e1 * t9764 * t11022 + 0.3e1 * t11030 * t619 - 0.18e2 * t11037 * t8924 - 0.9e1 * t2706 * t5952 - 0.3e1 * t2709 * t5929 - t801 + 0.3e1 * t9815 - 0.3e1 * t9819 + 0.3e1 * t9820;
  t11042 = t359 * t11036;
  t11045 = t1050 * t11036;
  t11050 = t10916 * t1054;
  t11051 = t1050 * t11050;
  t11059 = -0.9e1 * t2693 * t4933 * t10368 + 0.18e2 * t11042 * t8924 + 0.18e2 * t11042 * t8948 - 0.18e2 * t11045 * t8948 - 0.6e1 * t11051 * t8863 + 0.18e2 * t11051 * t8938 + t2731 + t2738 + t3354 - t3358 - t3360 - t3361 - t3362 + t3363;
  t11069 = t1059 * t3355 * params->csk_a;
  t11075 = t151 * t11050;
  t11078 = t359 * t11050;
  t11081 = 0.6e1 * t3099;
  t11082 = 0.9e1 * t2700 * t159 * t3541 * t718 - 0.9e1 * t2693 * t369 * t4933 * t718 - 0.12e2 * t11045 * t1059 * t8947 + 0.18e2 * t9521 * t11069 - 0.6e1 * t11075 * t8863 + 0.18e2 * t11078 * t8863 - t11081 + t2271 - t2274 + t2281 - t2754 + t3364 + t3367 + t3370 + t3373;
  t11086 = my_piecewise5(t58, 0, t61, 0, t10871 + t10897 + t10938 + t10983 + t11008 + t11040 + t11059 + t11082);
  t11093 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t130 * t3400 + t10857 + 0.3e1 / 0.2e2 * t7 * t32 * (-0.25e2 / 0.54e2 * t3201 + 0.5e1 / 0.18e2 * t38 * t48 * t2762 + t149 * t3398 + t53 * t11086));
  tv4rholapl30 = t8 * t11093 + t3404;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  t11100 = t7 * t180 * t3466 / 0.1e2;
  t11102 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t176 * t3466 + t11100);
  tv4rholapl33 = t8 * t11102 + t3470;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  t11108 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t193 * t3400 + t10857);
  tv4rholapl34 = t8 * t11108 + t3404;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  t11118 = t3417 * t1434;
  t11119 = t220 * t11118;
  t11122 = t1430 * t11118;
  t11123 = t548 * t10141;
  t11133 = -0.18e2 * t11119 * t9242 - 0.18e2 * t11122 * t11123 - t2345 + t2373 - t2797 + t2802 - t2804 - 0.9e1 * t9912 + 0.9e1 * t9914 + 0.9e1 * t9923 - 0.6e1 * t9942 - 0.9e1 * t9960 + 0.9e1 * t9972 + 0.9e1 * t9974;
  t11139 = t3408 * t4501;
  t11140 = t220 * t11139;
  t11142 = t538 * t11139;
  t11145 = t1430 * t11139;
  t11148 = t4539 * t11139;
  t11160 = 0.11e2 * t11140 * t9342 + 0.6e1 * t11140 * t9346 + t11140 * t9419 - 0.18e2 * t11142 * t9346 - 0.7e1 * t11142 * t9419 + 0.6e1 * t11145 * t9346 + 0.18e2 * t11145 * t9410 + 0.6e1 * t11145 * t9419 - t11148 * t9419 + 0.9e1 * t10014 - 0.3e1 * t10018 + 0.9e1 * t9981 + 0.9e1 * t9985 - 0.3e1 * t9989;
  t11173 = t1438 * t3408;
  t11175 = t1492 * t11173 * t562;
  t11178 = t1460 * t2828;
  t11183 = t4628 * t3408;
  t11185 = t4645 * t11183 * params->csk_a;
  t11189 = t1481 * t1497 * t769;
  t11195 = t4526 * t11173 * t1093;
  t11204 = -0.6e1 * t2807 * t1492 * t1507 * t769 - 0.6e1 * t1430 * t663 * t11175 - 0.7e1 * t11142 * t9410 + 0.7e1 * t11142 * t9415 + 0.12e2 * t11145 * t9306 - 0.12e2 * t11148 * t9306 - 0.6e1 * t11148 * t9372 + 0.9e1 * t2813 * t11178 - 0.6e1 * t9282 * t11185 - 0.9e1 * t2807 * t11189 + 0.9e1 * t2813 * t11189 + 0.18e2 * t9282 * t11195 + 0.9e1 * t2807 * t6219 + 0.9e1 * t2838 * t6275;
  t11211 = t547 * t3408;
  t11213 = t4552 * t11211 * params->csk_a;
  t11221 = t1481 * t11211 * t562;
  t11224 = t3408 * t4496;
  t11225 = t538 * t11224;
  t11228 = t3408 * t222;
  t11244 = t1456 * t2828;
  t11247 = 0.9e1 * t2824 * t553 * t1477 * t769 + 0.3e1 * t220 * t11228 * t5319 - 0.18e2 * t10094 * t11213 - 0.11e2 * t11142 * t9337 - 0.11e2 * t11142 * t9342 - 0.6e1 * t11145 * t9362 - 0.12e2 * t11145 * t9372 + 0.7e1 * t11148 * t9337 - 0.7e1 * t11148 * t9410 - 0.9e1 * t2811 * t11178 - 0.18e2 * t664 * t11221 - 0.3e1 * t11225 * t671 - 0.3e1 * t11225 * t687 + 0.9e1 * t2813 * t11244 - 0.12e2 * t3438 * t9359;
  t11257 = t4645 * t11183 * t1093;
  t11269 = -0.6e1 * t11148 * t9319 - 0.3e1 * t2807 * t11244 - 0.3e1 * t2811 * t11244 + 0.11e2 * t9282 * t11257 + 0.9e1 * t2807 * t6233 + 0.3e1 * t10071 - 0.3e1 * t10080 - 0.3e1 * t10083 - 0.3e1 * t10088 - 0.9e1 * t10100 - 0.6e1 * t10104 + 0.9e1 * t10127 - t828 - t932;
  t11272 = t4645 * t11183;
  t11277 = t4552 * t11211;
  t11285 = t220 * t11224;
  t11290 = t4526 * t11173;
  t11298 = 0.3e1 * t538 * t11228 * t4618 - 0.6e1 * t2811 * t1838 * t2851 + 0.6e1 * t10094 * t11290 + 0.6e1 * t11140 * t9443 + t9282 * t11272 + 0.11e2 * t9329 * t11277 + 0.3e1 * t11285 * t682 - 0.3e1 * t2807 * t6387 - 0.9e1 * t2813 * t6372 - 0.9e1 * t10146 - 0.9e1 * t10171 + 0.3e1 * t10183 - 0.3e1 * t10187 + 0.3e1 * t10188;
  t11305 = t1439 * t3417 * params->csk_a;
  t11312 = t3408 * t541 * t1434;
  t11313 = t220 * t11312;
  t11316 = t538 * t11312;
  t11319 = t538 * t11118;
  t11322 = t1430 * t11312;
  t11336 = 0.9e1 * t2801 * t228 * t4486 * t769 - 0.9e1 * t2796 * t548 * t5455 * t769 - 0.12e2 * t11122 * t1439 * t10141 - 0.9e1 * t2796 * t5455 * t2828 + 0.18e2 * t11319 * t11123 + 0.18e2 * t9927 * t11305 - 0.6e1 * t11313 * t9214 + 0.18e2 * t11316 * t2388 + 0.18e2 * t11316 * t9214 - 0.6e1 * t11322 * t9214 + 0.18e2 * t11322 * t9251 - t3420 - t3422 + t3426;
  t11337 = 0.6e1 * t3184;
  t11338 = -t3427 - t3428 + t3429 + t2825 + t2839 - t2391 + t2399 + t2415 - t2418 - t2854 + t3430 - t11337 + t3433 + t3440 + t3443;
  t11342 = my_piecewise5(t104, 0, t105, 0, t11133 + t11160 + t11204 + t11247 + t11269 + t11298 + t11336 + t11338);
  t11349 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t204 * t3466 + t11100 + 0.3e1 / 0.2e2 * t7 * t88 * (-0.25e2 / 0.54e2 * t3272 + 0.5e1 / 0.18e2 * t38 * t98 * t2865 + t218 * t3464 + t103 * t11342));
  tv4rholapl37 = t8 * t11349 + t3470;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  tv4rhotau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  tv4rhotau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  tv4rhotau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  tv4rhotau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t11357 = t359 * t799 * t792 * t383 * t1024;
  t11360 = t159 * t8882 * t383;
  t11361 = t2243 * t11360;
  t11363 = t369 * t3082;
  t11364 = t8856 * t11363;
  t11366 = t1579 * t2898;
  t11367 = t2194 * t11366;
  t11369 = t6479 * t3041;
  t11371 = t792 * t792;
  t11372 = t11371 * t383;
  t11373 = t151 * t11372;
  t11376 = t359 * t11372;
  t11379 = t11371 * t362;
  t11380 = t1050 * t11379;
  t11384 = t1094 * t159 * t799;
  t11385 = t2173 * t11384;
  t11391 = t1100 * t1114 * t799;
  t11392 = t2182 * t11391;
  t11394 = t2173 * t6511;
  t11397 = t1109 * t1124 * t799;
  t11398 = t2173 * t11397;
  t11400 = t2230 * t6638;
  t11402 = t2173 * t11391;
  t11407 = t359 * t11379;
  t11419 = t3091 * t383;
  t11421 = t151 * t8854 * t374 * t11419;
  t11423 = -0.12e2 * t11380 * t1109 * t1124 * t383 - 0.6e1 * t151 * t11379 * t3576 - 0.6e1 * t11380 * t3576 - 0.18e2 * t11380 * t3600 + 0.18e2 * t11407 * t3576 + 0.18e2 * t11392 + 0.18e2 * t11394 - 0.12e2 * t11398 + 0.18e2 * t11400 - 0.18e2 * t11402 + 0.18e2 * t11421;
  t11425 = t2194 * t11384;
  t11427 = t2182 * t11384;
  t11431 = t2173 * t6606;
  t11433 = t11371 * t3656;
  t11434 = t3677 * t11433;
  t11436 = t1050 * t11433;
  t11443 = t359 * t11433;
  t11446 = t151 * t11433;
  t11459 = t799 * t799;
  t11460 = t11459 * t362;
  t11461 = t359 * t11460;
  t11463 = 0.3e1 * t11461 * t376;
  t11466 = 0.3e1 * t151 * t11460 * t376;
  t11468 = 0.3e1 * t11461 * t393;
  t11471 = -0.6e1 * t11380 * t3773 - 0.7e1 * t11434 * t3711 + 0.7e1 * t11434 * t3715 + 0.18e2 * t11436 * t3711 + 0.6e1 * t11436 * t3803 - 0.7e1 * t11443 * t3803 - t11463 + t11466 - t11468 - t801 - t803;
  t11482 = t2182 * t6804;
  t11492 = t2173 * t6815;
  t11497 = t11371 * t3651;
  t11498 = t359 * t11497;
  t11520 = 0.3e1 * t151 * t11497 * t376 - 0.12e2 * t11373 * t3792 - 0.18e2 * t11407 * t3734 - 0.6e1 * t11434 * t3756 - 0.6e1 * t11436 * t3720 + 0.6e1 * t11436 * t3813 - 0.11e2 * t11443 * t3715 - 0.18e2 * t11443 * t3813 + 0.6e1 * t11446 * t3813 - 0.3e1 * t11498 * t376 - 0.3e1 * t11498 * t393;
  t11522 = t6476 * t3092;
  t11524 = t151 * t11371;
  t11529 = t359 * t11371;
  t11537 = t151 * t11459;
  t11539 = 0.3e1 * t11537 * t385;
  t11542 = 0.3e1 * t359 * t11459 * t370;
  t11544 = 0.3e1 * t11537 * t387;
  t11559 = -0.4e1 * t2888 - 0.4e1 * t2890 - 0.4e1 * t2892 + 0.4e1 * t2896 + 0.4e1 * t2900 - 0.4e1 * t2902 + 0.4e1 * t2912 + 0.4e1 * t2914 + 0.4e1 * t2917 - 0.9e1 * t2924 + 0.4e1 * t2926;
  t11563 = my_piecewise5(t58, 0, t61, 0, t11559 + t11544 - t11539 + t11542 - 0.12e2 * t11522 + t11520 + 0.6e1 * t1050 * t11371 * t3668 + t3677 * t11371 * t3683 - 0.6e1 * t11492 - 0.18e2 * t11482 + t11471 + 0.18e2 * t11380 * t3632 + 0.3e1 * t11529 * t3664 + 0.11e2 * t11529 * t3685 + 0.6e1 * t11524 * t3660 + 0.3e1 * t11524 * t3653 + 0.7e1 * t11443 * t3737 + 0.11e2 * t11446 * t3784 - 0.11e2 * t11443 * t3784 + 0.18e2 * t11434 * t3720 - 0.12e2 * t11434 * t3699 + 0.11e2 * t11434 * t3728 - 0.6e1 * t11434 * t3707 - 0.12e2 * t11436 * t3761 + 0.18e2 * t11376 * t3593 - t11434 * t3803 + 0.12e2 * t11436 * t3699 - 0.6e1 * t11434 * t3761 - 0.18e2 * t11436 * t3737 - 0.7e1 * t11443 * t3711 + t11446 * t3803 - 0.18e2 * t11373 * t3551 + 0.18e2 * t11376 * t3551 + 0.18e2 * t11380 * t3619 + 0.18e2 * t11431 - 0.6e1 * t11425 + 0.18e2 * t11427 + t11423 - 0.6e1 * t11385 - 0.18e2 * t11367 + 0.18e2 * t11369 + 0.18e2 * t11361 - 0.18e2 * t11364 - 0.18e2 * t11357);
  t11569 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (-0.2e2 / 0.81e2 * t38 * t43 * t2943 + t53 * t11563));
  tv4sigma40 = t8 * t11569;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t11573 = t826 * t819;
  t11575 = t538 * t11573 * t562;
  t11576 = t11575 * t1408;
  t11578 = t228 * t4486 * t826;
  t11579 = t2386 * t11578;
  t11580 = t11575 * t1425;
  t11581 = t819 * t819;
  t11582 = t11581 * t541;
  t11583 = t220 * t11582;
  t11585 = t7048 * t3150;
  t11586 = t11581 * t562;
  t11589 = t2319 * t7112;
  t11591 = t1481 * t1497 * t826;
  t11592 = t2340 * t11591;
  t11593 = t2355 * t7151;
  t11594 = t2319 * t11591;
  t11598 = t1492 * t1507 * t826;
  t11599 = t2319 * t11598;
  t11601 = t538 * t11582;
  t11604 = t1838 * t2972;
  t11605 = t2364 * t11604;
  t11608 = t220 * t11573 * t1776;
  t11610 = t1430 * t11582;
  t11618 = t1838 * t2365 * t826;
  t11619 = t2364 * t11618;
  t11621 = t2340 * t11618;
  t11627 = t2319 * t7100;
  t11629 = -0.12e2 * t11610 * t1492 * t1507 * t562 - 0.6e1 * t11583 * t4378 + 0.18e2 * t11601 * t4378 + 0.18e2 * t11601 * t4409 - 0.18e2 * t11610 * t4409 - 0.12e2 * t11599 - 0.18e2 * t11605 + 0.18e2 * t11608 - 0.6e1 * t11619 + 0.18e2 * t11621 + 0.18e2 * t11627;
  t11633 = t2319 * t11618;
  t11639 = t11581 * t4501;
  t11640 = t220 * t11639;
  t11642 = t538 * t11639;
  t11645 = t1430 * t11639;
  t11648 = t4539 * t11639;
  t11667 = t2340 * t7253;
  t11673 = t826 * t826;
  t11674 = t11673 * t541;
  t11675 = t538 * t11674;
  t11677 = 0.3e1 * t11675 * t555;
  t11679 = 0.3e1 * t11675 * t572;
  t11680 = -0.7e1 * t11642 * t4581 - 0.6e1 * t11645 * t4527 - 0.18e2 * t11645 * t4553 + 0.18e2 * t11645 * t4581 + 0.12e2 * t11645 * t4651 - 0.6e1 * t11648 * t4546 + 0.7e1 * t11648 * t4558 - 0.7e1 * t11648 * t4581 - 0.18e2 * t11667 - t11677 - t11679;
  t11685 = 0.3e1 * t220 * t11674 * t555;
  t11694 = t2319 * t7240;
  t11709 = t11581 * t4496;
  t11710 = t538 * t11709;
  t11714 = t1838 * t9357;
  t11723 = t7045 * t3177;
  t11730 = -0.12e2 * t220 * t11586 * t11714 + 0.3e1 * t220 * t11709 * t555 - 0.18e2 * t11601 * t4518 + 0.11e2 * t11640 * t4507 - 0.11e2 * t11642 * t4507 + 0.6e1 * t11645 * t4523 - 0.12e2 * t11645 * t4546 - 0.3e1 * t11710 * t555 - 0.3e1 * t11710 * t572 - 0.12e2 * t11723 - t828;
  t11732 = t220 * t11581;
  t11737 = t538 * t11581;
  t11745 = t220 * t11673;
  t11747 = 0.3e1 * t11745 * t566;
  t11750 = 0.3e1 * t538 * t11673 * t549;
  t11752 = 0.3e1 * t11745 * t564;
  t11767 = -0.4e1 * t2962 - 0.4e1 * t2966 + 0.4e1 * t2970 + 0.4e1 * t2974 - 0.4e1 * t2976 - 0.4e1 * t2978 - 0.9e1 * t2986 + 0.4e1 * t2994 + 0.4e1 * t3002 + 0.4e1 * t3004 + 0.4e1 * t3007;
  t11771 = my_piecewise5(t104, 0, t105, 0, -t830 + t11767 - t11752 + t11750 + t11747 + t11730 - 0.6e1 * t11694 + t11685 + t11680 - 0.6e1 * t11633 + t11629 - 0.18e2 * t11594 + 0.18e2 * t11589 + 0.18e2 * t11592 + 0.18e2 * t11593 + 0.18e2 * t11585 + 0.18e2 * t11579 - 0.18e2 * t11580 - 0.18e2 * t11576 + 0.18e2 * t538 * t11586 * t5478 + 0.6e1 * t1430 * t11581 * t4622 + t4539 * t11581 * t4630 + 0.18e2 * t11610 * t4456 - 0.6e1 * t11610 * t4378 + 0.18e2 * t11610 * t4448 + t11640 * t4531 - 0.7e1 * t11642 * t4531 + 0.6e1 * t11645 * t4531 - 0.18e2 * t11583 * t4386 + 0.6e1 * t11732 * t4614 + 0.3e1 * t11732 * t4602 + 0.3e1 * t11737 * t4618 + 0.11e2 * t11737 * t4636 + 0.7e1 * t11642 * t4553 - 0.11e2 * t11642 * t4558 + 0.18e2 * t11648 * t4527 - 0.6e1 * t11610 * t4570 - 0.12e2 * t11648 * t4651 + 0.11e2 * t11648 * t4647 - 0.6e1 * t11648 * t4657 - 0.6e1 * t11648 * t4667 - t11648 * t4531 + 0.6e1 * t11640 * t4523 - 0.18e2 * t11642 * t4523);
  t11777 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (-0.2e2 / 0.81e2 * t38 * t93 * t3019 + t103 * t11771));
  tv4sigma414 = t8 * t11777;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  t11786 = t159 * t8883;
  t11787 = t2478 * t11786;
  t11788 = 0.9e1 * t11787;
  t11789 = t2465 * t11786;
  t11790 = 0.9e1 * t11789;
  t11791 = t281 * t2877;
  t11792 = t11791 * t383;
  t11796 = t359 * t11792;
  t11799 = t8888 * t7503;
  t11800 = 0.9e1 * t11799;
  t11801 = t8873 * t2485;
  t11802 = t2465 * t11801;
  t11803 = 0.9e1 * t11802;
  t11804 = t2483 * t11801;
  t11805 = 0.3e1 * t11804;
  t11806 = t8873 * t248;
  t11807 = t369 * t11806;
  t11808 = t2465 * t11807;
  t11809 = 0.9e1 * t11808;
  t11810 = t2478 * t11801;
  t11811 = 0.3e1 * t11810;
  t11814 = t1050 * t11792;
  t11817 = -0.18e2 * t151 * t11792 * t3551 + 0.18e2 * t11796 * t3551 + 0.18e2 * t11796 * t3569 - 0.6e1 * t11814 * t3569 - t11788 + t11790 + t11800 + t11803 - t11805 + t11809 - t11811 - 0.4e1 * t3035 - 0.4e1 * t3037;
  t11828 = t2483 * t1059 * t11806;
  t11829 = 0.6e1 * t11828;
  t11830 = t2483 * t11807;
  t11831 = 0.9e1 * t11830;
  t11834 = t8888 * t7380;
  t11835 = 0.9e1 * t11834;
  t11837 = t2496 * t369 * t9570;
  t11838 = 0.9e1 * t11837;
  t11842 = t374 * t1084 * t799;
  t11843 = t2472 * t11842;
  t11844 = 0.9e1 * t11843;
  t11850 = -0.6e1 * t5695 * t159 * t1093 * t2877 * t383 + 0.18e2 * t11796 * t3593 - 0.18e2 * t11814 * t3593 - 0.12e2 * t11814 * t3637 + 0.18e2 * t8869 * t5735 + 0.18e2 * t8869 * t5740 - 0.9e1 * t11357 + 0.9e1 * t11361 - 0.9e1 * t11364 - t11829 - t11831 + t11835 + t11838 + t11844;
  t11854 = t3710 * t2877 * t366 * t368;
  t11860 = t3783 * t4779 * t2877;
  t11872 = t3696 * t3698 * t2877;
  t11879 = t3812 * t2877 * t68 * t158;
  t11885 = -0.7e1 * t5768 * t11854 + 0.18e2 * t5771 * t11854 - 0.7e1 * t5788 * t11854 + t5762 * t11860 - 0.7e1 * t5768 * t11860 + 0.6e1 * t5771 * t11860 - t5788 * t11860 + 0.12e2 * t5771 * t11872 - 0.18e2 * t5768 * t11879 + 0.6e1 * t5771 * t11879 + 0.7e1 * t8969 * t5798 - 0.6e1 * t8969 * t5899 - 0.9e1 * t11367;
  t11897 = t158 * t2877;
  t11905 = 0.6e1 * t5762 * t3783 * t11897 + 0.11e2 * t8985 * t5949 + 0.3e1 * t8979 * t711 + 0.9e1 * t11369 - 0.3e1 * t11385 + 0.9e1 * t11392 + 0.9e1 * t11394 - 0.6e1 * t11398 + 0.9e1 * t11400 - 0.9e1 * t11402 + 0.9e1 * t11421 - 0.3e1 * t11425 + 0.9e1 * t11427 + 0.9e1 * t11431;
  t11908 = t151 * t11791;
  t11914 = t4933 * t799;
  t11916 = t2501 * t2511 * t11914;
  t11917 = 0.9e1 * t11916;
  t11919 = t374 * t158 * t3211;
  t11920 = t9571 * t11919;
  t11921 = 0.9e1 * t11920;
  t11922 = t9687 * t11919;
  t11923 = 0.9e1 * t11922;
  t11927 = 0.3e1 * t11908 * t3653 + t8969 * t5941 + 0.6e1 * t8974 * t5955 - t11463 + t11466 - t11468 - 0.9e1 * t11482 - 0.3e1 * t11492 - 0.6e1 * t11522 - t11917 + t11921 - t11923 - t801;
  t11929 = t3783 * t11897 * params->csk_a;
  t11934 = t359 * t11791;
  t11963 = -0.11e2 * t5768 * t3714 * t1114 * t2877 - 0.6e1 * t5788 * t3705 * t3706 * t2877 + 0.6e1 * t5762 * t11879 - 0.12e2 * t11908 * t4745 + 0.3e1 * t11908 * t4753 + 0.11e2 * t5762 * t11929 - 0.11e2 * t5768 * t11929 - 0.3e1 * t11934 * t4750 - 0.3e1 * t11934 * t4753 - 0.18e2 * t9003 * t5765 - 0.6e1 * t5771 * t8965 - 0.18e2 * t8974 * t5839 + 0.7e1 * t8985 * t5839 + 0.11e2 * t8969 * t5867;
  t11971 = t1910 * t1579 * t856 * t799;
  t11972 = 0.6e1 * t11971;
  t11973 = t1586 * t9752;
  t11974 = 0.3e1 * t11973;
  t11981 = t1554 * t1100 * t710 * t799;
  t11982 = 0.9e1 * t11981;
  t11987 = -0.12e2 * t5788 * t11872 + 0.18e2 * t8969 * t5814 - 0.6e1 * t8969 * t5882 - 0.6e1 * t9054 * t5892 - 0.12e2 * t8974 * t5899 - t11539 + t11542 + t11544 - t11972 - t11974 - t11982 + 0.4e1 * t3054 + 0.4e1 * t3057;
  t11989 = -t3059 - t3067 + t3075 - t2891 + t2901 - t2903 + 0.4e1 * t3084 - t855 + t2915 - t9143 + t2927 + t3095 - t3365 + t3102;
  t11993 = my_piecewise5(t58, 0, t61, 0, t11817 + t11850 + t11885 + t11905 + t11927 + t11963 + t11987 + t11989);
  t11999 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.54e2 * t38 * t48 * t2943 - 0.5e1 / 0.27e2 * t38 * t43 * t3105 + t53 * t11993));
  tv4sigma3lapl0 = t8 * t11999;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  t12007 = t228 * t9189 * t265;
  t12008 = t2594 * t12007;
  t12009 = 0.9e1 * t12008;
  t12010 = t2599 * t12007;
  t12011 = 0.9e1 * t12010;
  t12012 = t297 * t2953;
  t12013 = t12012 * t562;
  t12014 = t1430 * t12013;
  t12017 = t9224 * t265;
  t12018 = t228 * t12017;
  t12019 = t2594 * t12018;
  t12020 = 0.3e1 * t12019;
  t12024 = t538 * t12013;
  t12027 = t9230 * t8003;
  t12028 = 0.9e1 * t12027;
  t12029 = t2599 * t12018;
  t12030 = 0.9e1 * t12029;
  t12031 = t2602 * t12018;
  t12032 = 0.3e1 * t12031;
  t12033 = t548 * t12017;
  t12034 = t2599 * t12033;
  t12035 = 0.9e1 * t12034;
  t12045 = -0.6e1 * t6295 * t228 * t1093 * t2953 * t562 - 0.18e2 * t220 * t12013 * t5478 - 0.6e1 * t12014 * t4405 - 0.18e2 * t12014 * t4462 + 0.18e2 * t12024 * t4405 + 0.18e2 * t12024 * t5478 - t12009 + t12011 - t12020 + t12028 + t12030 - t12032 + t12035;
  t12051 = t2602 * t1439 * t12017;
  t12052 = 0.6e1 * t12051;
  t12053 = t2602 * t12033;
  t12054 = 0.9e1 * t12053;
  t12057 = t9230 * t7880;
  t12058 = 0.9e1 * t12057;
  t12062 = t553 * t1477 * t826;
  t12063 = t2617 * t12062;
  t12064 = 0.9e1 * t12063;
  t12066 = t2622 * t548 * t9921;
  t12067 = 0.9e1 * t12066;
  t12073 = -0.12e2 * t12014 * t4473 + 0.18e2 * t12024 * t4462 + 0.18e2 * t9184 * t6332 + 0.18e2 * t9184 * t6342 - 0.9e1 * t11576 + 0.9e1 * t11579 - 0.9e1 * t11580 + 0.9e1 * t11585 + 0.9e1 * t11589 - t12052 - t12054 + t12058 + t12064 + t12067;
  t12085 = t227 * t2953;
  t12091 = t220 * t12012;
  t12094 = 0.6e1 * t6141 * t5583 * t12085 + 0.3e1 * t12091 * t4602 + 0.11e2 * t9335 * t6367 + 0.9e1 * t11592 + 0.9e1 * t11593 - 0.9e1 * t11594 - 0.6e1 * t11599 - 0.9e1 * t11605 + 0.9e1 * t11608 - 0.3e1 * t11619 + 0.9e1 * t11621 + 0.9e1 * t11627 - 0.3e1 * t11633;
  t12104 = t553 * t227 * t3279;
  t12105 = t9922 * t12104;
  t12106 = 0.9e1 * t12105;
  t12107 = t10145 * t12104;
  t12108 = 0.9e1 * t12107;
  t12109 = t5455 * t826;
  t12111 = t2627 * t2628 * t12109;
  t12112 = 0.9e1 * t12111;
  t12115 = -0.18e2 * t9375 * t6269 + 0.6e1 * t9345 * t6375 + t9304 * t6390 + 0.3e1 * t9350 * t762 - 0.9e1 * t11667 - t11677 - t11679 + t11685 - 0.3e1 * t11694 - 0.6e1 * t11723 + t12106 - t12108 - t12112 - t828;
  t12123 = t5583 * t12085 * params->csk_a;
  t12128 = t538 * t12012;
  t12137 = t4530 * t2953 * t1436 * t1438;
  t12150 = t2077 * t1838 * t884 * t826;
  t12151 = 0.6e1 * t12150;
  t12152 = t1779 * t10087;
  t12153 = 0.3e1 * t12152;
  t12154 = -0.6e1 * t6177 * t4645 * t4656 * t2953 - 0.12e2 * t12091 * t5328 + 0.11e2 * t6141 * t12123 - 0.11e2 * t6151 * t12123 - 0.3e1 * t12128 * t5310 - 0.12e2 * t6177 * t12137 + 0.11e2 * t9304 * t6161 - 0.6e1 * t6170 * t9300 + 0.18e2 * t9304 * t6181 + 0.7e1 * t9335 * t6187 - 0.6e1 * t9304 * t6193 - t12151 - t12153;
  t12159 = t1756 * t1481 * t761 * t826;
  t12160 = 0.9e1 * t12159;
  t12168 = t4552 * t9408 * t2953;
  t12173 = t4522 * t2953 * t112 * t227;
  t12181 = t5583 * t7065 * t2953;
  t12190 = -0.3e1 * t12128 * t5319 + 0.12e2 * t6170 * t12137 - 0.7e1 * t6151 * t12168 + 0.6e1 * t6141 * t12173 - 0.18e2 * t6151 * t12173 + 0.6e1 * t6170 * t12173 + t6141 * t12181 - 0.7e1 * t6151 * t12181 + 0.6e1 * t6170 * t12181 - t6177 * t12181 - 0.12e2 * t9345 * t6133 - 0.18e2 * t9345 * t6187 - 0.6e1 * t9292 * t6279 - t12160;
  t12208 = -0.11e2 * t6151 * t4552 * t1497 * t2953 + 0.3e1 * t12091 * t5319 + 0.18e2 * t6170 * t12168 - 0.7e1 * t6177 * t12168 - 0.6e1 * t9304 * t6133 + 0.7e1 * t9304 * t6174 + t11747 + t11750 - t11752 - 0.4e1 * t3121 + 0.4e1 * t3126 - t3132 - t3140;
  t12212 = t3147 + 0.4e1 * t3161 + 0.4e1 * t3164 - t2963 + t2975 - t2977 - 0.4e1 * t3169 - t883 - t9473 + t2995 + t3005 + t3180 - t3431 + t3187;
  t12216 = my_piecewise5(t104, 0, t105, 0, t12045 + t12073 + t12094 + t12115 + t12154 + t12190 + t12208 + t12212);
  t12222 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (0.5e1 / 0.54e2 * t38 * t98 * t3019 - 0.5e1 / 0.27e2 * t38 * t93 * t3190 + t103 * t12216));
  tv4sigma3lapl19 = t8 * t12222;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  tv4sigma3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  tv4sigma3tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  t12230 = t159 * t795 * params->csk_a;
  t12235 = t2700 * t11360;
  t12239 = t9504 * t383;
  t12240 = t159 * t12239;
  t12249 = t369 * t12239;
  t12258 = t2693 * t8882 * t1023;
  t12263 = -0.12e2 * t8232 * t1059 * t12239 + 0.18e2 * t8232 * t11363 - 0.18e2 * t8246 * t12230 + 0.18e2 * t8251 * t12230 - 0.6e1 * t8232 * t12240 - 0.6e1 * t8258 * t12240 + 0.18e2 * t8261 * t12240 - 0.18e2 * t8232 * t12249 + 0.18e2 * t8261 * t12249 + 0.18e2 * t8232 * t6744 - 0.12e2 * t11787 + 0.12e2 * t11789 + 0.12e2 * t11799 + 0.3e1 * t12235 - 0.3e1 * t12258;
  t12279 = 0.12e2 * t11802 - 0.4e1 * t11804 + 0.12e2 * t11808 - 0.4e1 * t11810 - 0.8e1 * t11828 - 0.12e2 * t11830 + 0.12e2 * t11834 + 0.12e2 * t11837 + 0.12e2 * t11843 - 0.3e1 * t11357 + 0.3e1 * t11361 - 0.3e1 * t11364 - 0.3e1 * t11367 + 0.3e1 * t11369 - t11385 + 0.3e1 * t11392;
  t12291 = t902 * t792;
  t12298 = t2706 * t6804;
  t12302 = t6565 * t2747;
  t12305 = t2704 * t1579 * t3100;
  t12307 = 0.3e1 * t359 * t12291 * t3664 + 0.3e1 * t8425 * t374 * t3091 + 0.6e1 * t8353 * t3783 * t3091 + 0.6e1 * t6466 * t8452 + t6522 * t8438 + 0.3e1 * t11394 - 0.2e1 * t11398 + 0.3e1 * t11400 - 0.3e1 * t11402 + 0.3e1 * t11421 - t11425 + 0.3e1 * t11427 + 0.3e1 * t11431 - 0.3e1 * t12298 - t12302 - 0.2e1 * t12305;
  t12316 = t3710 * t3040;
  t12320 = t3783 * t9595;
  t12325 = 0.11e2 * t6470 * t3714 * t10319 + 0.6e1 * t8327 * t12316 - t8340 * t12316 - 0.11e2 * t8295 * t12320 + 0.11e2 * t8353 * t12320 - t11463 + t11466 - t11468 - 0.3e1 * t11482 - t11492 - 0.2e1 * t11522 - 0.12e2 * t11916 + 0.12e2 * t11920 - 0.12e2 * t11922 - t801 - t909;
  t12328 = t3710 * t3061;
  t12332 = t3696 * t3698 * t792;
  t12342 = t3783 * t3048;
  t12352 = t2709 * t6606;
  t12356 = t2709 * t6511;
  t12360 = t2706 * t11391;
  t12362 = -0.12e2 * t906 * t1579 * t11419 - 0.7e1 * t8295 * t12316 + t8353 * t12316 - 0.7e1 * t8295 * t12328 + 0.18e2 * t8327 * t12328 + 0.12e2 * t8327 * t12332 - 0.18e2 * t8295 * t12342 + 0.6e1 * t8353 * t12342 - 0.6e1 * t6522 * t8337 - 0.6e1 * t6522 * t8357 - 0.12e2 * t8327 * t6541 - 0.18e2 * t8327 * t6573 + 0.3e1 * t12352 + 0.3e1 * t12356 + 0.3e1 * t12360;
  t12363 = t2730 * t11842;
  t12367 = t2709 * t11391;
  t12375 = t2709 * t11397;
  t12383 = t2737 * t6638;
  t12401 = 0.18e2 * t6522 * t3696 * t2746 * t1093 - 0.6e1 * t8340 * t3705 * t3706 * t792 - 0.6e1 * t1050 * t795 * t8324 - 0.3e1 * t8392 * t391 * t6572 - 0.7e1 * t8340 * t12328 - 0.12e2 * t8340 * t12332 + 0.6e1 * t8327 * t12342 + 0.11e2 * t6522 * t8384 + 0.7e1 * t8295 * t6573 - 0.11e2 * t8295 * t6582 + 0.7e1 * t8340 * t6582 - 0.3e1 * t8392 * t9596 + 0.3e1 * t12363 - 0.3e1 * t12367 - 0.2e1 * t12375 + 0.3e1 * t12383;
  t12411 = t2706 * t11366;
  t12413 = t2704 * t11384;
  t12414 = t2706 * t11384;
  t12416 = t2709 * t11384;
  t12417 = t2704 * t11366;
  t12426 = t2693 * t369 * t11914;
  t12428 = 0.3e1 * t151 * t12291 * t4753 - 0.6e1 * t8327 * t3696 * t3068 - 0.18e2 * t911 * t6630 - t11539 - 0.8e1 * t11971 - 0.4e1 * t11973 - 0.12e2 * t11981 + 0.3e1 * t12411 - t12413 + 0.3e1 * t12414 - t12416 - 0.3e1 * t12417 - 0.3e1 * t12426 - 0.4e1 * t3205 + 0.4e1 * t3209 - 0.4e1 * t3213;
  t12431 = t11542 + t11544 + 0.4e1 * t3234 + 0.4e1 * t3242 - t3247 - t3248 + t3249 - t3078 + t3079 - t3080 + t3086 - t2925 + t3088 + t3250 - t11081 + t3252;
  t12435 = my_piecewise5(t58, 0, t61, 0, t12263 + t12279 + t12307 + t12325 + t12362 + t12401 + t12428 + t12431);
  t12441 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.27e2 * t38 * t48 * t3105 - 0.1e2 / 0.81e2 * t38 * t43 * t3261 + t53 * t12435));
  tv4sigma2lapl20 = t8 * t12441;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  t12463 = -0.12e2 * t12008 + 0.12e2 * t12010 - 0.4e1 * t12019 + 0.12e2 * t12027 + 0.12e2 * t12029 - 0.4e1 * t12031 + 0.12e2 * t12034 - 0.8e1 * t12051 - 0.12e2 * t12053 + 0.12e2 * t12057 + 0.12e2 * t12063 + 0.12e2 * t12066 - 0.3e1 * t11576 + 0.3e1 * t11579 - 0.3e1 * t11580;
  t12475 = t2811 * t1838 * t3185;
  t12479 = t2813 * t7253;
  t12483 = 0.6e1 * t7023 * t8790 + 0.11e2 * t7028 * t8785 + 0.3e1 * t11585 + 0.3e1 * t11589 + 0.3e1 * t11592 + 0.3e1 * t11593 - 0.3e1 * t11594 - 0.2e1 * t11599 - 0.3e1 * t11605 + 0.3e1 * t11608 - t11619 + 0.3e1 * t11621 + 0.3e1 * t11627 - t11633 - 0.2e1 * t12475 - 0.3e1 * t12479;
  t12485 = t7039 * t2861;
  t12490 = t925 * t819;
  t12502 = 0.3e1 * t538 * t12490 * t4618 + 0.3e1 * t8780 * t553 * t3176 + 0.6e1 * t8669 * t5583 * t3176 + t7035 * t8803 - 0.3e1 * t11667 - t11677 - t11679 + t11685 - t11694 - 0.2e1 * t11723 + 0.12e2 * t12105 - 0.12e2 * t12107 - 0.12e2 * t12111 - t12485 - t828 - t932;
  t12503 = t4530 * t3129;
  t12507 = t5583 * t9875;
  t12512 = t4530 * t3134;
  t12516 = t4526 * t4650 * t819;
  t12519 = t7181 * params->csk_a;
  t12520 = t4552 * t12519;
  t12526 = t5583 * t2365 * t819;
  t12536 = t2807 * t7112;
  t12540 = t2813 * t11591;
  t12542 = -t8651 * t12503 - 0.7e1 * t8666 * t12503 + t8669 * t12503 + 0.6e1 * t8693 * t12503 - 0.11e2 * t8666 * t12507 + 0.11e2 * t8669 * t12507 - 0.7e1 * t8666 * t12512 + 0.18e2 * t8693 * t12512 + 0.12e2 * t8693 * t12516 - 0.18e2 * t8693 * t12520 - 0.18e2 * t8666 * t12526 + 0.6e1 * t8669 * t12526 - 0.6e1 * t7035 * t8699 - 0.6e1 * t7035 * t8739 + 0.3e1 * t12536 + 0.3e1 * t12540;
  t12545 = t2824 * t12062;
  t12549 = t2807 * t11591;
  t12555 = t2807 * t11598;
  t12563 = t2838 * t7151;
  t12573 = t4552 * t1497 * t819;
  t12583 = -0.12e2 * t929 * t1838 * t3176 * t562 - 0.6e1 * t8651 * t4645 * t4656 * t819 - 0.3e1 * t8748 * t570 * t12519 - 0.6e1 * t1430 * t822 * t8637 - 0.7e1 * t8651 * t12512 - 0.12e2 * t8651 * t12516 + 0.7e1 * t8666 * t12520 + 0.6e1 * t8693 * t12526 + 0.7e1 * t8651 * t12573 + 0.11e2 * t7035 * t8647 + 0.18e2 * t7035 * t8711 + 0.3e1 * t12545 - 0.3e1 * t12549 - 0.2e1 * t12555 + 0.3e1 * t12563;
  t12595 = t2813 * t11604;
  t12597 = t2811 * t11618;
  t12598 = t2813 * t11618;
  t12600 = t2807 * t11618;
  t12601 = t2811 * t11604;
  t12603 = t2807 * t7100;
  t12611 = 0.3e1 * t220 * t12490 * t5319 - 0.11e2 * t8666 * t12573 - 0.12e2 * t8693 * t7097 - 0.6e1 * t8693 * t7119 - 0.18e2 * t934 * t7183 - 0.3e1 * t8748 * t9876 - 0.8e1 * t12150 - 0.4e1 * t12152 - 0.12e2 * t12159 + 0.3e1 * t12595 - t12597 + 0.3e1 * t12598 - t12600 - 0.3e1 * t12601 + 0.3e1 * t12603 + 0.4e1 * t3277;
  t12616 = t228 * t822 * params->csk_a;
  t12621 = t9879 * t562;
  t12626 = t2796 * t9189 * t1407;
  t12629 = t2796 * t548 * t12109;
  t12631 = t2801 * t11578;
  t12639 = t228 * t12621;
  t12646 = t548 * t12621;
  t12651 = -0.12e2 * t8567 * t1439 * t12621 + 0.18e2 * t8567 * t1439 * t3124 + 0.18e2 * t8567 * t548 * t3124 + 0.18e2 * t8597 * t12616 - 0.18e2 * t8609 * t12616 - 0.6e1 * t8567 * t12639 - 0.6e1 * t8612 * t12639 + 0.18e2 * t8615 * t12639 - 0.18e2 * t8567 * t12646 + 0.18e2 * t8615 * t12646 + t11747 - 0.3e1 * t12626 - 0.3e1 * t12629 + 0.3e1 * t12631 - 0.4e1 * t3281 - 0.4e1 * t3284;
  t12654 = t11750 - t11752 + 0.4e1 * t3305 + 0.4e1 * t3313 - t3318 - t3319 + t3320 - t3166 + t3167 - t3168 - t2987 + t3172 + t3173 + t3321 - t11337 + t3323;
  t12658 = my_piecewise5(t104, 0, t105, 0, t12463 + t12483 + t12502 + t12542 + t12583 + t12611 + t12651 + t12654);
  t12664 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (0.5e1 / 0.27e2 * t38 * t98 * t3190 - 0.1e2 / 0.81e2 * t38 * t93 * t3332 + t103 * t12658));
  tv4sigma2lapl217 = t8 * t12664;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  tv4sigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  tv4sigma2tau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  t12673 = 0.9e1 * t12235 - 0.9e1 * t12258 - t11788 + t11790 + t11800 + t11803 - t11805 + t11809 - t11811 - t11829 - t11831 + t11835 + t11838 + t11844;
  t12678 = t3342 * t248;
  t12691 = 0.6e1 * t10893 * t3783 * t856 + 0.3e1 * t359 * t12678 * t3664 + t4787 * t11011 + 0.11e2 * t4756 * t11017 + 0.6e1 * t4759 * t11022 + 0.3e1 * t11030 * t857 - t11917 + t11921 - t11923 - 0.9e1 * t12298 - 0.3e1 * t12302 - 0.6e1 * t12305 - t801 - t909;
  t12704 = t3710 * t3226;
  t12710 = t3783 * t4779 * t248;
  t12719 = -0.12e2 * t10917 * t1579 * t856 * t383 - 0.6e1 * t1050 * t605 * t10961 - 0.7e1 * t10880 * t12710 + 0.7e1 * t10880 * t4803 + 0.6e1 * t10883 * t12710 - 0.18e2 * t10883 * t4803 - 0.12e2 * t10883 * t4856 - 0.7e1 * t10890 * t12704 - t10890 * t12710 + 0.7e1 * t10890 * t4871 + t10893 * t12710 - t11463 + t11466 - t11468;
  t12720 = t3783 * t3217;
  t12728 = t3696 * t3698 * t248;
  t12749 = t3783 * t850;
  t12754 = -0.6e1 * t10890 * t3705 * t3706 * t248 - 0.7e1 * t10880 * t12704 - 0.18e2 * t10880 * t12720 - 0.11e2 * t10880 * t12749 - 0.11e2 * t10880 * t4871 + 0.18e2 * t10883 * t12704 + 0.12e2 * t10883 * t12728 - 0.12e2 * t10890 * t12728 - 0.6e1 * t10890 * t4856 + 0.6e1 * t10893 * t12720 + 0.11e2 * t10893 * t12749 + 0.11e2 * t4787 * t10927 - 0.6e1 * t4787 * t10935 + 0.18e2 * t4787 * t10952;
  t12778 = 0.3e1 * t151 * t12678 * t4753 + 0.6e1 * t10883 * t12720 - 0.6e1 * t10883 * t4920 - 0.3e1 * t10965 * t851 - 0.3e1 * t10965 * t861 - 0.18e2 * t10970 * t4888 + 0.9e1 * t12352 + 0.9e1 * t12356 + 0.9e1 * t12360 + 0.9e1 * t12363 - 0.9e1 * t12367 - 0.6e1 * t12375 + 0.9e1 * t12383 + 0.9e1 * t12411;
  t12785 = t159 * t1093 * t383 * t248;
  t12792 = t8946 * t248;
  t12793 = t369 * t12792;
  t12796 = 0.18e2 * t11042 * t12793 + 0.18e2 * t11051 * t4965 - 0.6e1 * t11075 * t12785 + 0.18e2 * t11078 * t12785 - t11972 - t11974 - t11982 - 0.3e1 * t12413 + 0.9e1 * t12414 - 0.3e1 * t12416 - 0.9e1 * t12417 - t3205 + t3209 - t3213;
  t12799 = t159 * t8922 * t248;
  t12815 = 0.18e2 * t1050 * t4980 * t11069 - 0.12e2 * t11045 * t1059 * t12792 - 0.18e2 * t11037 * t12799 + 0.18e2 * t11042 * t12799 - 0.18e2 * t11045 * t12793 - 0.6e1 * t11051 * t12785 - t11539 + t11542 + t11544 - 0.9e1 * t12426 + t3234 + t3354 - t3358 - t3360;
  t12817 = t3242 - t3361 - t3362 + t3363 - t2890 + t2900 - t2902 + t2914 - t2924 + t2926 + t3364 - 0.8e1 * t3099 + t3367 + t3370 + t3373;
  t12821 = my_piecewise5(t58, 0, t61, 0, t12673 + t12691 + t12719 + t12754 + t12778 + t12796 + t12815 + t12817);
  t12827 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.5e1 / 0.18e2 * t38 * t48 * t3261 - 0.5e1 / 0.81e2 * t38 * t43 * t3398 + t53 * t12821));
  tv4sigmalapl30 = t8 * t12827;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  t12834 = t4530 * t2604;
  t12840 = t5583 * t3288;
  t12843 = t4530 * t3297;
  t12847 = t4526 * t4650 * t265;
  t12862 = 0.6e1 * t11140 * t12840 - 0.7e1 * t11142 * t12834 - 0.18e2 * t11142 * t12840 - 0.7e1 * t11142 * t12843 + 0.6e1 * t11145 * t12834 + 0.6e1 * t11145 * t12840 + 0.18e2 * t11145 * t12843 + 0.12e2 * t11145 * t12847 - t11148 * t12834 - 0.7e1 * t11148 * t12843 - 0.6e1 * t11148 * t5345 + 0.7e1 * t11148 * t5412 - t12009 + t12011;
  t12864 = t5583 * t878;
  t12869 = t3408 * t265;
  t12883 = -0.12e2 * t3438 * t1838 * t9357 * t265 + 0.3e1 * t220 * t12869 * t5319 + t11140 * t12834 + 0.11e2 * t11140 * t12864 - 0.11e2 * t11142 * t12864 - 0.6e1 * t11145 * t5422 - 0.3e1 * t11225 * t879 - 0.3e1 * t11225 * t889 - t12020 + t12028 + t12030 - t12032 + t12035 - t12052;
  t12901 = 0.6e1 * t11140 * t5583 * t884 + 0.3e1 * t538 * t12869 * t4618 + t5289 * t11272 + 0.11e2 * t5267 * t11277 + 0.3e1 * t11285 * t885 + 0.6e1 * t5273 * t11290 - t11677 - t12054 + t12058 + t12064 + t12067 - 0.6e1 * t12475 - 0.9e1 * t12479 - 0.3e1 * t12485;
  t12918 = -0.6e1 * t11148 * t4645 * t4656 * t265 + 0.7e1 * t11142 * t5360 - 0.11e2 * t11142 * t5412 - 0.12e2 * t11148 * t12847 - 0.6e1 * t5289 * t11185 + 0.18e2 * t5289 * t11195 + 0.11e2 * t5289 * t11257 - t11679 + t11685 + t12106 - t12108 - t12112 - t828 - t932;
  t12940 = -0.6e1 * t1430 * t668 * t11175 - 0.12e2 * t11145 * t5345 - 0.18e2 * t5273 * t11213 - 0.18e2 * t684 * t11221 + 0.9e1 * t12536 + 0.9e1 * t12540 + 0.9e1 * t12545 - 0.9e1 * t12549 - 0.6e1 * t12555 + 0.9e1 * t12563 + 0.9e1 * t12595 - 0.3e1 * t12597 + 0.9e1 * t12598 - 0.3e1 * t12600;
  t12951 = t228 * t1093 * t562 * t265;
  t12956 = t10140 * t265;
  t12957 = t548 * t12956;
  t12962 = -0.18e2 * t11119 * t228 * t10176 * t265 - 0.6e1 * t11313 * t12951 + 0.18e2 * t11316 * t12951 + 0.18e2 * t11316 * t3276 + 0.18e2 * t11319 * t12957 + 0.18e2 * t11322 * t5553 - t12151 - t12153 - t12160 - 0.9e1 * t12601 + 0.9e1 * t12603 + t3277 - t3281 - t3284;
  t12977 = -0.12e2 * t11122 * t1439 * t12956 + 0.18e2 * t1430 * t5486 * t11305 - 0.18e2 * t11122 * t12957 - 0.6e1 * t11322 * t12951 + t11747 + t11750 - t11752 - 0.9e1 * t12626 - 0.9e1 * t12629 + 0.9e1 * t12631 + t3305 - t3420 - t3422 + t3426;
  t12979 = t3313 - t3427 - t3428 + t3429 - t2962 + t2974 - t2976 - t2986 + t2994 + t3004 + t3430 - 0.8e1 * t3184 + t3433 + t3440 + t3443;
  t12983 = my_piecewise5(t104, 0, t105, 0, t12862 + t12883 + t12901 + t12918 + t12940 + t12962 + t12977 + t12979);
  t12989 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (0.5e1 / 0.18e2 * t38 * t98 * t3332 - 0.5e1 / 0.81e2 * t38 * t93 * t3464 + t103 * t12983));
  tv4sigmalapl311 = t8 * t12989;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  tv4sigmatau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  tv4sigmatau311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  t12995 = t902 * t902;
  t12996 = t12995 * t383;
  t13000 = t359 * t12996;
  t13003 = t12995 * t362;
  t13004 = t1050 * t13003;
  t13007 = t151 * t13003;
  t13010 = t359 * t13003;
  t13015 = t1050 * t12996;
  t13025 = t12995 * t3656;
  t13026 = t1050 * t13025;
  t13029 = t3677 * t13025;
  t13033 = t359 * t13025;
  t13038 = t151 * t13025;
  t13046 = 0.18e2 * t13004 * t3632 - 0.12e2 * t13015 * t3637 + 0.12e2 * t13026 * t3699 - 0.18e2 * t13026 * t3737 + 0.6e1 * t13026 * t3803 - 0.6e1 * t13029 * t3761 - t13029 * t3803 - 0.7e1 * t13033 * t3711 - 0.7e1 * t13033 * t3803 + t13038 * t3803 + 0.6e1 * t13038 * t3813;
  t13058 = t12995 * t3651;
  t13059 = t359 * t13058;
  t13096 = -0.6e1 * t13004 * t3773 - 0.12e2 * t13026 * t3761 - 0.12e2 * t13029 * t3699 - 0.6e1 * t13029 * t3707 + 0.18e2 * t13029 * t3720 + 0.11e2 * t13029 * t3728 - 0.6e1 * t13029 * t3756 - 0.11e2 * t13033 * t3715 + 0.7e1 * t13033 * t3737 - 0.11e2 * t13033 * t3784 + 0.11e2 * t13038 * t3784;
  t13117 = 0.18e2 * t12356 + 0.18e2 * t12360 + 0.18e2 * t12363 - 0.18e2 * t12367 - 0.12e2 * t12375 + 0.18e2 * t12383 + 0.18e2 * t12411 - 0.6e1 * t12413 + 0.18e2 * t12414 - 0.6e1 * t12416 - 0.18e2 * t12417;
  t13120 = t359 * t12995;
  t13123 = t151 * t12995;
  t13147 = 0.4e1 * t3353 - 0.4e1 * t3357 - 0.4e1 * t3359 - 0.4e1 * t3059 - 0.4e1 * t3067 + 0.4e1 * t3075 + 0.4e1 * t3095 - 0.9e1 * t3099 + 0.4e1 * t3102 + 0.4e1 * t3369 + 0.4e1 * t3372;
  t13151 = my_piecewise5(t58, 0, t61, 0, -t801 - t909 + 0.18e2 * t12235 + 0.6e1 * t13123 * t3660 - 0.3e1 * t13059 * t393 - 0.18e2 * t13010 * t3734 - 0.6e1 * t13026 * t3720 - 0.18e2 * t13033 * t3813 + 0.18e2 * t13026 * t3711 + 0.7e1 * t13029 * t3715 - 0.7e1 * t13029 * t3711 + 0.6e1 * t13026 * t3813 + 0.18e2 * t13010 * t3576 + 0.18e2 * t13000 * t3593 - 0.18e2 * t13015 * t3593 - 0.6e1 * t13004 * t3576 + 0.18e2 * t13000 * t3551 + 0.18e2 * t13004 * t3619 - 0.6e1 * t13007 * t3576 + 0.11e2 * t13120 * t3685 - 0.3e1 * t13059 * t376 + 0.3e1 * t13120 * t3664 + 0.3e1 * t13123 * t3653 + t13117 + t13096 + t13046 + t11544 - t11539 + t11542 - 0.18e2 * t151 * t12996 * t3551 + 0.3e1 * t151 * t13058 * t376 + 0.6e1 * t1050 * t12995 * t3668 + t3677 * t12995 * t3683 - t11468 - t11463 + t11466 + t13147 - 0.12e2 * t13007 * t1579 * t158 * t383 - 0.18e2 * t12426 - 0.18e2 * t12258 + 0.18e2 * t12352 - 0.18e2 * t12298 - 0.6e1 * t12302 - 0.12e2 * t12305);
  t13157 = my_piecewise3(t2, 0, 0.3e1 / 0.2e2 * t7 * t32 * (0.1e2 / 0.27e2 * t38 * t48 * t3398 + t53 * t13151));
  tv4lapl40 = t8 * t13157;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  t13161 = t925 * t925;
  t13162 = t13161 * t562;
  t13163 = t220 * t13162;
  t13169 = t13161 * t541;
  t13170 = t1430 * t13169;
  t13176 = t538 * t13169;
  t13181 = t1430 * t13162;
  t13191 = t13161 * t4501;
  t13192 = t1430 * t13191;
  t13195 = t538 * t13191;
  t13200 = t4539 * t13191;
  t13206 = t220 * t13191;
  t13217 = 0.6e1 * t13192 * t4523 + 0.6e1 * t13192 * t4531 + 0.18e2 * t13192 * t4581 + 0.12e2 * t13192 * t4651 - 0.18e2 * t13195 * t4523 - 0.7e1 * t13195 * t4581 - t13200 * t4531 - 0.6e1 * t13200 * t4546 + 0.7e1 * t13200 * t4558 - 0.7e1 * t13200 * t4581 + 0.6e1 * t13206 * t4523;
  t13234 = t13161 * t4496;
  t13235 = t538 * t13234;
  t13263 = 0.3e1 * t220 * t13234 * t555 - 0.12e2 * t13163 * t11714 - 0.6e1 * t13192 * t4527 - 0.11e2 * t13195 * t4507 - 0.11e2 * t13195 * t4558 + 0.18e2 * t13200 * t4527 + 0.11e2 * t13200 * t4647 - 0.12e2 * t13200 * t4651 - 0.6e1 * t13200 * t4657 + 0.11e2 * t13206 * t4507 - 0.12e2 * t12475;
  t13283 = -0.18e2 * t12549 - 0.12e2 * t12555 + 0.18e2 * t12563 + 0.18e2 * t12595 - 0.6e1 * t12597 + 0.18e2 * t12598 - 0.6e1 * t12600 - 0.18e2 * t12601 + 0.18e2 * t12603 - 0.18e2 * t12626 - 0.18e2 * t12629;
  t13291 = t538 * t13161;
  t13296 = t220 * t13161;
  t13313 = -0.4e1 * t3419 - 0.4e1 * t3421 + 0.4e1 * t3425 - 0.4e1 * t3132 - 0.4e1 * t3140 + 0.4e1 * t3147 + 0.4e1 * t3180 - 0.9e1 * t3184 + 0.4e1 * t3187 + 0.4e1 * t3439 + 0.4e1 * t3442;
  t13317 = my_piecewise5(t104, 0, t105, 0, -t828 - t932 + t13313 + t13217 + t13263 + t13283 + 0.18e2 * t13176 * t4378 + 0.18e2 * t13170 * t4448 - 0.12e2 * t13181 * t4473 - 0.6e1 * t13170 * t4378 + 0.18e2 * t13176 * t4386 - 0.18e2 * t13181 * t4462 - 0.18e2 * t13163 * t5478 + 0.11e2 * t13291 * t4636 + 0.3e1 * t13291 * t4618 + 0.3e1 * t13296 * t4602 + 0.6e1 * t13296 * t4614 + t13206 * t4531 - 0.7e1 * t13195 * t4531 - 0.6e1 * t13200 * t4667 - 0.18e2 * t13192 * t4553 - 0.18e2 * t13176 * t4518 + 0.7e1 * t13195 * t4553 - 0.6e1 * t13170 * t4570 - 0.12e2 * t13192 * t4546 - 0.3e1 * t13235 * t555 - 0.3e1 * t13235 * t572 + 0.18e2 * t13170 * t4456 - t11752 + t11750 + t11747 + t11685 - t11677 - t11679 + 0.18e2 * t538 * t13162 * t4462 - 0.6e1 * t220 * t13169 * t4378 + 0.6e1 * t1430 * t13161 * t4622 + t4539 * t13161 * t4630 + 0.18e2 * t12631 + 0.18e2 * t12545 + 0.18e2 * t12540 + 0.18e2 * t12536 - 0.6e1 * t12485 - 0.18e2 * t12479);
  t13323 = my_piecewise3(t78, 0, 0.3e1 / 0.2e2 * t7 * t88 * (0.1e2 / 0.27e2 * t38 * t98 * t3464 + t103 * t13317));
  tv4lapl44 = t8 * t13323;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  tv4tau40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  tv4tau44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

