/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_c_wl.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t12;
  double t14, t15, t16, t17, t18, t22, t23, tzk0;


  t1 = sqrt(sigma[0]);
  t2 = POW_1_3(rho[0]);
  t4 = 0.1e1 / t2 / rho[0];
  t5 = t1 * t4;
  t7 = -0.7486e0 + 0.6001e-1 * t5;
  t8 = M_CBRT2;
  t9 = t1 * t8;
  t12 = M_CBRT3;
  t14 = POW_1_3(0.1e1 / M_PI);
  t15 = t12 * t14;
  t16 = M_CBRT4;
  t17 = t16 * t16;
  t18 = 0.1e1 / t2;
  t22 = 0.360073e1 + 0.18e1 * t9 * t4 + t15 * t17 * t18 / 0.4e1;
  t23 = 0.1e1 / t22;
  tzk0 = t7 * t23;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t12;
  double t14, t15, t16, t17, t18, t22, t23, tzk0;

  double t26, t27, t28, t29, t31, t37, t38, tvrho0;
  double t40, t41, t44, t46, tvsigma0;


  t1 = sqrt(sigma[0]);
  t2 = POW_1_3(rho[0]);
  t4 = 0.1e1 / t2 / rho[0];
  t5 = t1 * t4;
  t7 = -0.7486e0 + 0.6001e-1 * t5;
  t8 = M_CBRT2;
  t9 = t1 * t8;
  t12 = M_CBRT3;
  t14 = POW_1_3(0.1e1 / M_PI);
  t15 = t12 * t14;
  t16 = M_CBRT4;
  t17 = t16 * t16;
  t18 = 0.1e1 / t2;
  t22 = 0.360073e1 + 0.18e1 * t9 * t4 + t15 * t17 * t18 / 0.4e1;
  t23 = 0.1e1 / t22;
  tzk0 = t7 * t23;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t26 = rho[0] * t7;
  t27 = t22 * t22;
  t28 = 0.1e1 / t27;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t2 / t29;
  t37 = -0.24e1 * t9 * t31 - t15 * t17 * t4 / 0.12e2;
  t38 = t28 * t37;
  tvrho0 = tzk0 - 0.80013333333333333333e-1 * t5 * t23 - t26 * t38;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t40 = 0.1e1 / t1;
  t41 = t18 * t40;
  t44 = t18 * t7;
  t46 = t28 * t40 * t8;
  tvsigma0 = 0.30005e-1 * t41 * t23 - 0.9e0 * t44 * t46;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t12;
  double t14, t15, t16, t17, t18, t22, t23, tzk0;

  double t26, t27, t28, t29, t31, t37, t38, tvrho0;
  double t40, t41, t44, t46, tvsigma0;

  double t49, t52, t58, t59, t60, t63, t65, t71;
  double t72, tv2rho20, t74, t79, t82, t84, t88, t89;
  double t90, tv2rhosigma0, t94, t95, t99, t100, t101, t102;
  double t105, t107, t108, t112, tv2sigma20;


  t1 = sqrt(sigma[0]);
  t2 = POW_1_3(rho[0]);
  t4 = 0.1e1 / t2 / rho[0];
  t5 = t1 * t4;
  t7 = -0.7486e0 + 0.6001e-1 * t5;
  t8 = M_CBRT2;
  t9 = t1 * t8;
  t12 = M_CBRT3;
  t14 = POW_1_3(0.1e1 / M_PI);
  t15 = t12 * t14;
  t16 = M_CBRT4;
  t17 = t16 * t16;
  t18 = 0.1e1 / t2;
  t22 = 0.360073e1 + 0.18e1 * t9 * t4 + t15 * t17 * t18 / 0.4e1;
  t23 = 0.1e1 / t22;
  tzk0 = t7 * t23;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t26 = rho[0] * t7;
  t27 = t22 * t22;
  t28 = 0.1e1 / t27;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t2 / t29;
  t37 = -0.24e1 * t9 * t31 - t15 * t17 * t4 / 0.12e2;
  t38 = t28 * t37;
  tvrho0 = tzk0 - 0.80013333333333333333e-1 * t5 * t23 - t26 * t38;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t40 = 0.1e1 / t1;
  t41 = t18 * t40;
  t44 = t18 * t7;
  t46 = t28 * t40 * t8;
  tvsigma0 = 0.30005e-1 * t41 * t23 - 0.9e0 * t44 * t46;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t49 = t1 * t31;
  t52 = t7 * t28;
  t58 = 0.1e1 / t27 / t22;
  t59 = t37 * t37;
  t60 = t58 * t59;
  t63 = t29 * rho[0];
  t65 = 0.1e1 / t2 / t63;
  t71 = 0.56e1 * t9 * t65 + t15 * t17 * t31 / 0.9e1;
  t72 = t28 * t71;
  tv2rho20 = 0.26671111111111111107e-1 * t49 * t23 - 0.2e1 * t52 * t37 + 0.16002666666666666667e0 * t5 * t38 + 0.2e1 * t26 * t60 - t26 * t72;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t74 = t4 * t40;
  t79 = t4 * t7;
  t82 = t2 * t2;
  t84 = 0.1e1 / t82 / t29;
  t88 = t44 * t58;
  t89 = t40 * t8;
  t90 = t89 * t37;
  tv2rhosigma0 = -0.10001666666666666667e-1 * t74 * t23 - 0.30005e-1 * t41 * t38 + 0.3e0 * t79 * t46 + 0.72012e-1 * t84 * t28 * t8 + 0.18e1 * t88 * t90;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t94 = 0.1e1 / t1 / sigma[0];
  t95 = t18 * t94;
  t99 = 0.1e1 / t82 / rho[0];
  t100 = 0.1e1 / sigma[0];
  t101 = t99 * t100;
  t102 = t28 * t8;
  t105 = t99 * t7;
  t107 = t8 * t8;
  t108 = t58 * t100 * t107;
  t112 = t28 * t94 * t8;
  tv2sigma20 = -0.150025e-1 * t95 * t23 - 0.54009e-1 * t101 * t102 + 0.162e1 * t105 * t108 + 0.45e0 * t44 * t112;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t12;
  double t14, t15, t16, t17, t18, t22, t23, tzk0;

  double t26, t27, t28, t29, t31, t37, t38, tvrho0;
  double t40, t41, t44, t46, tvsigma0;

  double t49, t52, t58, t59, t60, t63, t65, t71;
  double t72, tv2rho20, t74, t79, t82, t84, t88, t89;
  double t90, tv2rhosigma0, t94, t95, t99, t100, t101, t102;
  double t105, t107, t108, t112, tv2sigma20;

  double t115, t120, t129, t130, t131, t132, t135, t136;
  double t139, t141, t147, t148, tv3rho30, t150, t159, t163;
  double t167, t170, t171, t174, t175, t178, tv3rho2sigma0, t181;
  double t186, t189, t190, t193, t196, t197, t198, t201;
  double t202, t203, t208, t209, tv3rhosigma20, t212, t214, t215;
  double t218, t219, t222, t223, t226, t227, t231, t235;
  double tv3sigma30;


  t1 = sqrt(sigma[0]);
  t2 = POW_1_3(rho[0]);
  t4 = 0.1e1 / t2 / rho[0];
  t5 = t1 * t4;
  t7 = -0.7486e0 + 0.6001e-1 * t5;
  t8 = M_CBRT2;
  t9 = t1 * t8;
  t12 = M_CBRT3;
  t14 = POW_1_3(0.1e1 / M_PI);
  t15 = t12 * t14;
  t16 = M_CBRT4;
  t17 = t16 * t16;
  t18 = 0.1e1 / t2;
  t22 = 0.360073e1 + 0.18e1 * t9 * t4 + t15 * t17 * t18 / 0.4e1;
  t23 = 0.1e1 / t22;
  tzk0 = t7 * t23;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t26 = rho[0] * t7;
  t27 = t22 * t22;
  t28 = 0.1e1 / t27;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t2 / t29;
  t37 = -0.24e1 * t9 * t31 - t15 * t17 * t4 / 0.12e2;
  t38 = t28 * t37;
  tvrho0 = tzk0 - 0.80013333333333333333e-1 * t5 * t23 - t26 * t38;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t40 = 0.1e1 / t1;
  t41 = t18 * t40;
  t44 = t18 * t7;
  t46 = t28 * t40 * t8;
  tvsigma0 = 0.30005e-1 * t41 * t23 - 0.9e0 * t44 * t46;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t49 = t1 * t31;
  t52 = t7 * t28;
  t58 = 0.1e1 / t27 / t22;
  t59 = t37 * t37;
  t60 = t58 * t59;
  t63 = t29 * rho[0];
  t65 = 0.1e1 / t2 / t63;
  t71 = 0.56e1 * t9 * t65 + t15 * t17 * t31 / 0.9e1;
  t72 = t28 * t71;
  tv2rho20 = 0.26671111111111111107e-1 * t49 * t23 - 0.2e1 * t52 * t37 + 0.16002666666666666667e0 * t5 * t38 + 0.2e1 * t26 * t60 - t26 * t72;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t74 = t4 * t40;
  t79 = t4 * t7;
  t82 = t2 * t2;
  t84 = 0.1e1 / t82 / t29;
  t88 = t44 * t58;
  t89 = t40 * t8;
  t90 = t89 * t37;
  tv2rhosigma0 = -0.10001666666666666667e-1 * t74 * t23 - 0.30005e-1 * t41 * t38 + 0.3e0 * t79 * t46 + 0.72012e-1 * t84 * t28 * t8 + 0.18e1 * t88 * t90;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t94 = 0.1e1 / t1 / sigma[0];
  t95 = t18 * t94;
  t99 = 0.1e1 / t82 / rho[0];
  t100 = 0.1e1 / sigma[0];
  t101 = t99 * t100;
  t102 = t28 * t8;
  t105 = t99 * t7;
  t107 = t8 * t8;
  t108 = t58 * t100 * t107;
  t112 = t28 * t94 * t8;
  tv2sigma20 = -0.150025e-1 * t95 * t23 - 0.54009e-1 * t101 * t102 + 0.162e1 * t105 * t108 + 0.45e0 * t44 * t112;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t115 = t1 * t65;
  t120 = t7 * t58;
  t129 = t27 * t27;
  t130 = 0.1e1 / t129;
  t131 = t59 * t37;
  t132 = t130 * t131;
  t135 = t58 * t37;
  t136 = t135 * t71;
  t139 = t29 * t29;
  t141 = 0.1e1 / t2 / t139;
  t147 = -0.18666666666666666667e2 * t9 * t141 - 0.7e1 / 0.27e2 * t15 * t17 * t65;
  t148 = t28 * t147;
  tv3rho30 = -0.62232592592592592583e-1 * t115 * t23 - 0.8001333333333333333e-1 * t49 * t38 + 0.6e1 * t120 * t59 - 0.3e1 * t52 * t71 - 0.48008000000000000001e0 * t5 * t60 + 0.24004e0 * t5 * t72 - 0.6e1 * t26 * t132 + 0.6e1 * t26 * t136 - t26 * t148;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t150 = t31 * t40;
  t159 = t31 * t7;
  t163 = 0.1e1 / t82 / t63;
  t167 = t79 * t58;
  t170 = t84 * t58;
  t171 = t8 * t37;
  t174 = t44 * t130;
  t175 = t89 * t59;
  t178 = t89 * t71;
  tv3rho2sigma0 = 0.13335555555555555556e-1 * t150 * t23 + 0.20003333333333333334e-1 * t74 * t38 + 0.6001e-1 * t41 * t60 - 0.30005e-1 * t41 * t72 - 0.4e0 * t159 * t46 - 0.216036e0 * t163 * t28 * t8 - 0.12e1 * t167 * t90 - 0.288048e0 * t170 * t171 - 0.54e1 * t174 * t175 + 0.18e1 * t88 * t178;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t181 = t4 * t94;
  t186 = t84 * t100;
  t189 = t58 * t8;
  t190 = t189 * t37;
  t193 = t84 * t7;
  t196 = 0.1e1 / t139;
  t197 = t196 * t40;
  t198 = t58 * t107;
  t201 = t105 * t130;
  t202 = t100 * t107;
  t203 = t202 * t37;
  t208 = t94 * t8;
  t209 = t208 * t37;
  tv3rhosigma20 = 0.50008333333333333333e-2 * t181 * t23 + 0.150025e-1 * t95 * t38 + 0.54009e-1 * t186 * t102 + 0.108018e0 * t101 * t190 - 0.27e1 * t193 * t108 - 0.1296216e0 * t197 * t198 - 0.486e1 * t201 * t203 - 0.15e0 * t79 * t112 - 0.9e0 * t88 * t209;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t212 = sigma[0] * sigma[0];
  t214 = 0.1e1 / t1 / t212;
  t215 = t18 * t214;
  t218 = 0.1e1 / t212;
  t219 = t99 * t218;
  t222 = 0.1e1 / t63;
  t223 = t222 * t94;
  t226 = t222 * t7;
  t227 = t130 * t94;
  t231 = t58 * t218 * t107;
  t235 = t28 * t214 * t8;
  tv3sigma30 = 0.2250375e-1 * t215 * t23 + 0.810135e-1 * t219 * t102 + 0.1458243e0 * t223 * t198 - 0.8748e1 * t226 * t227 - 0.243e1 * t105 * t231 - 0.675e0 * t44 * t235;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t4, t5, t7, t8, t9, t12;
  double t14, t15, t16, t17, t18, t22, t23, tzk0;

  double t26, t27, t28, t29, t31, t37, t38, tvrho0;
  double t40, t41, t44, t46, tvsigma0;

  double t49, t52, t58, t59, t60, t63, t65, t71;
  double t72, tv2rho20, t74, t79, t82, t84, t88, t89;
  double t90, tv2rhosigma0, t94, t95, t99, t100, t101, t102;
  double t105, t107, t108, t112, tv2sigma20;

  double t115, t120, t129, t130, t131, t132, t135, t136;
  double t139, t141, t147, t148, tv3rho30, t150, t159, t163;
  double t167, t170, t171, t174, t175, t178, tv3rho2sigma0, t181;
  double t186, t189, t190, t193, t196, t197, t198, t201;
  double t202, t203, t208, t209, tv3rhosigma20, t212, t214, t215;
  double t218, t219, t222, t223, t226, t227, t231, t235;
  double tv3sigma30;

  double t248, t253, t255, t273, t274, t282, tv4rho40, tv4rho3sigma0;
  double t378, tv4rho2sigma20, tv4rhosigma30, t429, t431, t435, tv4sigma40;


  t1 = sqrt(sigma[0]);
  t2 = POW_1_3(rho[0]);
  t4 = 0.1e1 / t2 / rho[0];
  t5 = t1 * t4;
  t7 = -0.7486e0 + 0.6001e-1 * t5;
  t8 = M_CBRT2;
  t9 = t1 * t8;
  t12 = M_CBRT3;
  t14 = POW_1_3(0.1e1 / M_PI);
  t15 = t12 * t14;
  t16 = M_CBRT4;
  t17 = t16 * t16;
  t18 = 0.1e1 / t2;
  t22 = 0.360073e1 + 0.18e1 * t9 * t4 + t15 * t17 * t18 / 0.4e1;
  t23 = 0.1e1 / t22;
  tzk0 = t7 * t23;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t26 = rho[0] * t7;
  t27 = t22 * t22;
  t28 = 0.1e1 / t27;
  t29 = rho[0] * rho[0];
  t31 = 0.1e1 / t2 / t29;
  t37 = -0.24e1 * t9 * t31 - t15 * t17 * t4 / 0.12e2;
  t38 = t28 * t37;
  tvrho0 = tzk0 - 0.80013333333333333333e-1 * t5 * t23 - t26 * t38;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t40 = 0.1e1 / t1;
  t41 = t18 * t40;
  t44 = t18 * t7;
  t46 = t28 * t40 * t8;
  tvsigma0 = 0.30005e-1 * t41 * t23 - 0.9e0 * t44 * t46;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t49 = t1 * t31;
  t52 = t7 * t28;
  t58 = 0.1e1 / t27 / t22;
  t59 = t37 * t37;
  t60 = t58 * t59;
  t63 = t29 * rho[0];
  t65 = 0.1e1 / t2 / t63;
  t71 = 0.56e1 * t9 * t65 + t15 * t17 * t31 / 0.9e1;
  t72 = t28 * t71;
  tv2rho20 = 0.26671111111111111107e-1 * t49 * t23 - 0.2e1 * t52 * t37 + 0.16002666666666666667e0 * t5 * t38 + 0.2e1 * t26 * t60 - t26 * t72;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t74 = t4 * t40;
  t79 = t4 * t7;
  t82 = t2 * t2;
  t84 = 0.1e1 / t82 / t29;
  t88 = t44 * t58;
  t89 = t40 * t8;
  t90 = t89 * t37;
  tv2rhosigma0 = -0.10001666666666666667e-1 * t74 * t23 - 0.30005e-1 * t41 * t38 + 0.3e0 * t79 * t46 + 0.72012e-1 * t84 * t28 * t8 + 0.18e1 * t88 * t90;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t94 = 0.1e1 / t1 / sigma[0];
  t95 = t18 * t94;
  t99 = 0.1e1 / t82 / rho[0];
  t100 = 0.1e1 / sigma[0];
  t101 = t99 * t100;
  t102 = t28 * t8;
  t105 = t99 * t7;
  t107 = t8 * t8;
  t108 = t58 * t100 * t107;
  t112 = t28 * t94 * t8;
  tv2sigma20 = -0.150025e-1 * t95 * t23 - 0.54009e-1 * t101 * t102 + 0.162e1 * t105 * t108 + 0.45e0 * t44 * t112;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t115 = t1 * t65;
  t120 = t7 * t58;
  t129 = t27 * t27;
  t130 = 0.1e1 / t129;
  t131 = t59 * t37;
  t132 = t130 * t131;
  t135 = t58 * t37;
  t136 = t135 * t71;
  t139 = t29 * t29;
  t141 = 0.1e1 / t2 / t139;
  t147 = -0.18666666666666666667e2 * t9 * t141 - 0.7e1 / 0.27e2 * t15 * t17 * t65;
  t148 = t28 * t147;
  tv3rho30 = -0.62232592592592592583e-1 * t115 * t23 - 0.8001333333333333333e-1 * t49 * t38 + 0.6e1 * t120 * t59 - 0.3e1 * t52 * t71 - 0.48008000000000000001e0 * t5 * t60 + 0.24004e0 * t5 * t72 - 0.6e1 * t26 * t132 + 0.6e1 * t26 * t136 - t26 * t148;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t150 = t31 * t40;
  t159 = t31 * t7;
  t163 = 0.1e1 / t82 / t63;
  t167 = t79 * t58;
  t170 = t84 * t58;
  t171 = t8 * t37;
  t174 = t44 * t130;
  t175 = t89 * t59;
  t178 = t89 * t71;
  tv3rho2sigma0 = 0.13335555555555555556e-1 * t150 * t23 + 0.20003333333333333334e-1 * t74 * t38 + 0.6001e-1 * t41 * t60 - 0.30005e-1 * t41 * t72 - 0.4e0 * t159 * t46 - 0.216036e0 * t163 * t28 * t8 - 0.12e1 * t167 * t90 - 0.288048e0 * t170 * t171 - 0.54e1 * t174 * t175 + 0.18e1 * t88 * t178;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t181 = t4 * t94;
  t186 = t84 * t100;
  t189 = t58 * t8;
  t190 = t189 * t37;
  t193 = t84 * t7;
  t196 = 0.1e1 / t139;
  t197 = t196 * t40;
  t198 = t58 * t107;
  t201 = t105 * t130;
  t202 = t100 * t107;
  t203 = t202 * t37;
  t208 = t94 * t8;
  t209 = t208 * t37;
  tv3rhosigma20 = 0.50008333333333333333e-2 * t181 * t23 + 0.150025e-1 * t95 * t38 + 0.54009e-1 * t186 * t102 + 0.108018e0 * t101 * t190 - 0.27e1 * t193 * t108 - 0.1296216e0 * t197 * t198 - 0.486e1 * t201 * t203 - 0.15e0 * t79 * t112 - 0.9e0 * t88 * t209;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t212 = sigma[0] * sigma[0];
  t214 = 0.1e1 / t1 / t212;
  t215 = t18 * t214;
  t218 = 0.1e1 / t212;
  t219 = t99 * t218;
  t222 = 0.1e1 / t63;
  t223 = t222 * t94;
  t226 = t222 * t7;
  t227 = t130 * t94;
  t231 = t58 * t218 * t107;
  t235 = t28 * t214 * t8;
  tv3sigma30 = 0.2250375e-1 * t215 * t23 + 0.810135e-1 * t219 * t102 + 0.1458243e0 * t223 * t198 - 0.8748e1 * t226 * t227 - 0.243e1 * t105 * t231 - 0.675e0 * t44 * t235;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t248 = t37 * t71;
  t253 = t139 * rho[0];
  t255 = 0.1e1 / t2 / t253;
  t273 = 0.1e1 / t129 / t22;
  t274 = t59 * t59;
  t282 = t71 * t71;
  tv4rho40 = 0.20744197530864197528e0 * t1 * t141 * t23 + 0.24893037037037037035e0 * t115 * t38 - 0.16002666666666666666e0 * t49 * t72 - 0.24e2 * t7 * t130 * t131 + 0.24e2 * t120 * t248 + 0.32005333333333333333e0 * t5 * t148 - t26 * t28 * (0.8088888888888888889e2 * t9 * t255 + 0.7e2 / 0.81e2 * t15 * t17 * t141) - 0.4e1 * t52 * t147 + 0.32005333333333333334e0 * t49 * t60 + 0.192032e1 * t5 * t132 - 0.192032e1 * t5 * t136 + 0.24e2 * t26 * t273 * t274 - 0.36e2 * t26 * t130 * t59 * t71 + 0.6e1 * t26 * t58 * t282 + 0.8e1 * t26 * t135 * t147;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  tv4rho3sigma0 = -0.31116296296296296297e-1 * t65 * t40 * t23 - 0.40006666666666666668e-1 * t150 * t38 + 0.30005000000000000001e-1 * t74 * t72 - 0.30005e-1 * t41 * t148 + 0.1296216e1 * t163 * t58 * t171 - 0.432072e0 * t170 * t8 * t71 + 0.93333333333333333333e0 * t65 * t7 * t46 + 0.24e1 * t159 * t58 * t90 - 0.18e1 * t167 * t178 + 0.18e1 * t88 * t89 * t147 + 0.54e1 * t79 * t130 * t175 + 0.216e2 * t44 * t273 * t89 * t131 - 0.162e2 * t174 * t89 * t248 + 0.82413733333333333333e0 / t82 / t139 * t28 * t8 - 0.60010000000000000001e-1 * t74 * t60 - 0.18003e0 * t41 * t132 + 0.18003e0 * t41 * t136 + 0.1296216e1 * t84 * t130 * t8 * t59;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t378 = t130 * t107 * t37;
  tv4rho2sigma20 = -0.324054e0 * t101 * t130 * t8 * t59 + 0.72e1 * t163 * t7 * t108 + 0.162e2 * t193 * t130 * t203 - 0.486e1 * t201 * t202 * t71 + 0.2e0 * t159 * t112 + 0.6e0 * t167 * t209 - 0.9e0 * t88 * t208 * t71 + 0.1944e2 * t105 * t273 * t202 * t59 + 0.27e1 * t174 * t208 * t59 - 0.30005e-1 * t95 * t60 - 0.132022e0 * t163 * t100 * t102 - 0.216036e0 * t186 * t190 + 0.108018e0 * t101 * t189 * t71 + 0.7777296e0 * t197 * t378 - 0.66677777777777777777e-2 * t31 * t94 * t23 - 0.10001666666666666667e-1 * t181 * t38 + 0.150025e-1 * t95 * t72 + 0.7345224e0 / t253 * t40 * t198;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rhosigma30 = -0.750125e-2 * t4 * t214 * t23 - 0.2250375e-1 * t215 * t38 - 0.810135e-1 * t84 * t218 * t102 - 0.162027e0 * t219 * t190 - 0.2430405e0 * t196 * t94 * t198 - 0.4374729e0 * t223 * t378 + 0.26244e2 * t196 * t7 * t227 + 0.69995664e0 * t255 * t100 * t130 + 0.34992e2 * t226 * t273 * t94 * t37 + 0.405e1 * t193 * t231 + 0.729e1 * t201 * t218 * t107 * t37 + 0.225e0 * t79 * t235 + 0.135e1 * t88 * t214 * t8 * t37;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t429 = t212 * sigma[0];
  t431 = 0.1e1 / t1 / t429;
  t435 = 0.1e1 / t429;
  tv4sigma40 = -0.56259375e-1 * t18 * t431 * t23 - 0.20253375e0 * t99 * t435 * t102 - 0.4374729e0 * t222 * t214 * t198 - 0.104993496e1 * t141 * t218 * t130 + 0.314928e2 * t141 * t7 * t273 * t218 * t8 + 0.26244e2 * t226 * t130 * t214 + 0.6075e1 * t105 * t58 * t435 * t107 + 0.16875e1 * t44 * t28 * t431 * t8;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t14, t17, t18, t19, t20, t22;
  double t25, t26, t28, t31, t33, t34, t35, t36;
  double t37, t41, t42, tzk0;


  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = sqrt(t7);
  t10 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t11 = sqrt(t10);
  t12 = POW_1_3(t3);
  t14 = 0.1e1 / t12 / t3;
  t17 = -0.7486e0 + 0.6001e-1 * t11 * t14;
  t18 = t8 * t17;
  t19 = sqrt(sigma[0]);
  t20 = POW_1_3(rho[0]);
  t22 = 0.1e1 / t20 / rho[0];
  t25 = sqrt(sigma[2]);
  t26 = POW_1_3(rho[1]);
  t28 = 0.1e1 / t26 / rho[1];
  t31 = M_CBRT3;
  t33 = POW_1_3(0.1e1 / M_PI);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t37 = 0.1e1 / t12;
  t41 = 0.360073e1 + 0.9e0 * t19 * t22 + 0.9e0 * t25 * t28 + t34 * t36 * t37 / 0.4e1;
  t42 = 0.1e1 / t41;
  tzk0 = t18 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t14, t17, t18, t19, t20, t22;
  double t25, t26, t28, t31, t33, t34, t35, t36;
  double t37, t41, t42, tzk0;

  double t43, t44, t45, t46, t47, t48, t49, t51;
  double t55, t56, t58, t59, t60, t61, t62, t63;
  double t65, t70, t71, tvrho0, t75, t79, t81, t84;
  double tvrho1, t87, t88, t89, t90, t91, t92, t93;
  double t94, t95, tvsigma0, tvsigma1, t98, t99, t100, tvsigma2;


  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = sqrt(t7);
  t10 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t11 = sqrt(t10);
  t12 = POW_1_3(t3);
  t14 = 0.1e1 / t12 / t3;
  t17 = -0.7486e0 + 0.6001e-1 * t11 * t14;
  t18 = t8 * t17;
  t19 = sqrt(sigma[0]);
  t20 = POW_1_3(rho[0]);
  t22 = 0.1e1 / t20 / rho[0];
  t25 = sqrt(sigma[2]);
  t26 = POW_1_3(rho[1]);
  t28 = 0.1e1 / t26 / rho[1];
  t31 = M_CBRT3;
  t33 = POW_1_3(0.1e1 / M_PI);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t37 = 0.1e1 / t12;
  t41 = 0.360073e1 + 0.9e0 * t19 * t22 + 0.9e0 * t25 * t28 + t34 * t36 * t37 / 0.4e1;
  t42 = 0.1e1 / t41;
  tzk0 = t18 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = 0.1e1 / t8;
  t44 = t3 * t43;
  t45 = t17 * t42;
  t46 = t1 * t5;
  t47 = t4 * t3;
  t48 = 0.1e1 / t47;
  t49 = t2 * t48;
  t51 = -0.2e1 * t46 + 0.2e1 * t49;
  t55 = t14 * t8;
  t56 = t11 * t42;
  t58 = 0.80013333333333333333e-1 * t55 * t56;
  t59 = t3 * t8;
  t60 = t41 * t41;
  t61 = 0.1e1 / t60;
  t62 = t17 * t61;
  t63 = rho[0] * rho[0];
  t65 = 0.1e1 / t20 / t63;
  t70 = t34 * t36 * t14 / 0.12e2;
  t71 = -0.12e1 * t19 * t65 - t70;
  tvrho0 = tzk0 + t44 * t45 * t51 / 0.2e1 - t58 - t59 * t62 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t75 = 0.2e1 * t46 + 0.2e1 * t49;
  t79 = rho[1] * rho[1];
  t81 = 0.1e1 / t26 / t79;
  t84 = -0.12e1 * t25 * t81 - t70;
  tvrho1 = tzk0 + t44 * t45 * t75 / 0.2e1 - t58 - t59 * t62 * t84;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t87 = t37 * t8;
  t88 = 0.1e1 / t11;
  t89 = t88 * t42;
  t90 = t87 * t89;
  t91 = 0.30005e-1 * t90;
  t92 = t59 * t17;
  t93 = 0.1e1 / t19;
  t94 = t61 * t93;
  t95 = t94 * t22;
  tvsigma0 = t91 - 0.45e0 * t92 * t95;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.6001e-1 * t90;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t98 = 0.1e1 / t25;
  t99 = t61 * t98;
  t100 = t99 * t28;
  tvsigma2 = t91 - 0.45e0 * t92 * t100;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t14, t17, t18, t19, t20, t22;
  double t25, t26, t28, t31, t33, t34, t35, t36;
  double t37, t41, t42, tzk0;

  double t43, t44, t45, t46, t47, t48, t49, t51;
  double t55, t56, t58, t59, t60, t61, t62, t63;
  double t65, t70, t71, tvrho0, t75, t79, t81, t84;
  double tvrho1, t87, t88, t89, t90, t91, t92, t93;
  double t94, t95, tvsigma0, tvsigma1, t98, t99, t100, tvsigma2;

  double t103, t104, t105, t106, t108, t109, t111, t113;
  double t116, t117, t118, t122, t124, t126, t127, t128;
  double t130, t132, t133, t134, t136, t137, t141, t143;
  double t146, t147, t148, t152, t154, t158, t159, t160;
  double tv2rho20, t164, t165, t167, t168, t172, t174, t175;
  double t178, t184, t185, t186, t190, t192, t193, t197;
  double t198, t199, tv2rho21, t203, t208, t210, t215, t219;
  double t221, t224, tv2rho22, t227, t228, t229, t230, t231;
  double t232, t233, t234, t235, t236, t238, t239, t240;
  double t243, t245, t246, t247, t248, t251, tv2rhosigma0, t254;
  double tv2rhosigma1, t258, t259, t260, t264, t265, t266, t267;
  double tv2rhosigma2, t270, t271, t272, t273, t274, t275, t276;
  double t277, t280, t281, tv2rhosigma3, tv2rhosigma4, t286, t287, t290;
  double t291, t294, tv2rhosigma5, t298, t299, t300, t301, t302;
  double t303, t304, t305, t306, t307, t309, t310, t314;
  double t315, t316, tv2sigma20, t319, tv2sigma21, t321, t323, t324;
  double t325, t326, tv2sigma22, tv2sigma23, t330, tv2sigma24, t331, t332;
  double t333, t335, t336, t340, t341, t342, tv2sigma25;


  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = sqrt(t7);
  t10 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t11 = sqrt(t10);
  t12 = POW_1_3(t3);
  t14 = 0.1e1 / t12 / t3;
  t17 = -0.7486e0 + 0.6001e-1 * t11 * t14;
  t18 = t8 * t17;
  t19 = sqrt(sigma[0]);
  t20 = POW_1_3(rho[0]);
  t22 = 0.1e1 / t20 / rho[0];
  t25 = sqrt(sigma[2]);
  t26 = POW_1_3(rho[1]);
  t28 = 0.1e1 / t26 / rho[1];
  t31 = M_CBRT3;
  t33 = POW_1_3(0.1e1 / M_PI);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t37 = 0.1e1 / t12;
  t41 = 0.360073e1 + 0.9e0 * t19 * t22 + 0.9e0 * t25 * t28 + t34 * t36 * t37 / 0.4e1;
  t42 = 0.1e1 / t41;
  tzk0 = t18 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = 0.1e1 / t8;
  t44 = t3 * t43;
  t45 = t17 * t42;
  t46 = t1 * t5;
  t47 = t4 * t3;
  t48 = 0.1e1 / t47;
  t49 = t2 * t48;
  t51 = -0.2e1 * t46 + 0.2e1 * t49;
  t55 = t14 * t8;
  t56 = t11 * t42;
  t58 = 0.80013333333333333333e-1 * t55 * t56;
  t59 = t3 * t8;
  t60 = t41 * t41;
  t61 = 0.1e1 / t60;
  t62 = t17 * t61;
  t63 = rho[0] * rho[0];
  t65 = 0.1e1 / t20 / t63;
  t70 = t34 * t36 * t14 / 0.12e2;
  t71 = -0.12e1 * t19 * t65 - t70;
  tvrho0 = tzk0 + t44 * t45 * t51 / 0.2e1 - t58 - t59 * t62 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t75 = 0.2e1 * t46 + 0.2e1 * t49;
  t79 = rho[1] * rho[1];
  t81 = 0.1e1 / t26 / t79;
  t84 = -0.12e1 * t25 * t81 - t70;
  tvrho1 = tzk0 + t44 * t45 * t75 / 0.2e1 - t58 - t59 * t62 * t84;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t87 = t37 * t8;
  t88 = 0.1e1 / t11;
  t89 = t88 * t42;
  t90 = t87 * t89;
  t91 = 0.30005e-1 * t90;
  t92 = t59 * t17;
  t93 = 0.1e1 / t19;
  t94 = t61 * t93;
  t95 = t94 * t22;
  tvsigma0 = t91 - 0.45e0 * t92 * t95;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.6001e-1 * t90;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t98 = 0.1e1 / t25;
  t99 = t61 * t98;
  t100 = t99 * t28;
  tvsigma2 = t91 - 0.45e0 * t92 * t100;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t103 = t43 * t17;
  t104 = t42 * t51;
  t105 = t103 * t104;
  t106 = t8 * t11;
  t108 = 0.1e1 / t12 / t4;
  t109 = t108 * t42;
  t111 = 0.26671111111111111107e-1 * t106 * t109;
  t113 = t18 * t61 * t71;
  t116 = 0.1e1 / t8 / t7;
  t117 = t3 * t116;
  t118 = t51 * t51;
  t122 = t14 * t43;
  t124 = t122 * t56 * t51;
  t126 = t44 * t17;
  t127 = t61 * t51;
  t128 = t127 * t71;
  t130 = 0.2e1 * t5;
  t132 = 0.8e1 * t1 * t48;
  t133 = t4 * t4;
  t134 = 0.1e1 / t133;
  t136 = 0.6e1 * t2 * t134;
  t137 = -t130 + t132 - t136;
  t141 = t11 * t61;
  t143 = t55 * t141 * t71;
  t146 = 0.1e1 / t60 / t41;
  t147 = t17 * t146;
  t148 = t71 * t71;
  t152 = t63 * rho[0];
  t154 = 0.1e1 / t20 / t152;
  t158 = t34 * t36 * t108;
  t159 = t158 / 0.9e1;
  t160 = 0.28e1 * t19 * t154 + t159;
  tv2rho20 = t105 + t111 - 0.2e1 * t113 - t117 * t45 * t118 / 0.4e1 - 0.80013333333333333332e-1 * t124 - t126 * t128 + t44 * t45 * t137 / 0.2e1 + 0.16002666666666666667e0 * t143 + 0.2e1 * t59 * t147 * t148 - t59 * t62 * t160;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t164 = t42 * t75;
  t165 = t103 * t164;
  t167 = t117 * t17;
  t168 = t164 * t51;
  t172 = t122 * t56 * t75;
  t174 = t61 * t75;
  t175 = t174 * t71;
  t178 = t130 - t136;
  t184 = t61 * t84;
  t185 = t18 * t184;
  t186 = t184 * t51;
  t190 = t55 * t141 * t84;
  t192 = t146 * t84;
  t193 = t192 * t71;
  t197 = t61 * t31;
  t198 = t33 * t36;
  t199 = t197 * t198;
  tv2rho21 = t105 / 0.2e1 + t111 - t113 + t165 / 0.2e1 - t167 * t168 / 0.4e1 - 0.40006666666666666666e-1 * t172 - t126 * t175 / 0.2e1 + t44 * t45 * t178 / 0.2e1 - 0.40006666666666666666e-1 * t124 + 0.80013333333333333333e-1 * t143 - t185 - t126 * t186 / 0.2e1 + 0.80013333333333333333e-1 * t190 + 0.2e1 * t92 * t193 - t55 * t17 * t199 / 0.9e1;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t203 = t75 * t75;
  t208 = t174 * t84;
  t210 = -t130 - t132 - t136;
  t215 = t84 * t84;
  t219 = t79 * rho[1];
  t221 = 0.1e1 / t26 / t219;
  t224 = 0.28e1 * t25 * t221 + t159;
  tv2rho22 = t165 + t111 - 0.2e1 * t185 - t117 * t45 * t203 / 0.4e1 - 0.80013333333333333332e-1 * t172 - t126 * t208 + t44 * t45 * t210 / 0.2e1 + 0.16002666666666666667e0 * t190 + 0.2e1 * t59 * t147 * t215 - t59 * t62 * t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t227 = t55 * t89;
  t228 = 0.10001666666666666667e-1 * t227;
  t229 = t37 * t43;
  t230 = t89 * t51;
  t231 = t229 * t230;
  t232 = 0.150025e-1 * t231;
  t233 = t88 * t61;
  t234 = t233 * t71;
  t235 = t87 * t234;
  t236 = 0.30005e-1 * t235;
  t238 = 0.45e0 * t18 * t95;
  t239 = t22 * t51;
  t240 = t94 * t239;
  t243 = t55 * t11;
  t245 = 0.36006e-1 * t243 * t95;
  t246 = t146 * t93;
  t247 = t22 * t71;
  t248 = t246 * t247;
  t251 = t94 * t65;
  tv2rhosigma0 = -t228 + t232 - t236 - t238 - 0.225e0 * t126 * t240 + t245 + 0.9e0 * t92 * t248 + 0.6e0 * t92 * t251;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t254 = 0.20003333333333333333e-1 * t227;
  tv2rhosigma1 = -t254 + 0.30005e-1 * t231 - 0.6001e-1 * t235;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t258 = 0.45e0 * t18 * t100;
  t259 = t28 * t51;
  t260 = t99 * t259;
  t264 = 0.36006e-1 * t243 * t100;
  t265 = t146 * t98;
  t266 = t28 * t71;
  t267 = t265 * t266;
  tv2rhosigma2 = -t228 + t232 - t236 - t258 - 0.225e0 * t126 * t260 + t264 + 0.9e0 * t92 * t267;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t270 = t89 * t75;
  t271 = t229 * t270;
  t272 = 0.150025e-1 * t271;
  t273 = t233 * t84;
  t274 = t87 * t273;
  t275 = 0.30005e-1 * t274;
  t276 = t22 * t75;
  t277 = t94 * t276;
  t280 = t22 * t84;
  t281 = t246 * t280;
  tv2rhosigma3 = -t228 + t272 - t275 - t238 - 0.225e0 * t126 * t277 + t245 + 0.9e0 * t92 * t281;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t254 + 0.30005e-1 * t271 - 0.6001e-1 * t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t286 = t28 * t75;
  t287 = t99 * t286;
  t290 = t28 * t84;
  t291 = t265 * t290;
  t294 = t99 * t81;
  tv2rhosigma5 = -t228 + t272 - t275 - t258 - 0.225e0 * t126 * t287 + t264 + 0.9e0 * t92 * t291 + 0.6e0 * t92 * t294;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t298 = 0.1e1 / t11 / t10;
  t299 = t298 * t42;
  t300 = t87 * t299;
  t301 = 0.150025e-1 * t300;
  t302 = t87 * t88;
  t303 = t302 * t95;
  t304 = 0.270045e-1 * t303;
  t305 = 0.1e1 / sigma[0];
  t306 = t146 * t305;
  t307 = t20 * t20;
  t309 = 0.1e1 / t307 / t63;
  t310 = t306 * t309;
  t314 = 0.1e1 / t19 / sigma[0];
  t315 = t61 * t314;
  t316 = t315 * t22;
  tv2sigma20 = -t301 - t304 + 0.405e0 * t92 * t310 + 0.225e0 * t92 * t316;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t319 = 0.30005e-1 * t300;
  tv2sigma21 = -t319 - t304;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  t321 = t302 * t100;
  t323 = t59 * t147;
  t324 = t98 * t28;
  t325 = t93 * t22;
  t326 = t324 * t325;
  tv2sigma22 = -t301 - 0.1350225e-1 * t303 - 0.1350225e-1 * t321 + 0.405e0 * t323 * t326;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = -0.6001e-1 * t300;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  t330 = 0.270045e-1 * t321;
  tv2sigma24 = -t319 - t330;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t331 = 0.1e1 / sigma[2];
  t332 = t146 * t331;
  t333 = t26 * t26;
  t335 = 0.1e1 / t333 / t79;
  t336 = t332 * t335;
  t340 = 0.1e1 / t25 / sigma[2];
  t341 = t61 * t340;
  t342 = t341 * t28;
  tv2sigma25 = -t301 - t330 + 0.405e0 * t92 * t336 + 0.225e0 * t92 * t342;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t14, t17, t18, t19, t20, t22;
  double t25, t26, t28, t31, t33, t34, t35, t36;
  double t37, t41, t42, tzk0;

  double t43, t44, t45, t46, t47, t48, t49, t51;
  double t55, t56, t58, t59, t60, t61, t62, t63;
  double t65, t70, t71, tvrho0, t75, t79, t81, t84;
  double tvrho1, t87, t88, t89, t90, t91, t92, t93;
  double t94, t95, tvsigma0, tvsigma1, t98, t99, t100, tvsigma2;

  double t103, t104, t105, t106, t108, t109, t111, t113;
  double t116, t117, t118, t122, t124, t126, t127, t128;
  double t130, t132, t133, t134, t136, t137, t141, t143;
  double t146, t147, t148, t152, t154, t158, t159, t160;
  double tv2rho20, t164, t165, t167, t168, t172, t174, t175;
  double t178, t184, t185, t186, t190, t192, t193, t197;
  double t198, t199, tv2rho21, t203, t208, t210, t215, t219;
  double t221, t224, tv2rho22, t227, t228, t229, t230, t231;
  double t232, t233, t234, t235, t236, t238, t239, t240;
  double t243, t245, t246, t247, t248, t251, tv2rhosigma0, t254;
  double tv2rhosigma1, t258, t259, t260, t264, t265, t266, t267;
  double tv2rhosigma2, t270, t271, t272, t273, t274, t275, t276;
  double t277, t280, t281, tv2rhosigma3, tv2rhosigma4, t286, t287, t290;
  double t291, t294, tv2rhosigma5, t298, t299, t300, t301, t302;
  double t303, t304, t305, t306, t307, t309, t310, t314;
  double t315, t316, tv2sigma20, t319, tv2sigma21, t321, t323, t324;
  double t325, t326, tv2sigma22, tv2sigma23, t330, tv2sigma24, t331, t332;
  double t333, t335, t336, t340, t341, t342, tv2sigma25;

  double t346, t349, t351, t353, t354, t355, t359, t360;
  double t363, t366, t367, t369, t370, t373, t376, t377;
  double t378, t380, t381, t382, t383, t387, t388, t391;
  double t392, t393, t394, t396, t398, t400, t403, t404;
  double t406, t407, t409, t412, t414, t416, t419, t421;
  double t422, t423, t425, t427, t428, t433, t435, t437;
  double t441, t442, t443, t446, t447, t450, tv3rho30, t453;
  double t454, t457, t458, t460, t464, t466, t467, t468;
  double t472, t474, t476, t484, t486, t487, t488, t491;
  double t493, t496, t497, t499, t502, t503, t506, t509;
  double t512, t514, t516, t517, t518, t521, t524, t527;
  double t530, t531, t534, t535, t539, t540, t543, t545;
  double t546, t549, t551, t552, t555, t556, tv3rho31, t559;
  double t561, t566, t569, t572, t574, t575, t576, t578;
  double t579, t581, t582, t584, t585, t591, t593, t594;
  double t598, t601, t604, t605, t608, t611, t613, t615;
  double t618, t619, t622, t625, t626, t629, t632, t633;
  double t637, t638, t641, t642, t645, tv3rho32, t649, t653;
  double t656, t659, t662, t665, t669, t673, t683, t687;
  double t690, t692, t695, t698, tv3rho33, t699, t700, t701;
  double t702, t703, t704, t705, t706, t707, t708, t709;
  double t710, t711, t712, t714, t715, t716, t718, t720;
  double t722, t723, t724, t727, t729, t731, t733, t734;
  double t735, t738, t741, t742, t745, t746, t749, t750;
  double t753, t754, t755, t758, t759, t762, t763, t764;
  double t765, t766, t767, t768, t769, t770, t771, t772;
  double t773, t774, t775, tv3rho2sigma0, t776, tv3rho2sigma1, t785, t788;
  double t791, t792, t793, t796, t798, t800, t801, t804;
  double t805, t808, t811, t812, t813, tv3rho2sigma2, t817, t818;
  double t820, t821, t822, t823, t826, t828, t830, t831;
  double t834, t835, t838, t839, t840, t841, t842, t843;
  double t844, t846, t847, t848, t849, t850, t853, t854;
  double t857, t858, t861, t862, t865, t866, t867, t868;
  double t869, t870, t871, t872, t873, t874, t875, t877;
  double t878, t885, t886, t889, tv3rho2sigma3, t892, tv3rho2sigma4, t900;
  double t901, t904, t906, t908, t909, t912, t913, t917;
  double t919, t922, t923, t926, t929, t932, t935, t938;
  double t943, t946, tv3rho2sigma5, t947, t952, t953, t956, t957;
  double t960, t961, t964, t965, t968, t969, t972, t973;
  double t974, t975, t976, t977, t978, t979, t980, t981;
  double t982, t983, t984, t985, tv3rho2sigma6, tv3rho2sigma7, t997, t998;
  double t1001, t1002, t1005, t1008, t1009, t1012, t1013, t1016;
  double t1017, t1020, t1021, t1024, t1025, t1030, tv3rho2sigma8, t1031;
  double t1032, t1033, t1034, t1035, t1036, t1037, t1038, t1039;
  double t1040, t1041, t1042, t1043, t1044, t1045, t1046, t1047;
  double t1048, t1050, t1051, t1052, t1056, t1057, t1058, t1059;
  double t1063, t1064, t1068, t1069, t1073, t1074, t1075, t1078;
  double tv3rhosigma20, t1081, t1082, t1083, tv3rhosigma21, t1084, t1088, t1089;
  double t1090, t1092, t1095, t1096, t1099, t1101, t1102, t1105;
  double t1106, tv3rhosigma22, t1109, tv3rhosigma23, t1112, t1113, t1114, tv3rhosigma24;
  double t1116, t1117, t1118, t1122, t1123, t1124, t1125, t1129;
  double t1130, t1134, t1135, t1136, tv3rhosigma25, t1139, t1140, t1141;
  double t1142, t1143, t1144, t1145, t1146, t1147, t1148, t1149;
  double t1150, t1153, t1154, t1157, t1160, tv3rhosigma26, t1163, t1164;
  double tv3rhosigma27, t1167, t1169, t1171, t1173, t1176, t1179, t1180;
  double tv3rhosigma28, tv3rhosigma29, t1185, t1186, t1187, tv3rhosigma210, t1188, t1189;
  double t1192, t1193, t1197, t1198, t1201, t1204, t1207, tv3rhosigma211;
  double t1210, t1212, t1213, t1214, t1215, t1216, t1217, t1219;
  double t1221, t1223, t1224, t1225, t1228, t1229, t1230, t1231;
  double t1235, t1236, t1237, tv3sigma30, t1240, t1241, tv3sigma31, t1244;
  double t1247, t1249, t1251, t1252, t1253, t1256, t1257, tv3sigma32;
  double t1260, tv3sigma33, t1261, tv3sigma34, t1263, t1265, t1266, t1269;
  double t1271, t1272, tv3sigma35, tv3sigma36, t1275, tv3sigma37, tv3sigma38, t1281;
  double t1282, t1283, t1286, t1287, t1288, t1289, t1293, t1294;
  double t1295, tv3sigma39;


  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = sqrt(t7);
  t10 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t11 = sqrt(t10);
  t12 = POW_1_3(t3);
  t14 = 0.1e1 / t12 / t3;
  t17 = -0.7486e0 + 0.6001e-1 * t11 * t14;
  t18 = t8 * t17;
  t19 = sqrt(sigma[0]);
  t20 = POW_1_3(rho[0]);
  t22 = 0.1e1 / t20 / rho[0];
  t25 = sqrt(sigma[2]);
  t26 = POW_1_3(rho[1]);
  t28 = 0.1e1 / t26 / rho[1];
  t31 = M_CBRT3;
  t33 = POW_1_3(0.1e1 / M_PI);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t37 = 0.1e1 / t12;
  t41 = 0.360073e1 + 0.9e0 * t19 * t22 + 0.9e0 * t25 * t28 + t34 * t36 * t37 / 0.4e1;
  t42 = 0.1e1 / t41;
  tzk0 = t18 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = 0.1e1 / t8;
  t44 = t3 * t43;
  t45 = t17 * t42;
  t46 = t1 * t5;
  t47 = t4 * t3;
  t48 = 0.1e1 / t47;
  t49 = t2 * t48;
  t51 = -0.2e1 * t46 + 0.2e1 * t49;
  t55 = t14 * t8;
  t56 = t11 * t42;
  t58 = 0.80013333333333333333e-1 * t55 * t56;
  t59 = t3 * t8;
  t60 = t41 * t41;
  t61 = 0.1e1 / t60;
  t62 = t17 * t61;
  t63 = rho[0] * rho[0];
  t65 = 0.1e1 / t20 / t63;
  t70 = t34 * t36 * t14 / 0.12e2;
  t71 = -0.12e1 * t19 * t65 - t70;
  tvrho0 = tzk0 + t44 * t45 * t51 / 0.2e1 - t58 - t59 * t62 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t75 = 0.2e1 * t46 + 0.2e1 * t49;
  t79 = rho[1] * rho[1];
  t81 = 0.1e1 / t26 / t79;
  t84 = -0.12e1 * t25 * t81 - t70;
  tvrho1 = tzk0 + t44 * t45 * t75 / 0.2e1 - t58 - t59 * t62 * t84;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t87 = t37 * t8;
  t88 = 0.1e1 / t11;
  t89 = t88 * t42;
  t90 = t87 * t89;
  t91 = 0.30005e-1 * t90;
  t92 = t59 * t17;
  t93 = 0.1e1 / t19;
  t94 = t61 * t93;
  t95 = t94 * t22;
  tvsigma0 = t91 - 0.45e0 * t92 * t95;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.6001e-1 * t90;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t98 = 0.1e1 / t25;
  t99 = t61 * t98;
  t100 = t99 * t28;
  tvsigma2 = t91 - 0.45e0 * t92 * t100;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t103 = t43 * t17;
  t104 = t42 * t51;
  t105 = t103 * t104;
  t106 = t8 * t11;
  t108 = 0.1e1 / t12 / t4;
  t109 = t108 * t42;
  t111 = 0.26671111111111111107e-1 * t106 * t109;
  t113 = t18 * t61 * t71;
  t116 = 0.1e1 / t8 / t7;
  t117 = t3 * t116;
  t118 = t51 * t51;
  t122 = t14 * t43;
  t124 = t122 * t56 * t51;
  t126 = t44 * t17;
  t127 = t61 * t51;
  t128 = t127 * t71;
  t130 = 0.2e1 * t5;
  t132 = 0.8e1 * t1 * t48;
  t133 = t4 * t4;
  t134 = 0.1e1 / t133;
  t136 = 0.6e1 * t2 * t134;
  t137 = -t130 + t132 - t136;
  t141 = t11 * t61;
  t143 = t55 * t141 * t71;
  t146 = 0.1e1 / t60 / t41;
  t147 = t17 * t146;
  t148 = t71 * t71;
  t152 = t63 * rho[0];
  t154 = 0.1e1 / t20 / t152;
  t158 = t34 * t36 * t108;
  t159 = t158 / 0.9e1;
  t160 = 0.28e1 * t19 * t154 + t159;
  tv2rho20 = t105 + t111 - 0.2e1 * t113 - t117 * t45 * t118 / 0.4e1 - 0.80013333333333333332e-1 * t124 - t126 * t128 + t44 * t45 * t137 / 0.2e1 + 0.16002666666666666667e0 * t143 + 0.2e1 * t59 * t147 * t148 - t59 * t62 * t160;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t164 = t42 * t75;
  t165 = t103 * t164;
  t167 = t117 * t17;
  t168 = t164 * t51;
  t172 = t122 * t56 * t75;
  t174 = t61 * t75;
  t175 = t174 * t71;
  t178 = t130 - t136;
  t184 = t61 * t84;
  t185 = t18 * t184;
  t186 = t184 * t51;
  t190 = t55 * t141 * t84;
  t192 = t146 * t84;
  t193 = t192 * t71;
  t197 = t61 * t31;
  t198 = t33 * t36;
  t199 = t197 * t198;
  tv2rho21 = t105 / 0.2e1 + t111 - t113 + t165 / 0.2e1 - t167 * t168 / 0.4e1 - 0.40006666666666666666e-1 * t172 - t126 * t175 / 0.2e1 + t44 * t45 * t178 / 0.2e1 - 0.40006666666666666666e-1 * t124 + 0.80013333333333333333e-1 * t143 - t185 - t126 * t186 / 0.2e1 + 0.80013333333333333333e-1 * t190 + 0.2e1 * t92 * t193 - t55 * t17 * t199 / 0.9e1;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t203 = t75 * t75;
  t208 = t174 * t84;
  t210 = -t130 - t132 - t136;
  t215 = t84 * t84;
  t219 = t79 * rho[1];
  t221 = 0.1e1 / t26 / t219;
  t224 = 0.28e1 * t25 * t221 + t159;
  tv2rho22 = t165 + t111 - 0.2e1 * t185 - t117 * t45 * t203 / 0.4e1 - 0.80013333333333333332e-1 * t172 - t126 * t208 + t44 * t45 * t210 / 0.2e1 + 0.16002666666666666667e0 * t190 + 0.2e1 * t59 * t147 * t215 - t59 * t62 * t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t227 = t55 * t89;
  t228 = 0.10001666666666666667e-1 * t227;
  t229 = t37 * t43;
  t230 = t89 * t51;
  t231 = t229 * t230;
  t232 = 0.150025e-1 * t231;
  t233 = t88 * t61;
  t234 = t233 * t71;
  t235 = t87 * t234;
  t236 = 0.30005e-1 * t235;
  t238 = 0.45e0 * t18 * t95;
  t239 = t22 * t51;
  t240 = t94 * t239;
  t243 = t55 * t11;
  t245 = 0.36006e-1 * t243 * t95;
  t246 = t146 * t93;
  t247 = t22 * t71;
  t248 = t246 * t247;
  t251 = t94 * t65;
  tv2rhosigma0 = -t228 + t232 - t236 - t238 - 0.225e0 * t126 * t240 + t245 + 0.9e0 * t92 * t248 + 0.6e0 * t92 * t251;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t254 = 0.20003333333333333333e-1 * t227;
  tv2rhosigma1 = -t254 + 0.30005e-1 * t231 - 0.6001e-1 * t235;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t258 = 0.45e0 * t18 * t100;
  t259 = t28 * t51;
  t260 = t99 * t259;
  t264 = 0.36006e-1 * t243 * t100;
  t265 = t146 * t98;
  t266 = t28 * t71;
  t267 = t265 * t266;
  tv2rhosigma2 = -t228 + t232 - t236 - t258 - 0.225e0 * t126 * t260 + t264 + 0.9e0 * t92 * t267;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t270 = t89 * t75;
  t271 = t229 * t270;
  t272 = 0.150025e-1 * t271;
  t273 = t233 * t84;
  t274 = t87 * t273;
  t275 = 0.30005e-1 * t274;
  t276 = t22 * t75;
  t277 = t94 * t276;
  t280 = t22 * t84;
  t281 = t246 * t280;
  tv2rhosigma3 = -t228 + t272 - t275 - t238 - 0.225e0 * t126 * t277 + t245 + 0.9e0 * t92 * t281;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t254 + 0.30005e-1 * t271 - 0.6001e-1 * t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t286 = t28 * t75;
  t287 = t99 * t286;
  t290 = t28 * t84;
  t291 = t265 * t290;
  t294 = t99 * t81;
  tv2rhosigma5 = -t228 + t272 - t275 - t258 - 0.225e0 * t126 * t287 + t264 + 0.9e0 * t92 * t291 + 0.6e0 * t92 * t294;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t298 = 0.1e1 / t11 / t10;
  t299 = t298 * t42;
  t300 = t87 * t299;
  t301 = 0.150025e-1 * t300;
  t302 = t87 * t88;
  t303 = t302 * t95;
  t304 = 0.270045e-1 * t303;
  t305 = 0.1e1 / sigma[0];
  t306 = t146 * t305;
  t307 = t20 * t20;
  t309 = 0.1e1 / t307 / t63;
  t310 = t306 * t309;
  t314 = 0.1e1 / t19 / sigma[0];
  t315 = t61 * t314;
  t316 = t315 * t22;
  tv2sigma20 = -t301 - t304 + 0.405e0 * t92 * t310 + 0.225e0 * t92 * t316;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t319 = 0.30005e-1 * t300;
  tv2sigma21 = -t319 - t304;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  t321 = t302 * t100;
  t323 = t59 * t147;
  t324 = t98 * t28;
  t325 = t93 * t22;
  t326 = t324 * t325;
  tv2sigma22 = -t301 - 0.1350225e-1 * t303 - 0.1350225e-1 * t321 + 0.405e0 * t323 * t326;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = -0.6001e-1 * t300;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  t330 = 0.270045e-1 * t321;
  tv2sigma24 = -t319 - t330;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t331 = 0.1e1 / sigma[2];
  t332 = t146 * t331;
  t333 = t26 * t26;
  t335 = 0.1e1 / t333 / t79;
  t336 = t332 * t335;
  t340 = 0.1e1 / t25 / sigma[2];
  t341 = t61 * t340;
  t342 = t341 * t28;
  tv2sigma25 = -t301 - t330 + 0.405e0 * t92 * t336 + 0.225e0 * t92 * t342;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t346 = t103 * t42 * t137;
  t349 = t18 * t61 * t160;
  t351 = t7 * t7;
  t353 = 0.1e1 / t8 / t351;
  t354 = t3 * t353;
  t355 = t118 * t51;
  t359 = t61 * t118;
  t360 = t359 * t71;
  t363 = t104 * t137;
  t366 = t122 * t11;
  t367 = t366 * t128;
  t369 = t61 * t137;
  t370 = t369 * t71;
  t373 = t127 * t160;
  t376 = t11 * t146;
  t377 = t376 * t148;
  t378 = t55 * t377;
  t380 = t60 * t60;
  t381 = 0.1e1 / t380;
  t382 = t17 * t381;
  t383 = t148 * t71;
  t387 = t146 * t71;
  t388 = t387 * t160;
  t391 = 0.3e1 / 0.2e1 * t346 - 0.3e1 * t349 + 0.3e1 / 0.8e1 * t354 * t45 * t355 + 0.3e1 / 0.4e1 * t167 * t360 - 0.3e1 / 0.4e1 * t167 * t363 + 0.24004e0 * t367 - 0.3e1 / 0.2e1 * t126 * t370 - 0.3e1 / 0.2e1 * t126 * t373 - 0.48008000000000000001e0 * t378 - 0.6e1 * t59 * t382 * t383 + 0.6e1 * t92 * t388;
  t392 = t116 * t17;
  t393 = t42 * t118;
  t394 = t392 * t393;
  t396 = t103 * t128;
  t398 = t43 * t11;
  t400 = t398 * t109 * t51;
  t403 = 0.1e1 / t12 / t47;
  t404 = t403 * t42;
  t406 = 0.62232592592592592583e-1 * t106 * t404;
  t407 = t108 * t61;
  t409 = t106 * t407 * t71;
  t412 = t18 * t146 * t148;
  t414 = t14 * t116;
  t416 = t414 * t56 * t118;
  t419 = t122 * t56 * t137;
  t421 = 0.12e2 * t48;
  t422 = t1 * t134;
  t423 = 0.36e2 * t422;
  t425 = 0.1e1 / t133 / t3;
  t427 = 0.24e2 * t2 * t425;
  t428 = t421 - t423 + t427;
  t433 = t55 * t141 * t160;
  t435 = t63 * t63;
  t437 = 0.1e1 / t20 / t435;
  t441 = t34 * t36 * t403;
  t442 = 0.7e1 / 0.27e2 * t441;
  t443 = -0.93333333333333333333e1 * t19 * t437 - t442;
  t446 = t146 * t51;
  t447 = t446 * t148;
  t450 = -0.3e1 / 0.4e1 * t394 - 0.3e1 * t396 + 0.40006666666666666661e-1 * t400 - t406 - 0.8001333333333333333e-1 * t409 + 0.6e1 * t412 + 0.60009999999999999999e-1 * t416 - 0.12002e0 * t419 + t44 * t45 * t428 / 0.2e1 + 0.24004e0 * t433 - t59 * t62 * t443 + 0.3e1 * t126 * t447;
  tv3rho30 = t391 + t450;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t453 = t42 * t178;
  t454 = t103 * t453;
  t457 = t392 * t168 / 0.2e1;
  t458 = t103 * t175;
  t460 = t398 * t109 * t75;
  t464 = 0.80013333333333333332e-1 * t122 * t56 * t178;
  t466 = 0.4e1 * t48;
  t467 = 0.12e2 * t422;
  t468 = -t466 - t467 + t427;
  t472 = t103 * t186;
  t474 = 0.4e1 * t18 * t193;
  t476 = t106 * t407 * t84;
  t484 = t44 * t45 * t468 / 0.2e1 - t472 + t474 - 0.26671111111111111107e-1 * t476 - 0.16002666666666666667e0 * t378 - t396 + 0.26671111111111111109e-1 * t400 - 0.53342222222222222214e-1 * t409 + 0.20003333333333333333e-1 * t416 - 0.40006666666666666666e-1 * t419 + 0.80013333333333333333e-1 * t433;
  t486 = t122 * t62;
  t487 = t36 * t51;
  t488 = t34 * t487;
  t491 = t55 * t147;
  t493 = t34 * t36 * t71;
  t496 = t146 * t75;
  t497 = t496 * t148;
  t499 = t184 * t118;
  t502 = t381 * t84;
  t503 = t502 * t148;
  t506 = t453 * t51;
  t509 = t164 * t137;
  t512 = t414 * t11;
  t514 = 0.40006666666666666666e-1 * t512 * t168;
  t516 = 0.80013333333333333332e-1 * t366 * t175;
  t517 = t61 * t178;
  t518 = t517 * t71;
  t521 = t174 * t160;
  t524 = t184 * t137;
  t527 = t366 * t186;
  t530 = 0.32005333333333333334e0 * t243 * t193;
  t531 = t192 * t160;
  t534 = t354 * t17;
  t535 = t164 * t118;
  t539 = t51 * t71;
  t540 = t174 * t539;
  t543 = t18 * t61;
  t545 = t543 * t158 / 0.27e2;
  t546 = t192 * t539;
  t549 = t12 * t12;
  t551 = 0.1e1 / t549 / t47;
  t552 = t551 * t8;
  t555 = 0.17780740740740740741e-1 * t552 * t11 * t199;
  t556 = -t126 * t521 / 0.2e1 - t126 * t524 / 0.2e1 + 0.80013333333333333332e-1 * t527 - t530 + 0.2e1 * t92 * t531 + 0.3e1 / 0.8e1 * t534 * t535 + 0.80013333333333333332e-1 * t367 + t167 * t540 / 0.2e1 + t545 + 0.2e1 * t126 * t546 + t555;
  tv3rho31 = -t394 / 0.4e1 - t406 + 0.2e1 * t412 + t454 + t346 / 0.2e1 - t349 - t457 - t458 + 0.13335555555555555555e-1 * t460 - t464 + t484 - t486 * t488 / 0.9e1 + 0.4e1 / 0.9e1 * t491 * t493 + t126 * t497 + t167 * t499 / 0.4e1 - 0.6e1 * t92 * t503 - t167 * t506 / 0.2e1 - t167 * t509 / 0.4e1 + t514 + t516 - t126 * t518 + t556;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t559 = t414 * t56 * t203;
  t561 = -t466 + t467 + t427;
  t566 = t122 * t56 * t210;
  t569 = t55 * t376 * t215;
  t572 = t55 * t141 * t224;
  t574 = t103 * t208;
  t575 = t42 * t203;
  t576 = t392 * t575;
  t578 = t42 * t210;
  t579 = t103 * t578;
  t581 = t146 * t215;
  t582 = t18 * t581;
  t584 = t61 * t224;
  t585 = t18 * t584;
  t591 = -t406 + t454 - t457 - t458 + 0.26671111111111111107e-1 * t460 - t464 - t472 + t474 - 0.5334222222222222222e-1 * t476 + 0.13335555555555555554e-1 * t400 - 0.26671111111111111107e-1 * t409;
  t593 = t75 * t31;
  t594 = t593 * t198;
  t598 = t84 * t31 * t198;
  t601 = t575 * t51;
  t604 = t61 * t203;
  t605 = t604 * t71;
  t608 = t164 * t178;
  t611 = t517 * t84;
  t613 = t366 * t208;
  t615 = t578 * t51;
  t618 = t61 * t210;
  t619 = t618 * t71;
  t622 = t581 * t51;
  t625 = t381 * t215;
  t626 = t625 * t71;
  t629 = t584 * t51;
  t632 = t146 * t224;
  t633 = t632 * t71;
  t637 = t84 * t51;
  t638 = t174 * t637;
  t641 = t84 * t71;
  t642 = t496 * t641;
  t645 = -0.6e1 * t92 * t626 - t126 * t629 / 0.2e1 + 0.2e1 * t92 * t633 + t514 + t516 + 0.80013333333333333335e-1 * t527 - t530 + t167 * t638 / 0.2e1 + 0.2e1 * t126 * t642 + t545 + t555;
  tv3rho32 = 0.20003333333333333333e-1 * t559 + t44 * t45 * t561 / 0.2e1 - 0.40006666666666666666e-1 * t566 - 0.16002666666666666667e0 * t569 + 0.80013333333333333333e-1 * t572 - t574 - t576 / 0.4e1 + t579 / 0.2e1 + 0.2e1 * t582 - t585 + t591 - t486 * t594 / 0.9e1 + 0.4e1 / 0.9e1 * t491 * t598 + 0.3e1 / 0.8e1 * t534 * t601 + t167 * t605 / 0.4e1 - t167 * t608 / 0.2e1 - t126 * t611 + 0.80013333333333333333e-1 * t613 - t167 * t615 / 0.4e1 - t126 * t619 / 0.2e1 + t126 * t622 + t645;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t649 = t203 * t75;
  t653 = t604 * t84;
  t656 = t164 * t210;
  t659 = t618 * t84;
  t662 = t174 * t224;
  t665 = t215 * t84;
  t669 = t192 * t224;
  t673 = -0.3e1 * t574 + 0.24004e0 * t613 + 0.3e1 / 0.8e1 * t354 * t45 * t649 + 0.3e1 / 0.4e1 * t167 * t653 - 0.3e1 / 0.4e1 * t167 * t656 - 0.3e1 / 0.2e1 * t126 * t659 - 0.3e1 / 0.2e1 * t126 * t662 - 0.6e1 * t59 * t382 * t665 + 0.6e1 * t92 * t669 - t406 + 0.40006666666666666661e-1 * t460;
  t683 = t421 + t423 + t427;
  t687 = t496 * t215;
  t690 = t79 * t79;
  t692 = 0.1e1 / t26 / t690;
  t695 = -0.93333333333333333333e1 * t25 * t692 - t442;
  t698 = -0.8001333333333333333e-1 * t476 - 0.3e1 / 0.4e1 * t576 + 0.60009999999999999999e-1 * t559 + 0.3e1 / 0.2e1 * t579 - 0.12002e0 * t566 + 0.6e1 * t582 - 0.48008000000000000001e0 * t569 - 0.3e1 * t585 + 0.24004e0 * t572 + t44 * t45 * t683 / 0.2e1 + 0.3e1 * t126 * t687 - t59 * t62 * t695;
  tv3rho33 = t673 + t698;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t699 = t37 * t116;
  t700 = t89 * t118;
  t701 = t699 * t700;
  t702 = 0.750125e-2 * t701;
  t703 = t229 * t88;
  t704 = t703 * t128;
  t705 = 0.30005e-1 * t704;
  t706 = t88 * t146;
  t707 = t706 * t148;
  t708 = t87 * t707;
  t709 = 0.6001e-1 * t708;
  t710 = t103 * t61;
  t711 = t325 * t51;
  t712 = t710 * t711;
  t714 = t18 * t146;
  t715 = t325 * t71;
  t716 = t714 * t715;
  t718 = t18 * t251;
  t720 = t106 * t108;
  t722 = 0.12002e-1 * t720 * t95;
  t723 = t22 * t137;
  t724 = t94 * t723;
  t727 = t366 * t240;
  t729 = t243 * t248;
  t731 = t243 * t251;
  t733 = -t702 - t705 + t709 - 0.45e0 * t712 + 0.18e1 * t716 + 0.12e1 * t718 - t722 - 0.225e0 * t126 * t724 + 0.36006e-1 * t727 - 0.144024e0 * t729 - 0.96016e-1 * t731;
  t734 = t22 * t160;
  t735 = t246 * t734;
  t738 = t94 * t154;
  t741 = t22 * t118;
  t742 = t94 * t741;
  t745 = t44 * t147;
  t746 = t325 * t539;
  t749 = t65 * t51;
  t750 = t94 * t749;
  t753 = t381 * t93;
  t754 = t22 * t148;
  t755 = t753 * t754;
  t758 = t65 * t71;
  t759 = t246 * t758;
  t762 = t108 * t8;
  t763 = t762 * t89;
  t764 = 0.13335555555555555556e-1 * t763;
  t765 = t122 * t230;
  t766 = 0.10001666666666666667e-1 * t765;
  t767 = t55 * t234;
  t768 = 0.20003333333333333334e-1 * t767;
  t769 = t89 * t137;
  t770 = t229 * t769;
  t771 = 0.150025e-1 * t770;
  t772 = t233 * t160;
  t773 = t87 * t772;
  t774 = 0.30005e-1 * t773;
  t775 = 0.9e0 * t92 * t735 - 0.14e1 * t92 * t738 + 0.1125e0 * t167 * t742 + 0.9e0 * t745 * t746 + 0.6e0 * t126 * t750 - 0.27e1 * t92 * t755 - 0.24e1 * t92 * t759 + t764 - t766 + t768 + t771 - t774;
  tv3rho2sigma0 = t733 + t775;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t776 = 0.26671111111111111111e-1 * t763;
  tv3rho2sigma1 = t776 - 0.20003333333333333333e-1 * t765 + 0.40006666666666666666e-1 * t767 - 0.150025e-1 * t701 - 0.6001e-1 * t704 + 0.30005e-1 * t770 + 0.12002e0 * t708 - 0.6001e-1 * t773;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t785 = t710 * t324 * t51;
  t788 = t714 * t324 * t71;
  t791 = 0.12002e-1 * t720 * t100;
  t792 = t28 * t137;
  t793 = t99 * t792;
  t796 = t366 * t260;
  t798 = t243 * t267;
  t800 = t28 * t160;
  t801 = t265 * t800;
  t804 = t28 * t118;
  t805 = t99 * t804;
  t808 = t324 * t539;
  t811 = t381 * t98;
  t812 = t28 * t148;
  t813 = t811 * t812;
  tv3rho2sigma2 = -t702 - t705 + t709 - 0.45e0 * t785 + 0.18e1 * t788 - t791 - 0.225e0 * t126 * t793 + 0.36006e-1 * t796 - 0.144024e0 * t798 + 0.9e0 * t92 * t801 + 0.1125e0 * t167 * t805 + 0.9e0 * t745 * t808 - 0.27e1 * t92 * t813 + t764 - t766 + t768 + t771 - t774;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t817 = 0.1e1 / t549 / t4;
  t818 = t817 * t8;
  t820 = t818 * t88 * t199;
  t821 = 0.33338888888888888889e-2 * t820;
  t822 = t22 * t178;
  t823 = t94 * t822;
  t826 = t366 * t277;
  t828 = t243 * t281;
  t830 = t65 * t75;
  t831 = t94 * t830;
  t834 = t65 * t84;
  t835 = t246 * t834;
  t838 = t89 * t178;
  t839 = t229 * t838;
  t840 = 0.150025e-1 * t839;
  t841 = t122 * t270;
  t842 = 0.50008333333333333333e-2 * t841;
  t843 = t55 * t273;
  t844 = 0.10001666666666666667e-1 * t843;
  t846 = 0.50008333333333333335e-2 * t765;
  t847 = 0.10001666666666666667e-1 * t767;
  t848 = t117 * t62;
  t849 = t75 * t51;
  t850 = t325 * t849;
  t853 = t75 * t71;
  t854 = t325 * t853;
  t857 = -t821 - 0.225e0 * t126 * t823 + 0.18003e-1 * t826 - 0.72012e-1 * t828 + 0.3e0 * t126 * t831 - 0.12e1 * t92 * t835 + t840 - t842 + t844 + 0.6e0 * t718 - t846 + t847 + t764 + 0.1125e0 * t848 * t850 + 0.45e0 * t745 * t854;
  t858 = t325 * t637;
  t861 = t59 * t382;
  t862 = t325 * t641;
  t865 = t699 * t88;
  t866 = t865 * t168;
  t867 = 0.750125e-2 * t866;
  t868 = t703 * t175;
  t869 = 0.150025e-1 * t868;
  t870 = t703 * t186;
  t871 = 0.150025e-1 * t870;
  t872 = t302 * t193;
  t873 = 0.6001e-1 * t872;
  t874 = t325 * t75;
  t875 = t710 * t874;
  t877 = t325 * t84;
  t878 = t714 * t877;
  t885 = t34 * t36;
  t886 = t325 * t885;
  t889 = 0.45e0 * t745 * t858 - 0.27e1 * t861 * t862 - t867 - t869 - t871 + t873 - 0.225e0 * t875 + 0.9e0 * t878 - 0.225e0 * t712 + 0.9e0 * t716 - t722 - 0.48008e-1 * t731 + 0.18003e-1 * t727 - 0.72012e-1 * t729 + 0.1e0 * t491 * t886;
  tv3rho2sigma3 = t857 + t889;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t892 = 0.10001666666666666667e-1 * t841;
  tv3rho2sigma4 = t776 - 0.10001666666666666666e-1 * t765 + 0.20003333333333333333e-1 * t767 - t892 - 0.150025e-1 * t866 - 0.30005e-1 * t868 + 0.30005e-1 * t839 + 0.20003333333333333333e-1 * t843 - 0.30005e-1 * t870 + 0.12002e0 * t872 - 0.66677777777777777778e-2 * t820;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t900 = t28 * t178;
  t901 = t99 * t900;
  t904 = t366 * t287;
  t906 = t243 * t291;
  t908 = t81 * t51;
  t909 = t99 * t908;
  t912 = t81 * t71;
  t913 = t265 * t912;
  t917 = t18 * t294;
  t919 = t324 * t849;
  t922 = -0.225e0 * t126 * t901 + 0.18003e-1 * t904 - 0.72012e-1 * t906 + 0.3e0 * t126 * t909 - 0.12e1 * t92 * t913 - 0.72012e-1 * t798 - t821 + 0.6e0 * t917 + t840 - t842 + t844 - t846 + t847 + t764 + 0.1125e0 * t848 * t919;
  t923 = t324 * t853;
  t926 = t324 * t637;
  t929 = t324 * t641;
  t932 = t243 * t294;
  t935 = t710 * t324 * t75;
  t938 = t714 * t324 * t84;
  t943 = t324 * t885;
  t946 = 0.45e0 * t745 * t923 + 0.45e0 * t745 * t926 - 0.27e1 * t861 * t929 - 0.48008e-1 * t932 - t867 - t869 - t871 + t873 - 0.225e0 * t935 + 0.9e0 * t938 - 0.225e0 * t785 + 0.9e0 * t788 - t791 + 0.18003e-1 * t796 + 0.1e0 * t491 * t943;
  tv3rho2sigma5 = t922 + t946;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t947 = 0.20003333333333333334e-1 * t843;
  t952 = t22 * t210;
  t953 = t94 * t952;
  t956 = t22 * t224;
  t957 = t246 * t956;
  t960 = t22 * t203;
  t961 = t94 * t960;
  t964 = t75 * t84;
  t965 = t325 * t964;
  t968 = t22 * t215;
  t969 = t753 * t968;
  t972 = t89 * t210;
  t973 = t229 * t972;
  t974 = 0.150025e-1 * t973;
  t975 = t233 * t224;
  t976 = t87 * t975;
  t977 = 0.30005e-1 * t976;
  t978 = t89 * t203;
  t979 = t699 * t978;
  t980 = 0.750125e-2 * t979;
  t981 = t703 * t208;
  t982 = 0.30005e-1 * t981;
  t983 = t706 * t215;
  t984 = t87 * t983;
  t985 = 0.6001e-1 * t984;
  tv3rho2sigma6 = -t722 - t892 + t947 - 0.45e0 * t875 + 0.36006e-1 * t826 + 0.18e1 * t878 - 0.144024e0 * t828 - 0.225e0 * t126 * t953 + 0.9e0 * t92 * t957 + 0.1125e0 * t167 * t961 + 0.9e0 * t745 * t965 - 0.27e1 * t92 * t969 + t764 + t974 - t977 - t980 - t982 + t985;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = t776 - 0.20003333333333333333e-1 * t841 + 0.40006666666666666666e-1 * t843 - 0.150025e-1 * t979 - 0.6001e-1 * t981 + 0.30005e-1 * t973 + 0.12002e0 * t984 - 0.6001e-1 * t976;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t997 = t28 * t210;
  t998 = t99 * t997;
  t1001 = t28 * t224;
  t1002 = t265 * t1001;
  t1005 = t99 * t221;
  t1008 = t28 * t203;
  t1009 = t99 * t1008;
  t1012 = -t791 - t892 + t947 - 0.45e0 * t935 + 0.36006e-1 * t904 + 0.18e1 * t938 - 0.144024e0 * t906 - 0.225e0 * t126 * t998 + 0.9e0 * t92 * t1002 - 0.14e1 * t92 * t1005 + 0.1125e0 * t167 * t1009;
  t1013 = t324 * t964;
  t1016 = t81 * t75;
  t1017 = t99 * t1016;
  t1020 = t28 * t215;
  t1021 = t811 * t1020;
  t1024 = t81 * t84;
  t1025 = t265 * t1024;
  t1030 = 0.9e0 * t745 * t1013 + 0.6e0 * t126 * t1017 - 0.27e1 * t92 * t1021 - 0.24e1 * t92 * t1025 + t764 + t974 - t977 + 0.12e1 * t917 - 0.96016e-1 * t932 - t980 - t982 + t985;
  tv3rho2sigma8 = t1012 + t1030;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1031 = t55 * t299;
  t1032 = 0.50008333333333333333e-2 * t1031;
  t1033 = t299 * t51;
  t1034 = t229 * t1033;
  t1035 = 0.750125e-2 * t1034;
  t1036 = t298 * t61;
  t1037 = t1036 * t71;
  t1038 = t87 * t1037;
  t1039 = 0.150025e-1 * t1038;
  t1040 = t55 * t88;
  t1041 = t1040 * t95;
  t1042 = 0.90015e-2 * t1041;
  t1043 = t703 * t240;
  t1044 = 0.1350225e-1 * t1043;
  t1045 = t302 * t248;
  t1046 = 0.54009e-1 * t1045;
  t1047 = t302 * t251;
  t1048 = 0.36006e-1 * t1047;
  t1050 = 0.405e0 * t18 * t310;
  t1051 = t309 * t51;
  t1052 = t306 * t1051;
  t1056 = 0.324054e-1 * t243 * t310;
  t1057 = t381 * t305;
  t1058 = t309 * t71;
  t1059 = t1057 * t1058;
  t1063 = 0.1e1 / t307 / t152;
  t1064 = t306 * t1063;
  t1068 = 0.225e0 * t18 * t316;
  t1069 = t315 * t239;
  t1073 = 0.18003e-1 * t243 * t316;
  t1074 = t146 * t314;
  t1075 = t1074 * t247;
  t1078 = t315 * t65;
  tv3rhosigma20 = t1032 - t1035 + t1039 + t1042 - t1044 + t1046 + t1048 + t1050 + 0.2025e0 * t126 * t1052 - t1056 - 0.1215e1 * t92 * t1059 - 0.108e1 * t92 * t1064 + t1068 + 0.1125e0 * t126 * t1069 - t1073 - 0.45e0 * t92 * t1075 - 0.3e0 * t92 * t1078;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t1081 = 0.10001666666666666667e-1 * t1031;
  t1082 = 0.150025e-1 * t1034;
  t1083 = 0.30005e-1 * t1038;
  tv3rhosigma21 = t1081 - t1082 + t1083 + t1042 - t1044 + t1046 + t1048;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  t1084 = 0.450075e-2 * t1041;
  t1088 = t1040 * t100;
  t1089 = 0.450075e-2 * t1088;
  t1090 = t703 * t260;
  t1092 = t302 * t267;
  t1095 = 0.405e0 * t714 * t326;
  t1096 = t324 * t711;
  t1099 = t55 * t376;
  t1101 = 0.324054e-1 * t1099 * t326;
  t1102 = t324 * t715;
  t1105 = t93 * t65;
  t1106 = t324 * t1105;
  tv3rhosigma22 = t1032 - t1035 + t1039 + t1084 - 0.6751125e-2 * t1043 + 0.270045e-1 * t1045 + 0.18003e-1 * t1047 + t1089 - 0.6751125e-2 * t1090 + 0.270045e-1 * t1092 + t1095 + 0.2025e0 * t745 * t1096 - t1101 - 0.1215e1 * t861 * t1102 - 0.54e0 * t323 * t1106;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t1109 = 0.20003333333333333333e-1 * t1031;
  tv3rhosigma23 = t1109 - 0.30005e-1 * t1034 + 0.6001e-1 * t1038;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  t1112 = 0.90015e-2 * t1088;
  t1113 = 0.1350225e-1 * t1090;
  t1114 = 0.54009e-1 * t1092;
  tv3rhosigma24 = t1081 - t1082 + t1083 + t1112 - t1113 + t1114;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1116 = 0.405e0 * t18 * t336;
  t1117 = t335 * t51;
  t1118 = t332 * t1117;
  t1122 = 0.324054e-1 * t243 * t336;
  t1123 = t381 * t331;
  t1124 = t335 * t71;
  t1125 = t1123 * t1124;
  t1129 = 0.225e0 * t18 * t342;
  t1130 = t341 * t259;
  t1134 = 0.18003e-1 * t243 * t342;
  t1135 = t146 * t340;
  t1136 = t1135 * t266;
  tv3rhosigma25 = t1032 - t1035 + t1039 + t1112 - t1113 + t1114 + t1116 + 0.2025e0 * t126 * t1118 - t1122 - 0.1215e1 * t92 * t1125 + t1129 + 0.1125e0 * t126 * t1130 - t1134 - 0.45e0 * t92 * t1136;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1139 = t299 * t75;
  t1140 = t229 * t1139;
  t1141 = 0.750125e-2 * t1140;
  t1142 = t1036 * t84;
  t1143 = t87 * t1142;
  t1144 = 0.150025e-1 * t1143;
  t1145 = t703 * t277;
  t1146 = 0.1350225e-1 * t1145;
  t1147 = t302 * t281;
  t1148 = 0.54009e-1 * t1147;
  t1149 = t309 * t75;
  t1150 = t306 * t1149;
  t1153 = t309 * t84;
  t1154 = t1057 * t1153;
  t1157 = t315 * t276;
  t1160 = t1074 * t280;
  tv3rhosigma26 = t1032 - t1141 + t1144 + t1042 - t1146 + t1148 + t1050 + 0.2025e0 * t126 * t1150 - t1056 - 0.1215e1 * t92 * t1154 + t1068 + 0.1125e0 * t126 * t1157 - t1073 - 0.45e0 * t92 * t1160;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  t1163 = 0.150025e-1 * t1140;
  t1164 = 0.30005e-1 * t1143;
  tv3rhosigma27 = t1081 - t1163 + t1164 + t1042 - t1146 + t1148;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  t1167 = t703 * t287;
  t1169 = t302 * t291;
  t1171 = t302 * t294;
  t1173 = t324 * t874;
  t1176 = t324 * t877;
  t1179 = t98 * t81;
  t1180 = t1179 * t325;
  tv3rhosigma28 = t1032 - t1141 + t1144 + t1084 - 0.6751125e-2 * t1145 + 0.270045e-1 * t1147 + t1089 - 0.6751125e-2 * t1167 + 0.270045e-1 * t1169 + 0.18003e-1 * t1171 + t1095 + 0.2025e0 * t745 * t1173 - t1101 - 0.1215e1 * t861 * t1176 - 0.54e0 * t323 * t1180;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = t1109 - 0.30005e-1 * t1140 + 0.6001e-1 * t1143;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  t1185 = 0.1350225e-1 * t1167;
  t1186 = 0.54009e-1 * t1169;
  t1187 = 0.36006e-1 * t1171;
  tv3rhosigma210 = t1081 - t1163 + t1164 + t1112 - t1185 + t1186 + t1187;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1188 = t335 * t75;
  t1189 = t332 * t1188;
  t1192 = t335 * t84;
  t1193 = t1123 * t1192;
  t1197 = 0.1e1 / t333 / t219;
  t1198 = t332 * t1197;
  t1201 = t341 * t286;
  t1204 = t1135 * t290;
  t1207 = t341 * t81;
  tv3rhosigma211 = t1032 - t1141 + t1144 + t1112 - t1185 + t1186 + t1187 + t1116 + 0.2025e0 * t126 * t1189 - t1122 - 0.1215e1 * t92 * t1193 - 0.108e1 * t92 * t1198 + t1129 + 0.1125e0 * t126 * t1201 - t1134 - 0.45e0 * t92 * t1204 - 0.3e0 * t92 * t1207;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1210 = t10 * t10;
  t1212 = 0.1e1 / t11 / t1210;
  t1213 = t1212 * t42;
  t1214 = t87 * t1213;
  t1215 = 0.2250375e-1 * t1214;
  t1216 = t87 * t298;
  t1217 = t1216 * t95;
  t1219 = t302 * t310;
  t1221 = t302 * t316;
  t1223 = t381 * t314;
  t1224 = 0.1e1 / t435;
  t1225 = t1223 * t1224;
  t1228 = sigma[0] * sigma[0];
  t1229 = 0.1e1 / t1228;
  t1230 = t146 * t1229;
  t1231 = t1230 * t309;
  t1235 = 0.1e1 / t19 / t1228;
  t1236 = t61 * t1235;
  t1237 = t1236 * t22;
  tv3sigma30 = t1215 + 0.20253375e-1 * t1217 + 0.36456075e-1 * t1219 + 0.20253375e-1 * t1221 - 0.54675e0 * t92 * t1225 - 0.6075e0 * t92 * t1231 - 0.3375e0 * t92 * t1237;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1240 = 0.450075e-1 * t1214;
  t1241 = 0.270045e-1 * t1217;
  tv3sigma31 = t1240 + t1241 + 0.2430405e-1 * t1219 + 0.1350225e-1 * t1221;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  t1244 = 0.1350225e-1 * t1217;
  t1247 = t1216 * t100;
  t1249 = t87 * t706;
  t1251 = 0.2430405e-1 * t1249 * t326;
  t1252 = t305 * t309;
  t1253 = t324 * t1252;
  t1256 = t314 * t22;
  t1257 = t324 * t1256;
  tv3sigma32 = t1215 + t1244 + 0.12152025e-1 * t1219 + 0.6751125e-2 * t1221 + 0.6751125e-2 * t1247 + t1251 - 0.54675e0 * t861 * t1253 - 0.2025e0 * t323 * t1257;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  t1260 = 0.90015e-1 * t1214;
  tv3sigma33 = t1260 + t1241;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  t1261 = 0.1350225e-1 * t1247;
  tv3sigma34 = t1240 + t1244 + t1261 + t1251;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  t1263 = t302 * t336;
  t1265 = t331 * t335;
  t1266 = t1265 * t325;
  t1269 = t302 * t342;
  t1271 = t340 * t28;
  t1272 = t1271 * t325;
  tv3sigma35 = t1215 + 0.6751125e-2 * t1217 + t1261 + t1251 + 0.12152025e-1 * t1263 - 0.54675e0 * t861 * t1266 + 0.6751125e-2 * t1269 - 0.2025e0 * t323 * t1272;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.18003e0 * t1214;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  t1275 = 0.270045e-1 * t1247;
  tv3sigma37 = t1260 + t1275;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = t1240 + t1275 + 0.2430405e-1 * t1263 + 0.1350225e-1 * t1269;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1281 = t381 * t340;
  t1282 = 0.1e1 / t690;
  t1283 = t1281 * t1282;
  t1286 = sigma[2] * sigma[2];
  t1287 = 0.1e1 / t1286;
  t1288 = t146 * t1287;
  t1289 = t1288 * t335;
  t1293 = 0.1e1 / t25 / t1286;
  t1294 = t61 * t1293;
  t1295 = t1294 * t28;
  tv3sigma39 = t1215 + 0.20253375e-1 * t1247 + 0.36456075e-1 * t1263 + 0.20253375e-1 * t1269 - 0.54675e0 * t92 * t1283 - 0.6075e0 * t92 * t1289 - 0.3375e0 * t92 * t1295;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t7, t8, t10;
  double t11, t12, t14, t17, t18, t19, t20, t22;
  double t25, t26, t28, t31, t33, t34, t35, t36;
  double t37, t41, t42, tzk0;

  double t43, t44, t45, t46, t47, t48, t49, t51;
  double t55, t56, t58, t59, t60, t61, t62, t63;
  double t65, t70, t71, tvrho0, t75, t79, t81, t84;
  double tvrho1, t87, t88, t89, t90, t91, t92, t93;
  double t94, t95, tvsigma0, tvsigma1, t98, t99, t100, tvsigma2;

  double t103, t104, t105, t106, t108, t109, t111, t113;
  double t116, t117, t118, t122, t124, t126, t127, t128;
  double t130, t132, t133, t134, t136, t137, t141, t143;
  double t146, t147, t148, t152, t154, t158, t159, t160;
  double tv2rho20, t164, t165, t167, t168, t172, t174, t175;
  double t178, t184, t185, t186, t190, t192, t193, t197;
  double t198, t199, tv2rho21, t203, t208, t210, t215, t219;
  double t221, t224, tv2rho22, t227, t228, t229, t230, t231;
  double t232, t233, t234, t235, t236, t238, t239, t240;
  double t243, t245, t246, t247, t248, t251, tv2rhosigma0, t254;
  double tv2rhosigma1, t258, t259, t260, t264, t265, t266, t267;
  double tv2rhosigma2, t270, t271, t272, t273, t274, t275, t276;
  double t277, t280, t281, tv2rhosigma3, tv2rhosigma4, t286, t287, t290;
  double t291, t294, tv2rhosigma5, t298, t299, t300, t301, t302;
  double t303, t304, t305, t306, t307, t309, t310, t314;
  double t315, t316, tv2sigma20, t319, tv2sigma21, t321, t323, t324;
  double t325, t326, tv2sigma22, tv2sigma23, t330, tv2sigma24, t331, t332;
  double t333, t335, t336, t340, t341, t342, tv2sigma25;

  double t346, t349, t351, t353, t354, t355, t359, t360;
  double t363, t366, t367, t369, t370, t373, t376, t377;
  double t378, t380, t381, t382, t383, t387, t388, t391;
  double t392, t393, t394, t396, t398, t400, t403, t404;
  double t406, t407, t409, t412, t414, t416, t419, t421;
  double t422, t423, t425, t427, t428, t433, t435, t437;
  double t441, t442, t443, t446, t447, t450, tv3rho30, t453;
  double t454, t457, t458, t460, t464, t466, t467, t468;
  double t472, t474, t476, t484, t486, t487, t488, t491;
  double t493, t496, t497, t499, t502, t503, t506, t509;
  double t512, t514, t516, t517, t518, t521, t524, t527;
  double t530, t531, t534, t535, t539, t540, t543, t545;
  double t546, t549, t551, t552, t555, t556, tv3rho31, t559;
  double t561, t566, t569, t572, t574, t575, t576, t578;
  double t579, t581, t582, t584, t585, t591, t593, t594;
  double t598, t601, t604, t605, t608, t611, t613, t615;
  double t618, t619, t622, t625, t626, t629, t632, t633;
  double t637, t638, t641, t642, t645, tv3rho32, t649, t653;
  double t656, t659, t662, t665, t669, t673, t683, t687;
  double t690, t692, t695, t698, tv3rho33, t699, t700, t701;
  double t702, t703, t704, t705, t706, t707, t708, t709;
  double t710, t711, t712, t714, t715, t716, t718, t720;
  double t722, t723, t724, t727, t729, t731, t733, t734;
  double t735, t738, t741, t742, t745, t746, t749, t750;
  double t753, t754, t755, t758, t759, t762, t763, t764;
  double t765, t766, t767, t768, t769, t770, t771, t772;
  double t773, t774, t775, tv3rho2sigma0, t776, tv3rho2sigma1, t785, t788;
  double t791, t792, t793, t796, t798, t800, t801, t804;
  double t805, t808, t811, t812, t813, tv3rho2sigma2, t817, t818;
  double t820, t821, t822, t823, t826, t828, t830, t831;
  double t834, t835, t838, t839, t840, t841, t842, t843;
  double t844, t846, t847, t848, t849, t850, t853, t854;
  double t857, t858, t861, t862, t865, t866, t867, t868;
  double t869, t870, t871, t872, t873, t874, t875, t877;
  double t878, t885, t886, t889, tv3rho2sigma3, t892, tv3rho2sigma4, t900;
  double t901, t904, t906, t908, t909, t912, t913, t917;
  double t919, t922, t923, t926, t929, t932, t935, t938;
  double t943, t946, tv3rho2sigma5, t947, t952, t953, t956, t957;
  double t960, t961, t964, t965, t968, t969, t972, t973;
  double t974, t975, t976, t977, t978, t979, t980, t981;
  double t982, t983, t984, t985, tv3rho2sigma6, tv3rho2sigma7, t997, t998;
  double t1001, t1002, t1005, t1008, t1009, t1012, t1013, t1016;
  double t1017, t1020, t1021, t1024, t1025, t1030, tv3rho2sigma8, t1031;
  double t1032, t1033, t1034, t1035, t1036, t1037, t1038, t1039;
  double t1040, t1041, t1042, t1043, t1044, t1045, t1046, t1047;
  double t1048, t1050, t1051, t1052, t1056, t1057, t1058, t1059;
  double t1063, t1064, t1068, t1069, t1073, t1074, t1075, t1078;
  double tv3rhosigma20, t1081, t1082, t1083, tv3rhosigma21, t1084, t1088, t1089;
  double t1090, t1092, t1095, t1096, t1099, t1101, t1102, t1105;
  double t1106, tv3rhosigma22, t1109, tv3rhosigma23, t1112, t1113, t1114, tv3rhosigma24;
  double t1116, t1117, t1118, t1122, t1123, t1124, t1125, t1129;
  double t1130, t1134, t1135, t1136, tv3rhosigma25, t1139, t1140, t1141;
  double t1142, t1143, t1144, t1145, t1146, t1147, t1148, t1149;
  double t1150, t1153, t1154, t1157, t1160, tv3rhosigma26, t1163, t1164;
  double tv3rhosigma27, t1167, t1169, t1171, t1173, t1176, t1179, t1180;
  double tv3rhosigma28, tv3rhosigma29, t1185, t1186, t1187, tv3rhosigma210, t1188, t1189;
  double t1192, t1193, t1197, t1198, t1201, t1204, t1207, tv3rhosigma211;
  double t1210, t1212, t1213, t1214, t1215, t1216, t1217, t1219;
  double t1221, t1223, t1224, t1225, t1228, t1229, t1230, t1231;
  double t1235, t1236, t1237, tv3sigma30, t1240, t1241, tv3sigma31, t1244;
  double t1247, t1249, t1251, t1252, t1253, t1256, t1257, tv3sigma32;
  double t1260, tv3sigma33, t1261, tv3sigma34, t1263, t1265, t1266, t1269;
  double t1271, t1272, tv3sigma35, tv3sigma36, t1275, tv3sigma37, tv3sigma38, t1281;
  double t1282, t1283, t1286, t1287, t1288, t1289, t1293, t1294;
  double t1295, tv3sigma39;

  double t1298, t1310, t1312, t1323, t1325, t1327, t1330, t1331;
  double t1332, t1336, t1340, t1341, t1344, t1346, t1348, t1350;
  double t1352, t1354, t1356, t1359, t1361, t1362, t1363, t1367;
  double t1373, t1375, t1377, t1381, t1384, t1388, t1390, t1397;
  double t1398, t1402, t1404, t1406, t1409, t1411, t1413, t1416;
  double t1419, t1422, t1424, t1426, t1428, t1432, t1433, t1437;
  double t1438, t1450, t1451, t1452, t1454, t1466, t1470, t1472;
  double t1474, tv4rho40, t1481, t1483, t1484, t1486, t1488, t1490;
  double t1494, t1496, t1498, t1500, t1502, t1506, t1510, t1520;
  double t1527, t1532, t1534, t1536, t1538, t1545, t1553, t1555;
  double t1560, t1561, t1562, t1564, t1565, t1566, t1568, t1570;
  double t1572, t1575, t1578, t1580, t1581, t1586, t1588, t1590;
  double t1592, t1594, t1597, t1599, t1606, t1608, t1611, t1624;
  double t1626, t1637, t1639, t1646, t1650, t1651, t1652, t1660;
  double t1667, t1669, t1682, t1691, t1693, t1694, t1696, t1697;
  double t1706, t1712, t1714, t1719, t1729, t1734, tv4rho41, t1737;
  double t1738, t1742, t1749, t1772, t1774, t1780, t1782, t1785;
  double t1790, t1795, t1800, t1805, t1810, t1815, t1817, t1818;
  double t1819, t1821, t1822, t1824, t1828, t1841, t1846, t1854;
  double t1856, t1858, t1861, t1863, t1865, t1866, t1868, t1870;
  double t1871, t1875, t1878, t1881, t1884, t1886, t1888, t1890;
  double t1897, t1918, t1920, t1924, t1929, t1931, t1939, t1943;
  double t1951, t1953, t1956, t1960, t1966, t1969, t1975, t1978;
  double t1980, t1982, t1997, t2001, t2005, tv4rho42, t2008, t2009;
  double t2010, t2011, t2013, t2014, t2016, t2017, t2026, t2031;
  double t2038, t2040, t2051, t2056, t2065, t2070, t2077, t2079;
  double t2093, t2099, t2101, t2103, t2105, t2107, t2109, t2112;
  double t2118, t2122, t2125, t2128, t2139, t2154, t2159, t2163;
  double t2167, t2177, t2181, t2191, t2195, t2199, t2226, tv4rho43;
  double t2256, t2277, t2291, t2295, t2299, t2307, t2309, t2315;
  double t2319, t2323, t2327, t2331, tv4rho44, t2334, t2335, t2336;
  double t2337, t2338, t2339, t2341, t2342, t2344, t2346, t2347;
  double t2348, t2349, t2350, t2351, t2352, t2353, t2354, t2355;
  double t2356, t2357, t2358, t2359, t2360, t2362, t2363, t2365;
  double t2366, t2367, t2369, t2370, t2371, t2373, t2375, t2376;
  double t2385, t2387, t2389, t2395, t2397, t2411, t2417, t2419;
  double t2421, t2423, t2437, t2448, t2449, t2457, t2461, t2468;
  double t2469, t2471, t2472, t2474, t2475, t2476, t2477, t2478;
  double t2479, t2480, t2481, t2482, t2484, t2485, t2486, t2488;
  double t2489, t2490, t2492, t2493, t2494, t2495, t2496, tv4rho3sigma0;
  double t2501, tv4rho3sigma1, t2517, t2520, t2523, t2526, t2529, t2530;
  double t2536, t2541, t2543, t2545, t2551, t2552, t2554, t2560;
  double t2562, t2583, tv4rho3sigma2, t2586, t2587, t2588, t2589, t2590;
  double t2591, t2592, t2593, t2594, t2595, t2596, t2597, t2598;
  double t2599, t2600, t2601, t2602, t2603, t2604, t2605, t2606;
  double t2607, t2608, t2610, t2611, t2613, t2614, t2616, t2617;
  double t2618, t2619, t2620, t2621, t2622, t2623, t2624, t2628;
  double t2630, t2637, t2638, t2639, t2640, t2642, t2644, t2645;
  double t2651, t2653, t2655, t2657, t2658, t2665, t2667, t2676;
  double t2677, t2680, t2698, t2699, t2711, t2713, t2714, t2719;
  double t2724, t2725, t2726, t2727, t2728, t2729, t2736, t2738;
  double t2740, t2741, t2744, t2745, t2747, t2748, t2752, t2756;
  double t2757, t2764, t2777, t2781, t2785, t2786, t2787, t2788;
  double t2790, t2791, t2792, t2793, t2794, t2795, t2797, t2798;
  double t2799, t2800, t2801, tv4rho3sigma3, t2814, t2818, t2832, t2835;
  double tv4rho3sigma4, t2838, t2841, t2842, t2846, t2851, t2862, t2866;
  double t2868, t2875, t2876, t2880, t2883, t2884, t2889, t2891;
  double t2892, t2899, t2901, t2903, t2904, t2912, t2918, t2934;
  double t2936, t2937, t2940, t2942, t2971, tv4rho3sigma5, t2974, t2975;
  double t2977, t2978, t2980, t2981, t2983, t2984, t2986, t2987;
  double t2988, t2989, t2990, t2991, t2992, t2993, t2994, t2995;
  double t2996, t2997, t2998, t2999, t3000, t3001, t3002, t3003;
  double t3004, t3005, t3006, t3007, t3008, t3009, t3010, t3023;
  double t3038, t3039, t3040, t3041, t3055, t3059, t3063, t3070;
  double t3075, t3076, t3078, t3079, t3088, t3090, t3092, t3094;
  double t3097, t3098, t3099, t3100, t3113, t3115, t3116, t3117;
  double t3118, t3119, t3120, t3121, t3122, t3124, t3125, t3126;
  double tv4rho3sigma6, t3142, t3158, tv4rho3sigma7, t3160, t3163, t3166, t3169;
  double t3172, t3175, t3177, t3179, t3181, t3194, t3203, t3209;
  double t3217, t3251, t3253, t3259, t3261, t3267, t3272, t3278;
  double t3280, t3282, t3284, t3286, tv4rho3sigma8, t3289, t3290, t3291;
  double t3292, t3293, t3294, t3295, t3296, t3297, t3298, t3299;
  double t3300, t3305, t3309, t3310, t3312, t3313, t3315, t3316;
  double t3318, t3319, t3321, t3322, t3323, t3346, t3353, t3360;
  double t3364, t3368, t3369, t3370, t3371, t3372, tv4rho3sigma9, tv4rho3sigma10;
  double t3400, t3407, t3447, t3478, tv4rho3sigma11, t3481, t3482, t3483;
  double t3485, t3486, t3489, t3490, t3491, t3493, t3494, t3496;
  double t3497, t3498, t3502, t3509, t3511, t3512, t3513, t3514;
  double t3515, t3516, t3517, t3518, t3519, t3520, t3521, t3522;
  double t3524, t3525, t3527, t3528, t3529, t3530, t3531, t3533;
  double t3536, t3537, t3538, t3540, t3541, t3542, t3548, t3553;
  double t3555, t3560, t3561, t3562, t3563, t3564, t3565, t3566;
  double t3567, t3572, t3574, t3575, t3576, t3577, t3578, t3579;
  double t3580, t3589, t3610, t3611, t3612, t3613, t3614, t3621;
  double tv4rho2sigma20, t3623, t3624, t3625, t3626, t3627, t3628, t3629;
  double t3630, tv4rho2sigma21, t3631, t3632, t3650, t3652, t3657, t3658;
  double t3663, t3664, t3665, t3667, t3668, t3675, t3677, t3679;
  double t3680, t3681, t3682, t3683, t3684, t3686, t3688, t3691;
  double t3693, t3695, t3697, t3699, t3703, t3704, t3710, tv4rho2sigma22;
  double t3712, tv4rho2sigma23, t3720, t3721, t3722, t3723, t3724, t3725;
  double t3726, t3727, tv4rho2sigma24, t3729, t3731, t3734, t3737, t3739;
  double t3742, t3744, t3745, t3754, t3756, t3765, t3767, t3788;
  double tv4rho2sigma25, t3795, t3796, t3804, t3805, t3806, t3807, t3808;
  double t3809, t3810, t3811, t3812, t3816, t3817, t3818, t3819;
  double t3820, t3821, t3822, t3823, t3824, t3825, t3827, t3828;
  double t3830, t3831, t3833, t3834, t3838, t3842, t3847, t3849;
  double t3852, t3853, t3854, t3855, t3860, t3862, t3863, t3875;
  double t3876, t3877, t3878, t3903, t3904, t3905, t3906, t3907;
  double t3908, t3909, t3913, t3914, t3915, t3916, t3917, t3918;
  double t3919, tv4rho2sigma26, t3921, t3922, t3923, t3924, t3925, t3926;
  double t3927, t3928, t3929, t3930, t3931, tv4rho2sigma27, t3939, t3944;
  double t3946, t3957, t3981, t3984, t3999, t4001, t4002, t4004;
  double t4006, t4008, t4011, t4014, t4022, t4024, t4026, t4028;
  double t4030, t4032, t4034, tv4rho2sigma28, t4038, tv4rho2sigma29, t4046, t4047;
  double t4048, t4049, t4050, t4051, t4052, t4053, t4054, t4055;
  double t4056, t4057, t4058, tv4rho2sigma210, t4059, t4061, t4071, t4075;
  double t4078, t4081, t4084, t4086, t4088, t4090, t4117, t4121;
  double t4133, t4135, t4148, t4150, tv4rho2sigma211, t4153, t4154, t4156;
  double t4157, t4159, t4160, t4162, t4163, t4168, t4169, t4173;
  double t4181, t4182, t4183, t4184, t4185, t4186, t4204, t4205;
  double t4206, t4207, t4219, t4220, t4221, tv4rho2sigma212, t4222, t4223;
  double t4224, t4225, t4226, t4227, tv4rho2sigma213, t4253, t4255, t4261;
  double t4268, t4273, t4275, t4277, t4279, t4281, t4283, t4285;
  double tv4rho2sigma214, tv4rho2sigma215, t4294, t4295, t4296, t4297, t4298, t4299;
  double t4300, t4301, t4302, t4303, t4304, tv4rho2sigma216, t4307, t4325;
  double t4334, t4377, tv4rho2sigma217, t4380, t4382, t4384, t4386, t4387;
  double t4388, t4390, t4391, t4392, t4393, t4397, t4398, t4399;
  double t4400, t4402, t4403, t4404, t4406, t4407, t4408, t4417;
  double t4419, t4421, t4423, t4424, t4426, t4428, t4430, t4432;
  double t4434, t4440, t4448, t4455, t4459, tv4rhosigma30, t4460, t4461;
  double t4462, t4463, t4464, t4465, t4466, t4467, t4471, tv4rhosigma31;
  double t4476, t4478, t4495, t4496, t4497, t4499, t4501, t4502;
  double t4503, t4505, t4507, t4510, t4512, t4517, t4518, t4524;
  double t4526, t4527, t4529, t4531, tv4rhosigma32, t4532, t4533, t4534;
  double tv4rhosigma33, t4535, t4536, t4537, tv4rhosigma34, t4539, t4541, t4560;
  double t4562, t4563, t4564, t4565, t4566, t4570, t4572, t4573;
  double t4575, t4577, t4579, t4581, tv4rhosigma35, t4582, tv4rhosigma36, t4585;
  double t4586, t4587, tv4rhosigma37, t4588, t4591, tv4rhosigma38, t4594, t4597;
  double t4600, t4603, t4605, t4611, t4612, t4618, t4623, t4624;
  double t4629, t4634, t4635, t4639, tv4rhosigma39, t4641, t4642, t4644;
  double t4645, t4646, t4648, t4650, t4652, t4654, t4656, t4658;
  double t4679, tv4rhosigma310, t4680, t4681, t4682, t4683, tv4rhosigma311, t4689;
  double t4696, t4699, t4700, t4702, t4715, t4716, t4721, t4723;
  double t4725, tv4rhosigma312, t4726, t4727, tv4rhosigma313, t4728, t4729, t4730;
  double tv4rhosigma314, t4739, t4741, t4743, t4758, t4760, t4762, t4764;
  double t4766, tv4rhosigma315, tv4rhosigma316, t4769, t4770, t4771, tv4rhosigma317, tv4rhosigma318;
  double t4785, t4818, tv4rhosigma319, t4823, t4824, t4825, t4826, t4827;
  double t4828, t4829, t4830, t4831, t4832, t4834, t4836, t4846;
  double tv4sigma40, t4858, tv4sigma41, t4869, t4872, t4873, t4874, t4876;
  double tv4sigma42, t4890, t4891, tv4sigma43, t4896, t4897, t4898, t4899;
  double tv4sigma44, t4900, t4903, t4905, t4906, t4913, t4915, t4916;
  double tv4sigma45, t4923, tv4sigma46, t4924, tv4sigma47, tv4sigma48, t4933, t4939;
  double t4945, tv4sigma49, tv4sigma410, t4952, tv4sigma411, tv4sigma412, t4956, t4957;
  double tv4sigma413, t4972, tv4sigma414;


  t1 = rho[0] - rho[1];
  t2 = t1 * t1;
  t3 = rho[0] + rho[1];
  t4 = t3 * t3;
  t5 = 0.1e1 / t4;
  t7 = -t2 * t5 + 0.1e1;
  t8 = sqrt(t7);
  t10 = sigma[0] + 0.2e1 * sigma[1] + sigma[2];
  t11 = sqrt(t10);
  t12 = POW_1_3(t3);
  t14 = 0.1e1 / t12 / t3;
  t17 = -0.7486e0 + 0.6001e-1 * t11 * t14;
  t18 = t8 * t17;
  t19 = sqrt(sigma[0]);
  t20 = POW_1_3(rho[0]);
  t22 = 0.1e1 / t20 / rho[0];
  t25 = sqrt(sigma[2]);
  t26 = POW_1_3(rho[1]);
  t28 = 0.1e1 / t26 / rho[1];
  t31 = M_CBRT3;
  t33 = POW_1_3(0.1e1 / M_PI);
  t34 = t31 * t33;
  t35 = M_CBRT4;
  t36 = t35 * t35;
  t37 = 0.1e1 / t12;
  t41 = 0.360073e1 + 0.9e0 * t19 * t22 + 0.9e0 * t25 * t28 + t34 * t36 * t37 / 0.4e1;
  t42 = 0.1e1 / t41;
  tzk0 = t18 * t42;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t43 = 0.1e1 / t8;
  t44 = t3 * t43;
  t45 = t17 * t42;
  t46 = t1 * t5;
  t47 = t4 * t3;
  t48 = 0.1e1 / t47;
  t49 = t2 * t48;
  t51 = -0.2e1 * t46 + 0.2e1 * t49;
  t55 = t14 * t8;
  t56 = t11 * t42;
  t58 = 0.80013333333333333333e-1 * t55 * t56;
  t59 = t3 * t8;
  t60 = t41 * t41;
  t61 = 0.1e1 / t60;
  t62 = t17 * t61;
  t63 = rho[0] * rho[0];
  t65 = 0.1e1 / t20 / t63;
  t70 = t34 * t36 * t14 / 0.12e2;
  t71 = -0.12e1 * t19 * t65 - t70;
  tvrho0 = tzk0 + t44 * t45 * t51 / 0.2e1 - t58 - t59 * t62 * t71;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t75 = 0.2e1 * t46 + 0.2e1 * t49;
  t79 = rho[1] * rho[1];
  t81 = 0.1e1 / t26 / t79;
  t84 = -0.12e1 * t25 * t81 - t70;
  tvrho1 = tzk0 + t44 * t45 * t75 / 0.2e1 - t58 - t59 * t62 * t84;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t87 = t37 * t8;
  t88 = 0.1e1 / t11;
  t89 = t88 * t42;
  t90 = t87 * t89;
  t91 = 0.30005e-1 * t90;
  t92 = t59 * t17;
  t93 = 0.1e1 / t19;
  t94 = t61 * t93;
  t95 = t94 * t22;
  tvsigma0 = t91 - 0.45e0 * t92 * t95;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.6001e-1 * t90;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t98 = 0.1e1 / t25;
  t99 = t61 * t98;
  t100 = t99 * t28;
  tvsigma2 = t91 - 0.45e0 * t92 * t100;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t103 = t43 * t17;
  t104 = t42 * t51;
  t105 = t103 * t104;
  t106 = t8 * t11;
  t108 = 0.1e1 / t12 / t4;
  t109 = t108 * t42;
  t111 = 0.26671111111111111107e-1 * t106 * t109;
  t113 = t18 * t61 * t71;
  t116 = 0.1e1 / t8 / t7;
  t117 = t3 * t116;
  t118 = t51 * t51;
  t122 = t14 * t43;
  t124 = t122 * t56 * t51;
  t126 = t44 * t17;
  t127 = t61 * t51;
  t128 = t127 * t71;
  t130 = 0.2e1 * t5;
  t132 = 0.8e1 * t1 * t48;
  t133 = t4 * t4;
  t134 = 0.1e1 / t133;
  t136 = 0.6e1 * t2 * t134;
  t137 = -t130 + t132 - t136;
  t141 = t11 * t61;
  t143 = t55 * t141 * t71;
  t146 = 0.1e1 / t60 / t41;
  t147 = t17 * t146;
  t148 = t71 * t71;
  t152 = t63 * rho[0];
  t154 = 0.1e1 / t20 / t152;
  t158 = t34 * t36 * t108;
  t159 = t158 / 0.9e1;
  t160 = 0.28e1 * t19 * t154 + t159;
  tv2rho20 = t105 + t111 - 0.2e1 * t113 - t117 * t45 * t118 / 0.4e1 - 0.80013333333333333332e-1 * t124 - t126 * t128 + t44 * t45 * t137 / 0.2e1 + 0.16002666666666666667e0 * t143 + 0.2e1 * t59 * t147 * t148 - t59 * t62 * t160;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t164 = t42 * t75;
  t165 = t103 * t164;
  t167 = t117 * t17;
  t168 = t164 * t51;
  t172 = t122 * t56 * t75;
  t174 = t61 * t75;
  t175 = t174 * t71;
  t178 = t130 - t136;
  t184 = t61 * t84;
  t185 = t18 * t184;
  t186 = t184 * t51;
  t190 = t55 * t141 * t84;
  t192 = t146 * t84;
  t193 = t192 * t71;
  t197 = t61 * t31;
  t198 = t33 * t36;
  t199 = t197 * t198;
  tv2rho21 = t105 / 0.2e1 + t111 - t113 + t165 / 0.2e1 - t167 * t168 / 0.4e1 - 0.40006666666666666666e-1 * t172 - t126 * t175 / 0.2e1 + t44 * t45 * t178 / 0.2e1 - 0.40006666666666666666e-1 * t124 + 0.80013333333333333333e-1 * t143 - t185 - t126 * t186 / 0.2e1 + 0.80013333333333333333e-1 * t190 + 0.2e1 * t92 * t193 - t55 * t17 * t199 / 0.9e1;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t203 = t75 * t75;
  t208 = t174 * t84;
  t210 = -t130 - t132 - t136;
  t215 = t84 * t84;
  t219 = t79 * rho[1];
  t221 = 0.1e1 / t26 / t219;
  t224 = 0.28e1 * t25 * t221 + t159;
  tv2rho22 = t165 + t111 - 0.2e1 * t185 - t117 * t45 * t203 / 0.4e1 - 0.80013333333333333332e-1 * t172 - t126 * t208 + t44 * t45 * t210 / 0.2e1 + 0.16002666666666666667e0 * t190 + 0.2e1 * t59 * t147 * t215 - t59 * t62 * t224;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t227 = t55 * t89;
  t228 = 0.10001666666666666667e-1 * t227;
  t229 = t37 * t43;
  t230 = t89 * t51;
  t231 = t229 * t230;
  t232 = 0.150025e-1 * t231;
  t233 = t88 * t61;
  t234 = t233 * t71;
  t235 = t87 * t234;
  t236 = 0.30005e-1 * t235;
  t238 = 0.45e0 * t18 * t95;
  t239 = t22 * t51;
  t240 = t94 * t239;
  t243 = t55 * t11;
  t245 = 0.36006e-1 * t243 * t95;
  t246 = t146 * t93;
  t247 = t22 * t71;
  t248 = t246 * t247;
  t251 = t94 * t65;
  tv2rhosigma0 = -t228 + t232 - t236 - t238 - 0.225e0 * t126 * t240 + t245 + 0.9e0 * t92 * t248 + 0.6e0 * t92 * t251;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t254 = 0.20003333333333333333e-1 * t227;
  tv2rhosigma1 = -t254 + 0.30005e-1 * t231 - 0.6001e-1 * t235;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t258 = 0.45e0 * t18 * t100;
  t259 = t28 * t51;
  t260 = t99 * t259;
  t264 = 0.36006e-1 * t243 * t100;
  t265 = t146 * t98;
  t266 = t28 * t71;
  t267 = t265 * t266;
  tv2rhosigma2 = -t228 + t232 - t236 - t258 - 0.225e0 * t126 * t260 + t264 + 0.9e0 * t92 * t267;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t270 = t89 * t75;
  t271 = t229 * t270;
  t272 = 0.150025e-1 * t271;
  t273 = t233 * t84;
  t274 = t87 * t273;
  t275 = 0.30005e-1 * t274;
  t276 = t22 * t75;
  t277 = t94 * t276;
  t280 = t22 * t84;
  t281 = t246 * t280;
  tv2rhosigma3 = -t228 + t272 - t275 - t238 - 0.225e0 * t126 * t277 + t245 + 0.9e0 * t92 * t281;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = -t254 + 0.30005e-1 * t271 - 0.6001e-1 * t274;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t286 = t28 * t75;
  t287 = t99 * t286;
  t290 = t28 * t84;
  t291 = t265 * t290;
  t294 = t99 * t81;
  tv2rhosigma5 = -t228 + t272 - t275 - t258 - 0.225e0 * t126 * t287 + t264 + 0.9e0 * t92 * t291 + 0.6e0 * t92 * t294;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t298 = 0.1e1 / t11 / t10;
  t299 = t298 * t42;
  t300 = t87 * t299;
  t301 = 0.150025e-1 * t300;
  t302 = t87 * t88;
  t303 = t302 * t95;
  t304 = 0.270045e-1 * t303;
  t305 = 0.1e1 / sigma[0];
  t306 = t146 * t305;
  t307 = t20 * t20;
  t309 = 0.1e1 / t307 / t63;
  t310 = t306 * t309;
  t314 = 0.1e1 / t19 / sigma[0];
  t315 = t61 * t314;
  t316 = t315 * t22;
  tv2sigma20 = -t301 - t304 + 0.405e0 * t92 * t310 + 0.225e0 * t92 * t316;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t319 = 0.30005e-1 * t300;
  tv2sigma21 = -t319 - t304;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  t321 = t302 * t100;
  t323 = t59 * t147;
  t324 = t98 * t28;
  t325 = t93 * t22;
  t326 = t324 * t325;
  tv2sigma22 = -t301 - 0.1350225e-1 * t303 - 0.1350225e-1 * t321 + 0.405e0 * t323 * t326;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = -0.6001e-1 * t300;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  t330 = 0.270045e-1 * t321;
  tv2sigma24 = -t319 - t330;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t331 = 0.1e1 / sigma[2];
  t332 = t146 * t331;
  t333 = t26 * t26;
  t335 = 0.1e1 / t333 / t79;
  t336 = t332 * t335;
  t340 = 0.1e1 / t25 / sigma[2];
  t341 = t61 * t340;
  t342 = t341 * t28;
  tv2sigma25 = -t301 - t330 + 0.405e0 * t92 * t336 + 0.225e0 * t92 * t342;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t346 = t103 * t42 * t137;
  t349 = t18 * t61 * t160;
  t351 = t7 * t7;
  t353 = 0.1e1 / t8 / t351;
  t354 = t3 * t353;
  t355 = t118 * t51;
  t359 = t61 * t118;
  t360 = t359 * t71;
  t363 = t104 * t137;
  t366 = t122 * t11;
  t367 = t366 * t128;
  t369 = t61 * t137;
  t370 = t369 * t71;
  t373 = t127 * t160;
  t376 = t11 * t146;
  t377 = t376 * t148;
  t378 = t55 * t377;
  t380 = t60 * t60;
  t381 = 0.1e1 / t380;
  t382 = t17 * t381;
  t383 = t148 * t71;
  t387 = t146 * t71;
  t388 = t387 * t160;
  t391 = 0.3e1 / 0.2e1 * t346 - 0.3e1 * t349 + 0.3e1 / 0.8e1 * t354 * t45 * t355 + 0.3e1 / 0.4e1 * t167 * t360 - 0.3e1 / 0.4e1 * t167 * t363 + 0.24004e0 * t367 - 0.3e1 / 0.2e1 * t126 * t370 - 0.3e1 / 0.2e1 * t126 * t373 - 0.48008000000000000001e0 * t378 - 0.6e1 * t59 * t382 * t383 + 0.6e1 * t92 * t388;
  t392 = t116 * t17;
  t393 = t42 * t118;
  t394 = t392 * t393;
  t396 = t103 * t128;
  t398 = t43 * t11;
  t400 = t398 * t109 * t51;
  t403 = 0.1e1 / t12 / t47;
  t404 = t403 * t42;
  t406 = 0.62232592592592592583e-1 * t106 * t404;
  t407 = t108 * t61;
  t409 = t106 * t407 * t71;
  t412 = t18 * t146 * t148;
  t414 = t14 * t116;
  t416 = t414 * t56 * t118;
  t419 = t122 * t56 * t137;
  t421 = 0.12e2 * t48;
  t422 = t1 * t134;
  t423 = 0.36e2 * t422;
  t425 = 0.1e1 / t133 / t3;
  t427 = 0.24e2 * t2 * t425;
  t428 = t421 - t423 + t427;
  t433 = t55 * t141 * t160;
  t435 = t63 * t63;
  t437 = 0.1e1 / t20 / t435;
  t441 = t34 * t36 * t403;
  t442 = 0.7e1 / 0.27e2 * t441;
  t443 = -0.93333333333333333333e1 * t19 * t437 - t442;
  t446 = t146 * t51;
  t447 = t446 * t148;
  t450 = -0.3e1 / 0.4e1 * t394 - 0.3e1 * t396 + 0.40006666666666666661e-1 * t400 - t406 - 0.8001333333333333333e-1 * t409 + 0.6e1 * t412 + 0.60009999999999999999e-1 * t416 - 0.12002e0 * t419 + t44 * t45 * t428 / 0.2e1 + 0.24004e0 * t433 - t59 * t62 * t443 + 0.3e1 * t126 * t447;
  tv3rho30 = t391 + t450;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t453 = t42 * t178;
  t454 = t103 * t453;
  t457 = t392 * t168 / 0.2e1;
  t458 = t103 * t175;
  t460 = t398 * t109 * t75;
  t464 = 0.80013333333333333332e-1 * t122 * t56 * t178;
  t466 = 0.4e1 * t48;
  t467 = 0.12e2 * t422;
  t468 = -t466 - t467 + t427;
  t472 = t103 * t186;
  t474 = 0.4e1 * t18 * t193;
  t476 = t106 * t407 * t84;
  t484 = t44 * t45 * t468 / 0.2e1 - t472 + t474 - 0.26671111111111111107e-1 * t476 - 0.16002666666666666667e0 * t378 - t396 + 0.26671111111111111109e-1 * t400 - 0.53342222222222222214e-1 * t409 + 0.20003333333333333333e-1 * t416 - 0.40006666666666666666e-1 * t419 + 0.80013333333333333333e-1 * t433;
  t486 = t122 * t62;
  t487 = t36 * t51;
  t488 = t34 * t487;
  t491 = t55 * t147;
  t493 = t34 * t36 * t71;
  t496 = t146 * t75;
  t497 = t496 * t148;
  t499 = t184 * t118;
  t502 = t381 * t84;
  t503 = t502 * t148;
  t506 = t453 * t51;
  t509 = t164 * t137;
  t512 = t414 * t11;
  t514 = 0.40006666666666666666e-1 * t512 * t168;
  t516 = 0.80013333333333333332e-1 * t366 * t175;
  t517 = t61 * t178;
  t518 = t517 * t71;
  t521 = t174 * t160;
  t524 = t184 * t137;
  t527 = t366 * t186;
  t530 = 0.32005333333333333334e0 * t243 * t193;
  t531 = t192 * t160;
  t534 = t354 * t17;
  t535 = t164 * t118;
  t539 = t51 * t71;
  t540 = t174 * t539;
  t543 = t18 * t61;
  t545 = t543 * t158 / 0.27e2;
  t546 = t192 * t539;
  t549 = t12 * t12;
  t551 = 0.1e1 / t549 / t47;
  t552 = t551 * t8;
  t555 = 0.17780740740740740741e-1 * t552 * t11 * t199;
  t556 = -t126 * t521 / 0.2e1 - t126 * t524 / 0.2e1 + 0.80013333333333333332e-1 * t527 - t530 + 0.2e1 * t92 * t531 + 0.3e1 / 0.8e1 * t534 * t535 + 0.80013333333333333332e-1 * t367 + t167 * t540 / 0.2e1 + t545 + 0.2e1 * t126 * t546 + t555;
  tv3rho31 = -t394 / 0.4e1 - t406 + 0.2e1 * t412 + t454 + t346 / 0.2e1 - t349 - t457 - t458 + 0.13335555555555555555e-1 * t460 - t464 + t484 - t486 * t488 / 0.9e1 + 0.4e1 / 0.9e1 * t491 * t493 + t126 * t497 + t167 * t499 / 0.4e1 - 0.6e1 * t92 * t503 - t167 * t506 / 0.2e1 - t167 * t509 / 0.4e1 + t514 + t516 - t126 * t518 + t556;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t559 = t414 * t56 * t203;
  t561 = -t466 + t467 + t427;
  t566 = t122 * t56 * t210;
  t569 = t55 * t376 * t215;
  t572 = t55 * t141 * t224;
  t574 = t103 * t208;
  t575 = t42 * t203;
  t576 = t392 * t575;
  t578 = t42 * t210;
  t579 = t103 * t578;
  t581 = t146 * t215;
  t582 = t18 * t581;
  t584 = t61 * t224;
  t585 = t18 * t584;
  t591 = -t406 + t454 - t457 - t458 + 0.26671111111111111107e-1 * t460 - t464 - t472 + t474 - 0.5334222222222222222e-1 * t476 + 0.13335555555555555554e-1 * t400 - 0.26671111111111111107e-1 * t409;
  t593 = t75 * t31;
  t594 = t593 * t198;
  t598 = t84 * t31 * t198;
  t601 = t575 * t51;
  t604 = t61 * t203;
  t605 = t604 * t71;
  t608 = t164 * t178;
  t611 = t517 * t84;
  t613 = t366 * t208;
  t615 = t578 * t51;
  t618 = t61 * t210;
  t619 = t618 * t71;
  t622 = t581 * t51;
  t625 = t381 * t215;
  t626 = t625 * t71;
  t629 = t584 * t51;
  t632 = t146 * t224;
  t633 = t632 * t71;
  t637 = t84 * t51;
  t638 = t174 * t637;
  t641 = t84 * t71;
  t642 = t496 * t641;
  t645 = -0.6e1 * t92 * t626 - t126 * t629 / 0.2e1 + 0.2e1 * t92 * t633 + t514 + t516 + 0.80013333333333333335e-1 * t527 - t530 + t167 * t638 / 0.2e1 + 0.2e1 * t126 * t642 + t545 + t555;
  tv3rho32 = 0.20003333333333333333e-1 * t559 + t44 * t45 * t561 / 0.2e1 - 0.40006666666666666666e-1 * t566 - 0.16002666666666666667e0 * t569 + 0.80013333333333333333e-1 * t572 - t574 - t576 / 0.4e1 + t579 / 0.2e1 + 0.2e1 * t582 - t585 + t591 - t486 * t594 / 0.9e1 + 0.4e1 / 0.9e1 * t491 * t598 + 0.3e1 / 0.8e1 * t534 * t601 + t167 * t605 / 0.4e1 - t167 * t608 / 0.2e1 - t126 * t611 + 0.80013333333333333333e-1 * t613 - t167 * t615 / 0.4e1 - t126 * t619 / 0.2e1 + t126 * t622 + t645;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t649 = t203 * t75;
  t653 = t604 * t84;
  t656 = t164 * t210;
  t659 = t618 * t84;
  t662 = t174 * t224;
  t665 = t215 * t84;
  t669 = t192 * t224;
  t673 = -0.3e1 * t574 + 0.24004e0 * t613 + 0.3e1 / 0.8e1 * t354 * t45 * t649 + 0.3e1 / 0.4e1 * t167 * t653 - 0.3e1 / 0.4e1 * t167 * t656 - 0.3e1 / 0.2e1 * t126 * t659 - 0.3e1 / 0.2e1 * t126 * t662 - 0.6e1 * t59 * t382 * t665 + 0.6e1 * t92 * t669 - t406 + 0.40006666666666666661e-1 * t460;
  t683 = t421 + t423 + t427;
  t687 = t496 * t215;
  t690 = t79 * t79;
  t692 = 0.1e1 / t26 / t690;
  t695 = -0.93333333333333333333e1 * t25 * t692 - t442;
  t698 = -0.8001333333333333333e-1 * t476 - 0.3e1 / 0.4e1 * t576 + 0.60009999999999999999e-1 * t559 + 0.3e1 / 0.2e1 * t579 - 0.12002e0 * t566 + 0.6e1 * t582 - 0.48008000000000000001e0 * t569 - 0.3e1 * t585 + 0.24004e0 * t572 + t44 * t45 * t683 / 0.2e1 + 0.3e1 * t126 * t687 - t59 * t62 * t695;
  tv3rho33 = t673 + t698;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t699 = t37 * t116;
  t700 = t89 * t118;
  t701 = t699 * t700;
  t702 = 0.750125e-2 * t701;
  t703 = t229 * t88;
  t704 = t703 * t128;
  t705 = 0.30005e-1 * t704;
  t706 = t88 * t146;
  t707 = t706 * t148;
  t708 = t87 * t707;
  t709 = 0.6001e-1 * t708;
  t710 = t103 * t61;
  t711 = t325 * t51;
  t712 = t710 * t711;
  t714 = t18 * t146;
  t715 = t325 * t71;
  t716 = t714 * t715;
  t718 = t18 * t251;
  t720 = t106 * t108;
  t722 = 0.12002e-1 * t720 * t95;
  t723 = t22 * t137;
  t724 = t94 * t723;
  t727 = t366 * t240;
  t729 = t243 * t248;
  t731 = t243 * t251;
  t733 = -t702 - t705 + t709 - 0.45e0 * t712 + 0.18e1 * t716 + 0.12e1 * t718 - t722 - 0.225e0 * t126 * t724 + 0.36006e-1 * t727 - 0.144024e0 * t729 - 0.96016e-1 * t731;
  t734 = t22 * t160;
  t735 = t246 * t734;
  t738 = t94 * t154;
  t741 = t22 * t118;
  t742 = t94 * t741;
  t745 = t44 * t147;
  t746 = t325 * t539;
  t749 = t65 * t51;
  t750 = t94 * t749;
  t753 = t381 * t93;
  t754 = t22 * t148;
  t755 = t753 * t754;
  t758 = t65 * t71;
  t759 = t246 * t758;
  t762 = t108 * t8;
  t763 = t762 * t89;
  t764 = 0.13335555555555555556e-1 * t763;
  t765 = t122 * t230;
  t766 = 0.10001666666666666667e-1 * t765;
  t767 = t55 * t234;
  t768 = 0.20003333333333333334e-1 * t767;
  t769 = t89 * t137;
  t770 = t229 * t769;
  t771 = 0.150025e-1 * t770;
  t772 = t233 * t160;
  t773 = t87 * t772;
  t774 = 0.30005e-1 * t773;
  t775 = 0.9e0 * t92 * t735 - 0.14e1 * t92 * t738 + 0.1125e0 * t167 * t742 + 0.9e0 * t745 * t746 + 0.6e0 * t126 * t750 - 0.27e1 * t92 * t755 - 0.24e1 * t92 * t759 + t764 - t766 + t768 + t771 - t774;
  tv3rho2sigma0 = t733 + t775;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t776 = 0.26671111111111111111e-1 * t763;
  tv3rho2sigma1 = t776 - 0.20003333333333333333e-1 * t765 + 0.40006666666666666666e-1 * t767 - 0.150025e-1 * t701 - 0.6001e-1 * t704 + 0.30005e-1 * t770 + 0.12002e0 * t708 - 0.6001e-1 * t773;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t785 = t710 * t324 * t51;
  t788 = t714 * t324 * t71;
  t791 = 0.12002e-1 * t720 * t100;
  t792 = t28 * t137;
  t793 = t99 * t792;
  t796 = t366 * t260;
  t798 = t243 * t267;
  t800 = t28 * t160;
  t801 = t265 * t800;
  t804 = t28 * t118;
  t805 = t99 * t804;
  t808 = t324 * t539;
  t811 = t381 * t98;
  t812 = t28 * t148;
  t813 = t811 * t812;
  tv3rho2sigma2 = -t702 - t705 + t709 - 0.45e0 * t785 + 0.18e1 * t788 - t791 - 0.225e0 * t126 * t793 + 0.36006e-1 * t796 - 0.144024e0 * t798 + 0.9e0 * t92 * t801 + 0.1125e0 * t167 * t805 + 0.9e0 * t745 * t808 - 0.27e1 * t92 * t813 + t764 - t766 + t768 + t771 - t774;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t817 = 0.1e1 / t549 / t4;
  t818 = t817 * t8;
  t820 = t818 * t88 * t199;
  t821 = 0.33338888888888888889e-2 * t820;
  t822 = t22 * t178;
  t823 = t94 * t822;
  t826 = t366 * t277;
  t828 = t243 * t281;
  t830 = t65 * t75;
  t831 = t94 * t830;
  t834 = t65 * t84;
  t835 = t246 * t834;
  t838 = t89 * t178;
  t839 = t229 * t838;
  t840 = 0.150025e-1 * t839;
  t841 = t122 * t270;
  t842 = 0.50008333333333333333e-2 * t841;
  t843 = t55 * t273;
  t844 = 0.10001666666666666667e-1 * t843;
  t846 = 0.50008333333333333335e-2 * t765;
  t847 = 0.10001666666666666667e-1 * t767;
  t848 = t117 * t62;
  t849 = t75 * t51;
  t850 = t325 * t849;
  t853 = t75 * t71;
  t854 = t325 * t853;
  t857 = -t821 - 0.225e0 * t126 * t823 + 0.18003e-1 * t826 - 0.72012e-1 * t828 + 0.3e0 * t126 * t831 - 0.12e1 * t92 * t835 + t840 - t842 + t844 + 0.6e0 * t718 - t846 + t847 + t764 + 0.1125e0 * t848 * t850 + 0.45e0 * t745 * t854;
  t858 = t325 * t637;
  t861 = t59 * t382;
  t862 = t325 * t641;
  t865 = t699 * t88;
  t866 = t865 * t168;
  t867 = 0.750125e-2 * t866;
  t868 = t703 * t175;
  t869 = 0.150025e-1 * t868;
  t870 = t703 * t186;
  t871 = 0.150025e-1 * t870;
  t872 = t302 * t193;
  t873 = 0.6001e-1 * t872;
  t874 = t325 * t75;
  t875 = t710 * t874;
  t877 = t325 * t84;
  t878 = t714 * t877;
  t885 = t34 * t36;
  t886 = t325 * t885;
  t889 = 0.45e0 * t745 * t858 - 0.27e1 * t861 * t862 - t867 - t869 - t871 + t873 - 0.225e0 * t875 + 0.9e0 * t878 - 0.225e0 * t712 + 0.9e0 * t716 - t722 - 0.48008e-1 * t731 + 0.18003e-1 * t727 - 0.72012e-1 * t729 + 0.1e0 * t491 * t886;
  tv3rho2sigma3 = t857 + t889;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  t892 = 0.10001666666666666667e-1 * t841;
  tv3rho2sigma4 = t776 - 0.10001666666666666666e-1 * t765 + 0.20003333333333333333e-1 * t767 - t892 - 0.150025e-1 * t866 - 0.30005e-1 * t868 + 0.30005e-1 * t839 + 0.20003333333333333333e-1 * t843 - 0.30005e-1 * t870 + 0.12002e0 * t872 - 0.66677777777777777778e-2 * t820;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t900 = t28 * t178;
  t901 = t99 * t900;
  t904 = t366 * t287;
  t906 = t243 * t291;
  t908 = t81 * t51;
  t909 = t99 * t908;
  t912 = t81 * t71;
  t913 = t265 * t912;
  t917 = t18 * t294;
  t919 = t324 * t849;
  t922 = -0.225e0 * t126 * t901 + 0.18003e-1 * t904 - 0.72012e-1 * t906 + 0.3e0 * t126 * t909 - 0.12e1 * t92 * t913 - 0.72012e-1 * t798 - t821 + 0.6e0 * t917 + t840 - t842 + t844 - t846 + t847 + t764 + 0.1125e0 * t848 * t919;
  t923 = t324 * t853;
  t926 = t324 * t637;
  t929 = t324 * t641;
  t932 = t243 * t294;
  t935 = t710 * t324 * t75;
  t938 = t714 * t324 * t84;
  t943 = t324 * t885;
  t946 = 0.45e0 * t745 * t923 + 0.45e0 * t745 * t926 - 0.27e1 * t861 * t929 - 0.48008e-1 * t932 - t867 - t869 - t871 + t873 - 0.225e0 * t935 + 0.9e0 * t938 - 0.225e0 * t785 + 0.9e0 * t788 - t791 + 0.18003e-1 * t796 + 0.1e0 * t491 * t943;
  tv3rho2sigma5 = t922 + t946;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t947 = 0.20003333333333333334e-1 * t843;
  t952 = t22 * t210;
  t953 = t94 * t952;
  t956 = t22 * t224;
  t957 = t246 * t956;
  t960 = t22 * t203;
  t961 = t94 * t960;
  t964 = t75 * t84;
  t965 = t325 * t964;
  t968 = t22 * t215;
  t969 = t753 * t968;
  t972 = t89 * t210;
  t973 = t229 * t972;
  t974 = 0.150025e-1 * t973;
  t975 = t233 * t224;
  t976 = t87 * t975;
  t977 = 0.30005e-1 * t976;
  t978 = t89 * t203;
  t979 = t699 * t978;
  t980 = 0.750125e-2 * t979;
  t981 = t703 * t208;
  t982 = 0.30005e-1 * t981;
  t983 = t706 * t215;
  t984 = t87 * t983;
  t985 = 0.6001e-1 * t984;
  tv3rho2sigma6 = -t722 - t892 + t947 - 0.45e0 * t875 + 0.36006e-1 * t826 + 0.18e1 * t878 - 0.144024e0 * t828 - 0.225e0 * t126 * t953 + 0.9e0 * t92 * t957 + 0.1125e0 * t167 * t961 + 0.9e0 * t745 * t965 - 0.27e1 * t92 * t969 + t764 + t974 - t977 - t980 - t982 + t985;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = t776 - 0.20003333333333333333e-1 * t841 + 0.40006666666666666666e-1 * t843 - 0.150025e-1 * t979 - 0.6001e-1 * t981 + 0.30005e-1 * t973 + 0.12002e0 * t984 - 0.6001e-1 * t976;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t997 = t28 * t210;
  t998 = t99 * t997;
  t1001 = t28 * t224;
  t1002 = t265 * t1001;
  t1005 = t99 * t221;
  t1008 = t28 * t203;
  t1009 = t99 * t1008;
  t1012 = -t791 - t892 + t947 - 0.45e0 * t935 + 0.36006e-1 * t904 + 0.18e1 * t938 - 0.144024e0 * t906 - 0.225e0 * t126 * t998 + 0.9e0 * t92 * t1002 - 0.14e1 * t92 * t1005 + 0.1125e0 * t167 * t1009;
  t1013 = t324 * t964;
  t1016 = t81 * t75;
  t1017 = t99 * t1016;
  t1020 = t28 * t215;
  t1021 = t811 * t1020;
  t1024 = t81 * t84;
  t1025 = t265 * t1024;
  t1030 = 0.9e0 * t745 * t1013 + 0.6e0 * t126 * t1017 - 0.27e1 * t92 * t1021 - 0.24e1 * t92 * t1025 + t764 + t974 - t977 + 0.12e1 * t917 - 0.96016e-1 * t932 - t980 - t982 + t985;
  tv3rho2sigma8 = t1012 + t1030;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1031 = t55 * t299;
  t1032 = 0.50008333333333333333e-2 * t1031;
  t1033 = t299 * t51;
  t1034 = t229 * t1033;
  t1035 = 0.750125e-2 * t1034;
  t1036 = t298 * t61;
  t1037 = t1036 * t71;
  t1038 = t87 * t1037;
  t1039 = 0.150025e-1 * t1038;
  t1040 = t55 * t88;
  t1041 = t1040 * t95;
  t1042 = 0.90015e-2 * t1041;
  t1043 = t703 * t240;
  t1044 = 0.1350225e-1 * t1043;
  t1045 = t302 * t248;
  t1046 = 0.54009e-1 * t1045;
  t1047 = t302 * t251;
  t1048 = 0.36006e-1 * t1047;
  t1050 = 0.405e0 * t18 * t310;
  t1051 = t309 * t51;
  t1052 = t306 * t1051;
  t1056 = 0.324054e-1 * t243 * t310;
  t1057 = t381 * t305;
  t1058 = t309 * t71;
  t1059 = t1057 * t1058;
  t1063 = 0.1e1 / t307 / t152;
  t1064 = t306 * t1063;
  t1068 = 0.225e0 * t18 * t316;
  t1069 = t315 * t239;
  t1073 = 0.18003e-1 * t243 * t316;
  t1074 = t146 * t314;
  t1075 = t1074 * t247;
  t1078 = t315 * t65;
  tv3rhosigma20 = t1032 - t1035 + t1039 + t1042 - t1044 + t1046 + t1048 + t1050 + 0.2025e0 * t126 * t1052 - t1056 - 0.1215e1 * t92 * t1059 - 0.108e1 * t92 * t1064 + t1068 + 0.1125e0 * t126 * t1069 - t1073 - 0.45e0 * t92 * t1075 - 0.3e0 * t92 * t1078;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t1081 = 0.10001666666666666667e-1 * t1031;
  t1082 = 0.150025e-1 * t1034;
  t1083 = 0.30005e-1 * t1038;
  tv3rhosigma21 = t1081 - t1082 + t1083 + t1042 - t1044 + t1046 + t1048;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  t1084 = 0.450075e-2 * t1041;
  t1088 = t1040 * t100;
  t1089 = 0.450075e-2 * t1088;
  t1090 = t703 * t260;
  t1092 = t302 * t267;
  t1095 = 0.405e0 * t714 * t326;
  t1096 = t324 * t711;
  t1099 = t55 * t376;
  t1101 = 0.324054e-1 * t1099 * t326;
  t1102 = t324 * t715;
  t1105 = t93 * t65;
  t1106 = t324 * t1105;
  tv3rhosigma22 = t1032 - t1035 + t1039 + t1084 - 0.6751125e-2 * t1043 + 0.270045e-1 * t1045 + 0.18003e-1 * t1047 + t1089 - 0.6751125e-2 * t1090 + 0.270045e-1 * t1092 + t1095 + 0.2025e0 * t745 * t1096 - t1101 - 0.1215e1 * t861 * t1102 - 0.54e0 * t323 * t1106;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  t1109 = 0.20003333333333333333e-1 * t1031;
  tv3rhosigma23 = t1109 - 0.30005e-1 * t1034 + 0.6001e-1 * t1038;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  t1112 = 0.90015e-2 * t1088;
  t1113 = 0.1350225e-1 * t1090;
  t1114 = 0.54009e-1 * t1092;
  tv3rhosigma24 = t1081 - t1082 + t1083 + t1112 - t1113 + t1114;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1116 = 0.405e0 * t18 * t336;
  t1117 = t335 * t51;
  t1118 = t332 * t1117;
  t1122 = 0.324054e-1 * t243 * t336;
  t1123 = t381 * t331;
  t1124 = t335 * t71;
  t1125 = t1123 * t1124;
  t1129 = 0.225e0 * t18 * t342;
  t1130 = t341 * t259;
  t1134 = 0.18003e-1 * t243 * t342;
  t1135 = t146 * t340;
  t1136 = t1135 * t266;
  tv3rhosigma25 = t1032 - t1035 + t1039 + t1112 - t1113 + t1114 + t1116 + 0.2025e0 * t126 * t1118 - t1122 - 0.1215e1 * t92 * t1125 + t1129 + 0.1125e0 * t126 * t1130 - t1134 - 0.45e0 * t92 * t1136;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1139 = t299 * t75;
  t1140 = t229 * t1139;
  t1141 = 0.750125e-2 * t1140;
  t1142 = t1036 * t84;
  t1143 = t87 * t1142;
  t1144 = 0.150025e-1 * t1143;
  t1145 = t703 * t277;
  t1146 = 0.1350225e-1 * t1145;
  t1147 = t302 * t281;
  t1148 = 0.54009e-1 * t1147;
  t1149 = t309 * t75;
  t1150 = t306 * t1149;
  t1153 = t309 * t84;
  t1154 = t1057 * t1153;
  t1157 = t315 * t276;
  t1160 = t1074 * t280;
  tv3rhosigma26 = t1032 - t1141 + t1144 + t1042 - t1146 + t1148 + t1050 + 0.2025e0 * t126 * t1150 - t1056 - 0.1215e1 * t92 * t1154 + t1068 + 0.1125e0 * t126 * t1157 - t1073 - 0.45e0 * t92 * t1160;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  t1163 = 0.150025e-1 * t1140;
  t1164 = 0.30005e-1 * t1143;
  tv3rhosigma27 = t1081 - t1163 + t1164 + t1042 - t1146 + t1148;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  t1167 = t703 * t287;
  t1169 = t302 * t291;
  t1171 = t302 * t294;
  t1173 = t324 * t874;
  t1176 = t324 * t877;
  t1179 = t98 * t81;
  t1180 = t1179 * t325;
  tv3rhosigma28 = t1032 - t1141 + t1144 + t1084 - 0.6751125e-2 * t1145 + 0.270045e-1 * t1147 + t1089 - 0.6751125e-2 * t1167 + 0.270045e-1 * t1169 + 0.18003e-1 * t1171 + t1095 + 0.2025e0 * t745 * t1173 - t1101 - 0.1215e1 * t861 * t1176 - 0.54e0 * t323 * t1180;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = t1109 - 0.30005e-1 * t1140 + 0.6001e-1 * t1143;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  t1185 = 0.1350225e-1 * t1167;
  t1186 = 0.54009e-1 * t1169;
  t1187 = 0.36006e-1 * t1171;
  tv3rhosigma210 = t1081 - t1163 + t1164 + t1112 - t1185 + t1186 + t1187;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1188 = t335 * t75;
  t1189 = t332 * t1188;
  t1192 = t335 * t84;
  t1193 = t1123 * t1192;
  t1197 = 0.1e1 / t333 / t219;
  t1198 = t332 * t1197;
  t1201 = t341 * t286;
  t1204 = t1135 * t290;
  t1207 = t341 * t81;
  tv3rhosigma211 = t1032 - t1141 + t1144 + t1112 - t1185 + t1186 + t1187 + t1116 + 0.2025e0 * t126 * t1189 - t1122 - 0.1215e1 * t92 * t1193 - 0.108e1 * t92 * t1198 + t1129 + 0.1125e0 * t126 * t1201 - t1134 - 0.45e0 * t92 * t1204 - 0.3e0 * t92 * t1207;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1210 = t10 * t10;
  t1212 = 0.1e1 / t11 / t1210;
  t1213 = t1212 * t42;
  t1214 = t87 * t1213;
  t1215 = 0.2250375e-1 * t1214;
  t1216 = t87 * t298;
  t1217 = t1216 * t95;
  t1219 = t302 * t310;
  t1221 = t302 * t316;
  t1223 = t381 * t314;
  t1224 = 0.1e1 / t435;
  t1225 = t1223 * t1224;
  t1228 = sigma[0] * sigma[0];
  t1229 = 0.1e1 / t1228;
  t1230 = t146 * t1229;
  t1231 = t1230 * t309;
  t1235 = 0.1e1 / t19 / t1228;
  t1236 = t61 * t1235;
  t1237 = t1236 * t22;
  tv3sigma30 = t1215 + 0.20253375e-1 * t1217 + 0.36456075e-1 * t1219 + 0.20253375e-1 * t1221 - 0.54675e0 * t92 * t1225 - 0.6075e0 * t92 * t1231 - 0.3375e0 * t92 * t1237;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t1240 = 0.450075e-1 * t1214;
  t1241 = 0.270045e-1 * t1217;
  tv3sigma31 = t1240 + t1241 + 0.2430405e-1 * t1219 + 0.1350225e-1 * t1221;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  t1244 = 0.1350225e-1 * t1217;
  t1247 = t1216 * t100;
  t1249 = t87 * t706;
  t1251 = 0.2430405e-1 * t1249 * t326;
  t1252 = t305 * t309;
  t1253 = t324 * t1252;
  t1256 = t314 * t22;
  t1257 = t324 * t1256;
  tv3sigma32 = t1215 + t1244 + 0.12152025e-1 * t1219 + 0.6751125e-2 * t1221 + 0.6751125e-2 * t1247 + t1251 - 0.54675e0 * t861 * t1253 - 0.2025e0 * t323 * t1257;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  t1260 = 0.90015e-1 * t1214;
  tv3sigma33 = t1260 + t1241;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  t1261 = 0.1350225e-1 * t1247;
  tv3sigma34 = t1240 + t1244 + t1261 + t1251;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  t1263 = t302 * t336;
  t1265 = t331 * t335;
  t1266 = t1265 * t325;
  t1269 = t302 * t342;
  t1271 = t340 * t28;
  t1272 = t1271 * t325;
  tv3sigma35 = t1215 + 0.6751125e-2 * t1217 + t1261 + t1251 + 0.12152025e-1 * t1263 - 0.54675e0 * t861 * t1266 + 0.6751125e-2 * t1269 - 0.2025e0 * t323 * t1272;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.18003e0 * t1214;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  t1275 = 0.270045e-1 * t1247;
  tv3sigma37 = t1260 + t1275;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = t1240 + t1275 + 0.2430405e-1 * t1263 + 0.1350225e-1 * t1269;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1281 = t381 * t340;
  t1282 = 0.1e1 / t690;
  t1283 = t1281 * t1282;
  t1286 = sigma[2] * sigma[2];
  t1287 = 0.1e1 / t1286;
  t1288 = t146 * t1287;
  t1289 = t1288 * t335;
  t1293 = 0.1e1 / t25 / t1286;
  t1294 = t61 * t1293;
  t1295 = t1294 * t28;
  tv3sigma39 = t1215 + 0.20253375e-1 * t1247 + 0.36456075e-1 * t1263 + 0.20253375e-1 * t1269 - 0.54675e0 * t92 * t1283 - 0.6075e0 * t92 * t1289 - 0.3375e0 * t92 * t1295;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1298 = t366 * t373;
  t1310 = t243 * t388;
  t1312 = t381 * t383;
  t1323 = t762 * t377;
  t1325 = t11 * t381;
  t1327 = t55 * t1325 * t383;
  t1330 = 0.1e1 / t380 / t41;
  t1331 = t17 * t1330;
  t1332 = t148 * t148;
  t1336 = t160 * t160;
  t1340 = 0.48008e0 * t1298 - 0.2e1 * t126 * t61 * t428 * t71 - 0.3e1 * t126 * t369 * t160 - 0.2e1 * t126 * t127 * t443 - 0.192032e1 * t1310 - 0.12e2 * t126 * t1312 * t51 - 0.36e2 * t92 * t381 * t148 * t160 + 0.8e1 * t92 * t387 * t443 + 0.32005333333333333334e0 * t1323 + 0.192032e1 * t1327 + 0.24e2 * t59 * t1331 * t1332 + 0.6e1 * t59 * t147 * t1336;
  t1341 = t103 * t447;
  t1344 = t398 * t404 * t51;
  t1346 = t14 * t353;
  t1348 = t1346 * t56 * t355;
  t1350 = t116 * t11;
  t1352 = t1350 * t109 * t118;
  t1354 = t403 * t61;
  t1356 = t106 * t1354 * t71;
  t1359 = t122 * t56 * t428;
  t1361 = 0.72e2 * t134;
  t1362 = t1 * t425;
  t1363 = 0.192e3 * t1362;
  t1367 = 0.12e3 * t2 / t133 / t4;
  t1373 = t55 * t141 * t443;
  t1375 = t435 * rho[0];
  t1377 = 0.1e1 / t20 / t1375;
  t1381 = 0.1e1 / t12 / t133;
  t1384 = 0.7e2 / 0.81e2 * t34 * t36 * t1381;
  t1388 = t392 * t360;
  t1390 = t137 * t137;
  t1397 = t3 / t8 / t351 / t7;
  t1398 = t118 * t118;
  t1402 = 0.12e2 * t1341 - 0.12446518518518518517e0 * t1344 - 0.12002e0 * t1348 - 0.40006666666666666662e-1 * t1352 + 0.24893037037037037035e0 * t1356 - 0.16002666666666666667e0 * t1359 + t44 * t45 * (-t1361 + t1363 - t1367) / 0.2e1 + 0.32005333333333333333e0 * t1373 - t59 * t62 * (0.40444444444444444444e2 * t19 * t1377 + t1384) + 0.3e1 * t1388 - 0.3e1 / 0.4e1 * t117 * t45 * t1390 - 0.15e2 / 0.16e2 * t1397 * t45 * t1398;
  t1404 = t392 * t363;
  t1406 = t103 * t370;
  t1409 = t398 * t109 * t137;
  t1411 = t103 * t373;
  t1413 = t18 * t388;
  t1416 = t106 * t407 * t160;
  t1419 = t103 * t42 * t428;
  t1422 = t18 * t61 * t443;
  t1424 = t353 * t17;
  t1426 = t1424 * t42 * t355;
  t1428 = t18 * t1312;
  t1432 = 0.20744197530864197528e0 * t106 * t1381 * t42;
  t1433 = t71 * t137;
  t1437 = -0.3e1 * t1404 - 0.6e1 * t1406 + 0.80013333333333333331e-1 * t1409 - 0.6e1 * t1411 + 0.24e2 * t1413 - 0.16002666666666666666e0 * t1416 + 0.2e1 * t1419 - 0.4e1 * t1422 + 0.3e1 / 0.2e1 * t1426 - 0.24e2 * t1428 + t1432 + 0.3e1 * t167 * t127 * t1433;
  t1438 = t160 * t71;
  t1450 = t108 * t43;
  t1451 = t1450 * t11;
  t1452 = t1451 * t128;
  t1454 = t366 * t447;
  t1466 = t512 * t360;
  t1470 = t512 * t363;
  t1472 = t366 * t370;
  t1474 = 0.12e2 * t126 * t446 * t1438 - 0.3e1 / 0.2e1 * t534 * t61 * t355 * t71 - 0.3e1 * t167 * t146 * t118 * t148 - 0.16002666666666666666e0 * t1452 - 0.96016e0 * t1454 + 0.6e1 * t126 * t146 * t137 * t148 + 0.9e1 / 0.4e1 * t534 * t393 * t137 + 0.3e1 / 0.2e1 * t167 * t359 * t160 - 0.24004e0 * t1466 - t167 * t104 * t428 + 0.24004e0 * t1470 + 0.48008e0 * t1472;
  tv4rho40 = t1340 + t1402 + t1437 + t1474;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1481 = t108 * t116 * t11 * t168;
  t1483 = t1346 * t11;
  t1484 = t1483 * t535;
  t1486 = t1451 * t175;
  t1488 = t366 * t497;
  t1490 = t146 * t178;
  t1494 = t1451 * t186;
  t1496 = t512 * t499;
  t1498 = t720 * t193;
  t1500 = t243 * t503;
  t1502 = t1397 * t17;
  t1506 = t381 * t75;
  t1510 = 0.9e1 / 0.8e1 * t534 * t453 * t118 - 0.20003333333333333332e-1 * t1481 - 0.90014999999999999999e-1 * t1484 - 0.40006666666666666662e-1 * t1486 - 0.24003999999999999999e0 * t1488 + 0.3e1 * t126 * t1490 * t148 - 0.40006666666666666661e-1 * t1494 - 0.60009999999999999999e-1 * t1496 + 0.16002666666666666667e0 * t1498 + 0.144024e1 * t1500 - 0.15e2 / 0.16e2 * t1502 * t164 * t355 - 0.3e1 * t126 * t1506 * t383;
  t1520 = t42 * t468;
  t1527 = t512 * t506;
  t1532 = t512 * t509;
  t1534 = t366 * t518;
  t1536 = t366 * t521;
  t1538 = t61 * t468;
  t1545 = -0.3e1 / 0.8e1 * t534 * t184 * t355 + 0.24e2 * t92 * t1330 * t84 * t383 + 0.12002e0 * t1298 - 0.48008000000000000001e0 * t1310 - 0.3e1 / 0.4e1 * t167 * t1520 * t51 - 0.3e1 / 0.4e1 * t167 * t453 * t137 + 0.12002e0 * t1527 - t167 * t164 * t428 / 0.4e1 + 0.60009999999999999999e-1 * t1532 + 0.24003999999999999999e0 * t1534 + 0.12002e0 * t1536 - 0.3e1 / 0.2e1 * t126 * t1538 * t71 - 0.3e1 / 0.2e1 * t126 * t517 * t160;
  t1553 = t366 * t524;
  t1555 = t243 * t531;
  t1560 = t392 * t61;
  t1561 = t849 * t71;
  t1562 = t1560 * t1561;
  t1564 = t103 * t146;
  t1565 = t637 * t71;
  t1566 = t1564 * t1565;
  t1568 = t392 * t506;
  t1570 = t103 * t518;
  t1572 = t18 * t503;
  t1575 = t106 * t1354 * t84;
  t1578 = t122 * t56 * t468;
  t1580 = -t126 * t174 * t443 / 0.2e1 - t126 * t184 * t428 / 0.2e1 + 0.12002e0 * t1553 - 0.48008000000000000001e0 * t1555 + 0.2e1 * t92 * t192 * t443 + 0.3e1 / 0.2e1 * t1562 + 0.6e1 * t1566 - 0.3e1 / 0.2e1 * t1568 - 0.3e1 * t1570 - 0.18e2 * t1572 + 0.62232592592592592583e-1 * t1575 - 0.12002e0 * t1578;
  t1581 = 0.96e2 * t1362;
  t1586 = t103 * t521;
  t1588 = t103 * t524;
  t1590 = t18 * t531;
  t1592 = t1424 * t535;
  t1594 = t103 * t497;
  t1597 = t398 * t404 * t75;
  t1599 = t392 * t499;
  t1606 = t398 * t109 * t178;
  t1608 = t44 * t45 * (t1581 - t1367) / 0.2e1 - 0.3e1 / 0.2e1 * t1586 - 0.3e1 / 0.2e1 * t1588 + 0.6e1 * t1590 + 0.9e1 / 0.8e1 * t1592 + 0.3e1 * t1594 - 0.31116296296296296295e-1 * t1597 + 0.3e1 / 0.4e1 * t1599 + 0.16002666666666666665e0 * t1323 + 0.48008000000000000001e0 * t1327 + 0.3e1 * t1341 - 0.9334888888888888888e-1 * t1344 + 0.40006666666666666662e-1 * t1606;
  t1611 = t392 * t509;
  t1624 = -0.3e1 / 0.4e1 * t1611 - 0.30005e-1 * t1348 - 0.20003333333333333332e-1 * t1352 + 0.18669777777777777775e0 * t1356 - 0.40006666666666666666e-1 * t1359 + 0.80013333333333333333e-1 * t1373 + 0.3e1 / 0.4e1 * t1388 - 0.3e1 / 0.4e1 * t1404 - 0.3e1 / 0.2e1 * t1406 + 0.40006666666666666664e-1 * t1409 - 0.3e1 / 0.2e1 * t1411 + 0.6e1 * t1413;
  t1626 = t103 * t1520;
  t1637 = t106 / t549 / t133 * t199;
  t1639 = t118 * t71;
  t1646 = t51 * t148;
  t1650 = t543 * t441;
  t1651 = 0.7e1 / 0.81e2 * t1650;
  t1652 = -0.80013333333333333321e-1 * t1416 + 0.3e1 / 0.2e1 * t1626 + t1419 / 0.2e1 - t1422 + 0.3e1 / 0.8e1 * t1426 - 0.6e1 * t1428 + t1432 - 0.18e2 * t92 * t502 * t1438 - 0.71122962962962962964e-1 * t1637 - 0.9e1 / 0.8e1 * t534 * t174 * t1639 - 0.3e1 / 0.2e1 * t167 * t192 * t1639 - 0.3e1 / 0.2e1 * t167 * t496 * t1646 - t1651;
  t1660 = t137 * t51;
  t1667 = t512 * t540;
  t1669 = t160 * t51;
  t1682 = t366 * t546;
  t1691 = -0.9e1 * t126 * t502 * t1646 + 0.3e1 / 0.2e1 * t167 * t517 * t539 + 0.9e1 / 0.8e1 * t534 * t164 * t1660 + 0.3e1 / 0.4e1 * t167 * t174 * t1433 - 0.12002e0 * t1667 + 0.3e1 / 0.4e1 * t167 * t174 * t1669 + 0.3e1 * t126 * t496 * t1438 + 0.3e1 / 0.4e1 * t167 * t184 * t1660 + 0.3e1 * t126 * t192 * t1433 - 0.48008e0 * t1682 + 0.3e1 * t126 * t192 * t1669 - t486 * t34 * t36 * t137 / 0.6e1;
  t1693 = t551 * t43 * t141;
  t1694 = t1693 * t488;
  t1696 = t552 * t376;
  t1697 = t1696 * t493;
  t1706 = t103 * t197 * t198 * t108 * t51;
  t1712 = t18 * t146 * t31 * t198 * t108 * t71;
  t1714 = t414 * t62;
  t1719 = t55 * t382;
  t1729 = t122 * t147;
  t1734 = 0.26671111111111111111e-1 * t1694 - 0.10668444444444444444e0 * t1697 + 0.2e1 / 0.3e1 * t491 * t34 * t36 * t160 + t1706 / 0.18e2 - 0.2e1 / 0.9e1 * t1712 + t1714 * t34 * t36 * t118 / 0.12e2 - 0.2e1 * t1719 * t34 * t36 * t148 - 0.80013333333333333323e-1 * t1452 - 0.24004e0 * t1454 - 0.60009999999999999999e-1 * t1466 + 0.60009999999999999999e-1 * t1470 + 0.12002e0 * t1472 + 0.2e1 / 0.3e1 * t1729 * t34 * t487 * t71;
  tv4rho41 = t1510 + t1545 + t1580 + t1608 + t1624 + t1652 + t1691 + t1734;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1737 = t42 * t561;
  t1738 = t103 * t1737;
  t1742 = t146 * t203;
  t1749 = t146 * t210;
  t1772 = t512 * t615;
  t1774 = t61 * t561;
  t1780 = t366 * t619;
  t1782 = t1738 - 0.15e2 / 0.16e2 * t1502 * t575 * t118 - t167 * t1742 * t148 / 0.2e1 + 0.3e1 / 0.8e1 * t534 * t578 * t118 + t126 * t1749 * t148 - t167 * t581 * t118 / 0.2e1 + 0.24e2 * t92 * t1330 * t215 * t148 + t167 * t584 * t118 / 0.4e1 - 0.6e1 * t92 * t381 * t224 * t148 - t167 * t1737 * t51 / 0.2e1 - t167 * t578 * t137 / 0.4e1 + 0.40006666666666666666e-1 * t1772 - t126 * t1774 * t71 - t126 * t618 * t160 / 0.2e1 + 0.80013333333333333332e-1 * t1780;
  t1785 = t366 * t622;
  t1790 = t243 * t626;
  t1795 = t366 * t629;
  t1800 = t243 * t633;
  t1805 = t1483 * t601;
  t1810 = t512 * t605;
  t1815 = t512 * t608;
  t1817 = t964 * t51;
  t1818 = t1560 * t1817;
  t1819 = t126 * t581 * t137 - 0.16002666666666666667e0 * t1785 - 0.6e1 * t92 * t625 * t160 + 0.96016000000000000001e0 * t1790 - t126 * t584 * t137 / 0.2e1 + 0.80013333333333333332e-1 * t1795 + 0.2e1 * t92 * t632 * t160 - 0.32005333333333333334e0 * t1800 + 0.3e1 / 0.8e1 * t534 * t575 * t137 - 0.6001e-1 * t1805 + t167 * t604 * t160 / 0.4e1 - 0.40006666666666666666e-1 * t1810 - t167 * t164 * t468 / 0.2e1 + 0.80013333333333333332e-1 * t1815 + t1818;
  t1821 = t964 * t71;
  t1822 = t1564 * t1821;
  t1824 = t1451 * t208;
  t1828 = t366 * t611;
  t1841 = 0.4e1 * t1822 - 0.26671111111111111107e-1 * t1824 - t126 * t1538 * t84 + 0.16002666666666666667e0 * t1828 - 0.26671111111111111109e-1 * t1481 - 0.60009999999999999999e-1 * t1484 - 0.53342222222222222214e-1 * t1486 - 0.16002666666666666666e0 * t1488 - 0.53342222222222222227e-1 * t1494 - 0.40006666666666666668e-1 * t1496 + 0.2133688888888888889e0 * t1498 + 0.96016000000000000002e0 * t1500 + 0.80013333333333333332e-1 * t1527 + 0.40006666666666666666e-1 * t1532 + 0.16002666666666666666e0 * t1534;
  t1846 = t18 * t633;
  t1854 = t122 * t56 * t561;
  t1856 = t108 * t146;
  t1858 = t106 * t1856 * t215;
  t1861 = t106 * t407 * t224;
  t1863 = t392 * t615;
  t1865 = t103 * t619;
  t1866 = t103 * t622;
  t1868 = t18 * t626;
  t1870 = t103 * t629;
  t1871 = t178 * t178;
  t1875 = 0.80013333333333333332e-1 * t1536 + 0.80013333333333333335e-1 * t1553 - 0.32005333333333333334e0 * t1555 + t1562 + 0.4e1 * t1566 + 0.4e1 * t1846 + t44 * t45 * (0.24e2 * t134 - t1367) / 0.2e1 - 0.80013333333333333332e-1 * t1854 + 0.5334222222222222222e-1 * t1858 - 0.26671111111111111107e-1 * t1861 - t1863 / 0.2e1 - t1865 + 0.2e1 * t1866 - 0.12e2 * t1868 - t1870 - t117 * t45 * t1871 / 0.2e1;
  t1878 = t103 * t611;
  t1881 = t1350 * t109 * t203;
  t1884 = t398 * t109 * t210;
  t1886 = t1424 * t601;
  t1888 = t392 * t605;
  t1890 = t392 * t608;
  t1897 = -0.2e1 * t1878 - 0.6667777777777777778e-2 * t1881 + 0.13335555555555555555e-1 * t1884 + 0.3e1 / 0.4e1 * t1886 + t1888 / 0.2e1 - t1890 - t1568 - 0.2e1 * t1570 - 0.12e2 * t1572 + 0.12446518518518518518e0 * t1575 - 0.80013333333333333332e-1 * t1578 - t1586 - t1588 + 0.4e1 * t1590 + 0.3e1 / 0.4e1 * t1592;
  t1918 = 0.2e1 * t1594 - 0.62232592592592592583e-1 * t1597 + t1599 / 0.2e1 + 0.53342222222222222214e-1 * t1323 - 0.62232592592592592585e-1 * t1344 + 0.53342222222222222214e-1 * t1606 - t1611 / 0.2e1 - 0.6667777777777777777e-2 * t1352 + 0.12446518518518518517e0 * t1356 + 0.13335555555555555554e-1 * t1409 - 0.26671111111111111107e-1 * t1416 + t1626 + t1432 + t167 * t618 * t539 / 0.2e1 - 0.6e1 * t126 * t625 * t539 + 0.2e1 * t126 * t632 * t539;
  t1920 = t84 * t137;
  t1924 = t84 * t160;
  t1929 = t31 * t31;
  t1931 = t33 * t33;
  t1939 = t51 * t178;
  t1943 = t71 * t178;
  t1951 = t512 * t638;
  t1953 = t366 * t642;
  t1956 = t84 * t118;
  t1960 = t84 * t148;
  t1966 = t167 * t174 * t1920 / 0.2e1 + 0.2e1 * t126 * t496 * t1924 + 0.16e2 / 0.81e2 * t552 * t17 * t146 * t1929 * t1931 * t35 - 0.3e1 / 0.4e1 * t534 * t604 * t539 + 0.3e1 / 0.2e1 * t534 * t164 * t1939 + t167 * t174 * t1943 + t167 * t517 * t637 + 0.4e1 * t126 * t1490 * t641 - 0.80013333333333333332e-1 * t1951 - 0.32005333333333333334e0 * t1953 - 0.94830617283950617285e-1 * t1637 - 0.3e1 / 0.4e1 * t534 * t174 * t1956 - 0.6e1 * t126 * t1506 * t1960 + 0.14e2 / 0.81e2 * t1650 - 0.80013333333333333332e-1 * t1667;
  t1969 = t103 * t174 * t158;
  t1975 = t1693 * t594;
  t1978 = t18 * t192 * t158;
  t1980 = t1696 * t598;
  t1982 = t117 * t147;
  t1997 = t198 * t51;
  t2001 = t198 * t71;
  t2005 = -0.32005333333333333334e0 * t1682 + t1969 / 0.27e2 - 0.2e1 / 0.9e1 * t486 * t178 * t31 * t198 + 0.17780740740740740741e-1 * t1975 - 0.4e1 / 0.27e2 * t1978 - 0.71122962962962962963e-1 * t1980 - 0.2e1 * t1982 * t964 * t539 + 0.17780740740740740741e-1 * t1694 - 0.71122962962962962964e-1 * t1697 + t1706 / 0.27e2 - 0.4e1 / 0.27e2 * t1712 - 0.26671111111111111108e-1 * t1452 + 0.4e1 / 0.9e1 * t1729 * t637 * t885 - 0.8e1 / 0.3e1 * t1719 * t641 * t885 + t1714 * t593 * t1997 / 0.9e1 + 0.4e1 / 0.9e1 * t1729 * t593 * t2001;
  tv4rho42 = t1782 + t1819 + t1841 + t1875 + t1897 + t1918 + t1966 + t2005;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t2008 = t61 * t695;
  t2009 = t18 * t2008;
  t2010 = t42 * t649;
  t2011 = t1424 * t2010;
  t2013 = t381 * t665;
  t2014 = t18 * t2013;
  t2016 = t42 * t683;
  t2017 = t103 * t2016;
  t2026 = t512 * t656;
  t2031 = t61 * t683;
  t2038 = t366 * t687;
  t2040 = -t2009 + 0.3e1 / 0.8e1 * t2011 - 0.6e1 * t2014 + t2017 / 0.2e1 + 0.3e1 / 0.2e1 * t1738 - 0.3e1 / 0.4e1 * t167 * t453 * t210 - 0.3e1 / 0.4e1 * t167 * t164 * t561 + 0.6001e-1 * t2026 - t167 * t2016 * t51 / 0.4e1 - t126 * t2031 * t71 / 0.2e1 + 0.3e1 * t126 * t1490 * t215 - 0.24004e0 * t2038;
  t2051 = t366 * t659;
  t2056 = t366 * t662;
  t2065 = t243 * t669;
  t2070 = t61 * t649;
  t2077 = t512 * t653;
  t2079 = -t126 * t2008 * t51 / 0.2e1 + 0.2e1 * t92 * t146 * t695 * t71 - 0.3e1 / 0.2e1 * t126 * t1774 * t84 + 0.12002e0 * t2051 - 0.3e1 / 0.2e1 * t126 * t517 * t224 + 0.12002e0 * t2056 - 0.3e1 * t126 * t2013 * t51 + 0.24e2 * t92 * t1330 * t665 * t71 - 0.48008e0 * t2065 - 0.15e2 / 0.16e2 * t1502 * t2010 * t51 - 0.3e1 / 0.8e1 * t534 * t2070 * t71 + 0.9e1 / 0.8e1 * t534 * t575 * t178 - 0.6001e-1 * t2077;
  t2093 = 0.6001e-1 * t1772 + 0.12002e0 * t1780 - 0.24004e0 * t1785 + 0.144024e1 * t1790 + 0.12002e0 * t1795 - 0.48008e0 * t1800 - 0.90014999999999999998e-1 * t1805 - 0.60009999999999999999e-1 * t1810 + 0.12002e0 * t1815 + 0.3e1 / 0.2e1 * t1818 + 0.6e1 * t1822 - 0.8001333333333333333e-1 * t1824;
  t2099 = t103 * t659;
  t2101 = t103 * t687;
  t2103 = t103 * t662;
  t2105 = t18 * t669;
  t2107 = t392 * t653;
  t2109 = t392 * t656;
  t2112 = t55 * t141 * t695;
  t2118 = 0.24004e0 * t1828 - 0.2000333333333333333e-1 * t1481 - 0.40006666666666666661e-1 * t1486 - 0.40006666666666666665e-1 * t1494 + 0.16002666666666666666e0 * t1498 - 0.3e1 / 0.2e1 * t2099 + 0.3e1 * t2101 - 0.3e1 / 0.2e1 * t2103 + 0.6e1 * t2105 + 0.3e1 / 0.4e1 * t2107 - 0.3e1 / 0.4e1 * t2109 + 0.80013333333333333333e-1 * t2112 + t44 * t45 * (-t1581 - t1367) / 0.2e1;
  t2122 = t122 * t56 * t683;
  t2125 = t55 * t1325 * t665;
  t2128 = t1346 * t56 * t649;
  t2139 = -0.40006666666666666666e-1 * t2122 + 0.48008e0 * t2125 - 0.30005e-1 * t2128 + 0.6e1 * t1846 - 0.12002e0 * t1854 + 0.16002666666666666668e0 * t1858 - 0.8001333333333333333e-1 * t1861 - 0.3e1 / 0.4e1 * t1863 - 0.3e1 / 0.2e1 * t1865 + 0.3e1 * t1866 - 0.18e2 * t1868 - 0.3e1 / 0.2e1 * t1870;
  t2154 = -0.3e1 * t1878 - 0.20003333333333333332e-1 * t1881 + 0.4000666666666666667e-1 * t1884 + 0.9e1 / 0.8e1 * t1886 + 0.3e1 / 0.4e1 * t1888 - 0.3e1 / 0.2e1 * t1890 + 0.18669777777777777777e0 * t1575 - 0.93348888888888888876e-1 * t1597 - 0.31116296296296296292e-1 * t1344 + 0.40006666666666666661e-1 * t1606 + 0.62232592592592592583e-1 * t1356 + t1432 - 0.9e1 / 0.8e1 * t534 * t604 * t637;
  t2159 = t84 * t178;
  t2163 = t210 * t51;
  t2167 = t210 * t71;
  t2177 = t224 * t51;
  t2181 = t224 * t71;
  t2191 = t215 * t51;
  t2195 = t215 * t71;
  t2199 = -0.3e1 / 0.2e1 * t167 * t1742 * t641 + 0.3e1 / 0.2e1 * t167 * t174 * t2159 + 0.9e1 / 0.8e1 * t534 * t164 * t2163 + 0.3e1 / 0.4e1 * t167 * t174 * t2167 + 0.3e1 / 0.4e1 * t167 * t618 * t637 + 0.3e1 * t126 * t1749 * t641 + 0.3e1 / 0.4e1 * t167 * t174 * t2177 + 0.3e1 * t126 * t496 * t2181 + 0.3e1 * t126 * t192 * t2177 - 0.18e2 * t92 * t502 * t2181 - 0.3e1 / 0.2e1 * t167 * t496 * t2191 - 0.9e1 * t126 * t1506 * t2195;
  t2226 = -0.12002e0 * t1951 - 0.48008e0 * t1953 - 0.71122962962962962963e-1 * t1637 - t1651 + t1714 * t203 * t31 * t198 / 0.12e2 - t486 * t210 * t31 * t198 / 0.6e1 - 0.2e1 * t1719 * t215 * t31 * t198 + 0.2e1 / 0.3e1 * t491 * t34 * t36 * t224 + t1969 / 0.18e2 + 0.26671111111111111111e-1 * t1975 - 0.2e1 / 0.9e1 * t1978 - 0.10668444444444444445e0 * t1980 + 0.2e1 / 0.3e1 * t1729 * t964 * t885;
  tv4rho43 = t2040 + t2079 + t2093 + t2118 + t2139 + t2154 + t2199 + t2226;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t2256 = -0.4e1 * t2009 + 0.3e1 / 0.2e1 * t2011 - 0.24e2 * t2014 + 0.2e1 * t2017 - 0.3e1 * t167 * t1742 * t215 + 0.6e1 * t126 * t1749 * t215 + 0.8e1 * t92 * t192 * t695 - t167 * t164 * t683 - 0.2e1 * t126 * t2031 * t84 - 0.3e1 * t126 * t618 * t224 - 0.2e1 * t126 * t174 * t695 - 0.12e2 * t126 * t2013 * t75;
  t2277 = -0.36e2 * t92 * t625 * t224 - 0.3e1 / 0.2e1 * t534 * t2070 * t84 + 0.9e1 / 0.4e1 * t534 * t575 * t210 + 0.3e1 / 0.2e1 * t167 * t604 * t224 + 0.24004e0 * t2026 - 0.96016e0 * t2038 + 0.48008e0 * t2051 + 0.48008e0 * t2056 - 0.192032e1 * t2065 - 0.24004e0 * t2077 - 0.16002666666666666666e0 * t1824 - 0.6e1 * t2099;
  t2291 = 0.12e2 * t2101 - 0.6e1 * t2103 + 0.24e2 * t2105 + 0.3e1 * t2107 - 0.3e1 * t2109 + 0.32005333333333333333e0 * t2112 - 0.16002666666666666667e0 * t2122 + 0.192032e1 * t2125 - 0.12002e0 * t2128 + 0.32005333333333333334e0 * t1858 - 0.16002666666666666666e0 * t1861 - 0.40006666666666666662e-1 * t1881;
  t2295 = t84 * t210;
  t2299 = t224 * t84;
  t2307 = t690 * rho[1];
  t2309 = 0.1e1 / t26 / t2307;
  t2315 = t224 * t224;
  t2319 = t210 * t210;
  t2323 = t215 * t215;
  t2327 = t203 * t203;
  t2331 = 0.80013333333333333331e-1 * t1884 + 0.24893037037037037035e0 * t1575 - 0.12446518518518518517e0 * t1597 + t1432 + 0.3e1 * t167 * t174 * t2295 + 0.12e2 * t126 * t496 * t2299 + t44 * t45 * (-t1361 - t1363 - t1367) / 0.2e1 - t59 * t62 * (0.40444444444444444444e2 * t25 * t2309 + t1384) + 0.6e1 * t59 * t147 * t2315 - 0.3e1 / 0.4e1 * t117 * t45 * t2319 + 0.24e2 * t59 * t1331 * t2323 - 0.15e2 / 0.16e2 * t1397 * t45 * t2327;
  tv4rho44 = t2256 + t2277 + t2291 + t2331;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t2334 = t403 * t8 * t89;
  t2335 = 0.31116296296296296297e-1 * t2334;
  t2336 = t302 * t388;
  t2337 = 0.18003e0 * t2336;
  t2338 = t325 * t137;
  t2339 = t710 * t2338;
  t2341 = t325 * t160;
  t2342 = t714 * t2341;
  t2344 = t720 * t251;
  t2346 = t865 * t360;
  t2347 = 0.2250375e-1 * t2346;
  t2348 = t865 * t363;
  t2349 = 0.2250375e-1 * t2348;
  t2350 = t703 * t370;
  t2351 = 0.450075e-1 * t2350;
  t2352 = t703 * t373;
  t2353 = 0.450075e-1 * t2352;
  t2354 = t122 * t88;
  t2355 = t2354 * t128;
  t2356 = 0.30005000000000000001e-1 * t2355;
  t2357 = t703 * t447;
  t2358 = 0.90015e-1 * t2357;
  t2359 = t325 * t118;
  t2360 = t1560 * t2359;
  t2362 = t1105 * t51;
  t2363 = t710 * t2362;
  t2365 = t18 * t381;
  t2366 = t325 * t148;
  t2367 = t2365 * t2366;
  t2369 = -t2335 + t2337 - 0.675e0 * t2339 + 0.27e1 * t2342 + 0.48007999999999999997e-1 * t2344 + t2347 - t2349 - t2351 - t2353 + t2356 + t2358 + 0.3375e0 * t2360 + 0.18e1 * t2363 - 0.81e1 * t2367;
  t2370 = t1105 * t71;
  t2371 = t714 * t2370;
  t2373 = t106 * t403;
  t2375 = 0.28004666666666666667e-1 * t2373 * t95;
  t2376 = t243 * t738;
  t2385 = t1564 * t746;
  t2387 = t1451 * t240;
  t2389 = t720 * t248;
  t2395 = t366 * t724;
  t2397 = t243 * t735;
  t2411 = -0.72e1 * t2371 + t2375 + 0.336056e0 * t2376 + 0.46666666666666666667e1 * t92 * t94 * t437 + 0.108e2 * t92 * t753 * t65 * t148 + 0.27e1 * t2385 - 0.18003e-1 * t2387 + 0.72012e-1 * t2389 - 0.225e0 * t126 * t94 * t22 * t428 + 0.54009e-1 * t2395 - 0.216036e0 * t2397 + 0.9e0 * t92 * t246 * t22 * t443 - 0.21e1 * t126 * t94 * t154 * t51 + 0.84e1 * t92 * t246 * t154 * t71;
  t2417 = t512 * t742;
  t2419 = t366 * t750;
  t2421 = t243 * t755;
  t2423 = t243 * t759;
  t2437 = t1330 * t93;
  t2448 = t122 * t376;
  t2449 = t2448 * t746;
  t2457 = 0.9e0 * t126 * t94 * t65 * t137 - 0.270045e-1 * t2417 - 0.144024e0 * t2419 + 0.648108e0 * t2421 + 0.576096e0 * t2423 - 0.36e1 * t92 * t246 * t65 * t160 - 0.16875e0 * t534 * t94 * t22 * t355 - 0.45e0 * t167 * t94 * t65 * t118 + 0.108e2 * t92 * t2437 * t22 * t383 + 0.3375e0 * t848 * t325 * t1660 + 0.135e1 * t745 * t325 * t1433 - 0.216036e0 * t2449 + 0.135e1 * t745 * t325 * t1669 - 0.81e1 * t861 * t325 * t1438;
  t2461 = t44 * t382;
  t2468 = t55 * t772;
  t2469 = 0.30005000000000000001e-1 * t2468;
  t2471 = t229 * t89 * t428;
  t2472 = 0.150025e-1 * t2471;
  t2474 = t87 * t233 * t443;
  t2475 = 0.30005e-1 * t2474;
  t2476 = t1450 * t230;
  t2477 = 0.20003333333333333334e-1 * t2476;
  t2478 = t762 * t234;
  t2479 = 0.40006666666666666668e-1 * t2478;
  t2480 = t122 * t769;
  t2481 = 0.150025e-1 * t2480;
  t2482 = t88 * t381;
  t2484 = t87 * t2482 * t383;
  t2485 = 0.18003e0 * t2484;
  t2486 = t18 * t738;
  t2488 = t414 * t700;
  t2489 = 0.75012500000000000002e-2 * t2488;
  t2490 = t37 * t353;
  t2492 = t2490 * t89 * t355;
  t2493 = 0.11251875e-1 * t2492;
  t2494 = t55 * t707;
  t2495 = 0.60010000000000000001e-1 * t2494;
  t2496 = -0.675e0 * t1982 * t325 * t1639 - 0.405e1 * t2461 * t325 * t1646 - 0.36e1 * t745 * t1105 * t539 + t2469 + t2472 - t2475 + t2477 - t2479 - t2481 - t2485 - 0.42e1 * t2486 + t2489 + t2493 - t2495;
  tv4rho3sigma0 = t2369 + t2411 + t2457 + t2496;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t2501 = 0.62232592592592592592e-1 * t2334;
  tv4rho3sigma1 = 0.60009999999999999999e-1 * t2468 + 0.30005e-1 * t2471 - 0.6001e-1 * t2474 - t2501 + 0.40006666666666666667e-1 * t2476 - 0.80013333333333333332e-1 * t2478 - 0.30005e-1 * t2480 - 0.36006e0 * t2484 + 0.36006e0 * t2336 + 0.15002499999999999999e-1 * t2488 + 0.2250375e-1 * t2492 + 0.450075e-1 * t2346 - 0.450075e-1 * t2348 - 0.90015e-1 * t2350 - 0.90015e-1 * t2352 - 0.12002e0 * t2494 + 0.60009999999999999999e-1 * t2355 + 0.18003e0 * t2357;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t2517 = t710 * t324 * t137;
  t2520 = t714 * t324 * t160;
  t2523 = t1560 * t324 * t118;
  t2526 = t2365 * t324 * t148;
  t2529 = 0.28004666666666666667e-1 * t2373 * t100;
  t2530 = t243 * t813;
  t2536 = t1330 * t98;
  t2541 = t1564 * t808;
  t2543 = t1451 * t260;
  t2545 = t720 * t267;
  t2551 = -t2335 - 0.675e0 * t2517 + 0.27e1 * t2520 + 0.3375e0 * t2523 - 0.81e1 * t2526 + t2529 + t2337 + t2347 - t2349 - t2351 - t2353 + t2356 + t2358 + 0.648108e0 * t2530 - 0.16875e0 * t534 * t99 * t28 * t355 + 0.108e2 * t92 * t2536 * t28 * t383 + 0.27e1 * t2541 - 0.18003e-1 * t2543 + 0.72012e-1 * t2545 - 0.225e0 * t126 * t99 * t28 * t428;
  t2552 = t366 * t793;
  t2554 = t243 * t801;
  t2560 = t512 * t805;
  t2562 = t2448 * t808;
  t2583 = 0.135e1 * t745 * t324 * t1433 + t2469 + t2472 - t2475 + t2477 - t2479 - t2481 - t2485 + t2489 + t2493 - t2495;
  tv4rho3sigma2 = t2551 + 0.54009e-1 * t2552 - 0.216036e0 * t2554 + 0.9e0 * t92 * t265 * t28 * t443 - 0.270045e-1 * t2560 - 0.216036e0 * t2562 + 0.135e1 * t745 * t324 * t1669 - 0.81e1 * t861 * t324 * t1438 - 0.675e0 * t1982 * t324 * t1639 - 0.405e1 * t2461 * t324 * t1646 + 0.3375e0 * t848 * t324 * t1660 + t2583;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t2586 = t414 * t88 * t168;
  t2587 = 0.50008333333333333333e-2 * t2586;
  t2588 = t2354 * t175;
  t2589 = 0.10001666666666666667e-1 * t2588;
  t2590 = t865 * t506;
  t2591 = 0.150025e-1 * t2590;
  t2592 = t865 * t509;
  t2593 = 0.750125e-2 * t2592;
  t2594 = t703 * t518;
  t2595 = 0.30005e-1 * t2594;
  t2596 = t703 * t521;
  t2597 = 0.150025e-1 * t2596;
  t2598 = t2490 * t88;
  t2599 = t2598 * t535;
  t2600 = 0.11251875e-1 * t2599;
  t2601 = t703 * t497;
  t2602 = 0.30005e-1 * t2601;
  t2603 = t865 * t499;
  t2604 = 0.750125e-2 * t2603;
  t2605 = t302 * t503;
  t2606 = 0.18003e0 * t2605;
  t2607 = -t2335 + t2587 + t2589 - t2591 - t2593 - t2595 - t2597 + t2600 + t2602 + t2604 - t2606;
  t2608 = t1105 * t75;
  t2610 = 0.6e0 * t710 * t2608;
  t2611 = t1105 * t84;
  t2613 = 0.24e1 * t714 * t2611;
  t2614 = t325 * t178;
  t2616 = 0.45e0 * t710 * t2614;
  t2617 = t2354 * t186;
  t2618 = 0.10001666666666666667e-1 * t2617;
  t2619 = t1040 * t193;
  t2620 = 0.40006666666666666667e-1 * t2619;
  t2621 = t703 * t524;
  t2622 = 0.150025e-1 * t2621;
  t2623 = t302 * t531;
  t2624 = 0.6001e-1 * t2623;
  t2628 = 0.10001666666666666667e-1 * t2355;
  t2630 = t2610 - t2613 - t2616 + t2618 - t2620 - t2622 + t2624 - 0.225e0 * t2339 + 0.9e0 * t2342 + 0.32005333333333333334e-1 * t2344 + t2628 + 0.1125e0 * t2360;
  t2637 = t552 * t88 * t199;
  t2638 = 0.10001666666666666667e-1 * t2637;
  t2639 = t703 * t546;
  t2640 = 0.6001e-1 * t2639;
  t2642 = 0.225e0 * t1560 * t850;
  t2644 = 0.9e0 * t1564 * t854;
  t2645 = t1451 * t277;
  t2651 = 0.6e0 * t2363 - 0.27e1 * t2367 - 0.24e1 * t2371 + t2375 + 0.11201866666666666667e0 * t2376 + t2638 + t2640 + t2642 + t2644 - 0.6001e-2 * t2645 - 0.225e0 * t126 * t94 * t22 * t468;
  t2653 = 0.36006e-1 * t366 * t823;
  t2655 = 0.9e0 * t1564 * t858;
  t2657 = 0.54e1 * t2365 * t862;
  t2658 = t720 * t281;
  t2665 = 0.48008e-1 * t366 * t831;
  t2667 = 0.192032e0 * t243 * t835;
  t2676 = t865 * t540;
  t2677 = 0.150025e-1 * t2676;
  t2680 = t2653 + t2655 - t2657 + 0.24004e-1 * t2658 + 0.6e0 * t126 * t94 * t65 * t178 - t2665 + t2667 - 0.7e0 * t126 * t94 * t154 * t75 + 0.28e1 * t92 * t246 * t154 * t84 + t2677 + 0.9e0 * t2385 - 0.12002e-1 * t2387;
  t2698 = 0.16002666666666666667e-1 * t1696 * t886;
  t2699 = 0.48008e-1 * t2389 + 0.18003e-1 * t2395 - 0.72012e-1 * t2397 - 0.90015e-2 * t2417 - 0.48008e-1 * t2419 + 0.216036e0 * t2421 + 0.192032e0 * t2423 + 0.45e0 * t745 * t325 * t1920 - 0.27e1 * t861 * t325 * t1924 - 0.72012e-1 * t2449 - t2698;
  t2711 = 0.3333333333333333333e-1 * t762 * t147 * t886;
  t2713 = t122 * t147 * t93;
  t2714 = t22 * t31;
  t2719 = t55 * t382 * t93;
  t2724 = t817 * t43 * t233;
  t2725 = t2724 * t488;
  t2726 = 0.33338888888888888888e-2 * t2725;
  t2727 = t818 * t706;
  t2728 = t2727 * t493;
  t2729 = 0.13335555555555555556e-1 * t2728;
  t2736 = t414 * t141;
  t2738 = 0.18003e-1 * t2736 * t850;
  t2740 = 0.72012e-1 * t2448 * t854;
  t2741 = -0.45e0 * t1982 * t325 * t1561 - 0.27e1 * t2461 * t325 * t1565 - 0.26666666666666666666e0 * t491 * t1105 * t885 - t2711 + 0.1e0 * t2713 * t2714 * t1997 - 0.6e0 * t2719 * t2714 * t2001 - t2726 + t2729 + 0.225e0 * t848 * t325 * t1939 + 0.9e0 * t745 * t325 * t1943 - t2738 - t2740;
  t2744 = 0.72012e-1 * t2448 * t858;
  t2745 = t55 * t1325;
  t2747 = 0.432072e0 * t2745 * t862;
  t2748 = t75 * t137;
  t2752 = t75 * t160;
  t2756 = t354 * t62;
  t2757 = t75 * t118;
  t2764 = t75 * t148;
  t2777 = t59 * t1331;
  t2781 = -t2744 + t2747 + 0.1125e0 * t848 * t325 * t2748 + 0.45e0 * t745 * t325 * t2752 - 0.16875e0 * t2756 * t325 * t2757 - 0.3e0 * t848 * t1105 * t849 - 0.135e1 * t2461 * t325 * t2764 - 0.12e1 * t745 * t1105 * t853 - 0.225e0 * t1982 * t325 * t1956 - 0.12e1 * t745 * t1105 * t637 + 0.108e2 * t2777 * t325 * t1960;
  t2785 = 0.10001666666666666667e-1 * t2468;
  t2786 = 0.13335555555555555556e-1 * t2476;
  t2787 = 0.26671111111111111112e-1 * t2478;
  t2788 = 0.50008333333333333335e-2 * t2480;
  t2790 = 0.25004166666666666668e-2 * t2488;
  t2791 = 0.20003333333333333334e-1 * t2494;
  t2792 = t762 * t273;
  t2793 = 0.13335555555555555556e-1 * t2792;
  t2794 = t1450 * t270;
  t2795 = 0.66677777777777777777e-2 * t2794;
  t2797 = t229 * t89 * t468;
  t2798 = 0.150025e-1 * t2797;
  t2799 = t122 * t838;
  t2800 = 0.10001666666666666667e-1 * t2799;
  t2801 = 0.72e1 * t861 * t1105 * t641 + t2785 + t2786 - t2787 - t2788 - 0.14e1 * t2486 + t2790 - t2791 - t2793 + t2795 + t2798 - t2800;
  tv4rho3sigma3 = t2607 + t2630 + t2651 + t2680 + t2699 + t2741 + t2781 + t2801;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  t2814 = 0.20003333333333333333e-1 * t2617;
  t2818 = -t2501 + 0.10001666666666666667e-1 * t2586 + 0.20003333333333333334e-1 * t2588 - 0.30005e-1 * t2590 - 0.150025e-1 * t2592 - 0.6001e-1 * t2594 - 0.30005e-1 * t2596 + 0.2250375e-1 * t2599 + 0.6001e-1 * t2601 + 0.150025e-1 * t2603 - 0.36006e0 * t2605 + t2814 - 0.80013333333333333333e-1 * t2619 - 0.30005e-1 * t2621 + 0.12002e0 * t2623;
  t2832 = 0.13335555555555555556e-1 * t2794;
  t2835 = 0.20003333333333333332e-1 * t2355 + 0.20003333333333333334e-1 * t2637 + 0.12002e0 * t2639 + 0.30005e-1 * t2676 - 0.66677777777777777778e-2 * t2725 + 0.26671111111111111112e-1 * t2728 + 0.20003333333333333333e-1 * t2468 + 0.26671111111111111111e-1 * t2476 - 0.53342222222222222222e-1 * t2478 - 0.10001666666666666666e-1 * t2480 + 0.5000833333333333333e-2 * t2488 - 0.40006666666666666666e-1 * t2494 - 0.26671111111111111111e-1 * t2792 + t2832 + 0.30005e-1 * t2797 - 0.20003333333333333334e-1 * t2799;
  tv4rho3sigma4 = t2818 + t2835;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t2838 = 0.6e0 * t710 * t1179 * t51;
  t2841 = 0.24e1 * t714 * t1179 * t71;
  t2842 = t720 * t294;
  t2846 = 0.45e0 * t710 * t324 * t178;
  t2851 = -t2335 + t2838 - t2841 + 0.16002666666666666667e-1 * t2842 - t2846 + t2587 + t2589 - t2591 - t2593 - t2595 - t2597 + t2600 + t2602 + t2604 - t2606 - 0.225e0 * t2517 + 0.9e0 * t2520 + 0.1125e0 * t2523 - 0.27e1 * t2526 + t2529;
  t2862 = t28 * t31;
  t2866 = 0.3333333333333333333e-1 * t18 * t265 * t2862 * t198 * t108;
  t2868 = 0.16002666666666666667e-1 * t1696 * t943;
  t2875 = t147 * t98;
  t2876 = t122 * t2875;
  t2880 = 0.48008e-1 * t2545 + 0.18003e-1 * t2552 - 0.72012e-1 * t2554 + t2677 - 0.90015e-2 * t2560 - 0.72012e-1 * t2562 - t2866 - t2868 - 0.45e0 * t1982 * t324 * t1561 - 0.27e1 * t2461 * t324 * t1565 + 0.1e0 * t2876 * t2862 * t1997;
  t2883 = t382 * t98;
  t2884 = t55 * t2883;
  t2889 = 0.225e0 * t1560 * t919;
  t2891 = 0.9e0 * t1564 * t923;
  t2892 = t1451 * t287;
  t2899 = 0.36006e-1 * t366 * t901;
  t2901 = 0.9e0 * t1564 * t926;
  t2903 = 0.54e1 * t2365 * t929;
  t2904 = t720 * t291;
  t2912 = 0.48008e-1 * t366 * t909;
  t2918 = 0.192032e0 * t243 * t913;
  t2934 = 0.18003e-1 * t2736 * t919;
  t2936 = 0.72012e-1 * t2448 * t923;
  t2937 = -t2912 - 0.12e1 * t92 * t265 * t81 * t160 + t2918 - 0.15e0 * t167 * t99 * t81 * t118 + 0.36e1 * t92 * t811 * t81 * t148 - t2726 + t2729 + 0.225e0 * t848 * t324 * t1939 + 0.9e0 * t745 * t324 * t1943 - t2934 - t2936;
  t2940 = 0.72012e-1 * t2448 * t926;
  t2942 = 0.432072e0 * t2745 * t929;
  t2971 = 0.108e2 * t2777 * t324 * t1960 + t2785 + t2786 - t2787 - t2788 + t2790 - t2791 - t2793 + t2795 + t2798 - t2800;
  tv4rho3sigma5 = t2971 - 0.225e0 * t126 * t99 * t28 * t468 + 0.3e0 * t126 * t99 * t81 * t137 + t2640 + t2638 + t2628 + t2624 - t2620 - t2622 + t2618 + t2942 - t2940 + t2937 - t2903 + 0.24004e-1 * t2904 + t2899 + t2901 + t2891 - 0.6001e-2 * t2892 + t2889 + t2880 + t2851 - 0.6e0 * t2884 * t2862 * t2001 - 0.12e1 * t745 * t1179 * t539 + 0.1125e0 * t848 * t324 * t2748 + 0.45e0 * t745 * t324 * t2752 + 0.45e0 * t745 * t324 * t1920 - 0.27e1 * t861 * t324 * t1924 - 0.16875e0 * t2756 * t324 * t2757 - 0.135e1 * t2461 * t324 * t2764 - 0.225e0 * t1982 * t324 * t1956 + 0.216036e0 * t2530 + 0.9e0 * t2541 - 0.12002e-1 * t2543;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2974 = t325 * t210;
  t2975 = t710 * t2974;
  t2977 = t325 * t224;
  t2978 = t714 * t2977;
  t2980 = t325 * t203;
  t2981 = t1560 * t2980;
  t2983 = t325 * t215;
  t2984 = t2365 * t2983;
  t2986 = t2354 * t208;
  t2987 = 0.10001666666666666667e-1 * t2986;
  t2988 = t703 * t622;
  t2989 = 0.30005e-1 * t2988;
  t2990 = t302 * t626;
  t2991 = 0.18003e0 * t2990;
  t2992 = t865 * t615;
  t2993 = 0.750125e-2 * t2992;
  t2994 = t703 * t619;
  t2995 = 0.150025e-1 * t2994;
  t2996 = t703 * t629;
  t2997 = 0.150025e-1 * t2996;
  t2998 = t302 * t633;
  t2999 = 0.6001e-1 * t2998;
  t3000 = t2598 * t601;
  t3001 = 0.11251875e-1 * t3000;
  t3002 = t865 * t605;
  t3003 = 0.750125e-2 * t3002;
  t3004 = t865 * t608;
  t3005 = 0.150025e-1 * t3004;
  t3006 = t703 * t611;
  t3007 = 0.30005e-1 * t3006;
  t3008 = 0.50008333333333333335e-2 * t2586;
  t3009 = -t2335 - 0.225e0 * t2975 + 0.9e0 * t2978 + 0.1125e0 * t2981 - 0.27e1 * t2984 + t2987 + t2989 - t2991 - t2993 - t2995 - t2997 + t2999 + t3001 + t3003 - t3005 - t3007 + t3008 + t2589 + t2610 - t2613;
  t3010 = 0.40006666666666666668e-1 * t2619;
  t3023 = t2655 - t2657 + 0.48008e-1 * t2658 - t2665 + t2667 - 0.6001e-2 * t2387 + 0.24004e-1 * t2389 - 0.45e0 * t1982 * t325 * t1817 - 0.27e1 * t2461 * t325 * t1821 - t2698 - t2711;
  t3038 = t2724 * t594;
  t3039 = 0.33338888888888888889e-2 * t3038;
  t3040 = t2727 * t598;
  t3041 = 0.13335555555555555556e-1 * t3040;
  t3055 = t203 * t51;
  t3059 = t203 * t71;
  t3063 = t75 * t178;
  t3070 = t2448 * t965;
  t3075 = 0.6667777777777777778e-2 * t2476;
  t3076 = 0.1125e0 * t848 * t325 * t2163 + 0.45e0 * t745 * t325 * t2167 + 0.45e0 * t745 * t325 * t2177 - 0.27e1 * t861 * t325 * t2181 - 0.16875e0 * t2756 * t325 * t3055 - 0.225e0 * t1982 * t325 * t3059 + 0.225e0 * t848 * t325 * t3063 + 0.9e0 * t745 * t325 * t2159 - 0.72012e-1 * t3070 - 0.12e1 * t745 * t1105 * t964 + t3075;
  t3078 = 0.13335555555555555556e-1 * t2478;
  t3079 = 0.26671111111111111112e-1 * t2792;
  t3088 = t366 * t953;
  t3090 = t243 * t957;
  t3092 = t512 * t961;
  t3094 = t243 * t969;
  t3097 = t865 * t638;
  t3098 = 0.150025e-1 * t3097;
  t3099 = t703 * t642;
  t3100 = 0.6001e-1 * t3099;
  t3113 = t1564 * t965;
  t3115 = t55 * t983;
  t3116 = 0.20003333333333333333e-1 * t3115;
  t3117 = t122 * t972;
  t3118 = 0.50008333333333333333e-2 * t3117;
  t3119 = t55 * t975;
  t3120 = 0.10001666666666666667e-1 * t3119;
  t3121 = t414 * t978;
  t3122 = 0.25004166666666666667e-2 * t3121;
  t3124 = t229 * t89 * t561;
  t3125 = 0.150025e-1 * t3124;
  t3126 = t3098 + t3100 + 0.3e0 * t126 * t94 * t65 * t210 - 0.12e1 * t92 * t246 * t65 * t224 - 0.15e0 * t167 * t94 * t65 * t203 + 0.9e0 * t3113 - t3116 - t3118 + t3120 + t3122 + t3125;
  tv4rho3sigma6 = t2747 - t2744 + t3023 - t2800 + 0.16002666666666666667e-1 * t2344 + t3009 - t3010 + 0.36e1 * t92 * t753 * t65 * t215 - 0.225e0 * t126 * t94 * t22 * t561 + t2375 - t2738 - t2740 + t2653 + t2644 - 0.12002e-1 * t2645 + t2642 + t2638 - t3079 - t2616 + t2618 - t3039 + t3041 + t3126 - 0.90015e-2 * t3092 + 0.216036e0 * t3094 + 0.18003e-1 * t3088 - 0.72012e-1 * t3090 + t3076 - t3078 + 0.1e0 * t2713 * t276 * t885 - 0.6e0 * t2719 * t280 * t885 - 0.135e1 * t2461 * t325 * t2191 + 0.108e2 * t2777 * t325 * t2195 + t2832;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  t3142 = -t2501 + 0.20003333333333333333e-1 * t2986 + 0.6001e-1 * t2988 - 0.36006e0 * t2990 - 0.150025e-1 * t2992 - 0.30005e-1 * t2994 - 0.30005e-1 * t2996 + 0.12002e0 * t2998 + 0.2250375e-1 * t3000 + 0.150025e-1 * t3002 - 0.30005e-1 * t3004 - 0.6001e-1 * t3006 + 0.10001666666666666666e-1 * t2586 + 0.20003333333333333333e-1 * t2588 + t2814;
  t3158 = -0.80013333333333333332e-1 * t2619 + 0.20003333333333333333e-1 * t2637 - 0.66677777777777777778e-2 * t3038 + 0.26671111111111111111e-1 * t3040 + t2786 - 0.26671111111111111111e-1 * t2478 - 0.53342222222222222221e-1 * t2792 + 0.26671111111111111111e-1 * t2794 - 0.20003333333333333333e-1 * t2799 + 0.30005e-1 * t3097 + 0.12002e0 * t3099 - 0.40006666666666666667e-1 * t3115 - 0.10001666666666666667e-1 * t3117 + 0.20003333333333333333e-1 * t3119 + 0.50008333333333333333e-2 * t3121 + 0.30005e-1 * t3124;
  tv4rho3sigma7 = t3142 + t3158;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t3160 = t710 * t324 * t210;
  t3163 = t714 * t324 * t224;
  t3166 = t1560 * t324 * t203;
  t3169 = t710 * t1179 * t75;
  t3172 = t2365 * t324 * t215;
  t3175 = t714 * t1179 * t84;
  t3177 = t243 * t1005;
  t3179 = -t2335 - 0.225e0 * t3160 + 0.9e0 * t3163 + 0.1125e0 * t3166 + 0.6e0 * t3169 - 0.27e1 * t3172 - 0.24e1 * t3175 + t2987 + 0.11201866666666666667e0 * t3177 + t2838 - t2841;
  t3181 = t2989 - t2991 - t2993 - t2995 - t2997 + t2999 + t3001 + t3003 - t3005 - t3007 + 0.3200533333333333333e-1 * t2842 - t2846;
  t3194 = t3008 + t2589 + t2529 + t2618 - t3010 + t2638 - 0.6001e-2 * t2543 + 0.24004e-1 * t2545 - 0.45e0 * t1982 * t324 * t1817 - 0.27e1 * t2461 * t324 * t1821 - 0.26666666666666666667e0 * t491 * t1179 * t885;
  t3203 = -t2866 - t2868 - 0.6e0 * t2884 * t290 * t885 + 0.1e0 * t2876 * t286 * t885 + t2889 + t2891 - 0.12002e-1 * t2892 + t2899 + t2901 - t2903 + 0.48008e-1 * t2904 - t2912;
  t3209 = t2448 * t1013;
  t3217 = t2918 - t2934 - t2936 - t2940 + t2942 - t3039 + t3041 + 0.9e0 * t745 * t324 * t2159 - 0.72012e-1 * t3209 - 0.3e0 * t848 * t1179 * t849 - 0.12e1 * t745 * t1179 * t853;
  t3251 = -0.135e1 * t2461 * t324 * t2191 + 0.108e2 * t2777 * t324 * t2195 - 0.12e1 * t745 * t1179 * t637 + 0.72e1 * t861 * t1179 * t641 + 0.1125e0 * t848 * t324 * t2163 + 0.45e0 * t745 * t324 * t2167 + 0.45e0 * t745 * t324 * t2177 - 0.27e1 * t861 * t324 * t2181 - 0.16875e0 * t2756 * t324 * t3055 - 0.225e0 * t1982 * t324 * t3059 + 0.225e0 * t848 * t324 * t3063 + t3075;
  t3253 = t1564 * t1013;
  t3259 = t366 * t998;
  t3261 = t243 * t1002;
  t3267 = -t3078 - t3079 + t2832 - t2800 + t3098 + t3100 + 0.9e0 * t3253 - 0.225e0 * t126 * t99 * t28 * t561 + 0.18003e-1 * t3259 - 0.72012e-1 * t3261 - 0.7e0 * t126 * t99 * t221 * t51;
  t3272 = t512 * t1009;
  t3278 = t366 * t1017;
  t3280 = t243 * t1021;
  t3282 = t243 * t1025;
  t3284 = t18 * t1005;
  t3286 = 0.28e1 * t92 * t265 * t221 * t71 - 0.90015e-2 * t3272 + 0.6e0 * t126 * t99 * t81 * t178 - 0.48008e-1 * t3278 + 0.216036e0 * t3280 + 0.192032e0 * t3282 - t3116 - t3118 + t3120 + t3122 + t3125 - 0.14e1 * t3284;
  tv4rho3sigma8 = t3179 + t3181 + t3194 + t3203 + t3217 + t3251 + t3267 + t3286;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t3289 = t865 * t656;
  t3290 = 0.2250375e-1 * t3289;
  t3291 = t703 * t659;
  t3292 = 0.450075e-1 * t3291;
  t3293 = t703 * t687;
  t3294 = 0.90015e-1 * t3293;
  t3295 = t703 * t662;
  t3296 = 0.450075e-1 * t3295;
  t3297 = t302 * t669;
  t3298 = 0.18003e0 * t3297;
  t3299 = t865 * t653;
  t3300 = 0.2250375e-1 * t3299;
  t3305 = 0.30005000000000000001e-1 * t2986;
  t3309 = t87 * t2482 * t665;
  t3310 = 0.18003e0 * t3309;
  t3312 = t229 * t89 * t683;
  t3313 = 0.150025e-1 * t3312;
  t3315 = t87 * t233 * t695;
  t3316 = 0.30005e-1 * t3315;
  t3318 = t2490 * t89 * t649;
  t3319 = 0.11251875e-1 * t3318;
  t3321 = -t2335 - t3290 - t3292 + t3294 - t3296 + t3298 + t3300 - 0.675e0 * t2975 + 0.27e1 * t2978 + 0.3375e0 * t2981 - 0.81e1 * t2984 + t3305 + t2375 - 0.18003e-1 * t2645 + 0.72012e-1 * t2658 - t3310 + t3313 - t3316 + t3319 - 0.216036e0 * t3070;
  t3322 = 0.40006666666666666668e-1 * t2792;
  t3323 = 0.20003333333333333334e-1 * t2794;
  t3346 = t210 * t75;
  t3353 = t224 * t75;
  t3360 = t203 * t84;
  t3364 = t75 * t215;
  t3368 = 0.60010000000000000001e-1 * t3115;
  t3369 = 0.150025e-1 * t3117;
  t3370 = 0.30005000000000000001e-1 * t3119;
  t3371 = 0.75012500000000000002e-2 * t3121;
  t3372 = -0.16875e0 * t534 * t94 * t22 * t649 + 0.3375e0 * t848 * t325 * t3346 + 0.135e1 * t745 * t325 * t2295 + 0.135e1 * t745 * t325 * t3353 - 0.81e1 * t861 * t325 * t2299 - 0.675e0 * t1982 * t325 * t3360 - 0.405e1 * t2461 * t325 * t3364 - t3368 - t3369 + t3370 + t3371;
  tv4rho3sigma9 = t3321 - t3322 + t3323 + 0.54009e-1 * t3088 - 0.216036e0 * t3090 - 0.270045e-1 * t3092 + 0.648108e0 * t3094 + 0.27e1 * t3113 - 0.225e0 * t126 * t94 * t22 * t683 + 0.9e0 * t92 * t246 * t22 * t695 + 0.108e2 * t92 * t2437 * t22 * t665 + t3372;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.18003e0 * t3293 + 0.30005e-1 * t3312 - 0.6001e-1 * t3315 - 0.90015e-1 * t3295 + 0.36006e0 * t3297 + 0.2250375e-1 * t3318 + 0.450075e-1 * t3299 - 0.36006e0 * t3309 - 0.450075e-1 * t3289 - 0.90015e-1 * t3291 - 0.12002e0 * t3115 - 0.30005e-1 * t3117 + 0.60009999999999999999e-1 * t3119 + 0.15002499999999999999e-1 * t3121 - 0.80013333333333333332e-1 * t2792 + 0.40006666666666666667e-1 * t2794 - t2501 + 0.60009999999999999999e-1 * t2986;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t3400 = -t2335 - t3290 - t3292 + 0.46666666666666666667e1 * t92 * t99 * t692 - 0.675e0 * t3160 + 0.27e1 * t3163 + 0.3375e0 * t3166 + 0.18e1 * t3169 - 0.81e1 * t3172 - 0.72e1 * t3175 + t3294 - t3296 + t3298 + t3300;
  t3407 = t3305 + 0.336056e0 * t3177 + 0.48007999999999999997e-1 * t2842 + t2529 - t3310 + t3313 - t3316 + t3319 - 0.18003e-1 * t2892 + 0.72012e-1 * t2904 - 0.216036e0 * t3209 - t3322 + t3323 + 0.27e1 * t3253;
  t3447 = 0.54009e-1 * t3259 - 0.216036e0 * t3261 - 0.270045e-1 * t3272 - 0.144024e0 * t3278 + 0.648108e0 * t3280 + 0.576096e0 * t3282 - 0.225e0 * t126 * t99 * t28 * t683 + 0.9e0 * t92 * t265 * t28 * t695 - 0.21e1 * t126 * t99 * t221 * t75 + 0.84e1 * t92 * t265 * t221 * t84 + 0.108e2 * t92 * t2536 * t28 * t665 + 0.108e2 * t92 * t811 * t81 * t215 + 0.9e0 * t126 * t99 * t81 * t210 - 0.36e1 * t92 * t265 * t81 * t224;
  t3478 = -0.16875e0 * t534 * t99 * t28 * t649 - 0.45e0 * t167 * t99 * t81 * t203 + 0.3375e0 * t848 * t324 * t3346 + 0.135e1 * t745 * t324 * t2295 + 0.135e1 * t745 * t324 * t3353 - 0.81e1 * t861 * t324 * t2299 - 0.675e0 * t1982 * t324 * t3360 - 0.405e1 * t2461 * t324 * t3364 - 0.36e1 * t745 * t1179 * t964 - t3368 - t3369 + t3370 + t3371 - 0.42e1 * t3284;
  tv4rho3sigma11 = t3400 + t3407 + t3447 + t3478;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t3481 = 0.6001e-2 * t720 * t316;
  t3482 = t1252 * t51;
  t3483 = t1564 * t3482;
  t3485 = t1252 * t71;
  t3486 = t2365 * t3485;
  t3489 = 0.108018e-1 * t720 * t310;
  t3490 = t1256 * t51;
  t3491 = t710 * t3490;
  t3493 = t1256 * t71;
  t3494 = t714 * t3493;
  t3496 = t229 * t298;
  t3497 = t3496 * t128;
  t3498 = 0.150025e-1 * t3497;
  t3502 = t243 * t1064;
  t3509 = t243 * t1078;
  t3511 = t762 * t88;
  t3512 = t3511 * t95;
  t3513 = 0.12002e-1 * t3512;
  t3514 = t3481 + 0.405e0 * t3483 - 0.243e1 * t3486 + t3489 + 0.225e0 * t3491 - 0.9e0 * t3494 + t3498 + 0.7e0 * t92 * t315 * t154 + 0.1728288e0 * t3502 + 0.396e1 * t92 * t306 / t307 / t435 + 0.48008e-1 * t3509 - t3513;
  t3515 = t1040 * t251;
  t3516 = 0.24004e-1 * t3515;
  t3517 = t302 * t738;
  t3518 = 0.84014e-1 * t3517;
  t3519 = t762 * t299;
  t3520 = 0.66677777777777777777e-2 * t3519;
  t3521 = t55 * t1037;
  t3522 = 0.10001666666666666667e-1 * t3521;
  t3524 = t229 * t299 * t137;
  t3525 = 0.750125e-2 * t3524;
  t3527 = t87 * t1036 * t160;
  t3528 = 0.150025e-1 * t3527;
  t3529 = t122 * t1033;
  t3530 = 0.50008333333333333333e-2 * t3529;
  t3531 = t18 * t1078;
  t3533 = t18 * t1064;
  t3536 = t699 * t299 * t118;
  t3537 = 0.3750625e-2 * t3536;
  t3538 = t298 * t146;
  t3540 = t87 * t3538 * t148;
  t3541 = 0.30005e-1 * t3540;
  t3542 = t243 * t1059;
  t3548 = -t3516 - t3518 - t3520 - t3522 - t3525 + t3528 + t3530 - 0.6e0 * t3531 - 0.216e1 * t3533 + t3537 - t3541 + 0.1944324e0 * t3542 - 0.1215e1 * t92 * t1057 * t309 * t160;
  t3553 = t366 * t1069;
  t3555 = t243 * t1075;
  t3560 = t2354 * t240;
  t3561 = 0.90015e-2 * t3560;
  t3562 = t1040 * t248;
  t3563 = 0.36006e-1 * t3562;
  t3564 = t703 * t724;
  t3565 = 0.1350225e-1 * t3564;
  t3566 = t302 * t735;
  t3567 = 0.54009e-1 * t3566;
  t3572 = t366 * t1052;
  t3574 = t703 * t750;
  t3575 = 0.36006e-1 * t3574;
  t3576 = t302 * t755;
  t3577 = 0.162027e0 * t3576;
  t3578 = 0.1125e0 * t126 * t315 * t723 - 0.18003e-1 * t3553 + 0.72012e-1 * t3555 - 0.45e0 * t92 * t1074 * t734 + t3561 - t3563 - t3565 + t3567 + 0.2025e0 * t126 * t306 * t309 * t137 - 0.324054e-1 * t3572 + t3575 - t3577;
  t3579 = t302 * t759;
  t3580 = 0.144024e0 * t3579;
  t3589 = t1330 * t305;
  t3610 = t865 * t742;
  t3611 = 0.6751125e-2 * t3610;
  t3612 = t229 * t706;
  t3613 = t3612 * t746;
  t3614 = 0.54009e-1 * t3613;
  t3621 = -t3580 - 0.10125e0 * t167 * t306 * t309 * t118 - 0.108e1 * t126 * t306 * t1063 * t51 + 0.486e1 * t92 * t3589 * t309 * t148 + 0.648e1 * t92 * t1057 * t1063 * t71 - 0.5625e-1 * t167 * t315 * t741 - 0.3e0 * t126 * t315 * t749 + 0.135e1 * t92 * t1223 * t754 + 0.12e1 * t92 * t1074 * t758 + t3611 + t3614 - 0.1215e1 * t2461 * t1252 * t539 - 0.45e0 * t745 * t1256 * t539;
  tv4rho2sigma20 = t3514 + t3548 + t3578 + t3621;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t3623 = 0.750125e-2 * t3536;
  t3624 = 0.30005e-1 * t3497;
  t3625 = 0.6001e-1 * t3540;
  t3626 = 0.20003333333333333334e-1 * t3521;
  t3627 = 0.150025e-1 * t3524;
  t3628 = 0.30005e-1 * t3527;
  t3629 = 0.13335555555555555556e-1 * t3519;
  t3630 = 0.10001666666666666667e-1 * t3529;
  tv4rho2sigma21 = t3623 + t3624 - t3625 - t3513 + t3561 - t3563 - t3516 - t3565 + t3567 - t3518 - t3626 - t3627 + t3628 - t3629 + t3630 + t3614 + t3575 - t3577 - t3580 + t3611;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  t3631 = 0.6001e-2 * t3512;
  t3632 = 0.12002e-1 * t3515;
  t3650 = t2448 * t1096;
  t3652 = t2745 * t1102;
  t3657 = t44 * t2883;
  t3658 = t28 * t93;
  t3663 = t3511 * t100;
  t3664 = 0.6001e-2 * t3663;
  t3665 = -0.324054e-1 * t3650 + 0.1944324e0 * t3652 - 0.1215e1 * t861 * t324 * t2341 - t3522 - t3525 + t3528 + t3530 + t3537 - t3541 - 0.1215e1 * t3657 * t3658 * t239 * t71 - t3664;
  t3667 = 0.450075e-2 * t3560;
  t3668 = 0.18003e-1 * t3562;
  t3675 = t703 * t793;
  t3677 = t302 * t801;
  t3679 = t2354 * t260;
  t3680 = 0.450075e-2 * t3679;
  t3681 = t3667 - t3668 - 0.6751125e-2 * t3564 + 0.270045e-1 * t3566 + 0.18003e-1 * t3574 - 0.810135e-1 * t3576 - 0.72012e-1 * t3579 + 0.33755625e-2 * t3610 - 0.6751125e-2 * t3675 + 0.270045e-1 * t3677 + t3680;
  t3682 = t1040 * t267;
  t3683 = 0.18003e-1 * t3682;
  t3684 = t865 * t805;
  t3686 = t302 * t813;
  t3688 = t714 * t1106;
  t3691 = t3612 * t808;
  t3693 = t103 * t265;
  t3695 = t3693 * t3658 * t239;
  t3697 = t18 * t811;
  t3699 = t3697 * t3658 * t247;
  t3703 = 0.108018e-1 * t106 * t1856 * t326;
  t3704 = t1099 * t1106;
  t3710 = -t3683 + 0.33755625e-2 * t3684 - 0.810135e-1 * t3686 - 0.108e1 * t3688 + 0.270045e-1 * t3613 + 0.270045e-1 * t3691 + 0.405e0 * t3695 - 0.243e1 * t3699 + t3703 + 0.864144e-1 * t3704 + 0.126e1 * t323 * t324 * t93 * t154;
  tv4rho2sigma22 = t3498 - t3631 - t3632 - 0.42007e-1 * t3517 - t3520 - 0.10125e0 * t1982 * t324 * t2359 - 0.54e0 * t745 * t324 * t2362 + 0.486e1 * t2777 * t324 * t2366 + 0.324e1 * t861 * t324 * t2370 + 0.2025e0 * t745 * t324 * t2338 + t3665 + t3681 + t3710;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  t3712 = 0.26671111111111111111e-1 * t3519;
  tv4rho2sigma23 = -t3712 + 0.20003333333333333333e-1 * t3529 - 0.40006666666666666666e-1 * t3521 + 0.150025e-1 * t3536 + 0.6001e-1 * t3497 - 0.30005e-1 * t3524 - 0.12002e0 * t3540 + 0.6001e-1 * t3527;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  t3720 = 0.12002e-1 * t3663;
  t3721 = 0.90015e-2 * t3679;
  t3722 = 0.36006e-1 * t3682;
  t3723 = 0.6751125e-2 * t3684;
  t3724 = 0.54009e-1 * t3691;
  t3725 = 0.1350225e-1 * t3675;
  t3726 = 0.162027e0 * t3686;
  t3727 = 0.54009e-1 * t3677;
  tv4rho2sigma24 = -t3629 + t3630 - t3626 + t3623 + t3624 - t3627 - t3625 + t3628 - t3720 + t3721 - t3722 + t3723 + t3724 - t3725 - t3726 + t3727;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t3729 = 0.108018e-1 * t720 * t336;
  t3731 = t710 * t1271 * t51;
  t3734 = t714 * t1271 * t71;
  t3737 = 0.6001e-2 * t720 * t342;
  t3739 = t1564 * t1265 * t51;
  t3742 = t2365 * t1265 * t71;
  t3744 = t3498 - t3520 - t3522 - t3525 + t3528 + t3530 + t3537 - t3541 - t3720 + t3729 + 0.225e0 * t3731 - 0.9e0 * t3734 + t3737 + 0.405e0 * t3739 - 0.243e1 * t3742 - t3725 + t3727 + t3721;
  t3745 = t243 * t1125;
  t3754 = t366 * t1130;
  t3756 = t243 * t1136;
  t3765 = t366 * t1118;
  t3767 = t1330 * t331;
  t3788 = -t3722 + t3723 - t3726 + 0.1944324e0 * t3745 - 0.1215e1 * t92 * t1123 * t335 * t160 + 0.1125e0 * t126 * t341 * t792 - 0.18003e-1 * t3754 + 0.72012e-1 * t3756 - 0.45e0 * t92 * t1135 * t800 + 0.2025e0 * t126 * t332 * t335 * t137 - 0.324054e-1 * t3765 + 0.486e1 * t92 * t3767 * t335 * t148 - 0.5625e-1 * t167 * t341 * t804 + 0.135e1 * t92 * t1281 * t812 - 0.10125e0 * t167 * t332 * t335 * t118 + t3724 - 0.45e0 * t745 * t1271 * t539 - 0.1215e1 * t2461 * t1265 * t539;
  tv4rho2sigma25 = t3744 + t3788;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t3795 = t2727 * t886;
  t3796 = 0.6001e-2 * t3795;
  t3804 = t229 * t299 * t178;
  t3805 = 0.750125e-2 * t3804;
  t3806 = t3481 + 0.2025e0 * t3483 - 0.1215e1 * t3486 + t3489 + 0.1125e0 * t3491 - 0.45e0 * t3494 + 0.864144e-1 * t3502 + 0.24004e-1 * t3509 - t3513 - t3632 - t3520 + t3796 - 0.135e0 * t1719 * t1252 * t885 - 0.5e-1 * t491 * t1256 * t885 - t3805;
  t3807 = t122 * t1139;
  t3808 = 0.25004166666666666667e-2 * t3807;
  t3809 = t55 * t1142;
  t3810 = 0.50008333333333333333e-2 * t3809;
  t3811 = 0.50008333333333333333e-2 * t3521;
  t3812 = 0.25004166666666666666e-2 * t3529;
  t3816 = t699 * t298 * t168;
  t3817 = 0.3750625e-2 * t3816;
  t3818 = t3496 * t175;
  t3819 = 0.750125e-2 * t3818;
  t3820 = t3496 * t186;
  t3821 = 0.750125e-2 * t3820;
  t3822 = t1216 * t193;
  t3823 = 0.30005e-1 * t3822;
  t3824 = t1252 * t84;
  t3825 = t2365 * t3824;
  t3827 = t1256 * t75;
  t3828 = t710 * t3827;
  t3830 = t1256 * t84;
  t3831 = t714 * t3830;
  t3833 = t1252 * t75;
  t3834 = t1564 * t3833;
  t3838 = t3808 - t3810 - t3811 + t3812 - 0.3e0 * t3531 - 0.108e1 * t3533 + t3817 + t3819 + t3821 - t3823 - 0.1215e1 * t3825 + 0.1125e0 * t3828 - 0.45e0 * t3831 + 0.2025e0 * t3834 + 0.972162e-1 * t3542 - 0.90015e-2 * t3553;
  t3842 = t243 * t1154;
  t3847 = t366 * t1157;
  t3849 = t243 * t1160;
  t3852 = t818 * t298 * t199;
  t3853 = 0.16669444444444444444e-2 * t3852;
  t3854 = t703 * t823;
  t3855 = 0.1350225e-1 * t3854;
  t3860 = t366 * t1150;
  t3862 = t302 * t835;
  t3863 = 0.72012e-1 * t3862;
  t3875 = 0.36006e-1 * t3555 + t3667 - t3668 - 0.162027e-1 * t3572 + 0.972162e-1 * t3842 + 0.1125e0 * t126 * t315 * t822 - 0.90015e-2 * t3847 + 0.36006e-1 * t3849 + t3853 - t3855 + 0.2025e0 * t126 * t306 * t309 * t178 - 0.162027e-1 * t3860 - t3863 - 0.54e0 * t126 * t306 * t1063 * t75 + 0.324e1 * t92 * t1057 * t1063 * t84 - 0.15e0 * t126 * t315 * t830;
  t3876 = t87 * t2482;
  t3877 = t3876 * t862;
  t3878 = 0.162027e0 * t3877;
  t3903 = t699 * t233;
  t3904 = t3903 * t850;
  t3905 = 0.6751125e-2 * t3904;
  t3906 = t3612 * t854;
  t3907 = 0.270045e-1 * t3906;
  t3908 = t3612 * t858;
  t3909 = 0.270045e-1 * t3908;
  t3913 = t2354 * t277;
  t3914 = 0.450075e-2 * t3913;
  t3915 = t703 * t831;
  t3916 = 0.18003e-1 * t3915;
  t3917 = t1040 * t281;
  t3918 = 0.18003e-1 * t3917;
  t3919 = -t3878 - 0.10125e0 * t1982 * t1252 * t849 - 0.6075e0 * t2461 * t1252 * t853 - 0.6075e0 * t2461 * t1252 * t637 + 0.486e1 * t2777 * t1252 * t641 - 0.5625e-1 * t848 * t1256 * t849 - 0.225e0 * t745 * t1256 * t853 - 0.225e0 * t745 * t1256 * t637 + 0.135e1 * t861 * t1256 * t641 + t3905 + t3907 + t3909 + 0.6e0 * t92 * t1074 * t834 + t3914 + t3916 - t3918;
  tv4rho2sigma26 = t3806 + t3838 + t3875 + t3919;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  t3921 = 0.150025e-1 * t3804;
  t3922 = 0.50008333333333333333e-2 * t3807;
  t3923 = 0.10001666666666666667e-1 * t3809;
  t3924 = 0.50008333333333333335e-2 * t3529;
  t3925 = 0.750125e-2 * t3816;
  t3926 = 0.150025e-1 * t3818;
  t3927 = 0.150025e-1 * t3820;
  t3928 = -t3513 - t3632 - t3629 + t3796 - t3921 + t3922 - t3923 - t3522 + t3924 + t3925 + t3926 + t3927;
  t3929 = 0.6001e-1 * t3822;
  t3930 = 0.33338888888888888889e-2 * t3852;
  t3931 = -t3929 + t3667 - t3668 + t3930 - t3855 - t3863 - t3878 + t3905 + t3907 + t3909 + t3914 + t3916 - t3918;
  tv4rho2sigma27 = t3928 + t3931;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  t3939 = t2727 * t943;
  t3944 = t2448 * t1173;
  t3946 = t2745 * t1176;
  t3957 = -t3631 - 0.6001e-2 * t3515 - t3520 - 0.27e0 * t745 * t324 * t2608 + 0.162e1 * t861 * t324 * t2611 + 0.30005e-2 * t3939 + 0.2025e0 * t745 * t324 * t2614 - 0.162027e-1 * t3944 + 0.972162e-1 * t3946 - 0.27e0 * t745 * t1179 * t711 + 0.162e1 * t861 * t1179 * t715 + 0.30005e-2 * t3795 - 0.162027e-1 * t3650 + 0.972162e-1 * t3652 - t3805;
  t3981 = t1040 * t294;
  t3984 = t3808 - t3810 - 0.135e0 * t2884 * t3658 * t22 * t885 - t3811 + t3812 - 0.6075e0 * t3657 * t3658 * t280 * t51 + 0.486e1 * t59 * t1331 * t98 * t3658 * t280 * t71 - 0.10125e0 * t117 * t2875 * t3658 * t276 * t51 - 0.6075e0 * t3657 * t3658 * t276 * t71 - t3664 + t3817 + t3819 + t3821 - t3823 - 0.6001e-2 * t3981 + 0.2250375e-2 * t3560;
  t3999 = t3903 * t919;
  t4001 = -0.90015e-2 * t3562 + 0.2250375e-2 * t3679 - 0.90015e-2 * t3682 - 0.54e0 * t3688 + t3853 - 0.6751125e-2 * t3854 - 0.36006e-1 * t3862 + 0.2025e0 * t3695 - 0.1215e1 * t3699 + t3703 + 0.432072e-1 * t3704 - 0.810135e-1 * t3877 + 0.33755625e-2 * t3904 + 0.1350225e-1 * t3906 + 0.1350225e-1 * t3908 + 0.33755625e-2 * t3999;
  t4002 = t3612 * t923;
  t4004 = t3612 * t926;
  t4006 = t3876 * t929;
  t4008 = t1099 * t1180;
  t4011 = t3693 * t3658 * t276;
  t4014 = t3697 * t3658 * t280;
  t4022 = t703 * t901;
  t4024 = t703 * t909;
  t4026 = t302 * t913;
  t4028 = t1040 * t291;
  t4030 = t714 * t1180;
  t4032 = t2354 * t287;
  t4034 = 0.1350225e-1 * t4002 + 0.1350225e-1 * t4004 - 0.810135e-1 * t4006 + 0.432072e-1 * t4008 + 0.2025e0 * t4011 - 0.1215e1 * t4014 + 0.72e0 * t323 * t1179 * t1105 + 0.2250375e-2 * t3913 + 0.90015e-2 * t3915 - 0.90015e-2 * t3917 - 0.6751125e-2 * t4022 + 0.90015e-2 * t4024 - 0.36006e-1 * t4026 - 0.90015e-2 * t4028 - 0.54e0 * t4030 + 0.2250375e-2 * t4032;
  tv4rho2sigma28 = t3957 + t3984 + t4001 + t4034;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  t4038 = 0.10001666666666666667e-1 * t3807;
  tv4rho2sigma29 = -t3712 + 0.10001666666666666666e-1 * t3529 - 0.20003333333333333333e-1 * t3521 + t4038 + 0.150025e-1 * t3816 + 0.30005e-1 * t3818 - 0.30005e-1 * t3804 - 0.20003333333333333333e-1 * t3809 + 0.30005e-1 * t3820 - 0.12002e0 * t3822 + 0.66677777777777777778e-2 * t3852;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  t4046 = 0.6001e-2 * t3939;
  t4047 = -t3629 + t4046 - t3921 + t3922 - t3923 - t3522 + t3924 - t3720 + t3925 + t3926 + t3927 - t3929;
  t4048 = 0.12002e-1 * t3981;
  t4049 = 0.6751125e-2 * t3999;
  t4050 = 0.270045e-1 * t4002;
  t4051 = 0.270045e-1 * t4004;
  t4052 = 0.162027e0 * t4006;
  t4053 = 0.1350225e-1 * t4022;
  t4054 = 0.18003e-1 * t4024;
  t4055 = 0.72012e-1 * t4026;
  t4056 = 0.18003e-1 * t4028;
  t4057 = 0.450075e-2 * t4032;
  t4058 = -t4048 + t3680 - t3683 + t3930 + t4049 + t4050 + t4051 - t4052 - t4053 + t4054 - t4055 - t4056 + t4057;
  tv4rho2sigma210 = t4047 + t4058;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t4059 = t18 * t1207;
  t4061 = t18 * t1198;
  t4071 = -t3520 - 0.3e0 * t4059 - 0.108e1 * t4061 - 0.135e0 * t1719 * t1265 * t885 - 0.5e-1 * t491 * t1271 * t885 + t4046 - t3805 + t3808 - t3810 - t3811 + t3812 - t3720 + t3729 + 0.1125e0 * t3731 - 0.45e0 * t3734;
  t4075 = t2365 * t1265 * t84;
  t4078 = t710 * t1271 * t75;
  t4081 = t714 * t1271 * t84;
  t4084 = t1564 * t1265 * t75;
  t4086 = t243 * t1198;
  t4088 = t243 * t1207;
  t4090 = t3737 + 0.2025e0 * t3739 - 0.1215e1 * t3742 + t3817 + t3819 + t3821 - t3823 - t4048 - 0.1215e1 * t4075 + 0.1125e0 * t4078 - 0.45e0 * t4081 + 0.2025e0 * t4084 + 0.864144e-1 * t4086 + 0.24004e-1 * t4088 + t3680 - t3683;
  t4117 = 0.972162e-1 * t3745 - 0.90015e-2 * t3754 + 0.36006e-1 * t3756 - 0.162027e-1 * t3765 + t3853 + t4049 + t4050 + t4051 - t4052 - 0.6075e0 * t2461 * t1265 * t637 + 0.486e1 * t2777 * t1265 * t641 - 0.5625e-1 * t848 * t1271 * t849 - 0.225e0 * t745 * t1271 * t853 - 0.225e0 * t745 * t1271 * t637 + 0.135e1 * t861 * t1271 * t641 - 0.10125e0 * t1982 * t1265 * t849;
  t4121 = t243 * t1204;
  t4133 = t366 * t1189;
  t4135 = t243 * t1193;
  t4148 = t366 * t1201;
  t4150 = -0.6075e0 * t2461 * t1265 * t853 - t4053 + t4054 - t4055 - t4056 + t4057 + 0.36006e-1 * t4121 - 0.15e0 * t126 * t341 * t908 + 0.6e0 * t92 * t1135 * t912 + 0.2025e0 * t126 * t332 * t335 * t178 - 0.162027e-1 * t4133 + 0.972162e-1 * t4135 - 0.54e0 * t126 * t332 * t1197 * t51 + 0.324e1 * t92 * t1123 * t1197 * t71 + 0.1125e0 * t126 * t341 * t900 - 0.90015e-2 * t4148;
  tv4rho2sigma211 = t4071 + t4090 + t4117 + t4150;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t4153 = t87 * t3538 * t215;
  t4154 = 0.30005e-1 * t4153;
  t4156 = t229 * t299 * t210;
  t4157 = 0.750125e-2 * t4156;
  t4159 = t87 * t1036 * t224;
  t4160 = 0.150025e-1 * t4159;
  t4162 = t699 * t299 * t203;
  t4163 = 0.3750625e-2 * t4162;
  t4168 = t3496 * t208;
  t4169 = 0.150025e-1 * t4168;
  t4173 = t3481 + t3489 - t3513 - t3520 - t4154 - t4157 + t4160 + t4163 + t3922 - t3923 - 0.243e1 * t3825 + 0.225e0 * t3828 - 0.9e0 * t3831 + 0.405e0 * t3834 + t4169 + 0.1944324e0 * t3842 - 0.18003e-1 * t3847 + 0.72012e-1 * t3849;
  t4181 = t3612 * t965;
  t4182 = 0.54009e-1 * t4181;
  t4183 = 0.90015e-2 * t3913;
  t4184 = 0.36006e-1 * t3917;
  t4185 = t302 * t969;
  t4186 = 0.162027e0 * t4185;
  t4204 = t703 * t953;
  t4205 = 0.1350225e-1 * t4204;
  t4206 = t302 * t957;
  t4207 = 0.54009e-1 * t4206;
  t4219 = t865 * t961;
  t4220 = 0.6751125e-2 * t4219;
  t4221 = -0.324054e-1 * t3860 - 0.1215e1 * t2461 * t1252 * t964 - 0.45e0 * t745 * t1256 * t964 + t4182 + t4183 - t4184 - t4186 - 0.10125e0 * t167 * t306 * t309 * t203 + 0.486e1 * t92 * t3589 * t309 * t215 - 0.5625e-1 * t167 * t315 * t960 + 0.135e1 * t92 * t1223 * t968 - 0.45e0 * t92 * t1074 * t956 - t4205 + t4207 + 0.2025e0 * t126 * t306 * t309 * t210 - 0.1215e1 * t92 * t1057 * t309 * t224 + 0.1125e0 * t126 * t315 * t952 + t4220;
  tv4rho2sigma212 = t4173 + t4221;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  t4222 = 0.20003333333333333334e-1 * t3809;
  t4223 = 0.750125e-2 * t4162;
  t4224 = 0.30005e-1 * t4168;
  t4225 = 0.150025e-1 * t4156;
  t4226 = 0.6001e-1 * t4153;
  t4227 = 0.30005e-1 * t4159;
  tv4rho2sigma213 = -t3629 + t4038 - t4222 + t4223 + t4224 - t4225 - t4226 + t4227 - t3513 + t4183 - t4184 + t4220 + t4182 - t4205 - t4186 + t4207;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  t4253 = t302 * t1005;
  t4255 = -0.54e0 * t745 * t1179 * t874 + 0.486e1 * t2777 * t324 * t2983 - 0.324054e-1 * t3944 + 0.1944324e0 * t3946 + t3922 - t3923 - 0.1215e1 * t3657 * t3658 * t276 * t84 - t3664 - t4048 + t4169 - 0.42007e-1 * t4253;
  t4261 = t3612 * t1013;
  t4268 = t3703 + 0.864144e-1 * t4008 + 0.405e0 * t4011 - 0.243e1 * t4014 + 0.270045e-1 * t4181 + 0.270045e-1 * t4261 + 0.126e1 * t323 * t98 * t221 * t325 + t3914 - t3918 - t4056 - 0.108e1 * t4030;
  t4273 = t703 * t1017;
  t4275 = t302 * t1021;
  t4277 = t302 * t1025;
  t4279 = t865 * t1009;
  t4281 = t703 * t998;
  t4283 = t302 * t1002;
  t4285 = t4057 - 0.810135e-1 * t4185 - 0.6751125e-2 * t4204 + 0.270045e-1 * t4206 + 0.33755625e-2 * t4219 + 0.18003e-1 * t4273 - 0.810135e-1 * t4275 - 0.72012e-1 * t4277 + 0.33755625e-2 * t4279 - 0.6751125e-2 * t4281 + 0.270045e-1 * t4283;
  tv4rho2sigma214 = -t3631 - t3520 - t4154 - t4157 + t4160 + t4163 + 0.2025e0 * t745 * t324 * t2974 - 0.1215e1 * t861 * t324 * t2977 + 0.324e1 * t861 * t1179 * t877 - 0.10125e0 * t1982 * t324 * t2980 + t4255 + t4268 + t4285;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = -t3712 + 0.20003333333333333333e-1 * t3807 - 0.40006666666666666666e-1 * t3809 + 0.150025e-1 * t4162 + 0.6001e-1 * t4168 - 0.30005e-1 * t4156 - 0.12002e0 * t4153 + 0.6001e-1 * t4159;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  t4294 = 0.54009e-1 * t4261;
  t4295 = 0.36006e-1 * t4273;
  t4296 = 0.162027e0 * t4275;
  t4297 = 0.144024e0 * t4277;
  t4298 = 0.6751125e-2 * t4279;
  t4299 = 0.1350225e-1 * t4281;
  t4300 = 0.54009e-1 * t4283;
  t4301 = 0.84014e-1 * t4253;
  t4302 = 0.24004e-1 * t3981;
  t4303 = 0.36006e-1 * t4028;
  t4304 = 0.90015e-2 * t4032;
  tv4rho2sigma216 = t4294 + t4295 - t4296 - t4297 + t4298 - t4225 + t4227 - t4299 + t4300 - t4301 + t4223 + t4224 - t4226 + t4038 - t4222 - t4302 - t3720 - t3629 - t4303 + t4304;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t4307 = -t3520 - t4154 - t4157 + t4160 + t4163 - 0.6e0 * t4059 - 0.216e1 * t4061 + t3922 - t3923 - t3720 + t3729 + t3737;
  t4325 = -t4302 - 0.243e1 * t4075 + 0.225e0 * t4078 - 0.9e0 * t4081 + 0.405e0 * t4084 + 0.1728288e0 * t4086 + 0.48008e-1 * t4088 + t4169 - t4301 + 0.7e0 * t92 * t341 * t221 + 0.396e1 * t92 * t332 / t333 / t690 + t4294 - 0.45e0 * t745 * t1271 * t964;
  t4334 = -0.1215e1 * t2461 * t1265 * t964 - t4303 + t4304 + 0.72012e-1 * t4121 - 0.324054e-1 * t4133 + 0.1944324e0 * t4135 - 0.18003e-1 * t4148 + t4295 - t4296 - t4297 + t4298 - t4299;
  t4377 = t4300 - 0.5625e-1 * t167 * t341 * t1008 - 0.3e0 * t126 * t341 * t1016 + 0.135e1 * t92 * t1281 * t1020 + 0.12e1 * t92 * t1135 * t1024 - 0.10125e0 * t167 * t332 * t335 * t203 - 0.108e1 * t126 * t332 * t1197 * t75 + 0.486e1 * t92 * t3767 * t335 * t215 + 0.648e1 * t92 * t1123 * t1197 * t84 - 0.45e0 * t92 * t1135 * t1001 + 0.2025e0 * t126 * t332 * t335 * t210 - 0.1215e1 * t92 * t1123 * t335 * t224 + 0.1125e0 * t126 * t341 * t997;
  tv4rho2sigma217 = t4307 + t4325 + t4334 + t4377;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t4380 = 0.3375e0 * t18 * t1237;
  t4382 = 0.54675e0 * t18 * t1225;
  t4384 = 0.6075e0 * t18 * t1231;
  t4386 = t229 * t1213 * t51;
  t4387 = 0.11251875e-1 * t4386;
  t4388 = t1212 * t61;
  t4390 = t87 * t4388 * t71;
  t4391 = 0.2250375e-1 * t4390;
  t4392 = t55 * t1213;
  t4393 = 0.750125e-2 * t4392;
  t4397 = t55 * t298;
  t4398 = t4397 * t95;
  t4399 = 0.6751125e-2 * t4398;
  t4400 = t1216 * t251;
  t4402 = t1040 * t310;
  t4403 = 0.12152025e-1 * t4402;
  t4404 = t302 * t1064;
  t4406 = t1040 * t316;
  t4407 = 0.6751125e-2 * t4406;
  t4408 = t302 * t1078;
  t4417 = -t4380 - t4382 - t4384 + t4387 - t4391 - t4393 + 0.45e0 * t92 * t1236 * t65 - t4399 - 0.270045e-1 * t4400 - t4403 - 0.972162e-1 * t4404 - t4407 - 0.270045e-1 * t4408 + 0.2187e1 * t92 * t1223 / t1375 + 0.162e1 * t92 * t1230 * t1063;
  t4419 = 0.486081e-1 * t243 * t1231;
  t4421 = 0.270045e-1 * t243 * t1237;
  t4423 = 0.4374729e-1 * t243 * t1225;
  t4424 = t3496 * t240;
  t4426 = t1216 * t248;
  t4428 = t703 * t1052;
  t4430 = t302 * t1059;
  t4432 = t703 * t1069;
  t4434 = t302 * t1075;
  t4440 = t1330 * t314;
  t4448 = t381 * t1229;
  t4455 = t146 * t1235;
  t4459 = t4419 + t4421 + t4423 + 0.101266875e-1 * t4424 - 0.4050675e-1 * t4426 + 0.182280375e-1 * t4428 - 0.109368225e0 * t4430 + 0.101266875e-1 * t4432 - 0.4050675e-1 * t4434 - 0.273375e0 * t126 * t1223 * t1224 * t51 + 0.2187e1 * t92 * t4440 * t1224 * t71 - 0.30375e0 * t126 * t1230 * t1051 + 0.18225e1 * t92 * t4448 * t1058 - 0.16875e0 * t126 * t1236 * t239 + 0.675e0 * t92 * t4455 * t247;
  tv4rhosigma30 = t4417 + t4459;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t4460 = 0.150025e-1 * t4392;
  t4461 = 0.2250375e-1 * t4386;
  t4462 = 0.450075e-1 * t4390;
  t4463 = 0.90015e-2 * t4398;
  t4464 = 0.1350225e-1 * t4424;
  t4465 = 0.54009e-1 * t4426;
  t4466 = 0.36006e-1 * t4400;
  t4467 = 0.810135e-2 * t4402;
  t4471 = 0.450075e-2 * t4406;
  tv4rhosigma31 = -t4460 + t4461 - t4462 - t4463 + t4464 - t4465 - t4466 - t4467 + 0.12152025e-1 * t4428 - 0.7291215e-1 * t4430 - 0.648108e-1 * t4404 - t4471 + 0.6751125e-2 * t4432 - 0.270045e-1 * t4434 - 0.18003e-1 * t4408;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  t4476 = 0.12152025e-1 * t3612 * t1096;
  t4478 = 0.7291215e-1 * t3876 * t1102;
  t4495 = 0.450075e-2 * t4398;
  t4496 = 0.18003e-1 * t4400;
  t4497 = 0.4050675e-2 * t4402;
  t4499 = 0.2250375e-2 * t4406;
  t4501 = t4387 - t4391 + t4476 - t4478 - 0.273375e0 * t2461 * t324 * t3482 + 0.2187e1 * t2777 * t324 * t3485 - 0.10125e0 * t745 * t324 * t3490 + 0.6075e0 * t861 * t324 * t3493 - t4393 + 0.27e0 * t323 * t324 * t314 * t65 - t4495 - t4496 - t4497 - 0.324054e-1 * t4404 - t4499 - 0.90015e-2 * t4408;
  t4502 = t4397 * t100;
  t4503 = 0.2250375e-2 * t4502;
  t4505 = 0.4374729e-1 * t2745 * t1253;
  t4507 = 0.162027e-1 * t1099 * t1257;
  t4510 = 0.810135e-2 * t55 * t706 * t326;
  t4512 = 0.324054e-1 * t1249 * t1106;
  t4517 = 0.6751125e-2 * t4424;
  t4518 = 0.270045e-1 * t4426;
  t4524 = 0.54675e0 * t2365 * t1253;
  t4526 = 0.2025e0 * t714 * t1257;
  t4527 = t1216 * t267;
  t4529 = t3496 * t260;
  t4531 = -t4503 + t4505 + t4507 - t4510 - t4512 + 0.1458e1 * t861 * t324 * t305 * t1063 + t4517 - t4518 + 0.60760125e-2 * t4428 - 0.36456075e-1 * t4430 + 0.33755625e-2 * t4432 - 0.1350225e-1 * t4434 - t4524 - t4526 - 0.1350225e-1 * t4527 + 0.33755625e-2 * t4529;
  tv4rhosigma32 = t4501 + t4531;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  t4532 = 0.30005e-1 * t4392;
  t4533 = 0.450075e-1 * t4386;
  t4534 = 0.90015e-1 * t4390;
  tv4rhosigma33 = -t4532 + t4533 - t4534 - t4463 + t4464 - t4465 - t4466;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  t4535 = 0.450075e-2 * t4502;
  t4536 = 0.6751125e-2 * t4529;
  t4537 = 0.270045e-1 * t4527;
  tv4rhosigma34 = -t4460 + t4461 - t4462 - t4495 + t4517 - t4518 - t4496 - t4535 + t4536 - t4537 - t4510 + t4476 - t4478 - t4512;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  t4539 = 0.4374729e-1 * t2745 * t1266;
  t4541 = 0.162027e-1 * t1099 * t1272;
  t4560 = 0.2250375e-2 * t4398;
  t4562 = t4387 - t4391 + t4476 - t4478 - t4393 + t4539 + t4541 + 0.729e0 * t861 * t1265 * t1105 + 0.27e0 * t323 * t1271 * t1105 - 0.273375e0 * t2461 * t1265 * t711 + 0.2187e1 * t2777 * t1265 * t715 - 0.10125e0 * t745 * t1271 * t711 + 0.6075e0 * t861 * t1271 * t715 - t4560 - 0.90015e-2 * t4400;
  t4563 = t1040 * t336;
  t4564 = 0.4050675e-2 * t4563;
  t4565 = t1040 * t342;
  t4566 = 0.2250375e-2 * t4565;
  t4570 = 0.54675e0 * t2365 * t1266;
  t4572 = 0.2025e0 * t714 * t1272;
  t4573 = t703 * t1118;
  t4575 = t302 * t1125;
  t4577 = t703 * t1130;
  t4579 = t302 * t1136;
  t4581 = -t4535 - t4564 - t4566 - t4510 - t4512 + 0.33755625e-2 * t4424 - 0.1350225e-1 * t4426 - t4537 + t4536 - t4570 - t4572 + 0.60760125e-2 * t4573 - 0.36456075e-1 * t4575 + 0.33755625e-2 * t4577 - 0.1350225e-1 * t4579;
  tv4rhosigma35 = t4562 + t4581;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  t4582 = 0.6001e-1 * t4392;
  tv4rhosigma36 = -t4582 + 0.90015e-1 * t4386 - 0.18003e0 * t4390;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  t4585 = 0.90015e-2 * t4502;
  t4586 = 0.1350225e-1 * t4529;
  t4587 = 0.54009e-1 * t4527;
  tv4rhosigma37 = -t4532 + t4533 - t4534 - t4585 + t4586 - t4587;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  t4588 = 0.810135e-2 * t4563;
  t4591 = 0.450075e-2 * t4565;
  tv4rhosigma38 = -t4460 + t4461 - t4462 - t4585 + t4586 - t4587 - t4588 + 0.12152025e-1 * t4573 - 0.7291215e-1 * t4575 - t4591 + 0.6751125e-2 * t4577 - 0.270045e-1 * t4579;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t4594 = 0.6751125e-2 * t4502;
  t4597 = 0.12152025e-1 * t4563;
  t4600 = 0.6751125e-2 * t4565;
  t4603 = -t4393 + t4387 - t4391 - t4594 + 0.101266875e-1 * t4529 - 0.4050675e-1 * t4527 - t4597 + 0.182280375e-1 * t4573 - 0.109368225e0 * t4575 - t4600 + 0.101266875e-1 * t4577 - 0.4050675e-1 * t4579;
  t4605 = 0.54675e0 * t18 * t1283;
  t4611 = 0.4374729e-1 * t243 * t1283;
  t4612 = t1330 * t340;
  t4618 = 0.6075e0 * t18 * t1289;
  t4623 = 0.486081e-1 * t243 * t1289;
  t4624 = t381 * t1287;
  t4629 = 0.3375e0 * t18 * t1295;
  t4634 = 0.270045e-1 * t243 * t1295;
  t4635 = t146 * t1293;
  t4639 = -t4605 - 0.273375e0 * t126 * t1281 * t1282 * t51 + t4611 + 0.2187e1 * t92 * t4612 * t1282 * t71 - t4618 - 0.30375e0 * t126 * t1288 * t1117 + t4623 + 0.18225e1 * t92 * t4624 * t1124 - t4629 - 0.16875e0 * t126 * t1294 * t259 + t4634 + 0.675e0 * t92 * t4635 * t266;
  tv4rhosigma39 = t4603 + t4639;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t4641 = t229 * t1213 * t75;
  t4642 = 0.11251875e-1 * t4641;
  t4644 = t87 * t4388 * t84;
  t4645 = 0.2250375e-1 * t4644;
  t4646 = t3496 * t277;
  t4648 = t1216 * t281;
  t4650 = t703 * t1150;
  t4652 = t302 * t1154;
  t4654 = t703 * t1157;
  t4656 = t302 * t1160;
  t4658 = -t4393 + t4642 - t4645 - t4399 + 0.101266875e-1 * t4646 - 0.4050675e-1 * t4648 - t4403 + 0.182280375e-1 * t4650 - 0.109368225e0 * t4652 - t4407 + 0.101266875e-1 * t4654 - 0.4050675e-1 * t4656;
  t4679 = -t4382 - 0.273375e0 * t126 * t1223 * t1224 * t75 + t4423 + 0.2187e1 * t92 * t4440 * t1224 * t84 - t4384 - 0.30375e0 * t126 * t1230 * t1149 + t4419 + 0.18225e1 * t92 * t4448 * t1153 - t4380 - 0.16875e0 * t126 * t1236 * t276 + t4421 + 0.675e0 * t92 * t4455 * t280;
  tv4rhosigma310 = t4658 + t4679;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  t4680 = 0.2250375e-1 * t4641;
  t4681 = 0.450075e-1 * t4644;
  t4682 = 0.1350225e-1 * t4646;
  t4683 = 0.54009e-1 * t4648;
  tv4rhosigma311 = -t4460 + t4680 - t4681 - t4463 + t4682 - t4683 - t4467 + 0.12152025e-1 * t4650 - 0.7291215e-1 * t4652 - t4471 + 0.6751125e-2 * t4654 - 0.270045e-1 * t4656;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  t4689 = 0.324054e-1 * t1249 * t1180;
  t4696 = t1216 * t294;
  t4699 = 0.12152025e-1 * t3612 * t1173;
  t4700 = -t4645 + t4642 - t4393 - t4689 + 0.729e0 * t861 * t1179 * t1252 + 0.27e0 * t323 * t1179 * t1256 - t4495 - t4497 - t4499 - t4503 - 0.90015e-2 * t4696 + t4505 + t4507 - t4510 + t4699;
  t4702 = 0.7291215e-1 * t3876 * t1176;
  t4715 = 0.6751125e-2 * t4646;
  t4716 = 0.270045e-1 * t4648;
  t4721 = t3496 * t287;
  t4723 = t1216 * t291;
  t4725 = -t4702 - 0.273375e0 * t2461 * t324 * t3833 + 0.2187e1 * t2777 * t324 * t3824 - 0.10125e0 * t745 * t324 * t3827 + 0.6075e0 * t861 * t324 * t3830 - t4524 - t4526 + t4715 - t4716 + 0.60760125e-2 * t4650 - 0.36456075e-1 * t4652 + 0.33755625e-2 * t4654 - 0.1350225e-1 * t4656 + 0.33755625e-2 * t4721 - 0.1350225e-1 * t4723;
  tv4rhosigma312 = t4700 + t4725;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  t4726 = 0.450075e-1 * t4641;
  t4727 = 0.90015e-1 * t4644;
  tv4rhosigma313 = -t4532 + t4726 - t4727 - t4463 + t4682 - t4683;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  t4728 = 0.6751125e-2 * t4721;
  t4729 = 0.270045e-1 * t4723;
  t4730 = 0.18003e-1 * t4696;
  tv4rhosigma314 = -t4460 + t4680 - t4681 - t4495 + t4715 - t4716 - t4535 + t4728 - t4729 - t4730 - t4510 + t4699 - t4702 - t4689;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  t4739 = t302 * t1207;
  t4741 = t302 * t1198;
  t4743 = -t4645 + t4642 - t4393 + 0.1458e1 * t861 * t331 * t1197 * t325 - t4689 + 0.27e0 * t323 * t340 * t81 * t325 + t4539 + t4541 - t4560 - t4535 - t4564 - t4566 - t4730 - 0.90015e-2 * t4739 - 0.324054e-1 * t4741 - t4510;
  t4758 = t703 * t1189;
  t4760 = t302 * t1193;
  t4762 = t703 * t1201;
  t4764 = t302 * t1204;
  t4766 = t4699 - t4702 - 0.273375e0 * t2461 * t1265 * t874 + 0.2187e1 * t2777 * t1265 * t877 - 0.10125e0 * t745 * t1271 * t874 + 0.6075e0 * t861 * t1271 * t877 - t4570 - t4572 + 0.33755625e-2 * t4646 - 0.1350225e-1 * t4648 + t4728 - t4729 + 0.60760125e-2 * t4758 - 0.36456075e-1 * t4760 + 0.33755625e-2 * t4762 - 0.1350225e-1 * t4764;
  tv4rhosigma315 = t4743 + t4766;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = -t4582 + 0.90015e-1 * t4641 - 0.18003e0 * t4644;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  t4769 = 0.1350225e-1 * t4721;
  t4770 = 0.54009e-1 * t4723;
  t4771 = 0.36006e-1 * t4696;
  tv4rhosigma317 = -t4532 + t4726 - t4727 - t4585 + t4769 - t4770 - t4771;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = -t4460 + t4680 - t4681 - t4585 + t4769 - t4770 - t4771 - t4588 + 0.12152025e-1 * t4758 - 0.7291215e-1 * t4760 - 0.648108e-1 * t4741 - t4591 + 0.6751125e-2 * t4762 - 0.270045e-1 * t4764 - 0.18003e-1 * t4739;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t4785 = -t4645 - t4605 - t4618 - t4629 + t4642 - t4393 - 0.16875e0 * t126 * t1294 * t286 + 0.675e0 * t92 * t4635 * t290 - t4594 - t4597 - t4600 + t4611 + t4623 + t4634 - 0.270045e-1 * t4696;
  t4818 = -0.270045e-1 * t4739 - 0.972162e-1 * t4741 + 0.2187e1 * t92 * t1281 / t2307 + 0.162e1 * t92 * t1288 * t1197 + 0.45e0 * t92 * t1294 * t81 + 0.101266875e-1 * t4721 - 0.4050675e-1 * t4723 + 0.182280375e-1 * t4758 - 0.109368225e0 * t4760 + 0.101266875e-1 * t4762 - 0.4050675e-1 * t4764 - 0.273375e0 * t126 * t1281 * t1282 * t75 + 0.2187e1 * t92 * t4612 * t1282 * t84 - 0.30375e0 * t126 * t1288 * t1188 + 0.18225e1 * t92 * t4624 * t1192;
  tv4rhosigma319 = t4785 + t4818;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t4823 = t87 / t11 / t1210 / t10 * t42;
  t4824 = 0.56259375e-1 * t4823;
  t4825 = t87 * t1212;
  t4826 = t4825 * t95;
  t4827 = 0.4050675e-1 * t4826;
  t4828 = t1216 * t310;
  t4829 = 0.36456075e-1 * t4828;
  t4830 = t1216 * t316;
  t4831 = 0.20253375e-1 * t4830;
  t4832 = t302 * t1225;
  t4834 = t302 * t1231;
  t4836 = t302 * t1237;
  t4846 = t1228 * sigma[0];
  tv4sigma40 = -t4824 - t4827 - t4829 - t4831 - 0.65620935e-1 * t4832 - 0.7291215e-1 * t4834 - 0.4050675e-1 * t4836 + 0.98415e0 * t92 * t1330 * t1229 * t1377 + 0.164025e1 * t92 * t381 * t1235 * t1224 + 0.151875e1 * t92 * t146 / t4846 * t309 + 0.84375e0 * t92 * t61 / t19 / t4846 * t22;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  t4858 = 0.11251875e0 * t4823;
  tv4sigma41 = -t4858 - 0.60760125e-1 * t4826 - t4829 - t4831 - 0.328104675e-1 * t4832 - 0.36456075e-1 * t4834 - 0.20253375e-1 * t4836;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  t4869 = t4825 * t100;
  t4872 = t87 * t3538 * t326;
  t4873 = 0.182280375e-1 * t4872;
  t4874 = t3876 * t1253;
  t4876 = t1249 * t1257;
  tv4sigma42 = -t4824 - 0.303800625e-1 * t4826 - 0.182280375e-1 * t4828 - 0.101266875e-1 * t4830 - 0.1640523375e-1 * t4832 - 0.182280375e-1 * t4834 - 0.101266875e-1 * t4836 - 0.101266875e-1 * t4869 - t4873 - 0.4921570125e-1 * t4874 - 0.182280375e-1 * t4876 + 0.98415e0 * t2777 * t324 * t314 * t1224 + 0.820125e0 * t861 * t324 * t1229 * t309 + 0.30375e0 * t323 * t324 * t1235 * t22;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  t4890 = 0.2250375e0 * t4823;
  t4891 = 0.810135e-1 * t4826;
  tv4sigma43 = -t4890 - t4891 - 0.2430405e-1 * t4828 - 0.1350225e-1 * t4830;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  t4896 = 0.20253375e-1 * t4869;
  t4897 = 0.2430405e-1 * t4872;
  t4898 = 0.328104675e-1 * t4874;
  t4899 = 0.12152025e-1 * t4876;
  tv4sigma44 = -t4858 - t4827 - 0.12152025e-1 * t4828 - 0.6751125e-2 * t4830 - t4896 - t4897 - t4898 - t4899;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  t4900 = 0.20253375e-1 * t4826;
  t4903 = t1216 * t336;
  t4905 = t3876 * t1266;
  t4906 = 0.328104675e-1 * t4905;
  t4913 = t1216 * t342;
  t4915 = t1249 * t1272;
  t4916 = 0.12152025e-1 * t4915;
  tv4sigma45 = -t4824 - t4900 - 0.60760125e-2 * t4828 - 0.33755625e-2 * t4830 - t4896 - t4897 - t4898 - t4899 - 0.60760125e-2 * t4903 - t4906 + 0.98415e0 * t2777 * t1265 * t1252 + 0.273375e0 * t861 * t1265 * t1256 - 0.33755625e-2 * t4913 - t4916 + 0.273375e0 * t861 * t1271 * t1252 + 0.10125e0 * t323 * t1271 * t1256;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  t4923 = 0.450075e0 * t4823;
  tv4sigma46 = -t4923 - t4891;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  t4924 = 0.4050675e-1 * t4869;
  tv4sigma47 = -t4890 - t4827 - t4924 - t4897;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = -t4858 - t4900 - t4924 - t4897 - 0.12152025e-1 * t4903 - t4906 - 0.6751125e-2 * t4913 - t4916;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  t4933 = t302 * t1283;
  t4939 = t302 * t1289;
  t4945 = t302 * t1295;
  tv4sigma49 = -t4824 - 0.101266875e-1 * t4826 - 0.303800625e-1 * t4869 - t4873 - 0.182280375e-1 * t4903 - 0.4921570125e-1 * t4905 - 0.101266875e-1 * t4913 - 0.182280375e-1 * t4915 - 0.1640523375e-1 * t4933 + 0.98415e0 * t2777 * t340 * t1282 * t325 - 0.182280375e-1 * t4939 + 0.820125e0 * t861 * t1287 * t335 * t325 - 0.101266875e-1 * t4945 + 0.30375e0 * t323 * t1293 * t28 * t325;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = -0.90015e0 * t4823;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  t4952 = 0.810135e-1 * t4869;
  tv4sigma411 = -t4923 - t4952;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = -t4890 - t4952 - 0.2430405e-1 * t4903 - 0.1350225e-1 * t4913;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  t4956 = 0.36456075e-1 * t4903;
  t4957 = 0.20253375e-1 * t4913;
  tv4sigma413 = -t4858 - 0.60760125e-1 * t4869 - t4956 - t4957 - 0.328104675e-1 * t4933 - 0.36456075e-1 * t4939 - 0.20253375e-1 * t4945;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t4972 = t1286 * sigma[2];
  tv4sigma414 = -t4824 - t4924 - t4956 - t4957 - 0.65620935e-1 * t4933 - 0.7291215e-1 * t4939 - 0.4050675e-1 * t4945 + 0.98415e0 * t92 * t1330 * t1287 * t2309 + 0.164025e1 * t92 * t381 * t1293 * t1282 + 0.151875e1 * t92 * t146 / t4972 * t335 + 0.84375e0 * t92 * t61 / t25 / t4972 * t28;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

