; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

;; SETEQ
define void @v16i8_icmp_eq_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v16i8_icmp_eq_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vseqi.b $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %cmp = icmp eq <16 x i8> %v0, <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v16i8_icmp_eq(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_eq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vseq.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp eq <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_eq_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v8i16_icmp_eq_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vseqi.h $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %cmp = icmp eq <8 x i16> %v0, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_eq(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_eq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vseq.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp eq <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_eq_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v4i32_icmp_eq_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vseqi.w $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %cmp = icmp eq <4 x i32> %v0, <i32 15, i32 15, i32 15, i32 15>
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_eq(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_eq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vseq.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp eq <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_eq_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v2i64_icmp_eq_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vseqi.d $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %cmp = icmp eq <2 x i64> %v0, <i64 15, i64 15>
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_eq(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_eq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vseq.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp eq <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; SETLE
define void @v16i8_icmp_sle_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v16i8_icmp_sle_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslei.b $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %cmp = icmp sle <16 x i8> %v0, <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v16i8_icmp_sle(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_sle:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsle.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp sle <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_sle_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v8i16_icmp_sle_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslei.h $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %cmp = icmp sle <8 x i16> %v0, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_sle(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_sle:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsle.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp sle <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_sle_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v4i32_icmp_sle_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslei.w $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %cmp = icmp sle <4 x i32> %v0, <i32 15, i32 15, i32 15, i32 15>
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_sle(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_sle:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsle.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp sle <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_sle_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v2i64_icmp_sle_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslei.d $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %cmp = icmp sle <2 x i64> %v0, <i64 15, i64 15>
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_sle(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_sle:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsle.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp sle <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; SETULE
define void @v16i8_icmp_ule_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v16i8_icmp_ule_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslei.bu $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %cmp = icmp ule <16 x i8> %v0, <i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31>
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v16i8_icmp_ule(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsle.bu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp ule <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_ule_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v8i16_icmp_ule_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslei.hu $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %cmp = icmp ule <8 x i16> %v0, <i16 31, i16 31, i16 31, i16 31, i16 31, i16 31, i16 31, i16 31>
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_ule(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsle.hu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp ule <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_ule_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v4i32_icmp_ule_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslei.wu $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %cmp = icmp ule <4 x i32> %v0, <i32 31, i32 31, i32 31, i32 31>
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_ule(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsle.wu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp ule <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_ule_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v2i64_icmp_ule_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslei.du $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %cmp = icmp ule <2 x i64> %v0, <i64 31, i64 31>
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_ule(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vsle.du $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp ule <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; SETLT
define void @v16i8_icmp_slt_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v16i8_icmp_slt_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslti.b $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %cmp = icmp slt <16 x i8> %v0, <i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15, i8 15>
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v16i8_icmp_slt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_slt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp slt <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_slt_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v8i16_icmp_slt_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslti.h $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %cmp = icmp slt <8 x i16> %v0, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_slt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_slt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vslt.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp slt <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_slt_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v4i32_icmp_slt_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslti.w $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %cmp = icmp slt <4 x i32> %v0, <i32 15, i32 15, i32 15, i32 15>
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_slt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_slt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vslt.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp slt <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_slt_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v2i64_icmp_slt_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslti.d $vr0, $vr0, 15
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %cmp = icmp slt <2 x i64> %v0, <i64 15, i64 15>
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_slt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_slt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vslt.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp slt <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; SETULT
define void @v16i8_icmp_ult_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v16i8_icmp_ult_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslti.bu $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %cmp = icmp ult <16 x i8> %v0, <i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31, i8 31>
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v16i8_icmp_ult(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vslt.bu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp ult <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_ult_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v8i16_icmp_ult_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslti.hu $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %cmp = icmp ult <8 x i16> %v0, <i16 31, i16 31, i16 31, i16 31, i16 31, i16 31, i16 31, i16 31>
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_ult(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vslt.hu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp ult <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_ult_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v4i32_icmp_ult_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslti.wu $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %cmp = icmp ult <4 x i32> %v0, <i32 31, i32 31, i32 31, i32 31>
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_ult(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vslt.wu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp ult <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_ult_imm(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: v2i64_icmp_ult_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vslti.du $vr0, $vr0, 31
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %cmp = icmp ult <2 x i64> %v0, <i64 31, i64 31>
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_ult(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vslt.du $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp ult <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; Expand SETNE
define void @v16i8_icmp_ne(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_ne:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vseq.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vxori.b $vr0, $vr0, 255
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp ne <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_ne(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_ne:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vseq.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vrepli.b $vr1, -1
; CHECK-NEXT:    vxor.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp ne <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_ne(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_ne:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vseq.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vrepli.b $vr1, -1
; CHECK-NEXT:    vxor.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp ne <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_ne(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_ne:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a2, 0
; CHECK-NEXT:    vld $vr1, $a1, 0
; CHECK-NEXT:    vseq.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vrepli.b $vr1, -1
; CHECK-NEXT:    vxor.v $vr0, $vr0, $vr1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp ne <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; Expand SETGE
define void @v16i8_icmp_sge(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_sge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vsle.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp sge <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_sge(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_sge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vsle.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp sge <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_sge(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_sge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vsle.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp sge <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_sge(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_sge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vsle.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp sge <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; Expand SETUGE
define void @v16i8_icmp_uge(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vsle.bu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp uge <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_uge(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vsle.hu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp uge <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_uge(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vsle.wu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp uge <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_uge(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vsle.du $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp uge <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; Expand SETGT
define void @v16i8_icmp_sgt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_sgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vslt.b $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp sgt <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_sgt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_sgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vslt.h $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp sgt <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_sgt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_sgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vslt.w $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp sgt <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_sgt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_sgt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vslt.d $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp sgt <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}

;; Expand SETUGT
define void @v16i8_icmp_ugt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v16i8_icmp_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vslt.bu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <16 x i8>, ptr %a0
  %v1 = load <16 x i8>, ptr %a1
  %cmp = icmp ugt <16 x i8> %v0, %v1
  %ext = sext <16 x i1> %cmp to <16 x i8>
  store <16 x i8> %ext, ptr %res
  ret void
}

define void @v8i16_icmp_ugt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v8i16_icmp_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vslt.hu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <8 x i16>, ptr %a0
  %v1 = load <8 x i16>, ptr %a1
  %cmp = icmp ugt <8 x i16> %v0, %v1
  %ext = sext <8 x i1> %cmp to <8 x i16>
  store <8 x i16> %ext, ptr %res
  ret void
}

define void @v4i32_icmp_ugt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v4i32_icmp_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vslt.wu $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <4 x i32>, ptr %a0
  %v1 = load <4 x i32>, ptr %a1
  %cmp = icmp ugt <4 x i32> %v0, %v1
  %ext = sext <4 x i1> %cmp to <4 x i32>
  store <4 x i32> %ext, ptr %res
  ret void
}

define void @v2i64_icmp_ugt(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: v2i64_icmp_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vslt.du $vr0, $vr1, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
  %v0 = load <2 x i64>, ptr %a0
  %v1 = load <2 x i64>, ptr %a1
  %cmp = icmp ugt <2 x i64> %v0, %v1
  %ext = sext <2 x i1> %cmp to <2 x i64>
  store <2 x i64> %ext, ptr %res
  ret void
}
