; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=loop-distribute -enable-loop-distribute -S < %s | \
; RUN:     FileCheck %s --check-prefix=DEFAULT

; RUN: opt -passes=loop-distribute -enable-loop-distribute -S -enable-mem-access-versioning=0 < %s | \
; RUN:     FileCheck %s --check-prefix=NO-VERSION

; If we don't speculate stride for 1 we can't distribute along the line
; because we could have a backward dependence:
;
;   for (i = 0; i < n; i++) {
;     A[i + 1] = A[i] * B[i];
;     =======================
;     C[i] = D[i] * A[stride * i];
;   }

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.10.0"

define void @f(ptr noalias %a,
;
;
; DEFAULT-LABEL: @f(
; DEFAULT-NEXT:  entry:
; DEFAULT-NEXT:    br label [[FOR_BODY_LVER_CHECK:%.*]]
; DEFAULT:       for.body.lver.check:
; DEFAULT-NEXT:    [[IDENT_CHECK:%.*]] = icmp ne i64 [[STRIDE:%.*]], 1
; DEFAULT-NEXT:    br i1 [[IDENT_CHECK]], label [[FOR_BODY_PH_LVER_ORIG:%.*]], label [[FOR_BODY_PH_LDIST1:%.*]]
; DEFAULT:       for.body.ph.lver.orig:
; DEFAULT-NEXT:    br label [[FOR_BODY_LVER_ORIG:%.*]]
; DEFAULT:       for.body.lver.orig:
; DEFAULT-NEXT:    [[IND_LVER_ORIG:%.*]] = phi i64 [ 0, [[FOR_BODY_PH_LVER_ORIG]] ], [ [[ADD_LVER_ORIG:%.*]], [[FOR_BODY_LVER_ORIG]] ]
; DEFAULT-NEXT:    [[ARRAYIDXA_LVER_ORIG:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[IND_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOADA_LVER_ORIG:%.*]] = load i32, ptr [[ARRAYIDXA_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[ARRAYIDXB_LVER_ORIG:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i64 [[IND_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOADB_LVER_ORIG:%.*]] = load i32, ptr [[ARRAYIDXB_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[MULA_LVER_ORIG:%.*]] = mul i32 [[LOADB_LVER_ORIG]], [[LOADA_LVER_ORIG]]
; DEFAULT-NEXT:    [[ADD_LVER_ORIG]] = add nuw nsw i64 [[IND_LVER_ORIG]], 1
; DEFAULT-NEXT:    [[ARRAYIDXA_PLUS_4_LVER_ORIG:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[ADD_LVER_ORIG]]
; DEFAULT-NEXT:    store i32 [[MULA_LVER_ORIG]], ptr [[ARRAYIDXA_PLUS_4_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[ARRAYIDXD_LVER_ORIG:%.*]] = getelementptr inbounds i32, ptr [[D:%.*]], i64 [[IND_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOADD_LVER_ORIG:%.*]] = load i32, ptr [[ARRAYIDXD_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[MUL_LVER_ORIG:%.*]] = mul i64 [[IND_LVER_ORIG]], [[STRIDE]]
; DEFAULT-NEXT:    [[ARRAYIDXSTRIDEDA_LVER_ORIG:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[MUL_LVER_ORIG]]
; DEFAULT-NEXT:    [[LOADSTRIDEDA_LVER_ORIG:%.*]] = load i32, ptr [[ARRAYIDXSTRIDEDA_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[MULC_LVER_ORIG:%.*]] = mul i32 [[LOADD_LVER_ORIG]], [[LOADSTRIDEDA_LVER_ORIG]]
; DEFAULT-NEXT:    [[ARRAYIDXC_LVER_ORIG:%.*]] = getelementptr inbounds i32, ptr [[C:%.*]], i64 [[IND_LVER_ORIG]]
; DEFAULT-NEXT:    store i32 [[MULC_LVER_ORIG]], ptr [[ARRAYIDXC_LVER_ORIG]], align 4
; DEFAULT-NEXT:    [[EXITCOND_LVER_ORIG:%.*]] = icmp eq i64 [[ADD_LVER_ORIG]], 20
; DEFAULT-NEXT:    br i1 [[EXITCOND_LVER_ORIG]], label [[FOR_END_LOOPEXIT:%.*]], label [[FOR_BODY_LVER_ORIG]]
; DEFAULT:       for.body.ph.ldist1:
; DEFAULT-NEXT:    br label [[FOR_BODY_LDIST1:%.*]]
; DEFAULT:       for.body.ldist1:
; DEFAULT-NEXT:    [[IND_LDIST1:%.*]] = phi i64 [ 0, [[FOR_BODY_PH_LDIST1]] ], [ [[ADD_LDIST1:%.*]], [[FOR_BODY_LDIST1]] ]
; DEFAULT-NEXT:    [[ARRAYIDXA_LDIST1:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[IND_LDIST1]]
; DEFAULT-NEXT:    [[LOADA_LDIST1:%.*]] = load i32, ptr [[ARRAYIDXA_LDIST1]], align 4
; DEFAULT-NEXT:    [[ARRAYIDXB_LDIST1:%.*]] = getelementptr inbounds i32, ptr [[B]], i64 [[IND_LDIST1]]
; DEFAULT-NEXT:    [[LOADB_LDIST1:%.*]] = load i32, ptr [[ARRAYIDXB_LDIST1]], align 4
; DEFAULT-NEXT:    [[MULA_LDIST1:%.*]] = mul i32 [[LOADB_LDIST1]], [[LOADA_LDIST1]]
; DEFAULT-NEXT:    [[ADD_LDIST1]] = add nuw nsw i64 [[IND_LDIST1]], 1
; DEFAULT-NEXT:    [[ARRAYIDXA_PLUS_4_LDIST1:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[ADD_LDIST1]]
; DEFAULT-NEXT:    store i32 [[MULA_LDIST1]], ptr [[ARRAYIDXA_PLUS_4_LDIST1]], align 4
; DEFAULT-NEXT:    [[EXITCOND_LDIST1:%.*]] = icmp eq i64 [[ADD_LDIST1]], 20
; DEFAULT-NEXT:    br i1 [[EXITCOND_LDIST1]], label [[FOR_BODY_PH:%.*]], label [[FOR_BODY_LDIST1]]
; DEFAULT:       for.body.ph:
; DEFAULT-NEXT:    br label [[FOR_BODY:%.*]]
; DEFAULT:       for.body:
; DEFAULT-NEXT:    [[IND:%.*]] = phi i64 [ 0, [[FOR_BODY_PH]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; DEFAULT-NEXT:    [[ADD]] = add nuw nsw i64 [[IND]], 1
; DEFAULT-NEXT:    [[ARRAYIDXD:%.*]] = getelementptr inbounds i32, ptr [[D]], i64 [[IND]]
; DEFAULT-NEXT:    [[LOADD:%.*]] = load i32, ptr [[ARRAYIDXD]], align 4
; DEFAULT-NEXT:    [[MUL:%.*]] = mul i64 [[IND]], [[STRIDE]]
; DEFAULT-NEXT:    [[ARRAYIDXSTRIDEDA:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[MUL]]
; DEFAULT-NEXT:    [[LOADSTRIDEDA:%.*]] = load i32, ptr [[ARRAYIDXSTRIDEDA]], align 4
; DEFAULT-NEXT:    [[MULC:%.*]] = mul i32 [[LOADD]], [[LOADSTRIDEDA]]
; DEFAULT-NEXT:    [[ARRAYIDXC:%.*]] = getelementptr inbounds i32, ptr [[C]], i64 [[IND]]
; DEFAULT-NEXT:    store i32 [[MULC]], ptr [[ARRAYIDXC]], align 4
; DEFAULT-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[ADD]], 20
; DEFAULT-NEXT:    br i1 [[EXITCOND]], label [[FOR_END_LOOPEXIT1:%.*]], label [[FOR_BODY]]
; DEFAULT:       for.end.loopexit:
; DEFAULT-NEXT:    br label [[FOR_END:%.*]]
; DEFAULT:       for.end.loopexit1:
; DEFAULT-NEXT:    br label [[FOR_END]]
; DEFAULT:       for.end:
; DEFAULT-NEXT:    ret void
;
; NO-VERSION-LABEL: @f(
; NO-VERSION-NEXT:  entry:
; NO-VERSION-NEXT:    br label [[FOR_BODY:%.*]]
; NO-VERSION:       for.body:
; NO-VERSION-NEXT:    [[IND:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; NO-VERSION-NEXT:    [[ARRAYIDXA:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[IND]]
; NO-VERSION-NEXT:    [[LOADA:%.*]] = load i32, ptr [[ARRAYIDXA]], align 4
; NO-VERSION-NEXT:    [[ARRAYIDXB:%.*]] = getelementptr inbounds i32, ptr [[B:%.*]], i64 [[IND]]
; NO-VERSION-NEXT:    [[LOADB:%.*]] = load i32, ptr [[ARRAYIDXB]], align 4
; NO-VERSION-NEXT:    [[MULA:%.*]] = mul i32 [[LOADB]], [[LOADA]]
; NO-VERSION-NEXT:    [[ADD]] = add nuw nsw i64 [[IND]], 1
; NO-VERSION-NEXT:    [[ARRAYIDXA_PLUS_4:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[ADD]]
; NO-VERSION-NEXT:    store i32 [[MULA]], ptr [[ARRAYIDXA_PLUS_4]], align 4
; NO-VERSION-NEXT:    [[ARRAYIDXD:%.*]] = getelementptr inbounds i32, ptr [[D:%.*]], i64 [[IND]]
; NO-VERSION-NEXT:    [[LOADD:%.*]] = load i32, ptr [[ARRAYIDXD]], align 4
; NO-VERSION-NEXT:    [[MUL:%.*]] = mul i64 [[IND]], [[STRIDE:%.*]]
; NO-VERSION-NEXT:    [[ARRAYIDXSTRIDEDA:%.*]] = getelementptr inbounds i32, ptr [[A]], i64 [[MUL]]
; NO-VERSION-NEXT:    [[LOADSTRIDEDA:%.*]] = load i32, ptr [[ARRAYIDXSTRIDEDA]], align 4
; NO-VERSION-NEXT:    [[MULC:%.*]] = mul i32 [[LOADD]], [[LOADSTRIDEDA]]
; NO-VERSION-NEXT:    [[ARRAYIDXC:%.*]] = getelementptr inbounds i32, ptr [[C:%.*]], i64 [[IND]]
; NO-VERSION-NEXT:    store i32 [[MULC]], ptr [[ARRAYIDXC]], align 4
; NO-VERSION-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[ADD]], 20
; NO-VERSION-NEXT:    br i1 [[EXITCOND]], label [[FOR_END:%.*]], label [[FOR_BODY]]
; NO-VERSION:       for.end:
; NO-VERSION-NEXT:    ret void
;
  i32* noalias %b,
  ptr noalias %c,
  ptr noalias %d,
  i64 %stride) {
entry:
  br label %for.body



for.body:                                         ; preds = %for.body, %entry
  %ind = phi i64 [ 0, %entry ], [ %add, %for.body ]

  %arrayidxA = getelementptr inbounds i32, ptr %a, i64 %ind
  %loadA = load i32, ptr %arrayidxA, align 4

  %arrayidxB = getelementptr inbounds i32, ptr %b, i64 %ind
  %loadB = load i32, ptr %arrayidxB, align 4

  %mulA = mul i32 %loadB, %loadA

  %add = add nuw nsw i64 %ind, 1
  %arrayidxA_plus_4 = getelementptr inbounds i32, ptr %a, i64 %add
  store i32 %mulA, ptr %arrayidxA_plus_4, align 4

  %arrayidxD = getelementptr inbounds i32, ptr %d, i64 %ind
  %loadD = load i32, ptr %arrayidxD, align 4

  %mul = mul i64 %ind, %stride
  %arrayidxStridedA = getelementptr inbounds i32, ptr %a, i64 %mul
  %loadStridedA = load i32, ptr %arrayidxStridedA, align 4

  %mulC = mul i32 %loadD, %loadStridedA

  %arrayidxC = getelementptr inbounds i32, ptr %c, i64 %ind
  store i32 %mulC, ptr %arrayidxC, align 4

  %exitcond = icmp eq i64 %add, 20
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}
