# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-u74 -mattr=+zba,+zbb -timeline \
# RUN:   -timeline-max-cycles=1000 -iterations=1 < %s | FileCheck %s

lui a0, 1
auipc a1, 1
add a0, a0, a1
addi a0, a0, 1
addw a0, a0, a0
addiw a0, a0, 1
sub a0, a0, a0
subw a0, a0, a0
and a0, a0, a0
andi a0, a0, 1
or a0, a0, a0
ori a0, a0, 1
xor a0, a0, a0
xori a0, a0, 1
sll a0, a0, a0
slli a0, a0, 1
sllw a0, a0, a0
slliw a0, a0, 1
srl a0, a0, a0
srli a0, a0, 1
srlw a0, a0, a0
srliw a0, a0, 1
sra a0, a0, a0
srai a0, a0, 1
sraw a0, a0, a0
sraiw a0, a0, 1
slt a0, a0, a0
slti a0, a0, 1
sltu a0, a0, a0
sltiu a0, a0, 1
mul a0, a0, a0
add a0, a0, a0
mulw a0, a0, a0
add a0, a0, a0
beq a0, a0, 1f
1:
add a0, a0, a0
bne a0, a0, 1f
1:
add a0, a0, a0
blt a0, a0, 1f
1:
add a0, a0, a0
bltu a0, a0, 1f
1:
add a0, a0, a0
bge a0, a0, 1f
1:
add a0, a0, a0
bgeu a0, a0, 1f
1:
# zba
add.uw a0, a0, a0
slli.uw a0, a0, 1
sh1add.uw a0, a0, a0
sh2add.uw a0, a0, a0
sh3add.uw a0, a0, a0
sh1add a0, a0, a0
sh2add a0, a0, a0
sh3add a0, a0, a0
# zbb
andn a0, a0, a0
orn a0, a0, a0
xnor a0, a0, a0
sext.b a0, a0
sext.h a0, a0
zext.h a0, a0
min a0, a0, a0
minu a0, a0, a0
max a0, a0, a0
maxu a0, a0, a0
rol a0, a0, a0
ror a0, a0, a0
rori a0, a0, 1
clz a0, a0
clzw a0, a0
ctz a0, a0
ctzw a0, a0
cpop a0, a0
add a0, a0, a0
cpopw a0, a0
add a0, a0, a0
rev8 a0, a0
orc.b a0, a0
lb a0, 0(a0)
add a0, a0, a0
lh a0, 0(a0)
and a0, a0, a0
lw a0, 0(a0)
or a0, a0, a0
ld a0, 0(a0)
xor a0, a0, a0
lbu a0, 0(a0)
addi a0, a0, 1
lhu a0, 0(a0)
sub a0, a0, a0
lwu a0, 0(a0)
addw a0, a0, a0
jr a0

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      91
# CHECK-NEXT: Total Cycles:      109
# CHECK-NEXT: Total uOps:        91

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.83
# CHECK-NEXT: IPC:               0.83
# CHECK-NEXT: Block RThroughput: 45.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     0.50                        lui	a0, 1
# CHECK-NEXT:  1      3     0.50                        auipc	a1, 1
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a1
# CHECK-NEXT:  1      3     0.50                        addi	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        addw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        addiw	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        sub	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        subw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        and	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        andi	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        or	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        ori	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        xor	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        xori	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        sll	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        slli	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        sllw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        slliw	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        srl	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        srli	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        srlw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        srliw	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        sra	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        srai	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        sraw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        sraiw	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        slt	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        slti	a0, a0, 1
# CHECK-NEXT:  1      3     0.50                        sltu	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        seqz	a0, a0
# CHECK-NEXT:  1      3     1.00                        mul	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        mulw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        beq	a0, a0, .Ltmp0
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        bne	a0, a0, .Ltmp1
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        blt	a0, a0, .Ltmp2
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        bltu	a0, a0, .Ltmp3
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        bge	a0, a0, .Ltmp4
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        bgeu	a0, a0, .Ltmp5
# CHECK-NEXT:  1      3     0.50                        add.uw	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        slli.uw	a0, a0, 1
# CHECK-NEXT:  1      3     1.00                        sh1add.uw	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        sh2add.uw	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        sh3add.uw	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        sh1add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        sh2add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        sh3add	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        andn	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        orn	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        xnor	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        sext.b	a0, a0
# CHECK-NEXT:  1      3     0.50                        sext.h	a0, a0
# CHECK-NEXT:  1      3     0.50                        zext.h	a0, a0
# CHECK-NEXT:  1      3     0.50                        min	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        minu	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        max	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        maxu	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        rol	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        ror	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        rori	a0, a0, 1
# CHECK-NEXT:  1      3     1.00                        clz	a0, a0
# CHECK-NEXT:  1      3     1.00                        clzw	a0, a0
# CHECK-NEXT:  1      3     1.00                        ctz	a0, a0
# CHECK-NEXT:  1      3     1.00                        ctzw	a0, a0
# CHECK-NEXT:  1      3     1.00                        cpop	a0, a0
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        cpopw	a0, a0
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     0.50                        rev8	a0, a0
# CHECK-NEXT:  1      3     1.00                        orc.b	a0, a0
# CHECK-NEXT:  1      3     1.00    *                   lb	a0, 0(a0)
# CHECK-NEXT:  1      3     0.50                        add	a0, a0, a0
# CHECK-NEXT:  1      3     1.00    *                   lh	a0, 0(a0)
# CHECK-NEXT:  1      3     0.50                        and	a0, a0, a0
# CHECK-NEXT:  1      3     1.00    *                   lw	a0, 0(a0)
# CHECK-NEXT:  1      3     0.50                        or	a0, a0, a0
# CHECK-NEXT:  1      3     1.00    *                   ld	a0, 0(a0)
# CHECK-NEXT:  1      3     0.50                        xor	a0, a0, a0
# CHECK-NEXT:  1      3     1.00    *                   lbu	a0, 0(a0)
# CHECK-NEXT:  1      3     0.50                        addi	a0, a0, 1
# CHECK-NEXT:  1      3     1.00    *                   lhu	a0, 0(a0)
# CHECK-NEXT:  1      3     0.50                        sub	a0, a0, a0
# CHECK-NEXT:  1      3     1.00    *                   lwu	a0, 0(a0)
# CHECK-NEXT:  1      3     0.50                        addw	a0, a0, a0
# CHECK-NEXT:  1      3     1.00                        jr	a0

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFive7FDiv
# CHECK-NEXT: [1]   - SiFive7IDiv
# CHECK-NEXT: [2]   - SiFive7PipeA
# CHECK-NEXT: [3]   - SiFive7PipeB
# CHECK-NEXT: [4]   - SiFive7VA
# CHECK-NEXT: [5]   - SiFive7VCQ
# CHECK-NEXT: [6]   - SiFive7VL
# CHECK-NEXT: [7]   - SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -     39.00  52.00   -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     lui	a0, 1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     auipc	a1, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     add	a0, a0, a1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     addi	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     addw	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     addiw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sub	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     subw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     and	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     andi	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     or	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     ori	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     xor	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     xori	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sll	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     slli	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sllw	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     slliw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     srl	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     srli	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     srlw	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     srliw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sra	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     srai	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sraw	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     sraiw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     slt	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     slti	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sltu	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     seqz	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     mul	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     mulw	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     beq	a0, a0, .Ltmp0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     bne	a0, a0, .Ltmp1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     blt	a0, a0, .Ltmp2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     bltu	a0, a0, .Ltmp3
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     bge	a0, a0, .Ltmp4
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     bgeu	a0, a0, .Ltmp5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add.uw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     slli.uw	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh1add.uw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh2add.uw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh3add.uw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh1add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh2add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sh3add	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     andn	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     orn	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     xnor	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     sext.b	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sext.h	a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     zext.h	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     min	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     minu	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     max	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     maxu	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     rol	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     ror	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     rori	a0, a0, 1
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     clz	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     clzw	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     ctz	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     ctzw	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     cpop	a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     cpopw	a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     rev8	a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     orc.b	a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     lb	a0, 0(a0)
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     add	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     lh	a0, 0(a0)
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     and	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     lw	a0, 0(a0)
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     or	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     ld	a0, 0(a0)
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     xor	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     lbu	a0, 0(a0)
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     addi	a0, a0, 1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     lhu	a0, 0(a0)
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     sub	a0, a0, a0
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     lwu	a0, 0(a0)
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     addw	a0, a0, a0
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -     jr	a0

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789          0123456789          0123456789          0123456789
# CHECK-NEXT: Index     0123456789          0123456789          0123456789          0123456789          0123456789          012345678

# CHECK:      [0,0]     DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   lui	a0, 1
# CHECK-NEXT: [0,1]     DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   auipc	a1, 1
# CHECK-NEXT: [0,2]     .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	a0, a0, a1
# CHECK-NEXT: [0,3]     . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   addi	a0, a0, 1
# CHECK-NEXT: [0,4]     .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   addw	a0, a0, a0
# CHECK-NEXT: [0,5]     .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   addiw	a0, a0, 1
# CHECK-NEXT: [0,6]     .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   sub	a0, a0, a0
# CHECK-NEXT: [0,7]     .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   subw	a0, a0, a0
# CHECK-NEXT: [0,8]     .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   and	a0, a0, a0
# CHECK-NEXT: [0,9]     .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   andi	a0, a0, 1
# CHECK-NEXT: [0,10]    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   or	a0, a0, a0
# CHECK-NEXT: [0,11]    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   ori	a0, a0, 1
# CHECK-NEXT: [0,12]    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   xor	a0, a0, a0
# CHECK-NEXT: [0,13]    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   xori	a0, a0, 1
# CHECK-NEXT: [0,14]    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   sll	a0, a0, a0
# CHECK-NEXT: [0,15]    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   slli	a0, a0, 1
# CHECK-NEXT: [0,16]    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   sllw	a0, a0, a0
# CHECK-NEXT: [0,17]    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   slliw	a0, a0, 1
# CHECK-NEXT: [0,18]    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   srl	a0, a0, a0
# CHECK-NEXT: [0,19]    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   srli	a0, a0, 1
# CHECK-NEXT: [0,20]    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   srlw	a0, a0, a0
# CHECK-NEXT: [0,21]    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   srliw	a0, a0, 1
# CHECK-NEXT: [0,22]    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   sra	a0, a0, a0
# CHECK-NEXT: [0,23]    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   srai	a0, a0, 1
# CHECK-NEXT: [0,24]    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   sraw	a0, a0, a0
# CHECK-NEXT: [0,25]    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   sraiw	a0, a0, 1
# CHECK-NEXT: [0,26]    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   slt	a0, a0, a0
# CHECK-NEXT: [0,27]    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   slti	a0, a0, 1
# CHECK-NEXT: [0,28]    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   sltu	a0, a0, a0
# CHECK-NEXT: [0,29]    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   seqz	a0, a0
# CHECK-NEXT: [0,30]    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   mul	a0, a0, a0
# CHECK-NEXT: [0,31]    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,32]    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   mulw	a0, a0, a0
# CHECK-NEXT: [0,33]    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,34]    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .  .   beq	a0, a0, .Ltmp0
# CHECK-NEXT: [0,35]    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,36]    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .  .   bne	a0, a0, .Ltmp1
# CHECK-NEXT: [0,37]    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,38]    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .  .   blt	a0, a0, .Ltmp2
# CHECK-NEXT: [0,39]    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,40]    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .  .   bltu	a0, a0, .Ltmp3
# CHECK-NEXT: [0,41]    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,42]    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .  .   bge	a0, a0, .Ltmp4
# CHECK-NEXT: [0,43]    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,44]    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .  .   bgeu	a0, a0, .Ltmp5
# CHECK-NEXT: [0,45]    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .  .   add.uw	a0, a0, a0
# CHECK-NEXT: [0,46]    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .  .   slli.uw	a0, a0, 1
# CHECK-NEXT: [0,47]    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .  .   sh1add.uw	a0, a0, a0
# CHECK-NEXT: [0,48]    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .  .   sh2add.uw	a0, a0, a0
# CHECK-NEXT: [0,49]    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .  .   sh3add.uw	a0, a0, a0
# CHECK-NEXT: [0,50]    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .  .   sh1add	a0, a0, a0
# CHECK-NEXT: [0,51]    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .  .   sh2add	a0, a0, a0
# CHECK-NEXT: [0,52]    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .  .   sh3add	a0, a0, a0
# CHECK-NEXT: [0,53]    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .  .   andn	a0, a0, a0
# CHECK-NEXT: [0,54]    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .  .   orn	a0, a0, a0
# CHECK-NEXT: [0,55]    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .  .   xnor	a0, a0, a0
# CHECK-NEXT: [0,56]    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .  .   sext.b	a0, a0
# CHECK-NEXT: [0,57]    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .  .   sext.h	a0, a0
# CHECK-NEXT: [0,58]    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .  .   zext.h	a0, a0
# CHECK-NEXT: [0,59]    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .  .   min	a0, a0, a0
# CHECK-NEXT: [0,60]    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .  .   minu	a0, a0, a0
# CHECK-NEXT: [0,61]    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .  .   max	a0, a0, a0
# CHECK-NEXT: [0,62]    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .  .   maxu	a0, a0, a0
# CHECK-NEXT: [0,63]    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .  .   rol	a0, a0, a0
# CHECK-NEXT: [0,64]    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .  .   ror	a0, a0, a0
# CHECK-NEXT: [0,65]    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .  .   rori	a0, a0, 1
# CHECK-NEXT: [0,66]    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .  .   clz	a0, a0
# CHECK-NEXT: [0,67]    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .  .   clzw	a0, a0
# CHECK-NEXT: [0,68]    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .  .   ctz	a0, a0
# CHECK-NEXT: [0,69]    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .  .   ctzw	a0, a0
# CHECK-NEXT: [0,70]    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .  .   cpop	a0, a0
# CHECK-NEXT: [0,71]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,72]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .  .   cpopw	a0, a0
# CHECK-NEXT: [0,73]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,74]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .  .   rev8	a0, a0
# CHECK-NEXT: [0,75]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .  .   orc.b	a0, a0
# CHECK-NEXT: [0,76]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .  .   lb	a0, 0(a0)
# CHECK-NEXT: [0,77]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .  .   add	a0, a0, a0
# CHECK-NEXT: [0,78]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .  .   lh	a0, 0(a0)
# CHECK-NEXT: [0,79]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .  .   and	a0, a0, a0
# CHECK-NEXT: [0,80]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .  .   lw	a0, 0(a0)
# CHECK-NEXT: [0,81]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .  .   or	a0, a0, a0
# CHECK-NEXT: [0,82]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .  .   ld	a0, 0(a0)
# CHECK-NEXT: [0,83]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .  .   xor	a0, a0, a0
# CHECK-NEXT: [0,84]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .  .   lbu	a0, 0(a0)
# CHECK-NEXT: [0,85]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .  .   addi	a0, a0, 1
# CHECK-NEXT: [0,86]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .  .   lhu	a0, 0(a0)
# CHECK-NEXT: [0,87]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .  .   sub	a0, a0, a0
# CHECK-NEXT: [0,88]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE .   lwu	a0, 0(a0)
# CHECK-NEXT: [0,89]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE.   addw	a0, a0, a0
# CHECK-NEXT: [0,90]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE   jr	a0

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       lui	a0, 1
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       auipc	a1, 1
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       add	a0, a0, a1
# CHECK-NEXT: 3.     1     0.0    0.0    0.0       addi	a0, a0, 1
# CHECK-NEXT: 4.     1     0.0    0.0    0.0       addw	a0, a0, a0
# CHECK-NEXT: 5.     1     0.0    0.0    0.0       addiw	a0, a0, 1
# CHECK-NEXT: 6.     1     0.0    0.0    0.0       sub	a0, a0, a0
# CHECK-NEXT: 7.     1     0.0    0.0    0.0       subw	a0, a0, a0
# CHECK-NEXT: 8.     1     0.0    0.0    0.0       and	a0, a0, a0
# CHECK-NEXT: 9.     1     0.0    0.0    0.0       andi	a0, a0, 1
# CHECK-NEXT: 10.    1     0.0    0.0    0.0       or	a0, a0, a0
# CHECK-NEXT: 11.    1     0.0    0.0    0.0       ori	a0, a0, 1
# CHECK-NEXT: 12.    1     0.0    0.0    0.0       xor	a0, a0, a0
# CHECK-NEXT: 13.    1     0.0    0.0    0.0       xori	a0, a0, 1
# CHECK-NEXT: 14.    1     0.0    0.0    0.0       sll	a0, a0, a0
# CHECK-NEXT: 15.    1     0.0    0.0    0.0       slli	a0, a0, 1
# CHECK-NEXT: 16.    1     0.0    0.0    0.0       sllw	a0, a0, a0
# CHECK-NEXT: 17.    1     0.0    0.0    0.0       slliw	a0, a0, 1
# CHECK-NEXT: 18.    1     0.0    0.0    0.0       srl	a0, a0, a0
# CHECK-NEXT: 19.    1     0.0    0.0    0.0       srli	a0, a0, 1
# CHECK-NEXT: 20.    1     0.0    0.0    0.0       srlw	a0, a0, a0
# CHECK-NEXT: 21.    1     0.0    0.0    0.0       srliw	a0, a0, 1
# CHECK-NEXT: 22.    1     0.0    0.0    0.0       sra	a0, a0, a0
# CHECK-NEXT: 23.    1     0.0    0.0    0.0       srai	a0, a0, 1
# CHECK-NEXT: 24.    1     0.0    0.0    0.0       sraw	a0, a0, a0
# CHECK-NEXT: 25.    1     0.0    0.0    0.0       sraiw	a0, a0, 1
# CHECK-NEXT: 26.    1     0.0    0.0    0.0       slt	a0, a0, a0
# CHECK-NEXT: 27.    1     0.0    0.0    0.0       slti	a0, a0, 1
# CHECK-NEXT: 28.    1     0.0    0.0    0.0       sltu	a0, a0, a0
# CHECK-NEXT: 29.    1     0.0    0.0    0.0       seqz	a0, a0
# CHECK-NEXT: 30.    1     0.0    0.0    0.0       mul	a0, a0, a0
# CHECK-NEXT: 31.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 32.    1     0.0    0.0    0.0       mulw	a0, a0, a0
# CHECK-NEXT: 33.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 34.    1     0.0    0.0    0.0       beq	a0, a0, .Ltmp0
# CHECK-NEXT: 35.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 36.    1     0.0    0.0    0.0       bne	a0, a0, .Ltmp1
# CHECK-NEXT: 37.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 38.    1     0.0    0.0    0.0       blt	a0, a0, .Ltmp2
# CHECK-NEXT: 39.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 40.    1     0.0    0.0    0.0       bltu	a0, a0, .Ltmp3
# CHECK-NEXT: 41.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 42.    1     0.0    0.0    0.0       bge	a0, a0, .Ltmp4
# CHECK-NEXT: 43.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 44.    1     0.0    0.0    0.0       bgeu	a0, a0, .Ltmp5
# CHECK-NEXT: 45.    1     0.0    0.0    0.0       add.uw	a0, a0, a0
# CHECK-NEXT: 46.    1     0.0    0.0    0.0       slli.uw	a0, a0, 1
# CHECK-NEXT: 47.    1     0.0    0.0    0.0       sh1add.uw	a0, a0, a0
# CHECK-NEXT: 48.    1     0.0    0.0    0.0       sh2add.uw	a0, a0, a0
# CHECK-NEXT: 49.    1     0.0    0.0    0.0       sh3add.uw	a0, a0, a0
# CHECK-NEXT: 50.    1     0.0    0.0    0.0       sh1add	a0, a0, a0
# CHECK-NEXT: 51.    1     0.0    0.0    0.0       sh2add	a0, a0, a0
# CHECK-NEXT: 52.    1     0.0    0.0    0.0       sh3add	a0, a0, a0
# CHECK-NEXT: 53.    1     0.0    0.0    0.0       andn	a0, a0, a0
# CHECK-NEXT: 54.    1     0.0    0.0    0.0       orn	a0, a0, a0
# CHECK-NEXT: 55.    1     0.0    0.0    0.0       xnor	a0, a0, a0
# CHECK-NEXT: 56.    1     0.0    0.0    0.0       sext.b	a0, a0
# CHECK-NEXT: 57.    1     0.0    0.0    0.0       sext.h	a0, a0
# CHECK-NEXT: 58.    1     0.0    0.0    0.0       zext.h	a0, a0
# CHECK-NEXT: 59.    1     0.0    0.0    0.0       min	a0, a0, a0
# CHECK-NEXT: 60.    1     0.0    0.0    0.0       minu	a0, a0, a0
# CHECK-NEXT: 61.    1     0.0    0.0    0.0       max	a0, a0, a0
# CHECK-NEXT: 62.    1     0.0    0.0    0.0       maxu	a0, a0, a0
# CHECK-NEXT: 63.    1     0.0    0.0    0.0       rol	a0, a0, a0
# CHECK-NEXT: 64.    1     0.0    0.0    0.0       ror	a0, a0, a0
# CHECK-NEXT: 65.    1     0.0    0.0    0.0       rori	a0, a0, 1
# CHECK-NEXT: 66.    1     0.0    0.0    0.0       clz	a0, a0
# CHECK-NEXT: 67.    1     0.0    0.0    0.0       clzw	a0, a0
# CHECK-NEXT: 68.    1     0.0    0.0    0.0       ctz	a0, a0
# CHECK-NEXT: 69.    1     0.0    0.0    0.0       ctzw	a0, a0
# CHECK-NEXT: 70.    1     0.0    0.0    0.0       cpop	a0, a0
# CHECK-NEXT: 71.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 72.    1     0.0    0.0    0.0       cpopw	a0, a0
# CHECK-NEXT: 73.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 74.    1     0.0    0.0    0.0       rev8	a0, a0
# CHECK-NEXT: 75.    1     0.0    0.0    0.0       orc.b	a0, a0
# CHECK-NEXT: 76.    1     0.0    0.0    0.0       lb	a0, 0(a0)
# CHECK-NEXT: 77.    1     0.0    0.0    0.0       add	a0, a0, a0
# CHECK-NEXT: 78.    1     0.0    0.0    0.0       lh	a0, 0(a0)
# CHECK-NEXT: 79.    1     0.0    0.0    0.0       and	a0, a0, a0
# CHECK-NEXT: 80.    1     0.0    0.0    0.0       lw	a0, 0(a0)
# CHECK-NEXT: 81.    1     0.0    0.0    0.0       or	a0, a0, a0
# CHECK-NEXT: 82.    1     0.0    0.0    0.0       ld	a0, 0(a0)
# CHECK-NEXT: 83.    1     0.0    0.0    0.0       xor	a0, a0, a0
# CHECK-NEXT: 84.    1     0.0    0.0    0.0       lbu	a0, 0(a0)
# CHECK-NEXT: 85.    1     0.0    0.0    0.0       addi	a0, a0, 1
# CHECK-NEXT: 86.    1     0.0    0.0    0.0       lhu	a0, 0(a0)
# CHECK-NEXT: 87.    1     0.0    0.0    0.0       sub	a0, a0, a0
# CHECK-NEXT: 88.    1     0.0    0.0    0.0       lwu	a0, 0(a0)
# CHECK-NEXT: 89.    1     0.0    0.0    0.0       addw	a0, a0, a0
# CHECK-NEXT: 90.    1     0.0    0.0    0.0       jr	a0
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
