; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-NOFP16
; RUN: llc -mtriple=aarch64 -mattr=+fullfp16 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-FP16
; RUN: llc -mtriple=aarch64 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-NOFP16
; RUN: llc -mtriple=aarch64 -mattr=+fullfp16 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-FP16

define double @sqrt_f64(double %a) {
; CHECK-LABEL: sqrt_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt d0, d0
; CHECK-NEXT:    ret
entry:
  %c = call double @llvm.sqrt.f64(double %a)
  ret double %c
}

define float @sqrt_f32(float %a) {
; CHECK-LABEL: sqrt_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt s0, s0
; CHECK-NEXT:    ret
entry:
  %c = call float @llvm.sqrt.f32(float %a)
  ret float %c
}

define half @sqrt_f16(half %a) {
; CHECK-SD-NOFP16-LABEL: sqrt_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fsqrt s0, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: sqrt_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    fsqrt h0, h0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: sqrt_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvt s0, h0
; CHECK-GI-NOFP16-NEXT:    fsqrt s0, s0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: sqrt_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    fsqrt h0, h0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call half @llvm.sqrt.f16(half %a)
  ret half %c
}

define <2 x double> @sqrt_v2f64(<2 x double> %a) {
; CHECK-LABEL: sqrt_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %a)
  ret <2 x double> %c
}

define <3 x double> @sqrt_v3f64(<3 x double> %a) {
; CHECK-SD-LABEL: sqrt_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    fsqrt v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    fsqrt v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sqrt_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    fsqrt d2, d2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    fsqrt v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = call <3 x double> @llvm.sqrt.v3f64(<3 x double> %a)
  ret <3 x double> %c
}

define <4 x double> @sqrt_v4f64(<4 x double> %a) {
; CHECK-LABEL: sqrt_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt v0.2d, v0.2d
; CHECK-NEXT:    fsqrt v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = call <4 x double> @llvm.sqrt.v4f64(<4 x double> %a)
  ret <4 x double> %c
}

define <2 x float> @sqrt_v2f32(<2 x float> %a) {
; CHECK-LABEL: sqrt_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = call <2 x float> @llvm.sqrt.v2f32(<2 x float> %a)
  ret <2 x float> %c
}

define <3 x float> @sqrt_v3f32(<3 x float> %a) {
; CHECK-LABEL: sqrt_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <3 x float> @llvm.sqrt.v3f32(<3 x float> %a)
  ret <3 x float> %c
}

define <4 x float> @sqrt_v4f32(<4 x float> %a) {
; CHECK-LABEL: sqrt_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %a)
  ret <4 x float> %c
}

define <8 x float> @sqrt_v8f32(<8 x float> %a) {
; CHECK-LABEL: sqrt_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fsqrt v0.4s, v0.4s
; CHECK-NEXT:    fsqrt v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <8 x float> @llvm.sqrt.v8f32(<8 x float> %a)
  ret <8 x float> %c
}

define <7 x half> @sqrt_v7f16(<7 x half> %a) {
; CHECK-SD-NOFP16-LABEL: sqrt_v7f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NOFP16-NEXT:    fcvt s2, h0
; CHECK-SD-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-SD-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-SD-NOFP16-NEXT:    mov h5, v0.h[4]
; CHECK-SD-NOFP16-NEXT:    mov h6, v0.h[5]
; CHECK-SD-NOFP16-NEXT:    mov h7, v0.h[6]
; CHECK-SD-NOFP16-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NOFP16-NEXT:    fcvt s1, h1
; CHECK-SD-NOFP16-NEXT:    fsqrt s2, s2
; CHECK-SD-NOFP16-NEXT:    fcvt s3, h3
; CHECK-SD-NOFP16-NEXT:    fcvt s4, h4
; CHECK-SD-NOFP16-NEXT:    fcvt s5, h5
; CHECK-SD-NOFP16-NEXT:    fcvt s6, h6
; CHECK-SD-NOFP16-NEXT:    fcvt s7, h7
; CHECK-SD-NOFP16-NEXT:    fcvt s16, h0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s2
; CHECK-SD-NOFP16-NEXT:    fsqrt s1, s1
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s1
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s3, s3
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s3
; CHECK-SD-NOFP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s4, s4
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s4
; CHECK-SD-NOFP16-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s5, s5
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s5
; CHECK-SD-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s6, s6
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s6
; CHECK-SD-NOFP16-NEXT:    mov v0.h[5], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s7, s7
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s7
; CHECK-SD-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s2, s16
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s2
; CHECK-SD-NOFP16-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: sqrt_v7f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    fsqrt v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: sqrt_v7f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[4]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[5]
; CHECK-GI-NOFP16-NEXT:    mov h0, v0.h[6]
; CHECK-GI-NOFP16-NEXT:    fsqrt v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v2.h[1], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v2.h[2], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v2.4h
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fsqrt v1.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    mov h2, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-GI-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v3.h[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h2, v1.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov h1, v1.h[2]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: sqrt_v7f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    fsqrt v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <7 x half> @llvm.sqrt.v7f16(<7 x half> %a)
  ret <7 x half> %c
}

define <4 x half> @sqrt_v4f16(<4 x half> %a) {
; CHECK-SD-NOFP16-LABEL: sqrt_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NOFP16-NEXT:    fcvt s2, h0
; CHECK-SD-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-SD-NOFP16-NEXT:    mov h0, v0.h[3]
; CHECK-SD-NOFP16-NEXT:    fcvt s1, h1
; CHECK-SD-NOFP16-NEXT:    fsqrt s2, s2
; CHECK-SD-NOFP16-NEXT:    fcvt s3, h3
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fsqrt s1, s1
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s1
; CHECK-SD-NOFP16-NEXT:    fsqrt s3, s3
; CHECK-SD-NOFP16-NEXT:    fsqrt s4, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s2
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s3
; CHECK-SD-NOFP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s4
; CHECK-SD-NOFP16-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: sqrt_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    fsqrt v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: sqrt_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fsqrt v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: sqrt_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    fsqrt v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <4 x half> @llvm.sqrt.v4f16(<4 x half> %a)
  ret <4 x half> %c
}

define <8 x half> @sqrt_v8f16(<8 x half> %a) {
; CHECK-SD-NOFP16-LABEL: sqrt_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-SD-NOFP16-NEXT:    fcvt s2, h0
; CHECK-SD-NOFP16-NEXT:    mov h3, v0.h[2]
; CHECK-SD-NOFP16-NEXT:    mov h4, v0.h[3]
; CHECK-SD-NOFP16-NEXT:    mov h5, v0.h[4]
; CHECK-SD-NOFP16-NEXT:    mov h6, v0.h[5]
; CHECK-SD-NOFP16-NEXT:    mov h7, v0.h[6]
; CHECK-SD-NOFP16-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NOFP16-NEXT:    fcvt s1, h1
; CHECK-SD-NOFP16-NEXT:    fsqrt s2, s2
; CHECK-SD-NOFP16-NEXT:    fcvt s3, h3
; CHECK-SD-NOFP16-NEXT:    fcvt s4, h4
; CHECK-SD-NOFP16-NEXT:    fcvt s5, h5
; CHECK-SD-NOFP16-NEXT:    fcvt s6, h6
; CHECK-SD-NOFP16-NEXT:    fcvt s7, h7
; CHECK-SD-NOFP16-NEXT:    fcvt s16, h0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s2
; CHECK-SD-NOFP16-NEXT:    fsqrt s1, s1
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s1
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s3, s3
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s3
; CHECK-SD-NOFP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s4, s4
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s4
; CHECK-SD-NOFP16-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s5, s5
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s5
; CHECK-SD-NOFP16-NEXT:    mov v0.h[4], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s6, s6
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s6
; CHECK-SD-NOFP16-NEXT:    mov v0.h[5], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s7, s7
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s7
; CHECK-SD-NOFP16-NEXT:    mov v0.h[6], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    fsqrt s2, s16
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s2
; CHECK-SD-NOFP16-NEXT:    mov v0.h[7], v1.h[0]
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: sqrt_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    fsqrt v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: sqrt_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v1.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fsqrt v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fsqrt v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: sqrt_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    fsqrt v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <8 x half> @llvm.sqrt.v8f16(<8 x half> %a)
  ret <8 x half> %c
}

define <16 x half> @sqrt_v16f16(<16 x half> %a) {
; CHECK-SD-NOFP16-LABEL: sqrt_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    mov h2, v0.h[1]
; CHECK-SD-NOFP16-NEXT:    fcvt s3, h0
; CHECK-SD-NOFP16-NEXT:    mov h4, v0.h[2]
; CHECK-SD-NOFP16-NEXT:    mov h5, v0.h[3]
; CHECK-SD-NOFP16-NEXT:    mov h6, v0.h[4]
; CHECK-SD-NOFP16-NEXT:    mov h7, v0.h[5]
; CHECK-SD-NOFP16-NEXT:    mov h16, v0.h[6]
; CHECK-SD-NOFP16-NEXT:    mov h0, v0.h[7]
; CHECK-SD-NOFP16-NEXT:    fcvt s2, h2
; CHECK-SD-NOFP16-NEXT:    fsqrt s3, s3
; CHECK-SD-NOFP16-NEXT:    fcvt s4, h4
; CHECK-SD-NOFP16-NEXT:    fcvt s5, h5
; CHECK-SD-NOFP16-NEXT:    fcvt s6, h6
; CHECK-SD-NOFP16-NEXT:    fcvt s7, h7
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fcvt s16, h16
; CHECK-SD-NOFP16-NEXT:    fsqrt s17, s0
; CHECK-SD-NOFP16-NEXT:    mov h0, v1.h[1]
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fsqrt s18, s0
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h1
; CHECK-SD-NOFP16-NEXT:    fsqrt s19, s0
; CHECK-SD-NOFP16-NEXT:    mov h0, v1.h[2]
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fsqrt s20, s0
; CHECK-SD-NOFP16-NEXT:    mov h0, v1.h[3]
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fsqrt s21, s0
; CHECK-SD-NOFP16-NEXT:    mov h0, v1.h[4]
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fsqrt s2, s2
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s2
; CHECK-SD-NOFP16-NEXT:    fsqrt s22, s0
; CHECK-SD-NOFP16-NEXT:    mov h0, v1.h[5]
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fsqrt s4, s4
; CHECK-SD-NOFP16-NEXT:    fsqrt s5, s5
; CHECK-SD-NOFP16-NEXT:    fsqrt s23, s0
; CHECK-SD-NOFP16-NEXT:    mov h0, v1.h[6]
; CHECK-SD-NOFP16-NEXT:    fcvt s0, h0
; CHECK-SD-NOFP16-NEXT:    fsqrt s6, s6
; CHECK-SD-NOFP16-NEXT:    fsqrt s7, s7
; CHECK-SD-NOFP16-NEXT:    fsqrt s24, s0
; CHECK-SD-NOFP16-NEXT:    mov h0, v1.h[7]
; CHECK-SD-NOFP16-NEXT:    fcvt h1, s19
; CHECK-SD-NOFP16-NEXT:    fcvt s25, h0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s3
; CHECK-SD-NOFP16-NEXT:    fcvt h3, s18
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s4
; CHECK-SD-NOFP16-NEXT:    mov v1.h[1], v3.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h3, s20
; CHECK-SD-NOFP16-NEXT:    mov v0.h[2], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s5
; CHECK-SD-NOFP16-NEXT:    mov v1.h[2], v3.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h3, s21
; CHECK-SD-NOFP16-NEXT:    mov v0.h[3], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s6
; CHECK-SD-NOFP16-NEXT:    mov v1.h[3], v3.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h3, s22
; CHECK-SD-NOFP16-NEXT:    mov v0.h[4], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s7
; CHECK-SD-NOFP16-NEXT:    mov v1.h[4], v3.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h3, s23
; CHECK-SD-NOFP16-NEXT:    mov v0.h[5], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    mov v1.h[5], v3.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h3, s24
; CHECK-SD-NOFP16-NEXT:    fsqrt s16, s16
; CHECK-SD-NOFP16-NEXT:    mov v1.h[6], v3.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s16
; CHECK-SD-NOFP16-NEXT:    mov v0.h[6], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s17
; CHECK-SD-NOFP16-NEXT:    fsqrt s18, s25
; CHECK-SD-NOFP16-NEXT:    mov v0.h[7], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    fcvt h3, s18
; CHECK-SD-NOFP16-NEXT:    mov v1.h[7], v3.h[0]
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: sqrt_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    fsqrt v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    fsqrt v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: sqrt_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fcvtl v2.4s, v0.4h
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v0.8h
; CHECK-GI-NOFP16-NEXT:    fsqrt v3.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtl v0.4s, v1.4h
; CHECK-GI-NOFP16-NEXT:    fsqrt v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    fsqrt v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtl2 v0.4s, v1.8h
; CHECK-GI-NOFP16-NEXT:    fsqrt v5.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: sqrt_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    fsqrt v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    fsqrt v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = call <16 x half> @llvm.sqrt.v16f16(<16 x half> %a)
  ret <16 x half> %c
}

declare <16 x half> @llvm.sqrt.v16f16(<16 x half>)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
declare <2 x float> @llvm.sqrt.v2f32(<2 x float>)
declare <3 x double> @llvm.sqrt.v3f64(<3 x double>)
declare <3 x float> @llvm.sqrt.v3f32(<3 x float>)
declare <4 x double> @llvm.sqrt.v4f64(<4 x double>)
declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <4 x half> @llvm.sqrt.v4f16(<4 x half>)
declare <7 x half> @llvm.sqrt.v7f16(<7 x half>)
declare <8 x float> @llvm.sqrt.v8f32(<8 x float>)
declare <8 x half> @llvm.sqrt.v8f16(<8 x half>)
declare double @llvm.sqrt.f64(double)
declare float @llvm.sqrt.f32(float)
declare half @llvm.sqrt.f16(half)
