; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc --mtriple=loongarch64 --frame-pointer=none --mattr=+lasx < %s | FileCheck %s

;; This test is checking that when a function allows stack realignment and
;; realignment needs were not detected before register allocation (at this
;; point, fp is not preserved), but realignment is required during register
;; allocation, the stack should not undergo realignment.

;; Ensure that the `bstrins.d $sp, $zero, n, 0` instruction is not generated.
;; n = log2(realign_size) - 1

%struct.S = type { [64 x i16] }

define dso_local noundef signext i32 @main() nounwind {
; CHECK-LABEL: main:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi.d $sp, $sp, -272
; CHECK-NEXT:    st.d $ra, $sp, 264 # 8-byte Folded Spill
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI0_0)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI0_0)
; CHECK-NEXT:    xvld $xr0, $a0, 0
; CHECK-NEXT:    xvst $xr0, $sp, 96 # 32-byte Folded Spill
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI0_1)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI0_1)
; CHECK-NEXT:    xvld $xr1, $a0, 0
; CHECK-NEXT:    xvst $xr1, $sp, 64 # 32-byte Folded Spill
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI0_2)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI0_2)
; CHECK-NEXT:    xvld $xr2, $a0, 0
; CHECK-NEXT:    xvst $xr2, $sp, 32 # 32-byte Folded Spill
; CHECK-NEXT:    pcalau12i $a0, %pc_hi20(.LCPI0_3)
; CHECK-NEXT:    addi.d $a0, $a0, %pc_lo12(.LCPI0_3)
; CHECK-NEXT:    xvld $xr3, $a0, 0
; CHECK-NEXT:    xvst $xr3, $sp, 0 # 32-byte Folded Spill
; CHECK-NEXT:    xvst $xr0, $sp, 136
; CHECK-NEXT:    xvst $xr1, $sp, 168
; CHECK-NEXT:    xvst $xr2, $sp, 200
; CHECK-NEXT:    xvst $xr3, $sp, 232
; CHECK-NEXT:    addi.d $a0, $sp, 136
; CHECK-NEXT:    bl %plt(foo)
; CHECK-NEXT:    xvld $xr0, $sp, 96 # 32-byte Folded Reload
; CHECK-NEXT:    xvst $xr0, $sp, 136
; CHECK-NEXT:    xvld $xr0, $sp, 64 # 32-byte Folded Reload
; CHECK-NEXT:    xvst $xr0, $sp, 168
; CHECK-NEXT:    xvld $xr0, $sp, 32 # 32-byte Folded Reload
; CHECK-NEXT:    xvst $xr0, $sp, 200
; CHECK-NEXT:    xvld $xr0, $sp, 0 # 32-byte Folded Reload
; CHECK-NEXT:    xvst $xr0, $sp, 232
; CHECK-NEXT:    addi.d $a0, $sp, 136
; CHECK-NEXT:    bl %plt(bar)
; CHECK-NEXT:    move $a0, $zero
; CHECK-NEXT:    ld.d $ra, $sp, 264 # 8-byte Folded Reload
; CHECK-NEXT:    addi.d $sp, $sp, 272
; CHECK-NEXT:    ret
entry:
  %s = alloca %struct.S, align 2
  call void @llvm.lifetime.start.p0(i64 128, ptr nonnull %s)
  store <16 x i16> <i16 16384, i16 16129, i16 15874, i16 15619, i16 15364, i16 15109, i16 14854, i16 14599, i16 14344, i16 14089, i16 13834, i16 13579, i16 13324, i16 13069, i16 12814, i16 12559>, ptr %s, align 2
  %0 = getelementptr inbounds [64 x i16], ptr %s, i64 0, i64 16
  store <16 x i16> <i16 12304, i16 12049, i16 11794, i16 11539, i16 11284, i16 11029, i16 10774, i16 10519, i16 10264, i16 10009, i16 9754, i16 9499, i16 9244, i16 8989, i16 8734, i16 8479>, ptr %0, align 2
  %1 = getelementptr inbounds [64 x i16], ptr %s, i64 0, i64 32
  store <16 x i16> <i16 8224, i16 7969, i16 7714, i16 7459, i16 7204, i16 6949, i16 6694, i16 6439, i16 6184, i16 5929, i16 5674, i16 5419, i16 5164, i16 4909, i16 4654, i16 4399>, ptr %1, align 2
  %2 = getelementptr inbounds [64 x i16], ptr %s, i64 0, i64 48
  store <16 x i16> <i16 4144, i16 3889, i16 3634, i16 3379, i16 3124, i16 2869, i16 2614, i16 2359, i16 2104, i16 1849, i16 1594, i16 1339, i16 1084, i16 829, i16 574, i16 319>, ptr %2, align 2
  call void @foo(ptr noundef nonnull %s)
  store <16 x i16> <i16 16384, i16 16129, i16 15874, i16 15619, i16 15364, i16 15109, i16 14854, i16 14599, i16 14344, i16 14089, i16 13834, i16 13579, i16 13324, i16 13069, i16 12814, i16 12559>, ptr %s, align 2
  %3 = getelementptr inbounds [64 x i16], ptr %s, i64 0, i64 16
  store <16 x i16> <i16 12304, i16 12049, i16 11794, i16 11539, i16 11284, i16 11029, i16 10774, i16 10519, i16 10264, i16 10009, i16 9754, i16 9499, i16 9244, i16 8989, i16 8734, i16 8479>, ptr %3, align 2
  %4 = getelementptr inbounds [64 x i16], ptr %s, i64 0, i64 32
  store <16 x i16> <i16 8224, i16 7969, i16 7714, i16 7459, i16 7204, i16 6949, i16 6694, i16 6439, i16 6184, i16 5929, i16 5674, i16 5419, i16 5164, i16 4909, i16 4654, i16 4399>, ptr %4, align 2
  %5 = getelementptr inbounds [64 x i16], ptr %s, i64 0, i64 48
  store <16 x i16> <i16 4144, i16 3889, i16 3634, i16 3379, i16 3124, i16 2869, i16 2614, i16 2359, i16 2104, i16 1849, i16 1594, i16 1339, i16 1084, i16 829, i16 574, i16 319>, ptr %5, align 2
  call void @bar(ptr noundef nonnull %s)
  call void @llvm.lifetime.end.p0(i64 128, ptr nonnull %s)
  ret i32 0
}

declare void @foo(ptr nocapture noundef)
declare void @bar(ptr nocapture noundef)

declare void @llvm.lifetime.start.p0(i64 immarg, ptr nocapture)
declare void @llvm.lifetime.end.p0(i64 immarg, ptr nocapture)
