; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=powerpc64le-unknown-linux-gnu -ppc-vsr-nums-as-vr \
; RUN:   -ppc-asm-full-reg-names -global-isel -o - < %s | FileCheck %s

define <16 x i8> @test_add_v16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_add_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddubm v2, v2, v3
; CHECK-NEXT:    blr
  %res = add <16 x i8> %a, %b
  ret <16 x i8> %res
}

define <8 x i16> @test_add_v8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_add_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vadduhm v2, v2, v3
; CHECK-NEXT:    blr
  %res = add <8 x i16> %a, %b
  ret <8 x i16> %res
}

define <4 x i32> @test_add_v4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_add_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vadduwm v2, v2, v3
; CHECK-NEXT:    blr
  %res = add <4 x i32> %a, %b
  ret <4 x i32> %res
}

define <2 x i64> @test_add_v2i64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_add_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddudm v2, v2, v3
; CHECK-NEXT:    blr
  %res = add <2 x i64> %a, %b
  ret <2 x i64> %res
}

define <16 x i8> @test_sub_v16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_sub_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsububm v2, v2, v3
; CHECK-NEXT:    blr
  %res = sub <16 x i8> %a, %b
  ret <16 x i8> %res
}

define <8 x i16> @test_sub_v8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_sub_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubuhm v2, v2, v3
; CHECK-NEXT:    blr
  %res = sub <8 x i16> %a, %b
  ret <8 x i16> %res
}

define <4 x i32> @test_sub_v4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_sub_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubuwm v2, v2, v3
; CHECK-NEXT:    blr
  %res = sub <4 x i32> %a, %b
  ret <4 x i32> %res
}

define <2 x i64> @test_sub_v2i64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_sub_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubudm v2, v2, v3
; CHECK-NEXT:    blr
  %res = sub <2 x i64> %a, %b
  ret <2 x i64> %res
}
