; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=nsan -nsan-shadow-type-mapping=dqq -S %s | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"

; Tests with memory manipulation (memcpy, llvm.memcpy, ...).


declare void @llvm.memcpy.p0i8.p0i8.i64(i8*, i8*, i64, i1)

define void @call_memcpy_intrinsic(i8* nonnull align 8 dereferenceable(16) %a, i8* nonnull align 8 dereferenceable(16) %b) sanitize_numerical_stability {
; CHECK-LABEL: @call_memcpy_intrinsic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @__nsan_copy_values(ptr [[A:%.*]], ptr [[B:%.*]], i64 16)
; CHECK-NEXT:    tail call void @llvm.memcpy.p0.p0.i64(ptr nonnull align 8 dereferenceable(16) [[A]], ptr nonnull align 8 dereferenceable(16) [[B]], i64 16, i1 false)
; CHECK-NEXT:    ret void
;
entry:
  tail call void @llvm.memcpy.p0i8.p0i8.i64(ptr nonnull align 8 dereferenceable(16) %a, ptr nonnull align 8 dereferenceable(16) %b, i64 16, i1 false)
  ret void
}

declare dso_local i8* @memcpy(i8*, i8*, i64) local_unnamed_addr

define void @call_memcpy(i8* nonnull align 8 dereferenceable(16) %a, i8* nonnull align 8 dereferenceable(16) %b) sanitize_numerical_stability {
; CHECK-LABEL: @call_memcpy(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call ptr @memcpy(ptr nonnull align 8 dereferenceable(16) [[A:%.*]], ptr nonnull align 8 dereferenceable(16) [[B:%.*]], i64 16) #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    ret void
;
entry:
  tail call i8* @memcpy(ptr nonnull align 8 dereferenceable(16) %a, ptr nonnull align 8 dereferenceable(16) %b, i64 16)
  ret void
}


define void @transfer_float(float* %dst, float* %src) sanitize_numerical_stability {
; CHECK-LABEL: @transfer_float(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[T:%.*]] = load float, ptr [[SRC:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[SRC]], i64 1)
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq ptr [[TMP0]], null
; CHECK-NEXT:    br i1 [[TMP1]], label [[TMP4:%.*]], label [[TMP2:%.*]]
; CHECK:       2:
; CHECK-NEXT:    [[TMP3:%.*]] = load double, ptr [[TMP0]], align 1
; CHECK-NEXT:    br label [[TMP6:%.*]]
; CHECK:       4:
; CHECK-NEXT:    [[TMP5:%.*]] = fpext float [[T]] to double
; CHECK-NEXT:    br label [[TMP6]]
; CHECK:       6:
; CHECK-NEXT:    [[TMP7:%.*]] = phi double [ [[TMP3]], [[TMP2]] ], [ [[TMP5]], [[TMP4]] ]
; CHECK-NEXT:    [[TMP8:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[DST:%.*]], i64 1)
; CHECK-NEXT:    [[TMP9:%.*]] = ptrtoint ptr [[DST]] to i64
; CHECK-NEXT:    [[TMP10:%.*]] = call i32 @__nsan_internal_check_float_d(float [[T]], double [[TMP7]], i32 4, i64 [[TMP9]])
; CHECK-NEXT:    [[TMP11:%.*]] = icmp eq i32 [[TMP10]], 1
; CHECK-NEXT:    [[TMP12:%.*]] = fpext float [[T]] to double
; CHECK-NEXT:    [[TMP13:%.*]] = select i1 [[TMP11]], double [[TMP12]], double [[TMP7]]
; CHECK-NEXT:    store double [[TMP13]], ptr [[TMP8]], align 1
; CHECK-NEXT:    store float [[T]], ptr [[DST]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %t = load float, ptr %src
  store float %t, ptr %dst, align 1
  ret void
}

define void @transfer_non_float(i32* %dst, i32* %src) sanitize_numerical_stability {
; CHECK-LABEL: @transfer_non_float(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[T:%.*]] = load i32, ptr [[SRC:%.*]], align 4
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[SRC]])
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[SRC]])
; CHECK-NEXT:    [[TMP3:%.*]] = load i64, ptr [[TMP2]], align 1
; CHECK-NEXT:    store i32 [[T]], ptr [[DST:%.*]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[DST]])
; CHECK-NEXT:    store i32 [[TMP1]], ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[DST]])
; CHECK-NEXT:    store i64 [[TMP3]], ptr [[TMP5]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %t = load i32, ptr %src
  store i32 %t, ptr %dst, align 1
  ret void
}

define void @transfer_array([2 x float]* %a) sanitize_numerical_stability {
; CHECK-LABEL: @transfer_array(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B:%.*]] = load [2 x float], ptr [[A:%.*]], align 1
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[A]])
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr [[TMP0]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[A]])
; CHECK-NEXT:    [[TMP3:%.*]] = load i128, ptr [[TMP2]], align 1
; CHECK-NEXT:    store [2 x float] [[B]], ptr [[A]], align 1
; CHECK-NEXT:    [[TMP4:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[A]])
; CHECK-NEXT:    store i64 [[TMP1]], ptr [[TMP4]], align 1
; CHECK-NEXT:    [[TMP5:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[A]])
; CHECK-NEXT:    store i128 [[TMP3]], ptr [[TMP5]], align 1
; CHECK-NEXT:    ret void
;
entry:
  %b = load [2 x float], ptr %a, align 1
  store [2 x float] %b, ptr %a, align 1
  ret void
}

define void @swap_untyped1(i64* nonnull align 8 %p, i64* nonnull align 8 %q) sanitize_numerical_stability {
; CHECK-LABEL: @swap_untyped1(
; CHECK-NEXT:    [[QV:%.*]] = load i64, ptr [[Q:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[Q]])
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[TMP1]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[Q]])
; CHECK-NEXT:    [[TMP4:%.*]] = load i128, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[PV:%.*]] = load i64, ptr [[P:%.*]], align 8
; CHECK-NEXT:    [[TMP5:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[P]])
; CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[P]])
; CHECK-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP7]], align 1
; CHECK-NEXT:    store i64 [[PV]], ptr [[Q]], align 8
; CHECK-NEXT:    [[TMP9:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[Q]])
; CHECK-NEXT:    store i64 [[TMP6]], ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP10:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[Q]])
; CHECK-NEXT:    store i128 [[TMP8]], ptr [[TMP10]], align 1
; CHECK-NEXT:    store i64 [[QV]], ptr [[P]], align 8
; CHECK-NEXT:    [[TMP11:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[P]])
; CHECK-NEXT:    store i64 [[TMP2]], ptr [[TMP11]], align 1
; CHECK-NEXT:    [[TMP12:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[P]])
; CHECK-NEXT:    store i128 [[TMP4]], ptr [[TMP12]], align 1
; CHECK-NEXT:    ret void
;
  %qv = load i64, ptr %q
  %pv = load i64, ptr %p
  store i64 %pv, ptr %q, align 8
  store i64 %qv, ptr %p, align 8
  ret void
}

; Same as swap_untyped1, but the load/stores are in the opposite order.
define void @swap_untyped2(i64* nonnull align 8 %p, i64* nonnull align 8 %q) sanitize_numerical_stability {
; CHECK-LABEL: @swap_untyped2(
; CHECK-NEXT:    [[PV:%.*]] = load i64, ptr [[P:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[P]])
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr [[TMP1]], align 1
; CHECK-NEXT:    [[TMP3:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[P]])
; CHECK-NEXT:    [[TMP4:%.*]] = load i128, ptr [[TMP3]], align 1
; CHECK-NEXT:    [[QV:%.*]] = load i64, ptr [[Q:%.*]], align 8
; CHECK-NEXT:    [[TMP5:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[Q]])
; CHECK-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP5]], align 1
; CHECK-NEXT:    [[TMP7:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[Q]])
; CHECK-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP7]], align 1
; CHECK-NEXT:    store i64 [[PV]], ptr [[Q]], align 8
; CHECK-NEXT:    [[TMP9:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[Q]])
; CHECK-NEXT:    store i64 [[TMP2]], ptr [[TMP9]], align 1
; CHECK-NEXT:    [[TMP10:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[Q]])
; CHECK-NEXT:    store i128 [[TMP4]], ptr [[TMP10]], align 1
; CHECK-NEXT:    store i64 [[QV]], ptr [[P]], align 8
; CHECK-NEXT:    [[TMP11:%.*]] = call ptr @__nsan_internal_get_raw_shadow_type_ptr(ptr [[P]])
; CHECK-NEXT:    store i64 [[TMP6]], ptr [[TMP11]], align 1
; CHECK-NEXT:    [[TMP12:%.*]] = call ptr @__nsan_internal_get_raw_shadow_ptr(ptr [[P]])
; CHECK-NEXT:    store i128 [[TMP8]], ptr [[TMP12]], align 1
; CHECK-NEXT:    ret void
;
  %pv = load i64, ptr %p
  %qv = load i64, ptr %q
  store i64 %pv, ptr %q, align 8
  store i64 %qv, ptr %p, align 8
  ret void
}

define void @swap_ft1(float* nonnull align 8 %p, float* nonnull align 8 %q) sanitize_numerical_stability {
; CHECK-LABEL: @swap_ft1(
; CHECK-NEXT:    [[QV:%.*]] = load float, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[Q]], i64 1)
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[TMP1]], null
; CHECK-NEXT:    br i1 [[TMP2]], label [[TMP5:%.*]], label [[TMP3:%.*]]
; CHECK:       3:
; CHECK-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 1
; CHECK-NEXT:    br label [[TMP7:%.*]]
; CHECK:       5:
; CHECK-NEXT:    [[TMP6:%.*]] = fpext float [[QV]] to double
; CHECK-NEXT:    br label [[TMP7]]
; CHECK:       7:
; CHECK-NEXT:    [[TMP8:%.*]] = phi double [ [[TMP4]], [[TMP3]] ], [ [[TMP6]], [[TMP5]] ]
; CHECK-NEXT:    [[PV:%.*]] = load float, ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP9:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[P]], i64 1)
; CHECK-NEXT:    [[TMP10:%.*]] = icmp eq ptr [[TMP9]], null
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP13:%.*]], label [[TMP11:%.*]]
; CHECK:       11:
; CHECK-NEXT:    [[TMP12:%.*]] = load double, ptr [[TMP9]], align 1
; CHECK-NEXT:    br label [[TMP15:%.*]]
; CHECK:       13:
; CHECK-NEXT:    [[TMP14:%.*]] = fpext float [[PV]] to double
; CHECK-NEXT:    br label [[TMP15]]
; CHECK:       15:
; CHECK-NEXT:    [[TMP16:%.*]] = phi double [ [[TMP12]], [[TMP11]] ], [ [[TMP14]], [[TMP13]] ]
; CHECK-NEXT:    [[TMP17:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[Q]], i64 1)
; CHECK-NEXT:    [[TMP18:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP19:%.*]] = call i32 @__nsan_internal_check_float_d(float [[PV]], double [[TMP16]], i32 4, i64 [[TMP18]])
; CHECK-NEXT:    [[TMP20:%.*]] = icmp eq i32 [[TMP19]], 1
; CHECK-NEXT:    [[TMP21:%.*]] = fpext float [[PV]] to double
; CHECK-NEXT:    [[TMP22:%.*]] = select i1 [[TMP20]], double [[TMP21]], double [[TMP16]]
; CHECK-NEXT:    store double [[TMP22]], ptr [[TMP17]], align 1
; CHECK-NEXT:    store float [[PV]], ptr [[Q]], align 8
; CHECK-NEXT:    [[TMP23:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[P]], i64 1)
; CHECK-NEXT:    [[TMP24:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP25:%.*]] = call i32 @__nsan_internal_check_float_d(float [[QV]], double [[TMP8]], i32 4, i64 [[TMP24]])
; CHECK-NEXT:    [[TMP26:%.*]] = icmp eq i32 [[TMP25]], 1
; CHECK-NEXT:    [[TMP27:%.*]] = fpext float [[QV]] to double
; CHECK-NEXT:    [[TMP28:%.*]] = select i1 [[TMP26]], double [[TMP27]], double [[TMP8]]
; CHECK-NEXT:    store double [[TMP28]], ptr [[TMP23]], align 1
; CHECK-NEXT:    store float [[QV]], ptr [[P]], align 8
; CHECK-NEXT:    ret void
;
  %qv = load float, ptr %q
  %pv = load float, ptr %p
  store float %pv, ptr %q, align 8
  store float %qv, ptr %p, align 8
  ret void
}

; Same as swap_ft1, but the load/stores are in the opposite order.
define void @swap_ft2(float* nonnull align 8 %p, float* nonnull align 8 %q) sanitize_numerical_stability {
; CHECK-LABEL: @swap_ft2(
; CHECK-NEXT:    [[PV:%.*]] = load float, ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[P]], i64 1)
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[TMP1]], null
; CHECK-NEXT:    br i1 [[TMP2]], label [[TMP5:%.*]], label [[TMP3:%.*]]
; CHECK:       3:
; CHECK-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP1]], align 1
; CHECK-NEXT:    br label [[TMP7:%.*]]
; CHECK:       5:
; CHECK-NEXT:    [[TMP6:%.*]] = fpext float [[PV]] to double
; CHECK-NEXT:    br label [[TMP7]]
; CHECK:       7:
; CHECK-NEXT:    [[TMP8:%.*]] = phi double [ [[TMP4]], [[TMP3]] ], [ [[TMP6]], [[TMP5]] ]
; CHECK-NEXT:    [[QV:%.*]] = load float, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[TMP9:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[Q]], i64 1)
; CHECK-NEXT:    [[TMP10:%.*]] = icmp eq ptr [[TMP9]], null
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP13:%.*]], label [[TMP11:%.*]]
; CHECK:       11:
; CHECK-NEXT:    [[TMP12:%.*]] = load double, ptr [[TMP9]], align 1
; CHECK-NEXT:    br label [[TMP15:%.*]]
; CHECK:       13:
; CHECK-NEXT:    [[TMP14:%.*]] = fpext float [[QV]] to double
; CHECK-NEXT:    br label [[TMP15]]
; CHECK:       15:
; CHECK-NEXT:    [[TMP16:%.*]] = phi double [ [[TMP12]], [[TMP11]] ], [ [[TMP14]], [[TMP13]] ]
; CHECK-NEXT:    [[TMP17:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[Q]], i64 1)
; CHECK-NEXT:    [[TMP18:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP19:%.*]] = call i32 @__nsan_internal_check_float_d(float [[PV]], double [[TMP8]], i32 4, i64 [[TMP18]])
; CHECK-NEXT:    [[TMP20:%.*]] = icmp eq i32 [[TMP19]], 1
; CHECK-NEXT:    [[TMP21:%.*]] = fpext float [[PV]] to double
; CHECK-NEXT:    [[TMP22:%.*]] = select i1 [[TMP20]], double [[TMP21]], double [[TMP8]]
; CHECK-NEXT:    store double [[TMP22]], ptr [[TMP17]], align 1
; CHECK-NEXT:    store float [[PV]], ptr [[Q]], align 8
; CHECK-NEXT:    [[TMP23:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[P]], i64 1)
; CHECK-NEXT:    [[TMP24:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP25:%.*]] = call i32 @__nsan_internal_check_float_d(float [[QV]], double [[TMP16]], i32 4, i64 [[TMP24]])
; CHECK-NEXT:    [[TMP26:%.*]] = icmp eq i32 [[TMP25]], 1
; CHECK-NEXT:    [[TMP27:%.*]] = fpext float [[QV]] to double
; CHECK-NEXT:    [[TMP28:%.*]] = select i1 [[TMP26]], double [[TMP27]], double [[TMP16]]
; CHECK-NEXT:    store double [[TMP28]], ptr [[TMP23]], align 1
; CHECK-NEXT:    store float [[QV]], ptr [[P]], align 8
; CHECK-NEXT:    ret void
;
  %pv = load float, ptr %p
  %qv = load float, ptr %q
  store float %pv, ptr %q, align 8
  store float %qv, ptr %p, align 8
  ret void
}

define void @swap_vectorft1(<2 x float>* nonnull align 16 %p, <2 x float>* nonnull align 16 %q) sanitize_numerical_stability {
; CHECK-LABEL: @swap_vectorft1(
; CHECK-NEXT:    [[QV:%.*]] = load <2 x float>, ptr [[Q:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[Q]], i64 2)
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[TMP1]], null
; CHECK-NEXT:    br i1 [[TMP2]], label [[TMP5:%.*]], label [[TMP3:%.*]]
; CHECK:       3:
; CHECK-NEXT:    [[TMP4:%.*]] = load <2 x double>, ptr [[TMP1]], align 1
; CHECK-NEXT:    br label [[TMP7:%.*]]
; CHECK:       5:
; CHECK-NEXT:    [[TMP6:%.*]] = fpext <2 x float> [[QV]] to <2 x double>
; CHECK-NEXT:    br label [[TMP7]]
; CHECK:       7:
; CHECK-NEXT:    [[TMP8:%.*]] = phi <2 x double> [ [[TMP4]], [[TMP3]] ], [ [[TMP6]], [[TMP5]] ]
; CHECK-NEXT:    [[PV:%.*]] = load <2 x float>, ptr [[P:%.*]], align 8
; CHECK-NEXT:    [[TMP9:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[P]], i64 2)
; CHECK-NEXT:    [[TMP10:%.*]] = icmp eq ptr [[TMP9]], null
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP13:%.*]], label [[TMP11:%.*]]
; CHECK:       11:
; CHECK-NEXT:    [[TMP12:%.*]] = load <2 x double>, ptr [[TMP9]], align 1
; CHECK-NEXT:    br label [[TMP15:%.*]]
; CHECK:       13:
; CHECK-NEXT:    [[TMP14:%.*]] = fpext <2 x float> [[PV]] to <2 x double>
; CHECK-NEXT:    br label [[TMP15]]
; CHECK:       15:
; CHECK-NEXT:    [[TMP16:%.*]] = phi <2 x double> [ [[TMP12]], [[TMP11]] ], [ [[TMP14]], [[TMP13]] ]
; CHECK-NEXT:    [[TMP17:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[Q]], i64 2)
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <2 x float> [[PV]], i64 0
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <2 x double> [[TMP16]], i64 0
; CHECK-NEXT:    [[TMP20:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP21:%.*]] = call i32 @__nsan_internal_check_float_d(float [[TMP18]], double [[TMP19]], i32 4, i64 [[TMP20]])
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <2 x float> [[PV]], i64 1
; CHECK-NEXT:    [[TMP23:%.*]] = extractelement <2 x double> [[TMP16]], i64 1
; CHECK-NEXT:    [[TMP24:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP25:%.*]] = call i32 @__nsan_internal_check_float_d(float [[TMP22]], double [[TMP23]], i32 4, i64 [[TMP24]])
; CHECK-NEXT:    [[TMP26:%.*]] = or i32 [[TMP21]], [[TMP25]]
; CHECK-NEXT:    [[TMP27:%.*]] = icmp eq i32 [[TMP26]], 1
; CHECK-NEXT:    [[TMP28:%.*]] = fpext <2 x float> [[PV]] to <2 x double>
; CHECK-NEXT:    [[TMP29:%.*]] = select i1 [[TMP27]], <2 x double> [[TMP28]], <2 x double> [[TMP16]]
; CHECK-NEXT:    store <2 x double> [[TMP29]], ptr [[TMP17]], align 1
; CHECK-NEXT:    store <2 x float> [[PV]], ptr [[Q]], align 16
; CHECK-NEXT:    [[TMP30:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[P]], i64 2)
; CHECK-NEXT:    [[TMP31:%.*]] = extractelement <2 x float> [[QV]], i64 0
; CHECK-NEXT:    [[TMP32:%.*]] = extractelement <2 x double> [[TMP8]], i64 0
; CHECK-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP34:%.*]] = call i32 @__nsan_internal_check_float_d(float [[TMP31]], double [[TMP32]], i32 4, i64 [[TMP33]])
; CHECK-NEXT:    [[TMP35:%.*]] = extractelement <2 x float> [[QV]], i64 1
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <2 x double> [[TMP8]], i64 1
; CHECK-NEXT:    [[TMP37:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP38:%.*]] = call i32 @__nsan_internal_check_float_d(float [[TMP35]], double [[TMP36]], i32 4, i64 [[TMP37]])
; CHECK-NEXT:    [[TMP39:%.*]] = or i32 [[TMP34]], [[TMP38]]
; CHECK-NEXT:    [[TMP40:%.*]] = icmp eq i32 [[TMP39]], 1
; CHECK-NEXT:    [[TMP41:%.*]] = fpext <2 x float> [[QV]] to <2 x double>
; CHECK-NEXT:    [[TMP42:%.*]] = select i1 [[TMP40]], <2 x double> [[TMP41]], <2 x double> [[TMP8]]
; CHECK-NEXT:    store <2 x double> [[TMP42]], ptr [[TMP30]], align 1
; CHECK-NEXT:    store <2 x float> [[QV]], ptr [[P]], align 16
; CHECK-NEXT:    ret void
;
  %qv = load <2 x float>, ptr %q
  %pv = load <2 x float>, ptr %p
  store <2 x float> %pv, ptr %q, align 16
  store <2 x float> %qv, ptr %p, align 16
  ret void
}

; Same as swap_vectorft1, but the load/stores are in the opposite order.
define void @swap_vectorft2(<2 x float>* nonnull align 16 %p, <2 x float>* nonnull align 16 %q) sanitize_numerical_stability {
; CHECK-LABEL: @swap_vectorft2(
; CHECK-NEXT:    [[PV:%.*]] = load <2 x float>, ptr [[P:%.*]], align 8
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[P]], i64 2)
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq ptr [[TMP1]], null
; CHECK-NEXT:    br i1 [[TMP2]], label [[TMP5:%.*]], label [[TMP3:%.*]]
; CHECK:       3:
; CHECK-NEXT:    [[TMP4:%.*]] = load <2 x double>, ptr [[TMP1]], align 1
; CHECK-NEXT:    br label [[TMP7:%.*]]
; CHECK:       5:
; CHECK-NEXT:    [[TMP6:%.*]] = fpext <2 x float> [[PV]] to <2 x double>
; CHECK-NEXT:    br label [[TMP7]]
; CHECK:       7:
; CHECK-NEXT:    [[TMP8:%.*]] = phi <2 x double> [ [[TMP4]], [[TMP3]] ], [ [[TMP6]], [[TMP5]] ]
; CHECK-NEXT:    [[QV:%.*]] = load <2 x float>, ptr [[Q:%.*]], align 8
; CHECK-NEXT:    [[TMP9:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_load(ptr [[Q]], i64 2)
; CHECK-NEXT:    [[TMP10:%.*]] = icmp eq ptr [[TMP9]], null
; CHECK-NEXT:    br i1 [[TMP10]], label [[TMP13:%.*]], label [[TMP11:%.*]]
; CHECK:       11:
; CHECK-NEXT:    [[TMP12:%.*]] = load <2 x double>, ptr [[TMP9]], align 1
; CHECK-NEXT:    br label [[TMP15:%.*]]
; CHECK:       13:
; CHECK-NEXT:    [[TMP14:%.*]] = fpext <2 x float> [[QV]] to <2 x double>
; CHECK-NEXT:    br label [[TMP15]]
; CHECK:       15:
; CHECK-NEXT:    [[TMP16:%.*]] = phi <2 x double> [ [[TMP12]], [[TMP11]] ], [ [[TMP14]], [[TMP13]] ]
; CHECK-NEXT:    [[TMP17:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[Q]], i64 2)
; CHECK-NEXT:    [[TMP18:%.*]] = extractelement <2 x float> [[PV]], i64 0
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <2 x double> [[TMP8]], i64 0
; CHECK-NEXT:    [[TMP20:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP21:%.*]] = call i32 @__nsan_internal_check_float_d(float [[TMP18]], double [[TMP19]], i32 4, i64 [[TMP20]])
; CHECK-NEXT:    [[TMP22:%.*]] = extractelement <2 x float> [[PV]], i64 1
; CHECK-NEXT:    [[TMP23:%.*]] = extractelement <2 x double> [[TMP8]], i64 1
; CHECK-NEXT:    [[TMP24:%.*]] = ptrtoint ptr [[Q]] to i64
; CHECK-NEXT:    [[TMP25:%.*]] = call i32 @__nsan_internal_check_float_d(float [[TMP22]], double [[TMP23]], i32 4, i64 [[TMP24]])
; CHECK-NEXT:    [[TMP26:%.*]] = or i32 [[TMP21]], [[TMP25]]
; CHECK-NEXT:    [[TMP27:%.*]] = icmp eq i32 [[TMP26]], 1
; CHECK-NEXT:    [[TMP28:%.*]] = fpext <2 x float> [[PV]] to <2 x double>
; CHECK-NEXT:    [[TMP29:%.*]] = select i1 [[TMP27]], <2 x double> [[TMP28]], <2 x double> [[TMP8]]
; CHECK-NEXT:    store <2 x double> [[TMP29]], ptr [[TMP17]], align 1
; CHECK-NEXT:    store <2 x float> [[PV]], ptr [[Q]], align 16
; CHECK-NEXT:    [[TMP30:%.*]] = call ptr @__nsan_get_shadow_ptr_for_float_store(ptr [[P]], i64 2)
; CHECK-NEXT:    [[TMP31:%.*]] = extractelement <2 x float> [[QV]], i64 0
; CHECK-NEXT:    [[TMP32:%.*]] = extractelement <2 x double> [[TMP16]], i64 0
; CHECK-NEXT:    [[TMP33:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP34:%.*]] = call i32 @__nsan_internal_check_float_d(float [[TMP31]], double [[TMP32]], i32 4, i64 [[TMP33]])
; CHECK-NEXT:    [[TMP35:%.*]] = extractelement <2 x float> [[QV]], i64 1
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <2 x double> [[TMP16]], i64 1
; CHECK-NEXT:    [[TMP37:%.*]] = ptrtoint ptr [[P]] to i64
; CHECK-NEXT:    [[TMP38:%.*]] = call i32 @__nsan_internal_check_float_d(float [[TMP35]], double [[TMP36]], i32 4, i64 [[TMP37]])
; CHECK-NEXT:    [[TMP39:%.*]] = or i32 [[TMP34]], [[TMP38]]
; CHECK-NEXT:    [[TMP40:%.*]] = icmp eq i32 [[TMP39]], 1
; CHECK-NEXT:    [[TMP41:%.*]] = fpext <2 x float> [[QV]] to <2 x double>
; CHECK-NEXT:    [[TMP42:%.*]] = select i1 [[TMP40]], <2 x double> [[TMP41]], <2 x double> [[TMP16]]
; CHECK-NEXT:    store <2 x double> [[TMP42]], ptr [[TMP30]], align 1
; CHECK-NEXT:    store <2 x float> [[QV]], ptr [[P]], align 16
; CHECK-NEXT:    ret void
;
  %pv = load <2 x float>, ptr %p
  %qv = load <2 x float>, ptr %q
  store <2 x float> %pv, ptr %q, align 16
  store <2 x float> %qv, ptr %p, align 16
  ret void
}
