; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -global-isel=0 -mcpu=tahiti < %s | FileCheck -check-prefixes=GFX6-SDAG %s
; RUN: llc -mtriple=amdgcn -global-isel=1 -mcpu=tahiti < %s | FileCheck -check-prefixes=GFX6-ISEL %s
; RUN: llc -mtriple=amdgcn -global-isel=0 -mcpu=fiji < %s | FileCheck -check-prefixes=GFX8-SDAG %s
; RUN: llc -mtriple=amdgcn -global-isel=1 -mcpu=fiji < %s | FileCheck -check-prefixes=GFX8-ISEL %s
; RUN: llc -mtriple=amdgcn -global-isel=0 -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9-SDAG %s
; RUN: llc -mtriple=amdgcn -global-isel=1 -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9-ISEL %s
; RUN: llc -mtriple=amdgcn -global-isel=0 -mcpu=gfx1030 < %s | FileCheck -check-prefixes=GFX10-SDAG %s
; RUN: llc -mtriple=amdgcn -global-isel=1 -mcpu=gfx1030 < %s | FileCheck -check-prefixes=GFX10-ISEL %s
; RUN: llc -mtriple=amdgcn -amdgpu-enable-delay-alu=0 -global-isel=0 -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GFX11-SDAG %s
; RUN: llc -mtriple=amdgcn -amdgpu-enable-delay-alu=0 -global-isel=1 -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GFX11-ISEL %s

declare i64 @llvm.get.fpenv.i64()

declare void @llvm.set.fpenv.i64(i64)

define i64 @get_fpenv() {
; GFX6-SDAG-LABEL: get_fpenv:
; GFX6-SDAG:       ; %bb.0: ; %entry
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX6-SDAG-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_MODE, 0, 23)
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v0, s5
; GFX6-SDAG-NEXT:    v_mov_b32_e32 v1, s4
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-ISEL-LABEL: get_fpenv:
; GFX6-ISEL:       ; %bb.0: ; %entry
; GFX6-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-ISEL-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 0, 23)
; GFX6-ISEL-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX6-ISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-ISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX6-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: get_fpenv:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX8-SDAG-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_MODE, 0, 23)
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v0, s5
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-ISEL-LABEL: get_fpenv:
; GFX8-ISEL:       ; %bb.0: ; %entry
; GFX8-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-ISEL-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 0, 23)
; GFX8-ISEL-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX8-ISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-ISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: get_fpenv:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX9-SDAG-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_MODE, 0, 23)
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-ISEL-LABEL: get_fpenv:
; GFX9-ISEL:       ; %bb.0: ; %entry
; GFX9-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-ISEL-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 0, 23)
; GFX9-ISEL-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX9-ISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-ISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: get_fpenv:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX10-SDAG-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_MODE, 0, 23)
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-SDAG-NEXT:    v_mov_b32_e32 v0, s5
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-ISEL-LABEL: get_fpenv:
; GFX10-ISEL:       ; %bb.0: ; %entry
; GFX10-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-ISEL-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 0, 23)
; GFX10-ISEL-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX10-ISEL-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-ISEL-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: get_fpenv:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX11-SDAG-NEXT:    s_getreg_b32 s1, hwreg(HW_REG_MODE, 0, 23)
; GFX11-SDAG-NEXT:    v_dual_mov_b32 v1, s0 :: v_dual_mov_b32 v0, s1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-ISEL-LABEL: get_fpenv:
; GFX11-ISEL:       ; %bb.0: ; %entry
; GFX11-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-ISEL-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 0, 23)
; GFX11-ISEL-NEXT:    s_getreg_b32 s1, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX11-ISEL-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-ISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = call i64 @llvm.get.fpenv.i64()
  ret i64 %0
}

define void @set_fpenv(i64 %env) {
; GFX6-SDAG-LABEL: set_fpenv:
; GFX6-SDAG:       ; %bb.0: ; %entry
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_readfirstlane_b32 s4, v0
; GFX6-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX6-SDAG-NEXT:    v_readfirstlane_b32 s4, v1
; GFX6-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-ISEL-LABEL: set_fpenv:
; GFX6-ISEL:       ; %bb.0: ; %entry
; GFX6-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-ISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX6-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX6-ISEL-NEXT:    v_readfirstlane_b32 s4, v1
; GFX6-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX6-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: set_fpenv:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX8-SDAG-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-ISEL-LABEL: set_fpenv:
; GFX8-ISEL:       ; %bb.0: ; %entry
; GFX8-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-ISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX8-ISEL-NEXT:    v_readfirstlane_b32 s4, v1
; GFX8-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX8-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: set_fpenv:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX9-SDAG-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-ISEL-LABEL: set_fpenv:
; GFX9-ISEL:       ; %bb.0: ; %entry
; GFX9-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-ISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX9-ISEL-NEXT:    v_readfirstlane_b32 s4, v1
; GFX9-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX9-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: set_fpenv:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v0
; GFX10-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX10-SDAG-NEXT:    v_readfirstlane_b32 s4, v1
; GFX10-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-ISEL-LABEL: set_fpenv:
; GFX10-ISEL:       ; %bb.0: ; %entry
; GFX10-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-ISEL-NEXT:    v_readfirstlane_b32 s4, v0
; GFX10-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX10-ISEL-NEXT:    v_readfirstlane_b32 s4, v1
; GFX10-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX10-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: set_fpenv:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s0
; GFX11-SDAG-NEXT:    v_readfirstlane_b32 s0, v1
; GFX11-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-ISEL-LABEL: set_fpenv:
; GFX11-ISEL:       ; %bb.0: ; %entry
; GFX11-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-ISEL-NEXT:    v_readfirstlane_b32 s0, v0
; GFX11-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s0
; GFX11-ISEL-NEXT:    v_readfirstlane_b32 s0, v1
; GFX11-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s0
; GFX11-ISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  call void @llvm.set.fpenv.i64(i64 %env)
  ret void
}

define void @set_fpenv_constant() {
; GFX6-SDAG-LABEL: set_fpenv_constant:
; GFX6-SDAG:       ; %bb.0: ; %entry
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX6-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-ISEL-LABEL: set_fpenv_constant:
; GFX6-ISEL:       ; %bb.0: ; %entry
; GFX6-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX6-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX6-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: set_fpenv_constant:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX8-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-ISEL-LABEL: set_fpenv_constant:
; GFX8-ISEL:       ; %bb.0: ; %entry
; GFX8-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX8-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX8-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: set_fpenv_constant:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX9-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-ISEL-LABEL: set_fpenv_constant:
; GFX9-ISEL:       ; %bb.0: ; %entry
; GFX9-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX9-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX9-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: set_fpenv_constant:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX10-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-ISEL-LABEL: set_fpenv_constant:
; GFX10-ISEL:       ; %bb.0: ; %entry
; GFX10-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX10-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX10-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: set_fpenv_constant:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX11-SDAG-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-ISEL-LABEL: set_fpenv_constant:
; GFX11-ISEL:       ; %bb.0: ; %entry
; GFX11-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_MODE, 0, 23), 0
; GFX11-ISEL-NEXT:    s_setreg_imm32_b32 hwreg(HW_REG_TRAPSTS, 0, 5), 0
; GFX11-ISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  call void @llvm.set.fpenv.i64(i64 0)
  ret void
}

define void @get_set_fpenv() {
; GFX6-SDAG-LABEL: get_set_fpenv:
; GFX6-SDAG:       ; %bb.0: ; %entry
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX6-SDAG-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_MODE, 0, 23)
; GFX6-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s5
; GFX6-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-ISEL-LABEL: get_set_fpenv:
; GFX6-ISEL:       ; %bb.0: ; %entry
; GFX6-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-ISEL-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 0, 23)
; GFX6-ISEL-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX6-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX6-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s5
; GFX6-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: get_set_fpenv:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX8-SDAG-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_MODE, 0, 23)
; GFX8-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s5
; GFX8-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-ISEL-LABEL: get_set_fpenv:
; GFX8-ISEL:       ; %bb.0: ; %entry
; GFX8-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-ISEL-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 0, 23)
; GFX8-ISEL-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX8-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX8-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s5
; GFX8-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: get_set_fpenv:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX9-SDAG-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_MODE, 0, 23)
; GFX9-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s5
; GFX9-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-ISEL-LABEL: get_set_fpenv:
; GFX9-ISEL:       ; %bb.0: ; %entry
; GFX9-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-ISEL-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 0, 23)
; GFX9-ISEL-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX9-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX9-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s5
; GFX9-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: get_set_fpenv:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX10-SDAG-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_MODE, 0, 23)
; GFX10-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s5
; GFX10-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s4
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-ISEL-LABEL: get_set_fpenv:
; GFX10-ISEL:       ; %bb.0: ; %entry
; GFX10-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-ISEL-NEXT:    s_getreg_b32 s4, hwreg(HW_REG_MODE, 0, 23)
; GFX10-ISEL-NEXT:    s_getreg_b32 s5, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX10-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s4
; GFX10-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s5
; GFX10-ISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: get_set_fpenv:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX11-SDAG-NEXT:    s_getreg_b32 s1, hwreg(HW_REG_MODE, 0, 23)
; GFX11-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s1
; GFX11-SDAG-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s0
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-ISEL-LABEL: get_set_fpenv:
; GFX11-ISEL:       ; %bb.0: ; %entry
; GFX11-ISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-ISEL-NEXT:    s_getreg_b32 s0, hwreg(HW_REG_MODE, 0, 23)
; GFX11-ISEL-NEXT:    s_getreg_b32 s1, hwreg(HW_REG_TRAPSTS, 0, 5)
; GFX11-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_MODE, 0, 23), s0
; GFX11-ISEL-NEXT:    s_setreg_b32 hwreg(HW_REG_TRAPSTS, 0, 5), s1
; GFX11-ISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %0 = call i64 @llvm.get.fpenv.i64()
  call void @llvm.set.fpenv.i64(i64 %0)
  ret void
}
