; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-NO16,CHECK-SD-NO16
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-FP16,CHECK-SD-FP16
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-NO16,CHECK-GI-NO16
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu -mattr=+fullfp16 -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-FP16,CHECK-GI-FP16

; fptoui

define i32 @fcvtzs_f32_i32_7(float %flt) {
; CHECK-SD-LABEL: fcvtzs_f32_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w0, s0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_f32_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzs w0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = fptosi float %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzs_f32_i32_32(float %flt) {
; CHECK-SD-LABEL: fcvtzs_f32_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w0, s0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_f32_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1333788672 // =0x4f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzs w0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 4294967296.0
  %cvt = fptosi float %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzs_f32_i64_7(float %flt) {
; CHECK-SD-LABEL: fcvtzs_f32_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x0, s0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_f32_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzs x0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = fptosi float %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzs_f32_i64_64(float %flt) {
; CHECK-SD-LABEL: fcvtzs_f32_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x0, s0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_f32_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1602224128 // =0x5f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzs x0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 18446744073709551616.0
  %cvt = fptosi float %fix to i64
  ret i64 %cvt
}

define i32 @fcvtzs_f64_i32_7(double %dbl) {
; CHECK-SD-LABEL: fcvtzs_f64_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w0, d0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_f64_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzs w0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = fptosi double %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzs_f64_i32_32(double %dbl) {
; CHECK-SD-LABEL: fcvtzs_f64_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w0, d0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_f64_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4751297606875873280 // =0x41f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzs w0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 4294967296.0
  %cvt = fptosi double %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzs_f64_i64_7(double %dbl) {
; CHECK-SD-LABEL: fcvtzs_f64_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x0, d0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_f64_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzs x0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = fptosi double %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzs_f64_i64_64(double %dbl) {
; CHECK-SD-LABEL: fcvtzs_f64_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x0, d0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_f64_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4895412794951729152 // =0x43f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzs x0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 18446744073709551616.0
  %cvt = fptosi double %fix to i64
  ret i64 %cvt
}

define i32 @fcvtzs_f16_i32_7(half %flt) {
; CHECK-SD-NO16-LABEL: fcvtzs_f16_i32_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzs w0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzs_f16_i32_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w0, h0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzs_f16_i32_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzs w0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzs_f16_i32_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI8_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI8_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzs w0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %flt, 128.0
  %cvt = fptosi half %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzs_f16_i32_15(half %flt) {
; CHECK-SD-NO16-LABEL: fcvtzs_f16_i32_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzs w0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzs_f16_i32_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w0, h0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzs_f16_i32_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzs w0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzs_f16_i32_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI9_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI9_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzs w0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %flt, 32768.0
  %cvt = fptosi half %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzs_f16_i64_7(half %flt) {
; CHECK-SD-NO16-LABEL: fcvtzs_f16_i64_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzs x0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzs_f16_i64_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs x0, h0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzs_f16_i64_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzs x0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzs_f16_i64_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI10_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI10_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzs x0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %flt, 128.0
  %cvt = fptosi half %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzs_f16_i64_15(half %flt) {
; CHECK-SD-NO16-LABEL: fcvtzs_f16_i64_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzs x0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzs_f16_i64_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs x0, h0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzs_f16_i64_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzs x0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzs_f16_i64_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI11_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI11_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzs x0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %flt, 32768.0
  %cvt = fptosi half %fix to i64
  ret i64 %cvt
}

; fptoui

define i32 @fcvtzu_f32_i32_7(float %flt) {
; CHECK-SD-LABEL: fcvtzu_f32_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, s0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_f32_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzu w0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = fptoui float %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzu_f32_i32_32(float %flt) {
; CHECK-SD-LABEL: fcvtzu_f32_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, s0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_f32_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1333788672 // =0x4f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzu w0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 4294967296.0
  %cvt = fptoui float %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzu_f32_i64_7(float %flt) {
; CHECK-SD-LABEL: fcvtzu_f32_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu x0, s0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_f32_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzu x0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = fptoui float %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzu_f32_i64_64(float %flt) {
; CHECK-SD-LABEL: fcvtzu_f32_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu x0, s0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_f32_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1602224128 // =0x5f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzu x0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 18446744073709551616.0
  %cvt = fptoui float %fix to i64
  ret i64 %cvt
}

define i32 @fcvtzu_f64_i32_7(double %dbl) {
; CHECK-SD-LABEL: fcvtzu_f64_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, d0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_f64_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzu w0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = fptoui double %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzu_f64_i32_32(double %dbl) {
; CHECK-SD-LABEL: fcvtzu_f64_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, d0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_f64_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4751297606875873280 // =0x41f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzu w0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 4294967296.0
  %cvt = fptoui double %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzu_f64_i64_7(double %dbl) {
; CHECK-SD-LABEL: fcvtzu_f64_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu x0, d0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_f64_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzu x0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = fptoui double %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzu_f64_i64_64(double %dbl) {
; CHECK-SD-LABEL: fcvtzu_f64_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu x0, d0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_f64_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4895412794951729152 // =0x43f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzu x0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 18446744073709551616.0
  %cvt = fptoui double %fix to i64
  ret i64 %cvt
}

define i32 @fcvtzu_f16_i32_7(half %flt) {
; CHECK-SD-NO16-LABEL: fcvtzu_f16_i32_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzu w0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzu_f16_i32_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu w0, h0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzu_f16_i32_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzu w0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzu_f16_i32_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI20_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI20_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzu w0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %flt, 128.0
  %cvt = fptoui half %fix to i32
  ret i32 %cvt
}

define i32 @fcvtzu_f16_i32_15(half %flt) {
; CHECK-SD-NO16-LABEL: fcvtzu_f16_i32_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzu w0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzu_f16_i32_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu w0, h0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzu_f16_i32_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzu w0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzu_f16_i32_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI21_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI21_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzu w0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %flt, 32768.0
  %cvt = fptoui half %fix to i32
  ret i32 %cvt
}

define i64 @fcvtzu_f16_i64_7(half %flt) {
; CHECK-SD-NO16-LABEL: fcvtzu_f16_i64_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzu x0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzu_f16_i64_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu x0, h0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzu_f16_i64_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzu x0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzu_f16_i64_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI22_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI22_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzu x0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %flt, 128.0
  %cvt = fptoui half %fix to i64
  ret i64 %cvt
}

define i64 @fcvtzu_f16_i64_15(half %flt) {
; CHECK-SD-NO16-LABEL: fcvtzu_f16_i64_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzu x0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzu_f16_i64_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu x0, h0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzu_f16_i64_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzu x0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzu_f16_i64_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI23_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI23_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzu x0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %flt, 32768.0
  %cvt = fptoui half %fix to i64
  ret i64 %cvt
}

; sitofp

define float @scvtf_f32_i32_7(i32 %int) {
; CHECK-SD-LABEL: scvtf_f32_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    scvtf s0, w0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scvtf_f32_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v0.2s, #67, lsl #24
; CHECK-GI-NEXT:    scvtf s1, w0
; CHECK-GI-NEXT:    fdiv s0, s1, s0
; CHECK-GI-NEXT:    ret
  %cvt = sitofp i32 %int to float
  %fix = fdiv float %cvt, 128.0
  ret float %fix
}

define float @scvtf_f32_i32_32(i32 %int) {
; CHECK-SD-LABEL: scvtf_f32_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    scvtf s0, w0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scvtf_f32_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    scvtf s0, w0
; CHECK-GI-NEXT:    mov w8, #1333788672 // =0x4f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NEXT:    ret
  %cvt = sitofp i32 %int to float
  %fix = fdiv float %cvt, 4294967296.0
  ret float %fix
}

define float @scvtf_f32_i64_7(i64 %long) {
; CHECK-SD-LABEL: scvtf_f32_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    scvtf s0, x0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scvtf_f32_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v0.2s, #67, lsl #24
; CHECK-GI-NEXT:    scvtf s1, x0
; CHECK-GI-NEXT:    fdiv s0, s1, s0
; CHECK-GI-NEXT:    ret
  %cvt = sitofp i64 %long to float
  %fix = fdiv float %cvt, 128.0
  ret float %fix
}

define float @scvtf_f32_i64_64(i64 %long) {
; CHECK-SD-LABEL: scvtf_f32_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    scvtf s0, x0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scvtf_f32_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    scvtf s0, x0
; CHECK-GI-NEXT:    mov w8, #1602224128 // =0x5f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NEXT:    ret
  %cvt = sitofp i64 %long to float
  %fix = fdiv float %cvt, 18446744073709551616.0
  ret float %fix
}

define double @scvtf_f64_i32_7(i32 %int) {
; CHECK-SD-LABEL: scvtf_f64_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    scvtf d0, w0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scvtf_f64_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    scvtf d0, w0
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fdiv d0, d0, d1
; CHECK-GI-NEXT:    ret
  %cvt = sitofp i32 %int to double
  %fix = fdiv double %cvt, 128.0
  ret double %fix
}

define double @scvtf_f64_i32_32(i32 %int) {
; CHECK-SD-LABEL: scvtf_f64_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    scvtf d0, w0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scvtf_f64_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    scvtf d0, w0
; CHECK-GI-NEXT:    mov x8, #4751297606875873280 // =0x41f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fdiv d0, d0, d1
; CHECK-GI-NEXT:    ret
  %cvt = sitofp i32 %int to double
  %fix = fdiv double %cvt, 4294967296.0
  ret double %fix
}

define double @scvtf_f64_i64_7(i64 %long) {
; CHECK-SD-LABEL: scvtf_f64_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    scvtf d0, x0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scvtf_f64_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    scvtf d0, x0
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fdiv d0, d0, d1
; CHECK-GI-NEXT:    ret
  %cvt = sitofp i64 %long to double
  %fix = fdiv double %cvt, 128.0
  ret double %fix
}

define double @scvtf_f64_i64_64(i64 %long) {
; CHECK-SD-LABEL: scvtf_f64_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    scvtf d0, x0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: scvtf_f64_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    scvtf d0, x0
; CHECK-GI-NEXT:    mov x8, #4895412794951729152 // =0x43f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fdiv d0, d0, d1
; CHECK-GI-NEXT:    ret
  %cvt = sitofp i64 %long to double
  %fix = fdiv double %cvt, 18446744073709551616.0
  ret double %fix
}

define half @scvtf_f16_i32_7(i32 %int) {
; CHECK-SD-NO16-LABEL: scvtf_f16_i32_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    scvtf s1, w0
; CHECK-SD-NO16-NEXT:    movi v0.2s, #60, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt h1, s1
; CHECK-SD-NO16-NEXT:    fcvt s1, h1
; CHECK-SD-NO16-NEXT:    fmul s0, s1, s0
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: scvtf_f16_i32_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    scvtf h0, w0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: scvtf_f16_i32_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    scvtf s0, w0
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: scvtf_f16_i32_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    scvtf h0, w0
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI32_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI32_0]
; CHECK-GI-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-GI-FP16-NEXT:    ret
  %cvt = sitofp i32 %int to half
  %fix = fdiv half %cvt, 128.0
  ret half %fix
}

define half @scvtf_f16_i32_15(i32 %int) {
; CHECK-SD-NO16-LABEL: scvtf_f16_i32_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    scvtf s1, w0
; CHECK-SD-NO16-NEXT:    movi v0.2s, #56, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt h1, s1
; CHECK-SD-NO16-NEXT:    fcvt s1, h1
; CHECK-SD-NO16-NEXT:    fmul s0, s1, s0
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: scvtf_f16_i32_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    scvtf h0, w0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: scvtf_f16_i32_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    scvtf s0, w0
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: scvtf_f16_i32_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    scvtf h0, w0
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI33_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI33_0]
; CHECK-GI-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-GI-FP16-NEXT:    ret
  %cvt = sitofp i32 %int to half
  %fix = fdiv half %cvt, 32768.0
  ret half %fix
}

define half @scvtf_f16_i64_7(i64 %long) {
; CHECK-SD-NO16-LABEL: scvtf_f16_i64_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    scvtf s1, x0
; CHECK-SD-NO16-NEXT:    movi v0.2s, #60, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt h1, s1
; CHECK-SD-NO16-NEXT:    fcvt s1, h1
; CHECK-SD-NO16-NEXT:    fmul s0, s1, s0
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: scvtf_f16_i64_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    scvtf h0, x0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: scvtf_f16_i64_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    scvtf s0, x0
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: scvtf_f16_i64_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    scvtf h0, x0
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI34_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI34_0]
; CHECK-GI-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-GI-FP16-NEXT:    ret
  %cvt = sitofp i64 %long to half
  %fix = fdiv half %cvt, 128.0
  ret half %fix
}

define half @scvtf_f16_i64_15(i64 %long) {
; CHECK-SD-NO16-LABEL: scvtf_f16_i64_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    scvtf s1, x0
; CHECK-SD-NO16-NEXT:    movi v0.2s, #56, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt h1, s1
; CHECK-SD-NO16-NEXT:    fcvt s1, h1
; CHECK-SD-NO16-NEXT:    fmul s0, s1, s0
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: scvtf_f16_i64_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    scvtf h0, x0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: scvtf_f16_i64_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    scvtf s0, x0
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: scvtf_f16_i64_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    scvtf h0, x0
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI35_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI35_0]
; CHECK-GI-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-GI-FP16-NEXT:    ret
  %cvt = sitofp i64 %long to half
  %fix = fdiv half %cvt, 32768.0
  ret half %fix
}

; uitofp

define float @ucvtf_f32_i32_7(i32 %int) {
; CHECK-SD-LABEL: ucvtf_f32_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ucvtf s0, w0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucvtf_f32_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v0.2s, #67, lsl #24
; CHECK-GI-NEXT:    ucvtf s1, w0
; CHECK-GI-NEXT:    fdiv s0, s1, s0
; CHECK-GI-NEXT:    ret
  %cvt = uitofp i32 %int to float
  %fix = fdiv float %cvt, 128.0
  ret float %fix
}

define float @ucvtf_f32_i32_32(i32 %int) {
; CHECK-SD-LABEL: ucvtf_f32_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ucvtf s0, w0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucvtf_f32_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ucvtf s0, w0
; CHECK-GI-NEXT:    mov w8, #1333788672 // =0x4f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NEXT:    ret
  %cvt = uitofp i32 %int to float
  %fix = fdiv float %cvt, 4294967296.0
  ret float %fix
}

define float @ucvtf_f32_i64_7(i64 %long) {
; CHECK-SD-LABEL: ucvtf_f32_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ucvtf s0, x0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucvtf_f32_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v0.2s, #67, lsl #24
; CHECK-GI-NEXT:    ucvtf s1, x0
; CHECK-GI-NEXT:    fdiv s0, s1, s0
; CHECK-GI-NEXT:    ret
  %cvt = uitofp i64 %long to float
  %fix = fdiv float %cvt, 128.0
  ret float %fix
}

define float @ucvtf_f32_i64_64(i64 %long) {
; CHECK-SD-LABEL: ucvtf_f32_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ucvtf s0, x0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucvtf_f32_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ucvtf s0, x0
; CHECK-GI-NEXT:    mov w8, #1602224128 // =0x5f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NEXT:    ret
  %cvt = uitofp i64 %long to float
  %fix = fdiv float %cvt, 18446744073709551616.0
  ret float %fix
}

define double @ucvtf_f64_i32_7(i32 %int) {
; CHECK-SD-LABEL: ucvtf_f64_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ucvtf d0, w0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucvtf_f64_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ucvtf d0, w0
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fdiv d0, d0, d1
; CHECK-GI-NEXT:    ret
  %cvt = uitofp i32 %int to double
  %fix = fdiv double %cvt, 128.0
  ret double %fix
}

define double @ucvtf_f64_i32_32(i32 %int) {
; CHECK-SD-LABEL: ucvtf_f64_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ucvtf d0, w0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucvtf_f64_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ucvtf d0, w0
; CHECK-GI-NEXT:    mov x8, #4751297606875873280 // =0x41f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fdiv d0, d0, d1
; CHECK-GI-NEXT:    ret
  %cvt = uitofp i32 %int to double
  %fix = fdiv double %cvt, 4294967296.0
  ret double %fix
}

define double @ucvtf_f64_i64_7(i64 %long) {
; CHECK-SD-LABEL: ucvtf_f64_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ucvtf d0, x0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucvtf_f64_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ucvtf d0, x0
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fdiv d0, d0, d1
; CHECK-GI-NEXT:    ret
  %cvt = uitofp i64 %long to double
  %fix = fdiv double %cvt, 128.0
  ret double %fix
}

define double @ucvtf_f64_i64_64(i64 %long) {
; CHECK-SD-LABEL: ucvtf_f64_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    ucvtf d0, x0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: ucvtf_f64_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    ucvtf d0, x0
; CHECK-GI-NEXT:    mov x8, #4895412794951729152 // =0x43f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fdiv d0, d0, d1
; CHECK-GI-NEXT:    ret
  %cvt = uitofp i64 %long to double
  %fix = fdiv double %cvt, 18446744073709551616.0
  ret double %fix
}

define half @ucvtf_f16_i32_7(i32 %int) {
; CHECK-SD-NO16-LABEL: ucvtf_f16_i32_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    ucvtf s1, w0
; CHECK-SD-NO16-NEXT:    movi v0.2s, #60, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt h1, s1
; CHECK-SD-NO16-NEXT:    fcvt s1, h1
; CHECK-SD-NO16-NEXT:    fmul s0, s1, s0
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ucvtf_f16_i32_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    ucvtf h0, w0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: ucvtf_f16_i32_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    ucvtf s0, w0
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ucvtf_f16_i32_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    ucvtf h0, w0
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI44_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI44_0]
; CHECK-GI-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-GI-FP16-NEXT:    ret
  %cvt = uitofp i32 %int to half
  %fix = fdiv half %cvt, 128.0
  ret half %fix
}

define half @ucvtf_f16_i32_15(i32 %int) {
; CHECK-SD-NO16-LABEL: ucvtf_f16_i32_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    ucvtf s1, w0
; CHECK-SD-NO16-NEXT:    movi v0.2s, #56, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt h1, s1
; CHECK-SD-NO16-NEXT:    fcvt s1, h1
; CHECK-SD-NO16-NEXT:    fmul s0, s1, s0
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ucvtf_f16_i32_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    ucvtf h0, w0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: ucvtf_f16_i32_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    ucvtf s0, w0
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ucvtf_f16_i32_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    ucvtf h0, w0
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI45_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI45_0]
; CHECK-GI-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-GI-FP16-NEXT:    ret
  %cvt = uitofp i32 %int to half
  %fix = fdiv half %cvt, 32768.0
  ret half %fix
}

define half @ucvtf_f16_i64_7(i64 %long) {
; CHECK-SD-NO16-LABEL: ucvtf_f16_i64_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    ucvtf s1, x0
; CHECK-SD-NO16-NEXT:    movi v0.2s, #60, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt h1, s1
; CHECK-SD-NO16-NEXT:    fcvt s1, h1
; CHECK-SD-NO16-NEXT:    fmul s0, s1, s0
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ucvtf_f16_i64_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    ucvtf h0, x0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: ucvtf_f16_i64_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    ucvtf s0, x0
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ucvtf_f16_i64_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    ucvtf h0, x0
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI46_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI46_0]
; CHECK-GI-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-GI-FP16-NEXT:    ret
  %cvt = uitofp i64 %long to half
  %fix = fdiv half %cvt, 128.0
  ret half %fix
}

define half @ucvtf_f16_i64_15(i64 %long) {
; CHECK-SD-NO16-LABEL: ucvtf_f16_i64_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    ucvtf s1, x0
; CHECK-SD-NO16-NEXT:    movi v0.2s, #56, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt h1, s1
; CHECK-SD-NO16-NEXT:    fcvt s1, h1
; CHECK-SD-NO16-NEXT:    fmul s0, s1, s0
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: ucvtf_f16_i64_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    ucvtf h0, x0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: ucvtf_f16_i64_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    ucvtf s0, x0
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fdiv s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: ucvtf_f16_i64_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    ucvtf h0, x0
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI47_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI47_0]
; CHECK-GI-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-GI-FP16-NEXT:    ret
  %cvt = uitofp i64 %long to half
  %fix = fdiv half %cvt, 32768.0
  ret half %fix
}


; fptoui.sat

declare i32 @llvm.fptosi.sat.i32.f32(float)
declare i64 @llvm.fptosi.sat.i64.f32(float)
declare i32 @llvm.fptosi.sat.i32.f64(double)
declare i64 @llvm.fptosi.sat.i64.f64(double)
declare i32 @llvm.fptosi.sat.i32.f16(half)
declare i64 @llvm.fptosi.sat.i64.f16(half)

define i32 @fcvtzs_sat_f32_i32_7(float %flt) {
; CHECK-SD-LABEL: fcvtzs_sat_f32_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w0, s0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_sat_f32_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzs w0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f32(float %fix)
  ret i32 %cvt
}

define i32 @fcvtzs_sat_f32_i32_32(float %flt) {
; CHECK-SD-LABEL: fcvtzs_sat_f32_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w0, s0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_sat_f32_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1333788672 // =0x4f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzs w0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 4294967296.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f32(float %fix)
  ret i32 %cvt
}

define i64 @fcvtzs_sat_f32_i64_64(float %flt) {
; CHECK-SD-LABEL: fcvtzs_sat_f32_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x0, s0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_sat_f32_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1602224128 // =0x5f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzs x0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 18446744073709551616.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f32(float %fix)
  ret i64 %cvt
}

define i32 @fcvtzs_sat_f64_i32_7(double %dbl) {
; CHECK-SD-LABEL: fcvtzs_sat_f64_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w0, d0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_sat_f64_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzs w0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f64(double %fix)
  ret i32 %cvt
}

define i32 @fcvtzs_sat_f64_i32_32(double %dbl) {
; CHECK-SD-LABEL: fcvtzs_sat_f64_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs w0, d0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_sat_f64_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4751297606875873280 // =0x41f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzs w0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 4294967296.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f64(double %fix)
  ret i32 %cvt
}

define i64 @fcvtzs_sat_f64_i64_7(double %dbl) {
; CHECK-SD-LABEL: fcvtzs_sat_f64_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x0, d0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_sat_f64_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzs x0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f64(double %fix)
  ret i64 %cvt
}

define i64 @fcvtzs_sat_f64_i64_64(double %dbl) {
; CHECK-SD-LABEL: fcvtzs_sat_f64_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzs x0, d0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzs_sat_f64_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4895412794951729152 // =0x43f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzs x0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 18446744073709551616.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f64(double %fix)
  ret i64 %cvt
}

define i32 @fcvtzs_sat_f16_i32_7(half %dbl) {
; CHECK-SD-NO16-LABEL: fcvtzs_sat_f16_i32_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzs w0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzs_sat_f16_i32_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w0, h0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzs_sat_f16_i32_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzs w0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzs_sat_f16_i32_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI55_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI55_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzs w0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %dbl, 128.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f16(half %fix)
  ret i32 %cvt
}

define i32 @fcvtzs_sat_f16_i32_15(half %dbl) {
; CHECK-SD-NO16-LABEL: fcvtzs_sat_f16_i32_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzs w0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzs_sat_f16_i32_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs w0, h0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzs_sat_f16_i32_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzs w0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzs_sat_f16_i32_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI56_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI56_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzs w0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %dbl, 32768.0
  %cvt = call i32 @llvm.fptosi.sat.i32.f16(half %fix)
  ret i32 %cvt
}

define i64 @fcvtzs_sat_f16_i64_7(half %dbl) {
; CHECK-SD-NO16-LABEL: fcvtzs_sat_f16_i64_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzs x0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzs_sat_f16_i64_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs x0, h0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzs_sat_f16_i64_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzs x0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzs_sat_f16_i64_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI57_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI57_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzs x0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %dbl, 128.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f16(half %fix)
  ret i64 %cvt
}

define i64 @fcvtzs_sat_f16_i64_15(half %dbl) {
; CHECK-SD-NO16-LABEL: fcvtzs_sat_f16_i64_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzs x0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzs_sat_f16_i64_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzs x0, h0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzs_sat_f16_i64_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzs x0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzs_sat_f16_i64_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI58_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI58_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzs x0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %dbl, 32768.0
  %cvt = call i64 @llvm.fptosi.sat.i64.f16(half %fix)
  ret i64 %cvt
}

; fptoui

declare i32 @llvm.fptoui.sat.i32.f32(float)
declare i64 @llvm.fptoui.sat.i64.f32(float)
declare i32 @llvm.fptoui.sat.i32.f64(double)
declare i64 @llvm.fptoui.sat.i64.f64(double)
declare i32 @llvm.fptoui.sat.i32.f16(half)
declare i64 @llvm.fptoui.sat.i64.f16(half)

define i32 @fcvtzu_sat_f32_i32_7(float %flt) {
; CHECK-SD-LABEL: fcvtzu_sat_f32_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, s0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_sat_f32_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzu w0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 128.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f32(float %fix)
  ret i32 %cvt
}

define i32 @fcvtzu_sat_f32_i32_32(float %flt) {
; CHECK-SD-LABEL: fcvtzu_sat_f32_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, s0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_sat_f32_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1333788672 // =0x4f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzu w0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 4294967296.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f32(float %fix)
  ret i32 %cvt
}

define i64 @fcvtzu_sat_f32_i64_64(float %flt) {
; CHECK-SD-LABEL: fcvtzu_sat_f32_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu x0, s0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_sat_f32_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov w8, #1602224128 // =0x5f800000
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    fmul s0, s0, s1
; CHECK-GI-NEXT:    fcvtzu x0, s0
; CHECK-GI-NEXT:    ret
  %fix = fmul float %flt, 18446744073709551616.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f32(float %fix)
  ret i64 %cvt
}

define i32 @fcvtzu_sat_f64_i32_7(double %dbl) {
; CHECK-SD-LABEL: fcvtzu_sat_f64_i32_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, d0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_sat_f64_i32_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzu w0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f64(double %fix)
  ret i32 %cvt
}

define i32 @fcvtzu_sat_f64_i32_32(double %dbl) {
; CHECK-SD-LABEL: fcvtzu_sat_f64_i32_32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu w0, d0, #32
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_sat_f64_i32_32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4751297606875873280 // =0x41f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzu w0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 4294967296.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f64(double %fix)
  ret i32 %cvt
}

define i64 @fcvtzu_sat_f64_i64_7(double %dbl) {
; CHECK-SD-LABEL: fcvtzu_sat_f64_i64_7:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu x0, d0, #7
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_sat_f64_i64_7:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4638707616191610880 // =0x4060000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzu x0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 128.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f64(double %fix)
  ret i64 %cvt
}

define i64 @fcvtzu_sat_f64_i64_64(double %dbl) {
; CHECK-SD-LABEL: fcvtzu_sat_f64_i64_64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcvtzu x0, d0, #64
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcvtzu_sat_f64_i64_64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    mov x8, #4895412794951729152 // =0x43f0000000000000
; CHECK-GI-NEXT:    fmov d1, x8
; CHECK-GI-NEXT:    fmul d0, d0, d1
; CHECK-GI-NEXT:    fcvtzu x0, d0
; CHECK-GI-NEXT:    ret
  %fix = fmul double %dbl, 18446744073709551616.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f64(double %fix)
  ret i64 %cvt
}

define i32 @fcvtzu_sat_f16_i32_7(half %dbl) {
; CHECK-SD-NO16-LABEL: fcvtzu_sat_f16_i32_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzu w0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzu_sat_f16_i32_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu w0, h0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzu_sat_f16_i32_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzu w0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzu_sat_f16_i32_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI66_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI66_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzu w0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %dbl, 128.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f16(half %fix)
  ret i32 %cvt
}

define i32 @fcvtzu_sat_f16_i32_15(half %dbl) {
; CHECK-SD-NO16-LABEL: fcvtzu_sat_f16_i32_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzu w0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzu_sat_f16_i32_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu w0, h0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzu_sat_f16_i32_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzu w0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzu_sat_f16_i32_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI67_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI67_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzu w0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %dbl, 32768.0
  %cvt = call i32 @llvm.fptoui.sat.i32.f16(half %fix)
  ret i32 %cvt
}

define i64 @fcvtzu_sat_f16_i64_7(half %dbl) {
; CHECK-SD-NO16-LABEL: fcvtzu_sat_f16_i64_7:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #67, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzu x0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzu_sat_f16_i64_7:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu x0, h0, #7
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzu_sat_f16_i64_7:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #22528 // =0x5800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzu x0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzu_sat_f16_i64_7:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI68_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI68_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzu x0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %dbl, 128.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f16(half %fix)
  ret i64 %cvt
}

define i64 @fcvtzu_sat_f16_i64_15(half %dbl) {
; CHECK-SD-NO16-LABEL: fcvtzu_sat_f16_i64_15:
; CHECK-SD-NO16:       // %bb.0:
; CHECK-SD-NO16-NEXT:    movi v1.2s, #71, lsl #24
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fmul s0, s0, s1
; CHECK-SD-NO16-NEXT:    fcvt h0, s0
; CHECK-SD-NO16-NEXT:    fcvt s0, h0
; CHECK-SD-NO16-NEXT:    fcvtzu x0, s0
; CHECK-SD-NO16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: fcvtzu_sat_f16_i64_15:
; CHECK-SD-FP16:       // %bb.0:
; CHECK-SD-FP16-NEXT:    fcvtzu x0, h0, #15
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NO16-LABEL: fcvtzu_sat_f16_i64_15:
; CHECK-GI-NO16:       // %bb.0:
; CHECK-GI-NO16-NEXT:    mov w8, #30720 // =0x7800
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fmov s1, w8
; CHECK-GI-NO16-NEXT:    fcvt s1, h1
; CHECK-GI-NO16-NEXT:    fmul s0, s0, s1
; CHECK-GI-NO16-NEXT:    fcvt h0, s0
; CHECK-GI-NO16-NEXT:    fcvt s0, h0
; CHECK-GI-NO16-NEXT:    fcvtzu x0, s0
; CHECK-GI-NO16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: fcvtzu_sat_f16_i64_15:
; CHECK-GI-FP16:       // %bb.0:
; CHECK-GI-FP16-NEXT:    adrp x8, .LCPI69_0
; CHECK-GI-FP16-NEXT:    ldr h1, [x8, :lo12:.LCPI69_0]
; CHECK-GI-FP16-NEXT:    fmul h0, h0, h1
; CHECK-GI-FP16-NEXT:    fcvtzu x0, h0
; CHECK-GI-FP16-NEXT:    ret
  %fix = fmul half %dbl, 32768.0
  %cvt = call i64 @llvm.fptoui.sat.i64.f16(half %fix)
  ret i64 %cvt
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
; CHECK-FP16: {{.*}}
; CHECK-NO16: {{.*}}
