; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux-gnu -mcpu=skx        -global-isel -verify-machineinstrs < %s -o - | FileCheck %s --check-prefix=ALL --check-prefix=SKX
; RUN: llc -mtriple=x86_64-linux-gnu -mcpu=core-avx2  -global-isel -verify-machineinstrs < %s -o - | FileCheck %s --check-prefix=ALL --check-prefix=AVX2
; RUN: llc -mtriple=x86_64-linux-gnu -mcpu=corei7-avx -global-isel -verify-machineinstrs < %s -o - | FileCheck %s --check-prefix=ALL --check-prefix=AVX1


define <16 x i8> @test_add_v16i8(<16 x i8> %arg1, <16 x i8> %arg2) {
; ALL-LABEL: test_add_v16i8:
; ALL:       # %bb.0:
; ALL-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; ALL-NEXT:    retq
  %ret = add <16 x i8> %arg1, %arg2
  ret <16 x i8> %ret
}

define <8 x i16> @test_add_v8i16(<8 x i16> %arg1, <8 x i16> %arg2) {
; ALL-LABEL: test_add_v8i16:
; ALL:       # %bb.0:
; ALL-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; ALL-NEXT:    retq
  %ret = add <8 x i16> %arg1, %arg2
  ret <8 x i16> %ret
}

define <4 x i32> @test_add_v4i32(<4 x i32> %arg1, <4 x i32> %arg2) {
; ALL-LABEL: test_add_v4i32:
; ALL:       # %bb.0:
; ALL-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; ALL-NEXT:    retq
  %ret = add <4 x i32> %arg1, %arg2
  ret <4 x i32> %ret
}

define <2 x i64> @test_add_v2i64(<2 x i64> %arg1, <2 x i64> %arg2) {
; ALL-LABEL: test_add_v2i64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; ALL-NEXT:    retq
  %ret = add <2 x i64> %arg1, %arg2
  ret <2 x i64> %ret
}

define <32 x i8> @test_add_v32i8(<32 x i8> %arg1, <32 x i8> %arg2) {
; SKX-LABEL: test_add_v32i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; SKX-NEXT:    retq
;
; AVX2-LABEL: test_add_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX1-LABEL: test_add_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
  %ret = add <32 x i8> %arg1, %arg2
  ret <32 x i8> %ret
}

define <16 x i16> @test_add_v16i16(<16 x i16> %arg1, <16 x i16> %arg2) {
; SKX-LABEL: test_add_v16i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; SKX-NEXT:    retq
;
; AVX2-LABEL: test_add_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX1-LABEL: test_add_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
  %ret = add <16 x i16> %arg1, %arg2
  ret <16 x i16> %ret
}

define <8 x i32> @test_add_v8i32(<8 x i32> %arg1, <8 x i32> %arg2) {
; SKX-LABEL: test_add_v8i32:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; SKX-NEXT:    retq
;
; AVX2-LABEL: test_add_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX1-LABEL: test_add_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
  %ret = add <8 x i32> %arg1, %arg2
  ret <8 x i32> %ret
}

define <4 x i64> @test_add_v4i64(<4 x i64> %arg1, <4 x i64> %arg2) {
; SKX-LABEL: test_add_v4i64:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; SKX-NEXT:    retq
;
; AVX2-LABEL: test_add_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX1-LABEL: test_add_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
  %ret = add <4 x i64> %arg1, %arg2
  ret <4 x i64> %ret
}

define <64 x i8> @test_add_v64i8(<64 x i8> %arg1, <64 x i8> %arg2) {
; SKX-LABEL: test_add_v64i8:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; SKX-NEXT:    retq
;
; AVX2-LABEL: test_add_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX1-LABEL: test_add_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; AVX1-NEXT:    vpaddb %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm6
; AVX1-NEXT:    vpaddb %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    retq
  %ret = add <64 x i8> %arg1, %arg2
  ret <64 x i8> %ret
}

define <32 x i16> @test_add_v32i16(<32 x i16> %arg1, <32 x i16> %arg2) {
; SKX-LABEL: test_add_v32i16:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddw %zmm1, %zmm0, %zmm0
; SKX-NEXT:    retq
;
; AVX2-LABEL: test_add_v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX1-LABEL: test_add_v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; AVX1-NEXT:    vpaddw %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm6
; AVX1-NEXT:    vpaddw %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpaddw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    retq
  %ret = add <32 x i16> %arg1, %arg2
  ret <32 x i16> %ret
}

define <16 x i32> @test_add_v16i32(<16 x i32> %arg1, <16 x i32> %arg2) {
; SKX-LABEL: test_add_v16i32:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; SKX-NEXT:    retq
;
; AVX2-LABEL: test_add_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX1-LABEL: test_add_v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; AVX1-NEXT:    vpaddd %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm6
; AVX1-NEXT:    vpaddd %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    retq
  %ret = add <16 x i32> %arg1, %arg2
  ret <16 x i32> %ret
}

define <8 x i64> @test_add_v8i64(<8 x i64> %arg1, <8 x i64> %arg2) {
; SKX-LABEL: test_add_v8i64:
; SKX:       # %bb.0:
; SKX-NEXT:    vpaddq %zmm1, %zmm0, %zmm0
; SKX-NEXT:    retq
;
; AVX2-LABEL: test_add_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX1-LABEL: test_add_v8i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; AVX1-NEXT:    vpaddq %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm6
; AVX1-NEXT:    vpaddq %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    retq
  %ret = add <8 x i64> %arg1, %arg2
  ret <8 x i64> %ret
}

