; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes='require<loops>,instcombine' -S | FileCheck %s
target datalayout = "E-p:64:64:64-p1:16:16:16-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64"

; Constant folding should fix notionally out-of-bounds indices
; and add inbounds keywords.

%struct.X = type { [3 x i32], [3 x i32] }

@Y = internal global [3 x %struct.X] zeroinitializer

define void @frob() {
; CHECK-LABEL: @frob(
; CHECK-NEXT:    store i32 1, ptr @Y, align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 4), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 8), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 12), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 16), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 20), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 24), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 28), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 32), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 36), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 40), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 44), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 48), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 52), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 56), align 8
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 60), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 64), align 8
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 68), align 4
; CHECK-NEXT:    store i32 1, ptr getelementptr inbounds nuw (i8, ptr @Y, i64 72), align 8
; CHECK-NEXT:    store i32 1, ptr getelementptr (i8, ptr @Y, i64 144), align 8
; CHECK-NEXT:    store i32 1, ptr getelementptr (i8, ptr @Y, i64 76), align 8
; CHECK-NEXT:    ret void
;
  store i32 1, ptr @Y, align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 1), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 2), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 3), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 4), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 5), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 6), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 7), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 8), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 9), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 10), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 11), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 12), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 13), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 14), align 8
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 15), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 16), align 8
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 17), align 4
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 18), align 8
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 36), align 8
  store i32 1, ptr getelementptr ([3 x %struct.X], ptr @Y, i64 0, i64 0, i32 0, i64 19), align 8
  ret void
}


; PR8883 - Constant fold exotic gep subtract
@X = global [1000 x i8] zeroinitializer, align 16

define i64 @test2() {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i64 1000
;
entry:
  %A = bitcast ptr getelementptr inbounds ([1000 x i8], ptr @X, i64 1, i64 0) to ptr

  %B2 = ptrtoint ptr @X to i64
  %C = sub i64 0, %B2
  %D = getelementptr i8, ptr %A, i64 %C
  %E = ptrtoint ptr %D to i64

  ret i64 %E
}

@X_as1 = addrspace(1) global [1000 x i8] zeroinitializer, align 16

define i16 @test2_as1() {
; CHECK-LABEL: @test2_as1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i16 1000
;

entry:
  %A = bitcast ptr addrspace(1) getelementptr inbounds ([1000 x i8], ptr addrspace(1) @X_as1, i64 1, i64 0) to ptr addrspace(1)

  %B2 = ptrtoint ptr addrspace(1) @X_as1 to i16
  %C = sub i16 0, %B2
  %D = getelementptr i8, ptr addrspace(1) %A, i16 %C
  %E = ptrtoint ptr addrspace(1) %D to i16

  ret i16 %E
}

@g = external global i8
@g2 = external global i8

declare i64 @get.i64()
declare void @use.ptr(ptr)

define ptr @gep_sub_self() {
; CHECK-LABEL: @gep_sub_self(
; CHECK-NEXT:    ret ptr getelementptr (i8, ptr @g, i64 sub (i64 0, i64 ptrtoint (ptr @g to i64)))
;
  %p.int = ptrtoint ptr @g to i64
  %p.int.neg = sub i64 0, %p.int
  %p1 = getelementptr i8, ptr @g, i64 %p.int.neg
  ret ptr %p1
}

define ptr @gep_sub_self_plus_addr(i64 %addr) {
; CHECK-LABEL: @gep_sub_self_plus_addr(
; CHECK-NEXT:    [[P2:%.*]] = getelementptr i8, ptr getelementptr (i8, ptr @g, i64 sub (i64 0, i64 ptrtoint (ptr @g to i64))), i64 [[ADDR:%.*]]
; CHECK-NEXT:    ret ptr [[P2]]
;
  %p.int = ptrtoint ptr @g to i64
  %p.int.neg = sub i64 0, %p.int
  %p1 = getelementptr i8, ptr @g, i64 %p.int.neg
  %p2 = getelementptr i8, ptr %p1, i64 %addr
  ret ptr %p2
}

define ptr @gep_plus_addr_sub_self(i64 %addr) {
; CHECK-LABEL: @gep_plus_addr_sub_self(
; CHECK-NEXT:    [[P1:%.*]] = getelementptr i8, ptr @g, i64 [[ADDR:%.*]]
; CHECK-NEXT:    [[P2:%.*]] = getelementptr i8, ptr [[P1]], i64 sub (i64 0, i64 ptrtoint (ptr @g to i64))
; CHECK-NEXT:    ret ptr [[P2]]
;
  %p.int = ptrtoint ptr @g to i64
  %p.int.neg = sub i64 0, %p.int
  %p1 = getelementptr i8, ptr @g, i64 %addr
  %p2 = getelementptr i8, ptr %p1, i64 %p.int.neg
  ret ptr %p2
}

define ptr @gep_plus_addr_sub_self_in_loop() {
; CHECK-LABEL: @gep_plus_addr_sub_self_in_loop(
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[ADDR:%.*]] = call i64 @get.i64()
; CHECK-NEXT:    [[P1:%.*]] = getelementptr i8, ptr @g, i64 [[ADDR]]
; CHECK-NEXT:    [[P2:%.*]] = getelementptr i8, ptr [[P1]], i64 sub (i64 0, i64 ptrtoint (ptr @g to i64))
; CHECK-NEXT:    call void @use.ptr(ptr [[P2]])
; CHECK-NEXT:    br label [[LOOP]]
;
  %p.int = ptrtoint ptr @g to i64
  %p.int.neg = sub i64 0, %p.int
  br label %loop

loop:
  %addr = call i64 @get.i64()
  %p1 = getelementptr i8, ptr @g, i64 %addr
  %p2 = getelementptr i8, ptr %p1, i64 %p.int.neg
  call void @use.ptr(ptr %p2)
  br label %loop
}

define ptr @gep_sub_other() {
; CHECK-LABEL: @gep_sub_other(
; CHECK-NEXT:    ret ptr getelementptr (i8, ptr @g, i64 sub (i64 0, i64 ptrtoint (ptr @g2 to i64)))
;
  %p.int = ptrtoint ptr @g2 to i64
  %p.int.neg = sub i64 0, %p.int
  %p1 = getelementptr i8, ptr @g, i64 %p.int.neg
  ret ptr %p1
}

define i64 @gep_sub_other_to_int() {
; CHECK-LABEL: @gep_sub_other_to_int(
; CHECK-NEXT:    ret i64 sub (i64 ptrtoint (ptr @g to i64), i64 ptrtoint (ptr @g2 to i64))
;
  %p.int = ptrtoint ptr @g2 to i64
  %p.int.neg = sub i64 0, %p.int
  %p1 = getelementptr i8, ptr @g, i64 %p.int.neg
  %p1.int = ptrtoint ptr %p1 to i64
  ret i64 %p1.int
}
